/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "conn_most_fi_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
  #define ETRACE_S_IMPORT_INTERFACE_GENERIC
  #include "etrace_if.h"

  #include "most_fi_etg_trace.h"
  #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_MOST_FI
  /* #define ETG_INLINE */
  #include "trcGenProj/Header/most_alltypes.cpp.trc.h"
#endif


// map platform types to ICU types
#ifndef _STDINT_H
   typedef tU8  uint8_t;
   typedef tS32 int32_t;
   typedef tU32 uint32_t; 
#endif  // _STDINT_H

///////////////////////////////////////////////////////////////////////////////
//
//      Extract of                ICU4C 4.6.1 
//
//            ICU - International Components for Unicode
//                (http://site.icu-project.org/home)
//
//      Tiny, but just sufficient to convert incoming UTF-16 strings
//
//      ICU defines macros handling many cases of low-level 
//      string operations inline 
//      
///////////////////////////////////////////////////////////////////////////////
//
//      UNICODE, INC. LICENSE AGREEMENT - DATA FILES AND SOFTWARE
//
//          Unicode Data Files include all data files under the directories
//      http://www.unicode.org/Public/, http://www.unicode.org/reports/, and
//      http://www.unicode.org/cldr/data/. Unicode Data Files do not include PDF
//      online code charts under the directory http://www.unicode.org/Public/.
//      Software includes any source code published in the Unicode Standard or under
//      the directories http://www.unicode.org/Public/,
//      http://www.unicode.org/reports/, and http://www.unicode.org/cldr/data/.
//
//          NOTICE TO USER: Carefully read the following legal agreement. BY
//      DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING UNICODE INC.'S DATA FILES
//      ("DATA FILES"), AND/OR SOFTWARE ("SOFTWARE"), YOU UNEQUIVOCALLY ACCEPT, AND
//      AGREE TO BE BOUND BY, ALL OF THE TERMS AND CONDITIONS OF THIS AGREEMENT. IF
//      YOU DO NOT AGREE, DO NOT DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA
//      FILES OR SOFTWARE.
//
//          COPYRIGHT AND PERMISSION NOTICE
//
//          Copyright  1991-2011 Unicode, Inc. All rights reserved. Distributed under
//      the Terms of Use in http://www.unicode.org/copyright.html.
//
//          Permission is hereby granted, free of charge, to any person obtaining a
//      copy of the Unicode data files and any associated documentation (the "Data
//      Files") or Unicode software and any associated documentation (the "Software")
//      to deal in the Data Files or Software without restriction, including without
//      limitation the rights to use, copy, modify, merge, publish, distribute, and/or
//      sell copies of the Data Files or Software, and to permit persons to whom the
//      Data Files or Software are furnished to do so, provided that (a) the above
//      copyright notice(s) and this permission notice appear with all copies of the
//      Data Files or Software, (b) both the above copyright notice(s) and this
//      permission notice appear in associated documentation, and (c) there is clear
//      notice in each modified Data File or in the Software as well as in the
//      documentation associated with the Data File(s) or Software that the data or
//      software has been modified.
//
//          THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
//      KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//      MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD
//      PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN
//      THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
//      DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
//      PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
//      ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE
//      DATA FILES OR SOFTWARE.
//
//          Except as contained in this notice, the name of a copyright holder shall
//      not be used in advertising or otherwise to promote the sale, use or other
//      dealings in these Data Files or Software without prior written authorization
//      of the copyright holder.
//
///////////////////////////////////////////////////////////////////////////////
//
//                        common\unicode\umachine.h
//
//      This file defines basic types and constants for utf.h to be
//      platform-independent.
//
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

    /**
    * Define UChar32 as a type for single Unicode code points.
    * UChar32 is a signed 32-bit integer (same as int32_t).
    *
    * The Unicode code point range is 0..0x10ffff.
    * All other values (negative or >=0x110000) are illegal as Unicode code points.
    * They may be used as sentinel values to indicate "done", "error"
    * or similar non-code point conditions.
    *
    * Before ICU 2.4 (Jitterbug 2146), UChar32 was defined
    * to be wchar_t if that is 32 bits wide (wchar_t may be signed or unsigned)
    * or else to be uint32_t.
    * That is, the definition of UChar32 was platform-dependent.
    *
    * @see U_SENTINEL
    * @stable ICU 2.4
    */
   typedef int32_t UChar32;

//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
//
//                          common\unicode\utf.h
//
//      This file defines macros for checking whether a code point is
//      a surrogate or a non-character etc.
//
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

   /**
    * This value is intended for sentinel values for APIs that
    * (take or) return single code points (UChar32).
    * It is outside of the Unicode code point range 0..0x10ffff.
    * 
    * For example, a "done" or "error" value in a new API
    * could be indicated with U_SENTINEL.
    *
    * ICU APIs designed before ICU 2.4 usually define service-specific "done"
    * values, mostly 0xffff.
    * Those may need to be distinguished from
    * actual U+ffff text contents by calling functions like
    * CharacterIterator::hasNext() or UnicodeString::length().
    *
    * @return -1
    * @see UChar32
    * @stable ICU 2.4
    */

   #define U_SENTINEL (-1)

   /**
    * Is this code point a surrogate (U+d800..U+dfff)?
    * @param c 32-bit code point
    * @return TRUE or FALSE
    * @stable ICU 2.4
    */
   #define U_IS_SURROGATE(c) (((c)&0xfffff800)==0xd800)

//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
//
//                       common\unicode\utf8.h
//
//      This file defines macros to deal with 8-bit Unicode (UTF-8) 
//      code units (bytes) and strings.
//
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

   /**
    * How many code units (bytes) are used for the UTF-8 encoding
    * of this Unicode code point?
    * @param c 32-bit code point
    * @return 1..4, or 0 if c is a surrogate or not a Unicode code point
    * @stable ICU 2.4
    */
   #define U8_LENGTH(c) \
       ((uint32_t)(c)<=0x7f ? 1 : \
           ((uint32_t)(c)<=0x7ff ? 2 : \
               ((uint32_t)(c)<=0xd7ff ? 3 : \
                   ((uint32_t)(c)<=0xdfff || (uint32_t)(c)>0x10ffff ? 0 : \
                       ((uint32_t)(c)<=0xffff ? 3 : 4)\
                   ) \
               ) \
           ) \
       )

   /**
    * Append a code point to a string, overwriting 1 to 4 bytes.
    * The offset points to the current end of the string contents
    * and is advanced (post-increment).
    * "Unsafe" macro, assumes a valid code point and sufficient space in the string.
    * Otherwise, the result is undefined.
    *
    * @param s const uint8_t * string buffer
    * @param i string offset
    * @param c code point to append
    * @see U8_APPEND
    * @stable ICU 2.4
    */
   #define U8_APPEND_UNSAFE(s, i, c) { \
       if((uint32_t)(c)<=0x7f) { \
           (s)[(i)++]=(uint8_t)(c); \
       } else { \
           if((uint32_t)(c)<=0x7ff) { \
               (s)[(i)++]=(uint8_t)(((c)>>6)|0xc0); \
           } else { \
               if((uint32_t)(c)<=0xffff) { \
                   (s)[(i)++]=(uint8_t)(((c)>>12)|0xe0); \
               } else { \
                   (s)[(i)++]=(uint8_t)(((c)>>18)|0xf0); \
                   (s)[(i)++]=(uint8_t)((((c)>>12)&0x3f)|0x80); \
               } \
               (s)[(i)++]=(uint8_t)((((c)>>6)&0x3f)|0x80); \
           } \
           (s)[(i)++]=(uint8_t)(((c)&0x3f)|0x80); \
       } \
   }


// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
//
//                       common\unicode\utf16.h
//
//      This file defines macros to deal with 16-bit Unicode (UTF-16)  
//      code units and strings.
//
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

   /* single-code point definitions -------------------------------------------- */

   /**
    * Does this code unit alone encode a code point (BMP, not a surrogate)?
    * @param c 16-bit code unit
    * @return TRUE or FALSE
    * @stable ICU 2.4
    */
   #define U16_IS_SINGLE(c) !U_IS_SURROGATE(c)

   /**
    * Is this code unit a lead surrogate (U+d800..U+dbff)?
    * @param c 16-bit code unit
    * @return TRUE or FALSE
    * @stable ICU 2.4
    */
   #define U16_IS_LEAD(c) (((c)&0xfffffc00)==0xd800)

   /**
    * Is this code unit a trail surrogate (U+dc00..U+dfff)?
    * @param c 16-bit code unit
    * @return TRUE or FALSE
    * @stable ICU 2.4
    */
   #define U16_IS_TRAIL(c) (((c)&0xfffffc00)==0xdc00)

   /**
    * Helper constant for U16_GET_SUPPLEMENTARY.
    * @internal
    */
   #define U16_SURROGATE_OFFSET ((0xd800<<10UL)+0xdc00-0x10000)

   /**
    * Get a supplementary code point value (U+10000..U+10ffff)
    * from its lead and trail surrogates.
    * The result is undefined if the input values are not
    * lead and trail surrogates.
    *
    * @param lead lead surrogate (U+d800..U+dbff)
    * @param trail trail surrogate (U+dc00..U+dfff)
    * @return supplementary code point (U+10000..U+10ffff)
    * @stable ICU 2.4
    */
   #define U16_GET_SUPPLEMENTARY(lead, trail) \
       (((UChar32)(lead)<<10UL)+(UChar32)(trail)-U16_SURROGATE_OFFSET)

//
//      E N D  of                ICU4C 4.6.1 
//
///////////////////////////////////////////////////////////////////////////////

#ifdef FI_MOST_GB18030_CHAR_SET_ID

/* types used in mediaplayer where this code is derived from. */
typedef signed int INT32;
typedef char INT8;

/** Maximum length/number of bytes of an UTF-8 character. */
#define MOST_FI_C_MAX_LENGTH_OF_UTF8_CHARACTER       8
/** Maximum length/number of bytes of an GB18030 character. */
#define MOST_FI_C_MAX_LENGTH_OF_GB18030_CHARACTER    sizeof(tU32)
/** Maximum length/number of bytes of an unicode character (even if
 *  MOST_FI_GB18030_Unicode_Mapping_Table contains only two byte unicode values). */
#define MOST_FI_C_MAX_LENGTH_OF_UNICODE_CHARACTER    sizeof(tU32)

/** */
#define MOST_FI_HALF_DIVISOR           2
/** hex value of space */
#define MOST_FI_HEXADECIMAL_SPACE      0x20

#define MOST_FI_VAL_TWO                0x02  /**< define for hex value 0x02 */
#define MOST_FI_HEX_VAL_THIRTY         0x30  /**< define for hex value 0x30 */
#define MOST_FI_HEX_VAL_THIRTY_NINE    0x39  /**< define for hex value 0x39 */
#define MOST_FI_HEX_VAL_FOURTY         0x40  /**< define for hex value 0x40 */

#define MOST_FI_SHIFT_6_BITS                  0x06
//#define MOST_FI_SHIFT_7_BITS                  0x07
#define MOST_FI_SHIFT_8_BITS                  0x08
//#define MOST_FI_SHIFT_10_BITS                 0x0A
#define MOST_FI_SHIFT_12_BITS                 0x0C
#define MOST_FI_SHIFT_16_BITS                 0x10
#define MOST_FI_SHIFT_18_BITS                 0x12
#define MOST_FI_SHIFT_24_BITS                 0x18

#define MOST_FI_UTF8_UNICODE_LIMIT1           (tU32)0x80        /**< Max value of an unicode character to be 1 byte UTF-8 coded. */
#define MOST_FI_UTF8_UNICODE_LIMIT2           (tU32)0x800       /**< Max value of an unicode character to be 2 byte UTF-8 coded. */
#define MOST_FI_UTF16_MAX_BMP                 (tU32)0x0000FFFF  /**< Largest valid code point for a BMP value */
//not used #define MOST_FI_UTF16_MAX_UTF16               (tU32)0x0010FFFF  /**< Largest valid code points for a UTF16 value */
#define MOST_FI_UTF16_MAX_UTF32               (tU32)0x7FFFFFFF  /**< */

#define MOST_FI_UTF8_CHAR_LIMIT_MINUS_TW0     0xFE
     
static const tU32 MOST_FI_GB18030_Unicode_Mapping_Table[][2] = {
{ 0x0000 , 0x00},
{ 0x0001 , 0x01},
{ 0x0002 , 0x02},
{ 0x0003 , 0x03},
{ 0x0004 , 0x04},
{ 0x0005 , 0x05},
{ 0x0006 , 0x06},
{ 0x0007 , 0x07},
{ 0x0008 , 0x08},
{ 0x0009 , 0x09},
{ 0x000A , 0x0A},
{ 0x000B , 0x0B},
{ 0x000C , 0x0C},
{ 0x000D , 0x0D},
{ 0x000E , 0x0E},
{ 0x000F , 0x0F},
{ 0x0010 , 0x10},
{ 0x0011 , 0x11},
{ 0x0012 , 0x12},
{ 0x0013 , 0x13},
{ 0x0014 , 0x14},
{ 0x0015 , 0x15},
{ 0x0016 , 0x16},
{ 0x0017 , 0x17},
{ 0x0018 , 0x18},
{ 0x0019 , 0x19},
{ 0x001A , 0x1A},
{ 0x001B , 0x1B},
{ 0x001C , 0x1C},
{ 0x001D , 0x1D},
{ 0x001E , 0x1E},
{ 0x001F , 0x1F},
{ 0x0020 , 0x20},
{ 0x0021 , 0x21},
{ 0x0022 , 0x22},
{ 0x0023 , 0x23},
{ 0x0024 , 0x24},
{ 0x0025 , 0x25},
{ 0x0026 , 0x26},
{ 0x0027 , 0x27},
{ 0x0028 , 0x28},
{ 0x0029 , 0x29},
{ 0x002A , 0x2A},
{ 0x002B , 0x2B},
{ 0x002C , 0x2C},
{ 0x002D , 0x2D},
{ 0x002E , 0x2E},
{ 0x002F , 0x2F},
{ 0x0030 , 0x30},
{ 0x0031 , 0x31},
{ 0x0032 , 0x32},
{ 0x0033 , 0x33},
{ 0x0034 , 0x34},
{ 0x0035 , 0x35},
{ 0x0036 , 0x36},
{ 0x0037 , 0x37},
{ 0x0038 , 0x38},
{ 0x0039 , 0x39},
{ 0x003A , 0x3A},
{ 0x003B , 0x3B},
{ 0x003C , 0x3C},
{ 0x003D , 0x3D},
{ 0x003E , 0x3E},
{ 0x003F , 0x3F},
{ 0x0040 , 0x40},
{ 0x0041 , 0x41},
{ 0x0042 , 0x42},
{ 0x0043 , 0x43},
{ 0x0044 , 0x44},
{ 0x0045 , 0x45},
{ 0x0046 , 0x46},
{ 0x0047 , 0x47},
{ 0x0048 , 0x48},
{ 0x0049 , 0x49},
{ 0x004A , 0x4A},
{ 0x004B , 0x4B},
{ 0x004C , 0x4C},
{ 0x004D , 0x4D},
{ 0x004E , 0x4E},
{ 0x004F , 0x4F},
{ 0x0050 , 0x50},
{ 0x0051 , 0x51},
{ 0x0052 , 0x52},
{ 0x0053 , 0x53},
{ 0x0054 , 0x54},
{ 0x0055 , 0x55},
{ 0x0056 , 0x56},
{ 0x0057 , 0x57},
{ 0x0058 , 0x58},
{ 0x0059 , 0x59},
{ 0x005A , 0x5A},
{ 0x005B , 0x5B},
{ 0x005C , 0x5C},
{ 0x005D , 0x5D},
{ 0x005E , 0x5E},
{ 0x005F , 0x5F},
{ 0x0060 , 0x60},
{ 0x0061 , 0x61},
{ 0x0062 , 0x62},
{ 0x0063 , 0x63},
{ 0x0064 , 0x64},
{ 0x0065 , 0x65},
{ 0x0066 , 0x66},
{ 0x0067 , 0x67},
{ 0x0068 , 0x68},
{ 0x0069 , 0x69},
{ 0x006A , 0x6A},
{ 0x006B , 0x6B},
{ 0x006C , 0x6C},
{ 0x006D , 0x6D},
{ 0x006E , 0x6E},
{ 0x006F , 0x6F},
{ 0x0070 , 0x70},
{ 0x0071 , 0x71},
{ 0x0072 , 0x72},
{ 0x0073 , 0x73},
{ 0x0074 , 0x74},
{ 0x0075 , 0x75},
{ 0x0076 , 0x76},
{ 0x0077 , 0x77},
{ 0x0078 , 0x78},
{ 0x0079 , 0x79},
{ 0x007A , 0x7A},
{ 0x007B , 0x7B},
{ 0x007C , 0x7C},
{ 0x007D , 0x7D},
{ 0x007E , 0x7E},
{ 0x007F , 0x7F},
{ 0x4E02 , 0x8140},
{ 0x4E04 , 0x8141},
{ 0x4E05 , 0x8142},
{ 0x4E06 , 0x8143},
{ 0x4E0F , 0x8144},
{ 0x4E12 , 0x8145},
{ 0x4E17 , 0x8146},
{ 0x4E1F , 0x8147},
{ 0x4E20 , 0x8148},
{ 0x4E21 , 0x8149},
{ 0x4E23 , 0x814A},
{ 0x4E26 , 0x814B},
{ 0x4E29 , 0x814C},
{ 0x4E2E , 0x814D},
{ 0x4E2F , 0x814E},
{ 0x4E31 , 0x814F},
{ 0x4E33 , 0x8150},
{ 0x4E35 , 0x8151},
{ 0x4E37 , 0x8152},
{ 0x4E3C , 0x8153},
{ 0x4E40 , 0x8154},
{ 0x4E41 , 0x8155},
{ 0x4E42 , 0x8156},
{ 0x4E44 , 0x8157},
{ 0x4E46 , 0x8158},
{ 0x4E4A , 0x8159},
{ 0x4E51 , 0x815A},
{ 0x4E55 , 0x815B},
{ 0x4E57 , 0x815C},
{ 0x4E5A , 0x815D},
{ 0x4E5B , 0x815E},
{ 0x4E62 , 0x815F},
{ 0x4E63 , 0x8160},
{ 0x4E64 , 0x8161},
{ 0x4E65 , 0x8162},
{ 0x4E67 , 0x8163},
{ 0x4E68 , 0x8164},
{ 0x4E6A , 0x8165},
{ 0x4E6B , 0x8166},
{ 0x4E6C , 0x8167},
{ 0x4E6D , 0x8168},
{ 0x4E6E , 0x8169},
{ 0x4E6F , 0x816A},
{ 0x4E72 , 0x816B},
{ 0x4E74 , 0x816C},
{ 0x4E75 , 0x816D},
{ 0x4E76 , 0x816E},
{ 0x4E77 , 0x816F},
{ 0x4E78 , 0x8170},
{ 0x4E79 , 0x8171},
{ 0x4E7A , 0x8172},
{ 0x4E7B , 0x8173},
{ 0x4E7C , 0x8174},
{ 0x4E7D , 0x8175},
{ 0x4E7F , 0x8176},
{ 0x4E80 , 0x8177},
{ 0x4E81 , 0x8178},
{ 0x4E82 , 0x8179},
{ 0x4E83 , 0x817A},
{ 0x4E84 , 0x817B},
{ 0x4E85 , 0x817C},
{ 0x4E87 , 0x817D},
{ 0x4E8A , 0x817E},
{ 0x4E90 , 0x8180},
{ 0x4E96 , 0x8181},
{ 0x4E97 , 0x8182},
{ 0x4E99 , 0x8183},
{ 0x4E9C , 0x8184},
{ 0x4E9D , 0x8185},
{ 0x4E9E , 0x8186},
{ 0x4EA3 , 0x8187},
{ 0x4EAA , 0x8188},
{ 0x4EAF , 0x8189},
{ 0x4EB0 , 0x818A},
{ 0x4EB1 , 0x818B},
{ 0x4EB4 , 0x818C},
{ 0x4EB6 , 0x818D},
{ 0x4EB7 , 0x818E},
{ 0x4EB8 , 0x818F},
{ 0x4EB9 , 0x8190},
{ 0x4EBC , 0x8191},
{ 0x4EBD , 0x8192},
{ 0x4EBE , 0x8193},
{ 0x4EC8 , 0x8194},
{ 0x4ECC , 0x8195},
{ 0x4ECF , 0x8196},
{ 0x4ED0 , 0x8197},
{ 0x4ED2 , 0x8198},
{ 0x4EDA , 0x8199},
{ 0x4EDB , 0x819A},
{ 0x4EDC , 0x819B},
{ 0x4EE0 , 0x819C},
{ 0x4EE2 , 0x819D},
{ 0x4EE6 , 0x819E},
{ 0x4EE7 , 0x819F},
{ 0x4EE9 , 0x81A0},
{ 0x4EED , 0x81A1},
{ 0x4EEE , 0x81A2},
{ 0x4EEF , 0x81A3},
{ 0x4EF1 , 0x81A4},
{ 0x4EF4 , 0x81A5},
{ 0x4EF8 , 0x81A6},
{ 0x4EF9 , 0x81A7},
{ 0x4EFA , 0x81A8},
{ 0x4EFC , 0x81A9},
{ 0x4EFE , 0x81AA},
{ 0x4F00 , 0x81AB},
{ 0x4F02 , 0x81AC},
{ 0x4F03 , 0x81AD},
{ 0x4F04 , 0x81AE},
{ 0x4F05 , 0x81AF},
{ 0x4F06 , 0x81B0},
{ 0x4F07 , 0x81B1},
{ 0x4F08 , 0x81B2},
{ 0x4F0B , 0x81B3},
{ 0x4F0C , 0x81B4},
{ 0x4F12 , 0x81B5},
{ 0x4F13 , 0x81B6},
{ 0x4F14 , 0x81B7},
{ 0x4F15 , 0x81B8},
{ 0x4F16 , 0x81B9},
{ 0x4F1C , 0x81BA},
{ 0x4F1D , 0x81BB},
{ 0x4F21 , 0x81BC},
{ 0x4F23 , 0x81BD},
{ 0x4F28 , 0x81BE},
{ 0x4F29 , 0x81BF},
{ 0x4F2C , 0x81C0},
{ 0x4F2D , 0x81C1},
{ 0x4F2E , 0x81C2},
{ 0x4F31 , 0x81C3},
{ 0x4F33 , 0x81C4},
{ 0x4F35 , 0x81C5},
{ 0x4F37 , 0x81C6},
{ 0x4F39 , 0x81C7},
{ 0x4F3B , 0x81C8},
{ 0x4F3E , 0x81C9},
{ 0x4F3F , 0x81CA},
{ 0x4F40 , 0x81CB},
{ 0x4F41 , 0x81CC},
{ 0x4F42 , 0x81CD},
{ 0x4F44 , 0x81CE},
{ 0x4F45 , 0x81CF},
{ 0x4F47 , 0x81D0},
{ 0x4F48 , 0x81D1},
{ 0x4F49 , 0x81D2},
{ 0x4F4A , 0x81D3},
{ 0x4F4B , 0x81D4},
{ 0x4F4C , 0x81D5},
{ 0x4F52 , 0x81D6},
{ 0x4F54 , 0x81D7},
{ 0x4F56 , 0x81D8},
{ 0x4F61 , 0x81D9},
{ 0x4F62 , 0x81DA},
{ 0x4F66 , 0x81DB},
{ 0x4F68 , 0x81DC},
{ 0x4F6A , 0x81DD},
{ 0x4F6B , 0x81DE},
{ 0x4F6D , 0x81DF},
{ 0x4F6E , 0x81E0},
{ 0x4F71 , 0x81E1},
{ 0x4F72 , 0x81E2},
{ 0x4F75 , 0x81E3},
{ 0x4F77 , 0x81E4},
{ 0x4F78 , 0x81E5},
{ 0x4F79 , 0x81E6},
{ 0x4F7A , 0x81E7},
{ 0x4F7D , 0x81E8},
{ 0x4F80 , 0x81E9},
{ 0x4F81 , 0x81EA},
{ 0x4F82 , 0x81EB},
{ 0x4F85 , 0x81EC},
{ 0x4F86 , 0x81ED},
{ 0x4F87 , 0x81EE},
{ 0x4F8A , 0x81EF},
{ 0x4F8C , 0x81F0},
{ 0x4F8E , 0x81F1},
{ 0x4F90 , 0x81F2},
{ 0x4F92 , 0x81F3},
{ 0x4F93 , 0x81F4},
{ 0x4F95 , 0x81F5},
{ 0x4F96 , 0x81F6},
{ 0x4F98 , 0x81F7},
{ 0x4F99 , 0x81F8},
{ 0x4F9A , 0x81F9},
{ 0x4F9C , 0x81FA},
{ 0x4F9E , 0x81FB},
{ 0x4F9F , 0x81FC},
{ 0x4FA1 , 0x81FD},
{ 0x4FA2 , 0x81FE},
{ 0x4FA4 , 0x8240},
{ 0x4FAB , 0x8241},
{ 0x4FAD , 0x8242},
{ 0x4FB0 , 0x8243},
{ 0x4FB1 , 0x8244},
{ 0x4FB2 , 0x8245},
{ 0x4FB3 , 0x8246},
{ 0x4FB4 , 0x8247},
{ 0x4FB6 , 0x8248},
{ 0x4FB7 , 0x8249},
{ 0x4FB8 , 0x824A},
{ 0x4FB9 , 0x824B},
{ 0x4FBA , 0x824C},
{ 0x4FBB , 0x824D},
{ 0x4FBC , 0x824E},
{ 0x4FBD , 0x824F},
{ 0x4FBE , 0x8250},
{ 0x4FC0 , 0x8251},
{ 0x4FC1 , 0x8252},
{ 0x4FC2 , 0x8253},
{ 0x4FC6 , 0x8254},
{ 0x4FC7 , 0x8255},
{ 0x4FC8 , 0x8256},
{ 0x4FC9 , 0x8257},
{ 0x4FCB , 0x8258},
{ 0x4FCC , 0x8259},
{ 0x4FCD , 0x825A},
{ 0x4FD2 , 0x825B},
{ 0x4FD3 , 0x825C},
{ 0x4FD4 , 0x825D},
{ 0x4FD5 , 0x825E},
{ 0x4FD6 , 0x825F},
{ 0x4FD9 , 0x8260},
{ 0x4FDB , 0x8261},
{ 0x4FE0 , 0x8262},
{ 0x4FE2 , 0x8263},
{ 0x4FE4 , 0x8264},
{ 0x4FE5 , 0x8265},
{ 0x4FE7 , 0x8266},
{ 0x4FEB , 0x8267},
{ 0x4FEC , 0x8268},
{ 0x4FF0 , 0x8269},
{ 0x4FF2 , 0x826A},
{ 0x4FF4 , 0x826B},
{ 0x4FF5 , 0x826C},
{ 0x4FF6 , 0x826D},
{ 0x4FF7 , 0x826E},
{ 0x4FF9 , 0x826F},
{ 0x4FFB , 0x8270},
{ 0x4FFC , 0x8271},
{ 0x4FFD , 0x8272},
{ 0x4FFF , 0x8273},
{ 0x5000 , 0x8274},
{ 0x5001 , 0x8275},
{ 0x5002 , 0x8276},
{ 0x5003 , 0x8277},
{ 0x5004 , 0x8278},
{ 0x5005 , 0x8279},
{ 0x5006 , 0x827A},
{ 0x5007 , 0x827B},
{ 0x5008 , 0x827C},
{ 0x5009 , 0x827D},
{ 0x500A , 0x827E},
{ 0x500B , 0x8280},
{ 0x500E , 0x8281},
{ 0x5010 , 0x8282},
{ 0x5011 , 0x8283},
{ 0x5013 , 0x8284},
{ 0x5015 , 0x8285},
{ 0x5016 , 0x8286},
{ 0x5017 , 0x8287},
{ 0x501B , 0x8288},
{ 0x501D , 0x8289},
{ 0x501E , 0x828A},
{ 0x5020 , 0x828B},
{ 0x5022 , 0x828C},
{ 0x5023 , 0x828D},
{ 0x5024 , 0x828E},
{ 0x5027 , 0x828F},
{ 0x502B , 0x8290},
{ 0x502F , 0x8291},
{ 0x5030 , 0x8292},
{ 0x5031 , 0x8293},
{ 0x5032 , 0x8294},
{ 0x5033 , 0x8295},
{ 0x5034 , 0x8296},
{ 0x5035 , 0x8297},
{ 0x5036 , 0x8298},
{ 0x5037 , 0x8299},
{ 0x5038 , 0x829A},
{ 0x5039 , 0x829B},
{ 0x503B , 0x829C},
{ 0x503D , 0x829D},
{ 0x503F , 0x829E},
{ 0x5040 , 0x829F},
{ 0x5041 , 0x82A0},
{ 0x5042 , 0x82A1},
{ 0x5044 , 0x82A2},
{ 0x5045 , 0x82A3},
{ 0x5046 , 0x82A4},
{ 0x5049 , 0x82A5},
{ 0x504A , 0x82A6},
{ 0x504B , 0x82A7},
{ 0x504D , 0x82A8},
{ 0x5050 , 0x82A9},
{ 0x5051 , 0x82AA},
{ 0x5052 , 0x82AB},
{ 0x5053 , 0x82AC},
{ 0x5054 , 0x82AD},
{ 0x5056 , 0x82AE},
{ 0x5057 , 0x82AF},
{ 0x5058 , 0x82B0},
{ 0x5059 , 0x82B1},
{ 0x505B , 0x82B2},
{ 0x505D , 0x82B3},
{ 0x505E , 0x82B4},
{ 0x505F , 0x82B5},
{ 0x5060 , 0x82B6},
{ 0x5061 , 0x82B7},
{ 0x5062 , 0x82B8},
{ 0x5063 , 0x82B9},
{ 0x5064 , 0x82BA},
{ 0x5066 , 0x82BB},
{ 0x5067 , 0x82BC},
{ 0x5068 , 0x82BD},
{ 0x5069 , 0x82BE},
{ 0x506A , 0x82BF},
{ 0x506B , 0x82C0},
{ 0x506D , 0x82C1},
{ 0x506E , 0x82C2},
{ 0x506F , 0x82C3},
{ 0x5070 , 0x82C4},
{ 0x5071 , 0x82C5},
{ 0x5072 , 0x82C6},
{ 0x5073 , 0x82C7},
{ 0x5074 , 0x82C8},
{ 0x5075 , 0x82C9},
{ 0x5078 , 0x82CA},
{ 0x5079 , 0x82CB},
{ 0x507A , 0x82CC},
{ 0x507C , 0x82CD},
{ 0x507D , 0x82CE},
{ 0x5081 , 0x82CF},
{ 0x5082 , 0x82D0},
{ 0x5083 , 0x82D1},
{ 0x5084 , 0x82D2},
{ 0x5086 , 0x82D3},
{ 0x5087 , 0x82D4},
{ 0x5089 , 0x82D5},
{ 0x508A , 0x82D6},
{ 0x508B , 0x82D7},
{ 0x508C , 0x82D8},
{ 0x508E , 0x82D9},
{ 0x508F , 0x82DA},
{ 0x5090 , 0x82DB},
{ 0x5091 , 0x82DC},
{ 0x5092 , 0x82DD},
{ 0x5093 , 0x82DE},
{ 0x5094 , 0x82DF},
{ 0x5095 , 0x82E0},
{ 0x5096 , 0x82E1},
{ 0x5097 , 0x82E2},
{ 0x5098 , 0x82E3},
{ 0x5099 , 0x82E4},
{ 0x509A , 0x82E5},
{ 0x509B , 0x82E6},
{ 0x509C , 0x82E7},
{ 0x509D , 0x82E8},
{ 0x509E , 0x82E9},
{ 0x509F , 0x82EA},
{ 0x50A0 , 0x82EB},
{ 0x50A1 , 0x82EC},
{ 0x50A2 , 0x82ED},
{ 0x50A4 , 0x82EE},
{ 0x50A6 , 0x82EF},
{ 0x50AA , 0x82F0},
{ 0x50AB , 0x82F1},
{ 0x50AD , 0x82F2},
{ 0x50AE , 0x82F3},
{ 0x50AF , 0x82F4},
{ 0x50B0 , 0x82F5},
{ 0x50B1 , 0x82F6},
{ 0x50B3 , 0x82F7},
{ 0x50B4 , 0x82F8},
{ 0x50B5 , 0x82F9},
{ 0x50B6 , 0x82FA},
{ 0x50B7 , 0x82FB},
{ 0x50B8 , 0x82FC},
{ 0x50B9 , 0x82FD},
{ 0x50BC , 0x82FE},
{ 0x50BD , 0x8340},
{ 0x50BE , 0x8341},
{ 0x50BF , 0x8342},
{ 0x50C0 , 0x8343},
{ 0x50C1 , 0x8344},
{ 0x50C2 , 0x8345},
{ 0x50C3 , 0x8346},
{ 0x50C4 , 0x8347},
{ 0x50C5 , 0x8348},
{ 0x50C6 , 0x8349},
{ 0x50C7 , 0x834A},
{ 0x50C8 , 0x834B},
{ 0x50C9 , 0x834C},
{ 0x50CA , 0x834D},
{ 0x50CB , 0x834E},
{ 0x50CC , 0x834F},
{ 0x50CD , 0x8350},
{ 0x50CE , 0x8351},
{ 0x50D0 , 0x8352},
{ 0x50D1 , 0x8353},
{ 0x50D2 , 0x8354},
{ 0x50D3 , 0x8355},
{ 0x50D4 , 0x8356},
{ 0x50D5 , 0x8357},
{ 0x50D7 , 0x8358},
{ 0x50D8 , 0x8359},
{ 0x50D9 , 0x835A},
{ 0x50DB , 0x835B},
{ 0x50DC , 0x835C},
{ 0x50DD , 0x835D},
{ 0x50DE , 0x835E},
{ 0x50DF , 0x835F},
{ 0x50E0 , 0x8360},
{ 0x50E1 , 0x8361},
{ 0x50E2 , 0x8362},
{ 0x50E3 , 0x8363},
{ 0x50E4 , 0x8364},
{ 0x50E5 , 0x8365},
{ 0x50E8 , 0x8366},
{ 0x50E9 , 0x8367},
{ 0x50EA , 0x8368},
{ 0x50EB , 0x8369},
{ 0x50EF , 0x836A},
{ 0x50F0 , 0x836B},
{ 0x50F1 , 0x836C},
{ 0x50F2 , 0x836D},
{ 0x50F4 , 0x836E},
{ 0x50F6 , 0x836F},
{ 0x50F7 , 0x8370},
{ 0x50F8 , 0x8371},
{ 0x50F9 , 0x8372},
{ 0x50FA , 0x8373},
{ 0x50FC , 0x8374},
{ 0x50FD , 0x8375},
{ 0x50FE , 0x8376},
{ 0x50FF , 0x8377},
{ 0x5100 , 0x8378},
{ 0x5101 , 0x8379},
{ 0x5102 , 0x837A},
{ 0x5103 , 0x837B},
{ 0x5104 , 0x837C},
{ 0x5105 , 0x837D},
{ 0x5108 , 0x837E},
{ 0x5109 , 0x8380},
{ 0x510A , 0x8381},
{ 0x510C , 0x8382},
{ 0x510D , 0x8383},
{ 0x510E , 0x8384},
{ 0x510F , 0x8385},
{ 0x5110 , 0x8386},
{ 0x5111 , 0x8387},
{ 0x5113 , 0x8388},
{ 0x5114 , 0x8389},
{ 0x5115 , 0x838A},
{ 0x5116 , 0x838B},
{ 0x5117 , 0x838C},
{ 0x5118 , 0x838D},
{ 0x5119 , 0x838E},
{ 0x511A , 0x838F},
{ 0x511B , 0x8390},
{ 0x511C , 0x8391},
{ 0x511D , 0x8392},
{ 0x511E , 0x8393},
{ 0x511F , 0x8394},
{ 0x5120 , 0x8395},
{ 0x5122 , 0x8396},
{ 0x5123 , 0x8397},
{ 0x5124 , 0x8398},
{ 0x5125 , 0x8399},
{ 0x5126 , 0x839A},
{ 0x5127 , 0x839B},
{ 0x5128 , 0x839C},
{ 0x5129 , 0x839D},
{ 0x512A , 0x839E},
{ 0x512B , 0x839F},
{ 0x512C , 0x83A0},
{ 0x512D , 0x83A1},
{ 0x512E , 0x83A2},
{ 0x512F , 0x83A3},
{ 0x5130 , 0x83A4},
{ 0x5131 , 0x83A5},
{ 0x5132 , 0x83A6},
{ 0x5133 , 0x83A7},
{ 0x5134 , 0x83A8},
{ 0x5135 , 0x83A9},
{ 0x5136 , 0x83AA},
{ 0x5137 , 0x83AB},
{ 0x5138 , 0x83AC},
{ 0x5139 , 0x83AD},
{ 0x513A , 0x83AE},
{ 0x513B , 0x83AF},
{ 0x513C , 0x83B0},
{ 0x513D , 0x83B1},
{ 0x513E , 0x83B2},
{ 0x5142 , 0x83B3},
{ 0x5147 , 0x83B4},
{ 0x514A , 0x83B5},
{ 0x514C , 0x83B6},
{ 0x514E , 0x83B7},
{ 0x514F , 0x83B8},
{ 0x5150 , 0x83B9},
{ 0x5152 , 0x83BA},
{ 0x5153 , 0x83BB},
{ 0x5157 , 0x83BC},
{ 0x5158 , 0x83BD},
{ 0x5159 , 0x83BE},
{ 0x515B , 0x83BF},
{ 0x515D , 0x83C0},
{ 0x515E , 0x83C1},
{ 0x515F , 0x83C2},
{ 0x5160 , 0x83C3},
{ 0x5161 , 0x83C4},
{ 0x5163 , 0x83C5},
{ 0x5164 , 0x83C6},
{ 0x5166 , 0x83C7},
{ 0x5167 , 0x83C8},
{ 0x5169 , 0x83C9},
{ 0x516A , 0x83CA},
{ 0x516F , 0x83CB},
{ 0x5172 , 0x83CC},
{ 0x517A , 0x83CD},
{ 0x517E , 0x83CE},
{ 0x517F , 0x83CF},
{ 0x5183 , 0x83D0},
{ 0x5184 , 0x83D1},
{ 0x5186 , 0x83D2},
{ 0x5187 , 0x83D3},
{ 0x518A , 0x83D4},
{ 0x518B , 0x83D5},
{ 0x518E , 0x83D6},
{ 0x518F , 0x83D7},
{ 0x5190 , 0x83D8},
{ 0x5191 , 0x83D9},
{ 0x5193 , 0x83DA},
{ 0x5194 , 0x83DB},
{ 0x5198 , 0x83DC},
{ 0x519A , 0x83DD},
{ 0x519D , 0x83DE},
{ 0x519E , 0x83DF},
{ 0x519F , 0x83E0},
{ 0x51A1 , 0x83E1},
{ 0x51A3 , 0x83E2},
{ 0x51A6 , 0x83E3},
{ 0x51A7 , 0x83E4},
{ 0x51A8 , 0x83E5},
{ 0x51A9 , 0x83E6},
{ 0x51AA , 0x83E7},
{ 0x51AD , 0x83E8},
{ 0x51AE , 0x83E9},
{ 0x51B4 , 0x83EA},
{ 0x51B8 , 0x83EB},
{ 0x51B9 , 0x83EC},
{ 0x51BA , 0x83ED},
{ 0x51BE , 0x83EE},
{ 0x51BF , 0x83EF},
{ 0x51C1 , 0x83F0},
{ 0x51C2 , 0x83F1},
{ 0x51C3 , 0x83F2},
{ 0x51C5 , 0x83F3},
{ 0x51C8 , 0x83F4},
{ 0x51CA , 0x83F5},
{ 0x51CD , 0x83F6},
{ 0x51CE , 0x83F7},
{ 0x51D0 , 0x83F8},
{ 0x51D2 , 0x83F9},
{ 0x51D3 , 0x83FA},
{ 0x51D4 , 0x83FB},
{ 0x51D5 , 0x83FC},
{ 0x51D6 , 0x83FD},
{ 0x51D7 , 0x83FE},
{ 0x51D8 , 0x8440},
{ 0x51D9 , 0x8441},
{ 0x51DA , 0x8442},
{ 0x51DC , 0x8443},
{ 0x51DE , 0x8444},
{ 0x51DF , 0x8445},
{ 0x51E2 , 0x8446},
{ 0x51E3 , 0x8447},
{ 0x51E5 , 0x8448},
{ 0x51E6 , 0x8449},
{ 0x51E7 , 0x844A},
{ 0x51E8 , 0x844B},
{ 0x51E9 , 0x844C},
{ 0x51EA , 0x844D},
{ 0x51EC , 0x844E},
{ 0x51EE , 0x844F},
{ 0x51F1 , 0x8450},
{ 0x51F2 , 0x8451},
{ 0x51F4 , 0x8452},
{ 0x51F7 , 0x8453},
{ 0x51FE , 0x8454},
{ 0x5204 , 0x8455},
{ 0x5205 , 0x8456},
{ 0x5209 , 0x8457},
{ 0x520B , 0x8458},
{ 0x520C , 0x8459},
{ 0x520F , 0x845A},
{ 0x5210 , 0x845B},
{ 0x5213 , 0x845C},
{ 0x5214 , 0x845D},
{ 0x5215 , 0x845E},
{ 0x521C , 0x845F},
{ 0x521E , 0x8460},
{ 0x521F , 0x8461},
{ 0x5221 , 0x8462},
{ 0x5222 , 0x8463},
{ 0x5223 , 0x8464},
{ 0x5225 , 0x8465},
{ 0x5226 , 0x8466},
{ 0x5227 , 0x8467},
{ 0x522A , 0x8468},
{ 0x522C , 0x8469},
{ 0x522F , 0x846A},
{ 0x5231 , 0x846B},
{ 0x5232 , 0x846C},
{ 0x5234 , 0x846D},
{ 0x5235 , 0x846E},
{ 0x523C , 0x846F},
{ 0x523E , 0x8470},
{ 0x5244 , 0x8471},
{ 0x5245 , 0x8472},
{ 0x5246 , 0x8473},
{ 0x5247 , 0x8474},
{ 0x5248 , 0x8475},
{ 0x5249 , 0x8476},
{ 0x524B , 0x8477},
{ 0x524E , 0x8478},
{ 0x524F , 0x8479},
{ 0x5252 , 0x847A},
{ 0x5253 , 0x847B},
{ 0x5255 , 0x847C},
{ 0x5257 , 0x847D},
{ 0x5258 , 0x847E},
{ 0x5259 , 0x8480},
{ 0x525A , 0x8481},
{ 0x525B , 0x8482},
{ 0x525D , 0x8483},
{ 0x525F , 0x8484},
{ 0x5260 , 0x8485},
{ 0x5262 , 0x8486},
{ 0x5263 , 0x8487},
{ 0x5264 , 0x8488},
{ 0x5266 , 0x8489},
{ 0x5268 , 0x848A},
{ 0x526B , 0x848B},
{ 0x526C , 0x848C},
{ 0x526D , 0x848D},
{ 0x526E , 0x848E},
{ 0x5270 , 0x848F},
{ 0x5271 , 0x8490},
{ 0x5273 , 0x8491},
{ 0x5274 , 0x8492},
{ 0x5275 , 0x8493},
{ 0x5276 , 0x8494},
{ 0x5277 , 0x8495},
{ 0x5278 , 0x8496},
{ 0x5279 , 0x8497},
{ 0x527A , 0x8498},
{ 0x527B , 0x8499},
{ 0x527C , 0x849A},
{ 0x527E , 0x849B},
{ 0x5280 , 0x849C},
{ 0x5283 , 0x849D},
{ 0x5284 , 0x849E},
{ 0x5285 , 0x849F},
{ 0x5286 , 0x84A0},
{ 0x5287 , 0x84A1},
{ 0x5289 , 0x84A2},
{ 0x528A , 0x84A3},
{ 0x528B , 0x84A4},
{ 0x528C , 0x84A5},
{ 0x528D , 0x84A6},
{ 0x528E , 0x84A7},
{ 0x528F , 0x84A8},
{ 0x5291 , 0x84A9},
{ 0x5292 , 0x84AA},
{ 0x5294 , 0x84AB},
{ 0x5295 , 0x84AC},
{ 0x5296 , 0x84AD},
{ 0x5297 , 0x84AE},
{ 0x5298 , 0x84AF},
{ 0x5299 , 0x84B0},
{ 0x529A , 0x84B1},
{ 0x529C , 0x84B2},
{ 0x52A4 , 0x84B3},
{ 0x52A5 , 0x84B4},
{ 0x52A6 , 0x84B5},
{ 0x52A7 , 0x84B6},
{ 0x52AE , 0x84B7},
{ 0x52AF , 0x84B8},
{ 0x52B0 , 0x84B9},
{ 0x52B4 , 0x84BA},
{ 0x52B5 , 0x84BB},
{ 0x52B6 , 0x84BC},
{ 0x52B7 , 0x84BD},
{ 0x52B8 , 0x84BE},
{ 0x52B9 , 0x84BF},
{ 0x52BA , 0x84C0},
{ 0x52BB , 0x84C1},
{ 0x52BC , 0x84C2},
{ 0x52BD , 0x84C3},
{ 0x52C0 , 0x84C4},
{ 0x52C1 , 0x84C5},
{ 0x52C2 , 0x84C6},
{ 0x52C4 , 0x84C7},
{ 0x52C5 , 0x84C8},
{ 0x52C6 , 0x84C9},
{ 0x52C8 , 0x84CA},
{ 0x52CA , 0x84CB},
{ 0x52CC , 0x84CC},
{ 0x52CD , 0x84CD},
{ 0x52CE , 0x84CE},
{ 0x52CF , 0x84CF},
{ 0x52D1 , 0x84D0},
{ 0x52D3 , 0x84D1},
{ 0x52D4 , 0x84D2},
{ 0x52D5 , 0x84D3},
{ 0x52D7 , 0x84D4},
{ 0x52D9 , 0x84D5},
{ 0x52DA , 0x84D6},
{ 0x52DB , 0x84D7},
{ 0x52DC , 0x84D8},
{ 0x52DD , 0x84D9},
{ 0x52DE , 0x84DA},
{ 0x52E0 , 0x84DB},
{ 0x52E1 , 0x84DC},
{ 0x52E2 , 0x84DD},
{ 0x52E3 , 0x84DE},
{ 0x52E5 , 0x84DF},
{ 0x52E6 , 0x84E0},
{ 0x52E7 , 0x84E1},
{ 0x52E8 , 0x84E2},
{ 0x52E9 , 0x84E3},
{ 0x52EA , 0x84E4},
{ 0x52EB , 0x84E5},
{ 0x52EC , 0x84E6},
{ 0x52ED , 0x84E7},
{ 0x52EE , 0x84E8},
{ 0x52EF , 0x84E9},
{ 0x52F1 , 0x84EA},
{ 0x52F2 , 0x84EB},
{ 0x52F3 , 0x84EC},
{ 0x52F4 , 0x84ED},
{ 0x52F5 , 0x84EE},
{ 0x52F6 , 0x84EF},
{ 0x52F7 , 0x84F0},
{ 0x52F8 , 0x84F1},
{ 0x52FB , 0x84F2},
{ 0x52FC , 0x84F3},
{ 0x52FD , 0x84F4},
{ 0x5301 , 0x84F5},
{ 0x5302 , 0x84F6},
{ 0x5303 , 0x84F7},
{ 0x5304 , 0x84F8},
{ 0x5307 , 0x84F9},
{ 0x5309 , 0x84FA},
{ 0x530A , 0x84FB},
{ 0x530B , 0x84FC},
{ 0x530C , 0x84FD},
{ 0x530E , 0x84FE},
{ 0x5311 , 0x8540},
{ 0x5312 , 0x8541},
{ 0x5313 , 0x8542},
{ 0x5314 , 0x8543},
{ 0x5318 , 0x8544},
{ 0x531B , 0x8545},
{ 0x531C , 0x8546},
{ 0x531E , 0x8547},
{ 0x531F , 0x8548},
{ 0x5322 , 0x8549},
{ 0x5324 , 0x854A},
{ 0x5325 , 0x854B},
{ 0x5327 , 0x854C},
{ 0x5328 , 0x854D},
{ 0x5329 , 0x854E},
{ 0x532B , 0x854F},
{ 0x532C , 0x8550},
{ 0x532D , 0x8551},
{ 0x532F , 0x8552},
{ 0x5330 , 0x8553},
{ 0x5331 , 0x8554},
{ 0x5332 , 0x8555},
{ 0x5333 , 0x8556},
{ 0x5334 , 0x8557},
{ 0x5335 , 0x8558},
{ 0x5336 , 0x8559},
{ 0x5337 , 0x855A},
{ 0x5338 , 0x855B},
{ 0x533C , 0x855C},
{ 0x533D , 0x855D},
{ 0x5340 , 0x855E},
{ 0x5342 , 0x855F},
{ 0x5344 , 0x8560},
{ 0x5346 , 0x8561},
{ 0x534B , 0x8562},
{ 0x534C , 0x8563},
{ 0x534D , 0x8564},
{ 0x5350 , 0x8565},
{ 0x5354 , 0x8566},
{ 0x5358 , 0x8567},
{ 0x5359 , 0x8568},
{ 0x535B , 0x8569},
{ 0x535D , 0x856A},
{ 0x5365 , 0x856B},
{ 0x5368 , 0x856C},
{ 0x536A , 0x856D},
{ 0x536C , 0x856E},
{ 0x536D , 0x856F},
{ 0x5372 , 0x8570},
{ 0x5376 , 0x8571},
{ 0x5379 , 0x8572},
{ 0x537B , 0x8573},
{ 0x537C , 0x8574},
{ 0x537D , 0x8575},
{ 0x537E , 0x8576},
{ 0x5380 , 0x8577},
{ 0x5381 , 0x8578},
{ 0x5383 , 0x8579},
{ 0x5387 , 0x857A},
{ 0x5388 , 0x857B},
{ 0x538A , 0x857C},
{ 0x538E , 0x857D},
{ 0x538F , 0x857E},
{ 0x5390 , 0x8580},
{ 0x5391 , 0x8581},
{ 0x5392 , 0x8582},
{ 0x5393 , 0x8583},
{ 0x5394 , 0x8584},
{ 0x5396 , 0x8585},
{ 0x5397 , 0x8586},
{ 0x5399 , 0x8587},
{ 0x539B , 0x8588},
{ 0x539C , 0x8589},
{ 0x539E , 0x858A},
{ 0x53A0 , 0x858B},
{ 0x53A1 , 0x858C},
{ 0x53A4 , 0x858D},
{ 0x53A7 , 0x858E},
{ 0x53AA , 0x858F},
{ 0x53AB , 0x8590},
{ 0x53AC , 0x8591},
{ 0x53AD , 0x8592},
{ 0x53AF , 0x8593},
{ 0x53B0 , 0x8594},
{ 0x53B1 , 0x8595},
{ 0x53B2 , 0x8596},
{ 0x53B3 , 0x8597},
{ 0x53B4 , 0x8598},
{ 0x53B5 , 0x8599},
{ 0x53B7 , 0x859A},
{ 0x53B8 , 0x859B},
{ 0x53B9 , 0x859C},
{ 0x53BA , 0x859D},
{ 0x53BC , 0x859E},
{ 0x53BD , 0x859F},
{ 0x53BE , 0x85A0},
{ 0x53C0 , 0x85A1},
{ 0x53C3 , 0x85A2},
{ 0x53C4 , 0x85A3},
{ 0x53C5 , 0x85A4},
{ 0x53C6 , 0x85A5},
{ 0x53C7 , 0x85A6},
{ 0x53CE , 0x85A7},
{ 0x53CF , 0x85A8},
{ 0x53D0 , 0x85A9},
{ 0x53D2 , 0x85AA},
{ 0x53D3 , 0x85AB},
{ 0x53D5 , 0x85AC},
{ 0x53DA , 0x85AD},
{ 0x53DC , 0x85AE},
{ 0x53DD , 0x85AF},
{ 0x53DE , 0x85B0},
{ 0x53E1 , 0x85B1},
{ 0x53E2 , 0x85B2},
{ 0x53E7 , 0x85B3},
{ 0x53F4 , 0x85B4},
{ 0x53FA , 0x85B5},
{ 0x53FE , 0x85B6},
{ 0x53FF , 0x85B7},
{ 0x5400 , 0x85B8},
{ 0x5402 , 0x85B9},
{ 0x5405 , 0x85BA},
{ 0x5407 , 0x85BB},
{ 0x540B , 0x85BC},
{ 0x5414 , 0x85BD},
{ 0x5418 , 0x85BE},
{ 0x5419 , 0x85BF},
{ 0x541A , 0x85C0},
{ 0x541C , 0x85C1},
{ 0x5422 , 0x85C2},
{ 0x5424 , 0x85C3},
{ 0x5425 , 0x85C4},
{ 0x542A , 0x85C5},
{ 0x5430 , 0x85C6},
{ 0x5433 , 0x85C7},
{ 0x5436 , 0x85C8},
{ 0x5437 , 0x85C9},
{ 0x543A , 0x85CA},
{ 0x543D , 0x85CB},
{ 0x543F , 0x85CC},
{ 0x5441 , 0x85CD},
{ 0x5442 , 0x85CE},
{ 0x5444 , 0x85CF},
{ 0x5445 , 0x85D0},
{ 0x5447 , 0x85D1},
{ 0x5449 , 0x85D2},
{ 0x544C , 0x85D3},
{ 0x544D , 0x85D4},
{ 0x544E , 0x85D5},
{ 0x544F , 0x85D6},
{ 0x5451 , 0x85D7},
{ 0x545A , 0x85D8},
{ 0x545D , 0x85D9},
{ 0x545E , 0x85DA},
{ 0x545F , 0x85DB},
{ 0x5460 , 0x85DC},
{ 0x5461 , 0x85DD},
{ 0x5463 , 0x85DE},
{ 0x5465 , 0x85DF},
{ 0x5467 , 0x85E0},
{ 0x5469 , 0x85E1},
{ 0x546A , 0x85E2},
{ 0x546B , 0x85E3},
{ 0x546C , 0x85E4},
{ 0x546D , 0x85E5},
{ 0x546E , 0x85E6},
{ 0x546F , 0x85E7},
{ 0x5470 , 0x85E8},
{ 0x5474 , 0x85E9},
{ 0x5479 , 0x85EA},
{ 0x547A , 0x85EB},
{ 0x547E , 0x85EC},
{ 0x547F , 0x85ED},
{ 0x5481 , 0x85EE},
{ 0x5483 , 0x85EF},
{ 0x5485 , 0x85F0},
{ 0x5487 , 0x85F1},
{ 0x5488 , 0x85F2},
{ 0x5489 , 0x85F3},
{ 0x548A , 0x85F4},
{ 0x548D , 0x85F5},
{ 0x5491 , 0x85F6},
{ 0x5493 , 0x85F7},
{ 0x5497 , 0x85F8},
{ 0x5498 , 0x85F9},
{ 0x549C , 0x85FA},
{ 0x549E , 0x85FB},
{ 0x549F , 0x85FC},
{ 0x54A0 , 0x85FD},
{ 0x54A1 , 0x85FE},
{ 0x54A2 , 0x8640},
{ 0x54A5 , 0x8641},
{ 0x54AE , 0x8642},
{ 0x54B0 , 0x8643},
{ 0x54B2 , 0x8644},
{ 0x54B5 , 0x8645},
{ 0x54B6 , 0x8646},
{ 0x54B7 , 0x8647},
{ 0x54B9 , 0x8648},
{ 0x54BA , 0x8649},
{ 0x54BC , 0x864A},
{ 0x54BE , 0x864B},
{ 0x54C3 , 0x864C},
{ 0x54C5 , 0x864D},
{ 0x54CA , 0x864E},
{ 0x54CB , 0x864F},
{ 0x54D6 , 0x8650},
{ 0x54D8 , 0x8651},
{ 0x54DB , 0x8652},
{ 0x54E0 , 0x8653},
{ 0x54E1 , 0x8654},
{ 0x54E2 , 0x8655},
{ 0x54E3 , 0x8656},
{ 0x54E4 , 0x8657},
{ 0x54EB , 0x8658},
{ 0x54EC , 0x8659},
{ 0x54EF , 0x865A},
{ 0x54F0 , 0x865B},
{ 0x54F1 , 0x865C},
{ 0x54F4 , 0x865D},
{ 0x54F5 , 0x865E},
{ 0x54F6 , 0x865F},
{ 0x54F7 , 0x8660},
{ 0x54F8 , 0x8661},
{ 0x54F9 , 0x8662},
{ 0x54FB , 0x8663},
{ 0x54FE , 0x8664},
{ 0x5500 , 0x8665},
{ 0x5502 , 0x8666},
{ 0x5503 , 0x8667},
{ 0x5504 , 0x8668},
{ 0x5505 , 0x8669},
{ 0x5508 , 0x866A},
{ 0x550A , 0x866B},
{ 0x550B , 0x866C},
{ 0x550C , 0x866D},
{ 0x550D , 0x866E},
{ 0x550E , 0x866F},
{ 0x5512 , 0x8670},
{ 0x5513 , 0x8671},
{ 0x5515 , 0x8672},
{ 0x5516 , 0x8673},
{ 0x5517 , 0x8674},
{ 0x5518 , 0x8675},
{ 0x5519 , 0x8676},
{ 0x551A , 0x8677},
{ 0x551C , 0x8678},
{ 0x551D , 0x8679},
{ 0x551E , 0x867A},
{ 0x551F , 0x867B},
{ 0x5521 , 0x867C},
{ 0x5525 , 0x867D},
{ 0x5526 , 0x867E},
{ 0x5528 , 0x8680},
{ 0x5529 , 0x8681},
{ 0x552B , 0x8682},
{ 0x552D , 0x8683},
{ 0x5532 , 0x8684},
{ 0x5534 , 0x8685},
{ 0x5535 , 0x8686},
{ 0x5536 , 0x8687},
{ 0x5538 , 0x8688},
{ 0x5539 , 0x8689},
{ 0x553A , 0x868A},
{ 0x553B , 0x868B},
{ 0x553D , 0x868C},
{ 0x5540 , 0x868D},
{ 0x5542 , 0x868E},
{ 0x5545 , 0x868F},
{ 0x5547 , 0x8690},
{ 0x5548 , 0x8691},
{ 0x554B , 0x8692},
{ 0x554C , 0x8693},
{ 0x554D , 0x8694},
{ 0x554E , 0x8695},
{ 0x554F , 0x8696},
{ 0x5551 , 0x8697},
{ 0x5552 , 0x8698},
{ 0x5553 , 0x8699},
{ 0x5554 , 0x869A},
{ 0x5557 , 0x869B},
{ 0x5558 , 0x869C},
{ 0x5559 , 0x869D},
{ 0x555A , 0x869E},
{ 0x555B , 0x869F},
{ 0x555D , 0x86A0},
{ 0x555E , 0x86A1},
{ 0x555F , 0x86A2},
{ 0x5560 , 0x86A3},
{ 0x5562 , 0x86A4},
{ 0x5563 , 0x86A5},
{ 0x5568 , 0x86A6},
{ 0x5569 , 0x86A7},
{ 0x556B , 0x86A8},
{ 0x556F , 0x86A9},
{ 0x5570 , 0x86AA},
{ 0x5571 , 0x86AB},
{ 0x5572 , 0x86AC},
{ 0x5573 , 0x86AD},
{ 0x5574 , 0x86AE},
{ 0x5579 , 0x86AF},
{ 0x557A , 0x86B0},
{ 0x557D , 0x86B1},
{ 0x557F , 0x86B2},
{ 0x5585 , 0x86B3},
{ 0x5586 , 0x86B4},
{ 0x558C , 0x86B5},
{ 0x558D , 0x86B6},
{ 0x558E , 0x86B7},
{ 0x5590 , 0x86B8},
{ 0x5592 , 0x86B9},
{ 0x5593 , 0x86BA},
{ 0x5595 , 0x86BB},
{ 0x5596 , 0x86BC},
{ 0x5597 , 0x86BD},
{ 0x559A , 0x86BE},
{ 0x559B , 0x86BF},
{ 0x559E , 0x86C0},
{ 0x55A0 , 0x86C1},
{ 0x55A1 , 0x86C2},
{ 0x55A2 , 0x86C3},
{ 0x55A3 , 0x86C4},
{ 0x55A4 , 0x86C5},
{ 0x55A5 , 0x86C6},
{ 0x55A6 , 0x86C7},
{ 0x55A8 , 0x86C8},
{ 0x55A9 , 0x86C9},
{ 0x55AA , 0x86CA},
{ 0x55AB , 0x86CB},
{ 0x55AC , 0x86CC},
{ 0x55AD , 0x86CD},
{ 0x55AE , 0x86CE},
{ 0x55AF , 0x86CF},
{ 0x55B0 , 0x86D0},
{ 0x55B2 , 0x86D1},
{ 0x55B4 , 0x86D2},
{ 0x55B6 , 0x86D3},
{ 0x55B8 , 0x86D4},
{ 0x55BA , 0x86D5},
{ 0x55BC , 0x86D6},
{ 0x55BF , 0x86D7},
{ 0x55C0 , 0x86D8},
{ 0x55C1 , 0x86D9},
{ 0x55C2 , 0x86DA},
{ 0x55C3 , 0x86DB},
{ 0x55C6 , 0x86DC},
{ 0x55C7 , 0x86DD},
{ 0x55C8 , 0x86DE},
{ 0x55CA , 0x86DF},
{ 0x55CB , 0x86E0},
{ 0x55CE , 0x86E1},
{ 0x55CF , 0x86E2},
{ 0x55D0 , 0x86E3},
{ 0x55D5 , 0x86E4},
{ 0x55D7 , 0x86E5},
{ 0x55D8 , 0x86E6},
{ 0x55D9 , 0x86E7},
{ 0x55DA , 0x86E8},
{ 0x55DB , 0x86E9},
{ 0x55DE , 0x86EA},
{ 0x55E0 , 0x86EB},
{ 0x55E2 , 0x86EC},
{ 0x55E7 , 0x86ED},
{ 0x55E9 , 0x86EE},
{ 0x55ED , 0x86EF},
{ 0x55EE , 0x86F0},
{ 0x55F0 , 0x86F1},
{ 0x55F1 , 0x86F2},
{ 0x55F4 , 0x86F3},
{ 0x55F6 , 0x86F4},
{ 0x55F8 , 0x86F5},
{ 0x55F9 , 0x86F6},
{ 0x55FA , 0x86F7},
{ 0x55FB , 0x86F8},
{ 0x55FC , 0x86F9},
{ 0x55FF , 0x86FA},
{ 0x5602 , 0x86FB},
{ 0x5603 , 0x86FC},
{ 0x5604 , 0x86FD},
{ 0x5605 , 0x86FE},
{ 0x5606 , 0x8740},
{ 0x5607 , 0x8741},
{ 0x560A , 0x8742},
{ 0x560B , 0x8743},
{ 0x560D , 0x8744},
{ 0x5610 , 0x8745},
{ 0x5611 , 0x8746},
{ 0x5612 , 0x8747},
{ 0x5613 , 0x8748},
{ 0x5614 , 0x8749},
{ 0x5615 , 0x874A},
{ 0x5616 , 0x874B},
{ 0x5617 , 0x874C},
{ 0x5619 , 0x874D},
{ 0x561A , 0x874E},
{ 0x561C , 0x874F},
{ 0x561D , 0x8750},
{ 0x5620 , 0x8751},
{ 0x5621 , 0x8752},
{ 0x5622 , 0x8753},
{ 0x5625 , 0x8754},
{ 0x5626 , 0x8755},
{ 0x5628 , 0x8756},
{ 0x5629 , 0x8757},
{ 0x562A , 0x8758},
{ 0x562B , 0x8759},
{ 0x562E , 0x875A},
{ 0x562F , 0x875B},
{ 0x5630 , 0x875C},
{ 0x5633 , 0x875D},
{ 0x5635 , 0x875E},
{ 0x5637 , 0x875F},
{ 0x5638 , 0x8760},
{ 0x563A , 0x8761},
{ 0x563C , 0x8762},
{ 0x563D , 0x8763},
{ 0x563E , 0x8764},
{ 0x5640 , 0x8765},
{ 0x5641 , 0x8766},
{ 0x5642 , 0x8767},
{ 0x5643 , 0x8768},
{ 0x5644 , 0x8769},
{ 0x5645 , 0x876A},
{ 0x5646 , 0x876B},
{ 0x5647 , 0x876C},
{ 0x5648 , 0x876D},
{ 0x5649 , 0x876E},
{ 0x564A , 0x876F},
{ 0x564B , 0x8770},
{ 0x564F , 0x8771},
{ 0x5650 , 0x8772},
{ 0x5651 , 0x8773},
{ 0x5652 , 0x8774},
{ 0x5653 , 0x8775},
{ 0x5655 , 0x8776},
{ 0x5656 , 0x8777},
{ 0x565A , 0x8778},
{ 0x565B , 0x8779},
{ 0x565D , 0x877A},
{ 0x565E , 0x877B},
{ 0x565F , 0x877C},
{ 0x5660 , 0x877D},
{ 0x5661 , 0x877E},
{ 0x5663 , 0x8780},
{ 0x5665 , 0x8781},
{ 0x5666 , 0x8782},
{ 0x5667 , 0x8783},
{ 0x566D , 0x8784},
{ 0x566E , 0x8785},
{ 0x566F , 0x8786},
{ 0x5670 , 0x8787},
{ 0x5672 , 0x8788},
{ 0x5673 , 0x8789},
{ 0x5674 , 0x878A},
{ 0x5675 , 0x878B},
{ 0x5677 , 0x878C},
{ 0x5678 , 0x878D},
{ 0x5679 , 0x878E},
{ 0x567A , 0x878F},
{ 0x567D , 0x8790},
{ 0x567E , 0x8791},
{ 0x567F , 0x8792},
{ 0x5680 , 0x8793},
{ 0x5681 , 0x8794},
{ 0x5682 , 0x8795},
{ 0x5683 , 0x8796},
{ 0x5684 , 0x8797},
{ 0x5687 , 0x8798},
{ 0x5688 , 0x8799},
{ 0x5689 , 0x879A},
{ 0x568A , 0x879B},
{ 0x568B , 0x879C},
{ 0x568C , 0x879D},
{ 0x568D , 0x879E},
{ 0x5690 , 0x879F},
{ 0x5691 , 0x87A0},
{ 0x5692 , 0x87A1},
{ 0x5694 , 0x87A2},
{ 0x5695 , 0x87A3},
{ 0x5696 , 0x87A4},
{ 0x5697 , 0x87A5},
{ 0x5698 , 0x87A6},
{ 0x5699 , 0x87A7},
{ 0x569A , 0x87A8},
{ 0x569B , 0x87A9},
{ 0x569C , 0x87AA},
{ 0x569D , 0x87AB},
{ 0x569E , 0x87AC},
{ 0x569F , 0x87AD},
{ 0x56A0 , 0x87AE},
{ 0x56A1 , 0x87AF},
{ 0x56A2 , 0x87B0},
{ 0x56A4 , 0x87B1},
{ 0x56A5 , 0x87B2},
{ 0x56A6 , 0x87B3},
{ 0x56A7 , 0x87B4},
{ 0x56A8 , 0x87B5},
{ 0x56A9 , 0x87B6},
{ 0x56AA , 0x87B7},
{ 0x56AB , 0x87B8},
{ 0x56AC , 0x87B9},
{ 0x56AD , 0x87BA},
{ 0x56AE , 0x87BB},
{ 0x56B0 , 0x87BC},
{ 0x56B1 , 0x87BD},
{ 0x56B2 , 0x87BE},
{ 0x56B3 , 0x87BF},
{ 0x56B4 , 0x87C0},
{ 0x56B5 , 0x87C1},
{ 0x56B6 , 0x87C2},
{ 0x56B8 , 0x87C3},
{ 0x56B9 , 0x87C4},
{ 0x56BA , 0x87C5},
{ 0x56BB , 0x87C6},
{ 0x56BD , 0x87C7},
{ 0x56BE , 0x87C8},
{ 0x56BF , 0x87C9},
{ 0x56C0 , 0x87CA},
{ 0x56C1 , 0x87CB},
{ 0x56C2 , 0x87CC},
{ 0x56C3 , 0x87CD},
{ 0x56C4 , 0x87CE},
{ 0x56C5 , 0x87CF},
{ 0x56C6 , 0x87D0},
{ 0x56C7 , 0x87D1},
{ 0x56C8 , 0x87D2},
{ 0x56C9 , 0x87D3},
{ 0x56CB , 0x87D4},
{ 0x56CC , 0x87D5},
{ 0x56CD , 0x87D6},
{ 0x56CE , 0x87D7},
{ 0x56CF , 0x87D8},
{ 0x56D0 , 0x87D9},
{ 0x56D1 , 0x87DA},
{ 0x56D2 , 0x87DB},
{ 0x56D3 , 0x87DC},
{ 0x56D5 , 0x87DD},
{ 0x56D6 , 0x87DE},
{ 0x56D8 , 0x87DF},
{ 0x56D9 , 0x87E0},
{ 0x56DC , 0x87E1},
{ 0x56E3 , 0x87E2},
{ 0x56E5 , 0x87E3},
{ 0x56E6 , 0x87E4},
{ 0x56E7 , 0x87E5},
{ 0x56E8 , 0x87E6},
{ 0x56E9 , 0x87E7},
{ 0x56EA , 0x87E8},
{ 0x56EC , 0x87E9},
{ 0x56EE , 0x87EA},
{ 0x56EF , 0x87EB},
{ 0x56F2 , 0x87EC},
{ 0x56F3 , 0x87ED},
{ 0x56F6 , 0x87EE},
{ 0x56F7 , 0x87EF},
{ 0x56F8 , 0x87F0},
{ 0x56FB , 0x87F1},
{ 0x56FC , 0x87F2},
{ 0x5700 , 0x87F3},
{ 0x5701 , 0x87F4},
{ 0x5702 , 0x87F5},
{ 0x5705 , 0x87F6},
{ 0x5707 , 0x87F7},
{ 0x570B , 0x87F8},
{ 0x570C , 0x87F9},
{ 0x570D , 0x87FA},
{ 0x570E , 0x87FB},
{ 0x570F , 0x87FC},
{ 0x5710 , 0x87FD},
{ 0x5711 , 0x87FE},
{ 0x5712 , 0x8840},
{ 0x5713 , 0x8841},
{ 0x5714 , 0x8842},
{ 0x5715 , 0x8843},
{ 0x5716 , 0x8844},
{ 0x5717 , 0x8845},
{ 0x5718 , 0x8846},
{ 0x5719 , 0x8847},
{ 0x571A , 0x8848},
{ 0x571B , 0x8849},
{ 0x571D , 0x884A},
{ 0x571E , 0x884B},
{ 0x5720 , 0x884C},
{ 0x5721 , 0x884D},
{ 0x5722 , 0x884E},
{ 0x5724 , 0x884F},
{ 0x5725 , 0x8850},
{ 0x5726 , 0x8851},
{ 0x5727 , 0x8852},
{ 0x572B , 0x8853},
{ 0x5731 , 0x8854},
{ 0x5732 , 0x8855},
{ 0x5734 , 0x8856},
{ 0x5735 , 0x8857},
{ 0x5736 , 0x8858},
{ 0x5737 , 0x8859},
{ 0x5738 , 0x885A},
{ 0x573C , 0x885B},
{ 0x573D , 0x885C},
{ 0x573F , 0x885D},
{ 0x5741 , 0x885E},
{ 0x5743 , 0x885F},
{ 0x5744 , 0x8860},
{ 0x5745 , 0x8861},
{ 0x5746 , 0x8862},
{ 0x5748 , 0x8863},
{ 0x5749 , 0x8864},
{ 0x574B , 0x8865},
{ 0x5752 , 0x8866},
{ 0x5753 , 0x8867},
{ 0x5754 , 0x8868},
{ 0x5755 , 0x8869},
{ 0x5756 , 0x886A},
{ 0x5758 , 0x886B},
{ 0x5759 , 0x886C},
{ 0x5762 , 0x886D},
{ 0x5763 , 0x886E},
{ 0x5765 , 0x886F},
{ 0x5767 , 0x8870},
{ 0x576C , 0x8871},
{ 0x576E , 0x8872},
{ 0x5770 , 0x8873},
{ 0x5771 , 0x8874},
{ 0x5772 , 0x8875},
{ 0x5774 , 0x8876},
{ 0x5775 , 0x8877},
{ 0x5778 , 0x8878},
{ 0x5779 , 0x8879},
{ 0x577A , 0x887A},
{ 0x577D , 0x887B},
{ 0x577E , 0x887C},
{ 0x577F , 0x887D},
{ 0x5780 , 0x887E},
{ 0x5781 , 0x8880},
{ 0x5787 , 0x8881},
{ 0x5788 , 0x8882},
{ 0x5789 , 0x8883},
{ 0x578A , 0x8884},
{ 0x578D , 0x8885},
{ 0x578E , 0x8886},
{ 0x578F , 0x8887},
{ 0x5790 , 0x8888},
{ 0x5791 , 0x8889},
{ 0x5794 , 0x888A},
{ 0x5795 , 0x888B},
{ 0x5796 , 0x888C},
{ 0x5797 , 0x888D},
{ 0x5798 , 0x888E},
{ 0x5799 , 0x888F},
{ 0x579A , 0x8890},
{ 0x579C , 0x8891},
{ 0x579D , 0x8892},
{ 0x579E , 0x8893},
{ 0x579F , 0x8894},
{ 0x57A5 , 0x8895},
{ 0x57A8 , 0x8896},
{ 0x57AA , 0x8897},
{ 0x57AC , 0x8898},
{ 0x57AF , 0x8899},
{ 0x57B0 , 0x889A},
{ 0x57B1 , 0x889B},
{ 0x57B3 , 0x889C},
{ 0x57B5 , 0x889D},
{ 0x57B6 , 0x889E},
{ 0x57B7 , 0x889F},
{ 0x57B9 , 0x88A0},
{ 0x57BA , 0x88A1},
{ 0x57BB , 0x88A2},
{ 0x57BC , 0x88A3},
{ 0x57BD , 0x88A4},
{ 0x57BE , 0x88A5},
{ 0x57BF , 0x88A6},
{ 0x57C0 , 0x88A7},
{ 0x57C1 , 0x88A8},
{ 0x57C4 , 0x88A9},
{ 0x57C5 , 0x88AA},
{ 0x57C6 , 0x88AB},
{ 0x57C7 , 0x88AC},
{ 0x57C8 , 0x88AD},
{ 0x57C9 , 0x88AE},
{ 0x57CA , 0x88AF},
{ 0x57CC , 0x88B0},
{ 0x57CD , 0x88B1},
{ 0x57D0 , 0x88B2},
{ 0x57D1 , 0x88B3},
{ 0x57D3 , 0x88B4},
{ 0x57D6 , 0x88B5},
{ 0x57D7 , 0x88B6},
{ 0x57DB , 0x88B7},
{ 0x57DC , 0x88B8},
{ 0x57DE , 0x88B9},
{ 0x57E1 , 0x88BA},
{ 0x57E2 , 0x88BB},
{ 0x57E3 , 0x88BC},
{ 0x57E5 , 0x88BD},
{ 0x57E6 , 0x88BE},
{ 0x57E7 , 0x88BF},
{ 0x57E8 , 0x88C0},
{ 0x57E9 , 0x88C1},
{ 0x57EA , 0x88C2},
{ 0x57EB , 0x88C3},
{ 0x57EC , 0x88C4},
{ 0x57EE , 0x88C5},
{ 0x57F0 , 0x88C6},
{ 0x57F1 , 0x88C7},
{ 0x57F2 , 0x88C8},
{ 0x57F3 , 0x88C9},
{ 0x57F5 , 0x88CA},
{ 0x57F6 , 0x88CB},
{ 0x57F7 , 0x88CC},
{ 0x57FB , 0x88CD},
{ 0x57FC , 0x88CE},
{ 0x57FE , 0x88CF},
{ 0x57FF , 0x88D0},
{ 0x5801 , 0x88D1},
{ 0x5803 , 0x88D2},
{ 0x5804 , 0x88D3},
{ 0x5805 , 0x88D4},
{ 0x5808 , 0x88D5},
{ 0x5809 , 0x88D6},
{ 0x580A , 0x88D7},
{ 0x580C , 0x88D8},
{ 0x580E , 0x88D9},
{ 0x580F , 0x88DA},
{ 0x5810 , 0x88DB},
{ 0x5812 , 0x88DC},
{ 0x5813 , 0x88DD},
{ 0x5814 , 0x88DE},
{ 0x5816 , 0x88DF},
{ 0x5817 , 0x88E0},
{ 0x5818 , 0x88E1},
{ 0x581A , 0x88E2},
{ 0x581B , 0x88E3},
{ 0x581C , 0x88E4},
{ 0x581D , 0x88E5},
{ 0x581F , 0x88E6},
{ 0x5822 , 0x88E7},
{ 0x5823 , 0x88E8},
{ 0x5825 , 0x88E9},
{ 0x5826 , 0x88EA},
{ 0x5827 , 0x88EB},
{ 0x5828 , 0x88EC},
{ 0x5829 , 0x88ED},
{ 0x582B , 0x88EE},
{ 0x582C , 0x88EF},
{ 0x582D , 0x88F0},
{ 0x582E , 0x88F1},
{ 0x582F , 0x88F2},
{ 0x5831 , 0x88F3},
{ 0x5832 , 0x88F4},
{ 0x5833 , 0x88F5},
{ 0x5834 , 0x88F6},
{ 0x5836 , 0x88F7},
{ 0x5837 , 0x88F8},
{ 0x5838 , 0x88F9},
{ 0x5839 , 0x88FA},
{ 0x583A , 0x88FB},
{ 0x583B , 0x88FC},
{ 0x583C , 0x88FD},
{ 0x583D , 0x88FE},
{ 0x583E , 0x8940},
{ 0x583F , 0x8941},
{ 0x5840 , 0x8942},
{ 0x5841 , 0x8943},
{ 0x5842 , 0x8944},
{ 0x5843 , 0x8945},
{ 0x5845 , 0x8946},
{ 0x5846 , 0x8947},
{ 0x5847 , 0x8948},
{ 0x5848 , 0x8949},
{ 0x5849 , 0x894A},
{ 0x584A , 0x894B},
{ 0x584B , 0x894C},
{ 0x584E , 0x894D},
{ 0x584F , 0x894E},
{ 0x5850 , 0x894F},
{ 0x5852 , 0x8950},
{ 0x5853 , 0x8951},
{ 0x5855 , 0x8952},
{ 0x5856 , 0x8953},
{ 0x5857 , 0x8954},
{ 0x5859 , 0x8955},
{ 0x585A , 0x8956},
{ 0x585B , 0x8957},
{ 0x585C , 0x8958},
{ 0x585D , 0x8959},
{ 0x585F , 0x895A},
{ 0x5860 , 0x895B},
{ 0x5861 , 0x895C},
{ 0x5862 , 0x895D},
{ 0x5863 , 0x895E},
{ 0x5864 , 0x895F},
{ 0x5866 , 0x8960},
{ 0x5867 , 0x8961},
{ 0x5868 , 0x8962},
{ 0x5869 , 0x8963},
{ 0x586A , 0x8964},
{ 0x586D , 0x8965},
{ 0x586E , 0x8966},
{ 0x586F , 0x8967},
{ 0x5870 , 0x8968},
{ 0x5871 , 0x8969},
{ 0x5872 , 0x896A},
{ 0x5873 , 0x896B},
{ 0x5874 , 0x896C},
{ 0x5875 , 0x896D},
{ 0x5876 , 0x896E},
{ 0x5877 , 0x896F},
{ 0x5878 , 0x8970},
{ 0x5879 , 0x8971},
{ 0x587A , 0x8972},
{ 0x587B , 0x8973},
{ 0x587C , 0x8974},
{ 0x587D , 0x8975},
{ 0x587F , 0x8976},
{ 0x5882 , 0x8977},
{ 0x5884 , 0x8978},
{ 0x5886 , 0x8979},
{ 0x5887 , 0x897A},
{ 0x5888 , 0x897B},
{ 0x588A , 0x897C},
{ 0x588B , 0x897D},
{ 0x588C , 0x897E},
{ 0x588D , 0x8980},
{ 0x588E , 0x8981},
{ 0x588F , 0x8982},
{ 0x5890 , 0x8983},
{ 0x5891 , 0x8984},
{ 0x5894 , 0x8985},
{ 0x5895 , 0x8986},
{ 0x5896 , 0x8987},
{ 0x5897 , 0x8988},
{ 0x5898 , 0x8989},
{ 0x589B , 0x898A},
{ 0x589C , 0x898B},
{ 0x589D , 0x898C},
{ 0x58A0 , 0x898D},
{ 0x58A1 , 0x898E},
{ 0x58A2 , 0x898F},
{ 0x58A3 , 0x8990},
{ 0x58A4 , 0x8991},
{ 0x58A5 , 0x8992},
{ 0x58A6 , 0x8993},
{ 0x58A7 , 0x8994},
{ 0x58AA , 0x8995},
{ 0x58AB , 0x8996},
{ 0x58AC , 0x8997},
{ 0x58AD , 0x8998},
{ 0x58AE , 0x8999},
{ 0x58AF , 0x899A},
{ 0x58B0 , 0x899B},
{ 0x58B1 , 0x899C},
{ 0x58B2 , 0x899D},
{ 0x58B3 , 0x899E},
{ 0x58B4 , 0x899F},
{ 0x58B5 , 0x89A0},
{ 0x58B6 , 0x89A1},
{ 0x58B7 , 0x89A2},
{ 0x58B8 , 0x89A3},
{ 0x58B9 , 0x89A4},
{ 0x58BA , 0x89A5},
{ 0x58BB , 0x89A6},
{ 0x58BD , 0x89A7},
{ 0x58BE , 0x89A8},
{ 0x58BF , 0x89A9},
{ 0x58C0 , 0x89AA},
{ 0x58C2 , 0x89AB},
{ 0x58C3 , 0x89AC},
{ 0x58C4 , 0x89AD},
{ 0x58C6 , 0x89AE},
{ 0x58C7 , 0x89AF},
{ 0x58C8 , 0x89B0},
{ 0x58C9 , 0x89B1},
{ 0x58CA , 0x89B2},
{ 0x58CB , 0x89B3},
{ 0x58CC , 0x89B4},
{ 0x58CD , 0x89B5},
{ 0x58CE , 0x89B6},
{ 0x58CF , 0x89B7},
{ 0x58D0 , 0x89B8},
{ 0x58D2 , 0x89B9},
{ 0x58D3 , 0x89BA},
{ 0x58D4 , 0x89BB},
{ 0x58D6 , 0x89BC},
{ 0x58D7 , 0x89BD},
{ 0x58D8 , 0x89BE},
{ 0x58D9 , 0x89BF},
{ 0x58DA , 0x89C0},
{ 0x58DB , 0x89C1},
{ 0x58DC , 0x89C2},
{ 0x58DD , 0x89C3},
{ 0x58DE , 0x89C4},
{ 0x58DF , 0x89C5},
{ 0x58E0 , 0x89C6},
{ 0x58E1 , 0x89C7},
{ 0x58E2 , 0x89C8},
{ 0x58E3 , 0x89C9},
{ 0x58E5 , 0x89CA},
{ 0x58E6 , 0x89CB},
{ 0x58E7 , 0x89CC},
{ 0x58E8 , 0x89CD},
{ 0x58E9 , 0x89CE},
{ 0x58EA , 0x89CF},
{ 0x58ED , 0x89D0},
{ 0x58EF , 0x89D1},
{ 0x58F1 , 0x89D2},
{ 0x58F2 , 0x89D3},
{ 0x58F4 , 0x89D4},
{ 0x58F5 , 0x89D5},
{ 0x58F7 , 0x89D6},
{ 0x58F8 , 0x89D7},
{ 0x58FA , 0x89D8},
{ 0x58FB , 0x89D9},
{ 0x58FC , 0x89DA},
{ 0x58FD , 0x89DB},
{ 0x58FE , 0x89DC},
{ 0x58FF , 0x89DD},
{ 0x5900 , 0x89DE},
{ 0x5901 , 0x89DF},
{ 0x5903 , 0x89E0},
{ 0x5905 , 0x89E1},
{ 0x5906 , 0x89E2},
{ 0x5908 , 0x89E3},
{ 0x5909 , 0x89E4},
{ 0x590A , 0x89E5},
{ 0x590B , 0x89E6},
{ 0x590C , 0x89E7},
{ 0x590E , 0x89E8},
{ 0x5910 , 0x89E9},
{ 0x5911 , 0x89EA},
{ 0x5912 , 0x89EB},
{ 0x5913 , 0x89EC},
{ 0x5917 , 0x89ED},
{ 0x5918 , 0x89EE},
{ 0x591B , 0x89EF},
{ 0x591D , 0x89F0},
{ 0x591E , 0x89F1},
{ 0x5920 , 0x89F2},
{ 0x5921 , 0x89F3},
{ 0x5922 , 0x89F4},
{ 0x5923 , 0x89F5},
{ 0x5926 , 0x89F6},
{ 0x5928 , 0x89F7},
{ 0x592C , 0x89F8},
{ 0x5930 , 0x89F9},
{ 0x5932 , 0x89FA},
{ 0x5933 , 0x89FB},
{ 0x5935 , 0x89FC},
{ 0x5936 , 0x89FD},
{ 0x593B , 0x89FE},
{ 0x593D , 0x8A40},
{ 0x593E , 0x8A41},
{ 0x593F , 0x8A42},
{ 0x5940 , 0x8A43},
{ 0x5943 , 0x8A44},
{ 0x5945 , 0x8A45},
{ 0x5946 , 0x8A46},
{ 0x594A , 0x8A47},
{ 0x594C , 0x8A48},
{ 0x594D , 0x8A49},
{ 0x5950 , 0x8A4A},
{ 0x5952 , 0x8A4B},
{ 0x5953 , 0x8A4C},
{ 0x5959 , 0x8A4D},
{ 0x595B , 0x8A4E},
{ 0x595C , 0x8A4F},
{ 0x595D , 0x8A50},
{ 0x595E , 0x8A51},
{ 0x595F , 0x8A52},
{ 0x5961 , 0x8A53},
{ 0x5963 , 0x8A54},
{ 0x5964 , 0x8A55},
{ 0x5966 , 0x8A56},
{ 0x5967 , 0x8A57},
{ 0x5968 , 0x8A58},
{ 0x5969 , 0x8A59},
{ 0x596A , 0x8A5A},
{ 0x596B , 0x8A5B},
{ 0x596C , 0x8A5C},
{ 0x596D , 0x8A5D},
{ 0x596E , 0x8A5E},
{ 0x596F , 0x8A5F},
{ 0x5970 , 0x8A60},
{ 0x5971 , 0x8A61},
{ 0x5972 , 0x8A62},
{ 0x5975 , 0x8A63},
{ 0x5977 , 0x8A64},
{ 0x597A , 0x8A65},
{ 0x597B , 0x8A66},
{ 0x597C , 0x8A67},
{ 0x597E , 0x8A68},
{ 0x597F , 0x8A69},
{ 0x5980 , 0x8A6A},
{ 0x5985 , 0x8A6B},
{ 0x5989 , 0x8A6C},
{ 0x598B , 0x8A6D},
{ 0x598C , 0x8A6E},
{ 0x598E , 0x8A6F},
{ 0x598F , 0x8A70},
{ 0x5990 , 0x8A71},
{ 0x5991 , 0x8A72},
{ 0x5994 , 0x8A73},
{ 0x5995 , 0x8A74},
{ 0x5998 , 0x8A75},
{ 0x599A , 0x8A76},
{ 0x599B , 0x8A77},
{ 0x599C , 0x8A78},
{ 0x599D , 0x8A79},
{ 0x599F , 0x8A7A},
{ 0x59A0 , 0x8A7B},
{ 0x59A1 , 0x8A7C},
{ 0x59A2 , 0x8A7D},
{ 0x59A6 , 0x8A7E},
{ 0x59A7 , 0x8A80},
{ 0x59AC , 0x8A81},
{ 0x59AD , 0x8A82},
{ 0x59B0 , 0x8A83},
{ 0x59B1 , 0x8A84},
{ 0x59B3 , 0x8A85},
{ 0x59B4 , 0x8A86},
{ 0x59B5 , 0x8A87},
{ 0x59B6 , 0x8A88},
{ 0x59B7 , 0x8A89},
{ 0x59B8 , 0x8A8A},
{ 0x59BA , 0x8A8B},
{ 0x59BC , 0x8A8C},
{ 0x59BD , 0x8A8D},
{ 0x59BF , 0x8A8E},
{ 0x59C0 , 0x8A8F},
{ 0x59C1 , 0x8A90},
{ 0x59C2 , 0x8A91},
{ 0x59C3 , 0x8A92},
{ 0x59C4 , 0x8A93},
{ 0x59C5 , 0x8A94},
{ 0x59C7 , 0x8A95},
{ 0x59C8 , 0x8A96},
{ 0x59C9 , 0x8A97},
{ 0x59CC , 0x8A98},
{ 0x59CD , 0x8A99},
{ 0x59CE , 0x8A9A},
{ 0x59CF , 0x8A9B},
{ 0x59D5 , 0x8A9C},
{ 0x59D6 , 0x8A9D},
{ 0x59D9 , 0x8A9E},
{ 0x59DB , 0x8A9F},
{ 0x59DE , 0x8AA0},
{ 0x59DF , 0x8AA1},
{ 0x59E0 , 0x8AA2},
{ 0x59E1 , 0x8AA3},
{ 0x59E2 , 0x8AA4},
{ 0x59E4 , 0x8AA5},
{ 0x59E6 , 0x8AA6},
{ 0x59E7 , 0x8AA7},
{ 0x59E9 , 0x8AA8},
{ 0x59EA , 0x8AA9},
{ 0x59EB , 0x8AAA},
{ 0x59ED , 0x8AAB},
{ 0x59EE , 0x8AAC},
{ 0x59EF , 0x8AAD},
{ 0x59F0 , 0x8AAE},
{ 0x59F1 , 0x8AAF},
{ 0x59F2 , 0x8AB0},
{ 0x59F3 , 0x8AB1},
{ 0x59F4 , 0x8AB2},
{ 0x59F5 , 0x8AB3},
{ 0x59F6 , 0x8AB4},
{ 0x59F7 , 0x8AB5},
{ 0x59F8 , 0x8AB6},
{ 0x59FA , 0x8AB7},
{ 0x59FC , 0x8AB8},
{ 0x59FD , 0x8AB9},
{ 0x59FE , 0x8ABA},
{ 0x5A00 , 0x8ABB},
{ 0x5A02 , 0x8ABC},
{ 0x5A0A , 0x8ABD},
{ 0x5A0B , 0x8ABE},
{ 0x5A0D , 0x8ABF},
{ 0x5A0E , 0x8AC0},
{ 0x5A0F , 0x8AC1},
{ 0x5A10 , 0x8AC2},
{ 0x5A12 , 0x8AC3},
{ 0x5A14 , 0x8AC4},
{ 0x5A15 , 0x8AC5},
{ 0x5A16 , 0x8AC6},
{ 0x5A17 , 0x8AC7},
{ 0x5A19 , 0x8AC8},
{ 0x5A1A , 0x8AC9},
{ 0x5A1B , 0x8ACA},
{ 0x5A1D , 0x8ACB},
{ 0x5A1E , 0x8ACC},
{ 0x5A21 , 0x8ACD},
{ 0x5A22 , 0x8ACE},
{ 0x5A24 , 0x8ACF},
{ 0x5A26 , 0x8AD0},
{ 0x5A27 , 0x8AD1},
{ 0x5A28 , 0x8AD2},
{ 0x5A2A , 0x8AD3},
{ 0x5A2B , 0x8AD4},
{ 0x5A2C , 0x8AD5},
{ 0x5A2D , 0x8AD6},
{ 0x5A2E , 0x8AD7},
{ 0x5A2F , 0x8AD8},
{ 0x5A30 , 0x8AD9},
{ 0x5A33 , 0x8ADA},
{ 0x5A35 , 0x8ADB},
{ 0x5A37 , 0x8ADC},
{ 0x5A38 , 0x8ADD},
{ 0x5A39 , 0x8ADE},
{ 0x5A3A , 0x8ADF},
{ 0x5A3B , 0x8AE0},
{ 0x5A3D , 0x8AE1},
{ 0x5A3E , 0x8AE2},
{ 0x5A3F , 0x8AE3},
{ 0x5A41 , 0x8AE4},
{ 0x5A42 , 0x8AE5},
{ 0x5A43 , 0x8AE6},
{ 0x5A44 , 0x8AE7},
{ 0x5A45 , 0x8AE8},
{ 0x5A47 , 0x8AE9},
{ 0x5A48 , 0x8AEA},
{ 0x5A4B , 0x8AEB},
{ 0x5A4C , 0x8AEC},
{ 0x5A4D , 0x8AED},
{ 0x5A4E , 0x8AEE},
{ 0x5A4F , 0x8AEF},
{ 0x5A50 , 0x8AF0},
{ 0x5A51 , 0x8AF1},
{ 0x5A52 , 0x8AF2},
{ 0x5A53 , 0x8AF3},
{ 0x5A54 , 0x8AF4},
{ 0x5A56 , 0x8AF5},
{ 0x5A57 , 0x8AF6},
{ 0x5A58 , 0x8AF7},
{ 0x5A59 , 0x8AF8},
{ 0x5A5B , 0x8AF9},
{ 0x5A5C , 0x8AFA},
{ 0x5A5D , 0x8AFB},
{ 0x5A5E , 0x8AFC},
{ 0x5A5F , 0x8AFD},
{ 0x5A60 , 0x8AFE},
{ 0x5A61 , 0x8B40},
{ 0x5A63 , 0x8B41},
{ 0x5A64 , 0x8B42},
{ 0x5A65 , 0x8B43},
{ 0x5A66 , 0x8B44},
{ 0x5A68 , 0x8B45},
{ 0x5A69 , 0x8B46},
{ 0x5A6B , 0x8B47},
{ 0x5A6C , 0x8B48},
{ 0x5A6D , 0x8B49},
{ 0x5A6E , 0x8B4A},
{ 0x5A6F , 0x8B4B},
{ 0x5A70 , 0x8B4C},
{ 0x5A71 , 0x8B4D},
{ 0x5A72 , 0x8B4E},
{ 0x5A73 , 0x8B4F},
{ 0x5A78 , 0x8B50},
{ 0x5A79 , 0x8B51},
{ 0x5A7B , 0x8B52},
{ 0x5A7C , 0x8B53},
{ 0x5A7D , 0x8B54},
{ 0x5A7E , 0x8B55},
{ 0x5A80 , 0x8B56},
{ 0x5A81 , 0x8B57},
{ 0x5A82 , 0x8B58},
{ 0x5A83 , 0x8B59},
{ 0x5A84 , 0x8B5A},
{ 0x5A85 , 0x8B5B},
{ 0x5A86 , 0x8B5C},
{ 0x5A87 , 0x8B5D},
{ 0x5A88 , 0x8B5E},
{ 0x5A89 , 0x8B5F},
{ 0x5A8A , 0x8B60},
{ 0x5A8B , 0x8B61},
{ 0x5A8C , 0x8B62},
{ 0x5A8D , 0x8B63},
{ 0x5A8E , 0x8B64},
{ 0x5A8F , 0x8B65},
{ 0x5A90 , 0x8B66},
{ 0x5A91 , 0x8B67},
{ 0x5A93 , 0x8B68},
{ 0x5A94 , 0x8B69},
{ 0x5A95 , 0x8B6A},
{ 0x5A96 , 0x8B6B},
{ 0x5A97 , 0x8B6C},
{ 0x5A98 , 0x8B6D},
{ 0x5A99 , 0x8B6E},
{ 0x5A9C , 0x8B6F},
{ 0x5A9D , 0x8B70},
{ 0x5A9E , 0x8B71},
{ 0x5A9F , 0x8B72},
{ 0x5AA0 , 0x8B73},
{ 0x5AA1 , 0x8B74},
{ 0x5AA2 , 0x8B75},
{ 0x5AA3 , 0x8B76},
{ 0x5AA4 , 0x8B77},
{ 0x5AA5 , 0x8B78},
{ 0x5AA6 , 0x8B79},
{ 0x5AA7 , 0x8B7A},
{ 0x5AA8 , 0x8B7B},
{ 0x5AA9 , 0x8B7C},
{ 0x5AAB , 0x8B7D},
{ 0x5AAC , 0x8B7E},
{ 0x5AAD , 0x8B80},
{ 0x5AAE , 0x8B81},
{ 0x5AAF , 0x8B82},
{ 0x5AB0 , 0x8B83},
{ 0x5AB1 , 0x8B84},
{ 0x5AB4 , 0x8B85},
{ 0x5AB6 , 0x8B86},
{ 0x5AB7 , 0x8B87},
{ 0x5AB9 , 0x8B88},
{ 0x5ABA , 0x8B89},
{ 0x5ABB , 0x8B8A},
{ 0x5ABC , 0x8B8B},
{ 0x5ABD , 0x8B8C},
{ 0x5ABF , 0x8B8D},
{ 0x5AC0 , 0x8B8E},
{ 0x5AC3 , 0x8B8F},
{ 0x5AC4 , 0x8B90},
{ 0x5AC5 , 0x8B91},
{ 0x5AC6 , 0x8B92},
{ 0x5AC7 , 0x8B93},
{ 0x5AC8 , 0x8B94},
{ 0x5ACA , 0x8B95},
{ 0x5ACB , 0x8B96},
{ 0x5ACD , 0x8B97},
{ 0x5ACE , 0x8B98},
{ 0x5ACF , 0x8B99},
{ 0x5AD0 , 0x8B9A},
{ 0x5AD1 , 0x8B9B},
{ 0x5AD3 , 0x8B9C},
{ 0x5AD5 , 0x8B9D},
{ 0x5AD7 , 0x8B9E},
{ 0x5AD9 , 0x8B9F},
{ 0x5ADA , 0x8BA0},
{ 0x5ADB , 0x8BA1},
{ 0x5ADD , 0x8BA2},
{ 0x5ADE , 0x8BA3},
{ 0x5ADF , 0x8BA4},
{ 0x5AE2 , 0x8BA5},
{ 0x5AE4 , 0x8BA6},
{ 0x5AE5 , 0x8BA7},
{ 0x5AE7 , 0x8BA8},
{ 0x5AE8 , 0x8BA9},
{ 0x5AEA , 0x8BAA},
{ 0x5AEC , 0x8BAB},
{ 0x5AED , 0x8BAC},
{ 0x5AEE , 0x8BAD},
{ 0x5AEF , 0x8BAE},
{ 0x5AF0 , 0x8BAF},
{ 0x5AF2 , 0x8BB0},
{ 0x5AF3 , 0x8BB1},
{ 0x5AF4 , 0x8BB2},
{ 0x5AF5 , 0x8BB3},
{ 0x5AF6 , 0x8BB4},
{ 0x5AF7 , 0x8BB5},
{ 0x5AF8 , 0x8BB6},
{ 0x5AF9 , 0x8BB7},
{ 0x5AFA , 0x8BB8},
{ 0x5AFB , 0x8BB9},
{ 0x5AFC , 0x8BBA},
{ 0x5AFD , 0x8BBB},
{ 0x5AFE , 0x8BBC},
{ 0x5AFF , 0x8BBD},
{ 0x5B00 , 0x8BBE},
{ 0x5B01 , 0x8BBF},
{ 0x5B02 , 0x8BC0},
{ 0x5B03 , 0x8BC1},
{ 0x5B04 , 0x8BC2},
{ 0x5B05 , 0x8BC3},
{ 0x5B06 , 0x8BC4},
{ 0x5B07 , 0x8BC5},
{ 0x5B08 , 0x8BC6},
{ 0x5B0A , 0x8BC7},
{ 0x5B0B , 0x8BC8},
{ 0x5B0C , 0x8BC9},
{ 0x5B0D , 0x8BCA},
{ 0x5B0E , 0x8BCB},
{ 0x5B0F , 0x8BCC},
{ 0x5B10 , 0x8BCD},
{ 0x5B11 , 0x8BCE},
{ 0x5B12 , 0x8BCF},
{ 0x5B13 , 0x8BD0},
{ 0x5B14 , 0x8BD1},
{ 0x5B15 , 0x8BD2},
{ 0x5B18 , 0x8BD3},
{ 0x5B19 , 0x8BD4},
{ 0x5B1A , 0x8BD5},
{ 0x5B1B , 0x8BD6},
{ 0x5B1C , 0x8BD7},
{ 0x5B1D , 0x8BD8},
{ 0x5B1E , 0x8BD9},
{ 0x5B1F , 0x8BDA},
{ 0x5B20 , 0x8BDB},
{ 0x5B21 , 0x8BDC},
{ 0x5B22 , 0x8BDD},
{ 0x5B23 , 0x8BDE},
{ 0x5B24 , 0x8BDF},
{ 0x5B25 , 0x8BE0},
{ 0x5B26 , 0x8BE1},
{ 0x5B27 , 0x8BE2},
{ 0x5B28 , 0x8BE3},
{ 0x5B29 , 0x8BE4},
{ 0x5B2A , 0x8BE5},
{ 0x5B2B , 0x8BE6},
{ 0x5B2C , 0x8BE7},
{ 0x5B2D , 0x8BE8},
{ 0x5B2E , 0x8BE9},
{ 0x5B2F , 0x8BEA},
{ 0x5B30 , 0x8BEB},
{ 0x5B31 , 0x8BEC},
{ 0x5B33 , 0x8BED},
{ 0x5B35 , 0x8BEE},
{ 0x5B36 , 0x8BEF},
{ 0x5B38 , 0x8BF0},
{ 0x5B39 , 0x8BF1},
{ 0x5B3A , 0x8BF2},
{ 0x5B3B , 0x8BF3},
{ 0x5B3C , 0x8BF4},
{ 0x5B3D , 0x8BF5},
{ 0x5B3E , 0x8BF6},
{ 0x5B3F , 0x8BF7},
{ 0x5B41 , 0x8BF8},
{ 0x5B42 , 0x8BF9},
{ 0x5B43 , 0x8BFA},
{ 0x5B44 , 0x8BFB},
{ 0x5B45 , 0x8BFC},
{ 0x5B46 , 0x8BFD},
{ 0x5B47 , 0x8BFE},
{ 0x5B48 , 0x8C40},
{ 0x5B49 , 0x8C41},
{ 0x5B4A , 0x8C42},
{ 0x5B4B , 0x8C43},
{ 0x5B4C , 0x8C44},
{ 0x5B4D , 0x8C45},
{ 0x5B4E , 0x8C46},
{ 0x5B4F , 0x8C47},
{ 0x5B52 , 0x8C48},
{ 0x5B56 , 0x8C49},
{ 0x5B5E , 0x8C4A},
{ 0x5B60 , 0x8C4B},
{ 0x5B61 , 0x8C4C},
{ 0x5B67 , 0x8C4D},
{ 0x5B68 , 0x8C4E},
{ 0x5B6B , 0x8C4F},
{ 0x5B6D , 0x8C50},
{ 0x5B6E , 0x8C51},
{ 0x5B6F , 0x8C52},
{ 0x5B72 , 0x8C53},
{ 0x5B74 , 0x8C54},
{ 0x5B76 , 0x8C55},
{ 0x5B77 , 0x8C56},
{ 0x5B78 , 0x8C57},
{ 0x5B79 , 0x8C58},
{ 0x5B7B , 0x8C59},
{ 0x5B7C , 0x8C5A},
{ 0x5B7E , 0x8C5B},
{ 0x5B7F , 0x8C5C},
{ 0x5B82 , 0x8C5D},
{ 0x5B86 , 0x8C5E},
{ 0x5B8A , 0x8C5F},
{ 0x5B8D , 0x8C60},
{ 0x5B8E , 0x8C61},
{ 0x5B90 , 0x8C62},
{ 0x5B91 , 0x8C63},
{ 0x5B92 , 0x8C64},
{ 0x5B94 , 0x8C65},
{ 0x5B96 , 0x8C66},
{ 0x5B9F , 0x8C67},
{ 0x5BA7 , 0x8C68},
{ 0x5BA8 , 0x8C69},
{ 0x5BA9 , 0x8C6A},
{ 0x5BAC , 0x8C6B},
{ 0x5BAD , 0x8C6C},
{ 0x5BAE , 0x8C6D},
{ 0x5BAF , 0x8C6E},
{ 0x5BB1 , 0x8C6F},
{ 0x5BB2 , 0x8C70},
{ 0x5BB7 , 0x8C71},
{ 0x5BBA , 0x8C72},
{ 0x5BBB , 0x8C73},
{ 0x5BBC , 0x8C74},
{ 0x5BC0 , 0x8C75},
{ 0x5BC1 , 0x8C76},
{ 0x5BC3 , 0x8C77},
{ 0x5BC8 , 0x8C78},
{ 0x5BC9 , 0x8C79},
{ 0x5BCA , 0x8C7A},
{ 0x5BCB , 0x8C7B},
{ 0x5BCD , 0x8C7C},
{ 0x5BCE , 0x8C7D},
{ 0x5BCF , 0x8C7E},
{ 0x5BD1 , 0x8C80},
{ 0x5BD4 , 0x8C81},
{ 0x5BD5 , 0x8C82},
{ 0x5BD6 , 0x8C83},
{ 0x5BD7 , 0x8C84},
{ 0x5BD8 , 0x8C85},
{ 0x5BD9 , 0x8C86},
{ 0x5BDA , 0x8C87},
{ 0x5BDB , 0x8C88},
{ 0x5BDC , 0x8C89},
{ 0x5BE0 , 0x8C8A},
{ 0x5BE2 , 0x8C8B},
{ 0x5BE3 , 0x8C8C},
{ 0x5BE6 , 0x8C8D},
{ 0x5BE7 , 0x8C8E},
{ 0x5BE9 , 0x8C8F},
{ 0x5BEA , 0x8C90},
{ 0x5BEB , 0x8C91},
{ 0x5BEC , 0x8C92},
{ 0x5BED , 0x8C93},
{ 0x5BEF , 0x8C94},
{ 0x5BF1 , 0x8C95},
{ 0x5BF2 , 0x8C96},
{ 0x5BF3 , 0x8C97},
{ 0x5BF4 , 0x8C98},
{ 0x5BF5 , 0x8C99},
{ 0x5BF6 , 0x8C9A},
{ 0x5BF7 , 0x8C9B},
{ 0x5BFD , 0x8C9C},
{ 0x5BFE , 0x8C9D},
{ 0x5C00 , 0x8C9E},
{ 0x5C02 , 0x8C9F},
{ 0x5C03 , 0x8CA0},
{ 0x5C05 , 0x8CA1},
{ 0x5C07 , 0x8CA2},
{ 0x5C08 , 0x8CA3},
{ 0x5C0B , 0x8CA4},
{ 0x5C0C , 0x8CA5},
{ 0x5C0D , 0x8CA6},
{ 0x5C0E , 0x8CA7},
{ 0x5C10 , 0x8CA8},
{ 0x5C12 , 0x8CA9},
{ 0x5C13 , 0x8CAA},
{ 0x5C17 , 0x8CAB},
{ 0x5C19 , 0x8CAC},
{ 0x5C1B , 0x8CAD},
{ 0x5C1E , 0x8CAE},
{ 0x5C1F , 0x8CAF},
{ 0x5C20 , 0x8CB0},
{ 0x5C21 , 0x8CB1},
{ 0x5C23 , 0x8CB2},
{ 0x5C26 , 0x8CB3},
{ 0x5C28 , 0x8CB4},
{ 0x5C29 , 0x8CB5},
{ 0x5C2A , 0x8CB6},
{ 0x5C2B , 0x8CB7},
{ 0x5C2D , 0x8CB8},
{ 0x5C2E , 0x8CB9},
{ 0x5C2F , 0x8CBA},
{ 0x5C30 , 0x8CBB},
{ 0x5C32 , 0x8CBC},
{ 0x5C33 , 0x8CBD},
{ 0x5C35 , 0x8CBE},
{ 0x5C36 , 0x8CBF},
{ 0x5C37 , 0x8CC0},
{ 0x5C43 , 0x8CC1},
{ 0x5C44 , 0x8CC2},
{ 0x5C46 , 0x8CC3},
{ 0x5C47 , 0x8CC4},
{ 0x5C4C , 0x8CC5},
{ 0x5C4D , 0x8CC6},
{ 0x5C52 , 0x8CC7},
{ 0x5C53 , 0x8CC8},
{ 0x5C54 , 0x8CC9},
{ 0x5C56 , 0x8CCA},
{ 0x5C57 , 0x8CCB},
{ 0x5C58 , 0x8CCC},
{ 0x5C5A , 0x8CCD},
{ 0x5C5B , 0x8CCE},
{ 0x5C5C , 0x8CCF},
{ 0x5C5D , 0x8CD0},
{ 0x5C5F , 0x8CD1},
{ 0x5C62 , 0x8CD2},
{ 0x5C64 , 0x8CD3},
{ 0x5C67 , 0x8CD4},
{ 0x5C68 , 0x8CD5},
{ 0x5C69 , 0x8CD6},
{ 0x5C6A , 0x8CD7},
{ 0x5C6B , 0x8CD8},
{ 0x5C6C , 0x8CD9},
{ 0x5C6D , 0x8CDA},
{ 0x5C70 , 0x8CDB},
{ 0x5C72 , 0x8CDC},
{ 0x5C73 , 0x8CDD},
{ 0x5C74 , 0x8CDE},
{ 0x5C75 , 0x8CDF},
{ 0x5C76 , 0x8CE0},
{ 0x5C77 , 0x8CE1},
{ 0x5C78 , 0x8CE2},
{ 0x5C7B , 0x8CE3},
{ 0x5C7C , 0x8CE4},
{ 0x5C7D , 0x8CE5},
{ 0x5C7E , 0x8CE6},
{ 0x5C80 , 0x8CE7},
{ 0x5C83 , 0x8CE8},
{ 0x5C84 , 0x8CE9},
{ 0x5C85 , 0x8CEA},
{ 0x5C86 , 0x8CEB},
{ 0x5C87 , 0x8CEC},
{ 0x5C89 , 0x8CED},
{ 0x5C8A , 0x8CEE},
{ 0x5C8B , 0x8CEF},
{ 0x5C8E , 0x8CF0},
{ 0x5C8F , 0x8CF1},
{ 0x5C92 , 0x8CF2},
{ 0x5C93 , 0x8CF3},
{ 0x5C95 , 0x8CF4},
{ 0x5C9D , 0x8CF5},
{ 0x5C9E , 0x8CF6},
{ 0x5C9F , 0x8CF7},
{ 0x5CA0 , 0x8CF8},
{ 0x5CA1 , 0x8CF9},
{ 0x5CA4 , 0x8CFA},
{ 0x5CA5 , 0x8CFB},
{ 0x5CA6 , 0x8CFC},
{ 0x5CA7 , 0x8CFD},
{ 0x5CA8 , 0x8CFE},
{ 0x5CAA , 0x8D40},
{ 0x5CAE , 0x8D41},
{ 0x5CAF , 0x8D42},
{ 0x5CB0 , 0x8D43},
{ 0x5CB2 , 0x8D44},
{ 0x5CB4 , 0x8D45},
{ 0x5CB6 , 0x8D46},
{ 0x5CB9 , 0x8D47},
{ 0x5CBA , 0x8D48},
{ 0x5CBB , 0x8D49},
{ 0x5CBC , 0x8D4A},
{ 0x5CBE , 0x8D4B},
{ 0x5CC0 , 0x8D4C},
{ 0x5CC2 , 0x8D4D},
{ 0x5CC3 , 0x8D4E},
{ 0x5CC5 , 0x8D4F},
{ 0x5CC6 , 0x8D50},
{ 0x5CC7 , 0x8D51},
{ 0x5CC8 , 0x8D52},
{ 0x5CC9 , 0x8D53},
{ 0x5CCA , 0x8D54},
{ 0x5CCC , 0x8D55},
{ 0x5CCD , 0x8D56},
{ 0x5CCE , 0x8D57},
{ 0x5CCF , 0x8D58},
{ 0x5CD0 , 0x8D59},
{ 0x5CD1 , 0x8D5A},
{ 0x5CD3 , 0x8D5B},
{ 0x5CD4 , 0x8D5C},
{ 0x5CD5 , 0x8D5D},
{ 0x5CD6 , 0x8D5E},
{ 0x5CD7 , 0x8D5F},
{ 0x5CD8 , 0x8D60},
{ 0x5CDA , 0x8D61},
{ 0x5CDB , 0x8D62},
{ 0x5CDC , 0x8D63},
{ 0x5CDD , 0x8D64},
{ 0x5CDE , 0x8D65},
{ 0x5CDF , 0x8D66},
{ 0x5CE0 , 0x8D67},
{ 0x5CE2 , 0x8D68},
{ 0x5CE3 , 0x8D69},
{ 0x5CE7 , 0x8D6A},
{ 0x5CE9 , 0x8D6B},
{ 0x5CEB , 0x8D6C},
{ 0x5CEC , 0x8D6D},
{ 0x5CEE , 0x8D6E},
{ 0x5CEF , 0x8D6F},
{ 0x5CF1 , 0x8D70},
{ 0x5CF2 , 0x8D71},
{ 0x5CF3 , 0x8D72},
{ 0x5CF4 , 0x8D73},
{ 0x5CF5 , 0x8D74},
{ 0x5CF6 , 0x8D75},
{ 0x5CF7 , 0x8D76},
{ 0x5CF8 , 0x8D77},
{ 0x5CF9 , 0x8D78},
{ 0x5CFA , 0x8D79},
{ 0x5CFC , 0x8D7A},
{ 0x5CFD , 0x8D7B},
{ 0x5CFE , 0x8D7C},
{ 0x5CFF , 0x8D7D},
{ 0x5D00 , 0x8D7E},
{ 0x5D01 , 0x8D80},
{ 0x5D04 , 0x8D81},
{ 0x5D05 , 0x8D82},
{ 0x5D08 , 0x8D83},
{ 0x5D09 , 0x8D84},
{ 0x5D0A , 0x8D85},
{ 0x5D0B , 0x8D86},
{ 0x5D0C , 0x8D87},
{ 0x5D0D , 0x8D88},
{ 0x5D0F , 0x8D89},
{ 0x5D10 , 0x8D8A},
{ 0x5D11 , 0x8D8B},
{ 0x5D12 , 0x8D8C},
{ 0x5D13 , 0x8D8D},
{ 0x5D15 , 0x8D8E},
{ 0x5D17 , 0x8D8F},
{ 0x5D18 , 0x8D90},
{ 0x5D19 , 0x8D91},
{ 0x5D1A , 0x8D92},
{ 0x5D1C , 0x8D93},
{ 0x5D1D , 0x8D94},
{ 0x5D1F , 0x8D95},
{ 0x5D20 , 0x8D96},
{ 0x5D21 , 0x8D97},
{ 0x5D22 , 0x8D98},
{ 0x5D23 , 0x8D99},
{ 0x5D25 , 0x8D9A},
{ 0x5D28 , 0x8D9B},
{ 0x5D2A , 0x8D9C},
{ 0x5D2B , 0x8D9D},
{ 0x5D2C , 0x8D9E},
{ 0x5D2F , 0x8D9F},
{ 0x5D30 , 0x8DA0},
{ 0x5D31 , 0x8DA1},
{ 0x5D32 , 0x8DA2},
{ 0x5D33 , 0x8DA3},
{ 0x5D35 , 0x8DA4},
{ 0x5D36 , 0x8DA5},
{ 0x5D37 , 0x8DA6},
{ 0x5D38 , 0x8DA7},
{ 0x5D39 , 0x8DA8},
{ 0x5D3A , 0x8DA9},
{ 0x5D3B , 0x8DAA},
{ 0x5D3C , 0x8DAB},
{ 0x5D3F , 0x8DAC},
{ 0x5D40 , 0x8DAD},
{ 0x5D41 , 0x8DAE},
{ 0x5D42 , 0x8DAF},
{ 0x5D43 , 0x8DB0},
{ 0x5D44 , 0x8DB1},
{ 0x5D45 , 0x8DB2},
{ 0x5D46 , 0x8DB3},
{ 0x5D48 , 0x8DB4},
{ 0x5D49 , 0x8DB5},
{ 0x5D4D , 0x8DB6},
{ 0x5D4E , 0x8DB7},
{ 0x5D4F , 0x8DB8},
{ 0x5D50 , 0x8DB9},
{ 0x5D51 , 0x8DBA},
{ 0x5D52 , 0x8DBB},
{ 0x5D53 , 0x8DBC},
{ 0x5D54 , 0x8DBD},
{ 0x5D55 , 0x8DBE},
{ 0x5D56 , 0x8DBF},
{ 0x5D57 , 0x8DC0},
{ 0x5D59 , 0x8DC1},
{ 0x5D5A , 0x8DC2},
{ 0x5D5C , 0x8DC3},
{ 0x5D5E , 0x8DC4},
{ 0x5D5F , 0x8DC5},
{ 0x5D60 , 0x8DC6},
{ 0x5D61 , 0x8DC7},
{ 0x5D62 , 0x8DC8},
{ 0x5D63 , 0x8DC9},
{ 0x5D64 , 0x8DCA},
{ 0x5D65 , 0x8DCB},
{ 0x5D66 , 0x8DCC},
{ 0x5D67 , 0x8DCD},
{ 0x5D68 , 0x8DCE},
{ 0x5D6A , 0x8DCF},
{ 0x5D6D , 0x8DD0},
{ 0x5D6E , 0x8DD1},
{ 0x5D70 , 0x8DD2},
{ 0x5D71 , 0x8DD3},
{ 0x5D72 , 0x8DD4},
{ 0x5D73 , 0x8DD5},
{ 0x5D75 , 0x8DD6},
{ 0x5D76 , 0x8DD7},
{ 0x5D77 , 0x8DD8},
{ 0x5D78 , 0x8DD9},
{ 0x5D79 , 0x8DDA},
{ 0x5D7A , 0x8DDB},
{ 0x5D7B , 0x8DDC},
{ 0x5D7C , 0x8DDD},
{ 0x5D7D , 0x8DDE},
{ 0x5D7E , 0x8DDF},
{ 0x5D7F , 0x8DE0},
{ 0x5D80 , 0x8DE1},
{ 0x5D81 , 0x8DE2},
{ 0x5D83 , 0x8DE3},
{ 0x5D84 , 0x8DE4},
{ 0x5D85 , 0x8DE5},
{ 0x5D86 , 0x8DE6},
{ 0x5D87 , 0x8DE7},
{ 0x5D88 , 0x8DE8},
{ 0x5D89 , 0x8DE9},
{ 0x5D8A , 0x8DEA},
{ 0x5D8B , 0x8DEB},
{ 0x5D8C , 0x8DEC},
{ 0x5D8D , 0x8DED},
{ 0x5D8E , 0x8DEE},
{ 0x5D8F , 0x8DEF},
{ 0x5D90 , 0x8DF0},
{ 0x5D91 , 0x8DF1},
{ 0x5D92 , 0x8DF2},
{ 0x5D93 , 0x8DF3},
{ 0x5D94 , 0x8DF4},
{ 0x5D95 , 0x8DF5},
{ 0x5D96 , 0x8DF6},
{ 0x5D97 , 0x8DF7},
{ 0x5D98 , 0x8DF8},
{ 0x5D9A , 0x8DF9},
{ 0x5D9B , 0x8DFA},
{ 0x5D9C , 0x8DFB},
{ 0x5D9E , 0x8DFC},
{ 0x5D9F , 0x8DFD},
{ 0x5DA0 , 0x8DFE},
{ 0x5DA1 , 0x8E40},
{ 0x5DA2 , 0x8E41},
{ 0x5DA3 , 0x8E42},
{ 0x5DA4 , 0x8E43},
{ 0x5DA5 , 0x8E44},
{ 0x5DA6 , 0x8E45},
{ 0x5DA7 , 0x8E46},
{ 0x5DA8 , 0x8E47},
{ 0x5DA9 , 0x8E48},
{ 0x5DAA , 0x8E49},
{ 0x5DAB , 0x8E4A},
{ 0x5DAC , 0x8E4B},
{ 0x5DAD , 0x8E4C},
{ 0x5DAE , 0x8E4D},
{ 0x5DAF , 0x8E4E},
{ 0x5DB0 , 0x8E4F},
{ 0x5DB1 , 0x8E50},
{ 0x5DB2 , 0x8E51},
{ 0x5DB3 , 0x8E52},
{ 0x5DB4 , 0x8E53},
{ 0x5DB5 , 0x8E54},
{ 0x5DB6 , 0x8E55},
{ 0x5DB8 , 0x8E56},
{ 0x5DB9 , 0x8E57},
{ 0x5DBA , 0x8E58},
{ 0x5DBB , 0x8E59},
{ 0x5DBC , 0x8E5A},
{ 0x5DBD , 0x8E5B},
{ 0x5DBE , 0x8E5C},
{ 0x5DBF , 0x8E5D},
{ 0x5DC0 , 0x8E5E},
{ 0x5DC1 , 0x8E5F},
{ 0x5DC2 , 0x8E60},
{ 0x5DC3 , 0x8E61},
{ 0x5DC4 , 0x8E62},
{ 0x5DC6 , 0x8E63},
{ 0x5DC7 , 0x8E64},
{ 0x5DC8 , 0x8E65},
{ 0x5DC9 , 0x8E66},
{ 0x5DCA , 0x8E67},
{ 0x5DCB , 0x8E68},
{ 0x5DCC , 0x8E69},
{ 0x5DCE , 0x8E6A},
{ 0x5DCF , 0x8E6B},
{ 0x5DD0 , 0x8E6C},
{ 0x5DD1 , 0x8E6D},
{ 0x5DD2 , 0x8E6E},
{ 0x5DD3 , 0x8E6F},
{ 0x5DD4 , 0x8E70},
{ 0x5DD5 , 0x8E71},
{ 0x5DD6 , 0x8E72},
{ 0x5DD7 , 0x8E73},
{ 0x5DD8 , 0x8E74},
{ 0x5DD9 , 0x8E75},
{ 0x5DDA , 0x8E76},
{ 0x5DDC , 0x8E77},
{ 0x5DDF , 0x8E78},
{ 0x5DE0 , 0x8E79},
{ 0x5DE3 , 0x8E7A},
{ 0x5DE4 , 0x8E7B},
{ 0x5DEA , 0x8E7C},
{ 0x5DEC , 0x8E7D},
{ 0x5DED , 0x8E7E},
{ 0x5DF0 , 0x8E80},
{ 0x5DF5 , 0x8E81},
{ 0x5DF6 , 0x8E82},
{ 0x5DF8 , 0x8E83},
{ 0x5DF9 , 0x8E84},
{ 0x5DFA , 0x8E85},
{ 0x5DFB , 0x8E86},
{ 0x5DFC , 0x8E87},
{ 0x5DFF , 0x8E88},
{ 0x5E00 , 0x8E89},
{ 0x5E04 , 0x8E8A},
{ 0x5E07 , 0x8E8B},
{ 0x5E09 , 0x8E8C},
{ 0x5E0A , 0x8E8D},
{ 0x5E0B , 0x8E8E},
{ 0x5E0D , 0x8E8F},
{ 0x5E0E , 0x8E90},
{ 0x5E12 , 0x8E91},
{ 0x5E13 , 0x8E92},
{ 0x5E17 , 0x8E93},
{ 0x5E1E , 0x8E94},
{ 0x5E1F , 0x8E95},
{ 0x5E20 , 0x8E96},
{ 0x5E21 , 0x8E97},
{ 0x5E22 , 0x8E98},
{ 0x5E23 , 0x8E99},
{ 0x5E24 , 0x8E9A},
{ 0x5E25 , 0x8E9B},
{ 0x5E28 , 0x8E9C},
{ 0x5E29 , 0x8E9D},
{ 0x5E2A , 0x8E9E},
{ 0x5E2B , 0x8E9F},
{ 0x5E2C , 0x8EA0},
{ 0x5E2F , 0x8EA1},
{ 0x5E30 , 0x8EA2},
{ 0x5E32 , 0x8EA3},
{ 0x5E33 , 0x8EA4},
{ 0x5E34 , 0x8EA5},
{ 0x5E35 , 0x8EA6},
{ 0x5E36 , 0x8EA7},
{ 0x5E39 , 0x8EA8},
{ 0x5E3A , 0x8EA9},
{ 0x5E3E , 0x8EAA},
{ 0x5E3F , 0x8EAB},
{ 0x5E40 , 0x8EAC},
{ 0x5E41 , 0x8EAD},
{ 0x5E43 , 0x8EAE},
{ 0x5E46 , 0x8EAF},
{ 0x5E47 , 0x8EB0},
{ 0x5E48 , 0x8EB1},
{ 0x5E49 , 0x8EB2},
{ 0x5E4A , 0x8EB3},
{ 0x5E4B , 0x8EB4},
{ 0x5E4D , 0x8EB5},
{ 0x5E4E , 0x8EB6},
{ 0x5E4F , 0x8EB7},
{ 0x5E50 , 0x8EB8},
{ 0x5E51 , 0x8EB9},
{ 0x5E52 , 0x8EBA},
{ 0x5E53 , 0x8EBB},
{ 0x5E56 , 0x8EBC},
{ 0x5E57 , 0x8EBD},
{ 0x5E58 , 0x8EBE},
{ 0x5E59 , 0x8EBF},
{ 0x5E5A , 0x8EC0},
{ 0x5E5C , 0x8EC1},
{ 0x5E5D , 0x8EC2},
{ 0x5E5F , 0x8EC3},
{ 0x5E60 , 0x8EC4},
{ 0x5E63 , 0x8EC5},
{ 0x5E64 , 0x8EC6},
{ 0x5E65 , 0x8EC7},
{ 0x5E66 , 0x8EC8},
{ 0x5E67 , 0x8EC9},
{ 0x5E68 , 0x8ECA},
{ 0x5E69 , 0x8ECB},
{ 0x5E6A , 0x8ECC},
{ 0x5E6B , 0x8ECD},
{ 0x5E6C , 0x8ECE},
{ 0x5E6D , 0x8ECF},
{ 0x5E6E , 0x8ED0},
{ 0x5E6F , 0x8ED1},
{ 0x5E70 , 0x8ED2},
{ 0x5E71 , 0x8ED3},
{ 0x5E75 , 0x8ED4},
{ 0x5E77 , 0x8ED5},
{ 0x5E79 , 0x8ED6},
{ 0x5E7E , 0x8ED7},
{ 0x5E81 , 0x8ED8},
{ 0x5E82 , 0x8ED9},
{ 0x5E83 , 0x8EDA},
{ 0x5E85 , 0x8EDB},
{ 0x5E88 , 0x8EDC},
{ 0x5E89 , 0x8EDD},
{ 0x5E8C , 0x8EDE},
{ 0x5E8D , 0x8EDF},
{ 0x5E8E , 0x8EE0},
{ 0x5E92 , 0x8EE1},
{ 0x5E98 , 0x8EE2},
{ 0x5E9B , 0x8EE3},
{ 0x5E9D , 0x8EE4},
{ 0x5EA1 , 0x8EE5},
{ 0x5EA2 , 0x8EE6},
{ 0x5EA3 , 0x8EE7},
{ 0x5EA4 , 0x8EE8},
{ 0x5EA8 , 0x8EE9},
{ 0x5EA9 , 0x8EEA},
{ 0x5EAA , 0x8EEB},
{ 0x5EAB , 0x8EEC},
{ 0x5EAC , 0x8EED},
{ 0x5EAE , 0x8EEE},
{ 0x5EAF , 0x8EEF},
{ 0x5EB0 , 0x8EF0},
{ 0x5EB1 , 0x8EF1},
{ 0x5EB2 , 0x8EF2},
{ 0x5EB4 , 0x8EF3},
{ 0x5EBA , 0x8EF4},
{ 0x5EBB , 0x8EF5},
{ 0x5EBC , 0x8EF6},
{ 0x5EBD , 0x8EF7},
{ 0x5EBF , 0x8EF8},
{ 0x5EC0 , 0x8EF9},
{ 0x5EC1 , 0x8EFA},
{ 0x5EC2 , 0x8EFB},
{ 0x5EC3 , 0x8EFC},
{ 0x5EC4 , 0x8EFD},
{ 0x5EC5 , 0x8EFE},
{ 0x5EC6 , 0x8F40},
{ 0x5EC7 , 0x8F41},
{ 0x5EC8 , 0x8F42},
{ 0x5ECB , 0x8F43},
{ 0x5ECC , 0x8F44},
{ 0x5ECD , 0x8F45},
{ 0x5ECE , 0x8F46},
{ 0x5ECF , 0x8F47},
{ 0x5ED0 , 0x8F48},
{ 0x5ED4 , 0x8F49},
{ 0x5ED5 , 0x8F4A},
{ 0x5ED7 , 0x8F4B},
{ 0x5ED8 , 0x8F4C},
{ 0x5ED9 , 0x8F4D},
{ 0x5EDA , 0x8F4E},
{ 0x5EDC , 0x8F4F},
{ 0x5EDD , 0x8F50},
{ 0x5EDE , 0x8F51},
{ 0x5EDF , 0x8F52},
{ 0x5EE0 , 0x8F53},
{ 0x5EE1 , 0x8F54},
{ 0x5EE2 , 0x8F55},
{ 0x5EE3 , 0x8F56},
{ 0x5EE4 , 0x8F57},
{ 0x5EE5 , 0x8F58},
{ 0x5EE6 , 0x8F59},
{ 0x5EE7 , 0x8F5A},
{ 0x5EE9 , 0x8F5B},
{ 0x5EEB , 0x8F5C},
{ 0x5EEC , 0x8F5D},
{ 0x5EED , 0x8F5E},
{ 0x5EEE , 0x8F5F},
{ 0x5EEF , 0x8F60},
{ 0x5EF0 , 0x8F61},
{ 0x5EF1 , 0x8F62},
{ 0x5EF2 , 0x8F63},
{ 0x5EF3 , 0x8F64},
{ 0x5EF5 , 0x8F65},
{ 0x5EF8 , 0x8F66},
{ 0x5EF9 , 0x8F67},
{ 0x5EFB , 0x8F68},
{ 0x5EFC , 0x8F69},
{ 0x5EFD , 0x8F6A},
{ 0x5F05 , 0x8F6B},
{ 0x5F06 , 0x8F6C},
{ 0x5F07 , 0x8F6D},
{ 0x5F09 , 0x8F6E},
{ 0x5F0C , 0x8F6F},
{ 0x5F0D , 0x8F70},
{ 0x5F0E , 0x8F71},
{ 0x5F10 , 0x8F72},
{ 0x5F12 , 0x8F73},
{ 0x5F14 , 0x8F74},
{ 0x5F16 , 0x8F75},
{ 0x5F19 , 0x8F76},
{ 0x5F1A , 0x8F77},
{ 0x5F1C , 0x8F78},
{ 0x5F1D , 0x8F79},
{ 0x5F1E , 0x8F7A},
{ 0x5F21 , 0x8F7B},
{ 0x5F22 , 0x8F7C},
{ 0x5F23 , 0x8F7D},
{ 0x5F24 , 0x8F7E},
{ 0x5F28 , 0x8F80},
{ 0x5F2B , 0x8F81},
{ 0x5F2C , 0x8F82},
{ 0x5F2E , 0x8F83},
{ 0x5F30 , 0x8F84},
{ 0x5F32 , 0x8F85},
{ 0x5F33 , 0x8F86},
{ 0x5F34 , 0x8F87},
{ 0x5F35 , 0x8F88},
{ 0x5F36 , 0x8F89},
{ 0x5F37 , 0x8F8A},
{ 0x5F38 , 0x8F8B},
{ 0x5F3B , 0x8F8C},
{ 0x5F3D , 0x8F8D},
{ 0x5F3E , 0x8F8E},
{ 0x5F3F , 0x8F8F},
{ 0x5F41 , 0x8F90},
{ 0x5F42 , 0x8F91},
{ 0x5F43 , 0x8F92},
{ 0x5F44 , 0x8F93},
{ 0x5F45 , 0x8F94},
{ 0x5F46 , 0x8F95},
{ 0x5F47 , 0x8F96},
{ 0x5F48 , 0x8F97},
{ 0x5F49 , 0x8F98},
{ 0x5F4A , 0x8F99},
{ 0x5F4B , 0x8F9A},
{ 0x5F4C , 0x8F9B},
{ 0x5F4D , 0x8F9C},
{ 0x5F4E , 0x8F9D},
{ 0x5F4F , 0x8F9E},
{ 0x5F51 , 0x8F9F},
{ 0x5F54 , 0x8FA0},
{ 0x5F59 , 0x8FA1},
{ 0x5F5A , 0x8FA2},
{ 0x5F5B , 0x8FA3},
{ 0x5F5C , 0x8FA4},
{ 0x5F5E , 0x8FA5},
{ 0x5F5F , 0x8FA6},
{ 0x5F60 , 0x8FA7},
{ 0x5F63 , 0x8FA8},
{ 0x5F65 , 0x8FA9},
{ 0x5F67 , 0x8FAA},
{ 0x5F68 , 0x8FAB},
{ 0x5F6B , 0x8FAC},
{ 0x5F6E , 0x8FAD},
{ 0x5F6F , 0x8FAE},
{ 0x5F72 , 0x8FAF},
{ 0x5F74 , 0x8FB0},
{ 0x5F75 , 0x8FB1},
{ 0x5F76 , 0x8FB2},
{ 0x5F78 , 0x8FB3},
{ 0x5F7A , 0x8FB4},
{ 0x5F7D , 0x8FB5},
{ 0x5F7E , 0x8FB6},
{ 0x5F7F , 0x8FB7},
{ 0x5F83 , 0x8FB8},
{ 0x5F86 , 0x8FB9},
{ 0x5F8D , 0x8FBA},
{ 0x5F8E , 0x8FBB},
{ 0x5F8F , 0x8FBC},
{ 0x5F91 , 0x8FBD},
{ 0x5F93 , 0x8FBE},
{ 0x5F94 , 0x8FBF},
{ 0x5F96 , 0x8FC0},
{ 0x5F9A , 0x8FC1},
{ 0x5F9B , 0x8FC2},
{ 0x5F9D , 0x8FC3},
{ 0x5F9E , 0x8FC4},
{ 0x5F9F , 0x8FC5},
{ 0x5FA0 , 0x8FC6},
{ 0x5FA2 , 0x8FC7},
{ 0x5FA3 , 0x8FC8},
{ 0x5FA4 , 0x8FC9},
{ 0x5FA5 , 0x8FCA},
{ 0x5FA6 , 0x8FCB},
{ 0x5FA7 , 0x8FCC},
{ 0x5FA9 , 0x8FCD},
{ 0x5FAB , 0x8FCE},
{ 0x5FAC , 0x8FCF},
{ 0x5FAF , 0x8FD0},
{ 0x5FB0 , 0x8FD1},
{ 0x5FB1 , 0x8FD2},
{ 0x5FB2 , 0x8FD3},
{ 0x5FB3 , 0x8FD4},
{ 0x5FB4 , 0x8FD5},
{ 0x5FB6 , 0x8FD6},
{ 0x5FB8 , 0x8FD7},
{ 0x5FB9 , 0x8FD8},
{ 0x5FBA , 0x8FD9},
{ 0x5FBB , 0x8FDA},
{ 0x5FBE , 0x8FDB},
{ 0x5FBF , 0x8FDC},
{ 0x5FC0 , 0x8FDD},
{ 0x5FC1 , 0x8FDE},
{ 0x5FC2 , 0x8FDF},
{ 0x5FC7 , 0x8FE0},
{ 0x5FC8 , 0x8FE1},
{ 0x5FCA , 0x8FE2},
{ 0x5FCB , 0x8FE3},
{ 0x5FCE , 0x8FE4},
{ 0x5FD3 , 0x8FE5},
{ 0x5FD4 , 0x8FE6},
{ 0x5FD5 , 0x8FE7},
{ 0x5FDA , 0x8FE8},
{ 0x5FDB , 0x8FE9},
{ 0x5FDC , 0x8FEA},
{ 0x5FDE , 0x8FEB},
{ 0x5FDF , 0x8FEC},
{ 0x5FE2 , 0x8FED},
{ 0x5FE3 , 0x8FEE},
{ 0x5FE5 , 0x8FEF},
{ 0x5FE6 , 0x8FF0},
{ 0x5FE8 , 0x8FF1},
{ 0x5FE9 , 0x8FF2},
{ 0x5FEC , 0x8FF3},
{ 0x5FEF , 0x8FF4},
{ 0x5FF0 , 0x8FF5},
{ 0x5FF2 , 0x8FF6},
{ 0x5FF3 , 0x8FF7},
{ 0x5FF4 , 0x8FF8},
{ 0x5FF6 , 0x8FF9},
{ 0x5FF7 , 0x8FFA},
{ 0x5FF9 , 0x8FFB},
{ 0x5FFA , 0x8FFC},
{ 0x5FFC , 0x8FFD},
{ 0x6007 , 0x8FFE},
{ 0x6008 , 0x9040},
{ 0x6009 , 0x9041},
{ 0x600B , 0x9042},
{ 0x600C , 0x9043},
{ 0x6010 , 0x9044},
{ 0x6011 , 0x9045},
{ 0x6013 , 0x9046},
{ 0x6017 , 0x9047},
{ 0x6018 , 0x9048},
{ 0x601A , 0x9049},
{ 0x601E , 0x904A},
{ 0x601F , 0x904B},
{ 0x6022 , 0x904C},
{ 0x6023 , 0x904D},
{ 0x6024 , 0x904E},
{ 0x602C , 0x904F},
{ 0x602D , 0x9050},
{ 0x602E , 0x9051},
{ 0x6030 , 0x9052},
{ 0x6031 , 0x9053},
{ 0x6032 , 0x9054},
{ 0x6033 , 0x9055},
{ 0x6034 , 0x9056},
{ 0x6036 , 0x9057},
{ 0x6037 , 0x9058},
{ 0x6038 , 0x9059},
{ 0x6039 , 0x905A},
{ 0x603A , 0x905B},
{ 0x603D , 0x905C},
{ 0x603E , 0x905D},
{ 0x6040 , 0x905E},
{ 0x6044 , 0x905F},
{ 0x6045 , 0x9060},
{ 0x6046 , 0x9061},
{ 0x6047 , 0x9062},
{ 0x6048 , 0x9063},
{ 0x6049 , 0x9064},
{ 0x604A , 0x9065},
{ 0x604C , 0x9066},
{ 0x604E , 0x9067},
{ 0x604F , 0x9068},
{ 0x6051 , 0x9069},
{ 0x6053 , 0x906A},
{ 0x6054 , 0x906B},
{ 0x6056 , 0x906C},
{ 0x6057 , 0x906D},
{ 0x6058 , 0x906E},
{ 0x605B , 0x906F},
{ 0x605C , 0x9070},
{ 0x605E , 0x9071},
{ 0x605F , 0x9072},
{ 0x6060 , 0x9073},
{ 0x6061 , 0x9074},
{ 0x6065 , 0x9075},
{ 0x6066 , 0x9076},
{ 0x606E , 0x9077},
{ 0x6071 , 0x9078},
{ 0x6072 , 0x9079},
{ 0x6074 , 0x907A},
{ 0x6075 , 0x907B},
{ 0x6077 , 0x907C},
{ 0x607E , 0x907D},
{ 0x6080 , 0x907E},
{ 0x6081 , 0x9080},
{ 0x6082 , 0x9081},
{ 0x6085 , 0x9082},
{ 0x6086 , 0x9083},
{ 0x6087 , 0x9084},
{ 0x6088 , 0x9085},
{ 0x608A , 0x9086},
{ 0x608B , 0x9087},
{ 0x608E , 0x9088},
{ 0x608F , 0x9089},
{ 0x6090 , 0x908A},
{ 0x6091 , 0x908B},
{ 0x6093 , 0x908C},
{ 0x6095 , 0x908D},
{ 0x6097 , 0x908E},
{ 0x6098 , 0x908F},
{ 0x6099 , 0x9090},
{ 0x609C , 0x9091},
{ 0x609E , 0x9092},
{ 0x60A1 , 0x9093},
{ 0x60A2 , 0x9094},
{ 0x60A4 , 0x9095},
{ 0x60A5 , 0x9096},
{ 0x60A7 , 0x9097},
{ 0x60A9 , 0x9098},
{ 0x60AA , 0x9099},
{ 0x60AE , 0x909A},
{ 0x60B0 , 0x909B},
{ 0x60B3 , 0x909C},
{ 0x60B5 , 0x909D},
{ 0x60B6 , 0x909E},
{ 0x60B7 , 0x909F},
{ 0x60B9 , 0x90A0},
{ 0x60BA , 0x90A1},
{ 0x60BD , 0x90A2},
{ 0x60BE , 0x90A3},
{ 0x60BF , 0x90A4},
{ 0x60C0 , 0x90A5},
{ 0x60C1 , 0x90A6},
{ 0x60C2 , 0x90A7},
{ 0x60C3 , 0x90A8},
{ 0x60C4 , 0x90A9},
{ 0x60C7 , 0x90AA},
{ 0x60C8 , 0x90AB},
{ 0x60C9 , 0x90AC},
{ 0x60CC , 0x90AD},
{ 0x60CD , 0x90AE},
{ 0x60CE , 0x90AF},
{ 0x60CF , 0x90B0},
{ 0x60D0 , 0x90B1},
{ 0x60D2 , 0x90B2},
{ 0x60D3 , 0x90B3},
{ 0x60D4 , 0x90B4},
{ 0x60D6 , 0x90B5},
{ 0x60D7 , 0x90B6},
{ 0x60D9 , 0x90B7},
{ 0x60DB , 0x90B8},
{ 0x60DE , 0x90B9},
{ 0x60E1 , 0x90BA},
{ 0x60E2 , 0x90BB},
{ 0x60E3 , 0x90BC},
{ 0x60E4 , 0x90BD},
{ 0x60E5 , 0x90BE},
{ 0x60EA , 0x90BF},
{ 0x60F1 , 0x90C0},
{ 0x60F2 , 0x90C1},
{ 0x60F5 , 0x90C2},
{ 0x60F7 , 0x90C3},
{ 0x60F8 , 0x90C4},
{ 0x60FB , 0x90C5},
{ 0x60FC , 0x90C6},
{ 0x60FD , 0x90C7},
{ 0x60FE , 0x90C8},
{ 0x60FF , 0x90C9},
{ 0x6102 , 0x90CA},
{ 0x6103 , 0x90CB},
{ 0x6104 , 0x90CC},
{ 0x6105 , 0x90CD},
{ 0x6107 , 0x90CE},
{ 0x610A , 0x90CF},
{ 0x610B , 0x90D0},
{ 0x610C , 0x90D1},
{ 0x6110 , 0x90D2},
{ 0x6111 , 0x90D3},
{ 0x6112 , 0x90D4},
{ 0x6113 , 0x90D5},
{ 0x6114 , 0x90D6},
{ 0x6116 , 0x90D7},
{ 0x6117 , 0x90D8},
{ 0x6118 , 0x90D9},
{ 0x6119 , 0x90DA},
{ 0x611B , 0x90DB},
{ 0x611C , 0x90DC},
{ 0x611D , 0x90DD},
{ 0x611E , 0x90DE},
{ 0x6121 , 0x90DF},
{ 0x6122 , 0x90E0},
{ 0x6125 , 0x90E1},
{ 0x6128 , 0x90E2},
{ 0x6129 , 0x90E3},
{ 0x612A , 0x90E4},
{ 0x612C , 0x90E5},
{ 0x612D , 0x90E6},
{ 0x612E , 0x90E7},
{ 0x612F , 0x90E8},
{ 0x6130 , 0x90E9},
{ 0x6131 , 0x90EA},
{ 0x6132 , 0x90EB},
{ 0x6133 , 0x90EC},
{ 0x6134 , 0x90ED},
{ 0x6135 , 0x90EE},
{ 0x6136 , 0x90EF},
{ 0x6137 , 0x90F0},
{ 0x6138 , 0x90F1},
{ 0x6139 , 0x90F2},
{ 0x613A , 0x90F3},
{ 0x613B , 0x90F4},
{ 0x613C , 0x90F5},
{ 0x613D , 0x90F6},
{ 0x613E , 0x90F7},
{ 0x6140 , 0x90F8},
{ 0x6141 , 0x90F9},
{ 0x6142 , 0x90FA},
{ 0x6143 , 0x90FB},
{ 0x6144 , 0x90FC},
{ 0x6145 , 0x90FD},
{ 0x6146 , 0x90FE},
{ 0x6147 , 0x9140},
{ 0x6149 , 0x9141},
{ 0x614B , 0x9142},
{ 0x614D , 0x9143},
{ 0x614F , 0x9144},
{ 0x6150 , 0x9145},
{ 0x6152 , 0x9146},
{ 0x6153 , 0x9147},
{ 0x6154 , 0x9148},
{ 0x6156 , 0x9149},
{ 0x6157 , 0x914A},
{ 0x6158 , 0x914B},
{ 0x6159 , 0x914C},
{ 0x615A , 0x914D},
{ 0x615B , 0x914E},
{ 0x615C , 0x914F},
{ 0x615E , 0x9150},
{ 0x615F , 0x9151},
{ 0x6160 , 0x9152},
{ 0x6161 , 0x9153},
{ 0x6163 , 0x9154},
{ 0x6164 , 0x9155},
{ 0x6165 , 0x9156},
{ 0x6166 , 0x9157},
{ 0x6169 , 0x9158},
{ 0x616A , 0x9159},
{ 0x616B , 0x915A},
{ 0x616C , 0x915B},
{ 0x616D , 0x915C},
{ 0x616E , 0x915D},
{ 0x616F , 0x915E},
{ 0x6171 , 0x915F},
{ 0x6172 , 0x9160},
{ 0x6173 , 0x9161},
{ 0x6174 , 0x9162},
{ 0x6176 , 0x9163},
{ 0x6178 , 0x9164},
{ 0x6179 , 0x9165},
{ 0x617A , 0x9166},
{ 0x617B , 0x9167},
{ 0x617C , 0x9168},
{ 0x617D , 0x9169},
{ 0x617E , 0x916A},
{ 0x617F , 0x916B},
{ 0x6180 , 0x916C},
{ 0x6181 , 0x916D},
{ 0x6182 , 0x916E},
{ 0x6183 , 0x916F},
{ 0x6184 , 0x9170},
{ 0x6185 , 0x9171},
{ 0x6186 , 0x9172},
{ 0x6187 , 0x9173},
{ 0x6188 , 0x9174},
{ 0x6189 , 0x9175},
{ 0x618A , 0x9176},
{ 0x618C , 0x9177},
{ 0x618D , 0x9178},
{ 0x618F , 0x9179},
{ 0x6190 , 0x917A},
{ 0x6191 , 0x917B},
{ 0x6192 , 0x917C},
{ 0x6193 , 0x917D},
{ 0x6195 , 0x917E},
{ 0x6196 , 0x9180},
{ 0x6197 , 0x9181},
{ 0x6198 , 0x9182},
{ 0x6199 , 0x9183},
{ 0x619A , 0x9184},
{ 0x619B , 0x9185},
{ 0x619C , 0x9186},
{ 0x619E , 0x9187},
{ 0x619F , 0x9188},
{ 0x61A0 , 0x9189},
{ 0x61A1 , 0x918A},
{ 0x61A2 , 0x918B},
{ 0x61A3 , 0x918C},
{ 0x61A4 , 0x918D},
{ 0x61A5 , 0x918E},
{ 0x61A6 , 0x918F},
{ 0x61AA , 0x9190},
{ 0x61AB , 0x9191},
{ 0x61AD , 0x9192},
{ 0x61AE , 0x9193},
{ 0x61AF , 0x9194},
{ 0x61B0 , 0x9195},
{ 0x61B1 , 0x9196},
{ 0x61B2 , 0x9197},
{ 0x61B3 , 0x9198},
{ 0x61B4 , 0x9199},
{ 0x61B5 , 0x919A},
{ 0x61B6 , 0x919B},
{ 0x61B8 , 0x919C},
{ 0x61B9 , 0x919D},
{ 0x61BA , 0x919E},
{ 0x61BB , 0x919F},
{ 0x61BC , 0x91A0},
{ 0x61BD , 0x91A1},
{ 0x61BF , 0x91A2},
{ 0x61C0 , 0x91A3},
{ 0x61C1 , 0x91A4},
{ 0x61C3 , 0x91A5},
{ 0x61C4 , 0x91A6},
{ 0x61C5 , 0x91A7},
{ 0x61C6 , 0x91A8},
{ 0x61C7 , 0x91A9},
{ 0x61C9 , 0x91AA},
{ 0x61CC , 0x91AB},
{ 0x61CD , 0x91AC},
{ 0x61CE , 0x91AD},
{ 0x61CF , 0x91AE},
{ 0x61D0 , 0x91AF},
{ 0x61D3 , 0x91B0},
{ 0x61D5 , 0x91B1},
{ 0x61D6 , 0x91B2},
{ 0x61D7 , 0x91B3},
{ 0x61D8 , 0x91B4},
{ 0x61D9 , 0x91B5},
{ 0x61DA , 0x91B6},
{ 0x61DB , 0x91B7},
{ 0x61DC , 0x91B8},
{ 0x61DD , 0x91B9},
{ 0x61DE , 0x91BA},
{ 0x61DF , 0x91BB},
{ 0x61E0 , 0x91BC},
{ 0x61E1 , 0x91BD},
{ 0x61E2 , 0x91BE},
{ 0x61E3 , 0x91BF},
{ 0x61E4 , 0x91C0},
{ 0x61E5 , 0x91C1},
{ 0x61E7 , 0x91C2},
{ 0x61E8 , 0x91C3},
{ 0x61E9 , 0x91C4},
{ 0x61EA , 0x91C5},
{ 0x61EB , 0x91C6},
{ 0x61EC , 0x91C7},
{ 0x61ED , 0x91C8},
{ 0x61EE , 0x91C9},
{ 0x61EF , 0x91CA},
{ 0x61F0 , 0x91CB},
{ 0x61F1 , 0x91CC},
{ 0x61F2 , 0x91CD},
{ 0x61F3 , 0x91CE},
{ 0x61F4 , 0x91CF},
{ 0x61F6 , 0x91D0},
{ 0x61F7 , 0x91D1},
{ 0x61F8 , 0x91D2},
{ 0x61F9 , 0x91D3},
{ 0x61FA , 0x91D4},
{ 0x61FB , 0x91D5},
{ 0x61FC , 0x91D6},
{ 0x61FD , 0x91D7},
{ 0x61FE , 0x91D8},
{ 0x6200 , 0x91D9},
{ 0x6201 , 0x91DA},
{ 0x6202 , 0x91DB},
{ 0x6203 , 0x91DC},
{ 0x6204 , 0x91DD},
{ 0x6205 , 0x91DE},
{ 0x6207 , 0x91DF},
{ 0x6209 , 0x91E0},
{ 0x6213 , 0x91E1},
{ 0x6214 , 0x91E2},
{ 0x6219 , 0x91E3},
{ 0x621C , 0x91E4},
{ 0x621D , 0x91E5},
{ 0x621E , 0x91E6},
{ 0x6220 , 0x91E7},
{ 0x6223 , 0x91E8},
{ 0x6226 , 0x91E9},
{ 0x6227 , 0x91EA},
{ 0x6228 , 0x91EB},
{ 0x6229 , 0x91EC},
{ 0x622B , 0x91ED},
{ 0x622D , 0x91EE},
{ 0x622F , 0x91EF},
{ 0x6230 , 0x91F0},
{ 0x6231 , 0x91F1},
{ 0x6232 , 0x91F2},
{ 0x6235 , 0x91F3},
{ 0x6236 , 0x91F4},
{ 0x6238 , 0x91F5},
{ 0x6239 , 0x91F6},
{ 0x623A , 0x91F7},
{ 0x623B , 0x91F8},
{ 0x623C , 0x91F9},
{ 0x6242 , 0x91FA},
{ 0x6244 , 0x91FB},
{ 0x6245 , 0x91FC},
{ 0x6246 , 0x91FD},
{ 0x624A , 0x91FE},
{ 0x624F , 0x9240},
{ 0x6250 , 0x9241},
{ 0x6255 , 0x9242},
{ 0x6256 , 0x9243},
{ 0x6257 , 0x9244},
{ 0x6259 , 0x9245},
{ 0x625A , 0x9246},
{ 0x625C , 0x9247},
{ 0x625D , 0x9248},
{ 0x625E , 0x9249},
{ 0x625F , 0x924A},
{ 0x6260 , 0x924B},
{ 0x6261 , 0x924C},
{ 0x6262 , 0x924D},
{ 0x6264 , 0x924E},
{ 0x6265 , 0x924F},
{ 0x6268 , 0x9250},
{ 0x6271 , 0x9251},
{ 0x6272 , 0x9252},
{ 0x6274 , 0x9253},
{ 0x6275 , 0x9254},
{ 0x6277 , 0x9255},
{ 0x6278 , 0x9256},
{ 0x627A , 0x9257},
{ 0x627B , 0x9258},
{ 0x627D , 0x9259},
{ 0x6281 , 0x925A},
{ 0x6282 , 0x925B},
{ 0x6283 , 0x925C},
{ 0x6285 , 0x925D},
{ 0x6286 , 0x925E},
{ 0x6287 , 0x925F},
{ 0x6288 , 0x9260},
{ 0x628B , 0x9261},
{ 0x628C , 0x9262},
{ 0x628D , 0x9263},
{ 0x628E , 0x9264},
{ 0x628F , 0x9265},
{ 0x6290 , 0x9266},
{ 0x6294 , 0x9267},
{ 0x6299 , 0x9268},
{ 0x629C , 0x9269},
{ 0x629D , 0x926A},
{ 0x629E , 0x926B},
{ 0x62A3 , 0x926C},
{ 0x62A6 , 0x926D},
{ 0x62A7 , 0x926E},
{ 0x62A9 , 0x926F},
{ 0x62AA , 0x9270},
{ 0x62AD , 0x9271},
{ 0x62AE , 0x9272},
{ 0x62AF , 0x9273},
{ 0x62B0 , 0x9274},
{ 0x62B2 , 0x9275},
{ 0x62B3 , 0x9276},
{ 0x62B4 , 0x9277},
{ 0x62B6 , 0x9278},
{ 0x62B7 , 0x9279},
{ 0x62B8 , 0x927A},
{ 0x62BA , 0x927B},
{ 0x62BE , 0x927C},
{ 0x62C0 , 0x927D},
{ 0x62C1 , 0x927E},
{ 0x62C3 , 0x9280},
{ 0x62CB , 0x9281},
{ 0x62CF , 0x9282},
{ 0x62D1 , 0x9283},
{ 0x62D5 , 0x9284},
{ 0x62DD , 0x9285},
{ 0x62DE , 0x9286},
{ 0x62E0 , 0x9287},
{ 0x62E1 , 0x9288},
{ 0x62E4 , 0x9289},
{ 0x62EA , 0x928A},
{ 0x62EB , 0x928B},
{ 0x62F0 , 0x928C},
{ 0x62F2 , 0x928D},
{ 0x62F5 , 0x928E},
{ 0x62F8 , 0x928F},
{ 0x62F9 , 0x9290},
{ 0x62FA , 0x9291},
{ 0x62FB , 0x9292},
{ 0x6300 , 0x9293},
{ 0x6303 , 0x9294},
{ 0x6304 , 0x9295},
{ 0x6305 , 0x9296},
{ 0x6306 , 0x9297},
{ 0x630A , 0x9298},
{ 0x630B , 0x9299},
{ 0x630C , 0x929A},
{ 0x630D , 0x929B},
{ 0x630F , 0x929C},
{ 0x6310 , 0x929D},
{ 0x6312 , 0x929E},
{ 0x6313 , 0x929F},
{ 0x6314 , 0x92A0},
{ 0x6315 , 0x92A1},
{ 0x6317 , 0x92A2},
{ 0x6318 , 0x92A3},
{ 0x6319 , 0x92A4},
{ 0x631C , 0x92A5},
{ 0x6326 , 0x92A6},
{ 0x6327 , 0x92A7},
{ 0x6329 , 0x92A8},
{ 0x632C , 0x92A9},
{ 0x632D , 0x92AA},
{ 0x632E , 0x92AB},
{ 0x6330 , 0x92AC},
{ 0x6331 , 0x92AD},
{ 0x6333 , 0x92AE},
{ 0x6334 , 0x92AF},
{ 0x6335 , 0x92B0},
{ 0x6336 , 0x92B1},
{ 0x6337 , 0x92B2},
{ 0x6338 , 0x92B3},
{ 0x633B , 0x92B4},
{ 0x633C , 0x92B5},
{ 0x633E , 0x92B6},
{ 0x633F , 0x92B7},
{ 0x6340 , 0x92B8},
{ 0x6341 , 0x92B9},
{ 0x6344 , 0x92BA},
{ 0x6347 , 0x92BB},
{ 0x6348 , 0x92BC},
{ 0x634A , 0x92BD},
{ 0x6351 , 0x92BE},
{ 0x6352 , 0x92BF},
{ 0x6353 , 0x92C0},
{ 0x6354 , 0x92C1},
{ 0x6356 , 0x92C2},
{ 0x6357 , 0x92C3},
{ 0x6358 , 0x92C4},
{ 0x6359 , 0x92C5},
{ 0x635A , 0x92C6},
{ 0x635B , 0x92C7},
{ 0x635C , 0x92C8},
{ 0x635D , 0x92C9},
{ 0x6360 , 0x92CA},
{ 0x6364 , 0x92CB},
{ 0x6365 , 0x92CC},
{ 0x6366 , 0x92CD},
{ 0x6368 , 0x92CE},
{ 0x636A , 0x92CF},
{ 0x636B , 0x92D0},
{ 0x636C , 0x92D1},
{ 0x636F , 0x92D2},
{ 0x6370 , 0x92D3},
{ 0x6372 , 0x92D4},
{ 0x6373 , 0x92D5},
{ 0x6374 , 0x92D6},
{ 0x6375 , 0x92D7},
{ 0x6378 , 0x92D8},
{ 0x6379 , 0x92D9},
{ 0x637C , 0x92DA},
{ 0x637D , 0x92DB},
{ 0x637E , 0x92DC},
{ 0x637F , 0x92DD},
{ 0x6381 , 0x92DE},
{ 0x6383 , 0x92DF},
{ 0x6384 , 0x92E0},
{ 0x6385 , 0x92E1},
{ 0x6386 , 0x92E2},
{ 0x638B , 0x92E3},
{ 0x638D , 0x92E4},
{ 0x6391 , 0x92E5},
{ 0x6393 , 0x92E6},
{ 0x6394 , 0x92E7},
{ 0x6395 , 0x92E8},
{ 0x6397 , 0x92E9},
{ 0x6399 , 0x92EA},
{ 0x639A , 0x92EB},
{ 0x639B , 0x92EC},
{ 0x639C , 0x92ED},
{ 0x639D , 0x92EE},
{ 0x639E , 0x92EF},
{ 0x639F , 0x92F0},
{ 0x63A1 , 0x92F1},
{ 0x63A4 , 0x92F2},
{ 0x63A6 , 0x92F3},
{ 0x63AB , 0x92F4},
{ 0x63AF , 0x92F5},
{ 0x63B1 , 0x92F6},
{ 0x63B2 , 0x92F7},
{ 0x63B5 , 0x92F8},
{ 0x63B6 , 0x92F9},
{ 0x63B9 , 0x92FA},
{ 0x63BB , 0x92FB},
{ 0x63BD , 0x92FC},
{ 0x63BF , 0x92FD},
{ 0x63C0 , 0x92FE},
{ 0x63C1 , 0x9340},
{ 0x63C2 , 0x9341},
{ 0x63C3 , 0x9342},
{ 0x63C5 , 0x9343},
{ 0x63C7 , 0x9344},
{ 0x63C8 , 0x9345},
{ 0x63CA , 0x9346},
{ 0x63CB , 0x9347},
{ 0x63CC , 0x9348},
{ 0x63D1 , 0x9349},
{ 0x63D3 , 0x934A},
{ 0x63D4 , 0x934B},
{ 0x63D5 , 0x934C},
{ 0x63D7 , 0x934D},
{ 0x63D8 , 0x934E},
{ 0x63D9 , 0x934F},
{ 0x63DA , 0x9350},
{ 0x63DB , 0x9351},
{ 0x63DC , 0x9352},
{ 0x63DD , 0x9353},
{ 0x63DF , 0x9354},
{ 0x63E2 , 0x9355},
{ 0x63E4 , 0x9356},
{ 0x63E5 , 0x9357},
{ 0x63E6 , 0x9358},
{ 0x63E7 , 0x9359},
{ 0x63E8 , 0x935A},
{ 0x63EB , 0x935B},
{ 0x63EC , 0x935C},
{ 0x63EE , 0x935D},
{ 0x63EF , 0x935E},
{ 0x63F0 , 0x935F},
{ 0x63F1 , 0x9360},
{ 0x63F3 , 0x9361},
{ 0x63F5 , 0x9362},
{ 0x63F7 , 0x9363},
{ 0x63F9 , 0x9364},
{ 0x63FA , 0x9365},
{ 0x63FB , 0x9366},
{ 0x63FC , 0x9367},
{ 0x63FE , 0x9368},
{ 0x6403 , 0x9369},
{ 0x6404 , 0x936A},
{ 0x6406 , 0x936B},
{ 0x6407 , 0x936C},
{ 0x6408 , 0x936D},
{ 0x6409 , 0x936E},
{ 0x640A , 0x936F},
{ 0x640D , 0x9370},
{ 0x640E , 0x9371},
{ 0x6411 , 0x9372},
{ 0x6412 , 0x9373},
{ 0x6415 , 0x9374},
{ 0x6416 , 0x9375},
{ 0x6417 , 0x9376},
{ 0x6418 , 0x9377},
{ 0x6419 , 0x9378},
{ 0x641A , 0x9379},
{ 0x641D , 0x937A},
{ 0x641F , 0x937B},
{ 0x6422 , 0x937C},
{ 0x6423 , 0x937D},
{ 0x6424 , 0x937E},
{ 0x6425 , 0x9380},
{ 0x6427 , 0x9381},
{ 0x6428 , 0x9382},
{ 0x6429 , 0x9383},
{ 0x642B , 0x9384},
{ 0x642E , 0x9385},
{ 0x642F , 0x9386},
{ 0x6430 , 0x9387},
{ 0x6431 , 0x9388},
{ 0x6432 , 0x9389},
{ 0x6433 , 0x938A},
{ 0x6435 , 0x938B},
{ 0x6436 , 0x938C},
{ 0x6437 , 0x938D},
{ 0x6438 , 0x938E},
{ 0x6439 , 0x938F},
{ 0x643B , 0x9390},
{ 0x643C , 0x9391},
{ 0x643E , 0x9392},
{ 0x6440 , 0x9393},
{ 0x6442 , 0x9394},
{ 0x6443 , 0x9395},
{ 0x6449 , 0x9396},
{ 0x644B , 0x9397},
{ 0x644C , 0x9398},
{ 0x644D , 0x9399},
{ 0x644E , 0x939A},
{ 0x644F , 0x939B},
{ 0x6450 , 0x939C},
{ 0x6451 , 0x939D},
{ 0x6453 , 0x939E},
{ 0x6455 , 0x939F},
{ 0x6456 , 0x93A0},
{ 0x6457 , 0x93A1},
{ 0x6459 , 0x93A2},
{ 0x645A , 0x93A3},
{ 0x645B , 0x93A4},
{ 0x645C , 0x93A5},
{ 0x645D , 0x93A6},
{ 0x645F , 0x93A7},
{ 0x6460 , 0x93A8},
{ 0x6461 , 0x93A9},
{ 0x6462 , 0x93AA},
{ 0x6463 , 0x93AB},
{ 0x6464 , 0x93AC},
{ 0x6465 , 0x93AD},
{ 0x6466 , 0x93AE},
{ 0x6468 , 0x93AF},
{ 0x646A , 0x93B0},
{ 0x646B , 0x93B1},
{ 0x646C , 0x93B2},
{ 0x646E , 0x93B3},
{ 0x646F , 0x93B4},
{ 0x6470 , 0x93B5},
{ 0x6471 , 0x93B6},
{ 0x6472 , 0x93B7},
{ 0x6473 , 0x93B8},
{ 0x6474 , 0x93B9},
{ 0x6475 , 0x93BA},
{ 0x6476 , 0x93BB},
{ 0x6477 , 0x93BC},
{ 0x647B , 0x93BD},
{ 0x647C , 0x93BE},
{ 0x647D , 0x93BF},
{ 0x647E , 0x93C0},
{ 0x647F , 0x93C1},
{ 0x6480 , 0x93C2},
{ 0x6481 , 0x93C3},
{ 0x6483 , 0x93C4},
{ 0x6486 , 0x93C5},
{ 0x6488 , 0x93C6},
{ 0x6489 , 0x93C7},
{ 0x648A , 0x93C8},
{ 0x648B , 0x93C9},
{ 0x648C , 0x93CA},
{ 0x648D , 0x93CB},
{ 0x648E , 0x93CC},
{ 0x648F , 0x93CD},
{ 0x6490 , 0x93CE},
{ 0x6493 , 0x93CF},
{ 0x6494 , 0x93D0},
{ 0x6497 , 0x93D1},
{ 0x6498 , 0x93D2},
{ 0x649A , 0x93D3},
{ 0x649B , 0x93D4},
{ 0x649C , 0x93D5},
{ 0x649D , 0x93D6},
{ 0x649F , 0x93D7},
{ 0x64A0 , 0x93D8},
{ 0x64A1 , 0x93D9},
{ 0x64A2 , 0x93DA},
{ 0x64A3 , 0x93DB},
{ 0x64A5 , 0x93DC},
{ 0x64A6 , 0x93DD},
{ 0x64A7 , 0x93DE},
{ 0x64A8 , 0x93DF},
{ 0x64AA , 0x93E0},
{ 0x64AB , 0x93E1},
{ 0x64AF , 0x93E2},
{ 0x64B1 , 0x93E3},
{ 0x64B2 , 0x93E4},
{ 0x64B3 , 0x93E5},
{ 0x64B4 , 0x93E6},
{ 0x64B6 , 0x93E7},
{ 0x64B9 , 0x93E8},
{ 0x64BB , 0x93E9},
{ 0x64BD , 0x93EA},
{ 0x64BE , 0x93EB},
{ 0x64BF , 0x93EC},
{ 0x64C1 , 0x93ED},
{ 0x64C3 , 0x93EE},
{ 0x64C4 , 0x93EF},
{ 0x64C6 , 0x93F0},
{ 0x64C7 , 0x93F1},
{ 0x64C8 , 0x93F2},
{ 0x64C9 , 0x93F3},
{ 0x64CA , 0x93F4},
{ 0x64CB , 0x93F5},
{ 0x64CC , 0x93F6},
{ 0x64CF , 0x93F7},
{ 0x64D1 , 0x93F8},
{ 0x64D3 , 0x93F9},
{ 0x64D4 , 0x93FA},
{ 0x64D5 , 0x93FB},
{ 0x64D6 , 0x93FC},
{ 0x64D9 , 0x93FD},
{ 0x64DA , 0x93FE},
{ 0x64DB , 0x9440},
{ 0x64DC , 0x9441},
{ 0x64DD , 0x9442},
{ 0x64DF , 0x9443},
{ 0x64E0 , 0x9444},
{ 0x64E1 , 0x9445},
{ 0x64E3 , 0x9446},
{ 0x64E5 , 0x9447},
{ 0x64E7 , 0x9448},
{ 0x64E8 , 0x9449},
{ 0x64E9 , 0x944A},
{ 0x64EA , 0x944B},
{ 0x64EB , 0x944C},
{ 0x64EC , 0x944D},
{ 0x64ED , 0x944E},
{ 0x64EE , 0x944F},
{ 0x64EF , 0x9450},
{ 0x64F0 , 0x9451},
{ 0x64F1 , 0x9452},
{ 0x64F2 , 0x9453},
{ 0x64F3 , 0x9454},
{ 0x64F4 , 0x9455},
{ 0x64F5 , 0x9456},
{ 0x64F6 , 0x9457},
{ 0x64F7 , 0x9458},
{ 0x64F8 , 0x9459},
{ 0x64F9 , 0x945A},
{ 0x64FA , 0x945B},
{ 0x64FB , 0x945C},
{ 0x64FC , 0x945D},
{ 0x64FD , 0x945E},
{ 0x64FE , 0x945F},
{ 0x64FF , 0x9460},
{ 0x6501 , 0x9461},
{ 0x6502 , 0x9462},
{ 0x6503 , 0x9463},
{ 0x6504 , 0x9464},
{ 0x6505 , 0x9465},
{ 0x6506 , 0x9466},
{ 0x6507 , 0x9467},
{ 0x6508 , 0x9468},
{ 0x650A , 0x9469},
{ 0x650B , 0x946A},
{ 0x650C , 0x946B},
{ 0x650D , 0x946C},
{ 0x650E , 0x946D},
{ 0x650F , 0x946E},
{ 0x6510 , 0x946F},
{ 0x6511 , 0x9470},
{ 0x6513 , 0x9471},
{ 0x6514 , 0x9472},
{ 0x6515 , 0x9473},
{ 0x6516 , 0x9474},
{ 0x6517 , 0x9475},
{ 0x6519 , 0x9476},
{ 0x651A , 0x9477},
{ 0x651B , 0x9478},
{ 0x651C , 0x9479},
{ 0x651D , 0x947A},
{ 0x651E , 0x947B},
{ 0x651F , 0x947C},
{ 0x6520 , 0x947D},
{ 0x6521 , 0x947E},
{ 0x6522 , 0x9480},
{ 0x6523 , 0x9481},
{ 0x6524 , 0x9482},
{ 0x6526 , 0x9483},
{ 0x6527 , 0x9484},
{ 0x6528 , 0x9485},
{ 0x6529 , 0x9486},
{ 0x652A , 0x9487},
{ 0x652C , 0x9488},
{ 0x652D , 0x9489},
{ 0x6530 , 0x948A},
{ 0x6531 , 0x948B},
{ 0x6532 , 0x948C},
{ 0x6533 , 0x948D},
{ 0x6537 , 0x948E},
{ 0x653A , 0x948F},
{ 0x653C , 0x9490},
{ 0x653D , 0x9491},
{ 0x6540 , 0x9492},
{ 0x6541 , 0x9493},
{ 0x6542 , 0x9494},
{ 0x6543 , 0x9495},
{ 0x6544 , 0x9496},
{ 0x6546 , 0x9497},
{ 0x6547 , 0x9498},
{ 0x654A , 0x9499},
{ 0x654B , 0x949A},
{ 0x654D , 0x949B},
{ 0x654E , 0x949C},
{ 0x6550 , 0x949D},
{ 0x6552 , 0x949E},
{ 0x6553 , 0x949F},
{ 0x6554 , 0x94A0},
{ 0x6557 , 0x94A1},
{ 0x6558 , 0x94A2},
{ 0x655A , 0x94A3},
{ 0x655C , 0x94A4},
{ 0x655F , 0x94A5},
{ 0x6560 , 0x94A6},
{ 0x6561 , 0x94A7},
{ 0x6564 , 0x94A8},
{ 0x6565 , 0x94A9},
{ 0x6567 , 0x94AA},
{ 0x6568 , 0x94AB},
{ 0x6569 , 0x94AC},
{ 0x656A , 0x94AD},
{ 0x656D , 0x94AE},
{ 0x656E , 0x94AF},
{ 0x656F , 0x94B0},
{ 0x6571 , 0x94B1},
{ 0x6573 , 0x94B2},
{ 0x6575 , 0x94B3},
{ 0x6576 , 0x94B4},
{ 0x6578 , 0x94B5},
{ 0x6579 , 0x94B6},
{ 0x657A , 0x94B7},
{ 0x657B , 0x94B8},
{ 0x657C , 0x94B9},
{ 0x657D , 0x94BA},
{ 0x657E , 0x94BB},
{ 0x657F , 0x94BC},
{ 0x6580 , 0x94BD},
{ 0x6581 , 0x94BE},
{ 0x6582 , 0x94BF},
{ 0x6583 , 0x94C0},
{ 0x6584 , 0x94C1},
{ 0x6585 , 0x94C2},
{ 0x6586 , 0x94C3},
{ 0x6588 , 0x94C4},
{ 0x6589 , 0x94C5},
{ 0x658A , 0x94C6},
{ 0x658D , 0x94C7},
{ 0x658E , 0x94C8},
{ 0x658F , 0x94C9},
{ 0x6592 , 0x94CA},
{ 0x6594 , 0x94CB},
{ 0x6595 , 0x94CC},
{ 0x6596 , 0x94CD},
{ 0x6598 , 0x94CE},
{ 0x659A , 0x94CF},
{ 0x659D , 0x94D0},
{ 0x659E , 0x94D1},
{ 0x65A0 , 0x94D2},
{ 0x65A2 , 0x94D3},
{ 0x65A3 , 0x94D4},
{ 0x65A6 , 0x94D5},
{ 0x65A8 , 0x94D6},
{ 0x65AA , 0x94D7},
{ 0x65AC , 0x94D8},
{ 0x65AE , 0x94D9},
{ 0x65B1 , 0x94DA},
{ 0x65B2 , 0x94DB},
{ 0x65B3 , 0x94DC},
{ 0x65B4 , 0x94DD},
{ 0x65B5 , 0x94DE},
{ 0x65B6 , 0x94DF},
{ 0x65B7 , 0x94E0},
{ 0x65B8 , 0x94E1},
{ 0x65BA , 0x94E2},
{ 0x65BB , 0x94E3},
{ 0x65BE , 0x94E4},
{ 0x65BF , 0x94E5},
{ 0x65C0 , 0x94E6},
{ 0x65C2 , 0x94E7},
{ 0x65C7 , 0x94E8},
{ 0x65C8 , 0x94E9},
{ 0x65C9 , 0x94EA},
{ 0x65CA , 0x94EB},
{ 0x65CD , 0x94EC},
{ 0x65D0 , 0x94ED},
{ 0x65D1 , 0x94EE},
{ 0x65D3 , 0x94EF},
{ 0x65D4 , 0x94F0},
{ 0x65D5 , 0x94F1},
{ 0x65D8 , 0x94F2},
{ 0x65D9 , 0x94F3},
{ 0x65DA , 0x94F4},
{ 0x65DB , 0x94F5},
{ 0x65DC , 0x94F6},
{ 0x65DD , 0x94F7},
{ 0x65DE , 0x94F8},
{ 0x65DF , 0x94F9},
{ 0x65E1 , 0x94FA},
{ 0x65E3 , 0x94FB},
{ 0x65E4 , 0x94FC},
{ 0x65EA , 0x94FD},
{ 0x65EB , 0x94FE},
{ 0x65F2 , 0x9540},
{ 0x65F3 , 0x9541},
{ 0x65F4 , 0x9542},
{ 0x65F5 , 0x9543},
{ 0x65F8 , 0x9544},
{ 0x65F9 , 0x9545},
{ 0x65FB , 0x9546},
{ 0x65FC , 0x9547},
{ 0x65FD , 0x9548},
{ 0x65FE , 0x9549},
{ 0x65FF , 0x954A},
{ 0x6601 , 0x954B},
{ 0x6604 , 0x954C},
{ 0x6605 , 0x954D},
{ 0x6607 , 0x954E},
{ 0x6608 , 0x954F},
{ 0x6609 , 0x9550},
{ 0x660B , 0x9551},
{ 0x660D , 0x9552},
{ 0x6610 , 0x9553},
{ 0x6611 , 0x9554},
{ 0x6612 , 0x9555},
{ 0x6616 , 0x9556},
{ 0x6617 , 0x9557},
{ 0x6618 , 0x9558},
{ 0x661A , 0x9559},
{ 0x661B , 0x955A},
{ 0x661C , 0x955B},
{ 0x661E , 0x955C},
{ 0x6621 , 0x955D},
{ 0x6622 , 0x955E},
{ 0x6623 , 0x955F},
{ 0x6624 , 0x9560},
{ 0x6626 , 0x9561},
{ 0x6629 , 0x9562},
{ 0x662A , 0x9563},
{ 0x662B , 0x9564},
{ 0x662C , 0x9565},
{ 0x662E , 0x9566},
{ 0x6630 , 0x9567},
{ 0x6632 , 0x9568},
{ 0x6633 , 0x9569},
{ 0x6637 , 0x956A},
{ 0x6638 , 0x956B},
{ 0x6639 , 0x956C},
{ 0x663A , 0x956D},
{ 0x663B , 0x956E},
{ 0x663D , 0x956F},
{ 0x663F , 0x9570},
{ 0x6640 , 0x9571},
{ 0x6642 , 0x9572},
{ 0x6644 , 0x9573},
{ 0x6645 , 0x9574},
{ 0x6646 , 0x9575},
{ 0x6647 , 0x9576},
{ 0x6648 , 0x9577},
{ 0x6649 , 0x9578},
{ 0x664A , 0x9579},
{ 0x664D , 0x957A},
{ 0x664E , 0x957B},
{ 0x6650 , 0x957C},
{ 0x6651 , 0x957D},
{ 0x6658 , 0x957E},
{ 0x6659 , 0x9580},
{ 0x665B , 0x9581},
{ 0x665C , 0x9582},
{ 0x665D , 0x9583},
{ 0x665E , 0x9584},
{ 0x6660 , 0x9585},
{ 0x6662 , 0x9586},
{ 0x6663 , 0x9587},
{ 0x6665 , 0x9588},
{ 0x6667 , 0x9589},
{ 0x6669 , 0x958A},
{ 0x666A , 0x958B},
{ 0x666B , 0x958C},
{ 0x666C , 0x958D},
{ 0x666D , 0x958E},
{ 0x6671 , 0x958F},
{ 0x6672 , 0x9590},
{ 0x6673 , 0x9591},
{ 0x6675 , 0x9592},
{ 0x6678 , 0x9593},
{ 0x6679 , 0x9594},
{ 0x667B , 0x9595},
{ 0x667C , 0x9596},
{ 0x667D , 0x9597},
{ 0x667F , 0x9598},
{ 0x6680 , 0x9599},
{ 0x6681 , 0x959A},
{ 0x6683 , 0x959B},
{ 0x6685 , 0x959C},
{ 0x6686 , 0x959D},
{ 0x6688 , 0x959E},
{ 0x6689 , 0x959F},
{ 0x668A , 0x95A0},
{ 0x668B , 0x95A1},
{ 0x668D , 0x95A2},
{ 0x668E , 0x95A3},
{ 0x668F , 0x95A4},
{ 0x6690 , 0x95A5},
{ 0x6692 , 0x95A6},
{ 0x6693 , 0x95A7},
{ 0x6694 , 0x95A8},
{ 0x6695 , 0x95A9},
{ 0x6698 , 0x95AA},
{ 0x6699 , 0x95AB},
{ 0x669A , 0x95AC},
{ 0x669B , 0x95AD},
{ 0x669C , 0x95AE},
{ 0x669E , 0x95AF},
{ 0x669F , 0x95B0},
{ 0x66A0 , 0x95B1},
{ 0x66A1 , 0x95B2},
{ 0x66A2 , 0x95B3},
{ 0x66A3 , 0x95B4},
{ 0x66A4 , 0x95B5},
{ 0x66A5 , 0x95B6},
{ 0x66A6 , 0x95B7},
{ 0x66A9 , 0x95B8},
{ 0x66AA , 0x95B9},
{ 0x66AB , 0x95BA},
{ 0x66AC , 0x95BB},
{ 0x66AD , 0x95BC},
{ 0x66AF , 0x95BD},
{ 0x66B0 , 0x95BE},
{ 0x66B1 , 0x95BF},
{ 0x66B2 , 0x95C0},
{ 0x66B3 , 0x95C1},
{ 0x66B5 , 0x95C2},
{ 0x66B6 , 0x95C3},
{ 0x66B7 , 0x95C4},
{ 0x66B8 , 0x95C5},
{ 0x66BA , 0x95C6},
{ 0x66BB , 0x95C7},
{ 0x66BC , 0x95C8},
{ 0x66BD , 0x95C9},
{ 0x66BF , 0x95CA},
{ 0x66C0 , 0x95CB},
{ 0x66C1 , 0x95CC},
{ 0x66C2 , 0x95CD},
{ 0x66C3 , 0x95CE},
{ 0x66C4 , 0x95CF},
{ 0x66C5 , 0x95D0},
{ 0x66C6 , 0x95D1},
{ 0x66C7 , 0x95D2},
{ 0x66C8 , 0x95D3},
{ 0x66C9 , 0x95D4},
{ 0x66CA , 0x95D5},
{ 0x66CB , 0x95D6},
{ 0x66CC , 0x95D7},
{ 0x66CD , 0x95D8},
{ 0x66CE , 0x95D9},
{ 0x66CF , 0x95DA},
{ 0x66D0 , 0x95DB},
{ 0x66D1 , 0x95DC},
{ 0x66D2 , 0x95DD},
{ 0x66D3 , 0x95DE},
{ 0x66D4 , 0x95DF},
{ 0x66D5 , 0x95E0},
{ 0x66D6 , 0x95E1},
{ 0x66D7 , 0x95E2},
{ 0x66D8 , 0x95E3},
{ 0x66DA , 0x95E4},
{ 0x66DE , 0x95E5},
{ 0x66DF , 0x95E6},
{ 0x66E0 , 0x95E7},
{ 0x66E1 , 0x95E8},
{ 0x66E2 , 0x95E9},
{ 0x66E3 , 0x95EA},
{ 0x66E4 , 0x95EB},
{ 0x66E5 , 0x95EC},
{ 0x66E7 , 0x95ED},
{ 0x66E8 , 0x95EE},
{ 0x66EA , 0x95EF},
{ 0x66EB , 0x95F0},
{ 0x66EC , 0x95F1},
{ 0x66ED , 0x95F2},
{ 0x66EE , 0x95F3},
{ 0x66EF , 0x95F4},
{ 0x66F1 , 0x95F5},
{ 0x66F5 , 0x95F6},
{ 0x66F6 , 0x95F7},
{ 0x66F8 , 0x95F8},
{ 0x66FA , 0x95F9},
{ 0x66FB , 0x95FA},
{ 0x66FD , 0x95FB},
{ 0x6701 , 0x95FC},
{ 0x6702 , 0x95FD},
{ 0x6703 , 0x95FE},
{ 0x6704 , 0x9640},
{ 0x6705 , 0x9641},
{ 0x6706 , 0x9642},
{ 0x6707 , 0x9643},
{ 0x670C , 0x9644},
{ 0x670E , 0x9645},
{ 0x670F , 0x9646},
{ 0x6711 , 0x9647},
{ 0x6712 , 0x9648},
{ 0x6713 , 0x9649},
{ 0x6716 , 0x964A},
{ 0x6718 , 0x964B},
{ 0x6719 , 0x964C},
{ 0x671A , 0x964D},
{ 0x671C , 0x964E},
{ 0x671E , 0x964F},
{ 0x6720 , 0x9650},
{ 0x6721 , 0x9651},
{ 0x6722 , 0x9652},
{ 0x6723 , 0x9653},
{ 0x6724 , 0x9654},
{ 0x6725 , 0x9655},
{ 0x6727 , 0x9656},
{ 0x6729 , 0x9657},
{ 0x672E , 0x9658},
{ 0x6730 , 0x9659},
{ 0x6732 , 0x965A},
{ 0x6733 , 0x965B},
{ 0x6736 , 0x965C},
{ 0x6737 , 0x965D},
{ 0x6738 , 0x965E},
{ 0x6739 , 0x965F},
{ 0x673B , 0x9660},
{ 0x673C , 0x9661},
{ 0x673E , 0x9662},
{ 0x673F , 0x9663},
{ 0x6741 , 0x9664},
{ 0x6744 , 0x9665},
{ 0x6745 , 0x9666},
{ 0x6747 , 0x9667},
{ 0x674A , 0x9668},
{ 0x674B , 0x9669},
{ 0x674D , 0x966A},
{ 0x6752 , 0x966B},
{ 0x6754 , 0x966C},
{ 0x6755 , 0x966D},
{ 0x6757 , 0x966E},
{ 0x6758 , 0x966F},
{ 0x6759 , 0x9670},
{ 0x675A , 0x9671},
{ 0x675B , 0x9672},
{ 0x675D , 0x9673},
{ 0x6762 , 0x9674},
{ 0x6763 , 0x9675},
{ 0x6764 , 0x9676},
{ 0x6766 , 0x9677},
{ 0x6767 , 0x9678},
{ 0x676B , 0x9679},
{ 0x676C , 0x967A},
{ 0x676E , 0x967B},
{ 0x6771 , 0x967C},
{ 0x6774 , 0x967D},
{ 0x6776 , 0x967E},
{ 0x6778 , 0x9680},
{ 0x6779 , 0x9681},
{ 0x677A , 0x9682},
{ 0x677B , 0x9683},
{ 0x677D , 0x9684},
{ 0x6780 , 0x9685},
{ 0x6782 , 0x9686},
{ 0x6783 , 0x9687},
{ 0x6785 , 0x9688},
{ 0x6786 , 0x9689},
{ 0x6788 , 0x968A},
{ 0x678A , 0x968B},
{ 0x678C , 0x968C},
{ 0x678D , 0x968D},
{ 0x678E , 0x968E},
{ 0x678F , 0x968F},
{ 0x6791 , 0x9690},
{ 0x6792 , 0x9691},
{ 0x6793 , 0x9692},
{ 0x6794 , 0x9693},
{ 0x6796 , 0x9694},
{ 0x6799 , 0x9695},
{ 0x679B , 0x9696},
{ 0x679F , 0x9697},
{ 0x67A0 , 0x9698},
{ 0x67A1 , 0x9699},
{ 0x67A4 , 0x969A},
{ 0x67A6 , 0x969B},
{ 0x67A9 , 0x969C},
{ 0x67AC , 0x969D},
{ 0x67AE , 0x969E},
{ 0x67B1 , 0x969F},
{ 0x67B2 , 0x96A0},
{ 0x67B4 , 0x96A1},
{ 0x67B9 , 0x96A2},
{ 0x67BA , 0x96A3},
{ 0x67BB , 0x96A4},
{ 0x67BC , 0x96A5},
{ 0x67BD , 0x96A6},
{ 0x67BE , 0x96A7},
{ 0x67BF , 0x96A8},
{ 0x67C0 , 0x96A9},
{ 0x67C2 , 0x96AA},
{ 0x67C5 , 0x96AB},
{ 0x67C6 , 0x96AC},
{ 0x67C7 , 0x96AD},
{ 0x67C8 , 0x96AE},
{ 0x67C9 , 0x96AF},
{ 0x67CA , 0x96B0},
{ 0x67CB , 0x96B1},
{ 0x67CC , 0x96B2},
{ 0x67CD , 0x96B3},
{ 0x67CE , 0x96B4},
{ 0x67D5 , 0x96B5},
{ 0x67D6 , 0x96B6},
{ 0x67D7 , 0x96B7},
{ 0x67DB , 0x96B8},
{ 0x67DF , 0x96B9},
{ 0x67E1 , 0x96BA},
{ 0x67E3 , 0x96BB},
{ 0x67E4 , 0x96BC},
{ 0x67E6 , 0x96BD},
{ 0x67E7 , 0x96BE},
{ 0x67E8 , 0x96BF},
{ 0x67EA , 0x96C0},
{ 0x67EB , 0x96C1},
{ 0x67ED , 0x96C2},
{ 0x67EE , 0x96C3},
{ 0x67F2 , 0x96C4},
{ 0x67F5 , 0x96C5},
{ 0x67F6 , 0x96C6},
{ 0x67F7 , 0x96C7},
{ 0x67F8 , 0x96C8},
{ 0x67F9 , 0x96C9},
{ 0x67FA , 0x96CA},
{ 0x67FB , 0x96CB},
{ 0x67FC , 0x96CC},
{ 0x67FE , 0x96CD},
{ 0x6801 , 0x96CE},
{ 0x6802 , 0x96CF},
{ 0x6803 , 0x96D0},
{ 0x6804 , 0x96D1},
{ 0x6806 , 0x96D2},
{ 0x680D , 0x96D3},
{ 0x6810 , 0x96D4},
{ 0x6812 , 0x96D5},
{ 0x6814 , 0x96D6},
{ 0x6815 , 0x96D7},
{ 0x6818 , 0x96D8},
{ 0x6819 , 0x96D9},
{ 0x681A , 0x96DA},
{ 0x681B , 0x96DB},
{ 0x681C , 0x96DC},
{ 0x681E , 0x96DD},
{ 0x681F , 0x96DE},
{ 0x6820 , 0x96DF},
{ 0x6822 , 0x96E0},
{ 0x6823 , 0x96E1},
{ 0x6824 , 0x96E2},
{ 0x6825 , 0x96E3},
{ 0x6826 , 0x96E4},
{ 0x6827 , 0x96E5},
{ 0x6828 , 0x96E6},
{ 0x682B , 0x96E7},
{ 0x682C , 0x96E8},
{ 0x682D , 0x96E9},
{ 0x682E , 0x96EA},
{ 0x682F , 0x96EB},
{ 0x6830 , 0x96EC},
{ 0x6831 , 0x96ED},
{ 0x6834 , 0x96EE},
{ 0x6835 , 0x96EF},
{ 0x6836 , 0x96F0},
{ 0x683A , 0x96F1},
{ 0x683B , 0x96F2},
{ 0x683F , 0x96F3},
{ 0x6847 , 0x96F4},
{ 0x684B , 0x96F5},
{ 0x684D , 0x96F6},
{ 0x684F , 0x96F7},
{ 0x6852 , 0x96F8},
{ 0x6856 , 0x96F9},
{ 0x6857 , 0x96FA},
{ 0x6858 , 0x96FB},
{ 0x6859 , 0x96FC},
{ 0x685A , 0x96FD},
{ 0x685B , 0x96FE},
{ 0x685C , 0x9740},
{ 0x685D , 0x9741},
{ 0x685E , 0x9742},
{ 0x685F , 0x9743},
{ 0x686A , 0x9744},
{ 0x686C , 0x9745},
{ 0x686D , 0x9746},
{ 0x686E , 0x9747},
{ 0x686F , 0x9748},
{ 0x6870 , 0x9749},
{ 0x6871 , 0x974A},
{ 0x6872 , 0x974B},
{ 0x6873 , 0x974C},
{ 0x6875 , 0x974D},
{ 0x6878 , 0x974E},
{ 0x6879 , 0x974F},
{ 0x687A , 0x9750},
{ 0x687B , 0x9751},
{ 0x687C , 0x9752},
{ 0x687D , 0x9753},
{ 0x687E , 0x9754},
{ 0x687F , 0x9755},
{ 0x6880 , 0x9756},
{ 0x6882 , 0x9757},
{ 0x6884 , 0x9758},
{ 0x6887 , 0x9759},
{ 0x6888 , 0x975A},
{ 0x6889 , 0x975B},
{ 0x688A , 0x975C},
{ 0x688B , 0x975D},
{ 0x688C , 0x975E},
{ 0x688D , 0x975F},
{ 0x688E , 0x9760},
{ 0x6890 , 0x9761},
{ 0x6891 , 0x9762},
{ 0x6892 , 0x9763},
{ 0x6894 , 0x9764},
{ 0x6895 , 0x9765},
{ 0x6896 , 0x9766},
{ 0x6898 , 0x9767},
{ 0x6899 , 0x9768},
{ 0x689A , 0x9769},
{ 0x689B , 0x976A},
{ 0x689C , 0x976B},
{ 0x689D , 0x976C},
{ 0x689E , 0x976D},
{ 0x689F , 0x976E},
{ 0x68A0 , 0x976F},
{ 0x68A1 , 0x9770},
{ 0x68A3 , 0x9771},
{ 0x68A4 , 0x9772},
{ 0x68A5 , 0x9773},
{ 0x68A9 , 0x9774},
{ 0x68AA , 0x9775},
{ 0x68AB , 0x9776},
{ 0x68AC , 0x9777},
{ 0x68AE , 0x9778},
{ 0x68B1 , 0x9779},
{ 0x68B2 , 0x977A},
{ 0x68B4 , 0x977B},
{ 0x68B6 , 0x977C},
{ 0x68B7 , 0x977D},
{ 0x68B8 , 0x977E},
{ 0x68B9 , 0x9780},
{ 0x68BA , 0x9781},
{ 0x68BB , 0x9782},
{ 0x68BC , 0x9783},
{ 0x68BD , 0x9784},
{ 0x68BE , 0x9785},
{ 0x68BF , 0x9786},
{ 0x68C1 , 0x9787},
{ 0x68C3 , 0x9788},
{ 0x68C4 , 0x9789},
{ 0x68C5 , 0x978A},
{ 0x68C6 , 0x978B},
{ 0x68C7 , 0x978C},
{ 0x68C8 , 0x978D},
{ 0x68CA , 0x978E},
{ 0x68CC , 0x978F},
{ 0x68CE , 0x9790},
{ 0x68CF , 0x9791},
{ 0x68D0 , 0x9792},
{ 0x68D1 , 0x9793},
{ 0x68D3 , 0x9794},
{ 0x68D4 , 0x9795},
{ 0x68D6 , 0x9796},
{ 0x68D7 , 0x9797},
{ 0x68D9 , 0x9798},
{ 0x68DB , 0x9799},
{ 0x68DC , 0x979A},
{ 0x68DD , 0x979B},
{ 0x68DE , 0x979C},
{ 0x68DF , 0x979D},
{ 0x68E1 , 0x979E},
{ 0x68E2 , 0x979F},
{ 0x68E4 , 0x97A0},
{ 0x68E5 , 0x97A1},
{ 0x68E6 , 0x97A2},
{ 0x68E7 , 0x97A3},
{ 0x68E8 , 0x97A4},
{ 0x68E9 , 0x97A5},
{ 0x68EA , 0x97A6},
{ 0x68EB , 0x97A7},
{ 0x68EC , 0x97A8},
{ 0x68ED , 0x97A9},
{ 0x68EF , 0x97AA},
{ 0x68F2 , 0x97AB},
{ 0x68F3 , 0x97AC},
{ 0x68F4 , 0x97AD},
{ 0x68F6 , 0x97AE},
{ 0x68F7 , 0x97AF},
{ 0x68F8 , 0x97B0},
{ 0x68FB , 0x97B1},
{ 0x68FD , 0x97B2},
{ 0x68FE , 0x97B3},
{ 0x68FF , 0x97B4},
{ 0x6900 , 0x97B5},
{ 0x6902 , 0x97B6},
{ 0x6903 , 0x97B7},
{ 0x6904 , 0x97B8},
{ 0x6906 , 0x97B9},
{ 0x6907 , 0x97BA},
{ 0x6908 , 0x97BB},
{ 0x6909 , 0x97BC},
{ 0x690A , 0x97BD},
{ 0x690C , 0x97BE},
{ 0x690F , 0x97BF},
{ 0x6911 , 0x97C0},
{ 0x6913 , 0x97C1},
{ 0x6914 , 0x97C2},
{ 0x6915 , 0x97C3},
{ 0x6916 , 0x97C4},
{ 0x6917 , 0x97C5},
{ 0x6918 , 0x97C6},
{ 0x6919 , 0x97C7},
{ 0x691A , 0x97C8},
{ 0x691B , 0x97C9},
{ 0x691C , 0x97CA},
{ 0x691D , 0x97CB},
{ 0x691E , 0x97CC},
{ 0x6921 , 0x97CD},
{ 0x6922 , 0x97CE},
{ 0x6923 , 0x97CF},
{ 0x6925 , 0x97D0},
{ 0x6926 , 0x97D1},
{ 0x6927 , 0x97D2},
{ 0x6928 , 0x97D3},
{ 0x6929 , 0x97D4},
{ 0x692A , 0x97D5},
{ 0x692B , 0x97D6},
{ 0x692C , 0x97D7},
{ 0x692E , 0x97D8},
{ 0x692F , 0x97D9},
{ 0x6931 , 0x97DA},
{ 0x6932 , 0x97DB},
{ 0x6933 , 0x97DC},
{ 0x6935 , 0x97DD},
{ 0x6936 , 0x97DE},
{ 0x6937 , 0x97DF},
{ 0x6938 , 0x97E0},
{ 0x693A , 0x97E1},
{ 0x693B , 0x97E2},
{ 0x693C , 0x97E3},
{ 0x693E , 0x97E4},
{ 0x6940 , 0x97E5},
{ 0x6941 , 0x97E6},
{ 0x6943 , 0x97E7},
{ 0x6944 , 0x97E8},
{ 0x6945 , 0x97E9},
{ 0x6946 , 0x97EA},
{ 0x6947 , 0x97EB},
{ 0x6948 , 0x97EC},
{ 0x6949 , 0x97ED},
{ 0x694A , 0x97EE},
{ 0x694B , 0x97EF},
{ 0x694C , 0x97F0},
{ 0x694D , 0x97F1},
{ 0x694E , 0x97F2},
{ 0x694F , 0x97F3},
{ 0x6950 , 0x97F4},
{ 0x6951 , 0x97F5},
{ 0x6952 , 0x97F6},
{ 0x6953 , 0x97F7},
{ 0x6955 , 0x97F8},
{ 0x6956 , 0x97F9},
{ 0x6958 , 0x97FA},
{ 0x6959 , 0x97FB},
{ 0x695B , 0x97FC},
{ 0x695C , 0x97FD},
{ 0x695F , 0x97FE},
{ 0x6961 , 0x9840},
{ 0x6962 , 0x9841},
{ 0x6964 , 0x9842},
{ 0x6965 , 0x9843},
{ 0x6967 , 0x9844},
{ 0x6968 , 0x9845},
{ 0x6969 , 0x9846},
{ 0x696A , 0x9847},
{ 0x696C , 0x9848},
{ 0x696D , 0x9849},
{ 0x696F , 0x984A},
{ 0x6970 , 0x984B},
{ 0x6972 , 0x984C},
{ 0x6973 , 0x984D},
{ 0x6974 , 0x984E},
{ 0x6975 , 0x984F},
{ 0x6976 , 0x9850},
{ 0x697A , 0x9851},
{ 0x697B , 0x9852},
{ 0x697D , 0x9853},
{ 0x697E , 0x9854},
{ 0x697F , 0x9855},
{ 0x6981 , 0x9856},
{ 0x6983 , 0x9857},
{ 0x6985 , 0x9858},
{ 0x698A , 0x9859},
{ 0x698B , 0x985A},
{ 0x698C , 0x985B},
{ 0x698E , 0x985C},
{ 0x698F , 0x985D},
{ 0x6990 , 0x985E},
{ 0x6991 , 0x985F},
{ 0x6992 , 0x9860},
{ 0x6993 , 0x9861},
{ 0x6996 , 0x9862},
{ 0x6997 , 0x9863},
{ 0x6999 , 0x9864},
{ 0x699A , 0x9865},
{ 0x699D , 0x9866},
{ 0x699E , 0x9867},
{ 0x699F , 0x9868},
{ 0x69A0 , 0x9869},
{ 0x69A1 , 0x986A},
{ 0x69A2 , 0x986B},
{ 0x69A3 , 0x986C},
{ 0x69A4 , 0x986D},
{ 0x69A5 , 0x986E},
{ 0x69A6 , 0x986F},
{ 0x69A9 , 0x9870},
{ 0x69AA , 0x9871},
{ 0x69AC , 0x9872},
{ 0x69AE , 0x9873},
{ 0x69AF , 0x9874},
{ 0x69B0 , 0x9875},
{ 0x69B2 , 0x9876},
{ 0x69B3 , 0x9877},
{ 0x69B5 , 0x9878},
{ 0x69B6 , 0x9879},
{ 0x69B8 , 0x987A},
{ 0x69B9 , 0x987B},
{ 0x69BA , 0x987C},
{ 0x69BC , 0x987D},
{ 0x69BD , 0x987E},
{ 0x69BE , 0x9880},
{ 0x69BF , 0x9881},
{ 0x69C0 , 0x9882},
{ 0x69C2 , 0x9883},
{ 0x69C3 , 0x9884},
{ 0x69C4 , 0x9885},
{ 0x69C5 , 0x9886},
{ 0x69C6 , 0x9887},
{ 0x69C7 , 0x9888},
{ 0x69C8 , 0x9889},
{ 0x69C9 , 0x988A},
{ 0x69CB , 0x988B},
{ 0x69CD , 0x988C},
{ 0x69CF , 0x988D},
{ 0x69D1 , 0x988E},
{ 0x69D2 , 0x988F},
{ 0x69D3 , 0x9890},
{ 0x69D5 , 0x9891},
{ 0x69D6 , 0x9892},
{ 0x69D7 , 0x9893},
{ 0x69D8 , 0x9894},
{ 0x69D9 , 0x9895},
{ 0x69DA , 0x9896},
{ 0x69DC , 0x9897},
{ 0x69DD , 0x9898},
{ 0x69DE , 0x9899},
{ 0x69E1 , 0x989A},
{ 0x69E2 , 0x989B},
{ 0x69E3 , 0x989C},
{ 0x69E4 , 0x989D},
{ 0x69E5 , 0x989E},
{ 0x69E6 , 0x989F},
{ 0x69E7 , 0x98A0},
{ 0x69E8 , 0x98A1},
{ 0x69E9 , 0x98A2},
{ 0x69EA , 0x98A3},
{ 0x69EB , 0x98A4},
{ 0x69EC , 0x98A5},
{ 0x69EE , 0x98A6},
{ 0x69EF , 0x98A7},
{ 0x69F0 , 0x98A8},
{ 0x69F1 , 0x98A9},
{ 0x69F3 , 0x98AA},
{ 0x69F4 , 0x98AB},
{ 0x69F5 , 0x98AC},
{ 0x69F6 , 0x98AD},
{ 0x69F7 , 0x98AE},
{ 0x69F8 , 0x98AF},
{ 0x69F9 , 0x98B0},
{ 0x69FA , 0x98B1},
{ 0x69FB , 0x98B2},
{ 0x69FC , 0x98B3},
{ 0x69FE , 0x98B4},
{ 0x6A00 , 0x98B5},
{ 0x6A01 , 0x98B6},
{ 0x6A02 , 0x98B7},
{ 0x6A03 , 0x98B8},
{ 0x6A04 , 0x98B9},
{ 0x6A05 , 0x98BA},
{ 0x6A06 , 0x98BB},
{ 0x6A07 , 0x98BC},
{ 0x6A08 , 0x98BD},
{ 0x6A09 , 0x98BE},
{ 0x6A0B , 0x98BF},
{ 0x6A0C , 0x98C0},
{ 0x6A0D , 0x98C1},
{ 0x6A0E , 0x98C2},
{ 0x6A0F , 0x98C3},
{ 0x6A10 , 0x98C4},
{ 0x6A11 , 0x98C5},
{ 0x6A12 , 0x98C6},
{ 0x6A13 , 0x98C7},
{ 0x6A14 , 0x98C8},
{ 0x6A15 , 0x98C9},
{ 0x6A16 , 0x98CA},
{ 0x6A19 , 0x98CB},
{ 0x6A1A , 0x98CC},
{ 0x6A1B , 0x98CD},
{ 0x6A1C , 0x98CE},
{ 0x6A1D , 0x98CF},
{ 0x6A1E , 0x98D0},
{ 0x6A20 , 0x98D1},
{ 0x6A22 , 0x98D2},
{ 0x6A23 , 0x98D3},
{ 0x6A24 , 0x98D4},
{ 0x6A25 , 0x98D5},
{ 0x6A26 , 0x98D6},
{ 0x6A27 , 0x98D7},
{ 0x6A29 , 0x98D8},
{ 0x6A2B , 0x98D9},
{ 0x6A2C , 0x98DA},
{ 0x6A2D , 0x98DB},
{ 0x6A2E , 0x98DC},
{ 0x6A30 , 0x98DD},
{ 0x6A32 , 0x98DE},
{ 0x6A33 , 0x98DF},
{ 0x6A34 , 0x98E0},
{ 0x6A36 , 0x98E1},
{ 0x6A37 , 0x98E2},
{ 0x6A38 , 0x98E3},
{ 0x6A39 , 0x98E4},
{ 0x6A3A , 0x98E5},
{ 0x6A3B , 0x98E6},
{ 0x6A3C , 0x98E7},
{ 0x6A3F , 0x98E8},
{ 0x6A40 , 0x98E9},
{ 0x6A41 , 0x98EA},
{ 0x6A42 , 0x98EB},
{ 0x6A43 , 0x98EC},
{ 0x6A45 , 0x98ED},
{ 0x6A46 , 0x98EE},
{ 0x6A48 , 0x98EF},
{ 0x6A49 , 0x98F0},
{ 0x6A4A , 0x98F1},
{ 0x6A4B , 0x98F2},
{ 0x6A4C , 0x98F3},
{ 0x6A4D , 0x98F4},
{ 0x6A4E , 0x98F5},
{ 0x6A4F , 0x98F6},
{ 0x6A51 , 0x98F7},
{ 0x6A52 , 0x98F8},
{ 0x6A53 , 0x98F9},
{ 0x6A54 , 0x98FA},
{ 0x6A55 , 0x98FB},
{ 0x6A56 , 0x98FC},
{ 0x6A57 , 0x98FD},
{ 0x6A5A , 0x98FE},
{ 0x6A5C , 0x9940},
{ 0x6A5D , 0x9941},
{ 0x6A5E , 0x9942},
{ 0x6A5F , 0x9943},
{ 0x6A60 , 0x9944},
{ 0x6A62 , 0x9945},
{ 0x6A63 , 0x9946},
{ 0x6A64 , 0x9947},
{ 0x6A66 , 0x9948},
{ 0x6A67 , 0x9949},
{ 0x6A68 , 0x994A},
{ 0x6A69 , 0x994B},
{ 0x6A6A , 0x994C},
{ 0x6A6B , 0x994D},
{ 0x6A6C , 0x994E},
{ 0x6A6D , 0x994F},
{ 0x6A6E , 0x9950},
{ 0x6A6F , 0x9951},
{ 0x6A70 , 0x9952},
{ 0x6A72 , 0x9953},
{ 0x6A73 , 0x9954},
{ 0x6A74 , 0x9955},
{ 0x6A75 , 0x9956},
{ 0x6A76 , 0x9957},
{ 0x6A77 , 0x9958},
{ 0x6A78 , 0x9959},
{ 0x6A7A , 0x995A},
{ 0x6A7B , 0x995B},
{ 0x6A7D , 0x995C},
{ 0x6A7E , 0x995D},
{ 0x6A7F , 0x995E},
{ 0x6A81 , 0x995F},
{ 0x6A82 , 0x9960},
{ 0x6A83 , 0x9961},
{ 0x6A85 , 0x9962},
{ 0x6A86 , 0x9963},
{ 0x6A87 , 0x9964},
{ 0x6A88 , 0x9965},
{ 0x6A89 , 0x9966},
{ 0x6A8A , 0x9967},
{ 0x6A8B , 0x9968},
{ 0x6A8C , 0x9969},
{ 0x6A8D , 0x996A},
{ 0x6A8F , 0x996B},
{ 0x6A92 , 0x996C},
{ 0x6A93 , 0x996D},
{ 0x6A94 , 0x996E},
{ 0x6A95 , 0x996F},
{ 0x6A96 , 0x9970},
{ 0x6A98 , 0x9971},
{ 0x6A99 , 0x9972},
{ 0x6A9A , 0x9973},
{ 0x6A9B , 0x9974},
{ 0x6A9C , 0x9975},
{ 0x6A9D , 0x9976},
{ 0x6A9E , 0x9977},
{ 0x6A9F , 0x9978},
{ 0x6AA1 , 0x9979},
{ 0x6AA2 , 0x997A},
{ 0x6AA3 , 0x997B},
{ 0x6AA4 , 0x997C},
{ 0x6AA5 , 0x997D},
{ 0x6AA6 , 0x997E},
{ 0x6AA7 , 0x9980},
{ 0x6AA8 , 0x9981},
{ 0x6AAA , 0x9982},
{ 0x6AAD , 0x9983},
{ 0x6AAE , 0x9984},
{ 0x6AAF , 0x9985},
{ 0x6AB0 , 0x9986},
{ 0x6AB1 , 0x9987},
{ 0x6AB2 , 0x9988},
{ 0x6AB3 , 0x9989},
{ 0x6AB4 , 0x998A},
{ 0x6AB5 , 0x998B},
{ 0x6AB6 , 0x998C},
{ 0x6AB7 , 0x998D},
{ 0x6AB8 , 0x998E},
{ 0x6AB9 , 0x998F},
{ 0x6ABA , 0x9990},
{ 0x6ABB , 0x9991},
{ 0x6ABC , 0x9992},
{ 0x6ABD , 0x9993},
{ 0x6ABE , 0x9994},
{ 0x6ABF , 0x9995},
{ 0x6AC0 , 0x9996},
{ 0x6AC1 , 0x9997},
{ 0x6AC2 , 0x9998},
{ 0x6AC3 , 0x9999},
{ 0x6AC4 , 0x999A},
{ 0x6AC5 , 0x999B},
{ 0x6AC6 , 0x999C},
{ 0x6AC7 , 0x999D},
{ 0x6AC8 , 0x999E},
{ 0x6AC9 , 0x999F},
{ 0x6ACA , 0x99A0},
{ 0x6ACB , 0x99A1},
{ 0x6ACC , 0x99A2},
{ 0x6ACD , 0x99A3},
{ 0x6ACE , 0x99A4},
{ 0x6ACF , 0x99A5},
{ 0x6AD0 , 0x99A6},
{ 0x6AD1 , 0x99A7},
{ 0x6AD2 , 0x99A8},
{ 0x6AD3 , 0x99A9},
{ 0x6AD4 , 0x99AA},
{ 0x6AD5 , 0x99AB},
{ 0x6AD6 , 0x99AC},
{ 0x6AD7 , 0x99AD},
{ 0x6AD8 , 0x99AE},
{ 0x6AD9 , 0x99AF},
{ 0x6ADA , 0x99B0},
{ 0x6ADB , 0x99B1},
{ 0x6ADC , 0x99B2},
{ 0x6ADD , 0x99B3},
{ 0x6ADE , 0x99B4},
{ 0x6ADF , 0x99B5},
{ 0x6AE0 , 0x99B6},
{ 0x6AE1 , 0x99B7},
{ 0x6AE2 , 0x99B8},
{ 0x6AE3 , 0x99B9},
{ 0x6AE4 , 0x99BA},
{ 0x6AE5 , 0x99BB},
{ 0x6AE6 , 0x99BC},
{ 0x6AE7 , 0x99BD},
{ 0x6AE8 , 0x99BE},
{ 0x6AE9 , 0x99BF},
{ 0x6AEA , 0x99C0},
{ 0x6AEB , 0x99C1},
{ 0x6AEC , 0x99C2},
{ 0x6AED , 0x99C3},
{ 0x6AEE , 0x99C4},
{ 0x6AEF , 0x99C5},
{ 0x6AF0 , 0x99C6},
{ 0x6AF1 , 0x99C7},
{ 0x6AF2 , 0x99C8},
{ 0x6AF3 , 0x99C9},
{ 0x6AF4 , 0x99CA},
{ 0x6AF5 , 0x99CB},
{ 0x6AF6 , 0x99CC},
{ 0x6AF7 , 0x99CD},
{ 0x6AF8 , 0x99CE},
{ 0x6AF9 , 0x99CF},
{ 0x6AFA , 0x99D0},
{ 0x6AFB , 0x99D1},
{ 0x6AFC , 0x99D2},
{ 0x6AFD , 0x99D3},
{ 0x6AFE , 0x99D4},
{ 0x6AFF , 0x99D5},
{ 0x6B00 , 0x99D6},
{ 0x6B01 , 0x99D7},
{ 0x6B02 , 0x99D8},
{ 0x6B03 , 0x99D9},
{ 0x6B04 , 0x99DA},
{ 0x6B05 , 0x99DB},
{ 0x6B06 , 0x99DC},
{ 0x6B07 , 0x99DD},
{ 0x6B08 , 0x99DE},
{ 0x6B09 , 0x99DF},
{ 0x6B0A , 0x99E0},
{ 0x6B0B , 0x99E1},
{ 0x6B0C , 0x99E2},
{ 0x6B0D , 0x99E3},
{ 0x6B0E , 0x99E4},
{ 0x6B0F , 0x99E5},
{ 0x6B10 , 0x99E6},
{ 0x6B11 , 0x99E7},
{ 0x6B12 , 0x99E8},
{ 0x6B13 , 0x99E9},
{ 0x6B14 , 0x99EA},
{ 0x6B15 , 0x99EB},
{ 0x6B16 , 0x99EC},
{ 0x6B17 , 0x99ED},
{ 0x6B18 , 0x99EE},
{ 0x6B19 , 0x99EF},
{ 0x6B1A , 0x99F0},
{ 0x6B1B , 0x99F1},
{ 0x6B1C , 0x99F2},
{ 0x6B1D , 0x99F3},
{ 0x6B1E , 0x99F4},
{ 0x6B1F , 0x99F5},
{ 0x6B25 , 0x99F6},
{ 0x6B26 , 0x99F7},
{ 0x6B28 , 0x99F8},
{ 0x6B29 , 0x99F9},
{ 0x6B2A , 0x99FA},
{ 0x6B2B , 0x99FB},
{ 0x6B2C , 0x99FC},
{ 0x6B2D , 0x99FD},
{ 0x6B2E , 0x99FE},
{ 0x6B2F , 0x9A40},
{ 0x6B30 , 0x9A41},
{ 0x6B31 , 0x9A42},
{ 0x6B33 , 0x9A43},
{ 0x6B34 , 0x9A44},
{ 0x6B35 , 0x9A45},
{ 0x6B36 , 0x9A46},
{ 0x6B38 , 0x9A47},
{ 0x6B3B , 0x9A48},
{ 0x6B3C , 0x9A49},
{ 0x6B3D , 0x9A4A},
{ 0x6B3F , 0x9A4B},
{ 0x6B40 , 0x9A4C},
{ 0x6B41 , 0x9A4D},
{ 0x6B42 , 0x9A4E},
{ 0x6B44 , 0x9A4F},
{ 0x6B45 , 0x9A50},
{ 0x6B48 , 0x9A51},
{ 0x6B4A , 0x9A52},
{ 0x6B4B , 0x9A53},
{ 0x6B4D , 0x9A54},
{ 0x6B4E , 0x9A55},
{ 0x6B4F , 0x9A56},
{ 0x6B50 , 0x9A57},
{ 0x6B51 , 0x9A58},
{ 0x6B52 , 0x9A59},
{ 0x6B53 , 0x9A5A},
{ 0x6B54 , 0x9A5B},
{ 0x6B55 , 0x9A5C},
{ 0x6B56 , 0x9A5D},
{ 0x6B57 , 0x9A5E},
{ 0x6B58 , 0x9A5F},
{ 0x6B5A , 0x9A60},
{ 0x6B5B , 0x9A61},
{ 0x6B5C , 0x9A62},
{ 0x6B5D , 0x9A63},
{ 0x6B5E , 0x9A64},
{ 0x6B5F , 0x9A65},
{ 0x6B60 , 0x9A66},
{ 0x6B61 , 0x9A67},
{ 0x6B68 , 0x9A68},
{ 0x6B69 , 0x9A69},
{ 0x6B6B , 0x9A6A},
{ 0x6B6C , 0x9A6B},
{ 0x6B6D , 0x9A6C},
{ 0x6B6E , 0x9A6D},
{ 0x6B6F , 0x9A6E},
{ 0x6B70 , 0x9A6F},
{ 0x6B71 , 0x9A70},
{ 0x6B72 , 0x9A71},
{ 0x6B73 , 0x9A72},
{ 0x6B74 , 0x9A73},
{ 0x6B75 , 0x9A74},
{ 0x6B76 , 0x9A75},
{ 0x6B77 , 0x9A76},
{ 0x6B78 , 0x9A77},
{ 0x6B7A , 0x9A78},
{ 0x6B7D , 0x9A79},
{ 0x6B7E , 0x9A7A},
{ 0x6B7F , 0x9A7B},
{ 0x6B80 , 0x9A7C},
{ 0x6B85 , 0x9A7D},
{ 0x6B88 , 0x9A7E},
{ 0x6B8C , 0x9A80},
{ 0x6B8E , 0x9A81},
{ 0x6B8F , 0x9A82},
{ 0x6B90 , 0x9A83},
{ 0x6B91 , 0x9A84},
{ 0x6B94 , 0x9A85},
{ 0x6B95 , 0x9A86},
{ 0x6B97 , 0x9A87},
{ 0x6B98 , 0x9A88},
{ 0x6B99 , 0x9A89},
{ 0x6B9C , 0x9A8A},
{ 0x6B9D , 0x9A8B},
{ 0x6B9E , 0x9A8C},
{ 0x6B9F , 0x9A8D},
{ 0x6BA0 , 0x9A8E},
{ 0x6BA2 , 0x9A8F},
{ 0x6BA3 , 0x9A90},
{ 0x6BA4 , 0x9A91},
{ 0x6BA5 , 0x9A92},
{ 0x6BA6 , 0x9A93},
{ 0x6BA7 , 0x9A94},
{ 0x6BA8 , 0x9A95},
{ 0x6BA9 , 0x9A96},
{ 0x6BAB , 0x9A97},
{ 0x6BAC , 0x9A98},
{ 0x6BAD , 0x9A99},
{ 0x6BAE , 0x9A9A},
{ 0x6BAF , 0x9A9B},
{ 0x6BB0 , 0x9A9C},
{ 0x6BB1 , 0x9A9D},
{ 0x6BB2 , 0x9A9E},
{ 0x6BB6 , 0x9A9F},
{ 0x6BB8 , 0x9AA0},
{ 0x6BB9 , 0x9AA1},
{ 0x6BBA , 0x9AA2},
{ 0x6BBB , 0x9AA3},
{ 0x6BBC , 0x9AA4},
{ 0x6BBD , 0x9AA5},
{ 0x6BBE , 0x9AA6},
{ 0x6BC0 , 0x9AA7},
{ 0x6BC3 , 0x9AA8},
{ 0x6BC4 , 0x9AA9},
{ 0x6BC6 , 0x9AAA},
{ 0x6BC7 , 0x9AAB},
{ 0x6BC8 , 0x9AAC},
{ 0x6BC9 , 0x9AAD},
{ 0x6BCA , 0x9AAE},
{ 0x6BCC , 0x9AAF},
{ 0x6BCE , 0x9AB0},
{ 0x6BD0 , 0x9AB1},
{ 0x6BD1 , 0x9AB2},
{ 0x6BD8 , 0x9AB3},
{ 0x6BDA , 0x9AB4},
{ 0x6BDC , 0x9AB5},
{ 0x6BDD , 0x9AB6},
{ 0x6BDE , 0x9AB7},
{ 0x6BDF , 0x9AB8},
{ 0x6BE0 , 0x9AB9},
{ 0x6BE2 , 0x9ABA},
{ 0x6BE3 , 0x9ABB},
{ 0x6BE4 , 0x9ABC},
{ 0x6BE5 , 0x9ABD},
{ 0x6BE6 , 0x9ABE},
{ 0x6BE7 , 0x9ABF},
{ 0x6BE8 , 0x9AC0},
{ 0x6BE9 , 0x9AC1},
{ 0x6BEC , 0x9AC2},
{ 0x6BED , 0x9AC3},
{ 0x6BEE , 0x9AC4},
{ 0x6BF0 , 0x9AC5},
{ 0x6BF1 , 0x9AC6},
{ 0x6BF2 , 0x9AC7},
{ 0x6BF4 , 0x9AC8},
{ 0x6BF6 , 0x9AC9},
{ 0x6BF7 , 0x9ACA},
{ 0x6BF8 , 0x9ACB},
{ 0x6BFA , 0x9ACC},
{ 0x6BFB , 0x9ACD},
{ 0x6BFC , 0x9ACE},
{ 0x6BFE , 0x9ACF},
{ 0x6BFF , 0x9AD0},
{ 0x6C00 , 0x9AD1},
{ 0x6C01 , 0x9AD2},
{ 0x6C02 , 0x9AD3},
{ 0x6C03 , 0x9AD4},
{ 0x6C04 , 0x9AD5},
{ 0x6C08 , 0x9AD6},
{ 0x6C09 , 0x9AD7},
{ 0x6C0A , 0x9AD8},
{ 0x6C0B , 0x9AD9},
{ 0x6C0C , 0x9ADA},
{ 0x6C0E , 0x9ADB},
{ 0x6C12 , 0x9ADC},
{ 0x6C17 , 0x9ADD},
{ 0x6C1C , 0x9ADE},
{ 0x6C1D , 0x9ADF},
{ 0x6C1E , 0x9AE0},
{ 0x6C20 , 0x9AE1},
{ 0x6C23 , 0x9AE2},
{ 0x6C25 , 0x9AE3},
{ 0x6C2B , 0x9AE4},
{ 0x6C2C , 0x9AE5},
{ 0x6C2D , 0x9AE6},
{ 0x6C31 , 0x9AE7},
{ 0x6C33 , 0x9AE8},
{ 0x6C36 , 0x9AE9},
{ 0x6C37 , 0x9AEA},
{ 0x6C39 , 0x9AEB},
{ 0x6C3A , 0x9AEC},
{ 0x6C3B , 0x9AED},
{ 0x6C3C , 0x9AEE},
{ 0x6C3E , 0x9AEF},
{ 0x6C3F , 0x9AF0},
{ 0x6C43 , 0x9AF1},
{ 0x6C44 , 0x9AF2},
{ 0x6C45 , 0x9AF3},
{ 0x6C48 , 0x9AF4},
{ 0x6C4B , 0x9AF5},
{ 0x6C4C , 0x9AF6},
{ 0x6C4D , 0x9AF7},
{ 0x6C4E , 0x9AF8},
{ 0x6C4F , 0x9AF9},
{ 0x6C51 , 0x9AFA},
{ 0x6C52 , 0x9AFB},
{ 0x6C53 , 0x9AFC},
{ 0x6C56 , 0x9AFD},
{ 0x6C58 , 0x9AFE},
{ 0x6C59 , 0x9B40},
{ 0x6C5A , 0x9B41},
{ 0x6C62 , 0x9B42},
{ 0x6C63 , 0x9B43},
{ 0x6C65 , 0x9B44},
{ 0x6C66 , 0x9B45},
{ 0x6C67 , 0x9B46},
{ 0x6C6B , 0x9B47},
{ 0x6C6C , 0x9B48},
{ 0x6C6D , 0x9B49},
{ 0x6C6E , 0x9B4A},
{ 0x6C6F , 0x9B4B},
{ 0x6C71 , 0x9B4C},
{ 0x6C73 , 0x9B4D},
{ 0x6C75 , 0x9B4E},
{ 0x6C77 , 0x9B4F},
{ 0x6C78 , 0x9B50},
{ 0x6C7A , 0x9B51},
{ 0x6C7B , 0x9B52},
{ 0x6C7C , 0x9B53},
{ 0x6C7F , 0x9B54},
{ 0x6C80 , 0x9B55},
{ 0x6C84 , 0x9B56},
{ 0x6C87 , 0x9B57},
{ 0x6C8A , 0x9B58},
{ 0x6C8B , 0x9B59},
{ 0x6C8D , 0x9B5A},
{ 0x6C8E , 0x9B5B},
{ 0x6C91 , 0x9B5C},
{ 0x6C92 , 0x9B5D},
{ 0x6C95 , 0x9B5E},
{ 0x6C96 , 0x9B5F},
{ 0x6C97 , 0x9B60},
{ 0x6C98 , 0x9B61},
{ 0x6C9A , 0x9B62},
{ 0x6C9C , 0x9B63},
{ 0x6C9D , 0x9B64},
{ 0x6C9E , 0x9B65},
{ 0x6CA0 , 0x9B66},
{ 0x6CA2 , 0x9B67},
{ 0x6CA8 , 0x9B68},
{ 0x6CAC , 0x9B69},
{ 0x6CAF , 0x9B6A},
{ 0x6CB0 , 0x9B6B},
{ 0x6CB4 , 0x9B6C},
{ 0x6CB5 , 0x9B6D},
{ 0x6CB6 , 0x9B6E},
{ 0x6CB7 , 0x9B6F},
{ 0x6CBA , 0x9B70},
{ 0x6CC0 , 0x9B71},
{ 0x6CC1 , 0x9B72},
{ 0x6CC2 , 0x9B73},
{ 0x6CC3 , 0x9B74},
{ 0x6CC6 , 0x9B75},
{ 0x6CC7 , 0x9B76},
{ 0x6CC8 , 0x9B77},
{ 0x6CCB , 0x9B78},
{ 0x6CCD , 0x9B79},
{ 0x6CCE , 0x9B7A},
{ 0x6CCF , 0x9B7B},
{ 0x6CD1 , 0x9B7C},
{ 0x6CD2 , 0x9B7D},
{ 0x6CD8 , 0x9B7E},
{ 0x6CD9 , 0x9B80},
{ 0x6CDA , 0x9B81},
{ 0x6CDC , 0x9B82},
{ 0x6CDD , 0x9B83},
{ 0x6CDF , 0x9B84},
{ 0x6CE4 , 0x9B85},
{ 0x6CE6 , 0x9B86},
{ 0x6CE7 , 0x9B87},
{ 0x6CE9 , 0x9B88},
{ 0x6CEC , 0x9B89},
{ 0x6CED , 0x9B8A},
{ 0x6CF2 , 0x9B8B},
{ 0x6CF4 , 0x9B8C},
{ 0x6CF9 , 0x9B8D},
{ 0x6CFF , 0x9B8E},
{ 0x6D00 , 0x9B8F},
{ 0x6D02 , 0x9B90},
{ 0x6D03 , 0x9B91},
{ 0x6D05 , 0x9B92},
{ 0x6D06 , 0x9B93},
{ 0x6D08 , 0x9B94},
{ 0x6D09 , 0x9B95},
{ 0x6D0A , 0x9B96},
{ 0x6D0D , 0x9B97},
{ 0x6D0F , 0x9B98},
{ 0x6D10 , 0x9B99},
{ 0x6D11 , 0x9B9A},
{ 0x6D13 , 0x9B9B},
{ 0x6D14 , 0x9B9C},
{ 0x6D15 , 0x9B9D},
{ 0x6D16 , 0x9B9E},
{ 0x6D18 , 0x9B9F},
{ 0x6D1C , 0x9BA0},
{ 0x6D1D , 0x9BA1},
{ 0x6D1F , 0x9BA2},
{ 0x6D20 , 0x9BA3},
{ 0x6D21 , 0x9BA4},
{ 0x6D22 , 0x9BA5},
{ 0x6D23 , 0x9BA6},
{ 0x6D24 , 0x9BA7},
{ 0x6D26 , 0x9BA8},
{ 0x6D28 , 0x9BA9},
{ 0x6D29 , 0x9BAA},
{ 0x6D2C , 0x9BAB},
{ 0x6D2D , 0x9BAC},
{ 0x6D2F , 0x9BAD},
{ 0x6D30 , 0x9BAE},
{ 0x6D34 , 0x9BAF},
{ 0x6D36 , 0x9BB0},
{ 0x6D37 , 0x9BB1},
{ 0x6D38 , 0x9BB2},
{ 0x6D3A , 0x9BB3},
{ 0x6D3F , 0x9BB4},
{ 0x6D40 , 0x9BB5},
{ 0x6D42 , 0x9BB6},
{ 0x6D44 , 0x9BB7},
{ 0x6D49 , 0x9BB8},
{ 0x6D4C , 0x9BB9},
{ 0x6D50 , 0x9BBA},
{ 0x6D55 , 0x9BBB},
{ 0x6D56 , 0x9BBC},
{ 0x6D57 , 0x9BBD},
{ 0x6D58 , 0x9BBE},
{ 0x6D5B , 0x9BBF},
{ 0x6D5D , 0x9BC0},
{ 0x6D5F , 0x9BC1},
{ 0x6D61 , 0x9BC2},
{ 0x6D62 , 0x9BC3},
{ 0x6D64 , 0x9BC4},
{ 0x6D65 , 0x9BC5},
{ 0x6D67 , 0x9BC6},
{ 0x6D68 , 0x9BC7},
{ 0x6D6B , 0x9BC8},
{ 0x6D6C , 0x9BC9},
{ 0x6D6D , 0x9BCA},
{ 0x6D70 , 0x9BCB},
{ 0x6D71 , 0x9BCC},
{ 0x6D72 , 0x9BCD},
{ 0x6D73 , 0x9BCE},
{ 0x6D75 , 0x9BCF},
{ 0x6D76 , 0x9BD0},
{ 0x6D79 , 0x9BD1},
{ 0x6D7A , 0x9BD2},
{ 0x6D7B , 0x9BD3},
{ 0x6D7D , 0x9BD4},
{ 0x6D7E , 0x9BD5},
{ 0x6D7F , 0x9BD6},
{ 0x6D80 , 0x9BD7},
{ 0x6D81 , 0x9BD8},
{ 0x6D83 , 0x9BD9},
{ 0x6D84 , 0x9BDA},
{ 0x6D86 , 0x9BDB},
{ 0x6D87 , 0x9BDC},
{ 0x6D8A , 0x9BDD},
{ 0x6D8B , 0x9BDE},
{ 0x6D8D , 0x9BDF},
{ 0x6D8F , 0x9BE0},
{ 0x6D90 , 0x9BE1},
{ 0x6D92 , 0x9BE2},
{ 0x6D96 , 0x9BE3},
{ 0x6D97 , 0x9BE4},
{ 0x6D98 , 0x9BE5},
{ 0x6D99 , 0x9BE6},
{ 0x6D9A , 0x9BE7},
{ 0x6D9C , 0x9BE8},
{ 0x6DA2 , 0x9BE9},
{ 0x6DA5 , 0x9BEA},
{ 0x6DAC , 0x9BEB},
{ 0x6DAD , 0x9BEC},
{ 0x6DB0 , 0x9BED},
{ 0x6DB1 , 0x9BEE},
{ 0x6DB3 , 0x9BEF},
{ 0x6DB4 , 0x9BF0},
{ 0x6DB6 , 0x9BF1},
{ 0x6DB7 , 0x9BF2},
{ 0x6DB9 , 0x9BF3},
{ 0x6DBA , 0x9BF4},
{ 0x6DBB , 0x9BF5},
{ 0x6DBC , 0x9BF6},
{ 0x6DBD , 0x9BF7},
{ 0x6DBE , 0x9BF8},
{ 0x6DC1 , 0x9BF9},
{ 0x6DC2 , 0x9BFA},
{ 0x6DC3 , 0x9BFB},
{ 0x6DC8 , 0x9BFC},
{ 0x6DC9 , 0x9BFD},
{ 0x6DCA , 0x9BFE},
{ 0x6DCD , 0x9C40},
{ 0x6DCE , 0x9C41},
{ 0x6DCF , 0x9C42},
{ 0x6DD0 , 0x9C43},
{ 0x6DD2 , 0x9C44},
{ 0x6DD3 , 0x9C45},
{ 0x6DD4 , 0x9C46},
{ 0x6DD5 , 0x9C47},
{ 0x6DD7 , 0x9C48},
{ 0x6DDA , 0x9C49},
{ 0x6DDB , 0x9C4A},
{ 0x6DDC , 0x9C4B},
{ 0x6DDF , 0x9C4C},
{ 0x6DE2 , 0x9C4D},
{ 0x6DE3 , 0x9C4E},
{ 0x6DE5 , 0x9C4F},
{ 0x6DE7 , 0x9C50},
{ 0x6DE8 , 0x9C51},
{ 0x6DE9 , 0x9C52},
{ 0x6DEA , 0x9C53},
{ 0x6DED , 0x9C54},
{ 0x6DEF , 0x9C55},
{ 0x6DF0 , 0x9C56},
{ 0x6DF2 , 0x9C57},
{ 0x6DF4 , 0x9C58},
{ 0x6DF5 , 0x9C59},
{ 0x6DF6 , 0x9C5A},
{ 0x6DF8 , 0x9C5B},
{ 0x6DFA , 0x9C5C},
{ 0x6DFD , 0x9C5D},
{ 0x6DFE , 0x9C5E},
{ 0x6DFF , 0x9C5F},
{ 0x6E00 , 0x9C60},
{ 0x6E01 , 0x9C61},
{ 0x6E02 , 0x9C62},
{ 0x6E03 , 0x9C63},
{ 0x6E04 , 0x9C64},
{ 0x6E06 , 0x9C65},
{ 0x6E07 , 0x9C66},
{ 0x6E08 , 0x9C67},
{ 0x6E09 , 0x9C68},
{ 0x6E0B , 0x9C69},
{ 0x6E0F , 0x9C6A},
{ 0x6E12 , 0x9C6B},
{ 0x6E13 , 0x9C6C},
{ 0x6E15 , 0x9C6D},
{ 0x6E18 , 0x9C6E},
{ 0x6E19 , 0x9C6F},
{ 0x6E1B , 0x9C70},
{ 0x6E1C , 0x9C71},
{ 0x6E1E , 0x9C72},
{ 0x6E1F , 0x9C73},
{ 0x6E22 , 0x9C74},
{ 0x6E26 , 0x9C75},
{ 0x6E27 , 0x9C76},
{ 0x6E28 , 0x9C77},
{ 0x6E2A , 0x9C78},
{ 0x6E2C , 0x9C79},
{ 0x6E2E , 0x9C7A},
{ 0x6E30 , 0x9C7B},
{ 0x6E31 , 0x9C7C},
{ 0x6E33 , 0x9C7D},
{ 0x6E35 , 0x9C7E},
{ 0x6E36 , 0x9C80},
{ 0x6E37 , 0x9C81},
{ 0x6E39 , 0x9C82},
{ 0x6E3B , 0x9C83},
{ 0x6E3C , 0x9C84},
{ 0x6E3D , 0x9C85},
{ 0x6E3E , 0x9C86},
{ 0x6E3F , 0x9C87},
{ 0x6E40 , 0x9C88},
{ 0x6E41 , 0x9C89},
{ 0x6E42 , 0x9C8A},
{ 0x6E45 , 0x9C8B},
{ 0x6E46 , 0x9C8C},
{ 0x6E47 , 0x9C8D},
{ 0x6E48 , 0x9C8E},
{ 0x6E49 , 0x9C8F},
{ 0x6E4A , 0x9C90},
{ 0x6E4B , 0x9C91},
{ 0x6E4C , 0x9C92},
{ 0x6E4F , 0x9C93},
{ 0x6E50 , 0x9C94},
{ 0x6E51 , 0x9C95},
{ 0x6E52 , 0x9C96},
{ 0x6E55 , 0x9C97},
{ 0x6E57 , 0x9C98},
{ 0x6E59 , 0x9C99},
{ 0x6E5A , 0x9C9A},
{ 0x6E5C , 0x9C9B},
{ 0x6E5D , 0x9C9C},
{ 0x6E5E , 0x9C9D},
{ 0x6E60 , 0x9C9E},
{ 0x6E61 , 0x9C9F},
{ 0x6E62 , 0x9CA0},
{ 0x6E63 , 0x9CA1},
{ 0x6E64 , 0x9CA2},
{ 0x6E65 , 0x9CA3},
{ 0x6E66 , 0x9CA4},
{ 0x6E67 , 0x9CA5},
{ 0x6E68 , 0x9CA6},
{ 0x6E69 , 0x9CA7},
{ 0x6E6A , 0x9CA8},
{ 0x6E6C , 0x9CA9},
{ 0x6E6D , 0x9CAA},
{ 0x6E6F , 0x9CAB},
{ 0x6E70 , 0x9CAC},
{ 0x6E71 , 0x9CAD},
{ 0x6E72 , 0x9CAE},
{ 0x6E73 , 0x9CAF},
{ 0x6E74 , 0x9CB0},
{ 0x6E75 , 0x9CB1},
{ 0x6E76 , 0x9CB2},
{ 0x6E77 , 0x9CB3},
{ 0x6E78 , 0x9CB4},
{ 0x6E79 , 0x9CB5},
{ 0x6E7A , 0x9CB6},
{ 0x6E7B , 0x9CB7},
{ 0x6E7C , 0x9CB8},
{ 0x6E7D , 0x9CB9},
{ 0x6E80 , 0x9CBA},
{ 0x6E81 , 0x9CBB},
{ 0x6E82 , 0x9CBC},
{ 0x6E84 , 0x9CBD},
{ 0x6E87 , 0x9CBE},
{ 0x6E88 , 0x9CBF},
{ 0x6E8A , 0x9CC0},
{ 0x6E8B , 0x9CC1},
{ 0x6E8C , 0x9CC2},
{ 0x6E8D , 0x9CC3},
{ 0x6E8E , 0x9CC4},
{ 0x6E91 , 0x9CC5},
{ 0x6E92 , 0x9CC6},
{ 0x6E93 , 0x9CC7},
{ 0x6E94 , 0x9CC8},
{ 0x6E95 , 0x9CC9},
{ 0x6E96 , 0x9CCA},
{ 0x6E97 , 0x9CCB},
{ 0x6E99 , 0x9CCC},
{ 0x6E9A , 0x9CCD},
{ 0x6E9B , 0x9CCE},
{ 0x6E9D , 0x9CCF},
{ 0x6E9E , 0x9CD0},
{ 0x6EA0 , 0x9CD1},
{ 0x6EA1 , 0x9CD2},
{ 0x6EA3 , 0x9CD3},
{ 0x6EA4 , 0x9CD4},
{ 0x6EA6 , 0x9CD5},
{ 0x6EA8 , 0x9CD6},
{ 0x6EA9 , 0x9CD7},
{ 0x6EAB , 0x9CD8},
{ 0x6EAC , 0x9CD9},
{ 0x6EAD , 0x9CDA},
{ 0x6EAE , 0x9CDB},
{ 0x6EB0 , 0x9CDC},
{ 0x6EB3 , 0x9CDD},
{ 0x6EB5 , 0x9CDE},
{ 0x6EB8 , 0x9CDF},
{ 0x6EB9 , 0x9CE0},
{ 0x6EBC , 0x9CE1},
{ 0x6EBE , 0x9CE2},
{ 0x6EBF , 0x9CE3},
{ 0x6EC0 , 0x9CE4},
{ 0x6EC3 , 0x9CE5},
{ 0x6EC4 , 0x9CE6},
{ 0x6EC5 , 0x9CE7},
{ 0x6EC6 , 0x9CE8},
{ 0x6EC8 , 0x9CE9},
{ 0x6EC9 , 0x9CEA},
{ 0x6ECA , 0x9CEB},
{ 0x6ECC , 0x9CEC},
{ 0x6ECD , 0x9CED},
{ 0x6ECE , 0x9CEE},
{ 0x6ED0 , 0x9CEF},
{ 0x6ED2 , 0x9CF0},
{ 0x6ED6 , 0x9CF1},
{ 0x6ED8 , 0x9CF2},
{ 0x6ED9 , 0x9CF3},
{ 0x6EDB , 0x9CF4},
{ 0x6EDC , 0x9CF5},
{ 0x6EDD , 0x9CF6},
{ 0x6EE3 , 0x9CF7},
{ 0x6EE7 , 0x9CF8},
{ 0x6EEA , 0x9CF9},
{ 0x6EEB , 0x9CFA},
{ 0x6EEC , 0x9CFB},
{ 0x6EED , 0x9CFC},
{ 0x6EEE , 0x9CFD},
{ 0x6EEF , 0x9CFE},
{ 0x6EF0 , 0x9D40},
{ 0x6EF1 , 0x9D41},
{ 0x6EF2 , 0x9D42},
{ 0x6EF3 , 0x9D43},
{ 0x6EF5 , 0x9D44},
{ 0x6EF6 , 0x9D45},
{ 0x6EF7 , 0x9D46},
{ 0x6EF8 , 0x9D47},
{ 0x6EFA , 0x9D48},
{ 0x6EFB , 0x9D49},
{ 0x6EFC , 0x9D4A},
{ 0x6EFD , 0x9D4B},
{ 0x6EFE , 0x9D4C},
{ 0x6EFF , 0x9D4D},
{ 0x6F00 , 0x9D4E},
{ 0x6F01 , 0x9D4F},
{ 0x6F03 , 0x9D50},
{ 0x6F04 , 0x9D51},
{ 0x6F05 , 0x9D52},
{ 0x6F07 , 0x9D53},
{ 0x6F08 , 0x9D54},
{ 0x6F0A , 0x9D55},
{ 0x6F0B , 0x9D56},
{ 0x6F0C , 0x9D57},
{ 0x6F0D , 0x9D58},
{ 0x6F0E , 0x9D59},
{ 0x6F10 , 0x9D5A},
{ 0x6F11 , 0x9D5B},
{ 0x6F12 , 0x9D5C},
{ 0x6F16 , 0x9D5D},
{ 0x6F17 , 0x9D5E},
{ 0x6F18 , 0x9D5F},
{ 0x6F19 , 0x9D60},
{ 0x6F1A , 0x9D61},
{ 0x6F1B , 0x9D62},
{ 0x6F1C , 0x9D63},
{ 0x6F1D , 0x9D64},
{ 0x6F1E , 0x9D65},
{ 0x6F1F , 0x9D66},
{ 0x6F21 , 0x9D67},
{ 0x6F22 , 0x9D68},
{ 0x6F23 , 0x9D69},
{ 0x6F25 , 0x9D6A},
{ 0x6F26 , 0x9D6B},
{ 0x6F27 , 0x9D6C},
{ 0x6F28 , 0x9D6D},
{ 0x6F2C , 0x9D6E},
{ 0x6F2E , 0x9D6F},
{ 0x6F30 , 0x9D70},
{ 0x6F32 , 0x9D71},
{ 0x6F34 , 0x9D72},
{ 0x6F35 , 0x9D73},
{ 0x6F37 , 0x9D74},
{ 0x6F38 , 0x9D75},
{ 0x6F39 , 0x9D76},
{ 0x6F3A , 0x9D77},
{ 0x6F3B , 0x9D78},
{ 0x6F3C , 0x9D79},
{ 0x6F3D , 0x9D7A},
{ 0x6F3F , 0x9D7B},
{ 0x6F40 , 0x9D7C},
{ 0x6F41 , 0x9D7D},
{ 0x6F42 , 0x9D7E},
{ 0x6F43 , 0x9D80},
{ 0x6F44 , 0x9D81},
{ 0x6F45 , 0x9D82},
{ 0x6F48 , 0x9D83},
{ 0x6F49 , 0x9D84},
{ 0x6F4A , 0x9D85},
{ 0x6F4C , 0x9D86},
{ 0x6F4E , 0x9D87},
{ 0x6F4F , 0x9D88},
{ 0x6F50 , 0x9D89},
{ 0x6F51 , 0x9D8A},
{ 0x6F52 , 0x9D8B},
{ 0x6F53 , 0x9D8C},
{ 0x6F54 , 0x9D8D},
{ 0x6F55 , 0x9D8E},
{ 0x6F56 , 0x9D8F},
{ 0x6F57 , 0x9D90},
{ 0x6F59 , 0x9D91},
{ 0x6F5A , 0x9D92},
{ 0x6F5B , 0x9D93},
{ 0x6F5D , 0x9D94},
{ 0x6F5F , 0x9D95},
{ 0x6F60 , 0x9D96},
{ 0x6F61 , 0x9D97},
{ 0x6F63 , 0x9D98},
{ 0x6F64 , 0x9D99},
{ 0x6F65 , 0x9D9A},
{ 0x6F67 , 0x9D9B},
{ 0x6F68 , 0x9D9C},
{ 0x6F69 , 0x9D9D},
{ 0x6F6A , 0x9D9E},
{ 0x6F6B , 0x9D9F},
{ 0x6F6C , 0x9DA0},
{ 0x6F6F , 0x9DA1},
{ 0x6F70 , 0x9DA2},
{ 0x6F71 , 0x9DA3},
{ 0x6F73 , 0x9DA4},
{ 0x6F75 , 0x9DA5},
{ 0x6F76 , 0x9DA6},
{ 0x6F77 , 0x9DA7},
{ 0x6F79 , 0x9DA8},
{ 0x6F7B , 0x9DA9},
{ 0x6F7D , 0x9DAA},
{ 0x6F7E , 0x9DAB},
{ 0x6F7F , 0x9DAC},
{ 0x6F80 , 0x9DAD},
{ 0x6F81 , 0x9DAE},
{ 0x6F82 , 0x9DAF},
{ 0x6F83 , 0x9DB0},
{ 0x6F85 , 0x9DB1},
{ 0x6F86 , 0x9DB2},
{ 0x6F87 , 0x9DB3},
{ 0x6F8A , 0x9DB4},
{ 0x6F8B , 0x9DB5},
{ 0x6F8F , 0x9DB6},
{ 0x6F90 , 0x9DB7},
{ 0x6F91 , 0x9DB8},
{ 0x6F92 , 0x9DB9},
{ 0x6F93 , 0x9DBA},
{ 0x6F94 , 0x9DBB},
{ 0x6F95 , 0x9DBC},
{ 0x6F96 , 0x9DBD},
{ 0x6F97 , 0x9DBE},
{ 0x6F98 , 0x9DBF},
{ 0x6F99 , 0x9DC0},
{ 0x6F9A , 0x9DC1},
{ 0x6F9B , 0x9DC2},
{ 0x6F9D , 0x9DC3},
{ 0x6F9E , 0x9DC4},
{ 0x6F9F , 0x9DC5},
{ 0x6FA0 , 0x9DC6},
{ 0x6FA2 , 0x9DC7},
{ 0x6FA3 , 0x9DC8},
{ 0x6FA4 , 0x9DC9},
{ 0x6FA5 , 0x9DCA},
{ 0x6FA6 , 0x9DCB},
{ 0x6FA8 , 0x9DCC},
{ 0x6FA9 , 0x9DCD},
{ 0x6FAA , 0x9DCE},
{ 0x6FAB , 0x9DCF},
{ 0x6FAC , 0x9DD0},
{ 0x6FAD , 0x9DD1},
{ 0x6FAE , 0x9DD2},
{ 0x6FAF , 0x9DD3},
{ 0x6FB0 , 0x9DD4},
{ 0x6FB1 , 0x9DD5},
{ 0x6FB2 , 0x9DD6},
{ 0x6FB4 , 0x9DD7},
{ 0x6FB5 , 0x9DD8},
{ 0x6FB7 , 0x9DD9},
{ 0x6FB8 , 0x9DDA},
{ 0x6FBA , 0x9DDB},
{ 0x6FBB , 0x9DDC},
{ 0x6FBC , 0x9DDD},
{ 0x6FBD , 0x9DDE},
{ 0x6FBE , 0x9DDF},
{ 0x6FBF , 0x9DE0},
{ 0x6FC1 , 0x9DE1},
{ 0x6FC3 , 0x9DE2},
{ 0x6FC4 , 0x9DE3},
{ 0x6FC5 , 0x9DE4},
{ 0x6FC6 , 0x9DE5},
{ 0x6FC7 , 0x9DE6},
{ 0x6FC8 , 0x9DE7},
{ 0x6FCA , 0x9DE8},
{ 0x6FCB , 0x9DE9},
{ 0x6FCC , 0x9DEA},
{ 0x6FCD , 0x9DEB},
{ 0x6FCE , 0x9DEC},
{ 0x6FCF , 0x9DED},
{ 0x6FD0 , 0x9DEE},
{ 0x6FD3 , 0x9DEF},
{ 0x6FD4 , 0x9DF0},
{ 0x6FD5 , 0x9DF1},
{ 0x6FD6 , 0x9DF2},
{ 0x6FD7 , 0x9DF3},
{ 0x6FD8 , 0x9DF4},
{ 0x6FD9 , 0x9DF5},
{ 0x6FDA , 0x9DF6},
{ 0x6FDB , 0x9DF7},
{ 0x6FDC , 0x9DF8},
{ 0x6FDD , 0x9DF9},
{ 0x6FDF , 0x9DFA},
{ 0x6FE2 , 0x9DFB},
{ 0x6FE3 , 0x9DFC},
{ 0x6FE4 , 0x9DFD},
{ 0x6FE5 , 0x9DFE},
{ 0x6FE6 , 0x9E40},
{ 0x6FE7 , 0x9E41},
{ 0x6FE8 , 0x9E42},
{ 0x6FE9 , 0x9E43},
{ 0x6FEA , 0x9E44},
{ 0x6FEB , 0x9E45},
{ 0x6FEC , 0x9E46},
{ 0x6FED , 0x9E47},
{ 0x6FF0 , 0x9E48},
{ 0x6FF1 , 0x9E49},
{ 0x6FF2 , 0x9E4A},
{ 0x6FF3 , 0x9E4B},
{ 0x6FF4 , 0x9E4C},
{ 0x6FF5 , 0x9E4D},
{ 0x6FF6 , 0x9E4E},
{ 0x6FF7 , 0x9E4F},
{ 0x6FF8 , 0x9E50},
{ 0x6FF9 , 0x9E51},
{ 0x6FFA , 0x9E52},
{ 0x6FFB , 0x9E53},
{ 0x6FFC , 0x9E54},
{ 0x6FFD , 0x9E55},
{ 0x6FFE , 0x9E56},
{ 0x6FFF , 0x9E57},
{ 0x7000 , 0x9E58},
{ 0x7001 , 0x9E59},
{ 0x7002 , 0x9E5A},
{ 0x7003 , 0x9E5B},
{ 0x7004 , 0x9E5C},
{ 0x7005 , 0x9E5D},
{ 0x7006 , 0x9E5E},
{ 0x7007 , 0x9E5F},
{ 0x7008 , 0x9E60},
{ 0x7009 , 0x9E61},
{ 0x700A , 0x9E62},
{ 0x700B , 0x9E63},
{ 0x700C , 0x9E64},
{ 0x700D , 0x9E65},
{ 0x700E , 0x9E66},
{ 0x700F , 0x9E67},
{ 0x7010 , 0x9E68},
{ 0x7012 , 0x9E69},
{ 0x7013 , 0x9E6A},
{ 0x7014 , 0x9E6B},
{ 0x7015 , 0x9E6C},
{ 0x7016 , 0x9E6D},
{ 0x7017 , 0x9E6E},
{ 0x7018 , 0x9E6F},
{ 0x7019 , 0x9E70},
{ 0x701C , 0x9E71},
{ 0x701D , 0x9E72},
{ 0x701E , 0x9E73},
{ 0x701F , 0x9E74},
{ 0x7020 , 0x9E75},
{ 0x7021 , 0x9E76},
{ 0x7022 , 0x9E77},
{ 0x7024 , 0x9E78},
{ 0x7025 , 0x9E79},
{ 0x7026 , 0x9E7A},
{ 0x7027 , 0x9E7B},
{ 0x7028 , 0x9E7C},
{ 0x7029 , 0x9E7D},
{ 0x702A , 0x9E7E},
{ 0x702B , 0x9E80},
{ 0x702C , 0x9E81},
{ 0x702D , 0x9E82},
{ 0x702E , 0x9E83},
{ 0x702F , 0x9E84},
{ 0x7030 , 0x9E85},
{ 0x7031 , 0x9E86},
{ 0x7032 , 0x9E87},
{ 0x7033 , 0x9E88},
{ 0x7034 , 0x9E89},
{ 0x7036 , 0x9E8A},
{ 0x7037 , 0x9E8B},
{ 0x7038 , 0x9E8C},
{ 0x703A , 0x9E8D},
{ 0x703B , 0x9E8E},
{ 0x703C , 0x9E8F},
{ 0x703D , 0x9E90},
{ 0x703E , 0x9E91},
{ 0x703F , 0x9E92},
{ 0x7040 , 0x9E93},
{ 0x7041 , 0x9E94},
{ 0x7042 , 0x9E95},
{ 0x7043 , 0x9E96},
{ 0x7044 , 0x9E97},
{ 0x7045 , 0x9E98},
{ 0x7046 , 0x9E99},
{ 0x7047 , 0x9E9A},
{ 0x7048 , 0x9E9B},
{ 0x7049 , 0x9E9C},
{ 0x704A , 0x9E9D},
{ 0x704B , 0x9E9E},
{ 0x704D , 0x9E9F},
{ 0x704E , 0x9EA0},
{ 0x7050 , 0x9EA1},
{ 0x7051 , 0x9EA2},
{ 0x7052 , 0x9EA3},
{ 0x7053 , 0x9EA4},
{ 0x7054 , 0x9EA5},
{ 0x7055 , 0x9EA6},
{ 0x7056 , 0x9EA7},
{ 0x7057 , 0x9EA8},
{ 0x7058 , 0x9EA9},
{ 0x7059 , 0x9EAA},
{ 0x705A , 0x9EAB},
{ 0x705B , 0x9EAC},
{ 0x705C , 0x9EAD},
{ 0x705D , 0x9EAE},
{ 0x705F , 0x9EAF},
{ 0x7060 , 0x9EB0},
{ 0x7061 , 0x9EB1},
{ 0x7062 , 0x9EB2},
{ 0x7063 , 0x9EB3},
{ 0x7064 , 0x9EB4},
{ 0x7065 , 0x9EB5},
{ 0x7066 , 0x9EB6},
{ 0x7067 , 0x9EB7},
{ 0x7068 , 0x9EB8},
{ 0x7069 , 0x9EB9},
{ 0x706A , 0x9EBA},
{ 0x706E , 0x9EBB},
{ 0x7071 , 0x9EBC},
{ 0x7072 , 0x9EBD},
{ 0x7073 , 0x9EBE},
{ 0x7074 , 0x9EBF},
{ 0x7077 , 0x9EC0},
{ 0x7079 , 0x9EC1},
{ 0x707A , 0x9EC2},
{ 0x707B , 0x9EC3},
{ 0x707D , 0x9EC4},
{ 0x7081 , 0x9EC5},
{ 0x7082 , 0x9EC6},
{ 0x7083 , 0x9EC7},
{ 0x7084 , 0x9EC8},
{ 0x7086 , 0x9EC9},
{ 0x7087 , 0x9ECA},
{ 0x7088 , 0x9ECB},
{ 0x708B , 0x9ECC},
{ 0x708C , 0x9ECD},
{ 0x708D , 0x9ECE},
{ 0x708F , 0x9ECF},
{ 0x7090 , 0x9ED0},
{ 0x7091 , 0x9ED1},
{ 0x7093 , 0x9ED2},
{ 0x7097 , 0x9ED3},
{ 0x7098 , 0x9ED4},
{ 0x709A , 0x9ED5},
{ 0x709B , 0x9ED6},
{ 0x709E , 0x9ED7},
{ 0x709F , 0x9ED8},
{ 0x70A0 , 0x9ED9},
{ 0x70A1 , 0x9EDA},
{ 0x70A2 , 0x9EDB},
{ 0x70A3 , 0x9EDC},
{ 0x70A4 , 0x9EDD},
{ 0x70A5 , 0x9EDE},
{ 0x70A6 , 0x9EDF},
{ 0x70A7 , 0x9EE0},
{ 0x70A8 , 0x9EE1},
{ 0x70A9 , 0x9EE2},
{ 0x70AA , 0x9EE3},
{ 0x70B0 , 0x9EE4},
{ 0x70B2 , 0x9EE5},
{ 0x70B4 , 0x9EE6},
{ 0x70B5 , 0x9EE7},
{ 0x70B6 , 0x9EE8},
{ 0x70BA , 0x9EE9},
{ 0x70BE , 0x9EEA},
{ 0x70BF , 0x9EEB},
{ 0x70C4 , 0x9EEC},
{ 0x70C5 , 0x9EED},
{ 0x70C6 , 0x9EEE},
{ 0x70C7 , 0x9EEF},
{ 0x70C9 , 0x9EF0},
{ 0x70CB , 0x9EF1},
{ 0x70CC , 0x9EF2},
{ 0x70CD , 0x9EF3},
{ 0x70CE , 0x9EF4},
{ 0x70CF , 0x9EF5},
{ 0x70D0 , 0x9EF6},
{ 0x70D1 , 0x9EF7},
{ 0x70D2 , 0x9EF8},
{ 0x70D3 , 0x9EF9},
{ 0x70D4 , 0x9EFA},
{ 0x70D5 , 0x9EFB},
{ 0x70D6 , 0x9EFC},
{ 0x70D7 , 0x9EFD},
{ 0x70DA , 0x9EFE},
{ 0x70DC , 0x9F40},
{ 0x70DD , 0x9F41},
{ 0x70DE , 0x9F42},
{ 0x70E0 , 0x9F43},
{ 0x70E1 , 0x9F44},
{ 0x70E2 , 0x9F45},
{ 0x70E3 , 0x9F46},
{ 0x70E5 , 0x9F47},
{ 0x70EA , 0x9F48},
{ 0x70EE , 0x9F49},
{ 0x70F0 , 0x9F4A},
{ 0x70F1 , 0x9F4B},
{ 0x70F2 , 0x9F4C},
{ 0x70F3 , 0x9F4D},
{ 0x70F4 , 0x9F4E},
{ 0x70F5 , 0x9F4F},
{ 0x70F6 , 0x9F50},
{ 0x70F8 , 0x9F51},
{ 0x70FA , 0x9F52},
{ 0x70FB , 0x9F53},
{ 0x70FC , 0x9F54},
{ 0x70FE , 0x9F55},
{ 0x70FF , 0x9F56},
{ 0x7100 , 0x9F57},
{ 0x7101 , 0x9F58},
{ 0x7102 , 0x9F59},
{ 0x7103 , 0x9F5A},
{ 0x7104 , 0x9F5B},
{ 0x7105 , 0x9F5C},
{ 0x7106 , 0x9F5D},
{ 0x7107 , 0x9F5E},
{ 0x7108 , 0x9F5F},
{ 0x710B , 0x9F60},
{ 0x710C , 0x9F61},
{ 0x710D , 0x9F62},
{ 0x710E , 0x9F63},
{ 0x710F , 0x9F64},
{ 0x7111 , 0x9F65},
{ 0x7112 , 0x9F66},
{ 0x7114 , 0x9F67},
{ 0x7117 , 0x9F68},
{ 0x711B , 0x9F69},
{ 0x711C , 0x9F6A},
{ 0x711D , 0x9F6B},
{ 0x711E , 0x9F6C},
{ 0x711F , 0x9F6D},
{ 0x7120 , 0x9F6E},
{ 0x7121 , 0x9F6F},
{ 0x7122 , 0x9F70},
{ 0x7123 , 0x9F71},
{ 0x7124 , 0x9F72},
{ 0x7125 , 0x9F73},
{ 0x7127 , 0x9F74},
{ 0x7128 , 0x9F75},
{ 0x7129 , 0x9F76},
{ 0x712A , 0x9F77},
{ 0x712B , 0x9F78},
{ 0x712C , 0x9F79},
{ 0x712D , 0x9F7A},
{ 0x712E , 0x9F7B},
{ 0x7132 , 0x9F7C},
{ 0x7133 , 0x9F7D},
{ 0x7134 , 0x9F7E},
{ 0x7135 , 0x9F80},
{ 0x7137 , 0x9F81},
{ 0x7138 , 0x9F82},
{ 0x7139 , 0x9F83},
{ 0x713A , 0x9F84},
{ 0x713B , 0x9F85},
{ 0x713C , 0x9F86},
{ 0x713D , 0x9F87},
{ 0x713E , 0x9F88},
{ 0x713F , 0x9F89},
{ 0x7140 , 0x9F8A},
{ 0x7141 , 0x9F8B},
{ 0x7142 , 0x9F8C},
{ 0x7143 , 0x9F8D},
{ 0x7144 , 0x9F8E},
{ 0x7146 , 0x9F8F},
{ 0x7147 , 0x9F90},
{ 0x7148 , 0x9F91},
{ 0x7149 , 0x9F92},
{ 0x714B , 0x9F93},
{ 0x714D , 0x9F94},
{ 0x714F , 0x9F95},
{ 0x7150 , 0x9F96},
{ 0x7151 , 0x9F97},
{ 0x7152 , 0x9F98},
{ 0x7153 , 0x9F99},
{ 0x7154 , 0x9F9A},
{ 0x7155 , 0x9F9B},
{ 0x7156 , 0x9F9C},
{ 0x7157 , 0x9F9D},
{ 0x7158 , 0x9F9E},
{ 0x7159 , 0x9F9F},
{ 0x715A , 0x9FA0},
{ 0x715B , 0x9FA1},
{ 0x715D , 0x9FA2},
{ 0x715F , 0x9FA3},
{ 0x7160 , 0x9FA4},
{ 0x7161 , 0x9FA5},
{ 0x7162 , 0x9FA6},
{ 0x7163 , 0x9FA7},
{ 0x7165 , 0x9FA8},
{ 0x7169 , 0x9FA9},
{ 0x716A , 0x9FAA},
{ 0x716B , 0x9FAB},
{ 0x716C , 0x9FAC},
{ 0x716D , 0x9FAD},
{ 0x716F , 0x9FAE},
{ 0x7170 , 0x9FAF},
{ 0x7171 , 0x9FB0},
{ 0x7174 , 0x9FB1},
{ 0x7175 , 0x9FB2},
{ 0x7176 , 0x9FB3},
{ 0x7177 , 0x9FB4},
{ 0x7179 , 0x9FB5},
{ 0x717B , 0x9FB6},
{ 0x717C , 0x9FB7},
{ 0x717E , 0x9FB8},
{ 0x717F , 0x9FB9},
{ 0x7180 , 0x9FBA},
{ 0x7181 , 0x9FBB},
{ 0x7182 , 0x9FBC},
{ 0x7183 , 0x9FBD},
{ 0x7185 , 0x9FBE},
{ 0x7186 , 0x9FBF},
{ 0x7187 , 0x9FC0},
{ 0x7188 , 0x9FC1},
{ 0x7189 , 0x9FC2},
{ 0x718B , 0x9FC3},
{ 0x718C , 0x9FC4},
{ 0x718D , 0x9FC5},
{ 0x718E , 0x9FC6},
{ 0x7190 , 0x9FC7},
{ 0x7191 , 0x9FC8},
{ 0x7192 , 0x9FC9},
{ 0x7193 , 0x9FCA},
{ 0x7195 , 0x9FCB},
{ 0x7196 , 0x9FCC},
{ 0x7197 , 0x9FCD},
{ 0x719A , 0x9FCE},
{ 0x719B , 0x9FCF},
{ 0x719C , 0x9FD0},
{ 0x719D , 0x9FD1},
{ 0x719E , 0x9FD2},
{ 0x71A1 , 0x9FD3},
{ 0x71A2 , 0x9FD4},
{ 0x71A3 , 0x9FD5},
{ 0x71A4 , 0x9FD6},
{ 0x71A5 , 0x9FD7},
{ 0x71A6 , 0x9FD8},
{ 0x71A7 , 0x9FD9},
{ 0x71A9 , 0x9FDA},
{ 0x71AA , 0x9FDB},
{ 0x71AB , 0x9FDC},
{ 0x71AD , 0x9FDD},
{ 0x71AE , 0x9FDE},
{ 0x71AF , 0x9FDF},
{ 0x71B0 , 0x9FE0},
{ 0x71B1 , 0x9FE1},
{ 0x71B2 , 0x9FE2},
{ 0x71B4 , 0x9FE3},
{ 0x71B6 , 0x9FE4},
{ 0x71B7 , 0x9FE5},
{ 0x71B8 , 0x9FE6},
{ 0x71BA , 0x9FE7},
{ 0x71BB , 0x9FE8},
{ 0x71BC , 0x9FE9},
{ 0x71BD , 0x9FEA},
{ 0x71BE , 0x9FEB},
{ 0x71BF , 0x9FEC},
{ 0x71C0 , 0x9FED},
{ 0x71C1 , 0x9FEE},
{ 0x71C2 , 0x9FEF},
{ 0x71C4 , 0x9FF0},
{ 0x71C5 , 0x9FF1},
{ 0x71C6 , 0x9FF2},
{ 0x71C7 , 0x9FF3},
{ 0x71C8 , 0x9FF4},
{ 0x71C9 , 0x9FF5},
{ 0x71CA , 0x9FF6},
{ 0x71CB , 0x9FF7},
{ 0x71CC , 0x9FF8},
{ 0x71CD , 0x9FF9},
{ 0x71CF , 0x9FFA},
{ 0x71D0 , 0x9FFB},
{ 0x71D1 , 0x9FFC},
{ 0x71D2 , 0x9FFD},
{ 0x71D3 , 0x9FFE},
{ 0x71D6 , 0xA040},
{ 0x71D7 , 0xA041},
{ 0x71D8 , 0xA042},
{ 0x71D9 , 0xA043},
{ 0x71DA , 0xA044},
{ 0x71DB , 0xA045},
{ 0x71DC , 0xA046},
{ 0x71DD , 0xA047},
{ 0x71DE , 0xA048},
{ 0x71DF , 0xA049},
{ 0x71E1 , 0xA04A},
{ 0x71E2 , 0xA04B},
{ 0x71E3 , 0xA04C},
{ 0x71E4 , 0xA04D},
{ 0x71E6 , 0xA04E},
{ 0x71E8 , 0xA04F},
{ 0x71E9 , 0xA050},
{ 0x71EA , 0xA051},
{ 0x71EB , 0xA052},
{ 0x71EC , 0xA053},
{ 0x71ED , 0xA054},
{ 0x71EF , 0xA055},
{ 0x71F0 , 0xA056},
{ 0x71F1 , 0xA057},
{ 0x71F2 , 0xA058},
{ 0x71F3 , 0xA059},
{ 0x71F4 , 0xA05A},
{ 0x71F5 , 0xA05B},
{ 0x71F6 , 0xA05C},
{ 0x71F7 , 0xA05D},
{ 0x71F8 , 0xA05E},
{ 0x71FA , 0xA05F},
{ 0x71FB , 0xA060},
{ 0x71FC , 0xA061},
{ 0x71FD , 0xA062},
{ 0x71FE , 0xA063},
{ 0x71FF , 0xA064},
{ 0x7200 , 0xA065},
{ 0x7201 , 0xA066},
{ 0x7202 , 0xA067},
{ 0x7203 , 0xA068},
{ 0x7204 , 0xA069},
{ 0x7205 , 0xA06A},
{ 0x7207 , 0xA06B},
{ 0x7208 , 0xA06C},
{ 0x7209 , 0xA06D},
{ 0x720A , 0xA06E},
{ 0x720B , 0xA06F},
{ 0x720C , 0xA070},
{ 0x720D , 0xA071},
{ 0x720E , 0xA072},
{ 0x720F , 0xA073},
{ 0x7210 , 0xA074},
{ 0x7211 , 0xA075},
{ 0x7212 , 0xA076},
{ 0x7213 , 0xA077},
{ 0x7214 , 0xA078},
{ 0x7215 , 0xA079},
{ 0x7216 , 0xA07A},
{ 0x7217 , 0xA07B},
{ 0x7218 , 0xA07C},
{ 0x7219 , 0xA07D},
{ 0x721A , 0xA07E},
{ 0x721B , 0xA080},
{ 0x721C , 0xA081},
{ 0x721E , 0xA082},
{ 0x721F , 0xA083},
{ 0x7220 , 0xA084},
{ 0x7221 , 0xA085},
{ 0x7222 , 0xA086},
{ 0x7223 , 0xA087},
{ 0x7224 , 0xA088},
{ 0x7225 , 0xA089},
{ 0x7226 , 0xA08A},
{ 0x7227 , 0xA08B},
{ 0x7229 , 0xA08C},
{ 0x722B , 0xA08D},
{ 0x722D , 0xA08E},
{ 0x722E , 0xA08F},
{ 0x722F , 0xA090},
{ 0x7232 , 0xA091},
{ 0x7233 , 0xA092},
{ 0x7234 , 0xA093},
{ 0x723A , 0xA094},
{ 0x723C , 0xA095},
{ 0x723E , 0xA096},
{ 0x7240 , 0xA097},
{ 0x7241 , 0xA098},
{ 0x7242 , 0xA099},
{ 0x7243 , 0xA09A},
{ 0x7244 , 0xA09B},
{ 0x7245 , 0xA09C},
{ 0x7246 , 0xA09D},
{ 0x7249 , 0xA09E},
{ 0x724A , 0xA09F},
{ 0x724B , 0xA0A0},
{ 0x724E , 0xA0A1},
{ 0x724F , 0xA0A2},
{ 0x7250 , 0xA0A3},
{ 0x7251 , 0xA0A4},
{ 0x7253 , 0xA0A5},
{ 0x7254 , 0xA0A6},
{ 0x7255 , 0xA0A7},
{ 0x7257 , 0xA0A8},
{ 0x7258 , 0xA0A9},
{ 0x725A , 0xA0AA},
{ 0x725C , 0xA0AB},
{ 0x725E , 0xA0AC},
{ 0x7260 , 0xA0AD},
{ 0x7263 , 0xA0AE},
{ 0x7264 , 0xA0AF},
{ 0x7265 , 0xA0B0},
{ 0x7268 , 0xA0B1},
{ 0x726A , 0xA0B2},
{ 0x726B , 0xA0B3},
{ 0x726C , 0xA0B4},
{ 0x726D , 0xA0B5},
{ 0x7270 , 0xA0B6},
{ 0x7271 , 0xA0B7},
{ 0x7273 , 0xA0B8},
{ 0x7274 , 0xA0B9},
{ 0x7276 , 0xA0BA},
{ 0x7277 , 0xA0BB},
{ 0x7278 , 0xA0BC},
{ 0x727B , 0xA0BD},
{ 0x727C , 0xA0BE},
{ 0x727D , 0xA0BF},
{ 0x7282 , 0xA0C0},
{ 0x7283 , 0xA0C1},
{ 0x7285 , 0xA0C2},
{ 0x7286 , 0xA0C3},
{ 0x7287 , 0xA0C4},
{ 0x7288 , 0xA0C5},
{ 0x7289 , 0xA0C6},
{ 0x728C , 0xA0C7},
{ 0x728E , 0xA0C8},
{ 0x7290 , 0xA0C9},
{ 0x7291 , 0xA0CA},
{ 0x7293 , 0xA0CB},
{ 0x7294 , 0xA0CC},
{ 0x7295 , 0xA0CD},
{ 0x7296 , 0xA0CE},
{ 0x7297 , 0xA0CF},
{ 0x7298 , 0xA0D0},
{ 0x7299 , 0xA0D1},
{ 0x729A , 0xA0D2},
{ 0x729B , 0xA0D3},
{ 0x729C , 0xA0D4},
{ 0x729D , 0xA0D5},
{ 0x729E , 0xA0D6},
{ 0x72A0 , 0xA0D7},
{ 0x72A1 , 0xA0D8},
{ 0x72A2 , 0xA0D9},
{ 0x72A3 , 0xA0DA},
{ 0x72A4 , 0xA0DB},
{ 0x72A5 , 0xA0DC},
{ 0x72A6 , 0xA0DD},
{ 0x72A7 , 0xA0DE},
{ 0x72A8 , 0xA0DF},
{ 0x72A9 , 0xA0E0},
{ 0x72AA , 0xA0E1},
{ 0x72AB , 0xA0E2},
{ 0x72AE , 0xA0E3},
{ 0x72B1 , 0xA0E4},
{ 0x72B2 , 0xA0E5},
{ 0x72B3 , 0xA0E6},
{ 0x72B5 , 0xA0E7},
{ 0x72BA , 0xA0E8},
{ 0x72BB , 0xA0E9},
{ 0x72BC , 0xA0EA},
{ 0x72BD , 0xA0EB},
{ 0x72BE , 0xA0EC},
{ 0x72BF , 0xA0ED},
{ 0x72C0 , 0xA0EE},
{ 0x72C5 , 0xA0EF},
{ 0x72C6 , 0xA0F0},
{ 0x72C7 , 0xA0F1},
{ 0x72C9 , 0xA0F2},
{ 0x72CA , 0xA0F3},
{ 0x72CB , 0xA0F4},
{ 0x72CC , 0xA0F5},
{ 0x72CF , 0xA0F6},
{ 0x72D1 , 0xA0F7},
{ 0x72D3 , 0xA0F8},
{ 0x72D4 , 0xA0F9},
{ 0x72D5 , 0xA0FA},
{ 0x72D6 , 0xA0FB},
{ 0x72D8 , 0xA0FC},
{ 0x72DA , 0xA0FD},
{ 0x72DB , 0xA0FE},
{ 0xE4C6 , 0xA140},
{ 0xE4C7 , 0xA141},
{ 0xE4C8 , 0xA142},
{ 0xE4C9 , 0xA143},
{ 0xE4CA , 0xA144},
{ 0xE4CB , 0xA145},
{ 0xE4CC , 0xA146},
{ 0xE4CD , 0xA147},
{ 0xE4CE , 0xA148},
{ 0xE4CF , 0xA149},
{ 0xE4D0 , 0xA14A},
{ 0xE4D1 , 0xA14B},
{ 0xE4D2 , 0xA14C},
{ 0xE4D3 , 0xA14D},
{ 0xE4D4 , 0xA14E},
{ 0xE4D5 , 0xA14F},
{ 0xE4D6 , 0xA150},
{ 0xE4D7 , 0xA151},
{ 0xE4D8 , 0xA152},
{ 0xE4D9 , 0xA153},
{ 0xE4DA , 0xA154},
{ 0xE4DB , 0xA155},
{ 0xE4DC , 0xA156},
{ 0xE4DD , 0xA157},
{ 0xE4DE , 0xA158},
{ 0xE4DF , 0xA159},
{ 0xE4E0 , 0xA15A},
{ 0xE4E1 , 0xA15B},
{ 0xE4E2 , 0xA15C},
{ 0xE4E3 , 0xA15D},
{ 0xE4E4 , 0xA15E},
{ 0xE4E5 , 0xA15F},
{ 0xE4E6 , 0xA160},
{ 0xE4E7 , 0xA161},
{ 0xE4E8 , 0xA162},
{ 0xE4E9 , 0xA163},
{ 0xE4EA , 0xA164},
{ 0xE4EB , 0xA165},
{ 0xE4EC , 0xA166},
{ 0xE4ED , 0xA167},
{ 0xE4EE , 0xA168},
{ 0xE4EF , 0xA169},
{ 0xE4F0 , 0xA16A},
{ 0xE4F1 , 0xA16B},
{ 0xE4F2 , 0xA16C},
{ 0xE4F3 , 0xA16D},
{ 0xE4F4 , 0xA16E},
{ 0xE4F5 , 0xA16F},
{ 0xE4F6 , 0xA170},
{ 0xE4F7 , 0xA171},
{ 0xE4F8 , 0xA172},
{ 0xE4F9 , 0xA173},
{ 0xE4FA , 0xA174},
{ 0xE4FB , 0xA175},
{ 0xE4FC , 0xA176},
{ 0xE4FD , 0xA177},
{ 0xE4FE , 0xA178},
{ 0xE4FF , 0xA179},
{ 0xE500 , 0xA17A},
{ 0xE501 , 0xA17B},
{ 0xE502 , 0xA17C},
{ 0xE503 , 0xA17D},
{ 0xE504 , 0xA17E},
{ 0xE505 , 0xA180},
{ 0xE506 , 0xA181},
{ 0xE507 , 0xA182},
{ 0xE508 , 0xA183},
{ 0xE509 , 0xA184},
{ 0xE50A , 0xA185},
{ 0xE50B , 0xA186},
{ 0xE50C , 0xA187},
{ 0xE50D , 0xA188},
{ 0xE50E , 0xA189},
{ 0xE50F , 0xA18A},
{ 0xE510 , 0xA18B},
{ 0xE511 , 0xA18C},
{ 0xE512 , 0xA18D},
{ 0xE513 , 0xA18E},
{ 0xE514 , 0xA18F},
{ 0xE515 , 0xA190},
{ 0xE516 , 0xA191},
{ 0xE517 , 0xA192},
{ 0xE518 , 0xA193},
{ 0xE519 , 0xA194},
{ 0xE51A , 0xA195},
{ 0xE51B , 0xA196},
{ 0xE51C , 0xA197},
{ 0xE51D , 0xA198},
{ 0xE51E , 0xA199},
{ 0xE51F , 0xA19A},
{ 0xE520 , 0xA19B},
{ 0xE521 , 0xA19C},
{ 0xE522 , 0xA19D},
{ 0xE523 , 0xA19E},
{ 0xE524 , 0xA19F},
{ 0xE525 , 0xA1A0},
{ 0x3000 , 0xA1A1},
{ 0x3001 , 0xA1A2},
{ 0x3002 , 0xA1A3},
{ 0x00B7 , 0xA1A4},
{ 0x02C9 , 0xA1A5},
{ 0x02C7 , 0xA1A6},
{ 0x00A8 , 0xA1A7},
{ 0x3003 , 0xA1A8},
{ 0x3005 , 0xA1A9},
{ 0x2014 , 0xA1AA},
{ 0xFF5E , 0xA1AB},
{ 0x2016 , 0xA1AC},
{ 0x2026 , 0xA1AD},
{ 0x2018 , 0xA1AE},
{ 0x2019 , 0xA1AF},
{ 0x201C , 0xA1B0},
{ 0x201D , 0xA1B1},
{ 0x3014 , 0xA1B2},
{ 0x3015 , 0xA1B3},
{ 0x3008 , 0xA1B4},
{ 0x3009 , 0xA1B5},
{ 0x300A , 0xA1B6},
{ 0x300B , 0xA1B7},
{ 0x300C , 0xA1B8},
{ 0x300D , 0xA1B9},
{ 0x300E , 0xA1BA},
{ 0x300F , 0xA1BB},
{ 0x3016 , 0xA1BC},
{ 0x3017 , 0xA1BD},
{ 0x3010 , 0xA1BE},
{ 0x3011 , 0xA1BF},
{ 0x00B1 , 0xA1C0},
{ 0x00D7 , 0xA1C1},
{ 0x00F7 , 0xA1C2},
{ 0x2236 , 0xA1C3},
{ 0x2227 , 0xA1C4},
{ 0x2228 , 0xA1C5},
{ 0x2211 , 0xA1C6},
{ 0x220F , 0xA1C7},
{ 0x222A , 0xA1C8},
{ 0x2229 , 0xA1C9},
{ 0x2208 , 0xA1CA},
{ 0x2237 , 0xA1CB},
{ 0x221A , 0xA1CC},
{ 0x22A5 , 0xA1CD},
{ 0x2225 , 0xA1CE},
{ 0x2220 , 0xA1CF},
{ 0x2312 , 0xA1D0},
{ 0x2299 , 0xA1D1},
{ 0x222B , 0xA1D2},
{ 0x222E , 0xA1D3},
{ 0x2261 , 0xA1D4},
{ 0x224C , 0xA1D5},
{ 0x2248 , 0xA1D6},
{ 0x223D , 0xA1D7},
{ 0x221D , 0xA1D8},
{ 0x2260 , 0xA1D9},
{ 0x226E , 0xA1DA},
{ 0x226F , 0xA1DB},
{ 0x2264 , 0xA1DC},
{ 0x2265 , 0xA1DD},
{ 0x221E , 0xA1DE},
{ 0x2235 , 0xA1DF},
{ 0x2234 , 0xA1E0},
{ 0x2642 , 0xA1E1},
{ 0x2640 , 0xA1E2},
{ 0x00B0 , 0xA1E3},
{ 0x2032 , 0xA1E4},
{ 0x2033 , 0xA1E5},
{ 0x2103 , 0xA1E6},
{ 0xFF04 , 0xA1E7},
{ 0x00A4 , 0xA1E8},
{ 0xFFE0 , 0xA1E9},
{ 0xFFE1 , 0xA1EA},
{ 0x2030 , 0xA1EB},
{ 0x00A7 , 0xA1EC},
{ 0x2116 , 0xA1ED},
{ 0x2606 , 0xA1EE},
{ 0x2605 , 0xA1EF},
{ 0x25CB , 0xA1F0},
{ 0x25CF , 0xA1F1},
{ 0x25CE , 0xA1F2},
{ 0x25C7 , 0xA1F3},
{ 0x25C6 , 0xA1F4},
{ 0x25A1 , 0xA1F5},
{ 0x25A0 , 0xA1F6},
{ 0x25B3 , 0xA1F7},
{ 0x25B2 , 0xA1F8},
{ 0x203B , 0xA1F9},
{ 0x2192 , 0xA1FA},
{ 0x2190 , 0xA1FB},
{ 0x2191 , 0xA1FC},
{ 0x2193 , 0xA1FD},
{ 0x3013 , 0xA1FE},
{ 0xE526 , 0xA240},
{ 0xE527 , 0xA241},
{ 0xE528 , 0xA242},
{ 0xE529 , 0xA243},
{ 0xE52A , 0xA244},
{ 0xE52B , 0xA245},
{ 0xE52C , 0xA246},
{ 0xE52D , 0xA247},
{ 0xE52E , 0xA248},
{ 0xE52F , 0xA249},
{ 0xE530 , 0xA24A},
{ 0xE531 , 0xA24B},
{ 0xE532 , 0xA24C},
{ 0xE533 , 0xA24D},
{ 0xE534 , 0xA24E},
{ 0xE535 , 0xA24F},
{ 0xE536 , 0xA250},
{ 0xE537 , 0xA251},
{ 0xE538 , 0xA252},
{ 0xE539 , 0xA253},
{ 0xE53A , 0xA254},
{ 0xE53B , 0xA255},
{ 0xE53C , 0xA256},
{ 0xE53D , 0xA257},
{ 0xE53E , 0xA258},
{ 0xE53F , 0xA259},
{ 0xE540 , 0xA25A},
{ 0xE541 , 0xA25B},
{ 0xE542 , 0xA25C},
{ 0xE543 , 0xA25D},
{ 0xE544 , 0xA25E},
{ 0xE545 , 0xA25F},
{ 0xE546 , 0xA260},
{ 0xE547 , 0xA261},
{ 0xE548 , 0xA262},
{ 0xE549 , 0xA263},
{ 0xE54A , 0xA264},
{ 0xE54B , 0xA265},
{ 0xE54C , 0xA266},
{ 0xE54D , 0xA267},
{ 0xE54E , 0xA268},
{ 0xE54F , 0xA269},
{ 0xE550 , 0xA26A},
{ 0xE551 , 0xA26B},
{ 0xE552 , 0xA26C},
{ 0xE553 , 0xA26D},
{ 0xE554 , 0xA26E},
{ 0xE555 , 0xA26F},
{ 0xE556 , 0xA270},
{ 0xE557 , 0xA271},
{ 0xE558 , 0xA272},
{ 0xE559 , 0xA273},
{ 0xE55A , 0xA274},
{ 0xE55B , 0xA275},
{ 0xE55C , 0xA276},
{ 0xE55D , 0xA277},
{ 0xE55E , 0xA278},
{ 0xE55F , 0xA279},
{ 0xE560 , 0xA27A},
{ 0xE561 , 0xA27B},
{ 0xE562 , 0xA27C},
{ 0xE563 , 0xA27D},
{ 0xE564 , 0xA27E},
{ 0xE565 , 0xA280},
{ 0xE566 , 0xA281},
{ 0xE567 , 0xA282},
{ 0xE568 , 0xA283},
{ 0xE569 , 0xA284},
{ 0xE56A , 0xA285},
{ 0xE56B , 0xA286},
{ 0xE56C , 0xA287},
{ 0xE56D , 0xA288},
{ 0xE56E , 0xA289},
{ 0xE56F , 0xA28A},
{ 0xE570 , 0xA28B},
{ 0xE571 , 0xA28C},
{ 0xE572 , 0xA28D},
{ 0xE573 , 0xA28E},
{ 0xE574 , 0xA28F},
{ 0xE575 , 0xA290},
{ 0xE576 , 0xA291},
{ 0xE577 , 0xA292},
{ 0xE578 , 0xA293},
{ 0xE579 , 0xA294},
{ 0xE57A , 0xA295},
{ 0xE57B , 0xA296},
{ 0xE57C , 0xA297},
{ 0xE57D , 0xA298},
{ 0xE57E , 0xA299},
{ 0xE57F , 0xA29A},
{ 0xE580 , 0xA29B},
{ 0xE581 , 0xA29C},
{ 0xE582 , 0xA29D},
{ 0xE583 , 0xA29E},
{ 0xE584 , 0xA29F},
{ 0xE585 , 0xA2A0},
{ 0x2170 , 0xA2A1},
{ 0x2171 , 0xA2A2},
{ 0x2172 , 0xA2A3},
{ 0x2173 , 0xA2A4},
{ 0x2174 , 0xA2A5},
{ 0x2175 , 0xA2A6},
{ 0x2176 , 0xA2A7},
{ 0x2177 , 0xA2A8},
{ 0x2178 , 0xA2A9},
{ 0x2179 , 0xA2AA},
{ 0xE766 , 0xA2AB},
{ 0xE767 , 0xA2AC},
{ 0xE768 , 0xA2AD},
{ 0xE769 , 0xA2AE},
{ 0xE76A , 0xA2AF},
{ 0xE76B , 0xA2B0},
{ 0x2488 , 0xA2B1},
{ 0x2489 , 0xA2B2},
{ 0x248A , 0xA2B3},
{ 0x248B , 0xA2B4},
{ 0x248C , 0xA2B5},
{ 0x248D , 0xA2B6},
{ 0x248E , 0xA2B7},
{ 0x248F , 0xA2B8},
{ 0x2490 , 0xA2B9},
{ 0x2491 , 0xA2BA},
{ 0x2492 , 0xA2BB},
{ 0x2493 , 0xA2BC},
{ 0x2494 , 0xA2BD},
{ 0x2495 , 0xA2BE},
{ 0x2496 , 0xA2BF},
{ 0x2497 , 0xA2C0},
{ 0x2498 , 0xA2C1},
{ 0x2499 , 0xA2C2},
{ 0x249A , 0xA2C3},
{ 0x249B , 0xA2C4},
{ 0x2474 , 0xA2C5},
{ 0x2475 , 0xA2C6},
{ 0x2476 , 0xA2C7},
{ 0x2477 , 0xA2C8},
{ 0x2478 , 0xA2C9},
{ 0x2479 , 0xA2CA},
{ 0x247A , 0xA2CB},
{ 0x247B , 0xA2CC},
{ 0x247C , 0xA2CD},
{ 0x247D , 0xA2CE},
{ 0x247E , 0xA2CF},
{ 0x247F , 0xA2D0},
{ 0x2480 , 0xA2D1},
{ 0x2481 , 0xA2D2},
{ 0x2482 , 0xA2D3},
{ 0x2483 , 0xA2D4},
{ 0x2484 , 0xA2D5},
{ 0x2485 , 0xA2D6},
{ 0x2486 , 0xA2D7},
{ 0x2487 , 0xA2D8},
{ 0x2460 , 0xA2D9},
{ 0x2461 , 0xA2DA},
{ 0x2462 , 0xA2DB},
{ 0x2463 , 0xA2DC},
{ 0x2464 , 0xA2DD},
{ 0x2465 , 0xA2DE},
{ 0x2466 , 0xA2DF},
{ 0x2467 , 0xA2E0},
{ 0x2468 , 0xA2E1},
{ 0x2469 , 0xA2E2},
{ 0x20AC , 0xA2E3},
{ 0xE76D , 0xA2E4},
{ 0x3220 , 0xA2E5},
{ 0x3221 , 0xA2E6},
{ 0x3222 , 0xA2E7},
{ 0x3223 , 0xA2E8},
{ 0x3224 , 0xA2E9},
{ 0x3225 , 0xA2EA},
{ 0x3226 , 0xA2EB},
{ 0x3227 , 0xA2EC},
{ 0x3228 , 0xA2ED},
{ 0x3229 , 0xA2EE},
{ 0xE76E , 0xA2EF},
{ 0xE76F , 0xA2F0},
{ 0x2160 , 0xA2F1},
{ 0x2161 , 0xA2F2},
{ 0x2162 , 0xA2F3},
{ 0x2163 , 0xA2F4},
{ 0x2164 , 0xA2F5},
{ 0x2165 , 0xA2F6},
{ 0x2166 , 0xA2F7},
{ 0x2167 , 0xA2F8},
{ 0x2168 , 0xA2F9},
{ 0x2169 , 0xA2FA},
{ 0x216A , 0xA2FB},
{ 0x216B , 0xA2FC},
{ 0xE770 , 0xA2FD},
{ 0xE771 , 0xA2FE},
{ 0xE586 , 0xA340},
{ 0xE587 , 0xA341},
{ 0xE588 , 0xA342},
{ 0xE589 , 0xA343},
{ 0xE58A , 0xA344},
{ 0xE58B , 0xA345},
{ 0xE58C , 0xA346},
{ 0xE58D , 0xA347},
{ 0xE58E , 0xA348},
{ 0xE58F , 0xA349},
{ 0xE590 , 0xA34A},
{ 0xE591 , 0xA34B},
{ 0xE592 , 0xA34C},
{ 0xE593 , 0xA34D},
{ 0xE594 , 0xA34E},
{ 0xE595 , 0xA34F},
{ 0xE596 , 0xA350},
{ 0xE597 , 0xA351},
{ 0xE598 , 0xA352},
{ 0xE599 , 0xA353},
{ 0xE59A , 0xA354},
{ 0xE59B , 0xA355},
{ 0xE59C , 0xA356},
{ 0xE59D , 0xA357},
{ 0xE59E , 0xA358},
{ 0xE59F , 0xA359},
{ 0xE5A0 , 0xA35A},
{ 0xE5A1 , 0xA35B},
{ 0xE5A2 , 0xA35C},
{ 0xE5A3 , 0xA35D},
{ 0xE5A4 , 0xA35E},
{ 0xE5A5 , 0xA35F},
{ 0xE5A6 , 0xA360},
{ 0xE5A7 , 0xA361},
{ 0xE5A8 , 0xA362},
{ 0xE5A9 , 0xA363},
{ 0xE5AA , 0xA364},
{ 0xE5AB , 0xA365},
{ 0xE5AC , 0xA366},
{ 0xE5AD , 0xA367},
{ 0xE5AE , 0xA368},
{ 0xE5AF , 0xA369},
{ 0xE5B0 , 0xA36A},
{ 0xE5B1 , 0xA36B},
{ 0xE5B2 , 0xA36C},
{ 0xE5B3 , 0xA36D},
{ 0xE5B4 , 0xA36E},
{ 0xE5B5 , 0xA36F},
{ 0xE5B6 , 0xA370},
{ 0xE5B7 , 0xA371},
{ 0xE5B8 , 0xA372},
{ 0xE5B9 , 0xA373},
{ 0xE5BA , 0xA374},
{ 0xE5BB , 0xA375},
{ 0xE5BC , 0xA376},
{ 0xE5BD , 0xA377},
{ 0xE5BE , 0xA378},
{ 0xE5BF , 0xA379},
{ 0xE5C0 , 0xA37A},
{ 0xE5C1 , 0xA37B},
{ 0xE5C2 , 0xA37C},
{ 0xE5C3 , 0xA37D},
{ 0xE5C4 , 0xA37E},
{ 0xE5C5 , 0xA380},
{ 0xE5C6 , 0xA381},
{ 0xE5C7 , 0xA382},
{ 0xE5C8 , 0xA383},
{ 0xE5C9 , 0xA384},
{ 0xE5CA , 0xA385},
{ 0xE5CB , 0xA386},
{ 0xE5CC , 0xA387},
{ 0xE5CD , 0xA388},
{ 0xE5CE , 0xA389},
{ 0xE5CF , 0xA38A},
{ 0xE5D0 , 0xA38B},
{ 0xE5D1 , 0xA38C},
{ 0xE5D2 , 0xA38D},
{ 0xE5D3 , 0xA38E},
{ 0xE5D4 , 0xA38F},
{ 0xE5D5 , 0xA390},
{ 0xE5D6 , 0xA391},
{ 0xE5D7 , 0xA392},
{ 0xE5D8 , 0xA393},
{ 0xE5D9 , 0xA394},
{ 0xE5DA , 0xA395},
{ 0xE5DB , 0xA396},
{ 0xE5DC , 0xA397},
{ 0xE5DD , 0xA398},
{ 0xE5DE , 0xA399},
{ 0xE5DF , 0xA39A},
{ 0xE5E0 , 0xA39B},
{ 0xE5E1 , 0xA39C},
{ 0xE5E2 , 0xA39D},
{ 0xE5E3 , 0xA39E},
{ 0xE5E4 , 0xA39F},
{ 0xE5E5 , 0xA3A0},
{ 0xFF01 , 0xA3A1},
{ 0xFF02 , 0xA3A2},
{ 0xFF03 , 0xA3A3},
{ 0xFFE5 , 0xA3A4},
{ 0xFF05 , 0xA3A5},
{ 0xFF06 , 0xA3A6},
{ 0xFF07 , 0xA3A7},
{ 0xFF08 , 0xA3A8},
{ 0xFF09 , 0xA3A9},
{ 0xFF0A , 0xA3AA},
{ 0xFF0B , 0xA3AB},
{ 0xFF0C , 0xA3AC},
{ 0xFF0D , 0xA3AD},
{ 0xFF0E , 0xA3AE},
{ 0xFF0F , 0xA3AF},
{ 0xFF10 , 0xA3B0},
{ 0xFF11 , 0xA3B1},
{ 0xFF12 , 0xA3B2},
{ 0xFF13 , 0xA3B3},
{ 0xFF14 , 0xA3B4},
{ 0xFF15 , 0xA3B5},
{ 0xFF16 , 0xA3B6},
{ 0xFF17 , 0xA3B7},
{ 0xFF18 , 0xA3B8},
{ 0xFF19 , 0xA3B9},
{ 0xFF1A , 0xA3BA},
{ 0xFF1B , 0xA3BB},
{ 0xFF1C , 0xA3BC},
{ 0xFF1D , 0xA3BD},
{ 0xFF1E , 0xA3BE},
{ 0xFF1F , 0xA3BF},
{ 0xFF20 , 0xA3C0},
{ 0xFF21 , 0xA3C1},
{ 0xFF22 , 0xA3C2},
{ 0xFF23 , 0xA3C3},
{ 0xFF24 , 0xA3C4},
{ 0xFF25 , 0xA3C5},
{ 0xFF26 , 0xA3C6},
{ 0xFF27 , 0xA3C7},
{ 0xFF28 , 0xA3C8},
{ 0xFF29 , 0xA3C9},
{ 0xFF2A , 0xA3CA},
{ 0xFF2B , 0xA3CB},
{ 0xFF2C , 0xA3CC},
{ 0xFF2D , 0xA3CD},
{ 0xFF2E , 0xA3CE},
{ 0xFF2F , 0xA3CF},
{ 0xFF30 , 0xA3D0},
{ 0xFF31 , 0xA3D1},
{ 0xFF32 , 0xA3D2},
{ 0xFF33 , 0xA3D3},
{ 0xFF34 , 0xA3D4},
{ 0xFF35 , 0xA3D5},
{ 0xFF36 , 0xA3D6},
{ 0xFF37 , 0xA3D7},
{ 0xFF38 , 0xA3D8},
{ 0xFF39 , 0xA3D9},
{ 0xFF3A , 0xA3DA},
{ 0xFF3B , 0xA3DB},
{ 0xFF3C , 0xA3DC},
{ 0xFF3D , 0xA3DD},
{ 0xFF3E , 0xA3DE},
{ 0xFF3F , 0xA3DF},
{ 0xFF40 , 0xA3E0},
{ 0xFF41 , 0xA3E1},
{ 0xFF42 , 0xA3E2},
{ 0xFF43 , 0xA3E3},
{ 0xFF44 , 0xA3E4},
{ 0xFF45 , 0xA3E5},
{ 0xFF46 , 0xA3E6},
{ 0xFF47 , 0xA3E7},
{ 0xFF48 , 0xA3E8},
{ 0xFF49 , 0xA3E9},
{ 0xFF4A , 0xA3EA},
{ 0xFF4B , 0xA3EB},
{ 0xFF4C , 0xA3EC},
{ 0xFF4D , 0xA3ED},
{ 0xFF4E , 0xA3EE},
{ 0xFF4F , 0xA3EF},
{ 0xFF50 , 0xA3F0},
{ 0xFF51 , 0xA3F1},
{ 0xFF52 , 0xA3F2},
{ 0xFF53 , 0xA3F3},
{ 0xFF54 , 0xA3F4},
{ 0xFF55 , 0xA3F5},
{ 0xFF56 , 0xA3F6},
{ 0xFF57 , 0xA3F7},
{ 0xFF58 , 0xA3F8},
{ 0xFF59 , 0xA3F9},
{ 0xFF5A , 0xA3FA},
{ 0xFF5B , 0xA3FB},
{ 0xFF5C , 0xA3FC},
{ 0xFF5D , 0xA3FD},
{ 0xFFE3 , 0xA3FE},
{ 0xE5E6 , 0xA440},
{ 0xE5E7 , 0xA441},
{ 0xE5E8 , 0xA442},
{ 0xE5E9 , 0xA443},
{ 0xE5EA , 0xA444},
{ 0xE5EB , 0xA445},
{ 0xE5EC , 0xA446},
{ 0xE5ED , 0xA447},
{ 0xE5EE , 0xA448},
{ 0xE5EF , 0xA449},
{ 0xE5F0 , 0xA44A},
{ 0xE5F1 , 0xA44B},
{ 0xE5F2 , 0xA44C},
{ 0xE5F3 , 0xA44D},
{ 0xE5F4 , 0xA44E},
{ 0xE5F5 , 0xA44F},
{ 0xE5F6 , 0xA450},
{ 0xE5F7 , 0xA451},
{ 0xE5F8 , 0xA452},
{ 0xE5F9 , 0xA453},
{ 0xE5FA , 0xA454},
{ 0xE5FB , 0xA455},
{ 0xE5FC , 0xA456},
{ 0xE5FD , 0xA457},
{ 0xE5FE , 0xA458},
{ 0xE5FF , 0xA459},
{ 0xE600 , 0xA45A},
{ 0xE601 , 0xA45B},
{ 0xE602 , 0xA45C},
{ 0xE603 , 0xA45D},
{ 0xE604 , 0xA45E},
{ 0xE605 , 0xA45F},
{ 0xE606 , 0xA460},
{ 0xE607 , 0xA461},
{ 0xE608 , 0xA462},
{ 0xE609 , 0xA463},
{ 0xE60A , 0xA464},
{ 0xE60B , 0xA465},
{ 0xE60C , 0xA466},
{ 0xE60D , 0xA467},
{ 0xE60E , 0xA468},
{ 0xE60F , 0xA469},
{ 0xE610 , 0xA46A},
{ 0xE611 , 0xA46B},
{ 0xE612 , 0xA46C},
{ 0xE613 , 0xA46D},
{ 0xE614 , 0xA46E},
{ 0xE615 , 0xA46F},
{ 0xE616 , 0xA470},
{ 0xE617 , 0xA471},
{ 0xE618 , 0xA472},
{ 0xE619 , 0xA473},
{ 0xE61A , 0xA474},
{ 0xE61B , 0xA475},
{ 0xE61C , 0xA476},
{ 0xE61D , 0xA477},
{ 0xE61E , 0xA478},
{ 0xE61F , 0xA479},
{ 0xE620 , 0xA47A},
{ 0xE621 , 0xA47B},
{ 0xE622 , 0xA47C},
{ 0xE623 , 0xA47D},
{ 0xE624 , 0xA47E},
{ 0xE625 , 0xA480},
{ 0xE626 , 0xA481},
{ 0xE627 , 0xA482},
{ 0xE628 , 0xA483},
{ 0xE629 , 0xA484},
{ 0xE62A , 0xA485},
{ 0xE62B , 0xA486},
{ 0xE62C , 0xA487},
{ 0xE62D , 0xA488},
{ 0xE62E , 0xA489},
{ 0xE62F , 0xA48A},
{ 0xE630 , 0xA48B},
{ 0xE631 , 0xA48C},
{ 0xE632 , 0xA48D},
{ 0xE633 , 0xA48E},
{ 0xE634 , 0xA48F},
{ 0xE635 , 0xA490},
{ 0xE636 , 0xA491},
{ 0xE637 , 0xA492},
{ 0xE638 , 0xA493},
{ 0xE639 , 0xA494},
{ 0xE63A , 0xA495},
{ 0xE63B , 0xA496},
{ 0xE63C , 0xA497},
{ 0xE63D , 0xA498},
{ 0xE63E , 0xA499},
{ 0xE63F , 0xA49A},
{ 0xE640 , 0xA49B},
{ 0xE641 , 0xA49C},
{ 0xE642 , 0xA49D},
{ 0xE643 , 0xA49E},
{ 0xE644 , 0xA49F},
{ 0xE645 , 0xA4A0},
{ 0x3041 , 0xA4A1},
{ 0x3042 , 0xA4A2},
{ 0x3043 , 0xA4A3},
{ 0x3044 , 0xA4A4},
{ 0x3045 , 0xA4A5},
{ 0x3046 , 0xA4A6},
{ 0x3047 , 0xA4A7},
{ 0x3048 , 0xA4A8},
{ 0x3049 , 0xA4A9},
{ 0x304A , 0xA4AA},
{ 0x304B , 0xA4AB},
{ 0x304C , 0xA4AC},
{ 0x304D , 0xA4AD},
{ 0x304E , 0xA4AE},
{ 0x304F , 0xA4AF},
{ 0x3050 , 0xA4B0},
{ 0x3051 , 0xA4B1},
{ 0x3052 , 0xA4B2},
{ 0x3053 , 0xA4B3},
{ 0x3054 , 0xA4B4},
{ 0x3055 , 0xA4B5},
{ 0x3056 , 0xA4B6},
{ 0x3057 , 0xA4B7},
{ 0x3058 , 0xA4B8},
{ 0x3059 , 0xA4B9},
{ 0x305A , 0xA4BA},
{ 0x305B , 0xA4BB},
{ 0x305C , 0xA4BC},
{ 0x305D , 0xA4BD},
{ 0x305E , 0xA4BE},
{ 0x305F , 0xA4BF},
{ 0x3060 , 0xA4C0},
{ 0x3061 , 0xA4C1},
{ 0x3062 , 0xA4C2},
{ 0x3063 , 0xA4C3},
{ 0x3064 , 0xA4C4},
{ 0x3065 , 0xA4C5},
{ 0x3066 , 0xA4C6},
{ 0x3067 , 0xA4C7},
{ 0x3068 , 0xA4C8},
{ 0x3069 , 0xA4C9},
{ 0x306A , 0xA4CA},
{ 0x306B , 0xA4CB},
{ 0x306C , 0xA4CC},
{ 0x306D , 0xA4CD},
{ 0x306E , 0xA4CE},
{ 0x306F , 0xA4CF},
{ 0x3070 , 0xA4D0},
{ 0x3071 , 0xA4D1},
{ 0x3072 , 0xA4D2},
{ 0x3073 , 0xA4D3},
{ 0x3074 , 0xA4D4},
{ 0x3075 , 0xA4D5},
{ 0x3076 , 0xA4D6},
{ 0x3077 , 0xA4D7},
{ 0x3078 , 0xA4D8},
{ 0x3079 , 0xA4D9},
{ 0x307A , 0xA4DA},
{ 0x307B , 0xA4DB},
{ 0x307C , 0xA4DC},
{ 0x307D , 0xA4DD},
{ 0x307E , 0xA4DE},
{ 0x307F , 0xA4DF},
{ 0x3080 , 0xA4E0},
{ 0x3081 , 0xA4E1},
{ 0x3082 , 0xA4E2},
{ 0x3083 , 0xA4E3},
{ 0x3084 , 0xA4E4},
{ 0x3085 , 0xA4E5},
{ 0x3086 , 0xA4E6},
{ 0x3087 , 0xA4E7},
{ 0x3088 , 0xA4E8},
{ 0x3089 , 0xA4E9},
{ 0x308A , 0xA4EA},
{ 0x308B , 0xA4EB},
{ 0x308C , 0xA4EC},
{ 0x308D , 0xA4ED},
{ 0x308E , 0xA4EE},
{ 0x308F , 0xA4EF},
{ 0x3090 , 0xA4F0},
{ 0x3091 , 0xA4F1},
{ 0x3092 , 0xA4F2},
{ 0x3093 , 0xA4F3},
{ 0xE772 , 0xA4F4},
{ 0xE773 , 0xA4F5},
{ 0xE774 , 0xA4F6},
{ 0xE775 , 0xA4F7},
{ 0xE776 , 0xA4F8},
{ 0xE777 , 0xA4F9},
{ 0xE778 , 0xA4FA},
{ 0xE779 , 0xA4FB},
{ 0xE77A , 0xA4FC},
{ 0xE77B , 0xA4FD},
{ 0xE77C , 0xA4FE},
{ 0xE646 , 0xA540},
{ 0xE647 , 0xA541},
{ 0xE648 , 0xA542},
{ 0xE649 , 0xA543},
{ 0xE64A , 0xA544},
{ 0xE64B , 0xA545},
{ 0xE64C , 0xA546},
{ 0xE64D , 0xA547},
{ 0xE64E , 0xA548},
{ 0xE64F , 0xA549},
{ 0xE650 , 0xA54A},
{ 0xE651 , 0xA54B},
{ 0xE652 , 0xA54C},
{ 0xE653 , 0xA54D},
{ 0xE654 , 0xA54E},
{ 0xE655 , 0xA54F},
{ 0xE656 , 0xA550},
{ 0xE657 , 0xA551},
{ 0xE658 , 0xA552},
{ 0xE659 , 0xA553},
{ 0xE65A , 0xA554},
{ 0xE65B , 0xA555},
{ 0xE65C , 0xA556},
{ 0xE65D , 0xA557},
{ 0xE65E , 0xA558},
{ 0xE65F , 0xA559},
{ 0xE660 , 0xA55A},
{ 0xE661 , 0xA55B},
{ 0xE662 , 0xA55C},
{ 0xE663 , 0xA55D},
{ 0xE664 , 0xA55E},
{ 0xE665 , 0xA55F},
{ 0xE666 , 0xA560},
{ 0xE667 , 0xA561},
{ 0xE668 , 0xA562},
{ 0xE669 , 0xA563},
{ 0xE66A , 0xA564},
{ 0xE66B , 0xA565},
{ 0xE66C , 0xA566},
{ 0xE66D , 0xA567},
{ 0xE66E , 0xA568},
{ 0xE66F , 0xA569},
{ 0xE670 , 0xA56A},
{ 0xE671 , 0xA56B},
{ 0xE672 , 0xA56C},
{ 0xE673 , 0xA56D},
{ 0xE674 , 0xA56E},
{ 0xE675 , 0xA56F},
{ 0xE676 , 0xA570},
{ 0xE677 , 0xA571},
{ 0xE678 , 0xA572},
{ 0xE679 , 0xA573},
{ 0xE67A , 0xA574},
{ 0xE67B , 0xA575},
{ 0xE67C , 0xA576},
{ 0xE67D , 0xA577},
{ 0xE67E , 0xA578},
{ 0xE67F , 0xA579},
{ 0xE680 , 0xA57A},
{ 0xE681 , 0xA57B},
{ 0xE682 , 0xA57C},
{ 0xE683 , 0xA57D},
{ 0xE684 , 0xA57E},
{ 0xE685 , 0xA580},
{ 0xE686 , 0xA581},
{ 0xE687 , 0xA582},
{ 0xE688 , 0xA583},
{ 0xE689 , 0xA584},
{ 0xE68A , 0xA585},
{ 0xE68B , 0xA586},
{ 0xE68C , 0xA587},
{ 0xE68D , 0xA588},
{ 0xE68E , 0xA589},
{ 0xE68F , 0xA58A},
{ 0xE690 , 0xA58B},
{ 0xE691 , 0xA58C},
{ 0xE692 , 0xA58D},
{ 0xE693 , 0xA58E},
{ 0xE694 , 0xA58F},
{ 0xE695 , 0xA590},
{ 0xE696 , 0xA591},
{ 0xE697 , 0xA592},
{ 0xE698 , 0xA593},
{ 0xE699 , 0xA594},
{ 0xE69A , 0xA595},
{ 0xE69B , 0xA596},
{ 0xE69C , 0xA597},
{ 0xE69D , 0xA598},
{ 0xE69E , 0xA599},
{ 0xE69F , 0xA59A},
{ 0xE6A0 , 0xA59B},
{ 0xE6A1 , 0xA59C},
{ 0xE6A2 , 0xA59D},
{ 0xE6A3 , 0xA59E},
{ 0xE6A4 , 0xA59F},
{ 0xE6A5 , 0xA5A0},
{ 0x30A1 , 0xA5A1},
{ 0x30A2 , 0xA5A2},
{ 0x30A3 , 0xA5A3},
{ 0x30A4 , 0xA5A4},
{ 0x30A5 , 0xA5A5},
{ 0x30A6 , 0xA5A6},
{ 0x30A7 , 0xA5A7},
{ 0x30A8 , 0xA5A8},
{ 0x30A9 , 0xA5A9},
{ 0x30AA , 0xA5AA},
{ 0x30AB , 0xA5AB},
{ 0x30AC , 0xA5AC},
{ 0x30AD , 0xA5AD},
{ 0x30AE , 0xA5AE},
{ 0x30AF , 0xA5AF},
{ 0x30B0 , 0xA5B0},
{ 0x30B1 , 0xA5B1},
{ 0x30B2 , 0xA5B2},
{ 0x30B3 , 0xA5B3},
{ 0x30B4 , 0xA5B4},
{ 0x30B5 , 0xA5B5},
{ 0x30B6 , 0xA5B6},
{ 0x30B7 , 0xA5B7},
{ 0x30B8 , 0xA5B8},
{ 0x30B9 , 0xA5B9},
{ 0x30BA , 0xA5BA},
{ 0x30BB , 0xA5BB},
{ 0x30BC , 0xA5BC},
{ 0x30BD , 0xA5BD},
{ 0x30BE , 0xA5BE},
{ 0x30BF , 0xA5BF},
{ 0x30C0 , 0xA5C0},
{ 0x30C1 , 0xA5C1},
{ 0x30C2 , 0xA5C2},
{ 0x30C3 , 0xA5C3},
{ 0x30C4 , 0xA5C4},
{ 0x30C5 , 0xA5C5},
{ 0x30C6 , 0xA5C6},
{ 0x30C7 , 0xA5C7},
{ 0x30C8 , 0xA5C8},
{ 0x30C9 , 0xA5C9},
{ 0x30CA , 0xA5CA},
{ 0x30CB , 0xA5CB},
{ 0x30CC , 0xA5CC},
{ 0x30CD , 0xA5CD},
{ 0x30CE , 0xA5CE},
{ 0x30CF , 0xA5CF},
{ 0x30D0 , 0xA5D0},
{ 0x30D1 , 0xA5D1},
{ 0x30D2 , 0xA5D2},
{ 0x30D3 , 0xA5D3},
{ 0x30D4 , 0xA5D4},
{ 0x30D5 , 0xA5D5},
{ 0x30D6 , 0xA5D6},
{ 0x30D7 , 0xA5D7},
{ 0x30D8 , 0xA5D8},
{ 0x30D9 , 0xA5D9},
{ 0x30DA , 0xA5DA},
{ 0x30DB , 0xA5DB},
{ 0x30DC , 0xA5DC},
{ 0x30DD , 0xA5DD},
{ 0x30DE , 0xA5DE},
{ 0x30DF , 0xA5DF},
{ 0x30E0 , 0xA5E0},
{ 0x30E1 , 0xA5E1},
{ 0x30E2 , 0xA5E2},
{ 0x30E3 , 0xA5E3},
{ 0x30E4 , 0xA5E4},
{ 0x30E5 , 0xA5E5},
{ 0x30E6 , 0xA5E6},
{ 0x30E7 , 0xA5E7},
{ 0x30E8 , 0xA5E8},
{ 0x30E9 , 0xA5E9},
{ 0x30EA , 0xA5EA},
{ 0x30EB , 0xA5EB},
{ 0x30EC , 0xA5EC},
{ 0x30ED , 0xA5ED},
{ 0x30EE , 0xA5EE},
{ 0x30EF , 0xA5EF},
{ 0x30F0 , 0xA5F0},
{ 0x30F1 , 0xA5F1},
{ 0x30F2 , 0xA5F2},
{ 0x30F3 , 0xA5F3},
{ 0x30F4 , 0xA5F4},
{ 0x30F5 , 0xA5F5},
{ 0x30F6 , 0xA5F6},
{ 0xE77D , 0xA5F7},
{ 0xE77E , 0xA5F8},
{ 0xE77F , 0xA5F9},
{ 0xE780 , 0xA5FA},
{ 0xE781 , 0xA5FB},
{ 0xE782 , 0xA5FC},
{ 0xE783 , 0xA5FD},
{ 0xE784 , 0xA5FE},
{ 0xE6A6 , 0xA640},
{ 0xE6A7 , 0xA641},
{ 0xE6A8 , 0xA642},
{ 0xE6A9 , 0xA643},
{ 0xE6AA , 0xA644},
{ 0xE6AB , 0xA645},
{ 0xE6AC , 0xA646},
{ 0xE6AD , 0xA647},
{ 0xE6AE , 0xA648},
{ 0xE6AF , 0xA649},
{ 0xE6B0 , 0xA64A},
{ 0xE6B1 , 0xA64B},
{ 0xE6B2 , 0xA64C},
{ 0xE6B3 , 0xA64D},
{ 0xE6B4 , 0xA64E},
{ 0xE6B5 , 0xA64F},
{ 0xE6B6 , 0xA650},
{ 0xE6B7 , 0xA651},
{ 0xE6B8 , 0xA652},
{ 0xE6B9 , 0xA653},
{ 0xE6BA , 0xA654},
{ 0xE6BB , 0xA655},
{ 0xE6BC , 0xA656},
{ 0xE6BD , 0xA657},
{ 0xE6BE , 0xA658},
{ 0xE6BF , 0xA659},
{ 0xE6C0 , 0xA65A},
{ 0xE6C1 , 0xA65B},
{ 0xE6C2 , 0xA65C},
{ 0xE6C3 , 0xA65D},
{ 0xE6C4 , 0xA65E},
{ 0xE6C5 , 0xA65F},
{ 0xE6C6 , 0xA660},
{ 0xE6C7 , 0xA661},
{ 0xE6C8 , 0xA662},
{ 0xE6C9 , 0xA663},
{ 0xE6CA , 0xA664},
{ 0xE6CB , 0xA665},
{ 0xE6CC , 0xA666},
{ 0xE6CD , 0xA667},
{ 0xE6CE , 0xA668},
{ 0xE6CF , 0xA669},
{ 0xE6D0 , 0xA66A},
{ 0xE6D1 , 0xA66B},
{ 0xE6D2 , 0xA66C},
{ 0xE6D3 , 0xA66D},
{ 0xE6D4 , 0xA66E},
{ 0xE6D5 , 0xA66F},
{ 0xE6D6 , 0xA670},
{ 0xE6D7 , 0xA671},
{ 0xE6D8 , 0xA672},
{ 0xE6D9 , 0xA673},
{ 0xE6DA , 0xA674},
{ 0xE6DB , 0xA675},
{ 0xE6DC , 0xA676},
{ 0xE6DD , 0xA677},
{ 0xE6DE , 0xA678},
{ 0xE6DF , 0xA679},
{ 0xE6E0 , 0xA67A},
{ 0xE6E1 , 0xA67B},
{ 0xE6E2 , 0xA67C},
{ 0xE6E3 , 0xA67D},
{ 0xE6E4 , 0xA67E},
{ 0xE6E5 , 0xA680},
{ 0xE6E6 , 0xA681},
{ 0xE6E7 , 0xA682},
{ 0xE6E8 , 0xA683},
{ 0xE6E9 , 0xA684},
{ 0xE6EA , 0xA685},
{ 0xE6EB , 0xA686},
{ 0xE6EC , 0xA687},
{ 0xE6ED , 0xA688},
{ 0xE6EE , 0xA689},
{ 0xE6EF , 0xA68A},
{ 0xE6F0 , 0xA68B},
{ 0xE6F1 , 0xA68C},
{ 0xE6F2 , 0xA68D},
{ 0xE6F3 , 0xA68E},
{ 0xE6F4 , 0xA68F},
{ 0xE6F5 , 0xA690},
{ 0xE6F6 , 0xA691},
{ 0xE6F7 , 0xA692},
{ 0xE6F8 , 0xA693},
{ 0xE6F9 , 0xA694},
{ 0xE6FA , 0xA695},
{ 0xE6FB , 0xA696},
{ 0xE6FC , 0xA697},
{ 0xE6FD , 0xA698},
{ 0xE6FE , 0xA699},
{ 0xE6FF , 0xA69A},
{ 0xE700 , 0xA69B},
{ 0xE701 , 0xA69C},
{ 0xE702 , 0xA69D},
{ 0xE703 , 0xA69E},
{ 0xE704 , 0xA69F},
{ 0xE705 , 0xA6A0},
{ 0x0391 , 0xA6A1},
{ 0x0392 , 0xA6A2},
{ 0x0393 , 0xA6A3},
{ 0x0394 , 0xA6A4},
{ 0x0395 , 0xA6A5},
{ 0x0396 , 0xA6A6},
{ 0x0397 , 0xA6A7},
{ 0x0398 , 0xA6A8},
{ 0x0399 , 0xA6A9},
{ 0x039A , 0xA6AA},
{ 0x039B , 0xA6AB},
{ 0x039C , 0xA6AC},
{ 0x039D , 0xA6AD},
{ 0x039E , 0xA6AE},
{ 0x039F , 0xA6AF},
{ 0x03A0 , 0xA6B0},
{ 0x03A1 , 0xA6B1},
{ 0x03A3 , 0xA6B2},
{ 0x03A4 , 0xA6B3},
{ 0x03A5 , 0xA6B4},
{ 0x03A6 , 0xA6B5},
{ 0x03A7 , 0xA6B6},
{ 0x03A8 , 0xA6B7},
{ 0x03A9 , 0xA6B8},
{ 0xE785 , 0xA6B9},
{ 0xE786 , 0xA6BA},
{ 0xE787 , 0xA6BB},
{ 0xE788 , 0xA6BC},
{ 0xE789 , 0xA6BD},
{ 0xE78A , 0xA6BE},
{ 0xE78B , 0xA6BF},
{ 0xE78C , 0xA6C0},
{ 0x03B1 , 0xA6C1},
{ 0x03B2 , 0xA6C2},
{ 0x03B3 , 0xA6C3},
{ 0x03B4 , 0xA6C4},
{ 0x03B5 , 0xA6C5},
{ 0x03B6 , 0xA6C6},
{ 0x03B7 , 0xA6C7},
{ 0x03B8 , 0xA6C8},
{ 0x03B9 , 0xA6C9},
{ 0x03BA , 0xA6CA},
{ 0x03BB , 0xA6CB},
{ 0x03BC , 0xA6CC},
{ 0x03BD , 0xA6CD},
{ 0x03BE , 0xA6CE},
{ 0x03BF , 0xA6CF},
{ 0x03C0 , 0xA6D0},
{ 0x03C1 , 0xA6D1},
{ 0x03C3 , 0xA6D2},
{ 0x03C4 , 0xA6D3},
{ 0x03C5 , 0xA6D4},
{ 0x03C6 , 0xA6D5},
{ 0x03C7 , 0xA6D6},
{ 0x03C8 , 0xA6D7},
{ 0x03C9 , 0xA6D8},
{ 0xE78D , 0xA6D9},
{ 0xE78E , 0xA6DA},
{ 0xE78F , 0xA6DB},
{ 0xE790 , 0xA6DC},
{ 0xE791 , 0xA6DD},
{ 0xE792 , 0xA6DE},
{ 0xE793 , 0xA6DF},
{ 0xFE35 , 0xA6E0},
{ 0xFE36 , 0xA6E1},
{ 0xFE39 , 0xA6E2},
{ 0xFE3A , 0xA6E3},
{ 0xFE3F , 0xA6E4},
{ 0xFE40 , 0xA6E5},
{ 0xFE3D , 0xA6E6},
{ 0xFE3E , 0xA6E7},
{ 0xFE41 , 0xA6E8},
{ 0xFE42 , 0xA6E9},
{ 0xFE43 , 0xA6EA},
{ 0xFE44 , 0xA6EB},
{ 0xE794 , 0xA6EC},
{ 0xE795 , 0xA6ED},
{ 0xFE3B , 0xA6EE},
{ 0xFE3C , 0xA6EF},
{ 0xFE37 , 0xA6F0},
{ 0xFE38 , 0xA6F1},
{ 0xFE31 , 0xA6F2},
{ 0xE796 , 0xA6F3},
{ 0xFE33 , 0xA6F4},
{ 0xFE34 , 0xA6F5},
{ 0xE797 , 0xA6F6},
{ 0xE798 , 0xA6F7},
{ 0xE799 , 0xA6F8},
{ 0xE79A , 0xA6F9},
{ 0xE79B , 0xA6FA},
{ 0xE79C , 0xA6FB},
{ 0xE79D , 0xA6FC},
{ 0xE79E , 0xA6FD},
{ 0xE79F , 0xA6FE},
{ 0xE706 , 0xA740},
{ 0xE707 , 0xA741},
{ 0xE708 , 0xA742},
{ 0xE709 , 0xA743},
{ 0xE70A , 0xA744},
{ 0xE70B , 0xA745},
{ 0xE70C , 0xA746},
{ 0xE70D , 0xA747},
{ 0xE70E , 0xA748},
{ 0xE70F , 0xA749},
{ 0xE710 , 0xA74A},
{ 0xE711 , 0xA74B},
{ 0xE712 , 0xA74C},
{ 0xE713 , 0xA74D},
{ 0xE714 , 0xA74E},
{ 0xE715 , 0xA74F},
{ 0xE716 , 0xA750},
{ 0xE717 , 0xA751},
{ 0xE718 , 0xA752},
{ 0xE719 , 0xA753},
{ 0xE71A , 0xA754},
{ 0xE71B , 0xA755},
{ 0xE71C , 0xA756},
{ 0xE71D , 0xA757},
{ 0xE71E , 0xA758},
{ 0xE71F , 0xA759},
{ 0xE720 , 0xA75A},
{ 0xE721 , 0xA75B},
{ 0xE722 , 0xA75C},
{ 0xE723 , 0xA75D},
{ 0xE724 , 0xA75E},
{ 0xE725 , 0xA75F},
{ 0xE726 , 0xA760},
{ 0xE727 , 0xA761},
{ 0xE728 , 0xA762},
{ 0xE729 , 0xA763},
{ 0xE72A , 0xA764},
{ 0xE72B , 0xA765},
{ 0xE72C , 0xA766},
{ 0xE72D , 0xA767},
{ 0xE72E , 0xA768},
{ 0xE72F , 0xA769},
{ 0xE730 , 0xA76A},
{ 0xE731 , 0xA76B},
{ 0xE732 , 0xA76C},
{ 0xE733 , 0xA76D},
{ 0xE734 , 0xA76E},
{ 0xE735 , 0xA76F},
{ 0xE736 , 0xA770},
{ 0xE737 , 0xA771},
{ 0xE738 , 0xA772},
{ 0xE739 , 0xA773},
{ 0xE73A , 0xA774},
{ 0xE73B , 0xA775},
{ 0xE73C , 0xA776},
{ 0xE73D , 0xA777},
{ 0xE73E , 0xA778},
{ 0xE73F , 0xA779},
{ 0xE740 , 0xA77A},
{ 0xE741 , 0xA77B},
{ 0xE742 , 0xA77C},
{ 0xE743 , 0xA77D},
{ 0xE744 , 0xA77E},
{ 0xE745 , 0xA780},
{ 0xE746 , 0xA781},
{ 0xE747 , 0xA782},
{ 0xE748 , 0xA783},
{ 0xE749 , 0xA784},
{ 0xE74A , 0xA785},
{ 0xE74B , 0xA786},
{ 0xE74C , 0xA787},
{ 0xE74D , 0xA788},
{ 0xE74E , 0xA789},
{ 0xE74F , 0xA78A},
{ 0xE750 , 0xA78B},
{ 0xE751 , 0xA78C},
{ 0xE752 , 0xA78D},
{ 0xE753 , 0xA78E},
{ 0xE754 , 0xA78F},
{ 0xE755 , 0xA790},
{ 0xE756 , 0xA791},
{ 0xE757 , 0xA792},
{ 0xE758 , 0xA793},
{ 0xE759 , 0xA794},
{ 0xE75A , 0xA795},
{ 0xE75B , 0xA796},
{ 0xE75C , 0xA797},
{ 0xE75D , 0xA798},
{ 0xE75E , 0xA799},
{ 0xE75F , 0xA79A},
{ 0xE760 , 0xA79B},
{ 0xE761 , 0xA79C},
{ 0xE762 , 0xA79D},
{ 0xE763 , 0xA79E},
{ 0xE764 , 0xA79F},
{ 0xE765 , 0xA7A0},
{ 0x0410 , 0xA7A1},
{ 0x0411 , 0xA7A2},
{ 0x0412 , 0xA7A3},
{ 0x0413 , 0xA7A4},
{ 0x0414 , 0xA7A5},
{ 0x0415 , 0xA7A6},
{ 0x0401 , 0xA7A7},
{ 0x0416 , 0xA7A8},
{ 0x0417 , 0xA7A9},
{ 0x0418 , 0xA7AA},
{ 0x0419 , 0xA7AB},
{ 0x041A , 0xA7AC},
{ 0x041B , 0xA7AD},
{ 0x041C , 0xA7AE},
{ 0x041D , 0xA7AF},
{ 0x041E , 0xA7B0},
{ 0x041F , 0xA7B1},
{ 0x0420 , 0xA7B2},
{ 0x0421 , 0xA7B3},
{ 0x0422 , 0xA7B4},
{ 0x0423 , 0xA7B5},
{ 0x0424 , 0xA7B6},
{ 0x0425 , 0xA7B7},
{ 0x0426 , 0xA7B8},
{ 0x0427 , 0xA7B9},
{ 0x0428 , 0xA7BA},
{ 0x0429 , 0xA7BB},
{ 0x042A , 0xA7BC},
{ 0x042B , 0xA7BD},
{ 0x042C , 0xA7BE},
{ 0x042D , 0xA7BF},
{ 0x042E , 0xA7C0},
{ 0x042F , 0xA7C1},
{ 0xE7A0 , 0xA7C2},
{ 0xE7A1 , 0xA7C3},
{ 0xE7A2 , 0xA7C4},
{ 0xE7A3 , 0xA7C5},
{ 0xE7A4 , 0xA7C6},
{ 0xE7A5 , 0xA7C7},
{ 0xE7A6 , 0xA7C8},
{ 0xE7A7 , 0xA7C9},
{ 0xE7A8 , 0xA7CA},
{ 0xE7A9 , 0xA7CB},
{ 0xE7AA , 0xA7CC},
{ 0xE7AB , 0xA7CD},
{ 0xE7AC , 0xA7CE},
{ 0xE7AD , 0xA7CF},
{ 0xE7AE , 0xA7D0},
{ 0x0430 , 0xA7D1},
{ 0x0431 , 0xA7D2},
{ 0x0432 , 0xA7D3},
{ 0x0433 , 0xA7D4},
{ 0x0434 , 0xA7D5},
{ 0x0435 , 0xA7D6},
{ 0x0451 , 0xA7D7},
{ 0x0436 , 0xA7D8},
{ 0x0437 , 0xA7D9},
{ 0x0438 , 0xA7DA},
{ 0x0439 , 0xA7DB},
{ 0x043A , 0xA7DC},
{ 0x043B , 0xA7DD},
{ 0x043C , 0xA7DE},
{ 0x043D , 0xA7DF},
{ 0x043E , 0xA7E0},
{ 0x043F , 0xA7E1},
{ 0x0440 , 0xA7E2},
{ 0x0441 , 0xA7E3},
{ 0x0442 , 0xA7E4},
{ 0x0443 , 0xA7E5},
{ 0x0444 , 0xA7E6},
{ 0x0445 , 0xA7E7},
{ 0x0446 , 0xA7E8},
{ 0x0447 , 0xA7E9},
{ 0x0448 , 0xA7EA},
{ 0x0449 , 0xA7EB},
{ 0x044A , 0xA7EC},
{ 0x044B , 0xA7ED},
{ 0x044C , 0xA7EE},
{ 0x044D , 0xA7EF},
{ 0x044E , 0xA7F0},
{ 0x044F , 0xA7F1},
{ 0xE7AF , 0xA7F2},
{ 0xE7B0 , 0xA7F3},
{ 0xE7B1 , 0xA7F4},
{ 0xE7B2 , 0xA7F5},
{ 0xE7B3 , 0xA7F6},
{ 0xE7B4 , 0xA7F7},
{ 0xE7B5 , 0xA7F8},
{ 0xE7B6 , 0xA7F9},
{ 0xE7B7 , 0xA7FA},
{ 0xE7B8 , 0xA7FB},
{ 0xE7B9 , 0xA7FC},
{ 0xE7BA , 0xA7FD},
{ 0xE7BB , 0xA7FE},
{ 0x02CA , 0xA840},
{ 0x02CB , 0xA841},
{ 0x02D9 , 0xA842},
{ 0x2013 , 0xA843},
{ 0x2015 , 0xA844},
{ 0x2025 , 0xA845},
{ 0x2035 , 0xA846},
{ 0x2105 , 0xA847},
{ 0x2109 , 0xA848},
{ 0x2196 , 0xA849},
{ 0x2197 , 0xA84A},
{ 0x2198 , 0xA84B},
{ 0x2199 , 0xA84C},
{ 0x2215 , 0xA84D},
{ 0x221F , 0xA84E},
{ 0x2223 , 0xA84F},
{ 0x2252 , 0xA850},
{ 0x2266 , 0xA851},
{ 0x2267 , 0xA852},
{ 0x22BF , 0xA853},
{ 0x2550 , 0xA854},
{ 0x2551 , 0xA855},
{ 0x2552 , 0xA856},
{ 0x2553 , 0xA857},
{ 0x2554 , 0xA858},
{ 0x2555 , 0xA859},
{ 0x2556 , 0xA85A},
{ 0x2557 , 0xA85B},
{ 0x2558 , 0xA85C},
{ 0x2559 , 0xA85D},
{ 0x255A , 0xA85E},
{ 0x255B , 0xA85F},
{ 0x255C , 0xA860},
{ 0x255D , 0xA861},
{ 0x255E , 0xA862},
{ 0x255F , 0xA863},
{ 0x2560 , 0xA864},
{ 0x2561 , 0xA865},
{ 0x2562 , 0xA866},
{ 0x2563 , 0xA867},
{ 0x2564 , 0xA868},
{ 0x2565 , 0xA869},
{ 0x2566 , 0xA86A},
{ 0x2567 , 0xA86B},
{ 0x2568 , 0xA86C},
{ 0x2569 , 0xA86D},
{ 0x256A , 0xA86E},
{ 0x256B , 0xA86F},
{ 0x256C , 0xA870},
{ 0x256D , 0xA871},
{ 0x256E , 0xA872},
{ 0x256F , 0xA873},
{ 0x2570 , 0xA874},
{ 0x2571 , 0xA875},
{ 0x2572 , 0xA876},
{ 0x2573 , 0xA877},
{ 0x2581 , 0xA878},
{ 0x2582 , 0xA879},
{ 0x2583 , 0xA87A},
{ 0x2584 , 0xA87B},
{ 0x2585 , 0xA87C},
{ 0x2586 , 0xA87D},
{ 0x2587 , 0xA87E},
{ 0x2588 , 0xA880},
{ 0x2589 , 0xA881},
{ 0x258A , 0xA882},
{ 0x258B , 0xA883},
{ 0x258C , 0xA884},
{ 0x258D , 0xA885},
{ 0x258E , 0xA886},
{ 0x258F , 0xA887},
{ 0x2593 , 0xA888},
{ 0x2594 , 0xA889},
{ 0x2595 , 0xA88A},
{ 0x25BC , 0xA88B},
{ 0x25BD , 0xA88C},
{ 0x25E2 , 0xA88D},
{ 0x25E3 , 0xA88E},
{ 0x25E4 , 0xA88F},
{ 0x25E5 , 0xA890},
{ 0x2609 , 0xA891},
{ 0x2295 , 0xA892},
{ 0x3012 , 0xA893},
{ 0x301D , 0xA894},
{ 0x301E , 0xA895},
{ 0xE7BC , 0xA896},
{ 0xE7BD , 0xA897},
{ 0xE7BE , 0xA898},
{ 0xE7BF , 0xA899},
{ 0xE7C0 , 0xA89A},
{ 0xE7C1 , 0xA89B},
{ 0xE7C2 , 0xA89C},
{ 0xE7C3 , 0xA89D},
{ 0xE7C4 , 0xA89E},
{ 0xE7C5 , 0xA89F},
{ 0xE7C6 , 0xA8A0},
{ 0x0101 , 0xA8A1},
{ 0x00E1 , 0xA8A2},
{ 0x01CE , 0xA8A3},
{ 0x00E0 , 0xA8A4},
{ 0x0113 , 0xA8A5},
{ 0x00E9 , 0xA8A6},
{ 0x011B , 0xA8A7},
{ 0x00E8 , 0xA8A8},
{ 0x012B , 0xA8A9},
{ 0x00ED , 0xA8AA},
{ 0x01D0 , 0xA8AB},
{ 0x00EC , 0xA8AC},
{ 0x014D , 0xA8AD},
{ 0x00F3 , 0xA8AE},
{ 0x01D2 , 0xA8AF},
{ 0x00F2 , 0xA8B0},
{ 0x016B , 0xA8B1},
{ 0x00FA , 0xA8B2},
{ 0x01D4 , 0xA8B3},
{ 0x00F9 , 0xA8B4},
{ 0x01D6 , 0xA8B5},
{ 0x01D8 , 0xA8B6},
{ 0x01DA , 0xA8B7},
{ 0x01DC , 0xA8B8},
{ 0x00FC , 0xA8B9},
{ 0x00EA , 0xA8BA},
{ 0x0251 , 0xA8BB},
{ 0xE7C7 , 0xA8BC},
{ 0x0144 , 0xA8BD},
{ 0x0148 , 0xA8BE},
{ 0x01F9 , 0xA8BF},
{ 0x0261 , 0xA8C0},
{ 0xE7C9 , 0xA8C1},
{ 0xE7CA , 0xA8C2},
{ 0xE7CB , 0xA8C3},
{ 0xE7CC , 0xA8C4},
{ 0x3105 , 0xA8C5},
{ 0x3106 , 0xA8C6},
{ 0x3107 , 0xA8C7},
{ 0x3108 , 0xA8C8},
{ 0x3109 , 0xA8C9},
{ 0x310A , 0xA8CA},
{ 0x310B , 0xA8CB},
{ 0x310C , 0xA8CC},
{ 0x310D , 0xA8CD},
{ 0x310E , 0xA8CE},
{ 0x310F , 0xA8CF},
{ 0x3110 , 0xA8D0},
{ 0x3111 , 0xA8D1},
{ 0x3112 , 0xA8D2},
{ 0x3113 , 0xA8D3},
{ 0x3114 , 0xA8D4},
{ 0x3115 , 0xA8D5},
{ 0x3116 , 0xA8D6},
{ 0x3117 , 0xA8D7},
{ 0x3118 , 0xA8D8},
{ 0x3119 , 0xA8D9},
{ 0x311A , 0xA8DA},
{ 0x311B , 0xA8DB},
{ 0x311C , 0xA8DC},
{ 0x311D , 0xA8DD},
{ 0x311E , 0xA8DE},
{ 0x311F , 0xA8DF},
{ 0x3120 , 0xA8E0},
{ 0x3121 , 0xA8E1},
{ 0x3122 , 0xA8E2},
{ 0x3123 , 0xA8E3},
{ 0x3124 , 0xA8E4},
{ 0x3125 , 0xA8E5},
{ 0x3126 , 0xA8E6},
{ 0x3127 , 0xA8E7},
{ 0x3128 , 0xA8E8},
{ 0x3129 , 0xA8E9},
{ 0xE7CD , 0xA8EA},
{ 0xE7CE , 0xA8EB},
{ 0xE7CF , 0xA8EC},
{ 0xE7D0 , 0xA8ED},
{ 0xE7D1 , 0xA8EE},
{ 0xE7D2 , 0xA8EF},
{ 0xE7D3 , 0xA8F0},
{ 0xE7D4 , 0xA8F1},
{ 0xE7D5 , 0xA8F2},
{ 0xE7D6 , 0xA8F3},
{ 0xE7D7 , 0xA8F4},
{ 0xE7D8 , 0xA8F5},
{ 0xE7D9 , 0xA8F6},
{ 0xE7DA , 0xA8F7},
{ 0xE7DB , 0xA8F8},
{ 0xE7DC , 0xA8F9},
{ 0xE7DD , 0xA8FA},
{ 0xE7DE , 0xA8FB},
{ 0xE7DF , 0xA8FC},
{ 0xE7E0 , 0xA8FD},
{ 0xE7E1 , 0xA8FE},
{ 0x3021 , 0xA940},
{ 0x3022 , 0xA941},
{ 0x3023 , 0xA942},
{ 0x3024 , 0xA943},
{ 0x3025 , 0xA944},
{ 0x3026 , 0xA945},
{ 0x3027 , 0xA946},
{ 0x3028 , 0xA947},
{ 0x3029 , 0xA948},
{ 0x32A3 , 0xA949},
{ 0x338E , 0xA94A},
{ 0x338F , 0xA94B},
{ 0x339C , 0xA94C},
{ 0x339D , 0xA94D},
{ 0x339E , 0xA94E},
{ 0x33A1 , 0xA94F},
{ 0x33C4 , 0xA950},
{ 0x33CE , 0xA951},
{ 0x33D1 , 0xA952},
{ 0x33D2 , 0xA953},
{ 0x33D5 , 0xA954},
{ 0xFE30 , 0xA955},
{ 0xFFE2 , 0xA956},
{ 0xFFE4 , 0xA957},
{ 0xE7E2 , 0xA958},
{ 0x2121 , 0xA959},
{ 0x3231 , 0xA95A},
{ 0xE7E3 , 0xA95B},
{ 0x2010 , 0xA95C},
{ 0xE7E4 , 0xA95D},
{ 0xE7E5 , 0xA95E},
{ 0xE7E6 , 0xA95F},
{ 0x30FC , 0xA960},
{ 0x309B , 0xA961},
{ 0x309C , 0xA962},
{ 0x30FD , 0xA963},
{ 0x30FE , 0xA964},
{ 0x3006 , 0xA965},
{ 0x309D , 0xA966},
{ 0x309E , 0xA967},
{ 0xFE49 , 0xA968},
{ 0xFE4A , 0xA969},
{ 0xFE4B , 0xA96A},
{ 0xFE4C , 0xA96B},
{ 0xFE4D , 0xA96C},
{ 0xFE4E , 0xA96D},
{ 0xFE4F , 0xA96E},
{ 0xFE50 , 0xA96F},
{ 0xFE51 , 0xA970},
{ 0xFE52 , 0xA971},
{ 0xFE54 , 0xA972},
{ 0xFE55 , 0xA973},
{ 0xFE56 , 0xA974},
{ 0xFE57 , 0xA975},
{ 0xFE59 , 0xA976},
{ 0xFE5A , 0xA977},
{ 0xFE5B , 0xA978},
{ 0xFE5C , 0xA979},
{ 0xFE5D , 0xA97A},
{ 0xFE5E , 0xA97B},
{ 0xFE5F , 0xA97C},
{ 0xFE60 , 0xA97D},
{ 0xFE61 , 0xA97E},
{ 0xFE62 , 0xA980},
{ 0xFE63 , 0xA981},
{ 0xFE64 , 0xA982},
{ 0xFE65 , 0xA983},
{ 0xFE66 , 0xA984},
{ 0xFE68 , 0xA985},
{ 0xFE69 , 0xA986},
{ 0xFE6A , 0xA987},
{ 0xFE6B , 0xA988},
{ 0x303E , 0xA989},
{ 0x2FF0 , 0xA98A},
{ 0x2FF1 , 0xA98B},
{ 0x2FF2 , 0xA98C},
{ 0x2FF3 , 0xA98D},
{ 0x2FF4 , 0xA98E},
{ 0x2FF5 , 0xA98F},
{ 0x2FF6 , 0xA990},
{ 0x2FF7 , 0xA991},
{ 0x2FF8 , 0xA992},
{ 0x2FF9 , 0xA993},
{ 0x2FFA , 0xA994},
{ 0x2FFB , 0xA995},
{ 0x3007 , 0xA996},
{ 0xE7F4 , 0xA997},
{ 0xE7F5 , 0xA998},
{ 0xE7F6 , 0xA999},
{ 0xE7F7 , 0xA99A},
{ 0xE7F8 , 0xA99B},
{ 0xE7F9 , 0xA99C},
{ 0xE7FA , 0xA99D},
{ 0xE7FB , 0xA99E},
{ 0xE7FC , 0xA99F},
{ 0xE7FD , 0xA9A0},
{ 0xE7FE , 0xA9A1},
{ 0xE7FF , 0xA9A2},
{ 0xE800 , 0xA9A3},
{ 0x2500 , 0xA9A4},
{ 0x2501 , 0xA9A5},
{ 0x2502 , 0xA9A6},
{ 0x2503 , 0xA9A7},
{ 0x2504 , 0xA9A8},
{ 0x2505 , 0xA9A9},
{ 0x2506 , 0xA9AA},
{ 0x2507 , 0xA9AB},
{ 0x2508 , 0xA9AC},
{ 0x2509 , 0xA9AD},
{ 0x250A , 0xA9AE},
{ 0x250B , 0xA9AF},
{ 0x250C , 0xA9B0},
{ 0x250D , 0xA9B1},
{ 0x250E , 0xA9B2},
{ 0x250F , 0xA9B3},
{ 0x2510 , 0xA9B4},
{ 0x2511 , 0xA9B5},
{ 0x2512 , 0xA9B6},
{ 0x2513 , 0xA9B7},
{ 0x2514 , 0xA9B8},
{ 0x2515 , 0xA9B9},
{ 0x2516 , 0xA9BA},
{ 0x2517 , 0xA9BB},
{ 0x2518 , 0xA9BC},
{ 0x2519 , 0xA9BD},
{ 0x251A , 0xA9BE},
{ 0x251B , 0xA9BF},
{ 0x251C , 0xA9C0},
{ 0x251D , 0xA9C1},
{ 0x251E , 0xA9C2},
{ 0x251F , 0xA9C3},
{ 0x2520 , 0xA9C4},
{ 0x2521 , 0xA9C5},
{ 0x2522 , 0xA9C6},
{ 0x2523 , 0xA9C7},
{ 0x2524 , 0xA9C8},
{ 0x2525 , 0xA9C9},
{ 0x2526 , 0xA9CA},
{ 0x2527 , 0xA9CB},
{ 0x2528 , 0xA9CC},
{ 0x2529 , 0xA9CD},
{ 0x252A , 0xA9CE},
{ 0x252B , 0xA9CF},
{ 0x252C , 0xA9D0},
{ 0x252D , 0xA9D1},
{ 0x252E , 0xA9D2},
{ 0x252F , 0xA9D3},
{ 0x2530 , 0xA9D4},
{ 0x2531 , 0xA9D5},
{ 0x2532 , 0xA9D6},
{ 0x2533 , 0xA9D7},
{ 0x2534 , 0xA9D8},
{ 0x2535 , 0xA9D9},
{ 0x2536 , 0xA9DA},
{ 0x2537 , 0xA9DB},
{ 0x2538 , 0xA9DC},
{ 0x2539 , 0xA9DD},
{ 0x253A , 0xA9DE},
{ 0x253B , 0xA9DF},
{ 0x253C , 0xA9E0},
{ 0x253D , 0xA9E1},
{ 0x253E , 0xA9E2},
{ 0x253F , 0xA9E3},
{ 0x2540 , 0xA9E4},
{ 0x2541 , 0xA9E5},
{ 0x2542 , 0xA9E6},
{ 0x2543 , 0xA9E7},
{ 0x2544 , 0xA9E8},
{ 0x2545 , 0xA9E9},
{ 0x2546 , 0xA9EA},
{ 0x2547 , 0xA9EB},
{ 0x2548 , 0xA9EC},
{ 0x2549 , 0xA9ED},
{ 0x254A , 0xA9EE},
{ 0x254B , 0xA9EF},
{ 0xE801 , 0xA9F0},
{ 0xE802 , 0xA9F1},
{ 0xE803 , 0xA9F2},
{ 0xE804 , 0xA9F3},
{ 0xE805 , 0xA9F4},
{ 0xE806 , 0xA9F5},
{ 0xE807 , 0xA9F6},
{ 0xE808 , 0xA9F7},
{ 0xE809 , 0xA9F8},
{ 0xE80A , 0xA9F9},
{ 0xE80B , 0xA9FA},
{ 0xE80C , 0xA9FB},
{ 0xE80D , 0xA9FC},
{ 0xE80E , 0xA9FD},
{ 0xE80F , 0xA9FE},
{ 0x72DC , 0xAA40},
{ 0x72DD , 0xAA41},
{ 0x72DF , 0xAA42},
{ 0x72E2 , 0xAA43},
{ 0x72E3 , 0xAA44},
{ 0x72E4 , 0xAA45},
{ 0x72E5 , 0xAA46},
{ 0x72E6 , 0xAA47},
{ 0x72E7 , 0xAA48},
{ 0x72EA , 0xAA49},
{ 0x72EB , 0xAA4A},
{ 0x72F5 , 0xAA4B},
{ 0x72F6 , 0xAA4C},
{ 0x72F9 , 0xAA4D},
{ 0x72FD , 0xAA4E},
{ 0x72FE , 0xAA4F},
{ 0x72FF , 0xAA50},
{ 0x7300 , 0xAA51},
{ 0x7302 , 0xAA52},
{ 0x7304 , 0xAA53},
{ 0x7305 , 0xAA54},
{ 0x7306 , 0xAA55},
{ 0x7307 , 0xAA56},
{ 0x7308 , 0xAA57},
{ 0x7309 , 0xAA58},
{ 0x730B , 0xAA59},
{ 0x730C , 0xAA5A},
{ 0x730D , 0xAA5B},
{ 0x730F , 0xAA5C},
{ 0x7310 , 0xAA5D},
{ 0x7311 , 0xAA5E},
{ 0x7312 , 0xAA5F},
{ 0x7314 , 0xAA60},
{ 0x7318 , 0xAA61},
{ 0x7319 , 0xAA62},
{ 0x731A , 0xAA63},
{ 0x731F , 0xAA64},
{ 0x7320 , 0xAA65},
{ 0x7323 , 0xAA66},
{ 0x7324 , 0xAA67},
{ 0x7326 , 0xAA68},
{ 0x7327 , 0xAA69},
{ 0x7328 , 0xAA6A},
{ 0x732D , 0xAA6B},
{ 0x732F , 0xAA6C},
{ 0x7330 , 0xAA6D},
{ 0x7332 , 0xAA6E},
{ 0x7333 , 0xAA6F},
{ 0x7335 , 0xAA70},
{ 0x7336 , 0xAA71},
{ 0x733A , 0xAA72},
{ 0x733B , 0xAA73},
{ 0x733C , 0xAA74},
{ 0x733D , 0xAA75},
{ 0x7340 , 0xAA76},
{ 0x7341 , 0xAA77},
{ 0x7342 , 0xAA78},
{ 0x7343 , 0xAA79},
{ 0x7344 , 0xAA7A},
{ 0x7345 , 0xAA7B},
{ 0x7346 , 0xAA7C},
{ 0x7347 , 0xAA7D},
{ 0x7348 , 0xAA7E},
{ 0x7349 , 0xAA80},
{ 0x734A , 0xAA81},
{ 0x734B , 0xAA82},
{ 0x734C , 0xAA83},
{ 0x734E , 0xAA84},
{ 0x734F , 0xAA85},
{ 0x7351 , 0xAA86},
{ 0x7353 , 0xAA87},
{ 0x7354 , 0xAA88},
{ 0x7355 , 0xAA89},
{ 0x7356 , 0xAA8A},
{ 0x7358 , 0xAA8B},
{ 0x7359 , 0xAA8C},
{ 0x735A , 0xAA8D},
{ 0x735B , 0xAA8E},
{ 0x735C , 0xAA8F},
{ 0x735D , 0xAA90},
{ 0x735E , 0xAA91},
{ 0x735F , 0xAA92},
{ 0x7361 , 0xAA93},
{ 0x7362 , 0xAA94},
{ 0x7363 , 0xAA95},
{ 0x7364 , 0xAA96},
{ 0x7365 , 0xAA97},
{ 0x7366 , 0xAA98},
{ 0x7367 , 0xAA99},
{ 0x7368 , 0xAA9A},
{ 0x7369 , 0xAA9B},
{ 0x736A , 0xAA9C},
{ 0x736B , 0xAA9D},
{ 0x736E , 0xAA9E},
{ 0x7370 , 0xAA9F},
{ 0x7371 , 0xAAA0},
{ 0xE000 , 0xAAA1},
{ 0xE001 , 0xAAA2},
{ 0xE002 , 0xAAA3},
{ 0xE003 , 0xAAA4},
{ 0xE004 , 0xAAA5},
{ 0xE005 , 0xAAA6},
{ 0xE006 , 0xAAA7},
{ 0xE007 , 0xAAA8},
{ 0xE008 , 0xAAA9},
{ 0xE009 , 0xAAAA},
{ 0xE00A , 0xAAAB},
{ 0xE00B , 0xAAAC},
{ 0xE00C , 0xAAAD},
{ 0xE00D , 0xAAAE},
{ 0xE00E , 0xAAAF},
{ 0xE00F , 0xAAB0},
{ 0xE010 , 0xAAB1},
{ 0xE011 , 0xAAB2},
{ 0xE012 , 0xAAB3},
{ 0xE013 , 0xAAB4},
{ 0xE014 , 0xAAB5},
{ 0xE015 , 0xAAB6},
{ 0xE016 , 0xAAB7},
{ 0xE017 , 0xAAB8},
{ 0xE018 , 0xAAB9},
{ 0xE019 , 0xAABA},
{ 0xE01A , 0xAABB},
{ 0xE01B , 0xAABC},
{ 0xE01C , 0xAABD},
{ 0xE01D , 0xAABE},
{ 0xE01E , 0xAABF},
{ 0xE01F , 0xAAC0},
{ 0xE020 , 0xAAC1},
{ 0xE021 , 0xAAC2},
{ 0xE022 , 0xAAC3},
{ 0xE023 , 0xAAC4},
{ 0xE024 , 0xAAC5},
{ 0xE025 , 0xAAC6},
{ 0xE026 , 0xAAC7},
{ 0xE027 , 0xAAC8},
{ 0xE028 , 0xAAC9},
{ 0xE029 , 0xAACA},
{ 0xE02A , 0xAACB},
{ 0xE02B , 0xAACC},
{ 0xE02C , 0xAACD},
{ 0xE02D , 0xAACE},
{ 0xE02E , 0xAACF},
{ 0xE02F , 0xAAD0},
{ 0xE030 , 0xAAD1},
{ 0xE031 , 0xAAD2},
{ 0xE032 , 0xAAD3},
{ 0xE033 , 0xAAD4},
{ 0xE034 , 0xAAD5},
{ 0xE035 , 0xAAD6},
{ 0xE036 , 0xAAD7},
{ 0xE037 , 0xAAD8},
{ 0xE038 , 0xAAD9},
{ 0xE039 , 0xAADA},
{ 0xE03A , 0xAADB},
{ 0xE03B , 0xAADC},
{ 0xE03C , 0xAADD},
{ 0xE03D , 0xAADE},
{ 0xE03E , 0xAADF},
{ 0xE03F , 0xAAE0},
{ 0xE040 , 0xAAE1},
{ 0xE041 , 0xAAE2},
{ 0xE042 , 0xAAE3},
{ 0xE043 , 0xAAE4},
{ 0xE044 , 0xAAE5},
{ 0xE045 , 0xAAE6},
{ 0xE046 , 0xAAE7},
{ 0xE047 , 0xAAE8},
{ 0xE048 , 0xAAE9},
{ 0xE049 , 0xAAEA},
{ 0xE04A , 0xAAEB},
{ 0xE04B , 0xAAEC},
{ 0xE04C , 0xAAED},
{ 0xE04D , 0xAAEE},
{ 0xE04E , 0xAAEF},
{ 0xE04F , 0xAAF0},
{ 0xE050 , 0xAAF1},
{ 0xE051 , 0xAAF2},
{ 0xE052 , 0xAAF3},
{ 0xE053 , 0xAAF4},
{ 0xE054 , 0xAAF5},
{ 0xE055 , 0xAAF6},
{ 0xE056 , 0xAAF7},
{ 0xE057 , 0xAAF8},
{ 0xE058 , 0xAAF9},
{ 0xE059 , 0xAAFA},
{ 0xE05A , 0xAAFB},
{ 0xE05B , 0xAAFC},
{ 0xE05C , 0xAAFD},
{ 0xE05D , 0xAAFE},
{ 0x7372 , 0xAB40},
{ 0x7373 , 0xAB41},
{ 0x7374 , 0xAB42},
{ 0x7375 , 0xAB43},
{ 0x7376 , 0xAB44},
{ 0x7377 , 0xAB45},
{ 0x7378 , 0xAB46},
{ 0x7379 , 0xAB47},
{ 0x737A , 0xAB48},
{ 0x737B , 0xAB49},
{ 0x737C , 0xAB4A},
{ 0x737D , 0xAB4B},
{ 0x737F , 0xAB4C},
{ 0x7380 , 0xAB4D},
{ 0x7381 , 0xAB4E},
{ 0x7382 , 0xAB4F},
{ 0x7383 , 0xAB50},
{ 0x7385 , 0xAB51},
{ 0x7386 , 0xAB52},
{ 0x7388 , 0xAB53},
{ 0x738A , 0xAB54},
{ 0x738C , 0xAB55},
{ 0x738D , 0xAB56},
{ 0x738F , 0xAB57},
{ 0x7390 , 0xAB58},
{ 0x7392 , 0xAB59},
{ 0x7393 , 0xAB5A},
{ 0x7394 , 0xAB5B},
{ 0x7395 , 0xAB5C},
{ 0x7397 , 0xAB5D},
{ 0x7398 , 0xAB5E},
{ 0x7399 , 0xAB5F},
{ 0x739A , 0xAB60},
{ 0x739C , 0xAB61},
{ 0x739D , 0xAB62},
{ 0x739E , 0xAB63},
{ 0x73A0 , 0xAB64},
{ 0x73A1 , 0xAB65},
{ 0x73A3 , 0xAB66},
{ 0x73A4 , 0xAB67},
{ 0x73A5 , 0xAB68},
{ 0x73A6 , 0xAB69},
{ 0x73A7 , 0xAB6A},
{ 0x73A8 , 0xAB6B},
{ 0x73AA , 0xAB6C},
{ 0x73AC , 0xAB6D},
{ 0x73AD , 0xAB6E},
{ 0x73B1 , 0xAB6F},
{ 0x73B4 , 0xAB70},
{ 0x73B5 , 0xAB71},
{ 0x73B6 , 0xAB72},
{ 0x73B8 , 0xAB73},
{ 0x73B9 , 0xAB74},
{ 0x73BC , 0xAB75},
{ 0x73BD , 0xAB76},
{ 0x73BE , 0xAB77},
{ 0x73BF , 0xAB78},
{ 0x73C1 , 0xAB79},
{ 0x73C3 , 0xAB7A},
{ 0x73C4 , 0xAB7B},
{ 0x73C5 , 0xAB7C},
{ 0x73C6 , 0xAB7D},
{ 0x73C7 , 0xAB7E},
{ 0x73CB , 0xAB80},
{ 0x73CC , 0xAB81},
{ 0x73CE , 0xAB82},
{ 0x73D2 , 0xAB83},
{ 0x73D3 , 0xAB84},
{ 0x73D4 , 0xAB85},
{ 0x73D5 , 0xAB86},
{ 0x73D6 , 0xAB87},
{ 0x73D7 , 0xAB88},
{ 0x73D8 , 0xAB89},
{ 0x73DA , 0xAB8A},
{ 0x73DB , 0xAB8B},
{ 0x73DC , 0xAB8C},
{ 0x73DD , 0xAB8D},
{ 0x73DF , 0xAB8E},
{ 0x73E1 , 0xAB8F},
{ 0x73E2 , 0xAB90},
{ 0x73E3 , 0xAB91},
{ 0x73E4 , 0xAB92},
{ 0x73E6 , 0xAB93},
{ 0x73E8 , 0xAB94},
{ 0x73EA , 0xAB95},
{ 0x73EB , 0xAB96},
{ 0x73EC , 0xAB97},
{ 0x73EE , 0xAB98},
{ 0x73EF , 0xAB99},
{ 0x73F0 , 0xAB9A},
{ 0x73F1 , 0xAB9B},
{ 0x73F3 , 0xAB9C},
{ 0x73F4 , 0xAB9D},
{ 0x73F5 , 0xAB9E},
{ 0x73F6 , 0xAB9F},
{ 0x73F7 , 0xABA0},
{ 0xE05E , 0xABA1},
{ 0xE05F , 0xABA2},
{ 0xE060 , 0xABA3},
{ 0xE061 , 0xABA4},
{ 0xE062 , 0xABA5},
{ 0xE063 , 0xABA6},
{ 0xE064 , 0xABA7},
{ 0xE065 , 0xABA8},
{ 0xE066 , 0xABA9},
{ 0xE067 , 0xABAA},
{ 0xE068 , 0xABAB},
{ 0xE069 , 0xABAC},
{ 0xE06A , 0xABAD},
{ 0xE06B , 0xABAE},
{ 0xE06C , 0xABAF},
{ 0xE06D , 0xABB0},
{ 0xE06E , 0xABB1},
{ 0xE06F , 0xABB2},
{ 0xE070 , 0xABB3},
{ 0xE071 , 0xABB4},
{ 0xE072 , 0xABB5},
{ 0xE073 , 0xABB6},
{ 0xE074 , 0xABB7},
{ 0xE075 , 0xABB8},
{ 0xE076 , 0xABB9},
{ 0xE077 , 0xABBA},
{ 0xE078 , 0xABBB},
{ 0xE079 , 0xABBC},
{ 0xE07A , 0xABBD},
{ 0xE07B , 0xABBE},
{ 0xE07C , 0xABBF},
{ 0xE07D , 0xABC0},
{ 0xE07E , 0xABC1},
{ 0xE07F , 0xABC2},
{ 0xE080 , 0xABC3},
{ 0xE081 , 0xABC4},
{ 0xE082 , 0xABC5},
{ 0xE083 , 0xABC6},
{ 0xE084 , 0xABC7},
{ 0xE085 , 0xABC8},
{ 0xE086 , 0xABC9},
{ 0xE087 , 0xABCA},
{ 0xE088 , 0xABCB},
{ 0xE089 , 0xABCC},
{ 0xE08A , 0xABCD},
{ 0xE08B , 0xABCE},
{ 0xE08C , 0xABCF},
{ 0xE08D , 0xABD0},
{ 0xE08E , 0xABD1},
{ 0xE08F , 0xABD2},
{ 0xE090 , 0xABD3},
{ 0xE091 , 0xABD4},
{ 0xE092 , 0xABD5},
{ 0xE093 , 0xABD6},
{ 0xE094 , 0xABD7},
{ 0xE095 , 0xABD8},
{ 0xE096 , 0xABD9},
{ 0xE097 , 0xABDA},
{ 0xE098 , 0xABDB},
{ 0xE099 , 0xABDC},
{ 0xE09A , 0xABDD},
{ 0xE09B , 0xABDE},
{ 0xE09C , 0xABDF},
{ 0xE09D , 0xABE0},
{ 0xE09E , 0xABE1},
{ 0xE09F , 0xABE2},
{ 0xE0A0 , 0xABE3},
{ 0xE0A1 , 0xABE4},
{ 0xE0A2 , 0xABE5},
{ 0xE0A3 , 0xABE6},
{ 0xE0A4 , 0xABE7},
{ 0xE0A5 , 0xABE8},
{ 0xE0A6 , 0xABE9},
{ 0xE0A7 , 0xABEA},
{ 0xE0A8 , 0xABEB},
{ 0xE0A9 , 0xABEC},
{ 0xE0AA , 0xABED},
{ 0xE0AB , 0xABEE},
{ 0xE0AC , 0xABEF},
{ 0xE0AD , 0xABF0},
{ 0xE0AE , 0xABF1},
{ 0xE0AF , 0xABF2},
{ 0xE0B0 , 0xABF3},
{ 0xE0B1 , 0xABF4},
{ 0xE0B2 , 0xABF5},
{ 0xE0B3 , 0xABF6},
{ 0xE0B4 , 0xABF7},
{ 0xE0B5 , 0xABF8},
{ 0xE0B6 , 0xABF9},
{ 0xE0B7 , 0xABFA},
{ 0xE0B8 , 0xABFB},
{ 0xE0B9 , 0xABFC},
{ 0xE0BA , 0xABFD},
{ 0xE0BB , 0xABFE},
{ 0x73F8 , 0xAC40},
{ 0x73F9 , 0xAC41},
{ 0x73FA , 0xAC42},
{ 0x73FB , 0xAC43},
{ 0x73FC , 0xAC44},
{ 0x73FD , 0xAC45},
{ 0x73FE , 0xAC46},
{ 0x73FF , 0xAC47},
{ 0x7400 , 0xAC48},
{ 0x7401 , 0xAC49},
{ 0x7402 , 0xAC4A},
{ 0x7404 , 0xAC4B},
{ 0x7407 , 0xAC4C},
{ 0x7408 , 0xAC4D},
{ 0x740B , 0xAC4E},
{ 0x740C , 0xAC4F},
{ 0x740D , 0xAC50},
{ 0x740E , 0xAC51},
{ 0x7411 , 0xAC52},
{ 0x7412 , 0xAC53},
{ 0x7413 , 0xAC54},
{ 0x7414 , 0xAC55},
{ 0x7415 , 0xAC56},
{ 0x7416 , 0xAC57},
{ 0x7417 , 0xAC58},
{ 0x7418 , 0xAC59},
{ 0x7419 , 0xAC5A},
{ 0x741C , 0xAC5B},
{ 0x741D , 0xAC5C},
{ 0x741E , 0xAC5D},
{ 0x741F , 0xAC5E},
{ 0x7420 , 0xAC5F},
{ 0x7421 , 0xAC60},
{ 0x7423 , 0xAC61},
{ 0x7424 , 0xAC62},
{ 0x7427 , 0xAC63},
{ 0x7429 , 0xAC64},
{ 0x742B , 0xAC65},
{ 0x742D , 0xAC66},
{ 0x742F , 0xAC67},
{ 0x7431 , 0xAC68},
{ 0x7432 , 0xAC69},
{ 0x7437 , 0xAC6A},
{ 0x7438 , 0xAC6B},
{ 0x7439 , 0xAC6C},
{ 0x743A , 0xAC6D},
{ 0x743B , 0xAC6E},
{ 0x743D , 0xAC6F},
{ 0x743E , 0xAC70},
{ 0x743F , 0xAC71},
{ 0x7440 , 0xAC72},
{ 0x7442 , 0xAC73},
{ 0x7443 , 0xAC74},
{ 0x7444 , 0xAC75},
{ 0x7445 , 0xAC76},
{ 0x7446 , 0xAC77},
{ 0x7447 , 0xAC78},
{ 0x7448 , 0xAC79},
{ 0x7449 , 0xAC7A},
{ 0x744A , 0xAC7B},
{ 0x744B , 0xAC7C},
{ 0x744C , 0xAC7D},
{ 0x744D , 0xAC7E},
{ 0x744E , 0xAC80},
{ 0x744F , 0xAC81},
{ 0x7450 , 0xAC82},
{ 0x7451 , 0xAC83},
{ 0x7452 , 0xAC84},
{ 0x7453 , 0xAC85},
{ 0x7454 , 0xAC86},
{ 0x7456 , 0xAC87},
{ 0x7458 , 0xAC88},
{ 0x745D , 0xAC89},
{ 0x7460 , 0xAC8A},
{ 0x7461 , 0xAC8B},
{ 0x7462 , 0xAC8C},
{ 0x7463 , 0xAC8D},
{ 0x7464 , 0xAC8E},
{ 0x7465 , 0xAC8F},
{ 0x7466 , 0xAC90},
{ 0x7467 , 0xAC91},
{ 0x7468 , 0xAC92},
{ 0x7469 , 0xAC93},
{ 0x746A , 0xAC94},
{ 0x746B , 0xAC95},
{ 0x746C , 0xAC96},
{ 0x746E , 0xAC97},
{ 0x746F , 0xAC98},
{ 0x7471 , 0xAC99},
{ 0x7472 , 0xAC9A},
{ 0x7473 , 0xAC9B},
{ 0x7474 , 0xAC9C},
{ 0x7475 , 0xAC9D},
{ 0x7478 , 0xAC9E},
{ 0x7479 , 0xAC9F},
{ 0x747A , 0xACA0},
{ 0xE0BC , 0xACA1},
{ 0xE0BD , 0xACA2},
{ 0xE0BE , 0xACA3},
{ 0xE0BF , 0xACA4},
{ 0xE0C0 , 0xACA5},
{ 0xE0C1 , 0xACA6},
{ 0xE0C2 , 0xACA7},
{ 0xE0C3 , 0xACA8},
{ 0xE0C4 , 0xACA9},
{ 0xE0C5 , 0xACAA},
{ 0xE0C6 , 0xACAB},
{ 0xE0C7 , 0xACAC},
{ 0xE0C8 , 0xACAD},
{ 0xE0C9 , 0xACAE},
{ 0xE0CA , 0xACAF},
{ 0xE0CB , 0xACB0},
{ 0xE0CC , 0xACB1},
{ 0xE0CD , 0xACB2},
{ 0xE0CE , 0xACB3},
{ 0xE0CF , 0xACB4},
{ 0xE0D0 , 0xACB5},
{ 0xE0D1 , 0xACB6},
{ 0xE0D2 , 0xACB7},
{ 0xE0D3 , 0xACB8},
{ 0xE0D4 , 0xACB9},
{ 0xE0D5 , 0xACBA},
{ 0xE0D6 , 0xACBB},
{ 0xE0D7 , 0xACBC},
{ 0xE0D8 , 0xACBD},
{ 0xE0D9 , 0xACBE},
{ 0xE0DA , 0xACBF},
{ 0xE0DB , 0xACC0},
{ 0xE0DC , 0xACC1},
{ 0xE0DD , 0xACC2},
{ 0xE0DE , 0xACC3},
{ 0xE0DF , 0xACC4},
{ 0xE0E0 , 0xACC5},
{ 0xE0E1 , 0xACC6},
{ 0xE0E2 , 0xACC7},
{ 0xE0E3 , 0xACC8},
{ 0xE0E4 , 0xACC9},
{ 0xE0E5 , 0xACCA},
{ 0xE0E6 , 0xACCB},
{ 0xE0E7 , 0xACCC},
{ 0xE0E8 , 0xACCD},
{ 0xE0E9 , 0xACCE},
{ 0xE0EA , 0xACCF},
{ 0xE0EB , 0xACD0},
{ 0xE0EC , 0xACD1},
{ 0xE0ED , 0xACD2},
{ 0xE0EE , 0xACD3},
{ 0xE0EF , 0xACD4},
{ 0xE0F0 , 0xACD5},
{ 0xE0F1 , 0xACD6},
{ 0xE0F2 , 0xACD7},
{ 0xE0F3 , 0xACD8},
{ 0xE0F4 , 0xACD9},
{ 0xE0F5 , 0xACDA},
{ 0xE0F6 , 0xACDB},
{ 0xE0F7 , 0xACDC},
{ 0xE0F8 , 0xACDD},
{ 0xE0F9 , 0xACDE},
{ 0xE0FA , 0xACDF},
{ 0xE0FB , 0xACE0},
{ 0xE0FC , 0xACE1},
{ 0xE0FD , 0xACE2},
{ 0xE0FE , 0xACE3},
{ 0xE0FF , 0xACE4},
{ 0xE100 , 0xACE5},
{ 0xE101 , 0xACE6},
{ 0xE102 , 0xACE7},
{ 0xE103 , 0xACE8},
{ 0xE104 , 0xACE9},
{ 0xE105 , 0xACEA},
{ 0xE106 , 0xACEB},
{ 0xE107 , 0xACEC},
{ 0xE108 , 0xACED},
{ 0xE109 , 0xACEE},
{ 0xE10A , 0xACEF},
{ 0xE10B , 0xACF0},
{ 0xE10C , 0xACF1},
{ 0xE10D , 0xACF2},
{ 0xE10E , 0xACF3},
{ 0xE10F , 0xACF4},
{ 0xE110 , 0xACF5},
{ 0xE111 , 0xACF6},
{ 0xE112 , 0xACF7},
{ 0xE113 , 0xACF8},
{ 0xE114 , 0xACF9},
{ 0xE115 , 0xACFA},
{ 0xE116 , 0xACFB},
{ 0xE117 , 0xACFC},
{ 0xE118 , 0xACFD},
{ 0xE119 , 0xACFE},
{ 0x747B , 0xAD40},
{ 0x747C , 0xAD41},
{ 0x747D , 0xAD42},
{ 0x747F , 0xAD43},
{ 0x7482 , 0xAD44},
{ 0x7484 , 0xAD45},
{ 0x7485 , 0xAD46},
{ 0x7486 , 0xAD47},
{ 0x7488 , 0xAD48},
{ 0x7489 , 0xAD49},
{ 0x748A , 0xAD4A},
{ 0x748C , 0xAD4B},
{ 0x748D , 0xAD4C},
{ 0x748F , 0xAD4D},
{ 0x7491 , 0xAD4E},
{ 0x7492 , 0xAD4F},
{ 0x7493 , 0xAD50},
{ 0x7494 , 0xAD51},
{ 0x7495 , 0xAD52},
{ 0x7496 , 0xAD53},
{ 0x7497 , 0xAD54},
{ 0x7498 , 0xAD55},
{ 0x7499 , 0xAD56},
{ 0x749A , 0xAD57},
{ 0x749B , 0xAD58},
{ 0x749D , 0xAD59},
{ 0x749F , 0xAD5A},
{ 0x74A0 , 0xAD5B},
{ 0x74A1 , 0xAD5C},
{ 0x74A2 , 0xAD5D},
{ 0x74A3 , 0xAD5E},
{ 0x74A4 , 0xAD5F},
{ 0x74A5 , 0xAD60},
{ 0x74A6 , 0xAD61},
{ 0x74AA , 0xAD62},
{ 0x74AB , 0xAD63},
{ 0x74AC , 0xAD64},
{ 0x74AD , 0xAD65},
{ 0x74AE , 0xAD66},
{ 0x74AF , 0xAD67},
{ 0x74B0 , 0xAD68},
{ 0x74B1 , 0xAD69},
{ 0x74B2 , 0xAD6A},
{ 0x74B3 , 0xAD6B},
{ 0x74B4 , 0xAD6C},
{ 0x74B5 , 0xAD6D},
{ 0x74B6 , 0xAD6E},
{ 0x74B7 , 0xAD6F},
{ 0x74B8 , 0xAD70},
{ 0x74B9 , 0xAD71},
{ 0x74BB , 0xAD72},
{ 0x74BC , 0xAD73},
{ 0x74BD , 0xAD74},
{ 0x74BE , 0xAD75},
{ 0x74BF , 0xAD76},
{ 0x74C0 , 0xAD77},
{ 0x74C1 , 0xAD78},
{ 0x74C2 , 0xAD79},
{ 0x74C3 , 0xAD7A},
{ 0x74C4 , 0xAD7B},
{ 0x74C5 , 0xAD7C},
{ 0x74C6 , 0xAD7D},
{ 0x74C7 , 0xAD7E},
{ 0x74C8 , 0xAD80},
{ 0x74C9 , 0xAD81},
{ 0x74CA , 0xAD82},
{ 0x74CB , 0xAD83},
{ 0x74CC , 0xAD84},
{ 0x74CD , 0xAD85},
{ 0x74CE , 0xAD86},
{ 0x74CF , 0xAD87},
{ 0x74D0 , 0xAD88},
{ 0x74D1 , 0xAD89},
{ 0x74D3 , 0xAD8A},
{ 0x74D4 , 0xAD8B},
{ 0x74D5 , 0xAD8C},
{ 0x74D6 , 0xAD8D},
{ 0x74D7 , 0xAD8E},
{ 0x74D8 , 0xAD8F},
{ 0x74D9 , 0xAD90},
{ 0x74DA , 0xAD91},
{ 0x74DB , 0xAD92},
{ 0x74DD , 0xAD93},
{ 0x74DF , 0xAD94},
{ 0x74E1 , 0xAD95},
{ 0x74E5 , 0xAD96},
{ 0x74E7 , 0xAD97},
{ 0x74E8 , 0xAD98},
{ 0x74E9 , 0xAD99},
{ 0x74EA , 0xAD9A},
{ 0x74EB , 0xAD9B},
{ 0x74EC , 0xAD9C},
{ 0x74ED , 0xAD9D},
{ 0x74F0 , 0xAD9E},
{ 0x74F1 , 0xAD9F},
{ 0x74F2 , 0xADA0},
{ 0xE11A , 0xADA1},
{ 0xE11B , 0xADA2},
{ 0xE11C , 0xADA3},
{ 0xE11D , 0xADA4},
{ 0xE11E , 0xADA5},
{ 0xE11F , 0xADA6},
{ 0xE120 , 0xADA7},
{ 0xE121 , 0xADA8},
{ 0xE122 , 0xADA9},
{ 0xE123 , 0xADAA},
{ 0xE124 , 0xADAB},
{ 0xE125 , 0xADAC},
{ 0xE126 , 0xADAD},
{ 0xE127 , 0xADAE},
{ 0xE128 , 0xADAF},
{ 0xE129 , 0xADB0},
{ 0xE12A , 0xADB1},
{ 0xE12B , 0xADB2},
{ 0xE12C , 0xADB3},
{ 0xE12D , 0xADB4},
{ 0xE12E , 0xADB5},
{ 0xE12F , 0xADB6},
{ 0xE130 , 0xADB7},
{ 0xE131 , 0xADB8},
{ 0xE132 , 0xADB9},
{ 0xE133 , 0xADBA},
{ 0xE134 , 0xADBB},
{ 0xE135 , 0xADBC},
{ 0xE136 , 0xADBD},
{ 0xE137 , 0xADBE},
{ 0xE138 , 0xADBF},
{ 0xE139 , 0xADC0},
{ 0xE13A , 0xADC1},
{ 0xE13B , 0xADC2},
{ 0xE13C , 0xADC3},
{ 0xE13D , 0xADC4},
{ 0xE13E , 0xADC5},
{ 0xE13F , 0xADC6},
{ 0xE140 , 0xADC7},
{ 0xE141 , 0xADC8},
{ 0xE142 , 0xADC9},
{ 0xE143 , 0xADCA},
{ 0xE144 , 0xADCB},
{ 0xE145 , 0xADCC},
{ 0xE146 , 0xADCD},
{ 0xE147 , 0xADCE},
{ 0xE148 , 0xADCF},
{ 0xE149 , 0xADD0},
{ 0xE14A , 0xADD1},
{ 0xE14B , 0xADD2},
{ 0xE14C , 0xADD3},
{ 0xE14D , 0xADD4},
{ 0xE14E , 0xADD5},
{ 0xE14F , 0xADD6},
{ 0xE150 , 0xADD7},
{ 0xE151 , 0xADD8},
{ 0xE152 , 0xADD9},
{ 0xE153 , 0xADDA},
{ 0xE154 , 0xADDB},
{ 0xE155 , 0xADDC},
{ 0xE156 , 0xADDD},
{ 0xE157 , 0xADDE},
{ 0xE158 , 0xADDF},
{ 0xE159 , 0xADE0},
{ 0xE15A , 0xADE1},
{ 0xE15B , 0xADE2},
{ 0xE15C , 0xADE3},
{ 0xE15D , 0xADE4},
{ 0xE15E , 0xADE5},
{ 0xE15F , 0xADE6},
{ 0xE160 , 0xADE7},
{ 0xE161 , 0xADE8},
{ 0xE162 , 0xADE9},
{ 0xE163 , 0xADEA},
{ 0xE164 , 0xADEB},
{ 0xE165 , 0xADEC},
{ 0xE166 , 0xADED},
{ 0xE167 , 0xADEE},
{ 0xE168 , 0xADEF},
{ 0xE169 , 0xADF0},
{ 0xE16A , 0xADF1},
{ 0xE16B , 0xADF2},
{ 0xE16C , 0xADF3},
{ 0xE16D , 0xADF4},
{ 0xE16E , 0xADF5},
{ 0xE16F , 0xADF6},
{ 0xE170 , 0xADF7},
{ 0xE171 , 0xADF8},
{ 0xE172 , 0xADF9},
{ 0xE173 , 0xADFA},
{ 0xE174 , 0xADFB},
{ 0xE175 , 0xADFC},
{ 0xE176 , 0xADFD},
{ 0xE177 , 0xADFE},
{ 0x74F3 , 0xAE40},
{ 0x74F5 , 0xAE41},
{ 0x74F8 , 0xAE42},
{ 0x74F9 , 0xAE43},
{ 0x74FA , 0xAE44},
{ 0x74FB , 0xAE45},
{ 0x74FC , 0xAE46},
{ 0x74FD , 0xAE47},
{ 0x74FE , 0xAE48},
{ 0x7500 , 0xAE49},
{ 0x7501 , 0xAE4A},
{ 0x7502 , 0xAE4B},
{ 0x7503 , 0xAE4C},
{ 0x7505 , 0xAE4D},
{ 0x7506 , 0xAE4E},
{ 0x7507 , 0xAE4F},
{ 0x7508 , 0xAE50},
{ 0x7509 , 0xAE51},
{ 0x750A , 0xAE52},
{ 0x750B , 0xAE53},
{ 0x750C , 0xAE54},
{ 0x750E , 0xAE55},
{ 0x7510 , 0xAE56},
{ 0x7512 , 0xAE57},
{ 0x7514 , 0xAE58},
{ 0x7515 , 0xAE59},
{ 0x7516 , 0xAE5A},
{ 0x7517 , 0xAE5B},
{ 0x751B , 0xAE5C},
{ 0x751D , 0xAE5D},
{ 0x751E , 0xAE5E},
{ 0x7520 , 0xAE5F},
{ 0x7521 , 0xAE60},
{ 0x7522 , 0xAE61},
{ 0x7523 , 0xAE62},
{ 0x7524 , 0xAE63},
{ 0x7526 , 0xAE64},
{ 0x7527 , 0xAE65},
{ 0x752A , 0xAE66},
{ 0x752E , 0xAE67},
{ 0x7534 , 0xAE68},
{ 0x7536 , 0xAE69},
{ 0x7539 , 0xAE6A},
{ 0x753C , 0xAE6B},
{ 0x753D , 0xAE6C},
{ 0x753F , 0xAE6D},
{ 0x7541 , 0xAE6E},
{ 0x7542 , 0xAE6F},
{ 0x7543 , 0xAE70},
{ 0x7544 , 0xAE71},
{ 0x7546 , 0xAE72},
{ 0x7547 , 0xAE73},
{ 0x7549 , 0xAE74},
{ 0x754A , 0xAE75},
{ 0x754D , 0xAE76},
{ 0x7550 , 0xAE77},
{ 0x7551 , 0xAE78},
{ 0x7552 , 0xAE79},
{ 0x7553 , 0xAE7A},
{ 0x7555 , 0xAE7B},
{ 0x7556 , 0xAE7C},
{ 0x7557 , 0xAE7D},
{ 0x7558 , 0xAE7E},
{ 0x755D , 0xAE80},
{ 0x755E , 0xAE81},
{ 0x755F , 0xAE82},
{ 0x7560 , 0xAE83},
{ 0x7561 , 0xAE84},
{ 0x7562 , 0xAE85},
{ 0x7563 , 0xAE86},
{ 0x7564 , 0xAE87},
{ 0x7567 , 0xAE88},
{ 0x7568 , 0xAE89},
{ 0x7569 , 0xAE8A},
{ 0x756B , 0xAE8B},
{ 0x756C , 0xAE8C},
{ 0x756D , 0xAE8D},
{ 0x756E , 0xAE8E},
{ 0x756F , 0xAE8F},
{ 0x7570 , 0xAE90},
{ 0x7571 , 0xAE91},
{ 0x7573 , 0xAE92},
{ 0x7575 , 0xAE93},
{ 0x7576 , 0xAE94},
{ 0x7577 , 0xAE95},
{ 0x757A , 0xAE96},
{ 0x757B , 0xAE97},
{ 0x757C , 0xAE98},
{ 0x757D , 0xAE99},
{ 0x757E , 0xAE9A},
{ 0x7580 , 0xAE9B},
{ 0x7581 , 0xAE9C},
{ 0x7582 , 0xAE9D},
{ 0x7584 , 0xAE9E},
{ 0x7585 , 0xAE9F},
{ 0x7587 , 0xAEA0},
{ 0xE178 , 0xAEA1},
{ 0xE179 , 0xAEA2},
{ 0xE17A , 0xAEA3},
{ 0xE17B , 0xAEA4},
{ 0xE17C , 0xAEA5},
{ 0xE17D , 0xAEA6},
{ 0xE17E , 0xAEA7},
{ 0xE17F , 0xAEA8},
{ 0xE180 , 0xAEA9},
{ 0xE181 , 0xAEAA},
{ 0xE182 , 0xAEAB},
{ 0xE183 , 0xAEAC},
{ 0xE184 , 0xAEAD},
{ 0xE185 , 0xAEAE},
{ 0xE186 , 0xAEAF},
{ 0xE187 , 0xAEB0},
{ 0xE188 , 0xAEB1},
{ 0xE189 , 0xAEB2},
{ 0xE18A , 0xAEB3},
{ 0xE18B , 0xAEB4},
{ 0xE18C , 0xAEB5},
{ 0xE18D , 0xAEB6},
{ 0xE18E , 0xAEB7},
{ 0xE18F , 0xAEB8},
{ 0xE190 , 0xAEB9},
{ 0xE191 , 0xAEBA},
{ 0xE192 , 0xAEBB},
{ 0xE193 , 0xAEBC},
{ 0xE194 , 0xAEBD},
{ 0xE195 , 0xAEBE},
{ 0xE196 , 0xAEBF},
{ 0xE197 , 0xAEC0},
{ 0xE198 , 0xAEC1},
{ 0xE199 , 0xAEC2},
{ 0xE19A , 0xAEC3},
{ 0xE19B , 0xAEC4},
{ 0xE19C , 0xAEC5},
{ 0xE19D , 0xAEC6},
{ 0xE19E , 0xAEC7},
{ 0xE19F , 0xAEC8},
{ 0xE1A0 , 0xAEC9},
{ 0xE1A1 , 0xAECA},
{ 0xE1A2 , 0xAECB},
{ 0xE1A3 , 0xAECC},
{ 0xE1A4 , 0xAECD},
{ 0xE1A5 , 0xAECE},
{ 0xE1A6 , 0xAECF},
{ 0xE1A7 , 0xAED0},
{ 0xE1A8 , 0xAED1},
{ 0xE1A9 , 0xAED2},
{ 0xE1AA , 0xAED3},
{ 0xE1AB , 0xAED4},
{ 0xE1AC , 0xAED5},
{ 0xE1AD , 0xAED6},
{ 0xE1AE , 0xAED7},
{ 0xE1AF , 0xAED8},
{ 0xE1B0 , 0xAED9},
{ 0xE1B1 , 0xAEDA},
{ 0xE1B2 , 0xAEDB},
{ 0xE1B3 , 0xAEDC},
{ 0xE1B4 , 0xAEDD},
{ 0xE1B5 , 0xAEDE},
{ 0xE1B6 , 0xAEDF},
{ 0xE1B7 , 0xAEE0},
{ 0xE1B8 , 0xAEE1},
{ 0xE1B9 , 0xAEE2},
{ 0xE1BA , 0xAEE3},
{ 0xE1BB , 0xAEE4},
{ 0xE1BC , 0xAEE5},
{ 0xE1BD , 0xAEE6},
{ 0xE1BE , 0xAEE7},
{ 0xE1BF , 0xAEE8},
{ 0xE1C0 , 0xAEE9},
{ 0xE1C1 , 0xAEEA},
{ 0xE1C2 , 0xAEEB},
{ 0xE1C3 , 0xAEEC},
{ 0xE1C4 , 0xAEED},
{ 0xE1C5 , 0xAEEE},
{ 0xE1C6 , 0xAEEF},
{ 0xE1C7 , 0xAEF0},
{ 0xE1C8 , 0xAEF1},
{ 0xE1C9 , 0xAEF2},
{ 0xE1CA , 0xAEF3},
{ 0xE1CB , 0xAEF4},
{ 0xE1CC , 0xAEF5},
{ 0xE1CD , 0xAEF6},
{ 0xE1CE , 0xAEF7},
{ 0xE1CF , 0xAEF8},
{ 0xE1D0 , 0xAEF9},
{ 0xE1D1 , 0xAEFA},
{ 0xE1D2 , 0xAEFB},
{ 0xE1D3 , 0xAEFC},
{ 0xE1D4 , 0xAEFD},
{ 0xE1D5 , 0xAEFE},
{ 0x7588 , 0xAF40},
{ 0x7589 , 0xAF41},
{ 0x758A , 0xAF42},
{ 0x758C , 0xAF43},
{ 0x758D , 0xAF44},
{ 0x758E , 0xAF45},
{ 0x7590 , 0xAF46},
{ 0x7593 , 0xAF47},
{ 0x7595 , 0xAF48},
{ 0x7598 , 0xAF49},
{ 0x759B , 0xAF4A},
{ 0x759C , 0xAF4B},
{ 0x759E , 0xAF4C},
{ 0x75A2 , 0xAF4D},
{ 0x75A6 , 0xAF4E},
{ 0x75A7 , 0xAF4F},
{ 0x75A8 , 0xAF50},
{ 0x75A9 , 0xAF51},
{ 0x75AA , 0xAF52},
{ 0x75AD , 0xAF53},
{ 0x75B6 , 0xAF54},
{ 0x75B7 , 0xAF55},
{ 0x75BA , 0xAF56},
{ 0x75BB , 0xAF57},
{ 0x75BF , 0xAF58},
{ 0x75C0 , 0xAF59},
{ 0x75C1 , 0xAF5A},
{ 0x75C6 , 0xAF5B},
{ 0x75CB , 0xAF5C},
{ 0x75CC , 0xAF5D},
{ 0x75CE , 0xAF5E},
{ 0x75CF , 0xAF5F},
{ 0x75D0 , 0xAF60},
{ 0x75D1 , 0xAF61},
{ 0x75D3 , 0xAF62},
{ 0x75D7 , 0xAF63},
{ 0x75D9 , 0xAF64},
{ 0x75DA , 0xAF65},
{ 0x75DC , 0xAF66},
{ 0x75DD , 0xAF67},
{ 0x75DF , 0xAF68},
{ 0x75E0 , 0xAF69},
{ 0x75E1 , 0xAF6A},
{ 0x75E5 , 0xAF6B},
{ 0x75E9 , 0xAF6C},
{ 0x75EC , 0xAF6D},
{ 0x75ED , 0xAF6E},
{ 0x75EE , 0xAF6F},
{ 0x75EF , 0xAF70},
{ 0x75F2 , 0xAF71},
{ 0x75F3 , 0xAF72},
{ 0x75F5 , 0xAF73},
{ 0x75F6 , 0xAF74},
{ 0x75F7 , 0xAF75},
{ 0x75F8 , 0xAF76},
{ 0x75FA , 0xAF77},
{ 0x75FB , 0xAF78},
{ 0x75FD , 0xAF79},
{ 0x75FE , 0xAF7A},
{ 0x7602 , 0xAF7B},
{ 0x7604 , 0xAF7C},
{ 0x7606 , 0xAF7D},
{ 0x7607 , 0xAF7E},
{ 0x7608 , 0xAF80},
{ 0x7609 , 0xAF81},
{ 0x760B , 0xAF82},
{ 0x760D , 0xAF83},
{ 0x760E , 0xAF84},
{ 0x760F , 0xAF85},
{ 0x7611 , 0xAF86},
{ 0x7612 , 0xAF87},
{ 0x7613 , 0xAF88},
{ 0x7614 , 0xAF89},
{ 0x7616 , 0xAF8A},
{ 0x761A , 0xAF8B},
{ 0x761C , 0xAF8C},
{ 0x761D , 0xAF8D},
{ 0x761E , 0xAF8E},
{ 0x7621 , 0xAF8F},
{ 0x7623 , 0xAF90},
{ 0x7627 , 0xAF91},
{ 0x7628 , 0xAF92},
{ 0x762C , 0xAF93},
{ 0x762E , 0xAF94},
{ 0x762F , 0xAF95},
{ 0x7631 , 0xAF96},
{ 0x7632 , 0xAF97},
{ 0x7636 , 0xAF98},
{ 0x7637 , 0xAF99},
{ 0x7639 , 0xAF9A},
{ 0x763A , 0xAF9B},
{ 0x763B , 0xAF9C},
{ 0x763D , 0xAF9D},
{ 0x7641 , 0xAF9E},
{ 0x7642 , 0xAF9F},
{ 0x7644 , 0xAFA0},
{ 0xE1D6 , 0xAFA1},
{ 0xE1D7 , 0xAFA2},
{ 0xE1D8 , 0xAFA3},
{ 0xE1D9 , 0xAFA4},
{ 0xE1DA , 0xAFA5},
{ 0xE1DB , 0xAFA6},
{ 0xE1DC , 0xAFA7},
{ 0xE1DD , 0xAFA8},
{ 0xE1DE , 0xAFA9},
{ 0xE1DF , 0xAFAA},
{ 0xE1E0 , 0xAFAB},
{ 0xE1E1 , 0xAFAC},
{ 0xE1E2 , 0xAFAD},
{ 0xE1E3 , 0xAFAE},
{ 0xE1E4 , 0xAFAF},
{ 0xE1E5 , 0xAFB0},
{ 0xE1E6 , 0xAFB1},
{ 0xE1E7 , 0xAFB2},
{ 0xE1E8 , 0xAFB3},
{ 0xE1E9 , 0xAFB4},
{ 0xE1EA , 0xAFB5},
{ 0xE1EB , 0xAFB6},
{ 0xE1EC , 0xAFB7},
{ 0xE1ED , 0xAFB8},
{ 0xE1EE , 0xAFB9},
{ 0xE1EF , 0xAFBA},
{ 0xE1F0 , 0xAFBB},
{ 0xE1F1 , 0xAFBC},
{ 0xE1F2 , 0xAFBD},
{ 0xE1F3 , 0xAFBE},
{ 0xE1F4 , 0xAFBF},
{ 0xE1F5 , 0xAFC0},
{ 0xE1F6 , 0xAFC1},
{ 0xE1F7 , 0xAFC2},
{ 0xE1F8 , 0xAFC3},
{ 0xE1F9 , 0xAFC4},
{ 0xE1FA , 0xAFC5},
{ 0xE1FB , 0xAFC6},
{ 0xE1FC , 0xAFC7},
{ 0xE1FD , 0xAFC8},
{ 0xE1FE , 0xAFC9},
{ 0xE1FF , 0xAFCA},
{ 0xE200 , 0xAFCB},
{ 0xE201 , 0xAFCC},
{ 0xE202 , 0xAFCD},
{ 0xE203 , 0xAFCE},
{ 0xE204 , 0xAFCF},
{ 0xE205 , 0xAFD0},
{ 0xE206 , 0xAFD1},
{ 0xE207 , 0xAFD2},
{ 0xE208 , 0xAFD3},
{ 0xE209 , 0xAFD4},
{ 0xE20A , 0xAFD5},
{ 0xE20B , 0xAFD6},
{ 0xE20C , 0xAFD7},
{ 0xE20D , 0xAFD8},
{ 0xE20E , 0xAFD9},
{ 0xE20F , 0xAFDA},
{ 0xE210 , 0xAFDB},
{ 0xE211 , 0xAFDC},
{ 0xE212 , 0xAFDD},
{ 0xE213 , 0xAFDE},
{ 0xE214 , 0xAFDF},
{ 0xE215 , 0xAFE0},
{ 0xE216 , 0xAFE1},
{ 0xE217 , 0xAFE2},
{ 0xE218 , 0xAFE3},
{ 0xE219 , 0xAFE4},
{ 0xE21A , 0xAFE5},
{ 0xE21B , 0xAFE6},
{ 0xE21C , 0xAFE7},
{ 0xE21D , 0xAFE8},
{ 0xE21E , 0xAFE9},
{ 0xE21F , 0xAFEA},
{ 0xE220 , 0xAFEB},
{ 0xE221 , 0xAFEC},
{ 0xE222 , 0xAFED},
{ 0xE223 , 0xAFEE},
{ 0xE224 , 0xAFEF},
{ 0xE225 , 0xAFF0},
{ 0xE226 , 0xAFF1},
{ 0xE227 , 0xAFF2},
{ 0xE228 , 0xAFF3},
{ 0xE229 , 0xAFF4},
{ 0xE22A , 0xAFF5},
{ 0xE22B , 0xAFF6},
{ 0xE22C , 0xAFF7},
{ 0xE22D , 0xAFF8},
{ 0xE22E , 0xAFF9},
{ 0xE22F , 0xAFFA},
{ 0xE230 , 0xAFFB},
{ 0xE231 , 0xAFFC},
{ 0xE232 , 0xAFFD},
{ 0xE233 , 0xAFFE},
{ 0x7645 , 0xB040},
{ 0x7646 , 0xB041},
{ 0x7647 , 0xB042},
{ 0x7648 , 0xB043},
{ 0x7649 , 0xB044},
{ 0x764A , 0xB045},
{ 0x764B , 0xB046},
{ 0x764E , 0xB047},
{ 0x764F , 0xB048},
{ 0x7650 , 0xB049},
{ 0x7651 , 0xB04A},
{ 0x7652 , 0xB04B},
{ 0x7653 , 0xB04C},
{ 0x7655 , 0xB04D},
{ 0x7657 , 0xB04E},
{ 0x7658 , 0xB04F},
{ 0x7659 , 0xB050},
{ 0x765A , 0xB051},
{ 0x765B , 0xB052},
{ 0x765D , 0xB053},
{ 0x765F , 0xB054},
{ 0x7660 , 0xB055},
{ 0x7661 , 0xB056},
{ 0x7662 , 0xB057},
{ 0x7664 , 0xB058},
{ 0x7665 , 0xB059},
{ 0x7666 , 0xB05A},
{ 0x7667 , 0xB05B},
{ 0x7668 , 0xB05C},
{ 0x7669 , 0xB05D},
{ 0x766A , 0xB05E},
{ 0x766C , 0xB05F},
{ 0x766D , 0xB060},
{ 0x766E , 0xB061},
{ 0x7670 , 0xB062},
{ 0x7671 , 0xB063},
{ 0x7672 , 0xB064},
{ 0x7673 , 0xB065},
{ 0x7674 , 0xB066},
{ 0x7675 , 0xB067},
{ 0x7676 , 0xB068},
{ 0x7677 , 0xB069},
{ 0x7679 , 0xB06A},
{ 0x767A , 0xB06B},
{ 0x767C , 0xB06C},
{ 0x767F , 0xB06D},
{ 0x7680 , 0xB06E},
{ 0x7681 , 0xB06F},
{ 0x7683 , 0xB070},
{ 0x7685 , 0xB071},
{ 0x7689 , 0xB072},
{ 0x768A , 0xB073},
{ 0x768C , 0xB074},
{ 0x768D , 0xB075},
{ 0x768F , 0xB076},
{ 0x7690 , 0xB077},
{ 0x7692 , 0xB078},
{ 0x7694 , 0xB079},
{ 0x7695 , 0xB07A},
{ 0x7697 , 0xB07B},
{ 0x7698 , 0xB07C},
{ 0x769A , 0xB07D},
{ 0x769B , 0xB07E},
{ 0x769C , 0xB080},
{ 0x769D , 0xB081},
{ 0x769E , 0xB082},
{ 0x769F , 0xB083},
{ 0x76A0 , 0xB084},
{ 0x76A1 , 0xB085},
{ 0x76A2 , 0xB086},
{ 0x76A3 , 0xB087},
{ 0x76A5 , 0xB088},
{ 0x76A6 , 0xB089},
{ 0x76A7 , 0xB08A},
{ 0x76A8 , 0xB08B},
{ 0x76A9 , 0xB08C},
{ 0x76AA , 0xB08D},
{ 0x76AB , 0xB08E},
{ 0x76AC , 0xB08F},
{ 0x76AD , 0xB090},
{ 0x76AF , 0xB091},
{ 0x76B0 , 0xB092},
{ 0x76B3 , 0xB093},
{ 0x76B5 , 0xB094},
{ 0x76B6 , 0xB095},
{ 0x76B7 , 0xB096},
{ 0x76B8 , 0xB097},
{ 0x76B9 , 0xB098},
{ 0x76BA , 0xB099},
{ 0x76BB , 0xB09A},
{ 0x76BC , 0xB09B},
{ 0x76BD , 0xB09C},
{ 0x76BE , 0xB09D},
{ 0x76C0 , 0xB09E},
{ 0x76C1 , 0xB09F},
{ 0x76C3 , 0xB0A0},
{ 0x554A , 0xB0A1},
{ 0x963F , 0xB0A2},
{ 0x57C3 , 0xB0A3},
{ 0x6328 , 0xB0A4},
{ 0x54CE , 0xB0A5},
{ 0x5509 , 0xB0A6},
{ 0x54C0 , 0xB0A7},
{ 0x7691 , 0xB0A8},
{ 0x764C , 0xB0A9},
{ 0x853C , 0xB0AA},
{ 0x77EE , 0xB0AB},
{ 0x827E , 0xB0AC},
{ 0x788D , 0xB0AD},
{ 0x7231 , 0xB0AE},
{ 0x9698 , 0xB0AF},
{ 0x978D , 0xB0B0},
{ 0x6C28 , 0xB0B1},
{ 0x5B89 , 0xB0B2},
{ 0x4FFA , 0xB0B3},
{ 0x6309 , 0xB0B4},
{ 0x6697 , 0xB0B5},
{ 0x5CB8 , 0xB0B6},
{ 0x80FA , 0xB0B7},
{ 0x6848 , 0xB0B8},
{ 0x80AE , 0xB0B9},
{ 0x6602 , 0xB0BA},
{ 0x76CE , 0xB0BB},
{ 0x51F9 , 0xB0BC},
{ 0x6556 , 0xB0BD},
{ 0x71AC , 0xB0BE},
{ 0x7FF1 , 0xB0BF},
{ 0x8884 , 0xB0C0},
{ 0x50B2 , 0xB0C1},
{ 0x5965 , 0xB0C2},
{ 0x61CA , 0xB0C3},
{ 0x6FB3 , 0xB0C4},
{ 0x82AD , 0xB0C5},
{ 0x634C , 0xB0C6},
{ 0x6252 , 0xB0C7},
{ 0x53ED , 0xB0C8},
{ 0x5427 , 0xB0C9},
{ 0x7B06 , 0xB0CA},
{ 0x516B , 0xB0CB},
{ 0x75A4 , 0xB0CC},
{ 0x5DF4 , 0xB0CD},
{ 0x62D4 , 0xB0CE},
{ 0x8DCB , 0xB0CF},
{ 0x9776 , 0xB0D0},
{ 0x628A , 0xB0D1},
{ 0x8019 , 0xB0D2},
{ 0x575D , 0xB0D3},
{ 0x9738 , 0xB0D4},
{ 0x7F62 , 0xB0D5},
{ 0x7238 , 0xB0D6},
{ 0x767D , 0xB0D7},
{ 0x67CF , 0xB0D8},
{ 0x767E , 0xB0D9},
{ 0x6446 , 0xB0DA},
{ 0x4F70 , 0xB0DB},
{ 0x8D25 , 0xB0DC},
{ 0x62DC , 0xB0DD},
{ 0x7A17 , 0xB0DE},
{ 0x6591 , 0xB0DF},
{ 0x73ED , 0xB0E0},
{ 0x642C , 0xB0E1},
{ 0x6273 , 0xB0E2},
{ 0x822C , 0xB0E3},
{ 0x9881 , 0xB0E4},
{ 0x677F , 0xB0E5},
{ 0x7248 , 0xB0E6},
{ 0x626E , 0xB0E7},
{ 0x62CC , 0xB0E8},
{ 0x4F34 , 0xB0E9},
{ 0x74E3 , 0xB0EA},
{ 0x534A , 0xB0EB},
{ 0x529E , 0xB0EC},
{ 0x7ECA , 0xB0ED},
{ 0x90A6 , 0xB0EE},
{ 0x5E2E , 0xB0EF},
{ 0x6886 , 0xB0F0},
{ 0x699C , 0xB0F1},
{ 0x8180 , 0xB0F2},
{ 0x7ED1 , 0xB0F3},
{ 0x68D2 , 0xB0F4},
{ 0x78C5 , 0xB0F5},
{ 0x868C , 0xB0F6},
{ 0x9551 , 0xB0F7},
{ 0x508D , 0xB0F8},
{ 0x8C24 , 0xB0F9},
{ 0x82DE , 0xB0FA},
{ 0x80DE , 0xB0FB},
{ 0x5305 , 0xB0FC},
{ 0x8912 , 0xB0FD},
{ 0x5265 , 0xB0FE},
{ 0x76C4 , 0xB140},
{ 0x76C7 , 0xB141},
{ 0x76C9 , 0xB142},
{ 0x76CB , 0xB143},
{ 0x76CC , 0xB144},
{ 0x76D3 , 0xB145},
{ 0x76D5 , 0xB146},
{ 0x76D9 , 0xB147},
{ 0x76DA , 0xB148},
{ 0x76DC , 0xB149},
{ 0x76DD , 0xB14A},
{ 0x76DE , 0xB14B},
{ 0x76E0 , 0xB14C},
{ 0x76E1 , 0xB14D},
{ 0x76E2 , 0xB14E},
{ 0x76E3 , 0xB14F},
{ 0x76E4 , 0xB150},
{ 0x76E6 , 0xB151},
{ 0x76E7 , 0xB152},
{ 0x76E8 , 0xB153},
{ 0x76E9 , 0xB154},
{ 0x76EA , 0xB155},
{ 0x76EB , 0xB156},
{ 0x76EC , 0xB157},
{ 0x76ED , 0xB158},
{ 0x76F0 , 0xB159},
{ 0x76F3 , 0xB15A},
{ 0x76F5 , 0xB15B},
{ 0x76F6 , 0xB15C},
{ 0x76F7 , 0xB15D},
{ 0x76FA , 0xB15E},
{ 0x76FB , 0xB15F},
{ 0x76FD , 0xB160},
{ 0x76FF , 0xB161},
{ 0x7700 , 0xB162},
{ 0x7702 , 0xB163},
{ 0x7703 , 0xB164},
{ 0x7705 , 0xB165},
{ 0x7706 , 0xB166},
{ 0x770A , 0xB167},
{ 0x770C , 0xB168},
{ 0x770E , 0xB169},
{ 0x770F , 0xB16A},
{ 0x7710 , 0xB16B},
{ 0x7711 , 0xB16C},
{ 0x7712 , 0xB16D},
{ 0x7713 , 0xB16E},
{ 0x7714 , 0xB16F},
{ 0x7715 , 0xB170},
{ 0x7716 , 0xB171},
{ 0x7717 , 0xB172},
{ 0x7718 , 0xB173},
{ 0x771B , 0xB174},
{ 0x771C , 0xB175},
{ 0x771D , 0xB176},
{ 0x771E , 0xB177},
{ 0x7721 , 0xB178},
{ 0x7723 , 0xB179},
{ 0x7724 , 0xB17A},
{ 0x7725 , 0xB17B},
{ 0x7727 , 0xB17C},
{ 0x772A , 0xB17D},
{ 0x772B , 0xB17E},
{ 0x772C , 0xB180},
{ 0x772E , 0xB181},
{ 0x7730 , 0xB182},
{ 0x7731 , 0xB183},
{ 0x7732 , 0xB184},
{ 0x7733 , 0xB185},
{ 0x7734 , 0xB186},
{ 0x7739 , 0xB187},
{ 0x773B , 0xB188},
{ 0x773D , 0xB189},
{ 0x773E , 0xB18A},
{ 0x773F , 0xB18B},
{ 0x7742 , 0xB18C},
{ 0x7744 , 0xB18D},
{ 0x7745 , 0xB18E},
{ 0x7746 , 0xB18F},
{ 0x7748 , 0xB190},
{ 0x7749 , 0xB191},
{ 0x774A , 0xB192},
{ 0x774B , 0xB193},
{ 0x774C , 0xB194},
{ 0x774D , 0xB195},
{ 0x774E , 0xB196},
{ 0x774F , 0xB197},
{ 0x7752 , 0xB198},
{ 0x7753 , 0xB199},
{ 0x7754 , 0xB19A},
{ 0x7755 , 0xB19B},
{ 0x7756 , 0xB19C},
{ 0x7757 , 0xB19D},
{ 0x7758 , 0xB19E},
{ 0x7759 , 0xB19F},
{ 0x775C , 0xB1A0},
{ 0x8584 , 0xB1A1},
{ 0x96F9 , 0xB1A2},
{ 0x4FDD , 0xB1A3},
{ 0x5821 , 0xB1A4},
{ 0x9971 , 0xB1A5},
{ 0x5B9D , 0xB1A6},
{ 0x62B1 , 0xB1A7},
{ 0x62A5 , 0xB1A8},
{ 0x66B4 , 0xB1A9},
{ 0x8C79 , 0xB1AA},
{ 0x9C8D , 0xB1AB},
{ 0x7206 , 0xB1AC},
{ 0x676F , 0xB1AD},
{ 0x7891 , 0xB1AE},
{ 0x60B2 , 0xB1AF},
{ 0x5351 , 0xB1B0},
{ 0x5317 , 0xB1B1},
{ 0x8F88 , 0xB1B2},
{ 0x80CC , 0xB1B3},
{ 0x8D1D , 0xB1B4},
{ 0x94A1 , 0xB1B5},
{ 0x500D , 0xB1B6},
{ 0x72C8 , 0xB1B7},
{ 0x5907 , 0xB1B8},
{ 0x60EB , 0xB1B9},
{ 0x7119 , 0xB1BA},
{ 0x88AB , 0xB1BB},
{ 0x5954 , 0xB1BC},
{ 0x82EF , 0xB1BD},
{ 0x672C , 0xB1BE},
{ 0x7B28 , 0xB1BF},
{ 0x5D29 , 0xB1C0},
{ 0x7EF7 , 0xB1C1},
{ 0x752D , 0xB1C2},
{ 0x6CF5 , 0xB1C3},
{ 0x8E66 , 0xB1C4},
{ 0x8FF8 , 0xB1C5},
{ 0x903C , 0xB1C6},
{ 0x9F3B , 0xB1C7},
{ 0x6BD4 , 0xB1C8},
{ 0x9119 , 0xB1C9},
{ 0x7B14 , 0xB1CA},
{ 0x5F7C , 0xB1CB},
{ 0x78A7 , 0xB1CC},
{ 0x84D6 , 0xB1CD},
{ 0x853D , 0xB1CE},
{ 0x6BD5 , 0xB1CF},
{ 0x6BD9 , 0xB1D0},
{ 0x6BD6 , 0xB1D1},
{ 0x5E01 , 0xB1D2},
{ 0x5E87 , 0xB1D3},
{ 0x75F9 , 0xB1D4},
{ 0x95ED , 0xB1D5},
{ 0x655D , 0xB1D6},
{ 0x5F0A , 0xB1D7},
{ 0x5FC5 , 0xB1D8},
{ 0x8F9F , 0xB1D9},
{ 0x58C1 , 0xB1DA},
{ 0x81C2 , 0xB1DB},
{ 0x907F , 0xB1DC},
{ 0x965B , 0xB1DD},
{ 0x97AD , 0xB1DE},
{ 0x8FB9 , 0xB1DF},
{ 0x7F16 , 0xB1E0},
{ 0x8D2C , 0xB1E1},
{ 0x6241 , 0xB1E2},
{ 0x4FBF , 0xB1E3},
{ 0x53D8 , 0xB1E4},
{ 0x535E , 0xB1E5},
{ 0x8FA8 , 0xB1E6},
{ 0x8FA9 , 0xB1E7},
{ 0x8FAB , 0xB1E8},
{ 0x904D , 0xB1E9},
{ 0x6807 , 0xB1EA},
{ 0x5F6A , 0xB1EB},
{ 0x8198 , 0xB1EC},
{ 0x8868 , 0xB1ED},
{ 0x9CD6 , 0xB1EE},
{ 0x618B , 0xB1EF},
{ 0x522B , 0xB1F0},
{ 0x762A , 0xB1F1},
{ 0x5F6C , 0xB1F2},
{ 0x658C , 0xB1F3},
{ 0x6FD2 , 0xB1F4},
{ 0x6EE8 , 0xB1F5},
{ 0x5BBE , 0xB1F6},
{ 0x6448 , 0xB1F7},
{ 0x5175 , 0xB1F8},
{ 0x51B0 , 0xB1F9},
{ 0x67C4 , 0xB1FA},
{ 0x4E19 , 0xB1FB},
{ 0x79C9 , 0xB1FC},
{ 0x997C , 0xB1FD},
{ 0x70B3 , 0xB1FE},
{ 0x775D , 0xB240},
{ 0x775E , 0xB241},
{ 0x775F , 0xB242},
{ 0x7760 , 0xB243},
{ 0x7764 , 0xB244},
{ 0x7767 , 0xB245},
{ 0x7769 , 0xB246},
{ 0x776A , 0xB247},
{ 0x776D , 0xB248},
{ 0x776E , 0xB249},
{ 0x776F , 0xB24A},
{ 0x7770 , 0xB24B},
{ 0x7771 , 0xB24C},
{ 0x7772 , 0xB24D},
{ 0x7773 , 0xB24E},
{ 0x7774 , 0xB24F},
{ 0x7775 , 0xB250},
{ 0x7776 , 0xB251},
{ 0x7777 , 0xB252},
{ 0x7778 , 0xB253},
{ 0x777A , 0xB254},
{ 0x777B , 0xB255},
{ 0x777C , 0xB256},
{ 0x7781 , 0xB257},
{ 0x7782 , 0xB258},
{ 0x7783 , 0xB259},
{ 0x7786 , 0xB25A},
{ 0x7787 , 0xB25B},
{ 0x7788 , 0xB25C},
{ 0x7789 , 0xB25D},
{ 0x778A , 0xB25E},
{ 0x778B , 0xB25F},
{ 0x778F , 0xB260},
{ 0x7790 , 0xB261},
{ 0x7793 , 0xB262},
{ 0x7794 , 0xB263},
{ 0x7795 , 0xB264},
{ 0x7796 , 0xB265},
{ 0x7797 , 0xB266},
{ 0x7798 , 0xB267},
{ 0x7799 , 0xB268},
{ 0x779A , 0xB269},
{ 0x779B , 0xB26A},
{ 0x779C , 0xB26B},
{ 0x779D , 0xB26C},
{ 0x779E , 0xB26D},
{ 0x77A1 , 0xB26E},
{ 0x77A3 , 0xB26F},
{ 0x77A4 , 0xB270},
{ 0x77A6 , 0xB271},
{ 0x77A8 , 0xB272},
{ 0x77AB , 0xB273},
{ 0x77AD , 0xB274},
{ 0x77AE , 0xB275},
{ 0x77AF , 0xB276},
{ 0x77B1 , 0xB277},
{ 0x77B2 , 0xB278},
{ 0x77B4 , 0xB279},
{ 0x77B6 , 0xB27A},
{ 0x77B7 , 0xB27B},
{ 0x77B8 , 0xB27C},
{ 0x77B9 , 0xB27D},
{ 0x77BA , 0xB27E},
{ 0x77BC , 0xB280},
{ 0x77BE , 0xB281},
{ 0x77C0 , 0xB282},
{ 0x77C1 , 0xB283},
{ 0x77C2 , 0xB284},
{ 0x77C3 , 0xB285},
{ 0x77C4 , 0xB286},
{ 0x77C5 , 0xB287},
{ 0x77C6 , 0xB288},
{ 0x77C7 , 0xB289},
{ 0x77C8 , 0xB28A},
{ 0x77C9 , 0xB28B},
{ 0x77CA , 0xB28C},
{ 0x77CB , 0xB28D},
{ 0x77CC , 0xB28E},
{ 0x77CE , 0xB28F},
{ 0x77CF , 0xB290},
{ 0x77D0 , 0xB291},
{ 0x77D1 , 0xB292},
{ 0x77D2 , 0xB293},
{ 0x77D3 , 0xB294},
{ 0x77D4 , 0xB295},
{ 0x77D5 , 0xB296},
{ 0x77D6 , 0xB297},
{ 0x77D8 , 0xB298},
{ 0x77D9 , 0xB299},
{ 0x77DA , 0xB29A},
{ 0x77DD , 0xB29B},
{ 0x77DE , 0xB29C},
{ 0x77DF , 0xB29D},
{ 0x77E0 , 0xB29E},
{ 0x77E1 , 0xB29F},
{ 0x77E4 , 0xB2A0},
{ 0x75C5 , 0xB2A1},
{ 0x5E76 , 0xB2A2},
{ 0x73BB , 0xB2A3},
{ 0x83E0 , 0xB2A4},
{ 0x64AD , 0xB2A5},
{ 0x62E8 , 0xB2A6},
{ 0x94B5 , 0xB2A7},
{ 0x6CE2 , 0xB2A8},
{ 0x535A , 0xB2A9},
{ 0x52C3 , 0xB2AA},
{ 0x640F , 0xB2AB},
{ 0x94C2 , 0xB2AC},
{ 0x7B94 , 0xB2AD},
{ 0x4F2F , 0xB2AE},
{ 0x5E1B , 0xB2AF},
{ 0x8236 , 0xB2B0},
{ 0x8116 , 0xB2B1},
{ 0x818A , 0xB2B2},
{ 0x6E24 , 0xB2B3},
{ 0x6CCA , 0xB2B4},
{ 0x9A73 , 0xB2B5},
{ 0x6355 , 0xB2B6},
{ 0x535C , 0xB2B7},
{ 0x54FA , 0xB2B8},
{ 0x8865 , 0xB2B9},
{ 0x57E0 , 0xB2BA},
{ 0x4E0D , 0xB2BB},
{ 0x5E03 , 0xB2BC},
{ 0x6B65 , 0xB2BD},
{ 0x7C3F , 0xB2BE},
{ 0x90E8 , 0xB2BF},
{ 0x6016 , 0xB2C0},
{ 0x64E6 , 0xB2C1},
{ 0x731C , 0xB2C2},
{ 0x88C1 , 0xB2C3},
{ 0x6750 , 0xB2C4},
{ 0x624D , 0xB2C5},
{ 0x8D22 , 0xB2C6},
{ 0x776C , 0xB2C7},
{ 0x8E29 , 0xB2C8},
{ 0x91C7 , 0xB2C9},
{ 0x5F69 , 0xB2CA},
{ 0x83DC , 0xB2CB},
{ 0x8521 , 0xB2CC},
{ 0x9910 , 0xB2CD},
{ 0x53C2 , 0xB2CE},
{ 0x8695 , 0xB2CF},
{ 0x6B8B , 0xB2D0},
{ 0x60ED , 0xB2D1},
{ 0x60E8 , 0xB2D2},
{ 0x707F , 0xB2D3},
{ 0x82CD , 0xB2D4},
{ 0x8231 , 0xB2D5},
{ 0x4ED3 , 0xB2D6},
{ 0x6CA7 , 0xB2D7},
{ 0x85CF , 0xB2D8},
{ 0x64CD , 0xB2D9},
{ 0x7CD9 , 0xB2DA},
{ 0x69FD , 0xB2DB},
{ 0x66F9 , 0xB2DC},
{ 0x8349 , 0xB2DD},
{ 0x5395 , 0xB2DE},
{ 0x7B56 , 0xB2DF},
{ 0x4FA7 , 0xB2E0},
{ 0x518C , 0xB2E1},
{ 0x6D4B , 0xB2E2},
{ 0x5C42 , 0xB2E3},
{ 0x8E6D , 0xB2E4},
{ 0x63D2 , 0xB2E5},
{ 0x53C9 , 0xB2E6},
{ 0x832C , 0xB2E7},
{ 0x8336 , 0xB2E8},
{ 0x67E5 , 0xB2E9},
{ 0x78B4 , 0xB2EA},
{ 0x643D , 0xB2EB},
{ 0x5BDF , 0xB2EC},
{ 0x5C94 , 0xB2ED},
{ 0x5DEE , 0xB2EE},
{ 0x8BE7 , 0xB2EF},
{ 0x62C6 , 0xB2F0},
{ 0x67F4 , 0xB2F1},
{ 0x8C7A , 0xB2F2},
{ 0x6400 , 0xB2F3},
{ 0x63BA , 0xB2F4},
{ 0x8749 , 0xB2F5},
{ 0x998B , 0xB2F6},
{ 0x8C17 , 0xB2F7},
{ 0x7F20 , 0xB2F8},
{ 0x94F2 , 0xB2F9},
{ 0x4EA7 , 0xB2FA},
{ 0x9610 , 0xB2FB},
{ 0x98A4 , 0xB2FC},
{ 0x660C , 0xB2FD},
{ 0x7316 , 0xB2FE},
{ 0x77E6 , 0xB340},
{ 0x77E8 , 0xB341},
{ 0x77EA , 0xB342},
{ 0x77EF , 0xB343},
{ 0x77F0 , 0xB344},
{ 0x77F1 , 0xB345},
{ 0x77F2 , 0xB346},
{ 0x77F4 , 0xB347},
{ 0x77F5 , 0xB348},
{ 0x77F7 , 0xB349},
{ 0x77F9 , 0xB34A},
{ 0x77FA , 0xB34B},
{ 0x77FB , 0xB34C},
{ 0x77FC , 0xB34D},
{ 0x7803 , 0xB34E},
{ 0x7804 , 0xB34F},
{ 0x7805 , 0xB350},
{ 0x7806 , 0xB351},
{ 0x7807 , 0xB352},
{ 0x7808 , 0xB353},
{ 0x780A , 0xB354},
{ 0x780B , 0xB355},
{ 0x780E , 0xB356},
{ 0x780F , 0xB357},
{ 0x7810 , 0xB358},
{ 0x7813 , 0xB359},
{ 0x7815 , 0xB35A},
{ 0x7819 , 0xB35B},
{ 0x781B , 0xB35C},
{ 0x781E , 0xB35D},
{ 0x7820 , 0xB35E},
{ 0x7821 , 0xB35F},
{ 0x7822 , 0xB360},
{ 0x7824 , 0xB361},
{ 0x7828 , 0xB362},
{ 0x782A , 0xB363},
{ 0x782B , 0xB364},
{ 0x782E , 0xB365},
{ 0x782F , 0xB366},
{ 0x7831 , 0xB367},
{ 0x7832 , 0xB368},
{ 0x7833 , 0xB369},
{ 0x7835 , 0xB36A},
{ 0x7836 , 0xB36B},
{ 0x783D , 0xB36C},
{ 0x783F , 0xB36D},
{ 0x7841 , 0xB36E},
{ 0x7842 , 0xB36F},
{ 0x7843 , 0xB370},
{ 0x7844 , 0xB371},
{ 0x7846 , 0xB372},
{ 0x7848 , 0xB373},
{ 0x7849 , 0xB374},
{ 0x784A , 0xB375},
{ 0x784B , 0xB376},
{ 0x784D , 0xB377},
{ 0x784F , 0xB378},
{ 0x7851 , 0xB379},
{ 0x7853 , 0xB37A},
{ 0x7854 , 0xB37B},
{ 0x7858 , 0xB37C},
{ 0x7859 , 0xB37D},
{ 0x785A , 0xB37E},
{ 0x785B , 0xB380},
{ 0x785C , 0xB381},
{ 0x785E , 0xB382},
{ 0x785F , 0xB383},
{ 0x7860 , 0xB384},
{ 0x7861 , 0xB385},
{ 0x7862 , 0xB386},
{ 0x7863 , 0xB387},
{ 0x7864 , 0xB388},
{ 0x7865 , 0xB389},
{ 0x7866 , 0xB38A},
{ 0x7867 , 0xB38B},
{ 0x7868 , 0xB38C},
{ 0x7869 , 0xB38D},
{ 0x786F , 0xB38E},
{ 0x7870 , 0xB38F},
{ 0x7871 , 0xB390},
{ 0x7872 , 0xB391},
{ 0x7873 , 0xB392},
{ 0x7874 , 0xB393},
{ 0x7875 , 0xB394},
{ 0x7876 , 0xB395},
{ 0x7878 , 0xB396},
{ 0x7879 , 0xB397},
{ 0x787A , 0xB398},
{ 0x787B , 0xB399},
{ 0x787D , 0xB39A},
{ 0x787E , 0xB39B},
{ 0x787F , 0xB39C},
{ 0x7880 , 0xB39D},
{ 0x7881 , 0xB39E},
{ 0x7882 , 0xB39F},
{ 0x7883 , 0xB3A0},
{ 0x573A , 0xB3A1},
{ 0x5C1D , 0xB3A2},
{ 0x5E38 , 0xB3A3},
{ 0x957F , 0xB3A4},
{ 0x507F , 0xB3A5},
{ 0x80A0 , 0xB3A6},
{ 0x5382 , 0xB3A7},
{ 0x655E , 0xB3A8},
{ 0x7545 , 0xB3A9},
{ 0x5531 , 0xB3AA},
{ 0x5021 , 0xB3AB},
{ 0x8D85 , 0xB3AC},
{ 0x6284 , 0xB3AD},
{ 0x949E , 0xB3AE},
{ 0x671D , 0xB3AF},
{ 0x5632 , 0xB3B0},
{ 0x6F6E , 0xB3B1},
{ 0x5DE2 , 0xB3B2},
{ 0x5435 , 0xB3B3},
{ 0x7092 , 0xB3B4},
{ 0x8F66 , 0xB3B5},
{ 0x626F , 0xB3B6},
{ 0x64A4 , 0xB3B7},
{ 0x63A3 , 0xB3B8},
{ 0x5F7B , 0xB3B9},
{ 0x6F88 , 0xB3BA},
{ 0x90F4 , 0xB3BB},
{ 0x81E3 , 0xB3BC},
{ 0x8FB0 , 0xB3BD},
{ 0x5C18 , 0xB3BE},
{ 0x6668 , 0xB3BF},
{ 0x5FF1 , 0xB3C0},
{ 0x6C89 , 0xB3C1},
{ 0x9648 , 0xB3C2},
{ 0x8D81 , 0xB3C3},
{ 0x886C , 0xB3C4},
{ 0x6491 , 0xB3C5},
{ 0x79F0 , 0xB3C6},
{ 0x57CE , 0xB3C7},
{ 0x6A59 , 0xB3C8},
{ 0x6210 , 0xB3C9},
{ 0x5448 , 0xB3CA},
{ 0x4E58 , 0xB3CB},
{ 0x7A0B , 0xB3CC},
{ 0x60E9 , 0xB3CD},
{ 0x6F84 , 0xB3CE},
{ 0x8BDA , 0xB3CF},
{ 0x627F , 0xB3D0},
{ 0x901E , 0xB3D1},
{ 0x9A8B , 0xB3D2},
{ 0x79E4 , 0xB3D3},
{ 0x5403 , 0xB3D4},
{ 0x75F4 , 0xB3D5},
{ 0x6301 , 0xB3D6},
{ 0x5319 , 0xB3D7},
{ 0x6C60 , 0xB3D8},
{ 0x8FDF , 0xB3D9},
{ 0x5F1B , 0xB3DA},
{ 0x9A70 , 0xB3DB},
{ 0x803B , 0xB3DC},
{ 0x9F7F , 0xB3DD},
{ 0x4F88 , 0xB3DE},
{ 0x5C3A , 0xB3DF},
{ 0x8D64 , 0xB3E0},
{ 0x7FC5 , 0xB3E1},
{ 0x65A5 , 0xB3E2},
{ 0x70BD , 0xB3E3},
{ 0x5145 , 0xB3E4},
{ 0x51B2 , 0xB3E5},
{ 0x866B , 0xB3E6},
{ 0x5D07 , 0xB3E7},
{ 0x5BA0 , 0xB3E8},
{ 0x62BD , 0xB3E9},
{ 0x916C , 0xB3EA},
{ 0x7574 , 0xB3EB},
{ 0x8E0C , 0xB3EC},
{ 0x7A20 , 0xB3ED},
{ 0x6101 , 0xB3EE},
{ 0x7B79 , 0xB3EF},
{ 0x4EC7 , 0xB3F0},
{ 0x7EF8 , 0xB3F1},
{ 0x7785 , 0xB3F2},
{ 0x4E11 , 0xB3F3},
{ 0x81ED , 0xB3F4},
{ 0x521D , 0xB3F5},
{ 0x51FA , 0xB3F6},
{ 0x6A71 , 0xB3F7},
{ 0x53A8 , 0xB3F8},
{ 0x8E87 , 0xB3F9},
{ 0x9504 , 0xB3FA},
{ 0x96CF , 0xB3FB},
{ 0x6EC1 , 0xB3FC},
{ 0x9664 , 0xB3FD},
{ 0x695A , 0xB3FE},
{ 0x7884 , 0xB440},
{ 0x7885 , 0xB441},
{ 0x7886 , 0xB442},
{ 0x7888 , 0xB443},
{ 0x788A , 0xB444},
{ 0x788B , 0xB445},
{ 0x788F , 0xB446},
{ 0x7890 , 0xB447},
{ 0x7892 , 0xB448},
{ 0x7894 , 0xB449},
{ 0x7895 , 0xB44A},
{ 0x7896 , 0xB44B},
{ 0x7899 , 0xB44C},
{ 0x789D , 0xB44D},
{ 0x789E , 0xB44E},
{ 0x78A0 , 0xB44F},
{ 0x78A2 , 0xB450},
{ 0x78A4 , 0xB451},
{ 0x78A6 , 0xB452},
{ 0x78A8 , 0xB453},
{ 0x78A9 , 0xB454},
{ 0x78AA , 0xB455},
{ 0x78AB , 0xB456},
{ 0x78AC , 0xB457},
{ 0x78AD , 0xB458},
{ 0x78AE , 0xB459},
{ 0x78AF , 0xB45A},
{ 0x78B5 , 0xB45B},
{ 0x78B6 , 0xB45C},
{ 0x78B7 , 0xB45D},
{ 0x78B8 , 0xB45E},
{ 0x78BA , 0xB45F},
{ 0x78BB , 0xB460},
{ 0x78BC , 0xB461},
{ 0x78BD , 0xB462},
{ 0x78BF , 0xB463},
{ 0x78C0 , 0xB464},
{ 0x78C2 , 0xB465},
{ 0x78C3 , 0xB466},
{ 0x78C4 , 0xB467},
{ 0x78C6 , 0xB468},
{ 0x78C7 , 0xB469},
{ 0x78C8 , 0xB46A},
{ 0x78CC , 0xB46B},
{ 0x78CD , 0xB46C},
{ 0x78CE , 0xB46D},
{ 0x78CF , 0xB46E},
{ 0x78D1 , 0xB46F},
{ 0x78D2 , 0xB470},
{ 0x78D3 , 0xB471},
{ 0x78D6 , 0xB472},
{ 0x78D7 , 0xB473},
{ 0x78D8 , 0xB474},
{ 0x78DA , 0xB475},
{ 0x78DB , 0xB476},
{ 0x78DC , 0xB477},
{ 0x78DD , 0xB478},
{ 0x78DE , 0xB479},
{ 0x78DF , 0xB47A},
{ 0x78E0 , 0xB47B},
{ 0x78E1 , 0xB47C},
{ 0x78E2 , 0xB47D},
{ 0x78E3 , 0xB47E},
{ 0x78E4 , 0xB480},
{ 0x78E5 , 0xB481},
{ 0x78E6 , 0xB482},
{ 0x78E7 , 0xB483},
{ 0x78E9 , 0xB484},
{ 0x78EA , 0xB485},
{ 0x78EB , 0xB486},
{ 0x78ED , 0xB487},
{ 0x78EE , 0xB488},
{ 0x78EF , 0xB489},
{ 0x78F0 , 0xB48A},
{ 0x78F1 , 0xB48B},
{ 0x78F3 , 0xB48C},
{ 0x78F5 , 0xB48D},
{ 0x78F6 , 0xB48E},
{ 0x78F8 , 0xB48F},
{ 0x78F9 , 0xB490},
{ 0x78FB , 0xB491},
{ 0x78FC , 0xB492},
{ 0x78FD , 0xB493},
{ 0x78FE , 0xB494},
{ 0x78FF , 0xB495},
{ 0x7900 , 0xB496},
{ 0x7902 , 0xB497},
{ 0x7903 , 0xB498},
{ 0x7904 , 0xB499},
{ 0x7906 , 0xB49A},
{ 0x7907 , 0xB49B},
{ 0x7908 , 0xB49C},
{ 0x7909 , 0xB49D},
{ 0x790A , 0xB49E},
{ 0x790B , 0xB49F},
{ 0x790C , 0xB4A0},
{ 0x7840 , 0xB4A1},
{ 0x50A8 , 0xB4A2},
{ 0x77D7 , 0xB4A3},
{ 0x6410 , 0xB4A4},
{ 0x89E6 , 0xB4A5},
{ 0x5904 , 0xB4A6},
{ 0x63E3 , 0xB4A7},
{ 0x5DDD , 0xB4A8},
{ 0x7A7F , 0xB4A9},
{ 0x693D , 0xB4AA},
{ 0x4F20 , 0xB4AB},
{ 0x8239 , 0xB4AC},
{ 0x5598 , 0xB4AD},
{ 0x4E32 , 0xB4AE},
{ 0x75AE , 0xB4AF},
{ 0x7A97 , 0xB4B0},
{ 0x5E62 , 0xB4B1},
{ 0x5E8A , 0xB4B2},
{ 0x95EF , 0xB4B3},
{ 0x521B , 0xB4B4},
{ 0x5439 , 0xB4B5},
{ 0x708A , 0xB4B6},
{ 0x6376 , 0xB4B7},
{ 0x9524 , 0xB4B8},
{ 0x5782 , 0xB4B9},
{ 0x6625 , 0xB4BA},
{ 0x693F , 0xB4BB},
{ 0x9187 , 0xB4BC},
{ 0x5507 , 0xB4BD},
{ 0x6DF3 , 0xB4BE},
{ 0x7EAF , 0xB4BF},
{ 0x8822 , 0xB4C0},
{ 0x6233 , 0xB4C1},
{ 0x7EF0 , 0xB4C2},
{ 0x75B5 , 0xB4C3},
{ 0x8328 , 0xB4C4},
{ 0x78C1 , 0xB4C5},
{ 0x96CC , 0xB4C6},
{ 0x8F9E , 0xB4C7},
{ 0x6148 , 0xB4C8},
{ 0x74F7 , 0xB4C9},
{ 0x8BCD , 0xB4CA},
{ 0x6B64 , 0xB4CB},
{ 0x523A , 0xB4CC},
{ 0x8D50 , 0xB4CD},
{ 0x6B21 , 0xB4CE},
{ 0x806A , 0xB4CF},
{ 0x8471 , 0xB4D0},
{ 0x56F1 , 0xB4D1},
{ 0x5306 , 0xB4D2},
{ 0x4ECE , 0xB4D3},
{ 0x4E1B , 0xB4D4},
{ 0x51D1 , 0xB4D5},
{ 0x7C97 , 0xB4D6},
{ 0x918B , 0xB4D7},
{ 0x7C07 , 0xB4D8},
{ 0x4FC3 , 0xB4D9},
{ 0x8E7F , 0xB4DA},
{ 0x7BE1 , 0xB4DB},
{ 0x7A9C , 0xB4DC},
{ 0x6467 , 0xB4DD},
{ 0x5D14 , 0xB4DE},
{ 0x50AC , 0xB4DF},
{ 0x8106 , 0xB4E0},
{ 0x7601 , 0xB4E1},
{ 0x7CB9 , 0xB4E2},
{ 0x6DEC , 0xB4E3},
{ 0x7FE0 , 0xB4E4},
{ 0x6751 , 0xB4E5},
{ 0x5B58 , 0xB4E6},
{ 0x5BF8 , 0xB4E7},
{ 0x78CB , 0xB4E8},
{ 0x64AE , 0xB4E9},
{ 0x6413 , 0xB4EA},
{ 0x63AA , 0xB4EB},
{ 0x632B , 0xB4EC},
{ 0x9519 , 0xB4ED},
{ 0x642D , 0xB4EE},
{ 0x8FBE , 0xB4EF},
{ 0x7B54 , 0xB4F0},
{ 0x7629 , 0xB4F1},
{ 0x6253 , 0xB4F2},
{ 0x5927 , 0xB4F3},
{ 0x5446 , 0xB4F4},
{ 0x6B79 , 0xB4F5},
{ 0x50A3 , 0xB4F6},
{ 0x6234 , 0xB4F7},
{ 0x5E26 , 0xB4F8},
{ 0x6B86 , 0xB4F9},
{ 0x4EE3 , 0xB4FA},
{ 0x8D37 , 0xB4FB},
{ 0x888B , 0xB4FC},
{ 0x5F85 , 0xB4FD},
{ 0x902E , 0xB4FE},
{ 0x790D , 0xB540},
{ 0x790E , 0xB541},
{ 0x790F , 0xB542},
{ 0x7910 , 0xB543},
{ 0x7911 , 0xB544},
{ 0x7912 , 0xB545},
{ 0x7914 , 0xB546},
{ 0x7915 , 0xB547},
{ 0x7916 , 0xB548},
{ 0x7917 , 0xB549},
{ 0x7918 , 0xB54A},
{ 0x7919 , 0xB54B},
{ 0x791A , 0xB54C},
{ 0x791B , 0xB54D},
{ 0x791C , 0xB54E},
{ 0x791D , 0xB54F},
{ 0x791F , 0xB550},
{ 0x7920 , 0xB551},
{ 0x7921 , 0xB552},
{ 0x7922 , 0xB553},
{ 0x7923 , 0xB554},
{ 0x7925 , 0xB555},
{ 0x7926 , 0xB556},
{ 0x7927 , 0xB557},
{ 0x7928 , 0xB558},
{ 0x7929 , 0xB559},
{ 0x792A , 0xB55A},
{ 0x792B , 0xB55B},
{ 0x792C , 0xB55C},
{ 0x792D , 0xB55D},
{ 0x792E , 0xB55E},
{ 0x792F , 0xB55F},
{ 0x7930 , 0xB560},
{ 0x7931 , 0xB561},
{ 0x7932 , 0xB562},
{ 0x7933 , 0xB563},
{ 0x7935 , 0xB564},
{ 0x7936 , 0xB565},
{ 0x7937 , 0xB566},
{ 0x7938 , 0xB567},
{ 0x7939 , 0xB568},
{ 0x793D , 0xB569},
{ 0x793F , 0xB56A},
{ 0x7942 , 0xB56B},
{ 0x7943 , 0xB56C},
{ 0x7944 , 0xB56D},
{ 0x7945 , 0xB56E},
{ 0x7947 , 0xB56F},
{ 0x794A , 0xB570},
{ 0x794B , 0xB571},
{ 0x794C , 0xB572},
{ 0x794D , 0xB573},
{ 0x794E , 0xB574},
{ 0x794F , 0xB575},
{ 0x7950 , 0xB576},
{ 0x7951 , 0xB577},
{ 0x7952 , 0xB578},
{ 0x7954 , 0xB579},
{ 0x7955 , 0xB57A},
{ 0x7958 , 0xB57B},
{ 0x7959 , 0xB57C},
{ 0x7961 , 0xB57D},
{ 0x7963 , 0xB57E},
{ 0x7964 , 0xB580},
{ 0x7966 , 0xB581},
{ 0x7969 , 0xB582},
{ 0x796A , 0xB583},
{ 0x796B , 0xB584},
{ 0x796C , 0xB585},
{ 0x796E , 0xB586},
{ 0x7970 , 0xB587},
{ 0x7971 , 0xB588},
{ 0x7972 , 0xB589},
{ 0x7973 , 0xB58A},
{ 0x7974 , 0xB58B},
{ 0x7975 , 0xB58C},
{ 0x7976 , 0xB58D},
{ 0x7979 , 0xB58E},
{ 0x797B , 0xB58F},
{ 0x797C , 0xB590},
{ 0x797D , 0xB591},
{ 0x797E , 0xB592},
{ 0x797F , 0xB593},
{ 0x7982 , 0xB594},
{ 0x7983 , 0xB595},
{ 0x7986 , 0xB596},
{ 0x7987 , 0xB597},
{ 0x7988 , 0xB598},
{ 0x7989 , 0xB599},
{ 0x798B , 0xB59A},
{ 0x798C , 0xB59B},
{ 0x798D , 0xB59C},
{ 0x798E , 0xB59D},
{ 0x7990 , 0xB59E},
{ 0x7991 , 0xB59F},
{ 0x7992 , 0xB5A0},
{ 0x6020 , 0xB5A1},
{ 0x803D , 0xB5A2},
{ 0x62C5 , 0xB5A3},
{ 0x4E39 , 0xB5A4},
{ 0x5355 , 0xB5A5},
{ 0x90F8 , 0xB5A6},
{ 0x63B8 , 0xB5A7},
{ 0x80C6 , 0xB5A8},
{ 0x65E6 , 0xB5A9},
{ 0x6C2E , 0xB5AA},
{ 0x4F46 , 0xB5AB},
{ 0x60EE , 0xB5AC},
{ 0x6DE1 , 0xB5AD},
{ 0x8BDE , 0xB5AE},
{ 0x5F39 , 0xB5AF},
{ 0x86CB , 0xB5B0},
{ 0x5F53 , 0xB5B1},
{ 0x6321 , 0xB5B2},
{ 0x515A , 0xB5B3},
{ 0x8361 , 0xB5B4},
{ 0x6863 , 0xB5B5},
{ 0x5200 , 0xB5B6},
{ 0x6363 , 0xB5B7},
{ 0x8E48 , 0xB5B8},
{ 0x5012 , 0xB5B9},
{ 0x5C9B , 0xB5BA},
{ 0x7977 , 0xB5BB},
{ 0x5BFC , 0xB5BC},
{ 0x5230 , 0xB5BD},
{ 0x7A3B , 0xB5BE},
{ 0x60BC , 0xB5BF},
{ 0x9053 , 0xB5C0},
{ 0x76D7 , 0xB5C1},
{ 0x5FB7 , 0xB5C2},
{ 0x5F97 , 0xB5C3},
{ 0x7684 , 0xB5C4},
{ 0x8E6C , 0xB5C5},
{ 0x706F , 0xB5C6},
{ 0x767B , 0xB5C7},
{ 0x7B49 , 0xB5C8},
{ 0x77AA , 0xB5C9},
{ 0x51F3 , 0xB5CA},
{ 0x9093 , 0xB5CB},
{ 0x5824 , 0xB5CC},
{ 0x4F4E , 0xB5CD},
{ 0x6EF4 , 0xB5CE},
{ 0x8FEA , 0xB5CF},
{ 0x654C , 0xB5D0},
{ 0x7B1B , 0xB5D1},
{ 0x72C4 , 0xB5D2},
{ 0x6DA4 , 0xB5D3},
{ 0x7FDF , 0xB5D4},
{ 0x5AE1 , 0xB5D5},
{ 0x62B5 , 0xB5D6},
{ 0x5E95 , 0xB5D7},
{ 0x5730 , 0xB5D8},
{ 0x8482 , 0xB5D9},
{ 0x7B2C , 0xB5DA},
{ 0x5E1D , 0xB5DB},
{ 0x5F1F , 0xB5DC},
{ 0x9012 , 0xB5DD},
{ 0x7F14 , 0xB5DE},
{ 0x98A0 , 0xB5DF},
{ 0x6382 , 0xB5E0},
{ 0x6EC7 , 0xB5E1},
{ 0x7898 , 0xB5E2},
{ 0x70B9 , 0xB5E3},
{ 0x5178 , 0xB5E4},
{ 0x975B , 0xB5E5},
{ 0x57AB , 0xB5E6},
{ 0x7535 , 0xB5E7},
{ 0x4F43 , 0xB5E8},
{ 0x7538 , 0xB5E9},
{ 0x5E97 , 0xB5EA},
{ 0x60E6 , 0xB5EB},
{ 0x5960 , 0xB5EC},
{ 0x6DC0 , 0xB5ED},
{ 0x6BBF , 0xB5EE},
{ 0x7889 , 0xB5EF},
{ 0x53FC , 0xB5F0},
{ 0x96D5 , 0xB5F1},
{ 0x51CB , 0xB5F2},
{ 0x5201 , 0xB5F3},
{ 0x6389 , 0xB5F4},
{ 0x540A , 0xB5F5},
{ 0x9493 , 0xB5F6},
{ 0x8C03 , 0xB5F7},
{ 0x8DCC , 0xB5F8},
{ 0x7239 , 0xB5F9},
{ 0x789F , 0xB5FA},
{ 0x8776 , 0xB5FB},
{ 0x8FED , 0xB5FC},
{ 0x8C0D , 0xB5FD},
{ 0x53E0 , 0xB5FE},
{ 0x7993 , 0xB640},
{ 0x7994 , 0xB641},
{ 0x7995 , 0xB642},
{ 0x7996 , 0xB643},
{ 0x7997 , 0xB644},
{ 0x7998 , 0xB645},
{ 0x7999 , 0xB646},
{ 0x799B , 0xB647},
{ 0x799C , 0xB648},
{ 0x799D , 0xB649},
{ 0x799E , 0xB64A},
{ 0x799F , 0xB64B},
{ 0x79A0 , 0xB64C},
{ 0x79A1 , 0xB64D},
{ 0x79A2 , 0xB64E},
{ 0x79A3 , 0xB64F},
{ 0x79A4 , 0xB650},
{ 0x79A5 , 0xB651},
{ 0x79A6 , 0xB652},
{ 0x79A8 , 0xB653},
{ 0x79A9 , 0xB654},
{ 0x79AA , 0xB655},
{ 0x79AB , 0xB656},
{ 0x79AC , 0xB657},
{ 0x79AD , 0xB658},
{ 0x79AE , 0xB659},
{ 0x79AF , 0xB65A},
{ 0x79B0 , 0xB65B},
{ 0x79B1 , 0xB65C},
{ 0x79B2 , 0xB65D},
{ 0x79B4 , 0xB65E},
{ 0x79B5 , 0xB65F},
{ 0x79B6 , 0xB660},
{ 0x79B7 , 0xB661},
{ 0x79B8 , 0xB662},
{ 0x79BC , 0xB663},
{ 0x79BF , 0xB664},
{ 0x79C2 , 0xB665},
{ 0x79C4 , 0xB666},
{ 0x79C5 , 0xB667},
{ 0x79C7 , 0xB668},
{ 0x79C8 , 0xB669},
{ 0x79CA , 0xB66A},
{ 0x79CC , 0xB66B},
{ 0x79CE , 0xB66C},
{ 0x79CF , 0xB66D},
{ 0x79D0 , 0xB66E},
{ 0x79D3 , 0xB66F},
{ 0x79D4 , 0xB670},
{ 0x79D6 , 0xB671},
{ 0x79D7 , 0xB672},
{ 0x79D9 , 0xB673},
{ 0x79DA , 0xB674},
{ 0x79DB , 0xB675},
{ 0x79DC , 0xB676},
{ 0x79DD , 0xB677},
{ 0x79DE , 0xB678},
{ 0x79E0 , 0xB679},
{ 0x79E1 , 0xB67A},
{ 0x79E2 , 0xB67B},
{ 0x79E5 , 0xB67C},
{ 0x79E8 , 0xB67D},
{ 0x79EA , 0xB67E},
{ 0x79EC , 0xB680},
{ 0x79EE , 0xB681},
{ 0x79F1 , 0xB682},
{ 0x79F2 , 0xB683},
{ 0x79F3 , 0xB684},
{ 0x79F4 , 0xB685},
{ 0x79F5 , 0xB686},
{ 0x79F6 , 0xB687},
{ 0x79F7 , 0xB688},
{ 0x79F9 , 0xB689},
{ 0x79FA , 0xB68A},
{ 0x79FC , 0xB68B},
{ 0x79FE , 0xB68C},
{ 0x79FF , 0xB68D},
{ 0x7A01 , 0xB68E},
{ 0x7A04 , 0xB68F},
{ 0x7A05 , 0xB690},
{ 0x7A07 , 0xB691},
{ 0x7A08 , 0xB692},
{ 0x7A09 , 0xB693},
{ 0x7A0A , 0xB694},
{ 0x7A0C , 0xB695},
{ 0x7A0F , 0xB696},
{ 0x7A10 , 0xB697},
{ 0x7A11 , 0xB698},
{ 0x7A12 , 0xB699},
{ 0x7A13 , 0xB69A},
{ 0x7A15 , 0xB69B},
{ 0x7A16 , 0xB69C},
{ 0x7A18 , 0xB69D},
{ 0x7A19 , 0xB69E},
{ 0x7A1B , 0xB69F},
{ 0x7A1C , 0xB6A0},
{ 0x4E01 , 0xB6A1},
{ 0x76EF , 0xB6A2},
{ 0x53EE , 0xB6A3},
{ 0x9489 , 0xB6A4},
{ 0x9876 , 0xB6A5},
{ 0x9F0E , 0xB6A6},
{ 0x952D , 0xB6A7},
{ 0x5B9A , 0xB6A8},
{ 0x8BA2 , 0xB6A9},
{ 0x4E22 , 0xB6AA},
{ 0x4E1C , 0xB6AB},
{ 0x51AC , 0xB6AC},
{ 0x8463 , 0xB6AD},
{ 0x61C2 , 0xB6AE},
{ 0x52A8 , 0xB6AF},
{ 0x680B , 0xB6B0},
{ 0x4F97 , 0xB6B1},
{ 0x606B , 0xB6B2},
{ 0x51BB , 0xB6B3},
{ 0x6D1E , 0xB6B4},
{ 0x515C , 0xB6B5},
{ 0x6296 , 0xB6B6},
{ 0x6597 , 0xB6B7},
{ 0x9661 , 0xB6B8},
{ 0x8C46 , 0xB6B9},
{ 0x9017 , 0xB6BA},
{ 0x75D8 , 0xB6BB},
{ 0x90FD , 0xB6BC},
{ 0x7763 , 0xB6BD},
{ 0x6BD2 , 0xB6BE},
{ 0x728A , 0xB6BF},
{ 0x72EC , 0xB6C0},
{ 0x8BFB , 0xB6C1},
{ 0x5835 , 0xB6C2},
{ 0x7779 , 0xB6C3},
{ 0x8D4C , 0xB6C4},
{ 0x675C , 0xB6C5},
{ 0x9540 , 0xB6C6},
{ 0x809A , 0xB6C7},
{ 0x5EA6 , 0xB6C8},
{ 0x6E21 , 0xB6C9},
{ 0x5992 , 0xB6CA},
{ 0x7AEF , 0xB6CB},
{ 0x77ED , 0xB6CC},
{ 0x953B , 0xB6CD},
{ 0x6BB5 , 0xB6CE},
{ 0x65AD , 0xB6CF},
{ 0x7F0E , 0xB6D0},
{ 0x5806 , 0xB6D1},
{ 0x5151 , 0xB6D2},
{ 0x961F , 0xB6D3},
{ 0x5BF9 , 0xB6D4},
{ 0x58A9 , 0xB6D5},
{ 0x5428 , 0xB6D6},
{ 0x8E72 , 0xB6D7},
{ 0x6566 , 0xB6D8},
{ 0x987F , 0xB6D9},
{ 0x56E4 , 0xB6DA},
{ 0x949D , 0xB6DB},
{ 0x76FE , 0xB6DC},
{ 0x9041 , 0xB6DD},
{ 0x6387 , 0xB6DE},
{ 0x54C6 , 0xB6DF},
{ 0x591A , 0xB6E0},
{ 0x593A , 0xB6E1},
{ 0x579B , 0xB6E2},
{ 0x8EB2 , 0xB6E3},
{ 0x6735 , 0xB6E4},
{ 0x8DFA , 0xB6E5},
{ 0x8235 , 0xB6E6},
{ 0x5241 , 0xB6E7},
{ 0x60F0 , 0xB6E8},
{ 0x5815 , 0xB6E9},
{ 0x86FE , 0xB6EA},
{ 0x5CE8 , 0xB6EB},
{ 0x9E45 , 0xB6EC},
{ 0x4FC4 , 0xB6ED},
{ 0x989D , 0xB6EE},
{ 0x8BB9 , 0xB6EF},
{ 0x5A25 , 0xB6F0},
{ 0x6076 , 0xB6F1},
{ 0x5384 , 0xB6F2},
{ 0x627C , 0xB6F3},
{ 0x904F , 0xB6F4},
{ 0x9102 , 0xB6F5},
{ 0x997F , 0xB6F6},
{ 0x6069 , 0xB6F7},
{ 0x800C , 0xB6F8},
{ 0x513F , 0xB6F9},
{ 0x8033 , 0xB6FA},
{ 0x5C14 , 0xB6FB},
{ 0x9975 , 0xB6FC},
{ 0x6D31 , 0xB6FD},
{ 0x4E8C , 0xB6FE},
{ 0x7A1D , 0xB740},
{ 0x7A1F , 0xB741},
{ 0x7A21 , 0xB742},
{ 0x7A22 , 0xB743},
{ 0x7A24 , 0xB744},
{ 0x7A25 , 0xB745},
{ 0x7A26 , 0xB746},
{ 0x7A27 , 0xB747},
{ 0x7A28 , 0xB748},
{ 0x7A29 , 0xB749},
{ 0x7A2A , 0xB74A},
{ 0x7A2B , 0xB74B},
{ 0x7A2C , 0xB74C},
{ 0x7A2D , 0xB74D},
{ 0x7A2E , 0xB74E},
{ 0x7A2F , 0xB74F},
{ 0x7A30 , 0xB750},
{ 0x7A31 , 0xB751},
{ 0x7A32 , 0xB752},
{ 0x7A34 , 0xB753},
{ 0x7A35 , 0xB754},
{ 0x7A36 , 0xB755},
{ 0x7A38 , 0xB756},
{ 0x7A3A , 0xB757},
{ 0x7A3E , 0xB758},
{ 0x7A40 , 0xB759},
{ 0x7A41 , 0xB75A},
{ 0x7A42 , 0xB75B},
{ 0x7A43 , 0xB75C},
{ 0x7A44 , 0xB75D},
{ 0x7A45 , 0xB75E},
{ 0x7A47 , 0xB75F},
{ 0x7A48 , 0xB760},
{ 0x7A49 , 0xB761},
{ 0x7A4A , 0xB762},
{ 0x7A4B , 0xB763},
{ 0x7A4C , 0xB764},
{ 0x7A4D , 0xB765},
{ 0x7A4E , 0xB766},
{ 0x7A4F , 0xB767},
{ 0x7A50 , 0xB768},
{ 0x7A52 , 0xB769},
{ 0x7A53 , 0xB76A},
{ 0x7A54 , 0xB76B},
{ 0x7A55 , 0xB76C},
{ 0x7A56 , 0xB76D},
{ 0x7A58 , 0xB76E},
{ 0x7A59 , 0xB76F},
{ 0x7A5A , 0xB770},
{ 0x7A5B , 0xB771},
{ 0x7A5C , 0xB772},
{ 0x7A5D , 0xB773},
{ 0x7A5E , 0xB774},
{ 0x7A5F , 0xB775},
{ 0x7A60 , 0xB776},
{ 0x7A61 , 0xB777},
{ 0x7A62 , 0xB778},
{ 0x7A63 , 0xB779},
{ 0x7A64 , 0xB77A},
{ 0x7A65 , 0xB77B},
{ 0x7A66 , 0xB77C},
{ 0x7A67 , 0xB77D},
{ 0x7A68 , 0xB77E},
{ 0x7A69 , 0xB780},
{ 0x7A6A , 0xB781},
{ 0x7A6B , 0xB782},
{ 0x7A6C , 0xB783},
{ 0x7A6D , 0xB784},
{ 0x7A6E , 0xB785},
{ 0x7A6F , 0xB786},
{ 0x7A71 , 0xB787},
{ 0x7A72 , 0xB788},
{ 0x7A73 , 0xB789},
{ 0x7A75 , 0xB78A},
{ 0x7A7B , 0xB78B},
{ 0x7A7C , 0xB78C},
{ 0x7A7D , 0xB78D},
{ 0x7A7E , 0xB78E},
{ 0x7A82 , 0xB78F},
{ 0x7A85 , 0xB790},
{ 0x7A87 , 0xB791},
{ 0x7A89 , 0xB792},
{ 0x7A8A , 0xB793},
{ 0x7A8B , 0xB794},
{ 0x7A8C , 0xB795},
{ 0x7A8E , 0xB796},
{ 0x7A8F , 0xB797},
{ 0x7A90 , 0xB798},
{ 0x7A93 , 0xB799},
{ 0x7A94 , 0xB79A},
{ 0x7A99 , 0xB79B},
{ 0x7A9A , 0xB79C},
{ 0x7A9B , 0xB79D},
{ 0x7A9E , 0xB79E},
{ 0x7AA1 , 0xB79F},
{ 0x7AA2 , 0xB7A0},
{ 0x8D30 , 0xB7A1},
{ 0x53D1 , 0xB7A2},
{ 0x7F5A , 0xB7A3},
{ 0x7B4F , 0xB7A4},
{ 0x4F10 , 0xB7A5},
{ 0x4E4F , 0xB7A6},
{ 0x9600 , 0xB7A7},
{ 0x6CD5 , 0xB7A8},
{ 0x73D0 , 0xB7A9},
{ 0x85E9 , 0xB7AA},
{ 0x5E06 , 0xB7AB},
{ 0x756A , 0xB7AC},
{ 0x7FFB , 0xB7AD},
{ 0x6A0A , 0xB7AE},
{ 0x77FE , 0xB7AF},
{ 0x9492 , 0xB7B0},
{ 0x7E41 , 0xB7B1},
{ 0x51E1 , 0xB7B2},
{ 0x70E6 , 0xB7B3},
{ 0x53CD , 0xB7B4},
{ 0x8FD4 , 0xB7B5},
{ 0x8303 , 0xB7B6},
{ 0x8D29 , 0xB7B7},
{ 0x72AF , 0xB7B8},
{ 0x996D , 0xB7B9},
{ 0x6CDB , 0xB7BA},
{ 0x574A , 0xB7BB},
{ 0x82B3 , 0xB7BC},
{ 0x65B9 , 0xB7BD},
{ 0x80AA , 0xB7BE},
{ 0x623F , 0xB7BF},
{ 0x9632 , 0xB7C0},
{ 0x59A8 , 0xB7C1},
{ 0x4EFF , 0xB7C2},
{ 0x8BBF , 0xB7C3},
{ 0x7EBA , 0xB7C4},
{ 0x653E , 0xB7C5},
{ 0x83F2 , 0xB7C6},
{ 0x975E , 0xB7C7},
{ 0x5561 , 0xB7C8},
{ 0x98DE , 0xB7C9},
{ 0x80A5 , 0xB7CA},
{ 0x532A , 0xB7CB},
{ 0x8BFD , 0xB7CC},
{ 0x5420 , 0xB7CD},
{ 0x80BA , 0xB7CE},
{ 0x5E9F , 0xB7CF},
{ 0x6CB8 , 0xB7D0},
{ 0x8D39 , 0xB7D1},
{ 0x82AC , 0xB7D2},
{ 0x915A , 0xB7D3},
{ 0x5429 , 0xB7D4},
{ 0x6C1B , 0xB7D5},
{ 0x5206 , 0xB7D6},
{ 0x7EB7 , 0xB7D7},
{ 0x575F , 0xB7D8},
{ 0x711A , 0xB7D9},
{ 0x6C7E , 0xB7DA},
{ 0x7C89 , 0xB7DB},
{ 0x594B , 0xB7DC},
{ 0x4EFD , 0xB7DD},
{ 0x5FFF , 0xB7DE},
{ 0x6124 , 0xB7DF},
{ 0x7CAA , 0xB7E0},
{ 0x4E30 , 0xB7E1},
{ 0x5C01 , 0xB7E2},
{ 0x67AB , 0xB7E3},
{ 0x8702 , 0xB7E4},
{ 0x5CF0 , 0xB7E5},
{ 0x950B , 0xB7E6},
{ 0x98CE , 0xB7E7},
{ 0x75AF , 0xB7E8},
{ 0x70FD , 0xB7E9},
{ 0x9022 , 0xB7EA},
{ 0x51AF , 0xB7EB},
{ 0x7F1D , 0xB7EC},
{ 0x8BBD , 0xB7ED},
{ 0x5949 , 0xB7EE},
{ 0x51E4 , 0xB7EF},
{ 0x4F5B , 0xB7F0},
{ 0x5426 , 0xB7F1},
{ 0x592B , 0xB7F2},
{ 0x6577 , 0xB7F3},
{ 0x80A4 , 0xB7F4},
{ 0x5B75 , 0xB7F5},
{ 0x6276 , 0xB7F6},
{ 0x62C2 , 0xB7F7},
{ 0x8F90 , 0xB7F8},
{ 0x5E45 , 0xB7F9},
{ 0x6C1F , 0xB7FA},
{ 0x7B26 , 0xB7FB},
{ 0x4F0F , 0xB7FC},
{ 0x4FD8 , 0xB7FD},
{ 0x670D , 0xB7FE},
{ 0x7AA3 , 0xB840},
{ 0x7AA4 , 0xB841},
{ 0x7AA7 , 0xB842},
{ 0x7AA9 , 0xB843},
{ 0x7AAA , 0xB844},
{ 0x7AAB , 0xB845},
{ 0x7AAE , 0xB846},
{ 0x7AAF , 0xB847},
{ 0x7AB0 , 0xB848},
{ 0x7AB1 , 0xB849},
{ 0x7AB2 , 0xB84A},
{ 0x7AB4 , 0xB84B},
{ 0x7AB5 , 0xB84C},
{ 0x7AB6 , 0xB84D},
{ 0x7AB7 , 0xB84E},
{ 0x7AB8 , 0xB84F},
{ 0x7AB9 , 0xB850},
{ 0x7ABA , 0xB851},
{ 0x7ABB , 0xB852},
{ 0x7ABC , 0xB853},
{ 0x7ABD , 0xB854},
{ 0x7ABE , 0xB855},
{ 0x7AC0 , 0xB856},
{ 0x7AC1 , 0xB857},
{ 0x7AC2 , 0xB858},
{ 0x7AC3 , 0xB859},
{ 0x7AC4 , 0xB85A},
{ 0x7AC5 , 0xB85B},
{ 0x7AC6 , 0xB85C},
{ 0x7AC7 , 0xB85D},
{ 0x7AC8 , 0xB85E},
{ 0x7AC9 , 0xB85F},
{ 0x7ACA , 0xB860},
{ 0x7ACC , 0xB861},
{ 0x7ACD , 0xB862},
{ 0x7ACE , 0xB863},
{ 0x7ACF , 0xB864},
{ 0x7AD0 , 0xB865},
{ 0x7AD1 , 0xB866},
{ 0x7AD2 , 0xB867},
{ 0x7AD3 , 0xB868},
{ 0x7AD4 , 0xB869},
{ 0x7AD5 , 0xB86A},
{ 0x7AD7 , 0xB86B},
{ 0x7AD8 , 0xB86C},
{ 0x7ADA , 0xB86D},
{ 0x7ADB , 0xB86E},
{ 0x7ADC , 0xB86F},
{ 0x7ADD , 0xB870},
{ 0x7AE1 , 0xB871},
{ 0x7AE2 , 0xB872},
{ 0x7AE4 , 0xB873},
{ 0x7AE7 , 0xB874},
{ 0x7AE8 , 0xB875},
{ 0x7AE9 , 0xB876},
{ 0x7AEA , 0xB877},
{ 0x7AEB , 0xB878},
{ 0x7AEC , 0xB879},
{ 0x7AEE , 0xB87A},
{ 0x7AF0 , 0xB87B},
{ 0x7AF1 , 0xB87C},
{ 0x7AF2 , 0xB87D},
{ 0x7AF3 , 0xB87E},
{ 0x7AF4 , 0xB880},
{ 0x7AF5 , 0xB881},
{ 0x7AF6 , 0xB882},
{ 0x7AF7 , 0xB883},
{ 0x7AF8 , 0xB884},
{ 0x7AFB , 0xB885},
{ 0x7AFC , 0xB886},
{ 0x7AFE , 0xB887},
{ 0x7B00 , 0xB888},
{ 0x7B01 , 0xB889},
{ 0x7B02 , 0xB88A},
{ 0x7B05 , 0xB88B},
{ 0x7B07 , 0xB88C},
{ 0x7B09 , 0xB88D},
{ 0x7B0C , 0xB88E},
{ 0x7B0D , 0xB88F},
{ 0x7B0E , 0xB890},
{ 0x7B10 , 0xB891},
{ 0x7B12 , 0xB892},
{ 0x7B13 , 0xB893},
{ 0x7B16 , 0xB894},
{ 0x7B17 , 0xB895},
{ 0x7B18 , 0xB896},
{ 0x7B1A , 0xB897},
{ 0x7B1C , 0xB898},
{ 0x7B1D , 0xB899},
{ 0x7B1F , 0xB89A},
{ 0x7B21 , 0xB89B},
{ 0x7B22 , 0xB89C},
{ 0x7B23 , 0xB89D},
{ 0x7B27 , 0xB89E},
{ 0x7B29 , 0xB89F},
{ 0x7B2D , 0xB8A0},
{ 0x6D6E , 0xB8A1},
{ 0x6DAA , 0xB8A2},
{ 0x798F , 0xB8A3},
{ 0x88B1 , 0xB8A4},
{ 0x5F17 , 0xB8A5},
{ 0x752B , 0xB8A6},
{ 0x629A , 0xB8A7},
{ 0x8F85 , 0xB8A8},
{ 0x4FEF , 0xB8A9},
{ 0x91DC , 0xB8AA},
{ 0x65A7 , 0xB8AB},
{ 0x812F , 0xB8AC},
{ 0x8151 , 0xB8AD},
{ 0x5E9C , 0xB8AE},
{ 0x8150 , 0xB8AF},
{ 0x8D74 , 0xB8B0},
{ 0x526F , 0xB8B1},
{ 0x8986 , 0xB8B2},
{ 0x8D4B , 0xB8B3},
{ 0x590D , 0xB8B4},
{ 0x5085 , 0xB8B5},
{ 0x4ED8 , 0xB8B6},
{ 0x961C , 0xB8B7},
{ 0x7236 , 0xB8B8},
{ 0x8179 , 0xB8B9},
{ 0x8D1F , 0xB8BA},
{ 0x5BCC , 0xB8BB},
{ 0x8BA3 , 0xB8BC},
{ 0x9644 , 0xB8BD},
{ 0x5987 , 0xB8BE},
{ 0x7F1A , 0xB8BF},
{ 0x5490 , 0xB8C0},
{ 0x5676 , 0xB8C1},
{ 0x560E , 0xB8C2},
{ 0x8BE5 , 0xB8C3},
{ 0x6539 , 0xB8C4},
{ 0x6982 , 0xB8C5},
{ 0x9499 , 0xB8C6},
{ 0x76D6 , 0xB8C7},
{ 0x6E89 , 0xB8C8},
{ 0x5E72 , 0xB8C9},
{ 0x7518 , 0xB8CA},
{ 0x6746 , 0xB8CB},
{ 0x67D1 , 0xB8CC},
{ 0x7AFF , 0xB8CD},
{ 0x809D , 0xB8CE},
{ 0x8D76 , 0xB8CF},
{ 0x611F , 0xB8D0},
{ 0x79C6 , 0xB8D1},
{ 0x6562 , 0xB8D2},
{ 0x8D63 , 0xB8D3},
{ 0x5188 , 0xB8D4},
{ 0x521A , 0xB8D5},
{ 0x94A2 , 0xB8D6},
{ 0x7F38 , 0xB8D7},
{ 0x809B , 0xB8D8},
{ 0x7EB2 , 0xB8D9},
{ 0x5C97 , 0xB8DA},
{ 0x6E2F , 0xB8DB},
{ 0x6760 , 0xB8DC},
{ 0x7BD9 , 0xB8DD},
{ 0x768B , 0xB8DE},
{ 0x9AD8 , 0xB8DF},
{ 0x818F , 0xB8E0},
{ 0x7F94 , 0xB8E1},
{ 0x7CD5 , 0xB8E2},
{ 0x641E , 0xB8E3},
{ 0x9550 , 0xB8E4},
{ 0x7A3F , 0xB8E5},
{ 0x544A , 0xB8E6},
{ 0x54E5 , 0xB8E7},
{ 0x6B4C , 0xB8E8},
{ 0x6401 , 0xB8E9},
{ 0x6208 , 0xB8EA},
{ 0x9E3D , 0xB8EB},
{ 0x80F3 , 0xB8EC},
{ 0x7599 , 0xB8ED},
{ 0x5272 , 0xB8EE},
{ 0x9769 , 0xB8EF},
{ 0x845B , 0xB8F0},
{ 0x683C , 0xB8F1},
{ 0x86E4 , 0xB8F2},
{ 0x9601 , 0xB8F3},
{ 0x9694 , 0xB8F4},
{ 0x94EC , 0xB8F5},
{ 0x4E2A , 0xB8F6},
{ 0x5404 , 0xB8F7},
{ 0x7ED9 , 0xB8F8},
{ 0x6839 , 0xB8F9},
{ 0x8DDF , 0xB8FA},
{ 0x8015 , 0xB8FB},
{ 0x66F4 , 0xB8FC},
{ 0x5E9A , 0xB8FD},
{ 0x7FB9 , 0xB8FE},
{ 0x7B2F , 0xB940},
{ 0x7B30 , 0xB941},
{ 0x7B32 , 0xB942},
{ 0x7B34 , 0xB943},
{ 0x7B35 , 0xB944},
{ 0x7B36 , 0xB945},
{ 0x7B37 , 0xB946},
{ 0x7B39 , 0xB947},
{ 0x7B3B , 0xB948},
{ 0x7B3D , 0xB949},
{ 0x7B3F , 0xB94A},
{ 0x7B40 , 0xB94B},
{ 0x7B41 , 0xB94C},
{ 0x7B42 , 0xB94D},
{ 0x7B43 , 0xB94E},
{ 0x7B44 , 0xB94F},
{ 0x7B46 , 0xB950},
{ 0x7B48 , 0xB951},
{ 0x7B4A , 0xB952},
{ 0x7B4D , 0xB953},
{ 0x7B4E , 0xB954},
{ 0x7B53 , 0xB955},
{ 0x7B55 , 0xB956},
{ 0x7B57 , 0xB957},
{ 0x7B59 , 0xB958},
{ 0x7B5C , 0xB959},
{ 0x7B5E , 0xB95A},
{ 0x7B5F , 0xB95B},
{ 0x7B61 , 0xB95C},
{ 0x7B63 , 0xB95D},
{ 0x7B64 , 0xB95E},
{ 0x7B65 , 0xB95F},
{ 0x7B66 , 0xB960},
{ 0x7B67 , 0xB961},
{ 0x7B68 , 0xB962},
{ 0x7B69 , 0xB963},
{ 0x7B6A , 0xB964},
{ 0x7B6B , 0xB965},
{ 0x7B6C , 0xB966},
{ 0x7B6D , 0xB967},
{ 0x7B6F , 0xB968},
{ 0x7B70 , 0xB969},
{ 0x7B73 , 0xB96A},
{ 0x7B74 , 0xB96B},
{ 0x7B76 , 0xB96C},
{ 0x7B78 , 0xB96D},
{ 0x7B7A , 0xB96E},
{ 0x7B7C , 0xB96F},
{ 0x7B7D , 0xB970},
{ 0x7B7F , 0xB971},
{ 0x7B81 , 0xB972},
{ 0x7B82 , 0xB973},
{ 0x7B83 , 0xB974},
{ 0x7B84 , 0xB975},
{ 0x7B86 , 0xB976},
{ 0x7B87 , 0xB977},
{ 0x7B88 , 0xB978},
{ 0x7B89 , 0xB979},
{ 0x7B8A , 0xB97A},
{ 0x7B8B , 0xB97B},
{ 0x7B8C , 0xB97C},
{ 0x7B8E , 0xB97D},
{ 0x7B8F , 0xB97E},
{ 0x7B91 , 0xB980},
{ 0x7B92 , 0xB981},
{ 0x7B93 , 0xB982},
{ 0x7B96 , 0xB983},
{ 0x7B98 , 0xB984},
{ 0x7B99 , 0xB985},
{ 0x7B9A , 0xB986},
{ 0x7B9B , 0xB987},
{ 0x7B9E , 0xB988},
{ 0x7B9F , 0xB989},
{ 0x7BA0 , 0xB98A},
{ 0x7BA3 , 0xB98B},
{ 0x7BA4 , 0xB98C},
{ 0x7BA5 , 0xB98D},
{ 0x7BAE , 0xB98E},
{ 0x7BAF , 0xB98F},
{ 0x7BB0 , 0xB990},
{ 0x7BB2 , 0xB991},
{ 0x7BB3 , 0xB992},
{ 0x7BB5 , 0xB993},
{ 0x7BB6 , 0xB994},
{ 0x7BB7 , 0xB995},
{ 0x7BB9 , 0xB996},
{ 0x7BBA , 0xB997},
{ 0x7BBB , 0xB998},
{ 0x7BBC , 0xB999},
{ 0x7BBD , 0xB99A},
{ 0x7BBE , 0xB99B},
{ 0x7BBF , 0xB99C},
{ 0x7BC0 , 0xB99D},
{ 0x7BC2 , 0xB99E},
{ 0x7BC3 , 0xB99F},
{ 0x7BC4 , 0xB9A0},
{ 0x57C2 , 0xB9A1},
{ 0x803F , 0xB9A2},
{ 0x6897 , 0xB9A3},
{ 0x5DE5 , 0xB9A4},
{ 0x653B , 0xB9A5},
{ 0x529F , 0xB9A6},
{ 0x606D , 0xB9A7},
{ 0x9F9A , 0xB9A8},
{ 0x4F9B , 0xB9A9},
{ 0x8EAC , 0xB9AA},
{ 0x516C , 0xB9AB},
{ 0x5BAB , 0xB9AC},
{ 0x5F13 , 0xB9AD},
{ 0x5DE9 , 0xB9AE},
{ 0x6C5E , 0xB9AF},
{ 0x62F1 , 0xB9B0},
{ 0x8D21 , 0xB9B1},
{ 0x5171 , 0xB9B2},
{ 0x94A9 , 0xB9B3},
{ 0x52FE , 0xB9B4},
{ 0x6C9F , 0xB9B5},
{ 0x82DF , 0xB9B6},
{ 0x72D7 , 0xB9B7},
{ 0x57A2 , 0xB9B8},
{ 0x6784 , 0xB9B9},
{ 0x8D2D , 0xB9BA},
{ 0x591F , 0xB9BB},
{ 0x8F9C , 0xB9BC},
{ 0x83C7 , 0xB9BD},
{ 0x5495 , 0xB9BE},
{ 0x7B8D , 0xB9BF},
{ 0x4F30 , 0xB9C0},
{ 0x6CBD , 0xB9C1},
{ 0x5B64 , 0xB9C2},
{ 0x59D1 , 0xB9C3},
{ 0x9F13 , 0xB9C4},
{ 0x53E4 , 0xB9C5},
{ 0x86CA , 0xB9C6},
{ 0x9AA8 , 0xB9C7},
{ 0x8C37 , 0xB9C8},
{ 0x80A1 , 0xB9C9},
{ 0x6545 , 0xB9CA},
{ 0x987E , 0xB9CB},
{ 0x56FA , 0xB9CC},
{ 0x96C7 , 0xB9CD},
{ 0x522E , 0xB9CE},
{ 0x74DC , 0xB9CF},
{ 0x5250 , 0xB9D0},
{ 0x5BE1 , 0xB9D1},
{ 0x6302 , 0xB9D2},
{ 0x8902 , 0xB9D3},
{ 0x4E56 , 0xB9D4},
{ 0x62D0 , 0xB9D5},
{ 0x602A , 0xB9D6},
{ 0x68FA , 0xB9D7},
{ 0x5173 , 0xB9D8},
{ 0x5B98 , 0xB9D9},
{ 0x51A0 , 0xB9DA},
{ 0x89C2 , 0xB9DB},
{ 0x7BA1 , 0xB9DC},
{ 0x9986 , 0xB9DD},
{ 0x7F50 , 0xB9DE},
{ 0x60EF , 0xB9DF},
{ 0x704C , 0xB9E0},
{ 0x8D2F , 0xB9E1},
{ 0x5149 , 0xB9E2},
{ 0x5E7F , 0xB9E3},
{ 0x901B , 0xB9E4},
{ 0x7470 , 0xB9E5},
{ 0x89C4 , 0xB9E6},
{ 0x572D , 0xB9E7},
{ 0x7845 , 0xB9E8},
{ 0x5F52 , 0xB9E9},
{ 0x9F9F , 0xB9EA},
{ 0x95FA , 0xB9EB},
{ 0x8F68 , 0xB9EC},
{ 0x9B3C , 0xB9ED},
{ 0x8BE1 , 0xB9EE},
{ 0x7678 , 0xB9EF},
{ 0x6842 , 0xB9F0},
{ 0x67DC , 0xB9F1},
{ 0x8DEA , 0xB9F2},
{ 0x8D35 , 0xB9F3},
{ 0x523D , 0xB9F4},
{ 0x8F8A , 0xB9F5},
{ 0x6EDA , 0xB9F6},
{ 0x68CD , 0xB9F7},
{ 0x9505 , 0xB9F8},
{ 0x90ED , 0xB9F9},
{ 0x56FD , 0xB9FA},
{ 0x679C , 0xB9FB},
{ 0x88F9 , 0xB9FC},
{ 0x8FC7 , 0xB9FD},
{ 0x54C8 , 0xB9FE},
{ 0x7BC5 , 0xBA40},
{ 0x7BC8 , 0xBA41},
{ 0x7BC9 , 0xBA42},
{ 0x7BCA , 0xBA43},
{ 0x7BCB , 0xBA44},
{ 0x7BCD , 0xBA45},
{ 0x7BCE , 0xBA46},
{ 0x7BCF , 0xBA47},
{ 0x7BD0 , 0xBA48},
{ 0x7BD2 , 0xBA49},
{ 0x7BD4 , 0xBA4A},
{ 0x7BD5 , 0xBA4B},
{ 0x7BD6 , 0xBA4C},
{ 0x7BD7 , 0xBA4D},
{ 0x7BD8 , 0xBA4E},
{ 0x7BDB , 0xBA4F},
{ 0x7BDC , 0xBA50},
{ 0x7BDE , 0xBA51},
{ 0x7BDF , 0xBA52},
{ 0x7BE0 , 0xBA53},
{ 0x7BE2 , 0xBA54},
{ 0x7BE3 , 0xBA55},
{ 0x7BE4 , 0xBA56},
{ 0x7BE7 , 0xBA57},
{ 0x7BE8 , 0xBA58},
{ 0x7BE9 , 0xBA59},
{ 0x7BEB , 0xBA5A},
{ 0x7BEC , 0xBA5B},
{ 0x7BED , 0xBA5C},
{ 0x7BEF , 0xBA5D},
{ 0x7BF0 , 0xBA5E},
{ 0x7BF2 , 0xBA5F},
{ 0x7BF3 , 0xBA60},
{ 0x7BF4 , 0xBA61},
{ 0x7BF5 , 0xBA62},
{ 0x7BF6 , 0xBA63},
{ 0x7BF8 , 0xBA64},
{ 0x7BF9 , 0xBA65},
{ 0x7BFA , 0xBA66},
{ 0x7BFB , 0xBA67},
{ 0x7BFD , 0xBA68},
{ 0x7BFF , 0xBA69},
{ 0x7C00 , 0xBA6A},
{ 0x7C01 , 0xBA6B},
{ 0x7C02 , 0xBA6C},
{ 0x7C03 , 0xBA6D},
{ 0x7C04 , 0xBA6E},
{ 0x7C05 , 0xBA6F},
{ 0x7C06 , 0xBA70},
{ 0x7C08 , 0xBA71},
{ 0x7C09 , 0xBA72},
{ 0x7C0A , 0xBA73},
{ 0x7C0D , 0xBA74},
{ 0x7C0E , 0xBA75},
{ 0x7C10 , 0xBA76},
{ 0x7C11 , 0xBA77},
{ 0x7C12 , 0xBA78},
{ 0x7C13 , 0xBA79},
{ 0x7C14 , 0xBA7A},
{ 0x7C15 , 0xBA7B},
{ 0x7C17 , 0xBA7C},
{ 0x7C18 , 0xBA7D},
{ 0x7C19 , 0xBA7E},
{ 0x7C1A , 0xBA80},
{ 0x7C1B , 0xBA81},
{ 0x7C1C , 0xBA82},
{ 0x7C1D , 0xBA83},
{ 0x7C1E , 0xBA84},
{ 0x7C20 , 0xBA85},
{ 0x7C21 , 0xBA86},
{ 0x7C22 , 0xBA87},
{ 0x7C23 , 0xBA88},
{ 0x7C24 , 0xBA89},
{ 0x7C25 , 0xBA8A},
{ 0x7C28 , 0xBA8B},
{ 0x7C29 , 0xBA8C},
{ 0x7C2B , 0xBA8D},
{ 0x7C2C , 0xBA8E},
{ 0x7C2D , 0xBA8F},
{ 0x7C2E , 0xBA90},
{ 0x7C2F , 0xBA91},
{ 0x7C30 , 0xBA92},
{ 0x7C31 , 0xBA93},
{ 0x7C32 , 0xBA94},
{ 0x7C33 , 0xBA95},
{ 0x7C34 , 0xBA96},
{ 0x7C35 , 0xBA97},
{ 0x7C36 , 0xBA98},
{ 0x7C37 , 0xBA99},
{ 0x7C39 , 0xBA9A},
{ 0x7C3A , 0xBA9B},
{ 0x7C3B , 0xBA9C},
{ 0x7C3C , 0xBA9D},
{ 0x7C3D , 0xBA9E},
{ 0x7C3E , 0xBA9F},
{ 0x7C42 , 0xBAA0},
{ 0x9AB8 , 0xBAA1},
{ 0x5B69 , 0xBAA2},
{ 0x6D77 , 0xBAA3},
{ 0x6C26 , 0xBAA4},
{ 0x4EA5 , 0xBAA5},
{ 0x5BB3 , 0xBAA6},
{ 0x9A87 , 0xBAA7},
{ 0x9163 , 0xBAA8},
{ 0x61A8 , 0xBAA9},
{ 0x90AF , 0xBAAA},
{ 0x97E9 , 0xBAAB},
{ 0x542B , 0xBAAC},
{ 0x6DB5 , 0xBAAD},
{ 0x5BD2 , 0xBAAE},
{ 0x51FD , 0xBAAF},
{ 0x558A , 0xBAB0},
{ 0x7F55 , 0xBAB1},
{ 0x7FF0 , 0xBAB2},
{ 0x64BC , 0xBAB3},
{ 0x634D , 0xBAB4},
{ 0x65F1 , 0xBAB5},
{ 0x61BE , 0xBAB6},
{ 0x608D , 0xBAB7},
{ 0x710A , 0xBAB8},
{ 0x6C57 , 0xBAB9},
{ 0x6C49 , 0xBABA},
{ 0x592F , 0xBABB},
{ 0x676D , 0xBABC},
{ 0x822A , 0xBABD},
{ 0x58D5 , 0xBABE},
{ 0x568E , 0xBABF},
{ 0x8C6A , 0xBAC0},
{ 0x6BEB , 0xBAC1},
{ 0x90DD , 0xBAC2},
{ 0x597D , 0xBAC3},
{ 0x8017 , 0xBAC4},
{ 0x53F7 , 0xBAC5},
{ 0x6D69 , 0xBAC6},
{ 0x5475 , 0xBAC7},
{ 0x559D , 0xBAC8},
{ 0x8377 , 0xBAC9},
{ 0x83CF , 0xBACA},
{ 0x6838 , 0xBACB},
{ 0x79BE , 0xBACC},
{ 0x548C , 0xBACD},
{ 0x4F55 , 0xBACE},
{ 0x5408 , 0xBACF},
{ 0x76D2 , 0xBAD0},
{ 0x8C89 , 0xBAD1},
{ 0x9602 , 0xBAD2},
{ 0x6CB3 , 0xBAD3},
{ 0x6DB8 , 0xBAD4},
{ 0x8D6B , 0xBAD5},
{ 0x8910 , 0xBAD6},
{ 0x9E64 , 0xBAD7},
{ 0x8D3A , 0xBAD8},
{ 0x563F , 0xBAD9},
{ 0x9ED1 , 0xBADA},
{ 0x75D5 , 0xBADB},
{ 0x5F88 , 0xBADC},
{ 0x72E0 , 0xBADD},
{ 0x6068 , 0xBADE},
{ 0x54FC , 0xBADF},
{ 0x4EA8 , 0xBAE0},
{ 0x6A2A , 0xBAE1},
{ 0x8861 , 0xBAE2},
{ 0x6052 , 0xBAE3},
{ 0x8F70 , 0xBAE4},
{ 0x54C4 , 0xBAE5},
{ 0x70D8 , 0xBAE6},
{ 0x8679 , 0xBAE7},
{ 0x9E3F , 0xBAE8},
{ 0x6D2A , 0xBAE9},
{ 0x5B8F , 0xBAEA},
{ 0x5F18 , 0xBAEB},
{ 0x7EA2 , 0xBAEC},
{ 0x5589 , 0xBAED},
{ 0x4FAF , 0xBAEE},
{ 0x7334 , 0xBAEF},
{ 0x543C , 0xBAF0},
{ 0x539A , 0xBAF1},
{ 0x5019 , 0xBAF2},
{ 0x540E , 0xBAF3},
{ 0x547C , 0xBAF4},
{ 0x4E4E , 0xBAF5},
{ 0x5FFD , 0xBAF6},
{ 0x745A , 0xBAF7},
{ 0x58F6 , 0xBAF8},
{ 0x846B , 0xBAF9},
{ 0x80E1 , 0xBAFA},
{ 0x8774 , 0xBAFB},
{ 0x72D0 , 0xBAFC},
{ 0x7CCA , 0xBAFD},
{ 0x6E56 , 0xBAFE},
{ 0x7C43 , 0xBB40},
{ 0x7C44 , 0xBB41},
{ 0x7C45 , 0xBB42},
{ 0x7C46 , 0xBB43},
{ 0x7C47 , 0xBB44},
{ 0x7C48 , 0xBB45},
{ 0x7C49 , 0xBB46},
{ 0x7C4A , 0xBB47},
{ 0x7C4B , 0xBB48},
{ 0x7C4C , 0xBB49},
{ 0x7C4E , 0xBB4A},
{ 0x7C4F , 0xBB4B},
{ 0x7C50 , 0xBB4C},
{ 0x7C51 , 0xBB4D},
{ 0x7C52 , 0xBB4E},
{ 0x7C53 , 0xBB4F},
{ 0x7C54 , 0xBB50},
{ 0x7C55 , 0xBB51},
{ 0x7C56 , 0xBB52},
{ 0x7C57 , 0xBB53},
{ 0x7C58 , 0xBB54},
{ 0x7C59 , 0xBB55},
{ 0x7C5A , 0xBB56},
{ 0x7C5B , 0xBB57},
{ 0x7C5C , 0xBB58},
{ 0x7C5D , 0xBB59},
{ 0x7C5E , 0xBB5A},
{ 0x7C5F , 0xBB5B},
{ 0x7C60 , 0xBB5C},
{ 0x7C61 , 0xBB5D},
{ 0x7C62 , 0xBB5E},
{ 0x7C63 , 0xBB5F},
{ 0x7C64 , 0xBB60},
{ 0x7C65 , 0xBB61},
{ 0x7C66 , 0xBB62},
{ 0x7C67 , 0xBB63},
{ 0x7C68 , 0xBB64},
{ 0x7C69 , 0xBB65},
{ 0x7C6A , 0xBB66},
{ 0x7C6B , 0xBB67},
{ 0x7C6C , 0xBB68},
{ 0x7C6D , 0xBB69},
{ 0x7C6E , 0xBB6A},
{ 0x7C6F , 0xBB6B},
{ 0x7C70 , 0xBB6C},
{ 0x7C71 , 0xBB6D},
{ 0x7C72 , 0xBB6E},
{ 0x7C75 , 0xBB6F},
{ 0x7C76 , 0xBB70},
{ 0x7C77 , 0xBB71},
{ 0x7C78 , 0xBB72},
{ 0x7C79 , 0xBB73},
{ 0x7C7A , 0xBB74},
{ 0x7C7E , 0xBB75},
{ 0x7C7F , 0xBB76},
{ 0x7C80 , 0xBB77},
{ 0x7C81 , 0xBB78},
{ 0x7C82 , 0xBB79},
{ 0x7C83 , 0xBB7A},
{ 0x7C84 , 0xBB7B},
{ 0x7C85 , 0xBB7C},
{ 0x7C86 , 0xBB7D},
{ 0x7C87 , 0xBB7E},
{ 0x7C88 , 0xBB80},
{ 0x7C8A , 0xBB81},
{ 0x7C8B , 0xBB82},
{ 0x7C8C , 0xBB83},
{ 0x7C8D , 0xBB84},
{ 0x7C8E , 0xBB85},
{ 0x7C8F , 0xBB86},
{ 0x7C90 , 0xBB87},
{ 0x7C93 , 0xBB88},
{ 0x7C94 , 0xBB89},
{ 0x7C96 , 0xBB8A},
{ 0x7C99 , 0xBB8B},
{ 0x7C9A , 0xBB8C},
{ 0x7C9B , 0xBB8D},
{ 0x7CA0 , 0xBB8E},
{ 0x7CA1 , 0xBB8F},
{ 0x7CA3 , 0xBB90},
{ 0x7CA6 , 0xBB91},
{ 0x7CA7 , 0xBB92},
{ 0x7CA8 , 0xBB93},
{ 0x7CA9 , 0xBB94},
{ 0x7CAB , 0xBB95},
{ 0x7CAC , 0xBB96},
{ 0x7CAD , 0xBB97},
{ 0x7CAF , 0xBB98},
{ 0x7CB0 , 0xBB99},
{ 0x7CB4 , 0xBB9A},
{ 0x7CB5 , 0xBB9B},
{ 0x7CB6 , 0xBB9C},
{ 0x7CB7 , 0xBB9D},
{ 0x7CB8 , 0xBB9E},
{ 0x7CBA , 0xBB9F},
{ 0x7CBB , 0xBBA0},
{ 0x5F27 , 0xBBA1},
{ 0x864E , 0xBBA2},
{ 0x552C , 0xBBA3},
{ 0x62A4 , 0xBBA4},
{ 0x4E92 , 0xBBA5},
{ 0x6CAA , 0xBBA6},
{ 0x6237 , 0xBBA7},
{ 0x82B1 , 0xBBA8},
{ 0x54D7 , 0xBBA9},
{ 0x534E , 0xBBAA},
{ 0x733E , 0xBBAB},
{ 0x6ED1 , 0xBBAC},
{ 0x753B , 0xBBAD},
{ 0x5212 , 0xBBAE},
{ 0x5316 , 0xBBAF},
{ 0x8BDD , 0xBBB0},
{ 0x69D0 , 0xBBB1},
{ 0x5F8A , 0xBBB2},
{ 0x6000 , 0xBBB3},
{ 0x6DEE , 0xBBB4},
{ 0x574F , 0xBBB5},
{ 0x6B22 , 0xBBB6},
{ 0x73AF , 0xBBB7},
{ 0x6853 , 0xBBB8},
{ 0x8FD8 , 0xBBB9},
{ 0x7F13 , 0xBBBA},
{ 0x6362 , 0xBBBB},
{ 0x60A3 , 0xBBBC},
{ 0x5524 , 0xBBBD},
{ 0x75EA , 0xBBBE},
{ 0x8C62 , 0xBBBF},
{ 0x7115 , 0xBBC0},
{ 0x6DA3 , 0xBBC1},
{ 0x5BA6 , 0xBBC2},
{ 0x5E7B , 0xBBC3},
{ 0x8352 , 0xBBC4},
{ 0x614C , 0xBBC5},
{ 0x9EC4 , 0xBBC6},
{ 0x78FA , 0xBBC7},
{ 0x8757 , 0xBBC8},
{ 0x7C27 , 0xBBC9},
{ 0x7687 , 0xBBCA},
{ 0x51F0 , 0xBBCB},
{ 0x60F6 , 0xBBCC},
{ 0x714C , 0xBBCD},
{ 0x6643 , 0xBBCE},
{ 0x5E4C , 0xBBCF},
{ 0x604D , 0xBBD0},
{ 0x8C0E , 0xBBD1},
{ 0x7070 , 0xBBD2},
{ 0x6325 , 0xBBD3},
{ 0x8F89 , 0xBBD4},
{ 0x5FBD , 0xBBD5},
{ 0x6062 , 0xBBD6},
{ 0x86D4 , 0xBBD7},
{ 0x56DE , 0xBBD8},
{ 0x6BC1 , 0xBBD9},
{ 0x6094 , 0xBBDA},
{ 0x6167 , 0xBBDB},
{ 0x5349 , 0xBBDC},
{ 0x60E0 , 0xBBDD},
{ 0x6666 , 0xBBDE},
{ 0x8D3F , 0xBBDF},
{ 0x79FD , 0xBBE0},
{ 0x4F1A , 0xBBE1},
{ 0x70E9 , 0xBBE2},
{ 0x6C47 , 0xBBE3},
{ 0x8BB3 , 0xBBE4},
{ 0x8BF2 , 0xBBE5},
{ 0x7ED8 , 0xBBE6},
{ 0x8364 , 0xBBE7},
{ 0x660F , 0xBBE8},
{ 0x5A5A , 0xBBE9},
{ 0x9B42 , 0xBBEA},
{ 0x6D51 , 0xBBEB},
{ 0x6DF7 , 0xBBEC},
{ 0x8C41 , 0xBBED},
{ 0x6D3B , 0xBBEE},
{ 0x4F19 , 0xBBEF},
{ 0x706B , 0xBBF0},
{ 0x83B7 , 0xBBF1},
{ 0x6216 , 0xBBF2},
{ 0x60D1 , 0xBBF3},
{ 0x970D , 0xBBF4},
{ 0x8D27 , 0xBBF5},
{ 0x7978 , 0xBBF6},
{ 0x51FB , 0xBBF7},
{ 0x573E , 0xBBF8},
{ 0x57FA , 0xBBF9},
{ 0x673A , 0xBBFA},
{ 0x7578 , 0xBBFB},
{ 0x7A3D , 0xBBFC},
{ 0x79EF , 0xBBFD},
{ 0x7B95 , 0xBBFE},
{ 0x7CBF , 0xBC40},
{ 0x7CC0 , 0xBC41},
{ 0x7CC2 , 0xBC42},
{ 0x7CC3 , 0xBC43},
{ 0x7CC4 , 0xBC44},
{ 0x7CC6 , 0xBC45},
{ 0x7CC9 , 0xBC46},
{ 0x7CCB , 0xBC47},
{ 0x7CCE , 0xBC48},
{ 0x7CCF , 0xBC49},
{ 0x7CD0 , 0xBC4A},
{ 0x7CD1 , 0xBC4B},
{ 0x7CD2 , 0xBC4C},
{ 0x7CD3 , 0xBC4D},
{ 0x7CD4 , 0xBC4E},
{ 0x7CD8 , 0xBC4F},
{ 0x7CDA , 0xBC50},
{ 0x7CDB , 0xBC51},
{ 0x7CDD , 0xBC52},
{ 0x7CDE , 0xBC53},
{ 0x7CE1 , 0xBC54},
{ 0x7CE2 , 0xBC55},
{ 0x7CE3 , 0xBC56},
{ 0x7CE4 , 0xBC57},
{ 0x7CE5 , 0xBC58},
{ 0x7CE6 , 0xBC59},
{ 0x7CE7 , 0xBC5A},
{ 0x7CE9 , 0xBC5B},
{ 0x7CEA , 0xBC5C},
{ 0x7CEB , 0xBC5D},
{ 0x7CEC , 0xBC5E},
{ 0x7CED , 0xBC5F},
{ 0x7CEE , 0xBC60},
{ 0x7CF0 , 0xBC61},
{ 0x7CF1 , 0xBC62},
{ 0x7CF2 , 0xBC63},
{ 0x7CF3 , 0xBC64},
{ 0x7CF4 , 0xBC65},
{ 0x7CF5 , 0xBC66},
{ 0x7CF6 , 0xBC67},
{ 0x7CF7 , 0xBC68},
{ 0x7CF9 , 0xBC69},
{ 0x7CFA , 0xBC6A},
{ 0x7CFC , 0xBC6B},
{ 0x7CFD , 0xBC6C},
{ 0x7CFE , 0xBC6D},
{ 0x7CFF , 0xBC6E},
{ 0x7D00 , 0xBC6F},
{ 0x7D01 , 0xBC70},
{ 0x7D02 , 0xBC71},
{ 0x7D03 , 0xBC72},
{ 0x7D04 , 0xBC73},
{ 0x7D05 , 0xBC74},
{ 0x7D06 , 0xBC75},
{ 0x7D07 , 0xBC76},
{ 0x7D08 , 0xBC77},
{ 0x7D09 , 0xBC78},
{ 0x7D0B , 0xBC79},
{ 0x7D0C , 0xBC7A},
{ 0x7D0D , 0xBC7B},
{ 0x7D0E , 0xBC7C},
{ 0x7D0F , 0xBC7D},
{ 0x7D10 , 0xBC7E},
{ 0x7D11 , 0xBC80},
{ 0x7D12 , 0xBC81},
{ 0x7D13 , 0xBC82},
{ 0x7D14 , 0xBC83},
{ 0x7D15 , 0xBC84},
{ 0x7D16 , 0xBC85},
{ 0x7D17 , 0xBC86},
{ 0x7D18 , 0xBC87},
{ 0x7D19 , 0xBC88},
{ 0x7D1A , 0xBC89},
{ 0x7D1B , 0xBC8A},
{ 0x7D1C , 0xBC8B},
{ 0x7D1D , 0xBC8C},
{ 0x7D1E , 0xBC8D},
{ 0x7D1F , 0xBC8E},
{ 0x7D21 , 0xBC8F},
{ 0x7D23 , 0xBC90},
{ 0x7D24 , 0xBC91},
{ 0x7D25 , 0xBC92},
{ 0x7D26 , 0xBC93},
{ 0x7D28 , 0xBC94},
{ 0x7D29 , 0xBC95},
{ 0x7D2A , 0xBC96},
{ 0x7D2C , 0xBC97},
{ 0x7D2D , 0xBC98},
{ 0x7D2E , 0xBC99},
{ 0x7D30 , 0xBC9A},
{ 0x7D31 , 0xBC9B},
{ 0x7D32 , 0xBC9C},
{ 0x7D33 , 0xBC9D},
{ 0x7D34 , 0xBC9E},
{ 0x7D35 , 0xBC9F},
{ 0x7D36 , 0xBCA0},
{ 0x808C , 0xBCA1},
{ 0x9965 , 0xBCA2},
{ 0x8FF9 , 0xBCA3},
{ 0x6FC0 , 0xBCA4},
{ 0x8BA5 , 0xBCA5},
{ 0x9E21 , 0xBCA6},
{ 0x59EC , 0xBCA7},
{ 0x7EE9 , 0xBCA8},
{ 0x7F09 , 0xBCA9},
{ 0x5409 , 0xBCAA},
{ 0x6781 , 0xBCAB},
{ 0x68D8 , 0xBCAC},
{ 0x8F91 , 0xBCAD},
{ 0x7C4D , 0xBCAE},
{ 0x96C6 , 0xBCAF},
{ 0x53CA , 0xBCB0},
{ 0x6025 , 0xBCB1},
{ 0x75BE , 0xBCB2},
{ 0x6C72 , 0xBCB3},
{ 0x5373 , 0xBCB4},
{ 0x5AC9 , 0xBCB5},
{ 0x7EA7 , 0xBCB6},
{ 0x6324 , 0xBCB7},
{ 0x51E0 , 0xBCB8},
{ 0x810A , 0xBCB9},
{ 0x5DF1 , 0xBCBA},
{ 0x84DF , 0xBCBB},
{ 0x6280 , 0xBCBC},
{ 0x5180 , 0xBCBD},
{ 0x5B63 , 0xBCBE},
{ 0x4F0E , 0xBCBF},
{ 0x796D , 0xBCC0},
{ 0x5242 , 0xBCC1},
{ 0x60B8 , 0xBCC2},
{ 0x6D4E , 0xBCC3},
{ 0x5BC4 , 0xBCC4},
{ 0x5BC2 , 0xBCC5},
{ 0x8BA1 , 0xBCC6},
{ 0x8BB0 , 0xBCC7},
{ 0x65E2 , 0xBCC8},
{ 0x5FCC , 0xBCC9},
{ 0x9645 , 0xBCCA},
{ 0x5993 , 0xBCCB},
{ 0x7EE7 , 0xBCCC},
{ 0x7EAA , 0xBCCD},
{ 0x5609 , 0xBCCE},
{ 0x67B7 , 0xBCCF},
{ 0x5939 , 0xBCD0},
{ 0x4F73 , 0xBCD1},
{ 0x5BB6 , 0xBCD2},
{ 0x52A0 , 0xBCD3},
{ 0x835A , 0xBCD4},
{ 0x988A , 0xBCD5},
{ 0x8D3E , 0xBCD6},
{ 0x7532 , 0xBCD7},
{ 0x94BE , 0xBCD8},
{ 0x5047 , 0xBCD9},
{ 0x7A3C , 0xBCDA},
{ 0x4EF7 , 0xBCDB},
{ 0x67B6 , 0xBCDC},
{ 0x9A7E , 0xBCDD},
{ 0x5AC1 , 0xBCDE},
{ 0x6B7C , 0xBCDF},
{ 0x76D1 , 0xBCE0},
{ 0x575A , 0xBCE1},
{ 0x5C16 , 0xBCE2},
{ 0x7B3A , 0xBCE3},
{ 0x95F4 , 0xBCE4},
{ 0x714E , 0xBCE5},
{ 0x517C , 0xBCE6},
{ 0x80A9 , 0xBCE7},
{ 0x8270 , 0xBCE8},
{ 0x5978 , 0xBCE9},
{ 0x7F04 , 0xBCEA},
{ 0x8327 , 0xBCEB},
{ 0x68C0 , 0xBCEC},
{ 0x67EC , 0xBCED},
{ 0x78B1 , 0xBCEE},
{ 0x7877 , 0xBCEF},
{ 0x62E3 , 0xBCF0},
{ 0x6361 , 0xBCF1},
{ 0x7B80 , 0xBCF2},
{ 0x4FED , 0xBCF3},
{ 0x526A , 0xBCF4},
{ 0x51CF , 0xBCF5},
{ 0x8350 , 0xBCF6},
{ 0x69DB , 0xBCF7},
{ 0x9274 , 0xBCF8},
{ 0x8DF5 , 0xBCF9},
{ 0x8D31 , 0xBCFA},
{ 0x89C1 , 0xBCFB},
{ 0x952E , 0xBCFC},
{ 0x7BAD , 0xBCFD},
{ 0x4EF6 , 0xBCFE},
{ 0x7D37 , 0xBD40},
{ 0x7D38 , 0xBD41},
{ 0x7D39 , 0xBD42},
{ 0x7D3A , 0xBD43},
{ 0x7D3B , 0xBD44},
{ 0x7D3C , 0xBD45},
{ 0x7D3D , 0xBD46},
{ 0x7D3E , 0xBD47},
{ 0x7D3F , 0xBD48},
{ 0x7D40 , 0xBD49},
{ 0x7D41 , 0xBD4A},
{ 0x7D42 , 0xBD4B},
{ 0x7D43 , 0xBD4C},
{ 0x7D44 , 0xBD4D},
{ 0x7D45 , 0xBD4E},
{ 0x7D46 , 0xBD4F},
{ 0x7D47 , 0xBD50},
{ 0x7D48 , 0xBD51},
{ 0x7D49 , 0xBD52},
{ 0x7D4A , 0xBD53},
{ 0x7D4B , 0xBD54},
{ 0x7D4C , 0xBD55},
{ 0x7D4D , 0xBD56},
{ 0x7D4E , 0xBD57},
{ 0x7D4F , 0xBD58},
{ 0x7D50 , 0xBD59},
{ 0x7D51 , 0xBD5A},
{ 0x7D52 , 0xBD5B},
{ 0x7D53 , 0xBD5C},
{ 0x7D54 , 0xBD5D},
{ 0x7D55 , 0xBD5E},
{ 0x7D56 , 0xBD5F},
{ 0x7D57 , 0xBD60},
{ 0x7D58 , 0xBD61},
{ 0x7D59 , 0xBD62},
{ 0x7D5A , 0xBD63},
{ 0x7D5B , 0xBD64},
{ 0x7D5C , 0xBD65},
{ 0x7D5D , 0xBD66},
{ 0x7D5E , 0xBD67},
{ 0x7D5F , 0xBD68},
{ 0x7D60 , 0xBD69},
{ 0x7D61 , 0xBD6A},
{ 0x7D62 , 0xBD6B},
{ 0x7D63 , 0xBD6C},
{ 0x7D64 , 0xBD6D},
{ 0x7D65 , 0xBD6E},
{ 0x7D66 , 0xBD6F},
{ 0x7D67 , 0xBD70},
{ 0x7D68 , 0xBD71},
{ 0x7D69 , 0xBD72},
{ 0x7D6A , 0xBD73},
{ 0x7D6B , 0xBD74},
{ 0x7D6C , 0xBD75},
{ 0x7D6D , 0xBD76},
{ 0x7D6F , 0xBD77},
{ 0x7D70 , 0xBD78},
{ 0x7D71 , 0xBD79},
{ 0x7D72 , 0xBD7A},
{ 0x7D73 , 0xBD7B},
{ 0x7D74 , 0xBD7C},
{ 0x7D75 , 0xBD7D},
{ 0x7D76 , 0xBD7E},
{ 0x7D78 , 0xBD80},
{ 0x7D79 , 0xBD81},
{ 0x7D7A , 0xBD82},
{ 0x7D7B , 0xBD83},
{ 0x7D7C , 0xBD84},
{ 0x7D7D , 0xBD85},
{ 0x7D7E , 0xBD86},
{ 0x7D7F , 0xBD87},
{ 0x7D80 , 0xBD88},
{ 0x7D81 , 0xBD89},
{ 0x7D82 , 0xBD8A},
{ 0x7D83 , 0xBD8B},
{ 0x7D84 , 0xBD8C},
{ 0x7D85 , 0xBD8D},
{ 0x7D86 , 0xBD8E},
{ 0x7D87 , 0xBD8F},
{ 0x7D88 , 0xBD90},
{ 0x7D89 , 0xBD91},
{ 0x7D8A , 0xBD92},
{ 0x7D8B , 0xBD93},
{ 0x7D8C , 0xBD94},
{ 0x7D8D , 0xBD95},
{ 0x7D8E , 0xBD96},
{ 0x7D8F , 0xBD97},
{ 0x7D90 , 0xBD98},
{ 0x7D91 , 0xBD99},
{ 0x7D92 , 0xBD9A},
{ 0x7D93 , 0xBD9B},
{ 0x7D94 , 0xBD9C},
{ 0x7D95 , 0xBD9D},
{ 0x7D96 , 0xBD9E},
{ 0x7D97 , 0xBD9F},
{ 0x7D98 , 0xBDA0},
{ 0x5065 , 0xBDA1},
{ 0x8230 , 0xBDA2},
{ 0x5251 , 0xBDA3},
{ 0x996F , 0xBDA4},
{ 0x6E10 , 0xBDA5},
{ 0x6E85 , 0xBDA6},
{ 0x6DA7 , 0xBDA7},
{ 0x5EFA , 0xBDA8},
{ 0x50F5 , 0xBDA9},
{ 0x59DC , 0xBDAA},
{ 0x5C06 , 0xBDAB},
{ 0x6D46 , 0xBDAC},
{ 0x6C5F , 0xBDAD},
{ 0x7586 , 0xBDAE},
{ 0x848B , 0xBDAF},
{ 0x6868 , 0xBDB0},
{ 0x5956 , 0xBDB1},
{ 0x8BB2 , 0xBDB2},
{ 0x5320 , 0xBDB3},
{ 0x9171 , 0xBDB4},
{ 0x964D , 0xBDB5},
{ 0x8549 , 0xBDB6},
{ 0x6912 , 0xBDB7},
{ 0x7901 , 0xBDB8},
{ 0x7126 , 0xBDB9},
{ 0x80F6 , 0xBDBA},
{ 0x4EA4 , 0xBDBB},
{ 0x90CA , 0xBDBC},
{ 0x6D47 , 0xBDBD},
{ 0x9A84 , 0xBDBE},
{ 0x5A07 , 0xBDBF},
{ 0x56BC , 0xBDC0},
{ 0x6405 , 0xBDC1},
{ 0x94F0 , 0xBDC2},
{ 0x77EB , 0xBDC3},
{ 0x4FA5 , 0xBDC4},
{ 0x811A , 0xBDC5},
{ 0x72E1 , 0xBDC6},
{ 0x89D2 , 0xBDC7},
{ 0x997A , 0xBDC8},
{ 0x7F34 , 0xBDC9},
{ 0x7EDE , 0xBDCA},
{ 0x527F , 0xBDCB},
{ 0x6559 , 0xBDCC},
{ 0x9175 , 0xBDCD},
{ 0x8F7F , 0xBDCE},
{ 0x8F83 , 0xBDCF},
{ 0x53EB , 0xBDD0},
{ 0x7A96 , 0xBDD1},
{ 0x63ED , 0xBDD2},
{ 0x63A5 , 0xBDD3},
{ 0x7686 , 0xBDD4},
{ 0x79F8 , 0xBDD5},
{ 0x8857 , 0xBDD6},
{ 0x9636 , 0xBDD7},
{ 0x622A , 0xBDD8},
{ 0x52AB , 0xBDD9},
{ 0x8282 , 0xBDDA},
{ 0x6854 , 0xBDDB},
{ 0x6770 , 0xBDDC},
{ 0x6377 , 0xBDDD},
{ 0x776B , 0xBDDE},
{ 0x7AED , 0xBDDF},
{ 0x6D01 , 0xBDE0},
{ 0x7ED3 , 0xBDE1},
{ 0x89E3 , 0xBDE2},
{ 0x59D0 , 0xBDE3},
{ 0x6212 , 0xBDE4},
{ 0x85C9 , 0xBDE5},
{ 0x82A5 , 0xBDE6},
{ 0x754C , 0xBDE7},
{ 0x501F , 0xBDE8},
{ 0x4ECB , 0xBDE9},
{ 0x75A5 , 0xBDEA},
{ 0x8BEB , 0xBDEB},
{ 0x5C4A , 0xBDEC},
{ 0x5DFE , 0xBDED},
{ 0x7B4B , 0xBDEE},
{ 0x65A4 , 0xBDEF},
{ 0x91D1 , 0xBDF0},
{ 0x4ECA , 0xBDF1},
{ 0x6D25 , 0xBDF2},
{ 0x895F , 0xBDF3},
{ 0x7D27 , 0xBDF4},
{ 0x9526 , 0xBDF5},
{ 0x4EC5 , 0xBDF6},
{ 0x8C28 , 0xBDF7},
{ 0x8FDB , 0xBDF8},
{ 0x9773 , 0xBDF9},
{ 0x664B , 0xBDFA},
{ 0x7981 , 0xBDFB},
{ 0x8FD1 , 0xBDFC},
{ 0x70EC , 0xBDFD},
{ 0x6D78 , 0xBDFE},
{ 0x7D99 , 0xBE40},
{ 0x7D9A , 0xBE41},
{ 0x7D9B , 0xBE42},
{ 0x7D9C , 0xBE43},
{ 0x7D9D , 0xBE44},
{ 0x7D9E , 0xBE45},
{ 0x7D9F , 0xBE46},
{ 0x7DA0 , 0xBE47},
{ 0x7DA1 , 0xBE48},
{ 0x7DA2 , 0xBE49},
{ 0x7DA3 , 0xBE4A},
{ 0x7DA4 , 0xBE4B},
{ 0x7DA5 , 0xBE4C},
{ 0x7DA7 , 0xBE4D},
{ 0x7DA8 , 0xBE4E},
{ 0x7DA9 , 0xBE4F},
{ 0x7DAA , 0xBE50},
{ 0x7DAB , 0xBE51},
{ 0x7DAC , 0xBE52},
{ 0x7DAD , 0xBE53},
{ 0x7DAF , 0xBE54},
{ 0x7DB0 , 0xBE55},
{ 0x7DB1 , 0xBE56},
{ 0x7DB2 , 0xBE57},
{ 0x7DB3 , 0xBE58},
{ 0x7DB4 , 0xBE59},
{ 0x7DB5 , 0xBE5A},
{ 0x7DB6 , 0xBE5B},
{ 0x7DB7 , 0xBE5C},
{ 0x7DB8 , 0xBE5D},
{ 0x7DB9 , 0xBE5E},
{ 0x7DBA , 0xBE5F},
{ 0x7DBB , 0xBE60},
{ 0x7DBC , 0xBE61},
{ 0x7DBD , 0xBE62},
{ 0x7DBE , 0xBE63},
{ 0x7DBF , 0xBE64},
{ 0x7DC0 , 0xBE65},
{ 0x7DC1 , 0xBE66},
{ 0x7DC2 , 0xBE67},
{ 0x7DC3 , 0xBE68},
{ 0x7DC4 , 0xBE69},
{ 0x7DC5 , 0xBE6A},
{ 0x7DC6 , 0xBE6B},
{ 0x7DC7 , 0xBE6C},
{ 0x7DC8 , 0xBE6D},
{ 0x7DC9 , 0xBE6E},
{ 0x7DCA , 0xBE6F},
{ 0x7DCB , 0xBE70},
{ 0x7DCC , 0xBE71},
{ 0x7DCD , 0xBE72},
{ 0x7DCE , 0xBE73},
{ 0x7DCF , 0xBE74},
{ 0x7DD0 , 0xBE75},
{ 0x7DD1 , 0xBE76},
{ 0x7DD2 , 0xBE77},
{ 0x7DD3 , 0xBE78},
{ 0x7DD4 , 0xBE79},
{ 0x7DD5 , 0xBE7A},
{ 0x7DD6 , 0xBE7B},
{ 0x7DD7 , 0xBE7C},
{ 0x7DD8 , 0xBE7D},
{ 0x7DD9 , 0xBE7E},
{ 0x7DDA , 0xBE80},
{ 0x7DDB , 0xBE81},
{ 0x7DDC , 0xBE82},
{ 0x7DDD , 0xBE83},
{ 0x7DDE , 0xBE84},
{ 0x7DDF , 0xBE85},
{ 0x7DE0 , 0xBE86},
{ 0x7DE1 , 0xBE87},
{ 0x7DE2 , 0xBE88},
{ 0x7DE3 , 0xBE89},
{ 0x7DE4 , 0xBE8A},
{ 0x7DE5 , 0xBE8B},
{ 0x7DE6 , 0xBE8C},
{ 0x7DE7 , 0xBE8D},
{ 0x7DE8 , 0xBE8E},
{ 0x7DE9 , 0xBE8F},
{ 0x7DEA , 0xBE90},
{ 0x7DEB , 0xBE91},
{ 0x7DEC , 0xBE92},
{ 0x7DED , 0xBE93},
{ 0x7DEE , 0xBE94},
{ 0x7DEF , 0xBE95},
{ 0x7DF0 , 0xBE96},
{ 0x7DF1 , 0xBE97},
{ 0x7DF2 , 0xBE98},
{ 0x7DF3 , 0xBE99},
{ 0x7DF4 , 0xBE9A},
{ 0x7DF5 , 0xBE9B},
{ 0x7DF6 , 0xBE9C},
{ 0x7DF7 , 0xBE9D},
{ 0x7DF8 , 0xBE9E},
{ 0x7DF9 , 0xBE9F},
{ 0x7DFA , 0xBEA0},
{ 0x5C3D , 0xBEA1},
{ 0x52B2 , 0xBEA2},
{ 0x8346 , 0xBEA3},
{ 0x5162 , 0xBEA4},
{ 0x830E , 0xBEA5},
{ 0x775B , 0xBEA6},
{ 0x6676 , 0xBEA7},
{ 0x9CB8 , 0xBEA8},
{ 0x4EAC , 0xBEA9},
{ 0x60CA , 0xBEAA},
{ 0x7CBE , 0xBEAB},
{ 0x7CB3 , 0xBEAC},
{ 0x7ECF , 0xBEAD},
{ 0x4E95 , 0xBEAE},
{ 0x8B66 , 0xBEAF},
{ 0x666F , 0xBEB0},
{ 0x9888 , 0xBEB1},
{ 0x9759 , 0xBEB2},
{ 0x5883 , 0xBEB3},
{ 0x656C , 0xBEB4},
{ 0x955C , 0xBEB5},
{ 0x5F84 , 0xBEB6},
{ 0x75C9 , 0xBEB7},
{ 0x9756 , 0xBEB8},
{ 0x7ADF , 0xBEB9},
{ 0x7ADE , 0xBEBA},
{ 0x51C0 , 0xBEBB},
{ 0x70AF , 0xBEBC},
{ 0x7A98 , 0xBEBD},
{ 0x63EA , 0xBEBE},
{ 0x7A76 , 0xBEBF},
{ 0x7EA0 , 0xBEC0},
{ 0x7396 , 0xBEC1},
{ 0x97ED , 0xBEC2},
{ 0x4E45 , 0xBEC3},
{ 0x7078 , 0xBEC4},
{ 0x4E5D , 0xBEC5},
{ 0x9152 , 0xBEC6},
{ 0x53A9 , 0xBEC7},
{ 0x6551 , 0xBEC8},
{ 0x65E7 , 0xBEC9},
{ 0x81FC , 0xBECA},
{ 0x8205 , 0xBECB},
{ 0x548E , 0xBECC},
{ 0x5C31 , 0xBECD},
{ 0x759A , 0xBECE},
{ 0x97A0 , 0xBECF},
{ 0x62D8 , 0xBED0},
{ 0x72D9 , 0xBED1},
{ 0x75BD , 0xBED2},
{ 0x5C45 , 0xBED3},
{ 0x9A79 , 0xBED4},
{ 0x83CA , 0xBED5},
{ 0x5C40 , 0xBED6},
{ 0x5480 , 0xBED7},
{ 0x77E9 , 0xBED8},
{ 0x4E3E , 0xBED9},
{ 0x6CAE , 0xBEDA},
{ 0x805A , 0xBEDB},
{ 0x62D2 , 0xBEDC},
{ 0x636E , 0xBEDD},
{ 0x5DE8 , 0xBEDE},
{ 0x5177 , 0xBEDF},
{ 0x8DDD , 0xBEE0},
{ 0x8E1E , 0xBEE1},
{ 0x952F , 0xBEE2},
{ 0x4FF1 , 0xBEE3},
{ 0x53E5 , 0xBEE4},
{ 0x60E7 , 0xBEE5},
{ 0x70AC , 0xBEE6},
{ 0x5267 , 0xBEE7},
{ 0x6350 , 0xBEE8},
{ 0x9E43 , 0xBEE9},
{ 0x5A1F , 0xBEEA},
{ 0x5026 , 0xBEEB},
{ 0x7737 , 0xBEEC},
{ 0x5377 , 0xBEED},
{ 0x7EE2 , 0xBEEE},
{ 0x6485 , 0xBEEF},
{ 0x652B , 0xBEF0},
{ 0x6289 , 0xBEF1},
{ 0x6398 , 0xBEF2},
{ 0x5014 , 0xBEF3},
{ 0x7235 , 0xBEF4},
{ 0x89C9 , 0xBEF5},
{ 0x51B3 , 0xBEF6},
{ 0x8BC0 , 0xBEF7},
{ 0x7EDD , 0xBEF8},
{ 0x5747 , 0xBEF9},
{ 0x83CC , 0xBEFA},
{ 0x94A7 , 0xBEFB},
{ 0x519B , 0xBEFC},
{ 0x541B , 0xBEFD},
{ 0x5CFB , 0xBEFE},
{ 0x7DFB , 0xBF40},
{ 0x7DFC , 0xBF41},
{ 0x7DFD , 0xBF42},
{ 0x7DFE , 0xBF43},
{ 0x7DFF , 0xBF44},
{ 0x7E00 , 0xBF45},
{ 0x7E01 , 0xBF46},
{ 0x7E02 , 0xBF47},
{ 0x7E03 , 0xBF48},
{ 0x7E04 , 0xBF49},
{ 0x7E05 , 0xBF4A},
{ 0x7E06 , 0xBF4B},
{ 0x7E07 , 0xBF4C},
{ 0x7E08 , 0xBF4D},
{ 0x7E09 , 0xBF4E},
{ 0x7E0A , 0xBF4F},
{ 0x7E0B , 0xBF50},
{ 0x7E0C , 0xBF51},
{ 0x7E0D , 0xBF52},
{ 0x7E0E , 0xBF53},
{ 0x7E0F , 0xBF54},
{ 0x7E10 , 0xBF55},
{ 0x7E11 , 0xBF56},
{ 0x7E12 , 0xBF57},
{ 0x7E13 , 0xBF58},
{ 0x7E14 , 0xBF59},
{ 0x7E15 , 0xBF5A},
{ 0x7E16 , 0xBF5B},
{ 0x7E17 , 0xBF5C},
{ 0x7E18 , 0xBF5D},
{ 0x7E19 , 0xBF5E},
{ 0x7E1A , 0xBF5F},
{ 0x7E1B , 0xBF60},
{ 0x7E1C , 0xBF61},
{ 0x7E1D , 0xBF62},
{ 0x7E1E , 0xBF63},
{ 0x7E1F , 0xBF64},
{ 0x7E20 , 0xBF65},
{ 0x7E21 , 0xBF66},
{ 0x7E22 , 0xBF67},
{ 0x7E23 , 0xBF68},
{ 0x7E24 , 0xBF69},
{ 0x7E25 , 0xBF6A},
{ 0x7E26 , 0xBF6B},
{ 0x7E27 , 0xBF6C},
{ 0x7E28 , 0xBF6D},
{ 0x7E29 , 0xBF6E},
{ 0x7E2A , 0xBF6F},
{ 0x7E2B , 0xBF70},
{ 0x7E2C , 0xBF71},
{ 0x7E2D , 0xBF72},
{ 0x7E2E , 0xBF73},
{ 0x7E2F , 0xBF74},
{ 0x7E30 , 0xBF75},
{ 0x7E31 , 0xBF76},
{ 0x7E32 , 0xBF77},
{ 0x7E33 , 0xBF78},
{ 0x7E34 , 0xBF79},
{ 0x7E35 , 0xBF7A},
{ 0x7E36 , 0xBF7B},
{ 0x7E37 , 0xBF7C},
{ 0x7E38 , 0xBF7D},
{ 0x7E39 , 0xBF7E},
{ 0x7E3A , 0xBF80},
{ 0x7E3C , 0xBF81},
{ 0x7E3D , 0xBF82},
{ 0x7E3E , 0xBF83},
{ 0x7E3F , 0xBF84},
{ 0x7E40 , 0xBF85},
{ 0x7E42 , 0xBF86},
{ 0x7E43 , 0xBF87},
{ 0x7E44 , 0xBF88},
{ 0x7E45 , 0xBF89},
{ 0x7E46 , 0xBF8A},
{ 0x7E48 , 0xBF8B},
{ 0x7E49 , 0xBF8C},
{ 0x7E4A , 0xBF8D},
{ 0x7E4B , 0xBF8E},
{ 0x7E4C , 0xBF8F},
{ 0x7E4D , 0xBF90},
{ 0x7E4E , 0xBF91},
{ 0x7E4F , 0xBF92},
{ 0x7E50 , 0xBF93},
{ 0x7E51 , 0xBF94},
{ 0x7E52 , 0xBF95},
{ 0x7E53 , 0xBF96},
{ 0x7E54 , 0xBF97},
{ 0x7E55 , 0xBF98},
{ 0x7E56 , 0xBF99},
{ 0x7E57 , 0xBF9A},
{ 0x7E58 , 0xBF9B},
{ 0x7E59 , 0xBF9C},
{ 0x7E5A , 0xBF9D},
{ 0x7E5B , 0xBF9E},
{ 0x7E5C , 0xBF9F},
{ 0x7E5D , 0xBFA0},
{ 0x4FCA , 0xBFA1},
{ 0x7AE3 , 0xBFA2},
{ 0x6D5A , 0xBFA3},
{ 0x90E1 , 0xBFA4},
{ 0x9A8F , 0xBFA5},
{ 0x5580 , 0xBFA6},
{ 0x5496 , 0xBFA7},
{ 0x5361 , 0xBFA8},
{ 0x54AF , 0xBFA9},
{ 0x5F00 , 0xBFAA},
{ 0x63E9 , 0xBFAB},
{ 0x6977 , 0xBFAC},
{ 0x51EF , 0xBFAD},
{ 0x6168 , 0xBFAE},
{ 0x520A , 0xBFAF},
{ 0x582A , 0xBFB0},
{ 0x52D8 , 0xBFB1},
{ 0x574E , 0xBFB2},
{ 0x780D , 0xBFB3},
{ 0x770B , 0xBFB4},
{ 0x5EB7 , 0xBFB5},
{ 0x6177 , 0xBFB6},
{ 0x7CE0 , 0xBFB7},
{ 0x625B , 0xBFB8},
{ 0x6297 , 0xBFB9},
{ 0x4EA2 , 0xBFBA},
{ 0x7095 , 0xBFBB},
{ 0x8003 , 0xBFBC},
{ 0x62F7 , 0xBFBD},
{ 0x70E4 , 0xBFBE},
{ 0x9760 , 0xBFBF},
{ 0x5777 , 0xBFC0},
{ 0x82DB , 0xBFC1},
{ 0x67EF , 0xBFC2},
{ 0x68F5 , 0xBFC3},
{ 0x78D5 , 0xBFC4},
{ 0x9897 , 0xBFC5},
{ 0x79D1 , 0xBFC6},
{ 0x58F3 , 0xBFC7},
{ 0x54B3 , 0xBFC8},
{ 0x53EF , 0xBFC9},
{ 0x6E34 , 0xBFCA},
{ 0x514B , 0xBFCB},
{ 0x523B , 0xBFCC},
{ 0x5BA2 , 0xBFCD},
{ 0x8BFE , 0xBFCE},
{ 0x80AF , 0xBFCF},
{ 0x5543 , 0xBFD0},
{ 0x57A6 , 0xBFD1},
{ 0x6073 , 0xBFD2},
{ 0x5751 , 0xBFD3},
{ 0x542D , 0xBFD4},
{ 0x7A7A , 0xBFD5},
{ 0x6050 , 0xBFD6},
{ 0x5B54 , 0xBFD7},
{ 0x63A7 , 0xBFD8},
{ 0x62A0 , 0xBFD9},
{ 0x53E3 , 0xBFDA},
{ 0x6263 , 0xBFDB},
{ 0x5BC7 , 0xBFDC},
{ 0x67AF , 0xBFDD},
{ 0x54ED , 0xBFDE},
{ 0x7A9F , 0xBFDF},
{ 0x82E6 , 0xBFE0},
{ 0x9177 , 0xBFE1},
{ 0x5E93 , 0xBFE2},
{ 0x88E4 , 0xBFE3},
{ 0x5938 , 0xBFE4},
{ 0x57AE , 0xBFE5},
{ 0x630E , 0xBFE6},
{ 0x8DE8 , 0xBFE7},
{ 0x80EF , 0xBFE8},
{ 0x5757 , 0xBFE9},
{ 0x7B77 , 0xBFEA},
{ 0x4FA9 , 0xBFEB},
{ 0x5FEB , 0xBFEC},
{ 0x5BBD , 0xBFED},
{ 0x6B3E , 0xBFEE},
{ 0x5321 , 0xBFEF},
{ 0x7B50 , 0xBFF0},
{ 0x72C2 , 0xBFF1},
{ 0x6846 , 0xBFF2},
{ 0x77FF , 0xBFF3},
{ 0x7736 , 0xBFF4},
{ 0x65F7 , 0xBFF5},
{ 0x51B5 , 0xBFF6},
{ 0x4E8F , 0xBFF7},
{ 0x76D4 , 0xBFF8},
{ 0x5CBF , 0xBFF9},
{ 0x7AA5 , 0xBFFA},
{ 0x8475 , 0xBFFB},
{ 0x594E , 0xBFFC},
{ 0x9B41 , 0xBFFD},
{ 0x5080 , 0xBFFE},
{ 0x7E5E , 0xC040},
{ 0x7E5F , 0xC041},
{ 0x7E60 , 0xC042},
{ 0x7E61 , 0xC043},
{ 0x7E62 , 0xC044},
{ 0x7E63 , 0xC045},
{ 0x7E64 , 0xC046},
{ 0x7E65 , 0xC047},
{ 0x7E66 , 0xC048},
{ 0x7E67 , 0xC049},
{ 0x7E68 , 0xC04A},
{ 0x7E69 , 0xC04B},
{ 0x7E6A , 0xC04C},
{ 0x7E6B , 0xC04D},
{ 0x7E6C , 0xC04E},
{ 0x7E6D , 0xC04F},
{ 0x7E6E , 0xC050},
{ 0x7E6F , 0xC051},
{ 0x7E70 , 0xC052},
{ 0x7E71 , 0xC053},
{ 0x7E72 , 0xC054},
{ 0x7E73 , 0xC055},
{ 0x7E74 , 0xC056},
{ 0x7E75 , 0xC057},
{ 0x7E76 , 0xC058},
{ 0x7E77 , 0xC059},
{ 0x7E78 , 0xC05A},
{ 0x7E79 , 0xC05B},
{ 0x7E7A , 0xC05C},
{ 0x7E7B , 0xC05D},
{ 0x7E7C , 0xC05E},
{ 0x7E7D , 0xC05F},
{ 0x7E7E , 0xC060},
{ 0x7E7F , 0xC061},
{ 0x7E80 , 0xC062},
{ 0x7E81 , 0xC063},
{ 0x7E83 , 0xC064},
{ 0x7E84 , 0xC065},
{ 0x7E85 , 0xC066},
{ 0x7E86 , 0xC067},
{ 0x7E87 , 0xC068},
{ 0x7E88 , 0xC069},
{ 0x7E89 , 0xC06A},
{ 0x7E8A , 0xC06B},
{ 0x7E8B , 0xC06C},
{ 0x7E8C , 0xC06D},
{ 0x7E8D , 0xC06E},
{ 0x7E8E , 0xC06F},
{ 0x7E8F , 0xC070},
{ 0x7E90 , 0xC071},
{ 0x7E91 , 0xC072},
{ 0x7E92 , 0xC073},
{ 0x7E93 , 0xC074},
{ 0x7E94 , 0xC075},
{ 0x7E95 , 0xC076},
{ 0x7E96 , 0xC077},
{ 0x7E97 , 0xC078},
{ 0x7E98 , 0xC079},
{ 0x7E99 , 0xC07A},
{ 0x7E9A , 0xC07B},
{ 0x7E9C , 0xC07C},
{ 0x7E9D , 0xC07D},
{ 0x7E9E , 0xC07E},
{ 0x7EAE , 0xC080},
{ 0x7EB4 , 0xC081},
{ 0x7EBB , 0xC082},
{ 0x7EBC , 0xC083},
{ 0x7ED6 , 0xC084},
{ 0x7EE4 , 0xC085},
{ 0x7EEC , 0xC086},
{ 0x7EF9 , 0xC087},
{ 0x7F0A , 0xC088},
{ 0x7F10 , 0xC089},
{ 0x7F1E , 0xC08A},
{ 0x7F37 , 0xC08B},
{ 0x7F39 , 0xC08C},
{ 0x7F3B , 0xC08D},
{ 0x7F3C , 0xC08E},
{ 0x7F3D , 0xC08F},
{ 0x7F3E , 0xC090},
{ 0x7F3F , 0xC091},
{ 0x7F40 , 0xC092},
{ 0x7F41 , 0xC093},
{ 0x7F43 , 0xC094},
{ 0x7F46 , 0xC095},
{ 0x7F47 , 0xC096},
{ 0x7F48 , 0xC097},
{ 0x7F49 , 0xC098},
{ 0x7F4A , 0xC099},
{ 0x7F4B , 0xC09A},
{ 0x7F4C , 0xC09B},
{ 0x7F4D , 0xC09C},
{ 0x7F4E , 0xC09D},
{ 0x7F4F , 0xC09E},
{ 0x7F52 , 0xC09F},
{ 0x7F53 , 0xC0A0},
{ 0x9988 , 0xC0A1},
{ 0x6127 , 0xC0A2},
{ 0x6E83 , 0xC0A3},
{ 0x5764 , 0xC0A4},
{ 0x6606 , 0xC0A5},
{ 0x6346 , 0xC0A6},
{ 0x56F0 , 0xC0A7},
{ 0x62EC , 0xC0A8},
{ 0x6269 , 0xC0A9},
{ 0x5ED3 , 0xC0AA},
{ 0x9614 , 0xC0AB},
{ 0x5783 , 0xC0AC},
{ 0x62C9 , 0xC0AD},
{ 0x5587 , 0xC0AE},
{ 0x8721 , 0xC0AF},
{ 0x814A , 0xC0B0},
{ 0x8FA3 , 0xC0B1},
{ 0x5566 , 0xC0B2},
{ 0x83B1 , 0xC0B3},
{ 0x6765 , 0xC0B4},
{ 0x8D56 , 0xC0B5},
{ 0x84DD , 0xC0B6},
{ 0x5A6A , 0xC0B7},
{ 0x680F , 0xC0B8},
{ 0x62E6 , 0xC0B9},
{ 0x7BEE , 0xC0BA},
{ 0x9611 , 0xC0BB},
{ 0x5170 , 0xC0BC},
{ 0x6F9C , 0xC0BD},
{ 0x8C30 , 0xC0BE},
{ 0x63FD , 0xC0BF},
{ 0x89C8 , 0xC0C0},
{ 0x61D2 , 0xC0C1},
{ 0x7F06 , 0xC0C2},
{ 0x70C2 , 0xC0C3},
{ 0x6EE5 , 0xC0C4},
{ 0x7405 , 0xC0C5},
{ 0x6994 , 0xC0C6},
{ 0x72FC , 0xC0C7},
{ 0x5ECA , 0xC0C8},
{ 0x90CE , 0xC0C9},
{ 0x6717 , 0xC0CA},
{ 0x6D6A , 0xC0CB},
{ 0x635E , 0xC0CC},
{ 0x52B3 , 0xC0CD},
{ 0x7262 , 0xC0CE},
{ 0x8001 , 0xC0CF},
{ 0x4F6C , 0xC0D0},
{ 0x59E5 , 0xC0D1},
{ 0x916A , 0xC0D2},
{ 0x70D9 , 0xC0D3},
{ 0x6D9D , 0xC0D4},
{ 0x52D2 , 0xC0D5},
{ 0x4E50 , 0xC0D6},
{ 0x96F7 , 0xC0D7},
{ 0x956D , 0xC0D8},
{ 0x857E , 0xC0D9},
{ 0x78CA , 0xC0DA},
{ 0x7D2F , 0xC0DB},
{ 0x5121 , 0xC0DC},
{ 0x5792 , 0xC0DD},
{ 0x64C2 , 0xC0DE},
{ 0x808B , 0xC0DF},
{ 0x7C7B , 0xC0E0},
{ 0x6CEA , 0xC0E1},
{ 0x68F1 , 0xC0E2},
{ 0x695E , 0xC0E3},
{ 0x51B7 , 0xC0E4},
{ 0x5398 , 0xC0E5},
{ 0x68A8 , 0xC0E6},
{ 0x7281 , 0xC0E7},
{ 0x9ECE , 0xC0E8},
{ 0x7BF1 , 0xC0E9},
{ 0x72F8 , 0xC0EA},
{ 0x79BB , 0xC0EB},
{ 0x6F13 , 0xC0EC},
{ 0x7406 , 0xC0ED},
{ 0x674E , 0xC0EE},
{ 0x91CC , 0xC0EF},
{ 0x9CA4 , 0xC0F0},
{ 0x793C , 0xC0F1},
{ 0x8389 , 0xC0F2},
{ 0x8354 , 0xC0F3},
{ 0x540F , 0xC0F4},
{ 0x6817 , 0xC0F5},
{ 0x4E3D , 0xC0F6},
{ 0x5389 , 0xC0F7},
{ 0x52B1 , 0xC0F8},
{ 0x783E , 0xC0F9},
{ 0x5386 , 0xC0FA},
{ 0x5229 , 0xC0FB},
{ 0x5088 , 0xC0FC},
{ 0x4F8B , 0xC0FD},
{ 0x4FD0 , 0xC0FE},
{ 0x7F56 , 0xC140},
{ 0x7F59 , 0xC141},
{ 0x7F5B , 0xC142},
{ 0x7F5C , 0xC143},
{ 0x7F5D , 0xC144},
{ 0x7F5E , 0xC145},
{ 0x7F60 , 0xC146},
{ 0x7F63 , 0xC147},
{ 0x7F64 , 0xC148},
{ 0x7F65 , 0xC149},
{ 0x7F66 , 0xC14A},
{ 0x7F67 , 0xC14B},
{ 0x7F6B , 0xC14C},
{ 0x7F6C , 0xC14D},
{ 0x7F6D , 0xC14E},
{ 0x7F6F , 0xC14F},
{ 0x7F70 , 0xC150},
{ 0x7F73 , 0xC151},
{ 0x7F75 , 0xC152},
{ 0x7F76 , 0xC153},
{ 0x7F77 , 0xC154},
{ 0x7F78 , 0xC155},
{ 0x7F7A , 0xC156},
{ 0x7F7B , 0xC157},
{ 0x7F7C , 0xC158},
{ 0x7F7D , 0xC159},
{ 0x7F7F , 0xC15A},
{ 0x7F80 , 0xC15B},
{ 0x7F82 , 0xC15C},
{ 0x7F83 , 0xC15D},
{ 0x7F84 , 0xC15E},
{ 0x7F85 , 0xC15F},
{ 0x7F86 , 0xC160},
{ 0x7F87 , 0xC161},
{ 0x7F88 , 0xC162},
{ 0x7F89 , 0xC163},
{ 0x7F8B , 0xC164},
{ 0x7F8D , 0xC165},
{ 0x7F8F , 0xC166},
{ 0x7F90 , 0xC167},
{ 0x7F91 , 0xC168},
{ 0x7F92 , 0xC169},
{ 0x7F93 , 0xC16A},
{ 0x7F95 , 0xC16B},
{ 0x7F96 , 0xC16C},
{ 0x7F97 , 0xC16D},
{ 0x7F98 , 0xC16E},
{ 0x7F99 , 0xC16F},
{ 0x7F9B , 0xC170},
{ 0x7F9C , 0xC171},
{ 0x7FA0 , 0xC172},
{ 0x7FA2 , 0xC173},
{ 0x7FA3 , 0xC174},
{ 0x7FA5 , 0xC175},
{ 0x7FA6 , 0xC176},
{ 0x7FA8 , 0xC177},
{ 0x7FA9 , 0xC178},
{ 0x7FAA , 0xC179},
{ 0x7FAB , 0xC17A},
{ 0x7FAC , 0xC17B},
{ 0x7FAD , 0xC17C},
{ 0x7FAE , 0xC17D},
{ 0x7FB1 , 0xC17E},
{ 0x7FB3 , 0xC180},
{ 0x7FB4 , 0xC181},
{ 0x7FB5 , 0xC182},
{ 0x7FB6 , 0xC183},
{ 0x7FB7 , 0xC184},
{ 0x7FBA , 0xC185},
{ 0x7FBB , 0xC186},
{ 0x7FBE , 0xC187},
{ 0x7FC0 , 0xC188},
{ 0x7FC2 , 0xC189},
{ 0x7FC3 , 0xC18A},
{ 0x7FC4 , 0xC18B},
{ 0x7FC6 , 0xC18C},
{ 0x7FC7 , 0xC18D},
{ 0x7FC8 , 0xC18E},
{ 0x7FC9 , 0xC18F},
{ 0x7FCB , 0xC190},
{ 0x7FCD , 0xC191},
{ 0x7FCF , 0xC192},
{ 0x7FD0 , 0xC193},
{ 0x7FD1 , 0xC194},
{ 0x7FD2 , 0xC195},
{ 0x7FD3 , 0xC196},
{ 0x7FD6 , 0xC197},
{ 0x7FD7 , 0xC198},
{ 0x7FD9 , 0xC199},
{ 0x7FDA , 0xC19A},
{ 0x7FDB , 0xC19B},
{ 0x7FDC , 0xC19C},
{ 0x7FDD , 0xC19D},
{ 0x7FDE , 0xC19E},
{ 0x7FE2 , 0xC19F},
{ 0x7FE3 , 0xC1A0},
{ 0x75E2 , 0xC1A1},
{ 0x7ACB , 0xC1A2},
{ 0x7C92 , 0xC1A3},
{ 0x6CA5 , 0xC1A4},
{ 0x96B6 , 0xC1A5},
{ 0x529B , 0xC1A6},
{ 0x7483 , 0xC1A7},
{ 0x54E9 , 0xC1A8},
{ 0x4FE9 , 0xC1A9},
{ 0x8054 , 0xC1AA},
{ 0x83B2 , 0xC1AB},
{ 0x8FDE , 0xC1AC},
{ 0x9570 , 0xC1AD},
{ 0x5EC9 , 0xC1AE},
{ 0x601C , 0xC1AF},
{ 0x6D9F , 0xC1B0},
{ 0x5E18 , 0xC1B1},
{ 0x655B , 0xC1B2},
{ 0x8138 , 0xC1B3},
{ 0x94FE , 0xC1B4},
{ 0x604B , 0xC1B5},
{ 0x70BC , 0xC1B6},
{ 0x7EC3 , 0xC1B7},
{ 0x7CAE , 0xC1B8},
{ 0x51C9 , 0xC1B9},
{ 0x6881 , 0xC1BA},
{ 0x7CB1 , 0xC1BB},
{ 0x826F , 0xC1BC},
{ 0x4E24 , 0xC1BD},
{ 0x8F86 , 0xC1BE},
{ 0x91CF , 0xC1BF},
{ 0x667E , 0xC1C0},
{ 0x4EAE , 0xC1C1},
{ 0x8C05 , 0xC1C2},
{ 0x64A9 , 0xC1C3},
{ 0x804A , 0xC1C4},
{ 0x50DA , 0xC1C5},
{ 0x7597 , 0xC1C6},
{ 0x71CE , 0xC1C7},
{ 0x5BE5 , 0xC1C8},
{ 0x8FBD , 0xC1C9},
{ 0x6F66 , 0xC1CA},
{ 0x4E86 , 0xC1CB},
{ 0x6482 , 0xC1CC},
{ 0x9563 , 0xC1CD},
{ 0x5ED6 , 0xC1CE},
{ 0x6599 , 0xC1CF},
{ 0x5217 , 0xC1D0},
{ 0x88C2 , 0xC1D1},
{ 0x70C8 , 0xC1D2},
{ 0x52A3 , 0xC1D3},
{ 0x730E , 0xC1D4},
{ 0x7433 , 0xC1D5},
{ 0x6797 , 0xC1D6},
{ 0x78F7 , 0xC1D7},
{ 0x9716 , 0xC1D8},
{ 0x4E34 , 0xC1D9},
{ 0x90BB , 0xC1DA},
{ 0x9CDE , 0xC1DB},
{ 0x6DCB , 0xC1DC},
{ 0x51DB , 0xC1DD},
{ 0x8D41 , 0xC1DE},
{ 0x541D , 0xC1DF},
{ 0x62CE , 0xC1E0},
{ 0x73B2 , 0xC1E1},
{ 0x83F1 , 0xC1E2},
{ 0x96F6 , 0xC1E3},
{ 0x9F84 , 0xC1E4},
{ 0x94C3 , 0xC1E5},
{ 0x4F36 , 0xC1E6},
{ 0x7F9A , 0xC1E7},
{ 0x51CC , 0xC1E8},
{ 0x7075 , 0xC1E9},
{ 0x9675 , 0xC1EA},
{ 0x5CAD , 0xC1EB},
{ 0x9886 , 0xC1EC},
{ 0x53E6 , 0xC1ED},
{ 0x4EE4 , 0xC1EE},
{ 0x6E9C , 0xC1EF},
{ 0x7409 , 0xC1F0},
{ 0x69B4 , 0xC1F1},
{ 0x786B , 0xC1F2},
{ 0x998F , 0xC1F3},
{ 0x7559 , 0xC1F4},
{ 0x5218 , 0xC1F5},
{ 0x7624 , 0xC1F6},
{ 0x6D41 , 0xC1F7},
{ 0x67F3 , 0xC1F8},
{ 0x516D , 0xC1F9},
{ 0x9F99 , 0xC1FA},
{ 0x804B , 0xC1FB},
{ 0x5499 , 0xC1FC},
{ 0x7B3C , 0xC1FD},
{ 0x7ABF , 0xC1FE},
{ 0x7FE4 , 0xC240},
{ 0x7FE7 , 0xC241},
{ 0x7FE8 , 0xC242},
{ 0x7FEA , 0xC243},
{ 0x7FEB , 0xC244},
{ 0x7FEC , 0xC245},
{ 0x7FED , 0xC246},
{ 0x7FEF , 0xC247},
{ 0x7FF2 , 0xC248},
{ 0x7FF4 , 0xC249},
{ 0x7FF5 , 0xC24A},
{ 0x7FF6 , 0xC24B},
{ 0x7FF7 , 0xC24C},
{ 0x7FF8 , 0xC24D},
{ 0x7FF9 , 0xC24E},
{ 0x7FFA , 0xC24F},
{ 0x7FFD , 0xC250},
{ 0x7FFE , 0xC251},
{ 0x7FFF , 0xC252},
{ 0x8002 , 0xC253},
{ 0x8007 , 0xC254},
{ 0x8008 , 0xC255},
{ 0x8009 , 0xC256},
{ 0x800A , 0xC257},
{ 0x800E , 0xC258},
{ 0x800F , 0xC259},
{ 0x8011 , 0xC25A},
{ 0x8013 , 0xC25B},
{ 0x801A , 0xC25C},
{ 0x801B , 0xC25D},
{ 0x801D , 0xC25E},
{ 0x801E , 0xC25F},
{ 0x801F , 0xC260},
{ 0x8021 , 0xC261},
{ 0x8023 , 0xC262},
{ 0x8024 , 0xC263},
{ 0x802B , 0xC264},
{ 0x802C , 0xC265},
{ 0x802D , 0xC266},
{ 0x802E , 0xC267},
{ 0x802F , 0xC268},
{ 0x8030 , 0xC269},
{ 0x8032 , 0xC26A},
{ 0x8034 , 0xC26B},
{ 0x8039 , 0xC26C},
{ 0x803A , 0xC26D},
{ 0x803C , 0xC26E},
{ 0x803E , 0xC26F},
{ 0x8040 , 0xC270},
{ 0x8041 , 0xC271},
{ 0x8044 , 0xC272},
{ 0x8045 , 0xC273},
{ 0x8047 , 0xC274},
{ 0x8048 , 0xC275},
{ 0x8049 , 0xC276},
{ 0x804E , 0xC277},
{ 0x804F , 0xC278},
{ 0x8050 , 0xC279},
{ 0x8051 , 0xC27A},
{ 0x8053 , 0xC27B},
{ 0x8055 , 0xC27C},
{ 0x8056 , 0xC27D},
{ 0x8057 , 0xC27E},
{ 0x8059 , 0xC280},
{ 0x805B , 0xC281},
{ 0x805C , 0xC282},
{ 0x805D , 0xC283},
{ 0x805E , 0xC284},
{ 0x805F , 0xC285},
{ 0x8060 , 0xC286},
{ 0x8061 , 0xC287},
{ 0x8062 , 0xC288},
{ 0x8063 , 0xC289},
{ 0x8064 , 0xC28A},
{ 0x8065 , 0xC28B},
{ 0x8066 , 0xC28C},
{ 0x8067 , 0xC28D},
{ 0x8068 , 0xC28E},
{ 0x806B , 0xC28F},
{ 0x806C , 0xC290},
{ 0x806D , 0xC291},
{ 0x806E , 0xC292},
{ 0x806F , 0xC293},
{ 0x8070 , 0xC294},
{ 0x8072 , 0xC295},
{ 0x8073 , 0xC296},
{ 0x8074 , 0xC297},
{ 0x8075 , 0xC298},
{ 0x8076 , 0xC299},
{ 0x8077 , 0xC29A},
{ 0x8078 , 0xC29B},
{ 0x8079 , 0xC29C},
{ 0x807A , 0xC29D},
{ 0x807B , 0xC29E},
{ 0x807C , 0xC29F},
{ 0x807D , 0xC2A0},
{ 0x9686 , 0xC2A1},
{ 0x5784 , 0xC2A2},
{ 0x62E2 , 0xC2A3},
{ 0x9647 , 0xC2A4},
{ 0x697C , 0xC2A5},
{ 0x5A04 , 0xC2A6},
{ 0x6402 , 0xC2A7},
{ 0x7BD3 , 0xC2A8},
{ 0x6F0F , 0xC2A9},
{ 0x964B , 0xC2AA},
{ 0x82A6 , 0xC2AB},
{ 0x5362 , 0xC2AC},
{ 0x9885 , 0xC2AD},
{ 0x5E90 , 0xC2AE},
{ 0x7089 , 0xC2AF},
{ 0x63B3 , 0xC2B0},
{ 0x5364 , 0xC2B1},
{ 0x864F , 0xC2B2},
{ 0x9C81 , 0xC2B3},
{ 0x9E93 , 0xC2B4},
{ 0x788C , 0xC2B5},
{ 0x9732 , 0xC2B6},
{ 0x8DEF , 0xC2B7},
{ 0x8D42 , 0xC2B8},
{ 0x9E7F , 0xC2B9},
{ 0x6F5E , 0xC2BA},
{ 0x7984 , 0xC2BB},
{ 0x5F55 , 0xC2BC},
{ 0x9646 , 0xC2BD},
{ 0x622E , 0xC2BE},
{ 0x9A74 , 0xC2BF},
{ 0x5415 , 0xC2C0},
{ 0x94DD , 0xC2C1},
{ 0x4FA3 , 0xC2C2},
{ 0x65C5 , 0xC2C3},
{ 0x5C65 , 0xC2C4},
{ 0x5C61 , 0xC2C5},
{ 0x7F15 , 0xC2C6},
{ 0x8651 , 0xC2C7},
{ 0x6C2F , 0xC2C8},
{ 0x5F8B , 0xC2C9},
{ 0x7387 , 0xC2CA},
{ 0x6EE4 , 0xC2CB},
{ 0x7EFF , 0xC2CC},
{ 0x5CE6 , 0xC2CD},
{ 0x631B , 0xC2CE},
{ 0x5B6A , 0xC2CF},
{ 0x6EE6 , 0xC2D0},
{ 0x5375 , 0xC2D1},
{ 0x4E71 , 0xC2D2},
{ 0x63A0 , 0xC2D3},
{ 0x7565 , 0xC2D4},
{ 0x62A1 , 0xC2D5},
{ 0x8F6E , 0xC2D6},
{ 0x4F26 , 0xC2D7},
{ 0x4ED1 , 0xC2D8},
{ 0x6CA6 , 0xC2D9},
{ 0x7EB6 , 0xC2DA},
{ 0x8BBA , 0xC2DB},
{ 0x841D , 0xC2DC},
{ 0x87BA , 0xC2DD},
{ 0x7F57 , 0xC2DE},
{ 0x903B , 0xC2DF},
{ 0x9523 , 0xC2E0},
{ 0x7BA9 , 0xC2E1},
{ 0x9AA1 , 0xC2E2},
{ 0x88F8 , 0xC2E3},
{ 0x843D , 0xC2E4},
{ 0x6D1B , 0xC2E5},
{ 0x9A86 , 0xC2E6},
{ 0x7EDC , 0xC2E7},
{ 0x5988 , 0xC2E8},
{ 0x9EBB , 0xC2E9},
{ 0x739B , 0xC2EA},
{ 0x7801 , 0xC2EB},
{ 0x8682 , 0xC2EC},
{ 0x9A6C , 0xC2ED},
{ 0x9A82 , 0xC2EE},
{ 0x561B , 0xC2EF},
{ 0x5417 , 0xC2F0},
{ 0x57CB , 0xC2F1},
{ 0x4E70 , 0xC2F2},
{ 0x9EA6 , 0xC2F3},
{ 0x5356 , 0xC2F4},
{ 0x8FC8 , 0xC2F5},
{ 0x8109 , 0xC2F6},
{ 0x7792 , 0xC2F7},
{ 0x9992 , 0xC2F8},
{ 0x86EE , 0xC2F9},
{ 0x6EE1 , 0xC2FA},
{ 0x8513 , 0xC2FB},
{ 0x66FC , 0xC2FC},
{ 0x6162 , 0xC2FD},
{ 0x6F2B , 0xC2FE},
{ 0x807E , 0xC340},
{ 0x8081 , 0xC341},
{ 0x8082 , 0xC342},
{ 0x8085 , 0xC343},
{ 0x8088 , 0xC344},
{ 0x808A , 0xC345},
{ 0x808D , 0xC346},
{ 0x808E , 0xC347},
{ 0x808F , 0xC348},
{ 0x8090 , 0xC349},
{ 0x8091 , 0xC34A},
{ 0x8092 , 0xC34B},
{ 0x8094 , 0xC34C},
{ 0x8095 , 0xC34D},
{ 0x8097 , 0xC34E},
{ 0x8099 , 0xC34F},
{ 0x809E , 0xC350},
{ 0x80A3 , 0xC351},
{ 0x80A6 , 0xC352},
{ 0x80A7 , 0xC353},
{ 0x80A8 , 0xC354},
{ 0x80AC , 0xC355},
{ 0x80B0 , 0xC356},
{ 0x80B3 , 0xC357},
{ 0x80B5 , 0xC358},
{ 0x80B6 , 0xC359},
{ 0x80B8 , 0xC35A},
{ 0x80B9 , 0xC35B},
{ 0x80BB , 0xC35C},
{ 0x80C5 , 0xC35D},
{ 0x80C7 , 0xC35E},
{ 0x80C8 , 0xC35F},
{ 0x80C9 , 0xC360},
{ 0x80CA , 0xC361},
{ 0x80CB , 0xC362},
{ 0x80CF , 0xC363},
{ 0x80D0 , 0xC364},
{ 0x80D1 , 0xC365},
{ 0x80D2 , 0xC366},
{ 0x80D3 , 0xC367},
{ 0x80D4 , 0xC368},
{ 0x80D5 , 0xC369},
{ 0x80D8 , 0xC36A},
{ 0x80DF , 0xC36B},
{ 0x80E0 , 0xC36C},
{ 0x80E2 , 0xC36D},
{ 0x80E3 , 0xC36E},
{ 0x80E6 , 0xC36F},
{ 0x80EE , 0xC370},
{ 0x80F5 , 0xC371},
{ 0x80F7 , 0xC372},
{ 0x80F9 , 0xC373},
{ 0x80FB , 0xC374},
{ 0x80FE , 0xC375},
{ 0x80FF , 0xC376},
{ 0x8100 , 0xC377},
{ 0x8101 , 0xC378},
{ 0x8103 , 0xC379},
{ 0x8104 , 0xC37A},
{ 0x8105 , 0xC37B},
{ 0x8107 , 0xC37C},
{ 0x8108 , 0xC37D},
{ 0x810B , 0xC37E},
{ 0x810C , 0xC380},
{ 0x8115 , 0xC381},
{ 0x8117 , 0xC382},
{ 0x8119 , 0xC383},
{ 0x811B , 0xC384},
{ 0x811C , 0xC385},
{ 0x811D , 0xC386},
{ 0x811F , 0xC387},
{ 0x8120 , 0xC388},
{ 0x8121 , 0xC389},
{ 0x8122 , 0xC38A},
{ 0x8123 , 0xC38B},
{ 0x8124 , 0xC38C},
{ 0x8125 , 0xC38D},
{ 0x8126 , 0xC38E},
{ 0x8127 , 0xC38F},
{ 0x8128 , 0xC390},
{ 0x8129 , 0xC391},
{ 0x812A , 0xC392},
{ 0x812B , 0xC393},
{ 0x812D , 0xC394},
{ 0x812E , 0xC395},
{ 0x8130 , 0xC396},
{ 0x8133 , 0xC397},
{ 0x8134 , 0xC398},
{ 0x8135 , 0xC399},
{ 0x8137 , 0xC39A},
{ 0x8139 , 0xC39B},
{ 0x813A , 0xC39C},
{ 0x813B , 0xC39D},
{ 0x813C , 0xC39E},
{ 0x813D , 0xC39F},
{ 0x813F , 0xC3A0},
{ 0x8C29 , 0xC3A1},
{ 0x8292 , 0xC3A2},
{ 0x832B , 0xC3A3},
{ 0x76F2 , 0xC3A4},
{ 0x6C13 , 0xC3A5},
{ 0x5FD9 , 0xC3A6},
{ 0x83BD , 0xC3A7},
{ 0x732B , 0xC3A8},
{ 0x8305 , 0xC3A9},
{ 0x951A , 0xC3AA},
{ 0x6BDB , 0xC3AB},
{ 0x77DB , 0xC3AC},
{ 0x94C6 , 0xC3AD},
{ 0x536F , 0xC3AE},
{ 0x8302 , 0xC3AF},
{ 0x5192 , 0xC3B0},
{ 0x5E3D , 0xC3B1},
{ 0x8C8C , 0xC3B2},
{ 0x8D38 , 0xC3B3},
{ 0x4E48 , 0xC3B4},
{ 0x73AB , 0xC3B5},
{ 0x679A , 0xC3B6},
{ 0x6885 , 0xC3B7},
{ 0x9176 , 0xC3B8},
{ 0x9709 , 0xC3B9},
{ 0x7164 , 0xC3BA},
{ 0x6CA1 , 0xC3BB},
{ 0x7709 , 0xC3BC},
{ 0x5A92 , 0xC3BD},
{ 0x9541 , 0xC3BE},
{ 0x6BCF , 0xC3BF},
{ 0x7F8E , 0xC3C0},
{ 0x6627 , 0xC3C1},
{ 0x5BD0 , 0xC3C2},
{ 0x59B9 , 0xC3C3},
{ 0x5A9A , 0xC3C4},
{ 0x95E8 , 0xC3C5},
{ 0x95F7 , 0xC3C6},
{ 0x4EEC , 0xC3C7},
{ 0x840C , 0xC3C8},
{ 0x8499 , 0xC3C9},
{ 0x6AAC , 0xC3CA},
{ 0x76DF , 0xC3CB},
{ 0x9530 , 0xC3CC},
{ 0x731B , 0xC3CD},
{ 0x68A6 , 0xC3CE},
{ 0x5B5F , 0xC3CF},
{ 0x772F , 0xC3D0},
{ 0x919A , 0xC3D1},
{ 0x9761 , 0xC3D2},
{ 0x7CDC , 0xC3D3},
{ 0x8FF7 , 0xC3D4},
{ 0x8C1C , 0xC3D5},
{ 0x5F25 , 0xC3D6},
{ 0x7C73 , 0xC3D7},
{ 0x79D8 , 0xC3D8},
{ 0x89C5 , 0xC3D9},
{ 0x6CCC , 0xC3DA},
{ 0x871C , 0xC3DB},
{ 0x5BC6 , 0xC3DC},
{ 0x5E42 , 0xC3DD},
{ 0x68C9 , 0xC3DE},
{ 0x7720 , 0xC3DF},
{ 0x7EF5 , 0xC3E0},
{ 0x5195 , 0xC3E1},
{ 0x514D , 0xC3E2},
{ 0x52C9 , 0xC3E3},
{ 0x5A29 , 0xC3E4},
{ 0x7F05 , 0xC3E5},
{ 0x9762 , 0xC3E6},
{ 0x82D7 , 0xC3E7},
{ 0x63CF , 0xC3E8},
{ 0x7784 , 0xC3E9},
{ 0x85D0 , 0xC3EA},
{ 0x79D2 , 0xC3EB},
{ 0x6E3A , 0xC3EC},
{ 0x5E99 , 0xC3ED},
{ 0x5999 , 0xC3EE},
{ 0x8511 , 0xC3EF},
{ 0x706D , 0xC3F0},
{ 0x6C11 , 0xC3F1},
{ 0x62BF , 0xC3F2},
{ 0x76BF , 0xC3F3},
{ 0x654F , 0xC3F4},
{ 0x60AF , 0xC3F5},
{ 0x95FD , 0xC3F6},
{ 0x660E , 0xC3F7},
{ 0x879F , 0xC3F8},
{ 0x9E23 , 0xC3F9},
{ 0x94ED , 0xC3FA},
{ 0x540D , 0xC3FB},
{ 0x547D , 0xC3FC},
{ 0x8C2C , 0xC3FD},
{ 0x6478 , 0xC3FE},
{ 0x8140 , 0xC440},
{ 0x8141 , 0xC441},
{ 0x8142 , 0xC442},
{ 0x8143 , 0xC443},
{ 0x8144 , 0xC444},
{ 0x8145 , 0xC445},
{ 0x8147 , 0xC446},
{ 0x8149 , 0xC447},
{ 0x814D , 0xC448},
{ 0x814E , 0xC449},
{ 0x814F , 0xC44A},
{ 0x8152 , 0xC44B},
{ 0x8156 , 0xC44C},
{ 0x8157 , 0xC44D},
{ 0x8158 , 0xC44E},
{ 0x815B , 0xC44F},
{ 0x815C , 0xC450},
{ 0x815D , 0xC451},
{ 0x815E , 0xC452},
{ 0x815F , 0xC453},
{ 0x8161 , 0xC454},
{ 0x8162 , 0xC455},
{ 0x8163 , 0xC456},
{ 0x8164 , 0xC457},
{ 0x8166 , 0xC458},
{ 0x8168 , 0xC459},
{ 0x816A , 0xC45A},
{ 0x816B , 0xC45B},
{ 0x816C , 0xC45C},
{ 0x816F , 0xC45D},
{ 0x8172 , 0xC45E},
{ 0x8173 , 0xC45F},
{ 0x8175 , 0xC460},
{ 0x8176 , 0xC461},
{ 0x8177 , 0xC462},
{ 0x8178 , 0xC463},
{ 0x8181 , 0xC464},
{ 0x8183 , 0xC465},
{ 0x8184 , 0xC466},
{ 0x8185 , 0xC467},
{ 0x8186 , 0xC468},
{ 0x8187 , 0xC469},
{ 0x8189 , 0xC46A},
{ 0x818B , 0xC46B},
{ 0x818C , 0xC46C},
{ 0x818D , 0xC46D},
{ 0x818E , 0xC46E},
{ 0x8190 , 0xC46F},
{ 0x8192 , 0xC470},
{ 0x8193 , 0xC471},
{ 0x8194 , 0xC472},
{ 0x8195 , 0xC473},
{ 0x8196 , 0xC474},
{ 0x8197 , 0xC475},
{ 0x8199 , 0xC476},
{ 0x819A , 0xC477},
{ 0x819E , 0xC478},
{ 0x819F , 0xC479},
{ 0x81A0 , 0xC47A},
{ 0x81A1 , 0xC47B},
{ 0x81A2 , 0xC47C},
{ 0x81A4 , 0xC47D},
{ 0x81A5 , 0xC47E},
{ 0x81A7 , 0xC480},
{ 0x81A9 , 0xC481},
{ 0x81AB , 0xC482},
{ 0x81AC , 0xC483},
{ 0x81AD , 0xC484},
{ 0x81AE , 0xC485},
{ 0x81AF , 0xC486},
{ 0x81B0 , 0xC487},
{ 0x81B1 , 0xC488},
{ 0x81B2 , 0xC489},
{ 0x81B4 , 0xC48A},
{ 0x81B5 , 0xC48B},
{ 0x81B6 , 0xC48C},
{ 0x81B7 , 0xC48D},
{ 0x81B8 , 0xC48E},
{ 0x81B9 , 0xC48F},
{ 0x81BC , 0xC490},
{ 0x81BD , 0xC491},
{ 0x81BE , 0xC492},
{ 0x81BF , 0xC493},
{ 0x81C4 , 0xC494},
{ 0x81C5 , 0xC495},
{ 0x81C7 , 0xC496},
{ 0x81C8 , 0xC497},
{ 0x81C9 , 0xC498},
{ 0x81CB , 0xC499},
{ 0x81CD , 0xC49A},
{ 0x81CE , 0xC49B},
{ 0x81CF , 0xC49C},
{ 0x81D0 , 0xC49D},
{ 0x81D1 , 0xC49E},
{ 0x81D2 , 0xC49F},
{ 0x81D3 , 0xC4A0},
{ 0x6479 , 0xC4A1},
{ 0x8611 , 0xC4A2},
{ 0x6A21 , 0xC4A3},
{ 0x819C , 0xC4A4},
{ 0x78E8 , 0xC4A5},
{ 0x6469 , 0xC4A6},
{ 0x9B54 , 0xC4A7},
{ 0x62B9 , 0xC4A8},
{ 0x672B , 0xC4A9},
{ 0x83AB , 0xC4AA},
{ 0x58A8 , 0xC4AB},
{ 0x9ED8 , 0xC4AC},
{ 0x6CAB , 0xC4AD},
{ 0x6F20 , 0xC4AE},
{ 0x5BDE , 0xC4AF},
{ 0x964C , 0xC4B0},
{ 0x8C0B , 0xC4B1},
{ 0x725F , 0xC4B2},
{ 0x67D0 , 0xC4B3},
{ 0x62C7 , 0xC4B4},
{ 0x7261 , 0xC4B5},
{ 0x4EA9 , 0xC4B6},
{ 0x59C6 , 0xC4B7},
{ 0x6BCD , 0xC4B8},
{ 0x5893 , 0xC4B9},
{ 0x66AE , 0xC4BA},
{ 0x5E55 , 0xC4BB},
{ 0x52DF , 0xC4BC},
{ 0x6155 , 0xC4BD},
{ 0x6728 , 0xC4BE},
{ 0x76EE , 0xC4BF},
{ 0x7766 , 0xC4C0},
{ 0x7267 , 0xC4C1},
{ 0x7A46 , 0xC4C2},
{ 0x62FF , 0xC4C3},
{ 0x54EA , 0xC4C4},
{ 0x5450 , 0xC4C5},
{ 0x94A0 , 0xC4C6},
{ 0x90A3 , 0xC4C7},
{ 0x5A1C , 0xC4C8},
{ 0x7EB3 , 0xC4C9},
{ 0x6C16 , 0xC4CA},
{ 0x4E43 , 0xC4CB},
{ 0x5976 , 0xC4CC},
{ 0x8010 , 0xC4CD},
{ 0x5948 , 0xC4CE},
{ 0x5357 , 0xC4CF},
{ 0x7537 , 0xC4D0},
{ 0x96BE , 0xC4D1},
{ 0x56CA , 0xC4D2},
{ 0x6320 , 0xC4D3},
{ 0x8111 , 0xC4D4},
{ 0x607C , 0xC4D5},
{ 0x95F9 , 0xC4D6},
{ 0x6DD6 , 0xC4D7},
{ 0x5462 , 0xC4D8},
{ 0x9981 , 0xC4D9},
{ 0x5185 , 0xC4DA},
{ 0x5AE9 , 0xC4DB},
{ 0x80FD , 0xC4DC},
{ 0x59AE , 0xC4DD},
{ 0x9713 , 0xC4DE},
{ 0x502A , 0xC4DF},
{ 0x6CE5 , 0xC4E0},
{ 0x5C3C , 0xC4E1},
{ 0x62DF , 0xC4E2},
{ 0x4F60 , 0xC4E3},
{ 0x533F , 0xC4E4},
{ 0x817B , 0xC4E5},
{ 0x9006 , 0xC4E6},
{ 0x6EBA , 0xC4E7},
{ 0x852B , 0xC4E8},
{ 0x62C8 , 0xC4E9},
{ 0x5E74 , 0xC4EA},
{ 0x78BE , 0xC4EB},
{ 0x64B5 , 0xC4EC},
{ 0x637B , 0xC4ED},
{ 0x5FF5 , 0xC4EE},
{ 0x5A18 , 0xC4EF},
{ 0x917F , 0xC4F0},
{ 0x9E1F , 0xC4F1},
{ 0x5C3F , 0xC4F2},
{ 0x634F , 0xC4F3},
{ 0x8042 , 0xC4F4},
{ 0x5B7D , 0xC4F5},
{ 0x556E , 0xC4F6},
{ 0x954A , 0xC4F7},
{ 0x954D , 0xC4F8},
{ 0x6D85 , 0xC4F9},
{ 0x60A8 , 0xC4FA},
{ 0x67E0 , 0xC4FB},
{ 0x72DE , 0xC4FC},
{ 0x51DD , 0xC4FD},
{ 0x5B81 , 0xC4FE},
{ 0x81D4 , 0xC540},
{ 0x81D5 , 0xC541},
{ 0x81D6 , 0xC542},
{ 0x81D7 , 0xC543},
{ 0x81D8 , 0xC544},
{ 0x81D9 , 0xC545},
{ 0x81DA , 0xC546},
{ 0x81DB , 0xC547},
{ 0x81DC , 0xC548},
{ 0x81DD , 0xC549},
{ 0x81DE , 0xC54A},
{ 0x81DF , 0xC54B},
{ 0x81E0 , 0xC54C},
{ 0x81E1 , 0xC54D},
{ 0x81E2 , 0xC54E},
{ 0x81E4 , 0xC54F},
{ 0x81E5 , 0xC550},
{ 0x81E6 , 0xC551},
{ 0x81E8 , 0xC552},
{ 0x81E9 , 0xC553},
{ 0x81EB , 0xC554},
{ 0x81EE , 0xC555},
{ 0x81EF , 0xC556},
{ 0x81F0 , 0xC557},
{ 0x81F1 , 0xC558},
{ 0x81F2 , 0xC559},
{ 0x81F5 , 0xC55A},
{ 0x81F6 , 0xC55B},
{ 0x81F7 , 0xC55C},
{ 0x81F8 , 0xC55D},
{ 0x81F9 , 0xC55E},
{ 0x81FA , 0xC55F},
{ 0x81FD , 0xC560},
{ 0x81FF , 0xC561},
{ 0x8203 , 0xC562},
{ 0x8207 , 0xC563},
{ 0x8208 , 0xC564},
{ 0x8209 , 0xC565},
{ 0x820A , 0xC566},
{ 0x820B , 0xC567},
{ 0x820E , 0xC568},
{ 0x820F , 0xC569},
{ 0x8211 , 0xC56A},
{ 0x8213 , 0xC56B},
{ 0x8215 , 0xC56C},
{ 0x8216 , 0xC56D},
{ 0x8217 , 0xC56E},
{ 0x8218 , 0xC56F},
{ 0x8219 , 0xC570},
{ 0x821A , 0xC571},
{ 0x821D , 0xC572},
{ 0x8220 , 0xC573},
{ 0x8224 , 0xC574},
{ 0x8225 , 0xC575},
{ 0x8226 , 0xC576},
{ 0x8227 , 0xC577},
{ 0x8229 , 0xC578},
{ 0x822E , 0xC579},
{ 0x8232 , 0xC57A},
{ 0x823A , 0xC57B},
{ 0x823C , 0xC57C},
{ 0x823D , 0xC57D},
{ 0x823F , 0xC57E},
{ 0x8240 , 0xC580},
{ 0x8241 , 0xC581},
{ 0x8242 , 0xC582},
{ 0x8243 , 0xC583},
{ 0x8245 , 0xC584},
{ 0x8246 , 0xC585},
{ 0x8248 , 0xC586},
{ 0x824A , 0xC587},
{ 0x824C , 0xC588},
{ 0x824D , 0xC589},
{ 0x824E , 0xC58A},
{ 0x8250 , 0xC58B},
{ 0x8251 , 0xC58C},
{ 0x8252 , 0xC58D},
{ 0x8253 , 0xC58E},
{ 0x8254 , 0xC58F},
{ 0x8255 , 0xC590},
{ 0x8256 , 0xC591},
{ 0x8257 , 0xC592},
{ 0x8259 , 0xC593},
{ 0x825B , 0xC594},
{ 0x825C , 0xC595},
{ 0x825D , 0xC596},
{ 0x825E , 0xC597},
{ 0x8260 , 0xC598},
{ 0x8261 , 0xC599},
{ 0x8262 , 0xC59A},
{ 0x8263 , 0xC59B},
{ 0x8264 , 0xC59C},
{ 0x8265 , 0xC59D},
{ 0x8266 , 0xC59E},
{ 0x8267 , 0xC59F},
{ 0x8269 , 0xC5A0},
{ 0x62E7 , 0xC5A1},
{ 0x6CDE , 0xC5A2},
{ 0x725B , 0xC5A3},
{ 0x626D , 0xC5A4},
{ 0x94AE , 0xC5A5},
{ 0x7EBD , 0xC5A6},
{ 0x8113 , 0xC5A7},
{ 0x6D53 , 0xC5A8},
{ 0x519C , 0xC5A9},
{ 0x5F04 , 0xC5AA},
{ 0x5974 , 0xC5AB},
{ 0x52AA , 0xC5AC},
{ 0x6012 , 0xC5AD},
{ 0x5973 , 0xC5AE},
{ 0x6696 , 0xC5AF},
{ 0x8650 , 0xC5B0},
{ 0x759F , 0xC5B1},
{ 0x632A , 0xC5B2},
{ 0x61E6 , 0xC5B3},
{ 0x7CEF , 0xC5B4},
{ 0x8BFA , 0xC5B5},
{ 0x54E6 , 0xC5B6},
{ 0x6B27 , 0xC5B7},
{ 0x9E25 , 0xC5B8},
{ 0x6BB4 , 0xC5B9},
{ 0x85D5 , 0xC5BA},
{ 0x5455 , 0xC5BB},
{ 0x5076 , 0xC5BC},
{ 0x6CA4 , 0xC5BD},
{ 0x556A , 0xC5BE},
{ 0x8DB4 , 0xC5BF},
{ 0x722C , 0xC5C0},
{ 0x5E15 , 0xC5C1},
{ 0x6015 , 0xC5C2},
{ 0x7436 , 0xC5C3},
{ 0x62CD , 0xC5C4},
{ 0x6392 , 0xC5C5},
{ 0x724C , 0xC5C6},
{ 0x5F98 , 0xC5C7},
{ 0x6E43 , 0xC5C8},
{ 0x6D3E , 0xC5C9},
{ 0x6500 , 0xC5CA},
{ 0x6F58 , 0xC5CB},
{ 0x76D8 , 0xC5CC},
{ 0x78D0 , 0xC5CD},
{ 0x76FC , 0xC5CE},
{ 0x7554 , 0xC5CF},
{ 0x5224 , 0xC5D0},
{ 0x53DB , 0xC5D1},
{ 0x4E53 , 0xC5D2},
{ 0x5E9E , 0xC5D3},
{ 0x65C1 , 0xC5D4},
{ 0x802A , 0xC5D5},
{ 0x80D6 , 0xC5D6},
{ 0x629B , 0xC5D7},
{ 0x5486 , 0xC5D8},
{ 0x5228 , 0xC5D9},
{ 0x70AE , 0xC5DA},
{ 0x888D , 0xC5DB},
{ 0x8DD1 , 0xC5DC},
{ 0x6CE1 , 0xC5DD},
{ 0x5478 , 0xC5DE},
{ 0x80DA , 0xC5DF},
{ 0x57F9 , 0xC5E0},
{ 0x88F4 , 0xC5E1},
{ 0x8D54 , 0xC5E2},
{ 0x966A , 0xC5E3},
{ 0x914D , 0xC5E4},
{ 0x4F69 , 0xC5E5},
{ 0x6C9B , 0xC5E6},
{ 0x55B7 , 0xC5E7},
{ 0x76C6 , 0xC5E8},
{ 0x7830 , 0xC5E9},
{ 0x62A8 , 0xC5EA},
{ 0x70F9 , 0xC5EB},
{ 0x6F8E , 0xC5EC},
{ 0x5F6D , 0xC5ED},
{ 0x84EC , 0xC5EE},
{ 0x68DA , 0xC5EF},
{ 0x787C , 0xC5F0},
{ 0x7BF7 , 0xC5F1},
{ 0x81A8 , 0xC5F2},
{ 0x670B , 0xC5F3},
{ 0x9E4F , 0xC5F4},
{ 0x6367 , 0xC5F5},
{ 0x78B0 , 0xC5F6},
{ 0x576F , 0xC5F7},
{ 0x7812 , 0xC5F8},
{ 0x9739 , 0xC5F9},
{ 0x6279 , 0xC5FA},
{ 0x62AB , 0xC5FB},
{ 0x5288 , 0xC5FC},
{ 0x7435 , 0xC5FD},
{ 0x6BD7 , 0xC5FE},
{ 0x826A , 0xC640},
{ 0x826B , 0xC641},
{ 0x826C , 0xC642},
{ 0x826D , 0xC643},
{ 0x8271 , 0xC644},
{ 0x8275 , 0xC645},
{ 0x8276 , 0xC646},
{ 0x8277 , 0xC647},
{ 0x8278 , 0xC648},
{ 0x827B , 0xC649},
{ 0x827C , 0xC64A},
{ 0x8280 , 0xC64B},
{ 0x8281 , 0xC64C},
{ 0x8283 , 0xC64D},
{ 0x8285 , 0xC64E},
{ 0x8286 , 0xC64F},
{ 0x8287 , 0xC650},
{ 0x8289 , 0xC651},
{ 0x828C , 0xC652},
{ 0x8290 , 0xC653},
{ 0x8293 , 0xC654},
{ 0x8294 , 0xC655},
{ 0x8295 , 0xC656},
{ 0x8296 , 0xC657},
{ 0x829A , 0xC658},
{ 0x829B , 0xC659},
{ 0x829E , 0xC65A},
{ 0x82A0 , 0xC65B},
{ 0x82A2 , 0xC65C},
{ 0x82A3 , 0xC65D},
{ 0x82A7 , 0xC65E},
{ 0x82B2 , 0xC65F},
{ 0x82B5 , 0xC660},
{ 0x82B6 , 0xC661},
{ 0x82BA , 0xC662},
{ 0x82BB , 0xC663},
{ 0x82BC , 0xC664},
{ 0x82BF , 0xC665},
{ 0x82C0 , 0xC666},
{ 0x82C2 , 0xC667},
{ 0x82C3 , 0xC668},
{ 0x82C5 , 0xC669},
{ 0x82C6 , 0xC66A},
{ 0x82C9 , 0xC66B},
{ 0x82D0 , 0xC66C},
{ 0x82D6 , 0xC66D},
{ 0x82D9 , 0xC66E},
{ 0x82DA , 0xC66F},
{ 0x82DD , 0xC670},
{ 0x82E2 , 0xC671},
{ 0x82E7 , 0xC672},
{ 0x82E8 , 0xC673},
{ 0x82E9 , 0xC674},
{ 0x82EA , 0xC675},
{ 0x82EC , 0xC676},
{ 0x82ED , 0xC677},
{ 0x82EE , 0xC678},
{ 0x82F0 , 0xC679},
{ 0x82F2 , 0xC67A},
{ 0x82F3 , 0xC67B},
{ 0x82F5 , 0xC67C},
{ 0x82F6 , 0xC67D},
{ 0x82F8 , 0xC67E},
{ 0x82FA , 0xC680},
{ 0x82FC , 0xC681},
{ 0x82FD , 0xC682},
{ 0x82FE , 0xC683},
{ 0x82FF , 0xC684},
{ 0x8300 , 0xC685},
{ 0x830A , 0xC686},
{ 0x830B , 0xC687},
{ 0x830D , 0xC688},
{ 0x8310 , 0xC689},
{ 0x8312 , 0xC68A},
{ 0x8313 , 0xC68B},
{ 0x8316 , 0xC68C},
{ 0x8318 , 0xC68D},
{ 0x8319 , 0xC68E},
{ 0x831D , 0xC68F},
{ 0x831E , 0xC690},
{ 0x831F , 0xC691},
{ 0x8320 , 0xC692},
{ 0x8321 , 0xC693},
{ 0x8322 , 0xC694},
{ 0x8323 , 0xC695},
{ 0x8324 , 0xC696},
{ 0x8325 , 0xC697},
{ 0x8326 , 0xC698},
{ 0x8329 , 0xC699},
{ 0x832A , 0xC69A},
{ 0x832E , 0xC69B},
{ 0x8330 , 0xC69C},
{ 0x8332 , 0xC69D},
{ 0x8337 , 0xC69E},
{ 0x833B , 0xC69F},
{ 0x833D , 0xC6A0},
{ 0x5564 , 0xC6A1},
{ 0x813E , 0xC6A2},
{ 0x75B2 , 0xC6A3},
{ 0x76AE , 0xC6A4},
{ 0x5339 , 0xC6A5},
{ 0x75DE , 0xC6A6},
{ 0x50FB , 0xC6A7},
{ 0x5C41 , 0xC6A8},
{ 0x8B6C , 0xC6A9},
{ 0x7BC7 , 0xC6AA},
{ 0x504F , 0xC6AB},
{ 0x7247 , 0xC6AC},
{ 0x9A97 , 0xC6AD},
{ 0x98D8 , 0xC6AE},
{ 0x6F02 , 0xC6AF},
{ 0x74E2 , 0xC6B0},
{ 0x7968 , 0xC6B1},
{ 0x6487 , 0xC6B2},
{ 0x77A5 , 0xC6B3},
{ 0x62FC , 0xC6B4},
{ 0x9891 , 0xC6B5},
{ 0x8D2B , 0xC6B6},
{ 0x54C1 , 0xC6B7},
{ 0x8058 , 0xC6B8},
{ 0x4E52 , 0xC6B9},
{ 0x576A , 0xC6BA},
{ 0x82F9 , 0xC6BB},
{ 0x840D , 0xC6BC},
{ 0x5E73 , 0xC6BD},
{ 0x51ED , 0xC6BE},
{ 0x74F6 , 0xC6BF},
{ 0x8BC4 , 0xC6C0},
{ 0x5C4F , 0xC6C1},
{ 0x5761 , 0xC6C2},
{ 0x6CFC , 0xC6C3},
{ 0x9887 , 0xC6C4},
{ 0x5A46 , 0xC6C5},
{ 0x7834 , 0xC6C6},
{ 0x9B44 , 0xC6C7},
{ 0x8FEB , 0xC6C8},
{ 0x7C95 , 0xC6C9},
{ 0x5256 , 0xC6CA},
{ 0x6251 , 0xC6CB},
{ 0x94FA , 0xC6CC},
{ 0x4EC6 , 0xC6CD},
{ 0x8386 , 0xC6CE},
{ 0x8461 , 0xC6CF},
{ 0x83E9 , 0xC6D0},
{ 0x84B2 , 0xC6D1},
{ 0x57D4 , 0xC6D2},
{ 0x6734 , 0xC6D3},
{ 0x5703 , 0xC6D4},
{ 0x666E , 0xC6D5},
{ 0x6D66 , 0xC6D6},
{ 0x8C31 , 0xC6D7},
{ 0x66DD , 0xC6D8},
{ 0x7011 , 0xC6D9},
{ 0x671F , 0xC6DA},
{ 0x6B3A , 0xC6DB},
{ 0x6816 , 0xC6DC},
{ 0x621A , 0xC6DD},
{ 0x59BB , 0xC6DE},
{ 0x4E03 , 0xC6DF},
{ 0x51C4 , 0xC6E0},
{ 0x6F06 , 0xC6E1},
{ 0x67D2 , 0xC6E2},
{ 0x6C8F , 0xC6E3},
{ 0x5176 , 0xC6E4},
{ 0x68CB , 0xC6E5},
{ 0x5947 , 0xC6E6},
{ 0x6B67 , 0xC6E7},
{ 0x7566 , 0xC6E8},
{ 0x5D0E , 0xC6E9},
{ 0x8110 , 0xC6EA},
{ 0x9F50 , 0xC6EB},
{ 0x65D7 , 0xC6EC},
{ 0x7948 , 0xC6ED},
{ 0x7941 , 0xC6EE},
{ 0x9A91 , 0xC6EF},
{ 0x8D77 , 0xC6F0},
{ 0x5C82 , 0xC6F1},
{ 0x4E5E , 0xC6F2},
{ 0x4F01 , 0xC6F3},
{ 0x542F , 0xC6F4},
{ 0x5951 , 0xC6F5},
{ 0x780C , 0xC6F6},
{ 0x5668 , 0xC6F7},
{ 0x6C14 , 0xC6F8},
{ 0x8FC4 , 0xC6F9},
{ 0x5F03 , 0xC6FA},
{ 0x6C7D , 0xC6FB},
{ 0x6CE3 , 0xC6FC},
{ 0x8BAB , 0xC6FD},
{ 0x6390 , 0xC6FE},
{ 0x833E , 0xC740},
{ 0x833F , 0xC741},
{ 0x8341 , 0xC742},
{ 0x8342 , 0xC743},
{ 0x8344 , 0xC744},
{ 0x8345 , 0xC745},
{ 0x8348 , 0xC746},
{ 0x834A , 0xC747},
{ 0x834B , 0xC748},
{ 0x834C , 0xC749},
{ 0x834D , 0xC74A},
{ 0x834E , 0xC74B},
{ 0x8353 , 0xC74C},
{ 0x8355 , 0xC74D},
{ 0x8356 , 0xC74E},
{ 0x8357 , 0xC74F},
{ 0x8358 , 0xC750},
{ 0x8359 , 0xC751},
{ 0x835D , 0xC752},
{ 0x8362 , 0xC753},
{ 0x8370 , 0xC754},
{ 0x8371 , 0xC755},
{ 0x8372 , 0xC756},
{ 0x8373 , 0xC757},
{ 0x8374 , 0xC758},
{ 0x8375 , 0xC759},
{ 0x8376 , 0xC75A},
{ 0x8379 , 0xC75B},
{ 0x837A , 0xC75C},
{ 0x837E , 0xC75D},
{ 0x837F , 0xC75E},
{ 0x8380 , 0xC75F},
{ 0x8381 , 0xC760},
{ 0x8382 , 0xC761},
{ 0x8383 , 0xC762},
{ 0x8384 , 0xC763},
{ 0x8387 , 0xC764},
{ 0x8388 , 0xC765},
{ 0x838A , 0xC766},
{ 0x838B , 0xC767},
{ 0x838C , 0xC768},
{ 0x838D , 0xC769},
{ 0x838F , 0xC76A},
{ 0x8390 , 0xC76B},
{ 0x8391 , 0xC76C},
{ 0x8394 , 0xC76D},
{ 0x8395 , 0xC76E},
{ 0x8396 , 0xC76F},
{ 0x8397 , 0xC770},
{ 0x8399 , 0xC771},
{ 0x839A , 0xC772},
{ 0x839D , 0xC773},
{ 0x839F , 0xC774},
{ 0x83A1 , 0xC775},
{ 0x83A2 , 0xC776},
{ 0x83A3 , 0xC777},
{ 0x83A4 , 0xC778},
{ 0x83A5 , 0xC779},
{ 0x83A6 , 0xC77A},
{ 0x83A7 , 0xC77B},
{ 0x83AC , 0xC77C},
{ 0x83AD , 0xC77D},
{ 0x83AE , 0xC77E},
{ 0x83AF , 0xC780},
{ 0x83B5 , 0xC781},
{ 0x83BB , 0xC782},
{ 0x83BE , 0xC783},
{ 0x83BF , 0xC784},
{ 0x83C2 , 0xC785},
{ 0x83C3 , 0xC786},
{ 0x83C4 , 0xC787},
{ 0x83C6 , 0xC788},
{ 0x83C8 , 0xC789},
{ 0x83C9 , 0xC78A},
{ 0x83CB , 0xC78B},
{ 0x83CD , 0xC78C},
{ 0x83CE , 0xC78D},
{ 0x83D0 , 0xC78E},
{ 0x83D1 , 0xC78F},
{ 0x83D2 , 0xC790},
{ 0x83D3 , 0xC791},
{ 0x83D5 , 0xC792},
{ 0x83D7 , 0xC793},
{ 0x83D9 , 0xC794},
{ 0x83DA , 0xC795},
{ 0x83DB , 0xC796},
{ 0x83DE , 0xC797},
{ 0x83E2 , 0xC798},
{ 0x83E3 , 0xC799},
{ 0x83E4 , 0xC79A},
{ 0x83E6 , 0xC79B},
{ 0x83E7 , 0xC79C},
{ 0x83E8 , 0xC79D},
{ 0x83EB , 0xC79E},
{ 0x83EC , 0xC79F},
{ 0x83ED , 0xC7A0},
{ 0x6070 , 0xC7A1},
{ 0x6D3D , 0xC7A2},
{ 0x7275 , 0xC7A3},
{ 0x6266 , 0xC7A4},
{ 0x948E , 0xC7A5},
{ 0x94C5 , 0xC7A6},
{ 0x5343 , 0xC7A7},
{ 0x8FC1 , 0xC7A8},
{ 0x7B7E , 0xC7A9},
{ 0x4EDF , 0xC7AA},
{ 0x8C26 , 0xC7AB},
{ 0x4E7E , 0xC7AC},
{ 0x9ED4 , 0xC7AD},
{ 0x94B1 , 0xC7AE},
{ 0x94B3 , 0xC7AF},
{ 0x524D , 0xC7B0},
{ 0x6F5C , 0xC7B1},
{ 0x9063 , 0xC7B2},
{ 0x6D45 , 0xC7B3},
{ 0x8C34 , 0xC7B4},
{ 0x5811 , 0xC7B5},
{ 0x5D4C , 0xC7B6},
{ 0x6B20 , 0xC7B7},
{ 0x6B49 , 0xC7B8},
{ 0x67AA , 0xC7B9},
{ 0x545B , 0xC7BA},
{ 0x8154 , 0xC7BB},
{ 0x7F8C , 0xC7BC},
{ 0x5899 , 0xC7BD},
{ 0x8537 , 0xC7BE},
{ 0x5F3A , 0xC7BF},
{ 0x62A2 , 0xC7C0},
{ 0x6A47 , 0xC7C1},
{ 0x9539 , 0xC7C2},
{ 0x6572 , 0xC7C3},
{ 0x6084 , 0xC7C4},
{ 0x6865 , 0xC7C5},
{ 0x77A7 , 0xC7C6},
{ 0x4E54 , 0xC7C7},
{ 0x4FA8 , 0xC7C8},
{ 0x5DE7 , 0xC7C9},
{ 0x9798 , 0xC7CA},
{ 0x64AC , 0xC7CB},
{ 0x7FD8 , 0xC7CC},
{ 0x5CED , 0xC7CD},
{ 0x4FCF , 0xC7CE},
{ 0x7A8D , 0xC7CF},
{ 0x5207 , 0xC7D0},
{ 0x8304 , 0xC7D1},
{ 0x4E14 , 0xC7D2},
{ 0x602F , 0xC7D3},
{ 0x7A83 , 0xC7D4},
{ 0x94A6 , 0xC7D5},
{ 0x4FB5 , 0xC7D6},
{ 0x4EB2 , 0xC7D7},
{ 0x79E6 , 0xC7D8},
{ 0x7434 , 0xC7D9},
{ 0x52E4 , 0xC7DA},
{ 0x82B9 , 0xC7DB},
{ 0x64D2 , 0xC7DC},
{ 0x79BD , 0xC7DD},
{ 0x5BDD , 0xC7DE},
{ 0x6C81 , 0xC7DF},
{ 0x9752 , 0xC7E0},
{ 0x8F7B , 0xC7E1},
{ 0x6C22 , 0xC7E2},
{ 0x503E , 0xC7E3},
{ 0x537F , 0xC7E4},
{ 0x6E05 , 0xC7E5},
{ 0x64CE , 0xC7E6},
{ 0x6674 , 0xC7E7},
{ 0x6C30 , 0xC7E8},
{ 0x60C5 , 0xC7E9},
{ 0x9877 , 0xC7EA},
{ 0x8BF7 , 0xC7EB},
{ 0x5E86 , 0xC7EC},
{ 0x743C , 0xC7ED},
{ 0x7A77 , 0xC7EE},
{ 0x79CB , 0xC7EF},
{ 0x4E18 , 0xC7F0},
{ 0x90B1 , 0xC7F1},
{ 0x7403 , 0xC7F2},
{ 0x6C42 , 0xC7F3},
{ 0x56DA , 0xC7F4},
{ 0x914B , 0xC7F5},
{ 0x6CC5 , 0xC7F6},
{ 0x8D8B , 0xC7F7},
{ 0x533A , 0xC7F8},
{ 0x86C6 , 0xC7F9},
{ 0x66F2 , 0xC7FA},
{ 0x8EAF , 0xC7FB},
{ 0x5C48 , 0xC7FC},
{ 0x9A71 , 0xC7FD},
{ 0x6E20 , 0xC7FE},
{ 0x83EE , 0xC840},
{ 0x83EF , 0xC841},
{ 0x83F3 , 0xC842},
{ 0x83F4 , 0xC843},
{ 0x83F5 , 0xC844},
{ 0x83F6 , 0xC845},
{ 0x83F7 , 0xC846},
{ 0x83FA , 0xC847},
{ 0x83FB , 0xC848},
{ 0x83FC , 0xC849},
{ 0x83FE , 0xC84A},
{ 0x83FF , 0xC84B},
{ 0x8400 , 0xC84C},
{ 0x8402 , 0xC84D},
{ 0x8405 , 0xC84E},
{ 0x8407 , 0xC84F},
{ 0x8408 , 0xC850},
{ 0x8409 , 0xC851},
{ 0x840A , 0xC852},
{ 0x8410 , 0xC853},
{ 0x8412 , 0xC854},
{ 0x8413 , 0xC855},
{ 0x8414 , 0xC856},
{ 0x8415 , 0xC857},
{ 0x8416 , 0xC858},
{ 0x8417 , 0xC859},
{ 0x8419 , 0xC85A},
{ 0x841A , 0xC85B},
{ 0x841B , 0xC85C},
{ 0x841E , 0xC85D},
{ 0x841F , 0xC85E},
{ 0x8420 , 0xC85F},
{ 0x8421 , 0xC860},
{ 0x8422 , 0xC861},
{ 0x8423 , 0xC862},
{ 0x8429 , 0xC863},
{ 0x842A , 0xC864},
{ 0x842B , 0xC865},
{ 0x842C , 0xC866},
{ 0x842D , 0xC867},
{ 0x842E , 0xC868},
{ 0x842F , 0xC869},
{ 0x8430 , 0xC86A},
{ 0x8432 , 0xC86B},
{ 0x8433 , 0xC86C},
{ 0x8434 , 0xC86D},
{ 0x8435 , 0xC86E},
{ 0x8436 , 0xC86F},
{ 0x8437 , 0xC870},
{ 0x8439 , 0xC871},
{ 0x843A , 0xC872},
{ 0x843B , 0xC873},
{ 0x843E , 0xC874},
{ 0x843F , 0xC875},
{ 0x8440 , 0xC876},
{ 0x8441 , 0xC877},
{ 0x8442 , 0xC878},
{ 0x8443 , 0xC879},
{ 0x8444 , 0xC87A},
{ 0x8445 , 0xC87B},
{ 0x8447 , 0xC87C},
{ 0x8448 , 0xC87D},
{ 0x8449 , 0xC87E},
{ 0x844A , 0xC880},
{ 0x844B , 0xC881},
{ 0x844C , 0xC882},
{ 0x844D , 0xC883},
{ 0x844E , 0xC884},
{ 0x844F , 0xC885},
{ 0x8450 , 0xC886},
{ 0x8452 , 0xC887},
{ 0x8453 , 0xC888},
{ 0x8454 , 0xC889},
{ 0x8455 , 0xC88A},
{ 0x8456 , 0xC88B},
{ 0x8458 , 0xC88C},
{ 0x845D , 0xC88D},
{ 0x845E , 0xC88E},
{ 0x845F , 0xC88F},
{ 0x8460 , 0xC890},
{ 0x8462 , 0xC891},
{ 0x8464 , 0xC892},
{ 0x8465 , 0xC893},
{ 0x8466 , 0xC894},
{ 0x8467 , 0xC895},
{ 0x8468 , 0xC896},
{ 0x846A , 0xC897},
{ 0x846E , 0xC898},
{ 0x846F , 0xC899},
{ 0x8470 , 0xC89A},
{ 0x8472 , 0xC89B},
{ 0x8474 , 0xC89C},
{ 0x8477 , 0xC89D},
{ 0x8479 , 0xC89E},
{ 0x847B , 0xC89F},
{ 0x847C , 0xC8A0},
{ 0x53D6 , 0xC8A1},
{ 0x5A36 , 0xC8A2},
{ 0x9F8B , 0xC8A3},
{ 0x8DA3 , 0xC8A4},
{ 0x53BB , 0xC8A5},
{ 0x5708 , 0xC8A6},
{ 0x98A7 , 0xC8A7},
{ 0x6743 , 0xC8A8},
{ 0x919B , 0xC8A9},
{ 0x6CC9 , 0xC8AA},
{ 0x5168 , 0xC8AB},
{ 0x75CA , 0xC8AC},
{ 0x62F3 , 0xC8AD},
{ 0x72AC , 0xC8AE},
{ 0x5238 , 0xC8AF},
{ 0x529D , 0xC8B0},
{ 0x7F3A , 0xC8B1},
{ 0x7094 , 0xC8B2},
{ 0x7638 , 0xC8B3},
{ 0x5374 , 0xC8B4},
{ 0x9E4A , 0xC8B5},
{ 0x69B7 , 0xC8B6},
{ 0x786E , 0xC8B7},
{ 0x96C0 , 0xC8B8},
{ 0x88D9 , 0xC8B9},
{ 0x7FA4 , 0xC8BA},
{ 0x7136 , 0xC8BB},
{ 0x71C3 , 0xC8BC},
{ 0x5189 , 0xC8BD},
{ 0x67D3 , 0xC8BE},
{ 0x74E4 , 0xC8BF},
{ 0x58E4 , 0xC8C0},
{ 0x6518 , 0xC8C1},
{ 0x56B7 , 0xC8C2},
{ 0x8BA9 , 0xC8C3},
{ 0x9976 , 0xC8C4},
{ 0x6270 , 0xC8C5},
{ 0x7ED5 , 0xC8C6},
{ 0x60F9 , 0xC8C7},
{ 0x70ED , 0xC8C8},
{ 0x58EC , 0xC8C9},
{ 0x4EC1 , 0xC8CA},
{ 0x4EBA , 0xC8CB},
{ 0x5FCD , 0xC8CC},
{ 0x97E7 , 0xC8CD},
{ 0x4EFB , 0xC8CE},
{ 0x8BA4 , 0xC8CF},
{ 0x5203 , 0xC8D0},
{ 0x598A , 0xC8D1},
{ 0x7EAB , 0xC8D2},
{ 0x6254 , 0xC8D3},
{ 0x4ECD , 0xC8D4},
{ 0x65E5 , 0xC8D5},
{ 0x620E , 0xC8D6},
{ 0x8338 , 0xC8D7},
{ 0x84C9 , 0xC8D8},
{ 0x8363 , 0xC8D9},
{ 0x878D , 0xC8DA},
{ 0x7194 , 0xC8DB},
{ 0x6EB6 , 0xC8DC},
{ 0x5BB9 , 0xC8DD},
{ 0x7ED2 , 0xC8DE},
{ 0x5197 , 0xC8DF},
{ 0x63C9 , 0xC8E0},
{ 0x67D4 , 0xC8E1},
{ 0x8089 , 0xC8E2},
{ 0x8339 , 0xC8E3},
{ 0x8815 , 0xC8E4},
{ 0x5112 , 0xC8E5},
{ 0x5B7A , 0xC8E6},
{ 0x5982 , 0xC8E7},
{ 0x8FB1 , 0xC8E8},
{ 0x4E73 , 0xC8E9},
{ 0x6C5D , 0xC8EA},
{ 0x5165 , 0xC8EB},
{ 0x8925 , 0xC8EC},
{ 0x8F6F , 0xC8ED},
{ 0x962E , 0xC8EE},
{ 0x854A , 0xC8EF},
{ 0x745E , 0xC8F0},
{ 0x9510 , 0xC8F1},
{ 0x95F0 , 0xC8F2},
{ 0x6DA6 , 0xC8F3},
{ 0x82E5 , 0xC8F4},
{ 0x5F31 , 0xC8F5},
{ 0x6492 , 0xC8F6},
{ 0x6D12 , 0xC8F7},
{ 0x8428 , 0xC8F8},
{ 0x816E , 0xC8F9},
{ 0x9CC3 , 0xC8FA},
{ 0x585E , 0xC8FB},
{ 0x8D5B , 0xC8FC},
{ 0x4E09 , 0xC8FD},
{ 0x53C1 , 0xC8FE},
{ 0x847D , 0xC940},
{ 0x847E , 0xC941},
{ 0x847F , 0xC942},
{ 0x8480 , 0xC943},
{ 0x8481 , 0xC944},
{ 0x8483 , 0xC945},
{ 0x8484 , 0xC946},
{ 0x8485 , 0xC947},
{ 0x8486 , 0xC948},
{ 0x848A , 0xC949},
{ 0x848D , 0xC94A},
{ 0x848F , 0xC94B},
{ 0x8490 , 0xC94C},
{ 0x8491 , 0xC94D},
{ 0x8492 , 0xC94E},
{ 0x8493 , 0xC94F},
{ 0x8494 , 0xC950},
{ 0x8495 , 0xC951},
{ 0x8496 , 0xC952},
{ 0x8498 , 0xC953},
{ 0x849A , 0xC954},
{ 0x849B , 0xC955},
{ 0x849D , 0xC956},
{ 0x849E , 0xC957},
{ 0x849F , 0xC958},
{ 0x84A0 , 0xC959},
{ 0x84A2 , 0xC95A},
{ 0x84A3 , 0xC95B},
{ 0x84A4 , 0xC95C},
{ 0x84A5 , 0xC95D},
{ 0x84A6 , 0xC95E},
{ 0x84A7 , 0xC95F},
{ 0x84A8 , 0xC960},
{ 0x84A9 , 0xC961},
{ 0x84AA , 0xC962},
{ 0x84AB , 0xC963},
{ 0x84AC , 0xC964},
{ 0x84AD , 0xC965},
{ 0x84AE , 0xC966},
{ 0x84B0 , 0xC967},
{ 0x84B1 , 0xC968},
{ 0x84B3 , 0xC969},
{ 0x84B5 , 0xC96A},
{ 0x84B6 , 0xC96B},
{ 0x84B7 , 0xC96C},
{ 0x84BB , 0xC96D},
{ 0x84BC , 0xC96E},
{ 0x84BE , 0xC96F},
{ 0x84C0 , 0xC970},
{ 0x84C2 , 0xC971},
{ 0x84C3 , 0xC972},
{ 0x84C5 , 0xC973},
{ 0x84C6 , 0xC974},
{ 0x84C7 , 0xC975},
{ 0x84C8 , 0xC976},
{ 0x84CB , 0xC977},
{ 0x84CC , 0xC978},
{ 0x84CE , 0xC979},
{ 0x84CF , 0xC97A},
{ 0x84D2 , 0xC97B},
{ 0x84D4 , 0xC97C},
{ 0x84D5 , 0xC97D},
{ 0x84D7 , 0xC97E},
{ 0x84D8 , 0xC980},
{ 0x84D9 , 0xC981},
{ 0x84DA , 0xC982},
{ 0x84DB , 0xC983},
{ 0x84DC , 0xC984},
{ 0x84DE , 0xC985},
{ 0x84E1 , 0xC986},
{ 0x84E2 , 0xC987},
{ 0x84E4 , 0xC988},
{ 0x84E7 , 0xC989},
{ 0x84E8 , 0xC98A},
{ 0x84E9 , 0xC98B},
{ 0x84EA , 0xC98C},
{ 0x84EB , 0xC98D},
{ 0x84ED , 0xC98E},
{ 0x84EE , 0xC98F},
{ 0x84EF , 0xC990},
{ 0x84F1 , 0xC991},
{ 0x84F2 , 0xC992},
{ 0x84F3 , 0xC993},
{ 0x84F4 , 0xC994},
{ 0x84F5 , 0xC995},
{ 0x84F6 , 0xC996},
{ 0x84F7 , 0xC997},
{ 0x84F8 , 0xC998},
{ 0x84F9 , 0xC999},
{ 0x84FA , 0xC99A},
{ 0x84FB , 0xC99B},
{ 0x84FD , 0xC99C},
{ 0x84FE , 0xC99D},
{ 0x8500 , 0xC99E},
{ 0x8501 , 0xC99F},
{ 0x8502 , 0xC9A0},
{ 0x4F1E , 0xC9A1},
{ 0x6563 , 0xC9A2},
{ 0x6851 , 0xC9A3},
{ 0x55D3 , 0xC9A4},
{ 0x4E27 , 0xC9A5},
{ 0x6414 , 0xC9A6},
{ 0x9A9A , 0xC9A7},
{ 0x626B , 0xC9A8},
{ 0x5AC2 , 0xC9A9},
{ 0x745F , 0xC9AA},
{ 0x8272 , 0xC9AB},
{ 0x6DA9 , 0xC9AC},
{ 0x68EE , 0xC9AD},
{ 0x50E7 , 0xC9AE},
{ 0x838E , 0xC9AF},
{ 0x7802 , 0xC9B0},
{ 0x6740 , 0xC9B1},
{ 0x5239 , 0xC9B2},
{ 0x6C99 , 0xC9B3},
{ 0x7EB1 , 0xC9B4},
{ 0x50BB , 0xC9B5},
{ 0x5565 , 0xC9B6},
{ 0x715E , 0xC9B7},
{ 0x7B5B , 0xC9B8},
{ 0x6652 , 0xC9B9},
{ 0x73CA , 0xC9BA},
{ 0x82EB , 0xC9BB},
{ 0x6749 , 0xC9BC},
{ 0x5C71 , 0xC9BD},
{ 0x5220 , 0xC9BE},
{ 0x717D , 0xC9BF},
{ 0x886B , 0xC9C0},
{ 0x95EA , 0xC9C1},
{ 0x9655 , 0xC9C2},
{ 0x64C5 , 0xC9C3},
{ 0x8D61 , 0xC9C4},
{ 0x81B3 , 0xC9C5},
{ 0x5584 , 0xC9C6},
{ 0x6C55 , 0xC9C7},
{ 0x6247 , 0xC9C8},
{ 0x7F2E , 0xC9C9},
{ 0x5892 , 0xC9CA},
{ 0x4F24 , 0xC9CB},
{ 0x5546 , 0xC9CC},
{ 0x8D4F , 0xC9CD},
{ 0x664C , 0xC9CE},
{ 0x4E0A , 0xC9CF},
{ 0x5C1A , 0xC9D0},
{ 0x88F3 , 0xC9D1},
{ 0x68A2 , 0xC9D2},
{ 0x634E , 0xC9D3},
{ 0x7A0D , 0xC9D4},
{ 0x70E7 , 0xC9D5},
{ 0x828D , 0xC9D6},
{ 0x52FA , 0xC9D7},
{ 0x97F6 , 0xC9D8},
{ 0x5C11 , 0xC9D9},
{ 0x54E8 , 0xC9DA},
{ 0x90B5 , 0xC9DB},
{ 0x7ECD , 0xC9DC},
{ 0x5962 , 0xC9DD},
{ 0x8D4A , 0xC9DE},
{ 0x86C7 , 0xC9DF},
{ 0x820C , 0xC9E0},
{ 0x820D , 0xC9E1},
{ 0x8D66 , 0xC9E2},
{ 0x6444 , 0xC9E3},
{ 0x5C04 , 0xC9E4},
{ 0x6151 , 0xC9E5},
{ 0x6D89 , 0xC9E6},
{ 0x793E , 0xC9E7},
{ 0x8BBE , 0xC9E8},
{ 0x7837 , 0xC9E9},
{ 0x7533 , 0xC9EA},
{ 0x547B , 0xC9EB},
{ 0x4F38 , 0xC9EC},
{ 0x8EAB , 0xC9ED},
{ 0x6DF1 , 0xC9EE},
{ 0x5A20 , 0xC9EF},
{ 0x7EC5 , 0xC9F0},
{ 0x795E , 0xC9F1},
{ 0x6C88 , 0xC9F2},
{ 0x5BA1 , 0xC9F3},
{ 0x5A76 , 0xC9F4},
{ 0x751A , 0xC9F5},
{ 0x80BE , 0xC9F6},
{ 0x614E , 0xC9F7},
{ 0x6E17 , 0xC9F8},
{ 0x58F0 , 0xC9F9},
{ 0x751F , 0xC9FA},
{ 0x7525 , 0xC9FB},
{ 0x7272 , 0xC9FC},
{ 0x5347 , 0xC9FD},
{ 0x7EF3 , 0xC9FE},
{ 0x8503 , 0xCA40},
{ 0x8504 , 0xCA41},
{ 0x8505 , 0xCA42},
{ 0x8506 , 0xCA43},
{ 0x8507 , 0xCA44},
{ 0x8508 , 0xCA45},
{ 0x8509 , 0xCA46},
{ 0x850A , 0xCA47},
{ 0x850B , 0xCA48},
{ 0x850D , 0xCA49},
{ 0x850E , 0xCA4A},
{ 0x850F , 0xCA4B},
{ 0x8510 , 0xCA4C},
{ 0x8512 , 0xCA4D},
{ 0x8514 , 0xCA4E},
{ 0x8515 , 0xCA4F},
{ 0x8516 , 0xCA50},
{ 0x8518 , 0xCA51},
{ 0x8519 , 0xCA52},
{ 0x851B , 0xCA53},
{ 0x851C , 0xCA54},
{ 0x851D , 0xCA55},
{ 0x851E , 0xCA56},
{ 0x8520 , 0xCA57},
{ 0x8522 , 0xCA58},
{ 0x8523 , 0xCA59},
{ 0x8524 , 0xCA5A},
{ 0x8525 , 0xCA5B},
{ 0x8526 , 0xCA5C},
{ 0x8527 , 0xCA5D},
{ 0x8528 , 0xCA5E},
{ 0x8529 , 0xCA5F},
{ 0x852A , 0xCA60},
{ 0x852D , 0xCA61},
{ 0x852E , 0xCA62},
{ 0x852F , 0xCA63},
{ 0x8530 , 0xCA64},
{ 0x8531 , 0xCA65},
{ 0x8532 , 0xCA66},
{ 0x8533 , 0xCA67},
{ 0x8534 , 0xCA68},
{ 0x8535 , 0xCA69},
{ 0x8536 , 0xCA6A},
{ 0x853E , 0xCA6B},
{ 0x853F , 0xCA6C},
{ 0x8540 , 0xCA6D},
{ 0x8541 , 0xCA6E},
{ 0x8542 , 0xCA6F},
{ 0x8544 , 0xCA70},
{ 0x8545 , 0xCA71},
{ 0x8546 , 0xCA72},
{ 0x8547 , 0xCA73},
{ 0x854B , 0xCA74},
{ 0x854C , 0xCA75},
{ 0x854D , 0xCA76},
{ 0x854E , 0xCA77},
{ 0x854F , 0xCA78},
{ 0x8550 , 0xCA79},
{ 0x8551 , 0xCA7A},
{ 0x8552 , 0xCA7B},
{ 0x8553 , 0xCA7C},
{ 0x8554 , 0xCA7D},
{ 0x8555 , 0xCA7E},
{ 0x8557 , 0xCA80},
{ 0x8558 , 0xCA81},
{ 0x855A , 0xCA82},
{ 0x855B , 0xCA83},
{ 0x855C , 0xCA84},
{ 0x855D , 0xCA85},
{ 0x855F , 0xCA86},
{ 0x8560 , 0xCA87},
{ 0x8561 , 0xCA88},
{ 0x8562 , 0xCA89},
{ 0x8563 , 0xCA8A},
{ 0x8565 , 0xCA8B},
{ 0x8566 , 0xCA8C},
{ 0x8567 , 0xCA8D},
{ 0x8569 , 0xCA8E},
{ 0x856A , 0xCA8F},
{ 0x856B , 0xCA90},
{ 0x856C , 0xCA91},
{ 0x856D , 0xCA92},
{ 0x856E , 0xCA93},
{ 0x856F , 0xCA94},
{ 0x8570 , 0xCA95},
{ 0x8571 , 0xCA96},
{ 0x8573 , 0xCA97},
{ 0x8575 , 0xCA98},
{ 0x8576 , 0xCA99},
{ 0x8577 , 0xCA9A},
{ 0x8578 , 0xCA9B},
{ 0x857C , 0xCA9C},
{ 0x857D , 0xCA9D},
{ 0x857F , 0xCA9E},
{ 0x8580 , 0xCA9F},
{ 0x8581 , 0xCAA0},
{ 0x7701 , 0xCAA1},
{ 0x76DB , 0xCAA2},
{ 0x5269 , 0xCAA3},
{ 0x80DC , 0xCAA4},
{ 0x5723 , 0xCAA5},
{ 0x5E08 , 0xCAA6},
{ 0x5931 , 0xCAA7},
{ 0x72EE , 0xCAA8},
{ 0x65BD , 0xCAA9},
{ 0x6E7F , 0xCAAA},
{ 0x8BD7 , 0xCAAB},
{ 0x5C38 , 0xCAAC},
{ 0x8671 , 0xCAAD},
{ 0x5341 , 0xCAAE},
{ 0x77F3 , 0xCAAF},
{ 0x62FE , 0xCAB0},
{ 0x65F6 , 0xCAB1},
{ 0x4EC0 , 0xCAB2},
{ 0x98DF , 0xCAB3},
{ 0x8680 , 0xCAB4},
{ 0x5B9E , 0xCAB5},
{ 0x8BC6 , 0xCAB6},
{ 0x53F2 , 0xCAB7},
{ 0x77E2 , 0xCAB8},
{ 0x4F7F , 0xCAB9},
{ 0x5C4E , 0xCABA},
{ 0x9A76 , 0xCABB},
{ 0x59CB , 0xCABC},
{ 0x5F0F , 0xCABD},
{ 0x793A , 0xCABE},
{ 0x58EB , 0xCABF},
{ 0x4E16 , 0xCAC0},
{ 0x67FF , 0xCAC1},
{ 0x4E8B , 0xCAC2},
{ 0x62ED , 0xCAC3},
{ 0x8A93 , 0xCAC4},
{ 0x901D , 0xCAC5},
{ 0x52BF , 0xCAC6},
{ 0x662F , 0xCAC7},
{ 0x55DC , 0xCAC8},
{ 0x566C , 0xCAC9},
{ 0x9002 , 0xCACA},
{ 0x4ED5 , 0xCACB},
{ 0x4F8D , 0xCACC},
{ 0x91CA , 0xCACD},
{ 0x9970 , 0xCACE},
{ 0x6C0F , 0xCACF},
{ 0x5E02 , 0xCAD0},
{ 0x6043 , 0xCAD1},
{ 0x5BA4 , 0xCAD2},
{ 0x89C6 , 0xCAD3},
{ 0x8BD5 , 0xCAD4},
{ 0x6536 , 0xCAD5},
{ 0x624B , 0xCAD6},
{ 0x9996 , 0xCAD7},
{ 0x5B88 , 0xCAD8},
{ 0x5BFF , 0xCAD9},
{ 0x6388 , 0xCADA},
{ 0x552E , 0xCADB},
{ 0x53D7 , 0xCADC},
{ 0x7626 , 0xCADD},
{ 0x517D , 0xCADE},
{ 0x852C , 0xCADF},
{ 0x67A2 , 0xCAE0},
{ 0x68B3 , 0xCAE1},
{ 0x6B8A , 0xCAE2},
{ 0x6292 , 0xCAE3},
{ 0x8F93 , 0xCAE4},
{ 0x53D4 , 0xCAE5},
{ 0x8212 , 0xCAE6},
{ 0x6DD1 , 0xCAE7},
{ 0x758F , 0xCAE8},
{ 0x4E66 , 0xCAE9},
{ 0x8D4E , 0xCAEA},
{ 0x5B70 , 0xCAEB},
{ 0x719F , 0xCAEC},
{ 0x85AF , 0xCAED},
{ 0x6691 , 0xCAEE},
{ 0x66D9 , 0xCAEF},
{ 0x7F72 , 0xCAF0},
{ 0x8700 , 0xCAF1},
{ 0x9ECD , 0xCAF2},
{ 0x9F20 , 0xCAF3},
{ 0x5C5E , 0xCAF4},
{ 0x672F , 0xCAF5},
{ 0x8FF0 , 0xCAF6},
{ 0x6811 , 0xCAF7},
{ 0x675F , 0xCAF8},
{ 0x620D , 0xCAF9},
{ 0x7AD6 , 0xCAFA},
{ 0x5885 , 0xCAFB},
{ 0x5EB6 , 0xCAFC},
{ 0x6570 , 0xCAFD},
{ 0x6F31 , 0xCAFE},
{ 0x8582 , 0xCB40},
{ 0x8583 , 0xCB41},
{ 0x8586 , 0xCB42},
{ 0x8588 , 0xCB43},
{ 0x8589 , 0xCB44},
{ 0x858A , 0xCB45},
{ 0x858B , 0xCB46},
{ 0x858C , 0xCB47},
{ 0x858D , 0xCB48},
{ 0x858E , 0xCB49},
{ 0x8590 , 0xCB4A},
{ 0x8591 , 0xCB4B},
{ 0x8592 , 0xCB4C},
{ 0x8593 , 0xCB4D},
{ 0x8594 , 0xCB4E},
{ 0x8595 , 0xCB4F},
{ 0x8596 , 0xCB50},
{ 0x8597 , 0xCB51},
{ 0x8598 , 0xCB52},
{ 0x8599 , 0xCB53},
{ 0x859A , 0xCB54},
{ 0x859D , 0xCB55},
{ 0x859E , 0xCB56},
{ 0x859F , 0xCB57},
{ 0x85A0 , 0xCB58},
{ 0x85A1 , 0xCB59},
{ 0x85A2 , 0xCB5A},
{ 0x85A3 , 0xCB5B},
{ 0x85A5 , 0xCB5C},
{ 0x85A6 , 0xCB5D},
{ 0x85A7 , 0xCB5E},
{ 0x85A9 , 0xCB5F},
{ 0x85AB , 0xCB60},
{ 0x85AC , 0xCB61},
{ 0x85AD , 0xCB62},
{ 0x85B1 , 0xCB63},
{ 0x85B2 , 0xCB64},
{ 0x85B3 , 0xCB65},
{ 0x85B4 , 0xCB66},
{ 0x85B5 , 0xCB67},
{ 0x85B6 , 0xCB68},
{ 0x85B8 , 0xCB69},
{ 0x85BA , 0xCB6A},
{ 0x85BB , 0xCB6B},
{ 0x85BC , 0xCB6C},
{ 0x85BD , 0xCB6D},
{ 0x85BE , 0xCB6E},
{ 0x85BF , 0xCB6F},
{ 0x85C0 , 0xCB70},
{ 0x85C2 , 0xCB71},
{ 0x85C3 , 0xCB72},
{ 0x85C4 , 0xCB73},
{ 0x85C5 , 0xCB74},
{ 0x85C6 , 0xCB75},
{ 0x85C7 , 0xCB76},
{ 0x85C8 , 0xCB77},
{ 0x85CA , 0xCB78},
{ 0x85CB , 0xCB79},
{ 0x85CC , 0xCB7A},
{ 0x85CD , 0xCB7B},
{ 0x85CE , 0xCB7C},
{ 0x85D1 , 0xCB7D},
{ 0x85D2 , 0xCB7E},
{ 0x85D4 , 0xCB80},
{ 0x85D6 , 0xCB81},
{ 0x85D7 , 0xCB82},
{ 0x85D8 , 0xCB83},
{ 0x85D9 , 0xCB84},
{ 0x85DA , 0xCB85},
{ 0x85DB , 0xCB86},
{ 0x85DD , 0xCB87},
{ 0x85DE , 0xCB88},
{ 0x85DF , 0xCB89},
{ 0x85E0 , 0xCB8A},
{ 0x85E1 , 0xCB8B},
{ 0x85E2 , 0xCB8C},
{ 0x85E3 , 0xCB8D},
{ 0x85E5 , 0xCB8E},
{ 0x85E6 , 0xCB8F},
{ 0x85E7 , 0xCB90},
{ 0x85E8 , 0xCB91},
{ 0x85EA , 0xCB92},
{ 0x85EB , 0xCB93},
{ 0x85EC , 0xCB94},
{ 0x85ED , 0xCB95},
{ 0x85EE , 0xCB96},
{ 0x85EF , 0xCB97},
{ 0x85F0 , 0xCB98},
{ 0x85F1 , 0xCB99},
{ 0x85F2 , 0xCB9A},
{ 0x85F3 , 0xCB9B},
{ 0x85F4 , 0xCB9C},
{ 0x85F5 , 0xCB9D},
{ 0x85F6 , 0xCB9E},
{ 0x85F7 , 0xCB9F},
{ 0x85F8 , 0xCBA0},
{ 0x6055 , 0xCBA1},
{ 0x5237 , 0xCBA2},
{ 0x800D , 0xCBA3},
{ 0x6454 , 0xCBA4},
{ 0x8870 , 0xCBA5},
{ 0x7529 , 0xCBA6},
{ 0x5E05 , 0xCBA7},
{ 0x6813 , 0xCBA8},
{ 0x62F4 , 0xCBA9},
{ 0x971C , 0xCBAA},
{ 0x53CC , 0xCBAB},
{ 0x723D , 0xCBAC},
{ 0x8C01 , 0xCBAD},
{ 0x6C34 , 0xCBAE},
{ 0x7761 , 0xCBAF},
{ 0x7A0E , 0xCBB0},
{ 0x542E , 0xCBB1},
{ 0x77AC , 0xCBB2},
{ 0x987A , 0xCBB3},
{ 0x821C , 0xCBB4},
{ 0x8BF4 , 0xCBB5},
{ 0x7855 , 0xCBB6},
{ 0x6714 , 0xCBB7},
{ 0x70C1 , 0xCBB8},
{ 0x65AF , 0xCBB9},
{ 0x6495 , 0xCBBA},
{ 0x5636 , 0xCBBB},
{ 0x601D , 0xCBBC},
{ 0x79C1 , 0xCBBD},
{ 0x53F8 , 0xCBBE},
{ 0x4E1D , 0xCBBF},
{ 0x6B7B , 0xCBC0},
{ 0x8086 , 0xCBC1},
{ 0x5BFA , 0xCBC2},
{ 0x55E3 , 0xCBC3},
{ 0x56DB , 0xCBC4},
{ 0x4F3A , 0xCBC5},
{ 0x4F3C , 0xCBC6},
{ 0x9972 , 0xCBC7},
{ 0x5DF3 , 0xCBC8},
{ 0x677E , 0xCBC9},
{ 0x8038 , 0xCBCA},
{ 0x6002 , 0xCBCB},
{ 0x9882 , 0xCBCC},
{ 0x9001 , 0xCBCD},
{ 0x5B8B , 0xCBCE},
{ 0x8BBC , 0xCBCF},
{ 0x8BF5 , 0xCBD0},
{ 0x641C , 0xCBD1},
{ 0x8258 , 0xCBD2},
{ 0x64DE , 0xCBD3},
{ 0x55FD , 0xCBD4},
{ 0x82CF , 0xCBD5},
{ 0x9165 , 0xCBD6},
{ 0x4FD7 , 0xCBD7},
{ 0x7D20 , 0xCBD8},
{ 0x901F , 0xCBD9},
{ 0x7C9F , 0xCBDA},
{ 0x50F3 , 0xCBDB},
{ 0x5851 , 0xCBDC},
{ 0x6EAF , 0xCBDD},
{ 0x5BBF , 0xCBDE},
{ 0x8BC9 , 0xCBDF},
{ 0x8083 , 0xCBE0},
{ 0x9178 , 0xCBE1},
{ 0x849C , 0xCBE2},
{ 0x7B97 , 0xCBE3},
{ 0x867D , 0xCBE4},
{ 0x968B , 0xCBE5},
{ 0x968F , 0xCBE6},
{ 0x7EE5 , 0xCBE7},
{ 0x9AD3 , 0xCBE8},
{ 0x788E , 0xCBE9},
{ 0x5C81 , 0xCBEA},
{ 0x7A57 , 0xCBEB},
{ 0x9042 , 0xCBEC},
{ 0x96A7 , 0xCBED},
{ 0x795F , 0xCBEE},
{ 0x5B59 , 0xCBEF},
{ 0x635F , 0xCBF0},
{ 0x7B0B , 0xCBF1},
{ 0x84D1 , 0xCBF2},
{ 0x68AD , 0xCBF3},
{ 0x5506 , 0xCBF4},
{ 0x7F29 , 0xCBF5},
{ 0x7410 , 0xCBF6},
{ 0x7D22 , 0xCBF7},
{ 0x9501 , 0xCBF8},
{ 0x6240 , 0xCBF9},
{ 0x584C , 0xCBFA},
{ 0x4ED6 , 0xCBFB},
{ 0x5B83 , 0xCBFC},
{ 0x5979 , 0xCBFD},
{ 0x5854 , 0xCBFE},
{ 0x85F9 , 0xCC40},
{ 0x85FA , 0xCC41},
{ 0x85FC , 0xCC42},
{ 0x85FD , 0xCC43},
{ 0x85FE , 0xCC44},
{ 0x8600 , 0xCC45},
{ 0x8601 , 0xCC46},
{ 0x8602 , 0xCC47},
{ 0x8603 , 0xCC48},
{ 0x8604 , 0xCC49},
{ 0x8606 , 0xCC4A},
{ 0x8607 , 0xCC4B},
{ 0x8608 , 0xCC4C},
{ 0x8609 , 0xCC4D},
{ 0x860A , 0xCC4E},
{ 0x860B , 0xCC4F},
{ 0x860C , 0xCC50},
{ 0x860D , 0xCC51},
{ 0x860E , 0xCC52},
{ 0x860F , 0xCC53},
{ 0x8610 , 0xCC54},
{ 0x8612 , 0xCC55},
{ 0x8613 , 0xCC56},
{ 0x8614 , 0xCC57},
{ 0x8615 , 0xCC58},
{ 0x8617 , 0xCC59},
{ 0x8618 , 0xCC5A},
{ 0x8619 , 0xCC5B},
{ 0x861A , 0xCC5C},
{ 0x861B , 0xCC5D},
{ 0x861C , 0xCC5E},
{ 0x861D , 0xCC5F},
{ 0x861E , 0xCC60},
{ 0x861F , 0xCC61},
{ 0x8620 , 0xCC62},
{ 0x8621 , 0xCC63},
{ 0x8622 , 0xCC64},
{ 0x8623 , 0xCC65},
{ 0x8624 , 0xCC66},
{ 0x8625 , 0xCC67},
{ 0x8626 , 0xCC68},
{ 0x8628 , 0xCC69},
{ 0x862A , 0xCC6A},
{ 0x862B , 0xCC6B},
{ 0x862C , 0xCC6C},
{ 0x862D , 0xCC6D},
{ 0x862E , 0xCC6E},
{ 0x862F , 0xCC6F},
{ 0x8630 , 0xCC70},
{ 0x8631 , 0xCC71},
{ 0x8632 , 0xCC72},
{ 0x8633 , 0xCC73},
{ 0x8634 , 0xCC74},
{ 0x8635 , 0xCC75},
{ 0x8636 , 0xCC76},
{ 0x8637 , 0xCC77},
{ 0x8639 , 0xCC78},
{ 0x863A , 0xCC79},
{ 0x863B , 0xCC7A},
{ 0x863D , 0xCC7B},
{ 0x863E , 0xCC7C},
{ 0x863F , 0xCC7D},
{ 0x8640 , 0xCC7E},
{ 0x8641 , 0xCC80},
{ 0x8642 , 0xCC81},
{ 0x8643 , 0xCC82},
{ 0x8644 , 0xCC83},
{ 0x8645 , 0xCC84},
{ 0x8646 , 0xCC85},
{ 0x8647 , 0xCC86},
{ 0x8648 , 0xCC87},
{ 0x8649 , 0xCC88},
{ 0x864A , 0xCC89},
{ 0x864B , 0xCC8A},
{ 0x864C , 0xCC8B},
{ 0x8652 , 0xCC8C},
{ 0x8653 , 0xCC8D},
{ 0x8655 , 0xCC8E},
{ 0x8656 , 0xCC8F},
{ 0x8657 , 0xCC90},
{ 0x8658 , 0xCC91},
{ 0x8659 , 0xCC92},
{ 0x865B , 0xCC93},
{ 0x865C , 0xCC94},
{ 0x865D , 0xCC95},
{ 0x865F , 0xCC96},
{ 0x8660 , 0xCC97},
{ 0x8661 , 0xCC98},
{ 0x8663 , 0xCC99},
{ 0x8664 , 0xCC9A},
{ 0x8665 , 0xCC9B},
{ 0x8666 , 0xCC9C},
{ 0x8667 , 0xCC9D},
{ 0x8668 , 0xCC9E},
{ 0x8669 , 0xCC9F},
{ 0x866A , 0xCCA0},
{ 0x736D , 0xCCA1},
{ 0x631E , 0xCCA2},
{ 0x8E4B , 0xCCA3},
{ 0x8E0F , 0xCCA4},
{ 0x80CE , 0xCCA5},
{ 0x82D4 , 0xCCA6},
{ 0x62AC , 0xCCA7},
{ 0x53F0 , 0xCCA8},
{ 0x6CF0 , 0xCCA9},
{ 0x915E , 0xCCAA},
{ 0x592A , 0xCCAB},
{ 0x6001 , 0xCCAC},
{ 0x6C70 , 0xCCAD},
{ 0x574D , 0xCCAE},
{ 0x644A , 0xCCAF},
{ 0x8D2A , 0xCCB0},
{ 0x762B , 0xCCB1},
{ 0x6EE9 , 0xCCB2},
{ 0x575B , 0xCCB3},
{ 0x6A80 , 0xCCB4},
{ 0x75F0 , 0xCCB5},
{ 0x6F6D , 0xCCB6},
{ 0x8C2D , 0xCCB7},
{ 0x8C08 , 0xCCB8},
{ 0x5766 , 0xCCB9},
{ 0x6BEF , 0xCCBA},
{ 0x8892 , 0xCCBB},
{ 0x78B3 , 0xCCBC},
{ 0x63A2 , 0xCCBD},
{ 0x53F9 , 0xCCBE},
{ 0x70AD , 0xCCBF},
{ 0x6C64 , 0xCCC0},
{ 0x5858 , 0xCCC1},
{ 0x642A , 0xCCC2},
{ 0x5802 , 0xCCC3},
{ 0x68E0 , 0xCCC4},
{ 0x819B , 0xCCC5},
{ 0x5510 , 0xCCC6},
{ 0x7CD6 , 0xCCC7},
{ 0x5018 , 0xCCC8},
{ 0x8EBA , 0xCCC9},
{ 0x6DCC , 0xCCCA},
{ 0x8D9F , 0xCCCB},
{ 0x70EB , 0xCCCC},
{ 0x638F , 0xCCCD},
{ 0x6D9B , 0xCCCE},
{ 0x6ED4 , 0xCCCF},
{ 0x7EE6 , 0xCCD0},
{ 0x8404 , 0xCCD1},
{ 0x6843 , 0xCCD2},
{ 0x9003 , 0xCCD3},
{ 0x6DD8 , 0xCCD4},
{ 0x9676 , 0xCCD5},
{ 0x8BA8 , 0xCCD6},
{ 0x5957 , 0xCCD7},
{ 0x7279 , 0xCCD8},
{ 0x85E4 , 0xCCD9},
{ 0x817E , 0xCCDA},
{ 0x75BC , 0xCCDB},
{ 0x8A8A , 0xCCDC},
{ 0x68AF , 0xCCDD},
{ 0x5254 , 0xCCDE},
{ 0x8E22 , 0xCCDF},
{ 0x9511 , 0xCCE0},
{ 0x63D0 , 0xCCE1},
{ 0x9898 , 0xCCE2},
{ 0x8E44 , 0xCCE3},
{ 0x557C , 0xCCE4},
{ 0x4F53 , 0xCCE5},
{ 0x66FF , 0xCCE6},
{ 0x568F , 0xCCE7},
{ 0x60D5 , 0xCCE8},
{ 0x6D95 , 0xCCE9},
{ 0x5243 , 0xCCEA},
{ 0x5C49 , 0xCCEB},
{ 0x5929 , 0xCCEC},
{ 0x6DFB , 0xCCED},
{ 0x586B , 0xCCEE},
{ 0x7530 , 0xCCEF},
{ 0x751C , 0xCCF0},
{ 0x606C , 0xCCF1},
{ 0x8214 , 0xCCF2},
{ 0x8146 , 0xCCF3},
{ 0x6311 , 0xCCF4},
{ 0x6761 , 0xCCF5},
{ 0x8FE2 , 0xCCF6},
{ 0x773A , 0xCCF7},
{ 0x8DF3 , 0xCCF8},
{ 0x8D34 , 0xCCF9},
{ 0x94C1 , 0xCCFA},
{ 0x5E16 , 0xCCFB},
{ 0x5385 , 0xCCFC},
{ 0x542C , 0xCCFD},
{ 0x70C3 , 0xCCFE},
{ 0x866D , 0xCD40},
{ 0x866F , 0xCD41},
{ 0x8670 , 0xCD42},
{ 0x8672 , 0xCD43},
{ 0x8673 , 0xCD44},
{ 0x8674 , 0xCD45},
{ 0x8675 , 0xCD46},
{ 0x8676 , 0xCD47},
{ 0x8677 , 0xCD48},
{ 0x8678 , 0xCD49},
{ 0x8683 , 0xCD4A},
{ 0x8684 , 0xCD4B},
{ 0x8685 , 0xCD4C},
{ 0x8686 , 0xCD4D},
{ 0x8687 , 0xCD4E},
{ 0x8688 , 0xCD4F},
{ 0x8689 , 0xCD50},
{ 0x868E , 0xCD51},
{ 0x868F , 0xCD52},
{ 0x8690 , 0xCD53},
{ 0x8691 , 0xCD54},
{ 0x8692 , 0xCD55},
{ 0x8694 , 0xCD56},
{ 0x8696 , 0xCD57},
{ 0x8697 , 0xCD58},
{ 0x8698 , 0xCD59},
{ 0x8699 , 0xCD5A},
{ 0x869A , 0xCD5B},
{ 0x869B , 0xCD5C},
{ 0x869E , 0xCD5D},
{ 0x869F , 0xCD5E},
{ 0x86A0 , 0xCD5F},
{ 0x86A1 , 0xCD60},
{ 0x86A2 , 0xCD61},
{ 0x86A5 , 0xCD62},
{ 0x86A6 , 0xCD63},
{ 0x86AB , 0xCD64},
{ 0x86AD , 0xCD65},
{ 0x86AE , 0xCD66},
{ 0x86B2 , 0xCD67},
{ 0x86B3 , 0xCD68},
{ 0x86B7 , 0xCD69},
{ 0x86B8 , 0xCD6A},
{ 0x86B9 , 0xCD6B},
{ 0x86BB , 0xCD6C},
{ 0x86BC , 0xCD6D},
{ 0x86BD , 0xCD6E},
{ 0x86BE , 0xCD6F},
{ 0x86BF , 0xCD70},
{ 0x86C1 , 0xCD71},
{ 0x86C2 , 0xCD72},
{ 0x86C3 , 0xCD73},
{ 0x86C5 , 0xCD74},
{ 0x86C8 , 0xCD75},
{ 0x86CC , 0xCD76},
{ 0x86CD , 0xCD77},
{ 0x86D2 , 0xCD78},
{ 0x86D3 , 0xCD79},
{ 0x86D5 , 0xCD7A},
{ 0x86D6 , 0xCD7B},
{ 0x86D7 , 0xCD7C},
{ 0x86DA , 0xCD7D},
{ 0x86DC , 0xCD7E},
{ 0x86DD , 0xCD80},
{ 0x86E0 , 0xCD81},
{ 0x86E1 , 0xCD82},
{ 0x86E2 , 0xCD83},
{ 0x86E3 , 0xCD84},
{ 0x86E5 , 0xCD85},
{ 0x86E6 , 0xCD86},
{ 0x86E7 , 0xCD87},
{ 0x86E8 , 0xCD88},
{ 0x86EA , 0xCD89},
{ 0x86EB , 0xCD8A},
{ 0x86EC , 0xCD8B},
{ 0x86EF , 0xCD8C},
{ 0x86F5 , 0xCD8D},
{ 0x86F6 , 0xCD8E},
{ 0x86F7 , 0xCD8F},
{ 0x86FA , 0xCD90},
{ 0x86FB , 0xCD91},
{ 0x86FC , 0xCD92},
{ 0x86FD , 0xCD93},
{ 0x86FF , 0xCD94},
{ 0x8701 , 0xCD95},
{ 0x8704 , 0xCD96},
{ 0x8705 , 0xCD97},
{ 0x8706 , 0xCD98},
{ 0x870B , 0xCD99},
{ 0x870C , 0xCD9A},
{ 0x870E , 0xCD9B},
{ 0x870F , 0xCD9C},
{ 0x8710 , 0xCD9D},
{ 0x8711 , 0xCD9E},
{ 0x8714 , 0xCD9F},
{ 0x8716 , 0xCDA0},
{ 0x6C40 , 0xCDA1},
{ 0x5EF7 , 0xCDA2},
{ 0x505C , 0xCDA3},
{ 0x4EAD , 0xCDA4},
{ 0x5EAD , 0xCDA5},
{ 0x633A , 0xCDA6},
{ 0x8247 , 0xCDA7},
{ 0x901A , 0xCDA8},
{ 0x6850 , 0xCDA9},
{ 0x916E , 0xCDAA},
{ 0x77B3 , 0xCDAB},
{ 0x540C , 0xCDAC},
{ 0x94DC , 0xCDAD},
{ 0x5F64 , 0xCDAE},
{ 0x7AE5 , 0xCDAF},
{ 0x6876 , 0xCDB0},
{ 0x6345 , 0xCDB1},
{ 0x7B52 , 0xCDB2},
{ 0x7EDF , 0xCDB3},
{ 0x75DB , 0xCDB4},
{ 0x5077 , 0xCDB5},
{ 0x6295 , 0xCDB6},
{ 0x5934 , 0xCDB7},
{ 0x900F , 0xCDB8},
{ 0x51F8 , 0xCDB9},
{ 0x79C3 , 0xCDBA},
{ 0x7A81 , 0xCDBB},
{ 0x56FE , 0xCDBC},
{ 0x5F92 , 0xCDBD},
{ 0x9014 , 0xCDBE},
{ 0x6D82 , 0xCDBF},
{ 0x5C60 , 0xCDC0},
{ 0x571F , 0xCDC1},
{ 0x5410 , 0xCDC2},
{ 0x5154 , 0xCDC3},
{ 0x6E4D , 0xCDC4},
{ 0x56E2 , 0xCDC5},
{ 0x63A8 , 0xCDC6},
{ 0x9893 , 0xCDC7},
{ 0x817F , 0xCDC8},
{ 0x8715 , 0xCDC9},
{ 0x892A , 0xCDCA},
{ 0x9000 , 0xCDCB},
{ 0x541E , 0xCDCC},
{ 0x5C6F , 0xCDCD},
{ 0x81C0 , 0xCDCE},
{ 0x62D6 , 0xCDCF},
{ 0x6258 , 0xCDD0},
{ 0x8131 , 0xCDD1},
{ 0x9E35 , 0xCDD2},
{ 0x9640 , 0xCDD3},
{ 0x9A6E , 0xCDD4},
{ 0x9A7C , 0xCDD5},
{ 0x692D , 0xCDD6},
{ 0x59A5 , 0xCDD7},
{ 0x62D3 , 0xCDD8},
{ 0x553E , 0xCDD9},
{ 0x6316 , 0xCDDA},
{ 0x54C7 , 0xCDDB},
{ 0x86D9 , 0xCDDC},
{ 0x6D3C , 0xCDDD},
{ 0x5A03 , 0xCDDE},
{ 0x74E6 , 0xCDDF},
{ 0x889C , 0xCDE0},
{ 0x6B6A , 0xCDE1},
{ 0x5916 , 0xCDE2},
{ 0x8C4C , 0xCDE3},
{ 0x5F2F , 0xCDE4},
{ 0x6E7E , 0xCDE5},
{ 0x73A9 , 0xCDE6},
{ 0x987D , 0xCDE7},
{ 0x4E38 , 0xCDE8},
{ 0x70F7 , 0xCDE9},
{ 0x5B8C , 0xCDEA},
{ 0x7897 , 0xCDEB},
{ 0x633D , 0xCDEC},
{ 0x665A , 0xCDED},
{ 0x7696 , 0xCDEE},
{ 0x60CB , 0xCDEF},
{ 0x5B9B , 0xCDF0},
{ 0x5A49 , 0xCDF1},
{ 0x4E07 , 0xCDF2},
{ 0x8155 , 0xCDF3},
{ 0x6C6A , 0xCDF4},
{ 0x738B , 0xCDF5},
{ 0x4EA1 , 0xCDF6},
{ 0x6789 , 0xCDF7},
{ 0x7F51 , 0xCDF8},
{ 0x5F80 , 0xCDF9},
{ 0x65FA , 0xCDFA},
{ 0x671B , 0xCDFB},
{ 0x5FD8 , 0xCDFC},
{ 0x5984 , 0xCDFD},
{ 0x5A01 , 0xCDFE},
{ 0x8719 , 0xCE40},
{ 0x871B , 0xCE41},
{ 0x871D , 0xCE42},
{ 0x871F , 0xCE43},
{ 0x8720 , 0xCE44},
{ 0x8724 , 0xCE45},
{ 0x8726 , 0xCE46},
{ 0x8727 , 0xCE47},
{ 0x8728 , 0xCE48},
{ 0x872A , 0xCE49},
{ 0x872B , 0xCE4A},
{ 0x872C , 0xCE4B},
{ 0x872D , 0xCE4C},
{ 0x872F , 0xCE4D},
{ 0x8730 , 0xCE4E},
{ 0x8732 , 0xCE4F},
{ 0x8733 , 0xCE50},
{ 0x8735 , 0xCE51},
{ 0x8736 , 0xCE52},
{ 0x8738 , 0xCE53},
{ 0x8739 , 0xCE54},
{ 0x873A , 0xCE55},
{ 0x873C , 0xCE56},
{ 0x873D , 0xCE57},
{ 0x8740 , 0xCE58},
{ 0x8741 , 0xCE59},
{ 0x8742 , 0xCE5A},
{ 0x8743 , 0xCE5B},
{ 0x8744 , 0xCE5C},
{ 0x8745 , 0xCE5D},
{ 0x8746 , 0xCE5E},
{ 0x874A , 0xCE5F},
{ 0x874B , 0xCE60},
{ 0x874D , 0xCE61},
{ 0x874F , 0xCE62},
{ 0x8750 , 0xCE63},
{ 0x8751 , 0xCE64},
{ 0x8752 , 0xCE65},
{ 0x8754 , 0xCE66},
{ 0x8755 , 0xCE67},
{ 0x8756 , 0xCE68},
{ 0x8758 , 0xCE69},
{ 0x875A , 0xCE6A},
{ 0x875B , 0xCE6B},
{ 0x875C , 0xCE6C},
{ 0x875D , 0xCE6D},
{ 0x875E , 0xCE6E},
{ 0x875F , 0xCE6F},
{ 0x8761 , 0xCE70},
{ 0x8762 , 0xCE71},
{ 0x8766 , 0xCE72},
{ 0x8767 , 0xCE73},
{ 0x8768 , 0xCE74},
{ 0x8769 , 0xCE75},
{ 0x876A , 0xCE76},
{ 0x876B , 0xCE77},
{ 0x876C , 0xCE78},
{ 0x876D , 0xCE79},
{ 0x876F , 0xCE7A},
{ 0x8771 , 0xCE7B},
{ 0x8772 , 0xCE7C},
{ 0x8773 , 0xCE7D},
{ 0x8775 , 0xCE7E},
{ 0x8777 , 0xCE80},
{ 0x8778 , 0xCE81},
{ 0x8779 , 0xCE82},
{ 0x877A , 0xCE83},
{ 0x877F , 0xCE84},
{ 0x8780 , 0xCE85},
{ 0x8781 , 0xCE86},
{ 0x8784 , 0xCE87},
{ 0x8786 , 0xCE88},
{ 0x8787 , 0xCE89},
{ 0x8789 , 0xCE8A},
{ 0x878A , 0xCE8B},
{ 0x878C , 0xCE8C},
{ 0x878E , 0xCE8D},
{ 0x878F , 0xCE8E},
{ 0x8790 , 0xCE8F},
{ 0x8791 , 0xCE90},
{ 0x8792 , 0xCE91},
{ 0x8794 , 0xCE92},
{ 0x8795 , 0xCE93},
{ 0x8796 , 0xCE94},
{ 0x8798 , 0xCE95},
{ 0x8799 , 0xCE96},
{ 0x879A , 0xCE97},
{ 0x879B , 0xCE98},
{ 0x879C , 0xCE99},
{ 0x879D , 0xCE9A},
{ 0x879E , 0xCE9B},
{ 0x87A0 , 0xCE9C},
{ 0x87A1 , 0xCE9D},
{ 0x87A2 , 0xCE9E},
{ 0x87A3 , 0xCE9F},
{ 0x87A4 , 0xCEA0},
{ 0x5DCD , 0xCEA1},
{ 0x5FAE , 0xCEA2},
{ 0x5371 , 0xCEA3},
{ 0x97E6 , 0xCEA4},
{ 0x8FDD , 0xCEA5},
{ 0x6845 , 0xCEA6},
{ 0x56F4 , 0xCEA7},
{ 0x552F , 0xCEA8},
{ 0x60DF , 0xCEA9},
{ 0x4E3A , 0xCEAA},
{ 0x6F4D , 0xCEAB},
{ 0x7EF4 , 0xCEAC},
{ 0x82C7 , 0xCEAD},
{ 0x840E , 0xCEAE},
{ 0x59D4 , 0xCEAF},
{ 0x4F1F , 0xCEB0},
{ 0x4F2A , 0xCEB1},
{ 0x5C3E , 0xCEB2},
{ 0x7EAC , 0xCEB3},
{ 0x672A , 0xCEB4},
{ 0x851A , 0xCEB5},
{ 0x5473 , 0xCEB6},
{ 0x754F , 0xCEB7},
{ 0x80C3 , 0xCEB8},
{ 0x5582 , 0xCEB9},
{ 0x9B4F , 0xCEBA},
{ 0x4F4D , 0xCEBB},
{ 0x6E2D , 0xCEBC},
{ 0x8C13 , 0xCEBD},
{ 0x5C09 , 0xCEBE},
{ 0x6170 , 0xCEBF},
{ 0x536B , 0xCEC0},
{ 0x761F , 0xCEC1},
{ 0x6E29 , 0xCEC2},
{ 0x868A , 0xCEC3},
{ 0x6587 , 0xCEC4},
{ 0x95FB , 0xCEC5},
{ 0x7EB9 , 0xCEC6},
{ 0x543B , 0xCEC7},
{ 0x7A33 , 0xCEC8},
{ 0x7D0A , 0xCEC9},
{ 0x95EE , 0xCECA},
{ 0x55E1 , 0xCECB},
{ 0x7FC1 , 0xCECC},
{ 0x74EE , 0xCECD},
{ 0x631D , 0xCECE},
{ 0x8717 , 0xCECF},
{ 0x6DA1 , 0xCED0},
{ 0x7A9D , 0xCED1},
{ 0x6211 , 0xCED2},
{ 0x65A1 , 0xCED3},
{ 0x5367 , 0xCED4},
{ 0x63E1 , 0xCED5},
{ 0x6C83 , 0xCED6},
{ 0x5DEB , 0xCED7},
{ 0x545C , 0xCED8},
{ 0x94A8 , 0xCED9},
{ 0x4E4C , 0xCEDA},
{ 0x6C61 , 0xCEDB},
{ 0x8BEC , 0xCEDC},
{ 0x5C4B , 0xCEDD},
{ 0x65E0 , 0xCEDE},
{ 0x829C , 0xCEDF},
{ 0x68A7 , 0xCEE0},
{ 0x543E , 0xCEE1},
{ 0x5434 , 0xCEE2},
{ 0x6BCB , 0xCEE3},
{ 0x6B66 , 0xCEE4},
{ 0x4E94 , 0xCEE5},
{ 0x6342 , 0xCEE6},
{ 0x5348 , 0xCEE7},
{ 0x821E , 0xCEE8},
{ 0x4F0D , 0xCEE9},
{ 0x4FAE , 0xCEEA},
{ 0x575E , 0xCEEB},
{ 0x620A , 0xCEEC},
{ 0x96FE , 0xCEED},
{ 0x6664 , 0xCEEE},
{ 0x7269 , 0xCEEF},
{ 0x52FF , 0xCEF0},
{ 0x52A1 , 0xCEF1},
{ 0x609F , 0xCEF2},
{ 0x8BEF , 0xCEF3},
{ 0x6614 , 0xCEF4},
{ 0x7199 , 0xCEF5},
{ 0x6790 , 0xCEF6},
{ 0x897F , 0xCEF7},
{ 0x7852 , 0xCEF8},
{ 0x77FD , 0xCEF9},
{ 0x6670 , 0xCEFA},
{ 0x563B , 0xCEFB},
{ 0x5438 , 0xCEFC},
{ 0x9521 , 0xCEFD},
{ 0x727A , 0xCEFE},
{ 0x87A5 , 0xCF40},
{ 0x87A6 , 0xCF41},
{ 0x87A7 , 0xCF42},
{ 0x87A9 , 0xCF43},
{ 0x87AA , 0xCF44},
{ 0x87AE , 0xCF45},
{ 0x87B0 , 0xCF46},
{ 0x87B1 , 0xCF47},
{ 0x87B2 , 0xCF48},
{ 0x87B4 , 0xCF49},
{ 0x87B6 , 0xCF4A},
{ 0x87B7 , 0xCF4B},
{ 0x87B8 , 0xCF4C},
{ 0x87B9 , 0xCF4D},
{ 0x87BB , 0xCF4E},
{ 0x87BC , 0xCF4F},
{ 0x87BE , 0xCF50},
{ 0x87BF , 0xCF51},
{ 0x87C1 , 0xCF52},
{ 0x87C2 , 0xCF53},
{ 0x87C3 , 0xCF54},
{ 0x87C4 , 0xCF55},
{ 0x87C5 , 0xCF56},
{ 0x87C7 , 0xCF57},
{ 0x87C8 , 0xCF58},
{ 0x87C9 , 0xCF59},
{ 0x87CC , 0xCF5A},
{ 0x87CD , 0xCF5B},
{ 0x87CE , 0xCF5C},
{ 0x87CF , 0xCF5D},
{ 0x87D0 , 0xCF5E},
{ 0x87D4 , 0xCF5F},
{ 0x87D5 , 0xCF60},
{ 0x87D6 , 0xCF61},
{ 0x87D7 , 0xCF62},
{ 0x87D8 , 0xCF63},
{ 0x87D9 , 0xCF64},
{ 0x87DA , 0xCF65},
{ 0x87DC , 0xCF66},
{ 0x87DD , 0xCF67},
{ 0x87DE , 0xCF68},
{ 0x87DF , 0xCF69},
{ 0x87E1 , 0xCF6A},
{ 0x87E2 , 0xCF6B},
{ 0x87E3 , 0xCF6C},
{ 0x87E4 , 0xCF6D},
{ 0x87E6 , 0xCF6E},
{ 0x87E7 , 0xCF6F},
{ 0x87E8 , 0xCF70},
{ 0x87E9 , 0xCF71},
{ 0x87EB , 0xCF72},
{ 0x87EC , 0xCF73},
{ 0x87ED , 0xCF74},
{ 0x87EF , 0xCF75},
{ 0x87F0 , 0xCF76},
{ 0x87F1 , 0xCF77},
{ 0x87F2 , 0xCF78},
{ 0x87F3 , 0xCF79},
{ 0x87F4 , 0xCF7A},
{ 0x87F5 , 0xCF7B},
{ 0x87F6 , 0xCF7C},
{ 0x87F7 , 0xCF7D},
{ 0x87F8 , 0xCF7E},
{ 0x87FA , 0xCF80},
{ 0x87FB , 0xCF81},
{ 0x87FC , 0xCF82},
{ 0x87FD , 0xCF83},
{ 0x87FF , 0xCF84},
{ 0x8800 , 0xCF85},
{ 0x8801 , 0xCF86},
{ 0x8802 , 0xCF87},
{ 0x8804 , 0xCF88},
{ 0x8805 , 0xCF89},
{ 0x8806 , 0xCF8A},
{ 0x8807 , 0xCF8B},
{ 0x8808 , 0xCF8C},
{ 0x8809 , 0xCF8D},
{ 0x880B , 0xCF8E},
{ 0x880C , 0xCF8F},
{ 0x880D , 0xCF90},
{ 0x880E , 0xCF91},
{ 0x880F , 0xCF92},
{ 0x8810 , 0xCF93},
{ 0x8811 , 0xCF94},
{ 0x8812 , 0xCF95},
{ 0x8814 , 0xCF96},
{ 0x8817 , 0xCF97},
{ 0x8818 , 0xCF98},
{ 0x8819 , 0xCF99},
{ 0x881A , 0xCF9A},
{ 0x881C , 0xCF9B},
{ 0x881D , 0xCF9C},
{ 0x881E , 0xCF9D},
{ 0x881F , 0xCF9E},
{ 0x8820 , 0xCF9F},
{ 0x8823 , 0xCFA0},
{ 0x7A00 , 0xCFA1},
{ 0x606F , 0xCFA2},
{ 0x5E0C , 0xCFA3},
{ 0x6089 , 0xCFA4},
{ 0x819D , 0xCFA5},
{ 0x5915 , 0xCFA6},
{ 0x60DC , 0xCFA7},
{ 0x7184 , 0xCFA8},
{ 0x70EF , 0xCFA9},
{ 0x6EAA , 0xCFAA},
{ 0x6C50 , 0xCFAB},
{ 0x7280 , 0xCFAC},
{ 0x6A84 , 0xCFAD},
{ 0x88AD , 0xCFAE},
{ 0x5E2D , 0xCFAF},
{ 0x4E60 , 0xCFB0},
{ 0x5AB3 , 0xCFB1},
{ 0x559C , 0xCFB2},
{ 0x94E3 , 0xCFB3},
{ 0x6D17 , 0xCFB4},
{ 0x7CFB , 0xCFB5},
{ 0x9699 , 0xCFB6},
{ 0x620F , 0xCFB7},
{ 0x7EC6 , 0xCFB8},
{ 0x778E , 0xCFB9},
{ 0x867E , 0xCFBA},
{ 0x5323 , 0xCFBB},
{ 0x971E , 0xCFBC},
{ 0x8F96 , 0xCFBD},
{ 0x6687 , 0xCFBE},
{ 0x5CE1 , 0xCFBF},
{ 0x4FA0 , 0xCFC0},
{ 0x72ED , 0xCFC1},
{ 0x4E0B , 0xCFC2},
{ 0x53A6 , 0xCFC3},
{ 0x590F , 0xCFC4},
{ 0x5413 , 0xCFC5},
{ 0x6380 , 0xCFC6},
{ 0x9528 , 0xCFC7},
{ 0x5148 , 0xCFC8},
{ 0x4ED9 , 0xCFC9},
{ 0x9C9C , 0xCFCA},
{ 0x7EA4 , 0xCFCB},
{ 0x54B8 , 0xCFCC},
{ 0x8D24 , 0xCFCD},
{ 0x8854 , 0xCFCE},
{ 0x8237 , 0xCFCF},
{ 0x95F2 , 0xCFD0},
{ 0x6D8E , 0xCFD1},
{ 0x5F26 , 0xCFD2},
{ 0x5ACC , 0xCFD3},
{ 0x663E , 0xCFD4},
{ 0x9669 , 0xCFD5},
{ 0x73B0 , 0xCFD6},
{ 0x732E , 0xCFD7},
{ 0x53BF , 0xCFD8},
{ 0x817A , 0xCFD9},
{ 0x9985 , 0xCFDA},
{ 0x7FA1 , 0xCFDB},
{ 0x5BAA , 0xCFDC},
{ 0x9677 , 0xCFDD},
{ 0x9650 , 0xCFDE},
{ 0x7EBF , 0xCFDF},
{ 0x76F8 , 0xCFE0},
{ 0x53A2 , 0xCFE1},
{ 0x9576 , 0xCFE2},
{ 0x9999 , 0xCFE3},
{ 0x7BB1 , 0xCFE4},
{ 0x8944 , 0xCFE5},
{ 0x6E58 , 0xCFE6},
{ 0x4E61 , 0xCFE7},
{ 0x7FD4 , 0xCFE8},
{ 0x7965 , 0xCFE9},
{ 0x8BE6 , 0xCFEA},
{ 0x60F3 , 0xCFEB},
{ 0x54CD , 0xCFEC},
{ 0x4EAB , 0xCFED},
{ 0x9879 , 0xCFEE},
{ 0x5DF7 , 0xCFEF},
{ 0x6A61 , 0xCFF0},
{ 0x50CF , 0xCFF1},
{ 0x5411 , 0xCFF2},
{ 0x8C61 , 0xCFF3},
{ 0x8427 , 0xCFF4},
{ 0x785D , 0xCFF5},
{ 0x9704 , 0xCFF6},
{ 0x524A , 0xCFF7},
{ 0x54EE , 0xCFF8},
{ 0x56A3 , 0xCFF9},
{ 0x9500 , 0xCFFA},
{ 0x6D88 , 0xCFFB},
{ 0x5BB5 , 0xCFFC},
{ 0x6DC6 , 0xCFFD},
{ 0x6653 , 0xCFFE},
{ 0x8824 , 0xD040},
{ 0x8825 , 0xD041},
{ 0x8826 , 0xD042},
{ 0x8827 , 0xD043},
{ 0x8828 , 0xD044},
{ 0x8829 , 0xD045},
{ 0x882A , 0xD046},
{ 0x882B , 0xD047},
{ 0x882C , 0xD048},
{ 0x882D , 0xD049},
{ 0x882E , 0xD04A},
{ 0x882F , 0xD04B},
{ 0x8830 , 0xD04C},
{ 0x8831 , 0xD04D},
{ 0x8833 , 0xD04E},
{ 0x8834 , 0xD04F},
{ 0x8835 , 0xD050},
{ 0x8836 , 0xD051},
{ 0x8837 , 0xD052},
{ 0x8838 , 0xD053},
{ 0x883A , 0xD054},
{ 0x883B , 0xD055},
{ 0x883D , 0xD056},
{ 0x883E , 0xD057},
{ 0x883F , 0xD058},
{ 0x8841 , 0xD059},
{ 0x8842 , 0xD05A},
{ 0x8843 , 0xD05B},
{ 0x8846 , 0xD05C},
{ 0x8847 , 0xD05D},
{ 0x8848 , 0xD05E},
{ 0x8849 , 0xD05F},
{ 0x884A , 0xD060},
{ 0x884B , 0xD061},
{ 0x884E , 0xD062},
{ 0x884F , 0xD063},
{ 0x8850 , 0xD064},
{ 0x8851 , 0xD065},
{ 0x8852 , 0xD066},
{ 0x8853 , 0xD067},
{ 0x8855 , 0xD068},
{ 0x8856 , 0xD069},
{ 0x8858 , 0xD06A},
{ 0x885A , 0xD06B},
{ 0x885B , 0xD06C},
{ 0x885C , 0xD06D},
{ 0x885D , 0xD06E},
{ 0x885E , 0xD06F},
{ 0x885F , 0xD070},
{ 0x8860 , 0xD071},
{ 0x8866 , 0xD072},
{ 0x8867 , 0xD073},
{ 0x886A , 0xD074},
{ 0x886D , 0xD075},
{ 0x886F , 0xD076},
{ 0x8871 , 0xD077},
{ 0x8873 , 0xD078},
{ 0x8874 , 0xD079},
{ 0x8875 , 0xD07A},
{ 0x8876 , 0xD07B},
{ 0x8878 , 0xD07C},
{ 0x8879 , 0xD07D},
{ 0x887A , 0xD07E},
{ 0x887B , 0xD080},
{ 0x887C , 0xD081},
{ 0x8880 , 0xD082},
{ 0x8883 , 0xD083},
{ 0x8886 , 0xD084},
{ 0x8887 , 0xD085},
{ 0x8889 , 0xD086},
{ 0x888A , 0xD087},
{ 0x888C , 0xD088},
{ 0x888E , 0xD089},
{ 0x888F , 0xD08A},
{ 0x8890 , 0xD08B},
{ 0x8891 , 0xD08C},
{ 0x8893 , 0xD08D},
{ 0x8894 , 0xD08E},
{ 0x8895 , 0xD08F},
{ 0x8897 , 0xD090},
{ 0x8898 , 0xD091},
{ 0x8899 , 0xD092},
{ 0x889A , 0xD093},
{ 0x889B , 0xD094},
{ 0x889D , 0xD095},
{ 0x889E , 0xD096},
{ 0x889F , 0xD097},
{ 0x88A0 , 0xD098},
{ 0x88A1 , 0xD099},
{ 0x88A3 , 0xD09A},
{ 0x88A5 , 0xD09B},
{ 0x88A6 , 0xD09C},
{ 0x88A7 , 0xD09D},
{ 0x88A8 , 0xD09E},
{ 0x88A9 , 0xD09F},
{ 0x88AA , 0xD0A0},
{ 0x5C0F , 0xD0A1},
{ 0x5B5D , 0xD0A2},
{ 0x6821 , 0xD0A3},
{ 0x8096 , 0xD0A4},
{ 0x5578 , 0xD0A5},
{ 0x7B11 , 0xD0A6},
{ 0x6548 , 0xD0A7},
{ 0x6954 , 0xD0A8},
{ 0x4E9B , 0xD0A9},
{ 0x6B47 , 0xD0AA},
{ 0x874E , 0xD0AB},
{ 0x978B , 0xD0AC},
{ 0x534F , 0xD0AD},
{ 0x631F , 0xD0AE},
{ 0x643A , 0xD0AF},
{ 0x90AA , 0xD0B0},
{ 0x659C , 0xD0B1},
{ 0x80C1 , 0xD0B2},
{ 0x8C10 , 0xD0B3},
{ 0x5199 , 0xD0B4},
{ 0x68B0 , 0xD0B5},
{ 0x5378 , 0xD0B6},
{ 0x87F9 , 0xD0B7},
{ 0x61C8 , 0xD0B8},
{ 0x6CC4 , 0xD0B9},
{ 0x6CFB , 0xD0BA},
{ 0x8C22 , 0xD0BB},
{ 0x5C51 , 0xD0BC},
{ 0x85AA , 0xD0BD},
{ 0x82AF , 0xD0BE},
{ 0x950C , 0xD0BF},
{ 0x6B23 , 0xD0C0},
{ 0x8F9B , 0xD0C1},
{ 0x65B0 , 0xD0C2},
{ 0x5FFB , 0xD0C3},
{ 0x5FC3 , 0xD0C4},
{ 0x4FE1 , 0xD0C5},
{ 0x8845 , 0xD0C6},
{ 0x661F , 0xD0C7},
{ 0x8165 , 0xD0C8},
{ 0x7329 , 0xD0C9},
{ 0x60FA , 0xD0CA},
{ 0x5174 , 0xD0CB},
{ 0x5211 , 0xD0CC},
{ 0x578B , 0xD0CD},
{ 0x5F62 , 0xD0CE},
{ 0x90A2 , 0xD0CF},
{ 0x884C , 0xD0D0},
{ 0x9192 , 0xD0D1},
{ 0x5E78 , 0xD0D2},
{ 0x674F , 0xD0D3},
{ 0x6027 , 0xD0D4},
{ 0x59D3 , 0xD0D5},
{ 0x5144 , 0xD0D6},
{ 0x51F6 , 0xD0D7},
{ 0x80F8 , 0xD0D8},
{ 0x5308 , 0xD0D9},
{ 0x6C79 , 0xD0DA},
{ 0x96C4 , 0xD0DB},
{ 0x718A , 0xD0DC},
{ 0x4F11 , 0xD0DD},
{ 0x4FEE , 0xD0DE},
{ 0x7F9E , 0xD0DF},
{ 0x673D , 0xD0E0},
{ 0x55C5 , 0xD0E1},
{ 0x9508 , 0xD0E2},
{ 0x79C0 , 0xD0E3},
{ 0x8896 , 0xD0E4},
{ 0x7EE3 , 0xD0E5},
{ 0x589F , 0xD0E6},
{ 0x620C , 0xD0E7},
{ 0x9700 , 0xD0E8},
{ 0x865A , 0xD0E9},
{ 0x5618 , 0xD0EA},
{ 0x987B , 0xD0EB},
{ 0x5F90 , 0xD0EC},
{ 0x8BB8 , 0xD0ED},
{ 0x84C4 , 0xD0EE},
{ 0x9157 , 0xD0EF},
{ 0x53D9 , 0xD0F0},
{ 0x65ED , 0xD0F1},
{ 0x5E8F , 0xD0F2},
{ 0x755C , 0xD0F3},
{ 0x6064 , 0xD0F4},
{ 0x7D6E , 0xD0F5},
{ 0x5A7F , 0xD0F6},
{ 0x7EEA , 0xD0F7},
{ 0x7EED , 0xD0F8},
{ 0x8F69 , 0xD0F9},
{ 0x55A7 , 0xD0FA},
{ 0x5BA3 , 0xD0FB},
{ 0x60AC , 0xD0FC},
{ 0x65CB , 0xD0FD},
{ 0x7384 , 0xD0FE},
{ 0x88AC , 0xD140},
{ 0x88AE , 0xD141},
{ 0x88AF , 0xD142},
{ 0x88B0 , 0xD143},
{ 0x88B2 , 0xD144},
{ 0x88B3 , 0xD145},
{ 0x88B4 , 0xD146},
{ 0x88B5 , 0xD147},
{ 0x88B6 , 0xD148},
{ 0x88B8 , 0xD149},
{ 0x88B9 , 0xD14A},
{ 0x88BA , 0xD14B},
{ 0x88BB , 0xD14C},
{ 0x88BD , 0xD14D},
{ 0x88BE , 0xD14E},
{ 0x88BF , 0xD14F},
{ 0x88C0 , 0xD150},
{ 0x88C3 , 0xD151},
{ 0x88C4 , 0xD152},
{ 0x88C7 , 0xD153},
{ 0x88C8 , 0xD154},
{ 0x88CA , 0xD155},
{ 0x88CB , 0xD156},
{ 0x88CC , 0xD157},
{ 0x88CD , 0xD158},
{ 0x88CF , 0xD159},
{ 0x88D0 , 0xD15A},
{ 0x88D1 , 0xD15B},
{ 0x88D3 , 0xD15C},
{ 0x88D6 , 0xD15D},
{ 0x88D7 , 0xD15E},
{ 0x88DA , 0xD15F},
{ 0x88DB , 0xD160},
{ 0x88DC , 0xD161},
{ 0x88DD , 0xD162},
{ 0x88DE , 0xD163},
{ 0x88E0 , 0xD164},
{ 0x88E1 , 0xD165},
{ 0x88E6 , 0xD166},
{ 0x88E7 , 0xD167},
{ 0x88E9 , 0xD168},
{ 0x88EA , 0xD169},
{ 0x88EB , 0xD16A},
{ 0x88EC , 0xD16B},
{ 0x88ED , 0xD16C},
{ 0x88EE , 0xD16D},
{ 0x88EF , 0xD16E},
{ 0x88F2 , 0xD16F},
{ 0x88F5 , 0xD170},
{ 0x88F6 , 0xD171},
{ 0x88F7 , 0xD172},
{ 0x88FA , 0xD173},
{ 0x88FB , 0xD174},
{ 0x88FD , 0xD175},
{ 0x88FF , 0xD176},
{ 0x8900 , 0xD177},
{ 0x8901 , 0xD178},
{ 0x8903 , 0xD179},
{ 0x8904 , 0xD17A},
{ 0x8905 , 0xD17B},
{ 0x8906 , 0xD17C},
{ 0x8907 , 0xD17D},
{ 0x8908 , 0xD17E},
{ 0x8909 , 0xD180},
{ 0x890B , 0xD181},
{ 0x890C , 0xD182},
{ 0x890D , 0xD183},
{ 0x890E , 0xD184},
{ 0x890F , 0xD185},
{ 0x8911 , 0xD186},
{ 0x8914 , 0xD187},
{ 0x8915 , 0xD188},
{ 0x8916 , 0xD189},
{ 0x8917 , 0xD18A},
{ 0x8918 , 0xD18B},
{ 0x891C , 0xD18C},
{ 0x891D , 0xD18D},
{ 0x891E , 0xD18E},
{ 0x891F , 0xD18F},
{ 0x8920 , 0xD190},
{ 0x8922 , 0xD191},
{ 0x8923 , 0xD192},
{ 0x8924 , 0xD193},
{ 0x8926 , 0xD194},
{ 0x8927 , 0xD195},
{ 0x8928 , 0xD196},
{ 0x8929 , 0xD197},
{ 0x892C , 0xD198},
{ 0x892D , 0xD199},
{ 0x892E , 0xD19A},
{ 0x892F , 0xD19B},
{ 0x8931 , 0xD19C},
{ 0x8932 , 0xD19D},
{ 0x8933 , 0xD19E},
{ 0x8935 , 0xD19F},
{ 0x8937 , 0xD1A0},
{ 0x9009 , 0xD1A1},
{ 0x7663 , 0xD1A2},
{ 0x7729 , 0xD1A3},
{ 0x7EDA , 0xD1A4},
{ 0x9774 , 0xD1A5},
{ 0x859B , 0xD1A6},
{ 0x5B66 , 0xD1A7},
{ 0x7A74 , 0xD1A8},
{ 0x96EA , 0xD1A9},
{ 0x8840 , 0xD1AA},
{ 0x52CB , 0xD1AB},
{ 0x718F , 0xD1AC},
{ 0x5FAA , 0xD1AD},
{ 0x65EC , 0xD1AE},
{ 0x8BE2 , 0xD1AF},
{ 0x5BFB , 0xD1B0},
{ 0x9A6F , 0xD1B1},
{ 0x5DE1 , 0xD1B2},
{ 0x6B89 , 0xD1B3},
{ 0x6C5B , 0xD1B4},
{ 0x8BAD , 0xD1B5},
{ 0x8BAF , 0xD1B6},
{ 0x900A , 0xD1B7},
{ 0x8FC5 , 0xD1B8},
{ 0x538B , 0xD1B9},
{ 0x62BC , 0xD1BA},
{ 0x9E26 , 0xD1BB},
{ 0x9E2D , 0xD1BC},
{ 0x5440 , 0xD1BD},
{ 0x4E2B , 0xD1BE},
{ 0x82BD , 0xD1BF},
{ 0x7259 , 0xD1C0},
{ 0x869C , 0xD1C1},
{ 0x5D16 , 0xD1C2},
{ 0x8859 , 0xD1C3},
{ 0x6DAF , 0xD1C4},
{ 0x96C5 , 0xD1C5},
{ 0x54D1 , 0xD1C6},
{ 0x4E9A , 0xD1C7},
{ 0x8BB6 , 0xD1C8},
{ 0x7109 , 0xD1C9},
{ 0x54BD , 0xD1CA},
{ 0x9609 , 0xD1CB},
{ 0x70DF , 0xD1CC},
{ 0x6DF9 , 0xD1CD},
{ 0x76D0 , 0xD1CE},
{ 0x4E25 , 0xD1CF},
{ 0x7814 , 0xD1D0},
{ 0x8712 , 0xD1D1},
{ 0x5CA9 , 0xD1D2},
{ 0x5EF6 , 0xD1D3},
{ 0x8A00 , 0xD1D4},
{ 0x989C , 0xD1D5},
{ 0x960E , 0xD1D6},
{ 0x708E , 0xD1D7},
{ 0x6CBF , 0xD1D8},
{ 0x5944 , 0xD1D9},
{ 0x63A9 , 0xD1DA},
{ 0x773C , 0xD1DB},
{ 0x884D , 0xD1DC},
{ 0x6F14 , 0xD1DD},
{ 0x8273 , 0xD1DE},
{ 0x5830 , 0xD1DF},
{ 0x71D5 , 0xD1E0},
{ 0x538C , 0xD1E1},
{ 0x781A , 0xD1E2},
{ 0x96C1 , 0xD1E3},
{ 0x5501 , 0xD1E4},
{ 0x5F66 , 0xD1E5},
{ 0x7130 , 0xD1E6},
{ 0x5BB4 , 0xD1E7},
{ 0x8C1A , 0xD1E8},
{ 0x9A8C , 0xD1E9},
{ 0x6B83 , 0xD1EA},
{ 0x592E , 0xD1EB},
{ 0x9E2F , 0xD1EC},
{ 0x79E7 , 0xD1ED},
{ 0x6768 , 0xD1EE},
{ 0x626C , 0xD1EF},
{ 0x4F6F , 0xD1F0},
{ 0x75A1 , 0xD1F1},
{ 0x7F8A , 0xD1F2},
{ 0x6D0B , 0xD1F3},
{ 0x9633 , 0xD1F4},
{ 0x6C27 , 0xD1F5},
{ 0x4EF0 , 0xD1F6},
{ 0x75D2 , 0xD1F7},
{ 0x517B , 0xD1F8},
{ 0x6837 , 0xD1F9},
{ 0x6F3E , 0xD1FA},
{ 0x9080 , 0xD1FB},
{ 0x8170 , 0xD1FC},
{ 0x5996 , 0xD1FD},
{ 0x7476 , 0xD1FE},
{ 0x8938 , 0xD240},
{ 0x8939 , 0xD241},
{ 0x893A , 0xD242},
{ 0x893B , 0xD243},
{ 0x893C , 0xD244},
{ 0x893D , 0xD245},
{ 0x893E , 0xD246},
{ 0x893F , 0xD247},
{ 0x8940 , 0xD248},
{ 0x8942 , 0xD249},
{ 0x8943 , 0xD24A},
{ 0x8945 , 0xD24B},
{ 0x8946 , 0xD24C},
{ 0x8947 , 0xD24D},
{ 0x8948 , 0xD24E},
{ 0x8949 , 0xD24F},
{ 0x894A , 0xD250},
{ 0x894B , 0xD251},
{ 0x894C , 0xD252},
{ 0x894D , 0xD253},
{ 0x894E , 0xD254},
{ 0x894F , 0xD255},
{ 0x8950 , 0xD256},
{ 0x8951 , 0xD257},
{ 0x8952 , 0xD258},
{ 0x8953 , 0xD259},
{ 0x8954 , 0xD25A},
{ 0x8955 , 0xD25B},
{ 0x8956 , 0xD25C},
{ 0x8957 , 0xD25D},
{ 0x8958 , 0xD25E},
{ 0x8959 , 0xD25F},
{ 0x895A , 0xD260},
{ 0x895B , 0xD261},
{ 0x895C , 0xD262},
{ 0x895D , 0xD263},
{ 0x8960 , 0xD264},
{ 0x8961 , 0xD265},
{ 0x8962 , 0xD266},
{ 0x8963 , 0xD267},
{ 0x8964 , 0xD268},
{ 0x8965 , 0xD269},
{ 0x8967 , 0xD26A},
{ 0x8968 , 0xD26B},
{ 0x8969 , 0xD26C},
{ 0x896A , 0xD26D},
{ 0x896B , 0xD26E},
{ 0x896C , 0xD26F},
{ 0x896D , 0xD270},
{ 0x896E , 0xD271},
{ 0x896F , 0xD272},
{ 0x8970 , 0xD273},
{ 0x8971 , 0xD274},
{ 0x8972 , 0xD275},
{ 0x8973 , 0xD276},
{ 0x8974 , 0xD277},
{ 0x8975 , 0xD278},
{ 0x8976 , 0xD279},
{ 0x8977 , 0xD27A},
{ 0x8978 , 0xD27B},
{ 0x8979 , 0xD27C},
{ 0x897A , 0xD27D},
{ 0x897C , 0xD27E},
{ 0x897D , 0xD280},
{ 0x897E , 0xD281},
{ 0x8980 , 0xD282},
{ 0x8982 , 0xD283},
{ 0x8984 , 0xD284},
{ 0x8985 , 0xD285},
{ 0x8987 , 0xD286},
{ 0x8988 , 0xD287},
{ 0x8989 , 0xD288},
{ 0x898A , 0xD289},
{ 0x898B , 0xD28A},
{ 0x898C , 0xD28B},
{ 0x898D , 0xD28C},
{ 0x898E , 0xD28D},
{ 0x898F , 0xD28E},
{ 0x8990 , 0xD28F},
{ 0x8991 , 0xD290},
{ 0x8992 , 0xD291},
{ 0x8993 , 0xD292},
{ 0x8994 , 0xD293},
{ 0x8995 , 0xD294},
{ 0x8996 , 0xD295},
{ 0x8997 , 0xD296},
{ 0x8998 , 0xD297},
{ 0x8999 , 0xD298},
{ 0x899A , 0xD299},
{ 0x899B , 0xD29A},
{ 0x899C , 0xD29B},
{ 0x899D , 0xD29C},
{ 0x899E , 0xD29D},
{ 0x899F , 0xD29E},
{ 0x89A0 , 0xD29F},
{ 0x89A1 , 0xD2A0},
{ 0x6447 , 0xD2A1},
{ 0x5C27 , 0xD2A2},
{ 0x9065 , 0xD2A3},
{ 0x7A91 , 0xD2A4},
{ 0x8C23 , 0xD2A5},
{ 0x59DA , 0xD2A6},
{ 0x54AC , 0xD2A7},
{ 0x8200 , 0xD2A8},
{ 0x836F , 0xD2A9},
{ 0x8981 , 0xD2AA},
{ 0x8000 , 0xD2AB},
{ 0x6930 , 0xD2AC},
{ 0x564E , 0xD2AD},
{ 0x8036 , 0xD2AE},
{ 0x7237 , 0xD2AF},
{ 0x91CE , 0xD2B0},
{ 0x51B6 , 0xD2B1},
{ 0x4E5F , 0xD2B2},
{ 0x9875 , 0xD2B3},
{ 0x6396 , 0xD2B4},
{ 0x4E1A , 0xD2B5},
{ 0x53F6 , 0xD2B6},
{ 0x66F3 , 0xD2B7},
{ 0x814B , 0xD2B8},
{ 0x591C , 0xD2B9},
{ 0x6DB2 , 0xD2BA},
{ 0x4E00 , 0xD2BB},
{ 0x58F9 , 0xD2BC},
{ 0x533B , 0xD2BD},
{ 0x63D6 , 0xD2BE},
{ 0x94F1 , 0xD2BF},
{ 0x4F9D , 0xD2C0},
{ 0x4F0A , 0xD2C1},
{ 0x8863 , 0xD2C2},
{ 0x9890 , 0xD2C3},
{ 0x5937 , 0xD2C4},
{ 0x9057 , 0xD2C5},
{ 0x79FB , 0xD2C6},
{ 0x4EEA , 0xD2C7},
{ 0x80F0 , 0xD2C8},
{ 0x7591 , 0xD2C9},
{ 0x6C82 , 0xD2CA},
{ 0x5B9C , 0xD2CB},
{ 0x59E8 , 0xD2CC},
{ 0x5F5D , 0xD2CD},
{ 0x6905 , 0xD2CE},
{ 0x8681 , 0xD2CF},
{ 0x501A , 0xD2D0},
{ 0x5DF2 , 0xD2D1},
{ 0x4E59 , 0xD2D2},
{ 0x77E3 , 0xD2D3},
{ 0x4EE5 , 0xD2D4},
{ 0x827A , 0xD2D5},
{ 0x6291 , 0xD2D6},
{ 0x6613 , 0xD2D7},
{ 0x9091 , 0xD2D8},
{ 0x5C79 , 0xD2D9},
{ 0x4EBF , 0xD2DA},
{ 0x5F79 , 0xD2DB},
{ 0x81C6 , 0xD2DC},
{ 0x9038 , 0xD2DD},
{ 0x8084 , 0xD2DE},
{ 0x75AB , 0xD2DF},
{ 0x4EA6 , 0xD2E0},
{ 0x88D4 , 0xD2E1},
{ 0x610F , 0xD2E2},
{ 0x6BC5 , 0xD2E3},
{ 0x5FC6 , 0xD2E4},
{ 0x4E49 , 0xD2E5},
{ 0x76CA , 0xD2E6},
{ 0x6EA2 , 0xD2E7},
{ 0x8BE3 , 0xD2E8},
{ 0x8BAE , 0xD2E9},
{ 0x8C0A , 0xD2EA},
{ 0x8BD1 , 0xD2EB},
{ 0x5F02 , 0xD2EC},
{ 0x7FFC , 0xD2ED},
{ 0x7FCC , 0xD2EE},
{ 0x7ECE , 0xD2EF},
{ 0x8335 , 0xD2F0},
{ 0x836B , 0xD2F1},
{ 0x56E0 , 0xD2F2},
{ 0x6BB7 , 0xD2F3},
{ 0x97F3 , 0xD2F4},
{ 0x9634 , 0xD2F5},
{ 0x59FB , 0xD2F6},
{ 0x541F , 0xD2F7},
{ 0x94F6 , 0xD2F8},
{ 0x6DEB , 0xD2F9},
{ 0x5BC5 , 0xD2FA},
{ 0x996E , 0xD2FB},
{ 0x5C39 , 0xD2FC},
{ 0x5F15 , 0xD2FD},
{ 0x9690 , 0xD2FE},
{ 0x89A2 , 0xD340},
{ 0x89A3 , 0xD341},
{ 0x89A4 , 0xD342},
{ 0x89A5 , 0xD343},
{ 0x89A6 , 0xD344},
{ 0x89A7 , 0xD345},
{ 0x89A8 , 0xD346},
{ 0x89A9 , 0xD347},
{ 0x89AA , 0xD348},
{ 0x89AB , 0xD349},
{ 0x89AC , 0xD34A},
{ 0x89AD , 0xD34B},
{ 0x89AE , 0xD34C},
{ 0x89AF , 0xD34D},
{ 0x89B0 , 0xD34E},
{ 0x89B1 , 0xD34F},
{ 0x89B2 , 0xD350},
{ 0x89B3 , 0xD351},
{ 0x89B4 , 0xD352},
{ 0x89B5 , 0xD353},
{ 0x89B6 , 0xD354},
{ 0x89B7 , 0xD355},
{ 0x89B8 , 0xD356},
{ 0x89B9 , 0xD357},
{ 0x89BA , 0xD358},
{ 0x89BB , 0xD359},
{ 0x89BC , 0xD35A},
{ 0x89BD , 0xD35B},
{ 0x89BE , 0xD35C},
{ 0x89BF , 0xD35D},
{ 0x89C0 , 0xD35E},
{ 0x89C3 , 0xD35F},
{ 0x89CD , 0xD360},
{ 0x89D3 , 0xD361},
{ 0x89D4 , 0xD362},
{ 0x89D5 , 0xD363},
{ 0x89D7 , 0xD364},
{ 0x89D8 , 0xD365},
{ 0x89D9 , 0xD366},
{ 0x89DB , 0xD367},
{ 0x89DD , 0xD368},
{ 0x89DF , 0xD369},
{ 0x89E0 , 0xD36A},
{ 0x89E1 , 0xD36B},
{ 0x89E2 , 0xD36C},
{ 0x89E4 , 0xD36D},
{ 0x89E7 , 0xD36E},
{ 0x89E8 , 0xD36F},
{ 0x89E9 , 0xD370},
{ 0x89EA , 0xD371},
{ 0x89EC , 0xD372},
{ 0x89ED , 0xD373},
{ 0x89EE , 0xD374},
{ 0x89F0 , 0xD375},
{ 0x89F1 , 0xD376},
{ 0x89F2 , 0xD377},
{ 0x89F4 , 0xD378},
{ 0x89F5 , 0xD379},
{ 0x89F6 , 0xD37A},
{ 0x89F7 , 0xD37B},
{ 0x89F8 , 0xD37C},
{ 0x89F9 , 0xD37D},
{ 0x89FA , 0xD37E},
{ 0x89FB , 0xD380},
{ 0x89FC , 0xD381},
{ 0x89FD , 0xD382},
{ 0x89FE , 0xD383},
{ 0x89FF , 0xD384},
{ 0x8A01 , 0xD385},
{ 0x8A02 , 0xD386},
{ 0x8A03 , 0xD387},
{ 0x8A04 , 0xD388},
{ 0x8A05 , 0xD389},
{ 0x8A06 , 0xD38A},
{ 0x8A08 , 0xD38B},
{ 0x8A09 , 0xD38C},
{ 0x8A0A , 0xD38D},
{ 0x8A0B , 0xD38E},
{ 0x8A0C , 0xD38F},
{ 0x8A0D , 0xD390},
{ 0x8A0E , 0xD391},
{ 0x8A0F , 0xD392},
{ 0x8A10 , 0xD393},
{ 0x8A11 , 0xD394},
{ 0x8A12 , 0xD395},
{ 0x8A13 , 0xD396},
{ 0x8A14 , 0xD397},
{ 0x8A15 , 0xD398},
{ 0x8A16 , 0xD399},
{ 0x8A17 , 0xD39A},
{ 0x8A18 , 0xD39B},
{ 0x8A19 , 0xD39C},
{ 0x8A1A , 0xD39D},
{ 0x8A1B , 0xD39E},
{ 0x8A1C , 0xD39F},
{ 0x8A1D , 0xD3A0},
{ 0x5370 , 0xD3A1},
{ 0x82F1 , 0xD3A2},
{ 0x6A31 , 0xD3A3},
{ 0x5A74 , 0xD3A4},
{ 0x9E70 , 0xD3A5},
{ 0x5E94 , 0xD3A6},
{ 0x7F28 , 0xD3A7},
{ 0x83B9 , 0xD3A8},
{ 0x8424 , 0xD3A9},
{ 0x8425 , 0xD3AA},
{ 0x8367 , 0xD3AB},
{ 0x8747 , 0xD3AC},
{ 0x8FCE , 0xD3AD},
{ 0x8D62 , 0xD3AE},
{ 0x76C8 , 0xD3AF},
{ 0x5F71 , 0xD3B0},
{ 0x9896 , 0xD3B1},
{ 0x786C , 0xD3B2},
{ 0x6620 , 0xD3B3},
{ 0x54DF , 0xD3B4},
{ 0x62E5 , 0xD3B5},
{ 0x4F63 , 0xD3B6},
{ 0x81C3 , 0xD3B7},
{ 0x75C8 , 0xD3B8},
{ 0x5EB8 , 0xD3B9},
{ 0x96CD , 0xD3BA},
{ 0x8E0A , 0xD3BB},
{ 0x86F9 , 0xD3BC},
{ 0x548F , 0xD3BD},
{ 0x6CF3 , 0xD3BE},
{ 0x6D8C , 0xD3BF},
{ 0x6C38 , 0xD3C0},
{ 0x607F , 0xD3C1},
{ 0x52C7 , 0xD3C2},
{ 0x7528 , 0xD3C3},
{ 0x5E7D , 0xD3C4},
{ 0x4F18 , 0xD3C5},
{ 0x60A0 , 0xD3C6},
{ 0x5FE7 , 0xD3C7},
{ 0x5C24 , 0xD3C8},
{ 0x7531 , 0xD3C9},
{ 0x90AE , 0xD3CA},
{ 0x94C0 , 0xD3CB},
{ 0x72B9 , 0xD3CC},
{ 0x6CB9 , 0xD3CD},
{ 0x6E38 , 0xD3CE},
{ 0x9149 , 0xD3CF},
{ 0x6709 , 0xD3D0},
{ 0x53CB , 0xD3D1},
{ 0x53F3 , 0xD3D2},
{ 0x4F51 , 0xD3D3},
{ 0x91C9 , 0xD3D4},
{ 0x8BF1 , 0xD3D5},
{ 0x53C8 , 0xD3D6},
{ 0x5E7C , 0xD3D7},
{ 0x8FC2 , 0xD3D8},
{ 0x6DE4 , 0xD3D9},
{ 0x4E8E , 0xD3DA},
{ 0x76C2 , 0xD3DB},
{ 0x6986 , 0xD3DC},
{ 0x865E , 0xD3DD},
{ 0x611A , 0xD3DE},
{ 0x8206 , 0xD3DF},
{ 0x4F59 , 0xD3E0},
{ 0x4FDE , 0xD3E1},
{ 0x903E , 0xD3E2},
{ 0x9C7C , 0xD3E3},
{ 0x6109 , 0xD3E4},
{ 0x6E1D , 0xD3E5},
{ 0x6E14 , 0xD3E6},
{ 0x9685 , 0xD3E7},
{ 0x4E88 , 0xD3E8},
{ 0x5A31 , 0xD3E9},
{ 0x96E8 , 0xD3EA},
{ 0x4E0E , 0xD3EB},
{ 0x5C7F , 0xD3EC},
{ 0x79B9 , 0xD3ED},
{ 0x5B87 , 0xD3EE},
{ 0x8BED , 0xD3EF},
{ 0x7FBD , 0xD3F0},
{ 0x7389 , 0xD3F1},
{ 0x57DF , 0xD3F2},
{ 0x828B , 0xD3F3},
{ 0x90C1 , 0xD3F4},
{ 0x5401 , 0xD3F5},
{ 0x9047 , 0xD3F6},
{ 0x55BB , 0xD3F7},
{ 0x5CEA , 0xD3F8},
{ 0x5FA1 , 0xD3F9},
{ 0x6108 , 0xD3FA},
{ 0x6B32 , 0xD3FB},
{ 0x72F1 , 0xD3FC},
{ 0x80B2 , 0xD3FD},
{ 0x8A89 , 0xD3FE},
{ 0x8A1E , 0xD440},
{ 0x8A1F , 0xD441},
{ 0x8A20 , 0xD442},
{ 0x8A21 , 0xD443},
{ 0x8A22 , 0xD444},
{ 0x8A23 , 0xD445},
{ 0x8A24 , 0xD446},
{ 0x8A25 , 0xD447},
{ 0x8A26 , 0xD448},
{ 0x8A27 , 0xD449},
{ 0x8A28 , 0xD44A},
{ 0x8A29 , 0xD44B},
{ 0x8A2A , 0xD44C},
{ 0x8A2B , 0xD44D},
{ 0x8A2C , 0xD44E},
{ 0x8A2D , 0xD44F},
{ 0x8A2E , 0xD450},
{ 0x8A2F , 0xD451},
{ 0x8A30 , 0xD452},
{ 0x8A31 , 0xD453},
{ 0x8A32 , 0xD454},
{ 0x8A33 , 0xD455},
{ 0x8A34 , 0xD456},
{ 0x8A35 , 0xD457},
{ 0x8A36 , 0xD458},
{ 0x8A37 , 0xD459},
{ 0x8A38 , 0xD45A},
{ 0x8A39 , 0xD45B},
{ 0x8A3A , 0xD45C},
{ 0x8A3B , 0xD45D},
{ 0x8A3C , 0xD45E},
{ 0x8A3D , 0xD45F},
{ 0x8A3F , 0xD460},
{ 0x8A40 , 0xD461},
{ 0x8A41 , 0xD462},
{ 0x8A42 , 0xD463},
{ 0x8A43 , 0xD464},
{ 0x8A44 , 0xD465},
{ 0x8A45 , 0xD466},
{ 0x8A46 , 0xD467},
{ 0x8A47 , 0xD468},
{ 0x8A49 , 0xD469},
{ 0x8A4A , 0xD46A},
{ 0x8A4B , 0xD46B},
{ 0x8A4C , 0xD46C},
{ 0x8A4D , 0xD46D},
{ 0x8A4E , 0xD46E},
{ 0x8A4F , 0xD46F},
{ 0x8A50 , 0xD470},
{ 0x8A51 , 0xD471},
{ 0x8A52 , 0xD472},
{ 0x8A53 , 0xD473},
{ 0x8A54 , 0xD474},
{ 0x8A55 , 0xD475},
{ 0x8A56 , 0xD476},
{ 0x8A57 , 0xD477},
{ 0x8A58 , 0xD478},
{ 0x8A59 , 0xD479},
{ 0x8A5A , 0xD47A},
{ 0x8A5B , 0xD47B},
{ 0x8A5C , 0xD47C},
{ 0x8A5D , 0xD47D},
{ 0x8A5E , 0xD47E},
{ 0x8A5F , 0xD480},
{ 0x8A60 , 0xD481},
{ 0x8A61 , 0xD482},
{ 0x8A62 , 0xD483},
{ 0x8A63 , 0xD484},
{ 0x8A64 , 0xD485},
{ 0x8A65 , 0xD486},
{ 0x8A66 , 0xD487},
{ 0x8A67 , 0xD488},
{ 0x8A68 , 0xD489},
{ 0x8A69 , 0xD48A},
{ 0x8A6A , 0xD48B},
{ 0x8A6B , 0xD48C},
{ 0x8A6C , 0xD48D},
{ 0x8A6D , 0xD48E},
{ 0x8A6E , 0xD48F},
{ 0x8A6F , 0xD490},
{ 0x8A70 , 0xD491},
{ 0x8A71 , 0xD492},
{ 0x8A72 , 0xD493},
{ 0x8A73 , 0xD494},
{ 0x8A74 , 0xD495},
{ 0x8A75 , 0xD496},
{ 0x8A76 , 0xD497},
{ 0x8A77 , 0xD498},
{ 0x8A78 , 0xD499},
{ 0x8A7A , 0xD49A},
{ 0x8A7B , 0xD49B},
{ 0x8A7C , 0xD49C},
{ 0x8A7D , 0xD49D},
{ 0x8A7E , 0xD49E},
{ 0x8A7F , 0xD49F},
{ 0x8A80 , 0xD4A0},
{ 0x6D74 , 0xD4A1},
{ 0x5BD3 , 0xD4A2},
{ 0x88D5 , 0xD4A3},
{ 0x9884 , 0xD4A4},
{ 0x8C6B , 0xD4A5},
{ 0x9A6D , 0xD4A6},
{ 0x9E33 , 0xD4A7},
{ 0x6E0A , 0xD4A8},
{ 0x51A4 , 0xD4A9},
{ 0x5143 , 0xD4AA},
{ 0x57A3 , 0xD4AB},
{ 0x8881 , 0xD4AC},
{ 0x539F , 0xD4AD},
{ 0x63F4 , 0xD4AE},
{ 0x8F95 , 0xD4AF},
{ 0x56ED , 0xD4B0},
{ 0x5458 , 0xD4B1},
{ 0x5706 , 0xD4B2},
{ 0x733F , 0xD4B3},
{ 0x6E90 , 0xD4B4},
{ 0x7F18 , 0xD4B5},
{ 0x8FDC , 0xD4B6},
{ 0x82D1 , 0xD4B7},
{ 0x613F , 0xD4B8},
{ 0x6028 , 0xD4B9},
{ 0x9662 , 0xD4BA},
{ 0x66F0 , 0xD4BB},
{ 0x7EA6 , 0xD4BC},
{ 0x8D8A , 0xD4BD},
{ 0x8DC3 , 0xD4BE},
{ 0x94A5 , 0xD4BF},
{ 0x5CB3 , 0xD4C0},
{ 0x7CA4 , 0xD4C1},
{ 0x6708 , 0xD4C2},
{ 0x60A6 , 0xD4C3},
{ 0x9605 , 0xD4C4},
{ 0x8018 , 0xD4C5},
{ 0x4E91 , 0xD4C6},
{ 0x90E7 , 0xD4C7},
{ 0x5300 , 0xD4C8},
{ 0x9668 , 0xD4C9},
{ 0x5141 , 0xD4CA},
{ 0x8FD0 , 0xD4CB},
{ 0x8574 , 0xD4CC},
{ 0x915D , 0xD4CD},
{ 0x6655 , 0xD4CE},
{ 0x97F5 , 0xD4CF},
{ 0x5B55 , 0xD4D0},
{ 0x531D , 0xD4D1},
{ 0x7838 , 0xD4D2},
{ 0x6742 , 0xD4D3},
{ 0x683D , 0xD4D4},
{ 0x54C9 , 0xD4D5},
{ 0x707E , 0xD4D6},
{ 0x5BB0 , 0xD4D7},
{ 0x8F7D , 0xD4D8},
{ 0x518D , 0xD4D9},
{ 0x5728 , 0xD4DA},
{ 0x54B1 , 0xD4DB},
{ 0x6512 , 0xD4DC},
{ 0x6682 , 0xD4DD},
{ 0x8D5E , 0xD4DE},
{ 0x8D43 , 0xD4DF},
{ 0x810F , 0xD4E0},
{ 0x846C , 0xD4E1},
{ 0x906D , 0xD4E2},
{ 0x7CDF , 0xD4E3},
{ 0x51FF , 0xD4E4},
{ 0x85FB , 0xD4E5},
{ 0x67A3 , 0xD4E6},
{ 0x65E9 , 0xD4E7},
{ 0x6FA1 , 0xD4E8},
{ 0x86A4 , 0xD4E9},
{ 0x8E81 , 0xD4EA},
{ 0x566A , 0xD4EB},
{ 0x9020 , 0xD4EC},
{ 0x7682 , 0xD4ED},
{ 0x7076 , 0xD4EE},
{ 0x71E5 , 0xD4EF},
{ 0x8D23 , 0xD4F0},
{ 0x62E9 , 0xD4F1},
{ 0x5219 , 0xD4F2},
{ 0x6CFD , 0xD4F3},
{ 0x8D3C , 0xD4F4},
{ 0x600E , 0xD4F5},
{ 0x589E , 0xD4F6},
{ 0x618E , 0xD4F7},
{ 0x66FE , 0xD4F8},
{ 0x8D60 , 0xD4F9},
{ 0x624E , 0xD4FA},
{ 0x55B3 , 0xD4FB},
{ 0x6E23 , 0xD4FC},
{ 0x672D , 0xD4FD},
{ 0x8F67 , 0xD4FE},
{ 0x8A81 , 0xD540},
{ 0x8A82 , 0xD541},
{ 0x8A83 , 0xD542},
{ 0x8A84 , 0xD543},
{ 0x8A85 , 0xD544},
{ 0x8A86 , 0xD545},
{ 0x8A87 , 0xD546},
{ 0x8A88 , 0xD547},
{ 0x8A8B , 0xD548},
{ 0x8A8C , 0xD549},
{ 0x8A8D , 0xD54A},
{ 0x8A8E , 0xD54B},
{ 0x8A8F , 0xD54C},
{ 0x8A90 , 0xD54D},
{ 0x8A91 , 0xD54E},
{ 0x8A92 , 0xD54F},
{ 0x8A94 , 0xD550},
{ 0x8A95 , 0xD551},
{ 0x8A96 , 0xD552},
{ 0x8A97 , 0xD553},
{ 0x8A98 , 0xD554},
{ 0x8A99 , 0xD555},
{ 0x8A9A , 0xD556},
{ 0x8A9B , 0xD557},
{ 0x8A9C , 0xD558},
{ 0x8A9D , 0xD559},
{ 0x8A9E , 0xD55A},
{ 0x8A9F , 0xD55B},
{ 0x8AA0 , 0xD55C},
{ 0x8AA1 , 0xD55D},
{ 0x8AA2 , 0xD55E},
{ 0x8AA3 , 0xD55F},
{ 0x8AA4 , 0xD560},
{ 0x8AA5 , 0xD561},
{ 0x8AA6 , 0xD562},
{ 0x8AA7 , 0xD563},
{ 0x8AA8 , 0xD564},
{ 0x8AA9 , 0xD565},
{ 0x8AAA , 0xD566},
{ 0x8AAB , 0xD567},
{ 0x8AAC , 0xD568},
{ 0x8AAD , 0xD569},
{ 0x8AAE , 0xD56A},
{ 0x8AAF , 0xD56B},
{ 0x8AB0 , 0xD56C},
{ 0x8AB1 , 0xD56D},
{ 0x8AB2 , 0xD56E},
{ 0x8AB3 , 0xD56F},
{ 0x8AB4 , 0xD570},
{ 0x8AB5 , 0xD571},
{ 0x8AB6 , 0xD572},
{ 0x8AB7 , 0xD573},
{ 0x8AB8 , 0xD574},
{ 0x8AB9 , 0xD575},
{ 0x8ABA , 0xD576},
{ 0x8ABB , 0xD577},
{ 0x8ABC , 0xD578},
{ 0x8ABD , 0xD579},
{ 0x8ABE , 0xD57A},
{ 0x8ABF , 0xD57B},
{ 0x8AC0 , 0xD57C},
{ 0x8AC1 , 0xD57D},
{ 0x8AC2 , 0xD57E},
{ 0x8AC3 , 0xD580},
{ 0x8AC4 , 0xD581},
{ 0x8AC5 , 0xD582},
{ 0x8AC6 , 0xD583},
{ 0x8AC7 , 0xD584},
{ 0x8AC8 , 0xD585},
{ 0x8AC9 , 0xD586},
{ 0x8ACA , 0xD587},
{ 0x8ACB , 0xD588},
{ 0x8ACC , 0xD589},
{ 0x8ACD , 0xD58A},
{ 0x8ACE , 0xD58B},
{ 0x8ACF , 0xD58C},
{ 0x8AD0 , 0xD58D},
{ 0x8AD1 , 0xD58E},
{ 0x8AD2 , 0xD58F},
{ 0x8AD3 , 0xD590},
{ 0x8AD4 , 0xD591},
{ 0x8AD5 , 0xD592},
{ 0x8AD6 , 0xD593},
{ 0x8AD7 , 0xD594},
{ 0x8AD8 , 0xD595},
{ 0x8AD9 , 0xD596},
{ 0x8ADA , 0xD597},
{ 0x8ADB , 0xD598},
{ 0x8ADC , 0xD599},
{ 0x8ADD , 0xD59A},
{ 0x8ADE , 0xD59B},
{ 0x8ADF , 0xD59C},
{ 0x8AE0 , 0xD59D},
{ 0x8AE1 , 0xD59E},
{ 0x8AE2 , 0xD59F},
{ 0x8AE3 , 0xD5A0},
{ 0x94E1 , 0xD5A1},
{ 0x95F8 , 0xD5A2},
{ 0x7728 , 0xD5A3},
{ 0x6805 , 0xD5A4},
{ 0x69A8 , 0xD5A5},
{ 0x548B , 0xD5A6},
{ 0x4E4D , 0xD5A7},
{ 0x70B8 , 0xD5A8},
{ 0x8BC8 , 0xD5A9},
{ 0x6458 , 0xD5AA},
{ 0x658B , 0xD5AB},
{ 0x5B85 , 0xD5AC},
{ 0x7A84 , 0xD5AD},
{ 0x503A , 0xD5AE},
{ 0x5BE8 , 0xD5AF},
{ 0x77BB , 0xD5B0},
{ 0x6BE1 , 0xD5B1},
{ 0x8A79 , 0xD5B2},
{ 0x7C98 , 0xD5B3},
{ 0x6CBE , 0xD5B4},
{ 0x76CF , 0xD5B5},
{ 0x65A9 , 0xD5B6},
{ 0x8F97 , 0xD5B7},
{ 0x5D2D , 0xD5B8},
{ 0x5C55 , 0xD5B9},
{ 0x8638 , 0xD5BA},
{ 0x6808 , 0xD5BB},
{ 0x5360 , 0xD5BC},
{ 0x6218 , 0xD5BD},
{ 0x7AD9 , 0xD5BE},
{ 0x6E5B , 0xD5BF},
{ 0x7EFD , 0xD5C0},
{ 0x6A1F , 0xD5C1},
{ 0x7AE0 , 0xD5C2},
{ 0x5F70 , 0xD5C3},
{ 0x6F33 , 0xD5C4},
{ 0x5F20 , 0xD5C5},
{ 0x638C , 0xD5C6},
{ 0x6DA8 , 0xD5C7},
{ 0x6756 , 0xD5C8},
{ 0x4E08 , 0xD5C9},
{ 0x5E10 , 0xD5CA},
{ 0x8D26 , 0xD5CB},
{ 0x4ED7 , 0xD5CC},
{ 0x80C0 , 0xD5CD},
{ 0x7634 , 0xD5CE},
{ 0x969C , 0xD5CF},
{ 0x62DB , 0xD5D0},
{ 0x662D , 0xD5D1},
{ 0x627E , 0xD5D2},
{ 0x6CBC , 0xD5D3},
{ 0x8D75 , 0xD5D4},
{ 0x7167 , 0xD5D5},
{ 0x7F69 , 0xD5D6},
{ 0x5146 , 0xD5D7},
{ 0x8087 , 0xD5D8},
{ 0x53EC , 0xD5D9},
{ 0x906E , 0xD5DA},
{ 0x6298 , 0xD5DB},
{ 0x54F2 , 0xD5DC},
{ 0x86F0 , 0xD5DD},
{ 0x8F99 , 0xD5DE},
{ 0x8005 , 0xD5DF},
{ 0x9517 , 0xD5E0},
{ 0x8517 , 0xD5E1},
{ 0x8FD9 , 0xD5E2},
{ 0x6D59 , 0xD5E3},
{ 0x73CD , 0xD5E4},
{ 0x659F , 0xD5E5},
{ 0x771F , 0xD5E6},
{ 0x7504 , 0xD5E7},
{ 0x7827 , 0xD5E8},
{ 0x81FB , 0xD5E9},
{ 0x8D1E , 0xD5EA},
{ 0x9488 , 0xD5EB},
{ 0x4FA6 , 0xD5EC},
{ 0x6795 , 0xD5ED},
{ 0x75B9 , 0xD5EE},
{ 0x8BCA , 0xD5EF},
{ 0x9707 , 0xD5F0},
{ 0x632F , 0xD5F1},
{ 0x9547 , 0xD5F2},
{ 0x9635 , 0xD5F3},
{ 0x84B8 , 0xD5F4},
{ 0x6323 , 0xD5F5},
{ 0x7741 , 0xD5F6},
{ 0x5F81 , 0xD5F7},
{ 0x72F0 , 0xD5F8},
{ 0x4E89 , 0xD5F9},
{ 0x6014 , 0xD5FA},
{ 0x6574 , 0xD5FB},
{ 0x62EF , 0xD5FC},
{ 0x6B63 , 0xD5FD},
{ 0x653F , 0xD5FE},
{ 0x8AE4 , 0xD640},
{ 0x8AE5 , 0xD641},
{ 0x8AE6 , 0xD642},
{ 0x8AE7 , 0xD643},
{ 0x8AE8 , 0xD644},
{ 0x8AE9 , 0xD645},
{ 0x8AEA , 0xD646},
{ 0x8AEB , 0xD647},
{ 0x8AEC , 0xD648},
{ 0x8AED , 0xD649},
{ 0x8AEE , 0xD64A},
{ 0x8AEF , 0xD64B},
{ 0x8AF0 , 0xD64C},
{ 0x8AF1 , 0xD64D},
{ 0x8AF2 , 0xD64E},
{ 0x8AF3 , 0xD64F},
{ 0x8AF4 , 0xD650},
{ 0x8AF5 , 0xD651},
{ 0x8AF6 , 0xD652},
{ 0x8AF7 , 0xD653},
{ 0x8AF8 , 0xD654},
{ 0x8AF9 , 0xD655},
{ 0x8AFA , 0xD656},
{ 0x8AFB , 0xD657},
{ 0x8AFC , 0xD658},
{ 0x8AFD , 0xD659},
{ 0x8AFE , 0xD65A},
{ 0x8AFF , 0xD65B},
{ 0x8B00 , 0xD65C},
{ 0x8B01 , 0xD65D},
{ 0x8B02 , 0xD65E},
{ 0x8B03 , 0xD65F},
{ 0x8B04 , 0xD660},
{ 0x8B05 , 0xD661},
{ 0x8B06 , 0xD662},
{ 0x8B08 , 0xD663},
{ 0x8B09 , 0xD664},
{ 0x8B0A , 0xD665},
{ 0x8B0B , 0xD666},
{ 0x8B0C , 0xD667},
{ 0x8B0D , 0xD668},
{ 0x8B0E , 0xD669},
{ 0x8B0F , 0xD66A},
{ 0x8B10 , 0xD66B},
{ 0x8B11 , 0xD66C},
{ 0x8B12 , 0xD66D},
{ 0x8B13 , 0xD66E},
{ 0x8B14 , 0xD66F},
{ 0x8B15 , 0xD670},
{ 0x8B16 , 0xD671},
{ 0x8B17 , 0xD672},
{ 0x8B18 , 0xD673},
{ 0x8B19 , 0xD674},
{ 0x8B1A , 0xD675},
{ 0x8B1B , 0xD676},
{ 0x8B1C , 0xD677},
{ 0x8B1D , 0xD678},
{ 0x8B1E , 0xD679},
{ 0x8B1F , 0xD67A},
{ 0x8B20 , 0xD67B},
{ 0x8B21 , 0xD67C},
{ 0x8B22 , 0xD67D},
{ 0x8B23 , 0xD67E},
{ 0x8B24 , 0xD680},
{ 0x8B25 , 0xD681},
{ 0x8B27 , 0xD682},
{ 0x8B28 , 0xD683},
{ 0x8B29 , 0xD684},
{ 0x8B2A , 0xD685},
{ 0x8B2B , 0xD686},
{ 0x8B2C , 0xD687},
{ 0x8B2D , 0xD688},
{ 0x8B2E , 0xD689},
{ 0x8B2F , 0xD68A},
{ 0x8B30 , 0xD68B},
{ 0x8B31 , 0xD68C},
{ 0x8B32 , 0xD68D},
{ 0x8B33 , 0xD68E},
{ 0x8B34 , 0xD68F},
{ 0x8B35 , 0xD690},
{ 0x8B36 , 0xD691},
{ 0x8B37 , 0xD692},
{ 0x8B38 , 0xD693},
{ 0x8B39 , 0xD694},
{ 0x8B3A , 0xD695},
{ 0x8B3B , 0xD696},
{ 0x8B3C , 0xD697},
{ 0x8B3D , 0xD698},
{ 0x8B3E , 0xD699},
{ 0x8B3F , 0xD69A},
{ 0x8B40 , 0xD69B},
{ 0x8B41 , 0xD69C},
{ 0x8B42 , 0xD69D},
{ 0x8B43 , 0xD69E},
{ 0x8B44 , 0xD69F},
{ 0x8B45 , 0xD6A0},
{ 0x5E27 , 0xD6A1},
{ 0x75C7 , 0xD6A2},
{ 0x90D1 , 0xD6A3},
{ 0x8BC1 , 0xD6A4},
{ 0x829D , 0xD6A5},
{ 0x679D , 0xD6A6},
{ 0x652F , 0xD6A7},
{ 0x5431 , 0xD6A8},
{ 0x8718 , 0xD6A9},
{ 0x77E5 , 0xD6AA},
{ 0x80A2 , 0xD6AB},
{ 0x8102 , 0xD6AC},
{ 0x6C41 , 0xD6AD},
{ 0x4E4B , 0xD6AE},
{ 0x7EC7 , 0xD6AF},
{ 0x804C , 0xD6B0},
{ 0x76F4 , 0xD6B1},
{ 0x690D , 0xD6B2},
{ 0x6B96 , 0xD6B3},
{ 0x6267 , 0xD6B4},
{ 0x503C , 0xD6B5},
{ 0x4F84 , 0xD6B6},
{ 0x5740 , 0xD6B7},
{ 0x6307 , 0xD6B8},
{ 0x6B62 , 0xD6B9},
{ 0x8DBE , 0xD6BA},
{ 0x53EA , 0xD6BB},
{ 0x65E8 , 0xD6BC},
{ 0x7EB8 , 0xD6BD},
{ 0x5FD7 , 0xD6BE},
{ 0x631A , 0xD6BF},
{ 0x63B7 , 0xD6C0},
{ 0x81F3 , 0xD6C1},
{ 0x81F4 , 0xD6C2},
{ 0x7F6E , 0xD6C3},
{ 0x5E1C , 0xD6C4},
{ 0x5CD9 , 0xD6C5},
{ 0x5236 , 0xD6C6},
{ 0x667A , 0xD6C7},
{ 0x79E9 , 0xD6C8},
{ 0x7A1A , 0xD6C9},
{ 0x8D28 , 0xD6CA},
{ 0x7099 , 0xD6CB},
{ 0x75D4 , 0xD6CC},
{ 0x6EDE , 0xD6CD},
{ 0x6CBB , 0xD6CE},
{ 0x7A92 , 0xD6CF},
{ 0x4E2D , 0xD6D0},
{ 0x76C5 , 0xD6D1},
{ 0x5FE0 , 0xD6D2},
{ 0x949F , 0xD6D3},
{ 0x8877 , 0xD6D4},
{ 0x7EC8 , 0xD6D5},
{ 0x79CD , 0xD6D6},
{ 0x80BF , 0xD6D7},
{ 0x91CD , 0xD6D8},
{ 0x4EF2 , 0xD6D9},
{ 0x4F17 , 0xD6DA},
{ 0x821F , 0xD6DB},
{ 0x5468 , 0xD6DC},
{ 0x5DDE , 0xD6DD},
{ 0x6D32 , 0xD6DE},
{ 0x8BCC , 0xD6DF},
{ 0x7CA5 , 0xD6E0},
{ 0x8F74 , 0xD6E1},
{ 0x8098 , 0xD6E2},
{ 0x5E1A , 0xD6E3},
{ 0x5492 , 0xD6E4},
{ 0x76B1 , 0xD6E5},
{ 0x5B99 , 0xD6E6},
{ 0x663C , 0xD6E7},
{ 0x9AA4 , 0xD6E8},
{ 0x73E0 , 0xD6E9},
{ 0x682A , 0xD6EA},
{ 0x86DB , 0xD6EB},
{ 0x6731 , 0xD6EC},
{ 0x732A , 0xD6ED},
{ 0x8BF8 , 0xD6EE},
{ 0x8BDB , 0xD6EF},
{ 0x9010 , 0xD6F0},
{ 0x7AF9 , 0xD6F1},
{ 0x70DB , 0xD6F2},
{ 0x716E , 0xD6F3},
{ 0x62C4 , 0xD6F4},
{ 0x77A9 , 0xD6F5},
{ 0x5631 , 0xD6F6},
{ 0x4E3B , 0xD6F7},
{ 0x8457 , 0xD6F8},
{ 0x67F1 , 0xD6F9},
{ 0x52A9 , 0xD6FA},
{ 0x86C0 , 0xD6FB},
{ 0x8D2E , 0xD6FC},
{ 0x94F8 , 0xD6FD},
{ 0x7B51 , 0xD6FE},
{ 0x8B46 , 0xD740},
{ 0x8B47 , 0xD741},
{ 0x8B48 , 0xD742},
{ 0x8B49 , 0xD743},
{ 0x8B4A , 0xD744},
{ 0x8B4B , 0xD745},
{ 0x8B4C , 0xD746},
{ 0x8B4D , 0xD747},
{ 0x8B4E , 0xD748},
{ 0x8B4F , 0xD749},
{ 0x8B50 , 0xD74A},
{ 0x8B51 , 0xD74B},
{ 0x8B52 , 0xD74C},
{ 0x8B53 , 0xD74D},
{ 0x8B54 , 0xD74E},
{ 0x8B55 , 0xD74F},
{ 0x8B56 , 0xD750},
{ 0x8B57 , 0xD751},
{ 0x8B58 , 0xD752},
{ 0x8B59 , 0xD753},
{ 0x8B5A , 0xD754},
{ 0x8B5B , 0xD755},
{ 0x8B5C , 0xD756},
{ 0x8B5D , 0xD757},
{ 0x8B5E , 0xD758},
{ 0x8B5F , 0xD759},
{ 0x8B60 , 0xD75A},
{ 0x8B61 , 0xD75B},
{ 0x8B62 , 0xD75C},
{ 0x8B63 , 0xD75D},
{ 0x8B64 , 0xD75E},
{ 0x8B65 , 0xD75F},
{ 0x8B67 , 0xD760},
{ 0x8B68 , 0xD761},
{ 0x8B69 , 0xD762},
{ 0x8B6A , 0xD763},
{ 0x8B6B , 0xD764},
{ 0x8B6D , 0xD765},
{ 0x8B6E , 0xD766},
{ 0x8B6F , 0xD767},
{ 0x8B70 , 0xD768},
{ 0x8B71 , 0xD769},
{ 0x8B72 , 0xD76A},
{ 0x8B73 , 0xD76B},
{ 0x8B74 , 0xD76C},
{ 0x8B75 , 0xD76D},
{ 0x8B76 , 0xD76E},
{ 0x8B77 , 0xD76F},
{ 0x8B78 , 0xD770},
{ 0x8B79 , 0xD771},
{ 0x8B7A , 0xD772},
{ 0x8B7B , 0xD773},
{ 0x8B7C , 0xD774},
{ 0x8B7D , 0xD775},
{ 0x8B7E , 0xD776},
{ 0x8B7F , 0xD777},
{ 0x8B80 , 0xD778},
{ 0x8B81 , 0xD779},
{ 0x8B82 , 0xD77A},
{ 0x8B83 , 0xD77B},
{ 0x8B84 , 0xD77C},
{ 0x8B85 , 0xD77D},
{ 0x8B86 , 0xD77E},
{ 0x8B87 , 0xD780},
{ 0x8B88 , 0xD781},
{ 0x8B89 , 0xD782},
{ 0x8B8A , 0xD783},
{ 0x8B8B , 0xD784},
{ 0x8B8C , 0xD785},
{ 0x8B8D , 0xD786},
{ 0x8B8E , 0xD787},
{ 0x8B8F , 0xD788},
{ 0x8B90 , 0xD789},
{ 0x8B91 , 0xD78A},
{ 0x8B92 , 0xD78B},
{ 0x8B93 , 0xD78C},
{ 0x8B94 , 0xD78D},
{ 0x8B95 , 0xD78E},
{ 0x8B96 , 0xD78F},
{ 0x8B97 , 0xD790},
{ 0x8B98 , 0xD791},
{ 0x8B99 , 0xD792},
{ 0x8B9A , 0xD793},
{ 0x8B9B , 0xD794},
{ 0x8B9C , 0xD795},
{ 0x8B9D , 0xD796},
{ 0x8B9E , 0xD797},
{ 0x8B9F , 0xD798},
{ 0x8BAC , 0xD799},
{ 0x8BB1 , 0xD79A},
{ 0x8BBB , 0xD79B},
{ 0x8BC7 , 0xD79C},
{ 0x8BD0 , 0xD79D},
{ 0x8BEA , 0xD79E},
{ 0x8C09 , 0xD79F},
{ 0x8C1E , 0xD7A0},
{ 0x4F4F , 0xD7A1},
{ 0x6CE8 , 0xD7A2},
{ 0x795D , 0xD7A3},
{ 0x9A7B , 0xD7A4},
{ 0x6293 , 0xD7A5},
{ 0x722A , 0xD7A6},
{ 0x62FD , 0xD7A7},
{ 0x4E13 , 0xD7A8},
{ 0x7816 , 0xD7A9},
{ 0x8F6C , 0xD7AA},
{ 0x64B0 , 0xD7AB},
{ 0x8D5A , 0xD7AC},
{ 0x7BC6 , 0xD7AD},
{ 0x6869 , 0xD7AE},
{ 0x5E84 , 0xD7AF},
{ 0x88C5 , 0xD7B0},
{ 0x5986 , 0xD7B1},
{ 0x649E , 0xD7B2},
{ 0x58EE , 0xD7B3},
{ 0x72B6 , 0xD7B4},
{ 0x690E , 0xD7B5},
{ 0x9525 , 0xD7B6},
{ 0x8FFD , 0xD7B7},
{ 0x8D58 , 0xD7B8},
{ 0x5760 , 0xD7B9},
{ 0x7F00 , 0xD7BA},
{ 0x8C06 , 0xD7BB},
{ 0x51C6 , 0xD7BC},
{ 0x6349 , 0xD7BD},
{ 0x62D9 , 0xD7BE},
{ 0x5353 , 0xD7BF},
{ 0x684C , 0xD7C0},
{ 0x7422 , 0xD7C1},
{ 0x8301 , 0xD7C2},
{ 0x914C , 0xD7C3},
{ 0x5544 , 0xD7C4},
{ 0x7740 , 0xD7C5},
{ 0x707C , 0xD7C6},
{ 0x6D4A , 0xD7C7},
{ 0x5179 , 0xD7C8},
{ 0x54A8 , 0xD7C9},
{ 0x8D44 , 0xD7CA},
{ 0x59FF , 0xD7CB},
{ 0x6ECB , 0xD7CC},
{ 0x6DC4 , 0xD7CD},
{ 0x5B5C , 0xD7CE},
{ 0x7D2B , 0xD7CF},
{ 0x4ED4 , 0xD7D0},
{ 0x7C7D , 0xD7D1},
{ 0x6ED3 , 0xD7D2},
{ 0x5B50 , 0xD7D3},
{ 0x81EA , 0xD7D4},
{ 0x6E0D , 0xD7D5},
{ 0x5B57 , 0xD7D6},
{ 0x9B03 , 0xD7D7},
{ 0x68D5 , 0xD7D8},
{ 0x8E2A , 0xD7D9},
{ 0x5B97 , 0xD7DA},
{ 0x7EFC , 0xD7DB},
{ 0x603B , 0xD7DC},
{ 0x7EB5 , 0xD7DD},
{ 0x90B9 , 0xD7DE},
{ 0x8D70 , 0xD7DF},
{ 0x594F , 0xD7E0},
{ 0x63CD , 0xD7E1},
{ 0x79DF , 0xD7E2},
{ 0x8DB3 , 0xD7E3},
{ 0x5352 , 0xD7E4},
{ 0x65CF , 0xD7E5},
{ 0x7956 , 0xD7E6},
{ 0x8BC5 , 0xD7E7},
{ 0x963B , 0xD7E8},
{ 0x7EC4 , 0xD7E9},
{ 0x94BB , 0xD7EA},
{ 0x7E82 , 0xD7EB},
{ 0x5634 , 0xD7EC},
{ 0x9189 , 0xD7ED},
{ 0x6700 , 0xD7EE},
{ 0x7F6A , 0xD7EF},
{ 0x5C0A , 0xD7F0},
{ 0x9075 , 0xD7F1},
{ 0x6628 , 0xD7F2},
{ 0x5DE6 , 0xD7F3},
{ 0x4F50 , 0xD7F4},
{ 0x67DE , 0xD7F5},
{ 0x505A , 0xD7F6},
{ 0x4F5C , 0xD7F7},
{ 0x5750 , 0xD7F8},
{ 0x5EA7 , 0xD7F9},
{ 0xE810 , 0xD7FA},
{ 0xE811 , 0xD7FB},
{ 0xE812 , 0xD7FC},
{ 0xE813 , 0xD7FD},
{ 0xE814 , 0xD7FE},
{ 0x8C38 , 0xD840},
{ 0x8C39 , 0xD841},
{ 0x8C3A , 0xD842},
{ 0x8C3B , 0xD843},
{ 0x8C3C , 0xD844},
{ 0x8C3D , 0xD845},
{ 0x8C3E , 0xD846},
{ 0x8C3F , 0xD847},
{ 0x8C40 , 0xD848},
{ 0x8C42 , 0xD849},
{ 0x8C43 , 0xD84A},
{ 0x8C44 , 0xD84B},
{ 0x8C45 , 0xD84C},
{ 0x8C48 , 0xD84D},
{ 0x8C4A , 0xD84E},
{ 0x8C4B , 0xD84F},
{ 0x8C4D , 0xD850},
{ 0x8C4E , 0xD851},
{ 0x8C4F , 0xD852},
{ 0x8C50 , 0xD853},
{ 0x8C51 , 0xD854},
{ 0x8C52 , 0xD855},
{ 0x8C53 , 0xD856},
{ 0x8C54 , 0xD857},
{ 0x8C56 , 0xD858},
{ 0x8C57 , 0xD859},
{ 0x8C58 , 0xD85A},
{ 0x8C59 , 0xD85B},
{ 0x8C5B , 0xD85C},
{ 0x8C5C , 0xD85D},
{ 0x8C5D , 0xD85E},
{ 0x8C5E , 0xD85F},
{ 0x8C5F , 0xD860},
{ 0x8C60 , 0xD861},
{ 0x8C63 , 0xD862},
{ 0x8C64 , 0xD863},
{ 0x8C65 , 0xD864},
{ 0x8C66 , 0xD865},
{ 0x8C67 , 0xD866},
{ 0x8C68 , 0xD867},
{ 0x8C69 , 0xD868},
{ 0x8C6C , 0xD869},
{ 0x8C6D , 0xD86A},
{ 0x8C6E , 0xD86B},
{ 0x8C6F , 0xD86C},
{ 0x8C70 , 0xD86D},
{ 0x8C71 , 0xD86E},
{ 0x8C72 , 0xD86F},
{ 0x8C74 , 0xD870},
{ 0x8C75 , 0xD871},
{ 0x8C76 , 0xD872},
{ 0x8C77 , 0xD873},
{ 0x8C7B , 0xD874},
{ 0x8C7C , 0xD875},
{ 0x8C7D , 0xD876},
{ 0x8C7E , 0xD877},
{ 0x8C7F , 0xD878},
{ 0x8C80 , 0xD879},
{ 0x8C81 , 0xD87A},
{ 0x8C83 , 0xD87B},
{ 0x8C84 , 0xD87C},
{ 0x8C86 , 0xD87D},
{ 0x8C87 , 0xD87E},
{ 0x8C88 , 0xD880},
{ 0x8C8B , 0xD881},
{ 0x8C8D , 0xD882},
{ 0x8C8E , 0xD883},
{ 0x8C8F , 0xD884},
{ 0x8C90 , 0xD885},
{ 0x8C91 , 0xD886},
{ 0x8C92 , 0xD887},
{ 0x8C93 , 0xD888},
{ 0x8C95 , 0xD889},
{ 0x8C96 , 0xD88A},
{ 0x8C97 , 0xD88B},
{ 0x8C99 , 0xD88C},
{ 0x8C9A , 0xD88D},
{ 0x8C9B , 0xD88E},
{ 0x8C9C , 0xD88F},
{ 0x8C9D , 0xD890},
{ 0x8C9E , 0xD891},
{ 0x8C9F , 0xD892},
{ 0x8CA0 , 0xD893},
{ 0x8CA1 , 0xD894},
{ 0x8CA2 , 0xD895},
{ 0x8CA3 , 0xD896},
{ 0x8CA4 , 0xD897},
{ 0x8CA5 , 0xD898},
{ 0x8CA6 , 0xD899},
{ 0x8CA7 , 0xD89A},
{ 0x8CA8 , 0xD89B},
{ 0x8CA9 , 0xD89C},
{ 0x8CAA , 0xD89D},
{ 0x8CAB , 0xD89E},
{ 0x8CAC , 0xD89F},
{ 0x8CAD , 0xD8A0},
{ 0x4E8D , 0xD8A1},
{ 0x4E0C , 0xD8A2},
{ 0x5140 , 0xD8A3},
{ 0x4E10 , 0xD8A4},
{ 0x5EFF , 0xD8A5},
{ 0x5345 , 0xD8A6},
{ 0x4E15 , 0xD8A7},
{ 0x4E98 , 0xD8A8},
{ 0x4E1E , 0xD8A9},
{ 0x9B32 , 0xD8AA},
{ 0x5B6C , 0xD8AB},
{ 0x5669 , 0xD8AC},
{ 0x4E28 , 0xD8AD},
{ 0x79BA , 0xD8AE},
{ 0x4E3F , 0xD8AF},
{ 0x5315 , 0xD8B0},
{ 0x4E47 , 0xD8B1},
{ 0x592D , 0xD8B2},
{ 0x723B , 0xD8B3},
{ 0x536E , 0xD8B4},
{ 0x6C10 , 0xD8B5},
{ 0x56DF , 0xD8B6},
{ 0x80E4 , 0xD8B7},
{ 0x9997 , 0xD8B8},
{ 0x6BD3 , 0xD8B9},
{ 0x777E , 0xD8BA},
{ 0x9F17 , 0xD8BB},
{ 0x4E36 , 0xD8BC},
{ 0x4E9F , 0xD8BD},
{ 0x9F10 , 0xD8BE},
{ 0x4E5C , 0xD8BF},
{ 0x4E69 , 0xD8C0},
{ 0x4E93 , 0xD8C1},
{ 0x8288 , 0xD8C2},
{ 0x5B5B , 0xD8C3},
{ 0x556C , 0xD8C4},
{ 0x560F , 0xD8C5},
{ 0x4EC4 , 0xD8C6},
{ 0x538D , 0xD8C7},
{ 0x539D , 0xD8C8},
{ 0x53A3 , 0xD8C9},
{ 0x53A5 , 0xD8CA},
{ 0x53AE , 0xD8CB},
{ 0x9765 , 0xD8CC},
{ 0x8D5D , 0xD8CD},
{ 0x531A , 0xD8CE},
{ 0x53F5 , 0xD8CF},
{ 0x5326 , 0xD8D0},
{ 0x532E , 0xD8D1},
{ 0x533E , 0xD8D2},
{ 0x8D5C , 0xD8D3},
{ 0x5366 , 0xD8D4},
{ 0x5363 , 0xD8D5},
{ 0x5202 , 0xD8D6},
{ 0x5208 , 0xD8D7},
{ 0x520E , 0xD8D8},
{ 0x522D , 0xD8D9},
{ 0x5233 , 0xD8DA},
{ 0x523F , 0xD8DB},
{ 0x5240 , 0xD8DC},
{ 0x524C , 0xD8DD},
{ 0x525E , 0xD8DE},
{ 0x5261 , 0xD8DF},
{ 0x525C , 0xD8E0},
{ 0x84AF , 0xD8E1},
{ 0x527D , 0xD8E2},
{ 0x5282 , 0xD8E3},
{ 0x5281 , 0xD8E4},
{ 0x5290 , 0xD8E5},
{ 0x5293 , 0xD8E6},
{ 0x5182 , 0xD8E7},
{ 0x7F54 , 0xD8E8},
{ 0x4EBB , 0xD8E9},
{ 0x4EC3 , 0xD8EA},
{ 0x4EC9 , 0xD8EB},
{ 0x4EC2 , 0xD8EC},
{ 0x4EE8 , 0xD8ED},
{ 0x4EE1 , 0xD8EE},
{ 0x4EEB , 0xD8EF},
{ 0x4EDE , 0xD8F0},
{ 0x4F1B , 0xD8F1},
{ 0x4EF3 , 0xD8F2},
{ 0x4F22 , 0xD8F3},
{ 0x4F64 , 0xD8F4},
{ 0x4EF5 , 0xD8F5},
{ 0x4F25 , 0xD8F6},
{ 0x4F27 , 0xD8F7},
{ 0x4F09 , 0xD8F8},
{ 0x4F2B , 0xD8F9},
{ 0x4F5E , 0xD8FA},
{ 0x4F67 , 0xD8FB},
{ 0x6538 , 0xD8FC},
{ 0x4F5A , 0xD8FD},
{ 0x4F5D , 0xD8FE},
{ 0x8CAE , 0xD940},
{ 0x8CAF , 0xD941},
{ 0x8CB0 , 0xD942},
{ 0x8CB1 , 0xD943},
{ 0x8CB2 , 0xD944},
{ 0x8CB3 , 0xD945},
{ 0x8CB4 , 0xD946},
{ 0x8CB5 , 0xD947},
{ 0x8CB6 , 0xD948},
{ 0x8CB7 , 0xD949},
{ 0x8CB8 , 0xD94A},
{ 0x8CB9 , 0xD94B},
{ 0x8CBA , 0xD94C},
{ 0x8CBB , 0xD94D},
{ 0x8CBC , 0xD94E},
{ 0x8CBD , 0xD94F},
{ 0x8CBE , 0xD950},
{ 0x8CBF , 0xD951},
{ 0x8CC0 , 0xD952},
{ 0x8CC1 , 0xD953},
{ 0x8CC2 , 0xD954},
{ 0x8CC3 , 0xD955},
{ 0x8CC4 , 0xD956},
{ 0x8CC5 , 0xD957},
{ 0x8CC6 , 0xD958},
{ 0x8CC7 , 0xD959},
{ 0x8CC8 , 0xD95A},
{ 0x8CC9 , 0xD95B},
{ 0x8CCA , 0xD95C},
{ 0x8CCB , 0xD95D},
{ 0x8CCC , 0xD95E},
{ 0x8CCD , 0xD95F},
{ 0x8CCE , 0xD960},
{ 0x8CCF , 0xD961},
{ 0x8CD0 , 0xD962},
{ 0x8CD1 , 0xD963},
{ 0x8CD2 , 0xD964},
{ 0x8CD3 , 0xD965},
{ 0x8CD4 , 0xD966},
{ 0x8CD5 , 0xD967},
{ 0x8CD6 , 0xD968},
{ 0x8CD7 , 0xD969},
{ 0x8CD8 , 0xD96A},
{ 0x8CD9 , 0xD96B},
{ 0x8CDA , 0xD96C},
{ 0x8CDB , 0xD96D},
{ 0x8CDC , 0xD96E},
{ 0x8CDD , 0xD96F},
{ 0x8CDE , 0xD970},
{ 0x8CDF , 0xD971},
{ 0x8CE0 , 0xD972},
{ 0x8CE1 , 0xD973},
{ 0x8CE2 , 0xD974},
{ 0x8CE3 , 0xD975},
{ 0x8CE4 , 0xD976},
{ 0x8CE5 , 0xD977},
{ 0x8CE6 , 0xD978},
{ 0x8CE7 , 0xD979},
{ 0x8CE8 , 0xD97A},
{ 0x8CE9 , 0xD97B},
{ 0x8CEA , 0xD97C},
{ 0x8CEB , 0xD97D},
{ 0x8CEC , 0xD97E},
{ 0x8CED , 0xD980},
{ 0x8CEE , 0xD981},
{ 0x8CEF , 0xD982},
{ 0x8CF0 , 0xD983},
{ 0x8CF1 , 0xD984},
{ 0x8CF2 , 0xD985},
{ 0x8CF3 , 0xD986},
{ 0x8CF4 , 0xD987},
{ 0x8CF5 , 0xD988},
{ 0x8CF6 , 0xD989},
{ 0x8CF7 , 0xD98A},
{ 0x8CF8 , 0xD98B},
{ 0x8CF9 , 0xD98C},
{ 0x8CFA , 0xD98D},
{ 0x8CFB , 0xD98E},
{ 0x8CFC , 0xD98F},
{ 0x8CFD , 0xD990},
{ 0x8CFE , 0xD991},
{ 0x8CFF , 0xD992},
{ 0x8D00 , 0xD993},
{ 0x8D01 , 0xD994},
{ 0x8D02 , 0xD995},
{ 0x8D03 , 0xD996},
{ 0x8D04 , 0xD997},
{ 0x8D05 , 0xD998},
{ 0x8D06 , 0xD999},
{ 0x8D07 , 0xD99A},
{ 0x8D08 , 0xD99B},
{ 0x8D09 , 0xD99C},
{ 0x8D0A , 0xD99D},
{ 0x8D0B , 0xD99E},
{ 0x8D0C , 0xD99F},
{ 0x8D0D , 0xD9A0},
{ 0x4F5F , 0xD9A1},
{ 0x4F57 , 0xD9A2},
{ 0x4F32 , 0xD9A3},
{ 0x4F3D , 0xD9A4},
{ 0x4F76 , 0xD9A5},
{ 0x4F74 , 0xD9A6},
{ 0x4F91 , 0xD9A7},
{ 0x4F89 , 0xD9A8},
{ 0x4F83 , 0xD9A9},
{ 0x4F8F , 0xD9AA},
{ 0x4F7E , 0xD9AB},
{ 0x4F7B , 0xD9AC},
{ 0x4FAA , 0xD9AD},
{ 0x4F7C , 0xD9AE},
{ 0x4FAC , 0xD9AF},
{ 0x4F94 , 0xD9B0},
{ 0x4FE6 , 0xD9B1},
{ 0x4FE8 , 0xD9B2},
{ 0x4FEA , 0xD9B3},
{ 0x4FC5 , 0xD9B4},
{ 0x4FDA , 0xD9B5},
{ 0x4FE3 , 0xD9B6},
{ 0x4FDC , 0xD9B7},
{ 0x4FD1 , 0xD9B8},
{ 0x4FDF , 0xD9B9},
{ 0x4FF8 , 0xD9BA},
{ 0x5029 , 0xD9BB},
{ 0x504C , 0xD9BC},
{ 0x4FF3 , 0xD9BD},
{ 0x502C , 0xD9BE},
{ 0x500F , 0xD9BF},
{ 0x502E , 0xD9C0},
{ 0x502D , 0xD9C1},
{ 0x4FFE , 0xD9C2},
{ 0x501C , 0xD9C3},
{ 0x500C , 0xD9C4},
{ 0x5025 , 0xD9C5},
{ 0x5028 , 0xD9C6},
{ 0x507E , 0xD9C7},
{ 0x5043 , 0xD9C8},
{ 0x5055 , 0xD9C9},
{ 0x5048 , 0xD9CA},
{ 0x504E , 0xD9CB},
{ 0x506C , 0xD9CC},
{ 0x507B , 0xD9CD},
{ 0x50A5 , 0xD9CE},
{ 0x50A7 , 0xD9CF},
{ 0x50A9 , 0xD9D0},
{ 0x50BA , 0xD9D1},
{ 0x50D6 , 0xD9D2},
{ 0x5106 , 0xD9D3},
{ 0x50ED , 0xD9D4},
{ 0x50EC , 0xD9D5},
{ 0x50E6 , 0xD9D6},
{ 0x50EE , 0xD9D7},
{ 0x5107 , 0xD9D8},
{ 0x510B , 0xD9D9},
{ 0x4EDD , 0xD9DA},
{ 0x6C3D , 0xD9DB},
{ 0x4F58 , 0xD9DC},
{ 0x4F65 , 0xD9DD},
{ 0x4FCE , 0xD9DE},
{ 0x9FA0 , 0xD9DF},
{ 0x6C46 , 0xD9E0},
{ 0x7C74 , 0xD9E1},
{ 0x516E , 0xD9E2},
{ 0x5DFD , 0xD9E3},
{ 0x9EC9 , 0xD9E4},
{ 0x9998 , 0xD9E5},
{ 0x5181 , 0xD9E6},
{ 0x5914 , 0xD9E7},
{ 0x52F9 , 0xD9E8},
{ 0x530D , 0xD9E9},
{ 0x8A07 , 0xD9EA},
{ 0x5310 , 0xD9EB},
{ 0x51EB , 0xD9EC},
{ 0x5919 , 0xD9ED},
{ 0x5155 , 0xD9EE},
{ 0x4EA0 , 0xD9EF},
{ 0x5156 , 0xD9F0},
{ 0x4EB3 , 0xD9F1},
{ 0x886E , 0xD9F2},
{ 0x88A4 , 0xD9F3},
{ 0x4EB5 , 0xD9F4},
{ 0x8114 , 0xD9F5},
{ 0x88D2 , 0xD9F6},
{ 0x7980 , 0xD9F7},
{ 0x5B34 , 0xD9F8},
{ 0x8803 , 0xD9F9},
{ 0x7FB8 , 0xD9FA},
{ 0x51AB , 0xD9FB},
{ 0x51B1 , 0xD9FC},
{ 0x51BD , 0xD9FD},
{ 0x51BC , 0xD9FE},
{ 0x8D0E , 0xDA40},
{ 0x8D0F , 0xDA41},
{ 0x8D10 , 0xDA42},
{ 0x8D11 , 0xDA43},
{ 0x8D12 , 0xDA44},
{ 0x8D13 , 0xDA45},
{ 0x8D14 , 0xDA46},
{ 0x8D15 , 0xDA47},
{ 0x8D16 , 0xDA48},
{ 0x8D17 , 0xDA49},
{ 0x8D18 , 0xDA4A},
{ 0x8D19 , 0xDA4B},
{ 0x8D1A , 0xDA4C},
{ 0x8D1B , 0xDA4D},
{ 0x8D1C , 0xDA4E},
{ 0x8D20 , 0xDA4F},
{ 0x8D51 , 0xDA50},
{ 0x8D52 , 0xDA51},
{ 0x8D57 , 0xDA52},
{ 0x8D5F , 0xDA53},
{ 0x8D65 , 0xDA54},
{ 0x8D68 , 0xDA55},
{ 0x8D69 , 0xDA56},
{ 0x8D6A , 0xDA57},
{ 0x8D6C , 0xDA58},
{ 0x8D6E , 0xDA59},
{ 0x8D6F , 0xDA5A},
{ 0x8D71 , 0xDA5B},
{ 0x8D72 , 0xDA5C},
{ 0x8D78 , 0xDA5D},
{ 0x8D79 , 0xDA5E},
{ 0x8D7A , 0xDA5F},
{ 0x8D7B , 0xDA60},
{ 0x8D7C , 0xDA61},
{ 0x8D7D , 0xDA62},
{ 0x8D7E , 0xDA63},
{ 0x8D7F , 0xDA64},
{ 0x8D80 , 0xDA65},
{ 0x8D82 , 0xDA66},
{ 0x8D83 , 0xDA67},
{ 0x8D86 , 0xDA68},
{ 0x8D87 , 0xDA69},
{ 0x8D88 , 0xDA6A},
{ 0x8D89 , 0xDA6B},
{ 0x8D8C , 0xDA6C},
{ 0x8D8D , 0xDA6D},
{ 0x8D8E , 0xDA6E},
{ 0x8D8F , 0xDA6F},
{ 0x8D90 , 0xDA70},
{ 0x8D92 , 0xDA71},
{ 0x8D93 , 0xDA72},
{ 0x8D95 , 0xDA73},
{ 0x8D96 , 0xDA74},
{ 0x8D97 , 0xDA75},
{ 0x8D98 , 0xDA76},
{ 0x8D99 , 0xDA77},
{ 0x8D9A , 0xDA78},
{ 0x8D9B , 0xDA79},
{ 0x8D9C , 0xDA7A},
{ 0x8D9D , 0xDA7B},
{ 0x8D9E , 0xDA7C},
{ 0x8DA0 , 0xDA7D},
{ 0x8DA1 , 0xDA7E},
{ 0x8DA2 , 0xDA80},
{ 0x8DA4 , 0xDA81},
{ 0x8DA5 , 0xDA82},
{ 0x8DA6 , 0xDA83},
{ 0x8DA7 , 0xDA84},
{ 0x8DA8 , 0xDA85},
{ 0x8DA9 , 0xDA86},
{ 0x8DAA , 0xDA87},
{ 0x8DAB , 0xDA88},
{ 0x8DAC , 0xDA89},
{ 0x8DAD , 0xDA8A},
{ 0x8DAE , 0xDA8B},
{ 0x8DAF , 0xDA8C},
{ 0x8DB0 , 0xDA8D},
{ 0x8DB2 , 0xDA8E},
{ 0x8DB6 , 0xDA8F},
{ 0x8DB7 , 0xDA90},
{ 0x8DB9 , 0xDA91},
{ 0x8DBB , 0xDA92},
{ 0x8DBD , 0xDA93},
{ 0x8DC0 , 0xDA94},
{ 0x8DC1 , 0xDA95},
{ 0x8DC2 , 0xDA96},
{ 0x8DC5 , 0xDA97},
{ 0x8DC7 , 0xDA98},
{ 0x8DC8 , 0xDA99},
{ 0x8DC9 , 0xDA9A},
{ 0x8DCA , 0xDA9B},
{ 0x8DCD , 0xDA9C},
{ 0x8DD0 , 0xDA9D},
{ 0x8DD2 , 0xDA9E},
{ 0x8DD3 , 0xDA9F},
{ 0x8DD4 , 0xDAA0},
{ 0x51C7 , 0xDAA1},
{ 0x5196 , 0xDAA2},
{ 0x51A2 , 0xDAA3},
{ 0x51A5 , 0xDAA4},
{ 0x8BA0 , 0xDAA5},
{ 0x8BA6 , 0xDAA6},
{ 0x8BA7 , 0xDAA7},
{ 0x8BAA , 0xDAA8},
{ 0x8BB4 , 0xDAA9},
{ 0x8BB5 , 0xDAAA},
{ 0x8BB7 , 0xDAAB},
{ 0x8BC2 , 0xDAAC},
{ 0x8BC3 , 0xDAAD},
{ 0x8BCB , 0xDAAE},
{ 0x8BCF , 0xDAAF},
{ 0x8BCE , 0xDAB0},
{ 0x8BD2 , 0xDAB1},
{ 0x8BD3 , 0xDAB2},
{ 0x8BD4 , 0xDAB3},
{ 0x8BD6 , 0xDAB4},
{ 0x8BD8 , 0xDAB5},
{ 0x8BD9 , 0xDAB6},
{ 0x8BDC , 0xDAB7},
{ 0x8BDF , 0xDAB8},
{ 0x8BE0 , 0xDAB9},
{ 0x8BE4 , 0xDABA},
{ 0x8BE8 , 0xDABB},
{ 0x8BE9 , 0xDABC},
{ 0x8BEE , 0xDABD},
{ 0x8BF0 , 0xDABE},
{ 0x8BF3 , 0xDABF},
{ 0x8BF6 , 0xDAC0},
{ 0x8BF9 , 0xDAC1},
{ 0x8BFC , 0xDAC2},
{ 0x8BFF , 0xDAC3},
{ 0x8C00 , 0xDAC4},
{ 0x8C02 , 0xDAC5},
{ 0x8C04 , 0xDAC6},
{ 0x8C07 , 0xDAC7},
{ 0x8C0C , 0xDAC8},
{ 0x8C0F , 0xDAC9},
{ 0x8C11 , 0xDACA},
{ 0x8C12 , 0xDACB},
{ 0x8C14 , 0xDACC},
{ 0x8C15 , 0xDACD},
{ 0x8C16 , 0xDACE},
{ 0x8C19 , 0xDACF},
{ 0x8C1B , 0xDAD0},
{ 0x8C18 , 0xDAD1},
{ 0x8C1D , 0xDAD2},
{ 0x8C1F , 0xDAD3},
{ 0x8C20 , 0xDAD4},
{ 0x8C21 , 0xDAD5},
{ 0x8C25 , 0xDAD6},
{ 0x8C27 , 0xDAD7},
{ 0x8C2A , 0xDAD8},
{ 0x8C2B , 0xDAD9},
{ 0x8C2E , 0xDADA},
{ 0x8C2F , 0xDADB},
{ 0x8C32 , 0xDADC},
{ 0x8C33 , 0xDADD},
{ 0x8C35 , 0xDADE},
{ 0x8C36 , 0xDADF},
{ 0x5369 , 0xDAE0},
{ 0x537A , 0xDAE1},
{ 0x961D , 0xDAE2},
{ 0x9622 , 0xDAE3},
{ 0x9621 , 0xDAE4},
{ 0x9631 , 0xDAE5},
{ 0x962A , 0xDAE6},
{ 0x963D , 0xDAE7},
{ 0x963C , 0xDAE8},
{ 0x9642 , 0xDAE9},
{ 0x9649 , 0xDAEA},
{ 0x9654 , 0xDAEB},
{ 0x965F , 0xDAEC},
{ 0x9667 , 0xDAED},
{ 0x966C , 0xDAEE},
{ 0x9672 , 0xDAEF},
{ 0x9674 , 0xDAF0},
{ 0x9688 , 0xDAF1},
{ 0x968D , 0xDAF2},
{ 0x9697 , 0xDAF3},
{ 0x96B0 , 0xDAF4},
{ 0x9097 , 0xDAF5},
{ 0x909B , 0xDAF6},
{ 0x909D , 0xDAF7},
{ 0x9099 , 0xDAF8},
{ 0x90AC , 0xDAF9},
{ 0x90A1 , 0xDAFA},
{ 0x90B4 , 0xDAFB},
{ 0x90B3 , 0xDAFC},
{ 0x90B6 , 0xDAFD},
{ 0x90BA , 0xDAFE},
{ 0x8DD5 , 0xDB40},
{ 0x8DD8 , 0xDB41},
{ 0x8DD9 , 0xDB42},
{ 0x8DDC , 0xDB43},
{ 0x8DE0 , 0xDB44},
{ 0x8DE1 , 0xDB45},
{ 0x8DE2 , 0xDB46},
{ 0x8DE5 , 0xDB47},
{ 0x8DE6 , 0xDB48},
{ 0x8DE7 , 0xDB49},
{ 0x8DE9 , 0xDB4A},
{ 0x8DED , 0xDB4B},
{ 0x8DEE , 0xDB4C},
{ 0x8DF0 , 0xDB4D},
{ 0x8DF1 , 0xDB4E},
{ 0x8DF2 , 0xDB4F},
{ 0x8DF4 , 0xDB50},
{ 0x8DF6 , 0xDB51},
{ 0x8DFC , 0xDB52},
{ 0x8DFE , 0xDB53},
{ 0x8DFF , 0xDB54},
{ 0x8E00 , 0xDB55},
{ 0x8E01 , 0xDB56},
{ 0x8E02 , 0xDB57},
{ 0x8E03 , 0xDB58},
{ 0x8E04 , 0xDB59},
{ 0x8E06 , 0xDB5A},
{ 0x8E07 , 0xDB5B},
{ 0x8E08 , 0xDB5C},
{ 0x8E0B , 0xDB5D},
{ 0x8E0D , 0xDB5E},
{ 0x8E0E , 0xDB5F},
{ 0x8E10 , 0xDB60},
{ 0x8E11 , 0xDB61},
{ 0x8E12 , 0xDB62},
{ 0x8E13 , 0xDB63},
{ 0x8E15 , 0xDB64},
{ 0x8E16 , 0xDB65},
{ 0x8E17 , 0xDB66},
{ 0x8E18 , 0xDB67},
{ 0x8E19 , 0xDB68},
{ 0x8E1A , 0xDB69},
{ 0x8E1B , 0xDB6A},
{ 0x8E1C , 0xDB6B},
{ 0x8E20 , 0xDB6C},
{ 0x8E21 , 0xDB6D},
{ 0x8E24 , 0xDB6E},
{ 0x8E25 , 0xDB6F},
{ 0x8E26 , 0xDB70},
{ 0x8E27 , 0xDB71},
{ 0x8E28 , 0xDB72},
{ 0x8E2B , 0xDB73},
{ 0x8E2D , 0xDB74},
{ 0x8E30 , 0xDB75},
{ 0x8E32 , 0xDB76},
{ 0x8E33 , 0xDB77},
{ 0x8E34 , 0xDB78},
{ 0x8E36 , 0xDB79},
{ 0x8E37 , 0xDB7A},
{ 0x8E38 , 0xDB7B},
{ 0x8E3B , 0xDB7C},
{ 0x8E3C , 0xDB7D},
{ 0x8E3E , 0xDB7E},
{ 0x8E3F , 0xDB80},
{ 0x8E43 , 0xDB81},
{ 0x8E45 , 0xDB82},
{ 0x8E46 , 0xDB83},
{ 0x8E4C , 0xDB84},
{ 0x8E4D , 0xDB85},
{ 0x8E4E , 0xDB86},
{ 0x8E4F , 0xDB87},
{ 0x8E50 , 0xDB88},
{ 0x8E53 , 0xDB89},
{ 0x8E54 , 0xDB8A},
{ 0x8E55 , 0xDB8B},
{ 0x8E56 , 0xDB8C},
{ 0x8E57 , 0xDB8D},
{ 0x8E58 , 0xDB8E},
{ 0x8E5A , 0xDB8F},
{ 0x8E5B , 0xDB90},
{ 0x8E5C , 0xDB91},
{ 0x8E5D , 0xDB92},
{ 0x8E5E , 0xDB93},
{ 0x8E5F , 0xDB94},
{ 0x8E60 , 0xDB95},
{ 0x8E61 , 0xDB96},
{ 0x8E62 , 0xDB97},
{ 0x8E63 , 0xDB98},
{ 0x8E64 , 0xDB99},
{ 0x8E65 , 0xDB9A},
{ 0x8E67 , 0xDB9B},
{ 0x8E68 , 0xDB9C},
{ 0x8E6A , 0xDB9D},
{ 0x8E6B , 0xDB9E},
{ 0x8E6E , 0xDB9F},
{ 0x8E71 , 0xDBA0},
{ 0x90B8 , 0xDBA1},
{ 0x90B0 , 0xDBA2},
{ 0x90CF , 0xDBA3},
{ 0x90C5 , 0xDBA4},
{ 0x90BE , 0xDBA5},
{ 0x90D0 , 0xDBA6},
{ 0x90C4 , 0xDBA7},
{ 0x90C7 , 0xDBA8},
{ 0x90D3 , 0xDBA9},
{ 0x90E6 , 0xDBAA},
{ 0x90E2 , 0xDBAB},
{ 0x90DC , 0xDBAC},
{ 0x90D7 , 0xDBAD},
{ 0x90DB , 0xDBAE},
{ 0x90EB , 0xDBAF},
{ 0x90EF , 0xDBB0},
{ 0x90FE , 0xDBB1},
{ 0x9104 , 0xDBB2},
{ 0x9122 , 0xDBB3},
{ 0x911E , 0xDBB4},
{ 0x9123 , 0xDBB5},
{ 0x9131 , 0xDBB6},
{ 0x912F , 0xDBB7},
{ 0x9139 , 0xDBB8},
{ 0x9143 , 0xDBB9},
{ 0x9146 , 0xDBBA},
{ 0x520D , 0xDBBB},
{ 0x5942 , 0xDBBC},
{ 0x52A2 , 0xDBBD},
{ 0x52AC , 0xDBBE},
{ 0x52AD , 0xDBBF},
{ 0x52BE , 0xDBC0},
{ 0x54FF , 0xDBC1},
{ 0x52D0 , 0xDBC2},
{ 0x52D6 , 0xDBC3},
{ 0x52F0 , 0xDBC4},
{ 0x53DF , 0xDBC5},
{ 0x71EE , 0xDBC6},
{ 0x77CD , 0xDBC7},
{ 0x5EF4 , 0xDBC8},
{ 0x51F5 , 0xDBC9},
{ 0x51FC , 0xDBCA},
{ 0x9B2F , 0xDBCB},
{ 0x53B6 , 0xDBCC},
{ 0x5F01 , 0xDBCD},
{ 0x755A , 0xDBCE},
{ 0x5DEF , 0xDBCF},
{ 0x574C , 0xDBD0},
{ 0x57A9 , 0xDBD1},
{ 0x57A1 , 0xDBD2},
{ 0x587E , 0xDBD3},
{ 0x58BC , 0xDBD4},
{ 0x58C5 , 0xDBD5},
{ 0x58D1 , 0xDBD6},
{ 0x5729 , 0xDBD7},
{ 0x572C , 0xDBD8},
{ 0x572A , 0xDBD9},
{ 0x5733 , 0xDBDA},
{ 0x5739 , 0xDBDB},
{ 0x572E , 0xDBDC},
{ 0x572F , 0xDBDD},
{ 0x575C , 0xDBDE},
{ 0x573B , 0xDBDF},
{ 0x5742 , 0xDBE0},
{ 0x5769 , 0xDBE1},
{ 0x5785 , 0xDBE2},
{ 0x576B , 0xDBE3},
{ 0x5786 , 0xDBE4},
{ 0x577C , 0xDBE5},
{ 0x577B , 0xDBE6},
{ 0x5768 , 0xDBE7},
{ 0x576D , 0xDBE8},
{ 0x5776 , 0xDBE9},
{ 0x5773 , 0xDBEA},
{ 0x57AD , 0xDBEB},
{ 0x57A4 , 0xDBEC},
{ 0x578C , 0xDBED},
{ 0x57B2 , 0xDBEE},
{ 0x57CF , 0xDBEF},
{ 0x57A7 , 0xDBF0},
{ 0x57B4 , 0xDBF1},
{ 0x5793 , 0xDBF2},
{ 0x57A0 , 0xDBF3},
{ 0x57D5 , 0xDBF4},
{ 0x57D8 , 0xDBF5},
{ 0x57DA , 0xDBF6},
{ 0x57D9 , 0xDBF7},
{ 0x57D2 , 0xDBF8},
{ 0x57B8 , 0xDBF9},
{ 0x57F4 , 0xDBFA},
{ 0x57EF , 0xDBFB},
{ 0x57F8 , 0xDBFC},
{ 0x57E4 , 0xDBFD},
{ 0x57DD , 0xDBFE},
{ 0x8E73 , 0xDC40},
{ 0x8E75 , 0xDC41},
{ 0x8E77 , 0xDC42},
{ 0x8E78 , 0xDC43},
{ 0x8E79 , 0xDC44},
{ 0x8E7A , 0xDC45},
{ 0x8E7B , 0xDC46},
{ 0x8E7D , 0xDC47},
{ 0x8E7E , 0xDC48},
{ 0x8E80 , 0xDC49},
{ 0x8E82 , 0xDC4A},
{ 0x8E83 , 0xDC4B},
{ 0x8E84 , 0xDC4C},
{ 0x8E86 , 0xDC4D},
{ 0x8E88 , 0xDC4E},
{ 0x8E89 , 0xDC4F},
{ 0x8E8A , 0xDC50},
{ 0x8E8B , 0xDC51},
{ 0x8E8C , 0xDC52},
{ 0x8E8D , 0xDC53},
{ 0x8E8E , 0xDC54},
{ 0x8E91 , 0xDC55},
{ 0x8E92 , 0xDC56},
{ 0x8E93 , 0xDC57},
{ 0x8E95 , 0xDC58},
{ 0x8E96 , 0xDC59},
{ 0x8E97 , 0xDC5A},
{ 0x8E98 , 0xDC5B},
{ 0x8E99 , 0xDC5C},
{ 0x8E9A , 0xDC5D},
{ 0x8E9B , 0xDC5E},
{ 0x8E9D , 0xDC5F},
{ 0x8E9F , 0xDC60},
{ 0x8EA0 , 0xDC61},
{ 0x8EA1 , 0xDC62},
{ 0x8EA2 , 0xDC63},
{ 0x8EA3 , 0xDC64},
{ 0x8EA4 , 0xDC65},
{ 0x8EA5 , 0xDC66},
{ 0x8EA6 , 0xDC67},
{ 0x8EA7 , 0xDC68},
{ 0x8EA8 , 0xDC69},
{ 0x8EA9 , 0xDC6A},
{ 0x8EAA , 0xDC6B},
{ 0x8EAD , 0xDC6C},
{ 0x8EAE , 0xDC6D},
{ 0x8EB0 , 0xDC6E},
{ 0x8EB1 , 0xDC6F},
{ 0x8EB3 , 0xDC70},
{ 0x8EB4 , 0xDC71},
{ 0x8EB5 , 0xDC72},
{ 0x8EB6 , 0xDC73},
{ 0x8EB7 , 0xDC74},
{ 0x8EB8 , 0xDC75},
{ 0x8EB9 , 0xDC76},
{ 0x8EBB , 0xDC77},
{ 0x8EBC , 0xDC78},
{ 0x8EBD , 0xDC79},
{ 0x8EBE , 0xDC7A},
{ 0x8EBF , 0xDC7B},
{ 0x8EC0 , 0xDC7C},
{ 0x8EC1 , 0xDC7D},
{ 0x8EC2 , 0xDC7E},
{ 0x8EC3 , 0xDC80},
{ 0x8EC4 , 0xDC81},
{ 0x8EC5 , 0xDC82},
{ 0x8EC6 , 0xDC83},
{ 0x8EC7 , 0xDC84},
{ 0x8EC8 , 0xDC85},
{ 0x8EC9 , 0xDC86},
{ 0x8ECA , 0xDC87},
{ 0x8ECB , 0xDC88},
{ 0x8ECC , 0xDC89},
{ 0x8ECD , 0xDC8A},
{ 0x8ECF , 0xDC8B},
{ 0x8ED0 , 0xDC8C},
{ 0x8ED1 , 0xDC8D},
{ 0x8ED2 , 0xDC8E},
{ 0x8ED3 , 0xDC8F},
{ 0x8ED4 , 0xDC90},
{ 0x8ED5 , 0xDC91},
{ 0x8ED6 , 0xDC92},
{ 0x8ED7 , 0xDC93},
{ 0x8ED8 , 0xDC94},
{ 0x8ED9 , 0xDC95},
{ 0x8EDA , 0xDC96},
{ 0x8EDB , 0xDC97},
{ 0x8EDC , 0xDC98},
{ 0x8EDD , 0xDC99},
{ 0x8EDE , 0xDC9A},
{ 0x8EDF , 0xDC9B},
{ 0x8EE0 , 0xDC9C},
{ 0x8EE1 , 0xDC9D},
{ 0x8EE2 , 0xDC9E},
{ 0x8EE3 , 0xDC9F},
{ 0x8EE4 , 0xDCA0},
{ 0x580B , 0xDCA1},
{ 0x580D , 0xDCA2},
{ 0x57FD , 0xDCA3},
{ 0x57ED , 0xDCA4},
{ 0x5800 , 0xDCA5},
{ 0x581E , 0xDCA6},
{ 0x5819 , 0xDCA7},
{ 0x5844 , 0xDCA8},
{ 0x5820 , 0xDCA9},
{ 0x5865 , 0xDCAA},
{ 0x586C , 0xDCAB},
{ 0x5881 , 0xDCAC},
{ 0x5889 , 0xDCAD},
{ 0x589A , 0xDCAE},
{ 0x5880 , 0xDCAF},
{ 0x99A8 , 0xDCB0},
{ 0x9F19 , 0xDCB1},
{ 0x61FF , 0xDCB2},
{ 0x8279 , 0xDCB3},
{ 0x827D , 0xDCB4},
{ 0x827F , 0xDCB5},
{ 0x828F , 0xDCB6},
{ 0x828A , 0xDCB7},
{ 0x82A8 , 0xDCB8},
{ 0x8284 , 0xDCB9},
{ 0x828E , 0xDCBA},
{ 0x8291 , 0xDCBB},
{ 0x8297 , 0xDCBC},
{ 0x8299 , 0xDCBD},
{ 0x82AB , 0xDCBE},
{ 0x82B8 , 0xDCBF},
{ 0x82BE , 0xDCC0},
{ 0x82B0 , 0xDCC1},
{ 0x82C8 , 0xDCC2},
{ 0x82CA , 0xDCC3},
{ 0x82E3 , 0xDCC4},
{ 0x8298 , 0xDCC5},
{ 0x82B7 , 0xDCC6},
{ 0x82AE , 0xDCC7},
{ 0x82CB , 0xDCC8},
{ 0x82CC , 0xDCC9},
{ 0x82C1 , 0xDCCA},
{ 0x82A9 , 0xDCCB},
{ 0x82B4 , 0xDCCC},
{ 0x82A1 , 0xDCCD},
{ 0x82AA , 0xDCCE},
{ 0x829F , 0xDCCF},
{ 0x82C4 , 0xDCD0},
{ 0x82CE , 0xDCD1},
{ 0x82A4 , 0xDCD2},
{ 0x82E1 , 0xDCD3},
{ 0x8309 , 0xDCD4},
{ 0x82F7 , 0xDCD5},
{ 0x82E4 , 0xDCD6},
{ 0x830F , 0xDCD7},
{ 0x8307 , 0xDCD8},
{ 0x82DC , 0xDCD9},
{ 0x82F4 , 0xDCDA},
{ 0x82D2 , 0xDCDB},
{ 0x82D8 , 0xDCDC},
{ 0x830C , 0xDCDD},
{ 0x82FB , 0xDCDE},
{ 0x82D3 , 0xDCDF},
{ 0x8311 , 0xDCE0},
{ 0x831A , 0xDCE1},
{ 0x8306 , 0xDCE2},
{ 0x8314 , 0xDCE3},
{ 0x8315 , 0xDCE4},
{ 0x82E0 , 0xDCE5},
{ 0x82D5 , 0xDCE6},
{ 0x831C , 0xDCE7},
{ 0x8351 , 0xDCE8},
{ 0x835B , 0xDCE9},
{ 0x835C , 0xDCEA},
{ 0x8308 , 0xDCEB},
{ 0x8392 , 0xDCEC},
{ 0x833C , 0xDCED},
{ 0x8334 , 0xDCEE},
{ 0x8331 , 0xDCEF},
{ 0x839B , 0xDCF0},
{ 0x835E , 0xDCF1},
{ 0x832F , 0xDCF2},
{ 0x834F , 0xDCF3},
{ 0x8347 , 0xDCF4},
{ 0x8343 , 0xDCF5},
{ 0x835F , 0xDCF6},
{ 0x8340 , 0xDCF7},
{ 0x8317 , 0xDCF8},
{ 0x8360 , 0xDCF9},
{ 0x832D , 0xDCFA},
{ 0x833A , 0xDCFB},
{ 0x8333 , 0xDCFC},
{ 0x8366 , 0xDCFD},
{ 0x8365 , 0xDCFE},
{ 0x8EE5 , 0xDD40},
{ 0x8EE6 , 0xDD41},
{ 0x8EE7 , 0xDD42},
{ 0x8EE8 , 0xDD43},
{ 0x8EE9 , 0xDD44},
{ 0x8EEA , 0xDD45},
{ 0x8EEB , 0xDD46},
{ 0x8EEC , 0xDD47},
{ 0x8EED , 0xDD48},
{ 0x8EEE , 0xDD49},
{ 0x8EEF , 0xDD4A},
{ 0x8EF0 , 0xDD4B},
{ 0x8EF1 , 0xDD4C},
{ 0x8EF2 , 0xDD4D},
{ 0x8EF3 , 0xDD4E},
{ 0x8EF4 , 0xDD4F},
{ 0x8EF5 , 0xDD50},
{ 0x8EF6 , 0xDD51},
{ 0x8EF7 , 0xDD52},
{ 0x8EF8 , 0xDD53},
{ 0x8EF9 , 0xDD54},
{ 0x8EFA , 0xDD55},
{ 0x8EFB , 0xDD56},
{ 0x8EFC , 0xDD57},
{ 0x8EFD , 0xDD58},
{ 0x8EFE , 0xDD59},
{ 0x8EFF , 0xDD5A},
{ 0x8F00 , 0xDD5B},
{ 0x8F01 , 0xDD5C},
{ 0x8F02 , 0xDD5D},
{ 0x8F03 , 0xDD5E},
{ 0x8F04 , 0xDD5F},
{ 0x8F05 , 0xDD60},
{ 0x8F06 , 0xDD61},
{ 0x8F07 , 0xDD62},
{ 0x8F08 , 0xDD63},
{ 0x8F09 , 0xDD64},
{ 0x8F0A , 0xDD65},
{ 0x8F0B , 0xDD66},
{ 0x8F0C , 0xDD67},
{ 0x8F0D , 0xDD68},
{ 0x8F0E , 0xDD69},
{ 0x8F0F , 0xDD6A},
{ 0x8F10 , 0xDD6B},
{ 0x8F11 , 0xDD6C},
{ 0x8F12 , 0xDD6D},
{ 0x8F13 , 0xDD6E},
{ 0x8F14 , 0xDD6F},
{ 0x8F15 , 0xDD70},
{ 0x8F16 , 0xDD71},
{ 0x8F17 , 0xDD72},
{ 0x8F18 , 0xDD73},
{ 0x8F19 , 0xDD74},
{ 0x8F1A , 0xDD75},
{ 0x8F1B , 0xDD76},
{ 0x8F1C , 0xDD77},
{ 0x8F1D , 0xDD78},
{ 0x8F1E , 0xDD79},
{ 0x8F1F , 0xDD7A},
{ 0x8F20 , 0xDD7B},
{ 0x8F21 , 0xDD7C},
{ 0x8F22 , 0xDD7D},
{ 0x8F23 , 0xDD7E},
{ 0x8F24 , 0xDD80},
{ 0x8F25 , 0xDD81},
{ 0x8F26 , 0xDD82},
{ 0x8F27 , 0xDD83},
{ 0x8F28 , 0xDD84},
{ 0x8F29 , 0xDD85},
{ 0x8F2A , 0xDD86},
{ 0x8F2B , 0xDD87},
{ 0x8F2C , 0xDD88},
{ 0x8F2D , 0xDD89},
{ 0x8F2E , 0xDD8A},
{ 0x8F2F , 0xDD8B},
{ 0x8F30 , 0xDD8C},
{ 0x8F31 , 0xDD8D},
{ 0x8F32 , 0xDD8E},
{ 0x8F33 , 0xDD8F},
{ 0x8F34 , 0xDD90},
{ 0x8F35 , 0xDD91},
{ 0x8F36 , 0xDD92},
{ 0x8F37 , 0xDD93},
{ 0x8F38 , 0xDD94},
{ 0x8F39 , 0xDD95},
{ 0x8F3A , 0xDD96},
{ 0x8F3B , 0xDD97},
{ 0x8F3C , 0xDD98},
{ 0x8F3D , 0xDD99},
{ 0x8F3E , 0xDD9A},
{ 0x8F3F , 0xDD9B},
{ 0x8F40 , 0xDD9C},
{ 0x8F41 , 0xDD9D},
{ 0x8F42 , 0xDD9E},
{ 0x8F43 , 0xDD9F},
{ 0x8F44 , 0xDDA0},
{ 0x8368 , 0xDDA1},
{ 0x831B , 0xDDA2},
{ 0x8369 , 0xDDA3},
{ 0x836C , 0xDDA4},
{ 0x836A , 0xDDA5},
{ 0x836D , 0xDDA6},
{ 0x836E , 0xDDA7},
{ 0x83B0 , 0xDDA8},
{ 0x8378 , 0xDDA9},
{ 0x83B3 , 0xDDAA},
{ 0x83B4 , 0xDDAB},
{ 0x83A0 , 0xDDAC},
{ 0x83AA , 0xDDAD},
{ 0x8393 , 0xDDAE},
{ 0x839C , 0xDDAF},
{ 0x8385 , 0xDDB0},
{ 0x837C , 0xDDB1},
{ 0x83B6 , 0xDDB2},
{ 0x83A9 , 0xDDB3},
{ 0x837D , 0xDDB4},
{ 0x83B8 , 0xDDB5},
{ 0x837B , 0xDDB6},
{ 0x8398 , 0xDDB7},
{ 0x839E , 0xDDB8},
{ 0x83A8 , 0xDDB9},
{ 0x83BA , 0xDDBA},
{ 0x83BC , 0xDDBB},
{ 0x83C1 , 0xDDBC},
{ 0x8401 , 0xDDBD},
{ 0x83E5 , 0xDDBE},
{ 0x83D8 , 0xDDBF},
{ 0x5807 , 0xDDC0},
{ 0x8418 , 0xDDC1},
{ 0x840B , 0xDDC2},
{ 0x83DD , 0xDDC3},
{ 0x83FD , 0xDDC4},
{ 0x83D6 , 0xDDC5},
{ 0x841C , 0xDDC6},
{ 0x8438 , 0xDDC7},
{ 0x8411 , 0xDDC8},
{ 0x8406 , 0xDDC9},
{ 0x83D4 , 0xDDCA},
{ 0x83DF , 0xDDCB},
{ 0x840F , 0xDDCC},
{ 0x8403 , 0xDDCD},
{ 0x83F8 , 0xDDCE},
{ 0x83F9 , 0xDDCF},
{ 0x83EA , 0xDDD0},
{ 0x83C5 , 0xDDD1},
{ 0x83C0 , 0xDDD2},
{ 0x8426 , 0xDDD3},
{ 0x83F0 , 0xDDD4},
{ 0x83E1 , 0xDDD5},
{ 0x845C , 0xDDD6},
{ 0x8451 , 0xDDD7},
{ 0x845A , 0xDDD8},
{ 0x8459 , 0xDDD9},
{ 0x8473 , 0xDDDA},
{ 0x8487 , 0xDDDB},
{ 0x8488 , 0xDDDC},
{ 0x847A , 0xDDDD},
{ 0x8489 , 0xDDDE},
{ 0x8478 , 0xDDDF},
{ 0x843C , 0xDDE0},
{ 0x8446 , 0xDDE1},
{ 0x8469 , 0xDDE2},
{ 0x8476 , 0xDDE3},
{ 0x848C , 0xDDE4},
{ 0x848E , 0xDDE5},
{ 0x8431 , 0xDDE6},
{ 0x846D , 0xDDE7},
{ 0x84C1 , 0xDDE8},
{ 0x84CD , 0xDDE9},
{ 0x84D0 , 0xDDEA},
{ 0x84E6 , 0xDDEB},
{ 0x84BD , 0xDDEC},
{ 0x84D3 , 0xDDED},
{ 0x84CA , 0xDDEE},
{ 0x84BF , 0xDDEF},
{ 0x84BA , 0xDDF0},
{ 0x84E0 , 0xDDF1},
{ 0x84A1 , 0xDDF2},
{ 0x84B9 , 0xDDF3},
{ 0x84B4 , 0xDDF4},
{ 0x8497 , 0xDDF5},
{ 0x84E5 , 0xDDF6},
{ 0x84E3 , 0xDDF7},
{ 0x850C , 0xDDF8},
{ 0x750D , 0xDDF9},
{ 0x8538 , 0xDDFA},
{ 0x84F0 , 0xDDFB},
{ 0x8539 , 0xDDFC},
{ 0x851F , 0xDDFD},
{ 0x853A , 0xDDFE},
{ 0x8F45 , 0xDE40},
{ 0x8F46 , 0xDE41},
{ 0x8F47 , 0xDE42},
{ 0x8F48 , 0xDE43},
{ 0x8F49 , 0xDE44},
{ 0x8F4A , 0xDE45},
{ 0x8F4B , 0xDE46},
{ 0x8F4C , 0xDE47},
{ 0x8F4D , 0xDE48},
{ 0x8F4E , 0xDE49},
{ 0x8F4F , 0xDE4A},
{ 0x8F50 , 0xDE4B},
{ 0x8F51 , 0xDE4C},
{ 0x8F52 , 0xDE4D},
{ 0x8F53 , 0xDE4E},
{ 0x8F54 , 0xDE4F},
{ 0x8F55 , 0xDE50},
{ 0x8F56 , 0xDE51},
{ 0x8F57 , 0xDE52},
{ 0x8F58 , 0xDE53},
{ 0x8F59 , 0xDE54},
{ 0x8F5A , 0xDE55},
{ 0x8F5B , 0xDE56},
{ 0x8F5C , 0xDE57},
{ 0x8F5D , 0xDE58},
{ 0x8F5E , 0xDE59},
{ 0x8F5F , 0xDE5A},
{ 0x8F60 , 0xDE5B},
{ 0x8F61 , 0xDE5C},
{ 0x8F62 , 0xDE5D},
{ 0x8F63 , 0xDE5E},
{ 0x8F64 , 0xDE5F},
{ 0x8F65 , 0xDE60},
{ 0x8F6A , 0xDE61},
{ 0x8F80 , 0xDE62},
{ 0x8F8C , 0xDE63},
{ 0x8F92 , 0xDE64},
{ 0x8F9D , 0xDE65},
{ 0x8FA0 , 0xDE66},
{ 0x8FA1 , 0xDE67},
{ 0x8FA2 , 0xDE68},
{ 0x8FA4 , 0xDE69},
{ 0x8FA5 , 0xDE6A},
{ 0x8FA6 , 0xDE6B},
{ 0x8FA7 , 0xDE6C},
{ 0x8FAA , 0xDE6D},
{ 0x8FAC , 0xDE6E},
{ 0x8FAD , 0xDE6F},
{ 0x8FAE , 0xDE70},
{ 0x8FAF , 0xDE71},
{ 0x8FB2 , 0xDE72},
{ 0x8FB3 , 0xDE73},
{ 0x8FB4 , 0xDE74},
{ 0x8FB5 , 0xDE75},
{ 0x8FB7 , 0xDE76},
{ 0x8FB8 , 0xDE77},
{ 0x8FBA , 0xDE78},
{ 0x8FBB , 0xDE79},
{ 0x8FBC , 0xDE7A},
{ 0x8FBF , 0xDE7B},
{ 0x8FC0 , 0xDE7C},
{ 0x8FC3 , 0xDE7D},
{ 0x8FC6 , 0xDE7E},
{ 0x8FC9 , 0xDE80},
{ 0x8FCA , 0xDE81},
{ 0x8FCB , 0xDE82},
{ 0x8FCC , 0xDE83},
{ 0x8FCD , 0xDE84},
{ 0x8FCF , 0xDE85},
{ 0x8FD2 , 0xDE86},
{ 0x8FD6 , 0xDE87},
{ 0x8FD7 , 0xDE88},
{ 0x8FDA , 0xDE89},
{ 0x8FE0 , 0xDE8A},
{ 0x8FE1 , 0xDE8B},
{ 0x8FE3 , 0xDE8C},
{ 0x8FE7 , 0xDE8D},
{ 0x8FEC , 0xDE8E},
{ 0x8FEF , 0xDE8F},
{ 0x8FF1 , 0xDE90},
{ 0x8FF2 , 0xDE91},
{ 0x8FF4 , 0xDE92},
{ 0x8FF5 , 0xDE93},
{ 0x8FF6 , 0xDE94},
{ 0x8FFA , 0xDE95},
{ 0x8FFB , 0xDE96},
{ 0x8FFC , 0xDE97},
{ 0x8FFE , 0xDE98},
{ 0x8FFF , 0xDE99},
{ 0x9007 , 0xDE9A},
{ 0x9008 , 0xDE9B},
{ 0x900C , 0xDE9C},
{ 0x900E , 0xDE9D},
{ 0x9013 , 0xDE9E},
{ 0x9015 , 0xDE9F},
{ 0x9018 , 0xDEA0},
{ 0x8556 , 0xDEA1},
{ 0x853B , 0xDEA2},
{ 0x84FF , 0xDEA3},
{ 0x84FC , 0xDEA4},
{ 0x8559 , 0xDEA5},
{ 0x8548 , 0xDEA6},
{ 0x8568 , 0xDEA7},
{ 0x8564 , 0xDEA8},
{ 0x855E , 0xDEA9},
{ 0x857A , 0xDEAA},
{ 0x77A2 , 0xDEAB},
{ 0x8543 , 0xDEAC},
{ 0x8572 , 0xDEAD},
{ 0x857B , 0xDEAE},
{ 0x85A4 , 0xDEAF},
{ 0x85A8 , 0xDEB0},
{ 0x8587 , 0xDEB1},
{ 0x858F , 0xDEB2},
{ 0x8579 , 0xDEB3},
{ 0x85AE , 0xDEB4},
{ 0x859C , 0xDEB5},
{ 0x8585 , 0xDEB6},
{ 0x85B9 , 0xDEB7},
{ 0x85B7 , 0xDEB8},
{ 0x85B0 , 0xDEB9},
{ 0x85D3 , 0xDEBA},
{ 0x85C1 , 0xDEBB},
{ 0x85DC , 0xDEBC},
{ 0x85FF , 0xDEBD},
{ 0x8627 , 0xDEBE},
{ 0x8605 , 0xDEBF},
{ 0x8629 , 0xDEC0},
{ 0x8616 , 0xDEC1},
{ 0x863C , 0xDEC2},
{ 0x5EFE , 0xDEC3},
{ 0x5F08 , 0xDEC4},
{ 0x593C , 0xDEC5},
{ 0x5941 , 0xDEC6},
{ 0x8037 , 0xDEC7},
{ 0x5955 , 0xDEC8},
{ 0x595A , 0xDEC9},
{ 0x5958 , 0xDECA},
{ 0x530F , 0xDECB},
{ 0x5C22 , 0xDECC},
{ 0x5C25 , 0xDECD},
{ 0x5C2C , 0xDECE},
{ 0x5C34 , 0xDECF},
{ 0x624C , 0xDED0},
{ 0x626A , 0xDED1},
{ 0x629F , 0xDED2},
{ 0x62BB , 0xDED3},
{ 0x62CA , 0xDED4},
{ 0x62DA , 0xDED5},
{ 0x62D7 , 0xDED6},
{ 0x62EE , 0xDED7},
{ 0x6322 , 0xDED8},
{ 0x62F6 , 0xDED9},
{ 0x6339 , 0xDEDA},
{ 0x634B , 0xDEDB},
{ 0x6343 , 0xDEDC},
{ 0x63AD , 0xDEDD},
{ 0x63F6 , 0xDEDE},
{ 0x6371 , 0xDEDF},
{ 0x637A , 0xDEE0},
{ 0x638E , 0xDEE1},
{ 0x63B4 , 0xDEE2},
{ 0x636D , 0xDEE3},
{ 0x63AC , 0xDEE4},
{ 0x638A , 0xDEE5},
{ 0x6369 , 0xDEE6},
{ 0x63AE , 0xDEE7},
{ 0x63BC , 0xDEE8},
{ 0x63F2 , 0xDEE9},
{ 0x63F8 , 0xDEEA},
{ 0x63E0 , 0xDEEB},
{ 0x63FF , 0xDEEC},
{ 0x63C4 , 0xDEED},
{ 0x63DE , 0xDEEE},
{ 0x63CE , 0xDEEF},
{ 0x6452 , 0xDEF0},
{ 0x63C6 , 0xDEF1},
{ 0x63BE , 0xDEF2},
{ 0x6445 , 0xDEF3},
{ 0x6441 , 0xDEF4},
{ 0x640B , 0xDEF5},
{ 0x641B , 0xDEF6},
{ 0x6420 , 0xDEF7},
{ 0x640C , 0xDEF8},
{ 0x6426 , 0xDEF9},
{ 0x6421 , 0xDEFA},
{ 0x645E , 0xDEFB},
{ 0x6484 , 0xDEFC},
{ 0x646D , 0xDEFD},
{ 0x6496 , 0xDEFE},
{ 0x9019 , 0xDF40},
{ 0x901C , 0xDF41},
{ 0x9023 , 0xDF42},
{ 0x9024 , 0xDF43},
{ 0x9025 , 0xDF44},
{ 0x9027 , 0xDF45},
{ 0x9028 , 0xDF46},
{ 0x9029 , 0xDF47},
{ 0x902A , 0xDF48},
{ 0x902B , 0xDF49},
{ 0x902C , 0xDF4A},
{ 0x9030 , 0xDF4B},
{ 0x9031 , 0xDF4C},
{ 0x9032 , 0xDF4D},
{ 0x9033 , 0xDF4E},
{ 0x9034 , 0xDF4F},
{ 0x9037 , 0xDF50},
{ 0x9039 , 0xDF51},
{ 0x903A , 0xDF52},
{ 0x903D , 0xDF53},
{ 0x903F , 0xDF54},
{ 0x9040 , 0xDF55},
{ 0x9043 , 0xDF56},
{ 0x9045 , 0xDF57},
{ 0x9046 , 0xDF58},
{ 0x9048 , 0xDF59},
{ 0x9049 , 0xDF5A},
{ 0x904A , 0xDF5B},
{ 0x904B , 0xDF5C},
{ 0x904C , 0xDF5D},
{ 0x904E , 0xDF5E},
{ 0x9054 , 0xDF5F},
{ 0x9055 , 0xDF60},
{ 0x9056 , 0xDF61},
{ 0x9059 , 0xDF62},
{ 0x905A , 0xDF63},
{ 0x905C , 0xDF64},
{ 0x905D , 0xDF65},
{ 0x905E , 0xDF66},
{ 0x905F , 0xDF67},
{ 0x9060 , 0xDF68},
{ 0x9061 , 0xDF69},
{ 0x9064 , 0xDF6A},
{ 0x9066 , 0xDF6B},
{ 0x9067 , 0xDF6C},
{ 0x9069 , 0xDF6D},
{ 0x906A , 0xDF6E},
{ 0x906B , 0xDF6F},
{ 0x906C , 0xDF70},
{ 0x906F , 0xDF71},
{ 0x9070 , 0xDF72},
{ 0x9071 , 0xDF73},
{ 0x9072 , 0xDF74},
{ 0x9073 , 0xDF75},
{ 0x9076 , 0xDF76},
{ 0x9077 , 0xDF77},
{ 0x9078 , 0xDF78},
{ 0x9079 , 0xDF79},
{ 0x907A , 0xDF7A},
{ 0x907B , 0xDF7B},
{ 0x907C , 0xDF7C},
{ 0x907E , 0xDF7D},
{ 0x9081 , 0xDF7E},
{ 0x9084 , 0xDF80},
{ 0x9085 , 0xDF81},
{ 0x9086 , 0xDF82},
{ 0x9087 , 0xDF83},
{ 0x9089 , 0xDF84},
{ 0x908A , 0xDF85},
{ 0x908C , 0xDF86},
{ 0x908D , 0xDF87},
{ 0x908E , 0xDF88},
{ 0x908F , 0xDF89},
{ 0x9090 , 0xDF8A},
{ 0x9092 , 0xDF8B},
{ 0x9094 , 0xDF8C},
{ 0x9096 , 0xDF8D},
{ 0x9098 , 0xDF8E},
{ 0x909A , 0xDF8F},
{ 0x909C , 0xDF90},
{ 0x909E , 0xDF91},
{ 0x909F , 0xDF92},
{ 0x90A0 , 0xDF93},
{ 0x90A4 , 0xDF94},
{ 0x90A5 , 0xDF95},
{ 0x90A7 , 0xDF96},
{ 0x90A8 , 0xDF97},
{ 0x90A9 , 0xDF98},
{ 0x90AB , 0xDF99},
{ 0x90AD , 0xDF9A},
{ 0x90B2 , 0xDF9B},
{ 0x90B7 , 0xDF9C},
{ 0x90BC , 0xDF9D},
{ 0x90BD , 0xDF9E},
{ 0x90BF , 0xDF9F},
{ 0x90C0 , 0xDFA0},
{ 0x647A , 0xDFA1},
{ 0x64B7 , 0xDFA2},
{ 0x64B8 , 0xDFA3},
{ 0x6499 , 0xDFA4},
{ 0x64BA , 0xDFA5},
{ 0x64C0 , 0xDFA6},
{ 0x64D0 , 0xDFA7},
{ 0x64D7 , 0xDFA8},
{ 0x64E4 , 0xDFA9},
{ 0x64E2 , 0xDFAA},
{ 0x6509 , 0xDFAB},
{ 0x6525 , 0xDFAC},
{ 0x652E , 0xDFAD},
{ 0x5F0B , 0xDFAE},
{ 0x5FD2 , 0xDFAF},
{ 0x7519 , 0xDFB0},
{ 0x5F11 , 0xDFB1},
{ 0x535F , 0xDFB2},
{ 0x53F1 , 0xDFB3},
{ 0x53FD , 0xDFB4},
{ 0x53E9 , 0xDFB5},
{ 0x53E8 , 0xDFB6},
{ 0x53FB , 0xDFB7},
{ 0x5412 , 0xDFB8},
{ 0x5416 , 0xDFB9},
{ 0x5406 , 0xDFBA},
{ 0x544B , 0xDFBB},
{ 0x5452 , 0xDFBC},
{ 0x5453 , 0xDFBD},
{ 0x5454 , 0xDFBE},
{ 0x5456 , 0xDFBF},
{ 0x5443 , 0xDFC0},
{ 0x5421 , 0xDFC1},
{ 0x5457 , 0xDFC2},
{ 0x5459 , 0xDFC3},
{ 0x5423 , 0xDFC4},
{ 0x5432 , 0xDFC5},
{ 0x5482 , 0xDFC6},
{ 0x5494 , 0xDFC7},
{ 0x5477 , 0xDFC8},
{ 0x5471 , 0xDFC9},
{ 0x5464 , 0xDFCA},
{ 0x549A , 0xDFCB},
{ 0x549B , 0xDFCC},
{ 0x5484 , 0xDFCD},
{ 0x5476 , 0xDFCE},
{ 0x5466 , 0xDFCF},
{ 0x549D , 0xDFD0},
{ 0x54D0 , 0xDFD1},
{ 0x54AD , 0xDFD2},
{ 0x54C2 , 0xDFD3},
{ 0x54B4 , 0xDFD4},
{ 0x54D2 , 0xDFD5},
{ 0x54A7 , 0xDFD6},
{ 0x54A6 , 0xDFD7},
{ 0x54D3 , 0xDFD8},
{ 0x54D4 , 0xDFD9},
{ 0x5472 , 0xDFDA},
{ 0x54A3 , 0xDFDB},
{ 0x54D5 , 0xDFDC},
{ 0x54BB , 0xDFDD},
{ 0x54BF , 0xDFDE},
{ 0x54CC , 0xDFDF},
{ 0x54D9 , 0xDFE0},
{ 0x54DA , 0xDFE1},
{ 0x54DC , 0xDFE2},
{ 0x54A9 , 0xDFE3},
{ 0x54AA , 0xDFE4},
{ 0x54A4 , 0xDFE5},
{ 0x54DD , 0xDFE6},
{ 0x54CF , 0xDFE7},
{ 0x54DE , 0xDFE8},
{ 0x551B , 0xDFE9},
{ 0x54E7 , 0xDFEA},
{ 0x5520 , 0xDFEB},
{ 0x54FD , 0xDFEC},
{ 0x5514 , 0xDFED},
{ 0x54F3 , 0xDFEE},
{ 0x5522 , 0xDFEF},
{ 0x5523 , 0xDFF0},
{ 0x550F , 0xDFF1},
{ 0x5511 , 0xDFF2},
{ 0x5527 , 0xDFF3},
{ 0x552A , 0xDFF4},
{ 0x5567 , 0xDFF5},
{ 0x558F , 0xDFF6},
{ 0x55B5 , 0xDFF7},
{ 0x5549 , 0xDFF8},
{ 0x556D , 0xDFF9},
{ 0x5541 , 0xDFFA},
{ 0x5555 , 0xDFFB},
{ 0x553F , 0xDFFC},
{ 0x5550 , 0xDFFD},
{ 0x553C , 0xDFFE},
{ 0x90C2 , 0xE040},
{ 0x90C3 , 0xE041},
{ 0x90C6 , 0xE042},
{ 0x90C8 , 0xE043},
{ 0x90C9 , 0xE044},
{ 0x90CB , 0xE045},
{ 0x90CC , 0xE046},
{ 0x90CD , 0xE047},
{ 0x90D2 , 0xE048},
{ 0x90D4 , 0xE049},
{ 0x90D5 , 0xE04A},
{ 0x90D6 , 0xE04B},
{ 0x90D8 , 0xE04C},
{ 0x90D9 , 0xE04D},
{ 0x90DA , 0xE04E},
{ 0x90DE , 0xE04F},
{ 0x90DF , 0xE050},
{ 0x90E0 , 0xE051},
{ 0x90E3 , 0xE052},
{ 0x90E4 , 0xE053},
{ 0x90E5 , 0xE054},
{ 0x90E9 , 0xE055},
{ 0x90EA , 0xE056},
{ 0x90EC , 0xE057},
{ 0x90EE , 0xE058},
{ 0x90F0 , 0xE059},
{ 0x90F1 , 0xE05A},
{ 0x90F2 , 0xE05B},
{ 0x90F3 , 0xE05C},
{ 0x90F5 , 0xE05D},
{ 0x90F6 , 0xE05E},
{ 0x90F7 , 0xE05F},
{ 0x90F9 , 0xE060},
{ 0x90FA , 0xE061},
{ 0x90FB , 0xE062},
{ 0x90FC , 0xE063},
{ 0x90FF , 0xE064},
{ 0x9100 , 0xE065},
{ 0x9101 , 0xE066},
{ 0x9103 , 0xE067},
{ 0x9105 , 0xE068},
{ 0x9106 , 0xE069},
{ 0x9107 , 0xE06A},
{ 0x9108 , 0xE06B},
{ 0x9109 , 0xE06C},
{ 0x910A , 0xE06D},
{ 0x910B , 0xE06E},
{ 0x910C , 0xE06F},
{ 0x910D , 0xE070},
{ 0x910E , 0xE071},
{ 0x910F , 0xE072},
{ 0x9110 , 0xE073},
{ 0x9111 , 0xE074},
{ 0x9112 , 0xE075},
{ 0x9113 , 0xE076},
{ 0x9114 , 0xE077},
{ 0x9115 , 0xE078},
{ 0x9116 , 0xE079},
{ 0x9117 , 0xE07A},
{ 0x9118 , 0xE07B},
{ 0x911A , 0xE07C},
{ 0x911B , 0xE07D},
{ 0x911C , 0xE07E},
{ 0x911D , 0xE080},
{ 0x911F , 0xE081},
{ 0x9120 , 0xE082},
{ 0x9121 , 0xE083},
{ 0x9124 , 0xE084},
{ 0x9125 , 0xE085},
{ 0x9126 , 0xE086},
{ 0x9127 , 0xE087},
{ 0x9128 , 0xE088},
{ 0x9129 , 0xE089},
{ 0x912A , 0xE08A},
{ 0x912B , 0xE08B},
{ 0x912C , 0xE08C},
{ 0x912D , 0xE08D},
{ 0x912E , 0xE08E},
{ 0x9130 , 0xE08F},
{ 0x9132 , 0xE090},
{ 0x9133 , 0xE091},
{ 0x9134 , 0xE092},
{ 0x9135 , 0xE093},
{ 0x9136 , 0xE094},
{ 0x9137 , 0xE095},
{ 0x9138 , 0xE096},
{ 0x913A , 0xE097},
{ 0x913B , 0xE098},
{ 0x913C , 0xE099},
{ 0x913D , 0xE09A},
{ 0x913E , 0xE09B},
{ 0x913F , 0xE09C},
{ 0x9140 , 0xE09D},
{ 0x9141 , 0xE09E},
{ 0x9142 , 0xE09F},
{ 0x9144 , 0xE0A0},
{ 0x5537 , 0xE0A1},
{ 0x5556 , 0xE0A2},
{ 0x5575 , 0xE0A3},
{ 0x5576 , 0xE0A4},
{ 0x5577 , 0xE0A5},
{ 0x5533 , 0xE0A6},
{ 0x5530 , 0xE0A7},
{ 0x555C , 0xE0A8},
{ 0x558B , 0xE0A9},
{ 0x55D2 , 0xE0AA},
{ 0x5583 , 0xE0AB},
{ 0x55B1 , 0xE0AC},
{ 0x55B9 , 0xE0AD},
{ 0x5588 , 0xE0AE},
{ 0x5581 , 0xE0AF},
{ 0x559F , 0xE0B0},
{ 0x557E , 0xE0B1},
{ 0x55D6 , 0xE0B2},
{ 0x5591 , 0xE0B3},
{ 0x557B , 0xE0B4},
{ 0x55DF , 0xE0B5},
{ 0x55BD , 0xE0B6},
{ 0x55BE , 0xE0B7},
{ 0x5594 , 0xE0B8},
{ 0x5599 , 0xE0B9},
{ 0x55EA , 0xE0BA},
{ 0x55F7 , 0xE0BB},
{ 0x55C9 , 0xE0BC},
{ 0x561F , 0xE0BD},
{ 0x55D1 , 0xE0BE},
{ 0x55EB , 0xE0BF},
{ 0x55EC , 0xE0C0},
{ 0x55D4 , 0xE0C1},
{ 0x55E6 , 0xE0C2},
{ 0x55DD , 0xE0C3},
{ 0x55C4 , 0xE0C4},
{ 0x55EF , 0xE0C5},
{ 0x55E5 , 0xE0C6},
{ 0x55F2 , 0xE0C7},
{ 0x55F3 , 0xE0C8},
{ 0x55CC , 0xE0C9},
{ 0x55CD , 0xE0CA},
{ 0x55E8 , 0xE0CB},
{ 0x55F5 , 0xE0CC},
{ 0x55E4 , 0xE0CD},
{ 0x8F94 , 0xE0CE},
{ 0x561E , 0xE0CF},
{ 0x5608 , 0xE0D0},
{ 0x560C , 0xE0D1},
{ 0x5601 , 0xE0D2},
{ 0x5624 , 0xE0D3},
{ 0x5623 , 0xE0D4},
{ 0x55FE , 0xE0D5},
{ 0x5600 , 0xE0D6},
{ 0x5627 , 0xE0D7},
{ 0x562D , 0xE0D8},
{ 0x5658 , 0xE0D9},
{ 0x5639 , 0xE0DA},
{ 0x5657 , 0xE0DB},
{ 0x562C , 0xE0DC},
{ 0x564D , 0xE0DD},
{ 0x5662 , 0xE0DE},
{ 0x5659 , 0xE0DF},
{ 0x565C , 0xE0E0},
{ 0x564C , 0xE0E1},
{ 0x5654 , 0xE0E2},
{ 0x5686 , 0xE0E3},
{ 0x5664 , 0xE0E4},
{ 0x5671 , 0xE0E5},
{ 0x566B , 0xE0E6},
{ 0x567B , 0xE0E7},
{ 0x567C , 0xE0E8},
{ 0x5685 , 0xE0E9},
{ 0x5693 , 0xE0EA},
{ 0x56AF , 0xE0EB},
{ 0x56D4 , 0xE0EC},
{ 0x56D7 , 0xE0ED},
{ 0x56DD , 0xE0EE},
{ 0x56E1 , 0xE0EF},
{ 0x56F5 , 0xE0F0},
{ 0x56EB , 0xE0F1},
{ 0x56F9 , 0xE0F2},
{ 0x56FF , 0xE0F3},
{ 0x5704 , 0xE0F4},
{ 0x570A , 0xE0F5},
{ 0x5709 , 0xE0F6},
{ 0x571C , 0xE0F7},
{ 0x5E0F , 0xE0F8},
{ 0x5E19 , 0xE0F9},
{ 0x5E14 , 0xE0FA},
{ 0x5E11 , 0xE0FB},
{ 0x5E31 , 0xE0FC},
{ 0x5E3B , 0xE0FD},
{ 0x5E3C , 0xE0FE},
{ 0x9145 , 0xE140},
{ 0x9147 , 0xE141},
{ 0x9148 , 0xE142},
{ 0x9151 , 0xE143},
{ 0x9153 , 0xE144},
{ 0x9154 , 0xE145},
{ 0x9155 , 0xE146},
{ 0x9156 , 0xE147},
{ 0x9158 , 0xE148},
{ 0x9159 , 0xE149},
{ 0x915B , 0xE14A},
{ 0x915C , 0xE14B},
{ 0x915F , 0xE14C},
{ 0x9160 , 0xE14D},
{ 0x9166 , 0xE14E},
{ 0x9167 , 0xE14F},
{ 0x9168 , 0xE150},
{ 0x916B , 0xE151},
{ 0x916D , 0xE152},
{ 0x9173 , 0xE153},
{ 0x917A , 0xE154},
{ 0x917B , 0xE155},
{ 0x917C , 0xE156},
{ 0x9180 , 0xE157},
{ 0x9181 , 0xE158},
{ 0x9182 , 0xE159},
{ 0x9183 , 0xE15A},
{ 0x9184 , 0xE15B},
{ 0x9186 , 0xE15C},
{ 0x9188 , 0xE15D},
{ 0x918A , 0xE15E},
{ 0x918E , 0xE15F},
{ 0x918F , 0xE160},
{ 0x9193 , 0xE161},
{ 0x9194 , 0xE162},
{ 0x9195 , 0xE163},
{ 0x9196 , 0xE164},
{ 0x9197 , 0xE165},
{ 0x9198 , 0xE166},
{ 0x9199 , 0xE167},
{ 0x919C , 0xE168},
{ 0x919D , 0xE169},
{ 0x919E , 0xE16A},
{ 0x919F , 0xE16B},
{ 0x91A0 , 0xE16C},
{ 0x91A1 , 0xE16D},
{ 0x91A4 , 0xE16E},
{ 0x91A5 , 0xE16F},
{ 0x91A6 , 0xE170},
{ 0x91A7 , 0xE171},
{ 0x91A8 , 0xE172},
{ 0x91A9 , 0xE173},
{ 0x91AB , 0xE174},
{ 0x91AC , 0xE175},
{ 0x91B0 , 0xE176},
{ 0x91B1 , 0xE177},
{ 0x91B2 , 0xE178},
{ 0x91B3 , 0xE179},
{ 0x91B6 , 0xE17A},
{ 0x91B7 , 0xE17B},
{ 0x91B8 , 0xE17C},
{ 0x91B9 , 0xE17D},
{ 0x91BB , 0xE17E},
{ 0x91BC , 0xE180},
{ 0x91BD , 0xE181},
{ 0x91BE , 0xE182},
{ 0x91BF , 0xE183},
{ 0x91C0 , 0xE184},
{ 0x91C1 , 0xE185},
{ 0x91C2 , 0xE186},
{ 0x91C3 , 0xE187},
{ 0x91C4 , 0xE188},
{ 0x91C5 , 0xE189},
{ 0x91C6 , 0xE18A},
{ 0x91C8 , 0xE18B},
{ 0x91CB , 0xE18C},
{ 0x91D0 , 0xE18D},
{ 0x91D2 , 0xE18E},
{ 0x91D3 , 0xE18F},
{ 0x91D4 , 0xE190},
{ 0x91D5 , 0xE191},
{ 0x91D6 , 0xE192},
{ 0x91D7 , 0xE193},
{ 0x91D8 , 0xE194},
{ 0x91D9 , 0xE195},
{ 0x91DA , 0xE196},
{ 0x91DB , 0xE197},
{ 0x91DD , 0xE198},
{ 0x91DE , 0xE199},
{ 0x91DF , 0xE19A},
{ 0x91E0 , 0xE19B},
{ 0x91E1 , 0xE19C},
{ 0x91E2 , 0xE19D},
{ 0x91E3 , 0xE19E},
{ 0x91E4 , 0xE19F},
{ 0x91E5 , 0xE1A0},
{ 0x5E37 , 0xE1A1},
{ 0x5E44 , 0xE1A2},
{ 0x5E54 , 0xE1A3},
{ 0x5E5B , 0xE1A4},
{ 0x5E5E , 0xE1A5},
{ 0x5E61 , 0xE1A6},
{ 0x5C8C , 0xE1A7},
{ 0x5C7A , 0xE1A8},
{ 0x5C8D , 0xE1A9},
{ 0x5C90 , 0xE1AA},
{ 0x5C96 , 0xE1AB},
{ 0x5C88 , 0xE1AC},
{ 0x5C98 , 0xE1AD},
{ 0x5C99 , 0xE1AE},
{ 0x5C91 , 0xE1AF},
{ 0x5C9A , 0xE1B0},
{ 0x5C9C , 0xE1B1},
{ 0x5CB5 , 0xE1B2},
{ 0x5CA2 , 0xE1B3},
{ 0x5CBD , 0xE1B4},
{ 0x5CAC , 0xE1B5},
{ 0x5CAB , 0xE1B6},
{ 0x5CB1 , 0xE1B7},
{ 0x5CA3 , 0xE1B8},
{ 0x5CC1 , 0xE1B9},
{ 0x5CB7 , 0xE1BA},
{ 0x5CC4 , 0xE1BB},
{ 0x5CD2 , 0xE1BC},
{ 0x5CE4 , 0xE1BD},
{ 0x5CCB , 0xE1BE},
{ 0x5CE5 , 0xE1BF},
{ 0x5D02 , 0xE1C0},
{ 0x5D03 , 0xE1C1},
{ 0x5D27 , 0xE1C2},
{ 0x5D26 , 0xE1C3},
{ 0x5D2E , 0xE1C4},
{ 0x5D24 , 0xE1C5},
{ 0x5D1E , 0xE1C6},
{ 0x5D06 , 0xE1C7},
{ 0x5D1B , 0xE1C8},
{ 0x5D58 , 0xE1C9},
{ 0x5D3E , 0xE1CA},
{ 0x5D34 , 0xE1CB},
{ 0x5D3D , 0xE1CC},
{ 0x5D6C , 0xE1CD},
{ 0x5D5B , 0xE1CE},
{ 0x5D6F , 0xE1CF},
{ 0x5D5D , 0xE1D0},
{ 0x5D6B , 0xE1D1},
{ 0x5D4B , 0xE1D2},
{ 0x5D4A , 0xE1D3},
{ 0x5D69 , 0xE1D4},
{ 0x5D74 , 0xE1D5},
{ 0x5D82 , 0xE1D6},
{ 0x5D99 , 0xE1D7},
{ 0x5D9D , 0xE1D8},
{ 0x8C73 , 0xE1D9},
{ 0x5DB7 , 0xE1DA},
{ 0x5DC5 , 0xE1DB},
{ 0x5F73 , 0xE1DC},
{ 0x5F77 , 0xE1DD},
{ 0x5F82 , 0xE1DE},
{ 0x5F87 , 0xE1DF},
{ 0x5F89 , 0xE1E0},
{ 0x5F8C , 0xE1E1},
{ 0x5F95 , 0xE1E2},
{ 0x5F99 , 0xE1E3},
{ 0x5F9C , 0xE1E4},
{ 0x5FA8 , 0xE1E5},
{ 0x5FAD , 0xE1E6},
{ 0x5FB5 , 0xE1E7},
{ 0x5FBC , 0xE1E8},
{ 0x8862 , 0xE1E9},
{ 0x5F61 , 0xE1EA},
{ 0x72AD , 0xE1EB},
{ 0x72B0 , 0xE1EC},
{ 0x72B4 , 0xE1ED},
{ 0x72B7 , 0xE1EE},
{ 0x72B8 , 0xE1EF},
{ 0x72C3 , 0xE1F0},
{ 0x72C1 , 0xE1F1},
{ 0x72CE , 0xE1F2},
{ 0x72CD , 0xE1F3},
{ 0x72D2 , 0xE1F4},
{ 0x72E8 , 0xE1F5},
{ 0x72EF , 0xE1F6},
{ 0x72E9 , 0xE1F7},
{ 0x72F2 , 0xE1F8},
{ 0x72F4 , 0xE1F9},
{ 0x72F7 , 0xE1FA},
{ 0x7301 , 0xE1FB},
{ 0x72F3 , 0xE1FC},
{ 0x7303 , 0xE1FD},
{ 0x72FA , 0xE1FE},
{ 0x91E6 , 0xE240},
{ 0x91E7 , 0xE241},
{ 0x91E8 , 0xE242},
{ 0x91E9 , 0xE243},
{ 0x91EA , 0xE244},
{ 0x91EB , 0xE245},
{ 0x91EC , 0xE246},
{ 0x91ED , 0xE247},
{ 0x91EE , 0xE248},
{ 0x91EF , 0xE249},
{ 0x91F0 , 0xE24A},
{ 0x91F1 , 0xE24B},
{ 0x91F2 , 0xE24C},
{ 0x91F3 , 0xE24D},
{ 0x91F4 , 0xE24E},
{ 0x91F5 , 0xE24F},
{ 0x91F6 , 0xE250},
{ 0x91F7 , 0xE251},
{ 0x91F8 , 0xE252},
{ 0x91F9 , 0xE253},
{ 0x91FA , 0xE254},
{ 0x91FB , 0xE255},
{ 0x91FC , 0xE256},
{ 0x91FD , 0xE257},
{ 0x91FE , 0xE258},
{ 0x91FF , 0xE259},
{ 0x9200 , 0xE25A},
{ 0x9201 , 0xE25B},
{ 0x9202 , 0xE25C},
{ 0x9203 , 0xE25D},
{ 0x9204 , 0xE25E},
{ 0x9205 , 0xE25F},
{ 0x9206 , 0xE260},
{ 0x9207 , 0xE261},
{ 0x9208 , 0xE262},
{ 0x9209 , 0xE263},
{ 0x920A , 0xE264},
{ 0x920B , 0xE265},
{ 0x920C , 0xE266},
{ 0x920D , 0xE267},
{ 0x920E , 0xE268},
{ 0x920F , 0xE269},
{ 0x9210 , 0xE26A},
{ 0x9211 , 0xE26B},
{ 0x9212 , 0xE26C},
{ 0x9213 , 0xE26D},
{ 0x9214 , 0xE26E},
{ 0x9215 , 0xE26F},
{ 0x9216 , 0xE270},
{ 0x9217 , 0xE271},
{ 0x9218 , 0xE272},
{ 0x9219 , 0xE273},
{ 0x921A , 0xE274},
{ 0x921B , 0xE275},
{ 0x921C , 0xE276},
{ 0x921D , 0xE277},
{ 0x921E , 0xE278},
{ 0x921F , 0xE279},
{ 0x9220 , 0xE27A},
{ 0x9221 , 0xE27B},
{ 0x9222 , 0xE27C},
{ 0x9223 , 0xE27D},
{ 0x9224 , 0xE27E},
{ 0x9225 , 0xE280},
{ 0x9226 , 0xE281},
{ 0x9227 , 0xE282},
{ 0x9228 , 0xE283},
{ 0x9229 , 0xE284},
{ 0x922A , 0xE285},
{ 0x922B , 0xE286},
{ 0x922C , 0xE287},
{ 0x922D , 0xE288},
{ 0x922E , 0xE289},
{ 0x922F , 0xE28A},
{ 0x9230 , 0xE28B},
{ 0x9231 , 0xE28C},
{ 0x9232 , 0xE28D},
{ 0x9233 , 0xE28E},
{ 0x9234 , 0xE28F},
{ 0x9235 , 0xE290},
{ 0x9236 , 0xE291},
{ 0x9237 , 0xE292},
{ 0x9238 , 0xE293},
{ 0x9239 , 0xE294},
{ 0x923A , 0xE295},
{ 0x923B , 0xE296},
{ 0x923C , 0xE297},
{ 0x923D , 0xE298},
{ 0x923E , 0xE299},
{ 0x923F , 0xE29A},
{ 0x9240 , 0xE29B},
{ 0x9241 , 0xE29C},
{ 0x9242 , 0xE29D},
{ 0x9243 , 0xE29E},
{ 0x9244 , 0xE29F},
{ 0x9245 , 0xE2A0},
{ 0x72FB , 0xE2A1},
{ 0x7317 , 0xE2A2},
{ 0x7313 , 0xE2A3},
{ 0x7321 , 0xE2A4},
{ 0x730A , 0xE2A5},
{ 0x731E , 0xE2A6},
{ 0x731D , 0xE2A7},
{ 0x7315 , 0xE2A8},
{ 0x7322 , 0xE2A9},
{ 0x7339 , 0xE2AA},
{ 0x7325 , 0xE2AB},
{ 0x732C , 0xE2AC},
{ 0x7338 , 0xE2AD},
{ 0x7331 , 0xE2AE},
{ 0x7350 , 0xE2AF},
{ 0x734D , 0xE2B0},
{ 0x7357 , 0xE2B1},
{ 0x7360 , 0xE2B2},
{ 0x736C , 0xE2B3},
{ 0x736F , 0xE2B4},
{ 0x737E , 0xE2B5},
{ 0x821B , 0xE2B6},
{ 0x5925 , 0xE2B7},
{ 0x98E7 , 0xE2B8},
{ 0x5924 , 0xE2B9},
{ 0x5902 , 0xE2BA},
{ 0x9963 , 0xE2BB},
{ 0x9967 , 0xE2BC},
{ 0x9968 , 0xE2BD},
{ 0x9969 , 0xE2BE},
{ 0x996A , 0xE2BF},
{ 0x996B , 0xE2C0},
{ 0x996C , 0xE2C1},
{ 0x9974 , 0xE2C2},
{ 0x9977 , 0xE2C3},
{ 0x997D , 0xE2C4},
{ 0x9980 , 0xE2C5},
{ 0x9984 , 0xE2C6},
{ 0x9987 , 0xE2C7},
{ 0x998A , 0xE2C8},
{ 0x998D , 0xE2C9},
{ 0x9990 , 0xE2CA},
{ 0x9991 , 0xE2CB},
{ 0x9993 , 0xE2CC},
{ 0x9994 , 0xE2CD},
{ 0x9995 , 0xE2CE},
{ 0x5E80 , 0xE2CF},
{ 0x5E91 , 0xE2D0},
{ 0x5E8B , 0xE2D1},
{ 0x5E96 , 0xE2D2},
{ 0x5EA5 , 0xE2D3},
{ 0x5EA0 , 0xE2D4},
{ 0x5EB9 , 0xE2D5},
{ 0x5EB5 , 0xE2D6},
{ 0x5EBE , 0xE2D7},
{ 0x5EB3 , 0xE2D8},
{ 0x8D53 , 0xE2D9},
{ 0x5ED2 , 0xE2DA},
{ 0x5ED1 , 0xE2DB},
{ 0x5EDB , 0xE2DC},
{ 0x5EE8 , 0xE2DD},
{ 0x5EEA , 0xE2DE},
{ 0x81BA , 0xE2DF},
{ 0x5FC4 , 0xE2E0},
{ 0x5FC9 , 0xE2E1},
{ 0x5FD6 , 0xE2E2},
{ 0x5FCF , 0xE2E3},
{ 0x6003 , 0xE2E4},
{ 0x5FEE , 0xE2E5},
{ 0x6004 , 0xE2E6},
{ 0x5FE1 , 0xE2E7},
{ 0x5FE4 , 0xE2E8},
{ 0x5FFE , 0xE2E9},
{ 0x6005 , 0xE2EA},
{ 0x6006 , 0xE2EB},
{ 0x5FEA , 0xE2EC},
{ 0x5FED , 0xE2ED},
{ 0x5FF8 , 0xE2EE},
{ 0x6019 , 0xE2EF},
{ 0x6035 , 0xE2F0},
{ 0x6026 , 0xE2F1},
{ 0x601B , 0xE2F2},
{ 0x600F , 0xE2F3},
{ 0x600D , 0xE2F4},
{ 0x6029 , 0xE2F5},
{ 0x602B , 0xE2F6},
{ 0x600A , 0xE2F7},
{ 0x603F , 0xE2F8},
{ 0x6021 , 0xE2F9},
{ 0x6078 , 0xE2FA},
{ 0x6079 , 0xE2FB},
{ 0x607B , 0xE2FC},
{ 0x607A , 0xE2FD},
{ 0x6042 , 0xE2FE},
{ 0x9246 , 0xE340},
{ 0x9247 , 0xE341},
{ 0x9248 , 0xE342},
{ 0x9249 , 0xE343},
{ 0x924A , 0xE344},
{ 0x924B , 0xE345},
{ 0x924C , 0xE346},
{ 0x924D , 0xE347},
{ 0x924E , 0xE348},
{ 0x924F , 0xE349},
{ 0x9250 , 0xE34A},
{ 0x9251 , 0xE34B},
{ 0x9252 , 0xE34C},
{ 0x9253 , 0xE34D},
{ 0x9254 , 0xE34E},
{ 0x9255 , 0xE34F},
{ 0x9256 , 0xE350},
{ 0x9257 , 0xE351},
{ 0x9258 , 0xE352},
{ 0x9259 , 0xE353},
{ 0x925A , 0xE354},
{ 0x925B , 0xE355},
{ 0x925C , 0xE356},
{ 0x925D , 0xE357},
{ 0x925E , 0xE358},
{ 0x925F , 0xE359},
{ 0x9260 , 0xE35A},
{ 0x9261 , 0xE35B},
{ 0x9262 , 0xE35C},
{ 0x9263 , 0xE35D},
{ 0x9264 , 0xE35E},
{ 0x9265 , 0xE35F},
{ 0x9266 , 0xE360},
{ 0x9267 , 0xE361},
{ 0x9268 , 0xE362},
{ 0x9269 , 0xE363},
{ 0x926A , 0xE364},
{ 0x926B , 0xE365},
{ 0x926C , 0xE366},
{ 0x926D , 0xE367},
{ 0x926E , 0xE368},
{ 0x926F , 0xE369},
{ 0x9270 , 0xE36A},
{ 0x9271 , 0xE36B},
{ 0x9272 , 0xE36C},
{ 0x9273 , 0xE36D},
{ 0x9275 , 0xE36E},
{ 0x9276 , 0xE36F},
{ 0x9277 , 0xE370},
{ 0x9278 , 0xE371},
{ 0x9279 , 0xE372},
{ 0x927A , 0xE373},
{ 0x927B , 0xE374},
{ 0x927C , 0xE375},
{ 0x927D , 0xE376},
{ 0x927E , 0xE377},
{ 0x927F , 0xE378},
{ 0x9280 , 0xE379},
{ 0x9281 , 0xE37A},
{ 0x9282 , 0xE37B},
{ 0x9283 , 0xE37C},
{ 0x9284 , 0xE37D},
{ 0x9285 , 0xE37E},
{ 0x9286 , 0xE380},
{ 0x9287 , 0xE381},
{ 0x9288 , 0xE382},
{ 0x9289 , 0xE383},
{ 0x928A , 0xE384},
{ 0x928B , 0xE385},
{ 0x928C , 0xE386},
{ 0x928D , 0xE387},
{ 0x928F , 0xE388},
{ 0x9290 , 0xE389},
{ 0x9291 , 0xE38A},
{ 0x9292 , 0xE38B},
{ 0x9293 , 0xE38C},
{ 0x9294 , 0xE38D},
{ 0x9295 , 0xE38E},
{ 0x9296 , 0xE38F},
{ 0x9297 , 0xE390},
{ 0x9298 , 0xE391},
{ 0x9299 , 0xE392},
{ 0x929A , 0xE393},
{ 0x929B , 0xE394},
{ 0x929C , 0xE395},
{ 0x929D , 0xE396},
{ 0x929E , 0xE397},
{ 0x929F , 0xE398},
{ 0x92A0 , 0xE399},
{ 0x92A1 , 0xE39A},
{ 0x92A2 , 0xE39B},
{ 0x92A3 , 0xE39C},
{ 0x92A4 , 0xE39D},
{ 0x92A5 , 0xE39E},
{ 0x92A6 , 0xE39F},
{ 0x92A7 , 0xE3A0},
{ 0x606A , 0xE3A1},
{ 0x607D , 0xE3A2},
{ 0x6096 , 0xE3A3},
{ 0x609A , 0xE3A4},
{ 0x60AD , 0xE3A5},
{ 0x609D , 0xE3A6},
{ 0x6083 , 0xE3A7},
{ 0x6092 , 0xE3A8},
{ 0x608C , 0xE3A9},
{ 0x609B , 0xE3AA},
{ 0x60EC , 0xE3AB},
{ 0x60BB , 0xE3AC},
{ 0x60B1 , 0xE3AD},
{ 0x60DD , 0xE3AE},
{ 0x60D8 , 0xE3AF},
{ 0x60C6 , 0xE3B0},
{ 0x60DA , 0xE3B1},
{ 0x60B4 , 0xE3B2},
{ 0x6120 , 0xE3B3},
{ 0x6126 , 0xE3B4},
{ 0x6115 , 0xE3B5},
{ 0x6123 , 0xE3B6},
{ 0x60F4 , 0xE3B7},
{ 0x6100 , 0xE3B8},
{ 0x610E , 0xE3B9},
{ 0x612B , 0xE3BA},
{ 0x614A , 0xE3BB},
{ 0x6175 , 0xE3BC},
{ 0x61AC , 0xE3BD},
{ 0x6194 , 0xE3BE},
{ 0x61A7 , 0xE3BF},
{ 0x61B7 , 0xE3C0},
{ 0x61D4 , 0xE3C1},
{ 0x61F5 , 0xE3C2},
{ 0x5FDD , 0xE3C3},
{ 0x96B3 , 0xE3C4},
{ 0x95E9 , 0xE3C5},
{ 0x95EB , 0xE3C6},
{ 0x95F1 , 0xE3C7},
{ 0x95F3 , 0xE3C8},
{ 0x95F5 , 0xE3C9},
{ 0x95F6 , 0xE3CA},
{ 0x95FC , 0xE3CB},
{ 0x95FE , 0xE3CC},
{ 0x9603 , 0xE3CD},
{ 0x9604 , 0xE3CE},
{ 0x9606 , 0xE3CF},
{ 0x9608 , 0xE3D0},
{ 0x960A , 0xE3D1},
{ 0x960B , 0xE3D2},
{ 0x960C , 0xE3D3},
{ 0x960D , 0xE3D4},
{ 0x960F , 0xE3D5},
{ 0x9612 , 0xE3D6},
{ 0x9615 , 0xE3D7},
{ 0x9616 , 0xE3D8},
{ 0x9617 , 0xE3D9},
{ 0x9619 , 0xE3DA},
{ 0x961A , 0xE3DB},
{ 0x4E2C , 0xE3DC},
{ 0x723F , 0xE3DD},
{ 0x6215 , 0xE3DE},
{ 0x6C35 , 0xE3DF},
{ 0x6C54 , 0xE3E0},
{ 0x6C5C , 0xE3E1},
{ 0x6C4A , 0xE3E2},
{ 0x6CA3 , 0xE3E3},
{ 0x6C85 , 0xE3E4},
{ 0x6C90 , 0xE3E5},
{ 0x6C94 , 0xE3E6},
{ 0x6C8C , 0xE3E7},
{ 0x6C68 , 0xE3E8},
{ 0x6C69 , 0xE3E9},
{ 0x6C74 , 0xE3EA},
{ 0x6C76 , 0xE3EB},
{ 0x6C86 , 0xE3EC},
{ 0x6CA9 , 0xE3ED},
{ 0x6CD0 , 0xE3EE},
{ 0x6CD4 , 0xE3EF},
{ 0x6CAD , 0xE3F0},
{ 0x6CF7 , 0xE3F1},
{ 0x6CF8 , 0xE3F2},
{ 0x6CF1 , 0xE3F3},
{ 0x6CD7 , 0xE3F4},
{ 0x6CB2 , 0xE3F5},
{ 0x6CE0 , 0xE3F6},
{ 0x6CD6 , 0xE3F7},
{ 0x6CFA , 0xE3F8},
{ 0x6CEB , 0xE3F9},
{ 0x6CEE , 0xE3FA},
{ 0x6CB1 , 0xE3FB},
{ 0x6CD3 , 0xE3FC},
{ 0x6CEF , 0xE3FD},
{ 0x6CFE , 0xE3FE},
{ 0x92A8 , 0xE440},
{ 0x92A9 , 0xE441},
{ 0x92AA , 0xE442},
{ 0x92AB , 0xE443},
{ 0x92AC , 0xE444},
{ 0x92AD , 0xE445},
{ 0x92AF , 0xE446},
{ 0x92B0 , 0xE447},
{ 0x92B1 , 0xE448},
{ 0x92B2 , 0xE449},
{ 0x92B3 , 0xE44A},
{ 0x92B4 , 0xE44B},
{ 0x92B5 , 0xE44C},
{ 0x92B6 , 0xE44D},
{ 0x92B7 , 0xE44E},
{ 0x92B8 , 0xE44F},
{ 0x92B9 , 0xE450},
{ 0x92BA , 0xE451},
{ 0x92BB , 0xE452},
{ 0x92BC , 0xE453},
{ 0x92BD , 0xE454},
{ 0x92BE , 0xE455},
{ 0x92BF , 0xE456},
{ 0x92C0 , 0xE457},
{ 0x92C1 , 0xE458},
{ 0x92C2 , 0xE459},
{ 0x92C3 , 0xE45A},
{ 0x92C4 , 0xE45B},
{ 0x92C5 , 0xE45C},
{ 0x92C6 , 0xE45D},
{ 0x92C7 , 0xE45E},
{ 0x92C9 , 0xE45F},
{ 0x92CA , 0xE460},
{ 0x92CB , 0xE461},
{ 0x92CC , 0xE462},
{ 0x92CD , 0xE463},
{ 0x92CE , 0xE464},
{ 0x92CF , 0xE465},
{ 0x92D0 , 0xE466},
{ 0x92D1 , 0xE467},
{ 0x92D2 , 0xE468},
{ 0x92D3 , 0xE469},
{ 0x92D4 , 0xE46A},
{ 0x92D5 , 0xE46B},
{ 0x92D6 , 0xE46C},
{ 0x92D7 , 0xE46D},
{ 0x92D8 , 0xE46E},
{ 0x92D9 , 0xE46F},
{ 0x92DA , 0xE470},
{ 0x92DB , 0xE471},
{ 0x92DC , 0xE472},
{ 0x92DD , 0xE473},
{ 0x92DE , 0xE474},
{ 0x92DF , 0xE475},
{ 0x92E0 , 0xE476},
{ 0x92E1 , 0xE477},
{ 0x92E2 , 0xE478},
{ 0x92E3 , 0xE479},
{ 0x92E4 , 0xE47A},
{ 0x92E5 , 0xE47B},
{ 0x92E6 , 0xE47C},
{ 0x92E7 , 0xE47D},
{ 0x92E8 , 0xE47E},
{ 0x92E9 , 0xE480},
{ 0x92EA , 0xE481},
{ 0x92EB , 0xE482},
{ 0x92EC , 0xE483},
{ 0x92ED , 0xE484},
{ 0x92EE , 0xE485},
{ 0x92EF , 0xE486},
{ 0x92F0 , 0xE487},
{ 0x92F1 , 0xE488},
{ 0x92F2 , 0xE489},
{ 0x92F3 , 0xE48A},
{ 0x92F4 , 0xE48B},
{ 0x92F5 , 0xE48C},
{ 0x92F6 , 0xE48D},
{ 0x92F7 , 0xE48E},
{ 0x92F8 , 0xE48F},
{ 0x92F9 , 0xE490},
{ 0x92FA , 0xE491},
{ 0x92FB , 0xE492},
{ 0x92FC , 0xE493},
{ 0x92FD , 0xE494},
{ 0x92FE , 0xE495},
{ 0x92FF , 0xE496},
{ 0x9300 , 0xE497},
{ 0x9301 , 0xE498},
{ 0x9302 , 0xE499},
{ 0x9303 , 0xE49A},
{ 0x9304 , 0xE49B},
{ 0x9305 , 0xE49C},
{ 0x9306 , 0xE49D},
{ 0x9307 , 0xE49E},
{ 0x9308 , 0xE49F},
{ 0x9309 , 0xE4A0},
{ 0x6D39 , 0xE4A1},
{ 0x6D27 , 0xE4A2},
{ 0x6D0C , 0xE4A3},
{ 0x6D43 , 0xE4A4},
{ 0x6D48 , 0xE4A5},
{ 0x6D07 , 0xE4A6},
{ 0x6D04 , 0xE4A7},
{ 0x6D19 , 0xE4A8},
{ 0x6D0E , 0xE4A9},
{ 0x6D2B , 0xE4AA},
{ 0x6D4D , 0xE4AB},
{ 0x6D2E , 0xE4AC},
{ 0x6D35 , 0xE4AD},
{ 0x6D1A , 0xE4AE},
{ 0x6D4F , 0xE4AF},
{ 0x6D52 , 0xE4B0},
{ 0x6D54 , 0xE4B1},
{ 0x6D33 , 0xE4B2},
{ 0x6D91 , 0xE4B3},
{ 0x6D6F , 0xE4B4},
{ 0x6D9E , 0xE4B5},
{ 0x6DA0 , 0xE4B6},
{ 0x6D5E , 0xE4B7},
{ 0x6D93 , 0xE4B8},
{ 0x6D94 , 0xE4B9},
{ 0x6D5C , 0xE4BA},
{ 0x6D60 , 0xE4BB},
{ 0x6D7C , 0xE4BC},
{ 0x6D63 , 0xE4BD},
{ 0x6E1A , 0xE4BE},
{ 0x6DC7 , 0xE4BF},
{ 0x6DC5 , 0xE4C0},
{ 0x6DDE , 0xE4C1},
{ 0x6E0E , 0xE4C2},
{ 0x6DBF , 0xE4C3},
{ 0x6DE0 , 0xE4C4},
{ 0x6E11 , 0xE4C5},
{ 0x6DE6 , 0xE4C6},
{ 0x6DDD , 0xE4C7},
{ 0x6DD9 , 0xE4C8},
{ 0x6E16 , 0xE4C9},
{ 0x6DAB , 0xE4CA},
{ 0x6E0C , 0xE4CB},
{ 0x6DAE , 0xE4CC},
{ 0x6E2B , 0xE4CD},
{ 0x6E6E , 0xE4CE},
{ 0x6E4E , 0xE4CF},
{ 0x6E6B , 0xE4D0},
{ 0x6EB2 , 0xE4D1},
{ 0x6E5F , 0xE4D2},
{ 0x6E86 , 0xE4D3},
{ 0x6E53 , 0xE4D4},
{ 0x6E54 , 0xE4D5},
{ 0x6E32 , 0xE4D6},
{ 0x6E25 , 0xE4D7},
{ 0x6E44 , 0xE4D8},
{ 0x6EDF , 0xE4D9},
{ 0x6EB1 , 0xE4DA},
{ 0x6E98 , 0xE4DB},
{ 0x6EE0 , 0xE4DC},
{ 0x6F2D , 0xE4DD},
{ 0x6EE2 , 0xE4DE},
{ 0x6EA5 , 0xE4DF},
{ 0x6EA7 , 0xE4E0},
{ 0x6EBD , 0xE4E1},
{ 0x6EBB , 0xE4E2},
{ 0x6EB7 , 0xE4E3},
{ 0x6ED7 , 0xE4E4},
{ 0x6EB4 , 0xE4E5},
{ 0x6ECF , 0xE4E6},
{ 0x6E8F , 0xE4E7},
{ 0x6EC2 , 0xE4E8},
{ 0x6E9F , 0xE4E9},
{ 0x6F62 , 0xE4EA},
{ 0x6F46 , 0xE4EB},
{ 0x6F47 , 0xE4EC},
{ 0x6F24 , 0xE4ED},
{ 0x6F15 , 0xE4EE},
{ 0x6EF9 , 0xE4EF},
{ 0x6F2F , 0xE4F0},
{ 0x6F36 , 0xE4F1},
{ 0x6F4B , 0xE4F2},
{ 0x6F74 , 0xE4F3},
{ 0x6F2A , 0xE4F4},
{ 0x6F09 , 0xE4F5},
{ 0x6F29 , 0xE4F6},
{ 0x6F89 , 0xE4F7},
{ 0x6F8D , 0xE4F8},
{ 0x6F8C , 0xE4F9},
{ 0x6F78 , 0xE4FA},
{ 0x6F72 , 0xE4FB},
{ 0x6F7C , 0xE4FC},
{ 0x6F7A , 0xE4FD},
{ 0x6FD1 , 0xE4FE},
{ 0x930A , 0xE540},
{ 0x930B , 0xE541},
{ 0x930C , 0xE542},
{ 0x930D , 0xE543},
{ 0x930E , 0xE544},
{ 0x930F , 0xE545},
{ 0x9310 , 0xE546},
{ 0x9311 , 0xE547},
{ 0x9312 , 0xE548},
{ 0x9313 , 0xE549},
{ 0x9314 , 0xE54A},
{ 0x9315 , 0xE54B},
{ 0x9316 , 0xE54C},
{ 0x9317 , 0xE54D},
{ 0x9318 , 0xE54E},
{ 0x9319 , 0xE54F},
{ 0x931A , 0xE550},
{ 0x931B , 0xE551},
{ 0x931C , 0xE552},
{ 0x931D , 0xE553},
{ 0x931E , 0xE554},
{ 0x931F , 0xE555},
{ 0x9320 , 0xE556},
{ 0x9321 , 0xE557},
{ 0x9322 , 0xE558},
{ 0x9323 , 0xE559},
{ 0x9324 , 0xE55A},
{ 0x9325 , 0xE55B},
{ 0x9326 , 0xE55C},
{ 0x9327 , 0xE55D},
{ 0x9328 , 0xE55E},
{ 0x9329 , 0xE55F},
{ 0x932A , 0xE560},
{ 0x932B , 0xE561},
{ 0x932C , 0xE562},
{ 0x932D , 0xE563},
{ 0x932E , 0xE564},
{ 0x932F , 0xE565},
{ 0x9330 , 0xE566},
{ 0x9331 , 0xE567},
{ 0x9332 , 0xE568},
{ 0x9333 , 0xE569},
{ 0x9334 , 0xE56A},
{ 0x9335 , 0xE56B},
{ 0x9336 , 0xE56C},
{ 0x9337 , 0xE56D},
{ 0x9338 , 0xE56E},
{ 0x9339 , 0xE56F},
{ 0x933A , 0xE570},
{ 0x933B , 0xE571},
{ 0x933C , 0xE572},
{ 0x933D , 0xE573},
{ 0x933F , 0xE574},
{ 0x9340 , 0xE575},
{ 0x9341 , 0xE576},
{ 0x9342 , 0xE577},
{ 0x9343 , 0xE578},
{ 0x9344 , 0xE579},
{ 0x9345 , 0xE57A},
{ 0x9346 , 0xE57B},
{ 0x9347 , 0xE57C},
{ 0x9348 , 0xE57D},
{ 0x9349 , 0xE57E},
{ 0x934A , 0xE580},
{ 0x934B , 0xE581},
{ 0x934C , 0xE582},
{ 0x934D , 0xE583},
{ 0x934E , 0xE584},
{ 0x934F , 0xE585},
{ 0x9350 , 0xE586},
{ 0x9351 , 0xE587},
{ 0x9352 , 0xE588},
{ 0x9353 , 0xE589},
{ 0x9354 , 0xE58A},
{ 0x9355 , 0xE58B},
{ 0x9356 , 0xE58C},
{ 0x9357 , 0xE58D},
{ 0x9358 , 0xE58E},
{ 0x9359 , 0xE58F},
{ 0x935A , 0xE590},
{ 0x935B , 0xE591},
{ 0x935C , 0xE592},
{ 0x935D , 0xE593},
{ 0x935E , 0xE594},
{ 0x935F , 0xE595},
{ 0x9360 , 0xE596},
{ 0x9361 , 0xE597},
{ 0x9362 , 0xE598},
{ 0x9363 , 0xE599},
{ 0x9364 , 0xE59A},
{ 0x9365 , 0xE59B},
{ 0x9366 , 0xE59C},
{ 0x9367 , 0xE59D},
{ 0x9368 , 0xE59E},
{ 0x9369 , 0xE59F},
{ 0x936B , 0xE5A0},
{ 0x6FC9 , 0xE5A1},
{ 0x6FA7 , 0xE5A2},
{ 0x6FB9 , 0xE5A3},
{ 0x6FB6 , 0xE5A4},
{ 0x6FC2 , 0xE5A5},
{ 0x6FE1 , 0xE5A6},
{ 0x6FEE , 0xE5A7},
{ 0x6FDE , 0xE5A8},
{ 0x6FE0 , 0xE5A9},
{ 0x6FEF , 0xE5AA},
{ 0x701A , 0xE5AB},
{ 0x7023 , 0xE5AC},
{ 0x701B , 0xE5AD},
{ 0x7039 , 0xE5AE},
{ 0x7035 , 0xE5AF},
{ 0x704F , 0xE5B0},
{ 0x705E , 0xE5B1},
{ 0x5B80 , 0xE5B2},
{ 0x5B84 , 0xE5B3},
{ 0x5B95 , 0xE5B4},
{ 0x5B93 , 0xE5B5},
{ 0x5BA5 , 0xE5B6},
{ 0x5BB8 , 0xE5B7},
{ 0x752F , 0xE5B8},
{ 0x9A9E , 0xE5B9},
{ 0x6434 , 0xE5BA},
{ 0x5BE4 , 0xE5BB},
{ 0x5BEE , 0xE5BC},
{ 0x8930 , 0xE5BD},
{ 0x5BF0 , 0xE5BE},
{ 0x8E47 , 0xE5BF},
{ 0x8B07 , 0xE5C0},
{ 0x8FB6 , 0xE5C1},
{ 0x8FD3 , 0xE5C2},
{ 0x8FD5 , 0xE5C3},
{ 0x8FE5 , 0xE5C4},
{ 0x8FEE , 0xE5C5},
{ 0x8FE4 , 0xE5C6},
{ 0x8FE9 , 0xE5C7},
{ 0x8FE6 , 0xE5C8},
{ 0x8FF3 , 0xE5C9},
{ 0x8FE8 , 0xE5CA},
{ 0x9005 , 0xE5CB},
{ 0x9004 , 0xE5CC},
{ 0x900B , 0xE5CD},
{ 0x9026 , 0xE5CE},
{ 0x9011 , 0xE5CF},
{ 0x900D , 0xE5D0},
{ 0x9016 , 0xE5D1},
{ 0x9021 , 0xE5D2},
{ 0x9035 , 0xE5D3},
{ 0x9036 , 0xE5D4},
{ 0x902D , 0xE5D5},
{ 0x902F , 0xE5D6},
{ 0x9044 , 0xE5D7},
{ 0x9051 , 0xE5D8},
{ 0x9052 , 0xE5D9},
{ 0x9050 , 0xE5DA},
{ 0x9068 , 0xE5DB},
{ 0x9058 , 0xE5DC},
{ 0x9062 , 0xE5DD},
{ 0x905B , 0xE5DE},
{ 0x66B9 , 0xE5DF},
{ 0x9074 , 0xE5E0},
{ 0x907D , 0xE5E1},
{ 0x9082 , 0xE5E2},
{ 0x9088 , 0xE5E3},
{ 0x9083 , 0xE5E4},
{ 0x908B , 0xE5E5},
{ 0x5F50 , 0xE5E6},
{ 0x5F57 , 0xE5E7},
{ 0x5F56 , 0xE5E8},
{ 0x5F58 , 0xE5E9},
{ 0x5C3B , 0xE5EA},
{ 0x54AB , 0xE5EB},
{ 0x5C50 , 0xE5EC},
{ 0x5C59 , 0xE5ED},
{ 0x5B71 , 0xE5EE},
{ 0x5C63 , 0xE5EF},
{ 0x5C66 , 0xE5F0},
{ 0x7FBC , 0xE5F1},
{ 0x5F2A , 0xE5F2},
{ 0x5F29 , 0xE5F3},
{ 0x5F2D , 0xE5F4},
{ 0x8274 , 0xE5F5},
{ 0x5F3C , 0xE5F6},
{ 0x9B3B , 0xE5F7},
{ 0x5C6E , 0xE5F8},
{ 0x5981 , 0xE5F9},
{ 0x5983 , 0xE5FA},
{ 0x598D , 0xE5FB},
{ 0x59A9 , 0xE5FC},
{ 0x59AA , 0xE5FD},
{ 0x59A3 , 0xE5FE},
{ 0x936C , 0xE640},
{ 0x936D , 0xE641},
{ 0x936E , 0xE642},
{ 0x936F , 0xE643},
{ 0x9370 , 0xE644},
{ 0x9371 , 0xE645},
{ 0x9372 , 0xE646},
{ 0x9373 , 0xE647},
{ 0x9374 , 0xE648},
{ 0x9375 , 0xE649},
{ 0x9376 , 0xE64A},
{ 0x9377 , 0xE64B},
{ 0x9378 , 0xE64C},
{ 0x9379 , 0xE64D},
{ 0x937A , 0xE64E},
{ 0x937B , 0xE64F},
{ 0x937C , 0xE650},
{ 0x937D , 0xE651},
{ 0x937E , 0xE652},
{ 0x937F , 0xE653},
{ 0x9380 , 0xE654},
{ 0x9381 , 0xE655},
{ 0x9382 , 0xE656},
{ 0x9383 , 0xE657},
{ 0x9384 , 0xE658},
{ 0x9385 , 0xE659},
{ 0x9386 , 0xE65A},
{ 0x9387 , 0xE65B},
{ 0x9388 , 0xE65C},
{ 0x9389 , 0xE65D},
{ 0x938A , 0xE65E},
{ 0x938B , 0xE65F},
{ 0x938C , 0xE660},
{ 0x938D , 0xE661},
{ 0x938E , 0xE662},
{ 0x9390 , 0xE663},
{ 0x9391 , 0xE664},
{ 0x9392 , 0xE665},
{ 0x9393 , 0xE666},
{ 0x9394 , 0xE667},
{ 0x9395 , 0xE668},
{ 0x9396 , 0xE669},
{ 0x9397 , 0xE66A},
{ 0x9398 , 0xE66B},
{ 0x9399 , 0xE66C},
{ 0x939A , 0xE66D},
{ 0x939B , 0xE66E},
{ 0x939C , 0xE66F},
{ 0x939D , 0xE670},
{ 0x939E , 0xE671},
{ 0x939F , 0xE672},
{ 0x93A0 , 0xE673},
{ 0x93A1 , 0xE674},
{ 0x93A2 , 0xE675},
{ 0x93A3 , 0xE676},
{ 0x93A4 , 0xE677},
{ 0x93A5 , 0xE678},
{ 0x93A6 , 0xE679},
{ 0x93A7 , 0xE67A},
{ 0x93A8 , 0xE67B},
{ 0x93A9 , 0xE67C},
{ 0x93AA , 0xE67D},
{ 0x93AB , 0xE67E},
{ 0x93AC , 0xE680},
{ 0x93AD , 0xE681},
{ 0x93AE , 0xE682},
{ 0x93AF , 0xE683},
{ 0x93B0 , 0xE684},
{ 0x93B1 , 0xE685},
{ 0x93B2 , 0xE686},
{ 0x93B3 , 0xE687},
{ 0x93B4 , 0xE688},
{ 0x93B5 , 0xE689},
{ 0x93B6 , 0xE68A},
{ 0x93B7 , 0xE68B},
{ 0x93B8 , 0xE68C},
{ 0x93B9 , 0xE68D},
{ 0x93BA , 0xE68E},
{ 0x93BB , 0xE68F},
{ 0x93BC , 0xE690},
{ 0x93BD , 0xE691},
{ 0x93BE , 0xE692},
{ 0x93BF , 0xE693},
{ 0x93C0 , 0xE694},
{ 0x93C1 , 0xE695},
{ 0x93C2 , 0xE696},
{ 0x93C3 , 0xE697},
{ 0x93C4 , 0xE698},
{ 0x93C5 , 0xE699},
{ 0x93C6 , 0xE69A},
{ 0x93C7 , 0xE69B},
{ 0x93C8 , 0xE69C},
{ 0x93C9 , 0xE69D},
{ 0x93CB , 0xE69E},
{ 0x93CC , 0xE69F},
{ 0x93CD , 0xE6A0},
{ 0x5997 , 0xE6A1},
{ 0x59CA , 0xE6A2},
{ 0x59AB , 0xE6A3},
{ 0x599E , 0xE6A4},
{ 0x59A4 , 0xE6A5},
{ 0x59D2 , 0xE6A6},
{ 0x59B2 , 0xE6A7},
{ 0x59AF , 0xE6A8},
{ 0x59D7 , 0xE6A9},
{ 0x59BE , 0xE6AA},
{ 0x5A05 , 0xE6AB},
{ 0x5A06 , 0xE6AC},
{ 0x59DD , 0xE6AD},
{ 0x5A08 , 0xE6AE},
{ 0x59E3 , 0xE6AF},
{ 0x59D8 , 0xE6B0},
{ 0x59F9 , 0xE6B1},
{ 0x5A0C , 0xE6B2},
{ 0x5A09 , 0xE6B3},
{ 0x5A32 , 0xE6B4},
{ 0x5A34 , 0xE6B5},
{ 0x5A11 , 0xE6B6},
{ 0x5A23 , 0xE6B7},
{ 0x5A13 , 0xE6B8},
{ 0x5A40 , 0xE6B9},
{ 0x5A67 , 0xE6BA},
{ 0x5A4A , 0xE6BB},
{ 0x5A55 , 0xE6BC},
{ 0x5A3C , 0xE6BD},
{ 0x5A62 , 0xE6BE},
{ 0x5A75 , 0xE6BF},
{ 0x80EC , 0xE6C0},
{ 0x5AAA , 0xE6C1},
{ 0x5A9B , 0xE6C2},
{ 0x5A77 , 0xE6C3},
{ 0x5A7A , 0xE6C4},
{ 0x5ABE , 0xE6C5},
{ 0x5AEB , 0xE6C6},
{ 0x5AB2 , 0xE6C7},
{ 0x5AD2 , 0xE6C8},
{ 0x5AD4 , 0xE6C9},
{ 0x5AB8 , 0xE6CA},
{ 0x5AE0 , 0xE6CB},
{ 0x5AE3 , 0xE6CC},
{ 0x5AF1 , 0xE6CD},
{ 0x5AD6 , 0xE6CE},
{ 0x5AE6 , 0xE6CF},
{ 0x5AD8 , 0xE6D0},
{ 0x5ADC , 0xE6D1},
{ 0x5B09 , 0xE6D2},
{ 0x5B17 , 0xE6D3},
{ 0x5B16 , 0xE6D4},
{ 0x5B32 , 0xE6D5},
{ 0x5B37 , 0xE6D6},
{ 0x5B40 , 0xE6D7},
{ 0x5C15 , 0xE6D8},
{ 0x5C1C , 0xE6D9},
{ 0x5B5A , 0xE6DA},
{ 0x5B65 , 0xE6DB},
{ 0x5B73 , 0xE6DC},
{ 0x5B51 , 0xE6DD},
{ 0x5B53 , 0xE6DE},
{ 0x5B62 , 0xE6DF},
{ 0x9A75 , 0xE6E0},
{ 0x9A77 , 0xE6E1},
{ 0x9A78 , 0xE6E2},
{ 0x9A7A , 0xE6E3},
{ 0x9A7F , 0xE6E4},
{ 0x9A7D , 0xE6E5},
{ 0x9A80 , 0xE6E6},
{ 0x9A81 , 0xE6E7},
{ 0x9A85 , 0xE6E8},
{ 0x9A88 , 0xE6E9},
{ 0x9A8A , 0xE6EA},
{ 0x9A90 , 0xE6EB},
{ 0x9A92 , 0xE6EC},
{ 0x9A93 , 0xE6ED},
{ 0x9A96 , 0xE6EE},
{ 0x9A98 , 0xE6EF},
{ 0x9A9B , 0xE6F0},
{ 0x9A9C , 0xE6F1},
{ 0x9A9D , 0xE6F2},
{ 0x9A9F , 0xE6F3},
{ 0x9AA0 , 0xE6F4},
{ 0x9AA2 , 0xE6F5},
{ 0x9AA3 , 0xE6F6},
{ 0x9AA5 , 0xE6F7},
{ 0x9AA7 , 0xE6F8},
{ 0x7E9F , 0xE6F9},
{ 0x7EA1 , 0xE6FA},
{ 0x7EA3 , 0xE6FB},
{ 0x7EA5 , 0xE6FC},
{ 0x7EA8 , 0xE6FD},
{ 0x7EA9 , 0xE6FE},
{ 0x93CE , 0xE740},
{ 0x93CF , 0xE741},
{ 0x93D0 , 0xE742},
{ 0x93D1 , 0xE743},
{ 0x93D2 , 0xE744},
{ 0x93D3 , 0xE745},
{ 0x93D4 , 0xE746},
{ 0x93D5 , 0xE747},
{ 0x93D7 , 0xE748},
{ 0x93D8 , 0xE749},
{ 0x93D9 , 0xE74A},
{ 0x93DA , 0xE74B},
{ 0x93DB , 0xE74C},
{ 0x93DC , 0xE74D},
{ 0x93DD , 0xE74E},
{ 0x93DE , 0xE74F},
{ 0x93DF , 0xE750},
{ 0x93E0 , 0xE751},
{ 0x93E1 , 0xE752},
{ 0x93E2 , 0xE753},
{ 0x93E3 , 0xE754},
{ 0x93E4 , 0xE755},
{ 0x93E5 , 0xE756},
{ 0x93E6 , 0xE757},
{ 0x93E7 , 0xE758},
{ 0x93E8 , 0xE759},
{ 0x93E9 , 0xE75A},
{ 0x93EA , 0xE75B},
{ 0x93EB , 0xE75C},
{ 0x93EC , 0xE75D},
{ 0x93ED , 0xE75E},
{ 0x93EE , 0xE75F},
{ 0x93EF , 0xE760},
{ 0x93F0 , 0xE761},
{ 0x93F1 , 0xE762},
{ 0x93F2 , 0xE763},
{ 0x93F3 , 0xE764},
{ 0x93F4 , 0xE765},
{ 0x93F5 , 0xE766},
{ 0x93F6 , 0xE767},
{ 0x93F7 , 0xE768},
{ 0x93F8 , 0xE769},
{ 0x93F9 , 0xE76A},
{ 0x93FA , 0xE76B},
{ 0x93FB , 0xE76C},
{ 0x93FC , 0xE76D},
{ 0x93FD , 0xE76E},
{ 0x93FE , 0xE76F},
{ 0x93FF , 0xE770},
{ 0x9400 , 0xE771},
{ 0x9401 , 0xE772},
{ 0x9402 , 0xE773},
{ 0x9403 , 0xE774},
{ 0x9404 , 0xE775},
{ 0x9405 , 0xE776},
{ 0x9406 , 0xE777},
{ 0x9407 , 0xE778},
{ 0x9408 , 0xE779},
{ 0x9409 , 0xE77A},
{ 0x940A , 0xE77B},
{ 0x940B , 0xE77C},
{ 0x940C , 0xE77D},
{ 0x940D , 0xE77E},
{ 0x940E , 0xE780},
{ 0x940F , 0xE781},
{ 0x9410 , 0xE782},
{ 0x9411 , 0xE783},
{ 0x9412 , 0xE784},
{ 0x9413 , 0xE785},
{ 0x9414 , 0xE786},
{ 0x9415 , 0xE787},
{ 0x9416 , 0xE788},
{ 0x9417 , 0xE789},
{ 0x9418 , 0xE78A},
{ 0x9419 , 0xE78B},
{ 0x941A , 0xE78C},
{ 0x941B , 0xE78D},
{ 0x941C , 0xE78E},
{ 0x941D , 0xE78F},
{ 0x941E , 0xE790},
{ 0x941F , 0xE791},
{ 0x9420 , 0xE792},
{ 0x9421 , 0xE793},
{ 0x9422 , 0xE794},
{ 0x9423 , 0xE795},
{ 0x9424 , 0xE796},
{ 0x9425 , 0xE797},
{ 0x9426 , 0xE798},
{ 0x9427 , 0xE799},
{ 0x9428 , 0xE79A},
{ 0x9429 , 0xE79B},
{ 0x942A , 0xE79C},
{ 0x942B , 0xE79D},
{ 0x942C , 0xE79E},
{ 0x942D , 0xE79F},
{ 0x942E , 0xE7A0},
{ 0x7EAD , 0xE7A1},
{ 0x7EB0 , 0xE7A2},
{ 0x7EBE , 0xE7A3},
{ 0x7EC0 , 0xE7A4},
{ 0x7EC1 , 0xE7A5},
{ 0x7EC2 , 0xE7A6},
{ 0x7EC9 , 0xE7A7},
{ 0x7ECB , 0xE7A8},
{ 0x7ECC , 0xE7A9},
{ 0x7ED0 , 0xE7AA},
{ 0x7ED4 , 0xE7AB},
{ 0x7ED7 , 0xE7AC},
{ 0x7EDB , 0xE7AD},
{ 0x7EE0 , 0xE7AE},
{ 0x7EE1 , 0xE7AF},
{ 0x7EE8 , 0xE7B0},
{ 0x7EEB , 0xE7B1},
{ 0x7EEE , 0xE7B2},
{ 0x7EEF , 0xE7B3},
{ 0x7EF1 , 0xE7B4},
{ 0x7EF2 , 0xE7B5},
{ 0x7F0D , 0xE7B6},
{ 0x7EF6 , 0xE7B7},
{ 0x7EFA , 0xE7B8},
{ 0x7EFB , 0xE7B9},
{ 0x7EFE , 0xE7BA},
{ 0x7F01 , 0xE7BB},
{ 0x7F02 , 0xE7BC},
{ 0x7F03 , 0xE7BD},
{ 0x7F07 , 0xE7BE},
{ 0x7F08 , 0xE7BF},
{ 0x7F0B , 0xE7C0},
{ 0x7F0C , 0xE7C1},
{ 0x7F0F , 0xE7C2},
{ 0x7F11 , 0xE7C3},
{ 0x7F12 , 0xE7C4},
{ 0x7F17 , 0xE7C5},
{ 0x7F19 , 0xE7C6},
{ 0x7F1C , 0xE7C7},
{ 0x7F1B , 0xE7C8},
{ 0x7F1F , 0xE7C9},
{ 0x7F21 , 0xE7CA},
{ 0x7F22 , 0xE7CB},
{ 0x7F23 , 0xE7CC},
{ 0x7F24 , 0xE7CD},
{ 0x7F25 , 0xE7CE},
{ 0x7F26 , 0xE7CF},
{ 0x7F27 , 0xE7D0},
{ 0x7F2A , 0xE7D1},
{ 0x7F2B , 0xE7D2},
{ 0x7F2C , 0xE7D3},
{ 0x7F2D , 0xE7D4},
{ 0x7F2F , 0xE7D5},
{ 0x7F30 , 0xE7D6},
{ 0x7F31 , 0xE7D7},
{ 0x7F32 , 0xE7D8},
{ 0x7F33 , 0xE7D9},
{ 0x7F35 , 0xE7DA},
{ 0x5E7A , 0xE7DB},
{ 0x757F , 0xE7DC},
{ 0x5DDB , 0xE7DD},
{ 0x753E , 0xE7DE},
{ 0x9095 , 0xE7DF},
{ 0x738E , 0xE7E0},
{ 0x7391 , 0xE7E1},
{ 0x73AE , 0xE7E2},
{ 0x73A2 , 0xE7E3},
{ 0x739F , 0xE7E4},
{ 0x73CF , 0xE7E5},
{ 0x73C2 , 0xE7E6},
{ 0x73D1 , 0xE7E7},
{ 0x73B7 , 0xE7E8},
{ 0x73B3 , 0xE7E9},
{ 0x73C0 , 0xE7EA},
{ 0x73C9 , 0xE7EB},
{ 0x73C8 , 0xE7EC},
{ 0x73E5 , 0xE7ED},
{ 0x73D9 , 0xE7EE},
{ 0x987C , 0xE7EF},
{ 0x740A , 0xE7F0},
{ 0x73E9 , 0xE7F1},
{ 0x73E7 , 0xE7F2},
{ 0x73DE , 0xE7F3},
{ 0x73BA , 0xE7F4},
{ 0x73F2 , 0xE7F5},
{ 0x740F , 0xE7F6},
{ 0x742A , 0xE7F7},
{ 0x745B , 0xE7F8},
{ 0x7426 , 0xE7F9},
{ 0x7425 , 0xE7FA},
{ 0x7428 , 0xE7FB},
{ 0x7430 , 0xE7FC},
{ 0x742E , 0xE7FD},
{ 0x742C , 0xE7FE},
{ 0x942F , 0xE840},
{ 0x9430 , 0xE841},
{ 0x9431 , 0xE842},
{ 0x9432 , 0xE843},
{ 0x9433 , 0xE844},
{ 0x9434 , 0xE845},
{ 0x9435 , 0xE846},
{ 0x9436 , 0xE847},
{ 0x9437 , 0xE848},
{ 0x9438 , 0xE849},
{ 0x9439 , 0xE84A},
{ 0x943A , 0xE84B},
{ 0x943B , 0xE84C},
{ 0x943C , 0xE84D},
{ 0x943D , 0xE84E},
{ 0x943F , 0xE84F},
{ 0x9440 , 0xE850},
{ 0x9441 , 0xE851},
{ 0x9442 , 0xE852},
{ 0x9443 , 0xE853},
{ 0x9444 , 0xE854},
{ 0x9445 , 0xE855},
{ 0x9446 , 0xE856},
{ 0x9447 , 0xE857},
{ 0x9448 , 0xE858},
{ 0x9449 , 0xE859},
{ 0x944A , 0xE85A},
{ 0x944B , 0xE85B},
{ 0x944C , 0xE85C},
{ 0x944D , 0xE85D},
{ 0x944E , 0xE85E},
{ 0x944F , 0xE85F},
{ 0x9450 , 0xE860},
{ 0x9451 , 0xE861},
{ 0x9452 , 0xE862},
{ 0x9453 , 0xE863},
{ 0x9454 , 0xE864},
{ 0x9455 , 0xE865},
{ 0x9456 , 0xE866},
{ 0x9457 , 0xE867},
{ 0x9458 , 0xE868},
{ 0x9459 , 0xE869},
{ 0x945A , 0xE86A},
{ 0x945B , 0xE86B},
{ 0x945C , 0xE86C},
{ 0x945D , 0xE86D},
{ 0x945E , 0xE86E},
{ 0x945F , 0xE86F},
{ 0x9460 , 0xE870},
{ 0x9461 , 0xE871},
{ 0x9462 , 0xE872},
{ 0x9463 , 0xE873},
{ 0x9464 , 0xE874},
{ 0x9465 , 0xE875},
{ 0x9466 , 0xE876},
{ 0x9467 , 0xE877},
{ 0x9468 , 0xE878},
{ 0x9469 , 0xE879},
{ 0x946A , 0xE87A},
{ 0x946C , 0xE87B},
{ 0x946D , 0xE87C},
{ 0x946E , 0xE87D},
{ 0x946F , 0xE87E},
{ 0x9470 , 0xE880},
{ 0x9471 , 0xE881},
{ 0x9472 , 0xE882},
{ 0x9473 , 0xE883},
{ 0x9474 , 0xE884},
{ 0x9475 , 0xE885},
{ 0x9476 , 0xE886},
{ 0x9477 , 0xE887},
{ 0x9478 , 0xE888},
{ 0x9479 , 0xE889},
{ 0x947A , 0xE88A},
{ 0x947B , 0xE88B},
{ 0x947C , 0xE88C},
{ 0x947D , 0xE88D},
{ 0x947E , 0xE88E},
{ 0x947F , 0xE88F},
{ 0x9480 , 0xE890},
{ 0x9481 , 0xE891},
{ 0x9482 , 0xE892},
{ 0x9483 , 0xE893},
{ 0x9484 , 0xE894},
{ 0x9491 , 0xE895},
{ 0x9496 , 0xE896},
{ 0x9498 , 0xE897},
{ 0x94C7 , 0xE898},
{ 0x94CF , 0xE899},
{ 0x94D3 , 0xE89A},
{ 0x94D4 , 0xE89B},
{ 0x94DA , 0xE89C},
{ 0x94E6 , 0xE89D},
{ 0x94FB , 0xE89E},
{ 0x951C , 0xE89F},
{ 0x9520 , 0xE8A0},
{ 0x741B , 0xE8A1},
{ 0x741A , 0xE8A2},
{ 0x7441 , 0xE8A3},
{ 0x745C , 0xE8A4},
{ 0x7457 , 0xE8A5},
{ 0x7455 , 0xE8A6},
{ 0x7459 , 0xE8A7},
{ 0x7477 , 0xE8A8},
{ 0x746D , 0xE8A9},
{ 0x747E , 0xE8AA},
{ 0x749C , 0xE8AB},
{ 0x748E , 0xE8AC},
{ 0x7480 , 0xE8AD},
{ 0x7481 , 0xE8AE},
{ 0x7487 , 0xE8AF},
{ 0x748B , 0xE8B0},
{ 0x749E , 0xE8B1},
{ 0x74A8 , 0xE8B2},
{ 0x74A9 , 0xE8B3},
{ 0x7490 , 0xE8B4},
{ 0x74A7 , 0xE8B5},
{ 0x74D2 , 0xE8B6},
{ 0x74BA , 0xE8B7},
{ 0x97EA , 0xE8B8},
{ 0x97EB , 0xE8B9},
{ 0x97EC , 0xE8BA},
{ 0x674C , 0xE8BB},
{ 0x6753 , 0xE8BC},
{ 0x675E , 0xE8BD},
{ 0x6748 , 0xE8BE},
{ 0x6769 , 0xE8BF},
{ 0x67A5 , 0xE8C0},
{ 0x6787 , 0xE8C1},
{ 0x676A , 0xE8C2},
{ 0x6773 , 0xE8C3},
{ 0x6798 , 0xE8C4},
{ 0x67A7 , 0xE8C5},
{ 0x6775 , 0xE8C6},
{ 0x67A8 , 0xE8C7},
{ 0x679E , 0xE8C8},
{ 0x67AD , 0xE8C9},
{ 0x678B , 0xE8CA},
{ 0x6777 , 0xE8CB},
{ 0x677C , 0xE8CC},
{ 0x67F0 , 0xE8CD},
{ 0x6809 , 0xE8CE},
{ 0x67D8 , 0xE8CF},
{ 0x680A , 0xE8D0},
{ 0x67E9 , 0xE8D1},
{ 0x67B0 , 0xE8D2},
{ 0x680C , 0xE8D3},
{ 0x67D9 , 0xE8D4},
{ 0x67B5 , 0xE8D5},
{ 0x67DA , 0xE8D6},
{ 0x67B3 , 0xE8D7},
{ 0x67DD , 0xE8D8},
{ 0x6800 , 0xE8D9},
{ 0x67C3 , 0xE8DA},
{ 0x67B8 , 0xE8DB},
{ 0x67E2 , 0xE8DC},
{ 0x680E , 0xE8DD},
{ 0x67C1 , 0xE8DE},
{ 0x67FD , 0xE8DF},
{ 0x6832 , 0xE8E0},
{ 0x6833 , 0xE8E1},
{ 0x6860 , 0xE8E2},
{ 0x6861 , 0xE8E3},
{ 0x684E , 0xE8E4},
{ 0x6862 , 0xE8E5},
{ 0x6844 , 0xE8E6},
{ 0x6864 , 0xE8E7},
{ 0x6883 , 0xE8E8},
{ 0x681D , 0xE8E9},
{ 0x6855 , 0xE8EA},
{ 0x6866 , 0xE8EB},
{ 0x6841 , 0xE8EC},
{ 0x6867 , 0xE8ED},
{ 0x6840 , 0xE8EE},
{ 0x683E , 0xE8EF},
{ 0x684A , 0xE8F0},
{ 0x6849 , 0xE8F1},
{ 0x6829 , 0xE8F2},
{ 0x68B5 , 0xE8F3},
{ 0x688F , 0xE8F4},
{ 0x6874 , 0xE8F5},
{ 0x6877 , 0xE8F6},
{ 0x6893 , 0xE8F7},
{ 0x686B , 0xE8F8},
{ 0x68C2 , 0xE8F9},
{ 0x696E , 0xE8FA},
{ 0x68FC , 0xE8FB},
{ 0x691F , 0xE8FC},
{ 0x6920 , 0xE8FD},
{ 0x68F9 , 0xE8FE},
{ 0x9527 , 0xE940},
{ 0x9533 , 0xE941},
{ 0x953D , 0xE942},
{ 0x9543 , 0xE943},
{ 0x9548 , 0xE944},
{ 0x954B , 0xE945},
{ 0x9555 , 0xE946},
{ 0x955A , 0xE947},
{ 0x9560 , 0xE948},
{ 0x956E , 0xE949},
{ 0x9574 , 0xE94A},
{ 0x9575 , 0xE94B},
{ 0x9577 , 0xE94C},
{ 0x9578 , 0xE94D},
{ 0x9579 , 0xE94E},
{ 0x957A , 0xE94F},
{ 0x957B , 0xE950},
{ 0x957C , 0xE951},
{ 0x957D , 0xE952},
{ 0x957E , 0xE953},
{ 0x9580 , 0xE954},
{ 0x9581 , 0xE955},
{ 0x9582 , 0xE956},
{ 0x9583 , 0xE957},
{ 0x9584 , 0xE958},
{ 0x9585 , 0xE959},
{ 0x9586 , 0xE95A},
{ 0x9587 , 0xE95B},
{ 0x9588 , 0xE95C},
{ 0x9589 , 0xE95D},
{ 0x958A , 0xE95E},
{ 0x958B , 0xE95F},
{ 0x958C , 0xE960},
{ 0x958D , 0xE961},
{ 0x958E , 0xE962},
{ 0x958F , 0xE963},
{ 0x9590 , 0xE964},
{ 0x9591 , 0xE965},
{ 0x9592 , 0xE966},
{ 0x9593 , 0xE967},
{ 0x9594 , 0xE968},
{ 0x9595 , 0xE969},
{ 0x9596 , 0xE96A},
{ 0x9597 , 0xE96B},
{ 0x9598 , 0xE96C},
{ 0x9599 , 0xE96D},
{ 0x959A , 0xE96E},
{ 0x959B , 0xE96F},
{ 0x959C , 0xE970},
{ 0x959D , 0xE971},
{ 0x959E , 0xE972},
{ 0x959F , 0xE973},
{ 0x95A0 , 0xE974},
{ 0x95A1 , 0xE975},
{ 0x95A2 , 0xE976},
{ 0x95A3 , 0xE977},
{ 0x95A4 , 0xE978},
{ 0x95A5 , 0xE979},
{ 0x95A6 , 0xE97A},
{ 0x95A7 , 0xE97B},
{ 0x95A8 , 0xE97C},
{ 0x95A9 , 0xE97D},
{ 0x95AA , 0xE97E},
{ 0x95AB , 0xE980},
{ 0x95AC , 0xE981},
{ 0x95AD , 0xE982},
{ 0x95AE , 0xE983},
{ 0x95AF , 0xE984},
{ 0x95B0 , 0xE985},
{ 0x95B1 , 0xE986},
{ 0x95B2 , 0xE987},
{ 0x95B3 , 0xE988},
{ 0x95B4 , 0xE989},
{ 0x95B5 , 0xE98A},
{ 0x95B6 , 0xE98B},
{ 0x95B7 , 0xE98C},
{ 0x95B8 , 0xE98D},
{ 0x95B9 , 0xE98E},
{ 0x95BA , 0xE98F},
{ 0x95BB , 0xE990},
{ 0x95BC , 0xE991},
{ 0x95BD , 0xE992},
{ 0x95BE , 0xE993},
{ 0x95BF , 0xE994},
{ 0x95C0 , 0xE995},
{ 0x95C1 , 0xE996},
{ 0x95C2 , 0xE997},
{ 0x95C3 , 0xE998},
{ 0x95C4 , 0xE999},
{ 0x95C5 , 0xE99A},
{ 0x95C6 , 0xE99B},
{ 0x95C7 , 0xE99C},
{ 0x95C8 , 0xE99D},
{ 0x95C9 , 0xE99E},
{ 0x95CA , 0xE99F},
{ 0x95CB , 0xE9A0},
{ 0x6924 , 0xE9A1},
{ 0x68F0 , 0xE9A2},
{ 0x690B , 0xE9A3},
{ 0x6901 , 0xE9A4},
{ 0x6957 , 0xE9A5},
{ 0x68E3 , 0xE9A6},
{ 0x6910 , 0xE9A7},
{ 0x6971 , 0xE9A8},
{ 0x6939 , 0xE9A9},
{ 0x6960 , 0xE9AA},
{ 0x6942 , 0xE9AB},
{ 0x695D , 0xE9AC},
{ 0x6984 , 0xE9AD},
{ 0x696B , 0xE9AE},
{ 0x6980 , 0xE9AF},
{ 0x6998 , 0xE9B0},
{ 0x6978 , 0xE9B1},
{ 0x6934 , 0xE9B2},
{ 0x69CC , 0xE9B3},
{ 0x6987 , 0xE9B4},
{ 0x6988 , 0xE9B5},
{ 0x69CE , 0xE9B6},
{ 0x6989 , 0xE9B7},
{ 0x6966 , 0xE9B8},
{ 0x6963 , 0xE9B9},
{ 0x6979 , 0xE9BA},
{ 0x699B , 0xE9BB},
{ 0x69A7 , 0xE9BC},
{ 0x69BB , 0xE9BD},
{ 0x69AB , 0xE9BE},
{ 0x69AD , 0xE9BF},
{ 0x69D4 , 0xE9C0},
{ 0x69B1 , 0xE9C1},
{ 0x69C1 , 0xE9C2},
{ 0x69CA , 0xE9C3},
{ 0x69DF , 0xE9C4},
{ 0x6995 , 0xE9C5},
{ 0x69E0 , 0xE9C6},
{ 0x698D , 0xE9C7},
{ 0x69FF , 0xE9C8},
{ 0x6A2F , 0xE9C9},
{ 0x69ED , 0xE9CA},
{ 0x6A17 , 0xE9CB},
{ 0x6A18 , 0xE9CC},
{ 0x6A65 , 0xE9CD},
{ 0x69F2 , 0xE9CE},
{ 0x6A44 , 0xE9CF},
{ 0x6A3E , 0xE9D0},
{ 0x6AA0 , 0xE9D1},
{ 0x6A50 , 0xE9D2},
{ 0x6A5B , 0xE9D3},
{ 0x6A35 , 0xE9D4},
{ 0x6A8E , 0xE9D5},
{ 0x6A79 , 0xE9D6},
{ 0x6A3D , 0xE9D7},
{ 0x6A28 , 0xE9D8},
{ 0x6A58 , 0xE9D9},
{ 0x6A7C , 0xE9DA},
{ 0x6A91 , 0xE9DB},
{ 0x6A90 , 0xE9DC},
{ 0x6AA9 , 0xE9DD},
{ 0x6A97 , 0xE9DE},
{ 0x6AAB , 0xE9DF},
{ 0x7337 , 0xE9E0},
{ 0x7352 , 0xE9E1},
{ 0x6B81 , 0xE9E2},
{ 0x6B82 , 0xE9E3},
{ 0x6B87 , 0xE9E4},
{ 0x6B84 , 0xE9E5},
{ 0x6B92 , 0xE9E6},
{ 0x6B93 , 0xE9E7},
{ 0x6B8D , 0xE9E8},
{ 0x6B9A , 0xE9E9},
{ 0x6B9B , 0xE9EA},
{ 0x6BA1 , 0xE9EB},
{ 0x6BAA , 0xE9EC},
{ 0x8F6B , 0xE9ED},
{ 0x8F6D , 0xE9EE},
{ 0x8F71 , 0xE9EF},
{ 0x8F72 , 0xE9F0},
{ 0x8F73 , 0xE9F1},
{ 0x8F75 , 0xE9F2},
{ 0x8F76 , 0xE9F3},
{ 0x8F78 , 0xE9F4},
{ 0x8F77 , 0xE9F5},
{ 0x8F79 , 0xE9F6},
{ 0x8F7A , 0xE9F7},
{ 0x8F7C , 0xE9F8},
{ 0x8F7E , 0xE9F9},
{ 0x8F81 , 0xE9FA},
{ 0x8F82 , 0xE9FB},
{ 0x8F84 , 0xE9FC},
{ 0x8F87 , 0xE9FD},
{ 0x8F8B , 0xE9FE},
{ 0x95CC , 0xEA40},
{ 0x95CD , 0xEA41},
{ 0x95CE , 0xEA42},
{ 0x95CF , 0xEA43},
{ 0x95D0 , 0xEA44},
{ 0x95D1 , 0xEA45},
{ 0x95D2 , 0xEA46},
{ 0x95D3 , 0xEA47},
{ 0x95D4 , 0xEA48},
{ 0x95D5 , 0xEA49},
{ 0x95D6 , 0xEA4A},
{ 0x95D7 , 0xEA4B},
{ 0x95D8 , 0xEA4C},
{ 0x95D9 , 0xEA4D},
{ 0x95DA , 0xEA4E},
{ 0x95DB , 0xEA4F},
{ 0x95DC , 0xEA50},
{ 0x95DD , 0xEA51},
{ 0x95DE , 0xEA52},
{ 0x95DF , 0xEA53},
{ 0x95E0 , 0xEA54},
{ 0x95E1 , 0xEA55},
{ 0x95E2 , 0xEA56},
{ 0x95E3 , 0xEA57},
{ 0x95E4 , 0xEA58},
{ 0x95E5 , 0xEA59},
{ 0x95E6 , 0xEA5A},
{ 0x95E7 , 0xEA5B},
{ 0x95EC , 0xEA5C},
{ 0x95FF , 0xEA5D},
{ 0x9607 , 0xEA5E},
{ 0x9613 , 0xEA5F},
{ 0x9618 , 0xEA60},
{ 0x961B , 0xEA61},
{ 0x961E , 0xEA62},
{ 0x9620 , 0xEA63},
{ 0x9623 , 0xEA64},
{ 0x9624 , 0xEA65},
{ 0x9625 , 0xEA66},
{ 0x9626 , 0xEA67},
{ 0x9627 , 0xEA68},
{ 0x9628 , 0xEA69},
{ 0x9629 , 0xEA6A},
{ 0x962B , 0xEA6B},
{ 0x962C , 0xEA6C},
{ 0x962D , 0xEA6D},
{ 0x962F , 0xEA6E},
{ 0x9630 , 0xEA6F},
{ 0x9637 , 0xEA70},
{ 0x9638 , 0xEA71},
{ 0x9639 , 0xEA72},
{ 0x963A , 0xEA73},
{ 0x963E , 0xEA74},
{ 0x9641 , 0xEA75},
{ 0x9643 , 0xEA76},
{ 0x964A , 0xEA77},
{ 0x964E , 0xEA78},
{ 0x964F , 0xEA79},
{ 0x9651 , 0xEA7A},
{ 0x9652 , 0xEA7B},
{ 0x9653 , 0xEA7C},
{ 0x9656 , 0xEA7D},
{ 0x9657 , 0xEA7E},
{ 0x9658 , 0xEA80},
{ 0x9659 , 0xEA81},
{ 0x965A , 0xEA82},
{ 0x965C , 0xEA83},
{ 0x965D , 0xEA84},
{ 0x965E , 0xEA85},
{ 0x9660 , 0xEA86},
{ 0x9663 , 0xEA87},
{ 0x9665 , 0xEA88},
{ 0x9666 , 0xEA89},
{ 0x966B , 0xEA8A},
{ 0x966D , 0xEA8B},
{ 0x966E , 0xEA8C},
{ 0x966F , 0xEA8D},
{ 0x9670 , 0xEA8E},
{ 0x9671 , 0xEA8F},
{ 0x9673 , 0xEA90},
{ 0x9678 , 0xEA91},
{ 0x9679 , 0xEA92},
{ 0x967A , 0xEA93},
{ 0x967B , 0xEA94},
{ 0x967C , 0xEA95},
{ 0x967D , 0xEA96},
{ 0x967E , 0xEA97},
{ 0x967F , 0xEA98},
{ 0x9680 , 0xEA99},
{ 0x9681 , 0xEA9A},
{ 0x9682 , 0xEA9B},
{ 0x9683 , 0xEA9C},
{ 0x9684 , 0xEA9D},
{ 0x9687 , 0xEA9E},
{ 0x9689 , 0xEA9F},
{ 0x968A , 0xEAA0},
{ 0x8F8D , 0xEAA1},
{ 0x8F8E , 0xEAA2},
{ 0x8F8F , 0xEAA3},
{ 0x8F98 , 0xEAA4},
{ 0x8F9A , 0xEAA5},
{ 0x8ECE , 0xEAA6},
{ 0x620B , 0xEAA7},
{ 0x6217 , 0xEAA8},
{ 0x621B , 0xEAA9},
{ 0x621F , 0xEAAA},
{ 0x6222 , 0xEAAB},
{ 0x6221 , 0xEAAC},
{ 0x6225 , 0xEAAD},
{ 0x6224 , 0xEAAE},
{ 0x622C , 0xEAAF},
{ 0x81E7 , 0xEAB0},
{ 0x74EF , 0xEAB1},
{ 0x74F4 , 0xEAB2},
{ 0x74FF , 0xEAB3},
{ 0x750F , 0xEAB4},
{ 0x7511 , 0xEAB5},
{ 0x7513 , 0xEAB6},
{ 0x6534 , 0xEAB7},
{ 0x65EE , 0xEAB8},
{ 0x65EF , 0xEAB9},
{ 0x65F0 , 0xEABA},
{ 0x660A , 0xEABB},
{ 0x6619 , 0xEABC},
{ 0x6772 , 0xEABD},
{ 0x6603 , 0xEABE},
{ 0x6615 , 0xEABF},
{ 0x6600 , 0xEAC0},
{ 0x7085 , 0xEAC1},
{ 0x66F7 , 0xEAC2},
{ 0x661D , 0xEAC3},
{ 0x6634 , 0xEAC4},
{ 0x6631 , 0xEAC5},
{ 0x6636 , 0xEAC6},
{ 0x6635 , 0xEAC7},
{ 0x8006 , 0xEAC8},
{ 0x665F , 0xEAC9},
{ 0x6654 , 0xEACA},
{ 0x6641 , 0xEACB},
{ 0x664F , 0xEACC},
{ 0x6656 , 0xEACD},
{ 0x6661 , 0xEACE},
{ 0x6657 , 0xEACF},
{ 0x6677 , 0xEAD0},
{ 0x6684 , 0xEAD1},
{ 0x668C , 0xEAD2},
{ 0x66A7 , 0xEAD3},
{ 0x669D , 0xEAD4},
{ 0x66BE , 0xEAD5},
{ 0x66DB , 0xEAD6},
{ 0x66DC , 0xEAD7},
{ 0x66E6 , 0xEAD8},
{ 0x66E9 , 0xEAD9},
{ 0x8D32 , 0xEADA},
{ 0x8D33 , 0xEADB},
{ 0x8D36 , 0xEADC},
{ 0x8D3B , 0xEADD},
{ 0x8D3D , 0xEADE},
{ 0x8D40 , 0xEADF},
{ 0x8D45 , 0xEAE0},
{ 0x8D46 , 0xEAE1},
{ 0x8D48 , 0xEAE2},
{ 0x8D49 , 0xEAE3},
{ 0x8D47 , 0xEAE4},
{ 0x8D4D , 0xEAE5},
{ 0x8D55 , 0xEAE6},
{ 0x8D59 , 0xEAE7},
{ 0x89C7 , 0xEAE8},
{ 0x89CA , 0xEAE9},
{ 0x89CB , 0xEAEA},
{ 0x89CC , 0xEAEB},
{ 0x89CE , 0xEAEC},
{ 0x89CF , 0xEAED},
{ 0x89D0 , 0xEAEE},
{ 0x89D1 , 0xEAEF},
{ 0x726E , 0xEAF0},
{ 0x729F , 0xEAF1},
{ 0x725D , 0xEAF2},
{ 0x7266 , 0xEAF3},
{ 0x726F , 0xEAF4},
{ 0x727E , 0xEAF5},
{ 0x727F , 0xEAF6},
{ 0x7284 , 0xEAF7},
{ 0x728B , 0xEAF8},
{ 0x728D , 0xEAF9},
{ 0x728F , 0xEAFA},
{ 0x7292 , 0xEAFB},
{ 0x6308 , 0xEAFC},
{ 0x6332 , 0xEAFD},
{ 0x63B0 , 0xEAFE},
{ 0x968C , 0xEB40},
{ 0x968E , 0xEB41},
{ 0x9691 , 0xEB42},
{ 0x9692 , 0xEB43},
{ 0x9693 , 0xEB44},
{ 0x9695 , 0xEB45},
{ 0x9696 , 0xEB46},
{ 0x969A , 0xEB47},
{ 0x969B , 0xEB48},
{ 0x969D , 0xEB49},
{ 0x969E , 0xEB4A},
{ 0x969F , 0xEB4B},
{ 0x96A0 , 0xEB4C},
{ 0x96A1 , 0xEB4D},
{ 0x96A2 , 0xEB4E},
{ 0x96A3 , 0xEB4F},
{ 0x96A4 , 0xEB50},
{ 0x96A5 , 0xEB51},
{ 0x96A6 , 0xEB52},
{ 0x96A8 , 0xEB53},
{ 0x96A9 , 0xEB54},
{ 0x96AA , 0xEB55},
{ 0x96AB , 0xEB56},
{ 0x96AC , 0xEB57},
{ 0x96AD , 0xEB58},
{ 0x96AE , 0xEB59},
{ 0x96AF , 0xEB5A},
{ 0x96B1 , 0xEB5B},
{ 0x96B2 , 0xEB5C},
{ 0x96B4 , 0xEB5D},
{ 0x96B5 , 0xEB5E},
{ 0x96B7 , 0xEB5F},
{ 0x96B8 , 0xEB60},
{ 0x96BA , 0xEB61},
{ 0x96BB , 0xEB62},
{ 0x96BF , 0xEB63},
{ 0x96C2 , 0xEB64},
{ 0x96C3 , 0xEB65},
{ 0x96C8 , 0xEB66},
{ 0x96CA , 0xEB67},
{ 0x96CB , 0xEB68},
{ 0x96D0 , 0xEB69},
{ 0x96D1 , 0xEB6A},
{ 0x96D3 , 0xEB6B},
{ 0x96D4 , 0xEB6C},
{ 0x96D6 , 0xEB6D},
{ 0x96D7 , 0xEB6E},
{ 0x96D8 , 0xEB6F},
{ 0x96D9 , 0xEB70},
{ 0x96DA , 0xEB71},
{ 0x96DB , 0xEB72},
{ 0x96DC , 0xEB73},
{ 0x96DD , 0xEB74},
{ 0x96DE , 0xEB75},
{ 0x96DF , 0xEB76},
{ 0x96E1 , 0xEB77},
{ 0x96E2 , 0xEB78},
{ 0x96E3 , 0xEB79},
{ 0x96E4 , 0xEB7A},
{ 0x96E5 , 0xEB7B},
{ 0x96E6 , 0xEB7C},
{ 0x96E7 , 0xEB7D},
{ 0x96EB , 0xEB7E},
{ 0x96EC , 0xEB80},
{ 0x96ED , 0xEB81},
{ 0x96EE , 0xEB82},
{ 0x96F0 , 0xEB83},
{ 0x96F1 , 0xEB84},
{ 0x96F2 , 0xEB85},
{ 0x96F4 , 0xEB86},
{ 0x96F5 , 0xEB87},
{ 0x96F8 , 0xEB88},
{ 0x96FA , 0xEB89},
{ 0x96FB , 0xEB8A},
{ 0x96FC , 0xEB8B},
{ 0x96FD , 0xEB8C},
{ 0x96FF , 0xEB8D},
{ 0x9702 , 0xEB8E},
{ 0x9703 , 0xEB8F},
{ 0x9705 , 0xEB90},
{ 0x970A , 0xEB91},
{ 0x970B , 0xEB92},
{ 0x970C , 0xEB93},
{ 0x9710 , 0xEB94},
{ 0x9711 , 0xEB95},
{ 0x9712 , 0xEB96},
{ 0x9714 , 0xEB97},
{ 0x9715 , 0xEB98},
{ 0x9717 , 0xEB99},
{ 0x9718 , 0xEB9A},
{ 0x9719 , 0xEB9B},
{ 0x971A , 0xEB9C},
{ 0x971B , 0xEB9D},
{ 0x971D , 0xEB9E},
{ 0x971F , 0xEB9F},
{ 0x9720 , 0xEBA0},
{ 0x643F , 0xEBA1},
{ 0x64D8 , 0xEBA2},
{ 0x8004 , 0xEBA3},
{ 0x6BEA , 0xEBA4},
{ 0x6BF3 , 0xEBA5},
{ 0x6BFD , 0xEBA6},
{ 0x6BF5 , 0xEBA7},
{ 0x6BF9 , 0xEBA8},
{ 0x6C05 , 0xEBA9},
{ 0x6C07 , 0xEBAA},
{ 0x6C06 , 0xEBAB},
{ 0x6C0D , 0xEBAC},
{ 0x6C15 , 0xEBAD},
{ 0x6C18 , 0xEBAE},
{ 0x6C19 , 0xEBAF},
{ 0x6C1A , 0xEBB0},
{ 0x6C21 , 0xEBB1},
{ 0x6C29 , 0xEBB2},
{ 0x6C24 , 0xEBB3},
{ 0x6C2A , 0xEBB4},
{ 0x6C32 , 0xEBB5},
{ 0x6535 , 0xEBB6},
{ 0x6555 , 0xEBB7},
{ 0x656B , 0xEBB8},
{ 0x724D , 0xEBB9},
{ 0x7252 , 0xEBBA},
{ 0x7256 , 0xEBBB},
{ 0x7230 , 0xEBBC},
{ 0x8662 , 0xEBBD},
{ 0x5216 , 0xEBBE},
{ 0x809F , 0xEBBF},
{ 0x809C , 0xEBC0},
{ 0x8093 , 0xEBC1},
{ 0x80BC , 0xEBC2},
{ 0x670A , 0xEBC3},
{ 0x80BD , 0xEBC4},
{ 0x80B1 , 0xEBC5},
{ 0x80AB , 0xEBC6},
{ 0x80AD , 0xEBC7},
{ 0x80B4 , 0xEBC8},
{ 0x80B7 , 0xEBC9},
{ 0x80E7 , 0xEBCA},
{ 0x80E8 , 0xEBCB},
{ 0x80E9 , 0xEBCC},
{ 0x80EA , 0xEBCD},
{ 0x80DB , 0xEBCE},
{ 0x80C2 , 0xEBCF},
{ 0x80C4 , 0xEBD0},
{ 0x80D9 , 0xEBD1},
{ 0x80CD , 0xEBD2},
{ 0x80D7 , 0xEBD3},
{ 0x6710 , 0xEBD4},
{ 0x80DD , 0xEBD5},
{ 0x80EB , 0xEBD6},
{ 0x80F1 , 0xEBD7},
{ 0x80F4 , 0xEBD8},
{ 0x80ED , 0xEBD9},
{ 0x810D , 0xEBDA},
{ 0x810E , 0xEBDB},
{ 0x80F2 , 0xEBDC},
{ 0x80FC , 0xEBDD},
{ 0x6715 , 0xEBDE},
{ 0x8112 , 0xEBDF},
{ 0x8C5A , 0xEBE0},
{ 0x8136 , 0xEBE1},
{ 0x811E , 0xEBE2},
{ 0x812C , 0xEBE3},
{ 0x8118 , 0xEBE4},
{ 0x8132 , 0xEBE5},
{ 0x8148 , 0xEBE6},
{ 0x814C , 0xEBE7},
{ 0x8153 , 0xEBE8},
{ 0x8174 , 0xEBE9},
{ 0x8159 , 0xEBEA},
{ 0x815A , 0xEBEB},
{ 0x8171 , 0xEBEC},
{ 0x8160 , 0xEBED},
{ 0x8169 , 0xEBEE},
{ 0x817C , 0xEBEF},
{ 0x817D , 0xEBF0},
{ 0x816D , 0xEBF1},
{ 0x8167 , 0xEBF2},
{ 0x584D , 0xEBF3},
{ 0x5AB5 , 0xEBF4},
{ 0x8188 , 0xEBF5},
{ 0x8182 , 0xEBF6},
{ 0x8191 , 0xEBF7},
{ 0x6ED5 , 0xEBF8},
{ 0x81A3 , 0xEBF9},
{ 0x81AA , 0xEBFA},
{ 0x81CC , 0xEBFB},
{ 0x6726 , 0xEBFC},
{ 0x81CA , 0xEBFD},
{ 0x81BB , 0xEBFE},
{ 0x9721 , 0xEC40},
{ 0x9722 , 0xEC41},
{ 0x9723 , 0xEC42},
{ 0x9724 , 0xEC43},
{ 0x9725 , 0xEC44},
{ 0x9726 , 0xEC45},
{ 0x9727 , 0xEC46},
{ 0x9728 , 0xEC47},
{ 0x9729 , 0xEC48},
{ 0x972B , 0xEC49},
{ 0x972C , 0xEC4A},
{ 0x972E , 0xEC4B},
{ 0x972F , 0xEC4C},
{ 0x9731 , 0xEC4D},
{ 0x9733 , 0xEC4E},
{ 0x9734 , 0xEC4F},
{ 0x9735 , 0xEC50},
{ 0x9736 , 0xEC51},
{ 0x9737 , 0xEC52},
{ 0x973A , 0xEC53},
{ 0x973B , 0xEC54},
{ 0x973C , 0xEC55},
{ 0x973D , 0xEC56},
{ 0x973F , 0xEC57},
{ 0x9740 , 0xEC58},
{ 0x9741 , 0xEC59},
{ 0x9742 , 0xEC5A},
{ 0x9743 , 0xEC5B},
{ 0x9744 , 0xEC5C},
{ 0x9745 , 0xEC5D},
{ 0x9746 , 0xEC5E},
{ 0x9747 , 0xEC5F},
{ 0x9748 , 0xEC60},
{ 0x9749 , 0xEC61},
{ 0x974A , 0xEC62},
{ 0x974B , 0xEC63},
{ 0x974C , 0xEC64},
{ 0x974D , 0xEC65},
{ 0x974E , 0xEC66},
{ 0x974F , 0xEC67},
{ 0x9750 , 0xEC68},
{ 0x9751 , 0xEC69},
{ 0x9754 , 0xEC6A},
{ 0x9755 , 0xEC6B},
{ 0x9757 , 0xEC6C},
{ 0x9758 , 0xEC6D},
{ 0x975A , 0xEC6E},
{ 0x975C , 0xEC6F},
{ 0x975D , 0xEC70},
{ 0x975F , 0xEC71},
{ 0x9763 , 0xEC72},
{ 0x9764 , 0xEC73},
{ 0x9766 , 0xEC74},
{ 0x9767 , 0xEC75},
{ 0x9768 , 0xEC76},
{ 0x976A , 0xEC77},
{ 0x976B , 0xEC78},
{ 0x976C , 0xEC79},
{ 0x976D , 0xEC7A},
{ 0x976E , 0xEC7B},
{ 0x976F , 0xEC7C},
{ 0x9770 , 0xEC7D},
{ 0x9771 , 0xEC7E},
{ 0x9772 , 0xEC80},
{ 0x9775 , 0xEC81},
{ 0x9777 , 0xEC82},
{ 0x9778 , 0xEC83},
{ 0x9779 , 0xEC84},
{ 0x977A , 0xEC85},
{ 0x977B , 0xEC86},
{ 0x977D , 0xEC87},
{ 0x977E , 0xEC88},
{ 0x977F , 0xEC89},
{ 0x9780 , 0xEC8A},
{ 0x9781 , 0xEC8B},
{ 0x9782 , 0xEC8C},
{ 0x9783 , 0xEC8D},
{ 0x9784 , 0xEC8E},
{ 0x9786 , 0xEC8F},
{ 0x9787 , 0xEC90},
{ 0x9788 , 0xEC91},
{ 0x9789 , 0xEC92},
{ 0x978A , 0xEC93},
{ 0x978C , 0xEC94},
{ 0x978E , 0xEC95},
{ 0x978F , 0xEC96},
{ 0x9790 , 0xEC97},
{ 0x9793 , 0xEC98},
{ 0x9795 , 0xEC99},
{ 0x9796 , 0xEC9A},
{ 0x9797 , 0xEC9B},
{ 0x9799 , 0xEC9C},
{ 0x979A , 0xEC9D},
{ 0x979B , 0xEC9E},
{ 0x979C , 0xEC9F},
{ 0x979D , 0xECA0},
{ 0x81C1 , 0xECA1},
{ 0x81A6 , 0xECA2},
{ 0x6B24 , 0xECA3},
{ 0x6B37 , 0xECA4},
{ 0x6B39 , 0xECA5},
{ 0x6B43 , 0xECA6},
{ 0x6B46 , 0xECA7},
{ 0x6B59 , 0xECA8},
{ 0x98D1 , 0xECA9},
{ 0x98D2 , 0xECAA},
{ 0x98D3 , 0xECAB},
{ 0x98D5 , 0xECAC},
{ 0x98D9 , 0xECAD},
{ 0x98DA , 0xECAE},
{ 0x6BB3 , 0xECAF},
{ 0x5F40 , 0xECB0},
{ 0x6BC2 , 0xECB1},
{ 0x89F3 , 0xECB2},
{ 0x6590 , 0xECB3},
{ 0x9F51 , 0xECB4},
{ 0x6593 , 0xECB5},
{ 0x65BC , 0xECB6},
{ 0x65C6 , 0xECB7},
{ 0x65C4 , 0xECB8},
{ 0x65C3 , 0xECB9},
{ 0x65CC , 0xECBA},
{ 0x65CE , 0xECBB},
{ 0x65D2 , 0xECBC},
{ 0x65D6 , 0xECBD},
{ 0x7080 , 0xECBE},
{ 0x709C , 0xECBF},
{ 0x7096 , 0xECC0},
{ 0x709D , 0xECC1},
{ 0x70BB , 0xECC2},
{ 0x70C0 , 0xECC3},
{ 0x70B7 , 0xECC4},
{ 0x70AB , 0xECC5},
{ 0x70B1 , 0xECC6},
{ 0x70E8 , 0xECC7},
{ 0x70CA , 0xECC8},
{ 0x7110 , 0xECC9},
{ 0x7113 , 0xECCA},
{ 0x7116 , 0xECCB},
{ 0x712F , 0xECCC},
{ 0x7131 , 0xECCD},
{ 0x7173 , 0xECCE},
{ 0x715C , 0xECCF},
{ 0x7168 , 0xECD0},
{ 0x7145 , 0xECD1},
{ 0x7172 , 0xECD2},
{ 0x714A , 0xECD3},
{ 0x7178 , 0xECD4},
{ 0x717A , 0xECD5},
{ 0x7198 , 0xECD6},
{ 0x71B3 , 0xECD7},
{ 0x71B5 , 0xECD8},
{ 0x71A8 , 0xECD9},
{ 0x71A0 , 0xECDA},
{ 0x71E0 , 0xECDB},
{ 0x71D4 , 0xECDC},
{ 0x71E7 , 0xECDD},
{ 0x71F9 , 0xECDE},
{ 0x721D , 0xECDF},
{ 0x7228 , 0xECE0},
{ 0x706C , 0xECE1},
{ 0x7118 , 0xECE2},
{ 0x7166 , 0xECE3},
{ 0x71B9 , 0xECE4},
{ 0x623E , 0xECE5},
{ 0x623D , 0xECE6},
{ 0x6243 , 0xECE7},
{ 0x6248 , 0xECE8},
{ 0x6249 , 0xECE9},
{ 0x793B , 0xECEA},
{ 0x7940 , 0xECEB},
{ 0x7946 , 0xECEC},
{ 0x7949 , 0xECED},
{ 0x795B , 0xECEE},
{ 0x795C , 0xECEF},
{ 0x7953 , 0xECF0},
{ 0x795A , 0xECF1},
{ 0x7962 , 0xECF2},
{ 0x7957 , 0xECF3},
{ 0x7960 , 0xECF4},
{ 0x796F , 0xECF5},
{ 0x7967 , 0xECF6},
{ 0x797A , 0xECF7},
{ 0x7985 , 0xECF8},
{ 0x798A , 0xECF9},
{ 0x799A , 0xECFA},
{ 0x79A7 , 0xECFB},
{ 0x79B3 , 0xECFC},
{ 0x5FD1 , 0xECFD},
{ 0x5FD0 , 0xECFE},
{ 0x979E , 0xED40},
{ 0x979F , 0xED41},
{ 0x97A1 , 0xED42},
{ 0x97A2 , 0xED43},
{ 0x97A4 , 0xED44},
{ 0x97A5 , 0xED45},
{ 0x97A6 , 0xED46},
{ 0x97A7 , 0xED47},
{ 0x97A8 , 0xED48},
{ 0x97A9 , 0xED49},
{ 0x97AA , 0xED4A},
{ 0x97AC , 0xED4B},
{ 0x97AE , 0xED4C},
{ 0x97B0 , 0xED4D},
{ 0x97B1 , 0xED4E},
{ 0x97B3 , 0xED4F},
{ 0x97B5 , 0xED50},
{ 0x97B6 , 0xED51},
{ 0x97B7 , 0xED52},
{ 0x97B8 , 0xED53},
{ 0x97B9 , 0xED54},
{ 0x97BA , 0xED55},
{ 0x97BB , 0xED56},
{ 0x97BC , 0xED57},
{ 0x97BD , 0xED58},
{ 0x97BE , 0xED59},
{ 0x97BF , 0xED5A},
{ 0x97C0 , 0xED5B},
{ 0x97C1 , 0xED5C},
{ 0x97C2 , 0xED5D},
{ 0x97C3 , 0xED5E},
{ 0x97C4 , 0xED5F},
{ 0x97C5 , 0xED60},
{ 0x97C6 , 0xED61},
{ 0x97C7 , 0xED62},
{ 0x97C8 , 0xED63},
{ 0x97C9 , 0xED64},
{ 0x97CA , 0xED65},
{ 0x97CB , 0xED66},
{ 0x97CC , 0xED67},
{ 0x97CD , 0xED68},
{ 0x97CE , 0xED69},
{ 0x97CF , 0xED6A},
{ 0x97D0 , 0xED6B},
{ 0x97D1 , 0xED6C},
{ 0x97D2 , 0xED6D},
{ 0x97D3 , 0xED6E},
{ 0x97D4 , 0xED6F},
{ 0x97D5 , 0xED70},
{ 0x97D6 , 0xED71},
{ 0x97D7 , 0xED72},
{ 0x97D8 , 0xED73},
{ 0x97D9 , 0xED74},
{ 0x97DA , 0xED75},
{ 0x97DB , 0xED76},
{ 0x97DC , 0xED77},
{ 0x97DD , 0xED78},
{ 0x97DE , 0xED79},
{ 0x97DF , 0xED7A},
{ 0x97E0 , 0xED7B},
{ 0x97E1 , 0xED7C},
{ 0x97E2 , 0xED7D},
{ 0x97E3 , 0xED7E},
{ 0x97E4 , 0xED80},
{ 0x97E5 , 0xED81},
{ 0x97E8 , 0xED82},
{ 0x97EE , 0xED83},
{ 0x97EF , 0xED84},
{ 0x97F0 , 0xED85},
{ 0x97F1 , 0xED86},
{ 0x97F2 , 0xED87},
{ 0x97F4 , 0xED88},
{ 0x97F7 , 0xED89},
{ 0x97F8 , 0xED8A},
{ 0x97F9 , 0xED8B},
{ 0x97FA , 0xED8C},
{ 0x97FB , 0xED8D},
{ 0x97FC , 0xED8E},
{ 0x97FD , 0xED8F},
{ 0x97FE , 0xED90},
{ 0x97FF , 0xED91},
{ 0x9800 , 0xED92},
{ 0x9801 , 0xED93},
{ 0x9802 , 0xED94},
{ 0x9803 , 0xED95},
{ 0x9804 , 0xED96},
{ 0x9805 , 0xED97},
{ 0x9806 , 0xED98},
{ 0x9807 , 0xED99},
{ 0x9808 , 0xED9A},
{ 0x9809 , 0xED9B},
{ 0x980A , 0xED9C},
{ 0x980B , 0xED9D},
{ 0x980C , 0xED9E},
{ 0x980D , 0xED9F},
{ 0x980E , 0xEDA0},
{ 0x603C , 0xEDA1},
{ 0x605D , 0xEDA2},
{ 0x605A , 0xEDA3},
{ 0x6067 , 0xEDA4},
{ 0x6041 , 0xEDA5},
{ 0x6059 , 0xEDA6},
{ 0x6063 , 0xEDA7},
{ 0x60AB , 0xEDA8},
{ 0x6106 , 0xEDA9},
{ 0x610D , 0xEDAA},
{ 0x615D , 0xEDAB},
{ 0x61A9 , 0xEDAC},
{ 0x619D , 0xEDAD},
{ 0x61CB , 0xEDAE},
{ 0x61D1 , 0xEDAF},
{ 0x6206 , 0xEDB0},
{ 0x8080 , 0xEDB1},
{ 0x807F , 0xEDB2},
{ 0x6C93 , 0xEDB3},
{ 0x6CF6 , 0xEDB4},
{ 0x6DFC , 0xEDB5},
{ 0x77F6 , 0xEDB6},
{ 0x77F8 , 0xEDB7},
{ 0x7800 , 0xEDB8},
{ 0x7809 , 0xEDB9},
{ 0x7817 , 0xEDBA},
{ 0x7818 , 0xEDBB},
{ 0x7811 , 0xEDBC},
{ 0x65AB , 0xEDBD},
{ 0x782D , 0xEDBE},
{ 0x781C , 0xEDBF},
{ 0x781D , 0xEDC0},
{ 0x7839 , 0xEDC1},
{ 0x783A , 0xEDC2},
{ 0x783B , 0xEDC3},
{ 0x781F , 0xEDC4},
{ 0x783C , 0xEDC5},
{ 0x7825 , 0xEDC6},
{ 0x782C , 0xEDC7},
{ 0x7823 , 0xEDC8},
{ 0x7829 , 0xEDC9},
{ 0x784E , 0xEDCA},
{ 0x786D , 0xEDCB},
{ 0x7856 , 0xEDCC},
{ 0x7857 , 0xEDCD},
{ 0x7826 , 0xEDCE},
{ 0x7850 , 0xEDCF},
{ 0x7847 , 0xEDD0},
{ 0x784C , 0xEDD1},
{ 0x786A , 0xEDD2},
{ 0x789B , 0xEDD3},
{ 0x7893 , 0xEDD4},
{ 0x789A , 0xEDD5},
{ 0x7887 , 0xEDD6},
{ 0x789C , 0xEDD7},
{ 0x78A1 , 0xEDD8},
{ 0x78A3 , 0xEDD9},
{ 0x78B2 , 0xEDDA},
{ 0x78B9 , 0xEDDB},
{ 0x78A5 , 0xEDDC},
{ 0x78D4 , 0xEDDD},
{ 0x78D9 , 0xEDDE},
{ 0x78C9 , 0xEDDF},
{ 0x78EC , 0xEDE0},
{ 0x78F2 , 0xEDE1},
{ 0x7905 , 0xEDE2},
{ 0x78F4 , 0xEDE3},
{ 0x7913 , 0xEDE4},
{ 0x7924 , 0xEDE5},
{ 0x791E , 0xEDE6},
{ 0x7934 , 0xEDE7},
{ 0x9F9B , 0xEDE8},
{ 0x9EF9 , 0xEDE9},
{ 0x9EFB , 0xEDEA},
{ 0x9EFC , 0xEDEB},
{ 0x76F1 , 0xEDEC},
{ 0x7704 , 0xEDED},
{ 0x770D , 0xEDEE},
{ 0x76F9 , 0xEDEF},
{ 0x7707 , 0xEDF0},
{ 0x7708 , 0xEDF1},
{ 0x771A , 0xEDF2},
{ 0x7722 , 0xEDF3},
{ 0x7719 , 0xEDF4},
{ 0x772D , 0xEDF5},
{ 0x7726 , 0xEDF6},
{ 0x7735 , 0xEDF7},
{ 0x7738 , 0xEDF8},
{ 0x7750 , 0xEDF9},
{ 0x7751 , 0xEDFA},
{ 0x7747 , 0xEDFB},
{ 0x7743 , 0xEDFC},
{ 0x775A , 0xEDFD},
{ 0x7768 , 0xEDFE},
{ 0x980F , 0xEE40},
{ 0x9810 , 0xEE41},
{ 0x9811 , 0xEE42},
{ 0x9812 , 0xEE43},
{ 0x9813 , 0xEE44},
{ 0x9814 , 0xEE45},
{ 0x9815 , 0xEE46},
{ 0x9816 , 0xEE47},
{ 0x9817 , 0xEE48},
{ 0x9818 , 0xEE49},
{ 0x9819 , 0xEE4A},
{ 0x981A , 0xEE4B},
{ 0x981B , 0xEE4C},
{ 0x981C , 0xEE4D},
{ 0x981D , 0xEE4E},
{ 0x981E , 0xEE4F},
{ 0x981F , 0xEE50},
{ 0x9820 , 0xEE51},
{ 0x9821 , 0xEE52},
{ 0x9822 , 0xEE53},
{ 0x9823 , 0xEE54},
{ 0x9824 , 0xEE55},
{ 0x9825 , 0xEE56},
{ 0x9826 , 0xEE57},
{ 0x9827 , 0xEE58},
{ 0x9828 , 0xEE59},
{ 0x9829 , 0xEE5A},
{ 0x982A , 0xEE5B},
{ 0x982B , 0xEE5C},
{ 0x982C , 0xEE5D},
{ 0x982D , 0xEE5E},
{ 0x982E , 0xEE5F},
{ 0x982F , 0xEE60},
{ 0x9830 , 0xEE61},
{ 0x9831 , 0xEE62},
{ 0x9832 , 0xEE63},
{ 0x9833 , 0xEE64},
{ 0x9834 , 0xEE65},
{ 0x9835 , 0xEE66},
{ 0x9836 , 0xEE67},
{ 0x9837 , 0xEE68},
{ 0x9838 , 0xEE69},
{ 0x9839 , 0xEE6A},
{ 0x983A , 0xEE6B},
{ 0x983B , 0xEE6C},
{ 0x983C , 0xEE6D},
{ 0x983D , 0xEE6E},
{ 0x983E , 0xEE6F},
{ 0x983F , 0xEE70},
{ 0x9840 , 0xEE71},
{ 0x9841 , 0xEE72},
{ 0x9842 , 0xEE73},
{ 0x9843 , 0xEE74},
{ 0x9844 , 0xEE75},
{ 0x9845 , 0xEE76},
{ 0x9846 , 0xEE77},
{ 0x9847 , 0xEE78},
{ 0x9848 , 0xEE79},
{ 0x9849 , 0xEE7A},
{ 0x984A , 0xEE7B},
{ 0x984B , 0xEE7C},
{ 0x984C , 0xEE7D},
{ 0x984D , 0xEE7E},
{ 0x984E , 0xEE80},
{ 0x984F , 0xEE81},
{ 0x9850 , 0xEE82},
{ 0x9851 , 0xEE83},
{ 0x9852 , 0xEE84},
{ 0x9853 , 0xEE85},
{ 0x9854 , 0xEE86},
{ 0x9855 , 0xEE87},
{ 0x9856 , 0xEE88},
{ 0x9857 , 0xEE89},
{ 0x9858 , 0xEE8A},
{ 0x9859 , 0xEE8B},
{ 0x985A , 0xEE8C},
{ 0x985B , 0xEE8D},
{ 0x985C , 0xEE8E},
{ 0x985D , 0xEE8F},
{ 0x985E , 0xEE90},
{ 0x985F , 0xEE91},
{ 0x9860 , 0xEE92},
{ 0x9861 , 0xEE93},
{ 0x9862 , 0xEE94},
{ 0x9863 , 0xEE95},
{ 0x9864 , 0xEE96},
{ 0x9865 , 0xEE97},
{ 0x9866 , 0xEE98},
{ 0x9867 , 0xEE99},
{ 0x9868 , 0xEE9A},
{ 0x9869 , 0xEE9B},
{ 0x986A , 0xEE9C},
{ 0x986B , 0xEE9D},
{ 0x986C , 0xEE9E},
{ 0x986D , 0xEE9F},
{ 0x986E , 0xEEA0},
{ 0x7762 , 0xEEA1},
{ 0x7765 , 0xEEA2},
{ 0x777F , 0xEEA3},
{ 0x778D , 0xEEA4},
{ 0x777D , 0xEEA5},
{ 0x7780 , 0xEEA6},
{ 0x778C , 0xEEA7},
{ 0x7791 , 0xEEA8},
{ 0x779F , 0xEEA9},
{ 0x77A0 , 0xEEAA},
{ 0x77B0 , 0xEEAB},
{ 0x77B5 , 0xEEAC},
{ 0x77BD , 0xEEAD},
{ 0x753A , 0xEEAE},
{ 0x7540 , 0xEEAF},
{ 0x754E , 0xEEB0},
{ 0x754B , 0xEEB1},
{ 0x7548 , 0xEEB2},
{ 0x755B , 0xEEB3},
{ 0x7572 , 0xEEB4},
{ 0x7579 , 0xEEB5},
{ 0x7583 , 0xEEB6},
{ 0x7F58 , 0xEEB7},
{ 0x7F61 , 0xEEB8},
{ 0x7F5F , 0xEEB9},
{ 0x8A48 , 0xEEBA},
{ 0x7F68 , 0xEEBB},
{ 0x7F74 , 0xEEBC},
{ 0x7F71 , 0xEEBD},
{ 0x7F79 , 0xEEBE},
{ 0x7F81 , 0xEEBF},
{ 0x7F7E , 0xEEC0},
{ 0x76CD , 0xEEC1},
{ 0x76E5 , 0xEEC2},
{ 0x8832 , 0xEEC3},
{ 0x9485 , 0xEEC4},
{ 0x9486 , 0xEEC5},
{ 0x9487 , 0xEEC6},
{ 0x948B , 0xEEC7},
{ 0x948A , 0xEEC8},
{ 0x948C , 0xEEC9},
{ 0x948D , 0xEECA},
{ 0x948F , 0xEECB},
{ 0x9490 , 0xEECC},
{ 0x9494 , 0xEECD},
{ 0x9497 , 0xEECE},
{ 0x9495 , 0xEECF},
{ 0x949A , 0xEED0},
{ 0x949B , 0xEED1},
{ 0x949C , 0xEED2},
{ 0x94A3 , 0xEED3},
{ 0x94A4 , 0xEED4},
{ 0x94AB , 0xEED5},
{ 0x94AA , 0xEED6},
{ 0x94AD , 0xEED7},
{ 0x94AC , 0xEED8},
{ 0x94AF , 0xEED9},
{ 0x94B0 , 0xEEDA},
{ 0x94B2 , 0xEEDB},
{ 0x94B4 , 0xEEDC},
{ 0x94B6 , 0xEEDD},
{ 0x94B7 , 0xEEDE},
{ 0x94B8 , 0xEEDF},
{ 0x94B9 , 0xEEE0},
{ 0x94BA , 0xEEE1},
{ 0x94BC , 0xEEE2},
{ 0x94BD , 0xEEE3},
{ 0x94BF , 0xEEE4},
{ 0x94C4 , 0xEEE5},
{ 0x94C8 , 0xEEE6},
{ 0x94C9 , 0xEEE7},
{ 0x94CA , 0xEEE8},
{ 0x94CB , 0xEEE9},
{ 0x94CC , 0xEEEA},
{ 0x94CD , 0xEEEB},
{ 0x94CE , 0xEEEC},
{ 0x94D0 , 0xEEED},
{ 0x94D1 , 0xEEEE},
{ 0x94D2 , 0xEEEF},
{ 0x94D5 , 0xEEF0},
{ 0x94D6 , 0xEEF1},
{ 0x94D7 , 0xEEF2},
{ 0x94D9 , 0xEEF3},
{ 0x94D8 , 0xEEF4},
{ 0x94DB , 0xEEF5},
{ 0x94DE , 0xEEF6},
{ 0x94DF , 0xEEF7},
{ 0x94E0 , 0xEEF8},
{ 0x94E2 , 0xEEF9},
{ 0x94E4 , 0xEEFA},
{ 0x94E5 , 0xEEFB},
{ 0x94E7 , 0xEEFC},
{ 0x94E8 , 0xEEFD},
{ 0x94EA , 0xEEFE},
{ 0x986F , 0xEF40},
{ 0x9870 , 0xEF41},
{ 0x9871 , 0xEF42},
{ 0x9872 , 0xEF43},
{ 0x9873 , 0xEF44},
{ 0x9874 , 0xEF45},
{ 0x988B , 0xEF46},
{ 0x988E , 0xEF47},
{ 0x9892 , 0xEF48},
{ 0x9895 , 0xEF49},
{ 0x9899 , 0xEF4A},
{ 0x98A3 , 0xEF4B},
{ 0x98A8 , 0xEF4C},
{ 0x98A9 , 0xEF4D},
{ 0x98AA , 0xEF4E},
{ 0x98AB , 0xEF4F},
{ 0x98AC , 0xEF50},
{ 0x98AD , 0xEF51},
{ 0x98AE , 0xEF52},
{ 0x98AF , 0xEF53},
{ 0x98B0 , 0xEF54},
{ 0x98B1 , 0xEF55},
{ 0x98B2 , 0xEF56},
{ 0x98B3 , 0xEF57},
{ 0x98B4 , 0xEF58},
{ 0x98B5 , 0xEF59},
{ 0x98B6 , 0xEF5A},
{ 0x98B7 , 0xEF5B},
{ 0x98B8 , 0xEF5C},
{ 0x98B9 , 0xEF5D},
{ 0x98BA , 0xEF5E},
{ 0x98BB , 0xEF5F},
{ 0x98BC , 0xEF60},
{ 0x98BD , 0xEF61},
{ 0x98BE , 0xEF62},
{ 0x98BF , 0xEF63},
{ 0x98C0 , 0xEF64},
{ 0x98C1 , 0xEF65},
{ 0x98C2 , 0xEF66},
{ 0x98C3 , 0xEF67},
{ 0x98C4 , 0xEF68},
{ 0x98C5 , 0xEF69},
{ 0x98C6 , 0xEF6A},
{ 0x98C7 , 0xEF6B},
{ 0x98C8 , 0xEF6C},
{ 0x98C9 , 0xEF6D},
{ 0x98CA , 0xEF6E},
{ 0x98CB , 0xEF6F},
{ 0x98CC , 0xEF70},
{ 0x98CD , 0xEF71},
{ 0x98CF , 0xEF72},
{ 0x98D0 , 0xEF73},
{ 0x98D4 , 0xEF74},
{ 0x98D6 , 0xEF75},
{ 0x98D7 , 0xEF76},
{ 0x98DB , 0xEF77},
{ 0x98DC , 0xEF78},
{ 0x98DD , 0xEF79},
{ 0x98E0 , 0xEF7A},
{ 0x98E1 , 0xEF7B},
{ 0x98E2 , 0xEF7C},
{ 0x98E3 , 0xEF7D},
{ 0x98E4 , 0xEF7E},
{ 0x98E5 , 0xEF80},
{ 0x98E6 , 0xEF81},
{ 0x98E9 , 0xEF82},
{ 0x98EA , 0xEF83},
{ 0x98EB , 0xEF84},
{ 0x98EC , 0xEF85},
{ 0x98ED , 0xEF86},
{ 0x98EE , 0xEF87},
{ 0x98EF , 0xEF88},
{ 0x98F0 , 0xEF89},
{ 0x98F1 , 0xEF8A},
{ 0x98F2 , 0xEF8B},
{ 0x98F3 , 0xEF8C},
{ 0x98F4 , 0xEF8D},
{ 0x98F5 , 0xEF8E},
{ 0x98F6 , 0xEF8F},
{ 0x98F7 , 0xEF90},
{ 0x98F8 , 0xEF91},
{ 0x98F9 , 0xEF92},
{ 0x98FA , 0xEF93},
{ 0x98FB , 0xEF94},
{ 0x98FC , 0xEF95},
{ 0x98FD , 0xEF96},
{ 0x98FE , 0xEF97},
{ 0x98FF , 0xEF98},
{ 0x9900 , 0xEF99},
{ 0x9901 , 0xEF9A},
{ 0x9902 , 0xEF9B},
{ 0x9903 , 0xEF9C},
{ 0x9904 , 0xEF9D},
{ 0x9905 , 0xEF9E},
{ 0x9906 , 0xEF9F},
{ 0x9907 , 0xEFA0},
{ 0x94E9 , 0xEFA1},
{ 0x94EB , 0xEFA2},
{ 0x94EE , 0xEFA3},
{ 0x94EF , 0xEFA4},
{ 0x94F3 , 0xEFA5},
{ 0x94F4 , 0xEFA6},
{ 0x94F5 , 0xEFA7},
{ 0x94F7 , 0xEFA8},
{ 0x94F9 , 0xEFA9},
{ 0x94FC , 0xEFAA},
{ 0x94FD , 0xEFAB},
{ 0x94FF , 0xEFAC},
{ 0x9503 , 0xEFAD},
{ 0x9502 , 0xEFAE},
{ 0x9506 , 0xEFAF},
{ 0x9507 , 0xEFB0},
{ 0x9509 , 0xEFB1},
{ 0x950A , 0xEFB2},
{ 0x950D , 0xEFB3},
{ 0x950E , 0xEFB4},
{ 0x950F , 0xEFB5},
{ 0x9512 , 0xEFB6},
{ 0x9513 , 0xEFB7},
{ 0x9514 , 0xEFB8},
{ 0x9515 , 0xEFB9},
{ 0x9516 , 0xEFBA},
{ 0x9518 , 0xEFBB},
{ 0x951B , 0xEFBC},
{ 0x951D , 0xEFBD},
{ 0x951E , 0xEFBE},
{ 0x951F , 0xEFBF},
{ 0x9522 , 0xEFC0},
{ 0x952A , 0xEFC1},
{ 0x952B , 0xEFC2},
{ 0x9529 , 0xEFC3},
{ 0x952C , 0xEFC4},
{ 0x9531 , 0xEFC5},
{ 0x9532 , 0xEFC6},
{ 0x9534 , 0xEFC7},
{ 0x9536 , 0xEFC8},
{ 0x9537 , 0xEFC9},
{ 0x9538 , 0xEFCA},
{ 0x953C , 0xEFCB},
{ 0x953E , 0xEFCC},
{ 0x953F , 0xEFCD},
{ 0x9542 , 0xEFCE},
{ 0x9535 , 0xEFCF},
{ 0x9544 , 0xEFD0},
{ 0x9545 , 0xEFD1},
{ 0x9546 , 0xEFD2},
{ 0x9549 , 0xEFD3},
{ 0x954C , 0xEFD4},
{ 0x954E , 0xEFD5},
{ 0x954F , 0xEFD6},
{ 0x9552 , 0xEFD7},
{ 0x9553 , 0xEFD8},
{ 0x9554 , 0xEFD9},
{ 0x9556 , 0xEFDA},
{ 0x9557 , 0xEFDB},
{ 0x9558 , 0xEFDC},
{ 0x9559 , 0xEFDD},
{ 0x955B , 0xEFDE},
{ 0x955E , 0xEFDF},
{ 0x955F , 0xEFE0},
{ 0x955D , 0xEFE1},
{ 0x9561 , 0xEFE2},
{ 0x9562 , 0xEFE3},
{ 0x9564 , 0xEFE4},
{ 0x9565 , 0xEFE5},
{ 0x9566 , 0xEFE6},
{ 0x9567 , 0xEFE7},
{ 0x9568 , 0xEFE8},
{ 0x9569 , 0xEFE9},
{ 0x956A , 0xEFEA},
{ 0x956B , 0xEFEB},
{ 0x956C , 0xEFEC},
{ 0x956F , 0xEFED},
{ 0x9571 , 0xEFEE},
{ 0x9572 , 0xEFEF},
{ 0x9573 , 0xEFF0},
{ 0x953A , 0xEFF1},
{ 0x77E7 , 0xEFF2},
{ 0x77EC , 0xEFF3},
{ 0x96C9 , 0xEFF4},
{ 0x79D5 , 0xEFF5},
{ 0x79ED , 0xEFF6},
{ 0x79E3 , 0xEFF7},
{ 0x79EB , 0xEFF8},
{ 0x7A06 , 0xEFF9},
{ 0x5D47 , 0xEFFA},
{ 0x7A03 , 0xEFFB},
{ 0x7A02 , 0xEFFC},
{ 0x7A1E , 0xEFFD},
{ 0x7A14 , 0xEFFE},
{ 0x9908 , 0xF040},
{ 0x9909 , 0xF041},
{ 0x990A , 0xF042},
{ 0x990B , 0xF043},
{ 0x990C , 0xF044},
{ 0x990E , 0xF045},
{ 0x990F , 0xF046},
{ 0x9911 , 0xF047},
{ 0x9912 , 0xF048},
{ 0x9913 , 0xF049},
{ 0x9914 , 0xF04A},
{ 0x9915 , 0xF04B},
{ 0x9916 , 0xF04C},
{ 0x9917 , 0xF04D},
{ 0x9918 , 0xF04E},
{ 0x9919 , 0xF04F},
{ 0x991A , 0xF050},
{ 0x991B , 0xF051},
{ 0x991C , 0xF052},
{ 0x991D , 0xF053},
{ 0x991E , 0xF054},
{ 0x991F , 0xF055},
{ 0x9920 , 0xF056},
{ 0x9921 , 0xF057},
{ 0x9922 , 0xF058},
{ 0x9923 , 0xF059},
{ 0x9924 , 0xF05A},
{ 0x9925 , 0xF05B},
{ 0x9926 , 0xF05C},
{ 0x9927 , 0xF05D},
{ 0x9928 , 0xF05E},
{ 0x9929 , 0xF05F},
{ 0x992A , 0xF060},
{ 0x992B , 0xF061},
{ 0x992C , 0xF062},
{ 0x992D , 0xF063},
{ 0x992F , 0xF064},
{ 0x9930 , 0xF065},
{ 0x9931 , 0xF066},
{ 0x9932 , 0xF067},
{ 0x9933 , 0xF068},
{ 0x9934 , 0xF069},
{ 0x9935 , 0xF06A},
{ 0x9936 , 0xF06B},
{ 0x9937 , 0xF06C},
{ 0x9938 , 0xF06D},
{ 0x9939 , 0xF06E},
{ 0x993A , 0xF06F},
{ 0x993B , 0xF070},
{ 0x993C , 0xF071},
{ 0x993D , 0xF072},
{ 0x993E , 0xF073},
{ 0x993F , 0xF074},
{ 0x9940 , 0xF075},
{ 0x9941 , 0xF076},
{ 0x9942 , 0xF077},
{ 0x9943 , 0xF078},
{ 0x9944 , 0xF079},
{ 0x9945 , 0xF07A},
{ 0x9946 , 0xF07B},
{ 0x9947 , 0xF07C},
{ 0x9948 , 0xF07D},
{ 0x9949 , 0xF07E},
{ 0x994A , 0xF080},
{ 0x994B , 0xF081},
{ 0x994C , 0xF082},
{ 0x994D , 0xF083},
{ 0x994E , 0xF084},
{ 0x994F , 0xF085},
{ 0x9950 , 0xF086},
{ 0x9951 , 0xF087},
{ 0x9952 , 0xF088},
{ 0x9953 , 0xF089},
{ 0x9956 , 0xF08A},
{ 0x9957 , 0xF08B},
{ 0x9958 , 0xF08C},
{ 0x9959 , 0xF08D},
{ 0x995A , 0xF08E},
{ 0x995B , 0xF08F},
{ 0x995C , 0xF090},
{ 0x995D , 0xF091},
{ 0x995E , 0xF092},
{ 0x995F , 0xF093},
{ 0x9960 , 0xF094},
{ 0x9961 , 0xF095},
{ 0x9962 , 0xF096},
{ 0x9964 , 0xF097},
{ 0x9966 , 0xF098},
{ 0x9973 , 0xF099},
{ 0x9978 , 0xF09A},
{ 0x9979 , 0xF09B},
{ 0x997B , 0xF09C},
{ 0x997E , 0xF09D},
{ 0x9982 , 0xF09E},
{ 0x9983 , 0xF09F},
{ 0x9989 , 0xF0A0},
{ 0x7A39 , 0xF0A1},
{ 0x7A37 , 0xF0A2},
{ 0x7A51 , 0xF0A3},
{ 0x9ECF , 0xF0A4},
{ 0x99A5 , 0xF0A5},
{ 0x7A70 , 0xF0A6},
{ 0x7688 , 0xF0A7},
{ 0x768E , 0xF0A8},
{ 0x7693 , 0xF0A9},
{ 0x7699 , 0xF0AA},
{ 0x76A4 , 0xF0AB},
{ 0x74DE , 0xF0AC},
{ 0x74E0 , 0xF0AD},
{ 0x752C , 0xF0AE},
{ 0x9E20 , 0xF0AF},
{ 0x9E22 , 0xF0B0},
{ 0x9E28 , 0xF0B1},
{ 0x9E29 , 0xF0B2},
{ 0x9E2A , 0xF0B3},
{ 0x9E2B , 0xF0B4},
{ 0x9E2C , 0xF0B5},
{ 0x9E32 , 0xF0B6},
{ 0x9E31 , 0xF0B7},
{ 0x9E36 , 0xF0B8},
{ 0x9E38 , 0xF0B9},
{ 0x9E37 , 0xF0BA},
{ 0x9E39 , 0xF0BB},
{ 0x9E3A , 0xF0BC},
{ 0x9E3E , 0xF0BD},
{ 0x9E41 , 0xF0BE},
{ 0x9E42 , 0xF0BF},
{ 0x9E44 , 0xF0C0},
{ 0x9E46 , 0xF0C1},
{ 0x9E47 , 0xF0C2},
{ 0x9E48 , 0xF0C3},
{ 0x9E49 , 0xF0C4},
{ 0x9E4B , 0xF0C5},
{ 0x9E4C , 0xF0C6},
{ 0x9E4E , 0xF0C7},
{ 0x9E51 , 0xF0C8},
{ 0x9E55 , 0xF0C9},
{ 0x9E57 , 0xF0CA},
{ 0x9E5A , 0xF0CB},
{ 0x9E5B , 0xF0CC},
{ 0x9E5C , 0xF0CD},
{ 0x9E5E , 0xF0CE},
{ 0x9E63 , 0xF0CF},
{ 0x9E66 , 0xF0D0},
{ 0x9E67 , 0xF0D1},
{ 0x9E68 , 0xF0D2},
{ 0x9E69 , 0xF0D3},
{ 0x9E6A , 0xF0D4},
{ 0x9E6B , 0xF0D5},
{ 0x9E6C , 0xF0D6},
{ 0x9E71 , 0xF0D7},
{ 0x9E6D , 0xF0D8},
{ 0x9E73 , 0xF0D9},
{ 0x7592 , 0xF0DA},
{ 0x7594 , 0xF0DB},
{ 0x7596 , 0xF0DC},
{ 0x75A0 , 0xF0DD},
{ 0x759D , 0xF0DE},
{ 0x75AC , 0xF0DF},
{ 0x75A3 , 0xF0E0},
{ 0x75B3 , 0xF0E1},
{ 0x75B4 , 0xF0E2},
{ 0x75B8 , 0xF0E3},
{ 0x75C4 , 0xF0E4},
{ 0x75B1 , 0xF0E5},
{ 0x75B0 , 0xF0E6},
{ 0x75C3 , 0xF0E7},
{ 0x75C2 , 0xF0E8},
{ 0x75D6 , 0xF0E9},
{ 0x75CD , 0xF0EA},
{ 0x75E3 , 0xF0EB},
{ 0x75E8 , 0xF0EC},
{ 0x75E6 , 0xF0ED},
{ 0x75E4 , 0xF0EE},
{ 0x75EB , 0xF0EF},
{ 0x75E7 , 0xF0F0},
{ 0x7603 , 0xF0F1},
{ 0x75F1 , 0xF0F2},
{ 0x75FC , 0xF0F3},
{ 0x75FF , 0xF0F4},
{ 0x7610 , 0xF0F5},
{ 0x7600 , 0xF0F6},
{ 0x7605 , 0xF0F7},
{ 0x760C , 0xF0F8},
{ 0x7617 , 0xF0F9},
{ 0x760A , 0xF0FA},
{ 0x7625 , 0xF0FB},
{ 0x7618 , 0xF0FC},
{ 0x7615 , 0xF0FD},
{ 0x7619 , 0xF0FE},
{ 0x998C , 0xF140},
{ 0x998E , 0xF141},
{ 0x999A , 0xF142},
{ 0x999B , 0xF143},
{ 0x999C , 0xF144},
{ 0x999D , 0xF145},
{ 0x999E , 0xF146},
{ 0x999F , 0xF147},
{ 0x99A0 , 0xF148},
{ 0x99A1 , 0xF149},
{ 0x99A2 , 0xF14A},
{ 0x99A3 , 0xF14B},
{ 0x99A4 , 0xF14C},
{ 0x99A6 , 0xF14D},
{ 0x99A7 , 0xF14E},
{ 0x99A9 , 0xF14F},
{ 0x99AA , 0xF150},
{ 0x99AB , 0xF151},
{ 0x99AC , 0xF152},
{ 0x99AD , 0xF153},
{ 0x99AE , 0xF154},
{ 0x99AF , 0xF155},
{ 0x99B0 , 0xF156},
{ 0x99B1 , 0xF157},
{ 0x99B2 , 0xF158},
{ 0x99B3 , 0xF159},
{ 0x99B4 , 0xF15A},
{ 0x99B5 , 0xF15B},
{ 0x99B6 , 0xF15C},
{ 0x99B7 , 0xF15D},
{ 0x99B8 , 0xF15E},
{ 0x99B9 , 0xF15F},
{ 0x99BA , 0xF160},
{ 0x99BB , 0xF161},
{ 0x99BC , 0xF162},
{ 0x99BD , 0xF163},
{ 0x99BE , 0xF164},
{ 0x99BF , 0xF165},
{ 0x99C0 , 0xF166},
{ 0x99C1 , 0xF167},
{ 0x99C2 , 0xF168},
{ 0x99C3 , 0xF169},
{ 0x99C4 , 0xF16A},
{ 0x99C5 , 0xF16B},
{ 0x99C6 , 0xF16C},
{ 0x99C7 , 0xF16D},
{ 0x99C8 , 0xF16E},
{ 0x99C9 , 0xF16F},
{ 0x99CA , 0xF170},
{ 0x99CB , 0xF171},
{ 0x99CC , 0xF172},
{ 0x99CD , 0xF173},
{ 0x99CE , 0xF174},
{ 0x99CF , 0xF175},
{ 0x99D0 , 0xF176},
{ 0x99D1 , 0xF177},
{ 0x99D2 , 0xF178},
{ 0x99D3 , 0xF179},
{ 0x99D4 , 0xF17A},
{ 0x99D5 , 0xF17B},
{ 0x99D6 , 0xF17C},
{ 0x99D7 , 0xF17D},
{ 0x99D8 , 0xF17E},
{ 0x99D9 , 0xF180},
{ 0x99DA , 0xF181},
{ 0x99DB , 0xF182},
{ 0x99DC , 0xF183},
{ 0x99DD , 0xF184},
{ 0x99DE , 0xF185},
{ 0x99DF , 0xF186},
{ 0x99E0 , 0xF187},
{ 0x99E1 , 0xF188},
{ 0x99E2 , 0xF189},
{ 0x99E3 , 0xF18A},
{ 0x99E4 , 0xF18B},
{ 0x99E5 , 0xF18C},
{ 0x99E6 , 0xF18D},
{ 0x99E7 , 0xF18E},
{ 0x99E8 , 0xF18F},
{ 0x99E9 , 0xF190},
{ 0x99EA , 0xF191},
{ 0x99EB , 0xF192},
{ 0x99EC , 0xF193},
{ 0x99ED , 0xF194},
{ 0x99EE , 0xF195},
{ 0x99EF , 0xF196},
{ 0x99F0 , 0xF197},
{ 0x99F1 , 0xF198},
{ 0x99F2 , 0xF199},
{ 0x99F3 , 0xF19A},
{ 0x99F4 , 0xF19B},
{ 0x99F5 , 0xF19C},
{ 0x99F6 , 0xF19D},
{ 0x99F7 , 0xF19E},
{ 0x99F8 , 0xF19F},
{ 0x99F9 , 0xF1A0},
{ 0x761B , 0xF1A1},
{ 0x763C , 0xF1A2},
{ 0x7622 , 0xF1A3},
{ 0x7620 , 0xF1A4},
{ 0x7640 , 0xF1A5},
{ 0x762D , 0xF1A6},
{ 0x7630 , 0xF1A7},
{ 0x763F , 0xF1A8},
{ 0x7635 , 0xF1A9},
{ 0x7643 , 0xF1AA},
{ 0x763E , 0xF1AB},
{ 0x7633 , 0xF1AC},
{ 0x764D , 0xF1AD},
{ 0x765E , 0xF1AE},
{ 0x7654 , 0xF1AF},
{ 0x765C , 0xF1B0},
{ 0x7656 , 0xF1B1},
{ 0x766B , 0xF1B2},
{ 0x766F , 0xF1B3},
{ 0x7FCA , 0xF1B4},
{ 0x7AE6 , 0xF1B5},
{ 0x7A78 , 0xF1B6},
{ 0x7A79 , 0xF1B7},
{ 0x7A80 , 0xF1B8},
{ 0x7A86 , 0xF1B9},
{ 0x7A88 , 0xF1BA},
{ 0x7A95 , 0xF1BB},
{ 0x7AA6 , 0xF1BC},
{ 0x7AA0 , 0xF1BD},
{ 0x7AAC , 0xF1BE},
{ 0x7AA8 , 0xF1BF},
{ 0x7AAD , 0xF1C0},
{ 0x7AB3 , 0xF1C1},
{ 0x8864 , 0xF1C2},
{ 0x8869 , 0xF1C3},
{ 0x8872 , 0xF1C4},
{ 0x887D , 0xF1C5},
{ 0x887F , 0xF1C6},
{ 0x8882 , 0xF1C7},
{ 0x88A2 , 0xF1C8},
{ 0x88C6 , 0xF1C9},
{ 0x88B7 , 0xF1CA},
{ 0x88BC , 0xF1CB},
{ 0x88C9 , 0xF1CC},
{ 0x88E2 , 0xF1CD},
{ 0x88CE , 0xF1CE},
{ 0x88E3 , 0xF1CF},
{ 0x88E5 , 0xF1D0},
{ 0x88F1 , 0xF1D1},
{ 0x891A , 0xF1D2},
{ 0x88FC , 0xF1D3},
{ 0x88E8 , 0xF1D4},
{ 0x88FE , 0xF1D5},
{ 0x88F0 , 0xF1D6},
{ 0x8921 , 0xF1D7},
{ 0x8919 , 0xF1D8},
{ 0x8913 , 0xF1D9},
{ 0x891B , 0xF1DA},
{ 0x890A , 0xF1DB},
{ 0x8934 , 0xF1DC},
{ 0x892B , 0xF1DD},
{ 0x8936 , 0xF1DE},
{ 0x8941 , 0xF1DF},
{ 0x8966 , 0xF1E0},
{ 0x897B , 0xF1E1},
{ 0x758B , 0xF1E2},
{ 0x80E5 , 0xF1E3},
{ 0x76B2 , 0xF1E4},
{ 0x76B4 , 0xF1E5},
{ 0x77DC , 0xF1E6},
{ 0x8012 , 0xF1E7},
{ 0x8014 , 0xF1E8},
{ 0x8016 , 0xF1E9},
{ 0x801C , 0xF1EA},
{ 0x8020 , 0xF1EB},
{ 0x8022 , 0xF1EC},
{ 0x8025 , 0xF1ED},
{ 0x8026 , 0xF1EE},
{ 0x8027 , 0xF1EF},
{ 0x8029 , 0xF1F0},
{ 0x8028 , 0xF1F1},
{ 0x8031 , 0xF1F2},
{ 0x800B , 0xF1F3},
{ 0x8035 , 0xF1F4},
{ 0x8043 , 0xF1F5},
{ 0x8046 , 0xF1F6},
{ 0x804D , 0xF1F7},
{ 0x8052 , 0xF1F8},
{ 0x8069 , 0xF1F9},
{ 0x8071 , 0xF1FA},
{ 0x8983 , 0xF1FB},
{ 0x9878 , 0xF1FC},
{ 0x9880 , 0xF1FD},
{ 0x9883 , 0xF1FE},
{ 0x99FA , 0xF240},
{ 0x99FB , 0xF241},
{ 0x99FC , 0xF242},
{ 0x99FD , 0xF243},
{ 0x99FE , 0xF244},
{ 0x99FF , 0xF245},
{ 0x9A00 , 0xF246},
{ 0x9A01 , 0xF247},
{ 0x9A02 , 0xF248},
{ 0x9A03 , 0xF249},
{ 0x9A04 , 0xF24A},
{ 0x9A05 , 0xF24B},
{ 0x9A06 , 0xF24C},
{ 0x9A07 , 0xF24D},
{ 0x9A08 , 0xF24E},
{ 0x9A09 , 0xF24F},
{ 0x9A0A , 0xF250},
{ 0x9A0B , 0xF251},
{ 0x9A0C , 0xF252},
{ 0x9A0D , 0xF253},
{ 0x9A0E , 0xF254},
{ 0x9A0F , 0xF255},
{ 0x9A10 , 0xF256},
{ 0x9A11 , 0xF257},
{ 0x9A12 , 0xF258},
{ 0x9A13 , 0xF259},
{ 0x9A14 , 0xF25A},
{ 0x9A15 , 0xF25B},
{ 0x9A16 , 0xF25C},
{ 0x9A17 , 0xF25D},
{ 0x9A18 , 0xF25E},
{ 0x9A19 , 0xF25F},
{ 0x9A1A , 0xF260},
{ 0x9A1B , 0xF261},
{ 0x9A1C , 0xF262},
{ 0x9A1D , 0xF263},
{ 0x9A1E , 0xF264},
{ 0x9A1F , 0xF265},
{ 0x9A20 , 0xF266},
{ 0x9A21 , 0xF267},
{ 0x9A22 , 0xF268},
{ 0x9A23 , 0xF269},
{ 0x9A24 , 0xF26A},
{ 0x9A25 , 0xF26B},
{ 0x9A26 , 0xF26C},
{ 0x9A27 , 0xF26D},
{ 0x9A28 , 0xF26E},
{ 0x9A29 , 0xF26F},
{ 0x9A2A , 0xF270},
{ 0x9A2B , 0xF271},
{ 0x9A2C , 0xF272},
{ 0x9A2D , 0xF273},
{ 0x9A2E , 0xF274},
{ 0x9A2F , 0xF275},
{ 0x9A30 , 0xF276},
{ 0x9A31 , 0xF277},
{ 0x9A32 , 0xF278},
{ 0x9A33 , 0xF279},
{ 0x9A34 , 0xF27A},
{ 0x9A35 , 0xF27B},
{ 0x9A36 , 0xF27C},
{ 0x9A37 , 0xF27D},
{ 0x9A38 , 0xF27E},
{ 0x9A39 , 0xF280},
{ 0x9A3A , 0xF281},
{ 0x9A3B , 0xF282},
{ 0x9A3C , 0xF283},
{ 0x9A3D , 0xF284},
{ 0x9A3E , 0xF285},
{ 0x9A3F , 0xF286},
{ 0x9A40 , 0xF287},
{ 0x9A41 , 0xF288},
{ 0x9A42 , 0xF289},
{ 0x9A43 , 0xF28A},
{ 0x9A44 , 0xF28B},
{ 0x9A45 , 0xF28C},
{ 0x9A46 , 0xF28D},
{ 0x9A47 , 0xF28E},
{ 0x9A48 , 0xF28F},
{ 0x9A49 , 0xF290},
{ 0x9A4A , 0xF291},
{ 0x9A4B , 0xF292},
{ 0x9A4C , 0xF293},
{ 0x9A4D , 0xF294},
{ 0x9A4E , 0xF295},
{ 0x9A4F , 0xF296},
{ 0x9A50 , 0xF297},
{ 0x9A51 , 0xF298},
{ 0x9A52 , 0xF299},
{ 0x9A53 , 0xF29A},
{ 0x9A54 , 0xF29B},
{ 0x9A55 , 0xF29C},
{ 0x9A56 , 0xF29D},
{ 0x9A57 , 0xF29E},
{ 0x9A58 , 0xF29F},
{ 0x9A59 , 0xF2A0},
{ 0x9889 , 0xF2A1},
{ 0x988C , 0xF2A2},
{ 0x988D , 0xF2A3},
{ 0x988F , 0xF2A4},
{ 0x9894 , 0xF2A5},
{ 0x989A , 0xF2A6},
{ 0x989B , 0xF2A7},
{ 0x989E , 0xF2A8},
{ 0x989F , 0xF2A9},
{ 0x98A1 , 0xF2AA},
{ 0x98A2 , 0xF2AB},
{ 0x98A5 , 0xF2AC},
{ 0x98A6 , 0xF2AD},
{ 0x864D , 0xF2AE},
{ 0x8654 , 0xF2AF},
{ 0x866C , 0xF2B0},
{ 0x866E , 0xF2B1},
{ 0x867F , 0xF2B2},
{ 0x867A , 0xF2B3},
{ 0x867C , 0xF2B4},
{ 0x867B , 0xF2B5},
{ 0x86A8 , 0xF2B6},
{ 0x868D , 0xF2B7},
{ 0x868B , 0xF2B8},
{ 0x86AC , 0xF2B9},
{ 0x869D , 0xF2BA},
{ 0x86A7 , 0xF2BB},
{ 0x86A3 , 0xF2BC},
{ 0x86AA , 0xF2BD},
{ 0x8693 , 0xF2BE},
{ 0x86A9 , 0xF2BF},
{ 0x86B6 , 0xF2C0},
{ 0x86C4 , 0xF2C1},
{ 0x86B5 , 0xF2C2},
{ 0x86CE , 0xF2C3},
{ 0x86B0 , 0xF2C4},
{ 0x86BA , 0xF2C5},
{ 0x86B1 , 0xF2C6},
{ 0x86AF , 0xF2C7},
{ 0x86C9 , 0xF2C8},
{ 0x86CF , 0xF2C9},
{ 0x86B4 , 0xF2CA},
{ 0x86E9 , 0xF2CB},
{ 0x86F1 , 0xF2CC},
{ 0x86F2 , 0xF2CD},
{ 0x86ED , 0xF2CE},
{ 0x86F3 , 0xF2CF},
{ 0x86D0 , 0xF2D0},
{ 0x8713 , 0xF2D1},
{ 0x86DE , 0xF2D2},
{ 0x86F4 , 0xF2D3},
{ 0x86DF , 0xF2D4},
{ 0x86D8 , 0xF2D5},
{ 0x86D1 , 0xF2D6},
{ 0x8703 , 0xF2D7},
{ 0x8707 , 0xF2D8},
{ 0x86F8 , 0xF2D9},
{ 0x8708 , 0xF2DA},
{ 0x870A , 0xF2DB},
{ 0x870D , 0xF2DC},
{ 0x8709 , 0xF2DD},
{ 0x8723 , 0xF2DE},
{ 0x873B , 0xF2DF},
{ 0x871E , 0xF2E0},
{ 0x8725 , 0xF2E1},
{ 0x872E , 0xF2E2},
{ 0x871A , 0xF2E3},
{ 0x873E , 0xF2E4},
{ 0x8748 , 0xF2E5},
{ 0x8734 , 0xF2E6},
{ 0x8731 , 0xF2E7},
{ 0x8729 , 0xF2E8},
{ 0x8737 , 0xF2E9},
{ 0x873F , 0xF2EA},
{ 0x8782 , 0xF2EB},
{ 0x8722 , 0xF2EC},
{ 0x877D , 0xF2ED},
{ 0x877E , 0xF2EE},
{ 0x877B , 0xF2EF},
{ 0x8760 , 0xF2F0},
{ 0x8770 , 0xF2F1},
{ 0x874C , 0xF2F2},
{ 0x876E , 0xF2F3},
{ 0x878B , 0xF2F4},
{ 0x8753 , 0xF2F5},
{ 0x8763 , 0xF2F6},
{ 0x877C , 0xF2F7},
{ 0x8764 , 0xF2F8},
{ 0x8759 , 0xF2F9},
{ 0x8765 , 0xF2FA},
{ 0x8793 , 0xF2FB},
{ 0x87AF , 0xF2FC},
{ 0x87A8 , 0xF2FD},
{ 0x87D2 , 0xF2FE},
{ 0x9A5A , 0xF340},
{ 0x9A5B , 0xF341},
{ 0x9A5C , 0xF342},
{ 0x9A5D , 0xF343},
{ 0x9A5E , 0xF344},
{ 0x9A5F , 0xF345},
{ 0x9A60 , 0xF346},
{ 0x9A61 , 0xF347},
{ 0x9A62 , 0xF348},
{ 0x9A63 , 0xF349},
{ 0x9A64 , 0xF34A},
{ 0x9A65 , 0xF34B},
{ 0x9A66 , 0xF34C},
{ 0x9A67 , 0xF34D},
{ 0x9A68 , 0xF34E},
{ 0x9A69 , 0xF34F},
{ 0x9A6A , 0xF350},
{ 0x9A6B , 0xF351},
{ 0x9A72 , 0xF352},
{ 0x9A83 , 0xF353},
{ 0x9A89 , 0xF354},
{ 0x9A8D , 0xF355},
{ 0x9A8E , 0xF356},
{ 0x9A94 , 0xF357},
{ 0x9A95 , 0xF358},
{ 0x9A99 , 0xF359},
{ 0x9AA6 , 0xF35A},
{ 0x9AA9 , 0xF35B},
{ 0x9AAA , 0xF35C},
{ 0x9AAB , 0xF35D},
{ 0x9AAC , 0xF35E},
{ 0x9AAD , 0xF35F},
{ 0x9AAE , 0xF360},
{ 0x9AAF , 0xF361},
{ 0x9AB2 , 0xF362},
{ 0x9AB3 , 0xF363},
{ 0x9AB4 , 0xF364},
{ 0x9AB5 , 0xF365},
{ 0x9AB9 , 0xF366},
{ 0x9ABB , 0xF367},
{ 0x9ABD , 0xF368},
{ 0x9ABE , 0xF369},
{ 0x9ABF , 0xF36A},
{ 0x9AC3 , 0xF36B},
{ 0x9AC4 , 0xF36C},
{ 0x9AC6 , 0xF36D},
{ 0x9AC7 , 0xF36E},
{ 0x9AC8 , 0xF36F},
{ 0x9AC9 , 0xF370},
{ 0x9ACA , 0xF371},
{ 0x9ACD , 0xF372},
{ 0x9ACE , 0xF373},
{ 0x9ACF , 0xF374},
{ 0x9AD0 , 0xF375},
{ 0x9AD2 , 0xF376},
{ 0x9AD4 , 0xF377},
{ 0x9AD5 , 0xF378},
{ 0x9AD6 , 0xF379},
{ 0x9AD7 , 0xF37A},
{ 0x9AD9 , 0xF37B},
{ 0x9ADA , 0xF37C},
{ 0x9ADB , 0xF37D},
{ 0x9ADC , 0xF37E},
{ 0x9ADD , 0xF380},
{ 0x9ADE , 0xF381},
{ 0x9AE0 , 0xF382},
{ 0x9AE2 , 0xF383},
{ 0x9AE3 , 0xF384},
{ 0x9AE4 , 0xF385},
{ 0x9AE5 , 0xF386},
{ 0x9AE7 , 0xF387},
{ 0x9AE8 , 0xF388},
{ 0x9AE9 , 0xF389},
{ 0x9AEA , 0xF38A},
{ 0x9AEC , 0xF38B},
{ 0x9AEE , 0xF38C},
{ 0x9AF0 , 0xF38D},
{ 0x9AF1 , 0xF38E},
{ 0x9AF2 , 0xF38F},
{ 0x9AF3 , 0xF390},
{ 0x9AF4 , 0xF391},
{ 0x9AF5 , 0xF392},
{ 0x9AF6 , 0xF393},
{ 0x9AF7 , 0xF394},
{ 0x9AF8 , 0xF395},
{ 0x9AFA , 0xF396},
{ 0x9AFC , 0xF397},
{ 0x9AFD , 0xF398},
{ 0x9AFE , 0xF399},
{ 0x9AFF , 0xF39A},
{ 0x9B00 , 0xF39B},
{ 0x9B01 , 0xF39C},
{ 0x9B02 , 0xF39D},
{ 0x9B04 , 0xF39E},
{ 0x9B05 , 0xF39F},
{ 0x9B06 , 0xF3A0},
{ 0x87C6 , 0xF3A1},
{ 0x8788 , 0xF3A2},
{ 0x8785 , 0xF3A3},
{ 0x87AD , 0xF3A4},
{ 0x8797 , 0xF3A5},
{ 0x8783 , 0xF3A6},
{ 0x87AB , 0xF3A7},
{ 0x87E5 , 0xF3A8},
{ 0x87AC , 0xF3A9},
{ 0x87B5 , 0xF3AA},
{ 0x87B3 , 0xF3AB},
{ 0x87CB , 0xF3AC},
{ 0x87D3 , 0xF3AD},
{ 0x87BD , 0xF3AE},
{ 0x87D1 , 0xF3AF},
{ 0x87C0 , 0xF3B0},
{ 0x87CA , 0xF3B1},
{ 0x87DB , 0xF3B2},
{ 0x87EA , 0xF3B3},
{ 0x87E0 , 0xF3B4},
{ 0x87EE , 0xF3B5},
{ 0x8816 , 0xF3B6},
{ 0x8813 , 0xF3B7},
{ 0x87FE , 0xF3B8},
{ 0x880A , 0xF3B9},
{ 0x881B , 0xF3BA},
{ 0x8821 , 0xF3BB},
{ 0x8839 , 0xF3BC},
{ 0x883C , 0xF3BD},
{ 0x7F36 , 0xF3BE},
{ 0x7F42 , 0xF3BF},
{ 0x7F44 , 0xF3C0},
{ 0x7F45 , 0xF3C1},
{ 0x8210 , 0xF3C2},
{ 0x7AFA , 0xF3C3},
{ 0x7AFD , 0xF3C4},
{ 0x7B08 , 0xF3C5},
{ 0x7B03 , 0xF3C6},
{ 0x7B04 , 0xF3C7},
{ 0x7B15 , 0xF3C8},
{ 0x7B0A , 0xF3C9},
{ 0x7B2B , 0xF3CA},
{ 0x7B0F , 0xF3CB},
{ 0x7B47 , 0xF3CC},
{ 0x7B38 , 0xF3CD},
{ 0x7B2A , 0xF3CE},
{ 0x7B19 , 0xF3CF},
{ 0x7B2E , 0xF3D0},
{ 0x7B31 , 0xF3D1},
{ 0x7B20 , 0xF3D2},
{ 0x7B25 , 0xF3D3},
{ 0x7B24 , 0xF3D4},
{ 0x7B33 , 0xF3D5},
{ 0x7B3E , 0xF3D6},
{ 0x7B1E , 0xF3D7},
{ 0x7B58 , 0xF3D8},
{ 0x7B5A , 0xF3D9},
{ 0x7B45 , 0xF3DA},
{ 0x7B75 , 0xF3DB},
{ 0x7B4C , 0xF3DC},
{ 0x7B5D , 0xF3DD},
{ 0x7B60 , 0xF3DE},
{ 0x7B6E , 0xF3DF},
{ 0x7B7B , 0xF3E0},
{ 0x7B62 , 0xF3E1},
{ 0x7B72 , 0xF3E2},
{ 0x7B71 , 0xF3E3},
{ 0x7B90 , 0xF3E4},
{ 0x7BA6 , 0xF3E5},
{ 0x7BA7 , 0xF3E6},
{ 0x7BB8 , 0xF3E7},
{ 0x7BAC , 0xF3E8},
{ 0x7B9D , 0xF3E9},
{ 0x7BA8 , 0xF3EA},
{ 0x7B85 , 0xF3EB},
{ 0x7BAA , 0xF3EC},
{ 0x7B9C , 0xF3ED},
{ 0x7BA2 , 0xF3EE},
{ 0x7BAB , 0xF3EF},
{ 0x7BB4 , 0xF3F0},
{ 0x7BD1 , 0xF3F1},
{ 0x7BC1 , 0xF3F2},
{ 0x7BCC , 0xF3F3},
{ 0x7BDD , 0xF3F4},
{ 0x7BDA , 0xF3F5},
{ 0x7BE5 , 0xF3F6},
{ 0x7BE6 , 0xF3F7},
{ 0x7BEA , 0xF3F8},
{ 0x7C0C , 0xF3F9},
{ 0x7BFE , 0xF3FA},
{ 0x7BFC , 0xF3FB},
{ 0x7C0F , 0xF3FC},
{ 0x7C16 , 0xF3FD},
{ 0x7C0B , 0xF3FE},
{ 0x9B07 , 0xF440},
{ 0x9B09 , 0xF441},
{ 0x9B0A , 0xF442},
{ 0x9B0B , 0xF443},
{ 0x9B0C , 0xF444},
{ 0x9B0D , 0xF445},
{ 0x9B0E , 0xF446},
{ 0x9B10 , 0xF447},
{ 0x9B11 , 0xF448},
{ 0x9B12 , 0xF449},
{ 0x9B14 , 0xF44A},
{ 0x9B15 , 0xF44B},
{ 0x9B16 , 0xF44C},
{ 0x9B17 , 0xF44D},
{ 0x9B18 , 0xF44E},
{ 0x9B19 , 0xF44F},
{ 0x9B1A , 0xF450},
{ 0x9B1B , 0xF451},
{ 0x9B1C , 0xF452},
{ 0x9B1D , 0xF453},
{ 0x9B1E , 0xF454},
{ 0x9B20 , 0xF455},
{ 0x9B21 , 0xF456},
{ 0x9B22 , 0xF457},
{ 0x9B24 , 0xF458},
{ 0x9B25 , 0xF459},
{ 0x9B26 , 0xF45A},
{ 0x9B27 , 0xF45B},
{ 0x9B28 , 0xF45C},
{ 0x9B29 , 0xF45D},
{ 0x9B2A , 0xF45E},
{ 0x9B2B , 0xF45F},
{ 0x9B2C , 0xF460},
{ 0x9B2D , 0xF461},
{ 0x9B2E , 0xF462},
{ 0x9B30 , 0xF463},
{ 0x9B31 , 0xF464},
{ 0x9B33 , 0xF465},
{ 0x9B34 , 0xF466},
{ 0x9B35 , 0xF467},
{ 0x9B36 , 0xF468},
{ 0x9B37 , 0xF469},
{ 0x9B38 , 0xF46A},
{ 0x9B39 , 0xF46B},
{ 0x9B3A , 0xF46C},
{ 0x9B3D , 0xF46D},
{ 0x9B3E , 0xF46E},
{ 0x9B3F , 0xF46F},
{ 0x9B40 , 0xF470},
{ 0x9B46 , 0xF471},
{ 0x9B4A , 0xF472},
{ 0x9B4B , 0xF473},
{ 0x9B4C , 0xF474},
{ 0x9B4E , 0xF475},
{ 0x9B50 , 0xF476},
{ 0x9B52 , 0xF477},
{ 0x9B53 , 0xF478},
{ 0x9B55 , 0xF479},
{ 0x9B56 , 0xF47A},
{ 0x9B57 , 0xF47B},
{ 0x9B58 , 0xF47C},
{ 0x9B59 , 0xF47D},
{ 0x9B5A , 0xF47E},
{ 0x9B5B , 0xF480},
{ 0x9B5C , 0xF481},
{ 0x9B5D , 0xF482},
{ 0x9B5E , 0xF483},
{ 0x9B5F , 0xF484},
{ 0x9B60 , 0xF485},
{ 0x9B61 , 0xF486},
{ 0x9B62 , 0xF487},
{ 0x9B63 , 0xF488},
{ 0x9B64 , 0xF489},
{ 0x9B65 , 0xF48A},
{ 0x9B66 , 0xF48B},
{ 0x9B67 , 0xF48C},
{ 0x9B68 , 0xF48D},
{ 0x9B69 , 0xF48E},
{ 0x9B6A , 0xF48F},
{ 0x9B6B , 0xF490},
{ 0x9B6C , 0xF491},
{ 0x9B6D , 0xF492},
{ 0x9B6E , 0xF493},
{ 0x9B6F , 0xF494},
{ 0x9B70 , 0xF495},
{ 0x9B71 , 0xF496},
{ 0x9B72 , 0xF497},
{ 0x9B73 , 0xF498},
{ 0x9B74 , 0xF499},
{ 0x9B75 , 0xF49A},
{ 0x9B76 , 0xF49B},
{ 0x9B77 , 0xF49C},
{ 0x9B78 , 0xF49D},
{ 0x9B79 , 0xF49E},
{ 0x9B7A , 0xF49F},
{ 0x9B7B , 0xF4A0},
{ 0x7C1F , 0xF4A1},
{ 0x7C2A , 0xF4A2},
{ 0x7C26 , 0xF4A3},
{ 0x7C38 , 0xF4A4},
{ 0x7C41 , 0xF4A5},
{ 0x7C40 , 0xF4A6},
{ 0x81FE , 0xF4A7},
{ 0x8201 , 0xF4A8},
{ 0x8202 , 0xF4A9},
{ 0x8204 , 0xF4AA},
{ 0x81EC , 0xF4AB},
{ 0x8844 , 0xF4AC},
{ 0x8221 , 0xF4AD},
{ 0x8222 , 0xF4AE},
{ 0x8223 , 0xF4AF},
{ 0x822D , 0xF4B0},
{ 0x822F , 0xF4B1},
{ 0x8228 , 0xF4B2},
{ 0x822B , 0xF4B3},
{ 0x8238 , 0xF4B4},
{ 0x823B , 0xF4B5},
{ 0x8233 , 0xF4B6},
{ 0x8234 , 0xF4B7},
{ 0x823E , 0xF4B8},
{ 0x8244 , 0xF4B9},
{ 0x8249 , 0xF4BA},
{ 0x824B , 0xF4BB},
{ 0x824F , 0xF4BC},
{ 0x825A , 0xF4BD},
{ 0x825F , 0xF4BE},
{ 0x8268 , 0xF4BF},
{ 0x887E , 0xF4C0},
{ 0x8885 , 0xF4C1},
{ 0x8888 , 0xF4C2},
{ 0x88D8 , 0xF4C3},
{ 0x88DF , 0xF4C4},
{ 0x895E , 0xF4C5},
{ 0x7F9D , 0xF4C6},
{ 0x7F9F , 0xF4C7},
{ 0x7FA7 , 0xF4C8},
{ 0x7FAF , 0xF4C9},
{ 0x7FB0 , 0xF4CA},
{ 0x7FB2 , 0xF4CB},
{ 0x7C7C , 0xF4CC},
{ 0x6549 , 0xF4CD},
{ 0x7C91 , 0xF4CE},
{ 0x7C9D , 0xF4CF},
{ 0x7C9C , 0xF4D0},
{ 0x7C9E , 0xF4D1},
{ 0x7CA2 , 0xF4D2},
{ 0x7CB2 , 0xF4D3},
{ 0x7CBC , 0xF4D4},
{ 0x7CBD , 0xF4D5},
{ 0x7CC1 , 0xF4D6},
{ 0x7CC7 , 0xF4D7},
{ 0x7CCC , 0xF4D8},
{ 0x7CCD , 0xF4D9},
{ 0x7CC8 , 0xF4DA},
{ 0x7CC5 , 0xF4DB},
{ 0x7CD7 , 0xF4DC},
{ 0x7CE8 , 0xF4DD},
{ 0x826E , 0xF4DE},
{ 0x66A8 , 0xF4DF},
{ 0x7FBF , 0xF4E0},
{ 0x7FCE , 0xF4E1},
{ 0x7FD5 , 0xF4E2},
{ 0x7FE5 , 0xF4E3},
{ 0x7FE1 , 0xF4E4},
{ 0x7FE6 , 0xF4E5},
{ 0x7FE9 , 0xF4E6},
{ 0x7FEE , 0xF4E7},
{ 0x7FF3 , 0xF4E8},
{ 0x7CF8 , 0xF4E9},
{ 0x7D77 , 0xF4EA},
{ 0x7DA6 , 0xF4EB},
{ 0x7DAE , 0xF4EC},
{ 0x7E47 , 0xF4ED},
{ 0x7E9B , 0xF4EE},
{ 0x9EB8 , 0xF4EF},
{ 0x9EB4 , 0xF4F0},
{ 0x8D73 , 0xF4F1},
{ 0x8D84 , 0xF4F2},
{ 0x8D94 , 0xF4F3},
{ 0x8D91 , 0xF4F4},
{ 0x8DB1 , 0xF4F5},
{ 0x8D67 , 0xF4F6},
{ 0x8D6D , 0xF4F7},
{ 0x8C47 , 0xF4F8},
{ 0x8C49 , 0xF4F9},
{ 0x914A , 0xF4FA},
{ 0x9150 , 0xF4FB},
{ 0x914E , 0xF4FC},
{ 0x914F , 0xF4FD},
{ 0x9164 , 0xF4FE},
{ 0x9B7C , 0xF540},
{ 0x9B7D , 0xF541},
{ 0x9B7E , 0xF542},
{ 0x9B7F , 0xF543},
{ 0x9B80 , 0xF544},
{ 0x9B81 , 0xF545},
{ 0x9B82 , 0xF546},
{ 0x9B83 , 0xF547},
{ 0x9B84 , 0xF548},
{ 0x9B85 , 0xF549},
{ 0x9B86 , 0xF54A},
{ 0x9B87 , 0xF54B},
{ 0x9B88 , 0xF54C},
{ 0x9B89 , 0xF54D},
{ 0x9B8A , 0xF54E},
{ 0x9B8B , 0xF54F},
{ 0x9B8C , 0xF550},
{ 0x9B8D , 0xF551},
{ 0x9B8E , 0xF552},
{ 0x9B8F , 0xF553},
{ 0x9B90 , 0xF554},
{ 0x9B91 , 0xF555},
{ 0x9B92 , 0xF556},
{ 0x9B93 , 0xF557},
{ 0x9B94 , 0xF558},
{ 0x9B95 , 0xF559},
{ 0x9B96 , 0xF55A},
{ 0x9B97 , 0xF55B},
{ 0x9B98 , 0xF55C},
{ 0x9B99 , 0xF55D},
{ 0x9B9A , 0xF55E},
{ 0x9B9B , 0xF55F},
{ 0x9B9C , 0xF560},
{ 0x9B9D , 0xF561},
{ 0x9B9E , 0xF562},
{ 0x9B9F , 0xF563},
{ 0x9BA0 , 0xF564},
{ 0x9BA1 , 0xF565},
{ 0x9BA2 , 0xF566},
{ 0x9BA3 , 0xF567},
{ 0x9BA4 , 0xF568},
{ 0x9BA5 , 0xF569},
{ 0x9BA6 , 0xF56A},
{ 0x9BA7 , 0xF56B},
{ 0x9BA8 , 0xF56C},
{ 0x9BA9 , 0xF56D},
{ 0x9BAA , 0xF56E},
{ 0x9BAB , 0xF56F},
{ 0x9BAC , 0xF570},
{ 0x9BAD , 0xF571},
{ 0x9BAE , 0xF572},
{ 0x9BAF , 0xF573},
{ 0x9BB0 , 0xF574},
{ 0x9BB1 , 0xF575},
{ 0x9BB2 , 0xF576},
{ 0x9BB3 , 0xF577},
{ 0x9BB4 , 0xF578},
{ 0x9BB5 , 0xF579},
{ 0x9BB6 , 0xF57A},
{ 0x9BB7 , 0xF57B},
{ 0x9BB8 , 0xF57C},
{ 0x9BB9 , 0xF57D},
{ 0x9BBA , 0xF57E},
{ 0x9BBB , 0xF580},
{ 0x9BBC , 0xF581},
{ 0x9BBD , 0xF582},
{ 0x9BBE , 0xF583},
{ 0x9BBF , 0xF584},
{ 0x9BC0 , 0xF585},
{ 0x9BC1 , 0xF586},
{ 0x9BC2 , 0xF587},
{ 0x9BC3 , 0xF588},
{ 0x9BC4 , 0xF589},
{ 0x9BC5 , 0xF58A},
{ 0x9BC6 , 0xF58B},
{ 0x9BC7 , 0xF58C},
{ 0x9BC8 , 0xF58D},
{ 0x9BC9 , 0xF58E},
{ 0x9BCA , 0xF58F},
{ 0x9BCB , 0xF590},
{ 0x9BCC , 0xF591},
{ 0x9BCD , 0xF592},
{ 0x9BCE , 0xF593},
{ 0x9BCF , 0xF594},
{ 0x9BD0 , 0xF595},
{ 0x9BD1 , 0xF596},
{ 0x9BD2 , 0xF597},
{ 0x9BD3 , 0xF598},
{ 0x9BD4 , 0xF599},
{ 0x9BD5 , 0xF59A},
{ 0x9BD6 , 0xF59B},
{ 0x9BD7 , 0xF59C},
{ 0x9BD8 , 0xF59D},
{ 0x9BD9 , 0xF59E},
{ 0x9BDA , 0xF59F},
{ 0x9BDB , 0xF5A0},
{ 0x9162 , 0xF5A1},
{ 0x9161 , 0xF5A2},
{ 0x9170 , 0xF5A3},
{ 0x9169 , 0xF5A4},
{ 0x916F , 0xF5A5},
{ 0x917D , 0xF5A6},
{ 0x917E , 0xF5A7},
{ 0x9172 , 0xF5A8},
{ 0x9174 , 0xF5A9},
{ 0x9179 , 0xF5AA},
{ 0x918C , 0xF5AB},
{ 0x9185 , 0xF5AC},
{ 0x9190 , 0xF5AD},
{ 0x918D , 0xF5AE},
{ 0x9191 , 0xF5AF},
{ 0x91A2 , 0xF5B0},
{ 0x91A3 , 0xF5B1},
{ 0x91AA , 0xF5B2},
{ 0x91AD , 0xF5B3},
{ 0x91AE , 0xF5B4},
{ 0x91AF , 0xF5B5},
{ 0x91B5 , 0xF5B6},
{ 0x91B4 , 0xF5B7},
{ 0x91BA , 0xF5B8},
{ 0x8C55 , 0xF5B9},
{ 0x9E7E , 0xF5BA},
{ 0x8DB8 , 0xF5BB},
{ 0x8DEB , 0xF5BC},
{ 0x8E05 , 0xF5BD},
{ 0x8E59 , 0xF5BE},
{ 0x8E69 , 0xF5BF},
{ 0x8DB5 , 0xF5C0},
{ 0x8DBF , 0xF5C1},
{ 0x8DBC , 0xF5C2},
{ 0x8DBA , 0xF5C3},
{ 0x8DC4 , 0xF5C4},
{ 0x8DD6 , 0xF5C5},
{ 0x8DD7 , 0xF5C6},
{ 0x8DDA , 0xF5C7},
{ 0x8DDE , 0xF5C8},
{ 0x8DCE , 0xF5C9},
{ 0x8DCF , 0xF5CA},
{ 0x8DDB , 0xF5CB},
{ 0x8DC6 , 0xF5CC},
{ 0x8DEC , 0xF5CD},
{ 0x8DF7 , 0xF5CE},
{ 0x8DF8 , 0xF5CF},
{ 0x8DE3 , 0xF5D0},
{ 0x8DF9 , 0xF5D1},
{ 0x8DFB , 0xF5D2},
{ 0x8DE4 , 0xF5D3},
{ 0x8E09 , 0xF5D4},
{ 0x8DFD , 0xF5D5},
{ 0x8E14 , 0xF5D6},
{ 0x8E1D , 0xF5D7},
{ 0x8E1F , 0xF5D8},
{ 0x8E2C , 0xF5D9},
{ 0x8E2E , 0xF5DA},
{ 0x8E23 , 0xF5DB},
{ 0x8E2F , 0xF5DC},
{ 0x8E3A , 0xF5DD},
{ 0x8E40 , 0xF5DE},
{ 0x8E39 , 0xF5DF},
{ 0x8E35 , 0xF5E0},
{ 0x8E3D , 0xF5E1},
{ 0x8E31 , 0xF5E2},
{ 0x8E49 , 0xF5E3},
{ 0x8E41 , 0xF5E4},
{ 0x8E42 , 0xF5E5},
{ 0x8E51 , 0xF5E6},
{ 0x8E52 , 0xF5E7},
{ 0x8E4A , 0xF5E8},
{ 0x8E70 , 0xF5E9},
{ 0x8E76 , 0xF5EA},
{ 0x8E7C , 0xF5EB},
{ 0x8E6F , 0xF5EC},
{ 0x8E74 , 0xF5ED},
{ 0x8E85 , 0xF5EE},
{ 0x8E8F , 0xF5EF},
{ 0x8E94 , 0xF5F0},
{ 0x8E90 , 0xF5F1},
{ 0x8E9C , 0xF5F2},
{ 0x8E9E , 0xF5F3},
{ 0x8C78 , 0xF5F4},
{ 0x8C82 , 0xF5F5},
{ 0x8C8A , 0xF5F6},
{ 0x8C85 , 0xF5F7},
{ 0x8C98 , 0xF5F8},
{ 0x8C94 , 0xF5F9},
{ 0x659B , 0xF5FA},
{ 0x89D6 , 0xF5FB},
{ 0x89DE , 0xF5FC},
{ 0x89DA , 0xF5FD},
{ 0x89DC , 0xF5FE},
{ 0x9BDC , 0xF640},
{ 0x9BDD , 0xF641},
{ 0x9BDE , 0xF642},
{ 0x9BDF , 0xF643},
{ 0x9BE0 , 0xF644},
{ 0x9BE1 , 0xF645},
{ 0x9BE2 , 0xF646},
{ 0x9BE3 , 0xF647},
{ 0x9BE4 , 0xF648},
{ 0x9BE5 , 0xF649},
{ 0x9BE6 , 0xF64A},
{ 0x9BE7 , 0xF64B},
{ 0x9BE8 , 0xF64C},
{ 0x9BE9 , 0xF64D},
{ 0x9BEA , 0xF64E},
{ 0x9BEB , 0xF64F},
{ 0x9BEC , 0xF650},
{ 0x9BED , 0xF651},
{ 0x9BEE , 0xF652},
{ 0x9BEF , 0xF653},
{ 0x9BF0 , 0xF654},
{ 0x9BF1 , 0xF655},
{ 0x9BF2 , 0xF656},
{ 0x9BF3 , 0xF657},
{ 0x9BF4 , 0xF658},
{ 0x9BF5 , 0xF659},
{ 0x9BF6 , 0xF65A},
{ 0x9BF7 , 0xF65B},
{ 0x9BF8 , 0xF65C},
{ 0x9BF9 , 0xF65D},
{ 0x9BFA , 0xF65E},
{ 0x9BFB , 0xF65F},
{ 0x9BFC , 0xF660},
{ 0x9BFD , 0xF661},
{ 0x9BFE , 0xF662},
{ 0x9BFF , 0xF663},
{ 0x9C00 , 0xF664},
{ 0x9C01 , 0xF665},
{ 0x9C02 , 0xF666},
{ 0x9C03 , 0xF667},
{ 0x9C04 , 0xF668},
{ 0x9C05 , 0xF669},
{ 0x9C06 , 0xF66A},
{ 0x9C07 , 0xF66B},
{ 0x9C08 , 0xF66C},
{ 0x9C09 , 0xF66D},
{ 0x9C0A , 0xF66E},
{ 0x9C0B , 0xF66F},
{ 0x9C0C , 0xF670},
{ 0x9C0D , 0xF671},
{ 0x9C0E , 0xF672},
{ 0x9C0F , 0xF673},
{ 0x9C10 , 0xF674},
{ 0x9C11 , 0xF675},
{ 0x9C12 , 0xF676},
{ 0x9C13 , 0xF677},
{ 0x9C14 , 0xF678},
{ 0x9C15 , 0xF679},
{ 0x9C16 , 0xF67A},
{ 0x9C17 , 0xF67B},
{ 0x9C18 , 0xF67C},
{ 0x9C19 , 0xF67D},
{ 0x9C1A , 0xF67E},
{ 0x9C1B , 0xF680},
{ 0x9C1C , 0xF681},
{ 0x9C1D , 0xF682},
{ 0x9C1E , 0xF683},
{ 0x9C1F , 0xF684},
{ 0x9C20 , 0xF685},
{ 0x9C21 , 0xF686},
{ 0x9C22 , 0xF687},
{ 0x9C23 , 0xF688},
{ 0x9C24 , 0xF689},
{ 0x9C25 , 0xF68A},
{ 0x9C26 , 0xF68B},
{ 0x9C27 , 0xF68C},
{ 0x9C28 , 0xF68D},
{ 0x9C29 , 0xF68E},
{ 0x9C2A , 0xF68F},
{ 0x9C2B , 0xF690},
{ 0x9C2C , 0xF691},
{ 0x9C2D , 0xF692},
{ 0x9C2E , 0xF693},
{ 0x9C2F , 0xF694},
{ 0x9C30 , 0xF695},
{ 0x9C31 , 0xF696},
{ 0x9C32 , 0xF697},
{ 0x9C33 , 0xF698},
{ 0x9C34 , 0xF699},
{ 0x9C35 , 0xF69A},
{ 0x9C36 , 0xF69B},
{ 0x9C37 , 0xF69C},
{ 0x9C38 , 0xF69D},
{ 0x9C39 , 0xF69E},
{ 0x9C3A , 0xF69F},
{ 0x9C3B , 0xF6A0},
{ 0x89E5 , 0xF6A1},
{ 0x89EB , 0xF6A2},
{ 0x89EF , 0xF6A3},
{ 0x8A3E , 0xF6A4},
{ 0x8B26 , 0xF6A5},
{ 0x9753 , 0xF6A6},
{ 0x96E9 , 0xF6A7},
{ 0x96F3 , 0xF6A8},
{ 0x96EF , 0xF6A9},
{ 0x9706 , 0xF6AA},
{ 0x9701 , 0xF6AB},
{ 0x9708 , 0xF6AC},
{ 0x970F , 0xF6AD},
{ 0x970E , 0xF6AE},
{ 0x972A , 0xF6AF},
{ 0x972D , 0xF6B0},
{ 0x9730 , 0xF6B1},
{ 0x973E , 0xF6B2},
{ 0x9F80 , 0xF6B3},
{ 0x9F83 , 0xF6B4},
{ 0x9F85 , 0xF6B5},
{ 0x9F86 , 0xF6B6},
{ 0x9F87 , 0xF6B7},
{ 0x9F88 , 0xF6B8},
{ 0x9F89 , 0xF6B9},
{ 0x9F8A , 0xF6BA},
{ 0x9F8C , 0xF6BB},
{ 0x9EFE , 0xF6BC},
{ 0x9F0B , 0xF6BD},
{ 0x9F0D , 0xF6BE},
{ 0x96B9 , 0xF6BF},
{ 0x96BC , 0xF6C0},
{ 0x96BD , 0xF6C1},
{ 0x96CE , 0xF6C2},
{ 0x96D2 , 0xF6C3},
{ 0x77BF , 0xF6C4},
{ 0x96E0 , 0xF6C5},
{ 0x928E , 0xF6C6},
{ 0x92AE , 0xF6C7},
{ 0x92C8 , 0xF6C8},
{ 0x933E , 0xF6C9},
{ 0x936A , 0xF6CA},
{ 0x93CA , 0xF6CB},
{ 0x938F , 0xF6CC},
{ 0x943E , 0xF6CD},
{ 0x946B , 0xF6CE},
{ 0x9C7F , 0xF6CF},
{ 0x9C82 , 0xF6D0},
{ 0x9C85 , 0xF6D1},
{ 0x9C86 , 0xF6D2},
{ 0x9C87 , 0xF6D3},
{ 0x9C88 , 0xF6D4},
{ 0x7A23 , 0xF6D5},
{ 0x9C8B , 0xF6D6},
{ 0x9C8E , 0xF6D7},
{ 0x9C90 , 0xF6D8},
{ 0x9C91 , 0xF6D9},
{ 0x9C92 , 0xF6DA},
{ 0x9C94 , 0xF6DB},
{ 0x9C95 , 0xF6DC},
{ 0x9C9A , 0xF6DD},
{ 0x9C9B , 0xF6DE},
{ 0x9C9E , 0xF6DF},
{ 0x9C9F , 0xF6E0},
{ 0x9CA0 , 0xF6E1},
{ 0x9CA1 , 0xF6E2},
{ 0x9CA2 , 0xF6E3},
{ 0x9CA3 , 0xF6E4},
{ 0x9CA5 , 0xF6E5},
{ 0x9CA6 , 0xF6E6},
{ 0x9CA7 , 0xF6E7},
{ 0x9CA8 , 0xF6E8},
{ 0x9CA9 , 0xF6E9},
{ 0x9CAB , 0xF6EA},
{ 0x9CAD , 0xF6EB},
{ 0x9CAE , 0xF6EC},
{ 0x9CB0 , 0xF6ED},
{ 0x9CB1 , 0xF6EE},
{ 0x9CB2 , 0xF6EF},
{ 0x9CB3 , 0xF6F0},
{ 0x9CB4 , 0xF6F1},
{ 0x9CB5 , 0xF6F2},
{ 0x9CB6 , 0xF6F3},
{ 0x9CB7 , 0xF6F4},
{ 0x9CBA , 0xF6F5},
{ 0x9CBB , 0xF6F6},
{ 0x9CBC , 0xF6F7},
{ 0x9CBD , 0xF6F8},
{ 0x9CC4 , 0xF6F9},
{ 0x9CC5 , 0xF6FA},
{ 0x9CC6 , 0xF6FB},
{ 0x9CC7 , 0xF6FC},
{ 0x9CCA , 0xF6FD},
{ 0x9CCB , 0xF6FE},
{ 0x9C3C , 0xF740},
{ 0x9C3D , 0xF741},
{ 0x9C3E , 0xF742},
{ 0x9C3F , 0xF743},
{ 0x9C40 , 0xF744},
{ 0x9C41 , 0xF745},
{ 0x9C42 , 0xF746},
{ 0x9C43 , 0xF747},
{ 0x9C44 , 0xF748},
{ 0x9C45 , 0xF749},
{ 0x9C46 , 0xF74A},
{ 0x9C47 , 0xF74B},
{ 0x9C48 , 0xF74C},
{ 0x9C49 , 0xF74D},
{ 0x9C4A , 0xF74E},
{ 0x9C4B , 0xF74F},
{ 0x9C4C , 0xF750},
{ 0x9C4D , 0xF751},
{ 0x9C4E , 0xF752},
{ 0x9C4F , 0xF753},
{ 0x9C50 , 0xF754},
{ 0x9C51 , 0xF755},
{ 0x9C52 , 0xF756},
{ 0x9C53 , 0xF757},
{ 0x9C54 , 0xF758},
{ 0x9C55 , 0xF759},
{ 0x9C56 , 0xF75A},
{ 0x9C57 , 0xF75B},
{ 0x9C58 , 0xF75C},
{ 0x9C59 , 0xF75D},
{ 0x9C5A , 0xF75E},
{ 0x9C5B , 0xF75F},
{ 0x9C5C , 0xF760},
{ 0x9C5D , 0xF761},
{ 0x9C5E , 0xF762},
{ 0x9C5F , 0xF763},
{ 0x9C60 , 0xF764},
{ 0x9C61 , 0xF765},
{ 0x9C62 , 0xF766},
{ 0x9C63 , 0xF767},
{ 0x9C64 , 0xF768},
{ 0x9C65 , 0xF769},
{ 0x9C66 , 0xF76A},
{ 0x9C67 , 0xF76B},
{ 0x9C68 , 0xF76C},
{ 0x9C69 , 0xF76D},
{ 0x9C6A , 0xF76E},
{ 0x9C6B , 0xF76F},
{ 0x9C6C , 0xF770},
{ 0x9C6D , 0xF771},
{ 0x9C6E , 0xF772},
{ 0x9C6F , 0xF773},
{ 0x9C70 , 0xF774},
{ 0x9C71 , 0xF775},
{ 0x9C72 , 0xF776},
{ 0x9C73 , 0xF777},
{ 0x9C74 , 0xF778},
{ 0x9C75 , 0xF779},
{ 0x9C76 , 0xF77A},
{ 0x9C77 , 0xF77B},
{ 0x9C78 , 0xF77C},
{ 0x9C79 , 0xF77D},
{ 0x9C7A , 0xF77E},
{ 0x9C7B , 0xF780},
{ 0x9C7D , 0xF781},
{ 0x9C7E , 0xF782},
{ 0x9C80 , 0xF783},
{ 0x9C83 , 0xF784},
{ 0x9C84 , 0xF785},
{ 0x9C89 , 0xF786},
{ 0x9C8A , 0xF787},
{ 0x9C8C , 0xF788},
{ 0x9C8F , 0xF789},
{ 0x9C93 , 0xF78A},
{ 0x9C96 , 0xF78B},
{ 0x9C97 , 0xF78C},
{ 0x9C98 , 0xF78D},
{ 0x9C99 , 0xF78E},
{ 0x9C9D , 0xF78F},
{ 0x9CAA , 0xF790},
{ 0x9CAC , 0xF791},
{ 0x9CAF , 0xF792},
{ 0x9CB9 , 0xF793},
{ 0x9CBE , 0xF794},
{ 0x9CBF , 0xF795},
{ 0x9CC0 , 0xF796},
{ 0x9CC1 , 0xF797},
{ 0x9CC2 , 0xF798},
{ 0x9CC8 , 0xF799},
{ 0x9CC9 , 0xF79A},
{ 0x9CD1 , 0xF79B},
{ 0x9CD2 , 0xF79C},
{ 0x9CDA , 0xF79D},
{ 0x9CDB , 0xF79E},
{ 0x9CE0 , 0xF79F},
{ 0x9CE1 , 0xF7A0},
{ 0x9CCC , 0xF7A1},
{ 0x9CCD , 0xF7A2},
{ 0x9CCE , 0xF7A3},
{ 0x9CCF , 0xF7A4},
{ 0x9CD0 , 0xF7A5},
{ 0x9CD3 , 0xF7A6},
{ 0x9CD4 , 0xF7A7},
{ 0x9CD5 , 0xF7A8},
{ 0x9CD7 , 0xF7A9},
{ 0x9CD8 , 0xF7AA},
{ 0x9CD9 , 0xF7AB},
{ 0x9CDC , 0xF7AC},
{ 0x9CDD , 0xF7AD},
{ 0x9CDF , 0xF7AE},
{ 0x9CE2 , 0xF7AF},
{ 0x977C , 0xF7B0},
{ 0x9785 , 0xF7B1},
{ 0x9791 , 0xF7B2},
{ 0x9792 , 0xF7B3},
{ 0x9794 , 0xF7B4},
{ 0x97AF , 0xF7B5},
{ 0x97AB , 0xF7B6},
{ 0x97A3 , 0xF7B7},
{ 0x97B2 , 0xF7B8},
{ 0x97B4 , 0xF7B9},
{ 0x9AB1 , 0xF7BA},
{ 0x9AB0 , 0xF7BB},
{ 0x9AB7 , 0xF7BC},
{ 0x9E58 , 0xF7BD},
{ 0x9AB6 , 0xF7BE},
{ 0x9ABA , 0xF7BF},
{ 0x9ABC , 0xF7C0},
{ 0x9AC1 , 0xF7C1},
{ 0x9AC0 , 0xF7C2},
{ 0x9AC5 , 0xF7C3},
{ 0x9AC2 , 0xF7C4},
{ 0x9ACB , 0xF7C5},
{ 0x9ACC , 0xF7C6},
{ 0x9AD1 , 0xF7C7},
{ 0x9B45 , 0xF7C8},
{ 0x9B43 , 0xF7C9},
{ 0x9B47 , 0xF7CA},
{ 0x9B49 , 0xF7CB},
{ 0x9B48 , 0xF7CC},
{ 0x9B4D , 0xF7CD},
{ 0x9B51 , 0xF7CE},
{ 0x98E8 , 0xF7CF},
{ 0x990D , 0xF7D0},
{ 0x992E , 0xF7D1},
{ 0x9955 , 0xF7D2},
{ 0x9954 , 0xF7D3},
{ 0x9ADF , 0xF7D4},
{ 0x9AE1 , 0xF7D5},
{ 0x9AE6 , 0xF7D6},
{ 0x9AEF , 0xF7D7},
{ 0x9AEB , 0xF7D8},
{ 0x9AFB , 0xF7D9},
{ 0x9AED , 0xF7DA},
{ 0x9AF9 , 0xF7DB},
{ 0x9B08 , 0xF7DC},
{ 0x9B0F , 0xF7DD},
{ 0x9B13 , 0xF7DE},
{ 0x9B1F , 0xF7DF},
{ 0x9B23 , 0xF7E0},
{ 0x9EBD , 0xF7E1},
{ 0x9EBE , 0xF7E2},
{ 0x7E3B , 0xF7E3},
{ 0x9E82 , 0xF7E4},
{ 0x9E87 , 0xF7E5},
{ 0x9E88 , 0xF7E6},
{ 0x9E8B , 0xF7E7},
{ 0x9E92 , 0xF7E8},
{ 0x93D6 , 0xF7E9},
{ 0x9E9D , 0xF7EA},
{ 0x9E9F , 0xF7EB},
{ 0x9EDB , 0xF7EC},
{ 0x9EDC , 0xF7ED},
{ 0x9EDD , 0xF7EE},
{ 0x9EE0 , 0xF7EF},
{ 0x9EDF , 0xF7F0},
{ 0x9EE2 , 0xF7F1},
{ 0x9EE9 , 0xF7F2},
{ 0x9EE7 , 0xF7F3},
{ 0x9EE5 , 0xF7F4},
{ 0x9EEA , 0xF7F5},
{ 0x9EEF , 0xF7F6},
{ 0x9F22 , 0xF7F7},
{ 0x9F2C , 0xF7F8},
{ 0x9F2F , 0xF7F9},
{ 0x9F39 , 0xF7FA},
{ 0x9F37 , 0xF7FB},
{ 0x9F3D , 0xF7FC},
{ 0x9F3E , 0xF7FD},
{ 0x9F44 , 0xF7FE},
{ 0x9CE3 , 0xF840},
{ 0x9CE4 , 0xF841},
{ 0x9CE5 , 0xF842},
{ 0x9CE6 , 0xF843},
{ 0x9CE7 , 0xF844},
{ 0x9CE8 , 0xF845},
{ 0x9CE9 , 0xF846},
{ 0x9CEA , 0xF847},
{ 0x9CEB , 0xF848},
{ 0x9CEC , 0xF849},
{ 0x9CED , 0xF84A},
{ 0x9CEE , 0xF84B},
{ 0x9CEF , 0xF84C},
{ 0x9CF0 , 0xF84D},
{ 0x9CF1 , 0xF84E},
{ 0x9CF2 , 0xF84F},
{ 0x9CF3 , 0xF850},
{ 0x9CF4 , 0xF851},
{ 0x9CF5 , 0xF852},
{ 0x9CF6 , 0xF853},
{ 0x9CF7 , 0xF854},
{ 0x9CF8 , 0xF855},
{ 0x9CF9 , 0xF856},
{ 0x9CFA , 0xF857},
{ 0x9CFB , 0xF858},
{ 0x9CFC , 0xF859},
{ 0x9CFD , 0xF85A},
{ 0x9CFE , 0xF85B},
{ 0x9CFF , 0xF85C},
{ 0x9D00 , 0xF85D},
{ 0x9D01 , 0xF85E},
{ 0x9D02 , 0xF85F},
{ 0x9D03 , 0xF860},
{ 0x9D04 , 0xF861},
{ 0x9D05 , 0xF862},
{ 0x9D06 , 0xF863},
{ 0x9D07 , 0xF864},
{ 0x9D08 , 0xF865},
{ 0x9D09 , 0xF866},
{ 0x9D0A , 0xF867},
{ 0x9D0B , 0xF868},
{ 0x9D0C , 0xF869},
{ 0x9D0D , 0xF86A},
{ 0x9D0E , 0xF86B},
{ 0x9D0F , 0xF86C},
{ 0x9D10 , 0xF86D},
{ 0x9D11 , 0xF86E},
{ 0x9D12 , 0xF86F},
{ 0x9D13 , 0xF870},
{ 0x9D14 , 0xF871},
{ 0x9D15 , 0xF872},
{ 0x9D16 , 0xF873},
{ 0x9D17 , 0xF874},
{ 0x9D18 , 0xF875},
{ 0x9D19 , 0xF876},
{ 0x9D1A , 0xF877},
{ 0x9D1B , 0xF878},
{ 0x9D1C , 0xF879},
{ 0x9D1D , 0xF87A},
{ 0x9D1E , 0xF87B},
{ 0x9D1F , 0xF87C},
{ 0x9D20 , 0xF87D},
{ 0x9D21 , 0xF87E},
{ 0x9D22 , 0xF880},
{ 0x9D23 , 0xF881},
{ 0x9D24 , 0xF882},
{ 0x9D25 , 0xF883},
{ 0x9D26 , 0xF884},
{ 0x9D27 , 0xF885},
{ 0x9D28 , 0xF886},
{ 0x9D29 , 0xF887},
{ 0x9D2A , 0xF888},
{ 0x9D2B , 0xF889},
{ 0x9D2C , 0xF88A},
{ 0x9D2D , 0xF88B},
{ 0x9D2E , 0xF88C},
{ 0x9D2F , 0xF88D},
{ 0x9D30 , 0xF88E},
{ 0x9D31 , 0xF88F},
{ 0x9D32 , 0xF890},
{ 0x9D33 , 0xF891},
{ 0x9D34 , 0xF892},
{ 0x9D35 , 0xF893},
{ 0x9D36 , 0xF894},
{ 0x9D37 , 0xF895},
{ 0x9D38 , 0xF896},
{ 0x9D39 , 0xF897},
{ 0x9D3A , 0xF898},
{ 0x9D3B , 0xF899},
{ 0x9D3C , 0xF89A},
{ 0x9D3D , 0xF89B},
{ 0x9D3E , 0xF89C},
{ 0x9D3F , 0xF89D},
{ 0x9D40 , 0xF89E},
{ 0x9D41 , 0xF89F},
{ 0x9D42 , 0xF8A0},
{ 0xE234 , 0xF8A1},
{ 0xE235 , 0xF8A2},
{ 0xE236 , 0xF8A3},
{ 0xE237 , 0xF8A4},
{ 0xE238 , 0xF8A5},
{ 0xE239 , 0xF8A6},
{ 0xE23A , 0xF8A7},
{ 0xE23B , 0xF8A8},
{ 0xE23C , 0xF8A9},
{ 0xE23D , 0xF8AA},
{ 0xE23E , 0xF8AB},
{ 0xE23F , 0xF8AC},
{ 0xE240 , 0xF8AD},
{ 0xE241 , 0xF8AE},
{ 0xE242 , 0xF8AF},
{ 0xE243 , 0xF8B0},
{ 0xE244 , 0xF8B1},
{ 0xE245 , 0xF8B2},
{ 0xE246 , 0xF8B3},
{ 0xE247 , 0xF8B4},
{ 0xE248 , 0xF8B5},
{ 0xE249 , 0xF8B6},
{ 0xE24A , 0xF8B7},
{ 0xE24B , 0xF8B8},
{ 0xE24C , 0xF8B9},
{ 0xE24D , 0xF8BA},
{ 0xE24E , 0xF8BB},
{ 0xE24F , 0xF8BC},
{ 0xE250 , 0xF8BD},
{ 0xE251 , 0xF8BE},
{ 0xE252 , 0xF8BF},
{ 0xE253 , 0xF8C0},
{ 0xE254 , 0xF8C1},
{ 0xE255 , 0xF8C2},
{ 0xE256 , 0xF8C3},
{ 0xE257 , 0xF8C4},
{ 0xE258 , 0xF8C5},
{ 0xE259 , 0xF8C6},
{ 0xE25A , 0xF8C7},
{ 0xE25B , 0xF8C8},
{ 0xE25C , 0xF8C9},
{ 0xE25D , 0xF8CA},
{ 0xE25E , 0xF8CB},
{ 0xE25F , 0xF8CC},
{ 0xE260 , 0xF8CD},
{ 0xE261 , 0xF8CE},
{ 0xE262 , 0xF8CF},
{ 0xE263 , 0xF8D0},
{ 0xE264 , 0xF8D1},
{ 0xE265 , 0xF8D2},
{ 0xE266 , 0xF8D3},
{ 0xE267 , 0xF8D4},
{ 0xE268 , 0xF8D5},
{ 0xE269 , 0xF8D6},
{ 0xE26A , 0xF8D7},
{ 0xE26B , 0xF8D8},
{ 0xE26C , 0xF8D9},
{ 0xE26D , 0xF8DA},
{ 0xE26E , 0xF8DB},
{ 0xE26F , 0xF8DC},
{ 0xE270 , 0xF8DD},
{ 0xE271 , 0xF8DE},
{ 0xE272 , 0xF8DF},
{ 0xE273 , 0xF8E0},
{ 0xE274 , 0xF8E1},
{ 0xE275 , 0xF8E2},
{ 0xE276 , 0xF8E3},
{ 0xE277 , 0xF8E4},
{ 0xE278 , 0xF8E5},
{ 0xE279 , 0xF8E6},
{ 0xE27A , 0xF8E7},
{ 0xE27B , 0xF8E8},
{ 0xE27C , 0xF8E9},
{ 0xE27D , 0xF8EA},
{ 0xE27E , 0xF8EB},
{ 0xE27F , 0xF8EC},
{ 0xE280 , 0xF8ED},
{ 0xE281 , 0xF8EE},
{ 0xE282 , 0xF8EF},
{ 0xE283 , 0xF8F0},
{ 0xE284 , 0xF8F1},
{ 0xE285 , 0xF8F2},
{ 0xE286 , 0xF8F3},
{ 0xE287 , 0xF8F4},
{ 0xE288 , 0xF8F5},
{ 0xE289 , 0xF8F6},
{ 0xE28A , 0xF8F7},
{ 0xE28B , 0xF8F8},
{ 0xE28C , 0xF8F9},
{ 0xE28D , 0xF8FA},
{ 0xE28E , 0xF8FB},
{ 0xE28F , 0xF8FC},
{ 0xE290 , 0xF8FD},
{ 0xE291 , 0xF8FE},
{ 0x9D43 , 0xF940},
{ 0x9D44 , 0xF941},
{ 0x9D45 , 0xF942},
{ 0x9D46 , 0xF943},
{ 0x9D47 , 0xF944},
{ 0x9D48 , 0xF945},
{ 0x9D49 , 0xF946},
{ 0x9D4A , 0xF947},
{ 0x9D4B , 0xF948},
{ 0x9D4C , 0xF949},
{ 0x9D4D , 0xF94A},
{ 0x9D4E , 0xF94B},
{ 0x9D4F , 0xF94C},
{ 0x9D50 , 0xF94D},
{ 0x9D51 , 0xF94E},
{ 0x9D52 , 0xF94F},
{ 0x9D53 , 0xF950},
{ 0x9D54 , 0xF951},
{ 0x9D55 , 0xF952},
{ 0x9D56 , 0xF953},
{ 0x9D57 , 0xF954},
{ 0x9D58 , 0xF955},
{ 0x9D59 , 0xF956},
{ 0x9D5A , 0xF957},
{ 0x9D5B , 0xF958},
{ 0x9D5C , 0xF959},
{ 0x9D5D , 0xF95A},
{ 0x9D5E , 0xF95B},
{ 0x9D5F , 0xF95C},
{ 0x9D60 , 0xF95D},
{ 0x9D61 , 0xF95E},
{ 0x9D62 , 0xF95F},
{ 0x9D63 , 0xF960},
{ 0x9D64 , 0xF961},
{ 0x9D65 , 0xF962},
{ 0x9D66 , 0xF963},
{ 0x9D67 , 0xF964},
{ 0x9D68 , 0xF965},
{ 0x9D69 , 0xF966},
{ 0x9D6A , 0xF967},
{ 0x9D6B , 0xF968},
{ 0x9D6C , 0xF969},
{ 0x9D6D , 0xF96A},
{ 0x9D6E , 0xF96B},
{ 0x9D6F , 0xF96C},
{ 0x9D70 , 0xF96D},
{ 0x9D71 , 0xF96E},
{ 0x9D72 , 0xF96F},
{ 0x9D73 , 0xF970},
{ 0x9D74 , 0xF971},
{ 0x9D75 , 0xF972},
{ 0x9D76 , 0xF973},
{ 0x9D77 , 0xF974},
{ 0x9D78 , 0xF975},
{ 0x9D79 , 0xF976},
{ 0x9D7A , 0xF977},
{ 0x9D7B , 0xF978},
{ 0x9D7C , 0xF979},
{ 0x9D7D , 0xF97A},
{ 0x9D7E , 0xF97B},
{ 0x9D7F , 0xF97C},
{ 0x9D80 , 0xF97D},
{ 0x9D81 , 0xF97E},
{ 0x9D82 , 0xF980},
{ 0x9D83 , 0xF981},
{ 0x9D84 , 0xF982},
{ 0x9D85 , 0xF983},
{ 0x9D86 , 0xF984},
{ 0x9D87 , 0xF985},
{ 0x9D88 , 0xF986},
{ 0x9D89 , 0xF987},
{ 0x9D8A , 0xF988},
{ 0x9D8B , 0xF989},
{ 0x9D8C , 0xF98A},
{ 0x9D8D , 0xF98B},
{ 0x9D8E , 0xF98C},
{ 0x9D8F , 0xF98D},
{ 0x9D90 , 0xF98E},
{ 0x9D91 , 0xF98F},
{ 0x9D92 , 0xF990},
{ 0x9D93 , 0xF991},
{ 0x9D94 , 0xF992},
{ 0x9D95 , 0xF993},
{ 0x9D96 , 0xF994},
{ 0x9D97 , 0xF995},
{ 0x9D98 , 0xF996},
{ 0x9D99 , 0xF997},
{ 0x9D9A , 0xF998},
{ 0x9D9B , 0xF999},
{ 0x9D9C , 0xF99A},
{ 0x9D9D , 0xF99B},
{ 0x9D9E , 0xF99C},
{ 0x9D9F , 0xF99D},
{ 0x9DA0 , 0xF99E},
{ 0x9DA1 , 0xF99F},
{ 0x9DA2 , 0xF9A0},
{ 0xE292 , 0xF9A1},
{ 0xE293 , 0xF9A2},
{ 0xE294 , 0xF9A3},
{ 0xE295 , 0xF9A4},
{ 0xE296 , 0xF9A5},
{ 0xE297 , 0xF9A6},
{ 0xE298 , 0xF9A7},
{ 0xE299 , 0xF9A8},
{ 0xE29A , 0xF9A9},
{ 0xE29B , 0xF9AA},
{ 0xE29C , 0xF9AB},
{ 0xE29D , 0xF9AC},
{ 0xE29E , 0xF9AD},
{ 0xE29F , 0xF9AE},
{ 0xE2A0 , 0xF9AF},
{ 0xE2A1 , 0xF9B0},
{ 0xE2A2 , 0xF9B1},
{ 0xE2A3 , 0xF9B2},
{ 0xE2A4 , 0xF9B3},
{ 0xE2A5 , 0xF9B4},
{ 0xE2A6 , 0xF9B5},
{ 0xE2A7 , 0xF9B6},
{ 0xE2A8 , 0xF9B7},
{ 0xE2A9 , 0xF9B8},
{ 0xE2AA , 0xF9B9},
{ 0xE2AB , 0xF9BA},
{ 0xE2AC , 0xF9BB},
{ 0xE2AD , 0xF9BC},
{ 0xE2AE , 0xF9BD},
{ 0xE2AF , 0xF9BE},
{ 0xE2B0 , 0xF9BF},
{ 0xE2B1 , 0xF9C0},
{ 0xE2B2 , 0xF9C1},
{ 0xE2B3 , 0xF9C2},
{ 0xE2B4 , 0xF9C3},
{ 0xE2B5 , 0xF9C4},
{ 0xE2B6 , 0xF9C5},
{ 0xE2B7 , 0xF9C6},
{ 0xE2B8 , 0xF9C7},
{ 0xE2B9 , 0xF9C8},
{ 0xE2BA , 0xF9C9},
{ 0xE2BB , 0xF9CA},
{ 0xE2BC , 0xF9CB},
{ 0xE2BD , 0xF9CC},
{ 0xE2BE , 0xF9CD},
{ 0xE2BF , 0xF9CE},
{ 0xE2C0 , 0xF9CF},
{ 0xE2C1 , 0xF9D0},
{ 0xE2C2 , 0xF9D1},
{ 0xE2C3 , 0xF9D2},
{ 0xE2C4 , 0xF9D3},
{ 0xE2C5 , 0xF9D4},
{ 0xE2C6 , 0xF9D5},
{ 0xE2C7 , 0xF9D6},
{ 0xE2C8 , 0xF9D7},
{ 0xE2C9 , 0xF9D8},
{ 0xE2CA , 0xF9D9},
{ 0xE2CB , 0xF9DA},
{ 0xE2CC , 0xF9DB},
{ 0xE2CD , 0xF9DC},
{ 0xE2CE , 0xF9DD},
{ 0xE2CF , 0xF9DE},
{ 0xE2D0 , 0xF9DF},
{ 0xE2D1 , 0xF9E0},
{ 0xE2D2 , 0xF9E1},
{ 0xE2D3 , 0xF9E2},
{ 0xE2D4 , 0xF9E3},
{ 0xE2D5 , 0xF9E4},
{ 0xE2D6 , 0xF9E5},
{ 0xE2D7 , 0xF9E6},
{ 0xE2D8 , 0xF9E7},
{ 0xE2D9 , 0xF9E8},
{ 0xE2DA , 0xF9E9},
{ 0xE2DB , 0xF9EA},
{ 0xE2DC , 0xF9EB},
{ 0xE2DD , 0xF9EC},
{ 0xE2DE , 0xF9ED},
{ 0xE2DF , 0xF9EE},
{ 0xE2E0 , 0xF9EF},
{ 0xE2E1 , 0xF9F0},
{ 0xE2E2 , 0xF9F1},
{ 0xE2E3 , 0xF9F2},
{ 0xE2E4 , 0xF9F3},
{ 0xE2E5 , 0xF9F4},
{ 0xE2E6 , 0xF9F5},
{ 0xE2E7 , 0xF9F6},
{ 0xE2E8 , 0xF9F7},
{ 0xE2E9 , 0xF9F8},
{ 0xE2EA , 0xF9F9},
{ 0xE2EB , 0xF9FA},
{ 0xE2EC , 0xF9FB},
{ 0xE2ED , 0xF9FC},
{ 0xE2EE , 0xF9FD},
{ 0xE2EF , 0xF9FE},
{ 0x9DA3 , 0xFA40},
{ 0x9DA4 , 0xFA41},
{ 0x9DA5 , 0xFA42},
{ 0x9DA6 , 0xFA43},
{ 0x9DA7 , 0xFA44},
{ 0x9DA8 , 0xFA45},
{ 0x9DA9 , 0xFA46},
{ 0x9DAA , 0xFA47},
{ 0x9DAB , 0xFA48},
{ 0x9DAC , 0xFA49},
{ 0x9DAD , 0xFA4A},
{ 0x9DAE , 0xFA4B},
{ 0x9DAF , 0xFA4C},
{ 0x9DB0 , 0xFA4D},
{ 0x9DB1 , 0xFA4E},
{ 0x9DB2 , 0xFA4F},
{ 0x9DB3 , 0xFA50},
{ 0x9DB4 , 0xFA51},
{ 0x9DB5 , 0xFA52},
{ 0x9DB6 , 0xFA53},
{ 0x9DB7 , 0xFA54},
{ 0x9DB8 , 0xFA55},
{ 0x9DB9 , 0xFA56},
{ 0x9DBA , 0xFA57},
{ 0x9DBB , 0xFA58},
{ 0x9DBC , 0xFA59},
{ 0x9DBD , 0xFA5A},
{ 0x9DBE , 0xFA5B},
{ 0x9DBF , 0xFA5C},
{ 0x9DC0 , 0xFA5D},
{ 0x9DC1 , 0xFA5E},
{ 0x9DC2 , 0xFA5F},
{ 0x9DC3 , 0xFA60},
{ 0x9DC4 , 0xFA61},
{ 0x9DC5 , 0xFA62},
{ 0x9DC6 , 0xFA63},
{ 0x9DC7 , 0xFA64},
{ 0x9DC8 , 0xFA65},
{ 0x9DC9 , 0xFA66},
{ 0x9DCA , 0xFA67},
{ 0x9DCB , 0xFA68},
{ 0x9DCC , 0xFA69},
{ 0x9DCD , 0xFA6A},
{ 0x9DCE , 0xFA6B},
{ 0x9DCF , 0xFA6C},
{ 0x9DD0 , 0xFA6D},
{ 0x9DD1 , 0xFA6E},
{ 0x9DD2 , 0xFA6F},
{ 0x9DD3 , 0xFA70},
{ 0x9DD4 , 0xFA71},
{ 0x9DD5 , 0xFA72},
{ 0x9DD6 , 0xFA73},
{ 0x9DD7 , 0xFA74},
{ 0x9DD8 , 0xFA75},
{ 0x9DD9 , 0xFA76},
{ 0x9DDA , 0xFA77},
{ 0x9DDB , 0xFA78},
{ 0x9DDC , 0xFA79},
{ 0x9DDD , 0xFA7A},
{ 0x9DDE , 0xFA7B},
{ 0x9DDF , 0xFA7C},
{ 0x9DE0 , 0xFA7D},
{ 0x9DE1 , 0xFA7E},
{ 0x9DE2 , 0xFA80},
{ 0x9DE3 , 0xFA81},
{ 0x9DE4 , 0xFA82},
{ 0x9DE5 , 0xFA83},
{ 0x9DE6 , 0xFA84},
{ 0x9DE7 , 0xFA85},
{ 0x9DE8 , 0xFA86},
{ 0x9DE9 , 0xFA87},
{ 0x9DEA , 0xFA88},
{ 0x9DEB , 0xFA89},
{ 0x9DEC , 0xFA8A},
{ 0x9DED , 0xFA8B},
{ 0x9DEE , 0xFA8C},
{ 0x9DEF , 0xFA8D},
{ 0x9DF0 , 0xFA8E},
{ 0x9DF1 , 0xFA8F},
{ 0x9DF2 , 0xFA90},
{ 0x9DF3 , 0xFA91},
{ 0x9DF4 , 0xFA92},
{ 0x9DF5 , 0xFA93},
{ 0x9DF6 , 0xFA94},
{ 0x9DF7 , 0xFA95},
{ 0x9DF8 , 0xFA96},
{ 0x9DF9 , 0xFA97},
{ 0x9DFA , 0xFA98},
{ 0x9DFB , 0xFA99},
{ 0x9DFC , 0xFA9A},
{ 0x9DFD , 0xFA9B},
{ 0x9DFE , 0xFA9C},
{ 0x9DFF , 0xFA9D},
{ 0x9E00 , 0xFA9E},
{ 0x9E01 , 0xFA9F},
{ 0x9E02 , 0xFAA0},
{ 0xE2F0 , 0xFAA1},
{ 0xE2F1 , 0xFAA2},
{ 0xE2F2 , 0xFAA3},
{ 0xE2F3 , 0xFAA4},
{ 0xE2F4 , 0xFAA5},
{ 0xE2F5 , 0xFAA6},
{ 0xE2F6 , 0xFAA7},
{ 0xE2F7 , 0xFAA8},
{ 0xE2F8 , 0xFAA9},
{ 0xE2F9 , 0xFAAA},
{ 0xE2FA , 0xFAAB},
{ 0xE2FB , 0xFAAC},
{ 0xE2FC , 0xFAAD},
{ 0xE2FD , 0xFAAE},
{ 0xE2FE , 0xFAAF},
{ 0xE2FF , 0xFAB0},
{ 0xE300 , 0xFAB1},
{ 0xE301 , 0xFAB2},
{ 0xE302 , 0xFAB3},
{ 0xE303 , 0xFAB4},
{ 0xE304 , 0xFAB5},
{ 0xE305 , 0xFAB6},
{ 0xE306 , 0xFAB7},
{ 0xE307 , 0xFAB8},
{ 0xE308 , 0xFAB9},
{ 0xE309 , 0xFABA},
{ 0xE30A , 0xFABB},
{ 0xE30B , 0xFABC},
{ 0xE30C , 0xFABD},
{ 0xE30D , 0xFABE},
{ 0xE30E , 0xFABF},
{ 0xE30F , 0xFAC0},
{ 0xE310 , 0xFAC1},
{ 0xE311 , 0xFAC2},
{ 0xE312 , 0xFAC3},
{ 0xE313 , 0xFAC4},
{ 0xE314 , 0xFAC5},
{ 0xE315 , 0xFAC6},
{ 0xE316 , 0xFAC7},
{ 0xE317 , 0xFAC8},
{ 0xE318 , 0xFAC9},
{ 0xE319 , 0xFACA},
{ 0xE31A , 0xFACB},
{ 0xE31B , 0xFACC},
{ 0xE31C , 0xFACD},
{ 0xE31D , 0xFACE},
{ 0xE31E , 0xFACF},
{ 0xE31F , 0xFAD0},
{ 0xE320 , 0xFAD1},
{ 0xE321 , 0xFAD2},
{ 0xE322 , 0xFAD3},
{ 0xE323 , 0xFAD4},
{ 0xE324 , 0xFAD5},
{ 0xE325 , 0xFAD6},
{ 0xE326 , 0xFAD7},
{ 0xE327 , 0xFAD8},
{ 0xE328 , 0xFAD9},
{ 0xE329 , 0xFADA},
{ 0xE32A , 0xFADB},
{ 0xE32B , 0xFADC},
{ 0xE32C , 0xFADD},
{ 0xE32D , 0xFADE},
{ 0xE32E , 0xFADF},
{ 0xE32F , 0xFAE0},
{ 0xE330 , 0xFAE1},
{ 0xE331 , 0xFAE2},
{ 0xE332 , 0xFAE3},
{ 0xE333 , 0xFAE4},
{ 0xE334 , 0xFAE5},
{ 0xE335 , 0xFAE6},
{ 0xE336 , 0xFAE7},
{ 0xE337 , 0xFAE8},
{ 0xE338 , 0xFAE9},
{ 0xE339 , 0xFAEA},
{ 0xE33A , 0xFAEB},
{ 0xE33B , 0xFAEC},
{ 0xE33C , 0xFAED},
{ 0xE33D , 0xFAEE},
{ 0xE33E , 0xFAEF},
{ 0xE33F , 0xFAF0},
{ 0xE340 , 0xFAF1},
{ 0xE341 , 0xFAF2},
{ 0xE342 , 0xFAF3},
{ 0xE343 , 0xFAF4},
{ 0xE344 , 0xFAF5},
{ 0xE345 , 0xFAF6},
{ 0xE346 , 0xFAF7},
{ 0xE347 , 0xFAF8},
{ 0xE348 , 0xFAF9},
{ 0xE349 , 0xFAFA},
{ 0xE34A , 0xFAFB},
{ 0xE34B , 0xFAFC},
{ 0xE34C , 0xFAFD},
{ 0xE34D , 0xFAFE},
{ 0x9E03 , 0xFB40},
{ 0x9E04 , 0xFB41},
{ 0x9E05 , 0xFB42},
{ 0x9E06 , 0xFB43},
{ 0x9E07 , 0xFB44},
{ 0x9E08 , 0xFB45},
{ 0x9E09 , 0xFB46},
{ 0x9E0A , 0xFB47},
{ 0x9E0B , 0xFB48},
{ 0x9E0C , 0xFB49},
{ 0x9E0D , 0xFB4A},
{ 0x9E0E , 0xFB4B},
{ 0x9E0F , 0xFB4C},
{ 0x9E10 , 0xFB4D},
{ 0x9E11 , 0xFB4E},
{ 0x9E12 , 0xFB4F},
{ 0x9E13 , 0xFB50},
{ 0x9E14 , 0xFB51},
{ 0x9E15 , 0xFB52},
{ 0x9E16 , 0xFB53},
{ 0x9E17 , 0xFB54},
{ 0x9E18 , 0xFB55},
{ 0x9E19 , 0xFB56},
{ 0x9E1A , 0xFB57},
{ 0x9E1B , 0xFB58},
{ 0x9E1C , 0xFB59},
{ 0x9E1D , 0xFB5A},
{ 0x9E1E , 0xFB5B},
{ 0x9E24 , 0xFB5C},
{ 0x9E27 , 0xFB5D},
{ 0x9E2E , 0xFB5E},
{ 0x9E30 , 0xFB5F},
{ 0x9E34 , 0xFB60},
{ 0x9E3B , 0xFB61},
{ 0x9E3C , 0xFB62},
{ 0x9E40 , 0xFB63},
{ 0x9E4D , 0xFB64},
{ 0x9E50 , 0xFB65},
{ 0x9E52 , 0xFB66},
{ 0x9E53 , 0xFB67},
{ 0x9E54 , 0xFB68},
{ 0x9E56 , 0xFB69},
{ 0x9E59 , 0xFB6A},
{ 0x9E5D , 0xFB6B},
{ 0x9E5F , 0xFB6C},
{ 0x9E60 , 0xFB6D},
{ 0x9E61 , 0xFB6E},
{ 0x9E62 , 0xFB6F},
{ 0x9E65 , 0xFB70},
{ 0x9E6E , 0xFB71},
{ 0x9E6F , 0xFB72},
{ 0x9E72 , 0xFB73},
{ 0x9E74 , 0xFB74},
{ 0x9E75 , 0xFB75},
{ 0x9E76 , 0xFB76},
{ 0x9E77 , 0xFB77},
{ 0x9E78 , 0xFB78},
{ 0x9E79 , 0xFB79},
{ 0x9E7A , 0xFB7A},
{ 0x9E7B , 0xFB7B},
{ 0x9E7C , 0xFB7C},
{ 0x9E7D , 0xFB7D},
{ 0x9E80 , 0xFB7E},
{ 0x9E81 , 0xFB80},
{ 0x9E83 , 0xFB81},
{ 0x9E84 , 0xFB82},
{ 0x9E85 , 0xFB83},
{ 0x9E86 , 0xFB84},
{ 0x9E89 , 0xFB85},
{ 0x9E8A , 0xFB86},
{ 0x9E8C , 0xFB87},
{ 0x9E8D , 0xFB88},
{ 0x9E8E , 0xFB89},
{ 0x9E8F , 0xFB8A},
{ 0x9E90 , 0xFB8B},
{ 0x9E91 , 0xFB8C},
{ 0x9E94 , 0xFB8D},
{ 0x9E95 , 0xFB8E},
{ 0x9E96 , 0xFB8F},
{ 0x9E97 , 0xFB90},
{ 0x9E98 , 0xFB91},
{ 0x9E99 , 0xFB92},
{ 0x9E9A , 0xFB93},
{ 0x9E9B , 0xFB94},
{ 0x9E9C , 0xFB95},
{ 0x9E9E , 0xFB96},
{ 0x9EA0 , 0xFB97},
{ 0x9EA1 , 0xFB98},
{ 0x9EA2 , 0xFB99},
{ 0x9EA3 , 0xFB9A},
{ 0x9EA4 , 0xFB9B},
{ 0x9EA5 , 0xFB9C},
{ 0x9EA7 , 0xFB9D},
{ 0x9EA8 , 0xFB9E},
{ 0x9EA9 , 0xFB9F},
{ 0x9EAA , 0xFBA0},
{ 0xE34E , 0xFBA1},
{ 0xE34F , 0xFBA2},
{ 0xE350 , 0xFBA3},
{ 0xE351 , 0xFBA4},
{ 0xE352 , 0xFBA5},
{ 0xE353 , 0xFBA6},
{ 0xE354 , 0xFBA7},
{ 0xE355 , 0xFBA8},
{ 0xE356 , 0xFBA9},
{ 0xE357 , 0xFBAA},
{ 0xE358 , 0xFBAB},
{ 0xE359 , 0xFBAC},
{ 0xE35A , 0xFBAD},
{ 0xE35B , 0xFBAE},
{ 0xE35C , 0xFBAF},
{ 0xE35D , 0xFBB0},
{ 0xE35E , 0xFBB1},
{ 0xE35F , 0xFBB2},
{ 0xE360 , 0xFBB3},
{ 0xE361 , 0xFBB4},
{ 0xE362 , 0xFBB5},
{ 0xE363 , 0xFBB6},
{ 0xE364 , 0xFBB7},
{ 0xE365 , 0xFBB8},
{ 0xE366 , 0xFBB9},
{ 0xE367 , 0xFBBA},
{ 0xE368 , 0xFBBB},
{ 0xE369 , 0xFBBC},
{ 0xE36A , 0xFBBD},
{ 0xE36B , 0xFBBE},
{ 0xE36C , 0xFBBF},
{ 0xE36D , 0xFBC0},
{ 0xE36E , 0xFBC1},
{ 0xE36F , 0xFBC2},
{ 0xE370 , 0xFBC3},
{ 0xE371 , 0xFBC4},
{ 0xE372 , 0xFBC5},
{ 0xE373 , 0xFBC6},
{ 0xE374 , 0xFBC7},
{ 0xE375 , 0xFBC8},
{ 0xE376 , 0xFBC9},
{ 0xE377 , 0xFBCA},
{ 0xE378 , 0xFBCB},
{ 0xE379 , 0xFBCC},
{ 0xE37A , 0xFBCD},
{ 0xE37B , 0xFBCE},
{ 0xE37C , 0xFBCF},
{ 0xE37D , 0xFBD0},
{ 0xE37E , 0xFBD1},
{ 0xE37F , 0xFBD2},
{ 0xE380 , 0xFBD3},
{ 0xE381 , 0xFBD4},
{ 0xE382 , 0xFBD5},
{ 0xE383 , 0xFBD6},
{ 0xE384 , 0xFBD7},
{ 0xE385 , 0xFBD8},
{ 0xE386 , 0xFBD9},
{ 0xE387 , 0xFBDA},
{ 0xE388 , 0xFBDB},
{ 0xE389 , 0xFBDC},
{ 0xE38A , 0xFBDD},
{ 0xE38B , 0xFBDE},
{ 0xE38C , 0xFBDF},
{ 0xE38D , 0xFBE0},
{ 0xE38E , 0xFBE1},
{ 0xE38F , 0xFBE2},
{ 0xE390 , 0xFBE3},
{ 0xE391 , 0xFBE4},
{ 0xE392 , 0xFBE5},
{ 0xE393 , 0xFBE6},
{ 0xE394 , 0xFBE7},
{ 0xE395 , 0xFBE8},
{ 0xE396 , 0xFBE9},
{ 0xE397 , 0xFBEA},
{ 0xE398 , 0xFBEB},
{ 0xE399 , 0xFBEC},
{ 0xE39A , 0xFBED},
{ 0xE39B , 0xFBEE},
{ 0xE39C , 0xFBEF},
{ 0xE39D , 0xFBF0},
{ 0xE39E , 0xFBF1},
{ 0xE39F , 0xFBF2},
{ 0xE3A0 , 0xFBF3},
{ 0xE3A1 , 0xFBF4},
{ 0xE3A2 , 0xFBF5},
{ 0xE3A3 , 0xFBF6},
{ 0xE3A4 , 0xFBF7},
{ 0xE3A5 , 0xFBF8},
{ 0xE3A6 , 0xFBF9},
{ 0xE3A7 , 0xFBFA},
{ 0xE3A8 , 0xFBFB},
{ 0xE3A9 , 0xFBFC},
{ 0xE3AA , 0xFBFD},
{ 0xE3AB , 0xFBFE},
{ 0x9EAB , 0xFC40},
{ 0x9EAC , 0xFC41},
{ 0x9EAD , 0xFC42},
{ 0x9EAE , 0xFC43},
{ 0x9EAF , 0xFC44},
{ 0x9EB0 , 0xFC45},
{ 0x9EB1 , 0xFC46},
{ 0x9EB2 , 0xFC47},
{ 0x9EB3 , 0xFC48},
{ 0x9EB5 , 0xFC49},
{ 0x9EB6 , 0xFC4A},
{ 0x9EB7 , 0xFC4B},
{ 0x9EB9 , 0xFC4C},
{ 0x9EBA , 0xFC4D},
{ 0x9EBC , 0xFC4E},
{ 0x9EBF , 0xFC4F},
{ 0x9EC0 , 0xFC50},
{ 0x9EC1 , 0xFC51},
{ 0x9EC2 , 0xFC52},
{ 0x9EC3 , 0xFC53},
{ 0x9EC5 , 0xFC54},
{ 0x9EC6 , 0xFC55},
{ 0x9EC7 , 0xFC56},
{ 0x9EC8 , 0xFC57},
{ 0x9ECA , 0xFC58},
{ 0x9ECB , 0xFC59},
{ 0x9ECC , 0xFC5A},
{ 0x9ED0 , 0xFC5B},
{ 0x9ED2 , 0xFC5C},
{ 0x9ED3 , 0xFC5D},
{ 0x9ED5 , 0xFC5E},
{ 0x9ED6 , 0xFC5F},
{ 0x9ED7 , 0xFC60},
{ 0x9ED9 , 0xFC61},
{ 0x9EDA , 0xFC62},
{ 0x9EDE , 0xFC63},
{ 0x9EE1 , 0xFC64},
{ 0x9EE3 , 0xFC65},
{ 0x9EE4 , 0xFC66},
{ 0x9EE6 , 0xFC67},
{ 0x9EE8 , 0xFC68},
{ 0x9EEB , 0xFC69},
{ 0x9EEC , 0xFC6A},
{ 0x9EED , 0xFC6B},
{ 0x9EEE , 0xFC6C},
{ 0x9EF0 , 0xFC6D},
{ 0x9EF1 , 0xFC6E},
{ 0x9EF2 , 0xFC6F},
{ 0x9EF3 , 0xFC70},
{ 0x9EF4 , 0xFC71},
{ 0x9EF5 , 0xFC72},
{ 0x9EF6 , 0xFC73},
{ 0x9EF7 , 0xFC74},
{ 0x9EF8 , 0xFC75},
{ 0x9EFA , 0xFC76},
{ 0x9EFD , 0xFC77},
{ 0x9EFF , 0xFC78},
{ 0x9F00 , 0xFC79},
{ 0x9F01 , 0xFC7A},
{ 0x9F02 , 0xFC7B},
{ 0x9F03 , 0xFC7C},
{ 0x9F04 , 0xFC7D},
{ 0x9F05 , 0xFC7E},
{ 0x9F06 , 0xFC80},
{ 0x9F07 , 0xFC81},
{ 0x9F08 , 0xFC82},
{ 0x9F09 , 0xFC83},
{ 0x9F0A , 0xFC84},
{ 0x9F0C , 0xFC85},
{ 0x9F0F , 0xFC86},
{ 0x9F11 , 0xFC87},
{ 0x9F12 , 0xFC88},
{ 0x9F14 , 0xFC89},
{ 0x9F15 , 0xFC8A},
{ 0x9F16 , 0xFC8B},
{ 0x9F18 , 0xFC8C},
{ 0x9F1A , 0xFC8D},
{ 0x9F1B , 0xFC8E},
{ 0x9F1C , 0xFC8F},
{ 0x9F1D , 0xFC90},
{ 0x9F1E , 0xFC91},
{ 0x9F1F , 0xFC92},
{ 0x9F21 , 0xFC93},
{ 0x9F23 , 0xFC94},
{ 0x9F24 , 0xFC95},
{ 0x9F25 , 0xFC96},
{ 0x9F26 , 0xFC97},
{ 0x9F27 , 0xFC98},
{ 0x9F28 , 0xFC99},
{ 0x9F29 , 0xFC9A},
{ 0x9F2A , 0xFC9B},
{ 0x9F2B , 0xFC9C},
{ 0x9F2D , 0xFC9D},
{ 0x9F2E , 0xFC9E},
{ 0x9F30 , 0xFC9F},
{ 0x9F31 , 0xFCA0},
{ 0xE3AC , 0xFCA1},
{ 0xE3AD , 0xFCA2},
{ 0xE3AE , 0xFCA3},
{ 0xE3AF , 0xFCA4},
{ 0xE3B0 , 0xFCA5},
{ 0xE3B1 , 0xFCA6},
{ 0xE3B2 , 0xFCA7},
{ 0xE3B3 , 0xFCA8},
{ 0xE3B4 , 0xFCA9},
{ 0xE3B5 , 0xFCAA},
{ 0xE3B6 , 0xFCAB},
{ 0xE3B7 , 0xFCAC},
{ 0xE3B8 , 0xFCAD},
{ 0xE3B9 , 0xFCAE},
{ 0xE3BA , 0xFCAF},
{ 0xE3BB , 0xFCB0},
{ 0xE3BC , 0xFCB1},
{ 0xE3BD , 0xFCB2},
{ 0xE3BE , 0xFCB3},
{ 0xE3BF , 0xFCB4},
{ 0xE3C0 , 0xFCB5},
{ 0xE3C1 , 0xFCB6},
{ 0xE3C2 , 0xFCB7},
{ 0xE3C3 , 0xFCB8},
{ 0xE3C4 , 0xFCB9},
{ 0xE3C5 , 0xFCBA},
{ 0xE3C6 , 0xFCBB},
{ 0xE3C7 , 0xFCBC},
{ 0xE3C8 , 0xFCBD},
{ 0xE3C9 , 0xFCBE},
{ 0xE3CA , 0xFCBF},
{ 0xE3CB , 0xFCC0},
{ 0xE3CC , 0xFCC1},
{ 0xE3CD , 0xFCC2},
{ 0xE3CE , 0xFCC3},
{ 0xE3CF , 0xFCC4},
{ 0xE3D0 , 0xFCC5},
{ 0xE3D1 , 0xFCC6},
{ 0xE3D2 , 0xFCC7},
{ 0xE3D3 , 0xFCC8},
{ 0xE3D4 , 0xFCC9},
{ 0xE3D5 , 0xFCCA},
{ 0xE3D6 , 0xFCCB},
{ 0xE3D7 , 0xFCCC},
{ 0xE3D8 , 0xFCCD},
{ 0xE3D9 , 0xFCCE},
{ 0xE3DA , 0xFCCF},
{ 0xE3DB , 0xFCD0},
{ 0xE3DC , 0xFCD1},
{ 0xE3DD , 0xFCD2},
{ 0xE3DE , 0xFCD3},
{ 0xE3DF , 0xFCD4},
{ 0xE3E0 , 0xFCD5},
{ 0xE3E1 , 0xFCD6},
{ 0xE3E2 , 0xFCD7},
{ 0xE3E3 , 0xFCD8},
{ 0xE3E4 , 0xFCD9},
{ 0xE3E5 , 0xFCDA},
{ 0xE3E6 , 0xFCDB},
{ 0xE3E7 , 0xFCDC},
{ 0xE3E8 , 0xFCDD},
{ 0xE3E9 , 0xFCDE},
{ 0xE3EA , 0xFCDF},
{ 0xE3EB , 0xFCE0},
{ 0xE3EC , 0xFCE1},
{ 0xE3ED , 0xFCE2},
{ 0xE3EE , 0xFCE3},
{ 0xE3EF , 0xFCE4},
{ 0xE3F0 , 0xFCE5},
{ 0xE3F1 , 0xFCE6},
{ 0xE3F2 , 0xFCE7},
{ 0xE3F3 , 0xFCE8},
{ 0xE3F4 , 0xFCE9},
{ 0xE3F5 , 0xFCEA},
{ 0xE3F6 , 0xFCEB},
{ 0xE3F7 , 0xFCEC},
{ 0xE3F8 , 0xFCED},
{ 0xE3F9 , 0xFCEE},
{ 0xE3FA , 0xFCEF},
{ 0xE3FB , 0xFCF0},
{ 0xE3FC , 0xFCF1},
{ 0xE3FD , 0xFCF2},
{ 0xE3FE , 0xFCF3},
{ 0xE3FF , 0xFCF4},
{ 0xE400 , 0xFCF5},
{ 0xE401 , 0xFCF6},
{ 0xE402 , 0xFCF7},
{ 0xE403 , 0xFCF8},
{ 0xE404 , 0xFCF9},
{ 0xE405 , 0xFCFA},
{ 0xE406 , 0xFCFB},
{ 0xE407 , 0xFCFC},
{ 0xE408 , 0xFCFD},
{ 0xE409 , 0xFCFE},
{ 0x9F32 , 0xFD40},
{ 0x9F33 , 0xFD41},
{ 0x9F34 , 0xFD42},
{ 0x9F35 , 0xFD43},
{ 0x9F36 , 0xFD44},
{ 0x9F38 , 0xFD45},
{ 0x9F3A , 0xFD46},
{ 0x9F3C , 0xFD47},
{ 0x9F3F , 0xFD48},
{ 0x9F40 , 0xFD49},
{ 0x9F41 , 0xFD4A},
{ 0x9F42 , 0xFD4B},
{ 0x9F43 , 0xFD4C},
{ 0x9F45 , 0xFD4D},
{ 0x9F46 , 0xFD4E},
{ 0x9F47 , 0xFD4F},
{ 0x9F48 , 0xFD50},
{ 0x9F49 , 0xFD51},
{ 0x9F4A , 0xFD52},
{ 0x9F4B , 0xFD53},
{ 0x9F4C , 0xFD54},
{ 0x9F4D , 0xFD55},
{ 0x9F4E , 0xFD56},
{ 0x9F4F , 0xFD57},
{ 0x9F52 , 0xFD58},
{ 0x9F53 , 0xFD59},
{ 0x9F54 , 0xFD5A},
{ 0x9F55 , 0xFD5B},
{ 0x9F56 , 0xFD5C},
{ 0x9F57 , 0xFD5D},
{ 0x9F58 , 0xFD5E},
{ 0x9F59 , 0xFD5F},
{ 0x9F5A , 0xFD60},
{ 0x9F5B , 0xFD61},
{ 0x9F5C , 0xFD62},
{ 0x9F5D , 0xFD63},
{ 0x9F5E , 0xFD64},
{ 0x9F5F , 0xFD65},
{ 0x9F60 , 0xFD66},
{ 0x9F61 , 0xFD67},
{ 0x9F62 , 0xFD68},
{ 0x9F63 , 0xFD69},
{ 0x9F64 , 0xFD6A},
{ 0x9F65 , 0xFD6B},
{ 0x9F66 , 0xFD6C},
{ 0x9F67 , 0xFD6D},
{ 0x9F68 , 0xFD6E},
{ 0x9F69 , 0xFD6F},
{ 0x9F6A , 0xFD70},
{ 0x9F6B , 0xFD71},
{ 0x9F6C , 0xFD72},
{ 0x9F6D , 0xFD73},
{ 0x9F6E , 0xFD74},
{ 0x9F6F , 0xFD75},
{ 0x9F70 , 0xFD76},
{ 0x9F71 , 0xFD77},
{ 0x9F72 , 0xFD78},
{ 0x9F73 , 0xFD79},
{ 0x9F74 , 0xFD7A},
{ 0x9F75 , 0xFD7B},
{ 0x9F76 , 0xFD7C},
{ 0x9F77 , 0xFD7D},
{ 0x9F78 , 0xFD7E},
{ 0x9F79 , 0xFD80},
{ 0x9F7A , 0xFD81},
{ 0x9F7B , 0xFD82},
{ 0x9F7C , 0xFD83},
{ 0x9F7D , 0xFD84},
{ 0x9F7E , 0xFD85},
{ 0x9F81 , 0xFD86},
{ 0x9F82 , 0xFD87},
{ 0x9F8D , 0xFD88},
{ 0x9F8E , 0xFD89},
{ 0x9F8F , 0xFD8A},
{ 0x9F90 , 0xFD8B},
{ 0x9F91 , 0xFD8C},
{ 0x9F92 , 0xFD8D},
{ 0x9F93 , 0xFD8E},
{ 0x9F94 , 0xFD8F},
{ 0x9F95 , 0xFD90},
{ 0x9F96 , 0xFD91},
{ 0x9F97 , 0xFD92},
{ 0x9F98 , 0xFD93},
{ 0x9F9C , 0xFD94},
{ 0x9F9D , 0xFD95},
{ 0x9F9E , 0xFD96},
{ 0x9FA1 , 0xFD97},
{ 0x9FA2 , 0xFD98},
{ 0x9FA3 , 0xFD99},
{ 0x9FA4 , 0xFD9A},
{ 0x9FA5 , 0xFD9B},
{ 0xF92C , 0xFD9C},
{ 0xF979 , 0xFD9D},
{ 0xF995 , 0xFD9E},
{ 0xF9E7 , 0xFD9F},
{ 0xF9F1 , 0xFDA0},
{ 0xE40A , 0xFDA1},
{ 0xE40B , 0xFDA2},
{ 0xE40C , 0xFDA3},
{ 0xE40D , 0xFDA4},
{ 0xE40E , 0xFDA5},
{ 0xE40F , 0xFDA6},
{ 0xE410 , 0xFDA7},
{ 0xE411 , 0xFDA8},
{ 0xE412 , 0xFDA9},
{ 0xE413 , 0xFDAA},
{ 0xE414 , 0xFDAB},
{ 0xE415 , 0xFDAC},
{ 0xE416 , 0xFDAD},
{ 0xE417 , 0xFDAE},
{ 0xE418 , 0xFDAF},
{ 0xE419 , 0xFDB0},
{ 0xE41A , 0xFDB1},
{ 0xE41B , 0xFDB2},
{ 0xE41C , 0xFDB3},
{ 0xE41D , 0xFDB4},
{ 0xE41E , 0xFDB5},
{ 0xE41F , 0xFDB6},
{ 0xE420 , 0xFDB7},
{ 0xE421 , 0xFDB8},
{ 0xE422 , 0xFDB9},
{ 0xE423 , 0xFDBA},
{ 0xE424 , 0xFDBB},
{ 0xE425 , 0xFDBC},
{ 0xE426 , 0xFDBD},
{ 0xE427 , 0xFDBE},
{ 0xE428 , 0xFDBF},
{ 0xE429 , 0xFDC0},
{ 0xE42A , 0xFDC1},
{ 0xE42B , 0xFDC2},
{ 0xE42C , 0xFDC3},
{ 0xE42D , 0xFDC4},
{ 0xE42E , 0xFDC5},
{ 0xE42F , 0xFDC6},
{ 0xE430 , 0xFDC7},
{ 0xE431 , 0xFDC8},
{ 0xE432 , 0xFDC9},
{ 0xE433 , 0xFDCA},
{ 0xE434 , 0xFDCB},
{ 0xE435 , 0xFDCC},
{ 0xE436 , 0xFDCD},
{ 0xE437 , 0xFDCE},
{ 0xE438 , 0xFDCF},
{ 0xE439 , 0xFDD0},
{ 0xE43A , 0xFDD1},
{ 0xE43B , 0xFDD2},
{ 0xE43C , 0xFDD3},
{ 0xE43D , 0xFDD4},
{ 0xE43E , 0xFDD5},
{ 0xE43F , 0xFDD6},
{ 0xE440 , 0xFDD7},
{ 0xE441 , 0xFDD8},
{ 0xE442 , 0xFDD9},
{ 0xE443 , 0xFDDA},
{ 0xE444 , 0xFDDB},
{ 0xE445 , 0xFDDC},
{ 0xE446 , 0xFDDD},
{ 0xE447 , 0xFDDE},
{ 0xE448 , 0xFDDF},
{ 0xE449 , 0xFDE0},
{ 0xE44A , 0xFDE1},
{ 0xE44B , 0xFDE2},
{ 0xE44C , 0xFDE3},
{ 0xE44D , 0xFDE4},
{ 0xE44E , 0xFDE5},
{ 0xE44F , 0xFDE6},
{ 0xE450 , 0xFDE7},
{ 0xE451 , 0xFDE8},
{ 0xE452 , 0xFDE9},
{ 0xE453 , 0xFDEA},
{ 0xE454 , 0xFDEB},
{ 0xE455 , 0xFDEC},
{ 0xE456 , 0xFDED},
{ 0xE457 , 0xFDEE},
{ 0xE458 , 0xFDEF},
{ 0xE459 , 0xFDF0},
{ 0xE45A , 0xFDF1},
{ 0xE45B , 0xFDF2},
{ 0xE45C , 0xFDF3},
{ 0xE45D , 0xFDF4},
{ 0xE45E , 0xFDF5},
{ 0xE45F , 0xFDF6},
{ 0xE460 , 0xFDF7},
{ 0xE461 , 0xFDF8},
{ 0xE462 , 0xFDF9},
{ 0xE463 , 0xFDFA},
{ 0xE464 , 0xFDFB},
{ 0xE465 , 0xFDFC},
{ 0xE466 , 0xFDFD},
{ 0xE467 , 0xFDFE},
{ 0xFA0C , 0xFE40},
{ 0xFA0D , 0xFE41},
{ 0xFA0E , 0xFE42},
{ 0xFA0F , 0xFE43},
{ 0xFA11 , 0xFE44},
{ 0xFA13 , 0xFE45},
{ 0xFA14 , 0xFE46},
{ 0xFA18 , 0xFE47},
{ 0xFA1F , 0xFE48},
{ 0xFA20 , 0xFE49},
{ 0xFA21 , 0xFE4A},
{ 0xFA23 , 0xFE4B},
{ 0xFA24 , 0xFE4C},
{ 0xFA27 , 0xFE4D},
{ 0xFA28 , 0xFE4E},
{ 0xFA29 , 0xFE4F},
{ 0x2E81 , 0xFE50},
{ 0xE816 , 0xFE51},
{ 0xE817 , 0xFE52},
{ 0xE818 , 0xFE53},
{ 0x2E84 , 0xFE54},
{ 0x3473 , 0xFE55},
{ 0x3447 , 0xFE56},
{ 0x2E88 , 0xFE57},
{ 0x2E8B , 0xFE58},
{ 0xE81E , 0xFE59},
{ 0x359E , 0xFE5A},
{ 0x361A , 0xFE5B},
{ 0x360E , 0xFE5C},
{ 0x2E8C , 0xFE5D},
{ 0x2E97 , 0xFE5E},
{ 0x396E , 0xFE5F},
{ 0x3918 , 0xFE60},
{ 0xE826 , 0xFE61},
{ 0x39CF , 0xFE62},
{ 0x39DF , 0xFE63},
{ 0x3A73 , 0xFE64},
{ 0x39D0 , 0xFE65},
{ 0xE82B , 0xFE66},
{ 0xE82C , 0xFE67},
{ 0x3B4E , 0xFE68},
{ 0x3C6E , 0xFE69},
{ 0x3CE0 , 0xFE6A},
{ 0x2EA7 , 0xFE6B},
{ 0xE831 , 0xFE6C},
{ 0xE832 , 0xFE6D},
{ 0x2EAA , 0xFE6E},
{ 0x4056 , 0xFE6F},
{ 0x415F , 0xFE70},
{ 0x2EAE , 0xFE71},
{ 0x4337 , 0xFE72},
{ 0x2EB3 , 0xFE73},
{ 0x2EB6 , 0xFE74},
{ 0x2EB7 , 0xFE75},
{ 0xE83B , 0xFE76},
{ 0x43B1 , 0xFE77},
{ 0x43AC , 0xFE78},
{ 0x2EBB , 0xFE79},
{ 0x43DD , 0xFE7A},
{ 0x44D6 , 0xFE7B},
{ 0x4661 , 0xFE7C},
{ 0x464C , 0xFE7D},
{ 0xE843 , 0xFE7E},
{ 0x4723 , 0xFE80},
{ 0x4729 , 0xFE81},
{ 0x477C , 0xFE82},
{ 0x478D , 0xFE83},
{ 0x2ECA , 0xFE84},
{ 0x4947 , 0xFE85},
{ 0x497A , 0xFE86},
{ 0x497D , 0xFE87},
{ 0x4982 , 0xFE88},
{ 0x4983 , 0xFE89},
{ 0x4985 , 0xFE8A},
{ 0x4986 , 0xFE8B},
{ 0x499F , 0xFE8C},
{ 0x499B , 0xFE8D},
{ 0x49B7 , 0xFE8E},
{ 0x49B6 , 0xFE8F},
{ 0xE854 , 0xFE90},
{ 0xE855 , 0xFE91},
{ 0x4CA3 , 0xFE92},
{ 0x4C9F , 0xFE93},
{ 0x4CA0 , 0xFE94},
{ 0x4CA1 , 0xFE95},
{ 0x4C77 , 0xFE96},
{ 0x4CA2 , 0xFE97},
{ 0x4D13 , 0xFE98},
{ 0x4D14 , 0xFE99},
{ 0x4D15 , 0xFE9A},
{ 0x4D16 , 0xFE9B},
{ 0x4D17 , 0xFE9C},
{ 0x4D18 , 0xFE9D},
{ 0x4D19 , 0xFE9E},
{ 0x4DAE , 0xFE9F},
{ 0xE864 , 0xFEA0},
{ 0xE468 , 0xFEA1},
{ 0xE469 , 0xFEA2},
{ 0xE46A , 0xFEA3},
{ 0xE46B , 0xFEA4},
{ 0xE46C , 0xFEA5},
{ 0xE46D , 0xFEA6},
{ 0xE46E , 0xFEA7},
{ 0xE46F , 0xFEA8},
{ 0xE470 , 0xFEA9},
{ 0xE471 , 0xFEAA},
{ 0xE472 , 0xFEAB},
{ 0xE473 , 0xFEAC},
{ 0xE474 , 0xFEAD},
{ 0xE475 , 0xFEAE},
{ 0xE476 , 0xFEAF},
{ 0xE477 , 0xFEB0},
{ 0xE478 , 0xFEB1},
{ 0xE479 , 0xFEB2},
{ 0xE47A , 0xFEB3},
{ 0xE47B , 0xFEB4},
{ 0xE47C , 0xFEB5},
{ 0xE47D , 0xFEB6},
{ 0xE47E , 0xFEB7},
{ 0xE47F , 0xFEB8},
{ 0xE480 , 0xFEB9},
{ 0xE481 , 0xFEBA},
{ 0xE482 , 0xFEBB},
{ 0xE483 , 0xFEBC},
{ 0xE484 , 0xFEBD},
{ 0xE485 , 0xFEBE},
{ 0xE486 , 0xFEBF},
{ 0xE487 , 0xFEC0},
{ 0xE488 , 0xFEC1},
{ 0xE489 , 0xFEC2},
{ 0xE48A , 0xFEC3},
{ 0xE48B , 0xFEC4},
{ 0xE48C , 0xFEC5},
{ 0xE48D , 0xFEC6},
{ 0xE48E , 0xFEC7},
{ 0xE48F , 0xFEC8},
{ 0xE490 , 0xFEC9},
{ 0xE491 , 0xFECA},
{ 0xE492 , 0xFECB},
{ 0xE493 , 0xFECC},
{ 0xE494 , 0xFECD},
{ 0xE495 , 0xFECE},
{ 0xE496 , 0xFECF},
{ 0xE497 , 0xFED0},
{ 0xE498 , 0xFED1},
{ 0xE499 , 0xFED2},
{ 0xE49A , 0xFED3},
{ 0xE49B , 0xFED4},
{ 0xE49C , 0xFED5},
{ 0xE49D , 0xFED6},
{ 0xE49E , 0xFED7},
{ 0xE49F , 0xFED8},
{ 0xE4A0 , 0xFED9},
{ 0xE4A1 , 0xFEDA},
{ 0xE4A2 , 0xFEDB},
{ 0xE4A3 , 0xFEDC},
{ 0xE4A4 , 0xFEDD},
{ 0xE4A5 , 0xFEDE},
{ 0xE4A6 , 0xFEDF},
{ 0xE4A7 , 0xFEE0},
{ 0xE4A8 , 0xFEE1},
{ 0xE4A9 , 0xFEE2},
{ 0xE4AA , 0xFEE3},
{ 0xE4AB , 0xFEE4},
{ 0xE4AC , 0xFEE5},
{ 0xE4AD , 0xFEE6},
{ 0xE4AE , 0xFEE7},
{ 0xE4AF , 0xFEE8},
{ 0xE4B0 , 0xFEE9},
{ 0xE4B1 , 0xFEEA},
{ 0xE4B2 , 0xFEEB},
{ 0xE4B3 , 0xFEEC},
{ 0xE4B4 , 0xFEED},
{ 0xE4B5 , 0xFEEE},
{ 0xE4B6 , 0xFEEF},
{ 0xE4B7 , 0xFEF0},
{ 0xE4B8 , 0xFEF1},
{ 0xE4B9 , 0xFEF2},
{ 0xE4BA , 0xFEF3},
{ 0xE4BB , 0xFEF4},
{ 0xE4BC , 0xFEF5},
{ 0xE4BD , 0xFEF6},
{ 0xE4BE , 0xFEF7},
{ 0xE4BF , 0xFEF8},
{ 0xE4C0 , 0xFEF9},
{ 0xE4C1 , 0xFEFA},
{ 0xE4C2 , 0xFEFB},
{ 0xE4C3 , 0xFEFC},
{ 0xE4C4 , 0xFEFD},
{ 0xE4C5 , 0xFEFE},
{ 0x0080 , 0x81308130},
{ 0x0081 , 0x81308131},
{ 0x0082 , 0x81308132},
{ 0x0083 , 0x81308133},
{ 0x0084 , 0x81308134},
{ 0x0085 , 0x81308135},
{ 0x0086 , 0x81308136},
{ 0x0087 , 0x81308137},
{ 0x0088 , 0x81308138},
{ 0x0089 , 0x81308139},
{ 0x008A , 0x81308230},
{ 0x008B , 0x81308231},
{ 0x008C , 0x81308232},
{ 0x008D , 0x81308233},
{ 0x008E , 0x81308234},
{ 0x008F , 0x81308235},
{ 0x0090 , 0x81308236},
{ 0x0091 , 0x81308237},
{ 0x0092 , 0x81308238},
{ 0x0093 , 0x81308239},
{ 0x0094 , 0x81308330},
{ 0x0095 , 0x81308331},
{ 0x0096 , 0x81308332},
{ 0x0097 , 0x81308333},
{ 0x0098 , 0x81308334},
{ 0x0099 , 0x81308335},
{ 0x009A , 0x81308336},
{ 0x009B , 0x81308337},
{ 0x009C , 0x81308338},
{ 0x009D , 0x81308339},
{ 0x009E , 0x81308430},
{ 0x009F , 0x81308431},
{ 0x00A0 , 0x81308432},
{ 0x00A1 , 0x81308433},
{ 0x00A2 , 0x81308434},
{ 0x00A3 , 0x81308435},
{ 0x00A5 , 0x81308436},
{ 0x00A6 , 0x81308437},
{ 0x00A9 , 0x81308438},
{ 0x00AA , 0x81308439},
{ 0x00AB , 0x81308530},
{ 0x00AC , 0x81308531},
{ 0x00AD , 0x81308532},
{ 0x00AE , 0x81308533},
{ 0x00AF , 0x81308534},
{ 0x00B2 , 0x81308535},
{ 0x00B3 , 0x81308536},
{ 0x00B4 , 0x81308537},
{ 0x00B5 , 0x81308538},
{ 0x00B6 , 0x81308539},
{ 0x00B8 , 0x81308630},
{ 0x00B9 , 0x81308631},
{ 0x00BA , 0x81308632},
{ 0x00BB , 0x81308633},
{ 0x00BC , 0x81308634},
{ 0x00BD , 0x81308635},
{ 0x00BE , 0x81308636},
{ 0x00BF , 0x81308637},
{ 0x00C0 , 0x81308638},
{ 0x00C1 , 0x81308639},
{ 0x00C2 , 0x81308730},
{ 0x00C3 , 0x81308731},
{ 0x00C4 , 0x81308732},
{ 0x00C5 , 0x81308733},
{ 0x00C6 , 0x81308734},
{ 0x00C7 , 0x81308735},
{ 0x00C8 , 0x81308736},
{ 0x00C9 , 0x81308737},
{ 0x00CA , 0x81308738},
{ 0x00CB , 0x81308739},
{ 0x00CC , 0x81308830},
{ 0x00CD , 0x81308831},
{ 0x00CE , 0x81308832},
{ 0x00CF , 0x81308833},
{ 0x00D0 , 0x81308834},
{ 0x00D1 , 0x81308835},
{ 0x00D2 , 0x81308836},
{ 0x00D3 , 0x81308837},
{ 0x00D4 , 0x81308838},
{ 0x00D5 , 0x81308839},
{ 0x00D6 , 0x81308930},
{ 0x00D8 , 0x81308931},
{ 0x00D9 , 0x81308932},
{ 0x00DA , 0x81308933},
{ 0x00DB , 0x81308934},
{ 0x00DC , 0x81308935},
{ 0x00DD , 0x81308936},
{ 0x00DE , 0x81308937},
{ 0x00DF , 0x81308938},
{ 0x00E2 , 0x81308939},
{ 0x00E3 , 0x81308A30},
{ 0x00E4 , 0x81308A31},
{ 0x00E5 , 0x81308A32},
{ 0x00E6 , 0x81308A33},
{ 0x00E7 , 0x81308A34},
{ 0x00EB , 0x81308A35},
{ 0x00EE , 0x81308A36},
{ 0x00EF , 0x81308A37},
{ 0x00F0 , 0x81308A38},
{ 0x00F1 , 0x81308A39},
{ 0x00F4 , 0x81308B30},
{ 0x00F5 , 0x81308B31},
{ 0x00F6 , 0x81308B32},
{ 0x00F8 , 0x81308B33},
{ 0x00FB , 0x81308B34},
{ 0x00FD , 0x81308B35},
{ 0x00FE , 0x81308B36},
{ 0x00FF , 0x81308B37},
{ 0x0100 , 0x81308B38},
{ 0x0102 , 0x81308B39},
{ 0x0103 , 0x81308C30},
{ 0x0104 , 0x81308C31},
{ 0x0105 , 0x81308C32},
{ 0x0106 , 0x81308C33},
{ 0x0107 , 0x81308C34},
{ 0x0108 , 0x81308C35},
{ 0x0109 , 0x81308C36},
{ 0x010A , 0x81308C37},
{ 0x010B , 0x81308C38},
{ 0x010C , 0x81308C39},
{ 0x010D , 0x81308D30},
{ 0x010E , 0x81308D31},
{ 0x010F , 0x81308D32},
{ 0x0110 , 0x81308D33},
{ 0x0111 , 0x81308D34},
{ 0x0112 , 0x81308D35},
{ 0x0114 , 0x81308D36},
{ 0x0115 , 0x81308D37},
{ 0x0116 , 0x81308D38},
{ 0x0117 , 0x81308D39},
{ 0x0118 , 0x81308E30},
{ 0x0119 , 0x81308E31},
{ 0x011A , 0x81308E32},
{ 0x011C , 0x81308E33},
{ 0x011D , 0x81308E34},
{ 0x011E , 0x81308E35},
{ 0x011F , 0x81308E36},
{ 0x0120 , 0x81308E37},
{ 0x0121 , 0x81308E38},
{ 0x0122 , 0x81308E39},
{ 0x0123 , 0x81308F30},
{ 0x0124 , 0x81308F31},
{ 0x0125 , 0x81308F32},
{ 0x0126 , 0x81308F33},
{ 0x0127 , 0x81308F34},
{ 0x0128 , 0x81308F35},
{ 0x0129 , 0x81308F36},
{ 0x012A , 0x81308F37},
{ 0x012C , 0x81308F38},
{ 0x012D , 0x81308F39},
{ 0x012E , 0x81309030},
{ 0x012F , 0x81309031},
{ 0x0130 , 0x81309032},
{ 0x0131 , 0x81309033},
{ 0x0132 , 0x81309034},
{ 0x0133 , 0x81309035},
{ 0x0134 , 0x81309036},
{ 0x0135 , 0x81309037},
{ 0x0136 , 0x81309038},
{ 0x0137 , 0x81309039},
{ 0x0138 , 0x81309130},
{ 0x0139 , 0x81309131},
{ 0x013A , 0x81309132},
{ 0x013B , 0x81309133},
{ 0x013C , 0x81309134},
{ 0x013D , 0x81309135},
{ 0x013E , 0x81309136},
{ 0x013F , 0x81309137},
{ 0x0140 , 0x81309138},
{ 0x0141 , 0x81309139},
{ 0x0142 , 0x81309230},
{ 0x0143 , 0x81309231},
{ 0x0145 , 0x81309232},
{ 0x0146 , 0x81309233},
{ 0x0147 , 0x81309234},
{ 0x0149 , 0x81309235},
{ 0x014A , 0x81309236},
{ 0x014B , 0x81309237},
{ 0x014C , 0x81309238},
{ 0x014E , 0x81309239},
{ 0x014F , 0x81309330},
{ 0x0150 , 0x81309331},
{ 0x0151 , 0x81309332},
{ 0x0152 , 0x81309333},
{ 0x0153 , 0x81309334},
{ 0x0154 , 0x81309335},
{ 0x0155 , 0x81309336},
{ 0x0156 , 0x81309337},
{ 0x0157 , 0x81309338},
{ 0x0158 , 0x81309339},
{ 0x0159 , 0x81309430},
{ 0x015A , 0x81309431},
{ 0x015B , 0x81309432},
{ 0x015C , 0x81309433},
{ 0x015D , 0x81309434},
{ 0x015E , 0x81309435},
{ 0x015F , 0x81309436},
{ 0x0160 , 0x81309437},
{ 0x0161 , 0x81309438},
{ 0x0162 , 0x81309439},
{ 0x0163 , 0x81309530},
{ 0x0164 , 0x81309531},
{ 0x0165 , 0x81309532},
{ 0x0166 , 0x81309533},
{ 0x0167 , 0x81309534},
{ 0x0168 , 0x81309535},
{ 0x0169 , 0x81309536},
{ 0x016A , 0x81309537},
{ 0x016C , 0x81309538},
{ 0x016D , 0x81309539},
{ 0x016E , 0x81309630},
{ 0x016F , 0x81309631},
{ 0x0170 , 0x81309632},
{ 0x0171 , 0x81309633},
{ 0x0172 , 0x81309634},
{ 0x0173 , 0x81309635},
{ 0x0174 , 0x81309636},
{ 0x0175 , 0x81309637},
{ 0x0176 , 0x81309638},
{ 0x0177 , 0x81309639},
{ 0x0178 , 0x81309730},
{ 0x0179 , 0x81309731},
{ 0x017A , 0x81309732},
{ 0x017B , 0x81309733},
{ 0x017C , 0x81309734},
{ 0x017D , 0x81309735},
{ 0x017E , 0x81309736},
{ 0x017F , 0x81309737},
{ 0x0180 , 0x81309738},
{ 0x0181 , 0x81309739},
{ 0x0182 , 0x81309830},
{ 0x0183 , 0x81309831},
{ 0x0184 , 0x81309832},
{ 0x0185 , 0x81309833},
{ 0x0186 , 0x81309834},
{ 0x0187 , 0x81309835},
{ 0x0188 , 0x81309836},
{ 0x0189 , 0x81309837},
{ 0x018A , 0x81309838},
{ 0x018B , 0x81309839},
{ 0x018C , 0x81309930},
{ 0x018D , 0x81309931},
{ 0x018E , 0x81309932},
{ 0x018F , 0x81309933},
{ 0x0190 , 0x81309934},
{ 0x0191 , 0x81309935},
{ 0x0192 , 0x81309936},
{ 0x0193 , 0x81309937},
{ 0x0194 , 0x81309938},
{ 0x0195 , 0x81309939},
{ 0x0196 , 0x81309A30},
{ 0x0197 , 0x81309A31},
{ 0x0198 , 0x81309A32},
{ 0x0199 , 0x81309A33},
{ 0x019A , 0x81309A34},
{ 0x019B , 0x81309A35},
{ 0x019C , 0x81309A36},
{ 0x019D , 0x81309A37},
{ 0x019E , 0x81309A38},
{ 0x019F , 0x81309A39},
{ 0x01A0 , 0x81309B30},
{ 0x01A1 , 0x81309B31},
{ 0x01A2 , 0x81309B32},
{ 0x01A3 , 0x81309B33},
{ 0x01A4 , 0x81309B34},
{ 0x01A5 , 0x81309B35},
{ 0x01A6 , 0x81309B36},
{ 0x01A7 , 0x81309B37},
{ 0x01A8 , 0x81309B38},
{ 0x01A9 , 0x81309B39},
{ 0x01AA , 0x81309C30},
{ 0x01AB , 0x81309C31},
{ 0x01AC , 0x81309C32},
{ 0x01AD , 0x81309C33},
{ 0x01AE , 0x81309C34},
{ 0x01AF , 0x81309C35},
{ 0x01B0 , 0x81309C36},
{ 0x01B1 , 0x81309C37},
{ 0x01B2 , 0x81309C38},
{ 0x01B3 , 0x81309C39},
{ 0x01B4 , 0x81309D30},
{ 0x01B5 , 0x81309D31},
{ 0x01B6 , 0x81309D32},
{ 0x01B7 , 0x81309D33},
{ 0x01B8 , 0x81309D34},
{ 0x01B9 , 0x81309D35},
{ 0x01BA , 0x81309D36},
{ 0x01BB , 0x81309D37},
{ 0x01BC , 0x81309D38},
{ 0x01BD , 0x81309D39},
{ 0x01BE , 0x81309E30},
{ 0x01BF , 0x81309E31},
{ 0x01C0 , 0x81309E32},
{ 0x01C1 , 0x81309E33},
{ 0x01C2 , 0x81309E34},
{ 0x01C3 , 0x81309E35},
{ 0x01C4 , 0x81309E36},
{ 0x01C5 , 0x81309E37},
{ 0x01C6 , 0x81309E38},
{ 0x01C7 , 0x81309E39},
{ 0x01C8 , 0x81309F30},
{ 0x01C9 , 0x81309F31},
{ 0x01CA , 0x81309F32},
{ 0x01CB , 0x81309F33},
{ 0x01CC , 0x81309F34},
{ 0x01CD , 0x81309F35},
{ 0x01CF , 0x81309F36},
{ 0x01D1 , 0x81309F37},
{ 0x01D3 , 0x81309F38},
{ 0x01D5 , 0x81309F39},
{ 0x01D7 , 0x8130A030},
{ 0x01D9 , 0x8130A031},
{ 0x01DB , 0x8130A032},
{ 0x01DD , 0x8130A033},
{ 0x01DE , 0x8130A034},
{ 0x01DF , 0x8130A035},
{ 0x01E0 , 0x8130A036},
{ 0x01E1 , 0x8130A037},
{ 0x01E2 , 0x8130A038},
{ 0x01E3 , 0x8130A039},
{ 0x01E4 , 0x8130A130},
{ 0x01E5 , 0x8130A131},
{ 0x01E6 , 0x8130A132},
{ 0x01E7 , 0x8130A133},
{ 0x01E8 , 0x8130A134},
{ 0x01E9 , 0x8130A135},
{ 0x01EA , 0x8130A136},
{ 0x01EB , 0x8130A137},
{ 0x01EC , 0x8130A138},
{ 0x01ED , 0x8130A139},
{ 0x01EE , 0x8130A230},
{ 0x01EF , 0x8130A231},
{ 0x01F0 , 0x8130A232},
{ 0x01F1 , 0x8130A233},
{ 0x01F2 , 0x8130A234},
{ 0x01F3 , 0x8130A235},
{ 0x01F4 , 0x8130A236},
{ 0x01F5 , 0x8130A237},
{ 0x01F6 , 0x8130A238},
{ 0x01F7 , 0x8130A239},
{ 0x01F8 , 0x8130A330},
{ 0x01FA , 0x8130A331},
{ 0x01FB , 0x8130A332},
{ 0x01FC , 0x8130A333},
{ 0x01FD , 0x8130A334},
{ 0x01FE , 0x8130A335},
{ 0x01FF , 0x8130A336},
{ 0x0200 , 0x8130A337},
{ 0x0201 , 0x8130A338},
{ 0x0202 , 0x8130A339},
{ 0x0203 , 0x8130A430},
{ 0x0204 , 0x8130A431},
{ 0x0205 , 0x8130A432},
{ 0x0206 , 0x8130A433},
{ 0x0207 , 0x8130A434},
{ 0x0208 , 0x8130A435},
{ 0x0209 , 0x8130A436},
{ 0x020A , 0x8130A437},
{ 0x020B , 0x8130A438},
{ 0x020C , 0x8130A439},
{ 0x020D , 0x8130A530},
{ 0x020E , 0x8130A531},
{ 0x020F , 0x8130A532},
{ 0x0210 , 0x8130A533},
{ 0x0211 , 0x8130A534},
{ 0x0212 , 0x8130A535},
{ 0x0213 , 0x8130A536},
{ 0x0214 , 0x8130A537},
{ 0x0215 , 0x8130A538},
{ 0x0216 , 0x8130A539},
{ 0x0217 , 0x8130A630},
{ 0x0218 , 0x8130A631},
{ 0x0219 , 0x8130A632},
{ 0x021A , 0x8130A633},
{ 0x021B , 0x8130A634},
{ 0x021C , 0x8130A635},
{ 0x021D , 0x8130A636},
{ 0x021E , 0x8130A637},
{ 0x021F , 0x8130A638},
{ 0x0220 , 0x8130A639},
{ 0x0221 , 0x8130A730},
{ 0x0222 , 0x8130A731},
{ 0x0223 , 0x8130A732},
{ 0x0224 , 0x8130A733},
{ 0x0225 , 0x8130A734},
{ 0x0226 , 0x8130A735},
{ 0x0227 , 0x8130A736},
{ 0x0228 , 0x8130A737},
{ 0x0229 , 0x8130A738},
{ 0x022A , 0x8130A739},
{ 0x022B , 0x8130A830},
{ 0x022C , 0x8130A831},
{ 0x022D , 0x8130A832},
{ 0x022E , 0x8130A833},
{ 0x022F , 0x8130A834},
{ 0x0230 , 0x8130A835},
{ 0x0231 , 0x8130A836},
{ 0x0232 , 0x8130A837},
{ 0x0233 , 0x8130A838},
{ 0x0234 , 0x8130A839},
{ 0x0235 , 0x8130A930},
{ 0x0236 , 0x8130A931},
{ 0x0237 , 0x8130A932},
{ 0x0238 , 0x8130A933},
{ 0x0239 , 0x8130A934},
{ 0x023A , 0x8130A935},
{ 0x023B , 0x8130A936},
{ 0x023C , 0x8130A937},
{ 0x023D , 0x8130A938},
{ 0x023E , 0x8130A939},
{ 0x023F , 0x8130AA30},
{ 0x0240 , 0x8130AA31},
{ 0x0241 , 0x8130AA32},
{ 0x0242 , 0x8130AA33},
{ 0x0243 , 0x8130AA34},
{ 0x0244 , 0x8130AA35},
{ 0x0245 , 0x8130AA36},
{ 0x0246 , 0x8130AA37},
{ 0x0247 , 0x8130AA38},
{ 0x0248 , 0x8130AA39},
{ 0x0249 , 0x8130AB30},
{ 0x024A , 0x8130AB31},
{ 0x024B , 0x8130AB32},
{ 0x024C , 0x8130AB33},
{ 0x024D , 0x8130AB34},
{ 0x024E , 0x8130AB35},
{ 0x024F , 0x8130AB36},
{ 0x0250 , 0x8130AB37},
{ 0x0252 , 0x8130AB38},
{ 0x0253 , 0x8130AB39},
{ 0x0254 , 0x8130AC30},
{ 0x0255 , 0x8130AC31},
{ 0x0256 , 0x8130AC32},
{ 0x0257 , 0x8130AC33},
{ 0x0258 , 0x8130AC34},
{ 0x0259 , 0x8130AC35},
{ 0x025A , 0x8130AC36},
{ 0x025B , 0x8130AC37},
{ 0x025C , 0x8130AC38},
{ 0x025D , 0x8130AC39},
{ 0x025E , 0x8130AD30},
{ 0x025F , 0x8130AD31},
{ 0x0260 , 0x8130AD32},
{ 0x0262 , 0x8130AD33},
{ 0x0263 , 0x8130AD34},
{ 0x0264 , 0x8130AD35},
{ 0x0265 , 0x8130AD36},
{ 0x0266 , 0x8130AD37},
{ 0x0267 , 0x8130AD38},
{ 0x0268 , 0x8130AD39},
{ 0x0269 , 0x8130AE30},
{ 0x026A , 0x8130AE31},
{ 0x026B , 0x8130AE32},
{ 0x026C , 0x8130AE33},
{ 0x026D , 0x8130AE34},
{ 0x026E , 0x8130AE35},
{ 0x026F , 0x8130AE36},
{ 0x0270 , 0x8130AE37},
{ 0x0271 , 0x8130AE38},
{ 0x0272 , 0x8130AE39},
{ 0x0273 , 0x8130AF30},
{ 0x0274 , 0x8130AF31},
{ 0x0275 , 0x8130AF32},
{ 0x0276 , 0x8130AF33},
{ 0x0277 , 0x8130AF34},
{ 0x0278 , 0x8130AF35},
{ 0x0279 , 0x8130AF36},
{ 0x027A , 0x8130AF37},
{ 0x027B , 0x8130AF38},
{ 0x027C , 0x8130AF39},
{ 0x027D , 0x8130B030},
{ 0x027E , 0x8130B031},
{ 0x027F , 0x8130B032},
{ 0x0280 , 0x8130B033},
{ 0x0281 , 0x8130B034},
{ 0x0282 , 0x8130B035},
{ 0x0283 , 0x8130B036},
{ 0x0284 , 0x8130B037},
{ 0x0285 , 0x8130B038},
{ 0x0286 , 0x8130B039},
{ 0x0287 , 0x8130B130},
{ 0x0288 , 0x8130B131},
{ 0x0289 , 0x8130B132},
{ 0x028A , 0x8130B133},
{ 0x028B , 0x8130B134},
{ 0x028C , 0x8130B135},
{ 0x028D , 0x8130B136},
{ 0x028E , 0x8130B137},
{ 0x028F , 0x8130B138},
{ 0x0290 , 0x8130B139},
{ 0x0291 , 0x8130B230},
{ 0x0292 , 0x8130B231},
{ 0x0293 , 0x8130B232},
{ 0x0294 , 0x8130B233},
{ 0x0295 , 0x8130B234},
{ 0x0296 , 0x8130B235},
{ 0x0297 , 0x8130B236},
{ 0x0298 , 0x8130B237},
{ 0x0299 , 0x8130B238},
{ 0x029A , 0x8130B239},
{ 0x029B , 0x8130B330},
{ 0x029C , 0x8130B331},
{ 0x029D , 0x8130B332},
{ 0x029E , 0x8130B333},
{ 0x029F , 0x8130B334},
{ 0x02A0 , 0x8130B335},
{ 0x02A1 , 0x8130B336},
{ 0x02A2 , 0x8130B337},
{ 0x02A3 , 0x8130B338},
{ 0x02A4 , 0x8130B339},
{ 0x02A5 , 0x8130B430},
{ 0x02A6 , 0x8130B431},
{ 0x02A7 , 0x8130B432},
{ 0x02A8 , 0x8130B433},
{ 0x02A9 , 0x8130B434},
{ 0x02AA , 0x8130B435},
{ 0x02AB , 0x8130B436},
{ 0x02AC , 0x8130B437},
{ 0x02AD , 0x8130B438},
{ 0x02AE , 0x8130B439},
{ 0x02AF , 0x8130B530},
{ 0x02B0 , 0x8130B531},
{ 0x02B1 , 0x8130B532},
{ 0x02B2 , 0x8130B533},
{ 0x02B3 , 0x8130B534},
{ 0x02B4 , 0x8130B535},
{ 0x02B5 , 0x8130B536},
{ 0x02B6 , 0x8130B537},
{ 0x02B7 , 0x8130B538},
{ 0x02B8 , 0x8130B539},
{ 0x02B9 , 0x8130B630},
{ 0x02BA , 0x8130B631},
{ 0x02BB , 0x8130B632},
{ 0x02BC , 0x8130B633},
{ 0x02BD , 0x8130B634},
{ 0x02BE , 0x8130B635},
{ 0x02BF , 0x8130B636},
{ 0x02C0 , 0x8130B637},
{ 0x02C1 , 0x8130B638},
{ 0x02C2 , 0x8130B639},
{ 0x02C3 , 0x8130B730},
{ 0x02C4 , 0x8130B731},
{ 0x02C5 , 0x8130B732},
{ 0x02C6 , 0x8130B733},
{ 0x02C8 , 0x8130B734},
{ 0x02CC , 0x8130B735},
{ 0x02CD , 0x8130B736},
{ 0x02CE , 0x8130B737},
{ 0x02CF , 0x8130B738},
{ 0x02D0 , 0x8130B739},
{ 0x02D1 , 0x8130B830},
{ 0x02D2 , 0x8130B831},
{ 0x02D3 , 0x8130B832},
{ 0x02D4 , 0x8130B833},
{ 0x02D5 , 0x8130B834},
{ 0x02D6 , 0x8130B835},
{ 0x02D7 , 0x8130B836},
{ 0x02D8 , 0x8130B837},
{ 0x02DA , 0x8130B838},
{ 0x02DB , 0x8130B839},
{ 0x02DC , 0x8130B930},
{ 0x02DD , 0x8130B931},
{ 0x02DE , 0x8130B932},
{ 0x02DF , 0x8130B933},
{ 0x02E0 , 0x8130B934},
{ 0x02E1 , 0x8130B935},
{ 0x02E2 , 0x8130B936},
{ 0x02E3 , 0x8130B937},
{ 0x02E4 , 0x8130B938},
{ 0x02E5 , 0x8130B939},
{ 0x02E6 , 0x8130BA30},
{ 0x02E7 , 0x8130BA31},
{ 0x02E8 , 0x8130BA32},
{ 0x02E9 , 0x8130BA33},
{ 0x02EA , 0x8130BA34},
{ 0x02EB , 0x8130BA35},
{ 0x02EC , 0x8130BA36},
{ 0x02ED , 0x8130BA37},
{ 0x02EE , 0x8130BA38},
{ 0x02EF , 0x8130BA39},
{ 0x02F0 , 0x8130BB30},
{ 0x02F1 , 0x8130BB31},
{ 0x02F2 , 0x8130BB32},
{ 0x02F3 , 0x8130BB33},
{ 0x02F4 , 0x8130BB34},
{ 0x02F5 , 0x8130BB35},
{ 0x02F6 , 0x8130BB36},
{ 0x02F7 , 0x8130BB37},
{ 0x02F8 , 0x8130BB38},
{ 0x02F9 , 0x8130BB39},
{ 0x02FA , 0x8130BC30},
{ 0x02FB , 0x8130BC31},
{ 0x02FC , 0x8130BC32},
{ 0x02FD , 0x8130BC33},
{ 0x02FE , 0x8130BC34},
{ 0x02FF , 0x8130BC35},
{ 0x0300 , 0x8130BC36},
{ 0x0301 , 0x8130BC37},
{ 0x0302 , 0x8130BC38},
{ 0x0303 , 0x8130BC39},
{ 0x0304 , 0x8130BD30},
{ 0x0305 , 0x8130BD31},
{ 0x0306 , 0x8130BD32},
{ 0x0307 , 0x8130BD33},
{ 0x0308 , 0x8130BD34},
{ 0x0309 , 0x8130BD35},
{ 0x030A , 0x8130BD36},
{ 0x030B , 0x8130BD37},
{ 0x030C , 0x8130BD38},
{ 0x030D , 0x8130BD39},
{ 0x030E , 0x8130BE30},
{ 0x030F , 0x8130BE31},
{ 0x0310 , 0x8130BE32},
{ 0x0311 , 0x8130BE33},
{ 0x0312 , 0x8130BE34},
{ 0x0313 , 0x8130BE35},
{ 0x0314 , 0x8130BE36},
{ 0x0315 , 0x8130BE37},
{ 0x0316 , 0x8130BE38},
{ 0x0317 , 0x8130BE39},
{ 0x0318 , 0x8130BF30},
{ 0x0319 , 0x8130BF31},
{ 0x031A , 0x8130BF32},
{ 0x031B , 0x8130BF33},
{ 0x031C , 0x8130BF34},
{ 0x031D , 0x8130BF35},
{ 0x031E , 0x8130BF36},
{ 0x031F , 0x8130BF37},
{ 0x0320 , 0x8130BF38},
{ 0x0321 , 0x8130BF39},
{ 0x0322 , 0x8130C030},
{ 0x0323 , 0x8130C031},
{ 0x0324 , 0x8130C032},
{ 0x0325 , 0x8130C033},
{ 0x0326 , 0x8130C034},
{ 0x0327 , 0x8130C035},
{ 0x0328 , 0x8130C036},
{ 0x0329 , 0x8130C037},
{ 0x032A , 0x8130C038},
{ 0x032B , 0x8130C039},
{ 0x032C , 0x8130C130},
{ 0x032D , 0x8130C131},
{ 0x032E , 0x8130C132},
{ 0x032F , 0x8130C133},
{ 0x0330 , 0x8130C134},
{ 0x0331 , 0x8130C135},
{ 0x0332 , 0x8130C136},
{ 0x0333 , 0x8130C137},
{ 0x0334 , 0x8130C138},
{ 0x0335 , 0x8130C139},
{ 0x0336 , 0x8130C230},
{ 0x0337 , 0x8130C231},
{ 0x0338 , 0x8130C232},
{ 0x0339 , 0x8130C233},
{ 0x033A , 0x8130C234},
{ 0x033B , 0x8130C235},
{ 0x033C , 0x8130C236},
{ 0x033D , 0x8130C237},
{ 0x033E , 0x8130C238},
{ 0x033F , 0x8130C239},
{ 0x0340 , 0x8130C330},
{ 0x0341 , 0x8130C331},
{ 0x0342 , 0x8130C332},
{ 0x0343 , 0x8130C333},
{ 0x0344 , 0x8130C334},
{ 0x0345 , 0x8130C335},
{ 0x0346 , 0x8130C336},
{ 0x0347 , 0x8130C337},
{ 0x0348 , 0x8130C338},
{ 0x0349 , 0x8130C339},
{ 0x034A , 0x8130C430},
{ 0x034B , 0x8130C431},
{ 0x034C , 0x8130C432},
{ 0x034D , 0x8130C433},
{ 0x034E , 0x8130C434},
{ 0x034F , 0x8130C435},
{ 0x0350 , 0x8130C436},
{ 0x0351 , 0x8130C437},
{ 0x0352 , 0x8130C438},
{ 0x0353 , 0x8130C439},
{ 0x0354 , 0x8130C530},
{ 0x0355 , 0x8130C531},
{ 0x0356 , 0x8130C532},
{ 0x0357 , 0x8130C533},
{ 0x0358 , 0x8130C534},
{ 0x0359 , 0x8130C535},
{ 0x035A , 0x8130C536},
{ 0x035B , 0x8130C537},
{ 0x035C , 0x8130C538},
{ 0x035D , 0x8130C539},
{ 0x035E , 0x8130C630},
{ 0x035F , 0x8130C631},
{ 0x0360 , 0x8130C632},
{ 0x0361 , 0x8130C633},
{ 0x0362 , 0x8130C634},
{ 0x0363 , 0x8130C635},
{ 0x0364 , 0x8130C636},
{ 0x0365 , 0x8130C637},
{ 0x0366 , 0x8130C638},
{ 0x0367 , 0x8130C639},
{ 0x0368 , 0x8130C730},
{ 0x0369 , 0x8130C731},
{ 0x036A , 0x8130C732},
{ 0x036B , 0x8130C733},
{ 0x036C , 0x8130C734},
{ 0x036D , 0x8130C735},
{ 0x036E , 0x8130C736},
{ 0x036F , 0x8130C737},
{ 0x0370 , 0x8130C738},
{ 0x0371 , 0x8130C739},
{ 0x0372 , 0x8130C830},
{ 0x0373 , 0x8130C831},
{ 0x0374 , 0x8130C832},
{ 0x0375 , 0x8130C833},
{ 0x0376 , 0x8130C834},
{ 0x0377 , 0x8130C835},
{ 0x0378 , 0x8130C836},
{ 0x0379 , 0x8130C837},
{ 0x037A , 0x8130C838},
{ 0x037B , 0x8130C839},
{ 0x037C , 0x8130C930},
{ 0x037D , 0x8130C931},
{ 0x037E , 0x8130C932},
{ 0x037F , 0x8130C933},
{ 0x0380 , 0x8130C934},
{ 0x0381 , 0x8130C935},
{ 0x0382 , 0x8130C936},
{ 0x0383 , 0x8130C937},
{ 0x0384 , 0x8130C938},
{ 0x0385 , 0x8130C939},
{ 0x0386 , 0x8130CA30},
{ 0x0387 , 0x8130CA31},
{ 0x0388 , 0x8130CA32},
{ 0x0389 , 0x8130CA33},
{ 0x038A , 0x8130CA34},
{ 0x038B , 0x8130CA35},
{ 0x038C , 0x8130CA36},
{ 0x038D , 0x8130CA37},
{ 0x038E , 0x8130CA38},
{ 0x038F , 0x8130CA39},
{ 0x0390 , 0x8130CB30},
{ 0x03A2 , 0x8130CB31},
{ 0x03AA , 0x8130CB32},
{ 0x03AB , 0x8130CB33},
{ 0x03AC , 0x8130CB34},
{ 0x03AD , 0x8130CB35},
{ 0x03AE , 0x8130CB36},
{ 0x03AF , 0x8130CB37},
{ 0x03B0 , 0x8130CB38},
{ 0x03C2 , 0x8130CB39},
{ 0x03CA , 0x8130CC30},
{ 0x03CB , 0x8130CC31},
{ 0x03CC , 0x8130CC32},
{ 0x03CD , 0x8130CC33},
{ 0x03CE , 0x8130CC34},
{ 0x03CF , 0x8130CC35},
{ 0x03D0 , 0x8130CC36},
{ 0x03D1 , 0x8130CC37},
{ 0x03D2 , 0x8130CC38},
{ 0x03D3 , 0x8130CC39},
{ 0x03D4 , 0x8130CD30},
{ 0x03D5 , 0x8130CD31},
{ 0x03D6 , 0x8130CD32},
{ 0x03D7 , 0x8130CD33},
{ 0x03D8 , 0x8130CD34},
{ 0x03D9 , 0x8130CD35},
{ 0x03DA , 0x8130CD36},
{ 0x03DB , 0x8130CD37},
{ 0x03DC , 0x8130CD38},
{ 0x03DD , 0x8130CD39},
{ 0x03DE , 0x8130CE30},
{ 0x03DF , 0x8130CE31},
{ 0x03E0 , 0x8130CE32},
{ 0x03E1 , 0x8130CE33},
{ 0x03E2 , 0x8130CE34},
{ 0x03E3 , 0x8130CE35},
{ 0x03E4 , 0x8130CE36},
{ 0x03E5 , 0x8130CE37},
{ 0x03E6 , 0x8130CE38},
{ 0x03E7 , 0x8130CE39},
{ 0x03E8 , 0x8130CF30},
{ 0x03E9 , 0x8130CF31},
{ 0x03EA , 0x8130CF32},
{ 0x03EB , 0x8130CF33},
{ 0x03EC , 0x8130CF34},
{ 0x03ED , 0x8130CF35},
{ 0x03EE , 0x8130CF36},
{ 0x03EF , 0x8130CF37},
{ 0x03F0 , 0x8130CF38},
{ 0x03F1 , 0x8130CF39},
{ 0x03F2 , 0x8130D030},
{ 0x03F3 , 0x8130D031},
{ 0x03F4 , 0x8130D032},
{ 0x03F5 , 0x8130D033},
{ 0x03F6 , 0x8130D034},
{ 0x03F7 , 0x8130D035},
{ 0x03F8 , 0x8130D036},
{ 0x03F9 , 0x8130D037},
{ 0x03FA , 0x8130D038},
{ 0x03FB , 0x8130D039},
{ 0x03FC , 0x8130D130},
{ 0x03FD , 0x8130D131},
{ 0x03FE , 0x8130D132},
{ 0x03FF , 0x8130D133},
{ 0x0400 , 0x8130D134},
{ 0x0402 , 0x8130D135},
{ 0x0403 , 0x8130D136},
{ 0x0404 , 0x8130D137},
{ 0x0405 , 0x8130D138},
{ 0x0406 , 0x8130D139},
{ 0x0407 , 0x8130D230},
{ 0x0408 , 0x8130D231},
{ 0x0409 , 0x8130D232},
{ 0x040A , 0x8130D233},
{ 0x040B , 0x8130D234},
{ 0x040C , 0x8130D235},
{ 0x040D , 0x8130D236},
{ 0x040E , 0x8130D237},
{ 0x040F , 0x8130D238},
{ 0x0450 , 0x8130D239},
{ 0x0452 , 0x8130D330},
{ 0x0453 , 0x8130D331},
{ 0x0454 , 0x8130D332},
{ 0x0455 , 0x8130D333},
{ 0x0456 , 0x8130D334},
{ 0x0457 , 0x8130D335},
{ 0x0458 , 0x8130D336},
{ 0x0459 , 0x8130D337},
{ 0x045A , 0x8130D338},
{ 0x045B , 0x8130D339},
{ 0x045C , 0x8130D430},
{ 0x045D , 0x8130D431},
{ 0x045E , 0x8130D432},
{ 0x045F , 0x8130D433},
{ 0x0460 , 0x8130D434},
{ 0x0461 , 0x8130D435},
{ 0x0462 , 0x8130D436},
{ 0x0463 , 0x8130D437},
{ 0x0464 , 0x8130D438},
{ 0x0465 , 0x8130D439},
{ 0x0466 , 0x8130D530},
{ 0x0467 , 0x8130D531},
{ 0x0468 , 0x8130D532},
{ 0x0469 , 0x8130D533},
{ 0x046A , 0x8130D534},
{ 0x046B , 0x8130D535},
{ 0x046C , 0x8130D536},
{ 0x046D , 0x8130D537},
{ 0x046E , 0x8130D538},
{ 0x046F , 0x8130D539},
{ 0x0470 , 0x8130D630},
{ 0x0471 , 0x8130D631},
{ 0x0472 , 0x8130D632},
{ 0x0473 , 0x8130D633},
{ 0x0474 , 0x8130D634},
{ 0x0475 , 0x8130D635},
{ 0x0476 , 0x8130D636},
{ 0x0477 , 0x8130D637},
{ 0x0478 , 0x8130D638},
{ 0x0479 , 0x8130D639},
{ 0x047A , 0x8130D730},
{ 0x047B , 0x8130D731},
{ 0x047C , 0x8130D732},
{ 0x047D , 0x8130D733},
{ 0x047E , 0x8130D734},
{ 0x047F , 0x8130D735},
{ 0x0480 , 0x8130D736},
{ 0x0481 , 0x8130D737},
{ 0x0482 , 0x8130D738},
{ 0x0483 , 0x8130D739},
{ 0x0484 , 0x8130D830},
{ 0x0485 , 0x8130D831},
{ 0x0486 , 0x8130D832},
{ 0x0487 , 0x8130D833},
{ 0x0488 , 0x8130D834},
{ 0x0489 , 0x8130D835},
{ 0x048A , 0x8130D836},
{ 0x048B , 0x8130D837},
{ 0x048C , 0x8130D838},
{ 0x048D , 0x8130D839},
{ 0x048E , 0x8130D930},
{ 0x048F , 0x8130D931},
{ 0x0490 , 0x8130D932},
{ 0x0491 , 0x8130D933},
{ 0x0492 , 0x8130D934},
{ 0x0493 , 0x8130D935},
{ 0x0494 , 0x8130D936},
{ 0x0495 , 0x8130D937},
{ 0x0496 , 0x8130D938},
{ 0x0497 , 0x8130D939},
{ 0x0498 , 0x8130DA30},
{ 0x0499 , 0x8130DA31},
{ 0x049A , 0x8130DA32},
{ 0x049B , 0x8130DA33},
{ 0x049C , 0x8130DA34},
{ 0x049D , 0x8130DA35},
{ 0x049E , 0x8130DA36},
{ 0x049F , 0x8130DA37},
{ 0x04A0 , 0x8130DA38},
{ 0x04A1 , 0x8130DA39},
{ 0x04A2 , 0x8130DB30},
{ 0x04A3 , 0x8130DB31},
{ 0x04A4 , 0x8130DB32},
{ 0x04A5 , 0x8130DB33},
{ 0x04A6 , 0x8130DB34},
{ 0x04A7 , 0x8130DB35},
{ 0x04A8 , 0x8130DB36},
{ 0x04A9 , 0x8130DB37},
{ 0x04AA , 0x8130DB38},
{ 0x04AB , 0x8130DB39},
{ 0x04AC , 0x8130DC30},
{ 0x04AD , 0x8130DC31},
{ 0x04AE , 0x8130DC32},
{ 0x04AF , 0x8130DC33},
{ 0x04B0 , 0x8130DC34},
{ 0x04B1 , 0x8130DC35},
{ 0x04B2 , 0x8130DC36},
{ 0x04B3 , 0x8130DC37},
{ 0x04B4 , 0x8130DC38},
{ 0x04B5 , 0x8130DC39},
{ 0x04B6 , 0x8130DD30},
{ 0x04B7 , 0x8130DD31},
{ 0x04B8 , 0x8130DD32},
{ 0x04B9 , 0x8130DD33},
{ 0x04BA , 0x8130DD34},
{ 0x04BB , 0x8130DD35},
{ 0x04BC , 0x8130DD36},
{ 0x04BD , 0x8130DD37},
{ 0x04BE , 0x8130DD38},
{ 0x04BF , 0x8130DD39},
{ 0x04C0 , 0x8130DE30},
{ 0x04C1 , 0x8130DE31},
{ 0x04C2 , 0x8130DE32},
{ 0x04C3 , 0x8130DE33},
{ 0x04C4 , 0x8130DE34},
{ 0x04C5 , 0x8130DE35},
{ 0x04C6 , 0x8130DE36},
{ 0x04C7 , 0x8130DE37},
{ 0x04C8 , 0x8130DE38},
{ 0x04C9 , 0x8130DE39},
{ 0x04CA , 0x8130DF30},
{ 0x04CB , 0x8130DF31},
{ 0x04CC , 0x8130DF32},
{ 0x04CD , 0x8130DF33},
{ 0x04CE , 0x8130DF34},
{ 0x04CF , 0x8130DF35},
{ 0x04D0 , 0x8130DF36},
{ 0x04D1 , 0x8130DF37},
{ 0x04D2 , 0x8130DF38},
{ 0x04D3 , 0x8130DF39},
{ 0x04D4 , 0x8130E030},
{ 0x04D5 , 0x8130E031},
{ 0x04D6 , 0x8130E032},
{ 0x04D7 , 0x8130E033},
{ 0x04D8 , 0x8130E034},
{ 0x04D9 , 0x8130E035},
{ 0x04DA , 0x8130E036},
{ 0x04DB , 0x8130E037},
{ 0x04DC , 0x8130E038},
{ 0x04DD , 0x8130E039},
{ 0x04DE , 0x8130E130},
{ 0x04DF , 0x8130E131},
{ 0x04E0 , 0x8130E132},
{ 0x04E1 , 0x8130E133},
{ 0x04E2 , 0x8130E134},
{ 0x04E3 , 0x8130E135},
{ 0x04E4 , 0x8130E136},
{ 0x04E5 , 0x8130E137},
{ 0x04E6 , 0x8130E138},
{ 0x04E7 , 0x8130E139},
{ 0x04E8 , 0x8130E230},
{ 0x04E9 , 0x8130E231},
{ 0x04EA , 0x8130E232},
{ 0x04EB , 0x8130E233},
{ 0x04EC , 0x8130E234},
{ 0x04ED , 0x8130E235},
{ 0x04EE , 0x8130E236},
{ 0x04EF , 0x8130E237},
{ 0x04F0 , 0x8130E238},
{ 0x04F1 , 0x8130E239},
{ 0x04F2 , 0x8130E330},
{ 0x04F3 , 0x8130E331},
{ 0x04F4 , 0x8130E332},
{ 0x04F5 , 0x8130E333},
{ 0x04F6 , 0x8130E334},
{ 0x04F7 , 0x8130E335},
{ 0x04F8 , 0x8130E336},
{ 0x04F9 , 0x8130E337},
{ 0x04FA , 0x8130E338},
{ 0x04FB , 0x8130E339},
{ 0x04FC , 0x8130E430},
{ 0x04FD , 0x8130E431},
{ 0x04FE , 0x8130E432},
{ 0x04FF , 0x8130E433},
{ 0x0500 , 0x8130E434},
{ 0x0501 , 0x8130E435},
{ 0x0502 , 0x8130E436},
{ 0x0503 , 0x8130E437},
{ 0x0504 , 0x8130E438},
{ 0x0505 , 0x8130E439},
{ 0x0506 , 0x8130E530},
{ 0x0507 , 0x8130E531},
{ 0x0508 , 0x8130E532},
{ 0x0509 , 0x8130E533},
{ 0x050A , 0x8130E534},
{ 0x050B , 0x8130E535},
{ 0x050C , 0x8130E536},
{ 0x050D , 0x8130E537},
{ 0x050E , 0x8130E538},
{ 0x050F , 0x8130E539},
{ 0x0510 , 0x8130E630},
{ 0x0511 , 0x8130E631},
{ 0x0512 , 0x8130E632},
{ 0x0513 , 0x8130E633},
{ 0x0514 , 0x8130E634},
{ 0x0515 , 0x8130E635},
{ 0x0516 , 0x8130E636},
{ 0x0517 , 0x8130E637},
{ 0x0518 , 0x8130E638},
{ 0x0519 , 0x8130E639},
{ 0x051A , 0x8130E730},
{ 0x051B , 0x8130E731},
{ 0x051C , 0x8130E732},
{ 0x051D , 0x8130E733},
{ 0x051E , 0x8130E734},
{ 0x051F , 0x8130E735},
{ 0x0520 , 0x8130E736},
{ 0x0521 , 0x8130E737},
{ 0x0522 , 0x8130E738},
{ 0x0523 , 0x8130E739},
{ 0x0524 , 0x8130E830},
{ 0x0525 , 0x8130E831},
{ 0x0526 , 0x8130E832},
{ 0x0527 , 0x8130E833},
{ 0x0528 , 0x8130E834},
{ 0x0529 , 0x8130E835},
{ 0x052A , 0x8130E836},
{ 0x052B , 0x8130E837},
{ 0x052C , 0x8130E838},
{ 0x052D , 0x8130E839},
{ 0x052E , 0x8130E930},
{ 0x052F , 0x8130E931},
{ 0x0530 , 0x8130E932},
{ 0x0531 , 0x8130E933},
{ 0x0532 , 0x8130E934},
{ 0x0533 , 0x8130E935},
{ 0x0534 , 0x8130E936},
{ 0x0535 , 0x8130E937},
{ 0x0536 , 0x8130E938},
{ 0x0537 , 0x8130E939},
{ 0x0538 , 0x8130EA30},
{ 0x0539 , 0x8130EA31},
{ 0x053A , 0x8130EA32},
{ 0x053B , 0x8130EA33},
{ 0x053C , 0x8130EA34},
{ 0x053D , 0x8130EA35},
{ 0x053E , 0x8130EA36},
{ 0x053F , 0x8130EA37},
{ 0x0540 , 0x8130EA38},
{ 0x0541 , 0x8130EA39},
{ 0x0542 , 0x8130EB30},
{ 0x0543 , 0x8130EB31},
{ 0x0544 , 0x8130EB32},
{ 0x0545 , 0x8130EB33},
{ 0x0546 , 0x8130EB34},
{ 0x0547 , 0x8130EB35},
{ 0x0548 , 0x8130EB36},
{ 0x0549 , 0x8130EB37},
{ 0x054A , 0x8130EB38},
{ 0x054B , 0x8130EB39},
{ 0x054C , 0x8130EC30},
{ 0x054D , 0x8130EC31},
{ 0x054E , 0x8130EC32},
{ 0x054F , 0x8130EC33},
{ 0x0550 , 0x8130EC34},
{ 0x0551 , 0x8130EC35},
{ 0x0552 , 0x8130EC36},
{ 0x0553 , 0x8130EC37},
{ 0x0554 , 0x8130EC38},
{ 0x0555 , 0x8130EC39},
{ 0x0556 , 0x8130ED30},
{ 0x0557 , 0x8130ED31},
{ 0x0558 , 0x8130ED32},
{ 0x0559 , 0x8130ED33},
{ 0x055A , 0x8130ED34},
{ 0x055B , 0x8130ED35},
{ 0x055C , 0x8130ED36},
{ 0x055D , 0x8130ED37},
{ 0x055E , 0x8130ED38},
{ 0x055F , 0x8130ED39},
{ 0x0560 , 0x8130EE30},
{ 0x0561 , 0x8130EE31},
{ 0x0562 , 0x8130EE32},
{ 0x0563 , 0x8130EE33},
{ 0x0564 , 0x8130EE34},
{ 0x0565 , 0x8130EE35},
{ 0x0566 , 0x8130EE36},
{ 0x0567 , 0x8130EE37},
{ 0x0568 , 0x8130EE38},
{ 0x0569 , 0x8130EE39},
{ 0x056A , 0x8130EF30},
{ 0x056B , 0x8130EF31},
{ 0x056C , 0x8130EF32},
{ 0x056D , 0x8130EF33},
{ 0x056E , 0x8130EF34},
{ 0x056F , 0x8130EF35},
{ 0x0570 , 0x8130EF36},
{ 0x0571 , 0x8130EF37},
{ 0x0572 , 0x8130EF38},
{ 0x0573 , 0x8130EF39},
{ 0x0574 , 0x8130F030},
{ 0x0575 , 0x8130F031},
{ 0x0576 , 0x8130F032},
{ 0x0577 , 0x8130F033},
{ 0x0578 , 0x8130F034},
{ 0x0579 , 0x8130F035},
{ 0x057A , 0x8130F036},
{ 0x057B , 0x8130F037},
{ 0x057C , 0x8130F038},
{ 0x057D , 0x8130F039},
{ 0x057E , 0x8130F130},
{ 0x057F , 0x8130F131},
{ 0x0580 , 0x8130F132},
{ 0x0581 , 0x8130F133},
{ 0x0582 , 0x8130F134},
{ 0x0583 , 0x8130F135},
{ 0x0584 , 0x8130F136},
{ 0x0585 , 0x8130F137},
{ 0x0586 , 0x8130F138},
{ 0x0587 , 0x8130F139},
{ 0x0588 , 0x8130F230},
{ 0x0589 , 0x8130F231},
{ 0x058A , 0x8130F232},
{ 0x058B , 0x8130F233},
{ 0x058C , 0x8130F234},
{ 0x058D , 0x8130F235},
{ 0x058E , 0x8130F236},
{ 0x058F , 0x8130F237},
{ 0x0590 , 0x8130F238},
{ 0x0591 , 0x8130F239},
{ 0x0592 , 0x8130F330},
{ 0x0593 , 0x8130F331},
{ 0x0594 , 0x8130F332},
{ 0x0595 , 0x8130F333},
{ 0x0596 , 0x8130F334},
{ 0x0597 , 0x8130F335},
{ 0x0598 , 0x8130F336},
{ 0x0599 , 0x8130F337},
{ 0x059A , 0x8130F338},
{ 0x059B , 0x8130F339},
{ 0x059C , 0x8130F430},
{ 0x059D , 0x8130F431},
{ 0x059E , 0x8130F432},
{ 0x059F , 0x8130F433},
{ 0x05A0 , 0x8130F434},
{ 0x05A1 , 0x8130F435},
{ 0x05A2 , 0x8130F436},
{ 0x05A3 , 0x8130F437},
{ 0x05A4 , 0x8130F438},
{ 0x05A5 , 0x8130F439},
{ 0x05A6 , 0x8130F530},
{ 0x05A7 , 0x8130F531},
{ 0x05A8 , 0x8130F532},
{ 0x05A9 , 0x8130F533},
{ 0x05AA , 0x8130F534},
{ 0x05AB , 0x8130F535},
{ 0x05AC , 0x8130F536},
{ 0x05AD , 0x8130F537},
{ 0x05AE , 0x8130F538},
{ 0x05AF , 0x8130F539},
{ 0x05B0 , 0x8130F630},
{ 0x05B1 , 0x8130F631},
{ 0x05B2 , 0x8130F632},
{ 0x05B3 , 0x8130F633},
{ 0x05B4 , 0x8130F634},
{ 0x05B5 , 0x8130F635},
{ 0x05B6 , 0x8130F636},
{ 0x05B7 , 0x8130F637},
{ 0x05B8 , 0x8130F638},
{ 0x05B9 , 0x8130F639},
{ 0x05BA , 0x8130F730},
{ 0x05BB , 0x8130F731},
{ 0x05BC , 0x8130F732},
{ 0x05BD , 0x8130F733},
{ 0x05BE , 0x8130F734},
{ 0x05BF , 0x8130F735},
{ 0x05C0 , 0x8130F736},
{ 0x05C1 , 0x8130F737},
{ 0x05C2 , 0x8130F738},
{ 0x05C3 , 0x8130F739},
{ 0x05C4 , 0x8130F830},
{ 0x05C5 , 0x8130F831},
{ 0x05C6 , 0x8130F832},
{ 0x05C7 , 0x8130F833},
{ 0x05C8 , 0x8130F834},
{ 0x05C9 , 0x8130F835},
{ 0x05CA , 0x8130F836},
{ 0x05CB , 0x8130F837},
{ 0x05CC , 0x8130F838},
{ 0x05CD , 0x8130F839},
{ 0x05CE , 0x8130F930},
{ 0x05CF , 0x8130F931},
{ 0x05D0 , 0x8130F932},
{ 0x05D1 , 0x8130F933},
{ 0x05D2 , 0x8130F934},
{ 0x05D3 , 0x8130F935},
{ 0x05D4 , 0x8130F936},
{ 0x05D5 , 0x8130F937},
{ 0x05D6 , 0x8130F938},
{ 0x05D7 , 0x8130F939},
{ 0x05D8 , 0x8130FA30},
{ 0x05D9 , 0x8130FA31},
{ 0x05DA , 0x8130FA32},
{ 0x05DB , 0x8130FA33},
{ 0x05DC , 0x8130FA34},
{ 0x05DD , 0x8130FA35},
{ 0x05DE , 0x8130FA36},
{ 0x05DF , 0x8130FA37},
{ 0x05E0 , 0x8130FA38},
{ 0x05E1 , 0x8130FA39},
{ 0x05E2 , 0x8130FB30},
{ 0x05E3 , 0x8130FB31},
{ 0x05E4 , 0x8130FB32},
{ 0x05E5 , 0x8130FB33},
{ 0x05E6 , 0x8130FB34},
{ 0x05E7 , 0x8130FB35},
{ 0x05E8 , 0x8130FB36},
{ 0x05E9 , 0x8130FB37},
{ 0x05EA , 0x8130FB38},
{ 0x05EB , 0x8130FB39},
{ 0x05EC , 0x8130FC30},
{ 0x05ED , 0x8130FC31},
{ 0x05EE , 0x8130FC32},
{ 0x05EF , 0x8130FC33},
{ 0x05F0 , 0x8130FC34},
{ 0x05F1 , 0x8130FC35},
{ 0x05F2 , 0x8130FC36},
{ 0x05F3 , 0x8130FC37},
{ 0x05F4 , 0x8130FC38},
{ 0x05F5 , 0x8130FC39},
{ 0x05F6 , 0x8130FD30},
{ 0x05F7 , 0x8130FD31},
{ 0x05F8 , 0x8130FD32},
{ 0x05F9 , 0x8130FD33},
{ 0x05FA , 0x8130FD34},
{ 0x05FB , 0x8130FD35},
{ 0x05FC , 0x8130FD36},
{ 0x05FD , 0x8130FD37},
{ 0x05FE , 0x8130FD38},
{ 0x05FF , 0x8130FD39},
{ 0x0600 , 0x8130FE30},
{ 0x0601 , 0x8130FE31},
{ 0x0602 , 0x8130FE32},
{ 0x0603 , 0x8130FE33},
{ 0x0604 , 0x8130FE34},
{ 0x0605 , 0x8130FE35},
{ 0x0606 , 0x8130FE36},
{ 0x0607 , 0x8130FE37},
{ 0x0608 , 0x8130FE38},
{ 0x0609 , 0x8130FE39},
{ 0x060A , 0x81318130},
{ 0x060B , 0x81318131},
{ 0x060C , 0x81318132},
{ 0x060D , 0x81318133},
{ 0x060E , 0x81318134},
{ 0x060F , 0x81318135},
{ 0x0610 , 0x81318136},
{ 0x0611 , 0x81318137},
{ 0x0612 , 0x81318138},
{ 0x0613 , 0x81318139},
{ 0x0614 , 0x81318230},
{ 0x0615 , 0x81318231},
{ 0x0616 , 0x81318232},
{ 0x0617 , 0x81318233},
{ 0x0618 , 0x81318234},
{ 0x0619 , 0x81318235},
{ 0x061A , 0x81318236},
{ 0x061B , 0x81318237},
{ 0x061C , 0x81318238},
{ 0x061D , 0x81318239},
{ 0x061E , 0x81318330},
{ 0x061F , 0x81318331},
{ 0x0620 , 0x81318332},
{ 0x0621 , 0x81318333},
{ 0x0622 , 0x81318334},
{ 0x0623 , 0x81318335},
{ 0x0624 , 0x81318336},
{ 0x0625 , 0x81318337},
{ 0x0626 , 0x81318338},
{ 0x0627 , 0x81318339},
{ 0x0628 , 0x81318430},
{ 0x0629 , 0x81318431},
{ 0x062A , 0x81318432},
{ 0x062B , 0x81318433},
{ 0x062C , 0x81318434},
{ 0x062D , 0x81318435},
{ 0x062E , 0x81318436},
{ 0x062F , 0x81318437},
{ 0x0630 , 0x81318438},
{ 0x0631 , 0x81318439},
{ 0x0632 , 0x81318530},
{ 0x0633 , 0x81318531},
{ 0x0634 , 0x81318532},
{ 0x0635 , 0x81318533},
{ 0x0636 , 0x81318534},
{ 0x0637 , 0x81318535},
{ 0x0638 , 0x81318536},
{ 0x0639 , 0x81318537},
{ 0x063A , 0x81318538},
{ 0x063B , 0x81318539},
{ 0x063C , 0x81318630},
{ 0x063D , 0x81318631},
{ 0x063E , 0x81318632},
{ 0x063F , 0x81318633},
{ 0x0640 , 0x81318634},
{ 0x0641 , 0x81318635},
{ 0x0642 , 0x81318636},
{ 0x0643 , 0x81318637},
{ 0x0644 , 0x81318638},
{ 0x0645 , 0x81318639},
{ 0x0646 , 0x81318730},
{ 0x0647 , 0x81318731},
{ 0x0648 , 0x81318732},
{ 0x0649 , 0x81318733},
{ 0x064A , 0x81318734},
{ 0x064B , 0x81318735},
{ 0x064C , 0x81318736},
{ 0x064D , 0x81318737},
{ 0x064E , 0x81318738},
{ 0x064F , 0x81318739},
{ 0x0650 , 0x81318830},
{ 0x0651 , 0x81318831},
{ 0x0652 , 0x81318832},
{ 0x0653 , 0x81318833},
{ 0x0654 , 0x81318834},
{ 0x0655 , 0x81318835},
{ 0x0656 , 0x81318836},
{ 0x0657 , 0x81318837},
{ 0x0658 , 0x81318838},
{ 0x0659 , 0x81318839},
{ 0x065A , 0x81318930},
{ 0x065B , 0x81318931},
{ 0x065C , 0x81318932},
{ 0x065D , 0x81318933},
{ 0x065E , 0x81318934},
{ 0x065F , 0x81318935},
{ 0x0660 , 0x81318936},
{ 0x0661 , 0x81318937},
{ 0x0662 , 0x81318938},
{ 0x0663 , 0x81318939},
{ 0x0664 , 0x81318A30},
{ 0x0665 , 0x81318A31},
{ 0x0666 , 0x81318A32},
{ 0x0667 , 0x81318A33},
{ 0x0668 , 0x81318A34},
{ 0x0669 , 0x81318A35},
{ 0x066A , 0x81318A36},
{ 0x066B , 0x81318A37},
{ 0x066C , 0x81318A38},
{ 0x066D , 0x81318A39},
{ 0x066E , 0x81318B30},
{ 0x066F , 0x81318B31},
{ 0x0670 , 0x81318B32},
{ 0x0671 , 0x81318B33},
{ 0x0672 , 0x81318B34},
{ 0x0673 , 0x81318B35},
{ 0x0674 , 0x81318B36},
{ 0x0675 , 0x81318B37},
{ 0x0676 , 0x81318B38},
{ 0x0677 , 0x81318B39},
{ 0x0678 , 0x81318C30},
{ 0x0679 , 0x81318C31},
{ 0x067A , 0x81318C32},
{ 0x067B , 0x81318C33},
{ 0x067C , 0x81318C34},
{ 0x067D , 0x81318C35},
{ 0x067E , 0x81318C36},
{ 0x067F , 0x81318C37},
{ 0x0680 , 0x81318C38},
{ 0x0681 , 0x81318C39},
{ 0x0682 , 0x81318D30},
{ 0x0683 , 0x81318D31},
{ 0x0684 , 0x81318D32},
{ 0x0685 , 0x81318D33},
{ 0x0686 , 0x81318D34},
{ 0x0687 , 0x81318D35},
{ 0x0688 , 0x81318D36},
{ 0x0689 , 0x81318D37},
{ 0x068A , 0x81318D38},
{ 0x068B , 0x81318D39},
{ 0x068C , 0x81318E30},
{ 0x068D , 0x81318E31},
{ 0x068E , 0x81318E32},
{ 0x068F , 0x81318E33},
{ 0x0690 , 0x81318E34},
{ 0x0691 , 0x81318E35},
{ 0x0692 , 0x81318E36},
{ 0x0693 , 0x81318E37},
{ 0x0694 , 0x81318E38},
{ 0x0695 , 0x81318E39},
{ 0x0696 , 0x81318F30},
{ 0x0697 , 0x81318F31},
{ 0x0698 , 0x81318F32},
{ 0x0699 , 0x81318F33},
{ 0x069A , 0x81318F34},
{ 0x069B , 0x81318F35},
{ 0x069C , 0x81318F36},
{ 0x069D , 0x81318F37},
{ 0x069E , 0x81318F38},
{ 0x069F , 0x81318F39},
{ 0x06A0 , 0x81319030},
{ 0x06A1 , 0x81319031},
{ 0x06A2 , 0x81319032},
{ 0x06A3 , 0x81319033},
{ 0x06A4 , 0x81319034},
{ 0x06A5 , 0x81319035},
{ 0x06A6 , 0x81319036},
{ 0x06A7 , 0x81319037},
{ 0x06A8 , 0x81319038},
{ 0x06A9 , 0x81319039},
{ 0x06AA , 0x81319130},
{ 0x06AB , 0x81319131},
{ 0x06AC , 0x81319132},
{ 0x06AD , 0x81319133},
{ 0x06AE , 0x81319134},
{ 0x06AF , 0x81319135},
{ 0x06B0 , 0x81319136},
{ 0x06B1 , 0x81319137},
{ 0x06B2 , 0x81319138},
{ 0x06B3 , 0x81319139},
{ 0x06B4 , 0x81319230},
{ 0x06B5 , 0x81319231},
{ 0x06B6 , 0x81319232},
{ 0x06B7 , 0x81319233},
{ 0x06B8 , 0x81319234},
{ 0x06B9 , 0x81319235},
{ 0x06BA , 0x81319236},
{ 0x06BB , 0x81319237},
{ 0x06BC , 0x81319238},
{ 0x06BD , 0x81319239},
{ 0x06BE , 0x81319330},
{ 0x06BF , 0x81319331},
{ 0x06C0 , 0x81319332},
{ 0x06C1 , 0x81319333},
{ 0x06C2 , 0x81319334},
{ 0x06C3 , 0x81319335},
{ 0x06C4 , 0x81319336},
{ 0x06C5 , 0x81319337},
{ 0x06C6 , 0x81319338},
{ 0x06C7 , 0x81319339},
{ 0x06C8 , 0x81319430},
{ 0x06C9 , 0x81319431},
{ 0x06CA , 0x81319432},
{ 0x06CB , 0x81319433},
{ 0x06CC , 0x81319434},
{ 0x06CD , 0x81319435},
{ 0x06CE , 0x81319436},
{ 0x06CF , 0x81319437},
{ 0x06D0 , 0x81319438},
{ 0x06D1 , 0x81319439},
{ 0x06D2 , 0x81319530},
{ 0x06D3 , 0x81319531},
{ 0x06D4 , 0x81319532},
{ 0x06D5 , 0x81319533},
{ 0x06D6 , 0x81319534},
{ 0x06D7 , 0x81319535},
{ 0x06D8 , 0x81319536},
{ 0x06D9 , 0x81319537},
{ 0x06DA , 0x81319538},
{ 0x06DB , 0x81319539},
{ 0x06DC , 0x81319630},
{ 0x06DD , 0x81319631},
{ 0x06DE , 0x81319632},
{ 0x06DF , 0x81319633},
{ 0x06E0 , 0x81319634},
{ 0x06E1 , 0x81319635},
{ 0x06E2 , 0x81319636},
{ 0x06E3 , 0x81319637},
{ 0x06E4 , 0x81319638},
{ 0x06E5 , 0x81319639},
{ 0x06E6 , 0x81319730},
{ 0x06E7 , 0x81319731},
{ 0x06E8 , 0x81319732},
{ 0x06E9 , 0x81319733},
{ 0x06EA , 0x81319734},
{ 0x06EB , 0x81319735},
{ 0x06EC , 0x81319736},
{ 0x06ED , 0x81319737},
{ 0x06EE , 0x81319738},
{ 0x06EF , 0x81319739},
{ 0x06F0 , 0x81319830},
{ 0x06F1 , 0x81319831},
{ 0x06F2 , 0x81319832},
{ 0x06F3 , 0x81319833},
{ 0x06F4 , 0x81319834},
{ 0x06F5 , 0x81319835},
{ 0x06F6 , 0x81319836},
{ 0x06F7 , 0x81319837},
{ 0x06F8 , 0x81319838},
{ 0x06F9 , 0x81319839},
{ 0x06FA , 0x81319930},
{ 0x06FB , 0x81319931},
{ 0x06FC , 0x81319932},
{ 0x06FD , 0x81319933},
{ 0x06FE , 0x81319934},
{ 0x06FF , 0x81319935},
{ 0x0700 , 0x81319936},
{ 0x0701 , 0x81319937},
{ 0x0702 , 0x81319938},
{ 0x0703 , 0x81319939},
{ 0x0704 , 0x81319A30},
{ 0x0705 , 0x81319A31},
{ 0x0706 , 0x81319A32},
{ 0x0707 , 0x81319A33},
{ 0x0708 , 0x81319A34},
{ 0x0709 , 0x81319A35},
{ 0x070A , 0x81319A36},
{ 0x070B , 0x81319A37},
{ 0x070C , 0x81319A38},
{ 0x070D , 0x81319A39},
{ 0x070E , 0x81319B30},
{ 0x070F , 0x81319B31},
{ 0x0710 , 0x81319B32},
{ 0x0711 , 0x81319B33},
{ 0x0712 , 0x81319B34},
{ 0x0713 , 0x81319B35},
{ 0x0714 , 0x81319B36},
{ 0x0715 , 0x81319B37},
{ 0x0716 , 0x81319B38},
{ 0x0717 , 0x81319B39},
{ 0x0718 , 0x81319C30},
{ 0x0719 , 0x81319C31},
{ 0x071A , 0x81319C32},
{ 0x071B , 0x81319C33},
{ 0x071C , 0x81319C34},
{ 0x071D , 0x81319C35},
{ 0x071E , 0x81319C36},
{ 0x071F , 0x81319C37},
{ 0x0720 , 0x81319C38},
{ 0x0721 , 0x81319C39},
{ 0x0722 , 0x81319D30},
{ 0x0723 , 0x81319D31},
{ 0x0724 , 0x81319D32},
{ 0x0725 , 0x81319D33},
{ 0x0726 , 0x81319D34},
{ 0x0727 , 0x81319D35},
{ 0x0728 , 0x81319D36},
{ 0x0729 , 0x81319D37},
{ 0x072A , 0x81319D38},
{ 0x072B , 0x81319D39},
{ 0x072C , 0x81319E30},
{ 0x072D , 0x81319E31},
{ 0x072E , 0x81319E32},
{ 0x072F , 0x81319E33},
{ 0x0730 , 0x81319E34},
{ 0x0731 , 0x81319E35},
{ 0x0732 , 0x81319E36},
{ 0x0733 , 0x81319E37},
{ 0x0734 , 0x81319E38},
{ 0x0735 , 0x81319E39},
{ 0x0736 , 0x81319F30},
{ 0x0737 , 0x81319F31},
{ 0x0738 , 0x81319F32},
{ 0x0739 , 0x81319F33},
{ 0x073A , 0x81319F34},
{ 0x073B , 0x81319F35},
{ 0x073C , 0x81319F36},
{ 0x073D , 0x81319F37},
{ 0x073E , 0x81319F38},
{ 0x073F , 0x81319F39},
{ 0x0740 , 0x8131A030},
{ 0x0741 , 0x8131A031},
{ 0x0742 , 0x8131A032},
{ 0x0743 , 0x8131A033},
{ 0x0744 , 0x8131A034},
{ 0x0745 , 0x8131A035},
{ 0x0746 , 0x8131A036},
{ 0x0747 , 0x8131A037},
{ 0x0748 , 0x8131A038},
{ 0x0749 , 0x8131A039},
{ 0x074A , 0x8131A130},
{ 0x074B , 0x8131A131},
{ 0x074C , 0x8131A132},
{ 0x074D , 0x8131A133},
{ 0x074E , 0x8131A134},
{ 0x074F , 0x8131A135},
{ 0x0750 , 0x8131A136},
{ 0x0751 , 0x8131A137},
{ 0x0752 , 0x8131A138},
{ 0x0753 , 0x8131A139},
{ 0x0754 , 0x8131A230},
{ 0x0755 , 0x8131A231},
{ 0x0756 , 0x8131A232},
{ 0x0757 , 0x8131A233},
{ 0x0758 , 0x8131A234},
{ 0x0759 , 0x8131A235},
{ 0x075A , 0x8131A236},
{ 0x075B , 0x8131A237},
{ 0x075C , 0x8131A238},
{ 0x075D , 0x8131A239},
{ 0x075E , 0x8131A330},
{ 0x075F , 0x8131A331},
{ 0x0760 , 0x8131A332},
{ 0x0761 , 0x8131A333},
{ 0x0762 , 0x8131A334},
{ 0x0763 , 0x8131A335},
{ 0x0764 , 0x8131A336},
{ 0x0765 , 0x8131A337},
{ 0x0766 , 0x8131A338},
{ 0x0767 , 0x8131A339},
{ 0x0768 , 0x8131A430},
{ 0x0769 , 0x8131A431},
{ 0x076A , 0x8131A432},
{ 0x076B , 0x8131A433},
{ 0x076C , 0x8131A434},
{ 0x076D , 0x8131A435},
{ 0x076E , 0x8131A436},
{ 0x076F , 0x8131A437},
{ 0x0770 , 0x8131A438},
{ 0x0771 , 0x8131A439},
{ 0x0772 , 0x8131A530},
{ 0x0773 , 0x8131A531},
{ 0x0774 , 0x8131A532},
{ 0x0775 , 0x8131A533},
{ 0x0776 , 0x8131A534},
{ 0x0777 , 0x8131A535},
{ 0x0778 , 0x8131A536},
{ 0x0779 , 0x8131A537},
{ 0x077A , 0x8131A538},
{ 0x077B , 0x8131A539},
{ 0x077C , 0x8131A630},
{ 0x077D , 0x8131A631},
{ 0x077E , 0x8131A632},
{ 0x077F , 0x8131A633},
{ 0x0780 , 0x8131A634},
{ 0x0781 , 0x8131A635},
{ 0x0782 , 0x8131A636},
{ 0x0783 , 0x8131A637},
{ 0x0784 , 0x8131A638},
{ 0x0785 , 0x8131A639},
{ 0x0786 , 0x8131A730},
{ 0x0787 , 0x8131A731},
{ 0x0788 , 0x8131A732},
{ 0x0789 , 0x8131A733},
{ 0x078A , 0x8131A734},
{ 0x078B , 0x8131A735},
{ 0x078C , 0x8131A736},
{ 0x078D , 0x8131A737},
{ 0x078E , 0x8131A738},
{ 0x078F , 0x8131A739},
{ 0x0790 , 0x8131A830},
{ 0x0791 , 0x8131A831},
{ 0x0792 , 0x8131A832},
{ 0x0793 , 0x8131A833},
{ 0x0794 , 0x8131A834},
{ 0x0795 , 0x8131A835},
{ 0x0796 , 0x8131A836},
{ 0x0797 , 0x8131A837},
{ 0x0798 , 0x8131A838},
{ 0x0799 , 0x8131A839},
{ 0x079A , 0x8131A930},
{ 0x079B , 0x8131A931},
{ 0x079C , 0x8131A932},
{ 0x079D , 0x8131A933},
{ 0x079E , 0x8131A934},
{ 0x079F , 0x8131A935},
{ 0x07A0 , 0x8131A936},
{ 0x07A1 , 0x8131A937},
{ 0x07A2 , 0x8131A938},
{ 0x07A3 , 0x8131A939},
{ 0x07A4 , 0x8131AA30},
{ 0x07A5 , 0x8131AA31},
{ 0x07A6 , 0x8131AA32},
{ 0x07A7 , 0x8131AA33},
{ 0x07A8 , 0x8131AA34},
{ 0x07A9 , 0x8131AA35},
{ 0x07AA , 0x8131AA36},
{ 0x07AB , 0x8131AA37},
{ 0x07AC , 0x8131AA38},
{ 0x07AD , 0x8131AA39},
{ 0x07AE , 0x8131AB30},
{ 0x07AF , 0x8131AB31},
{ 0x07B0 , 0x8131AB32},
{ 0x07B1 , 0x8131AB33},
{ 0x07B2 , 0x8131AB34},
{ 0x07B3 , 0x8131AB35},
{ 0x07B4 , 0x8131AB36},
{ 0x07B5 , 0x8131AB37},
{ 0x07B6 , 0x8131AB38},
{ 0x07B7 , 0x8131AB39},
{ 0x07B8 , 0x8131AC30},
{ 0x07B9 , 0x8131AC31},
{ 0x07BA , 0x8131AC32},
{ 0x07BB , 0x8131AC33},
{ 0x07BC , 0x8131AC34},
{ 0x07BD , 0x8131AC35},
{ 0x07BE , 0x8131AC36},
{ 0x07BF , 0x8131AC37},
{ 0x07C0 , 0x8131AC38},
{ 0x07C1 , 0x8131AC39},
{ 0x07C2 , 0x8131AD30},
{ 0x07C3 , 0x8131AD31},
{ 0x07C4 , 0x8131AD32},
{ 0x07C5 , 0x8131AD33},
{ 0x07C6 , 0x8131AD34},
{ 0x07C7 , 0x8131AD35},
{ 0x07C8 , 0x8131AD36},
{ 0x07C9 , 0x8131AD37},
{ 0x07CA , 0x8131AD38},
{ 0x07CB , 0x8131AD39},
{ 0x07CC , 0x8131AE30},
{ 0x07CD , 0x8131AE31},
{ 0x07CE , 0x8131AE32},
{ 0x07CF , 0x8131AE33},
{ 0x07D0 , 0x8131AE34},
{ 0x07D1 , 0x8131AE35},
{ 0x07D2 , 0x8131AE36},
{ 0x07D3 , 0x8131AE37},
{ 0x07D4 , 0x8131AE38},
{ 0x07D5 , 0x8131AE39},
{ 0x07D6 , 0x8131AF30},
{ 0x07D7 , 0x8131AF31},
{ 0x07D8 , 0x8131AF32},
{ 0x07D9 , 0x8131AF33},
{ 0x07DA , 0x8131AF34},
{ 0x07DB , 0x8131AF35},
{ 0x07DC , 0x8131AF36},
{ 0x07DD , 0x8131AF37},
{ 0x07DE , 0x8131AF38},
{ 0x07DF , 0x8131AF39},
{ 0x07E0 , 0x8131B030},
{ 0x07E1 , 0x8131B031},
{ 0x07E2 , 0x8131B032},
{ 0x07E3 , 0x8131B033},
{ 0x07E4 , 0x8131B034},
{ 0x07E5 , 0x8131B035},
{ 0x07E6 , 0x8131B036},
{ 0x07E7 , 0x8131B037},
{ 0x07E8 , 0x8131B038},
{ 0x07E9 , 0x8131B039},
{ 0x07EA , 0x8131B130},
{ 0x07EB , 0x8131B131},
{ 0x07EC , 0x8131B132},
{ 0x07ED , 0x8131B133},
{ 0x07EE , 0x8131B134},
{ 0x07EF , 0x8131B135},
{ 0x07F0 , 0x8131B136},
{ 0x07F1 , 0x8131B137},
{ 0x07F2 , 0x8131B138},
{ 0x07F3 , 0x8131B139},
{ 0x07F4 , 0x8131B230},
{ 0x07F5 , 0x8131B231},
{ 0x07F6 , 0x8131B232},
{ 0x07F7 , 0x8131B233},
{ 0x07F8 , 0x8131B234},
{ 0x07F9 , 0x8131B235},
{ 0x07FA , 0x8131B236},
{ 0x07FB , 0x8131B237},
{ 0x07FC , 0x8131B238},
{ 0x07FD , 0x8131B239},
{ 0x07FE , 0x8131B330},
{ 0x07FF , 0x8131B331},
{ 0x0800 , 0x8131B332},
{ 0x0801 , 0x8131B333},
{ 0x0802 , 0x8131B334},
{ 0x0803 , 0x8131B335},
{ 0x0804 , 0x8131B336},
{ 0x0805 , 0x8131B337},
{ 0x0806 , 0x8131B338},
{ 0x0807 , 0x8131B339},
{ 0x0808 , 0x8131B430},
{ 0x0809 , 0x8131B431},
{ 0x080A , 0x8131B432},
{ 0x080B , 0x8131B433},
{ 0x080C , 0x8131B434},
{ 0x080D , 0x8131B435},
{ 0x080E , 0x8131B436},
{ 0x080F , 0x8131B437},
{ 0x0810 , 0x8131B438},
{ 0x0811 , 0x8131B439},
{ 0x0812 , 0x8131B530},
{ 0x0813 , 0x8131B531},
{ 0x0814 , 0x8131B532},
{ 0x0815 , 0x8131B533},
{ 0x0816 , 0x8131B534},
{ 0x0817 , 0x8131B535},
{ 0x0818 , 0x8131B536},
{ 0x0819 , 0x8131B537},
{ 0x081A , 0x8131B538},
{ 0x081B , 0x8131B539},
{ 0x081C , 0x8131B630},
{ 0x081D , 0x8131B631},
{ 0x081E , 0x8131B632},
{ 0x081F , 0x8131B633},
{ 0x0820 , 0x8131B634},
{ 0x0821 , 0x8131B635},
{ 0x0822 , 0x8131B636},
{ 0x0823 , 0x8131B637},
{ 0x0824 , 0x8131B638},
{ 0x0825 , 0x8131B639},
{ 0x0826 , 0x8131B730},
{ 0x0827 , 0x8131B731},
{ 0x0828 , 0x8131B732},
{ 0x0829 , 0x8131B733},
{ 0x082A , 0x8131B734},
{ 0x082B , 0x8131B735},
{ 0x082C , 0x8131B736},
{ 0x082D , 0x8131B737},
{ 0x082E , 0x8131B738},
{ 0x082F , 0x8131B739},
{ 0x0830 , 0x8131B830},
{ 0x0831 , 0x8131B831},
{ 0x0832 , 0x8131B832},
{ 0x0833 , 0x8131B833},
{ 0x0834 , 0x8131B834},
{ 0x0835 , 0x8131B835},
{ 0x0836 , 0x8131B836},
{ 0x0837 , 0x8131B837},
{ 0x0838 , 0x8131B838},
{ 0x0839 , 0x8131B839},
{ 0x083A , 0x8131B930},
{ 0x083B , 0x8131B931},
{ 0x083C , 0x8131B932},
{ 0x083D , 0x8131B933},
{ 0x083E , 0x8131B934},
{ 0x083F , 0x8131B935},
{ 0x0840 , 0x8131B936},
{ 0x0841 , 0x8131B937},
{ 0x0842 , 0x8131B938},
{ 0x0843 , 0x8131B939},
{ 0x0844 , 0x8131BA30},
{ 0x0845 , 0x8131BA31},
{ 0x0846 , 0x8131BA32},
{ 0x0847 , 0x8131BA33},
{ 0x0848 , 0x8131BA34},
{ 0x0849 , 0x8131BA35},
{ 0x084A , 0x8131BA36},
{ 0x084B , 0x8131BA37},
{ 0x084C , 0x8131BA38},
{ 0x084D , 0x8131BA39},
{ 0x084E , 0x8131BB30},
{ 0x084F , 0x8131BB31},
{ 0x0850 , 0x8131BB32},
{ 0x0851 , 0x8131BB33},
{ 0x0852 , 0x8131BB34},
{ 0x0853 , 0x8131BB35},
{ 0x0854 , 0x8131BB36},
{ 0x0855 , 0x8131BB37},
{ 0x0856 , 0x8131BB38},
{ 0x0857 , 0x8131BB39},
{ 0x0858 , 0x8131BC30},
{ 0x0859 , 0x8131BC31},
{ 0x085A , 0x8131BC32},
{ 0x085B , 0x8131BC33},
{ 0x085C , 0x8131BC34},
{ 0x085D , 0x8131BC35},
{ 0x085E , 0x8131BC36},
{ 0x085F , 0x8131BC37},
{ 0x0860 , 0x8131BC38},
{ 0x0861 , 0x8131BC39},
{ 0x0862 , 0x8131BD30},
{ 0x0863 , 0x8131BD31},
{ 0x0864 , 0x8131BD32},
{ 0x0865 , 0x8131BD33},
{ 0x0866 , 0x8131BD34},
{ 0x0867 , 0x8131BD35},
{ 0x0868 , 0x8131BD36},
{ 0x0869 , 0x8131BD37},
{ 0x086A , 0x8131BD38},
{ 0x086B , 0x8131BD39},
{ 0x086C , 0x8131BE30},
{ 0x086D , 0x8131BE31},
{ 0x086E , 0x8131BE32},
{ 0x086F , 0x8131BE33},
{ 0x0870 , 0x8131BE34},
{ 0x0871 , 0x8131BE35},
{ 0x0872 , 0x8131BE36},
{ 0x0873 , 0x8131BE37},
{ 0x0874 , 0x8131BE38},
{ 0x0875 , 0x8131BE39},
{ 0x0876 , 0x8131BF30},
{ 0x0877 , 0x8131BF31},
{ 0x0878 , 0x8131BF32},
{ 0x0879 , 0x8131BF33},
{ 0x087A , 0x8131BF34},
{ 0x087B , 0x8131BF35},
{ 0x087C , 0x8131BF36},
{ 0x087D , 0x8131BF37},
{ 0x087E , 0x8131BF38},
{ 0x087F , 0x8131BF39},
{ 0x0880 , 0x8131C030},
{ 0x0881 , 0x8131C031},
{ 0x0882 , 0x8131C032},
{ 0x0883 , 0x8131C033},
{ 0x0884 , 0x8131C034},
{ 0x0885 , 0x8131C035},
{ 0x0886 , 0x8131C036},
{ 0x0887 , 0x8131C037},
{ 0x0888 , 0x8131C038},
{ 0x0889 , 0x8131C039},
{ 0x088A , 0x8131C130},
{ 0x088B , 0x8131C131},
{ 0x088C , 0x8131C132},
{ 0x088D , 0x8131C133},
{ 0x088E , 0x8131C134},
{ 0x088F , 0x8131C135},
{ 0x0890 , 0x8131C136},
{ 0x0891 , 0x8131C137},
{ 0x0892 , 0x8131C138},
{ 0x0893 , 0x8131C139},
{ 0x0894 , 0x8131C230},
{ 0x0895 , 0x8131C231},
{ 0x0896 , 0x8131C232},
{ 0x0897 , 0x8131C233},
{ 0x0898 , 0x8131C234},
{ 0x0899 , 0x8131C235},
{ 0x089A , 0x8131C236},
{ 0x089B , 0x8131C237},
{ 0x089C , 0x8131C238},
{ 0x089D , 0x8131C239},
{ 0x089E , 0x8131C330},
{ 0x089F , 0x8131C331},
{ 0x08A0 , 0x8131C332},
{ 0x08A1 , 0x8131C333},
{ 0x08A2 , 0x8131C334},
{ 0x08A3 , 0x8131C335},
{ 0x08A4 , 0x8131C336},
{ 0x08A5 , 0x8131C337},
{ 0x08A6 , 0x8131C338},
{ 0x08A7 , 0x8131C339},
{ 0x08A8 , 0x8131C430},
{ 0x08A9 , 0x8131C431},
{ 0x08AA , 0x8131C432},
{ 0x08AB , 0x8131C433},
{ 0x08AC , 0x8131C434},
{ 0x08AD , 0x8131C435},
{ 0x08AE , 0x8131C436},
{ 0x08AF , 0x8131C437},
{ 0x08B0 , 0x8131C438},
{ 0x08B1 , 0x8131C439},
{ 0x08B2 , 0x8131C530},
{ 0x08B3 , 0x8131C531},
{ 0x08B4 , 0x8131C532},
{ 0x08B5 , 0x8131C533},
{ 0x08B6 , 0x8131C534},
{ 0x08B7 , 0x8131C535},
{ 0x08B8 , 0x8131C536},
{ 0x08B9 , 0x8131C537},
{ 0x08BA , 0x8131C538},
{ 0x08BB , 0x8131C539},
{ 0x08BC , 0x8131C630},
{ 0x08BD , 0x8131C631},
{ 0x08BE , 0x8131C632},
{ 0x08BF , 0x8131C633},
{ 0x08C0 , 0x8131C634},
{ 0x08C1 , 0x8131C635},
{ 0x08C2 , 0x8131C636},
{ 0x08C3 , 0x8131C637},
{ 0x08C4 , 0x8131C638},
{ 0x08C5 , 0x8131C639},
{ 0x08C6 , 0x8131C730},
{ 0x08C7 , 0x8131C731},
{ 0x08C8 , 0x8131C732},
{ 0x08C9 , 0x8131C733},
{ 0x08CA , 0x8131C734},
{ 0x08CB , 0x8131C735},
{ 0x08CC , 0x8131C736},
{ 0x08CD , 0x8131C737},
{ 0x08CE , 0x8131C738},
{ 0x08CF , 0x8131C739},
{ 0x08D0 , 0x8131C830},
{ 0x08D1 , 0x8131C831},
{ 0x08D2 , 0x8131C832},
{ 0x08D3 , 0x8131C833},
{ 0x08D4 , 0x8131C834},
{ 0x08D5 , 0x8131C835},
{ 0x08D6 , 0x8131C836},
{ 0x08D7 , 0x8131C837},
{ 0x08D8 , 0x8131C838},
{ 0x08D9 , 0x8131C839},
{ 0x08DA , 0x8131C930},
{ 0x08DB , 0x8131C931},
{ 0x08DC , 0x8131C932},
{ 0x08DD , 0x8131C933},
{ 0x08DE , 0x8131C934},
{ 0x08DF , 0x8131C935},
{ 0x08E0 , 0x8131C936},
{ 0x08E1 , 0x8131C937},
{ 0x08E2 , 0x8131C938},
{ 0x08E3 , 0x8131C939},
{ 0x08E4 , 0x8131CA30},
{ 0x08E5 , 0x8131CA31},
{ 0x08E6 , 0x8131CA32},
{ 0x08E7 , 0x8131CA33},
{ 0x08E8 , 0x8131CA34},
{ 0x08E9 , 0x8131CA35},
{ 0x08EA , 0x8131CA36},
{ 0x08EB , 0x8131CA37},
{ 0x08EC , 0x8131CA38},
{ 0x08ED , 0x8131CA39},
{ 0x08EE , 0x8131CB30},
{ 0x08EF , 0x8131CB31},
{ 0x08F0 , 0x8131CB32},
{ 0x08F1 , 0x8131CB33},
{ 0x08F2 , 0x8131CB34},
{ 0x08F3 , 0x8131CB35},
{ 0x08F4 , 0x8131CB36},
{ 0x08F5 , 0x8131CB37},
{ 0x08F6 , 0x8131CB38},
{ 0x08F7 , 0x8131CB39},
{ 0x08F8 , 0x8131CC30},
{ 0x08F9 , 0x8131CC31},
{ 0x08FA , 0x8131CC32},
{ 0x08FB , 0x8131CC33},
{ 0x08FC , 0x8131CC34},
{ 0x08FD , 0x8131CC35},
{ 0x08FE , 0x8131CC36},
{ 0x08FF , 0x8131CC37},
{ 0x0900 , 0x8131CC38},
{ 0x0901 , 0x8131CC39},
{ 0x0902 , 0x8131CD30},
{ 0x0903 , 0x8131CD31},
{ 0x0904 , 0x8131CD32},
{ 0x0905 , 0x8131CD33},
{ 0x0906 , 0x8131CD34},
{ 0x0907 , 0x8131CD35},
{ 0x0908 , 0x8131CD36},
{ 0x0909 , 0x8131CD37},
{ 0x090A , 0x8131CD38},
{ 0x090B , 0x8131CD39},
{ 0x090C , 0x8131CE30},
{ 0x090D , 0x8131CE31},
{ 0x090E , 0x8131CE32},
{ 0x090F , 0x8131CE33},
{ 0x0910 , 0x8131CE34},
{ 0x0911 , 0x8131CE35},
{ 0x0912 , 0x8131CE36},
{ 0x0913 , 0x8131CE37},
{ 0x0914 , 0x8131CE38},
{ 0x0915 , 0x8131CE39},
{ 0x0916 , 0x8131CF30},
{ 0x0917 , 0x8131CF31},
{ 0x0918 , 0x8131CF32},
{ 0x0919 , 0x8131CF33},
{ 0x091A , 0x8131CF34},
{ 0x091B , 0x8131CF35},
{ 0x091C , 0x8131CF36},
{ 0x091D , 0x8131CF37},
{ 0x091E , 0x8131CF38},
{ 0x091F , 0x8131CF39},
{ 0x0920 , 0x8131D030},
{ 0x0921 , 0x8131D031},
{ 0x0922 , 0x8131D032},
{ 0x0923 , 0x8131D033},
{ 0x0924 , 0x8131D034},
{ 0x0925 , 0x8131D035},
{ 0x0926 , 0x8131D036},
{ 0x0927 , 0x8131D037},
{ 0x0928 , 0x8131D038},
{ 0x0929 , 0x8131D039},
{ 0x092A , 0x8131D130},
{ 0x092B , 0x8131D131},
{ 0x092C , 0x8131D132},
{ 0x092D , 0x8131D133},
{ 0x092E , 0x8131D134},
{ 0x092F , 0x8131D135},
{ 0x0930 , 0x8131D136},
{ 0x0931 , 0x8131D137},
{ 0x0932 , 0x8131D138},
{ 0x0933 , 0x8131D139},
{ 0x0934 , 0x8131D230},
{ 0x0935 , 0x8131D231},
{ 0x0936 , 0x8131D232},
{ 0x0937 , 0x8131D233},
{ 0x0938 , 0x8131D234},
{ 0x0939 , 0x8131D235},
{ 0x093A , 0x8131D236},
{ 0x093B , 0x8131D237},
{ 0x093C , 0x8131D238},
{ 0x093D , 0x8131D239},
{ 0x093E , 0x8131D330},
{ 0x093F , 0x8131D331},
{ 0x0940 , 0x8131D332},
{ 0x0941 , 0x8131D333},
{ 0x0942 , 0x8131D334},
{ 0x0943 , 0x8131D335},
{ 0x0944 , 0x8131D336},
{ 0x0945 , 0x8131D337},
{ 0x0946 , 0x8131D338},
{ 0x0947 , 0x8131D339},
{ 0x0948 , 0x8131D430},
{ 0x0949 , 0x8131D431},
{ 0x094A , 0x8131D432},
{ 0x094B , 0x8131D433},
{ 0x094C , 0x8131D434},
{ 0x094D , 0x8131D435},
{ 0x094E , 0x8131D436},
{ 0x094F , 0x8131D437},
{ 0x0950 , 0x8131D438},
{ 0x0951 , 0x8131D439},
{ 0x0952 , 0x8131D530},
{ 0x0953 , 0x8131D531},
{ 0x0954 , 0x8131D532},
{ 0x0955 , 0x8131D533},
{ 0x0956 , 0x8131D534},
{ 0x0957 , 0x8131D535},
{ 0x0958 , 0x8131D536},
{ 0x0959 , 0x8131D537},
{ 0x095A , 0x8131D538},
{ 0x095B , 0x8131D539},
{ 0x095C , 0x8131D630},
{ 0x095D , 0x8131D631},
{ 0x095E , 0x8131D632},
{ 0x095F , 0x8131D633},
{ 0x0960 , 0x8131D634},
{ 0x0961 , 0x8131D635},
{ 0x0962 , 0x8131D636},
{ 0x0963 , 0x8131D637},
{ 0x0964 , 0x8131D638},
{ 0x0965 , 0x8131D639},
{ 0x0966 , 0x8131D730},
{ 0x0967 , 0x8131D731},
{ 0x0968 , 0x8131D732},
{ 0x0969 , 0x8131D733},
{ 0x096A , 0x8131D734},
{ 0x096B , 0x8131D735},
{ 0x096C , 0x8131D736},
{ 0x096D , 0x8131D737},
{ 0x096E , 0x8131D738},
{ 0x096F , 0x8131D739},
{ 0x0970 , 0x8131D830},
{ 0x0971 , 0x8131D831},
{ 0x0972 , 0x8131D832},
{ 0x0973 , 0x8131D833},
{ 0x0974 , 0x8131D834},
{ 0x0975 , 0x8131D835},
{ 0x0976 , 0x8131D836},
{ 0x0977 , 0x8131D837},
{ 0x0978 , 0x8131D838},
{ 0x0979 , 0x8131D839},
{ 0x097A , 0x8131D930},
{ 0x097B , 0x8131D931},
{ 0x097C , 0x8131D932},
{ 0x097D , 0x8131D933},
{ 0x097E , 0x8131D934},
{ 0x097F , 0x8131D935},
{ 0x0980 , 0x8131D936},
{ 0x0981 , 0x8131D937},
{ 0x0982 , 0x8131D938},
{ 0x0983 , 0x8131D939},
{ 0x0984 , 0x8131DA30},
{ 0x0985 , 0x8131DA31},
{ 0x0986 , 0x8131DA32},
{ 0x0987 , 0x8131DA33},
{ 0x0988 , 0x8131DA34},
{ 0x0989 , 0x8131DA35},
{ 0x098A , 0x8131DA36},
{ 0x098B , 0x8131DA37},
{ 0x098C , 0x8131DA38},
{ 0x098D , 0x8131DA39},
{ 0x098E , 0x8131DB30},
{ 0x098F , 0x8131DB31},
{ 0x0990 , 0x8131DB32},
{ 0x0991 , 0x8131DB33},
{ 0x0992 , 0x8131DB34},
{ 0x0993 , 0x8131DB35},
{ 0x0994 , 0x8131DB36},
{ 0x0995 , 0x8131DB37},
{ 0x0996 , 0x8131DB38},
{ 0x0997 , 0x8131DB39},
{ 0x0998 , 0x8131DC30},
{ 0x0999 , 0x8131DC31},
{ 0x099A , 0x8131DC32},
{ 0x099B , 0x8131DC33},
{ 0x099C , 0x8131DC34},
{ 0x099D , 0x8131DC35},
{ 0x099E , 0x8131DC36},
{ 0x099F , 0x8131DC37},
{ 0x09A0 , 0x8131DC38},
{ 0x09A1 , 0x8131DC39},
{ 0x09A2 , 0x8131DD30},
{ 0x09A3 , 0x8131DD31},
{ 0x09A4 , 0x8131DD32},
{ 0x09A5 , 0x8131DD33},
{ 0x09A6 , 0x8131DD34},
{ 0x09A7 , 0x8131DD35},
{ 0x09A8 , 0x8131DD36},
{ 0x09A9 , 0x8131DD37},
{ 0x09AA , 0x8131DD38},
{ 0x09AB , 0x8131DD39},
{ 0x09AC , 0x8131DE30},
{ 0x09AD , 0x8131DE31},
{ 0x09AE , 0x8131DE32},
{ 0x09AF , 0x8131DE33},
{ 0x09B0 , 0x8131DE34},
{ 0x09B1 , 0x8131DE35},
{ 0x09B2 , 0x8131DE36},
{ 0x09B3 , 0x8131DE37},
{ 0x09B4 , 0x8131DE38},
{ 0x09B5 , 0x8131DE39},
{ 0x09B6 , 0x8131DF30},
{ 0x09B7 , 0x8131DF31},
{ 0x09B8 , 0x8131DF32},
{ 0x09B9 , 0x8131DF33},
{ 0x09BA , 0x8131DF34},
{ 0x09BB , 0x8131DF35},
{ 0x09BC , 0x8131DF36},
{ 0x09BD , 0x8131DF37},
{ 0x09BE , 0x8131DF38},
{ 0x09BF , 0x8131DF39},
{ 0x09C0 , 0x8131E030},
{ 0x09C1 , 0x8131E031},
{ 0x09C2 , 0x8131E032},
{ 0x09C3 , 0x8131E033},
{ 0x09C4 , 0x8131E034},
{ 0x09C5 , 0x8131E035},
{ 0x09C6 , 0x8131E036},
{ 0x09C7 , 0x8131E037},
{ 0x09C8 , 0x8131E038},
{ 0x09C9 , 0x8131E039},
{ 0x09CA , 0x8131E130},
{ 0x09CB , 0x8131E131},
{ 0x09CC , 0x8131E132},
{ 0x09CD , 0x8131E133},
{ 0x09CE , 0x8131E134},
{ 0x09CF , 0x8131E135},
{ 0x09D0 , 0x8131E136},
{ 0x09D1 , 0x8131E137},
{ 0x09D2 , 0x8131E138},
{ 0x09D3 , 0x8131E139},
{ 0x09D4 , 0x8131E230},
{ 0x09D5 , 0x8131E231},
{ 0x09D6 , 0x8131E232},
{ 0x09D7 , 0x8131E233},
{ 0x09D8 , 0x8131E234},
{ 0x09D9 , 0x8131E235},
{ 0x09DA , 0x8131E236},
{ 0x09DB , 0x8131E237},
{ 0x09DC , 0x8131E238},
{ 0x09DD , 0x8131E239},
{ 0x09DE , 0x8131E330},
{ 0x09DF , 0x8131E331},
{ 0x09E0 , 0x8131E332},
{ 0x09E1 , 0x8131E333},
{ 0x09E2 , 0x8131E334},
{ 0x09E3 , 0x8131E335},
{ 0x09E4 , 0x8131E336},
{ 0x09E5 , 0x8131E337},
{ 0x09E6 , 0x8131E338},
{ 0x09E7 , 0x8131E339},
{ 0x09E8 , 0x8131E430},
{ 0x09E9 , 0x8131E431},
{ 0x09EA , 0x8131E432},
{ 0x09EB , 0x8131E433},
{ 0x09EC , 0x8131E434},
{ 0x09ED , 0x8131E435},
{ 0x09EE , 0x8131E436},
{ 0x09EF , 0x8131E437},
{ 0x09F0 , 0x8131E438},
{ 0x09F1 , 0x8131E439},
{ 0x09F2 , 0x8131E530},
{ 0x09F3 , 0x8131E531},
{ 0x09F4 , 0x8131E532},
{ 0x09F5 , 0x8131E533},
{ 0x09F6 , 0x8131E534},
{ 0x09F7 , 0x8131E535},
{ 0x09F8 , 0x8131E536},
{ 0x09F9 , 0x8131E537},
{ 0x09FA , 0x8131E538},
{ 0x09FB , 0x8131E539},
{ 0x09FC , 0x8131E630},
{ 0x09FD , 0x8131E631},
{ 0x09FE , 0x8131E632},
{ 0x09FF , 0x8131E633},
{ 0x0A00 , 0x8131E634},
{ 0x0A01 , 0x8131E635},
{ 0x0A02 , 0x8131E636},
{ 0x0A03 , 0x8131E637},
{ 0x0A04 , 0x8131E638},
{ 0x0A05 , 0x8131E639},
{ 0x0A06 , 0x8131E730},
{ 0x0A07 , 0x8131E731},
{ 0x0A08 , 0x8131E732},
{ 0x0A09 , 0x8131E733},
{ 0x0A0A , 0x8131E734},
{ 0x0A0B , 0x8131E735},
{ 0x0A0C , 0x8131E736},
{ 0x0A0D , 0x8131E737},
{ 0x0A0E , 0x8131E738},
{ 0x0A0F , 0x8131E739},
{ 0x0A10 , 0x8131E830},
{ 0x0A11 , 0x8131E831},
{ 0x0A12 , 0x8131E832},
{ 0x0A13 , 0x8131E833},
{ 0x0A14 , 0x8131E834},
{ 0x0A15 , 0x8131E835},
{ 0x0A16 , 0x8131E836},
{ 0x0A17 , 0x8131E837},
{ 0x0A18 , 0x8131E838},
{ 0x0A19 , 0x8131E839},
{ 0x0A1A , 0x8131E930},
{ 0x0A1B , 0x8131E931},
{ 0x0A1C , 0x8131E932},
{ 0x0A1D , 0x8131E933},
{ 0x0A1E , 0x8131E934},
{ 0x0A1F , 0x8131E935},
{ 0x0A20 , 0x8131E936},
{ 0x0A21 , 0x8131E937},
{ 0x0A22 , 0x8131E938},
{ 0x0A23 , 0x8131E939},
{ 0x0A24 , 0x8131EA30},
{ 0x0A25 , 0x8131EA31},
{ 0x0A26 , 0x8131EA32},
{ 0x0A27 , 0x8131EA33},
{ 0x0A28 , 0x8131EA34},
{ 0x0A29 , 0x8131EA35},
{ 0x0A2A , 0x8131EA36},
{ 0x0A2B , 0x8131EA37},
{ 0x0A2C , 0x8131EA38},
{ 0x0A2D , 0x8131EA39},
{ 0x0A2E , 0x8131EB30},
{ 0x0A2F , 0x8131EB31},
{ 0x0A30 , 0x8131EB32},
{ 0x0A31 , 0x8131EB33},
{ 0x0A32 , 0x8131EB34},
{ 0x0A33 , 0x8131EB35},
{ 0x0A34 , 0x8131EB36},
{ 0x0A35 , 0x8131EB37},
{ 0x0A36 , 0x8131EB38},
{ 0x0A37 , 0x8131EB39},
{ 0x0A38 , 0x8131EC30},
{ 0x0A39 , 0x8131EC31},
{ 0x0A3A , 0x8131EC32},
{ 0x0A3B , 0x8131EC33},
{ 0x0A3C , 0x8131EC34},
{ 0x0A3D , 0x8131EC35},
{ 0x0A3E , 0x8131EC36},
{ 0x0A3F , 0x8131EC37},
{ 0x0A40 , 0x8131EC38},
{ 0x0A41 , 0x8131EC39},
{ 0x0A42 , 0x8131ED30},
{ 0x0A43 , 0x8131ED31},
{ 0x0A44 , 0x8131ED32},
{ 0x0A45 , 0x8131ED33},
{ 0x0A46 , 0x8131ED34},
{ 0x0A47 , 0x8131ED35},
{ 0x0A48 , 0x8131ED36},
{ 0x0A49 , 0x8131ED37},
{ 0x0A4A , 0x8131ED38},
{ 0x0A4B , 0x8131ED39},
{ 0x0A4C , 0x8131EE30},
{ 0x0A4D , 0x8131EE31},
{ 0x0A4E , 0x8131EE32},
{ 0x0A4F , 0x8131EE33},
{ 0x0A50 , 0x8131EE34},
{ 0x0A51 , 0x8131EE35},
{ 0x0A52 , 0x8131EE36},
{ 0x0A53 , 0x8131EE37},
{ 0x0A54 , 0x8131EE38},
{ 0x0A55 , 0x8131EE39},
{ 0x0A56 , 0x8131EF30},
{ 0x0A57 , 0x8131EF31},
{ 0x0A58 , 0x8131EF32},
{ 0x0A59 , 0x8131EF33},
{ 0x0A5A , 0x8131EF34},
{ 0x0A5B , 0x8131EF35},
{ 0x0A5C , 0x8131EF36},
{ 0x0A5D , 0x8131EF37},
{ 0x0A5E , 0x8131EF38},
{ 0x0A5F , 0x8131EF39},
{ 0x0A60 , 0x8131F030},
{ 0x0A61 , 0x8131F031},
{ 0x0A62 , 0x8131F032},
{ 0x0A63 , 0x8131F033},
{ 0x0A64 , 0x8131F034},
{ 0x0A65 , 0x8131F035},
{ 0x0A66 , 0x8131F036},
{ 0x0A67 , 0x8131F037},
{ 0x0A68 , 0x8131F038},
{ 0x0A69 , 0x8131F039},
{ 0x0A6A , 0x8131F130},
{ 0x0A6B , 0x8131F131},
{ 0x0A6C , 0x8131F132},
{ 0x0A6D , 0x8131F133},
{ 0x0A6E , 0x8131F134},
{ 0x0A6F , 0x8131F135},
{ 0x0A70 , 0x8131F136},
{ 0x0A71 , 0x8131F137},
{ 0x0A72 , 0x8131F138},
{ 0x0A73 , 0x8131F139},
{ 0x0A74 , 0x8131F230},
{ 0x0A75 , 0x8131F231},
{ 0x0A76 , 0x8131F232},
{ 0x0A77 , 0x8131F233},
{ 0x0A78 , 0x8131F234},
{ 0x0A79 , 0x8131F235},
{ 0x0A7A , 0x8131F236},
{ 0x0A7B , 0x8131F237},
{ 0x0A7C , 0x8131F238},
{ 0x0A7D , 0x8131F239},
{ 0x0A7E , 0x8131F330},
{ 0x0A7F , 0x8131F331},
{ 0x0A80 , 0x8131F332},
{ 0x0A81 , 0x8131F333},
{ 0x0A82 , 0x8131F334},
{ 0x0A83 , 0x8131F335},
{ 0x0A84 , 0x8131F336},
{ 0x0A85 , 0x8131F337},
{ 0x0A86 , 0x8131F338},
{ 0x0A87 , 0x8131F339},
{ 0x0A88 , 0x8131F430},
{ 0x0A89 , 0x8131F431},
{ 0x0A8A , 0x8131F432},
{ 0x0A8B , 0x8131F433},
{ 0x0A8C , 0x8131F434},
{ 0x0A8D , 0x8131F435},
{ 0x0A8E , 0x8131F436},
{ 0x0A8F , 0x8131F437},
{ 0x0A90 , 0x8131F438},
{ 0x0A91 , 0x8131F439},
{ 0x0A92 , 0x8131F530},
{ 0x0A93 , 0x8131F531},
{ 0x0A94 , 0x8131F532},
{ 0x0A95 , 0x8131F533},
{ 0x0A96 , 0x8131F534},
{ 0x0A97 , 0x8131F535},
{ 0x0A98 , 0x8131F536},
{ 0x0A99 , 0x8131F537},
{ 0x0A9A , 0x8131F538},
{ 0x0A9B , 0x8131F539},
{ 0x0A9C , 0x8131F630},
{ 0x0A9D , 0x8131F631},
{ 0x0A9E , 0x8131F632},
{ 0x0A9F , 0x8131F633},
{ 0x0AA0 , 0x8131F634},
{ 0x0AA1 , 0x8131F635},
{ 0x0AA2 , 0x8131F636},
{ 0x0AA3 , 0x8131F637},
{ 0x0AA4 , 0x8131F638},
{ 0x0AA5 , 0x8131F639},
{ 0x0AA6 , 0x8131F730},
{ 0x0AA7 , 0x8131F731},
{ 0x0AA8 , 0x8131F732},
{ 0x0AA9 , 0x8131F733},
{ 0x0AAA , 0x8131F734},
{ 0x0AAB , 0x8131F735},
{ 0x0AAC , 0x8131F736},
{ 0x0AAD , 0x8131F737},
{ 0x0AAE , 0x8131F738},
{ 0x0AAF , 0x8131F739},
{ 0x0AB0 , 0x8131F830},
{ 0x0AB1 , 0x8131F831},
{ 0x0AB2 , 0x8131F832},
{ 0x0AB3 , 0x8131F833},
{ 0x0AB4 , 0x8131F834},
{ 0x0AB5 , 0x8131F835},
{ 0x0AB6 , 0x8131F836},
{ 0x0AB7 , 0x8131F837},
{ 0x0AB8 , 0x8131F838},
{ 0x0AB9 , 0x8131F839},
{ 0x0ABA , 0x8131F930},
{ 0x0ABB , 0x8131F931},
{ 0x0ABC , 0x8131F932},
{ 0x0ABD , 0x8131F933},
{ 0x0ABE , 0x8131F934},
{ 0x0ABF , 0x8131F935},
{ 0x0AC0 , 0x8131F936},
{ 0x0AC1 , 0x8131F937},
{ 0x0AC2 , 0x8131F938},
{ 0x0AC3 , 0x8131F939},
{ 0x0AC4 , 0x8131FA30},
{ 0x0AC5 , 0x8131FA31},
{ 0x0AC6 , 0x8131FA32},
{ 0x0AC7 , 0x8131FA33},
{ 0x0AC8 , 0x8131FA34},
{ 0x0AC9 , 0x8131FA35},
{ 0x0ACA , 0x8131FA36},
{ 0x0ACB , 0x8131FA37},
{ 0x0ACC , 0x8131FA38},
{ 0x0ACD , 0x8131FA39},
{ 0x0ACE , 0x8131FB30},
{ 0x0ACF , 0x8131FB31},
{ 0x0AD0 , 0x8131FB32},
{ 0x0AD1 , 0x8131FB33},
{ 0x0AD2 , 0x8131FB34},
{ 0x0AD3 , 0x8131FB35},
{ 0x0AD4 , 0x8131FB36},
{ 0x0AD5 , 0x8131FB37},
{ 0x0AD6 , 0x8131FB38},
{ 0x0AD7 , 0x8131FB39},
{ 0x0AD8 , 0x8131FC30},
{ 0x0AD9 , 0x8131FC31},
{ 0x0ADA , 0x8131FC32},
{ 0x0ADB , 0x8131FC33},
{ 0x0ADC , 0x8131FC34},
{ 0x0ADD , 0x8131FC35},
{ 0x0ADE , 0x8131FC36},
{ 0x0ADF , 0x8131FC37},
{ 0x0AE0 , 0x8131FC38},
{ 0x0AE1 , 0x8131FC39},
{ 0x0AE2 , 0x8131FD30},
{ 0x0AE3 , 0x8131FD31},
{ 0x0AE4 , 0x8131FD32},
{ 0x0AE5 , 0x8131FD33},
{ 0x0AE6 , 0x8131FD34},
{ 0x0AE7 , 0x8131FD35},
{ 0x0AE8 , 0x8131FD36},
{ 0x0AE9 , 0x8131FD37},
{ 0x0AEA , 0x8131FD38},
{ 0x0AEB , 0x8131FD39},
{ 0x0AEC , 0x8131FE30},
{ 0x0AED , 0x8131FE31},
{ 0x0AEE , 0x8131FE32},
{ 0x0AEF , 0x8131FE33},
{ 0x0AF0 , 0x8131FE34},
{ 0x0AF1 , 0x8131FE35},
{ 0x0AF2 , 0x8131FE36},
{ 0x0AF3 , 0x8131FE37},
{ 0x0AF4 , 0x8131FE38},
{ 0x0AF5 , 0x8131FE39},
{ 0x0AF6 , 0x81328130},
{ 0x0AF7 , 0x81328131},
{ 0x0AF8 , 0x81328132},
{ 0x0AF9 , 0x81328133},
{ 0x0AFA , 0x81328134},
{ 0x0AFB , 0x81328135},
{ 0x0AFC , 0x81328136},
{ 0x0AFD , 0x81328137},
{ 0x0AFE , 0x81328138},
{ 0x0AFF , 0x81328139},
{ 0x0B00 , 0x81328230},
{ 0x0B01 , 0x81328231},
{ 0x0B02 , 0x81328232},
{ 0x0B03 , 0x81328233},
{ 0x0B04 , 0x81328234},
{ 0x0B05 , 0x81328235},
{ 0x0B06 , 0x81328236},
{ 0x0B07 , 0x81328237},
{ 0x0B08 , 0x81328238},
{ 0x0B09 , 0x81328239},
{ 0x0B0A , 0x81328330},
{ 0x0B0B , 0x81328331},
{ 0x0B0C , 0x81328332},
{ 0x0B0D , 0x81328333},
{ 0x0B0E , 0x81328334},
{ 0x0B0F , 0x81328335},
{ 0x0B10 , 0x81328336},
{ 0x0B11 , 0x81328337},
{ 0x0B12 , 0x81328338},
{ 0x0B13 , 0x81328339},
{ 0x0B14 , 0x81328430},
{ 0x0B15 , 0x81328431},
{ 0x0B16 , 0x81328432},
{ 0x0B17 , 0x81328433},
{ 0x0B18 , 0x81328434},
{ 0x0B19 , 0x81328435},
{ 0x0B1A , 0x81328436},
{ 0x0B1B , 0x81328437},
{ 0x0B1C , 0x81328438},
{ 0x0B1D , 0x81328439},
{ 0x0B1E , 0x81328530},
{ 0x0B1F , 0x81328531},
{ 0x0B20 , 0x81328532},
{ 0x0B21 , 0x81328533},
{ 0x0B22 , 0x81328534},
{ 0x0B23 , 0x81328535},
{ 0x0B24 , 0x81328536},
{ 0x0B25 , 0x81328537},
{ 0x0B26 , 0x81328538},
{ 0x0B27 , 0x81328539},
{ 0x0B28 , 0x81328630},
{ 0x0B29 , 0x81328631},
{ 0x0B2A , 0x81328632},
{ 0x0B2B , 0x81328633},
{ 0x0B2C , 0x81328634},
{ 0x0B2D , 0x81328635},
{ 0x0B2E , 0x81328636},
{ 0x0B2F , 0x81328637},
{ 0x0B30 , 0x81328638},
{ 0x0B31 , 0x81328639},
{ 0x0B32 , 0x81328730},
{ 0x0B33 , 0x81328731},
{ 0x0B34 , 0x81328732},
{ 0x0B35 , 0x81328733},
{ 0x0B36 , 0x81328734},
{ 0x0B37 , 0x81328735},
{ 0x0B38 , 0x81328736},
{ 0x0B39 , 0x81328737},
{ 0x0B3A , 0x81328738},
{ 0x0B3B , 0x81328739},
{ 0x0B3C , 0x81328830},
{ 0x0B3D , 0x81328831},
{ 0x0B3E , 0x81328832},
{ 0x0B3F , 0x81328833},
{ 0x0B40 , 0x81328834},
{ 0x0B41 , 0x81328835},
{ 0x0B42 , 0x81328836},
{ 0x0B43 , 0x81328837},
{ 0x0B44 , 0x81328838},
{ 0x0B45 , 0x81328839},
{ 0x0B46 , 0x81328930},
{ 0x0B47 , 0x81328931},
{ 0x0B48 , 0x81328932},
{ 0x0B49 , 0x81328933},
{ 0x0B4A , 0x81328934},
{ 0x0B4B , 0x81328935},
{ 0x0B4C , 0x81328936},
{ 0x0B4D , 0x81328937},
{ 0x0B4E , 0x81328938},
{ 0x0B4F , 0x81328939},
{ 0x0B50 , 0x81328A30},
{ 0x0B51 , 0x81328A31},
{ 0x0B52 , 0x81328A32},
{ 0x0B53 , 0x81328A33},
{ 0x0B54 , 0x81328A34},
{ 0x0B55 , 0x81328A35},
{ 0x0B56 , 0x81328A36},
{ 0x0B57 , 0x81328A37},
{ 0x0B58 , 0x81328A38},
{ 0x0B59 , 0x81328A39},
{ 0x0B5A , 0x81328B30},
{ 0x0B5B , 0x81328B31},
{ 0x0B5C , 0x81328B32},
{ 0x0B5D , 0x81328B33},
{ 0x0B5E , 0x81328B34},
{ 0x0B5F , 0x81328B35},
{ 0x0B60 , 0x81328B36},
{ 0x0B61 , 0x81328B37},
{ 0x0B62 , 0x81328B38},
{ 0x0B63 , 0x81328B39},
{ 0x0B64 , 0x81328C30},
{ 0x0B65 , 0x81328C31},
{ 0x0B66 , 0x81328C32},
{ 0x0B67 , 0x81328C33},
{ 0x0B68 , 0x81328C34},
{ 0x0B69 , 0x81328C35},
{ 0x0B6A , 0x81328C36},
{ 0x0B6B , 0x81328C37},
{ 0x0B6C , 0x81328C38},
{ 0x0B6D , 0x81328C39},
{ 0x0B6E , 0x81328D30},
{ 0x0B6F , 0x81328D31},
{ 0x0B70 , 0x81328D32},
{ 0x0B71 , 0x81328D33},
{ 0x0B72 , 0x81328D34},
{ 0x0B73 , 0x81328D35},
{ 0x0B74 , 0x81328D36},
{ 0x0B75 , 0x81328D37},
{ 0x0B76 , 0x81328D38},
{ 0x0B77 , 0x81328D39},
{ 0x0B78 , 0x81328E30},
{ 0x0B79 , 0x81328E31},
{ 0x0B7A , 0x81328E32},
{ 0x0B7B , 0x81328E33},
{ 0x0B7C , 0x81328E34},
{ 0x0B7D , 0x81328E35},
{ 0x0B7E , 0x81328E36},
{ 0x0B7F , 0x81328E37},
{ 0x0B80 , 0x81328E38},
{ 0x0B81 , 0x81328E39},
{ 0x0B82 , 0x81328F30},
{ 0x0B83 , 0x81328F31},
{ 0x0B84 , 0x81328F32},
{ 0x0B85 , 0x81328F33},
{ 0x0B86 , 0x81328F34},
{ 0x0B87 , 0x81328F35},
{ 0x0B88 , 0x81328F36},
{ 0x0B89 , 0x81328F37},
{ 0x0B8A , 0x81328F38},
{ 0x0B8B , 0x81328F39},
{ 0x0B8C , 0x81329030},
{ 0x0B8D , 0x81329031},
{ 0x0B8E , 0x81329032},
{ 0x0B8F , 0x81329033},
{ 0x0B90 , 0x81329034},
{ 0x0B91 , 0x81329035},
{ 0x0B92 , 0x81329036},
{ 0x0B93 , 0x81329037},
{ 0x0B94 , 0x81329038},
{ 0x0B95 , 0x81329039},
{ 0x0B96 , 0x81329130},
{ 0x0B97 , 0x81329131},
{ 0x0B98 , 0x81329132},
{ 0x0B99 , 0x81329133},
{ 0x0B9A , 0x81329134},
{ 0x0B9B , 0x81329135},
{ 0x0B9C , 0x81329136},
{ 0x0B9D , 0x81329137},
{ 0x0B9E , 0x81329138},
{ 0x0B9F , 0x81329139},
{ 0x0BA0 , 0x81329230},
{ 0x0BA1 , 0x81329231},
{ 0x0BA2 , 0x81329232},
{ 0x0BA3 , 0x81329233},
{ 0x0BA4 , 0x81329234},
{ 0x0BA5 , 0x81329235},
{ 0x0BA6 , 0x81329236},
{ 0x0BA7 , 0x81329237},
{ 0x0BA8 , 0x81329238},
{ 0x0BA9 , 0x81329239},
{ 0x0BAA , 0x81329330},
{ 0x0BAB , 0x81329331},
{ 0x0BAC , 0x81329332},
{ 0x0BAD , 0x81329333},
{ 0x0BAE , 0x81329334},
{ 0x0BAF , 0x81329335},
{ 0x0BB0 , 0x81329336},
{ 0x0BB1 , 0x81329337},
{ 0x0BB2 , 0x81329338},
{ 0x0BB3 , 0x81329339},
{ 0x0BB4 , 0x81329430},
{ 0x0BB5 , 0x81329431},
{ 0x0BB6 , 0x81329432},
{ 0x0BB7 , 0x81329433},
{ 0x0BB8 , 0x81329434},
{ 0x0BB9 , 0x81329435},
{ 0x0BBA , 0x81329436},
{ 0x0BBB , 0x81329437},
{ 0x0BBC , 0x81329438},
{ 0x0BBD , 0x81329439},
{ 0x0BBE , 0x81329530},
{ 0x0BBF , 0x81329531},
{ 0x0BC0 , 0x81329532},
{ 0x0BC1 , 0x81329533},
{ 0x0BC2 , 0x81329534},
{ 0x0BC3 , 0x81329535},
{ 0x0BC4 , 0x81329536},
{ 0x0BC5 , 0x81329537},
{ 0x0BC6 , 0x81329538},
{ 0x0BC7 , 0x81329539},
{ 0x0BC8 , 0x81329630},
{ 0x0BC9 , 0x81329631},
{ 0x0BCA , 0x81329632},
{ 0x0BCB , 0x81329633},
{ 0x0BCC , 0x81329634},
{ 0x0BCD , 0x81329635},
{ 0x0BCE , 0x81329636},
{ 0x0BCF , 0x81329637},
{ 0x0BD0 , 0x81329638},
{ 0x0BD1 , 0x81329639},
{ 0x0BD2 , 0x81329730},
{ 0x0BD3 , 0x81329731},
{ 0x0BD4 , 0x81329732},
{ 0x0BD5 , 0x81329733},
{ 0x0BD6 , 0x81329734},
{ 0x0BD7 , 0x81329735},
{ 0x0BD8 , 0x81329736},
{ 0x0BD9 , 0x81329737},
{ 0x0BDA , 0x81329738},
{ 0x0BDB , 0x81329739},
{ 0x0BDC , 0x81329830},
{ 0x0BDD , 0x81329831},
{ 0x0BDE , 0x81329832},
{ 0x0BDF , 0x81329833},
{ 0x0BE0 , 0x81329834},
{ 0x0BE1 , 0x81329835},
{ 0x0BE2 , 0x81329836},
{ 0x0BE3 , 0x81329837},
{ 0x0BE4 , 0x81329838},
{ 0x0BE5 , 0x81329839},
{ 0x0BE6 , 0x81329930},
{ 0x0BE7 , 0x81329931},
{ 0x0BE8 , 0x81329932},
{ 0x0BE9 , 0x81329933},
{ 0x0BEA , 0x81329934},
{ 0x0BEB , 0x81329935},
{ 0x0BEC , 0x81329936},
{ 0x0BED , 0x81329937},
{ 0x0BEE , 0x81329938},
{ 0x0BEF , 0x81329939},
{ 0x0BF0 , 0x81329A30},
{ 0x0BF1 , 0x81329A31},
{ 0x0BF2 , 0x81329A32},
{ 0x0BF3 , 0x81329A33},
{ 0x0BF4 , 0x81329A34},
{ 0x0BF5 , 0x81329A35},
{ 0x0BF6 , 0x81329A36},
{ 0x0BF7 , 0x81329A37},
{ 0x0BF8 , 0x81329A38},
{ 0x0BF9 , 0x81329A39},
{ 0x0BFA , 0x81329B30},
{ 0x0BFB , 0x81329B31},
{ 0x0BFC , 0x81329B32},
{ 0x0BFD , 0x81329B33},
{ 0x0BFE , 0x81329B34},
{ 0x0BFF , 0x81329B35},
{ 0x0C00 , 0x81329B36},
{ 0x0C01 , 0x81329B37},
{ 0x0C02 , 0x81329B38},
{ 0x0C03 , 0x81329B39},
{ 0x0C04 , 0x81329C30},
{ 0x0C05 , 0x81329C31},
{ 0x0C06 , 0x81329C32},
{ 0x0C07 , 0x81329C33},
{ 0x0C08 , 0x81329C34},
{ 0x0C09 , 0x81329C35},
{ 0x0C0A , 0x81329C36},
{ 0x0C0B , 0x81329C37},
{ 0x0C0C , 0x81329C38},
{ 0x0C0D , 0x81329C39},
{ 0x0C0E , 0x81329D30},
{ 0x0C0F , 0x81329D31},
{ 0x0C10 , 0x81329D32},
{ 0x0C11 , 0x81329D33},
{ 0x0C12 , 0x81329D34},
{ 0x0C13 , 0x81329D35},
{ 0x0C14 , 0x81329D36},
{ 0x0C15 , 0x81329D37},
{ 0x0C16 , 0x81329D38},
{ 0x0C17 , 0x81329D39},
{ 0x0C18 , 0x81329E30},
{ 0x0C19 , 0x81329E31},
{ 0x0C1A , 0x81329E32},
{ 0x0C1B , 0x81329E33},
{ 0x0C1C , 0x81329E34},
{ 0x0C1D , 0x81329E35},
{ 0x0C1E , 0x81329E36},
{ 0x0C1F , 0x81329E37},
{ 0x0C20 , 0x81329E38},
{ 0x0C21 , 0x81329E39},
{ 0x0C22 , 0x81329F30},
{ 0x0C23 , 0x81329F31},
{ 0x0C24 , 0x81329F32},
{ 0x0C25 , 0x81329F33},
{ 0x0C26 , 0x81329F34},
{ 0x0C27 , 0x81329F35},
{ 0x0C28 , 0x81329F36},
{ 0x0C29 , 0x81329F37},
{ 0x0C2A , 0x81329F38},
{ 0x0C2B , 0x81329F39},
{ 0x0C2C , 0x8132A030},
{ 0x0C2D , 0x8132A031},
{ 0x0C2E , 0x8132A032},
{ 0x0C2F , 0x8132A033},
{ 0x0C30 , 0x8132A034},
{ 0x0C31 , 0x8132A035},
{ 0x0C32 , 0x8132A036},
{ 0x0C33 , 0x8132A037},
{ 0x0C34 , 0x8132A038},
{ 0x0C35 , 0x8132A039},
{ 0x0C36 , 0x8132A130},
{ 0x0C37 , 0x8132A131},
{ 0x0C38 , 0x8132A132},
{ 0x0C39 , 0x8132A133},
{ 0x0C3A , 0x8132A134},
{ 0x0C3B , 0x8132A135},
{ 0x0C3C , 0x8132A136},
{ 0x0C3D , 0x8132A137},
{ 0x0C3E , 0x8132A138},
{ 0x0C3F , 0x8132A139},
{ 0x0C40 , 0x8132A230},
{ 0x0C41 , 0x8132A231},
{ 0x0C42 , 0x8132A232},
{ 0x0C43 , 0x8132A233},
{ 0x0C44 , 0x8132A234},
{ 0x0C45 , 0x8132A235},
{ 0x0C46 , 0x8132A236},
{ 0x0C47 , 0x8132A237},
{ 0x0C48 , 0x8132A238},
{ 0x0C49 , 0x8132A239},
{ 0x0C4A , 0x8132A330},
{ 0x0C4B , 0x8132A331},
{ 0x0C4C , 0x8132A332},
{ 0x0C4D , 0x8132A333},
{ 0x0C4E , 0x8132A334},
{ 0x0C4F , 0x8132A335},
{ 0x0C50 , 0x8132A336},
{ 0x0C51 , 0x8132A337},
{ 0x0C52 , 0x8132A338},
{ 0x0C53 , 0x8132A339},
{ 0x0C54 , 0x8132A430},
{ 0x0C55 , 0x8132A431},
{ 0x0C56 , 0x8132A432},
{ 0x0C57 , 0x8132A433},
{ 0x0C58 , 0x8132A434},
{ 0x0C59 , 0x8132A435},
{ 0x0C5A , 0x8132A436},
{ 0x0C5B , 0x8132A437},
{ 0x0C5C , 0x8132A438},
{ 0x0C5D , 0x8132A439},
{ 0x0C5E , 0x8132A530},
{ 0x0C5F , 0x8132A531},
{ 0x0C60 , 0x8132A532},
{ 0x0C61 , 0x8132A533},
{ 0x0C62 , 0x8132A534},
{ 0x0C63 , 0x8132A535},
{ 0x0C64 , 0x8132A536},
{ 0x0C65 , 0x8132A537},
{ 0x0C66 , 0x8132A538},
{ 0x0C67 , 0x8132A539},
{ 0x0C68 , 0x8132A630},
{ 0x0C69 , 0x8132A631},
{ 0x0C6A , 0x8132A632},
{ 0x0C6B , 0x8132A633},
{ 0x0C6C , 0x8132A634},
{ 0x0C6D , 0x8132A635},
{ 0x0C6E , 0x8132A636},
{ 0x0C6F , 0x8132A637},
{ 0x0C70 , 0x8132A638},
{ 0x0C71 , 0x8132A639},
{ 0x0C72 , 0x8132A730},
{ 0x0C73 , 0x8132A731},
{ 0x0C74 , 0x8132A732},
{ 0x0C75 , 0x8132A733},
{ 0x0C76 , 0x8132A734},
{ 0x0C77 , 0x8132A735},
{ 0x0C78 , 0x8132A736},
{ 0x0C79 , 0x8132A737},
{ 0x0C7A , 0x8132A738},
{ 0x0C7B , 0x8132A739},
{ 0x0C7C , 0x8132A830},
{ 0x0C7D , 0x8132A831},
{ 0x0C7E , 0x8132A832},
{ 0x0C7F , 0x8132A833},
{ 0x0C80 , 0x8132A834},
{ 0x0C81 , 0x8132A835},
{ 0x0C82 , 0x8132A836},
{ 0x0C83 , 0x8132A837},
{ 0x0C84 , 0x8132A838},
{ 0x0C85 , 0x8132A839},
{ 0x0C86 , 0x8132A930},
{ 0x0C87 , 0x8132A931},
{ 0x0C88 , 0x8132A932},
{ 0x0C89 , 0x8132A933},
{ 0x0C8A , 0x8132A934},
{ 0x0C8B , 0x8132A935},
{ 0x0C8C , 0x8132A936},
{ 0x0C8D , 0x8132A937},
{ 0x0C8E , 0x8132A938},
{ 0x0C8F , 0x8132A939},
{ 0x0C90 , 0x8132AA30},
{ 0x0C91 , 0x8132AA31},
{ 0x0C92 , 0x8132AA32},
{ 0x0C93 , 0x8132AA33},
{ 0x0C94 , 0x8132AA34},
{ 0x0C95 , 0x8132AA35},
{ 0x0C96 , 0x8132AA36},
{ 0x0C97 , 0x8132AA37},
{ 0x0C98 , 0x8132AA38},
{ 0x0C99 , 0x8132AA39},
{ 0x0C9A , 0x8132AB30},
{ 0x0C9B , 0x8132AB31},
{ 0x0C9C , 0x8132AB32},
{ 0x0C9D , 0x8132AB33},
{ 0x0C9E , 0x8132AB34},
{ 0x0C9F , 0x8132AB35},
{ 0x0CA0 , 0x8132AB36},
{ 0x0CA1 , 0x8132AB37},
{ 0x0CA2 , 0x8132AB38},
{ 0x0CA3 , 0x8132AB39},
{ 0x0CA4 , 0x8132AC30},
{ 0x0CA5 , 0x8132AC31},
{ 0x0CA6 , 0x8132AC32},
{ 0x0CA7 , 0x8132AC33},
{ 0x0CA8 , 0x8132AC34},
{ 0x0CA9 , 0x8132AC35},
{ 0x0CAA , 0x8132AC36},
{ 0x0CAB , 0x8132AC37},
{ 0x0CAC , 0x8132AC38},
{ 0x0CAD , 0x8132AC39},
{ 0x0CAE , 0x8132AD30},
{ 0x0CAF , 0x8132AD31},
{ 0x0CB0 , 0x8132AD32},
{ 0x0CB1 , 0x8132AD33},
{ 0x0CB2 , 0x8132AD34},
{ 0x0CB3 , 0x8132AD35},
{ 0x0CB4 , 0x8132AD36},
{ 0x0CB5 , 0x8132AD37},
{ 0x0CB6 , 0x8132AD38},
{ 0x0CB7 , 0x8132AD39},
{ 0x0CB8 , 0x8132AE30},
{ 0x0CB9 , 0x8132AE31},
{ 0x0CBA , 0x8132AE32},
{ 0x0CBB , 0x8132AE33},
{ 0x0CBC , 0x8132AE34},
{ 0x0CBD , 0x8132AE35},
{ 0x0CBE , 0x8132AE36},
{ 0x0CBF , 0x8132AE37},
{ 0x0CC0 , 0x8132AE38},
{ 0x0CC1 , 0x8132AE39},
{ 0x0CC2 , 0x8132AF30},
{ 0x0CC3 , 0x8132AF31},
{ 0x0CC4 , 0x8132AF32},
{ 0x0CC5 , 0x8132AF33},
{ 0x0CC6 , 0x8132AF34},
{ 0x0CC7 , 0x8132AF35},
{ 0x0CC8 , 0x8132AF36},
{ 0x0CC9 , 0x8132AF37},
{ 0x0CCA , 0x8132AF38},
{ 0x0CCB , 0x8132AF39},
{ 0x0CCC , 0x8132B030},
{ 0x0CCD , 0x8132B031},
{ 0x0CCE , 0x8132B032},
{ 0x0CCF , 0x8132B033},
{ 0x0CD0 , 0x8132B034},
{ 0x0CD1 , 0x8132B035},
{ 0x0CD2 , 0x8132B036},
{ 0x0CD3 , 0x8132B037},
{ 0x0CD4 , 0x8132B038},
{ 0x0CD5 , 0x8132B039},
{ 0x0CD6 , 0x8132B130},
{ 0x0CD7 , 0x8132B131},
{ 0x0CD8 , 0x8132B132},
{ 0x0CD9 , 0x8132B133},
{ 0x0CDA , 0x8132B134},
{ 0x0CDB , 0x8132B135},
{ 0x0CDC , 0x8132B136},
{ 0x0CDD , 0x8132B137},
{ 0x0CDE , 0x8132B138},
{ 0x0CDF , 0x8132B139},
{ 0x0CE0 , 0x8132B230},
{ 0x0CE1 , 0x8132B231},
{ 0x0CE2 , 0x8132B232},
{ 0x0CE3 , 0x8132B233},
{ 0x0CE4 , 0x8132B234},
{ 0x0CE5 , 0x8132B235},
{ 0x0CE6 , 0x8132B236},
{ 0x0CE7 , 0x8132B237},
{ 0x0CE8 , 0x8132B238},
{ 0x0CE9 , 0x8132B239},
{ 0x0CEA , 0x8132B330},
{ 0x0CEB , 0x8132B331},
{ 0x0CEC , 0x8132B332},
{ 0x0CED , 0x8132B333},
{ 0x0CEE , 0x8132B334},
{ 0x0CEF , 0x8132B335},
{ 0x0CF0 , 0x8132B336},
{ 0x0CF1 , 0x8132B337},
{ 0x0CF2 , 0x8132B338},
{ 0x0CF3 , 0x8132B339},
{ 0x0CF4 , 0x8132B430},
{ 0x0CF5 , 0x8132B431},
{ 0x0CF6 , 0x8132B432},
{ 0x0CF7 , 0x8132B433},
{ 0x0CF8 , 0x8132B434},
{ 0x0CF9 , 0x8132B435},
{ 0x0CFA , 0x8132B436},
{ 0x0CFB , 0x8132B437},
{ 0x0CFC , 0x8132B438},
{ 0x0CFD , 0x8132B439},
{ 0x0CFE , 0x8132B530},
{ 0x0CFF , 0x8132B531},
{ 0x0D00 , 0x8132B532},
{ 0x0D01 , 0x8132B533},
{ 0x0D02 , 0x8132B534},
{ 0x0D03 , 0x8132B535},
{ 0x0D04 , 0x8132B536},
{ 0x0D05 , 0x8132B537},
{ 0x0D06 , 0x8132B538},
{ 0x0D07 , 0x8132B539},
{ 0x0D08 , 0x8132B630},
{ 0x0D09 , 0x8132B631},
{ 0x0D0A , 0x8132B632},
{ 0x0D0B , 0x8132B633},
{ 0x0D0C , 0x8132B634},
{ 0x0D0D , 0x8132B635},
{ 0x0D0E , 0x8132B636},
{ 0x0D0F , 0x8132B637},
{ 0x0D10 , 0x8132B638},
{ 0x0D11 , 0x8132B639},
{ 0x0D12 , 0x8132B730},
{ 0x0D13 , 0x8132B731},
{ 0x0D14 , 0x8132B732},
{ 0x0D15 , 0x8132B733},
{ 0x0D16 , 0x8132B734},
{ 0x0D17 , 0x8132B735},
{ 0x0D18 , 0x8132B736},
{ 0x0D19 , 0x8132B737},
{ 0x0D1A , 0x8132B738},
{ 0x0D1B , 0x8132B739},
{ 0x0D1C , 0x8132B830},
{ 0x0D1D , 0x8132B831},
{ 0x0D1E , 0x8132B832},
{ 0x0D1F , 0x8132B833},
{ 0x0D20 , 0x8132B834},
{ 0x0D21 , 0x8132B835},
{ 0x0D22 , 0x8132B836},
{ 0x0D23 , 0x8132B837},
{ 0x0D24 , 0x8132B838},
{ 0x0D25 , 0x8132B839},
{ 0x0D26 , 0x8132B930},
{ 0x0D27 , 0x8132B931},
{ 0x0D28 , 0x8132B932},
{ 0x0D29 , 0x8132B933},
{ 0x0D2A , 0x8132B934},
{ 0x0D2B , 0x8132B935},
{ 0x0D2C , 0x8132B936},
{ 0x0D2D , 0x8132B937},
{ 0x0D2E , 0x8132B938},
{ 0x0D2F , 0x8132B939},
{ 0x0D30 , 0x8132BA30},
{ 0x0D31 , 0x8132BA31},
{ 0x0D32 , 0x8132BA32},
{ 0x0D33 , 0x8132BA33},
{ 0x0D34 , 0x8132BA34},
{ 0x0D35 , 0x8132BA35},
{ 0x0D36 , 0x8132BA36},
{ 0x0D37 , 0x8132BA37},
{ 0x0D38 , 0x8132BA38},
{ 0x0D39 , 0x8132BA39},
{ 0x0D3A , 0x8132BB30},
{ 0x0D3B , 0x8132BB31},
{ 0x0D3C , 0x8132BB32},
{ 0x0D3D , 0x8132BB33},
{ 0x0D3E , 0x8132BB34},
{ 0x0D3F , 0x8132BB35},
{ 0x0D40 , 0x8132BB36},
{ 0x0D41 , 0x8132BB37},
{ 0x0D42 , 0x8132BB38},
{ 0x0D43 , 0x8132BB39},
{ 0x0D44 , 0x8132BC30},
{ 0x0D45 , 0x8132BC31},
{ 0x0D46 , 0x8132BC32},
{ 0x0D47 , 0x8132BC33},
{ 0x0D48 , 0x8132BC34},
{ 0x0D49 , 0x8132BC35},
{ 0x0D4A , 0x8132BC36},
{ 0x0D4B , 0x8132BC37},
{ 0x0D4C , 0x8132BC38},
{ 0x0D4D , 0x8132BC39},
{ 0x0D4E , 0x8132BD30},
{ 0x0D4F , 0x8132BD31},
{ 0x0D50 , 0x8132BD32},
{ 0x0D51 , 0x8132BD33},
{ 0x0D52 , 0x8132BD34},
{ 0x0D53 , 0x8132BD35},
{ 0x0D54 , 0x8132BD36},
{ 0x0D55 , 0x8132BD37},
{ 0x0D56 , 0x8132BD38},
{ 0x0D57 , 0x8132BD39},
{ 0x0D58 , 0x8132BE30},
{ 0x0D59 , 0x8132BE31},
{ 0x0D5A , 0x8132BE32},
{ 0x0D5B , 0x8132BE33},
{ 0x0D5C , 0x8132BE34},
{ 0x0D5D , 0x8132BE35},
{ 0x0D5E , 0x8132BE36},
{ 0x0D5F , 0x8132BE37},
{ 0x0D60 , 0x8132BE38},
{ 0x0D61 , 0x8132BE39},
{ 0x0D62 , 0x8132BF30},
{ 0x0D63 , 0x8132BF31},
{ 0x0D64 , 0x8132BF32},
{ 0x0D65 , 0x8132BF33},
{ 0x0D66 , 0x8132BF34},
{ 0x0D67 , 0x8132BF35},
{ 0x0D68 , 0x8132BF36},
{ 0x0D69 , 0x8132BF37},
{ 0x0D6A , 0x8132BF38},
{ 0x0D6B , 0x8132BF39},
{ 0x0D6C , 0x8132C030},
{ 0x0D6D , 0x8132C031},
{ 0x0D6E , 0x8132C032},
{ 0x0D6F , 0x8132C033},
{ 0x0D70 , 0x8132C034},
{ 0x0D71 , 0x8132C035},
{ 0x0D72 , 0x8132C036},
{ 0x0D73 , 0x8132C037},
{ 0x0D74 , 0x8132C038},
{ 0x0D75 , 0x8132C039},
{ 0x0D76 , 0x8132C130},
{ 0x0D77 , 0x8132C131},
{ 0x0D78 , 0x8132C132},
{ 0x0D79 , 0x8132C133},
{ 0x0D7A , 0x8132C134},
{ 0x0D7B , 0x8132C135},
{ 0x0D7C , 0x8132C136},
{ 0x0D7D , 0x8132C137},
{ 0x0D7E , 0x8132C138},
{ 0x0D7F , 0x8132C139},
{ 0x0D80 , 0x8132C230},
{ 0x0D81 , 0x8132C231},
{ 0x0D82 , 0x8132C232},
{ 0x0D83 , 0x8132C233},
{ 0x0D84 , 0x8132C234},
{ 0x0D85 , 0x8132C235},
{ 0x0D86 , 0x8132C236},
{ 0x0D87 , 0x8132C237},
{ 0x0D88 , 0x8132C238},
{ 0x0D89 , 0x8132C239},
{ 0x0D8A , 0x8132C330},
{ 0x0D8B , 0x8132C331},
{ 0x0D8C , 0x8132C332},
{ 0x0D8D , 0x8132C333},
{ 0x0D8E , 0x8132C334},
{ 0x0D8F , 0x8132C335},
{ 0x0D90 , 0x8132C336},
{ 0x0D91 , 0x8132C337},
{ 0x0D92 , 0x8132C338},
{ 0x0D93 , 0x8132C339},
{ 0x0D94 , 0x8132C430},
{ 0x0D95 , 0x8132C431},
{ 0x0D96 , 0x8132C432},
{ 0x0D97 , 0x8132C433},
{ 0x0D98 , 0x8132C434},
{ 0x0D99 , 0x8132C435},
{ 0x0D9A , 0x8132C436},
{ 0x0D9B , 0x8132C437},
{ 0x0D9C , 0x8132C438},
{ 0x0D9D , 0x8132C439},
{ 0x0D9E , 0x8132C530},
{ 0x0D9F , 0x8132C531},
{ 0x0DA0 , 0x8132C532},
{ 0x0DA1 , 0x8132C533},
{ 0x0DA2 , 0x8132C534},
{ 0x0DA3 , 0x8132C535},
{ 0x0DA4 , 0x8132C536},
{ 0x0DA5 , 0x8132C537},
{ 0x0DA6 , 0x8132C538},
{ 0x0DA7 , 0x8132C539},
{ 0x0DA8 , 0x8132C630},
{ 0x0DA9 , 0x8132C631},
{ 0x0DAA , 0x8132C632},
{ 0x0DAB , 0x8132C633},
{ 0x0DAC , 0x8132C634},
{ 0x0DAD , 0x8132C635},
{ 0x0DAE , 0x8132C636},
{ 0x0DAF , 0x8132C637},
{ 0x0DB0 , 0x8132C638},
{ 0x0DB1 , 0x8132C639},
{ 0x0DB2 , 0x8132C730},
{ 0x0DB3 , 0x8132C731},
{ 0x0DB4 , 0x8132C732},
{ 0x0DB5 , 0x8132C733},
{ 0x0DB6 , 0x8132C734},
{ 0x0DB7 , 0x8132C735},
{ 0x0DB8 , 0x8132C736},
{ 0x0DB9 , 0x8132C737},
{ 0x0DBA , 0x8132C738},
{ 0x0DBB , 0x8132C739},
{ 0x0DBC , 0x8132C830},
{ 0x0DBD , 0x8132C831},
{ 0x0DBE , 0x8132C832},
{ 0x0DBF , 0x8132C833},
{ 0x0DC0 , 0x8132C834},
{ 0x0DC1 , 0x8132C835},
{ 0x0DC2 , 0x8132C836},
{ 0x0DC3 , 0x8132C837},
{ 0x0DC4 , 0x8132C838},
{ 0x0DC5 , 0x8132C839},
{ 0x0DC6 , 0x8132C930},
{ 0x0DC7 , 0x8132C931},
{ 0x0DC8 , 0x8132C932},
{ 0x0DC9 , 0x8132C933},
{ 0x0DCA , 0x8132C934},
{ 0x0DCB , 0x8132C935},
{ 0x0DCC , 0x8132C936},
{ 0x0DCD , 0x8132C937},
{ 0x0DCE , 0x8132C938},
{ 0x0DCF , 0x8132C939},
{ 0x0DD0 , 0x8132CA30},
{ 0x0DD1 , 0x8132CA31},
{ 0x0DD2 , 0x8132CA32},
{ 0x0DD3 , 0x8132CA33},
{ 0x0DD4 , 0x8132CA34},
{ 0x0DD5 , 0x8132CA35},
{ 0x0DD6 , 0x8132CA36},
{ 0x0DD7 , 0x8132CA37},
{ 0x0DD8 , 0x8132CA38},
{ 0x0DD9 , 0x8132CA39},
{ 0x0DDA , 0x8132CB30},
{ 0x0DDB , 0x8132CB31},
{ 0x0DDC , 0x8132CB32},
{ 0x0DDD , 0x8132CB33},
{ 0x0DDE , 0x8132CB34},
{ 0x0DDF , 0x8132CB35},
{ 0x0DE0 , 0x8132CB36},
{ 0x0DE1 , 0x8132CB37},
{ 0x0DE2 , 0x8132CB38},
{ 0x0DE3 , 0x8132CB39},
{ 0x0DE4 , 0x8132CC30},
{ 0x0DE5 , 0x8132CC31},
{ 0x0DE6 , 0x8132CC32},
{ 0x0DE7 , 0x8132CC33},
{ 0x0DE8 , 0x8132CC34},
{ 0x0DE9 , 0x8132CC35},
{ 0x0DEA , 0x8132CC36},
{ 0x0DEB , 0x8132CC37},
{ 0x0DEC , 0x8132CC38},
{ 0x0DED , 0x8132CC39},
{ 0x0DEE , 0x8132CD30},
{ 0x0DEF , 0x8132CD31},
{ 0x0DF0 , 0x8132CD32},
{ 0x0DF1 , 0x8132CD33},
{ 0x0DF2 , 0x8132CD34},
{ 0x0DF3 , 0x8132CD35},
{ 0x0DF4 , 0x8132CD36},
{ 0x0DF5 , 0x8132CD37},
{ 0x0DF6 , 0x8132CD38},
{ 0x0DF7 , 0x8132CD39},
{ 0x0DF8 , 0x8132CE30},
{ 0x0DF9 , 0x8132CE31},
{ 0x0DFA , 0x8132CE32},
{ 0x0DFB , 0x8132CE33},
{ 0x0DFC , 0x8132CE34},
{ 0x0DFD , 0x8132CE35},
{ 0x0DFE , 0x8132CE36},
{ 0x0DFF , 0x8132CE37},
{ 0x0E00 , 0x8132CE38},
{ 0x0E01 , 0x8132CE39},
{ 0x0E02 , 0x8132CF30},
{ 0x0E03 , 0x8132CF31},
{ 0x0E04 , 0x8132CF32},
{ 0x0E05 , 0x8132CF33},
{ 0x0E06 , 0x8132CF34},
{ 0x0E07 , 0x8132CF35},
{ 0x0E08 , 0x8132CF36},
{ 0x0E09 , 0x8132CF37},
{ 0x0E0A , 0x8132CF38},
{ 0x0E0B , 0x8132CF39},
{ 0x0E0C , 0x8132D030},
{ 0x0E0D , 0x8132D031},
{ 0x0E0E , 0x8132D032},
{ 0x0E0F , 0x8132D033},
{ 0x0E10 , 0x8132D034},
{ 0x0E11 , 0x8132D035},
{ 0x0E12 , 0x8132D036},
{ 0x0E13 , 0x8132D037},
{ 0x0E14 , 0x8132D038},
{ 0x0E15 , 0x8132D039},
{ 0x0E16 , 0x8132D130},
{ 0x0E17 , 0x8132D131},
{ 0x0E18 , 0x8132D132},
{ 0x0E19 , 0x8132D133},
{ 0x0E1A , 0x8132D134},
{ 0x0E1B , 0x8132D135},
{ 0x0E1C , 0x8132D136},
{ 0x0E1D , 0x8132D137},
{ 0x0E1E , 0x8132D138},
{ 0x0E1F , 0x8132D139},
{ 0x0E20 , 0x8132D230},
{ 0x0E21 , 0x8132D231},
{ 0x0E22 , 0x8132D232},
{ 0x0E23 , 0x8132D233},
{ 0x0E24 , 0x8132D234},
{ 0x0E25 , 0x8132D235},
{ 0x0E26 , 0x8132D236},
{ 0x0E27 , 0x8132D237},
{ 0x0E28 , 0x8132D238},
{ 0x0E29 , 0x8132D239},
{ 0x0E2A , 0x8132D330},
{ 0x0E2B , 0x8132D331},
{ 0x0E2C , 0x8132D332},
{ 0x0E2D , 0x8132D333},
{ 0x0E2E , 0x8132D334},
{ 0x0E2F , 0x8132D335},
{ 0x0E30 , 0x8132D336},
{ 0x0E31 , 0x8132D337},
{ 0x0E32 , 0x8132D338},
{ 0x0E33 , 0x8132D339},
{ 0x0E34 , 0x8132D430},
{ 0x0E35 , 0x8132D431},
{ 0x0E36 , 0x8132D432},
{ 0x0E37 , 0x8132D433},
{ 0x0E38 , 0x8132D434},
{ 0x0E39 , 0x8132D435},
{ 0x0E3A , 0x8132D436},
{ 0x0E3B , 0x8132D437},
{ 0x0E3C , 0x8132D438},
{ 0x0E3D , 0x8132D439},
{ 0x0E3E , 0x8132D530},
{ 0x0E3F , 0x8132D531},
{ 0x0E40 , 0x8132D532},
{ 0x0E41 , 0x8132D533},
{ 0x0E42 , 0x8132D534},
{ 0x0E43 , 0x8132D535},
{ 0x0E44 , 0x8132D536},
{ 0x0E45 , 0x8132D537},
{ 0x0E46 , 0x8132D538},
{ 0x0E47 , 0x8132D539},
{ 0x0E48 , 0x8132D630},
{ 0x0E49 , 0x8132D631},
{ 0x0E4A , 0x8132D632},
{ 0x0E4B , 0x8132D633},
{ 0x0E4C , 0x8132D634},
{ 0x0E4D , 0x8132D635},
{ 0x0E4E , 0x8132D636},
{ 0x0E4F , 0x8132D637},
{ 0x0E50 , 0x8132D638},
{ 0x0E51 , 0x8132D639},
{ 0x0E52 , 0x8132D730},
{ 0x0E53 , 0x8132D731},
{ 0x0E54 , 0x8132D732},
{ 0x0E55 , 0x8132D733},
{ 0x0E56 , 0x8132D734},
{ 0x0E57 , 0x8132D735},
{ 0x0E58 , 0x8132D736},
{ 0x0E59 , 0x8132D737},
{ 0x0E5A , 0x8132D738},
{ 0x0E5B , 0x8132D739},
{ 0x0E5C , 0x8132D830},
{ 0x0E5D , 0x8132D831},
{ 0x0E5E , 0x8132D832},
{ 0x0E5F , 0x8132D833},
{ 0x0E60 , 0x8132D834},
{ 0x0E61 , 0x8132D835},
{ 0x0E62 , 0x8132D836},
{ 0x0E63 , 0x8132D837},
{ 0x0E64 , 0x8132D838},
{ 0x0E65 , 0x8132D839},
{ 0x0E66 , 0x8132D930},
{ 0x0E67 , 0x8132D931},
{ 0x0E68 , 0x8132D932},
{ 0x0E69 , 0x8132D933},
{ 0x0E6A , 0x8132D934},
{ 0x0E6B , 0x8132D935},
{ 0x0E6C , 0x8132D936},
{ 0x0E6D , 0x8132D937},
{ 0x0E6E , 0x8132D938},
{ 0x0E6F , 0x8132D939},
{ 0x0E70 , 0x8132DA30},
{ 0x0E71 , 0x8132DA31},
{ 0x0E72 , 0x8132DA32},
{ 0x0E73 , 0x8132DA33},
{ 0x0E74 , 0x8132DA34},
{ 0x0E75 , 0x8132DA35},
{ 0x0E76 , 0x8132DA36},
{ 0x0E77 , 0x8132DA37},
{ 0x0E78 , 0x8132DA38},
{ 0x0E79 , 0x8132DA39},
{ 0x0E7A , 0x8132DB30},
{ 0x0E7B , 0x8132DB31},
{ 0x0E7C , 0x8132DB32},
{ 0x0E7D , 0x8132DB33},
{ 0x0E7E , 0x8132DB34},
{ 0x0E7F , 0x8132DB35},
{ 0x0E80 , 0x8132DB36},
{ 0x0E81 , 0x8132DB37},
{ 0x0E82 , 0x8132DB38},
{ 0x0E83 , 0x8132DB39},
{ 0x0E84 , 0x8132DC30},
{ 0x0E85 , 0x8132DC31},
{ 0x0E86 , 0x8132DC32},
{ 0x0E87 , 0x8132DC33},
{ 0x0E88 , 0x8132DC34},
{ 0x0E89 , 0x8132DC35},
{ 0x0E8A , 0x8132DC36},
{ 0x0E8B , 0x8132DC37},
{ 0x0E8C , 0x8132DC38},
{ 0x0E8D , 0x8132DC39},
{ 0x0E8E , 0x8132DD30},
{ 0x0E8F , 0x8132DD31},
{ 0x0E90 , 0x8132DD32},
{ 0x0E91 , 0x8132DD33},
{ 0x0E92 , 0x8132DD34},
{ 0x0E93 , 0x8132DD35},
{ 0x0E94 , 0x8132DD36},
{ 0x0E95 , 0x8132DD37},
{ 0x0E96 , 0x8132DD38},
{ 0x0E97 , 0x8132DD39},
{ 0x0E98 , 0x8132DE30},
{ 0x0E99 , 0x8132DE31},
{ 0x0E9A , 0x8132DE32},
{ 0x0E9B , 0x8132DE33},
{ 0x0E9C , 0x8132DE34},
{ 0x0E9D , 0x8132DE35},
{ 0x0E9E , 0x8132DE36},
{ 0x0E9F , 0x8132DE37},
{ 0x0EA0 , 0x8132DE38},
{ 0x0EA1 , 0x8132DE39},
{ 0x0EA2 , 0x8132DF30},
{ 0x0EA3 , 0x8132DF31},
{ 0x0EA4 , 0x8132DF32},
{ 0x0EA5 , 0x8132DF33},
{ 0x0EA6 , 0x8132DF34},
{ 0x0EA7 , 0x8132DF35},
{ 0x0EA8 , 0x8132DF36},
{ 0x0EA9 , 0x8132DF37},
{ 0x0EAA , 0x8132DF38},
{ 0x0EAB , 0x8132DF39},
{ 0x0EAC , 0x8132E030},
{ 0x0EAD , 0x8132E031},
{ 0x0EAE , 0x8132E032},
{ 0x0EAF , 0x8132E033},
{ 0x0EB0 , 0x8132E034},
{ 0x0EB1 , 0x8132E035},
{ 0x0EB2 , 0x8132E036},
{ 0x0EB3 , 0x8132E037},
{ 0x0EB4 , 0x8132E038},
{ 0x0EB5 , 0x8132E039},
{ 0x0EB6 , 0x8132E130},
{ 0x0EB7 , 0x8132E131},
{ 0x0EB8 , 0x8132E132},
{ 0x0EB9 , 0x8132E133},
{ 0x0EBA , 0x8132E134},
{ 0x0EBB , 0x8132E135},
{ 0x0EBC , 0x8132E136},
{ 0x0EBD , 0x8132E137},
{ 0x0EBE , 0x8132E138},
{ 0x0EBF , 0x8132E139},
{ 0x0EC0 , 0x8132E230},
{ 0x0EC1 , 0x8132E231},
{ 0x0EC2 , 0x8132E232},
{ 0x0EC3 , 0x8132E233},
{ 0x0EC4 , 0x8132E234},
{ 0x0EC5 , 0x8132E235},
{ 0x0EC6 , 0x8132E236},
{ 0x0EC7 , 0x8132E237},
{ 0x0EC8 , 0x8132E238},
{ 0x0EC9 , 0x8132E239},
{ 0x0ECA , 0x8132E330},
{ 0x0ECB , 0x8132E331},
{ 0x0ECC , 0x8132E332},
{ 0x0ECD , 0x8132E333},
{ 0x0ECE , 0x8132E334},
{ 0x0ECF , 0x8132E335},
{ 0x0ED0 , 0x8132E336},
{ 0x0ED1 , 0x8132E337},
{ 0x0ED2 , 0x8132E338},
{ 0x0ED3 , 0x8132E339},
{ 0x0ED4 , 0x8132E430},
{ 0x0ED5 , 0x8132E431},
{ 0x0ED6 , 0x8132E432},
{ 0x0ED7 , 0x8132E433},
{ 0x0ED8 , 0x8132E434},
{ 0x0ED9 , 0x8132E435},
{ 0x0EDA , 0x8132E436},
{ 0x0EDB , 0x8132E437},
{ 0x0EDC , 0x8132E438},
{ 0x0EDD , 0x8132E439},
{ 0x0EDE , 0x8132E530},
{ 0x0EDF , 0x8132E531},
{ 0x0EE0 , 0x8132E532},
{ 0x0EE1 , 0x8132E533},
{ 0x0EE2 , 0x8132E534},
{ 0x0EE3 , 0x8132E535},
{ 0x0EE4 , 0x8132E536},
{ 0x0EE5 , 0x8132E537},
{ 0x0EE6 , 0x8132E538},
{ 0x0EE7 , 0x8132E539},
{ 0x0EE8 , 0x8132E630},
{ 0x0EE9 , 0x8132E631},
{ 0x0EEA , 0x8132E632},
{ 0x0EEB , 0x8132E633},
{ 0x0EEC , 0x8132E634},
{ 0x0EED , 0x8132E635},
{ 0x0EEE , 0x8132E636},
{ 0x0EEF , 0x8132E637},
{ 0x0EF0 , 0x8132E638},
{ 0x0EF1 , 0x8132E639},
{ 0x0EF2 , 0x8132E730},
{ 0x0EF3 , 0x8132E731},
{ 0x0EF4 , 0x8132E732},
{ 0x0EF5 , 0x8132E733},
{ 0x0EF6 , 0x8132E734},
{ 0x0EF7 , 0x8132E735},
{ 0x0EF8 , 0x8132E736},
{ 0x0EF9 , 0x8132E737},
{ 0x0EFA , 0x8132E738},
{ 0x0EFB , 0x8132E739},
{ 0x0EFC , 0x8132E830},
{ 0x0EFD , 0x8132E831},
{ 0x0EFE , 0x8132E832},
{ 0x0EFF , 0x8132E833},
{ 0x0F00 , 0x8132E834},
{ 0x0F01 , 0x8132E835},
{ 0x0F02 , 0x8132E836},
{ 0x0F03 , 0x8132E837},
{ 0x0F04 , 0x8132E838},
{ 0x0F05 , 0x8132E839},
{ 0x0F06 , 0x8132E930},
{ 0x0F07 , 0x8132E931},
{ 0x0F08 , 0x8132E932},
{ 0x0F09 , 0x8132E933},
{ 0x0F0A , 0x8132E934},
{ 0x0F0B , 0x8132E935},
{ 0x0F0C , 0x8132E936},
{ 0x0F0D , 0x8132E937},
{ 0x0F0E , 0x8132E938},
{ 0x0F0F , 0x8132E939},
{ 0x0F10 , 0x8132EA30},
{ 0x0F11 , 0x8132EA31},
{ 0x0F12 , 0x8132EA32},
{ 0x0F13 , 0x8132EA33},
{ 0x0F14 , 0x8132EA34},
{ 0x0F15 , 0x8132EA35},
{ 0x0F16 , 0x8132EA36},
{ 0x0F17 , 0x8132EA37},
{ 0x0F18 , 0x8132EA38},
{ 0x0F19 , 0x8132EA39},
{ 0x0F1A , 0x8132EB30},
{ 0x0F1B , 0x8132EB31},
{ 0x0F1C , 0x8132EB32},
{ 0x0F1D , 0x8132EB33},
{ 0x0F1E , 0x8132EB34},
{ 0x0F1F , 0x8132EB35},
{ 0x0F20 , 0x8132EB36},
{ 0x0F21 , 0x8132EB37},
{ 0x0F22 , 0x8132EB38},
{ 0x0F23 , 0x8132EB39},
{ 0x0F24 , 0x8132EC30},
{ 0x0F25 , 0x8132EC31},
{ 0x0F26 , 0x8132EC32},
{ 0x0F27 , 0x8132EC33},
{ 0x0F28 , 0x8132EC34},
{ 0x0F29 , 0x8132EC35},
{ 0x0F2A , 0x8132EC36},
{ 0x0F2B , 0x8132EC37},
{ 0x0F2C , 0x8132EC38},
{ 0x0F2D , 0x8132EC39},
{ 0x0F2E , 0x8132ED30},
{ 0x0F2F , 0x8132ED31},
{ 0x0F30 , 0x8132ED32},
{ 0x0F31 , 0x8132ED33},
{ 0x0F32 , 0x8132ED34},
{ 0x0F33 , 0x8132ED35},
{ 0x0F34 , 0x8132ED36},
{ 0x0F35 , 0x8132ED37},
{ 0x0F36 , 0x8132ED38},
{ 0x0F37 , 0x8132ED39},
{ 0x0F38 , 0x8132EE30},
{ 0x0F39 , 0x8132EE31},
{ 0x0F3A , 0x8132EE32},
{ 0x0F3B , 0x8132EE33},
{ 0x0F3C , 0x8132EE34},
{ 0x0F3D , 0x8132EE35},
{ 0x0F3E , 0x8132EE36},
{ 0x0F3F , 0x8132EE37},
{ 0x0F40 , 0x8132EE38},
{ 0x0F41 , 0x8132EE39},
{ 0x0F42 , 0x8132EF30},
{ 0x0F43 , 0x8132EF31},
{ 0x0F44 , 0x8132EF32},
{ 0x0F45 , 0x8132EF33},
{ 0x0F46 , 0x8132EF34},
{ 0x0F47 , 0x8132EF35},
{ 0x0F48 , 0x8132EF36},
{ 0x0F49 , 0x8132EF37},
{ 0x0F4A , 0x8132EF38},
{ 0x0F4B , 0x8132EF39},
{ 0x0F4C , 0x8132F030},
{ 0x0F4D , 0x8132F031},
{ 0x0F4E , 0x8132F032},
{ 0x0F4F , 0x8132F033},
{ 0x0F50 , 0x8132F034},
{ 0x0F51 , 0x8132F035},
{ 0x0F52 , 0x8132F036},
{ 0x0F53 , 0x8132F037},
{ 0x0F54 , 0x8132F038},
{ 0x0F55 , 0x8132F039},
{ 0x0F56 , 0x8132F130},
{ 0x0F57 , 0x8132F131},
{ 0x0F58 , 0x8132F132},
{ 0x0F59 , 0x8132F133},
{ 0x0F5A , 0x8132F134},
{ 0x0F5B , 0x8132F135},
{ 0x0F5C , 0x8132F136},
{ 0x0F5D , 0x8132F137},
{ 0x0F5E , 0x8132F138},
{ 0x0F5F , 0x8132F139},
{ 0x0F60 , 0x8132F230},
{ 0x0F61 , 0x8132F231},
{ 0x0F62 , 0x8132F232},
{ 0x0F63 , 0x8132F233},
{ 0x0F64 , 0x8132F234},
{ 0x0F65 , 0x8132F235},
{ 0x0F66 , 0x8132F236},
{ 0x0F67 , 0x8132F237},
{ 0x0F68 , 0x8132F238},
{ 0x0F69 , 0x8132F239},
{ 0x0F6A , 0x8132F330},
{ 0x0F6B , 0x8132F331},
{ 0x0F6C , 0x8132F332},
{ 0x0F6D , 0x8132F333},
{ 0x0F6E , 0x8132F334},
{ 0x0F6F , 0x8132F335},
{ 0x0F70 , 0x8132F336},
{ 0x0F71 , 0x8132F337},
{ 0x0F72 , 0x8132F338},
{ 0x0F73 , 0x8132F339},
{ 0x0F74 , 0x8132F430},
{ 0x0F75 , 0x8132F431},
{ 0x0F76 , 0x8132F432},
{ 0x0F77 , 0x8132F433},
{ 0x0F78 , 0x8132F434},
{ 0x0F79 , 0x8132F435},
{ 0x0F7A , 0x8132F436},
{ 0x0F7B , 0x8132F437},
{ 0x0F7C , 0x8132F438},
{ 0x0F7D , 0x8132F439},
{ 0x0F7E , 0x8132F530},
{ 0x0F7F , 0x8132F531},
{ 0x0F80 , 0x8132F532},
{ 0x0F81 , 0x8132F533},
{ 0x0F82 , 0x8132F534},
{ 0x0F83 , 0x8132F535},
{ 0x0F84 , 0x8132F536},
{ 0x0F85 , 0x8132F537},
{ 0x0F86 , 0x8132F538},
{ 0x0F87 , 0x8132F539},
{ 0x0F88 , 0x8132F630},
{ 0x0F89 , 0x8132F631},
{ 0x0F8A , 0x8132F632},
{ 0x0F8B , 0x8132F633},
{ 0x0F8C , 0x8132F634},
{ 0x0F8D , 0x8132F635},
{ 0x0F8E , 0x8132F636},
{ 0x0F8F , 0x8132F637},
{ 0x0F90 , 0x8132F638},
{ 0x0F91 , 0x8132F639},
{ 0x0F92 , 0x8132F730},
{ 0x0F93 , 0x8132F731},
{ 0x0F94 , 0x8132F732},
{ 0x0F95 , 0x8132F733},
{ 0x0F96 , 0x8132F734},
{ 0x0F97 , 0x8132F735},
{ 0x0F98 , 0x8132F736},
{ 0x0F99 , 0x8132F737},
{ 0x0F9A , 0x8132F738},
{ 0x0F9B , 0x8132F739},
{ 0x0F9C , 0x8132F830},
{ 0x0F9D , 0x8132F831},
{ 0x0F9E , 0x8132F832},
{ 0x0F9F , 0x8132F833},
{ 0x0FA0 , 0x8132F834},
{ 0x0FA1 , 0x8132F835},
{ 0x0FA2 , 0x8132F836},
{ 0x0FA3 , 0x8132F837},
{ 0x0FA4 , 0x8132F838},
{ 0x0FA5 , 0x8132F839},
{ 0x0FA6 , 0x8132F930},
{ 0x0FA7 , 0x8132F931},
{ 0x0FA8 , 0x8132F932},
{ 0x0FA9 , 0x8132F933},
{ 0x0FAA , 0x8132F934},
{ 0x0FAB , 0x8132F935},
{ 0x0FAC , 0x8132F936},
{ 0x0FAD , 0x8132F937},
{ 0x0FAE , 0x8132F938},
{ 0x0FAF , 0x8132F939},
{ 0x0FB0 , 0x8132FA30},
{ 0x0FB1 , 0x8132FA31},
{ 0x0FB2 , 0x8132FA32},
{ 0x0FB3 , 0x8132FA33},
{ 0x0FB4 , 0x8132FA34},
{ 0x0FB5 , 0x8132FA35},
{ 0x0FB6 , 0x8132FA36},
{ 0x0FB7 , 0x8132FA37},
{ 0x0FB8 , 0x8132FA38},
{ 0x0FB9 , 0x8132FA39},
{ 0x0FBA , 0x8132FB30},
{ 0x0FBB , 0x8132FB31},
{ 0x0FBC , 0x8132FB32},
{ 0x0FBD , 0x8132FB33},
{ 0x0FBE , 0x8132FB34},
{ 0x0FBF , 0x8132FB35},
{ 0x0FC0 , 0x8132FB36},
{ 0x0FC1 , 0x8132FB37},
{ 0x0FC2 , 0x8132FB38},
{ 0x0FC3 , 0x8132FB39},
{ 0x0FC4 , 0x8132FC30},
{ 0x0FC5 , 0x8132FC31},
{ 0x0FC6 , 0x8132FC32},
{ 0x0FC7 , 0x8132FC33},
{ 0x0FC8 , 0x8132FC34},
{ 0x0FC9 , 0x8132FC35},
{ 0x0FCA , 0x8132FC36},
{ 0x0FCB , 0x8132FC37},
{ 0x0FCC , 0x8132FC38},
{ 0x0FCD , 0x8132FC39},
{ 0x0FCE , 0x8132FD30},
{ 0x0FCF , 0x8132FD31},
{ 0x0FD0 , 0x8132FD32},
{ 0x0FD1 , 0x8132FD33},
{ 0x0FD2 , 0x8132FD34},
{ 0x0FD3 , 0x8132FD35},
{ 0x0FD4 , 0x8132FD36},
{ 0x0FD5 , 0x8132FD37},
{ 0x0FD6 , 0x8132FD38},
{ 0x0FD7 , 0x8132FD39},
{ 0x0FD8 , 0x8132FE30},
{ 0x0FD9 , 0x8132FE31},
{ 0x0FDA , 0x8132FE32},
{ 0x0FDB , 0x8132FE33},
{ 0x0FDC , 0x8132FE34},
{ 0x0FDD , 0x8132FE35},
{ 0x0FDE , 0x8132FE36},
{ 0x0FDF , 0x8132FE37},
{ 0x0FE0 , 0x8132FE38},
{ 0x0FE1 , 0x8132FE39},
{ 0x0FE2 , 0x81338130},
{ 0x0FE3 , 0x81338131},
{ 0x0FE4 , 0x81338132},
{ 0x0FE5 , 0x81338133},
{ 0x0FE6 , 0x81338134},
{ 0x0FE7 , 0x81338135},
{ 0x0FE8 , 0x81338136},
{ 0x0FE9 , 0x81338137},
{ 0x0FEA , 0x81338138},
{ 0x0FEB , 0x81338139},
{ 0x0FEC , 0x81338230},
{ 0x0FED , 0x81338231},
{ 0x0FEE , 0x81338232},
{ 0x0FEF , 0x81338233},
{ 0x0FF0 , 0x81338234},
{ 0x0FF1 , 0x81338235},
{ 0x0FF2 , 0x81338236},
{ 0x0FF3 , 0x81338237},
{ 0x0FF4 , 0x81338238},
{ 0x0FF5 , 0x81338239},
{ 0x0FF6 , 0x81338330},
{ 0x0FF7 , 0x81338331},
{ 0x0FF8 , 0x81338332},
{ 0x0FF9 , 0x81338333},
{ 0x0FFA , 0x81338334},
{ 0x0FFB , 0x81338335},
{ 0x0FFC , 0x81338336},
{ 0x0FFD , 0x81338337},
{ 0x0FFE , 0x81338338},
{ 0x0FFF , 0x81338339},
{ 0x1000 , 0x81338430},
{ 0x1001 , 0x81338431},
{ 0x1002 , 0x81338432},
{ 0x1003 , 0x81338433},
{ 0x1004 , 0x81338434},
{ 0x1005 , 0x81338435},
{ 0x1006 , 0x81338436},
{ 0x1007 , 0x81338437},
{ 0x1008 , 0x81338438},
{ 0x1009 , 0x81338439},
{ 0x100A , 0x81338530},
{ 0x100B , 0x81338531},
{ 0x100C , 0x81338532},
{ 0x100D , 0x81338533},
{ 0x100E , 0x81338534},
{ 0x100F , 0x81338535},
{ 0x1010 , 0x81338536},
{ 0x1011 , 0x81338537},
{ 0x1012 , 0x81338538},
{ 0x1013 , 0x81338539},
{ 0x1014 , 0x81338630},
{ 0x1015 , 0x81338631},
{ 0x1016 , 0x81338632},
{ 0x1017 , 0x81338633},
{ 0x1018 , 0x81338634},
{ 0x1019 , 0x81338635},
{ 0x101A , 0x81338636},
{ 0x101B , 0x81338637},
{ 0x101C , 0x81338638},
{ 0x101D , 0x81338639},
{ 0x101E , 0x81338730},
{ 0x101F , 0x81338731},
{ 0x1020 , 0x81338732},
{ 0x1021 , 0x81338733},
{ 0x1022 , 0x81338734},
{ 0x1023 , 0x81338735},
{ 0x1024 , 0x81338736},
{ 0x1025 , 0x81338737},
{ 0x1026 , 0x81338738},
{ 0x1027 , 0x81338739},
{ 0x1028 , 0x81338830},
{ 0x1029 , 0x81338831},
{ 0x102A , 0x81338832},
{ 0x102B , 0x81338833},
{ 0x102C , 0x81338834},
{ 0x102D , 0x81338835},
{ 0x102E , 0x81338836},
{ 0x102F , 0x81338837},
{ 0x1030 , 0x81338838},
{ 0x1031 , 0x81338839},
{ 0x1032 , 0x81338930},
{ 0x1033 , 0x81338931},
{ 0x1034 , 0x81338932},
{ 0x1035 , 0x81338933},
{ 0x1036 , 0x81338934},
{ 0x1037 , 0x81338935},
{ 0x1038 , 0x81338936},
{ 0x1039 , 0x81338937},
{ 0x103A , 0x81338938},
{ 0x103B , 0x81338939},
{ 0x103C , 0x81338A30},
{ 0x103D , 0x81338A31},
{ 0x103E , 0x81338A32},
{ 0x103F , 0x81338A33},
{ 0x1040 , 0x81338A34},
{ 0x1041 , 0x81338A35},
{ 0x1042 , 0x81338A36},
{ 0x1043 , 0x81338A37},
{ 0x1044 , 0x81338A38},
{ 0x1045 , 0x81338A39},
{ 0x1046 , 0x81338B30},
{ 0x1047 , 0x81338B31},
{ 0x1048 , 0x81338B32},
{ 0x1049 , 0x81338B33},
{ 0x104A , 0x81338B34},
{ 0x104B , 0x81338B35},
{ 0x104C , 0x81338B36},
{ 0x104D , 0x81338B37},
{ 0x104E , 0x81338B38},
{ 0x104F , 0x81338B39},
{ 0x1050 , 0x81338C30},
{ 0x1051 , 0x81338C31},
{ 0x1052 , 0x81338C32},
{ 0x1053 , 0x81338C33},
{ 0x1054 , 0x81338C34},
{ 0x1055 , 0x81338C35},
{ 0x1056 , 0x81338C36},
{ 0x1057 , 0x81338C37},
{ 0x1058 , 0x81338C38},
{ 0x1059 , 0x81338C39},
{ 0x105A , 0x81338D30},
{ 0x105B , 0x81338D31},
{ 0x105C , 0x81338D32},
{ 0x105D , 0x81338D33},
{ 0x105E , 0x81338D34},
{ 0x105F , 0x81338D35},
{ 0x1060 , 0x81338D36},
{ 0x1061 , 0x81338D37},
{ 0x1062 , 0x81338D38},
{ 0x1063 , 0x81338D39},
{ 0x1064 , 0x81338E30},
{ 0x1065 , 0x81338E31},
{ 0x1066 , 0x81338E32},
{ 0x1067 , 0x81338E33},
{ 0x1068 , 0x81338E34},
{ 0x1069 , 0x81338E35},
{ 0x106A , 0x81338E36},
{ 0x106B , 0x81338E37},
{ 0x106C , 0x81338E38},
{ 0x106D , 0x81338E39},
{ 0x106E , 0x81338F30},
{ 0x106F , 0x81338F31},
{ 0x1070 , 0x81338F32},
{ 0x1071 , 0x81338F33},
{ 0x1072 , 0x81338F34},
{ 0x1073 , 0x81338F35},
{ 0x1074 , 0x81338F36},
{ 0x1075 , 0x81338F37},
{ 0x1076 , 0x81338F38},
{ 0x1077 , 0x81338F39},
{ 0x1078 , 0x81339030},
{ 0x1079 , 0x81339031},
{ 0x107A , 0x81339032},
{ 0x107B , 0x81339033},
{ 0x107C , 0x81339034},
{ 0x107D , 0x81339035},
{ 0x107E , 0x81339036},
{ 0x107F , 0x81339037},
{ 0x1080 , 0x81339038},
{ 0x1081 , 0x81339039},
{ 0x1082 , 0x81339130},
{ 0x1083 , 0x81339131},
{ 0x1084 , 0x81339132},
{ 0x1085 , 0x81339133},
{ 0x1086 , 0x81339134},
{ 0x1087 , 0x81339135},
{ 0x1088 , 0x81339136},
{ 0x1089 , 0x81339137},
{ 0x108A , 0x81339138},
{ 0x108B , 0x81339139},
{ 0x108C , 0x81339230},
{ 0x108D , 0x81339231},
{ 0x108E , 0x81339232},
{ 0x108F , 0x81339233},
{ 0x1090 , 0x81339234},
{ 0x1091 , 0x81339235},
{ 0x1092 , 0x81339236},
{ 0x1093 , 0x81339237},
{ 0x1094 , 0x81339238},
{ 0x1095 , 0x81339239},
{ 0x1096 , 0x81339330},
{ 0x1097 , 0x81339331},
{ 0x1098 , 0x81339332},
{ 0x1099 , 0x81339333},
{ 0x109A , 0x81339334},
{ 0x109B , 0x81339335},
{ 0x109C , 0x81339336},
{ 0x109D , 0x81339337},
{ 0x109E , 0x81339338},
{ 0x109F , 0x81339339},
{ 0x10A0 , 0x81339430},
{ 0x10A1 , 0x81339431},
{ 0x10A2 , 0x81339432},
{ 0x10A3 , 0x81339433},
{ 0x10A4 , 0x81339434},
{ 0x10A5 , 0x81339435},
{ 0x10A6 , 0x81339436},
{ 0x10A7 , 0x81339437},
{ 0x10A8 , 0x81339438},
{ 0x10A9 , 0x81339439},
{ 0x10AA , 0x81339530},
{ 0x10AB , 0x81339531},
{ 0x10AC , 0x81339532},
{ 0x10AD , 0x81339533},
{ 0x10AE , 0x81339534},
{ 0x10AF , 0x81339535},
{ 0x10B0 , 0x81339536},
{ 0x10B1 , 0x81339537},
{ 0x10B2 , 0x81339538},
{ 0x10B3 , 0x81339539},
{ 0x10B4 , 0x81339630},
{ 0x10B5 , 0x81339631},
{ 0x10B6 , 0x81339632},
{ 0x10B7 , 0x81339633},
{ 0x10B8 , 0x81339634},
{ 0x10B9 , 0x81339635},
{ 0x10BA , 0x81339636},
{ 0x10BB , 0x81339637},
{ 0x10BC , 0x81339638},
{ 0x10BD , 0x81339639},
{ 0x10BE , 0x81339730},
{ 0x10BF , 0x81339731},
{ 0x10C0 , 0x81339732},
{ 0x10C1 , 0x81339733},
{ 0x10C2 , 0x81339734},
{ 0x10C3 , 0x81339735},
{ 0x10C4 , 0x81339736},
{ 0x10C5 , 0x81339737},
{ 0x10C6 , 0x81339738},
{ 0x10C7 , 0x81339739},
{ 0x10C8 , 0x81339830},
{ 0x10C9 , 0x81339831},
{ 0x10CA , 0x81339832},
{ 0x10CB , 0x81339833},
{ 0x10CC , 0x81339834},
{ 0x10CD , 0x81339835},
{ 0x10CE , 0x81339836},
{ 0x10CF , 0x81339837},
{ 0x10D0 , 0x81339838},
{ 0x10D1 , 0x81339839},
{ 0x10D2 , 0x81339930},
{ 0x10D3 , 0x81339931},
{ 0x10D4 , 0x81339932},
{ 0x10D5 , 0x81339933},
{ 0x10D6 , 0x81339934},
{ 0x10D7 , 0x81339935},
{ 0x10D8 , 0x81339936},
{ 0x10D9 , 0x81339937},
{ 0x10DA , 0x81339938},
{ 0x10DB , 0x81339939},
{ 0x10DC , 0x81339A30},
{ 0x10DD , 0x81339A31},
{ 0x10DE , 0x81339A32},
{ 0x10DF , 0x81339A33},
{ 0x10E0 , 0x81339A34},
{ 0x10E1 , 0x81339A35},
{ 0x10E2 , 0x81339A36},
{ 0x10E3 , 0x81339A37},
{ 0x10E4 , 0x81339A38},
{ 0x10E5 , 0x81339A39},
{ 0x10E6 , 0x81339B30},
{ 0x10E7 , 0x81339B31},
{ 0x10E8 , 0x81339B32},
{ 0x10E9 , 0x81339B33},
{ 0x10EA , 0x81339B34},
{ 0x10EB , 0x81339B35},
{ 0x10EC , 0x81339B36},
{ 0x10ED , 0x81339B37},
{ 0x10EE , 0x81339B38},
{ 0x10EF , 0x81339B39},
{ 0x10F0 , 0x81339C30},
{ 0x10F1 , 0x81339C31},
{ 0x10F2 , 0x81339C32},
{ 0x10F3 , 0x81339C33},
{ 0x10F4 , 0x81339C34},
{ 0x10F5 , 0x81339C35},
{ 0x10F6 , 0x81339C36},
{ 0x10F7 , 0x81339C37},
{ 0x10F8 , 0x81339C38},
{ 0x10F9 , 0x81339C39},
{ 0x10FA , 0x81339D30},
{ 0x10FB , 0x81339D31},
{ 0x10FC , 0x81339D32},
{ 0x10FD , 0x81339D33},
{ 0x10FE , 0x81339D34},
{ 0x10FF , 0x81339D35},
{ 0x1100 , 0x81339D36},
{ 0x1101 , 0x81339D37},
{ 0x1102 , 0x81339D38},
{ 0x1103 , 0x81339D39},
{ 0x1104 , 0x81339E30},
{ 0x1105 , 0x81339E31},
{ 0x1106 , 0x81339E32},
{ 0x1107 , 0x81339E33},
{ 0x1108 , 0x81339E34},
{ 0x1109 , 0x81339E35},
{ 0x110A , 0x81339E36},
{ 0x110B , 0x81339E37},
{ 0x110C , 0x81339E38},
{ 0x110D , 0x81339E39},
{ 0x110E , 0x81339F30},
{ 0x110F , 0x81339F31},
{ 0x1110 , 0x81339F32},
{ 0x1111 , 0x81339F33},
{ 0x1112 , 0x81339F34},
{ 0x1113 , 0x81339F35},
{ 0x1114 , 0x81339F36},
{ 0x1115 , 0x81339F37},
{ 0x1116 , 0x81339F38},
{ 0x1117 , 0x81339F39},
{ 0x1118 , 0x8133A030},
{ 0x1119 , 0x8133A031},
{ 0x111A , 0x8133A032},
{ 0x111B , 0x8133A033},
{ 0x111C , 0x8133A034},
{ 0x111D , 0x8133A035},
{ 0x111E , 0x8133A036},
{ 0x111F , 0x8133A037},
{ 0x1120 , 0x8133A038},
{ 0x1121 , 0x8133A039},
{ 0x1122 , 0x8133A130},
{ 0x1123 , 0x8133A131},
{ 0x1124 , 0x8133A132},
{ 0x1125 , 0x8133A133},
{ 0x1126 , 0x8133A134},
{ 0x1127 , 0x8133A135},
{ 0x1128 , 0x8133A136},
{ 0x1129 , 0x8133A137},
{ 0x112A , 0x8133A138},
{ 0x112B , 0x8133A139},
{ 0x112C , 0x8133A230},
{ 0x112D , 0x8133A231},
{ 0x112E , 0x8133A232},
{ 0x112F , 0x8133A233},
{ 0x1130 , 0x8133A234},
{ 0x1131 , 0x8133A235},
{ 0x1132 , 0x8133A236},
{ 0x1133 , 0x8133A237},
{ 0x1134 , 0x8133A238},
{ 0x1135 , 0x8133A239},
{ 0x1136 , 0x8133A330},
{ 0x1137 , 0x8133A331},
{ 0x1138 , 0x8133A332},
{ 0x1139 , 0x8133A333},
{ 0x113A , 0x8133A334},
{ 0x113B , 0x8133A335},
{ 0x113C , 0x8133A336},
{ 0x113D , 0x8133A337},
{ 0x113E , 0x8133A338},
{ 0x113F , 0x8133A339},
{ 0x1140 , 0x8133A430},
{ 0x1141 , 0x8133A431},
{ 0x1142 , 0x8133A432},
{ 0x1143 , 0x8133A433},
{ 0x1144 , 0x8133A434},
{ 0x1145 , 0x8133A435},
{ 0x1146 , 0x8133A436},
{ 0x1147 , 0x8133A437},
{ 0x1148 , 0x8133A438},
{ 0x1149 , 0x8133A439},
{ 0x114A , 0x8133A530},
{ 0x114B , 0x8133A531},
{ 0x114C , 0x8133A532},
{ 0x114D , 0x8133A533},
{ 0x114E , 0x8133A534},
{ 0x114F , 0x8133A535},
{ 0x1150 , 0x8133A536},
{ 0x1151 , 0x8133A537},
{ 0x1152 , 0x8133A538},
{ 0x1153 , 0x8133A539},
{ 0x1154 , 0x8133A630},
{ 0x1155 , 0x8133A631},
{ 0x1156 , 0x8133A632},
{ 0x1157 , 0x8133A633},
{ 0x1158 , 0x8133A634},
{ 0x1159 , 0x8133A635},
{ 0x115A , 0x8133A636},
{ 0x115B , 0x8133A637},
{ 0x115C , 0x8133A638},
{ 0x115D , 0x8133A639},
{ 0x115E , 0x8133A730},
{ 0x115F , 0x8133A731},
{ 0x1160 , 0x8133A732},
{ 0x1161 , 0x8133A733},
{ 0x1162 , 0x8133A734},
{ 0x1163 , 0x8133A735},
{ 0x1164 , 0x8133A736},
{ 0x1165 , 0x8133A737},
{ 0x1166 , 0x8133A738},
{ 0x1167 , 0x8133A739},
{ 0x1168 , 0x8133A830},
{ 0x1169 , 0x8133A831},
{ 0x116A , 0x8133A832},
{ 0x116B , 0x8133A833},
{ 0x116C , 0x8133A834},
{ 0x116D , 0x8133A835},
{ 0x116E , 0x8133A836},
{ 0x116F , 0x8133A837},
{ 0x1170 , 0x8133A838},
{ 0x1171 , 0x8133A839},
{ 0x1172 , 0x8133A930},
{ 0x1173 , 0x8133A931},
{ 0x1174 , 0x8133A932},
{ 0x1175 , 0x8133A933},
{ 0x1176 , 0x8133A934},
{ 0x1177 , 0x8133A935},
{ 0x1178 , 0x8133A936},
{ 0x1179 , 0x8133A937},
{ 0x117A , 0x8133A938},
{ 0x117B , 0x8133A939},
{ 0x117C , 0x8133AA30},
{ 0x117D , 0x8133AA31},
{ 0x117E , 0x8133AA32},
{ 0x117F , 0x8133AA33},
{ 0x1180 , 0x8133AA34},
{ 0x1181 , 0x8133AA35},
{ 0x1182 , 0x8133AA36},
{ 0x1183 , 0x8133AA37},
{ 0x1184 , 0x8133AA38},
{ 0x1185 , 0x8133AA39},
{ 0x1186 , 0x8133AB30},
{ 0x1187 , 0x8133AB31},
{ 0x1188 , 0x8133AB32},
{ 0x1189 , 0x8133AB33},
{ 0x118A , 0x8133AB34},
{ 0x118B , 0x8133AB35},
{ 0x118C , 0x8133AB36},
{ 0x118D , 0x8133AB37},
{ 0x118E , 0x8133AB38},
{ 0x118F , 0x8133AB39},
{ 0x1190 , 0x8133AC30},
{ 0x1191 , 0x8133AC31},
{ 0x1192 , 0x8133AC32},
{ 0x1193 , 0x8133AC33},
{ 0x1194 , 0x8133AC34},
{ 0x1195 , 0x8133AC35},
{ 0x1196 , 0x8133AC36},
{ 0x1197 , 0x8133AC37},
{ 0x1198 , 0x8133AC38},
{ 0x1199 , 0x8133AC39},
{ 0x119A , 0x8133AD30},
{ 0x119B , 0x8133AD31},
{ 0x119C , 0x8133AD32},
{ 0x119D , 0x8133AD33},
{ 0x119E , 0x8133AD34},
{ 0x119F , 0x8133AD35},
{ 0x11A0 , 0x8133AD36},
{ 0x11A1 , 0x8133AD37},
{ 0x11A2 , 0x8133AD38},
{ 0x11A3 , 0x8133AD39},
{ 0x11A4 , 0x8133AE30},
{ 0x11A5 , 0x8133AE31},
{ 0x11A6 , 0x8133AE32},
{ 0x11A7 , 0x8133AE33},
{ 0x11A8 , 0x8133AE34},
{ 0x11A9 , 0x8133AE35},
{ 0x11AA , 0x8133AE36},
{ 0x11AB , 0x8133AE37},
{ 0x11AC , 0x8133AE38},
{ 0x11AD , 0x8133AE39},
{ 0x11AE , 0x8133AF30},
{ 0x11AF , 0x8133AF31},
{ 0x11B0 , 0x8133AF32},
{ 0x11B1 , 0x8133AF33},
{ 0x11B2 , 0x8133AF34},
{ 0x11B3 , 0x8133AF35},
{ 0x11B4 , 0x8133AF36},
{ 0x11B5 , 0x8133AF37},
{ 0x11B6 , 0x8133AF38},
{ 0x11B7 , 0x8133AF39},
{ 0x11B8 , 0x8133B030},
{ 0x11B9 , 0x8133B031},
{ 0x11BA , 0x8133B032},
{ 0x11BB , 0x8133B033},
{ 0x11BC , 0x8133B034},
{ 0x11BD , 0x8133B035},
{ 0x11BE , 0x8133B036},
{ 0x11BF , 0x8133B037},
{ 0x11C0 , 0x8133B038},
{ 0x11C1 , 0x8133B039},
{ 0x11C2 , 0x8133B130},
{ 0x11C3 , 0x8133B131},
{ 0x11C4 , 0x8133B132},
{ 0x11C5 , 0x8133B133},
{ 0x11C6 , 0x8133B134},
{ 0x11C7 , 0x8133B135},
{ 0x11C8 , 0x8133B136},
{ 0x11C9 , 0x8133B137},
{ 0x11CA , 0x8133B138},
{ 0x11CB , 0x8133B139},
{ 0x11CC , 0x8133B230},
{ 0x11CD , 0x8133B231},
{ 0x11CE , 0x8133B232},
{ 0x11CF , 0x8133B233},
{ 0x11D0 , 0x8133B234},
{ 0x11D1 , 0x8133B235},
{ 0x11D2 , 0x8133B236},
{ 0x11D3 , 0x8133B237},
{ 0x11D4 , 0x8133B238},
{ 0x11D5 , 0x8133B239},
{ 0x11D6 , 0x8133B330},
{ 0x11D7 , 0x8133B331},
{ 0x11D8 , 0x8133B332},
{ 0x11D9 , 0x8133B333},
{ 0x11DA , 0x8133B334},
{ 0x11DB , 0x8133B335},
{ 0x11DC , 0x8133B336},
{ 0x11DD , 0x8133B337},
{ 0x11DE , 0x8133B338},
{ 0x11DF , 0x8133B339},
{ 0x11E0 , 0x8133B430},
{ 0x11E1 , 0x8133B431},
{ 0x11E2 , 0x8133B432},
{ 0x11E3 , 0x8133B433},
{ 0x11E4 , 0x8133B434},
{ 0x11E5 , 0x8133B435},
{ 0x11E6 , 0x8133B436},
{ 0x11E7 , 0x8133B437},
{ 0x11E8 , 0x8133B438},
{ 0x11E9 , 0x8133B439},
{ 0x11EA , 0x8133B530},
{ 0x11EB , 0x8133B531},
{ 0x11EC , 0x8133B532},
{ 0x11ED , 0x8133B533},
{ 0x11EE , 0x8133B534},
{ 0x11EF , 0x8133B535},
{ 0x11F0 , 0x8133B536},
{ 0x11F1 , 0x8133B537},
{ 0x11F2 , 0x8133B538},
{ 0x11F3 , 0x8133B539},
{ 0x11F4 , 0x8133B630},
{ 0x11F5 , 0x8133B631},
{ 0x11F6 , 0x8133B632},
{ 0x11F7 , 0x8133B633},
{ 0x11F8 , 0x8133B634},
{ 0x11F9 , 0x8133B635},
{ 0x11FA , 0x8133B636},
{ 0x11FB , 0x8133B637},
{ 0x11FC , 0x8133B638},
{ 0x11FD , 0x8133B639},
{ 0x11FE , 0x8133B730},
{ 0x11FF , 0x8133B731},
{ 0x1200 , 0x8133B732},
{ 0x1201 , 0x8133B733},
{ 0x1202 , 0x8133B734},
{ 0x1203 , 0x8133B735},
{ 0x1204 , 0x8133B736},
{ 0x1205 , 0x8133B737},
{ 0x1206 , 0x8133B738},
{ 0x1207 , 0x8133B739},
{ 0x1208 , 0x8133B830},
{ 0x1209 , 0x8133B831},
{ 0x120A , 0x8133B832},
{ 0x120B , 0x8133B833},
{ 0x120C , 0x8133B834},
{ 0x120D , 0x8133B835},
{ 0x120E , 0x8133B836},
{ 0x120F , 0x8133B837},
{ 0x1210 , 0x8133B838},
{ 0x1211 , 0x8133B839},
{ 0x1212 , 0x8133B930},
{ 0x1213 , 0x8133B931},
{ 0x1214 , 0x8133B932},
{ 0x1215 , 0x8133B933},
{ 0x1216 , 0x8133B934},
{ 0x1217 , 0x8133B935},
{ 0x1218 , 0x8133B936},
{ 0x1219 , 0x8133B937},
{ 0x121A , 0x8133B938},
{ 0x121B , 0x8133B939},
{ 0x121C , 0x8133BA30},
{ 0x121D , 0x8133BA31},
{ 0x121E , 0x8133BA32},
{ 0x121F , 0x8133BA33},
{ 0x1220 , 0x8133BA34},
{ 0x1221 , 0x8133BA35},
{ 0x1222 , 0x8133BA36},
{ 0x1223 , 0x8133BA37},
{ 0x1224 , 0x8133BA38},
{ 0x1225 , 0x8133BA39},
{ 0x1226 , 0x8133BB30},
{ 0x1227 , 0x8133BB31},
{ 0x1228 , 0x8133BB32},
{ 0x1229 , 0x8133BB33},
{ 0x122A , 0x8133BB34},
{ 0x122B , 0x8133BB35},
{ 0x122C , 0x8133BB36},
{ 0x122D , 0x8133BB37},
{ 0x122E , 0x8133BB38},
{ 0x122F , 0x8133BB39},
{ 0x1230 , 0x8133BC30},
{ 0x1231 , 0x8133BC31},
{ 0x1232 , 0x8133BC32},
{ 0x1233 , 0x8133BC33},
{ 0x1234 , 0x8133BC34},
{ 0x1235 , 0x8133BC35},
{ 0x1236 , 0x8133BC36},
{ 0x1237 , 0x8133BC37},
{ 0x1238 , 0x8133BC38},
{ 0x1239 , 0x8133BC39},
{ 0x123A , 0x8133BD30},
{ 0x123B , 0x8133BD31},
{ 0x123C , 0x8133BD32},
{ 0x123D , 0x8133BD33},
{ 0x123E , 0x8133BD34},
{ 0x123F , 0x8133BD35},
{ 0x1240 , 0x8133BD36},
{ 0x1241 , 0x8133BD37},
{ 0x1242 , 0x8133BD38},
{ 0x1243 , 0x8133BD39},
{ 0x1244 , 0x8133BE30},
{ 0x1245 , 0x8133BE31},
{ 0x1246 , 0x8133BE32},
{ 0x1247 , 0x8133BE33},
{ 0x1248 , 0x8133BE34},
{ 0x1249 , 0x8133BE35},
{ 0x124A , 0x8133BE36},
{ 0x124B , 0x8133BE37},
{ 0x124C , 0x8133BE38},
{ 0x124D , 0x8133BE39},
{ 0x124E , 0x8133BF30},
{ 0x124F , 0x8133BF31},
{ 0x1250 , 0x8133BF32},
{ 0x1251 , 0x8133BF33},
{ 0x1252 , 0x8133BF34},
{ 0x1253 , 0x8133BF35},
{ 0x1254 , 0x8133BF36},
{ 0x1255 , 0x8133BF37},
{ 0x1256 , 0x8133BF38},
{ 0x1257 , 0x8133BF39},
{ 0x1258 , 0x8133C030},
{ 0x1259 , 0x8133C031},
{ 0x125A , 0x8133C032},
{ 0x125B , 0x8133C033},
{ 0x125C , 0x8133C034},
{ 0x125D , 0x8133C035},
{ 0x125E , 0x8133C036},
{ 0x125F , 0x8133C037},
{ 0x1260 , 0x8133C038},
{ 0x1261 , 0x8133C039},
{ 0x1262 , 0x8133C130},
{ 0x1263 , 0x8133C131},
{ 0x1264 , 0x8133C132},
{ 0x1265 , 0x8133C133},
{ 0x1266 , 0x8133C134},
{ 0x1267 , 0x8133C135},
{ 0x1268 , 0x8133C136},
{ 0x1269 , 0x8133C137},
{ 0x126A , 0x8133C138},
{ 0x126B , 0x8133C139},
{ 0x126C , 0x8133C230},
{ 0x126D , 0x8133C231},
{ 0x126E , 0x8133C232},
{ 0x126F , 0x8133C233},
{ 0x1270 , 0x8133C234},
{ 0x1271 , 0x8133C235},
{ 0x1272 , 0x8133C236},
{ 0x1273 , 0x8133C237},
{ 0x1274 , 0x8133C238},
{ 0x1275 , 0x8133C239},
{ 0x1276 , 0x8133C330},
{ 0x1277 , 0x8133C331},
{ 0x1278 , 0x8133C332},
{ 0x1279 , 0x8133C333},
{ 0x127A , 0x8133C334},
{ 0x127B , 0x8133C335},
{ 0x127C , 0x8133C336},
{ 0x127D , 0x8133C337},
{ 0x127E , 0x8133C338},
{ 0x127F , 0x8133C339},
{ 0x1280 , 0x8133C430},
{ 0x1281 , 0x8133C431},
{ 0x1282 , 0x8133C432},
{ 0x1283 , 0x8133C433},
{ 0x1284 , 0x8133C434},
{ 0x1285 , 0x8133C435},
{ 0x1286 , 0x8133C436},
{ 0x1287 , 0x8133C437},
{ 0x1288 , 0x8133C438},
{ 0x1289 , 0x8133C439},
{ 0x128A , 0x8133C530},
{ 0x128B , 0x8133C531},
{ 0x128C , 0x8133C532},
{ 0x128D , 0x8133C533},
{ 0x128E , 0x8133C534},
{ 0x128F , 0x8133C535},
{ 0x1290 , 0x8133C536},
{ 0x1291 , 0x8133C537},
{ 0x1292 , 0x8133C538},
{ 0x1293 , 0x8133C539},
{ 0x1294 , 0x8133C630},
{ 0x1295 , 0x8133C631},
{ 0x1296 , 0x8133C632},
{ 0x1297 , 0x8133C633},
{ 0x1298 , 0x8133C634},
{ 0x1299 , 0x8133C635},
{ 0x129A , 0x8133C636},
{ 0x129B , 0x8133C637},
{ 0x129C , 0x8133C638},
{ 0x129D , 0x8133C639},
{ 0x129E , 0x8133C730},
{ 0x129F , 0x8133C731},
{ 0x12A0 , 0x8133C732},
{ 0x12A1 , 0x8133C733},
{ 0x12A2 , 0x8133C734},
{ 0x12A3 , 0x8133C735},
{ 0x12A4 , 0x8133C736},
{ 0x12A5 , 0x8133C737},
{ 0x12A6 , 0x8133C738},
{ 0x12A7 , 0x8133C739},
{ 0x12A8 , 0x8133C830},
{ 0x12A9 , 0x8133C831},
{ 0x12AA , 0x8133C832},
{ 0x12AB , 0x8133C833},
{ 0x12AC , 0x8133C834},
{ 0x12AD , 0x8133C835},
{ 0x12AE , 0x8133C836},
{ 0x12AF , 0x8133C837},
{ 0x12B0 , 0x8133C838},
{ 0x12B1 , 0x8133C839},
{ 0x12B2 , 0x8133C930},
{ 0x12B3 , 0x8133C931},
{ 0x12B4 , 0x8133C932},
{ 0x12B5 , 0x8133C933},
{ 0x12B6 , 0x8133C934},
{ 0x12B7 , 0x8133C935},
{ 0x12B8 , 0x8133C936},
{ 0x12B9 , 0x8133C937},
{ 0x12BA , 0x8133C938},
{ 0x12BB , 0x8133C939},
{ 0x12BC , 0x8133CA30},
{ 0x12BD , 0x8133CA31},
{ 0x12BE , 0x8133CA32},
{ 0x12BF , 0x8133CA33},
{ 0x12C0 , 0x8133CA34},
{ 0x12C1 , 0x8133CA35},
{ 0x12C2 , 0x8133CA36},
{ 0x12C3 , 0x8133CA37},
{ 0x12C4 , 0x8133CA38},
{ 0x12C5 , 0x8133CA39},
{ 0x12C6 , 0x8133CB30},
{ 0x12C7 , 0x8133CB31},
{ 0x12C8 , 0x8133CB32},
{ 0x12C9 , 0x8133CB33},
{ 0x12CA , 0x8133CB34},
{ 0x12CB , 0x8133CB35},
{ 0x12CC , 0x8133CB36},
{ 0x12CD , 0x8133CB37},
{ 0x12CE , 0x8133CB38},
{ 0x12CF , 0x8133CB39},
{ 0x12D0 , 0x8133CC30},
{ 0x12D1 , 0x8133CC31},
{ 0x12D2 , 0x8133CC32},
{ 0x12D3 , 0x8133CC33},
{ 0x12D4 , 0x8133CC34},
{ 0x12D5 , 0x8133CC35},
{ 0x12D6 , 0x8133CC36},
{ 0x12D7 , 0x8133CC37},
{ 0x12D8 , 0x8133CC38},
{ 0x12D9 , 0x8133CC39},
{ 0x12DA , 0x8133CD30},
{ 0x12DB , 0x8133CD31},
{ 0x12DC , 0x8133CD32},
{ 0x12DD , 0x8133CD33},
{ 0x12DE , 0x8133CD34},
{ 0x12DF , 0x8133CD35},
{ 0x12E0 , 0x8133CD36},
{ 0x12E1 , 0x8133CD37},
{ 0x12E2 , 0x8133CD38},
{ 0x12E3 , 0x8133CD39},
{ 0x12E4 , 0x8133CE30},
{ 0x12E5 , 0x8133CE31},
{ 0x12E6 , 0x8133CE32},
{ 0x12E7 , 0x8133CE33},
{ 0x12E8 , 0x8133CE34},
{ 0x12E9 , 0x8133CE35},
{ 0x12EA , 0x8133CE36},
{ 0x12EB , 0x8133CE37},
{ 0x12EC , 0x8133CE38},
{ 0x12ED , 0x8133CE39},
{ 0x12EE , 0x8133CF30},
{ 0x12EF , 0x8133CF31},
{ 0x12F0 , 0x8133CF32},
{ 0x12F1 , 0x8133CF33},
{ 0x12F2 , 0x8133CF34},
{ 0x12F3 , 0x8133CF35},
{ 0x12F4 , 0x8133CF36},
{ 0x12F5 , 0x8133CF37},
{ 0x12F6 , 0x8133CF38},
{ 0x12F7 , 0x8133CF39},
{ 0x12F8 , 0x8133D030},
{ 0x12F9 , 0x8133D031},
{ 0x12FA , 0x8133D032},
{ 0x12FB , 0x8133D033},
{ 0x12FC , 0x8133D034},
{ 0x12FD , 0x8133D035},
{ 0x12FE , 0x8133D036},
{ 0x12FF , 0x8133D037},
{ 0x1300 , 0x8133D038},
{ 0x1301 , 0x8133D039},
{ 0x1302 , 0x8133D130},
{ 0x1303 , 0x8133D131},
{ 0x1304 , 0x8133D132},
{ 0x1305 , 0x8133D133},
{ 0x1306 , 0x8133D134},
{ 0x1307 , 0x8133D135},
{ 0x1308 , 0x8133D136},
{ 0x1309 , 0x8133D137},
{ 0x130A , 0x8133D138},
{ 0x130B , 0x8133D139},
{ 0x130C , 0x8133D230},
{ 0x130D , 0x8133D231},
{ 0x130E , 0x8133D232},
{ 0x130F , 0x8133D233},
{ 0x1310 , 0x8133D234},
{ 0x1311 , 0x8133D235},
{ 0x1312 , 0x8133D236},
{ 0x1313 , 0x8133D237},
{ 0x1314 , 0x8133D238},
{ 0x1315 , 0x8133D239},
{ 0x1316 , 0x8133D330},
{ 0x1317 , 0x8133D331},
{ 0x1318 , 0x8133D332},
{ 0x1319 , 0x8133D333},
{ 0x131A , 0x8133D334},
{ 0x131B , 0x8133D335},
{ 0x131C , 0x8133D336},
{ 0x131D , 0x8133D337},
{ 0x131E , 0x8133D338},
{ 0x131F , 0x8133D339},
{ 0x1320 , 0x8133D430},
{ 0x1321 , 0x8133D431},
{ 0x1322 , 0x8133D432},
{ 0x1323 , 0x8133D433},
{ 0x1324 , 0x8133D434},
{ 0x1325 , 0x8133D435},
{ 0x1326 , 0x8133D436},
{ 0x1327 , 0x8133D437},
{ 0x1328 , 0x8133D438},
{ 0x1329 , 0x8133D439},
{ 0x132A , 0x8133D530},
{ 0x132B , 0x8133D531},
{ 0x132C , 0x8133D532},
{ 0x132D , 0x8133D533},
{ 0x132E , 0x8133D534},
{ 0x132F , 0x8133D535},
{ 0x1330 , 0x8133D536},
{ 0x1331 , 0x8133D537},
{ 0x1332 , 0x8133D538},
{ 0x1333 , 0x8133D539},
{ 0x1334 , 0x8133D630},
{ 0x1335 , 0x8133D631},
{ 0x1336 , 0x8133D632},
{ 0x1337 , 0x8133D633},
{ 0x1338 , 0x8133D634},
{ 0x1339 , 0x8133D635},
{ 0x133A , 0x8133D636},
{ 0x133B , 0x8133D637},
{ 0x133C , 0x8133D638},
{ 0x133D , 0x8133D639},
{ 0x133E , 0x8133D730},
{ 0x133F , 0x8133D731},
{ 0x1340 , 0x8133D732},
{ 0x1341 , 0x8133D733},
{ 0x1342 , 0x8133D734},
{ 0x1343 , 0x8133D735},
{ 0x1344 , 0x8133D736},
{ 0x1345 , 0x8133D737},
{ 0x1346 , 0x8133D738},
{ 0x1347 , 0x8133D739},
{ 0x1348 , 0x8133D830},
{ 0x1349 , 0x8133D831},
{ 0x134A , 0x8133D832},
{ 0x134B , 0x8133D833},
{ 0x134C , 0x8133D834},
{ 0x134D , 0x8133D835},
{ 0x134E , 0x8133D836},
{ 0x134F , 0x8133D837},
{ 0x1350 , 0x8133D838},
{ 0x1351 , 0x8133D839},
{ 0x1352 , 0x8133D930},
{ 0x1353 , 0x8133D931},
{ 0x1354 , 0x8133D932},
{ 0x1355 , 0x8133D933},
{ 0x1356 , 0x8133D934},
{ 0x1357 , 0x8133D935},
{ 0x1358 , 0x8133D936},
{ 0x1359 , 0x8133D937},
{ 0x135A , 0x8133D938},
{ 0x135B , 0x8133D939},
{ 0x135C , 0x8133DA30},
{ 0x135D , 0x8133DA31},
{ 0x135E , 0x8133DA32},
{ 0x135F , 0x8133DA33},
{ 0x1360 , 0x8133DA34},
{ 0x1361 , 0x8133DA35},
{ 0x1362 , 0x8133DA36},
{ 0x1363 , 0x8133DA37},
{ 0x1364 , 0x8133DA38},
{ 0x1365 , 0x8133DA39},
{ 0x1366 , 0x8133DB30},
{ 0x1367 , 0x8133DB31},
{ 0x1368 , 0x8133DB32},
{ 0x1369 , 0x8133DB33},
{ 0x136A , 0x8133DB34},
{ 0x136B , 0x8133DB35},
{ 0x136C , 0x8133DB36},
{ 0x136D , 0x8133DB37},
{ 0x136E , 0x8133DB38},
{ 0x136F , 0x8133DB39},
{ 0x1370 , 0x8133DC30},
{ 0x1371 , 0x8133DC31},
{ 0x1372 , 0x8133DC32},
{ 0x1373 , 0x8133DC33},
{ 0x1374 , 0x8133DC34},
{ 0x1375 , 0x8133DC35},
{ 0x1376 , 0x8133DC36},
{ 0x1377 , 0x8133DC37},
{ 0x1378 , 0x8133DC38},
{ 0x1379 , 0x8133DC39},
{ 0x137A , 0x8133DD30},
{ 0x137B , 0x8133DD31},
{ 0x137C , 0x8133DD32},
{ 0x137D , 0x8133DD33},
{ 0x137E , 0x8133DD34},
{ 0x137F , 0x8133DD35},
{ 0x1380 , 0x8133DD36},
{ 0x1381 , 0x8133DD37},
{ 0x1382 , 0x8133DD38},
{ 0x1383 , 0x8133DD39},
{ 0x1384 , 0x8133DE30},
{ 0x1385 , 0x8133DE31},
{ 0x1386 , 0x8133DE32},
{ 0x1387 , 0x8133DE33},
{ 0x1388 , 0x8133DE34},
{ 0x1389 , 0x8133DE35},
{ 0x138A , 0x8133DE36},
{ 0x138B , 0x8133DE37},
{ 0x138C , 0x8133DE38},
{ 0x138D , 0x8133DE39},
{ 0x138E , 0x8133DF30},
{ 0x138F , 0x8133DF31},
{ 0x1390 , 0x8133DF32},
{ 0x1391 , 0x8133DF33},
{ 0x1392 , 0x8133DF34},
{ 0x1393 , 0x8133DF35},
{ 0x1394 , 0x8133DF36},
{ 0x1395 , 0x8133DF37},
{ 0x1396 , 0x8133DF38},
{ 0x1397 , 0x8133DF39},
{ 0x1398 , 0x8133E030},
{ 0x1399 , 0x8133E031},
{ 0x139A , 0x8133E032},
{ 0x139B , 0x8133E033},
{ 0x139C , 0x8133E034},
{ 0x139D , 0x8133E035},
{ 0x139E , 0x8133E036},
{ 0x139F , 0x8133E037},
{ 0x13A0 , 0x8133E038},
{ 0x13A1 , 0x8133E039},
{ 0x13A2 , 0x8133E130},
{ 0x13A3 , 0x8133E131},
{ 0x13A4 , 0x8133E132},
{ 0x13A5 , 0x8133E133},
{ 0x13A6 , 0x8133E134},
{ 0x13A7 , 0x8133E135},
{ 0x13A8 , 0x8133E136},
{ 0x13A9 , 0x8133E137},
{ 0x13AA , 0x8133E138},
{ 0x13AB , 0x8133E139},
{ 0x13AC , 0x8133E230},
{ 0x13AD , 0x8133E231},
{ 0x13AE , 0x8133E232},
{ 0x13AF , 0x8133E233},
{ 0x13B0 , 0x8133E234},
{ 0x13B1 , 0x8133E235},
{ 0x13B2 , 0x8133E236},
{ 0x13B3 , 0x8133E237},
{ 0x13B4 , 0x8133E238},
{ 0x13B5 , 0x8133E239},
{ 0x13B6 , 0x8133E330},
{ 0x13B7 , 0x8133E331},
{ 0x13B8 , 0x8133E332},
{ 0x13B9 , 0x8133E333},
{ 0x13BA , 0x8133E334},
{ 0x13BB , 0x8133E335},
{ 0x13BC , 0x8133E336},
{ 0x13BD , 0x8133E337},
{ 0x13BE , 0x8133E338},
{ 0x13BF , 0x8133E339},
{ 0x13C0 , 0x8133E430},
{ 0x13C1 , 0x8133E431},
{ 0x13C2 , 0x8133E432},
{ 0x13C3 , 0x8133E433},
{ 0x13C4 , 0x8133E434},
{ 0x13C5 , 0x8133E435},
{ 0x13C6 , 0x8133E436},
{ 0x13C7 , 0x8133E437},
{ 0x13C8 , 0x8133E438},
{ 0x13C9 , 0x8133E439},
{ 0x13CA , 0x8133E530},
{ 0x13CB , 0x8133E531},
{ 0x13CC , 0x8133E532},
{ 0x13CD , 0x8133E533},
{ 0x13CE , 0x8133E534},
{ 0x13CF , 0x8133E535},
{ 0x13D0 , 0x8133E536},
{ 0x13D1 , 0x8133E537},
{ 0x13D2 , 0x8133E538},
{ 0x13D3 , 0x8133E539},
{ 0x13D4 , 0x8133E630},
{ 0x13D5 , 0x8133E631},
{ 0x13D6 , 0x8133E632},
{ 0x13D7 , 0x8133E633},
{ 0x13D8 , 0x8133E634},
{ 0x13D9 , 0x8133E635},
{ 0x13DA , 0x8133E636},
{ 0x13DB , 0x8133E637},
{ 0x13DC , 0x8133E638},
{ 0x13DD , 0x8133E639},
{ 0x13DE , 0x8133E730},
{ 0x13DF , 0x8133E731},
{ 0x13E0 , 0x8133E732},
{ 0x13E1 , 0x8133E733},
{ 0x13E2 , 0x8133E734},
{ 0x13E3 , 0x8133E735},
{ 0x13E4 , 0x8133E736},
{ 0x13E5 , 0x8133E737},
{ 0x13E6 , 0x8133E738},
{ 0x13E7 , 0x8133E739},
{ 0x13E8 , 0x8133E830},
{ 0x13E9 , 0x8133E831},
{ 0x13EA , 0x8133E832},
{ 0x13EB , 0x8133E833},
{ 0x13EC , 0x8133E834},
{ 0x13ED , 0x8133E835},
{ 0x13EE , 0x8133E836},
{ 0x13EF , 0x8133E837},
{ 0x13F0 , 0x8133E838},
{ 0x13F1 , 0x8133E839},
{ 0x13F2 , 0x8133E930},
{ 0x13F3 , 0x8133E931},
{ 0x13F4 , 0x8133E932},
{ 0x13F5 , 0x8133E933},
{ 0x13F6 , 0x8133E934},
{ 0x13F7 , 0x8133E935},
{ 0x13F8 , 0x8133E936},
{ 0x13F9 , 0x8133E937},
{ 0x13FA , 0x8133E938},
{ 0x13FB , 0x8133E939},
{ 0x13FC , 0x8133EA30},
{ 0x13FD , 0x8133EA31},
{ 0x13FE , 0x8133EA32},
{ 0x13FF , 0x8133EA33},
{ 0x1400 , 0x8133EA34},
{ 0x1401 , 0x8133EA35},
{ 0x1402 , 0x8133EA36},
{ 0x1403 , 0x8133EA37},
{ 0x1404 , 0x8133EA38},
{ 0x1405 , 0x8133EA39},
{ 0x1406 , 0x8133EB30},
{ 0x1407 , 0x8133EB31},
{ 0x1408 , 0x8133EB32},
{ 0x1409 , 0x8133EB33},
{ 0x140A , 0x8133EB34},
{ 0x140B , 0x8133EB35},
{ 0x140C , 0x8133EB36},
{ 0x140D , 0x8133EB37},
{ 0x140E , 0x8133EB38},
{ 0x140F , 0x8133EB39},
{ 0x1410 , 0x8133EC30},
{ 0x1411 , 0x8133EC31},
{ 0x1412 , 0x8133EC32},
{ 0x1413 , 0x8133EC33},
{ 0x1414 , 0x8133EC34},
{ 0x1415 , 0x8133EC35},
{ 0x1416 , 0x8133EC36},
{ 0x1417 , 0x8133EC37},
{ 0x1418 , 0x8133EC38},
{ 0x1419 , 0x8133EC39},
{ 0x141A , 0x8133ED30},
{ 0x141B , 0x8133ED31},
{ 0x141C , 0x8133ED32},
{ 0x141D , 0x8133ED33},
{ 0x141E , 0x8133ED34},
{ 0x141F , 0x8133ED35},
{ 0x1420 , 0x8133ED36},
{ 0x1421 , 0x8133ED37},
{ 0x1422 , 0x8133ED38},
{ 0x1423 , 0x8133ED39},
{ 0x1424 , 0x8133EE30},
{ 0x1425 , 0x8133EE31},
{ 0x1426 , 0x8133EE32},
{ 0x1427 , 0x8133EE33},
{ 0x1428 , 0x8133EE34},
{ 0x1429 , 0x8133EE35},
{ 0x142A , 0x8133EE36},
{ 0x142B , 0x8133EE37},
{ 0x142C , 0x8133EE38},
{ 0x142D , 0x8133EE39},
{ 0x142E , 0x8133EF30},
{ 0x142F , 0x8133EF31},
{ 0x1430 , 0x8133EF32},
{ 0x1431 , 0x8133EF33},
{ 0x1432 , 0x8133EF34},
{ 0x1433 , 0x8133EF35},
{ 0x1434 , 0x8133EF36},
{ 0x1435 , 0x8133EF37},
{ 0x1436 , 0x8133EF38},
{ 0x1437 , 0x8133EF39},
{ 0x1438 , 0x8133F030},
{ 0x1439 , 0x8133F031},
{ 0x143A , 0x8133F032},
{ 0x143B , 0x8133F033},
{ 0x143C , 0x8133F034},
{ 0x143D , 0x8133F035},
{ 0x143E , 0x8133F036},
{ 0x143F , 0x8133F037},
{ 0x1440 , 0x8133F038},
{ 0x1441 , 0x8133F039},
{ 0x1442 , 0x8133F130},
{ 0x1443 , 0x8133F131},
{ 0x1444 , 0x8133F132},
{ 0x1445 , 0x8133F133},
{ 0x1446 , 0x8133F134},
{ 0x1447 , 0x8133F135},
{ 0x1448 , 0x8133F136},
{ 0x1449 , 0x8133F137},
{ 0x144A , 0x8133F138},
{ 0x144B , 0x8133F139},
{ 0x144C , 0x8133F230},
{ 0x144D , 0x8133F231},
{ 0x144E , 0x8133F232},
{ 0x144F , 0x8133F233},
{ 0x1450 , 0x8133F234},
{ 0x1451 , 0x8133F235},
{ 0x1452 , 0x8133F236},
{ 0x1453 , 0x8133F237},
{ 0x1454 , 0x8133F238},
{ 0x1455 , 0x8133F239},
{ 0x1456 , 0x8133F330},
{ 0x1457 , 0x8133F331},
{ 0x1458 , 0x8133F332},
{ 0x1459 , 0x8133F333},
{ 0x145A , 0x8133F334},
{ 0x145B , 0x8133F335},
{ 0x145C , 0x8133F336},
{ 0x145D , 0x8133F337},
{ 0x145E , 0x8133F338},
{ 0x145F , 0x8133F339},
{ 0x1460 , 0x8133F430},
{ 0x1461 , 0x8133F431},
{ 0x1462 , 0x8133F432},
{ 0x1463 , 0x8133F433},
{ 0x1464 , 0x8133F434},
{ 0x1465 , 0x8133F435},
{ 0x1466 , 0x8133F436},
{ 0x1467 , 0x8133F437},
{ 0x1468 , 0x8133F438},
{ 0x1469 , 0x8133F439},
{ 0x146A , 0x8133F530},
{ 0x146B , 0x8133F531},
{ 0x146C , 0x8133F532},
{ 0x146D , 0x8133F533},
{ 0x146E , 0x8133F534},
{ 0x146F , 0x8133F535},
{ 0x1470 , 0x8133F536},
{ 0x1471 , 0x8133F537},
{ 0x1472 , 0x8133F538},
{ 0x1473 , 0x8133F539},
{ 0x1474 , 0x8133F630},
{ 0x1475 , 0x8133F631},
{ 0x1476 , 0x8133F632},
{ 0x1477 , 0x8133F633},
{ 0x1478 , 0x8133F634},
{ 0x1479 , 0x8133F635},
{ 0x147A , 0x8133F636},
{ 0x147B , 0x8133F637},
{ 0x147C , 0x8133F638},
{ 0x147D , 0x8133F639},
{ 0x147E , 0x8133F730},
{ 0x147F , 0x8133F731},
{ 0x1480 , 0x8133F732},
{ 0x1481 , 0x8133F733},
{ 0x1482 , 0x8133F734},
{ 0x1483 , 0x8133F735},
{ 0x1484 , 0x8133F736},
{ 0x1485 , 0x8133F737},
{ 0x1486 , 0x8133F738},
{ 0x1487 , 0x8133F739},
{ 0x1488 , 0x8133F830},
{ 0x1489 , 0x8133F831},
{ 0x148A , 0x8133F832},
{ 0x148B , 0x8133F833},
{ 0x148C , 0x8133F834},
{ 0x148D , 0x8133F835},
{ 0x148E , 0x8133F836},
{ 0x148F , 0x8133F837},
{ 0x1490 , 0x8133F838},
{ 0x1491 , 0x8133F839},
{ 0x1492 , 0x8133F930},
{ 0x1493 , 0x8133F931},
{ 0x1494 , 0x8133F932},
{ 0x1495 , 0x8133F933},
{ 0x1496 , 0x8133F934},
{ 0x1497 , 0x8133F935},
{ 0x1498 , 0x8133F936},
{ 0x1499 , 0x8133F937},
{ 0x149A , 0x8133F938},
{ 0x149B , 0x8133F939},
{ 0x149C , 0x8133FA30},
{ 0x149D , 0x8133FA31},
{ 0x149E , 0x8133FA32},
{ 0x149F , 0x8133FA33},
{ 0x14A0 , 0x8133FA34},
{ 0x14A1 , 0x8133FA35},
{ 0x14A2 , 0x8133FA36},
{ 0x14A3 , 0x8133FA37},
{ 0x14A4 , 0x8133FA38},
{ 0x14A5 , 0x8133FA39},
{ 0x14A6 , 0x8133FB30},
{ 0x14A7 , 0x8133FB31},
{ 0x14A8 , 0x8133FB32},
{ 0x14A9 , 0x8133FB33},
{ 0x14AA , 0x8133FB34},
{ 0x14AB , 0x8133FB35},
{ 0x14AC , 0x8133FB36},
{ 0x14AD , 0x8133FB37},
{ 0x14AE , 0x8133FB38},
{ 0x14AF , 0x8133FB39},
{ 0x14B0 , 0x8133FC30},
{ 0x14B1 , 0x8133FC31},
{ 0x14B2 , 0x8133FC32},
{ 0x14B3 , 0x8133FC33},
{ 0x14B4 , 0x8133FC34},
{ 0x14B5 , 0x8133FC35},
{ 0x14B6 , 0x8133FC36},
{ 0x14B7 , 0x8133FC37},
{ 0x14B8 , 0x8133FC38},
{ 0x14B9 , 0x8133FC39},
{ 0x14BA , 0x8133FD30},
{ 0x14BB , 0x8133FD31},
{ 0x14BC , 0x8133FD32},
{ 0x14BD , 0x8133FD33},
{ 0x14BE , 0x8133FD34},
{ 0x14BF , 0x8133FD35},
{ 0x14C0 , 0x8133FD36},
{ 0x14C1 , 0x8133FD37},
{ 0x14C2 , 0x8133FD38},
{ 0x14C3 , 0x8133FD39},
{ 0x14C4 , 0x8133FE30},
{ 0x14C5 , 0x8133FE31},
{ 0x14C6 , 0x8133FE32},
{ 0x14C7 , 0x8133FE33},
{ 0x14C8 , 0x8133FE34},
{ 0x14C9 , 0x8133FE35},
{ 0x14CA , 0x8133FE36},
{ 0x14CB , 0x8133FE37},
{ 0x14CC , 0x8133FE38},
{ 0x14CD , 0x8133FE39},
{ 0x14CE , 0x81348130},
{ 0x14CF , 0x81348131},
{ 0x14D0 , 0x81348132},
{ 0x14D1 , 0x81348133},
{ 0x14D2 , 0x81348134},
{ 0x14D3 , 0x81348135},
{ 0x14D4 , 0x81348136},
{ 0x14D5 , 0x81348137},
{ 0x14D6 , 0x81348138},
{ 0x14D7 , 0x81348139},
{ 0x14D8 , 0x81348230},
{ 0x14D9 , 0x81348231},
{ 0x14DA , 0x81348232},
{ 0x14DB , 0x81348233},
{ 0x14DC , 0x81348234},
{ 0x14DD , 0x81348235},
{ 0x14DE , 0x81348236},
{ 0x14DF , 0x81348237},
{ 0x14E0 , 0x81348238},
{ 0x14E1 , 0x81348239},
{ 0x14E2 , 0x81348330},
{ 0x14E3 , 0x81348331},
{ 0x14E4 , 0x81348332},
{ 0x14E5 , 0x81348333},
{ 0x14E6 , 0x81348334},
{ 0x14E7 , 0x81348335},
{ 0x14E8 , 0x81348336},
{ 0x14E9 , 0x81348337},
{ 0x14EA , 0x81348338},
{ 0x14EB , 0x81348339},
{ 0x14EC , 0x81348430},
{ 0x14ED , 0x81348431},
{ 0x14EE , 0x81348432},
{ 0x14EF , 0x81348433},
{ 0x14F0 , 0x81348434},
{ 0x14F1 , 0x81348435},
{ 0x14F2 , 0x81348436},
{ 0x14F3 , 0x81348437},
{ 0x14F4 , 0x81348438},
{ 0x14F5 , 0x81348439},
{ 0x14F6 , 0x81348530},
{ 0x14F7 , 0x81348531},
{ 0x14F8 , 0x81348532},
{ 0x14F9 , 0x81348533},
{ 0x14FA , 0x81348534},
{ 0x14FB , 0x81348535},
{ 0x14FC , 0x81348536},
{ 0x14FD , 0x81348537},
{ 0x14FE , 0x81348538},
{ 0x14FF , 0x81348539},
{ 0x1500 , 0x81348630},
{ 0x1501 , 0x81348631},
{ 0x1502 , 0x81348632},
{ 0x1503 , 0x81348633},
{ 0x1504 , 0x81348634},
{ 0x1505 , 0x81348635},
{ 0x1506 , 0x81348636},
{ 0x1507 , 0x81348637},
{ 0x1508 , 0x81348638},
{ 0x1509 , 0x81348639},
{ 0x150A , 0x81348730},
{ 0x150B , 0x81348731},
{ 0x150C , 0x81348732},
{ 0x150D , 0x81348733},
{ 0x150E , 0x81348734},
{ 0x150F , 0x81348735},
{ 0x1510 , 0x81348736},
{ 0x1511 , 0x81348737},
{ 0x1512 , 0x81348738},
{ 0x1513 , 0x81348739},
{ 0x1514 , 0x81348830},
{ 0x1515 , 0x81348831},
{ 0x1516 , 0x81348832},
{ 0x1517 , 0x81348833},
{ 0x1518 , 0x81348834},
{ 0x1519 , 0x81348835},
{ 0x151A , 0x81348836},
{ 0x151B , 0x81348837},
{ 0x151C , 0x81348838},
{ 0x151D , 0x81348839},
{ 0x151E , 0x81348930},
{ 0x151F , 0x81348931},
{ 0x1520 , 0x81348932},
{ 0x1521 , 0x81348933},
{ 0x1522 , 0x81348934},
{ 0x1523 , 0x81348935},
{ 0x1524 , 0x81348936},
{ 0x1525 , 0x81348937},
{ 0x1526 , 0x81348938},
{ 0x1527 , 0x81348939},
{ 0x1528 , 0x81348A30},
{ 0x1529 , 0x81348A31},
{ 0x152A , 0x81348A32},
{ 0x152B , 0x81348A33},
{ 0x152C , 0x81348A34},
{ 0x152D , 0x81348A35},
{ 0x152E , 0x81348A36},
{ 0x152F , 0x81348A37},
{ 0x1530 , 0x81348A38},
{ 0x1531 , 0x81348A39},
{ 0x1532 , 0x81348B30},
{ 0x1533 , 0x81348B31},
{ 0x1534 , 0x81348B32},
{ 0x1535 , 0x81348B33},
{ 0x1536 , 0x81348B34},
{ 0x1537 , 0x81348B35},
{ 0x1538 , 0x81348B36},
{ 0x1539 , 0x81348B37},
{ 0x153A , 0x81348B38},
{ 0x153B , 0x81348B39},
{ 0x153C , 0x81348C30},
{ 0x153D , 0x81348C31},
{ 0x153E , 0x81348C32},
{ 0x153F , 0x81348C33},
{ 0x1540 , 0x81348C34},
{ 0x1541 , 0x81348C35},
{ 0x1542 , 0x81348C36},
{ 0x1543 , 0x81348C37},
{ 0x1544 , 0x81348C38},
{ 0x1545 , 0x81348C39},
{ 0x1546 , 0x81348D30},
{ 0x1547 , 0x81348D31},
{ 0x1548 , 0x81348D32},
{ 0x1549 , 0x81348D33},
{ 0x154A , 0x81348D34},
{ 0x154B , 0x81348D35},
{ 0x154C , 0x81348D36},
{ 0x154D , 0x81348D37},
{ 0x154E , 0x81348D38},
{ 0x154F , 0x81348D39},
{ 0x1550 , 0x81348E30},
{ 0x1551 , 0x81348E31},
{ 0x1552 , 0x81348E32},
{ 0x1553 , 0x81348E33},
{ 0x1554 , 0x81348E34},
{ 0x1555 , 0x81348E35},
{ 0x1556 , 0x81348E36},
{ 0x1557 , 0x81348E37},
{ 0x1558 , 0x81348E38},
{ 0x1559 , 0x81348E39},
{ 0x155A , 0x81348F30},
{ 0x155B , 0x81348F31},
{ 0x155C , 0x81348F32},
{ 0x155D , 0x81348F33},
{ 0x155E , 0x81348F34},
{ 0x155F , 0x81348F35},
{ 0x1560 , 0x81348F36},
{ 0x1561 , 0x81348F37},
{ 0x1562 , 0x81348F38},
{ 0x1563 , 0x81348F39},
{ 0x1564 , 0x81349030},
{ 0x1565 , 0x81349031},
{ 0x1566 , 0x81349032},
{ 0x1567 , 0x81349033},
{ 0x1568 , 0x81349034},
{ 0x1569 , 0x81349035},
{ 0x156A , 0x81349036},
{ 0x156B , 0x81349037},
{ 0x156C , 0x81349038},
{ 0x156D , 0x81349039},
{ 0x156E , 0x81349130},
{ 0x156F , 0x81349131},
{ 0x1570 , 0x81349132},
{ 0x1571 , 0x81349133},
{ 0x1572 , 0x81349134},
{ 0x1573 , 0x81349135},
{ 0x1574 , 0x81349136},
{ 0x1575 , 0x81349137},
{ 0x1576 , 0x81349138},
{ 0x1577 , 0x81349139},
{ 0x1578 , 0x81349230},
{ 0x1579 , 0x81349231},
{ 0x157A , 0x81349232},
{ 0x157B , 0x81349233},
{ 0x157C , 0x81349234},
{ 0x157D , 0x81349235},
{ 0x157E , 0x81349236},
{ 0x157F , 0x81349237},
{ 0x1580 , 0x81349238},
{ 0x1581 , 0x81349239},
{ 0x1582 , 0x81349330},
{ 0x1583 , 0x81349331},
{ 0x1584 , 0x81349332},
{ 0x1585 , 0x81349333},
{ 0x1586 , 0x81349334},
{ 0x1587 , 0x81349335},
{ 0x1588 , 0x81349336},
{ 0x1589 , 0x81349337},
{ 0x158A , 0x81349338},
{ 0x158B , 0x81349339},
{ 0x158C , 0x81349430},
{ 0x158D , 0x81349431},
{ 0x158E , 0x81349432},
{ 0x158F , 0x81349433},
{ 0x1590 , 0x81349434},
{ 0x1591 , 0x81349435},
{ 0x1592 , 0x81349436},
{ 0x1593 , 0x81349437},
{ 0x1594 , 0x81349438},
{ 0x1595 , 0x81349439},
{ 0x1596 , 0x81349530},
{ 0x1597 , 0x81349531},
{ 0x1598 , 0x81349532},
{ 0x1599 , 0x81349533},
{ 0x159A , 0x81349534},
{ 0x159B , 0x81349535},
{ 0x159C , 0x81349536},
{ 0x159D , 0x81349537},
{ 0x159E , 0x81349538},
{ 0x159F , 0x81349539},
{ 0x15A0 , 0x81349630},
{ 0x15A1 , 0x81349631},
{ 0x15A2 , 0x81349632},
{ 0x15A3 , 0x81349633},
{ 0x15A4 , 0x81349634},
{ 0x15A5 , 0x81349635},
{ 0x15A6 , 0x81349636},
{ 0x15A7 , 0x81349637},
{ 0x15A8 , 0x81349638},
{ 0x15A9 , 0x81349639},
{ 0x15AA , 0x81349730},
{ 0x15AB , 0x81349731},
{ 0x15AC , 0x81349732},
{ 0x15AD , 0x81349733},
{ 0x15AE , 0x81349734},
{ 0x15AF , 0x81349735},
{ 0x15B0 , 0x81349736},
{ 0x15B1 , 0x81349737},
{ 0x15B2 , 0x81349738},
{ 0x15B3 , 0x81349739},
{ 0x15B4 , 0x81349830},
{ 0x15B5 , 0x81349831},
{ 0x15B6 , 0x81349832},
{ 0x15B7 , 0x81349833},
{ 0x15B8 , 0x81349834},
{ 0x15B9 , 0x81349835},
{ 0x15BA , 0x81349836},
{ 0x15BB , 0x81349837},
{ 0x15BC , 0x81349838},
{ 0x15BD , 0x81349839},
{ 0x15BE , 0x81349930},
{ 0x15BF , 0x81349931},
{ 0x15C0 , 0x81349932},
{ 0x15C1 , 0x81349933},
{ 0x15C2 , 0x81349934},
{ 0x15C3 , 0x81349935},
{ 0x15C4 , 0x81349936},
{ 0x15C5 , 0x81349937},
{ 0x15C6 , 0x81349938},
{ 0x15C7 , 0x81349939},
{ 0x15C8 , 0x81349A30},
{ 0x15C9 , 0x81349A31},
{ 0x15CA , 0x81349A32},
{ 0x15CB , 0x81349A33},
{ 0x15CC , 0x81349A34},
{ 0x15CD , 0x81349A35},
{ 0x15CE , 0x81349A36},
{ 0x15CF , 0x81349A37},
{ 0x15D0 , 0x81349A38},
{ 0x15D1 , 0x81349A39},
{ 0x15D2 , 0x81349B30},
{ 0x15D3 , 0x81349B31},
{ 0x15D4 , 0x81349B32},
{ 0x15D5 , 0x81349B33},
{ 0x15D6 , 0x81349B34},
{ 0x15D7 , 0x81349B35},
{ 0x15D8 , 0x81349B36},
{ 0x15D9 , 0x81349B37},
{ 0x15DA , 0x81349B38},
{ 0x15DB , 0x81349B39},
{ 0x15DC , 0x81349C30},
{ 0x15DD , 0x81349C31},
{ 0x15DE , 0x81349C32},
{ 0x15DF , 0x81349C33},
{ 0x15E0 , 0x81349C34},
{ 0x15E1 , 0x81349C35},
{ 0x15E2 , 0x81349C36},
{ 0x15E3 , 0x81349C37},
{ 0x15E4 , 0x81349C38},
{ 0x15E5 , 0x81349C39},
{ 0x15E6 , 0x81349D30},
{ 0x15E7 , 0x81349D31},
{ 0x15E8 , 0x81349D32},
{ 0x15E9 , 0x81349D33},
{ 0x15EA , 0x81349D34},
{ 0x15EB , 0x81349D35},
{ 0x15EC , 0x81349D36},
{ 0x15ED , 0x81349D37},
{ 0x15EE , 0x81349D38},
{ 0x15EF , 0x81349D39},
{ 0x15F0 , 0x81349E30},
{ 0x15F1 , 0x81349E31},
{ 0x15F2 , 0x81349E32},
{ 0x15F3 , 0x81349E33},
{ 0x15F4 , 0x81349E34},
{ 0x15F5 , 0x81349E35},
{ 0x15F6 , 0x81349E36},
{ 0x15F7 , 0x81349E37},
{ 0x15F8 , 0x81349E38},
{ 0x15F9 , 0x81349E39},
{ 0x15FA , 0x81349F30},
{ 0x15FB , 0x81349F31},
{ 0x15FC , 0x81349F32},
{ 0x15FD , 0x81349F33},
{ 0x15FE , 0x81349F34},
{ 0x15FF , 0x81349F35},
{ 0x1600 , 0x81349F36},
{ 0x1601 , 0x81349F37},
{ 0x1602 , 0x81349F38},
{ 0x1603 , 0x81349F39},
{ 0x1604 , 0x8134A030},
{ 0x1605 , 0x8134A031},
{ 0x1606 , 0x8134A032},
{ 0x1607 , 0x8134A033},
{ 0x1608 , 0x8134A034},
{ 0x1609 , 0x8134A035},
{ 0x160A , 0x8134A036},
{ 0x160B , 0x8134A037},
{ 0x160C , 0x8134A038},
{ 0x160D , 0x8134A039},
{ 0x160E , 0x8134A130},
{ 0x160F , 0x8134A131},
{ 0x1610 , 0x8134A132},
{ 0x1611 , 0x8134A133},
{ 0x1612 , 0x8134A134},
{ 0x1613 , 0x8134A135},
{ 0x1614 , 0x8134A136},
{ 0x1615 , 0x8134A137},
{ 0x1616 , 0x8134A138},
{ 0x1617 , 0x8134A139},
{ 0x1618 , 0x8134A230},
{ 0x1619 , 0x8134A231},
{ 0x161A , 0x8134A232},
{ 0x161B , 0x8134A233},
{ 0x161C , 0x8134A234},
{ 0x161D , 0x8134A235},
{ 0x161E , 0x8134A236},
{ 0x161F , 0x8134A237},
{ 0x1620 , 0x8134A238},
{ 0x1621 , 0x8134A239},
{ 0x1622 , 0x8134A330},
{ 0x1623 , 0x8134A331},
{ 0x1624 , 0x8134A332},
{ 0x1625 , 0x8134A333},
{ 0x1626 , 0x8134A334},
{ 0x1627 , 0x8134A335},
{ 0x1628 , 0x8134A336},
{ 0x1629 , 0x8134A337},
{ 0x162A , 0x8134A338},
{ 0x162B , 0x8134A339},
{ 0x162C , 0x8134A430},
{ 0x162D , 0x8134A431},
{ 0x162E , 0x8134A432},
{ 0x162F , 0x8134A433},
{ 0x1630 , 0x8134A434},
{ 0x1631 , 0x8134A435},
{ 0x1632 , 0x8134A436},
{ 0x1633 , 0x8134A437},
{ 0x1634 , 0x8134A438},
{ 0x1635 , 0x8134A439},
{ 0x1636 , 0x8134A530},
{ 0x1637 , 0x8134A531},
{ 0x1638 , 0x8134A532},
{ 0x1639 , 0x8134A533},
{ 0x163A , 0x8134A534},
{ 0x163B , 0x8134A535},
{ 0x163C , 0x8134A536},
{ 0x163D , 0x8134A537},
{ 0x163E , 0x8134A538},
{ 0x163F , 0x8134A539},
{ 0x1640 , 0x8134A630},
{ 0x1641 , 0x8134A631},
{ 0x1642 , 0x8134A632},
{ 0x1643 , 0x8134A633},
{ 0x1644 , 0x8134A634},
{ 0x1645 , 0x8134A635},
{ 0x1646 , 0x8134A636},
{ 0x1647 , 0x8134A637},
{ 0x1648 , 0x8134A638},
{ 0x1649 , 0x8134A639},
{ 0x164A , 0x8134A730},
{ 0x164B , 0x8134A731},
{ 0x164C , 0x8134A732},
{ 0x164D , 0x8134A733},
{ 0x164E , 0x8134A734},
{ 0x164F , 0x8134A735},
{ 0x1650 , 0x8134A736},
{ 0x1651 , 0x8134A737},
{ 0x1652 , 0x8134A738},
{ 0x1653 , 0x8134A739},
{ 0x1654 , 0x8134A830},
{ 0x1655 , 0x8134A831},
{ 0x1656 , 0x8134A832},
{ 0x1657 , 0x8134A833},
{ 0x1658 , 0x8134A834},
{ 0x1659 , 0x8134A835},
{ 0x165A , 0x8134A836},
{ 0x165B , 0x8134A837},
{ 0x165C , 0x8134A838},
{ 0x165D , 0x8134A839},
{ 0x165E , 0x8134A930},
{ 0x165F , 0x8134A931},
{ 0x1660 , 0x8134A932},
{ 0x1661 , 0x8134A933},
{ 0x1662 , 0x8134A934},
{ 0x1663 , 0x8134A935},
{ 0x1664 , 0x8134A936},
{ 0x1665 , 0x8134A937},
{ 0x1666 , 0x8134A938},
{ 0x1667 , 0x8134A939},
{ 0x1668 , 0x8134AA30},
{ 0x1669 , 0x8134AA31},
{ 0x166A , 0x8134AA32},
{ 0x166B , 0x8134AA33},
{ 0x166C , 0x8134AA34},
{ 0x166D , 0x8134AA35},
{ 0x166E , 0x8134AA36},
{ 0x166F , 0x8134AA37},
{ 0x1670 , 0x8134AA38},
{ 0x1671 , 0x8134AA39},
{ 0x1672 , 0x8134AB30},
{ 0x1673 , 0x8134AB31},
{ 0x1674 , 0x8134AB32},
{ 0x1675 , 0x8134AB33},
{ 0x1676 , 0x8134AB34},
{ 0x1677 , 0x8134AB35},
{ 0x1678 , 0x8134AB36},
{ 0x1679 , 0x8134AB37},
{ 0x167A , 0x8134AB38},
{ 0x167B , 0x8134AB39},
{ 0x167C , 0x8134AC30},
{ 0x167D , 0x8134AC31},
{ 0x167E , 0x8134AC32},
{ 0x167F , 0x8134AC33},
{ 0x1680 , 0x8134AC34},
{ 0x1681 , 0x8134AC35},
{ 0x1682 , 0x8134AC36},
{ 0x1683 , 0x8134AC37},
{ 0x1684 , 0x8134AC38},
{ 0x1685 , 0x8134AC39},
{ 0x1686 , 0x8134AD30},
{ 0x1687 , 0x8134AD31},
{ 0x1688 , 0x8134AD32},
{ 0x1689 , 0x8134AD33},
{ 0x168A , 0x8134AD34},
{ 0x168B , 0x8134AD35},
{ 0x168C , 0x8134AD36},
{ 0x168D , 0x8134AD37},
{ 0x168E , 0x8134AD38},
{ 0x168F , 0x8134AD39},
{ 0x1690 , 0x8134AE30},
{ 0x1691 , 0x8134AE31},
{ 0x1692 , 0x8134AE32},
{ 0x1693 , 0x8134AE33},
{ 0x1694 , 0x8134AE34},
{ 0x1695 , 0x8134AE35},
{ 0x1696 , 0x8134AE36},
{ 0x1697 , 0x8134AE37},
{ 0x1698 , 0x8134AE38},
{ 0x1699 , 0x8134AE39},
{ 0x169A , 0x8134AF30},
{ 0x169B , 0x8134AF31},
{ 0x169C , 0x8134AF32},
{ 0x169D , 0x8134AF33},
{ 0x169E , 0x8134AF34},
{ 0x169F , 0x8134AF35},
{ 0x16A0 , 0x8134AF36},
{ 0x16A1 , 0x8134AF37},
{ 0x16A2 , 0x8134AF38},
{ 0x16A3 , 0x8134AF39},
{ 0x16A4 , 0x8134B030},
{ 0x16A5 , 0x8134B031},
{ 0x16A6 , 0x8134B032},
{ 0x16A7 , 0x8134B033},
{ 0x16A8 , 0x8134B034},
{ 0x16A9 , 0x8134B035},
{ 0x16AA , 0x8134B036},
{ 0x16AB , 0x8134B037},
{ 0x16AC , 0x8134B038},
{ 0x16AD , 0x8134B039},
{ 0x16AE , 0x8134B130},
{ 0x16AF , 0x8134B131},
{ 0x16B0 , 0x8134B132},
{ 0x16B1 , 0x8134B133},
{ 0x16B2 , 0x8134B134},
{ 0x16B3 , 0x8134B135},
{ 0x16B4 , 0x8134B136},
{ 0x16B5 , 0x8134B137},
{ 0x16B6 , 0x8134B138},
{ 0x16B7 , 0x8134B139},
{ 0x16B8 , 0x8134B230},
{ 0x16B9 , 0x8134B231},
{ 0x16BA , 0x8134B232},
{ 0x16BB , 0x8134B233},
{ 0x16BC , 0x8134B234},
{ 0x16BD , 0x8134B235},
{ 0x16BE , 0x8134B236},
{ 0x16BF , 0x8134B237},
{ 0x16C0 , 0x8134B238},
{ 0x16C1 , 0x8134B239},
{ 0x16C2 , 0x8134B330},
{ 0x16C3 , 0x8134B331},
{ 0x16C4 , 0x8134B332},
{ 0x16C5 , 0x8134B333},
{ 0x16C6 , 0x8134B334},
{ 0x16C7 , 0x8134B335},
{ 0x16C8 , 0x8134B336},
{ 0x16C9 , 0x8134B337},
{ 0x16CA , 0x8134B338},
{ 0x16CB , 0x8134B339},
{ 0x16CC , 0x8134B430},
{ 0x16CD , 0x8134B431},
{ 0x16CE , 0x8134B432},
{ 0x16CF , 0x8134B433},
{ 0x16D0 , 0x8134B434},
{ 0x16D1 , 0x8134B435},
{ 0x16D2 , 0x8134B436},
{ 0x16D3 , 0x8134B437},
{ 0x16D4 , 0x8134B438},
{ 0x16D5 , 0x8134B439},
{ 0x16D6 , 0x8134B530},
{ 0x16D7 , 0x8134B531},
{ 0x16D8 , 0x8134B532},
{ 0x16D9 , 0x8134B533},
{ 0x16DA , 0x8134B534},
{ 0x16DB , 0x8134B535},
{ 0x16DC , 0x8134B536},
{ 0x16DD , 0x8134B537},
{ 0x16DE , 0x8134B538},
{ 0x16DF , 0x8134B539},
{ 0x16E0 , 0x8134B630},
{ 0x16E1 , 0x8134B631},
{ 0x16E2 , 0x8134B632},
{ 0x16E3 , 0x8134B633},
{ 0x16E4 , 0x8134B634},
{ 0x16E5 , 0x8134B635},
{ 0x16E6 , 0x8134B636},
{ 0x16E7 , 0x8134B637},
{ 0x16E8 , 0x8134B638},
{ 0x16E9 , 0x8134B639},
{ 0x16EA , 0x8134B730},
{ 0x16EB , 0x8134B731},
{ 0x16EC , 0x8134B732},
{ 0x16ED , 0x8134B733},
{ 0x16EE , 0x8134B734},
{ 0x16EF , 0x8134B735},
{ 0x16F0 , 0x8134B736},
{ 0x16F1 , 0x8134B737},
{ 0x16F2 , 0x8134B738},
{ 0x16F3 , 0x8134B739},
{ 0x16F4 , 0x8134B830},
{ 0x16F5 , 0x8134B831},
{ 0x16F6 , 0x8134B832},
{ 0x16F7 , 0x8134B833},
{ 0x16F8 , 0x8134B834},
{ 0x16F9 , 0x8134B835},
{ 0x16FA , 0x8134B836},
{ 0x16FB , 0x8134B837},
{ 0x16FC , 0x8134B838},
{ 0x16FD , 0x8134B839},
{ 0x16FE , 0x8134B930},
{ 0x16FF , 0x8134B931},
{ 0x1700 , 0x8134B932},
{ 0x1701 , 0x8134B933},
{ 0x1702 , 0x8134B934},
{ 0x1703 , 0x8134B935},
{ 0x1704 , 0x8134B936},
{ 0x1705 , 0x8134B937},
{ 0x1706 , 0x8134B938},
{ 0x1707 , 0x8134B939},
{ 0x1708 , 0x8134BA30},
{ 0x1709 , 0x8134BA31},
{ 0x170A , 0x8134BA32},
{ 0x170B , 0x8134BA33},
{ 0x170C , 0x8134BA34},
{ 0x170D , 0x8134BA35},
{ 0x170E , 0x8134BA36},
{ 0x170F , 0x8134BA37},
{ 0x1710 , 0x8134BA38},
{ 0x1711 , 0x8134BA39},
{ 0x1712 , 0x8134BB30},
{ 0x1713 , 0x8134BB31},
{ 0x1714 , 0x8134BB32},
{ 0x1715 , 0x8134BB33},
{ 0x1716 , 0x8134BB34},
{ 0x1717 , 0x8134BB35},
{ 0x1718 , 0x8134BB36},
{ 0x1719 , 0x8134BB37},
{ 0x171A , 0x8134BB38},
{ 0x171B , 0x8134BB39},
{ 0x171C , 0x8134BC30},
{ 0x171D , 0x8134BC31},
{ 0x171E , 0x8134BC32},
{ 0x171F , 0x8134BC33},
{ 0x1720 , 0x8134BC34},
{ 0x1721 , 0x8134BC35},
{ 0x1722 , 0x8134BC36},
{ 0x1723 , 0x8134BC37},
{ 0x1724 , 0x8134BC38},
{ 0x1725 , 0x8134BC39},
{ 0x1726 , 0x8134BD30},
{ 0x1727 , 0x8134BD31},
{ 0x1728 , 0x8134BD32},
{ 0x1729 , 0x8134BD33},
{ 0x172A , 0x8134BD34},
{ 0x172B , 0x8134BD35},
{ 0x172C , 0x8134BD36},
{ 0x172D , 0x8134BD37},
{ 0x172E , 0x8134BD38},
{ 0x172F , 0x8134BD39},
{ 0x1730 , 0x8134BE30},
{ 0x1731 , 0x8134BE31},
{ 0x1732 , 0x8134BE32},
{ 0x1733 , 0x8134BE33},
{ 0x1734 , 0x8134BE34},
{ 0x1735 , 0x8134BE35},
{ 0x1736 , 0x8134BE36},
{ 0x1737 , 0x8134BE37},
{ 0x1738 , 0x8134BE38},
{ 0x1739 , 0x8134BE39},
{ 0x173A , 0x8134BF30},
{ 0x173B , 0x8134BF31},
{ 0x173C , 0x8134BF32},
{ 0x173D , 0x8134BF33},
{ 0x173E , 0x8134BF34},
{ 0x173F , 0x8134BF35},
{ 0x1740 , 0x8134BF36},
{ 0x1741 , 0x8134BF37},
{ 0x1742 , 0x8134BF38},
{ 0x1743 , 0x8134BF39},
{ 0x1744 , 0x8134C030},
{ 0x1745 , 0x8134C031},
{ 0x1746 , 0x8134C032},
{ 0x1747 , 0x8134C033},
{ 0x1748 , 0x8134C034},
{ 0x1749 , 0x8134C035},
{ 0x174A , 0x8134C036},
{ 0x174B , 0x8134C037},
{ 0x174C , 0x8134C038},
{ 0x174D , 0x8134C039},
{ 0x174E , 0x8134C130},
{ 0x174F , 0x8134C131},
{ 0x1750 , 0x8134C132},
{ 0x1751 , 0x8134C133},
{ 0x1752 , 0x8134C134},
{ 0x1753 , 0x8134C135},
{ 0x1754 , 0x8134C136},
{ 0x1755 , 0x8134C137},
{ 0x1756 , 0x8134C138},
{ 0x1757 , 0x8134C139},
{ 0x1758 , 0x8134C230},
{ 0x1759 , 0x8134C231},
{ 0x175A , 0x8134C232},
{ 0x175B , 0x8134C233},
{ 0x175C , 0x8134C234},
{ 0x175D , 0x8134C235},
{ 0x175E , 0x8134C236},
{ 0x175F , 0x8134C237},
{ 0x1760 , 0x8134C238},
{ 0x1761 , 0x8134C239},
{ 0x1762 , 0x8134C330},
{ 0x1763 , 0x8134C331},
{ 0x1764 , 0x8134C332},
{ 0x1765 , 0x8134C333},
{ 0x1766 , 0x8134C334},
{ 0x1767 , 0x8134C335},
{ 0x1768 , 0x8134C336},
{ 0x1769 , 0x8134C337},
{ 0x176A , 0x8134C338},
{ 0x176B , 0x8134C339},
{ 0x176C , 0x8134C430},
{ 0x176D , 0x8134C431},
{ 0x176E , 0x8134C432},
{ 0x176F , 0x8134C433},
{ 0x1770 , 0x8134C434},
{ 0x1771 , 0x8134C435},
{ 0x1772 , 0x8134C436},
{ 0x1773 , 0x8134C437},
{ 0x1774 , 0x8134C438},
{ 0x1775 , 0x8134C439},
{ 0x1776 , 0x8134C530},
{ 0x1777 , 0x8134C531},
{ 0x1778 , 0x8134C532},
{ 0x1779 , 0x8134C533},
{ 0x177A , 0x8134C534},
{ 0x177B , 0x8134C535},
{ 0x177C , 0x8134C536},
{ 0x177D , 0x8134C537},
{ 0x177E , 0x8134C538},
{ 0x177F , 0x8134C539},
{ 0x1780 , 0x8134C630},
{ 0x1781 , 0x8134C631},
{ 0x1782 , 0x8134C632},
{ 0x1783 , 0x8134C633},
{ 0x1784 , 0x8134C634},
{ 0x1785 , 0x8134C635},
{ 0x1786 , 0x8134C636},
{ 0x1787 , 0x8134C637},
{ 0x1788 , 0x8134C638},
{ 0x1789 , 0x8134C639},
{ 0x178A , 0x8134C730},
{ 0x178B , 0x8134C731},
{ 0x178C , 0x8134C732},
{ 0x178D , 0x8134C733},
{ 0x178E , 0x8134C734},
{ 0x178F , 0x8134C735},
{ 0x1790 , 0x8134C736},
{ 0x1791 , 0x8134C737},
{ 0x1792 , 0x8134C738},
{ 0x1793 , 0x8134C739},
{ 0x1794 , 0x8134C830},
{ 0x1795 , 0x8134C831},
{ 0x1796 , 0x8134C832},
{ 0x1797 , 0x8134C833},
{ 0x1798 , 0x8134C834},
{ 0x1799 , 0x8134C835},
{ 0x179A , 0x8134C836},
{ 0x179B , 0x8134C837},
{ 0x179C , 0x8134C838},
{ 0x179D , 0x8134C839},
{ 0x179E , 0x8134C930},
{ 0x179F , 0x8134C931},
{ 0x17A0 , 0x8134C932},
{ 0x17A1 , 0x8134C933},
{ 0x17A2 , 0x8134C934},
{ 0x17A3 , 0x8134C935},
{ 0x17A4 , 0x8134C936},
{ 0x17A5 , 0x8134C937},
{ 0x17A6 , 0x8134C938},
{ 0x17A7 , 0x8134C939},
{ 0x17A8 , 0x8134CA30},
{ 0x17A9 , 0x8134CA31},
{ 0x17AA , 0x8134CA32},
{ 0x17AB , 0x8134CA33},
{ 0x17AC , 0x8134CA34},
{ 0x17AD , 0x8134CA35},
{ 0x17AE , 0x8134CA36},
{ 0x17AF , 0x8134CA37},
{ 0x17B0 , 0x8134CA38},
{ 0x17B1 , 0x8134CA39},
{ 0x17B2 , 0x8134CB30},
{ 0x17B3 , 0x8134CB31},
{ 0x17B4 , 0x8134CB32},
{ 0x17B5 , 0x8134CB33},
{ 0x17B6 , 0x8134CB34},
{ 0x17B7 , 0x8134CB35},
{ 0x17B8 , 0x8134CB36},
{ 0x17B9 , 0x8134CB37},
{ 0x17BA , 0x8134CB38},
{ 0x17BB , 0x8134CB39},
{ 0x17BC , 0x8134CC30},
{ 0x17BD , 0x8134CC31},
{ 0x17BE , 0x8134CC32},
{ 0x17BF , 0x8134CC33},
{ 0x17C0 , 0x8134CC34},
{ 0x17C1 , 0x8134CC35},
{ 0x17C2 , 0x8134CC36},
{ 0x17C3 , 0x8134CC37},
{ 0x17C4 , 0x8134CC38},
{ 0x17C5 , 0x8134CC39},
{ 0x17C6 , 0x8134CD30},
{ 0x17C7 , 0x8134CD31},
{ 0x17C8 , 0x8134CD32},
{ 0x17C9 , 0x8134CD33},
{ 0x17CA , 0x8134CD34},
{ 0x17CB , 0x8134CD35},
{ 0x17CC , 0x8134CD36},
{ 0x17CD , 0x8134CD37},
{ 0x17CE , 0x8134CD38},
{ 0x17CF , 0x8134CD39},
{ 0x17D0 , 0x8134CE30},
{ 0x17D1 , 0x8134CE31},
{ 0x17D2 , 0x8134CE32},
{ 0x17D3 , 0x8134CE33},
{ 0x17D4 , 0x8134CE34},
{ 0x17D5 , 0x8134CE35},
{ 0x17D6 , 0x8134CE36},
{ 0x17D7 , 0x8134CE37},
{ 0x17D8 , 0x8134CE38},
{ 0x17D9 , 0x8134CE39},
{ 0x17DA , 0x8134CF30},
{ 0x17DB , 0x8134CF31},
{ 0x17DC , 0x8134CF32},
{ 0x17DD , 0x8134CF33},
{ 0x17DE , 0x8134CF34},
{ 0x17DF , 0x8134CF35},
{ 0x17E0 , 0x8134CF36},
{ 0x17E1 , 0x8134CF37},
{ 0x17E2 , 0x8134CF38},
{ 0x17E3 , 0x8134CF39},
{ 0x17E4 , 0x8134D030},
{ 0x17E5 , 0x8134D031},
{ 0x17E6 , 0x8134D032},
{ 0x17E7 , 0x8134D033},
{ 0x17E8 , 0x8134D034},
{ 0x17E9 , 0x8134D035},
{ 0x17EA , 0x8134D036},
{ 0x17EB , 0x8134D037},
{ 0x17EC , 0x8134D038},
{ 0x17ED , 0x8134D039},
{ 0x17EE , 0x8134D130},
{ 0x17EF , 0x8134D131},
{ 0x17F0 , 0x8134D132},
{ 0x17F1 , 0x8134D133},
{ 0x17F2 , 0x8134D134},
{ 0x17F3 , 0x8134D135},
{ 0x17F4 , 0x8134D136},
{ 0x17F5 , 0x8134D137},
{ 0x17F6 , 0x8134D138},
{ 0x17F7 , 0x8134D139},
{ 0x17F8 , 0x8134D230},
{ 0x17F9 , 0x8134D231},
{ 0x17FA , 0x8134D232},
{ 0x17FB , 0x8134D233},
{ 0x17FC , 0x8134D234},
{ 0x17FD , 0x8134D235},
{ 0x17FE , 0x8134D236},
{ 0x17FF , 0x8134D237},
{ 0x1800 , 0x8134D238},
{ 0x1801 , 0x8134D239},
{ 0x1802 , 0x8134D330},
{ 0x1803 , 0x8134D331},
{ 0x1804 , 0x8134D332},
{ 0x1805 , 0x8134D333},
{ 0x1806 , 0x8134D334},
{ 0x1807 , 0x8134D335},
{ 0x1808 , 0x8134D336},
{ 0x1809 , 0x8134D337},
{ 0x180A , 0x8134D338},
{ 0x180B , 0x8134D339},
{ 0x180C , 0x8134D430},
{ 0x180D , 0x8134D431},
{ 0x180E , 0x8134D432},
{ 0x180F , 0x8134D433},
{ 0x1810 , 0x8134D434},
{ 0x1811 , 0x8134D435},
{ 0x1812 , 0x8134D436},
{ 0x1813 , 0x8134D437},
{ 0x1814 , 0x8134D438},
{ 0x1815 , 0x8134D439},
{ 0x1816 , 0x8134D530},
{ 0x1817 , 0x8134D531},
{ 0x1818 , 0x8134D532},
{ 0x1819 , 0x8134D533},
{ 0x181A , 0x8134D534},
{ 0x181B , 0x8134D535},
{ 0x181C , 0x8134D536},
{ 0x181D , 0x8134D537},
{ 0x181E , 0x8134D538},
{ 0x181F , 0x8134D539},
{ 0x1820 , 0x8134D630},
{ 0x1821 , 0x8134D631},
{ 0x1822 , 0x8134D632},
{ 0x1823 , 0x8134D633},
{ 0x1824 , 0x8134D634},
{ 0x1825 , 0x8134D635},
{ 0x1826 , 0x8134D636},
{ 0x1827 , 0x8134D637},
{ 0x1828 , 0x8134D638},
{ 0x1829 , 0x8134D639},
{ 0x182A , 0x8134D730},
{ 0x182B , 0x8134D731},
{ 0x182C , 0x8134D732},
{ 0x182D , 0x8134D733},
{ 0x182E , 0x8134D734},
{ 0x182F , 0x8134D735},
{ 0x1830 , 0x8134D736},
{ 0x1831 , 0x8134D737},
{ 0x1832 , 0x8134D738},
{ 0x1833 , 0x8134D739},
{ 0x1834 , 0x8134D830},
{ 0x1835 , 0x8134D831},
{ 0x1836 , 0x8134D832},
{ 0x1837 , 0x8134D833},
{ 0x1838 , 0x8134D834},
{ 0x1839 , 0x8134D835},
{ 0x183A , 0x8134D836},
{ 0x183B , 0x8134D837},
{ 0x183C , 0x8134D838},
{ 0x183D , 0x8134D839},
{ 0x183E , 0x8134D930},
{ 0x183F , 0x8134D931},
{ 0x1840 , 0x8134D932},
{ 0x1841 , 0x8134D933},
{ 0x1842 , 0x8134D934},
{ 0x1843 , 0x8134D935},
{ 0x1844 , 0x8134D936},
{ 0x1845 , 0x8134D937},
{ 0x1846 , 0x8134D938},
{ 0x1847 , 0x8134D939},
{ 0x1848 , 0x8134DA30},
{ 0x1849 , 0x8134DA31},
{ 0x184A , 0x8134DA32},
{ 0x184B , 0x8134DA33},
{ 0x184C , 0x8134DA34},
{ 0x184D , 0x8134DA35},
{ 0x184E , 0x8134DA36},
{ 0x184F , 0x8134DA37},
{ 0x1850 , 0x8134DA38},
{ 0x1851 , 0x8134DA39},
{ 0x1852 , 0x8134DB30},
{ 0x1853 , 0x8134DB31},
{ 0x1854 , 0x8134DB32},
{ 0x1855 , 0x8134DB33},
{ 0x1856 , 0x8134DB34},
{ 0x1857 , 0x8134DB35},
{ 0x1858 , 0x8134DB36},
{ 0x1859 , 0x8134DB37},
{ 0x185A , 0x8134DB38},
{ 0x185B , 0x8134DB39},
{ 0x185C , 0x8134DC30},
{ 0x185D , 0x8134DC31},
{ 0x185E , 0x8134DC32},
{ 0x185F , 0x8134DC33},
{ 0x1860 , 0x8134DC34},
{ 0x1861 , 0x8134DC35},
{ 0x1862 , 0x8134DC36},
{ 0x1863 , 0x8134DC37},
{ 0x1864 , 0x8134DC38},
{ 0x1865 , 0x8134DC39},
{ 0x1866 , 0x8134DD30},
{ 0x1867 , 0x8134DD31},
{ 0x1868 , 0x8134DD32},
{ 0x1869 , 0x8134DD33},
{ 0x186A , 0x8134DD34},
{ 0x186B , 0x8134DD35},
{ 0x186C , 0x8134DD36},
{ 0x186D , 0x8134DD37},
{ 0x186E , 0x8134DD38},
{ 0x186F , 0x8134DD39},
{ 0x1870 , 0x8134DE30},
{ 0x1871 , 0x8134DE31},
{ 0x1872 , 0x8134DE32},
{ 0x1873 , 0x8134DE33},
{ 0x1874 , 0x8134DE34},
{ 0x1875 , 0x8134DE35},
{ 0x1876 , 0x8134DE36},
{ 0x1877 , 0x8134DE37},
{ 0x1878 , 0x8134DE38},
{ 0x1879 , 0x8134DE39},
{ 0x187A , 0x8134DF30},
{ 0x187B , 0x8134DF31},
{ 0x187C , 0x8134DF32},
{ 0x187D , 0x8134DF33},
{ 0x187E , 0x8134DF34},
{ 0x187F , 0x8134DF35},
{ 0x1880 , 0x8134DF36},
{ 0x1881 , 0x8134DF37},
{ 0x1882 , 0x8134DF38},
{ 0x1883 , 0x8134DF39},
{ 0x1884 , 0x8134E030},
{ 0x1885 , 0x8134E031},
{ 0x1886 , 0x8134E032},
{ 0x1887 , 0x8134E033},
{ 0x1888 , 0x8134E034},
{ 0x1889 , 0x8134E035},
{ 0x188A , 0x8134E036},
{ 0x188B , 0x8134E037},
{ 0x188C , 0x8134E038},
{ 0x188D , 0x8134E039},
{ 0x188E , 0x8134E130},
{ 0x188F , 0x8134E131},
{ 0x1890 , 0x8134E132},
{ 0x1891 , 0x8134E133},
{ 0x1892 , 0x8134E134},
{ 0x1893 , 0x8134E135},
{ 0x1894 , 0x8134E136},
{ 0x1895 , 0x8134E137},
{ 0x1896 , 0x8134E138},
{ 0x1897 , 0x8134E139},
{ 0x1898 , 0x8134E230},
{ 0x1899 , 0x8134E231},
{ 0x189A , 0x8134E232},
{ 0x189B , 0x8134E233},
{ 0x189C , 0x8134E234},
{ 0x189D , 0x8134E235},
{ 0x189E , 0x8134E236},
{ 0x189F , 0x8134E237},
{ 0x18A0 , 0x8134E238},
{ 0x18A1 , 0x8134E239},
{ 0x18A2 , 0x8134E330},
{ 0x18A3 , 0x8134E331},
{ 0x18A4 , 0x8134E332},
{ 0x18A5 , 0x8134E333},
{ 0x18A6 , 0x8134E334},
{ 0x18A7 , 0x8134E335},
{ 0x18A8 , 0x8134E336},
{ 0x18A9 , 0x8134E337},
{ 0x18AA , 0x8134E338},
{ 0x18AB , 0x8134E339},
{ 0x18AC , 0x8134E430},
{ 0x18AD , 0x8134E431},
{ 0x18AE , 0x8134E432},
{ 0x18AF , 0x8134E433},
{ 0x18B0 , 0x8134E434},
{ 0x18B1 , 0x8134E435},
{ 0x18B2 , 0x8134E436},
{ 0x18B3 , 0x8134E437},
{ 0x18B4 , 0x8134E438},
{ 0x18B5 , 0x8134E439},
{ 0x18B6 , 0x8134E530},
{ 0x18B7 , 0x8134E531},
{ 0x18B8 , 0x8134E532},
{ 0x18B9 , 0x8134E533},
{ 0x18BA , 0x8134E534},
{ 0x18BB , 0x8134E535},
{ 0x18BC , 0x8134E536},
{ 0x18BD , 0x8134E537},
{ 0x18BE , 0x8134E538},
{ 0x18BF , 0x8134E539},
{ 0x18C0 , 0x8134E630},
{ 0x18C1 , 0x8134E631},
{ 0x18C2 , 0x8134E632},
{ 0x18C3 , 0x8134E633},
{ 0x18C4 , 0x8134E634},
{ 0x18C5 , 0x8134E635},
{ 0x18C6 , 0x8134E636},
{ 0x18C7 , 0x8134E637},
{ 0x18C8 , 0x8134E638},
{ 0x18C9 , 0x8134E639},
{ 0x18CA , 0x8134E730},
{ 0x18CB , 0x8134E731},
{ 0x18CC , 0x8134E732},
{ 0x18CD , 0x8134E733},
{ 0x18CE , 0x8134E734},
{ 0x18CF , 0x8134E735},
{ 0x18D0 , 0x8134E736},
{ 0x18D1 , 0x8134E737},
{ 0x18D2 , 0x8134E738},
{ 0x18D3 , 0x8134E739},
{ 0x18D4 , 0x8134E830},
{ 0x18D5 , 0x8134E831},
{ 0x18D6 , 0x8134E832},
{ 0x18D7 , 0x8134E833},
{ 0x18D8 , 0x8134E834},
{ 0x18D9 , 0x8134E835},
{ 0x18DA , 0x8134E836},
{ 0x18DB , 0x8134E837},
{ 0x18DC , 0x8134E838},
{ 0x18DD , 0x8134E839},
{ 0x18DE , 0x8134E930},
{ 0x18DF , 0x8134E931},
{ 0x18E0 , 0x8134E932},
{ 0x18E1 , 0x8134E933},
{ 0x18E2 , 0x8134E934},
{ 0x18E3 , 0x8134E935},
{ 0x18E4 , 0x8134E936},
{ 0x18E5 , 0x8134E937},
{ 0x18E6 , 0x8134E938},
{ 0x18E7 , 0x8134E939},
{ 0x18E8 , 0x8134EA30},
{ 0x18E9 , 0x8134EA31},
{ 0x18EA , 0x8134EA32},
{ 0x18EB , 0x8134EA33},
{ 0x18EC , 0x8134EA34},
{ 0x18ED , 0x8134EA35},
{ 0x18EE , 0x8134EA36},
{ 0x18EF , 0x8134EA37},
{ 0x18F0 , 0x8134EA38},
{ 0x18F1 , 0x8134EA39},
{ 0x18F2 , 0x8134EB30},
{ 0x18F3 , 0x8134EB31},
{ 0x18F4 , 0x8134EB32},
{ 0x18F5 , 0x8134EB33},
{ 0x18F6 , 0x8134EB34},
{ 0x18F7 , 0x8134EB35},
{ 0x18F8 , 0x8134EB36},
{ 0x18F9 , 0x8134EB37},
{ 0x18FA , 0x8134EB38},
{ 0x18FB , 0x8134EB39},
{ 0x18FC , 0x8134EC30},
{ 0x18FD , 0x8134EC31},
{ 0x18FE , 0x8134EC32},
{ 0x18FF , 0x8134EC33},
{ 0x1900 , 0x8134EC34},
{ 0x1901 , 0x8134EC35},
{ 0x1902 , 0x8134EC36},
{ 0x1903 , 0x8134EC37},
{ 0x1904 , 0x8134EC38},
{ 0x1905 , 0x8134EC39},
{ 0x1906 , 0x8134ED30},
{ 0x1907 , 0x8134ED31},
{ 0x1908 , 0x8134ED32},
{ 0x1909 , 0x8134ED33},
{ 0x190A , 0x8134ED34},
{ 0x190B , 0x8134ED35},
{ 0x190C , 0x8134ED36},
{ 0x190D , 0x8134ED37},
{ 0x190E , 0x8134ED38},
{ 0x190F , 0x8134ED39},
{ 0x1910 , 0x8134EE30},
{ 0x1911 , 0x8134EE31},
{ 0x1912 , 0x8134EE32},
{ 0x1913 , 0x8134EE33},
{ 0x1914 , 0x8134EE34},
{ 0x1915 , 0x8134EE35},
{ 0x1916 , 0x8134EE36},
{ 0x1917 , 0x8134EE37},
{ 0x1918 , 0x8134EE38},
{ 0x1919 , 0x8134EE39},
{ 0x191A , 0x8134EF30},
{ 0x191B , 0x8134EF31},
{ 0x191C , 0x8134EF32},
{ 0x191D , 0x8134EF33},
{ 0x191E , 0x8134EF34},
{ 0x191F , 0x8134EF35},
{ 0x1920 , 0x8134EF36},
{ 0x1921 , 0x8134EF37},
{ 0x1922 , 0x8134EF38},
{ 0x1923 , 0x8134EF39},
{ 0x1924 , 0x8134F030},
{ 0x1925 , 0x8134F031},
{ 0x1926 , 0x8134F032},
{ 0x1927 , 0x8134F033},
{ 0x1928 , 0x8134F034},
{ 0x1929 , 0x8134F035},
{ 0x192A , 0x8134F036},
{ 0x192B , 0x8134F037},
{ 0x192C , 0x8134F038},
{ 0x192D , 0x8134F039},
{ 0x192E , 0x8134F130},
{ 0x192F , 0x8134F131},
{ 0x1930 , 0x8134F132},
{ 0x1931 , 0x8134F133},
{ 0x1932 , 0x8134F134},
{ 0x1933 , 0x8134F135},
{ 0x1934 , 0x8134F136},
{ 0x1935 , 0x8134F137},
{ 0x1936 , 0x8134F138},
{ 0x1937 , 0x8134F139},
{ 0x1938 , 0x8134F230},
{ 0x1939 , 0x8134F231},
{ 0x193A , 0x8134F232},
{ 0x193B , 0x8134F233},
{ 0x193C , 0x8134F234},
{ 0x193D , 0x8134F235},
{ 0x193E , 0x8134F236},
{ 0x193F , 0x8134F237},
{ 0x1940 , 0x8134F238},
{ 0x1941 , 0x8134F239},
{ 0x1942 , 0x8134F330},
{ 0x1943 , 0x8134F331},
{ 0x1944 , 0x8134F332},
{ 0x1945 , 0x8134F333},
{ 0x1946 , 0x8134F334},
{ 0x1947 , 0x8134F335},
{ 0x1948 , 0x8134F336},
{ 0x1949 , 0x8134F337},
{ 0x194A , 0x8134F338},
{ 0x194B , 0x8134F339},
{ 0x194C , 0x8134F430},
{ 0x194D , 0x8134F431},
{ 0x194E , 0x8134F432},
{ 0x194F , 0x8134F433},
{ 0x1950 , 0x8134F434},
{ 0x1951 , 0x8134F435},
{ 0x1952 , 0x8134F436},
{ 0x1953 , 0x8134F437},
{ 0x1954 , 0x8134F438},
{ 0x1955 , 0x8134F439},
{ 0x1956 , 0x8134F530},
{ 0x1957 , 0x8134F531},
{ 0x1958 , 0x8134F532},
{ 0x1959 , 0x8134F533},
{ 0x195A , 0x8134F534},
{ 0x195B , 0x8134F535},
{ 0x195C , 0x8134F536},
{ 0x195D , 0x8134F537},
{ 0x195E , 0x8134F538},
{ 0x195F , 0x8134F539},
{ 0x1960 , 0x8134F630},
{ 0x1961 , 0x8134F631},
{ 0x1962 , 0x8134F632},
{ 0x1963 , 0x8134F633},
{ 0x1964 , 0x8134F634},
{ 0x1965 , 0x8134F635},
{ 0x1966 , 0x8134F636},
{ 0x1967 , 0x8134F637},
{ 0x1968 , 0x8134F638},
{ 0x1969 , 0x8134F639},
{ 0x196A , 0x8134F730},
{ 0x196B , 0x8134F731},
{ 0x196C , 0x8134F732},
{ 0x196D , 0x8134F733},
{ 0x196E , 0x8134F734},
{ 0x196F , 0x8134F735},
{ 0x1970 , 0x8134F736},
{ 0x1971 , 0x8134F737},
{ 0x1972 , 0x8134F738},
{ 0x1973 , 0x8134F739},
{ 0x1974 , 0x8134F830},
{ 0x1975 , 0x8134F831},
{ 0x1976 , 0x8134F832},
{ 0x1977 , 0x8134F833},
{ 0x1978 , 0x8134F834},
{ 0x1979 , 0x8134F835},
{ 0x197A , 0x8134F836},
{ 0x197B , 0x8134F837},
{ 0x197C , 0x8134F838},
{ 0x197D , 0x8134F839},
{ 0x197E , 0x8134F930},
{ 0x197F , 0x8134F931},
{ 0x1980 , 0x8134F932},
{ 0x1981 , 0x8134F933},
{ 0x1982 , 0x8134F934},
{ 0x1983 , 0x8134F935},
{ 0x1984 , 0x8134F936},
{ 0x1985 , 0x8134F937},
{ 0x1986 , 0x8134F938},
{ 0x1987 , 0x8134F939},
{ 0x1988 , 0x8134FA30},
{ 0x1989 , 0x8134FA31},
{ 0x198A , 0x8134FA32},
{ 0x198B , 0x8134FA33},
{ 0x198C , 0x8134FA34},
{ 0x198D , 0x8134FA35},
{ 0x198E , 0x8134FA36},
{ 0x198F , 0x8134FA37},
{ 0x1990 , 0x8134FA38},
{ 0x1991 , 0x8134FA39},
{ 0x1992 , 0x8134FB30},
{ 0x1993 , 0x8134FB31},
{ 0x1994 , 0x8134FB32},
{ 0x1995 , 0x8134FB33},
{ 0x1996 , 0x8134FB34},
{ 0x1997 , 0x8134FB35},
{ 0x1998 , 0x8134FB36},
{ 0x1999 , 0x8134FB37},
{ 0x199A , 0x8134FB38},
{ 0x199B , 0x8134FB39},
{ 0x199C , 0x8134FC30},
{ 0x199D , 0x8134FC31},
{ 0x199E , 0x8134FC32},
{ 0x199F , 0x8134FC33},
{ 0x19A0 , 0x8134FC34},
{ 0x19A1 , 0x8134FC35},
{ 0x19A2 , 0x8134FC36},
{ 0x19A3 , 0x8134FC37},
{ 0x19A4 , 0x8134FC38},
{ 0x19A5 , 0x8134FC39},
{ 0x19A6 , 0x8134FD30},
{ 0x19A7 , 0x8134FD31},
{ 0x19A8 , 0x8134FD32},
{ 0x19A9 , 0x8134FD33},
{ 0x19AA , 0x8134FD34},
{ 0x19AB , 0x8134FD35},
{ 0x19AC , 0x8134FD36},
{ 0x19AD , 0x8134FD37},
{ 0x19AE , 0x8134FD38},
{ 0x19AF , 0x8134FD39},
{ 0x19B0 , 0x8134FE30},
{ 0x19B1 , 0x8134FE31},
{ 0x19B2 , 0x8134FE32},
{ 0x19B3 , 0x8134FE33},
{ 0x19B4 , 0x8134FE34},
{ 0x19B5 , 0x8134FE35},
{ 0x19B6 , 0x8134FE36},
{ 0x19B7 , 0x8134FE37},
{ 0x19B8 , 0x8134FE38},
{ 0x19B9 , 0x8134FE39},
{ 0x19BA , 0x81358130},
{ 0x19BB , 0x81358131},
{ 0x19BC , 0x81358132},
{ 0x19BD , 0x81358133},
{ 0x19BE , 0x81358134},
{ 0x19BF , 0x81358135},
{ 0x19C0 , 0x81358136},
{ 0x19C1 , 0x81358137},
{ 0x19C2 , 0x81358138},
{ 0x19C3 , 0x81358139},
{ 0x19C4 , 0x81358230},
{ 0x19C5 , 0x81358231},
{ 0x19C6 , 0x81358232},
{ 0x19C7 , 0x81358233},
{ 0x19C8 , 0x81358234},
{ 0x19C9 , 0x81358235},
{ 0x19CA , 0x81358236},
{ 0x19CB , 0x81358237},
{ 0x19CC , 0x81358238},
{ 0x19CD , 0x81358239},
{ 0x19CE , 0x81358330},
{ 0x19CF , 0x81358331},
{ 0x19D0 , 0x81358332},
{ 0x19D1 , 0x81358333},
{ 0x19D2 , 0x81358334},
{ 0x19D3 , 0x81358335},
{ 0x19D4 , 0x81358336},
{ 0x19D5 , 0x81358337},
{ 0x19D6 , 0x81358338},
{ 0x19D7 , 0x81358339},
{ 0x19D8 , 0x81358430},
{ 0x19D9 , 0x81358431},
{ 0x19DA , 0x81358432},
{ 0x19DB , 0x81358433},
{ 0x19DC , 0x81358434},
{ 0x19DD , 0x81358435},
{ 0x19DE , 0x81358436},
{ 0x19DF , 0x81358437},
{ 0x19E0 , 0x81358438},
{ 0x19E1 , 0x81358439},
{ 0x19E2 , 0x81358530},
{ 0x19E3 , 0x81358531},
{ 0x19E4 , 0x81358532},
{ 0x19E5 , 0x81358533},
{ 0x19E6 , 0x81358534},
{ 0x19E7 , 0x81358535},
{ 0x19E8 , 0x81358536},
{ 0x19E9 , 0x81358537},
{ 0x19EA , 0x81358538},
{ 0x19EB , 0x81358539},
{ 0x19EC , 0x81358630},
{ 0x19ED , 0x81358631},
{ 0x19EE , 0x81358632},
{ 0x19EF , 0x81358633},
{ 0x19F0 , 0x81358634},
{ 0x19F1 , 0x81358635},
{ 0x19F2 , 0x81358636},
{ 0x19F3 , 0x81358637},
{ 0x19F4 , 0x81358638},
{ 0x19F5 , 0x81358639},
{ 0x19F6 , 0x81358730},
{ 0x19F7 , 0x81358731},
{ 0x19F8 , 0x81358732},
{ 0x19F9 , 0x81358733},
{ 0x19FA , 0x81358734},
{ 0x19FB , 0x81358735},
{ 0x19FC , 0x81358736},
{ 0x19FD , 0x81358737},
{ 0x19FE , 0x81358738},
{ 0x19FF , 0x81358739},
{ 0x1A00 , 0x81358830},
{ 0x1A01 , 0x81358831},
{ 0x1A02 , 0x81358832},
{ 0x1A03 , 0x81358833},
{ 0x1A04 , 0x81358834},
{ 0x1A05 , 0x81358835},
{ 0x1A06 , 0x81358836},
{ 0x1A07 , 0x81358837},
{ 0x1A08 , 0x81358838},
{ 0x1A09 , 0x81358839},
{ 0x1A0A , 0x81358930},
{ 0x1A0B , 0x81358931},
{ 0x1A0C , 0x81358932},
{ 0x1A0D , 0x81358933},
{ 0x1A0E , 0x81358934},
{ 0x1A0F , 0x81358935},
{ 0x1A10 , 0x81358936},
{ 0x1A11 , 0x81358937},
{ 0x1A12 , 0x81358938},
{ 0x1A13 , 0x81358939},
{ 0x1A14 , 0x81358A30},
{ 0x1A15 , 0x81358A31},
{ 0x1A16 , 0x81358A32},
{ 0x1A17 , 0x81358A33},
{ 0x1A18 , 0x81358A34},
{ 0x1A19 , 0x81358A35},
{ 0x1A1A , 0x81358A36},
{ 0x1A1B , 0x81358A37},
{ 0x1A1C , 0x81358A38},
{ 0x1A1D , 0x81358A39},
{ 0x1A1E , 0x81358B30},
{ 0x1A1F , 0x81358B31},
{ 0x1A20 , 0x81358B32},
{ 0x1A21 , 0x81358B33},
{ 0x1A22 , 0x81358B34},
{ 0x1A23 , 0x81358B35},
{ 0x1A24 , 0x81358B36},
{ 0x1A25 , 0x81358B37},
{ 0x1A26 , 0x81358B38},
{ 0x1A27 , 0x81358B39},
{ 0x1A28 , 0x81358C30},
{ 0x1A29 , 0x81358C31},
{ 0x1A2A , 0x81358C32},
{ 0x1A2B , 0x81358C33},
{ 0x1A2C , 0x81358C34},
{ 0x1A2D , 0x81358C35},
{ 0x1A2E , 0x81358C36},
{ 0x1A2F , 0x81358C37},
{ 0x1A30 , 0x81358C38},
{ 0x1A31 , 0x81358C39},
{ 0x1A32 , 0x81358D30},
{ 0x1A33 , 0x81358D31},
{ 0x1A34 , 0x81358D32},
{ 0x1A35 , 0x81358D33},
{ 0x1A36 , 0x81358D34},
{ 0x1A37 , 0x81358D35},
{ 0x1A38 , 0x81358D36},
{ 0x1A39 , 0x81358D37},
{ 0x1A3A , 0x81358D38},
{ 0x1A3B , 0x81358D39},
{ 0x1A3C , 0x81358E30},
{ 0x1A3D , 0x81358E31},
{ 0x1A3E , 0x81358E32},
{ 0x1A3F , 0x81358E33},
{ 0x1A40 , 0x81358E34},
{ 0x1A41 , 0x81358E35},
{ 0x1A42 , 0x81358E36},
{ 0x1A43 , 0x81358E37},
{ 0x1A44 , 0x81358E38},
{ 0x1A45 , 0x81358E39},
{ 0x1A46 , 0x81358F30},
{ 0x1A47 , 0x81358F31},
{ 0x1A48 , 0x81358F32},
{ 0x1A49 , 0x81358F33},
{ 0x1A4A , 0x81358F34},
{ 0x1A4B , 0x81358F35},
{ 0x1A4C , 0x81358F36},
{ 0x1A4D , 0x81358F37},
{ 0x1A4E , 0x81358F38},
{ 0x1A4F , 0x81358F39},
{ 0x1A50 , 0x81359030},
{ 0x1A51 , 0x81359031},
{ 0x1A52 , 0x81359032},
{ 0x1A53 , 0x81359033},
{ 0x1A54 , 0x81359034},
{ 0x1A55 , 0x81359035},
{ 0x1A56 , 0x81359036},
{ 0x1A57 , 0x81359037},
{ 0x1A58 , 0x81359038},
{ 0x1A59 , 0x81359039},
{ 0x1A5A , 0x81359130},
{ 0x1A5B , 0x81359131},
{ 0x1A5C , 0x81359132},
{ 0x1A5D , 0x81359133},
{ 0x1A5E , 0x81359134},
{ 0x1A5F , 0x81359135},
{ 0x1A60 , 0x81359136},
{ 0x1A61 , 0x81359137},
{ 0x1A62 , 0x81359138},
{ 0x1A63 , 0x81359139},
{ 0x1A64 , 0x81359230},
{ 0x1A65 , 0x81359231},
{ 0x1A66 , 0x81359232},
{ 0x1A67 , 0x81359233},
{ 0x1A68 , 0x81359234},
{ 0x1A69 , 0x81359235},
{ 0x1A6A , 0x81359236},
{ 0x1A6B , 0x81359237},
{ 0x1A6C , 0x81359238},
{ 0x1A6D , 0x81359239},
{ 0x1A6E , 0x81359330},
{ 0x1A6F , 0x81359331},
{ 0x1A70 , 0x81359332},
{ 0x1A71 , 0x81359333},
{ 0x1A72 , 0x81359334},
{ 0x1A73 , 0x81359335},
{ 0x1A74 , 0x81359336},
{ 0x1A75 , 0x81359337},
{ 0x1A76 , 0x81359338},
{ 0x1A77 , 0x81359339},
{ 0x1A78 , 0x81359430},
{ 0x1A79 , 0x81359431},
{ 0x1A7A , 0x81359432},
{ 0x1A7B , 0x81359433},
{ 0x1A7C , 0x81359434},
{ 0x1A7D , 0x81359435},
{ 0x1A7E , 0x81359436},
{ 0x1A7F , 0x81359437},
{ 0x1A80 , 0x81359438},
{ 0x1A81 , 0x81359439},
{ 0x1A82 , 0x81359530},
{ 0x1A83 , 0x81359531},
{ 0x1A84 , 0x81359532},
{ 0x1A85 , 0x81359533},
{ 0x1A86 , 0x81359534},
{ 0x1A87 , 0x81359535},
{ 0x1A88 , 0x81359536},
{ 0x1A89 , 0x81359537},
{ 0x1A8A , 0x81359538},
{ 0x1A8B , 0x81359539},
{ 0x1A8C , 0x81359630},
{ 0x1A8D , 0x81359631},
{ 0x1A8E , 0x81359632},
{ 0x1A8F , 0x81359633},
{ 0x1A90 , 0x81359634},
{ 0x1A91 , 0x81359635},
{ 0x1A92 , 0x81359636},
{ 0x1A93 , 0x81359637},
{ 0x1A94 , 0x81359638},
{ 0x1A95 , 0x81359639},
{ 0x1A96 , 0x81359730},
{ 0x1A97 , 0x81359731},
{ 0x1A98 , 0x81359732},
{ 0x1A99 , 0x81359733},
{ 0x1A9A , 0x81359734},
{ 0x1A9B , 0x81359735},
{ 0x1A9C , 0x81359736},
{ 0x1A9D , 0x81359737},
{ 0x1A9E , 0x81359738},
{ 0x1A9F , 0x81359739},
{ 0x1AA0 , 0x81359830},
{ 0x1AA1 , 0x81359831},
{ 0x1AA2 , 0x81359832},
{ 0x1AA3 , 0x81359833},
{ 0x1AA4 , 0x81359834},
{ 0x1AA5 , 0x81359835},
{ 0x1AA6 , 0x81359836},
{ 0x1AA7 , 0x81359837},
{ 0x1AA8 , 0x81359838},
{ 0x1AA9 , 0x81359839},
{ 0x1AAA , 0x81359930},
{ 0x1AAB , 0x81359931},
{ 0x1AAC , 0x81359932},
{ 0x1AAD , 0x81359933},
{ 0x1AAE , 0x81359934},
{ 0x1AAF , 0x81359935},
{ 0x1AB0 , 0x81359936},
{ 0x1AB1 , 0x81359937},
{ 0x1AB2 , 0x81359938},
{ 0x1AB3 , 0x81359939},
{ 0x1AB4 , 0x81359A30},
{ 0x1AB5 , 0x81359A31},
{ 0x1AB6 , 0x81359A32},
{ 0x1AB7 , 0x81359A33},
{ 0x1AB8 , 0x81359A34},
{ 0x1AB9 , 0x81359A35},
{ 0x1ABA , 0x81359A36},
{ 0x1ABB , 0x81359A37},
{ 0x1ABC , 0x81359A38},
{ 0x1ABD , 0x81359A39},
{ 0x1ABE , 0x81359B30},
{ 0x1ABF , 0x81359B31},
{ 0x1AC0 , 0x81359B32},
{ 0x1AC1 , 0x81359B33},
{ 0x1AC2 , 0x81359B34},
{ 0x1AC3 , 0x81359B35},
{ 0x1AC4 , 0x81359B36},
{ 0x1AC5 , 0x81359B37},
{ 0x1AC6 , 0x81359B38},
{ 0x1AC7 , 0x81359B39},
{ 0x1AC8 , 0x81359C30},
{ 0x1AC9 , 0x81359C31},
{ 0x1ACA , 0x81359C32},
{ 0x1ACB , 0x81359C33},
{ 0x1ACC , 0x81359C34},
{ 0x1ACD , 0x81359C35},
{ 0x1ACE , 0x81359C36},
{ 0x1ACF , 0x81359C37},
{ 0x1AD0 , 0x81359C38},
{ 0x1AD1 , 0x81359C39},
{ 0x1AD2 , 0x81359D30},
{ 0x1AD3 , 0x81359D31},
{ 0x1AD4 , 0x81359D32},
{ 0x1AD5 , 0x81359D33},
{ 0x1AD6 , 0x81359D34},
{ 0x1AD7 , 0x81359D35},
{ 0x1AD8 , 0x81359D36},
{ 0x1AD9 , 0x81359D37},
{ 0x1ADA , 0x81359D38},
{ 0x1ADB , 0x81359D39},
{ 0x1ADC , 0x81359E30},
{ 0x1ADD , 0x81359E31},
{ 0x1ADE , 0x81359E32},
{ 0x1ADF , 0x81359E33},
{ 0x1AE0 , 0x81359E34},
{ 0x1AE1 , 0x81359E35},
{ 0x1AE2 , 0x81359E36},
{ 0x1AE3 , 0x81359E37},
{ 0x1AE4 , 0x81359E38},
{ 0x1AE5 , 0x81359E39},
{ 0x1AE6 , 0x81359F30},
{ 0x1AE7 , 0x81359F31},
{ 0x1AE8 , 0x81359F32},
{ 0x1AE9 , 0x81359F33},
{ 0x1AEA , 0x81359F34},
{ 0x1AEB , 0x81359F35},
{ 0x1AEC , 0x81359F36},
{ 0x1AED , 0x81359F37},
{ 0x1AEE , 0x81359F38},
{ 0x1AEF , 0x81359F39},
{ 0x1AF0 , 0x8135A030},
{ 0x1AF1 , 0x8135A031},
{ 0x1AF2 , 0x8135A032},
{ 0x1AF3 , 0x8135A033},
{ 0x1AF4 , 0x8135A034},
{ 0x1AF5 , 0x8135A035},
{ 0x1AF6 , 0x8135A036},
{ 0x1AF7 , 0x8135A037},
{ 0x1AF8 , 0x8135A038},
{ 0x1AF9 , 0x8135A039},
{ 0x1AFA , 0x8135A130},
{ 0x1AFB , 0x8135A131},
{ 0x1AFC , 0x8135A132},
{ 0x1AFD , 0x8135A133},
{ 0x1AFE , 0x8135A134},
{ 0x1AFF , 0x8135A135},
{ 0x1B00 , 0x8135A136},
{ 0x1B01 , 0x8135A137},
{ 0x1B02 , 0x8135A138},
{ 0x1B03 , 0x8135A139},
{ 0x1B04 , 0x8135A230},
{ 0x1B05 , 0x8135A231},
{ 0x1B06 , 0x8135A232},
{ 0x1B07 , 0x8135A233},
{ 0x1B08 , 0x8135A234},
{ 0x1B09 , 0x8135A235},
{ 0x1B0A , 0x8135A236},
{ 0x1B0B , 0x8135A237},
{ 0x1B0C , 0x8135A238},
{ 0x1B0D , 0x8135A239},
{ 0x1B0E , 0x8135A330},
{ 0x1B0F , 0x8135A331},
{ 0x1B10 , 0x8135A332},
{ 0x1B11 , 0x8135A333},
{ 0x1B12 , 0x8135A334},
{ 0x1B13 , 0x8135A335},
{ 0x1B14 , 0x8135A336},
{ 0x1B15 , 0x8135A337},
{ 0x1B16 , 0x8135A338},
{ 0x1B17 , 0x8135A339},
{ 0x1B18 , 0x8135A430},
{ 0x1B19 , 0x8135A431},
{ 0x1B1A , 0x8135A432},
{ 0x1B1B , 0x8135A433},
{ 0x1B1C , 0x8135A434},
{ 0x1B1D , 0x8135A435},
{ 0x1B1E , 0x8135A436},
{ 0x1B1F , 0x8135A437},
{ 0x1B20 , 0x8135A438},
{ 0x1B21 , 0x8135A439},
{ 0x1B22 , 0x8135A530},
{ 0x1B23 , 0x8135A531},
{ 0x1B24 , 0x8135A532},
{ 0x1B25 , 0x8135A533},
{ 0x1B26 , 0x8135A534},
{ 0x1B27 , 0x8135A535},
{ 0x1B28 , 0x8135A536},
{ 0x1B29 , 0x8135A537},
{ 0x1B2A , 0x8135A538},
{ 0x1B2B , 0x8135A539},
{ 0x1B2C , 0x8135A630},
{ 0x1B2D , 0x8135A631},
{ 0x1B2E , 0x8135A632},
{ 0x1B2F , 0x8135A633},
{ 0x1B30 , 0x8135A634},
{ 0x1B31 , 0x8135A635},
{ 0x1B32 , 0x8135A636},
{ 0x1B33 , 0x8135A637},
{ 0x1B34 , 0x8135A638},
{ 0x1B35 , 0x8135A639},
{ 0x1B36 , 0x8135A730},
{ 0x1B37 , 0x8135A731},
{ 0x1B38 , 0x8135A732},
{ 0x1B39 , 0x8135A733},
{ 0x1B3A , 0x8135A734},
{ 0x1B3B , 0x8135A735},
{ 0x1B3C , 0x8135A736},
{ 0x1B3D , 0x8135A737},
{ 0x1B3E , 0x8135A738},
{ 0x1B3F , 0x8135A739},
{ 0x1B40 , 0x8135A830},
{ 0x1B41 , 0x8135A831},
{ 0x1B42 , 0x8135A832},
{ 0x1B43 , 0x8135A833},
{ 0x1B44 , 0x8135A834},
{ 0x1B45 , 0x8135A835},
{ 0x1B46 , 0x8135A836},
{ 0x1B47 , 0x8135A837},
{ 0x1B48 , 0x8135A838},
{ 0x1B49 , 0x8135A839},
{ 0x1B4A , 0x8135A930},
{ 0x1B4B , 0x8135A931},
{ 0x1B4C , 0x8135A932},
{ 0x1B4D , 0x8135A933},
{ 0x1B4E , 0x8135A934},
{ 0x1B4F , 0x8135A935},
{ 0x1B50 , 0x8135A936},
{ 0x1B51 , 0x8135A937},
{ 0x1B52 , 0x8135A938},
{ 0x1B53 , 0x8135A939},
{ 0x1B54 , 0x8135AA30},
{ 0x1B55 , 0x8135AA31},
{ 0x1B56 , 0x8135AA32},
{ 0x1B57 , 0x8135AA33},
{ 0x1B58 , 0x8135AA34},
{ 0x1B59 , 0x8135AA35},
{ 0x1B5A , 0x8135AA36},
{ 0x1B5B , 0x8135AA37},
{ 0x1B5C , 0x8135AA38},
{ 0x1B5D , 0x8135AA39},
{ 0x1B5E , 0x8135AB30},
{ 0x1B5F , 0x8135AB31},
{ 0x1B60 , 0x8135AB32},
{ 0x1B61 , 0x8135AB33},
{ 0x1B62 , 0x8135AB34},
{ 0x1B63 , 0x8135AB35},
{ 0x1B64 , 0x8135AB36},
{ 0x1B65 , 0x8135AB37},
{ 0x1B66 , 0x8135AB38},
{ 0x1B67 , 0x8135AB39},
{ 0x1B68 , 0x8135AC30},
{ 0x1B69 , 0x8135AC31},
{ 0x1B6A , 0x8135AC32},
{ 0x1B6B , 0x8135AC33},
{ 0x1B6C , 0x8135AC34},
{ 0x1B6D , 0x8135AC35},
{ 0x1B6E , 0x8135AC36},
{ 0x1B6F , 0x8135AC37},
{ 0x1B70 , 0x8135AC38},
{ 0x1B71 , 0x8135AC39},
{ 0x1B72 , 0x8135AD30},
{ 0x1B73 , 0x8135AD31},
{ 0x1B74 , 0x8135AD32},
{ 0x1B75 , 0x8135AD33},
{ 0x1B76 , 0x8135AD34},
{ 0x1B77 , 0x8135AD35},
{ 0x1B78 , 0x8135AD36},
{ 0x1B79 , 0x8135AD37},
{ 0x1B7A , 0x8135AD38},
{ 0x1B7B , 0x8135AD39},
{ 0x1B7C , 0x8135AE30},
{ 0x1B7D , 0x8135AE31},
{ 0x1B7E , 0x8135AE32},
{ 0x1B7F , 0x8135AE33},
{ 0x1B80 , 0x8135AE34},
{ 0x1B81 , 0x8135AE35},
{ 0x1B82 , 0x8135AE36},
{ 0x1B83 , 0x8135AE37},
{ 0x1B84 , 0x8135AE38},
{ 0x1B85 , 0x8135AE39},
{ 0x1B86 , 0x8135AF30},
{ 0x1B87 , 0x8135AF31},
{ 0x1B88 , 0x8135AF32},
{ 0x1B89 , 0x8135AF33},
{ 0x1B8A , 0x8135AF34},
{ 0x1B8B , 0x8135AF35},
{ 0x1B8C , 0x8135AF36},
{ 0x1B8D , 0x8135AF37},
{ 0x1B8E , 0x8135AF38},
{ 0x1B8F , 0x8135AF39},
{ 0x1B90 , 0x8135B030},
{ 0x1B91 , 0x8135B031},
{ 0x1B92 , 0x8135B032},
{ 0x1B93 , 0x8135B033},
{ 0x1B94 , 0x8135B034},
{ 0x1B95 , 0x8135B035},
{ 0x1B96 , 0x8135B036},
{ 0x1B97 , 0x8135B037},
{ 0x1B98 , 0x8135B038},
{ 0x1B99 , 0x8135B039},
{ 0x1B9A , 0x8135B130},
{ 0x1B9B , 0x8135B131},
{ 0x1B9C , 0x8135B132},
{ 0x1B9D , 0x8135B133},
{ 0x1B9E , 0x8135B134},
{ 0x1B9F , 0x8135B135},
{ 0x1BA0 , 0x8135B136},
{ 0x1BA1 , 0x8135B137},
{ 0x1BA2 , 0x8135B138},
{ 0x1BA3 , 0x8135B139},
{ 0x1BA4 , 0x8135B230},
{ 0x1BA5 , 0x8135B231},
{ 0x1BA6 , 0x8135B232},
{ 0x1BA7 , 0x8135B233},
{ 0x1BA8 , 0x8135B234},
{ 0x1BA9 , 0x8135B235},
{ 0x1BAA , 0x8135B236},
{ 0x1BAB , 0x8135B237},
{ 0x1BAC , 0x8135B238},
{ 0x1BAD , 0x8135B239},
{ 0x1BAE , 0x8135B330},
{ 0x1BAF , 0x8135B331},
{ 0x1BB0 , 0x8135B332},
{ 0x1BB1 , 0x8135B333},
{ 0x1BB2 , 0x8135B334},
{ 0x1BB3 , 0x8135B335},
{ 0x1BB4 , 0x8135B336},
{ 0x1BB5 , 0x8135B337},
{ 0x1BB6 , 0x8135B338},
{ 0x1BB7 , 0x8135B339},
{ 0x1BB8 , 0x8135B430},
{ 0x1BB9 , 0x8135B431},
{ 0x1BBA , 0x8135B432},
{ 0x1BBB , 0x8135B433},
{ 0x1BBC , 0x8135B434},
{ 0x1BBD , 0x8135B435},
{ 0x1BBE , 0x8135B436},
{ 0x1BBF , 0x8135B437},
{ 0x1BC0 , 0x8135B438},
{ 0x1BC1 , 0x8135B439},
{ 0x1BC2 , 0x8135B530},
{ 0x1BC3 , 0x8135B531},
{ 0x1BC4 , 0x8135B532},
{ 0x1BC5 , 0x8135B533},
{ 0x1BC6 , 0x8135B534},
{ 0x1BC7 , 0x8135B535},
{ 0x1BC8 , 0x8135B536},
{ 0x1BC9 , 0x8135B537},
{ 0x1BCA , 0x8135B538},
{ 0x1BCB , 0x8135B539},
{ 0x1BCC , 0x8135B630},
{ 0x1BCD , 0x8135B631},
{ 0x1BCE , 0x8135B632},
{ 0x1BCF , 0x8135B633},
{ 0x1BD0 , 0x8135B634},
{ 0x1BD1 , 0x8135B635},
{ 0x1BD2 , 0x8135B636},
{ 0x1BD3 , 0x8135B637},
{ 0x1BD4 , 0x8135B638},
{ 0x1BD5 , 0x8135B639},
{ 0x1BD6 , 0x8135B730},
{ 0x1BD7 , 0x8135B731},
{ 0x1BD8 , 0x8135B732},
{ 0x1BD9 , 0x8135B733},
{ 0x1BDA , 0x8135B734},
{ 0x1BDB , 0x8135B735},
{ 0x1BDC , 0x8135B736},
{ 0x1BDD , 0x8135B737},
{ 0x1BDE , 0x8135B738},
{ 0x1BDF , 0x8135B739},
{ 0x1BE0 , 0x8135B830},
{ 0x1BE1 , 0x8135B831},
{ 0x1BE2 , 0x8135B832},
{ 0x1BE3 , 0x8135B833},
{ 0x1BE4 , 0x8135B834},
{ 0x1BE5 , 0x8135B835},
{ 0x1BE6 , 0x8135B836},
{ 0x1BE7 , 0x8135B837},
{ 0x1BE8 , 0x8135B838},
{ 0x1BE9 , 0x8135B839},
{ 0x1BEA , 0x8135B930},
{ 0x1BEB , 0x8135B931},
{ 0x1BEC , 0x8135B932},
{ 0x1BED , 0x8135B933},
{ 0x1BEE , 0x8135B934},
{ 0x1BEF , 0x8135B935},
{ 0x1BF0 , 0x8135B936},
{ 0x1BF1 , 0x8135B937},
{ 0x1BF2 , 0x8135B938},
{ 0x1BF3 , 0x8135B939},
{ 0x1BF4 , 0x8135BA30},
{ 0x1BF5 , 0x8135BA31},
{ 0x1BF6 , 0x8135BA32},
{ 0x1BF7 , 0x8135BA33},
{ 0x1BF8 , 0x8135BA34},
{ 0x1BF9 , 0x8135BA35},
{ 0x1BFA , 0x8135BA36},
{ 0x1BFB , 0x8135BA37},
{ 0x1BFC , 0x8135BA38},
{ 0x1BFD , 0x8135BA39},
{ 0x1BFE , 0x8135BB30},
{ 0x1BFF , 0x8135BB31},
{ 0x1C00 , 0x8135BB32},
{ 0x1C01 , 0x8135BB33},
{ 0x1C02 , 0x8135BB34},
{ 0x1C03 , 0x8135BB35},
{ 0x1C04 , 0x8135BB36},
{ 0x1C05 , 0x8135BB37},
{ 0x1C06 , 0x8135BB38},
{ 0x1C07 , 0x8135BB39},
{ 0x1C08 , 0x8135BC30},
{ 0x1C09 , 0x8135BC31},
{ 0x1C0A , 0x8135BC32},
{ 0x1C0B , 0x8135BC33},
{ 0x1C0C , 0x8135BC34},
{ 0x1C0D , 0x8135BC35},
{ 0x1C0E , 0x8135BC36},
{ 0x1C0F , 0x8135BC37},
{ 0x1C10 , 0x8135BC38},
{ 0x1C11 , 0x8135BC39},
{ 0x1C12 , 0x8135BD30},
{ 0x1C13 , 0x8135BD31},
{ 0x1C14 , 0x8135BD32},
{ 0x1C15 , 0x8135BD33},
{ 0x1C16 , 0x8135BD34},
{ 0x1C17 , 0x8135BD35},
{ 0x1C18 , 0x8135BD36},
{ 0x1C19 , 0x8135BD37},
{ 0x1C1A , 0x8135BD38},
{ 0x1C1B , 0x8135BD39},
{ 0x1C1C , 0x8135BE30},
{ 0x1C1D , 0x8135BE31},
{ 0x1C1E , 0x8135BE32},
{ 0x1C1F , 0x8135BE33},
{ 0x1C20 , 0x8135BE34},
{ 0x1C21 , 0x8135BE35},
{ 0x1C22 , 0x8135BE36},
{ 0x1C23 , 0x8135BE37},
{ 0x1C24 , 0x8135BE38},
{ 0x1C25 , 0x8135BE39},
{ 0x1C26 , 0x8135BF30},
{ 0x1C27 , 0x8135BF31},
{ 0x1C28 , 0x8135BF32},
{ 0x1C29 , 0x8135BF33},
{ 0x1C2A , 0x8135BF34},
{ 0x1C2B , 0x8135BF35},
{ 0x1C2C , 0x8135BF36},
{ 0x1C2D , 0x8135BF37},
{ 0x1C2E , 0x8135BF38},
{ 0x1C2F , 0x8135BF39},
{ 0x1C30 , 0x8135C030},
{ 0x1C31 , 0x8135C031},
{ 0x1C32 , 0x8135C032},
{ 0x1C33 , 0x8135C033},
{ 0x1C34 , 0x8135C034},
{ 0x1C35 , 0x8135C035},
{ 0x1C36 , 0x8135C036},
{ 0x1C37 , 0x8135C037},
{ 0x1C38 , 0x8135C038},
{ 0x1C39 , 0x8135C039},
{ 0x1C3A , 0x8135C130},
{ 0x1C3B , 0x8135C131},
{ 0x1C3C , 0x8135C132},
{ 0x1C3D , 0x8135C133},
{ 0x1C3E , 0x8135C134},
{ 0x1C3F , 0x8135C135},
{ 0x1C40 , 0x8135C136},
{ 0x1C41 , 0x8135C137},
{ 0x1C42 , 0x8135C138},
{ 0x1C43 , 0x8135C139},
{ 0x1C44 , 0x8135C230},
{ 0x1C45 , 0x8135C231},
{ 0x1C46 , 0x8135C232},
{ 0x1C47 , 0x8135C233},
{ 0x1C48 , 0x8135C234},
{ 0x1C49 , 0x8135C235},
{ 0x1C4A , 0x8135C236},
{ 0x1C4B , 0x8135C237},
{ 0x1C4C , 0x8135C238},
{ 0x1C4D , 0x8135C239},
{ 0x1C4E , 0x8135C330},
{ 0x1C4F , 0x8135C331},
{ 0x1C50 , 0x8135C332},
{ 0x1C51 , 0x8135C333},
{ 0x1C52 , 0x8135C334},
{ 0x1C53 , 0x8135C335},
{ 0x1C54 , 0x8135C336},
{ 0x1C55 , 0x8135C337},
{ 0x1C56 , 0x8135C338},
{ 0x1C57 , 0x8135C339},
{ 0x1C58 , 0x8135C430},
{ 0x1C59 , 0x8135C431},
{ 0x1C5A , 0x8135C432},
{ 0x1C5B , 0x8135C433},
{ 0x1C5C , 0x8135C434},
{ 0x1C5D , 0x8135C435},
{ 0x1C5E , 0x8135C436},
{ 0x1C5F , 0x8135C437},
{ 0x1C60 , 0x8135C438},
{ 0x1C61 , 0x8135C439},
{ 0x1C62 , 0x8135C530},
{ 0x1C63 , 0x8135C531},
{ 0x1C64 , 0x8135C532},
{ 0x1C65 , 0x8135C533},
{ 0x1C66 , 0x8135C534},
{ 0x1C67 , 0x8135C535},
{ 0x1C68 , 0x8135C536},
{ 0x1C69 , 0x8135C537},
{ 0x1C6A , 0x8135C538},
{ 0x1C6B , 0x8135C539},
{ 0x1C6C , 0x8135C630},
{ 0x1C6D , 0x8135C631},
{ 0x1C6E , 0x8135C632},
{ 0x1C6F , 0x8135C633},
{ 0x1C70 , 0x8135C634},
{ 0x1C71 , 0x8135C635},
{ 0x1C72 , 0x8135C636},
{ 0x1C73 , 0x8135C637},
{ 0x1C74 , 0x8135C638},
{ 0x1C75 , 0x8135C639},
{ 0x1C76 , 0x8135C730},
{ 0x1C77 , 0x8135C731},
{ 0x1C78 , 0x8135C732},
{ 0x1C79 , 0x8135C733},
{ 0x1C7A , 0x8135C734},
{ 0x1C7B , 0x8135C735},
{ 0x1C7C , 0x8135C736},
{ 0x1C7D , 0x8135C737},
{ 0x1C7E , 0x8135C738},
{ 0x1C7F , 0x8135C739},
{ 0x1C80 , 0x8135C830},
{ 0x1C81 , 0x8135C831},
{ 0x1C82 , 0x8135C832},
{ 0x1C83 , 0x8135C833},
{ 0x1C84 , 0x8135C834},
{ 0x1C85 , 0x8135C835},
{ 0x1C86 , 0x8135C836},
{ 0x1C87 , 0x8135C837},
{ 0x1C88 , 0x8135C838},
{ 0x1C89 , 0x8135C839},
{ 0x1C8A , 0x8135C930},
{ 0x1C8B , 0x8135C931},
{ 0x1C8C , 0x8135C932},
{ 0x1C8D , 0x8135C933},
{ 0x1C8E , 0x8135C934},
{ 0x1C8F , 0x8135C935},
{ 0x1C90 , 0x8135C936},
{ 0x1C91 , 0x8135C937},
{ 0x1C92 , 0x8135C938},
{ 0x1C93 , 0x8135C939},
{ 0x1C94 , 0x8135CA30},
{ 0x1C95 , 0x8135CA31},
{ 0x1C96 , 0x8135CA32},
{ 0x1C97 , 0x8135CA33},
{ 0x1C98 , 0x8135CA34},
{ 0x1C99 , 0x8135CA35},
{ 0x1C9A , 0x8135CA36},
{ 0x1C9B , 0x8135CA37},
{ 0x1C9C , 0x8135CA38},
{ 0x1C9D , 0x8135CA39},
{ 0x1C9E , 0x8135CB30},
{ 0x1C9F , 0x8135CB31},
{ 0x1CA0 , 0x8135CB32},
{ 0x1CA1 , 0x8135CB33},
{ 0x1CA2 , 0x8135CB34},
{ 0x1CA3 , 0x8135CB35},
{ 0x1CA4 , 0x8135CB36},
{ 0x1CA5 , 0x8135CB37},
{ 0x1CA6 , 0x8135CB38},
{ 0x1CA7 , 0x8135CB39},
{ 0x1CA8 , 0x8135CC30},
{ 0x1CA9 , 0x8135CC31},
{ 0x1CAA , 0x8135CC32},
{ 0x1CAB , 0x8135CC33},
{ 0x1CAC , 0x8135CC34},
{ 0x1CAD , 0x8135CC35},
{ 0x1CAE , 0x8135CC36},
{ 0x1CAF , 0x8135CC37},
{ 0x1CB0 , 0x8135CC38},
{ 0x1CB1 , 0x8135CC39},
{ 0x1CB2 , 0x8135CD30},
{ 0x1CB3 , 0x8135CD31},
{ 0x1CB4 , 0x8135CD32},
{ 0x1CB5 , 0x8135CD33},
{ 0x1CB6 , 0x8135CD34},
{ 0x1CB7 , 0x8135CD35},
{ 0x1CB8 , 0x8135CD36},
{ 0x1CB9 , 0x8135CD37},
{ 0x1CBA , 0x8135CD38},
{ 0x1CBB , 0x8135CD39},
{ 0x1CBC , 0x8135CE30},
{ 0x1CBD , 0x8135CE31},
{ 0x1CBE , 0x8135CE32},
{ 0x1CBF , 0x8135CE33},
{ 0x1CC0 , 0x8135CE34},
{ 0x1CC1 , 0x8135CE35},
{ 0x1CC2 , 0x8135CE36},
{ 0x1CC3 , 0x8135CE37},
{ 0x1CC4 , 0x8135CE38},
{ 0x1CC5 , 0x8135CE39},
{ 0x1CC6 , 0x8135CF30},
{ 0x1CC7 , 0x8135CF31},
{ 0x1CC8 , 0x8135CF32},
{ 0x1CC9 , 0x8135CF33},
{ 0x1CCA , 0x8135CF34},
{ 0x1CCB , 0x8135CF35},
{ 0x1CCC , 0x8135CF36},
{ 0x1CCD , 0x8135CF37},
{ 0x1CCE , 0x8135CF38},
{ 0x1CCF , 0x8135CF39},
{ 0x1CD0 , 0x8135D030},
{ 0x1CD1 , 0x8135D031},
{ 0x1CD2 , 0x8135D032},
{ 0x1CD3 , 0x8135D033},
{ 0x1CD4 , 0x8135D034},
{ 0x1CD5 , 0x8135D035},
{ 0x1CD6 , 0x8135D036},
{ 0x1CD7 , 0x8135D037},
{ 0x1CD8 , 0x8135D038},
{ 0x1CD9 , 0x8135D039},
{ 0x1CDA , 0x8135D130},
{ 0x1CDB , 0x8135D131},
{ 0x1CDC , 0x8135D132},
{ 0x1CDD , 0x8135D133},
{ 0x1CDE , 0x8135D134},
{ 0x1CDF , 0x8135D135},
{ 0x1CE0 , 0x8135D136},
{ 0x1CE1 , 0x8135D137},
{ 0x1CE2 , 0x8135D138},
{ 0x1CE3 , 0x8135D139},
{ 0x1CE4 , 0x8135D230},
{ 0x1CE5 , 0x8135D231},
{ 0x1CE6 , 0x8135D232},
{ 0x1CE7 , 0x8135D233},
{ 0x1CE8 , 0x8135D234},
{ 0x1CE9 , 0x8135D235},
{ 0x1CEA , 0x8135D236},
{ 0x1CEB , 0x8135D237},
{ 0x1CEC , 0x8135D238},
{ 0x1CED , 0x8135D239},
{ 0x1CEE , 0x8135D330},
{ 0x1CEF , 0x8135D331},
{ 0x1CF0 , 0x8135D332},
{ 0x1CF1 , 0x8135D333},
{ 0x1CF2 , 0x8135D334},
{ 0x1CF3 , 0x8135D335},
{ 0x1CF4 , 0x8135D336},
{ 0x1CF5 , 0x8135D337},
{ 0x1CF6 , 0x8135D338},
{ 0x1CF7 , 0x8135D339},
{ 0x1CF8 , 0x8135D430},
{ 0x1CF9 , 0x8135D431},
{ 0x1CFA , 0x8135D432},
{ 0x1CFB , 0x8135D433},
{ 0x1CFC , 0x8135D434},
{ 0x1CFD , 0x8135D435},
{ 0x1CFE , 0x8135D436},
{ 0x1CFF , 0x8135D437},
{ 0x1D00 , 0x8135D438},
{ 0x1D01 , 0x8135D439},
{ 0x1D02 , 0x8135D530},
{ 0x1D03 , 0x8135D531},
{ 0x1D04 , 0x8135D532},
{ 0x1D05 , 0x8135D533},
{ 0x1D06 , 0x8135D534},
{ 0x1D07 , 0x8135D535},
{ 0x1D08 , 0x8135D536},
{ 0x1D09 , 0x8135D537},
{ 0x1D0A , 0x8135D538},
{ 0x1D0B , 0x8135D539},
{ 0x1D0C , 0x8135D630},
{ 0x1D0D , 0x8135D631},
{ 0x1D0E , 0x8135D632},
{ 0x1D0F , 0x8135D633},
{ 0x1D10 , 0x8135D634},
{ 0x1D11 , 0x8135D635},
{ 0x1D12 , 0x8135D636},
{ 0x1D13 , 0x8135D637},
{ 0x1D14 , 0x8135D638},
{ 0x1D15 , 0x8135D639},
{ 0x1D16 , 0x8135D730},
{ 0x1D17 , 0x8135D731},
{ 0x1D18 , 0x8135D732},
{ 0x1D19 , 0x8135D733},
{ 0x1D1A , 0x8135D734},
{ 0x1D1B , 0x8135D735},
{ 0x1D1C , 0x8135D736},
{ 0x1D1D , 0x8135D737},
{ 0x1D1E , 0x8135D738},
{ 0x1D1F , 0x8135D739},
{ 0x1D20 , 0x8135D830},
{ 0x1D21 , 0x8135D831},
{ 0x1D22 , 0x8135D832},
{ 0x1D23 , 0x8135D833},
{ 0x1D24 , 0x8135D834},
{ 0x1D25 , 0x8135D835},
{ 0x1D26 , 0x8135D836},
{ 0x1D27 , 0x8135D837},
{ 0x1D28 , 0x8135D838},
{ 0x1D29 , 0x8135D839},
{ 0x1D2A , 0x8135D930},
{ 0x1D2B , 0x8135D931},
{ 0x1D2C , 0x8135D932},
{ 0x1D2D , 0x8135D933},
{ 0x1D2E , 0x8135D934},
{ 0x1D2F , 0x8135D935},
{ 0x1D30 , 0x8135D936},
{ 0x1D31 , 0x8135D937},
{ 0x1D32 , 0x8135D938},
{ 0x1D33 , 0x8135D939},
{ 0x1D34 , 0x8135DA30},
{ 0x1D35 , 0x8135DA31},
{ 0x1D36 , 0x8135DA32},
{ 0x1D37 , 0x8135DA33},
{ 0x1D38 , 0x8135DA34},
{ 0x1D39 , 0x8135DA35},
{ 0x1D3A , 0x8135DA36},
{ 0x1D3B , 0x8135DA37},
{ 0x1D3C , 0x8135DA38},
{ 0x1D3D , 0x8135DA39},
{ 0x1D3E , 0x8135DB30},
{ 0x1D3F , 0x8135DB31},
{ 0x1D40 , 0x8135DB32},
{ 0x1D41 , 0x8135DB33},
{ 0x1D42 , 0x8135DB34},
{ 0x1D43 , 0x8135DB35},
{ 0x1D44 , 0x8135DB36},
{ 0x1D45 , 0x8135DB37},
{ 0x1D46 , 0x8135DB38},
{ 0x1D47 , 0x8135DB39},
{ 0x1D48 , 0x8135DC30},
{ 0x1D49 , 0x8135DC31},
{ 0x1D4A , 0x8135DC32},
{ 0x1D4B , 0x8135DC33},
{ 0x1D4C , 0x8135DC34},
{ 0x1D4D , 0x8135DC35},
{ 0x1D4E , 0x8135DC36},
{ 0x1D4F , 0x8135DC37},
{ 0x1D50 , 0x8135DC38},
{ 0x1D51 , 0x8135DC39},
{ 0x1D52 , 0x8135DD30},
{ 0x1D53 , 0x8135DD31},
{ 0x1D54 , 0x8135DD32},
{ 0x1D55 , 0x8135DD33},
{ 0x1D56 , 0x8135DD34},
{ 0x1D57 , 0x8135DD35},
{ 0x1D58 , 0x8135DD36},
{ 0x1D59 , 0x8135DD37},
{ 0x1D5A , 0x8135DD38},
{ 0x1D5B , 0x8135DD39},
{ 0x1D5C , 0x8135DE30},
{ 0x1D5D , 0x8135DE31},
{ 0x1D5E , 0x8135DE32},
{ 0x1D5F , 0x8135DE33},
{ 0x1D60 , 0x8135DE34},
{ 0x1D61 , 0x8135DE35},
{ 0x1D62 , 0x8135DE36},
{ 0x1D63 , 0x8135DE37},
{ 0x1D64 , 0x8135DE38},
{ 0x1D65 , 0x8135DE39},
{ 0x1D66 , 0x8135DF30},
{ 0x1D67 , 0x8135DF31},
{ 0x1D68 , 0x8135DF32},
{ 0x1D69 , 0x8135DF33},
{ 0x1D6A , 0x8135DF34},
{ 0x1D6B , 0x8135DF35},
{ 0x1D6C , 0x8135DF36},
{ 0x1D6D , 0x8135DF37},
{ 0x1D6E , 0x8135DF38},
{ 0x1D6F , 0x8135DF39},
{ 0x1D70 , 0x8135E030},
{ 0x1D71 , 0x8135E031},
{ 0x1D72 , 0x8135E032},
{ 0x1D73 , 0x8135E033},
{ 0x1D74 , 0x8135E034},
{ 0x1D75 , 0x8135E035},
{ 0x1D76 , 0x8135E036},
{ 0x1D77 , 0x8135E037},
{ 0x1D78 , 0x8135E038},
{ 0x1D79 , 0x8135E039},
{ 0x1D7A , 0x8135E130},
{ 0x1D7B , 0x8135E131},
{ 0x1D7C , 0x8135E132},
{ 0x1D7D , 0x8135E133},
{ 0x1D7E , 0x8135E134},
{ 0x1D7F , 0x8135E135},
{ 0x1D80 , 0x8135E136},
{ 0x1D81 , 0x8135E137},
{ 0x1D82 , 0x8135E138},
{ 0x1D83 , 0x8135E139},
{ 0x1D84 , 0x8135E230},
{ 0x1D85 , 0x8135E231},
{ 0x1D86 , 0x8135E232},
{ 0x1D87 , 0x8135E233},
{ 0x1D88 , 0x8135E234},
{ 0x1D89 , 0x8135E235},
{ 0x1D8A , 0x8135E236},
{ 0x1D8B , 0x8135E237},
{ 0x1D8C , 0x8135E238},
{ 0x1D8D , 0x8135E239},
{ 0x1D8E , 0x8135E330},
{ 0x1D8F , 0x8135E331},
{ 0x1D90 , 0x8135E332},
{ 0x1D91 , 0x8135E333},
{ 0x1D92 , 0x8135E334},
{ 0x1D93 , 0x8135E335},
{ 0x1D94 , 0x8135E336},
{ 0x1D95 , 0x8135E337},
{ 0x1D96 , 0x8135E338},
{ 0x1D97 , 0x8135E339},
{ 0x1D98 , 0x8135E430},
{ 0x1D99 , 0x8135E431},
{ 0x1D9A , 0x8135E432},
{ 0x1D9B , 0x8135E433},
{ 0x1D9C , 0x8135E434},
{ 0x1D9D , 0x8135E435},
{ 0x1D9E , 0x8135E436},
{ 0x1D9F , 0x8135E437},
{ 0x1DA0 , 0x8135E438},
{ 0x1DA1 , 0x8135E439},
{ 0x1DA2 , 0x8135E530},
{ 0x1DA3 , 0x8135E531},
{ 0x1DA4 , 0x8135E532},
{ 0x1DA5 , 0x8135E533},
{ 0x1DA6 , 0x8135E534},
{ 0x1DA7 , 0x8135E535},
{ 0x1DA8 , 0x8135E536},
{ 0x1DA9 , 0x8135E537},
{ 0x1DAA , 0x8135E538},
{ 0x1DAB , 0x8135E539},
{ 0x1DAC , 0x8135E630},
{ 0x1DAD , 0x8135E631},
{ 0x1DAE , 0x8135E632},
{ 0x1DAF , 0x8135E633},
{ 0x1DB0 , 0x8135E634},
{ 0x1DB1 , 0x8135E635},
{ 0x1DB2 , 0x8135E636},
{ 0x1DB3 , 0x8135E637},
{ 0x1DB4 , 0x8135E638},
{ 0x1DB5 , 0x8135E639},
{ 0x1DB6 , 0x8135E730},
{ 0x1DB7 , 0x8135E731},
{ 0x1DB8 , 0x8135E732},
{ 0x1DB9 , 0x8135E733},
{ 0x1DBA , 0x8135E734},
{ 0x1DBB , 0x8135E735},
{ 0x1DBC , 0x8135E736},
{ 0x1DBD , 0x8135E737},
{ 0x1DBE , 0x8135E738},
{ 0x1DBF , 0x8135E739},
{ 0x1DC0 , 0x8135E830},
{ 0x1DC1 , 0x8135E831},
{ 0x1DC2 , 0x8135E832},
{ 0x1DC3 , 0x8135E833},
{ 0x1DC4 , 0x8135E834},
{ 0x1DC5 , 0x8135E835},
{ 0x1DC6 , 0x8135E836},
{ 0x1DC7 , 0x8135E837},
{ 0x1DC8 , 0x8135E838},
{ 0x1DC9 , 0x8135E839},
{ 0x1DCA , 0x8135E930},
{ 0x1DCB , 0x8135E931},
{ 0x1DCC , 0x8135E932},
{ 0x1DCD , 0x8135E933},
{ 0x1DCE , 0x8135E934},
{ 0x1DCF , 0x8135E935},
{ 0x1DD0 , 0x8135E936},
{ 0x1DD1 , 0x8135E937},
{ 0x1DD2 , 0x8135E938},
{ 0x1DD3 , 0x8135E939},
{ 0x1DD4 , 0x8135EA30},
{ 0x1DD5 , 0x8135EA31},
{ 0x1DD6 , 0x8135EA32},
{ 0x1DD7 , 0x8135EA33},
{ 0x1DD8 , 0x8135EA34},
{ 0x1DD9 , 0x8135EA35},
{ 0x1DDA , 0x8135EA36},
{ 0x1DDB , 0x8135EA37},
{ 0x1DDC , 0x8135EA38},
{ 0x1DDD , 0x8135EA39},
{ 0x1DDE , 0x8135EB30},
{ 0x1DDF , 0x8135EB31},
{ 0x1DE0 , 0x8135EB32},
{ 0x1DE1 , 0x8135EB33},
{ 0x1DE2 , 0x8135EB34},
{ 0x1DE3 , 0x8135EB35},
{ 0x1DE4 , 0x8135EB36},
{ 0x1DE5 , 0x8135EB37},
{ 0x1DE6 , 0x8135EB38},
{ 0x1DE7 , 0x8135EB39},
{ 0x1DE8 , 0x8135EC30},
{ 0x1DE9 , 0x8135EC31},
{ 0x1DEA , 0x8135EC32},
{ 0x1DEB , 0x8135EC33},
{ 0x1DEC , 0x8135EC34},
{ 0x1DED , 0x8135EC35},
{ 0x1DEE , 0x8135EC36},
{ 0x1DEF , 0x8135EC37},
{ 0x1DF0 , 0x8135EC38},
{ 0x1DF1 , 0x8135EC39},
{ 0x1DF2 , 0x8135ED30},
{ 0x1DF3 , 0x8135ED31},
{ 0x1DF4 , 0x8135ED32},
{ 0x1DF5 , 0x8135ED33},
{ 0x1DF6 , 0x8135ED34},
{ 0x1DF7 , 0x8135ED35},
{ 0x1DF8 , 0x8135ED36},
{ 0x1DF9 , 0x8135ED37},
{ 0x1DFA , 0x8135ED38},
{ 0x1DFB , 0x8135ED39},
{ 0x1DFC , 0x8135EE30},
{ 0x1DFD , 0x8135EE31},
{ 0x1DFE , 0x8135EE32},
{ 0x1DFF , 0x8135EE33},
{ 0x1E00 , 0x8135EE34},
{ 0x1E01 , 0x8135EE35},
{ 0x1E02 , 0x8135EE36},
{ 0x1E03 , 0x8135EE37},
{ 0x1E04 , 0x8135EE38},
{ 0x1E05 , 0x8135EE39},
{ 0x1E06 , 0x8135EF30},
{ 0x1E07 , 0x8135EF31},
{ 0x1E08 , 0x8135EF32},
{ 0x1E09 , 0x8135EF33},
{ 0x1E0A , 0x8135EF34},
{ 0x1E0B , 0x8135EF35},
{ 0x1E0C , 0x8135EF36},
{ 0x1E0D , 0x8135EF37},
{ 0x1E0E , 0x8135EF38},
{ 0x1E0F , 0x8135EF39},
{ 0x1E10 , 0x8135F030},
{ 0x1E11 , 0x8135F031},
{ 0x1E12 , 0x8135F032},
{ 0x1E13 , 0x8135F033},
{ 0x1E14 , 0x8135F034},
{ 0x1E15 , 0x8135F035},
{ 0x1E16 , 0x8135F036},
{ 0x1E17 , 0x8135F037},
{ 0x1E18 , 0x8135F038},
{ 0x1E19 , 0x8135F039},
{ 0x1E1A , 0x8135F130},
{ 0x1E1B , 0x8135F131},
{ 0x1E1C , 0x8135F132},
{ 0x1E1D , 0x8135F133},
{ 0x1E1E , 0x8135F134},
{ 0x1E1F , 0x8135F135},
{ 0x1E20 , 0x8135F136},
{ 0x1E21 , 0x8135F137},
{ 0x1E22 , 0x8135F138},
{ 0x1E23 , 0x8135F139},
{ 0x1E24 , 0x8135F230},
{ 0x1E25 , 0x8135F231},
{ 0x1E26 , 0x8135F232},
{ 0x1E27 , 0x8135F233},
{ 0x1E28 , 0x8135F234},
{ 0x1E29 , 0x8135F235},
{ 0x1E2A , 0x8135F236},
{ 0x1E2B , 0x8135F237},
{ 0x1E2C , 0x8135F238},
{ 0x1E2D , 0x8135F239},
{ 0x1E2E , 0x8135F330},
{ 0x1E2F , 0x8135F331},
{ 0x1E30 , 0x8135F332},
{ 0x1E31 , 0x8135F333},
{ 0x1E32 , 0x8135F334},
{ 0x1E33 , 0x8135F335},
{ 0x1E34 , 0x8135F336},
{ 0x1E35 , 0x8135F337},
{ 0x1E36 , 0x8135F338},
{ 0x1E37 , 0x8135F339},
{ 0x1E38 , 0x8135F430},
{ 0x1E39 , 0x8135F431},
{ 0x1E3A , 0x8135F432},
{ 0x1E3B , 0x8135F433},
{ 0x1E3C , 0x8135F434},
{ 0x1E3D , 0x8135F435},
{ 0x1E3E , 0x8135F436},
{ 0x1E3F , 0x8135F437},
{ 0x1E40 , 0x8135F438},
{ 0x1E41 , 0x8135F439},
{ 0x1E42 , 0x8135F530},
{ 0x1E43 , 0x8135F531},
{ 0x1E44 , 0x8135F532},
{ 0x1E45 , 0x8135F533},
{ 0x1E46 , 0x8135F534},
{ 0x1E47 , 0x8135F535},
{ 0x1E48 , 0x8135F536},
{ 0x1E49 , 0x8135F537},
{ 0x1E4A , 0x8135F538},
{ 0x1E4B , 0x8135F539},
{ 0x1E4C , 0x8135F630},
{ 0x1E4D , 0x8135F631},
{ 0x1E4E , 0x8135F632},
{ 0x1E4F , 0x8135F633},
{ 0x1E50 , 0x8135F634},
{ 0x1E51 , 0x8135F635},
{ 0x1E52 , 0x8135F636},
{ 0x1E53 , 0x8135F637},
{ 0x1E54 , 0x8135F638},
{ 0x1E55 , 0x8135F639},
{ 0x1E56 , 0x8135F730},
{ 0x1E57 , 0x8135F731},
{ 0x1E58 , 0x8135F732},
{ 0x1E59 , 0x8135F733},
{ 0x1E5A , 0x8135F734},
{ 0x1E5B , 0x8135F735},
{ 0x1E5C , 0x8135F736},
{ 0x1E5D , 0x8135F737},
{ 0x1E5E , 0x8135F738},
{ 0x1E5F , 0x8135F739},
{ 0x1E60 , 0x8135F830},
{ 0x1E61 , 0x8135F831},
{ 0x1E62 , 0x8135F832},
{ 0x1E63 , 0x8135F833},
{ 0x1E64 , 0x8135F834},
{ 0x1E65 , 0x8135F835},
{ 0x1E66 , 0x8135F836},
{ 0x1E67 , 0x8135F837},
{ 0x1E68 , 0x8135F838},
{ 0x1E69 , 0x8135F839},
{ 0x1E6A , 0x8135F930},
{ 0x1E6B , 0x8135F931},
{ 0x1E6C , 0x8135F932},
{ 0x1E6D , 0x8135F933},
{ 0x1E6E , 0x8135F934},
{ 0x1E6F , 0x8135F935},
{ 0x1E70 , 0x8135F936},
{ 0x1E71 , 0x8135F937},
{ 0x1E72 , 0x8135F938},
{ 0x1E73 , 0x8135F939},
{ 0x1E74 , 0x8135FA30},
{ 0x1E75 , 0x8135FA31},
{ 0x1E76 , 0x8135FA32},
{ 0x1E77 , 0x8135FA33},
{ 0x1E78 , 0x8135FA34},
{ 0x1E79 , 0x8135FA35},
{ 0x1E7A , 0x8135FA36},
{ 0x1E7B , 0x8135FA37},
{ 0x1E7C , 0x8135FA38},
{ 0x1E7D , 0x8135FA39},
{ 0x1E7E , 0x8135FB30},
{ 0x1E7F , 0x8135FB31},
{ 0x1E80 , 0x8135FB32},
{ 0x1E81 , 0x8135FB33},
{ 0x1E82 , 0x8135FB34},
{ 0x1E83 , 0x8135FB35},
{ 0x1E84 , 0x8135FB36},
{ 0x1E85 , 0x8135FB37},
{ 0x1E86 , 0x8135FB38},
{ 0x1E87 , 0x8135FB39},
{ 0x1E88 , 0x8135FC30},
{ 0x1E89 , 0x8135FC31},
{ 0x1E8A , 0x8135FC32},
{ 0x1E8B , 0x8135FC33},
{ 0x1E8C , 0x8135FC34},
{ 0x1E8D , 0x8135FC35},
{ 0x1E8E , 0x8135FC36},
{ 0x1E8F , 0x8135FC37},
{ 0x1E90 , 0x8135FC38},
{ 0x1E91 , 0x8135FC39},
{ 0x1E92 , 0x8135FD30},
{ 0x1E93 , 0x8135FD31},
{ 0x1E94 , 0x8135FD32},
{ 0x1E95 , 0x8135FD33},
{ 0x1E96 , 0x8135FD34},
{ 0x1E97 , 0x8135FD35},
{ 0x1E98 , 0x8135FD36},
{ 0x1E99 , 0x8135FD37},
{ 0x1E9A , 0x8135FD38},
{ 0x1E9B , 0x8135FD39},
{ 0x1E9C , 0x8135FE30},
{ 0x1E9D , 0x8135FE31},
{ 0x1E9E , 0x8135FE32},
{ 0x1E9F , 0x8135FE33},
{ 0x1EA0 , 0x8135FE34},
{ 0x1EA1 , 0x8135FE35},
{ 0x1EA2 , 0x8135FE36},
{ 0x1EA3 , 0x8135FE37},
{ 0x1EA4 , 0x8135FE38},
{ 0x1EA5 , 0x8135FE39},
{ 0x1EA6 , 0x81368130},
{ 0x1EA7 , 0x81368131},
{ 0x1EA8 , 0x81368132},
{ 0x1EA9 , 0x81368133},
{ 0x1EAA , 0x81368134},
{ 0x1EAB , 0x81368135},
{ 0x1EAC , 0x81368136},
{ 0x1EAD , 0x81368137},
{ 0x1EAE , 0x81368138},
{ 0x1EAF , 0x81368139},
{ 0x1EB0 , 0x81368230},
{ 0x1EB1 , 0x81368231},
{ 0x1EB2 , 0x81368232},
{ 0x1EB3 , 0x81368233},
{ 0x1EB4 , 0x81368234},
{ 0x1EB5 , 0x81368235},
{ 0x1EB6 , 0x81368236},
{ 0x1EB7 , 0x81368237},
{ 0x1EB8 , 0x81368238},
{ 0x1EB9 , 0x81368239},
{ 0x1EBA , 0x81368330},
{ 0x1EBB , 0x81368331},
{ 0x1EBC , 0x81368332},
{ 0x1EBD , 0x81368333},
{ 0x1EBE , 0x81368334},
{ 0x1EBF , 0x81368335},
{ 0x1EC0 , 0x81368336},
{ 0x1EC1 , 0x81368337},
{ 0x1EC2 , 0x81368338},
{ 0x1EC3 , 0x81368339},
{ 0x1EC4 , 0x81368430},
{ 0x1EC5 , 0x81368431},
{ 0x1EC6 , 0x81368432},
{ 0x1EC7 , 0x81368433},
{ 0x1EC8 , 0x81368434},
{ 0x1EC9 , 0x81368435},
{ 0x1ECA , 0x81368436},
{ 0x1ECB , 0x81368437},
{ 0x1ECC , 0x81368438},
{ 0x1ECD , 0x81368439},
{ 0x1ECE , 0x81368530},
{ 0x1ECF , 0x81368531},
{ 0x1ED0 , 0x81368532},
{ 0x1ED1 , 0x81368533},
{ 0x1ED2 , 0x81368534},
{ 0x1ED3 , 0x81368535},
{ 0x1ED4 , 0x81368536},
{ 0x1ED5 , 0x81368537},
{ 0x1ED6 , 0x81368538},
{ 0x1ED7 , 0x81368539},
{ 0x1ED8 , 0x81368630},
{ 0x1ED9 , 0x81368631},
{ 0x1EDA , 0x81368632},
{ 0x1EDB , 0x81368633},
{ 0x1EDC , 0x81368634},
{ 0x1EDD , 0x81368635},
{ 0x1EDE , 0x81368636},
{ 0x1EDF , 0x81368637},
{ 0x1EE0 , 0x81368638},
{ 0x1EE1 , 0x81368639},
{ 0x1EE2 , 0x81368730},
{ 0x1EE3 , 0x81368731},
{ 0x1EE4 , 0x81368732},
{ 0x1EE5 , 0x81368733},
{ 0x1EE6 , 0x81368734},
{ 0x1EE7 , 0x81368735},
{ 0x1EE8 , 0x81368736},
{ 0x1EE9 , 0x81368737},
{ 0x1EEA , 0x81368738},
{ 0x1EEB , 0x81368739},
{ 0x1EEC , 0x81368830},
{ 0x1EED , 0x81368831},
{ 0x1EEE , 0x81368832},
{ 0x1EEF , 0x81368833},
{ 0x1EF0 , 0x81368834},
{ 0x1EF1 , 0x81368835},
{ 0x1EF2 , 0x81368836},
{ 0x1EF3 , 0x81368837},
{ 0x1EF4 , 0x81368838},
{ 0x1EF5 , 0x81368839},
{ 0x1EF6 , 0x81368930},
{ 0x1EF7 , 0x81368931},
{ 0x1EF8 , 0x81368932},
{ 0x1EF9 , 0x81368933},
{ 0x1EFA , 0x81368934},
{ 0x1EFB , 0x81368935},
{ 0x1EFC , 0x81368936},
{ 0x1EFD , 0x81368937},
{ 0x1EFE , 0x81368938},
{ 0x1EFF , 0x81368939},
{ 0x1F00 , 0x81368A30},
{ 0x1F01 , 0x81368A31},
{ 0x1F02 , 0x81368A32},
{ 0x1F03 , 0x81368A33},
{ 0x1F04 , 0x81368A34},
{ 0x1F05 , 0x81368A35},
{ 0x1F06 , 0x81368A36},
{ 0x1F07 , 0x81368A37},
{ 0x1F08 , 0x81368A38},
{ 0x1F09 , 0x81368A39},
{ 0x1F0A , 0x81368B30},
{ 0x1F0B , 0x81368B31},
{ 0x1F0C , 0x81368B32},
{ 0x1F0D , 0x81368B33},
{ 0x1F0E , 0x81368B34},
{ 0x1F0F , 0x81368B35},
{ 0x1F10 , 0x81368B36},
{ 0x1F11 , 0x81368B37},
{ 0x1F12 , 0x81368B38},
{ 0x1F13 , 0x81368B39},
{ 0x1F14 , 0x81368C30},
{ 0x1F15 , 0x81368C31},
{ 0x1F16 , 0x81368C32},
{ 0x1F17 , 0x81368C33},
{ 0x1F18 , 0x81368C34},
{ 0x1F19 , 0x81368C35},
{ 0x1F1A , 0x81368C36},
{ 0x1F1B , 0x81368C37},
{ 0x1F1C , 0x81368C38},
{ 0x1F1D , 0x81368C39},
{ 0x1F1E , 0x81368D30},
{ 0x1F1F , 0x81368D31},
{ 0x1F20 , 0x81368D32},
{ 0x1F21 , 0x81368D33},
{ 0x1F22 , 0x81368D34},
{ 0x1F23 , 0x81368D35},
{ 0x1F24 , 0x81368D36},
{ 0x1F25 , 0x81368D37},
{ 0x1F26 , 0x81368D38},
{ 0x1F27 , 0x81368D39},
{ 0x1F28 , 0x81368E30},
{ 0x1F29 , 0x81368E31},
{ 0x1F2A , 0x81368E32},
{ 0x1F2B , 0x81368E33},
{ 0x1F2C , 0x81368E34},
{ 0x1F2D , 0x81368E35},
{ 0x1F2E , 0x81368E36},
{ 0x1F2F , 0x81368E37},
{ 0x1F30 , 0x81368E38},
{ 0x1F31 , 0x81368E39},
{ 0x1F32 , 0x81368F30},
{ 0x1F33 , 0x81368F31},
{ 0x1F34 , 0x81368F32},
{ 0x1F35 , 0x81368F33},
{ 0x1F36 , 0x81368F34},
{ 0x1F37 , 0x81368F35},
{ 0x1F38 , 0x81368F36},
{ 0x1F39 , 0x81368F37},
{ 0x1F3A , 0x81368F38},
{ 0x1F3B , 0x81368F39},
{ 0x1F3C , 0x81369030},
{ 0x1F3D , 0x81369031},
{ 0x1F3E , 0x81369032},
{ 0x1F3F , 0x81369033},
{ 0x1F40 , 0x81369034},
{ 0x1F41 , 0x81369035},
{ 0x1F42 , 0x81369036},
{ 0x1F43 , 0x81369037},
{ 0x1F44 , 0x81369038},
{ 0x1F45 , 0x81369039},
{ 0x1F46 , 0x81369130},
{ 0x1F47 , 0x81369131},
{ 0x1F48 , 0x81369132},
{ 0x1F49 , 0x81369133},
{ 0x1F4A , 0x81369134},
{ 0x1F4B , 0x81369135},
{ 0x1F4C , 0x81369136},
{ 0x1F4D , 0x81369137},
{ 0x1F4E , 0x81369138},
{ 0x1F4F , 0x81369139},
{ 0x1F50 , 0x81369230},
{ 0x1F51 , 0x81369231},
{ 0x1F52 , 0x81369232},
{ 0x1F53 , 0x81369233},
{ 0x1F54 , 0x81369234},
{ 0x1F55 , 0x81369235},
{ 0x1F56 , 0x81369236},
{ 0x1F57 , 0x81369237},
{ 0x1F58 , 0x81369238},
{ 0x1F59 , 0x81369239},
{ 0x1F5A , 0x81369330},
{ 0x1F5B , 0x81369331},
{ 0x1F5C , 0x81369332},
{ 0x1F5D , 0x81369333},
{ 0x1F5E , 0x81369334},
{ 0x1F5F , 0x81369335},
{ 0x1F60 , 0x81369336},
{ 0x1F61 , 0x81369337},
{ 0x1F62 , 0x81369338},
{ 0x1F63 , 0x81369339},
{ 0x1F64 , 0x81369430},
{ 0x1F65 , 0x81369431},
{ 0x1F66 , 0x81369432},
{ 0x1F67 , 0x81369433},
{ 0x1F68 , 0x81369434},
{ 0x1F69 , 0x81369435},
{ 0x1F6A , 0x81369436},
{ 0x1F6B , 0x81369437},
{ 0x1F6C , 0x81369438},
{ 0x1F6D , 0x81369439},
{ 0x1F6E , 0x81369530},
{ 0x1F6F , 0x81369531},
{ 0x1F70 , 0x81369532},
{ 0x1F71 , 0x81369533},
{ 0x1F72 , 0x81369534},
{ 0x1F73 , 0x81369535},
{ 0x1F74 , 0x81369536},
{ 0x1F75 , 0x81369537},
{ 0x1F76 , 0x81369538},
{ 0x1F77 , 0x81369539},
{ 0x1F78 , 0x81369630},
{ 0x1F79 , 0x81369631},
{ 0x1F7A , 0x81369632},
{ 0x1F7B , 0x81369633},
{ 0x1F7C , 0x81369634},
{ 0x1F7D , 0x81369635},
{ 0x1F7E , 0x81369636},
{ 0x1F7F , 0x81369637},
{ 0x1F80 , 0x81369638},
{ 0x1F81 , 0x81369639},
{ 0x1F82 , 0x81369730},
{ 0x1F83 , 0x81369731},
{ 0x1F84 , 0x81369732},
{ 0x1F85 , 0x81369733},
{ 0x1F86 , 0x81369734},
{ 0x1F87 , 0x81369735},
{ 0x1F88 , 0x81369736},
{ 0x1F89 , 0x81369737},
{ 0x1F8A , 0x81369738},
{ 0x1F8B , 0x81369739},
{ 0x1F8C , 0x81369830},
{ 0x1F8D , 0x81369831},
{ 0x1F8E , 0x81369832},
{ 0x1F8F , 0x81369833},
{ 0x1F90 , 0x81369834},
{ 0x1F91 , 0x81369835},
{ 0x1F92 , 0x81369836},
{ 0x1F93 , 0x81369837},
{ 0x1F94 , 0x81369838},
{ 0x1F95 , 0x81369839},
{ 0x1F96 , 0x81369930},
{ 0x1F97 , 0x81369931},
{ 0x1F98 , 0x81369932},
{ 0x1F99 , 0x81369933},
{ 0x1F9A , 0x81369934},
{ 0x1F9B , 0x81369935},
{ 0x1F9C , 0x81369936},
{ 0x1F9D , 0x81369937},
{ 0x1F9E , 0x81369938},
{ 0x1F9F , 0x81369939},
{ 0x1FA0 , 0x81369A30},
{ 0x1FA1 , 0x81369A31},
{ 0x1FA2 , 0x81369A32},
{ 0x1FA3 , 0x81369A33},
{ 0x1FA4 , 0x81369A34},
{ 0x1FA5 , 0x81369A35},
{ 0x1FA6 , 0x81369A36},
{ 0x1FA7 , 0x81369A37},
{ 0x1FA8 , 0x81369A38},
{ 0x1FA9 , 0x81369A39},
{ 0x1FAA , 0x81369B30},
{ 0x1FAB , 0x81369B31},
{ 0x1FAC , 0x81369B32},
{ 0x1FAD , 0x81369B33},
{ 0x1FAE , 0x81369B34},
{ 0x1FAF , 0x81369B35},
{ 0x1FB0 , 0x81369B36},
{ 0x1FB1 , 0x81369B37},
{ 0x1FB2 , 0x81369B38},
{ 0x1FB3 , 0x81369B39},
{ 0x1FB4 , 0x81369C30},
{ 0x1FB5 , 0x81369C31},
{ 0x1FB6 , 0x81369C32},
{ 0x1FB7 , 0x81369C33},
{ 0x1FB8 , 0x81369C34},
{ 0x1FB9 , 0x81369C35},
{ 0x1FBA , 0x81369C36},
{ 0x1FBB , 0x81369C37},
{ 0x1FBC , 0x81369C38},
{ 0x1FBD , 0x81369C39},
{ 0x1FBE , 0x81369D30},
{ 0x1FBF , 0x81369D31},
{ 0x1FC0 , 0x81369D32},
{ 0x1FC1 , 0x81369D33},
{ 0x1FC2 , 0x81369D34},
{ 0x1FC3 , 0x81369D35},
{ 0x1FC4 , 0x81369D36},
{ 0x1FC5 , 0x81369D37},
{ 0x1FC6 , 0x81369D38},
{ 0x1FC7 , 0x81369D39},
{ 0x1FC8 , 0x81369E30},
{ 0x1FC9 , 0x81369E31},
{ 0x1FCA , 0x81369E32},
{ 0x1FCB , 0x81369E33},
{ 0x1FCC , 0x81369E34},
{ 0x1FCD , 0x81369E35},
{ 0x1FCE , 0x81369E36},
{ 0x1FCF , 0x81369E37},
{ 0x1FD0 , 0x81369E38},
{ 0x1FD1 , 0x81369E39},
{ 0x1FD2 , 0x81369F30},
{ 0x1FD3 , 0x81369F31},
{ 0x1FD4 , 0x81369F32},
{ 0x1FD5 , 0x81369F33},
{ 0x1FD6 , 0x81369F34},
{ 0x1FD7 , 0x81369F35},
{ 0x1FD8 , 0x81369F36},
{ 0x1FD9 , 0x81369F37},
{ 0x1FDA , 0x81369F38},
{ 0x1FDB , 0x81369F39},
{ 0x1FDC , 0x8136A030},
{ 0x1FDD , 0x8136A031},
{ 0x1FDE , 0x8136A032},
{ 0x1FDF , 0x8136A033},
{ 0x1FE0 , 0x8136A034},
{ 0x1FE1 , 0x8136A035},
{ 0x1FE2 , 0x8136A036},
{ 0x1FE3 , 0x8136A037},
{ 0x1FE4 , 0x8136A038},
{ 0x1FE5 , 0x8136A039},
{ 0x1FE6 , 0x8136A130},
{ 0x1FE7 , 0x8136A131},
{ 0x1FE8 , 0x8136A132},
{ 0x1FE9 , 0x8136A133},
{ 0x1FEA , 0x8136A134},
{ 0x1FEB , 0x8136A135},
{ 0x1FEC , 0x8136A136},
{ 0x1FED , 0x8136A137},
{ 0x1FEE , 0x8136A138},
{ 0x1FEF , 0x8136A139},
{ 0x1FF0 , 0x8136A230},
{ 0x1FF1 , 0x8136A231},
{ 0x1FF2 , 0x8136A232},
{ 0x1FF3 , 0x8136A233},
{ 0x1FF4 , 0x8136A234},
{ 0x1FF5 , 0x8136A235},
{ 0x1FF6 , 0x8136A236},
{ 0x1FF7 , 0x8136A237},
{ 0x1FF8 , 0x8136A238},
{ 0x1FF9 , 0x8136A239},
{ 0x1FFA , 0x8136A330},
{ 0x1FFB , 0x8136A331},
{ 0x1FFC , 0x8136A332},
{ 0x1FFD , 0x8136A333},
{ 0x1FFE , 0x8136A334},
{ 0x1FFF , 0x8136A335},
{ 0x2000 , 0x8136A336},
{ 0x2001 , 0x8136A337},
{ 0x2002 , 0x8136A338},
{ 0x2003 , 0x8136A339},
{ 0x2004 , 0x8136A430},
{ 0x2005 , 0x8136A431},
{ 0x2006 , 0x8136A432},
{ 0x2007 , 0x8136A433},
{ 0x2008 , 0x8136A434},
{ 0x2009 , 0x8136A435},
{ 0x200A , 0x8136A436},
{ 0x200B , 0x8136A437},
{ 0x200C , 0x8136A438},
{ 0x200D , 0x8136A439},
{ 0x200E , 0x8136A530},
{ 0x200F , 0x8136A531},
{ 0x2011 , 0x8136A532},
{ 0x2012 , 0x8136A533},
{ 0x2017 , 0x8136A534},
{ 0x201A , 0x8136A535},
{ 0x201B , 0x8136A536},
{ 0x201E , 0x8136A537},
{ 0x201F , 0x8136A538},
{ 0x2020 , 0x8136A539},
{ 0x2021 , 0x8136A630},
{ 0x2022 , 0x8136A631},
{ 0x2023 , 0x8136A632},
{ 0x2024 , 0x8136A633},
{ 0x2027 , 0x8136A634},
{ 0x2028 , 0x8136A635},
{ 0x2029 , 0x8136A636},
{ 0x202A , 0x8136A637},
{ 0x202B , 0x8136A638},
{ 0x202C , 0x8136A639},
{ 0x202D , 0x8136A730},
{ 0x202E , 0x8136A731},
{ 0x202F , 0x8136A732},
{ 0x2031 , 0x8136A733},
{ 0x2034 , 0x8136A734},
{ 0x2036 , 0x8136A735},
{ 0x2037 , 0x8136A736},
{ 0x2038 , 0x8136A737},
{ 0x2039 , 0x8136A738},
{ 0x203A , 0x8136A739},
{ 0x203C , 0x8136A830},
{ 0x203D , 0x8136A831},
{ 0x203E , 0x8136A832},
{ 0x203F , 0x8136A833},
{ 0x2040 , 0x8136A834},
{ 0x2041 , 0x8136A835},
{ 0x2042 , 0x8136A836},
{ 0x2043 , 0x8136A837},
{ 0x2044 , 0x8136A838},
{ 0x2045 , 0x8136A839},
{ 0x2046 , 0x8136A930},
{ 0x2047 , 0x8136A931},
{ 0x2048 , 0x8136A932},
{ 0x2049 , 0x8136A933},
{ 0x204A , 0x8136A934},
{ 0x204B , 0x8136A935},
{ 0x204C , 0x8136A936},
{ 0x204D , 0x8136A937},
{ 0x204E , 0x8136A938},
{ 0x204F , 0x8136A939},
{ 0x2050 , 0x8136AA30},
{ 0x2051 , 0x8136AA31},
{ 0x2052 , 0x8136AA32},
{ 0x2053 , 0x8136AA33},
{ 0x2054 , 0x8136AA34},
{ 0x2055 , 0x8136AA35},
{ 0x2056 , 0x8136AA36},
{ 0x2057 , 0x8136AA37},
{ 0x2058 , 0x8136AA38},
{ 0x2059 , 0x8136AA39},
{ 0x205A , 0x8136AB30},
{ 0x205B , 0x8136AB31},
{ 0x205C , 0x8136AB32},
{ 0x205D , 0x8136AB33},
{ 0x205E , 0x8136AB34},
{ 0x205F , 0x8136AB35},
{ 0x2060 , 0x8136AB36},
{ 0x2061 , 0x8136AB37},
{ 0x2062 , 0x8136AB38},
{ 0x2063 , 0x8136AB39},
{ 0x2064 , 0x8136AC30},
{ 0x2065 , 0x8136AC31},
{ 0x2066 , 0x8136AC32},
{ 0x2067 , 0x8136AC33},
{ 0x2068 , 0x8136AC34},
{ 0x2069 , 0x8136AC35},
{ 0x206A , 0x8136AC36},
{ 0x206B , 0x8136AC37},
{ 0x206C , 0x8136AC38},
{ 0x206D , 0x8136AC39},
{ 0x206E , 0x8136AD30},
{ 0x206F , 0x8136AD31},
{ 0x2070 , 0x8136AD32},
{ 0x2071 , 0x8136AD33},
{ 0x2072 , 0x8136AD34},
{ 0x2073 , 0x8136AD35},
{ 0x2074 , 0x8136AD36},
{ 0x2075 , 0x8136AD37},
{ 0x2076 , 0x8136AD38},
{ 0x2077 , 0x8136AD39},
{ 0x2078 , 0x8136AE30},
{ 0x2079 , 0x8136AE31},
{ 0x207A , 0x8136AE32},
{ 0x207B , 0x8136AE33},
{ 0x207C , 0x8136AE34},
{ 0x207D , 0x8136AE35},
{ 0x207E , 0x8136AE36},
{ 0x207F , 0x8136AE37},
{ 0x2080 , 0x8136AE38},
{ 0x2081 , 0x8136AE39},
{ 0x2082 , 0x8136AF30},
{ 0x2083 , 0x8136AF31},
{ 0x2084 , 0x8136AF32},
{ 0x2085 , 0x8136AF33},
{ 0x2086 , 0x8136AF34},
{ 0x2087 , 0x8136AF35},
{ 0x2088 , 0x8136AF36},
{ 0x2089 , 0x8136AF37},
{ 0x208A , 0x8136AF38},
{ 0x208B , 0x8136AF39},
{ 0x208C , 0x8136B030},
{ 0x208D , 0x8136B031},
{ 0x208E , 0x8136B032},
{ 0x208F , 0x8136B033},
{ 0x2090 , 0x8136B034},
{ 0x2091 , 0x8136B035},
{ 0x2092 , 0x8136B036},
{ 0x2093 , 0x8136B037},
{ 0x2094 , 0x8136B038},
{ 0x2095 , 0x8136B039},
{ 0x2096 , 0x8136B130},
{ 0x2097 , 0x8136B131},
{ 0x2098 , 0x8136B132},
{ 0x2099 , 0x8136B133},
{ 0x209A , 0x8136B134},
{ 0x209B , 0x8136B135},
{ 0x209C , 0x8136B136},
{ 0x209D , 0x8136B137},
{ 0x209E , 0x8136B138},
{ 0x209F , 0x8136B139},
{ 0x20A0 , 0x8136B230},
{ 0x20A1 , 0x8136B231},
{ 0x20A2 , 0x8136B232},
{ 0x20A3 , 0x8136B233},
{ 0x20A4 , 0x8136B234},
{ 0x20A5 , 0x8136B235},
{ 0x20A6 , 0x8136B236},
{ 0x20A7 , 0x8136B237},
{ 0x20A8 , 0x8136B238},
{ 0x20A9 , 0x8136B239},
{ 0x20AA , 0x8136B330},
{ 0x20AB , 0x8136B331},
{ 0x20AD , 0x8136B332},
{ 0x20AE , 0x8136B333},
{ 0x20AF , 0x8136B334},
{ 0x20B0 , 0x8136B335},
{ 0x20B1 , 0x8136B336},
{ 0x20B2 , 0x8136B337},
{ 0x20B3 , 0x8136B338},
{ 0x20B4 , 0x8136B339},
{ 0x20B5 , 0x8136B430},
{ 0x20B6 , 0x8136B431},
{ 0x20B7 , 0x8136B432},
{ 0x20B8 , 0x8136B433},
{ 0x20B9 , 0x8136B434},
{ 0x20BA , 0x8136B435},
{ 0x20BB , 0x8136B436},
{ 0x20BC , 0x8136B437},
{ 0x20BD , 0x8136B438},
{ 0x20BE , 0x8136B439},
{ 0x20BF , 0x8136B530},
{ 0x20C0 , 0x8136B531},
{ 0x20C1 , 0x8136B532},
{ 0x20C2 , 0x8136B533},
{ 0x20C3 , 0x8136B534},
{ 0x20C4 , 0x8136B535},
{ 0x20C5 , 0x8136B536},
{ 0x20C6 , 0x8136B537},
{ 0x20C7 , 0x8136B538},
{ 0x20C8 , 0x8136B539},
{ 0x20C9 , 0x8136B630},
{ 0x20CA , 0x8136B631},
{ 0x20CB , 0x8136B632},
{ 0x20CC , 0x8136B633},
{ 0x20CD , 0x8136B634},
{ 0x20CE , 0x8136B635},
{ 0x20CF , 0x8136B636},
{ 0x20D0 , 0x8136B637},
{ 0x20D1 , 0x8136B638},
{ 0x20D2 , 0x8136B639},
{ 0x20D3 , 0x8136B730},
{ 0x20D4 , 0x8136B731},
{ 0x20D5 , 0x8136B732},
{ 0x20D6 , 0x8136B733},
{ 0x20D7 , 0x8136B734},
{ 0x20D8 , 0x8136B735},
{ 0x20D9 , 0x8136B736},
{ 0x20DA , 0x8136B737},
{ 0x20DB , 0x8136B738},
{ 0x20DC , 0x8136B739},
{ 0x20DD , 0x8136B830},
{ 0x20DE , 0x8136B831},
{ 0x20DF , 0x8136B832},
{ 0x20E0 , 0x8136B833},
{ 0x20E1 , 0x8136B834},
{ 0x20E2 , 0x8136B835},
{ 0x20E3 , 0x8136B836},
{ 0x20E4 , 0x8136B837},
{ 0x20E5 , 0x8136B838},
{ 0x20E6 , 0x8136B839},
{ 0x20E7 , 0x8136B930},
{ 0x20E8 , 0x8136B931},
{ 0x20E9 , 0x8136B932},
{ 0x20EA , 0x8136B933},
{ 0x20EB , 0x8136B934},
{ 0x20EC , 0x8136B935},
{ 0x20ED , 0x8136B936},
{ 0x20EE , 0x8136B937},
{ 0x20EF , 0x8136B938},
{ 0x20F0 , 0x8136B939},
{ 0x20F1 , 0x8136BA30},
{ 0x20F2 , 0x8136BA31},
{ 0x20F3 , 0x8136BA32},
{ 0x20F4 , 0x8136BA33},
{ 0x20F5 , 0x8136BA34},
{ 0x20F6 , 0x8136BA35},
{ 0x20F7 , 0x8136BA36},
{ 0x20F8 , 0x8136BA37},
{ 0x20F9 , 0x8136BA38},
{ 0x20FA , 0x8136BA39},
{ 0x20FB , 0x8136BB30},
{ 0x20FC , 0x8136BB31},
{ 0x20FD , 0x8136BB32},
{ 0x20FE , 0x8136BB33},
{ 0x20FF , 0x8136BB34},
{ 0x2100 , 0x8136BB35},
{ 0x2101 , 0x8136BB36},
{ 0x2102 , 0x8136BB37},
{ 0x2104 , 0x8136BB38},
{ 0x2106 , 0x8136BB39},
{ 0x2107 , 0x8136BC30},
{ 0x2108 , 0x8136BC31},
{ 0x210A , 0x8136BC32},
{ 0x210B , 0x8136BC33},
{ 0x210C , 0x8136BC34},
{ 0x210D , 0x8136BC35},
{ 0x210E , 0x8136BC36},
{ 0x210F , 0x8136BC37},
{ 0x2110 , 0x8136BC38},
{ 0x2111 , 0x8136BC39},
{ 0x2112 , 0x8136BD30},
{ 0x2113 , 0x8136BD31},
{ 0x2114 , 0x8136BD32},
{ 0x2115 , 0x8136BD33},
{ 0x2117 , 0x8136BD34},
{ 0x2118 , 0x8136BD35},
{ 0x2119 , 0x8136BD36},
{ 0x211A , 0x8136BD37},
{ 0x211B , 0x8136BD38},
{ 0x211C , 0x8136BD39},
{ 0x211D , 0x8136BE30},
{ 0x211E , 0x8136BE31},
{ 0x211F , 0x8136BE32},
{ 0x2120 , 0x8136BE33},
{ 0x2122 , 0x8136BE34},
{ 0x2123 , 0x8136BE35},
{ 0x2124 , 0x8136BE36},
{ 0x2125 , 0x8136BE37},
{ 0x2126 , 0x8136BE38},
{ 0x2127 , 0x8136BE39},
{ 0x2128 , 0x8136BF30},
{ 0x2129 , 0x8136BF31},
{ 0x212A , 0x8136BF32},
{ 0x212B , 0x8136BF33},
{ 0x212C , 0x8136BF34},
{ 0x212D , 0x8136BF35},
{ 0x212E , 0x8136BF36},
{ 0x212F , 0x8136BF37},
{ 0x2130 , 0x8136BF38},
{ 0x2131 , 0x8136BF39},
{ 0x2132 , 0x8136C030},
{ 0x2133 , 0x8136C031},
{ 0x2134 , 0x8136C032},
{ 0x2135 , 0x8136C033},
{ 0x2136 , 0x8136C034},
{ 0x2137 , 0x8136C035},
{ 0x2138 , 0x8136C036},
{ 0x2139 , 0x8136C037},
{ 0x213A , 0x8136C038},
{ 0x213B , 0x8136C039},
{ 0x213C , 0x8136C130},
{ 0x213D , 0x8136C131},
{ 0x213E , 0x8136C132},
{ 0x213F , 0x8136C133},
{ 0x2140 , 0x8136C134},
{ 0x2141 , 0x8136C135},
{ 0x2142 , 0x8136C136},
{ 0x2143 , 0x8136C137},
{ 0x2144 , 0x8136C138},
{ 0x2145 , 0x8136C139},
{ 0x2146 , 0x8136C230},
{ 0x2147 , 0x8136C231},
{ 0x2148 , 0x8136C232},
{ 0x2149 , 0x8136C233},
{ 0x214A , 0x8136C234},
{ 0x214B , 0x8136C235},
{ 0x214C , 0x8136C236},
{ 0x214D , 0x8136C237},
{ 0x214E , 0x8136C238},
{ 0x214F , 0x8136C239},
{ 0x2150 , 0x8136C330},
{ 0x2151 , 0x8136C331},
{ 0x2152 , 0x8136C332},
{ 0x2153 , 0x8136C333},
{ 0x2154 , 0x8136C334},
{ 0x2155 , 0x8136C335},
{ 0x2156 , 0x8136C336},
{ 0x2157 , 0x8136C337},
{ 0x2158 , 0x8136C338},
{ 0x2159 , 0x8136C339},
{ 0x215A , 0x8136C430},
{ 0x215B , 0x8136C431},
{ 0x215C , 0x8136C432},
{ 0x215D , 0x8136C433},
{ 0x215E , 0x8136C434},
{ 0x215F , 0x8136C435},
{ 0x216C , 0x8136C436},
{ 0x216D , 0x8136C437},
{ 0x216E , 0x8136C438},
{ 0x216F , 0x8136C439},
{ 0x217A , 0x8136C530},
{ 0x217B , 0x8136C531},
{ 0x217C , 0x8136C532},
{ 0x217D , 0x8136C533},
{ 0x217E , 0x8136C534},
{ 0x217F , 0x8136C535},
{ 0x2180 , 0x8136C536},
{ 0x2181 , 0x8136C537},
{ 0x2182 , 0x8136C538},
{ 0x2183 , 0x8136C539},
{ 0x2184 , 0x8136C630},
{ 0x2185 , 0x8136C631},
{ 0x2186 , 0x8136C632},
{ 0x2187 , 0x8136C633},
{ 0x2188 , 0x8136C634},
{ 0x2189 , 0x8136C635},
{ 0x218A , 0x8136C636},
{ 0x218B , 0x8136C637},
{ 0x218C , 0x8136C638},
{ 0x218D , 0x8136C639},
{ 0x218E , 0x8136C730},
{ 0x218F , 0x8136C731},
{ 0x2194 , 0x8136C732},
{ 0x2195 , 0x8136C733},
{ 0x219A , 0x8136C734},
{ 0x219B , 0x8136C735},
{ 0x219C , 0x8136C736},
{ 0x219D , 0x8136C737},
{ 0x219E , 0x8136C738},
{ 0x219F , 0x8136C739},
{ 0x21A0 , 0x8136C830},
{ 0x21A1 , 0x8136C831},
{ 0x21A2 , 0x8136C832},
{ 0x21A3 , 0x8136C833},
{ 0x21A4 , 0x8136C834},
{ 0x21A5 , 0x8136C835},
{ 0x21A6 , 0x8136C836},
{ 0x21A7 , 0x8136C837},
{ 0x21A8 , 0x8136C838},
{ 0x21A9 , 0x8136C839},
{ 0x21AA , 0x8136C930},
{ 0x21AB , 0x8136C931},
{ 0x21AC , 0x8136C932},
{ 0x21AD , 0x8136C933},
{ 0x21AE , 0x8136C934},
{ 0x21AF , 0x8136C935},
{ 0x21B0 , 0x8136C936},
{ 0x21B1 , 0x8136C937},
{ 0x21B2 , 0x8136C938},
{ 0x21B3 , 0x8136C939},
{ 0x21B4 , 0x8136CA30},
{ 0x21B5 , 0x8136CA31},
{ 0x21B6 , 0x8136CA32},
{ 0x21B7 , 0x8136CA33},
{ 0x21B8 , 0x8136CA34},
{ 0x21B9 , 0x8136CA35},
{ 0x21BA , 0x8136CA36},
{ 0x21BB , 0x8136CA37},
{ 0x21BC , 0x8136CA38},
{ 0x21BD , 0x8136CA39},
{ 0x21BE , 0x8136CB30},
{ 0x21BF , 0x8136CB31},
{ 0x21C0 , 0x8136CB32},
{ 0x21C1 , 0x8136CB33},
{ 0x21C2 , 0x8136CB34},
{ 0x21C3 , 0x8136CB35},
{ 0x21C4 , 0x8136CB36},
{ 0x21C5 , 0x8136CB37},
{ 0x21C6 , 0x8136CB38},
{ 0x21C7 , 0x8136CB39},
{ 0x21C8 , 0x8136CC30},
{ 0x21C9 , 0x8136CC31},
{ 0x21CA , 0x8136CC32},
{ 0x21CB , 0x8136CC33},
{ 0x21CC , 0x8136CC34},
{ 0x21CD , 0x8136CC35},
{ 0x21CE , 0x8136CC36},
{ 0x21CF , 0x8136CC37},
{ 0x21D0 , 0x8136CC38},
{ 0x21D1 , 0x8136CC39},
{ 0x21D2 , 0x8136CD30},
{ 0x21D3 , 0x8136CD31},
{ 0x21D4 , 0x8136CD32},
{ 0x21D5 , 0x8136CD33},
{ 0x21D6 , 0x8136CD34},
{ 0x21D7 , 0x8136CD35},
{ 0x21D8 , 0x8136CD36},
{ 0x21D9 , 0x8136CD37},
{ 0x21DA , 0x8136CD38},
{ 0x21DB , 0x8136CD39},
{ 0x21DC , 0x8136CE30},
{ 0x21DD , 0x8136CE31},
{ 0x21DE , 0x8136CE32},
{ 0x21DF , 0x8136CE33},
{ 0x21E0 , 0x8136CE34},
{ 0x21E1 , 0x8136CE35},
{ 0x21E2 , 0x8136CE36},
{ 0x21E3 , 0x8136CE37},
{ 0x21E4 , 0x8136CE38},
{ 0x21E5 , 0x8136CE39},
{ 0x21E6 , 0x8136CF30},
{ 0x21E7 , 0x8136CF31},
{ 0x21E8 , 0x8136CF32},
{ 0x21E9 , 0x8136CF33},
{ 0x21EA , 0x8136CF34},
{ 0x21EB , 0x8136CF35},
{ 0x21EC , 0x8136CF36},
{ 0x21ED , 0x8136CF37},
{ 0x21EE , 0x8136CF38},
{ 0x21EF , 0x8136CF39},
{ 0x21F0 , 0x8136D030},
{ 0x21F1 , 0x8136D031},
{ 0x21F2 , 0x8136D032},
{ 0x21F3 , 0x8136D033},
{ 0x21F4 , 0x8136D034},
{ 0x21F5 , 0x8136D035},
{ 0x21F6 , 0x8136D036},
{ 0x21F7 , 0x8136D037},
{ 0x21F8 , 0x8136D038},
{ 0x21F9 , 0x8136D039},
{ 0x21FA , 0x8136D130},
{ 0x21FB , 0x8136D131},
{ 0x21FC , 0x8136D132},
{ 0x21FD , 0x8136D133},
{ 0x21FE , 0x8136D134},
{ 0x21FF , 0x8136D135},
{ 0x2200 , 0x8136D136},
{ 0x2201 , 0x8136D137},
{ 0x2202 , 0x8136D138},
{ 0x2203 , 0x8136D139},
{ 0x2204 , 0x8136D230},
{ 0x2205 , 0x8136D231},
{ 0x2206 , 0x8136D232},
{ 0x2207 , 0x8136D233},
{ 0x2209 , 0x8136D234},
{ 0x220A , 0x8136D235},
{ 0x220B , 0x8136D236},
{ 0x220C , 0x8136D237},
{ 0x220D , 0x8136D238},
{ 0x220E , 0x8136D239},
{ 0x2210 , 0x8136D330},
{ 0x2212 , 0x8136D331},
{ 0x2213 , 0x8136D332},
{ 0x2214 , 0x8136D333},
{ 0x2216 , 0x8136D334},
{ 0x2217 , 0x8136D335},
{ 0x2218 , 0x8136D336},
{ 0x2219 , 0x8136D337},
{ 0x221B , 0x8136D338},
{ 0x221C , 0x8136D339},
{ 0x2221 , 0x8136D430},
{ 0x2222 , 0x8136D431},
{ 0x2224 , 0x8136D432},
{ 0x2226 , 0x8136D433},
{ 0x222C , 0x8136D434},
{ 0x222D , 0x8136D435},
{ 0x222F , 0x8136D436},
{ 0x2230 , 0x8136D437},
{ 0x2231 , 0x8136D438},
{ 0x2232 , 0x8136D439},
{ 0x2233 , 0x8136D530},
{ 0x2238 , 0x8136D531},
{ 0x2239 , 0x8136D532},
{ 0x223A , 0x8136D533},
{ 0x223B , 0x8136D534},
{ 0x223C , 0x8136D535},
{ 0x223E , 0x8136D536},
{ 0x223F , 0x8136D537},
{ 0x2240 , 0x8136D538},
{ 0x2241 , 0x8136D539},
{ 0x2242 , 0x8136D630},
{ 0x2243 , 0x8136D631},
{ 0x2244 , 0x8136D632},
{ 0x2245 , 0x8136D633},
{ 0x2246 , 0x8136D634},
{ 0x2247 , 0x8136D635},
{ 0x2249 , 0x8136D636},
{ 0x224A , 0x8136D637},
{ 0x224B , 0x8136D638},
{ 0x224D , 0x8136D639},
{ 0x224E , 0x8136D730},
{ 0x224F , 0x8136D731},
{ 0x2250 , 0x8136D732},
{ 0x2251 , 0x8136D733},
{ 0x2253 , 0x8136D734},
{ 0x2254 , 0x8136D735},
{ 0x2255 , 0x8136D736},
{ 0x2256 , 0x8136D737},
{ 0x2257 , 0x8136D738},
{ 0x2258 , 0x8136D739},
{ 0x2259 , 0x8136D830},
{ 0x225A , 0x8136D831},
{ 0x225B , 0x8136D832},
{ 0x225C , 0x8136D833},
{ 0x225D , 0x8136D834},
{ 0x225E , 0x8136D835},
{ 0x225F , 0x8136D836},
{ 0x2262 , 0x8136D837},
{ 0x2263 , 0x8136D838},
{ 0x2268 , 0x8136D839},
{ 0x2269 , 0x8136D930},
{ 0x226A , 0x8136D931},
{ 0x226B , 0x8136D932},
{ 0x226C , 0x8136D933},
{ 0x226D , 0x8136D934},
{ 0x2270 , 0x8136D935},
{ 0x2271 , 0x8136D936},
{ 0x2272 , 0x8136D937},
{ 0x2273 , 0x8136D938},
{ 0x2274 , 0x8136D939},
{ 0x2275 , 0x8136DA30},
{ 0x2276 , 0x8136DA31},
{ 0x2277 , 0x8136DA32},
{ 0x2278 , 0x8136DA33},
{ 0x2279 , 0x8136DA34},
{ 0x227A , 0x8136DA35},
{ 0x227B , 0x8136DA36},
{ 0x227C , 0x8136DA37},
{ 0x227D , 0x8136DA38},
{ 0x227E , 0x8136DA39},
{ 0x227F , 0x8136DB30},
{ 0x2280 , 0x8136DB31},
{ 0x2281 , 0x8136DB32},
{ 0x2282 , 0x8136DB33},
{ 0x2283 , 0x8136DB34},
{ 0x2284 , 0x8136DB35},
{ 0x2285 , 0x8136DB36},
{ 0x2286 , 0x8136DB37},
{ 0x2287 , 0x8136DB38},
{ 0x2288 , 0x8136DB39},
{ 0x2289 , 0x8136DC30},
{ 0x228A , 0x8136DC31},
{ 0x228B , 0x8136DC32},
{ 0x228C , 0x8136DC33},
{ 0x228D , 0x8136DC34},
{ 0x228E , 0x8136DC35},
{ 0x228F , 0x8136DC36},
{ 0x2290 , 0x8136DC37},
{ 0x2291 , 0x8136DC38},
{ 0x2292 , 0x8136DC39},
{ 0x2293 , 0x8136DD30},
{ 0x2294 , 0x8136DD31},
{ 0x2296 , 0x8136DD32},
{ 0x2297 , 0x8136DD33},
{ 0x2298 , 0x8136DD34},
{ 0x229A , 0x8136DD35},
{ 0x229B , 0x8136DD36},
{ 0x229C , 0x8136DD37},
{ 0x229D , 0x8136DD38},
{ 0x229E , 0x8136DD39},
{ 0x229F , 0x8136DE30},
{ 0x22A0 , 0x8136DE31},
{ 0x22A1 , 0x8136DE32},
{ 0x22A2 , 0x8136DE33},
{ 0x22A3 , 0x8136DE34},
{ 0x22A4 , 0x8136DE35},
{ 0x22A6 , 0x8136DE36},
{ 0x22A7 , 0x8136DE37},
{ 0x22A8 , 0x8136DE38},
{ 0x22A9 , 0x8136DE39},
{ 0x22AA , 0x8136DF30},
{ 0x22AB , 0x8136DF31},
{ 0x22AC , 0x8136DF32},
{ 0x22AD , 0x8136DF33},
{ 0x22AE , 0x8136DF34},
{ 0x22AF , 0x8136DF35},
{ 0x22B0 , 0x8136DF36},
{ 0x22B1 , 0x8136DF37},
{ 0x22B2 , 0x8136DF38},
{ 0x22B3 , 0x8136DF39},
{ 0x22B4 , 0x8136E030},
{ 0x22B5 , 0x8136E031},
{ 0x22B6 , 0x8136E032},
{ 0x22B7 , 0x8136E033},
{ 0x22B8 , 0x8136E034},
{ 0x22B9 , 0x8136E035},
{ 0x22BA , 0x8136E036},
{ 0x22BB , 0x8136E037},
{ 0x22BC , 0x8136E038},
{ 0x22BD , 0x8136E039},
{ 0x22BE , 0x8136E130},
{ 0x22C0 , 0x8136E131},
{ 0x22C1 , 0x8136E132},
{ 0x22C2 , 0x8136E133},
{ 0x22C3 , 0x8136E134},
{ 0x22C4 , 0x8136E135},
{ 0x22C5 , 0x8136E136},
{ 0x22C6 , 0x8136E137},
{ 0x22C7 , 0x8136E138},
{ 0x22C8 , 0x8136E139},
{ 0x22C9 , 0x8136E230},
{ 0x22CA , 0x8136E231},
{ 0x22CB , 0x8136E232},
{ 0x22CC , 0x8136E233},
{ 0x22CD , 0x8136E234},
{ 0x22CE , 0x8136E235},
{ 0x22CF , 0x8136E236},
{ 0x22D0 , 0x8136E237},
{ 0x22D1 , 0x8136E238},
{ 0x22D2 , 0x8136E239},
{ 0x22D3 , 0x8136E330},
{ 0x22D4 , 0x8136E331},
{ 0x22D5 , 0x8136E332},
{ 0x22D6 , 0x8136E333},
{ 0x22D7 , 0x8136E334},
{ 0x22D8 , 0x8136E335},
{ 0x22D9 , 0x8136E336},
{ 0x22DA , 0x8136E337},
{ 0x22DB , 0x8136E338},
{ 0x22DC , 0x8136E339},
{ 0x22DD , 0x8136E430},
{ 0x22DE , 0x8136E431},
{ 0x22DF , 0x8136E432},
{ 0x22E0 , 0x8136E433},
{ 0x22E1 , 0x8136E434},
{ 0x22E2 , 0x8136E435},
{ 0x22E3 , 0x8136E436},
{ 0x22E4 , 0x8136E437},
{ 0x22E5 , 0x8136E438},
{ 0x22E6 , 0x8136E439},
{ 0x22E7 , 0x8136E530},
{ 0x22E8 , 0x8136E531},
{ 0x22E9 , 0x8136E532},
{ 0x22EA , 0x8136E533},
{ 0x22EB , 0x8136E534},
{ 0x22EC , 0x8136E535},
{ 0x22ED , 0x8136E536},
{ 0x22EE , 0x8136E537},
{ 0x22EF , 0x8136E538},
{ 0x22F0 , 0x8136E539},
{ 0x22F1 , 0x8136E630},
{ 0x22F2 , 0x8136E631},
{ 0x22F3 , 0x8136E632},
{ 0x22F4 , 0x8136E633},
{ 0x22F5 , 0x8136E634},
{ 0x22F6 , 0x8136E635},
{ 0x22F7 , 0x8136E636},
{ 0x22F8 , 0x8136E637},
{ 0x22F9 , 0x8136E638},
{ 0x22FA , 0x8136E639},
{ 0x22FB , 0x8136E730},
{ 0x22FC , 0x8136E731},
{ 0x22FD , 0x8136E732},
{ 0x22FE , 0x8136E733},
{ 0x22FF , 0x8136E734},
{ 0x2300 , 0x8136E735},
{ 0x2301 , 0x8136E736},
{ 0x2302 , 0x8136E737},
{ 0x2303 , 0x8136E738},
{ 0x2304 , 0x8136E739},
{ 0x2305 , 0x8136E830},
{ 0x2306 , 0x8136E831},
{ 0x2307 , 0x8136E832},
{ 0x2308 , 0x8136E833},
{ 0x2309 , 0x8136E834},
{ 0x230A , 0x8136E835},
{ 0x230B , 0x8136E836},
{ 0x230C , 0x8136E837},
{ 0x230D , 0x8136E838},
{ 0x230E , 0x8136E839},
{ 0x230F , 0x8136E930},
{ 0x2310 , 0x8136E931},
{ 0x2311 , 0x8136E932},
{ 0x2313 , 0x8136E933},
{ 0x2314 , 0x8136E934},
{ 0x2315 , 0x8136E935},
{ 0x2316 , 0x8136E936},
{ 0x2317 , 0x8136E937},
{ 0x2318 , 0x8136E938},
{ 0x2319 , 0x8136E939},
{ 0x231A , 0x8136EA30},
{ 0x231B , 0x8136EA31},
{ 0x231C , 0x8136EA32},
{ 0x231D , 0x8136EA33},
{ 0x231E , 0x8136EA34},
{ 0x231F , 0x8136EA35},
{ 0x2320 , 0x8136EA36},
{ 0x2321 , 0x8136EA37},
{ 0x2322 , 0x8136EA38},
{ 0x2323 , 0x8136EA39},
{ 0x2324 , 0x8136EB30},
{ 0x2325 , 0x8136EB31},
{ 0x2326 , 0x8136EB32},
{ 0x2327 , 0x8136EB33},
{ 0x2328 , 0x8136EB34},
{ 0x2329 , 0x8136EB35},
{ 0x232A , 0x8136EB36},
{ 0x232B , 0x8136EB37},
{ 0x232C , 0x8136EB38},
{ 0x232D , 0x8136EB39},
{ 0x232E , 0x8136EC30},
{ 0x232F , 0x8136EC31},
{ 0x2330 , 0x8136EC32},
{ 0x2331 , 0x8136EC33},
{ 0x2332 , 0x8136EC34},
{ 0x2333 , 0x8136EC35},
{ 0x2334 , 0x8136EC36},
{ 0x2335 , 0x8136EC37},
{ 0x2336 , 0x8136EC38},
{ 0x2337 , 0x8136EC39},
{ 0x2338 , 0x8136ED30},
{ 0x2339 , 0x8136ED31},
{ 0x233A , 0x8136ED32},
{ 0x233B , 0x8136ED33},
{ 0x233C , 0x8136ED34},
{ 0x233D , 0x8136ED35},
{ 0x233E , 0x8136ED36},
{ 0x233F , 0x8136ED37},
{ 0x2340 , 0x8136ED38},
{ 0x2341 , 0x8136ED39},
{ 0x2342 , 0x8136EE30},
{ 0x2343 , 0x8136EE31},
{ 0x2344 , 0x8136EE32},
{ 0x2345 , 0x8136EE33},
{ 0x2346 , 0x8136EE34},
{ 0x2347 , 0x8136EE35},
{ 0x2348 , 0x8136EE36},
{ 0x2349 , 0x8136EE37},
{ 0x234A , 0x8136EE38},
{ 0x234B , 0x8136EE39},
{ 0x234C , 0x8136EF30},
{ 0x234D , 0x8136EF31},
{ 0x234E , 0x8136EF32},
{ 0x234F , 0x8136EF33},
{ 0x2350 , 0x8136EF34},
{ 0x2351 , 0x8136EF35},
{ 0x2352 , 0x8136EF36},
{ 0x2353 , 0x8136EF37},
{ 0x2354 , 0x8136EF38},
{ 0x2355 , 0x8136EF39},
{ 0x2356 , 0x8136F030},
{ 0x2357 , 0x8136F031},
{ 0x2358 , 0x8136F032},
{ 0x2359 , 0x8136F033},
{ 0x235A , 0x8136F034},
{ 0x235B , 0x8136F035},
{ 0x235C , 0x8136F036},
{ 0x235D , 0x8136F037},
{ 0x235E , 0x8136F038},
{ 0x235F , 0x8136F039},
{ 0x2360 , 0x8136F130},
{ 0x2361 , 0x8136F131},
{ 0x2362 , 0x8136F132},
{ 0x2363 , 0x8136F133},
{ 0x2364 , 0x8136F134},
{ 0x2365 , 0x8136F135},
{ 0x2366 , 0x8136F136},
{ 0x2367 , 0x8136F137},
{ 0x2368 , 0x8136F138},
{ 0x2369 , 0x8136F139},
{ 0x236A , 0x8136F230},
{ 0x236B , 0x8136F231},
{ 0x236C , 0x8136F232},
{ 0x236D , 0x8136F233},
{ 0x236E , 0x8136F234},
{ 0x236F , 0x8136F235},
{ 0x2370 , 0x8136F236},
{ 0x2371 , 0x8136F237},
{ 0x2372 , 0x8136F238},
{ 0x2373 , 0x8136F239},
{ 0x2374 , 0x8136F330},
{ 0x2375 , 0x8136F331},
{ 0x2376 , 0x8136F332},
{ 0x2377 , 0x8136F333},
{ 0x2378 , 0x8136F334},
{ 0x2379 , 0x8136F335},
{ 0x237A , 0x8136F336},
{ 0x237B , 0x8136F337},
{ 0x237C , 0x8136F338},
{ 0x237D , 0x8136F339},
{ 0x237E , 0x8136F430},
{ 0x237F , 0x8136F431},
{ 0x2380 , 0x8136F432},
{ 0x2381 , 0x8136F433},
{ 0x2382 , 0x8136F434},
{ 0x2383 , 0x8136F435},
{ 0x2384 , 0x8136F436},
{ 0x2385 , 0x8136F437},
{ 0x2386 , 0x8136F438},
{ 0x2387 , 0x8136F439},
{ 0x2388 , 0x8136F530},
{ 0x2389 , 0x8136F531},
{ 0x238A , 0x8136F532},
{ 0x238B , 0x8136F533},
{ 0x238C , 0x8136F534},
{ 0x238D , 0x8136F535},
{ 0x238E , 0x8136F536},
{ 0x238F , 0x8136F537},
{ 0x2390 , 0x8136F538},
{ 0x2391 , 0x8136F539},
{ 0x2392 , 0x8136F630},
{ 0x2393 , 0x8136F631},
{ 0x2394 , 0x8136F632},
{ 0x2395 , 0x8136F633},
{ 0x2396 , 0x8136F634},
{ 0x2397 , 0x8136F635},
{ 0x2398 , 0x8136F636},
{ 0x2399 , 0x8136F637},
{ 0x239A , 0x8136F638},
{ 0x239B , 0x8136F639},
{ 0x239C , 0x8136F730},
{ 0x239D , 0x8136F731},
{ 0x239E , 0x8136F732},
{ 0x239F , 0x8136F733},
{ 0x23A0 , 0x8136F734},
{ 0x23A1 , 0x8136F735},
{ 0x23A2 , 0x8136F736},
{ 0x23A3 , 0x8136F737},
{ 0x23A4 , 0x8136F738},
{ 0x23A5 , 0x8136F739},
{ 0x23A6 , 0x8136F830},
{ 0x23A7 , 0x8136F831},
{ 0x23A8 , 0x8136F832},
{ 0x23A9 , 0x8136F833},
{ 0x23AA , 0x8136F834},
{ 0x23AB , 0x8136F835},
{ 0x23AC , 0x8136F836},
{ 0x23AD , 0x8136F837},
{ 0x23AE , 0x8136F838},
{ 0x23AF , 0x8136F839},
{ 0x23B0 , 0x8136F930},
{ 0x23B1 , 0x8136F931},
{ 0x23B2 , 0x8136F932},
{ 0x23B3 , 0x8136F933},
{ 0x23B4 , 0x8136F934},
{ 0x23B5 , 0x8136F935},
{ 0x23B6 , 0x8136F936},
{ 0x23B7 , 0x8136F937},
{ 0x23B8 , 0x8136F938},
{ 0x23B9 , 0x8136F939},
{ 0x23BA , 0x8136FA30},
{ 0x23BB , 0x8136FA31},
{ 0x23BC , 0x8136FA32},
{ 0x23BD , 0x8136FA33},
{ 0x23BE , 0x8136FA34},
{ 0x23BF , 0x8136FA35},
{ 0x23C0 , 0x8136FA36},
{ 0x23C1 , 0x8136FA37},
{ 0x23C2 , 0x8136FA38},
{ 0x23C3 , 0x8136FA39},
{ 0x23C4 , 0x8136FB30},
{ 0x23C5 , 0x8136FB31},
{ 0x23C6 , 0x8136FB32},
{ 0x23C7 , 0x8136FB33},
{ 0x23C8 , 0x8136FB34},
{ 0x23C9 , 0x8136FB35},
{ 0x23CA , 0x8136FB36},
{ 0x23CB , 0x8136FB37},
{ 0x23CC , 0x8136FB38},
{ 0x23CD , 0x8136FB39},
{ 0x23CE , 0x8136FC30},
{ 0x23CF , 0x8136FC31},
{ 0x23D0 , 0x8136FC32},
{ 0x23D1 , 0x8136FC33},
{ 0x23D2 , 0x8136FC34},
{ 0x23D3 , 0x8136FC35},
{ 0x23D4 , 0x8136FC36},
{ 0x23D5 , 0x8136FC37},
{ 0x23D6 , 0x8136FC38},
{ 0x23D7 , 0x8136FC39},
{ 0x23D8 , 0x8136FD30},
{ 0x23D9 , 0x8136FD31},
{ 0x23DA , 0x8136FD32},
{ 0x23DB , 0x8136FD33},
{ 0x23DC , 0x8136FD34},
{ 0x23DD , 0x8136FD35},
{ 0x23DE , 0x8136FD36},
{ 0x23DF , 0x8136FD37},
{ 0x23E0 , 0x8136FD38},
{ 0x23E1 , 0x8136FD39},
{ 0x23E2 , 0x8136FE30},
{ 0x23E3 , 0x8136FE31},
{ 0x23E4 , 0x8136FE32},
{ 0x23E5 , 0x8136FE33},
{ 0x23E6 , 0x8136FE34},
{ 0x23E7 , 0x8136FE35},
{ 0x23E8 , 0x8136FE36},
{ 0x23E9 , 0x8136FE37},
{ 0x23EA , 0x8136FE38},
{ 0x23EB , 0x8136FE39},
{ 0x23EC , 0x81378130},
{ 0x23ED , 0x81378131},
{ 0x23EE , 0x81378132},
{ 0x23EF , 0x81378133},
{ 0x23F0 , 0x81378134},
{ 0x23F1 , 0x81378135},
{ 0x23F2 , 0x81378136},
{ 0x23F3 , 0x81378137},
{ 0x23F4 , 0x81378138},
{ 0x23F5 , 0x81378139},
{ 0x23F6 , 0x81378230},
{ 0x23F7 , 0x81378231},
{ 0x23F8 , 0x81378232},
{ 0x23F9 , 0x81378233},
{ 0x23FA , 0x81378234},
{ 0x23FB , 0x81378235},
{ 0x23FC , 0x81378236},
{ 0x23FD , 0x81378237},
{ 0x23FE , 0x81378238},
{ 0x23FF , 0x81378239},
{ 0x2400 , 0x81378330},
{ 0x2401 , 0x81378331},
{ 0x2402 , 0x81378332},
{ 0x2403 , 0x81378333},
{ 0x2404 , 0x81378334},
{ 0x2405 , 0x81378335},
{ 0x2406 , 0x81378336},
{ 0x2407 , 0x81378337},
{ 0x2408 , 0x81378338},
{ 0x2409 , 0x81378339},
{ 0x240A , 0x81378430},
{ 0x240B , 0x81378431},
{ 0x240C , 0x81378432},
{ 0x240D , 0x81378433},
{ 0x240E , 0x81378434},
{ 0x240F , 0x81378435},
{ 0x2410 , 0x81378436},
{ 0x2411 , 0x81378437},
{ 0x2412 , 0x81378438},
{ 0x2413 , 0x81378439},
{ 0x2414 , 0x81378530},
{ 0x2415 , 0x81378531},
{ 0x2416 , 0x81378532},
{ 0x2417 , 0x81378533},
{ 0x2418 , 0x81378534},
{ 0x2419 , 0x81378535},
{ 0x241A , 0x81378536},
{ 0x241B , 0x81378537},
{ 0x241C , 0x81378538},
{ 0x241D , 0x81378539},
{ 0x241E , 0x81378630},
{ 0x241F , 0x81378631},
{ 0x2420 , 0x81378632},
{ 0x2421 , 0x81378633},
{ 0x2422 , 0x81378634},
{ 0x2423 , 0x81378635},
{ 0x2424 , 0x81378636},
{ 0x2425 , 0x81378637},
{ 0x2426 , 0x81378638},
{ 0x2427 , 0x81378639},
{ 0x2428 , 0x81378730},
{ 0x2429 , 0x81378731},
{ 0x242A , 0x81378732},
{ 0x242B , 0x81378733},
{ 0x242C , 0x81378734},
{ 0x242D , 0x81378735},
{ 0x242E , 0x81378736},
{ 0x242F , 0x81378737},
{ 0x2430 , 0x81378738},
{ 0x2431 , 0x81378739},
{ 0x2432 , 0x81378830},
{ 0x2433 , 0x81378831},
{ 0x2434 , 0x81378832},
{ 0x2435 , 0x81378833},
{ 0x2436 , 0x81378834},
{ 0x2437 , 0x81378835},
{ 0x2438 , 0x81378836},
{ 0x2439 , 0x81378837},
{ 0x243A , 0x81378838},
{ 0x243B , 0x81378839},
{ 0x243C , 0x81378930},
{ 0x243D , 0x81378931},
{ 0x243E , 0x81378932},
{ 0x243F , 0x81378933},
{ 0x2440 , 0x81378934},
{ 0x2441 , 0x81378935},
{ 0x2442 , 0x81378936},
{ 0x2443 , 0x81378937},
{ 0x2444 , 0x81378938},
{ 0x2445 , 0x81378939},
{ 0x2446 , 0x81378A30},
{ 0x2447 , 0x81378A31},
{ 0x2448 , 0x81378A32},
{ 0x2449 , 0x81378A33},
{ 0x244A , 0x81378A34},
{ 0x244B , 0x81378A35},
{ 0x244C , 0x81378A36},
{ 0x244D , 0x81378A37},
{ 0x244E , 0x81378A38},
{ 0x244F , 0x81378A39},
{ 0x2450 , 0x81378B30},
{ 0x2451 , 0x81378B31},
{ 0x2452 , 0x81378B32},
{ 0x2453 , 0x81378B33},
{ 0x2454 , 0x81378B34},
{ 0x2455 , 0x81378B35},
{ 0x2456 , 0x81378B36},
{ 0x2457 , 0x81378B37},
{ 0x2458 , 0x81378B38},
{ 0x2459 , 0x81378B39},
{ 0x245A , 0x81378C30},
{ 0x245B , 0x81378C31},
{ 0x245C , 0x81378C32},
{ 0x245D , 0x81378C33},
{ 0x245E , 0x81378C34},
{ 0x245F , 0x81378C35},
{ 0x246A , 0x81378C36},
{ 0x246B , 0x81378C37},
{ 0x246C , 0x81378C38},
{ 0x246D , 0x81378C39},
{ 0x246E , 0x81378D30},
{ 0x246F , 0x81378D31},
{ 0x2470 , 0x81378D32},
{ 0x2471 , 0x81378D33},
{ 0x2472 , 0x81378D34},
{ 0x2473 , 0x81378D35},
{ 0x249C , 0x81378D36},
{ 0x249D , 0x81378D37},
{ 0x249E , 0x81378D38},
{ 0x249F , 0x81378D39},
{ 0x24A0 , 0x81378E30},
{ 0x24A1 , 0x81378E31},
{ 0x24A2 , 0x81378E32},
{ 0x24A3 , 0x81378E33},
{ 0x24A4 , 0x81378E34},
{ 0x24A5 , 0x81378E35},
{ 0x24A6 , 0x81378E36},
{ 0x24A7 , 0x81378E37},
{ 0x24A8 , 0x81378E38},
{ 0x24A9 , 0x81378E39},
{ 0x24AA , 0x81378F30},
{ 0x24AB , 0x81378F31},
{ 0x24AC , 0x81378F32},
{ 0x24AD , 0x81378F33},
{ 0x24AE , 0x81378F34},
{ 0x24AF , 0x81378F35},
{ 0x24B0 , 0x81378F36},
{ 0x24B1 , 0x81378F37},
{ 0x24B2 , 0x81378F38},
{ 0x24B3 , 0x81378F39},
{ 0x24B4 , 0x81379030},
{ 0x24B5 , 0x81379031},
{ 0x24B6 , 0x81379032},
{ 0x24B7 , 0x81379033},
{ 0x24B8 , 0x81379034},
{ 0x24B9 , 0x81379035},
{ 0x24BA , 0x81379036},
{ 0x24BB , 0x81379037},
{ 0x24BC , 0x81379038},
{ 0x24BD , 0x81379039},
{ 0x24BE , 0x81379130},
{ 0x24BF , 0x81379131},
{ 0x24C0 , 0x81379132},
{ 0x24C1 , 0x81379133},
{ 0x24C2 , 0x81379134},
{ 0x24C3 , 0x81379135},
{ 0x24C4 , 0x81379136},
{ 0x24C5 , 0x81379137},
{ 0x24C6 , 0x81379138},
{ 0x24C7 , 0x81379139},
{ 0x24C8 , 0x81379230},
{ 0x24C9 , 0x81379231},
{ 0x24CA , 0x81379232},
{ 0x24CB , 0x81379233},
{ 0x24CC , 0x81379234},
{ 0x24CD , 0x81379235},
{ 0x24CE , 0x81379236},
{ 0x24CF , 0x81379237},
{ 0x24D0 , 0x81379238},
{ 0x24D1 , 0x81379239},
{ 0x24D2 , 0x81379330},
{ 0x24D3 , 0x81379331},
{ 0x24D4 , 0x81379332},
{ 0x24D5 , 0x81379333},
{ 0x24D6 , 0x81379334},
{ 0x24D7 , 0x81379335},
{ 0x24D8 , 0x81379336},
{ 0x24D9 , 0x81379337},
{ 0x24DA , 0x81379338},
{ 0x24DB , 0x81379339},
{ 0x24DC , 0x81379430},
{ 0x24DD , 0x81379431},
{ 0x24DE , 0x81379432},
{ 0x24DF , 0x81379433},
{ 0x24E0 , 0x81379434},
{ 0x24E1 , 0x81379435},
{ 0x24E2 , 0x81379436},
{ 0x24E3 , 0x81379437},
{ 0x24E4 , 0x81379438},
{ 0x24E5 , 0x81379439},
{ 0x24E6 , 0x81379530},
{ 0x24E7 , 0x81379531},
{ 0x24E8 , 0x81379532},
{ 0x24E9 , 0x81379533},
{ 0x24EA , 0x81379534},
{ 0x24EB , 0x81379535},
{ 0x24EC , 0x81379536},
{ 0x24ED , 0x81379537},
{ 0x24EE , 0x81379538},
{ 0x24EF , 0x81379539},
{ 0x24F0 , 0x81379630},
{ 0x24F1 , 0x81379631},
{ 0x24F2 , 0x81379632},
{ 0x24F3 , 0x81379633},
{ 0x24F4 , 0x81379634},
{ 0x24F5 , 0x81379635},
{ 0x24F6 , 0x81379636},
{ 0x24F7 , 0x81379637},
{ 0x24F8 , 0x81379638},
{ 0x24F9 , 0x81379639},
{ 0x24FA , 0x81379730},
{ 0x24FB , 0x81379731},
{ 0x24FC , 0x81379732},
{ 0x24FD , 0x81379733},
{ 0x24FE , 0x81379734},
{ 0x24FF , 0x81379735},
{ 0x254C , 0x81379736},
{ 0x254D , 0x81379737},
{ 0x254E , 0x81379738},
{ 0x254F , 0x81379739},
{ 0x2574 , 0x81379830},
{ 0x2575 , 0x81379831},
{ 0x2576 , 0x81379832},
{ 0x2577 , 0x81379833},
{ 0x2578 , 0x81379834},
{ 0x2579 , 0x81379835},
{ 0x257A , 0x81379836},
{ 0x257B , 0x81379837},
{ 0x257C , 0x81379838},
{ 0x257D , 0x81379839},
{ 0x257E , 0x81379930},
{ 0x257F , 0x81379931},
{ 0x2580 , 0x81379932},
{ 0x2590 , 0x81379933},
{ 0x2591 , 0x81379934},
{ 0x2592 , 0x81379935},
{ 0x2596 , 0x81379936},
{ 0x2597 , 0x81379937},
{ 0x2598 , 0x81379938},
{ 0x2599 , 0x81379939},
{ 0x259A , 0x81379A30},
{ 0x259B , 0x81379A31},
{ 0x259C , 0x81379A32},
{ 0x259D , 0x81379A33},
{ 0x259E , 0x81379A34},
{ 0x259F , 0x81379A35},
{ 0x25A2 , 0x81379A36},
{ 0x25A3 , 0x81379A37},
{ 0x25A4 , 0x81379A38},
{ 0x25A5 , 0x81379A39},
{ 0x25A6 , 0x81379B30},
{ 0x25A7 , 0x81379B31},
{ 0x25A8 , 0x81379B32},
{ 0x25A9 , 0x81379B33},
{ 0x25AA , 0x81379B34},
{ 0x25AB , 0x81379B35},
{ 0x25AC , 0x81379B36},
{ 0x25AD , 0x81379B37},
{ 0x25AE , 0x81379B38},
{ 0x25AF , 0x81379B39},
{ 0x25B0 , 0x81379C30},
{ 0x25B1 , 0x81379C31},
{ 0x25B4 , 0x81379C32},
{ 0x25B5 , 0x81379C33},
{ 0x25B6 , 0x81379C34},
{ 0x25B7 , 0x81379C35},
{ 0x25B8 , 0x81379C36},
{ 0x25B9 , 0x81379C37},
{ 0x25BA , 0x81379C38},
{ 0x25BB , 0x81379C39},
{ 0x25BE , 0x81379D30},
{ 0x25BF , 0x81379D31},
{ 0x25C0 , 0x81379D32},
{ 0x25C1 , 0x81379D33},
{ 0x25C2 , 0x81379D34},
{ 0x25C3 , 0x81379D35},
{ 0x25C4 , 0x81379D36},
{ 0x25C5 , 0x81379D37},
{ 0x25C8 , 0x81379D38},
{ 0x25C9 , 0x81379D39},
{ 0x25CA , 0x81379E30},
{ 0x25CC , 0x81379E31},
{ 0x25CD , 0x81379E32},
{ 0x25D0 , 0x81379E33},
{ 0x25D1 , 0x81379E34},
{ 0x25D2 , 0x81379E35},
{ 0x25D3 , 0x81379E36},
{ 0x25D4 , 0x81379E37},
{ 0x25D5 , 0x81379E38},
{ 0x25D6 , 0x81379E39},
{ 0x25D7 , 0x81379F30},
{ 0x25D8 , 0x81379F31},
{ 0x25D9 , 0x81379F32},
{ 0x25DA , 0x81379F33},
{ 0x25DB , 0x81379F34},
{ 0x25DC , 0x81379F35},
{ 0x25DD , 0x81379F36},
{ 0x25DE , 0x81379F37},
{ 0x25DF , 0x81379F38},
{ 0x25E0 , 0x81379F39},
{ 0x25E1 , 0x8137A030},
{ 0x25E6 , 0x8137A031},
{ 0x25E7 , 0x8137A032},
{ 0x25E8 , 0x8137A033},
{ 0x25E9 , 0x8137A034},
{ 0x25EA , 0x8137A035},
{ 0x25EB , 0x8137A036},
{ 0x25EC , 0x8137A037},
{ 0x25ED , 0x8137A038},
{ 0x25EE , 0x8137A039},
{ 0x25EF , 0x8137A130},
{ 0x25F0 , 0x8137A131},
{ 0x25F1 , 0x8137A132},
{ 0x25F2 , 0x8137A133},
{ 0x25F3 , 0x8137A134},
{ 0x25F4 , 0x8137A135},
{ 0x25F5 , 0x8137A136},
{ 0x25F6 , 0x8137A137},
{ 0x25F7 , 0x8137A138},
{ 0x25F8 , 0x8137A139},
{ 0x25F9 , 0x8137A230},
{ 0x25FA , 0x8137A231},
{ 0x25FB , 0x8137A232},
{ 0x25FC , 0x8137A233},
{ 0x25FD , 0x8137A234},
{ 0x25FE , 0x8137A235},
{ 0x25FF , 0x8137A236},
{ 0x2600 , 0x8137A237},
{ 0x2601 , 0x8137A238},
{ 0x2602 , 0x8137A239},
{ 0x2603 , 0x8137A330},
{ 0x2604 , 0x8137A331},
{ 0x2607 , 0x8137A332},
{ 0x2608 , 0x8137A333},
{ 0x260A , 0x8137A334},
{ 0x260B , 0x8137A335},
{ 0x260C , 0x8137A336},
{ 0x260D , 0x8137A337},
{ 0x260E , 0x8137A338},
{ 0x260F , 0x8137A339},
{ 0x2610 , 0x8137A430},
{ 0x2611 , 0x8137A431},
{ 0x2612 , 0x8137A432},
{ 0x2613 , 0x8137A433},
{ 0x2614 , 0x8137A434},
{ 0x2615 , 0x8137A435},
{ 0x2616 , 0x8137A436},
{ 0x2617 , 0x8137A437},
{ 0x2618 , 0x8137A438},
{ 0x2619 , 0x8137A439},
{ 0x261A , 0x8137A530},
{ 0x261B , 0x8137A531},
{ 0x261C , 0x8137A532},
{ 0x261D , 0x8137A533},
{ 0x261E , 0x8137A534},
{ 0x261F , 0x8137A535},
{ 0x2620 , 0x8137A536},
{ 0x2621 , 0x8137A537},
{ 0x2622 , 0x8137A538},
{ 0x2623 , 0x8137A539},
{ 0x2624 , 0x8137A630},
{ 0x2625 , 0x8137A631},
{ 0x2626 , 0x8137A632},
{ 0x2627 , 0x8137A633},
{ 0x2628 , 0x8137A634},
{ 0x2629 , 0x8137A635},
{ 0x262A , 0x8137A636},
{ 0x262B , 0x8137A637},
{ 0x262C , 0x8137A638},
{ 0x262D , 0x8137A639},
{ 0x262E , 0x8137A730},
{ 0x262F , 0x8137A731},
{ 0x2630 , 0x8137A732},
{ 0x2631 , 0x8137A733},
{ 0x2632 , 0x8137A734},
{ 0x2633 , 0x8137A735},
{ 0x2634 , 0x8137A736},
{ 0x2635 , 0x8137A737},
{ 0x2636 , 0x8137A738},
{ 0x2637 , 0x8137A739},
{ 0x2638 , 0x8137A830},
{ 0x2639 , 0x8137A831},
{ 0x263A , 0x8137A832},
{ 0x263B , 0x8137A833},
{ 0x263C , 0x8137A834},
{ 0x263D , 0x8137A835},
{ 0x263E , 0x8137A836},
{ 0x263F , 0x8137A837},
{ 0x2641 , 0x8137A838},
{ 0x2643 , 0x8137A839},
{ 0x2644 , 0x8137A930},
{ 0x2645 , 0x8137A931},
{ 0x2646 , 0x8137A932},
{ 0x2647 , 0x8137A933},
{ 0x2648 , 0x8137A934},
{ 0x2649 , 0x8137A935},
{ 0x264A , 0x8137A936},
{ 0x264B , 0x8137A937},
{ 0x264C , 0x8137A938},
{ 0x264D , 0x8137A939},
{ 0x264E , 0x8137AA30},
{ 0x264F , 0x8137AA31},
{ 0x2650 , 0x8137AA32},
{ 0x2651 , 0x8137AA33},
{ 0x2652 , 0x8137AA34},
{ 0x2653 , 0x8137AA35},
{ 0x2654 , 0x8137AA36},
{ 0x2655 , 0x8137AA37},
{ 0x2656 , 0x8137AA38},
{ 0x2657 , 0x8137AA39},
{ 0x2658 , 0x8137AB30},
{ 0x2659 , 0x8137AB31},
{ 0x265A , 0x8137AB32},
{ 0x265B , 0x8137AB33},
{ 0x265C , 0x8137AB34},
{ 0x265D , 0x8137AB35},
{ 0x265E , 0x8137AB36},
{ 0x265F , 0x8137AB37},
{ 0x2660 , 0x8137AB38},
{ 0x2661 , 0x8137AB39},
{ 0x2662 , 0x8137AC30},
{ 0x2663 , 0x8137AC31},
{ 0x2664 , 0x8137AC32},
{ 0x2665 , 0x8137AC33},
{ 0x2666 , 0x8137AC34},
{ 0x2667 , 0x8137AC35},
{ 0x2668 , 0x8137AC36},
{ 0x2669 , 0x8137AC37},
{ 0x266A , 0x8137AC38},
{ 0x266B , 0x8137AC39},
{ 0x266C , 0x8137AD30},
{ 0x266D , 0x8137AD31},
{ 0x266E , 0x8137AD32},
{ 0x266F , 0x8137AD33},
{ 0x2670 , 0x8137AD34},
{ 0x2671 , 0x8137AD35},
{ 0x2672 , 0x8137AD36},
{ 0x2673 , 0x8137AD37},
{ 0x2674 , 0x8137AD38},
{ 0x2675 , 0x8137AD39},
{ 0x2676 , 0x8137AE30},
{ 0x2677 , 0x8137AE31},
{ 0x2678 , 0x8137AE32},
{ 0x2679 , 0x8137AE33},
{ 0x267A , 0x8137AE34},
{ 0x267B , 0x8137AE35},
{ 0x267C , 0x8137AE36},
{ 0x267D , 0x8137AE37},
{ 0x267E , 0x8137AE38},
{ 0x267F , 0x8137AE39},
{ 0x2680 , 0x8137AF30},
{ 0x2681 , 0x8137AF31},
{ 0x2682 , 0x8137AF32},
{ 0x2683 , 0x8137AF33},
{ 0x2684 , 0x8137AF34},
{ 0x2685 , 0x8137AF35},
{ 0x2686 , 0x8137AF36},
{ 0x2687 , 0x8137AF37},
{ 0x2688 , 0x8137AF38},
{ 0x2689 , 0x8137AF39},
{ 0x268A , 0x8137B030},
{ 0x268B , 0x8137B031},
{ 0x268C , 0x8137B032},
{ 0x268D , 0x8137B033},
{ 0x268E , 0x8137B034},
{ 0x268F , 0x8137B035},
{ 0x2690 , 0x8137B036},
{ 0x2691 , 0x8137B037},
{ 0x2692 , 0x8137B038},
{ 0x2693 , 0x8137B039},
{ 0x2694 , 0x8137B130},
{ 0x2695 , 0x8137B131},
{ 0x2696 , 0x8137B132},
{ 0x2697 , 0x8137B133},
{ 0x2698 , 0x8137B134},
{ 0x2699 , 0x8137B135},
{ 0x269A , 0x8137B136},
{ 0x269B , 0x8137B137},
{ 0x269C , 0x8137B138},
{ 0x269D , 0x8137B139},
{ 0x269E , 0x8137B230},
{ 0x269F , 0x8137B231},
{ 0x26A0 , 0x8137B232},
{ 0x26A1 , 0x8137B233},
{ 0x26A2 , 0x8137B234},
{ 0x26A3 , 0x8137B235},
{ 0x26A4 , 0x8137B236},
{ 0x26A5 , 0x8137B237},
{ 0x26A6 , 0x8137B238},
{ 0x26A7 , 0x8137B239},
{ 0x26A8 , 0x8137B330},
{ 0x26A9 , 0x8137B331},
{ 0x26AA , 0x8137B332},
{ 0x26AB , 0x8137B333},
{ 0x26AC , 0x8137B334},
{ 0x26AD , 0x8137B335},
{ 0x26AE , 0x8137B336},
{ 0x26AF , 0x8137B337},
{ 0x26B0 , 0x8137B338},
{ 0x26B1 , 0x8137B339},
{ 0x26B2 , 0x8137B430},
{ 0x26B3 , 0x8137B431},
{ 0x26B4 , 0x8137B432},
{ 0x26B5 , 0x8137B433},
{ 0x26B6 , 0x8137B434},
{ 0x26B7 , 0x8137B435},
{ 0x26B8 , 0x8137B436},
{ 0x26B9 , 0x8137B437},
{ 0x26BA , 0x8137B438},
{ 0x26BB , 0x8137B439},
{ 0x26BC , 0x8137B530},
{ 0x26BD , 0x8137B531},
{ 0x26BE , 0x8137B532},
{ 0x26BF , 0x8137B533},
{ 0x26C0 , 0x8137B534},
{ 0x26C1 , 0x8137B535},
{ 0x26C2 , 0x8137B536},
{ 0x26C3 , 0x8137B537},
{ 0x26C4 , 0x8137B538},
{ 0x26C5 , 0x8137B539},
{ 0x26C6 , 0x8137B630},
{ 0x26C7 , 0x8137B631},
{ 0x26C8 , 0x8137B632},
{ 0x26C9 , 0x8137B633},
{ 0x26CA , 0x8137B634},
{ 0x26CB , 0x8137B635},
{ 0x26CC , 0x8137B636},
{ 0x26CD , 0x8137B637},
{ 0x26CE , 0x8137B638},
{ 0x26CF , 0x8137B639},
{ 0x26D0 , 0x8137B730},
{ 0x26D1 , 0x8137B731},
{ 0x26D2 , 0x8137B732},
{ 0x26D3 , 0x8137B733},
{ 0x26D4 , 0x8137B734},
{ 0x26D5 , 0x8137B735},
{ 0x26D6 , 0x8137B736},
{ 0x26D7 , 0x8137B737},
{ 0x26D8 , 0x8137B738},
{ 0x26D9 , 0x8137B739},
{ 0x26DA , 0x8137B830},
{ 0x26DB , 0x8137B831},
{ 0x26DC , 0x8137B832},
{ 0x26DD , 0x8137B833},
{ 0x26DE , 0x8137B834},
{ 0x26DF , 0x8137B835},
{ 0x26E0 , 0x8137B836},
{ 0x26E1 , 0x8137B837},
{ 0x26E2 , 0x8137B838},
{ 0x26E3 , 0x8137B839},
{ 0x26E4 , 0x8137B930},
{ 0x26E5 , 0x8137B931},
{ 0x26E6 , 0x8137B932},
{ 0x26E7 , 0x8137B933},
{ 0x26E8 , 0x8137B934},
{ 0x26E9 , 0x8137B935},
{ 0x26EA , 0x8137B936},
{ 0x26EB , 0x8137B937},
{ 0x26EC , 0x8137B938},
{ 0x26ED , 0x8137B939},
{ 0x26EE , 0x8137BA30},
{ 0x26EF , 0x8137BA31},
{ 0x26F0 , 0x8137BA32},
{ 0x26F1 , 0x8137BA33},
{ 0x26F2 , 0x8137BA34},
{ 0x26F3 , 0x8137BA35},
{ 0x26F4 , 0x8137BA36},
{ 0x26F5 , 0x8137BA37},
{ 0x26F6 , 0x8137BA38},
{ 0x26F7 , 0x8137BA39},
{ 0x26F8 , 0x8137BB30},
{ 0x26F9 , 0x8137BB31},
{ 0x26FA , 0x8137BB32},
{ 0x26FB , 0x8137BB33},
{ 0x26FC , 0x8137BB34},
{ 0x26FD , 0x8137BB35},
{ 0x26FE , 0x8137BB36},
{ 0x26FF , 0x8137BB37},
{ 0x2700 , 0x8137BB38},
{ 0x2701 , 0x8137BB39},
{ 0x2702 , 0x8137BC30},
{ 0x2703 , 0x8137BC31},
{ 0x2704 , 0x8137BC32},
{ 0x2705 , 0x8137BC33},
{ 0x2706 , 0x8137BC34},
{ 0x2707 , 0x8137BC35},
{ 0x2708 , 0x8137BC36},
{ 0x2709 , 0x8137BC37},
{ 0x270A , 0x8137BC38},
{ 0x270B , 0x8137BC39},
{ 0x270C , 0x8137BD30},
{ 0x270D , 0x8137BD31},
{ 0x270E , 0x8137BD32},
{ 0x270F , 0x8137BD33},
{ 0x2710 , 0x8137BD34},
{ 0x2711 , 0x8137BD35},
{ 0x2712 , 0x8137BD36},
{ 0x2713 , 0x8137BD37},
{ 0x2714 , 0x8137BD38},
{ 0x2715 , 0x8137BD39},
{ 0x2716 , 0x8137BE30},
{ 0x2717 , 0x8137BE31},
{ 0x2718 , 0x8137BE32},
{ 0x2719 , 0x8137BE33},
{ 0x271A , 0x8137BE34},
{ 0x271B , 0x8137BE35},
{ 0x271C , 0x8137BE36},
{ 0x271D , 0x8137BE37},
{ 0x271E , 0x8137BE38},
{ 0x271F , 0x8137BE39},
{ 0x2720 , 0x8137BF30},
{ 0x2721 , 0x8137BF31},
{ 0x2722 , 0x8137BF32},
{ 0x2723 , 0x8137BF33},
{ 0x2724 , 0x8137BF34},
{ 0x2725 , 0x8137BF35},
{ 0x2726 , 0x8137BF36},
{ 0x2727 , 0x8137BF37},
{ 0x2728 , 0x8137BF38},
{ 0x2729 , 0x8137BF39},
{ 0x272A , 0x8137C030},
{ 0x272B , 0x8137C031},
{ 0x272C , 0x8137C032},
{ 0x272D , 0x8137C033},
{ 0x272E , 0x8137C034},
{ 0x272F , 0x8137C035},
{ 0x2730 , 0x8137C036},
{ 0x2731 , 0x8137C037},
{ 0x2732 , 0x8137C038},
{ 0x2733 , 0x8137C039},
{ 0x2734 , 0x8137C130},
{ 0x2735 , 0x8137C131},
{ 0x2736 , 0x8137C132},
{ 0x2737 , 0x8137C133},
{ 0x2738 , 0x8137C134},
{ 0x2739 , 0x8137C135},
{ 0x273A , 0x8137C136},
{ 0x273B , 0x8137C137},
{ 0x273C , 0x8137C138},
{ 0x273D , 0x8137C139},
{ 0x273E , 0x8137C230},
{ 0x273F , 0x8137C231},
{ 0x2740 , 0x8137C232},
{ 0x2741 , 0x8137C233},
{ 0x2742 , 0x8137C234},
{ 0x2743 , 0x8137C235},
{ 0x2744 , 0x8137C236},
{ 0x2745 , 0x8137C237},
{ 0x2746 , 0x8137C238},
{ 0x2747 , 0x8137C239},
{ 0x2748 , 0x8137C330},
{ 0x2749 , 0x8137C331},
{ 0x274A , 0x8137C332},
{ 0x274B , 0x8137C333},
{ 0x274C , 0x8137C334},
{ 0x274D , 0x8137C335},
{ 0x274E , 0x8137C336},
{ 0x274F , 0x8137C337},
{ 0x2750 , 0x8137C338},
{ 0x2751 , 0x8137C339},
{ 0x2752 , 0x8137C430},
{ 0x2753 , 0x8137C431},
{ 0x2754 , 0x8137C432},
{ 0x2755 , 0x8137C433},
{ 0x2756 , 0x8137C434},
{ 0x2757 , 0x8137C435},
{ 0x2758 , 0x8137C436},
{ 0x2759 , 0x8137C437},
{ 0x275A , 0x8137C438},
{ 0x275B , 0x8137C439},
{ 0x275C , 0x8137C530},
{ 0x275D , 0x8137C531},
{ 0x275E , 0x8137C532},
{ 0x275F , 0x8137C533},
{ 0x2760 , 0x8137C534},
{ 0x2761 , 0x8137C535},
{ 0x2762 , 0x8137C536},
{ 0x2763 , 0x8137C537},
{ 0x2764 , 0x8137C538},
{ 0x2765 , 0x8137C539},
{ 0x2766 , 0x8137C630},
{ 0x2767 , 0x8137C631},
{ 0x2768 , 0x8137C632},
{ 0x2769 , 0x8137C633},
{ 0x276A , 0x8137C634},
{ 0x276B , 0x8137C635},
{ 0x276C , 0x8137C636},
{ 0x276D , 0x8137C637},
{ 0x276E , 0x8137C638},
{ 0x276F , 0x8137C639},
{ 0x2770 , 0x8137C730},
{ 0x2771 , 0x8137C731},
{ 0x2772 , 0x8137C732},
{ 0x2773 , 0x8137C733},
{ 0x2774 , 0x8137C734},
{ 0x2775 , 0x8137C735},
{ 0x2776 , 0x8137C736},
{ 0x2777 , 0x8137C737},
{ 0x2778 , 0x8137C738},
{ 0x2779 , 0x8137C739},
{ 0x277A , 0x8137C830},
{ 0x277B , 0x8137C831},
{ 0x277C , 0x8137C832},
{ 0x277D , 0x8137C833},
{ 0x277E , 0x8137C834},
{ 0x277F , 0x8137C835},
{ 0x2780 , 0x8137C836},
{ 0x2781 , 0x8137C837},
{ 0x2782 , 0x8137C838},
{ 0x2783 , 0x8137C839},
{ 0x2784 , 0x8137C930},
{ 0x2785 , 0x8137C931},
{ 0x2786 , 0x8137C932},
{ 0x2787 , 0x8137C933},
{ 0x2788 , 0x8137C934},
{ 0x2789 , 0x8137C935},
{ 0x278A , 0x8137C936},
{ 0x278B , 0x8137C937},
{ 0x278C , 0x8137C938},
{ 0x278D , 0x8137C939},
{ 0x278E , 0x8137CA30},
{ 0x278F , 0x8137CA31},
{ 0x2790 , 0x8137CA32},
{ 0x2791 , 0x8137CA33},
{ 0x2792 , 0x8137CA34},
{ 0x2793 , 0x8137CA35},
{ 0x2794 , 0x8137CA36},
{ 0x2795 , 0x8137CA37},
{ 0x2796 , 0x8137CA38},
{ 0x2797 , 0x8137CA39},
{ 0x2798 , 0x8137CB30},
{ 0x2799 , 0x8137CB31},
{ 0x279A , 0x8137CB32},
{ 0x279B , 0x8137CB33},
{ 0x279C , 0x8137CB34},
{ 0x279D , 0x8137CB35},
{ 0x279E , 0x8137CB36},
{ 0x279F , 0x8137CB37},
{ 0x27A0 , 0x8137CB38},
{ 0x27A1 , 0x8137CB39},
{ 0x27A2 , 0x8137CC30},
{ 0x27A3 , 0x8137CC31},
{ 0x27A4 , 0x8137CC32},
{ 0x27A5 , 0x8137CC33},
{ 0x27A6 , 0x8137CC34},
{ 0x27A7 , 0x8137CC35},
{ 0x27A8 , 0x8137CC36},
{ 0x27A9 , 0x8137CC37},
{ 0x27AA , 0x8137CC38},
{ 0x27AB , 0x8137CC39},
{ 0x27AC , 0x8137CD30},
{ 0x27AD , 0x8137CD31},
{ 0x27AE , 0x8137CD32},
{ 0x27AF , 0x8137CD33},
{ 0x27B0 , 0x8137CD34},
{ 0x27B1 , 0x8137CD35},
{ 0x27B2 , 0x8137CD36},
{ 0x27B3 , 0x8137CD37},
{ 0x27B4 , 0x8137CD38},
{ 0x27B5 , 0x8137CD39},
{ 0x27B6 , 0x8137CE30},
{ 0x27B7 , 0x8137CE31},
{ 0x27B8 , 0x8137CE32},
{ 0x27B9 , 0x8137CE33},
{ 0x27BA , 0x8137CE34},
{ 0x27BB , 0x8137CE35},
{ 0x27BC , 0x8137CE36},
{ 0x27BD , 0x8137CE37},
{ 0x27BE , 0x8137CE38},
{ 0x27BF , 0x8137CE39},
{ 0x27C0 , 0x8137CF30},
{ 0x27C1 , 0x8137CF31},
{ 0x27C2 , 0x8137CF32},
{ 0x27C3 , 0x8137CF33},
{ 0x27C4 , 0x8137CF34},
{ 0x27C5 , 0x8137CF35},
{ 0x27C6 , 0x8137CF36},
{ 0x27C7 , 0x8137CF37},
{ 0x27C8 , 0x8137CF38},
{ 0x27C9 , 0x8137CF39},
{ 0x27CA , 0x8137D030},
{ 0x27CB , 0x8137D031},
{ 0x27CC , 0x8137D032},
{ 0x27CD , 0x8137D033},
{ 0x27CE , 0x8137D034},
{ 0x27CF , 0x8137D035},
{ 0x27D0 , 0x8137D036},
{ 0x27D1 , 0x8137D037},
{ 0x27D2 , 0x8137D038},
{ 0x27D3 , 0x8137D039},
{ 0x27D4 , 0x8137D130},
{ 0x27D5 , 0x8137D131},
{ 0x27D6 , 0x8137D132},
{ 0x27D7 , 0x8137D133},
{ 0x27D8 , 0x8137D134},
{ 0x27D9 , 0x8137D135},
{ 0x27DA , 0x8137D136},
{ 0x27DB , 0x8137D137},
{ 0x27DC , 0x8137D138},
{ 0x27DD , 0x8137D139},
{ 0x27DE , 0x8137D230},
{ 0x27DF , 0x8137D231},
{ 0x27E0 , 0x8137D232},
{ 0x27E1 , 0x8137D233},
{ 0x27E2 , 0x8137D234},
{ 0x27E3 , 0x8137D235},
{ 0x27E4 , 0x8137D236},
{ 0x27E5 , 0x8137D237},
{ 0x27E6 , 0x8137D238},
{ 0x27E7 , 0x8137D239},
{ 0x27E8 , 0x8137D330},
{ 0x27E9 , 0x8137D331},
{ 0x27EA , 0x8137D332},
{ 0x27EB , 0x8137D333},
{ 0x27EC , 0x8137D334},
{ 0x27ED , 0x8137D335},
{ 0x27EE , 0x8137D336},
{ 0x27EF , 0x8137D337},
{ 0x27F0 , 0x8137D338},
{ 0x27F1 , 0x8137D339},
{ 0x27F2 , 0x8137D430},
{ 0x27F3 , 0x8137D431},
{ 0x27F4 , 0x8137D432},
{ 0x27F5 , 0x8137D433},
{ 0x27F6 , 0x8137D434},
{ 0x27F7 , 0x8137D435},
{ 0x27F8 , 0x8137D436},
{ 0x27F9 , 0x8137D437},
{ 0x27FA , 0x8137D438},
{ 0x27FB , 0x8137D439},
{ 0x27FC , 0x8137D530},
{ 0x27FD , 0x8137D531},
{ 0x27FE , 0x8137D532},
{ 0x27FF , 0x8137D533},
{ 0x2800 , 0x8137D534},
{ 0x2801 , 0x8137D535},
{ 0x2802 , 0x8137D536},
{ 0x2803 , 0x8137D537},
{ 0x2804 , 0x8137D538},
{ 0x2805 , 0x8137D539},
{ 0x2806 , 0x8137D630},
{ 0x2807 , 0x8137D631},
{ 0x2808 , 0x8137D632},
{ 0x2809 , 0x8137D633},
{ 0x280A , 0x8137D634},
{ 0x280B , 0x8137D635},
{ 0x280C , 0x8137D636},
{ 0x280D , 0x8137D637},
{ 0x280E , 0x8137D638},
{ 0x280F , 0x8137D639},
{ 0x2810 , 0x8137D730},
{ 0x2811 , 0x8137D731},
{ 0x2812 , 0x8137D732},
{ 0x2813 , 0x8137D733},
{ 0x2814 , 0x8137D734},
{ 0x2815 , 0x8137D735},
{ 0x2816 , 0x8137D736},
{ 0x2817 , 0x8137D737},
{ 0x2818 , 0x8137D738},
{ 0x2819 , 0x8137D739},
{ 0x281A , 0x8137D830},
{ 0x281B , 0x8137D831},
{ 0x281C , 0x8137D832},
{ 0x281D , 0x8137D833},
{ 0x281E , 0x8137D834},
{ 0x281F , 0x8137D835},
{ 0x2820 , 0x8137D836},
{ 0x2821 , 0x8137D837},
{ 0x2822 , 0x8137D838},
{ 0x2823 , 0x8137D839},
{ 0x2824 , 0x8137D930},
{ 0x2825 , 0x8137D931},
{ 0x2826 , 0x8137D932},
{ 0x2827 , 0x8137D933},
{ 0x2828 , 0x8137D934},
{ 0x2829 , 0x8137D935},
{ 0x282A , 0x8137D936},
{ 0x282B , 0x8137D937},
{ 0x282C , 0x8137D938},
{ 0x282D , 0x8137D939},
{ 0x282E , 0x8137DA30},
{ 0x282F , 0x8137DA31},
{ 0x2830 , 0x8137DA32},
{ 0x2831 , 0x8137DA33},
{ 0x2832 , 0x8137DA34},
{ 0x2833 , 0x8137DA35},
{ 0x2834 , 0x8137DA36},
{ 0x2835 , 0x8137DA37},
{ 0x2836 , 0x8137DA38},
{ 0x2837 , 0x8137DA39},
{ 0x2838 , 0x8137DB30},
{ 0x2839 , 0x8137DB31},
{ 0x283A , 0x8137DB32},
{ 0x283B , 0x8137DB33},
{ 0x283C , 0x8137DB34},
{ 0x283D , 0x8137DB35},
{ 0x283E , 0x8137DB36},
{ 0x283F , 0x8137DB37},
{ 0x2840 , 0x8137DB38},
{ 0x2841 , 0x8137DB39},
{ 0x2842 , 0x8137DC30},
{ 0x2843 , 0x8137DC31},
{ 0x2844 , 0x8137DC32},
{ 0x2845 , 0x8137DC33},
{ 0x2846 , 0x8137DC34},
{ 0x2847 , 0x8137DC35},
{ 0x2848 , 0x8137DC36},
{ 0x2849 , 0x8137DC37},
{ 0x284A , 0x8137DC38},
{ 0x284B , 0x8137DC39},
{ 0x284C , 0x8137DD30},
{ 0x284D , 0x8137DD31},
{ 0x284E , 0x8137DD32},
{ 0x284F , 0x8137DD33},
{ 0x2850 , 0x8137DD34},
{ 0x2851 , 0x8137DD35},
{ 0x2852 , 0x8137DD36},
{ 0x2853 , 0x8137DD37},
{ 0x2854 , 0x8137DD38},
{ 0x2855 , 0x8137DD39},
{ 0x2856 , 0x8137DE30},
{ 0x2857 , 0x8137DE31},
{ 0x2858 , 0x8137DE32},
{ 0x2859 , 0x8137DE33},
{ 0x285A , 0x8137DE34},
{ 0x285B , 0x8137DE35},
{ 0x285C , 0x8137DE36},
{ 0x285D , 0x8137DE37},
{ 0x285E , 0x8137DE38},
{ 0x285F , 0x8137DE39},
{ 0x2860 , 0x8137DF30},
{ 0x2861 , 0x8137DF31},
{ 0x2862 , 0x8137DF32},
{ 0x2863 , 0x8137DF33},
{ 0x2864 , 0x8137DF34},
{ 0x2865 , 0x8137DF35},
{ 0x2866 , 0x8137DF36},
{ 0x2867 , 0x8137DF37},
{ 0x2868 , 0x8137DF38},
{ 0x2869 , 0x8137DF39},
{ 0x286A , 0x8137E030},
{ 0x286B , 0x8137E031},
{ 0x286C , 0x8137E032},
{ 0x286D , 0x8137E033},
{ 0x286E , 0x8137E034},
{ 0x286F , 0x8137E035},
{ 0x2870 , 0x8137E036},
{ 0x2871 , 0x8137E037},
{ 0x2872 , 0x8137E038},
{ 0x2873 , 0x8137E039},
{ 0x2874 , 0x8137E130},
{ 0x2875 , 0x8137E131},
{ 0x2876 , 0x8137E132},
{ 0x2877 , 0x8137E133},
{ 0x2878 , 0x8137E134},
{ 0x2879 , 0x8137E135},
{ 0x287A , 0x8137E136},
{ 0x287B , 0x8137E137},
{ 0x287C , 0x8137E138},
{ 0x287D , 0x8137E139},
{ 0x287E , 0x8137E230},
{ 0x287F , 0x8137E231},
{ 0x2880 , 0x8137E232},
{ 0x2881 , 0x8137E233},
{ 0x2882 , 0x8137E234},
{ 0x2883 , 0x8137E235},
{ 0x2884 , 0x8137E236},
{ 0x2885 , 0x8137E237},
{ 0x2886 , 0x8137E238},
{ 0x2887 , 0x8137E239},
{ 0x2888 , 0x8137E330},
{ 0x2889 , 0x8137E331},
{ 0x288A , 0x8137E332},
{ 0x288B , 0x8137E333},
{ 0x288C , 0x8137E334},
{ 0x288D , 0x8137E335},
{ 0x288E , 0x8137E336},
{ 0x288F , 0x8137E337},
{ 0x2890 , 0x8137E338},
{ 0x2891 , 0x8137E339},
{ 0x2892 , 0x8137E430},
{ 0x2893 , 0x8137E431},
{ 0x2894 , 0x8137E432},
{ 0x2895 , 0x8137E433},
{ 0x2896 , 0x8137E434},
{ 0x2897 , 0x8137E435},
{ 0x2898 , 0x8137E436},
{ 0x2899 , 0x8137E437},
{ 0x289A , 0x8137E438},
{ 0x289B , 0x8137E439},
{ 0x289C , 0x8137E530},
{ 0x289D , 0x8137E531},
{ 0x289E , 0x8137E532},
{ 0x289F , 0x8137E533},
{ 0x28A0 , 0x8137E534},
{ 0x28A1 , 0x8137E535},
{ 0x28A2 , 0x8137E536},
{ 0x28A3 , 0x8137E537},
{ 0x28A4 , 0x8137E538},
{ 0x28A5 , 0x8137E539},
{ 0x28A6 , 0x8137E630},
{ 0x28A7 , 0x8137E631},
{ 0x28A8 , 0x8137E632},
{ 0x28A9 , 0x8137E633},
{ 0x28AA , 0x8137E634},
{ 0x28AB , 0x8137E635},
{ 0x28AC , 0x8137E636},
{ 0x28AD , 0x8137E637},
{ 0x28AE , 0x8137E638},
{ 0x28AF , 0x8137E639},
{ 0x28B0 , 0x8137E730},
{ 0x28B1 , 0x8137E731},
{ 0x28B2 , 0x8137E732},
{ 0x28B3 , 0x8137E733},
{ 0x28B4 , 0x8137E734},
{ 0x28B5 , 0x8137E735},
{ 0x28B6 , 0x8137E736},
{ 0x28B7 , 0x8137E737},
{ 0x28B8 , 0x8137E738},
{ 0x28B9 , 0x8137E739},
{ 0x28BA , 0x8137E830},
{ 0x28BB , 0x8137E831},
{ 0x28BC , 0x8137E832},
{ 0x28BD , 0x8137E833},
{ 0x28BE , 0x8137E834},
{ 0x28BF , 0x8137E835},
{ 0x28C0 , 0x8137E836},
{ 0x28C1 , 0x8137E837},
{ 0x28C2 , 0x8137E838},
{ 0x28C3 , 0x8137E839},
{ 0x28C4 , 0x8137E930},
{ 0x28C5 , 0x8137E931},
{ 0x28C6 , 0x8137E932},
{ 0x28C7 , 0x8137E933},
{ 0x28C8 , 0x8137E934},
{ 0x28C9 , 0x8137E935},
{ 0x28CA , 0x8137E936},
{ 0x28CB , 0x8137E937},
{ 0x28CC , 0x8137E938},
{ 0x28CD , 0x8137E939},
{ 0x28CE , 0x8137EA30},
{ 0x28CF , 0x8137EA31},
{ 0x28D0 , 0x8137EA32},
{ 0x28D1 , 0x8137EA33},
{ 0x28D2 , 0x8137EA34},
{ 0x28D3 , 0x8137EA35},
{ 0x28D4 , 0x8137EA36},
{ 0x28D5 , 0x8137EA37},
{ 0x28D6 , 0x8137EA38},
{ 0x28D7 , 0x8137EA39},
{ 0x28D8 , 0x8137EB30},
{ 0x28D9 , 0x8137EB31},
{ 0x28DA , 0x8137EB32},
{ 0x28DB , 0x8137EB33},
{ 0x28DC , 0x8137EB34},
{ 0x28DD , 0x8137EB35},
{ 0x28DE , 0x8137EB36},
{ 0x28DF , 0x8137EB37},
{ 0x28E0 , 0x8137EB38},
{ 0x28E1 , 0x8137EB39},
{ 0x28E2 , 0x8137EC30},
{ 0x28E3 , 0x8137EC31},
{ 0x28E4 , 0x8137EC32},
{ 0x28E5 , 0x8137EC33},
{ 0x28E6 , 0x8137EC34},
{ 0x28E7 , 0x8137EC35},
{ 0x28E8 , 0x8137EC36},
{ 0x28E9 , 0x8137EC37},
{ 0x28EA , 0x8137EC38},
{ 0x28EB , 0x8137EC39},
{ 0x28EC , 0x8137ED30},
{ 0x28ED , 0x8137ED31},
{ 0x28EE , 0x8137ED32},
{ 0x28EF , 0x8137ED33},
{ 0x28F0 , 0x8137ED34},
{ 0x28F1 , 0x8137ED35},
{ 0x28F2 , 0x8137ED36},
{ 0x28F3 , 0x8137ED37},
{ 0x28F4 , 0x8137ED38},
{ 0x28F5 , 0x8137ED39},
{ 0x28F6 , 0x8137EE30},
{ 0x28F7 , 0x8137EE31},
{ 0x28F8 , 0x8137EE32},
{ 0x28F9 , 0x8137EE33},
{ 0x28FA , 0x8137EE34},
{ 0x28FB , 0x8137EE35},
{ 0x28FC , 0x8137EE36},
{ 0x28FD , 0x8137EE37},
{ 0x28FE , 0x8137EE38},
{ 0x28FF , 0x8137EE39},
{ 0x2900 , 0x8137EF30},
{ 0x2901 , 0x8137EF31},
{ 0x2902 , 0x8137EF32},
{ 0x2903 , 0x8137EF33},
{ 0x2904 , 0x8137EF34},
{ 0x2905 , 0x8137EF35},
{ 0x2906 , 0x8137EF36},
{ 0x2907 , 0x8137EF37},
{ 0x2908 , 0x8137EF38},
{ 0x2909 , 0x8137EF39},
{ 0x290A , 0x8137F030},
{ 0x290B , 0x8137F031},
{ 0x290C , 0x8137F032},
{ 0x290D , 0x8137F033},
{ 0x290E , 0x8137F034},
{ 0x290F , 0x8137F035},
{ 0x2910 , 0x8137F036},
{ 0x2911 , 0x8137F037},
{ 0x2912 , 0x8137F038},
{ 0x2913 , 0x8137F039},
{ 0x2914 , 0x8137F130},
{ 0x2915 , 0x8137F131},
{ 0x2916 , 0x8137F132},
{ 0x2917 , 0x8137F133},
{ 0x2918 , 0x8137F134},
{ 0x2919 , 0x8137F135},
{ 0x291A , 0x8137F136},
{ 0x291B , 0x8137F137},
{ 0x291C , 0x8137F138},
{ 0x291D , 0x8137F139},
{ 0x291E , 0x8137F230},
{ 0x291F , 0x8137F231},
{ 0x2920 , 0x8137F232},
{ 0x2921 , 0x8137F233},
{ 0x2922 , 0x8137F234},
{ 0x2923 , 0x8137F235},
{ 0x2924 , 0x8137F236},
{ 0x2925 , 0x8137F237},
{ 0x2926 , 0x8137F238},
{ 0x2927 , 0x8137F239},
{ 0x2928 , 0x8137F330},
{ 0x2929 , 0x8137F331},
{ 0x292A , 0x8137F332},
{ 0x292B , 0x8137F333},
{ 0x292C , 0x8137F334},
{ 0x292D , 0x8137F335},
{ 0x292E , 0x8137F336},
{ 0x292F , 0x8137F337},
{ 0x2930 , 0x8137F338},
{ 0x2931 , 0x8137F339},
{ 0x2932 , 0x8137F430},
{ 0x2933 , 0x8137F431},
{ 0x2934 , 0x8137F432},
{ 0x2935 , 0x8137F433},
{ 0x2936 , 0x8137F434},
{ 0x2937 , 0x8137F435},
{ 0x2938 , 0x8137F436},
{ 0x2939 , 0x8137F437},
{ 0x293A , 0x8137F438},
{ 0x293B , 0x8137F439},
{ 0x293C , 0x8137F530},
{ 0x293D , 0x8137F531},
{ 0x293E , 0x8137F532},
{ 0x293F , 0x8137F533},
{ 0x2940 , 0x8137F534},
{ 0x2941 , 0x8137F535},
{ 0x2942 , 0x8137F536},
{ 0x2943 , 0x8137F537},
{ 0x2944 , 0x8137F538},
{ 0x2945 , 0x8137F539},
{ 0x2946 , 0x8137F630},
{ 0x2947 , 0x8137F631},
{ 0x2948 , 0x8137F632},
{ 0x2949 , 0x8137F633},
{ 0x294A , 0x8137F634},
{ 0x294B , 0x8137F635},
{ 0x294C , 0x8137F636},
{ 0x294D , 0x8137F637},
{ 0x294E , 0x8137F638},
{ 0x294F , 0x8137F639},
{ 0x2950 , 0x8137F730},
{ 0x2951 , 0x8137F731},
{ 0x2952 , 0x8137F732},
{ 0x2953 , 0x8137F733},
{ 0x2954 , 0x8137F734},
{ 0x2955 , 0x8137F735},
{ 0x2956 , 0x8137F736},
{ 0x2957 , 0x8137F737},
{ 0x2958 , 0x8137F738},
{ 0x2959 , 0x8137F739},
{ 0x295A , 0x8137F830},
{ 0x295B , 0x8137F831},
{ 0x295C , 0x8137F832},
{ 0x295D , 0x8137F833},
{ 0x295E , 0x8137F834},
{ 0x295F , 0x8137F835},
{ 0x2960 , 0x8137F836},
{ 0x2961 , 0x8137F837},
{ 0x2962 , 0x8137F838},
{ 0x2963 , 0x8137F839},
{ 0x2964 , 0x8137F930},
{ 0x2965 , 0x8137F931},
{ 0x2966 , 0x8137F932},
{ 0x2967 , 0x8137F933},
{ 0x2968 , 0x8137F934},
{ 0x2969 , 0x8137F935},
{ 0x296A , 0x8137F936},
{ 0x296B , 0x8137F937},
{ 0x296C , 0x8137F938},
{ 0x296D , 0x8137F939},
{ 0x296E , 0x8137FA30},
{ 0x296F , 0x8137FA31},
{ 0x2970 , 0x8137FA32},
{ 0x2971 , 0x8137FA33},
{ 0x2972 , 0x8137FA34},
{ 0x2973 , 0x8137FA35},
{ 0x2974 , 0x8137FA36},
{ 0x2975 , 0x8137FA37},
{ 0x2976 , 0x8137FA38},
{ 0x2977 , 0x8137FA39},
{ 0x2978 , 0x8137FB30},
{ 0x2979 , 0x8137FB31},
{ 0x297A , 0x8137FB32},
{ 0x297B , 0x8137FB33},
{ 0x297C , 0x8137FB34},
{ 0x297D , 0x8137FB35},
{ 0x297E , 0x8137FB36},
{ 0x297F , 0x8137FB37},
{ 0x2980 , 0x8137FB38},
{ 0x2981 , 0x8137FB39},
{ 0x2982 , 0x8137FC30},
{ 0x2983 , 0x8137FC31},
{ 0x2984 , 0x8137FC32},
{ 0x2985 , 0x8137FC33},
{ 0x2986 , 0x8137FC34},
{ 0x2987 , 0x8137FC35},
{ 0x2988 , 0x8137FC36},
{ 0x2989 , 0x8137FC37},
{ 0x298A , 0x8137FC38},
{ 0x298B , 0x8137FC39},
{ 0x298C , 0x8137FD30},
{ 0x298D , 0x8137FD31},
{ 0x298E , 0x8137FD32},
{ 0x298F , 0x8137FD33},
{ 0x2990 , 0x8137FD34},
{ 0x2991 , 0x8137FD35},
{ 0x2992 , 0x8137FD36},
{ 0x2993 , 0x8137FD37},
{ 0x2994 , 0x8137FD38},
{ 0x2995 , 0x8137FD39},
{ 0x2996 , 0x8137FE30},
{ 0x2997 , 0x8137FE31},
{ 0x2998 , 0x8137FE32},
{ 0x2999 , 0x8137FE33},
{ 0x299A , 0x8137FE34},
{ 0x299B , 0x8137FE35},
{ 0x299C , 0x8137FE36},
{ 0x299D , 0x8137FE37},
{ 0x299E , 0x8137FE38},
{ 0x299F , 0x8137FE39},
{ 0x29A0 , 0x81388130},
{ 0x29A1 , 0x81388131},
{ 0x29A2 , 0x81388132},
{ 0x29A3 , 0x81388133},
{ 0x29A4 , 0x81388134},
{ 0x29A5 , 0x81388135},
{ 0x29A6 , 0x81388136},
{ 0x29A7 , 0x81388137},
{ 0x29A8 , 0x81388138},
{ 0x29A9 , 0x81388139},
{ 0x29AA , 0x81388230},
{ 0x29AB , 0x81388231},
{ 0x29AC , 0x81388232},
{ 0x29AD , 0x81388233},
{ 0x29AE , 0x81388234},
{ 0x29AF , 0x81388235},
{ 0x29B0 , 0x81388236},
{ 0x29B1 , 0x81388237},
{ 0x29B2 , 0x81388238},
{ 0x29B3 , 0x81388239},
{ 0x29B4 , 0x81388330},
{ 0x29B5 , 0x81388331},
{ 0x29B6 , 0x81388332},
{ 0x29B7 , 0x81388333},
{ 0x29B8 , 0x81388334},
{ 0x29B9 , 0x81388335},
{ 0x29BA , 0x81388336},
{ 0x29BB , 0x81388337},
{ 0x29BC , 0x81388338},
{ 0x29BD , 0x81388339},
{ 0x29BE , 0x81388430},
{ 0x29BF , 0x81388431},
{ 0x29C0 , 0x81388432},
{ 0x29C1 , 0x81388433},
{ 0x29C2 , 0x81388434},
{ 0x29C3 , 0x81388435},
{ 0x29C4 , 0x81388436},
{ 0x29C5 , 0x81388437},
{ 0x29C6 , 0x81388438},
{ 0x29C7 , 0x81388439},
{ 0x29C8 , 0x81388530},
{ 0x29C9 , 0x81388531},
{ 0x29CA , 0x81388532},
{ 0x29CB , 0x81388533},
{ 0x29CC , 0x81388534},
{ 0x29CD , 0x81388535},
{ 0x29CE , 0x81388536},
{ 0x29CF , 0x81388537},
{ 0x29D0 , 0x81388538},
{ 0x29D1 , 0x81388539},
{ 0x29D2 , 0x81388630},
{ 0x29D3 , 0x81388631},
{ 0x29D4 , 0x81388632},
{ 0x29D5 , 0x81388633},
{ 0x29D6 , 0x81388634},
{ 0x29D7 , 0x81388635},
{ 0x29D8 , 0x81388636},
{ 0x29D9 , 0x81388637},
{ 0x29DA , 0x81388638},
{ 0x29DB , 0x81388639},
{ 0x29DC , 0x81388730},
{ 0x29DD , 0x81388731},
{ 0x29DE , 0x81388732},
{ 0x29DF , 0x81388733},
{ 0x29E0 , 0x81388734},
{ 0x29E1 , 0x81388735},
{ 0x29E2 , 0x81388736},
{ 0x29E3 , 0x81388737},
{ 0x29E4 , 0x81388738},
{ 0x29E5 , 0x81388739},
{ 0x29E6 , 0x81388830},
{ 0x29E7 , 0x81388831},
{ 0x29E8 , 0x81388832},
{ 0x29E9 , 0x81388833},
{ 0x29EA , 0x81388834},
{ 0x29EB , 0x81388835},
{ 0x29EC , 0x81388836},
{ 0x29ED , 0x81388837},
{ 0x29EE , 0x81388838},
{ 0x29EF , 0x81388839},
{ 0x29F0 , 0x81388930},
{ 0x29F1 , 0x81388931},
{ 0x29F2 , 0x81388932},
{ 0x29F3 , 0x81388933},
{ 0x29F4 , 0x81388934},
{ 0x29F5 , 0x81388935},
{ 0x29F6 , 0x81388936},
{ 0x29F7 , 0x81388937},
{ 0x29F8 , 0x81388938},
{ 0x29F9 , 0x81388939},
{ 0x29FA , 0x81388A30},
{ 0x29FB , 0x81388A31},
{ 0x29FC , 0x81388A32},
{ 0x29FD , 0x81388A33},
{ 0x29FE , 0x81388A34},
{ 0x29FF , 0x81388A35},
{ 0x2A00 , 0x81388A36},
{ 0x2A01 , 0x81388A37},
{ 0x2A02 , 0x81388A38},
{ 0x2A03 , 0x81388A39},
{ 0x2A04 , 0x81388B30},
{ 0x2A05 , 0x81388B31},
{ 0x2A06 , 0x81388B32},
{ 0x2A07 , 0x81388B33},
{ 0x2A08 , 0x81388B34},
{ 0x2A09 , 0x81388B35},
{ 0x2A0A , 0x81388B36},
{ 0x2A0B , 0x81388B37},
{ 0x2A0C , 0x81388B38},
{ 0x2A0D , 0x81388B39},
{ 0x2A0E , 0x81388C30},
{ 0x2A0F , 0x81388C31},
{ 0x2A10 , 0x81388C32},
{ 0x2A11 , 0x81388C33},
{ 0x2A12 , 0x81388C34},
{ 0x2A13 , 0x81388C35},
{ 0x2A14 , 0x81388C36},
{ 0x2A15 , 0x81388C37},
{ 0x2A16 , 0x81388C38},
{ 0x2A17 , 0x81388C39},
{ 0x2A18 , 0x81388D30},
{ 0x2A19 , 0x81388D31},
{ 0x2A1A , 0x81388D32},
{ 0x2A1B , 0x81388D33},
{ 0x2A1C , 0x81388D34},
{ 0x2A1D , 0x81388D35},
{ 0x2A1E , 0x81388D36},
{ 0x2A1F , 0x81388D37},
{ 0x2A20 , 0x81388D38},
{ 0x2A21 , 0x81388D39},
{ 0x2A22 , 0x81388E30},
{ 0x2A23 , 0x81388E31},
{ 0x2A24 , 0x81388E32},
{ 0x2A25 , 0x81388E33},
{ 0x2A26 , 0x81388E34},
{ 0x2A27 , 0x81388E35},
{ 0x2A28 , 0x81388E36},
{ 0x2A29 , 0x81388E37},
{ 0x2A2A , 0x81388E38},
{ 0x2A2B , 0x81388E39},
{ 0x2A2C , 0x81388F30},
{ 0x2A2D , 0x81388F31},
{ 0x2A2E , 0x81388F32},
{ 0x2A2F , 0x81388F33},
{ 0x2A30 , 0x81388F34},
{ 0x2A31 , 0x81388F35},
{ 0x2A32 , 0x81388F36},
{ 0x2A33 , 0x81388F37},
{ 0x2A34 , 0x81388F38},
{ 0x2A35 , 0x81388F39},
{ 0x2A36 , 0x81389030},
{ 0x2A37 , 0x81389031},
{ 0x2A38 , 0x81389032},
{ 0x2A39 , 0x81389033},
{ 0x2A3A , 0x81389034},
{ 0x2A3B , 0x81389035},
{ 0x2A3C , 0x81389036},
{ 0x2A3D , 0x81389037},
{ 0x2A3E , 0x81389038},
{ 0x2A3F , 0x81389039},
{ 0x2A40 , 0x81389130},
{ 0x2A41 , 0x81389131},
{ 0x2A42 , 0x81389132},
{ 0x2A43 , 0x81389133},
{ 0x2A44 , 0x81389134},
{ 0x2A45 , 0x81389135},
{ 0x2A46 , 0x81389136},
{ 0x2A47 , 0x81389137},
{ 0x2A48 , 0x81389138},
{ 0x2A49 , 0x81389139},
{ 0x2A4A , 0x81389230},
{ 0x2A4B , 0x81389231},
{ 0x2A4C , 0x81389232},
{ 0x2A4D , 0x81389233},
{ 0x2A4E , 0x81389234},
{ 0x2A4F , 0x81389235},
{ 0x2A50 , 0x81389236},
{ 0x2A51 , 0x81389237},
{ 0x2A52 , 0x81389238},
{ 0x2A53 , 0x81389239},
{ 0x2A54 , 0x81389330},
{ 0x2A55 , 0x81389331},
{ 0x2A56 , 0x81389332},
{ 0x2A57 , 0x81389333},
{ 0x2A58 , 0x81389334},
{ 0x2A59 , 0x81389335},
{ 0x2A5A , 0x81389336},
{ 0x2A5B , 0x81389337},
{ 0x2A5C , 0x81389338},
{ 0x2A5D , 0x81389339},
{ 0x2A5E , 0x81389430},
{ 0x2A5F , 0x81389431},
{ 0x2A60 , 0x81389432},
{ 0x2A61 , 0x81389433},
{ 0x2A62 , 0x81389434},
{ 0x2A63 , 0x81389435},
{ 0x2A64 , 0x81389436},
{ 0x2A65 , 0x81389437},
{ 0x2A66 , 0x81389438},
{ 0x2A67 , 0x81389439},
{ 0x2A68 , 0x81389530},
{ 0x2A69 , 0x81389531},
{ 0x2A6A , 0x81389532},
{ 0x2A6B , 0x81389533},
{ 0x2A6C , 0x81389534},
{ 0x2A6D , 0x81389535},
{ 0x2A6E , 0x81389536},
{ 0x2A6F , 0x81389537},
{ 0x2A70 , 0x81389538},
{ 0x2A71 , 0x81389539},
{ 0x2A72 , 0x81389630},
{ 0x2A73 , 0x81389631},
{ 0x2A74 , 0x81389632},
{ 0x2A75 , 0x81389633},
{ 0x2A76 , 0x81389634},
{ 0x2A77 , 0x81389635},
{ 0x2A78 , 0x81389636},
{ 0x2A79 , 0x81389637},
{ 0x2A7A , 0x81389638},
{ 0x2A7B , 0x81389639},
{ 0x2A7C , 0x81389730},
{ 0x2A7D , 0x81389731},
{ 0x2A7E , 0x81389732},
{ 0x2A7F , 0x81389733},
{ 0x2A80 , 0x81389734},
{ 0x2A81 , 0x81389735},
{ 0x2A82 , 0x81389736},
{ 0x2A83 , 0x81389737},
{ 0x2A84 , 0x81389738},
{ 0x2A85 , 0x81389739},
{ 0x2A86 , 0x81389830},
{ 0x2A87 , 0x81389831},
{ 0x2A88 , 0x81389832},
{ 0x2A89 , 0x81389833},
{ 0x2A8A , 0x81389834},
{ 0x2A8B , 0x81389835},
{ 0x2A8C , 0x81389836},
{ 0x2A8D , 0x81389837},
{ 0x2A8E , 0x81389838},
{ 0x2A8F , 0x81389839},
{ 0x2A90 , 0x81389930},
{ 0x2A91 , 0x81389931},
{ 0x2A92 , 0x81389932},
{ 0x2A93 , 0x81389933},
{ 0x2A94 , 0x81389934},
{ 0x2A95 , 0x81389935},
{ 0x2A96 , 0x81389936},
{ 0x2A97 , 0x81389937},
{ 0x2A98 , 0x81389938},
{ 0x2A99 , 0x81389939},
{ 0x2A9A , 0x81389A30},
{ 0x2A9B , 0x81389A31},
{ 0x2A9C , 0x81389A32},
{ 0x2A9D , 0x81389A33},
{ 0x2A9E , 0x81389A34},
{ 0x2A9F , 0x81389A35},
{ 0x2AA0 , 0x81389A36},
{ 0x2AA1 , 0x81389A37},
{ 0x2AA2 , 0x81389A38},
{ 0x2AA3 , 0x81389A39},
{ 0x2AA4 , 0x81389B30},
{ 0x2AA5 , 0x81389B31},
{ 0x2AA6 , 0x81389B32},
{ 0x2AA7 , 0x81389B33},
{ 0x2AA8 , 0x81389B34},
{ 0x2AA9 , 0x81389B35},
{ 0x2AAA , 0x81389B36},
{ 0x2AAB , 0x81389B37},
{ 0x2AAC , 0x81389B38},
{ 0x2AAD , 0x81389B39},
{ 0x2AAE , 0x81389C30},
{ 0x2AAF , 0x81389C31},
{ 0x2AB0 , 0x81389C32},
{ 0x2AB1 , 0x81389C33},
{ 0x2AB2 , 0x81389C34},
{ 0x2AB3 , 0x81389C35},
{ 0x2AB4 , 0x81389C36},
{ 0x2AB5 , 0x81389C37},
{ 0x2AB6 , 0x81389C38},
{ 0x2AB7 , 0x81389C39},
{ 0x2AB8 , 0x81389D30},
{ 0x2AB9 , 0x81389D31},
{ 0x2ABA , 0x81389D32},
{ 0x2ABB , 0x81389D33},
{ 0x2ABC , 0x81389D34},
{ 0x2ABD , 0x81389D35},
{ 0x2ABE , 0x81389D36},
{ 0x2ABF , 0x81389D37},
{ 0x2AC0 , 0x81389D38},
{ 0x2AC1 , 0x81389D39},
{ 0x2AC2 , 0x81389E30},
{ 0x2AC3 , 0x81389E31},
{ 0x2AC4 , 0x81389E32},
{ 0x2AC5 , 0x81389E33},
{ 0x2AC6 , 0x81389E34},
{ 0x2AC7 , 0x81389E35},
{ 0x2AC8 , 0x81389E36},
{ 0x2AC9 , 0x81389E37},
{ 0x2ACA , 0x81389E38},
{ 0x2ACB , 0x81389E39},
{ 0x2ACC , 0x81389F30},
{ 0x2ACD , 0x81389F31},
{ 0x2ACE , 0x81389F32},
{ 0x2ACF , 0x81389F33},
{ 0x2AD0 , 0x81389F34},
{ 0x2AD1 , 0x81389F35},
{ 0x2AD2 , 0x81389F36},
{ 0x2AD3 , 0x81389F37},
{ 0x2AD4 , 0x81389F38},
{ 0x2AD5 , 0x81389F39},
{ 0x2AD6 , 0x8138A030},
{ 0x2AD7 , 0x8138A031},
{ 0x2AD8 , 0x8138A032},
{ 0x2AD9 , 0x8138A033},
{ 0x2ADA , 0x8138A034},
{ 0x2ADB , 0x8138A035},
{ 0x2ADC , 0x8138A036},
{ 0x2ADD , 0x8138A037},
{ 0x2ADE , 0x8138A038},
{ 0x2ADF , 0x8138A039},
{ 0x2AE0 , 0x8138A130},
{ 0x2AE1 , 0x8138A131},
{ 0x2AE2 , 0x8138A132},
{ 0x2AE3 , 0x8138A133},
{ 0x2AE4 , 0x8138A134},
{ 0x2AE5 , 0x8138A135},
{ 0x2AE6 , 0x8138A136},
{ 0x2AE7 , 0x8138A137},
{ 0x2AE8 , 0x8138A138},
{ 0x2AE9 , 0x8138A139},
{ 0x2AEA , 0x8138A230},
{ 0x2AEB , 0x8138A231},
{ 0x2AEC , 0x8138A232},
{ 0x2AED , 0x8138A233},
{ 0x2AEE , 0x8138A234},
{ 0x2AEF , 0x8138A235},
{ 0x2AF0 , 0x8138A236},
{ 0x2AF1 , 0x8138A237},
{ 0x2AF2 , 0x8138A238},
{ 0x2AF3 , 0x8138A239},
{ 0x2AF4 , 0x8138A330},
{ 0x2AF5 , 0x8138A331},
{ 0x2AF6 , 0x8138A332},
{ 0x2AF7 , 0x8138A333},
{ 0x2AF8 , 0x8138A334},
{ 0x2AF9 , 0x8138A335},
{ 0x2AFA , 0x8138A336},
{ 0x2AFB , 0x8138A337},
{ 0x2AFC , 0x8138A338},
{ 0x2AFD , 0x8138A339},
{ 0x2AFE , 0x8138A430},
{ 0x2AFF , 0x8138A431},
{ 0x2B00 , 0x8138A432},
{ 0x2B01 , 0x8138A433},
{ 0x2B02 , 0x8138A434},
{ 0x2B03 , 0x8138A435},
{ 0x2B04 , 0x8138A436},
{ 0x2B05 , 0x8138A437},
{ 0x2B06 , 0x8138A438},
{ 0x2B07 , 0x8138A439},
{ 0x2B08 , 0x8138A530},
{ 0x2B09 , 0x8138A531},
{ 0x2B0A , 0x8138A532},
{ 0x2B0B , 0x8138A533},
{ 0x2B0C , 0x8138A534},
{ 0x2B0D , 0x8138A535},
{ 0x2B0E , 0x8138A536},
{ 0x2B0F , 0x8138A537},
{ 0x2B10 , 0x8138A538},
{ 0x2B11 , 0x8138A539},
{ 0x2B12 , 0x8138A630},
{ 0x2B13 , 0x8138A631},
{ 0x2B14 , 0x8138A632},
{ 0x2B15 , 0x8138A633},
{ 0x2B16 , 0x8138A634},
{ 0x2B17 , 0x8138A635},
{ 0x2B18 , 0x8138A636},
{ 0x2B19 , 0x8138A637},
{ 0x2B1A , 0x8138A638},
{ 0x2B1B , 0x8138A639},
{ 0x2B1C , 0x8138A730},
{ 0x2B1D , 0x8138A731},
{ 0x2B1E , 0x8138A732},
{ 0x2B1F , 0x8138A733},
{ 0x2B20 , 0x8138A734},
{ 0x2B21 , 0x8138A735},
{ 0x2B22 , 0x8138A736},
{ 0x2B23 , 0x8138A737},
{ 0x2B24 , 0x8138A738},
{ 0x2B25 , 0x8138A739},
{ 0x2B26 , 0x8138A830},
{ 0x2B27 , 0x8138A831},
{ 0x2B28 , 0x8138A832},
{ 0x2B29 , 0x8138A833},
{ 0x2B2A , 0x8138A834},
{ 0x2B2B , 0x8138A835},
{ 0x2B2C , 0x8138A836},
{ 0x2B2D , 0x8138A837},
{ 0x2B2E , 0x8138A838},
{ 0x2B2F , 0x8138A839},
{ 0x2B30 , 0x8138A930},
{ 0x2B31 , 0x8138A931},
{ 0x2B32 , 0x8138A932},
{ 0x2B33 , 0x8138A933},
{ 0x2B34 , 0x8138A934},
{ 0x2B35 , 0x8138A935},
{ 0x2B36 , 0x8138A936},
{ 0x2B37 , 0x8138A937},
{ 0x2B38 , 0x8138A938},
{ 0x2B39 , 0x8138A939},
{ 0x2B3A , 0x8138AA30},
{ 0x2B3B , 0x8138AA31},
{ 0x2B3C , 0x8138AA32},
{ 0x2B3D , 0x8138AA33},
{ 0x2B3E , 0x8138AA34},
{ 0x2B3F , 0x8138AA35},
{ 0x2B40 , 0x8138AA36},
{ 0x2B41 , 0x8138AA37},
{ 0x2B42 , 0x8138AA38},
{ 0x2B43 , 0x8138AA39},
{ 0x2B44 , 0x8138AB30},
{ 0x2B45 , 0x8138AB31},
{ 0x2B46 , 0x8138AB32},
{ 0x2B47 , 0x8138AB33},
{ 0x2B48 , 0x8138AB34},
{ 0x2B49 , 0x8138AB35},
{ 0x2B4A , 0x8138AB36},
{ 0x2B4B , 0x8138AB37},
{ 0x2B4C , 0x8138AB38},
{ 0x2B4D , 0x8138AB39},
{ 0x2B4E , 0x8138AC30},
{ 0x2B4F , 0x8138AC31},
{ 0x2B50 , 0x8138AC32},
{ 0x2B51 , 0x8138AC33},
{ 0x2B52 , 0x8138AC34},
{ 0x2B53 , 0x8138AC35},
{ 0x2B54 , 0x8138AC36},
{ 0x2B55 , 0x8138AC37},
{ 0x2B56 , 0x8138AC38},
{ 0x2B57 , 0x8138AC39},
{ 0x2B58 , 0x8138AD30},
{ 0x2B59 , 0x8138AD31},
{ 0x2B5A , 0x8138AD32},
{ 0x2B5B , 0x8138AD33},
{ 0x2B5C , 0x8138AD34},
{ 0x2B5D , 0x8138AD35},
{ 0x2B5E , 0x8138AD36},
{ 0x2B5F , 0x8138AD37},
{ 0x2B60 , 0x8138AD38},
{ 0x2B61 , 0x8138AD39},
{ 0x2B62 , 0x8138AE30},
{ 0x2B63 , 0x8138AE31},
{ 0x2B64 , 0x8138AE32},
{ 0x2B65 , 0x8138AE33},
{ 0x2B66 , 0x8138AE34},
{ 0x2B67 , 0x8138AE35},
{ 0x2B68 , 0x8138AE36},
{ 0x2B69 , 0x8138AE37},
{ 0x2B6A , 0x8138AE38},
{ 0x2B6B , 0x8138AE39},
{ 0x2B6C , 0x8138AF30},
{ 0x2B6D , 0x8138AF31},
{ 0x2B6E , 0x8138AF32},
{ 0x2B6F , 0x8138AF33},
{ 0x2B70 , 0x8138AF34},
{ 0x2B71 , 0x8138AF35},
{ 0x2B72 , 0x8138AF36},
{ 0x2B73 , 0x8138AF37},
{ 0x2B74 , 0x8138AF38},
{ 0x2B75 , 0x8138AF39},
{ 0x2B76 , 0x8138B030},
{ 0x2B77 , 0x8138B031},
{ 0x2B78 , 0x8138B032},
{ 0x2B79 , 0x8138B033},
{ 0x2B7A , 0x8138B034},
{ 0x2B7B , 0x8138B035},
{ 0x2B7C , 0x8138B036},
{ 0x2B7D , 0x8138B037},
{ 0x2B7E , 0x8138B038},
{ 0x2B7F , 0x8138B039},
{ 0x2B80 , 0x8138B130},
{ 0x2B81 , 0x8138B131},
{ 0x2B82 , 0x8138B132},
{ 0x2B83 , 0x8138B133},
{ 0x2B84 , 0x8138B134},
{ 0x2B85 , 0x8138B135},
{ 0x2B86 , 0x8138B136},
{ 0x2B87 , 0x8138B137},
{ 0x2B88 , 0x8138B138},
{ 0x2B89 , 0x8138B139},
{ 0x2B8A , 0x8138B230},
{ 0x2B8B , 0x8138B231},
{ 0x2B8C , 0x8138B232},
{ 0x2B8D , 0x8138B233},
{ 0x2B8E , 0x8138B234},
{ 0x2B8F , 0x8138B235},
{ 0x2B90 , 0x8138B236},
{ 0x2B91 , 0x8138B237},
{ 0x2B92 , 0x8138B238},
{ 0x2B93 , 0x8138B239},
{ 0x2B94 , 0x8138B330},
{ 0x2B95 , 0x8138B331},
{ 0x2B96 , 0x8138B332},
{ 0x2B97 , 0x8138B333},
{ 0x2B98 , 0x8138B334},
{ 0x2B99 , 0x8138B335},
{ 0x2B9A , 0x8138B336},
{ 0x2B9B , 0x8138B337},
{ 0x2B9C , 0x8138B338},
{ 0x2B9D , 0x8138B339},
{ 0x2B9E , 0x8138B430},
{ 0x2B9F , 0x8138B431},
{ 0x2BA0 , 0x8138B432},
{ 0x2BA1 , 0x8138B433},
{ 0x2BA2 , 0x8138B434},
{ 0x2BA3 , 0x8138B435},
{ 0x2BA4 , 0x8138B436},
{ 0x2BA5 , 0x8138B437},
{ 0x2BA6 , 0x8138B438},
{ 0x2BA7 , 0x8138B439},
{ 0x2BA8 , 0x8138B530},
{ 0x2BA9 , 0x8138B531},
{ 0x2BAA , 0x8138B532},
{ 0x2BAB , 0x8138B533},
{ 0x2BAC , 0x8138B534},
{ 0x2BAD , 0x8138B535},
{ 0x2BAE , 0x8138B536},
{ 0x2BAF , 0x8138B537},
{ 0x2BB0 , 0x8138B538},
{ 0x2BB1 , 0x8138B539},
{ 0x2BB2 , 0x8138B630},
{ 0x2BB3 , 0x8138B631},
{ 0x2BB4 , 0x8138B632},
{ 0x2BB5 , 0x8138B633},
{ 0x2BB6 , 0x8138B634},
{ 0x2BB7 , 0x8138B635},
{ 0x2BB8 , 0x8138B636},
{ 0x2BB9 , 0x8138B637},
{ 0x2BBA , 0x8138B638},
{ 0x2BBB , 0x8138B639},
{ 0x2BBC , 0x8138B730},
{ 0x2BBD , 0x8138B731},
{ 0x2BBE , 0x8138B732},
{ 0x2BBF , 0x8138B733},
{ 0x2BC0 , 0x8138B734},
{ 0x2BC1 , 0x8138B735},
{ 0x2BC2 , 0x8138B736},
{ 0x2BC3 , 0x8138B737},
{ 0x2BC4 , 0x8138B738},
{ 0x2BC5 , 0x8138B739},
{ 0x2BC6 , 0x8138B830},
{ 0x2BC7 , 0x8138B831},
{ 0x2BC8 , 0x8138B832},
{ 0x2BC9 , 0x8138B833},
{ 0x2BCA , 0x8138B834},
{ 0x2BCB , 0x8138B835},
{ 0x2BCC , 0x8138B836},
{ 0x2BCD , 0x8138B837},
{ 0x2BCE , 0x8138B838},
{ 0x2BCF , 0x8138B839},
{ 0x2BD0 , 0x8138B930},
{ 0x2BD1 , 0x8138B931},
{ 0x2BD2 , 0x8138B932},
{ 0x2BD3 , 0x8138B933},
{ 0x2BD4 , 0x8138B934},
{ 0x2BD5 , 0x8138B935},
{ 0x2BD6 , 0x8138B936},
{ 0x2BD7 , 0x8138B937},
{ 0x2BD8 , 0x8138B938},
{ 0x2BD9 , 0x8138B939},
{ 0x2BDA , 0x8138BA30},
{ 0x2BDB , 0x8138BA31},
{ 0x2BDC , 0x8138BA32},
{ 0x2BDD , 0x8138BA33},
{ 0x2BDE , 0x8138BA34},
{ 0x2BDF , 0x8138BA35},
{ 0x2BE0 , 0x8138BA36},
{ 0x2BE1 , 0x8138BA37},
{ 0x2BE2 , 0x8138BA38},
{ 0x2BE3 , 0x8138BA39},
{ 0x2BE4 , 0x8138BB30},
{ 0x2BE5 , 0x8138BB31},
{ 0x2BE6 , 0x8138BB32},
{ 0x2BE7 , 0x8138BB33},
{ 0x2BE8 , 0x8138BB34},
{ 0x2BE9 , 0x8138BB35},
{ 0x2BEA , 0x8138BB36},
{ 0x2BEB , 0x8138BB37},
{ 0x2BEC , 0x8138BB38},
{ 0x2BED , 0x8138BB39},
{ 0x2BEE , 0x8138BC30},
{ 0x2BEF , 0x8138BC31},
{ 0x2BF0 , 0x8138BC32},
{ 0x2BF1 , 0x8138BC33},
{ 0x2BF2 , 0x8138BC34},
{ 0x2BF3 , 0x8138BC35},
{ 0x2BF4 , 0x8138BC36},
{ 0x2BF5 , 0x8138BC37},
{ 0x2BF6 , 0x8138BC38},
{ 0x2BF7 , 0x8138BC39},
{ 0x2BF8 , 0x8138BD30},
{ 0x2BF9 , 0x8138BD31},
{ 0x2BFA , 0x8138BD32},
{ 0x2BFB , 0x8138BD33},
{ 0x2BFC , 0x8138BD34},
{ 0x2BFD , 0x8138BD35},
{ 0x2BFE , 0x8138BD36},
{ 0x2BFF , 0x8138BD37},
{ 0x2C00 , 0x8138BD38},
{ 0x2C01 , 0x8138BD39},
{ 0x2C02 , 0x8138BE30},
{ 0x2C03 , 0x8138BE31},
{ 0x2C04 , 0x8138BE32},
{ 0x2C05 , 0x8138BE33},
{ 0x2C06 , 0x8138BE34},
{ 0x2C07 , 0x8138BE35},
{ 0x2C08 , 0x8138BE36},
{ 0x2C09 , 0x8138BE37},
{ 0x2C0A , 0x8138BE38},
{ 0x2C0B , 0x8138BE39},
{ 0x2C0C , 0x8138BF30},
{ 0x2C0D , 0x8138BF31},
{ 0x2C0E , 0x8138BF32},
{ 0x2C0F , 0x8138BF33},
{ 0x2C10 , 0x8138BF34},
{ 0x2C11 , 0x8138BF35},
{ 0x2C12 , 0x8138BF36},
{ 0x2C13 , 0x8138BF37},
{ 0x2C14 , 0x8138BF38},
{ 0x2C15 , 0x8138BF39},
{ 0x2C16 , 0x8138C030},
{ 0x2C17 , 0x8138C031},
{ 0x2C18 , 0x8138C032},
{ 0x2C19 , 0x8138C033},
{ 0x2C1A , 0x8138C034},
{ 0x2C1B , 0x8138C035},
{ 0x2C1C , 0x8138C036},
{ 0x2C1D , 0x8138C037},
{ 0x2C1E , 0x8138C038},
{ 0x2C1F , 0x8138C039},
{ 0x2C20 , 0x8138C130},
{ 0x2C21 , 0x8138C131},
{ 0x2C22 , 0x8138C132},
{ 0x2C23 , 0x8138C133},
{ 0x2C24 , 0x8138C134},
{ 0x2C25 , 0x8138C135},
{ 0x2C26 , 0x8138C136},
{ 0x2C27 , 0x8138C137},
{ 0x2C28 , 0x8138C138},
{ 0x2C29 , 0x8138C139},
{ 0x2C2A , 0x8138C230},
{ 0x2C2B , 0x8138C231},
{ 0x2C2C , 0x8138C232},
{ 0x2C2D , 0x8138C233},
{ 0x2C2E , 0x8138C234},
{ 0x2C2F , 0x8138C235},
{ 0x2C30 , 0x8138C236},
{ 0x2C31 , 0x8138C237},
{ 0x2C32 , 0x8138C238},
{ 0x2C33 , 0x8138C239},
{ 0x2C34 , 0x8138C330},
{ 0x2C35 , 0x8138C331},
{ 0x2C36 , 0x8138C332},
{ 0x2C37 , 0x8138C333},
{ 0x2C38 , 0x8138C334},
{ 0x2C39 , 0x8138C335},
{ 0x2C3A , 0x8138C336},
{ 0x2C3B , 0x8138C337},
{ 0x2C3C , 0x8138C338},
{ 0x2C3D , 0x8138C339},
{ 0x2C3E , 0x8138C430},
{ 0x2C3F , 0x8138C431},
{ 0x2C40 , 0x8138C432},
{ 0x2C41 , 0x8138C433},
{ 0x2C42 , 0x8138C434},
{ 0x2C43 , 0x8138C435},
{ 0x2C44 , 0x8138C436},
{ 0x2C45 , 0x8138C437},
{ 0x2C46 , 0x8138C438},
{ 0x2C47 , 0x8138C439},
{ 0x2C48 , 0x8138C530},
{ 0x2C49 , 0x8138C531},
{ 0x2C4A , 0x8138C532},
{ 0x2C4B , 0x8138C533},
{ 0x2C4C , 0x8138C534},
{ 0x2C4D , 0x8138C535},
{ 0x2C4E , 0x8138C536},
{ 0x2C4F , 0x8138C537},
{ 0x2C50 , 0x8138C538},
{ 0x2C51 , 0x8138C539},
{ 0x2C52 , 0x8138C630},
{ 0x2C53 , 0x8138C631},
{ 0x2C54 , 0x8138C632},
{ 0x2C55 , 0x8138C633},
{ 0x2C56 , 0x8138C634},
{ 0x2C57 , 0x8138C635},
{ 0x2C58 , 0x8138C636},
{ 0x2C59 , 0x8138C637},
{ 0x2C5A , 0x8138C638},
{ 0x2C5B , 0x8138C639},
{ 0x2C5C , 0x8138C730},
{ 0x2C5D , 0x8138C731},
{ 0x2C5E , 0x8138C732},
{ 0x2C5F , 0x8138C733},
{ 0x2C60 , 0x8138C734},
{ 0x2C61 , 0x8138C735},
{ 0x2C62 , 0x8138C736},
{ 0x2C63 , 0x8138C737},
{ 0x2C64 , 0x8138C738},
{ 0x2C65 , 0x8138C739},
{ 0x2C66 , 0x8138C830},
{ 0x2C67 , 0x8138C831},
{ 0x2C68 , 0x8138C832},
{ 0x2C69 , 0x8138C833},
{ 0x2C6A , 0x8138C834},
{ 0x2C6B , 0x8138C835},
{ 0x2C6C , 0x8138C836},
{ 0x2C6D , 0x8138C837},
{ 0x2C6E , 0x8138C838},
{ 0x2C6F , 0x8138C839},
{ 0x2C70 , 0x8138C930},
{ 0x2C71 , 0x8138C931},
{ 0x2C72 , 0x8138C932},
{ 0x2C73 , 0x8138C933},
{ 0x2C74 , 0x8138C934},
{ 0x2C75 , 0x8138C935},
{ 0x2C76 , 0x8138C936},
{ 0x2C77 , 0x8138C937},
{ 0x2C78 , 0x8138C938},
{ 0x2C79 , 0x8138C939},
{ 0x2C7A , 0x8138CA30},
{ 0x2C7B , 0x8138CA31},
{ 0x2C7C , 0x8138CA32},
{ 0x2C7D , 0x8138CA33},
{ 0x2C7E , 0x8138CA34},
{ 0x2C7F , 0x8138CA35},
{ 0x2C80 , 0x8138CA36},
{ 0x2C81 , 0x8138CA37},
{ 0x2C82 , 0x8138CA38},
{ 0x2C83 , 0x8138CA39},
{ 0x2C84 , 0x8138CB30},
{ 0x2C85 , 0x8138CB31},
{ 0x2C86 , 0x8138CB32},
{ 0x2C87 , 0x8138CB33},
{ 0x2C88 , 0x8138CB34},
{ 0x2C89 , 0x8138CB35},
{ 0x2C8A , 0x8138CB36},
{ 0x2C8B , 0x8138CB37},
{ 0x2C8C , 0x8138CB38},
{ 0x2C8D , 0x8138CB39},
{ 0x2C8E , 0x8138CC30},
{ 0x2C8F , 0x8138CC31},
{ 0x2C90 , 0x8138CC32},
{ 0x2C91 , 0x8138CC33},
{ 0x2C92 , 0x8138CC34},
{ 0x2C93 , 0x8138CC35},
{ 0x2C94 , 0x8138CC36},
{ 0x2C95 , 0x8138CC37},
{ 0x2C96 , 0x8138CC38},
{ 0x2C97 , 0x8138CC39},
{ 0x2C98 , 0x8138CD30},
{ 0x2C99 , 0x8138CD31},
{ 0x2C9A , 0x8138CD32},
{ 0x2C9B , 0x8138CD33},
{ 0x2C9C , 0x8138CD34},
{ 0x2C9D , 0x8138CD35},
{ 0x2C9E , 0x8138CD36},
{ 0x2C9F , 0x8138CD37},
{ 0x2CA0 , 0x8138CD38},
{ 0x2CA1 , 0x8138CD39},
{ 0x2CA2 , 0x8138CE30},
{ 0x2CA3 , 0x8138CE31},
{ 0x2CA4 , 0x8138CE32},
{ 0x2CA5 , 0x8138CE33},
{ 0x2CA6 , 0x8138CE34},
{ 0x2CA7 , 0x8138CE35},
{ 0x2CA8 , 0x8138CE36},
{ 0x2CA9 , 0x8138CE37},
{ 0x2CAA , 0x8138CE38},
{ 0x2CAB , 0x8138CE39},
{ 0x2CAC , 0x8138CF30},
{ 0x2CAD , 0x8138CF31},
{ 0x2CAE , 0x8138CF32},
{ 0x2CAF , 0x8138CF33},
{ 0x2CB0 , 0x8138CF34},
{ 0x2CB1 , 0x8138CF35},
{ 0x2CB2 , 0x8138CF36},
{ 0x2CB3 , 0x8138CF37},
{ 0x2CB4 , 0x8138CF38},
{ 0x2CB5 , 0x8138CF39},
{ 0x2CB6 , 0x8138D030},
{ 0x2CB7 , 0x8138D031},
{ 0x2CB8 , 0x8138D032},
{ 0x2CB9 , 0x8138D033},
{ 0x2CBA , 0x8138D034},
{ 0x2CBB , 0x8138D035},
{ 0x2CBC , 0x8138D036},
{ 0x2CBD , 0x8138D037},
{ 0x2CBE , 0x8138D038},
{ 0x2CBF , 0x8138D039},
{ 0x2CC0 , 0x8138D130},
{ 0x2CC1 , 0x8138D131},
{ 0x2CC2 , 0x8138D132},
{ 0x2CC3 , 0x8138D133},
{ 0x2CC4 , 0x8138D134},
{ 0x2CC5 , 0x8138D135},
{ 0x2CC6 , 0x8138D136},
{ 0x2CC7 , 0x8138D137},
{ 0x2CC8 , 0x8138D138},
{ 0x2CC9 , 0x8138D139},
{ 0x2CCA , 0x8138D230},
{ 0x2CCB , 0x8138D231},
{ 0x2CCC , 0x8138D232},
{ 0x2CCD , 0x8138D233},
{ 0x2CCE , 0x8138D234},
{ 0x2CCF , 0x8138D235},
{ 0x2CD0 , 0x8138D236},
{ 0x2CD1 , 0x8138D237},
{ 0x2CD2 , 0x8138D238},
{ 0x2CD3 , 0x8138D239},
{ 0x2CD4 , 0x8138D330},
{ 0x2CD5 , 0x8138D331},
{ 0x2CD6 , 0x8138D332},
{ 0x2CD7 , 0x8138D333},
{ 0x2CD8 , 0x8138D334},
{ 0x2CD9 , 0x8138D335},
{ 0x2CDA , 0x8138D336},
{ 0x2CDB , 0x8138D337},
{ 0x2CDC , 0x8138D338},
{ 0x2CDD , 0x8138D339},
{ 0x2CDE , 0x8138D430},
{ 0x2CDF , 0x8138D431},
{ 0x2CE0 , 0x8138D432},
{ 0x2CE1 , 0x8138D433},
{ 0x2CE2 , 0x8138D434},
{ 0x2CE3 , 0x8138D435},
{ 0x2CE4 , 0x8138D436},
{ 0x2CE5 , 0x8138D437},
{ 0x2CE6 , 0x8138D438},
{ 0x2CE7 , 0x8138D439},
{ 0x2CE8 , 0x8138D530},
{ 0x2CE9 , 0x8138D531},
{ 0x2CEA , 0x8138D532},
{ 0x2CEB , 0x8138D533},
{ 0x2CEC , 0x8138D534},
{ 0x2CED , 0x8138D535},
{ 0x2CEE , 0x8138D536},
{ 0x2CEF , 0x8138D537},
{ 0x2CF0 , 0x8138D538},
{ 0x2CF1 , 0x8138D539},
{ 0x2CF2 , 0x8138D630},
{ 0x2CF3 , 0x8138D631},
{ 0x2CF4 , 0x8138D632},
{ 0x2CF5 , 0x8138D633},
{ 0x2CF6 , 0x8138D634},
{ 0x2CF7 , 0x8138D635},
{ 0x2CF8 , 0x8138D636},
{ 0x2CF9 , 0x8138D637},
{ 0x2CFA , 0x8138D638},
{ 0x2CFB , 0x8138D639},
{ 0x2CFC , 0x8138D730},
{ 0x2CFD , 0x8138D731},
{ 0x2CFE , 0x8138D732},
{ 0x2CFF , 0x8138D733},
{ 0x2D00 , 0x8138D734},
{ 0x2D01 , 0x8138D735},
{ 0x2D02 , 0x8138D736},
{ 0x2D03 , 0x8138D737},
{ 0x2D04 , 0x8138D738},
{ 0x2D05 , 0x8138D739},
{ 0x2D06 , 0x8138D830},
{ 0x2D07 , 0x8138D831},
{ 0x2D08 , 0x8138D832},
{ 0x2D09 , 0x8138D833},
{ 0x2D0A , 0x8138D834},
{ 0x2D0B , 0x8138D835},
{ 0x2D0C , 0x8138D836},
{ 0x2D0D , 0x8138D837},
{ 0x2D0E , 0x8138D838},
{ 0x2D0F , 0x8138D839},
{ 0x2D10 , 0x8138D930},
{ 0x2D11 , 0x8138D931},
{ 0x2D12 , 0x8138D932},
{ 0x2D13 , 0x8138D933},
{ 0x2D14 , 0x8138D934},
{ 0x2D15 , 0x8138D935},
{ 0x2D16 , 0x8138D936},
{ 0x2D17 , 0x8138D937},
{ 0x2D18 , 0x8138D938},
{ 0x2D19 , 0x8138D939},
{ 0x2D1A , 0x8138DA30},
{ 0x2D1B , 0x8138DA31},
{ 0x2D1C , 0x8138DA32},
{ 0x2D1D , 0x8138DA33},
{ 0x2D1E , 0x8138DA34},
{ 0x2D1F , 0x8138DA35},
{ 0x2D20 , 0x8138DA36},
{ 0x2D21 , 0x8138DA37},
{ 0x2D22 , 0x8138DA38},
{ 0x2D23 , 0x8138DA39},
{ 0x2D24 , 0x8138DB30},
{ 0x2D25 , 0x8138DB31},
{ 0x2D26 , 0x8138DB32},
{ 0x2D27 , 0x8138DB33},
{ 0x2D28 , 0x8138DB34},
{ 0x2D29 , 0x8138DB35},
{ 0x2D2A , 0x8138DB36},
{ 0x2D2B , 0x8138DB37},
{ 0x2D2C , 0x8138DB38},
{ 0x2D2D , 0x8138DB39},
{ 0x2D2E , 0x8138DC30},
{ 0x2D2F , 0x8138DC31},
{ 0x2D30 , 0x8138DC32},
{ 0x2D31 , 0x8138DC33},
{ 0x2D32 , 0x8138DC34},
{ 0x2D33 , 0x8138DC35},
{ 0x2D34 , 0x8138DC36},
{ 0x2D35 , 0x8138DC37},
{ 0x2D36 , 0x8138DC38},
{ 0x2D37 , 0x8138DC39},
{ 0x2D38 , 0x8138DD30},
{ 0x2D39 , 0x8138DD31},
{ 0x2D3A , 0x8138DD32},
{ 0x2D3B , 0x8138DD33},
{ 0x2D3C , 0x8138DD34},
{ 0x2D3D , 0x8138DD35},
{ 0x2D3E , 0x8138DD36},
{ 0x2D3F , 0x8138DD37},
{ 0x2D40 , 0x8138DD38},
{ 0x2D41 , 0x8138DD39},
{ 0x2D42 , 0x8138DE30},
{ 0x2D43 , 0x8138DE31},
{ 0x2D44 , 0x8138DE32},
{ 0x2D45 , 0x8138DE33},
{ 0x2D46 , 0x8138DE34},
{ 0x2D47 , 0x8138DE35},
{ 0x2D48 , 0x8138DE36},
{ 0x2D49 , 0x8138DE37},
{ 0x2D4A , 0x8138DE38},
{ 0x2D4B , 0x8138DE39},
{ 0x2D4C , 0x8138DF30},
{ 0x2D4D , 0x8138DF31},
{ 0x2D4E , 0x8138DF32},
{ 0x2D4F , 0x8138DF33},
{ 0x2D50 , 0x8138DF34},
{ 0x2D51 , 0x8138DF35},
{ 0x2D52 , 0x8138DF36},
{ 0x2D53 , 0x8138DF37},
{ 0x2D54 , 0x8138DF38},
{ 0x2D55 , 0x8138DF39},
{ 0x2D56 , 0x8138E030},
{ 0x2D57 , 0x8138E031},
{ 0x2D58 , 0x8138E032},
{ 0x2D59 , 0x8138E033},
{ 0x2D5A , 0x8138E034},
{ 0x2D5B , 0x8138E035},
{ 0x2D5C , 0x8138E036},
{ 0x2D5D , 0x8138E037},
{ 0x2D5E , 0x8138E038},
{ 0x2D5F , 0x8138E039},
{ 0x2D60 , 0x8138E130},
{ 0x2D61 , 0x8138E131},
{ 0x2D62 , 0x8138E132},
{ 0x2D63 , 0x8138E133},
{ 0x2D64 , 0x8138E134},
{ 0x2D65 , 0x8138E135},
{ 0x2D66 , 0x8138E136},
{ 0x2D67 , 0x8138E137},
{ 0x2D68 , 0x8138E138},
{ 0x2D69 , 0x8138E139},
{ 0x2D6A , 0x8138E230},
{ 0x2D6B , 0x8138E231},
{ 0x2D6C , 0x8138E232},
{ 0x2D6D , 0x8138E233},
{ 0x2D6E , 0x8138E234},
{ 0x2D6F , 0x8138E235},
{ 0x2D70 , 0x8138E236},
{ 0x2D71 , 0x8138E237},
{ 0x2D72 , 0x8138E238},
{ 0x2D73 , 0x8138E239},
{ 0x2D74 , 0x8138E330},
{ 0x2D75 , 0x8138E331},
{ 0x2D76 , 0x8138E332},
{ 0x2D77 , 0x8138E333},
{ 0x2D78 , 0x8138E334},
{ 0x2D79 , 0x8138E335},
{ 0x2D7A , 0x8138E336},
{ 0x2D7B , 0x8138E337},
{ 0x2D7C , 0x8138E338},
{ 0x2D7D , 0x8138E339},
{ 0x2D7E , 0x8138E430},
{ 0x2D7F , 0x8138E431},
{ 0x2D80 , 0x8138E432},
{ 0x2D81 , 0x8138E433},
{ 0x2D82 , 0x8138E434},
{ 0x2D83 , 0x8138E435},
{ 0x2D84 , 0x8138E436},
{ 0x2D85 , 0x8138E437},
{ 0x2D86 , 0x8138E438},
{ 0x2D87 , 0x8138E439},
{ 0x2D88 , 0x8138E530},
{ 0x2D89 , 0x8138E531},
{ 0x2D8A , 0x8138E532},
{ 0x2D8B , 0x8138E533},
{ 0x2D8C , 0x8138E534},
{ 0x2D8D , 0x8138E535},
{ 0x2D8E , 0x8138E536},
{ 0x2D8F , 0x8138E537},
{ 0x2D90 , 0x8138E538},
{ 0x2D91 , 0x8138E539},
{ 0x2D92 , 0x8138E630},
{ 0x2D93 , 0x8138E631},
{ 0x2D94 , 0x8138E632},
{ 0x2D95 , 0x8138E633},
{ 0x2D96 , 0x8138E634},
{ 0x2D97 , 0x8138E635},
{ 0x2D98 , 0x8138E636},
{ 0x2D99 , 0x8138E637},
{ 0x2D9A , 0x8138E638},
{ 0x2D9B , 0x8138E639},
{ 0x2D9C , 0x8138E730},
{ 0x2D9D , 0x8138E731},
{ 0x2D9E , 0x8138E732},
{ 0x2D9F , 0x8138E733},
{ 0x2DA0 , 0x8138E734},
{ 0x2DA1 , 0x8138E735},
{ 0x2DA2 , 0x8138E736},
{ 0x2DA3 , 0x8138E737},
{ 0x2DA4 , 0x8138E738},
{ 0x2DA5 , 0x8138E739},
{ 0x2DA6 , 0x8138E830},
{ 0x2DA7 , 0x8138E831},
{ 0x2DA8 , 0x8138E832},
{ 0x2DA9 , 0x8138E833},
{ 0x2DAA , 0x8138E834},
{ 0x2DAB , 0x8138E835},
{ 0x2DAC , 0x8138E836},
{ 0x2DAD , 0x8138E837},
{ 0x2DAE , 0x8138E838},
{ 0x2DAF , 0x8138E839},
{ 0x2DB0 , 0x8138E930},
{ 0x2DB1 , 0x8138E931},
{ 0x2DB2 , 0x8138E932},
{ 0x2DB3 , 0x8138E933},
{ 0x2DB4 , 0x8138E934},
{ 0x2DB5 , 0x8138E935},
{ 0x2DB6 , 0x8138E936},
{ 0x2DB7 , 0x8138E937},
{ 0x2DB8 , 0x8138E938},
{ 0x2DB9 , 0x8138E939},
{ 0x2DBA , 0x8138EA30},
{ 0x2DBB , 0x8138EA31},
{ 0x2DBC , 0x8138EA32},
{ 0x2DBD , 0x8138EA33},
{ 0x2DBE , 0x8138EA34},
{ 0x2DBF , 0x8138EA35},
{ 0x2DC0 , 0x8138EA36},
{ 0x2DC1 , 0x8138EA37},
{ 0x2DC2 , 0x8138EA38},
{ 0x2DC3 , 0x8138EA39},
{ 0x2DC4 , 0x8138EB30},
{ 0x2DC5 , 0x8138EB31},
{ 0x2DC6 , 0x8138EB32},
{ 0x2DC7 , 0x8138EB33},
{ 0x2DC8 , 0x8138EB34},
{ 0x2DC9 , 0x8138EB35},
{ 0x2DCA , 0x8138EB36},
{ 0x2DCB , 0x8138EB37},
{ 0x2DCC , 0x8138EB38},
{ 0x2DCD , 0x8138EB39},
{ 0x2DCE , 0x8138EC30},
{ 0x2DCF , 0x8138EC31},
{ 0x2DD0 , 0x8138EC32},
{ 0x2DD1 , 0x8138EC33},
{ 0x2DD2 , 0x8138EC34},
{ 0x2DD3 , 0x8138EC35},
{ 0x2DD4 , 0x8138EC36},
{ 0x2DD5 , 0x8138EC37},
{ 0x2DD6 , 0x8138EC38},
{ 0x2DD7 , 0x8138EC39},
{ 0x2DD8 , 0x8138ED30},
{ 0x2DD9 , 0x8138ED31},
{ 0x2DDA , 0x8138ED32},
{ 0x2DDB , 0x8138ED33},
{ 0x2DDC , 0x8138ED34},
{ 0x2DDD , 0x8138ED35},
{ 0x2DDE , 0x8138ED36},
{ 0x2DDF , 0x8138ED37},
{ 0x2DE0 , 0x8138ED38},
{ 0x2DE1 , 0x8138ED39},
{ 0x2DE2 , 0x8138EE30},
{ 0x2DE3 , 0x8138EE31},
{ 0x2DE4 , 0x8138EE32},
{ 0x2DE5 , 0x8138EE33},
{ 0x2DE6 , 0x8138EE34},
{ 0x2DE7 , 0x8138EE35},
{ 0x2DE8 , 0x8138EE36},
{ 0x2DE9 , 0x8138EE37},
{ 0x2DEA , 0x8138EE38},
{ 0x2DEB , 0x8138EE39},
{ 0x2DEC , 0x8138EF30},
{ 0x2DED , 0x8138EF31},
{ 0x2DEE , 0x8138EF32},
{ 0x2DEF , 0x8138EF33},
{ 0x2DF0 , 0x8138EF34},
{ 0x2DF1 , 0x8138EF35},
{ 0x2DF2 , 0x8138EF36},
{ 0x2DF3 , 0x8138EF37},
{ 0x2DF4 , 0x8138EF38},
{ 0x2DF5 , 0x8138EF39},
{ 0x2DF6 , 0x8138F030},
{ 0x2DF7 , 0x8138F031},
{ 0x2DF8 , 0x8138F032},
{ 0x2DF9 , 0x8138F033},
{ 0x2DFA , 0x8138F034},
{ 0x2DFB , 0x8138F035},
{ 0x2DFC , 0x8138F036},
{ 0x2DFD , 0x8138F037},
{ 0x2DFE , 0x8138F038},
{ 0x2DFF , 0x8138F039},
{ 0x2E00 , 0x8138F130},
{ 0x2E01 , 0x8138F131},
{ 0x2E02 , 0x8138F132},
{ 0x2E03 , 0x8138F133},
{ 0x2E04 , 0x8138F134},
{ 0x2E05 , 0x8138F135},
{ 0x2E06 , 0x8138F136},
{ 0x2E07 , 0x8138F137},
{ 0x2E08 , 0x8138F138},
{ 0x2E09 , 0x8138F139},
{ 0x2E0A , 0x8138F230},
{ 0x2E0B , 0x8138F231},
{ 0x2E0C , 0x8138F232},
{ 0x2E0D , 0x8138F233},
{ 0x2E0E , 0x8138F234},
{ 0x2E0F , 0x8138F235},
{ 0x2E10 , 0x8138F236},
{ 0x2E11 , 0x8138F237},
{ 0x2E12 , 0x8138F238},
{ 0x2E13 , 0x8138F239},
{ 0x2E14 , 0x8138F330},
{ 0x2E15 , 0x8138F331},
{ 0x2E16 , 0x8138F332},
{ 0x2E17 , 0x8138F333},
{ 0x2E18 , 0x8138F334},
{ 0x2E19 , 0x8138F335},
{ 0x2E1A , 0x8138F336},
{ 0x2E1B , 0x8138F337},
{ 0x2E1C , 0x8138F338},
{ 0x2E1D , 0x8138F339},
{ 0x2E1E , 0x8138F430},
{ 0x2E1F , 0x8138F431},
{ 0x2E20 , 0x8138F432},
{ 0x2E21 , 0x8138F433},
{ 0x2E22 , 0x8138F434},
{ 0x2E23 , 0x8138F435},
{ 0x2E24 , 0x8138F436},
{ 0x2E25 , 0x8138F437},
{ 0x2E26 , 0x8138F438},
{ 0x2E27 , 0x8138F439},
{ 0x2E28 , 0x8138F530},
{ 0x2E29 , 0x8138F531},
{ 0x2E2A , 0x8138F532},
{ 0x2E2B , 0x8138F533},
{ 0x2E2C , 0x8138F534},
{ 0x2E2D , 0x8138F535},
{ 0x2E2E , 0x8138F536},
{ 0x2E2F , 0x8138F537},
{ 0x2E30 , 0x8138F538},
{ 0x2E31 , 0x8138F539},
{ 0x2E32 , 0x8138F630},
{ 0x2E33 , 0x8138F631},
{ 0x2E34 , 0x8138F632},
{ 0x2E35 , 0x8138F633},
{ 0x2E36 , 0x8138F634},
{ 0x2E37 , 0x8138F635},
{ 0x2E38 , 0x8138F636},
{ 0x2E39 , 0x8138F637},
{ 0x2E3A , 0x8138F638},
{ 0x2E3B , 0x8138F639},
{ 0x2E3C , 0x8138F730},
{ 0x2E3D , 0x8138F731},
{ 0x2E3E , 0x8138F732},
{ 0x2E3F , 0x8138F733},
{ 0x2E40 , 0x8138F734},
{ 0x2E41 , 0x8138F735},
{ 0x2E42 , 0x8138F736},
{ 0x2E43 , 0x8138F737},
{ 0x2E44 , 0x8138F738},
{ 0x2E45 , 0x8138F739},
{ 0x2E46 , 0x8138F830},
{ 0x2E47 , 0x8138F831},
{ 0x2E48 , 0x8138F832},
{ 0x2E49 , 0x8138F833},
{ 0x2E4A , 0x8138F834},
{ 0x2E4B , 0x8138F835},
{ 0x2E4C , 0x8138F836},
{ 0x2E4D , 0x8138F837},
{ 0x2E4E , 0x8138F838},
{ 0x2E4F , 0x8138F839},
{ 0x2E50 , 0x8138F930},
{ 0x2E51 , 0x8138F931},
{ 0x2E52 , 0x8138F932},
{ 0x2E53 , 0x8138F933},
{ 0x2E54 , 0x8138F934},
{ 0x2E55 , 0x8138F935},
{ 0x2E56 , 0x8138F936},
{ 0x2E57 , 0x8138F937},
{ 0x2E58 , 0x8138F938},
{ 0x2E59 , 0x8138F939},
{ 0x2E5A , 0x8138FA30},
{ 0x2E5B , 0x8138FA31},
{ 0x2E5C , 0x8138FA32},
{ 0x2E5D , 0x8138FA33},
{ 0x2E5E , 0x8138FA34},
{ 0x2E5F , 0x8138FA35},
{ 0x2E60 , 0x8138FA36},
{ 0x2E61 , 0x8138FA37},
{ 0x2E62 , 0x8138FA38},
{ 0x2E63 , 0x8138FA39},
{ 0x2E64 , 0x8138FB30},
{ 0x2E65 , 0x8138FB31},
{ 0x2E66 , 0x8138FB32},
{ 0x2E67 , 0x8138FB33},
{ 0x2E68 , 0x8138FB34},
{ 0x2E69 , 0x8138FB35},
{ 0x2E6A , 0x8138FB36},
{ 0x2E6B , 0x8138FB37},
{ 0x2E6C , 0x8138FB38},
{ 0x2E6D , 0x8138FB39},
{ 0x2E6E , 0x8138FC30},
{ 0x2E6F , 0x8138FC31},
{ 0x2E70 , 0x8138FC32},
{ 0x2E71 , 0x8138FC33},
{ 0x2E72 , 0x8138FC34},
{ 0x2E73 , 0x8138FC35},
{ 0x2E74 , 0x8138FC36},
{ 0x2E75 , 0x8138FC37},
{ 0x2E76 , 0x8138FC38},
{ 0x2E77 , 0x8138FC39},
{ 0x2E78 , 0x8138FD30},
{ 0x2E79 , 0x8138FD31},
{ 0x2E7A , 0x8138FD32},
{ 0x2E7B , 0x8138FD33},
{ 0x2E7C , 0x8138FD34},
{ 0x2E7D , 0x8138FD35},
{ 0x2E7E , 0x8138FD36},
{ 0x2E7F , 0x8138FD37},
{ 0x2E80 , 0x8138FD38},
{ 0x2E82 , 0x8138FD39},
{ 0x2E83 , 0x8138FE30},
{ 0x2E85 , 0x8138FE31},
{ 0x2E86 , 0x8138FE32},
{ 0x2E87 , 0x8138FE33},
{ 0x2E89 , 0x8138FE34},
{ 0x2E8A , 0x8138FE35},
{ 0x2E8D , 0x8138FE36},
{ 0x2E8E , 0x8138FE37},
{ 0x2E8F , 0x8138FE38},
{ 0x2E90 , 0x8138FE39},
{ 0x2E91 , 0x81398130},
{ 0x2E92 , 0x81398131},
{ 0x2E93 , 0x81398132},
{ 0x2E94 , 0x81398133},
{ 0x2E95 , 0x81398134},
{ 0x2E96 , 0x81398135},
{ 0x2E98 , 0x81398136},
{ 0x2E99 , 0x81398137},
{ 0x2E9A , 0x81398138},
{ 0x2E9B , 0x81398139},
{ 0x2E9C , 0x81398230},
{ 0x2E9D , 0x81398231},
{ 0x2E9E , 0x81398232},
{ 0x2E9F , 0x81398233},
{ 0x2EA0 , 0x81398234},
{ 0x2EA1 , 0x81398235},
{ 0x2EA2 , 0x81398236},
{ 0x2EA3 , 0x81398237},
{ 0x2EA4 , 0x81398238},
{ 0x2EA5 , 0x81398239},
{ 0x2EA6 , 0x81398330},
{ 0x2EA8 , 0x81398331},
{ 0x2EA9 , 0x81398332},
{ 0x2EAB , 0x81398333},
{ 0x2EAC , 0x81398334},
{ 0x2EAD , 0x81398335},
{ 0x2EAF , 0x81398336},
{ 0x2EB0 , 0x81398337},
{ 0x2EB1 , 0x81398338},
{ 0x2EB2 , 0x81398339},
{ 0x2EB4 , 0x81398430},
{ 0x2EB5 , 0x81398431},
{ 0x2EB8 , 0x81398432},
{ 0x2EB9 , 0x81398433},
{ 0x2EBA , 0x81398434},
{ 0x2EBC , 0x81398435},
{ 0x2EBD , 0x81398436},
{ 0x2EBE , 0x81398437},
{ 0x2EBF , 0x81398438},
{ 0x2EC0 , 0x81398439},
{ 0x2EC1 , 0x81398530},
{ 0x2EC2 , 0x81398531},
{ 0x2EC3 , 0x81398532},
{ 0x2EC4 , 0x81398533},
{ 0x2EC5 , 0x81398534},
{ 0x2EC6 , 0x81398535},
{ 0x2EC7 , 0x81398536},
{ 0x2EC8 , 0x81398537},
{ 0x2EC9 , 0x81398538},
{ 0x2ECB , 0x81398539},
{ 0x2ECC , 0x81398630},
{ 0x2ECD , 0x81398631},
{ 0x2ECE , 0x81398632},
{ 0x2ECF , 0x81398633},
{ 0x2ED0 , 0x81398634},
{ 0x2ED1 , 0x81398635},
{ 0x2ED2 , 0x81398636},
{ 0x2ED3 , 0x81398637},
{ 0x2ED4 , 0x81398638},
{ 0x2ED5 , 0x81398639},
{ 0x2ED6 , 0x81398730},
{ 0x2ED7 , 0x81398731},
{ 0x2ED8 , 0x81398732},
{ 0x2ED9 , 0x81398733},
{ 0x2EDA , 0x81398734},
{ 0x2EDB , 0x81398735},
{ 0x2EDC , 0x81398736},
{ 0x2EDD , 0x81398737},
{ 0x2EDE , 0x81398738},
{ 0x2EDF , 0x81398739},
{ 0x2EE0 , 0x81398830},
{ 0x2EE1 , 0x81398831},
{ 0x2EE2 , 0x81398832},
{ 0x2EE3 , 0x81398833},
{ 0x2EE4 , 0x81398834},
{ 0x2EE5 , 0x81398835},
{ 0x2EE6 , 0x81398836},
{ 0x2EE7 , 0x81398837},
{ 0x2EE8 , 0x81398838},
{ 0x2EE9 , 0x81398839},
{ 0x2EEA , 0x81398930},
{ 0x2EEB , 0x81398931},
{ 0x2EEC , 0x81398932},
{ 0x2EED , 0x81398933},
{ 0x2EEE , 0x81398934},
{ 0x2EEF , 0x81398935},
{ 0x2EF0 , 0x81398936},
{ 0x2EF1 , 0x81398937},
{ 0x2EF2 , 0x81398938},
{ 0x2EF3 , 0x81398939},
{ 0x2EF4 , 0x81398A30},
{ 0x2EF5 , 0x81398A31},
{ 0x2EF6 , 0x81398A32},
{ 0x2EF7 , 0x81398A33},
{ 0x2EF8 , 0x81398A34},
{ 0x2EF9 , 0x81398A35},
{ 0x2EFA , 0x81398A36},
{ 0x2EFB , 0x81398A37},
{ 0x2EFC , 0x81398A38},
{ 0x2EFD , 0x81398A39},
{ 0x2EFE , 0x81398B30},
{ 0x2EFF , 0x81398B31},
{ 0x2F00 , 0x81398B32},
{ 0x2F01 , 0x81398B33},
{ 0x2F02 , 0x81398B34},
{ 0x2F03 , 0x81398B35},
{ 0x2F04 , 0x81398B36},
{ 0x2F05 , 0x81398B37},
{ 0x2F06 , 0x81398B38},
{ 0x2F07 , 0x81398B39},
{ 0x2F08 , 0x81398C30},
{ 0x2F09 , 0x81398C31},
{ 0x2F0A , 0x81398C32},
{ 0x2F0B , 0x81398C33},
{ 0x2F0C , 0x81398C34},
{ 0x2F0D , 0x81398C35},
{ 0x2F0E , 0x81398C36},
{ 0x2F0F , 0x81398C37},
{ 0x2F10 , 0x81398C38},
{ 0x2F11 , 0x81398C39},
{ 0x2F12 , 0x81398D30},
{ 0x2F13 , 0x81398D31},
{ 0x2F14 , 0x81398D32},
{ 0x2F15 , 0x81398D33},
{ 0x2F16 , 0x81398D34},
{ 0x2F17 , 0x81398D35},
{ 0x2F18 , 0x81398D36},
{ 0x2F19 , 0x81398D37},
{ 0x2F1A , 0x81398D38},
{ 0x2F1B , 0x81398D39},
{ 0x2F1C , 0x81398E30},
{ 0x2F1D , 0x81398E31},
{ 0x2F1E , 0x81398E32},
{ 0x2F1F , 0x81398E33},
{ 0x2F20 , 0x81398E34},
{ 0x2F21 , 0x81398E35},
{ 0x2F22 , 0x81398E36},
{ 0x2F23 , 0x81398E37},
{ 0x2F24 , 0x81398E38},
{ 0x2F25 , 0x81398E39},
{ 0x2F26 , 0x81398F30},
{ 0x2F27 , 0x81398F31},
{ 0x2F28 , 0x81398F32},
{ 0x2F29 , 0x81398F33},
{ 0x2F2A , 0x81398F34},
{ 0x2F2B , 0x81398F35},
{ 0x2F2C , 0x81398F36},
{ 0x2F2D , 0x81398F37},
{ 0x2F2E , 0x81398F38},
{ 0x2F2F , 0x81398F39},
{ 0x2F30 , 0x81399030},
{ 0x2F31 , 0x81399031},
{ 0x2F32 , 0x81399032},
{ 0x2F33 , 0x81399033},
{ 0x2F34 , 0x81399034},
{ 0x2F35 , 0x81399035},
{ 0x2F36 , 0x81399036},
{ 0x2F37 , 0x81399037},
{ 0x2F38 , 0x81399038},
{ 0x2F39 , 0x81399039},
{ 0x2F3A , 0x81399130},
{ 0x2F3B , 0x81399131},
{ 0x2F3C , 0x81399132},
{ 0x2F3D , 0x81399133},
{ 0x2F3E , 0x81399134},
{ 0x2F3F , 0x81399135},
{ 0x2F40 , 0x81399136},
{ 0x2F41 , 0x81399137},
{ 0x2F42 , 0x81399138},
{ 0x2F43 , 0x81399139},
{ 0x2F44 , 0x81399230},
{ 0x2F45 , 0x81399231},
{ 0x2F46 , 0x81399232},
{ 0x2F47 , 0x81399233},
{ 0x2F48 , 0x81399234},
{ 0x2F49 , 0x81399235},
{ 0x2F4A , 0x81399236},
{ 0x2F4B , 0x81399237},
{ 0x2F4C , 0x81399238},
{ 0x2F4D , 0x81399239},
{ 0x2F4E , 0x81399330},
{ 0x2F4F , 0x81399331},
{ 0x2F50 , 0x81399332},
{ 0x2F51 , 0x81399333},
{ 0x2F52 , 0x81399334},
{ 0x2F53 , 0x81399335},
{ 0x2F54 , 0x81399336},
{ 0x2F55 , 0x81399337},
{ 0x2F56 , 0x81399338},
{ 0x2F57 , 0x81399339},
{ 0x2F58 , 0x81399430},
{ 0x2F59 , 0x81399431},
{ 0x2F5A , 0x81399432},
{ 0x2F5B , 0x81399433},
{ 0x2F5C , 0x81399434},
{ 0x2F5D , 0x81399435},
{ 0x2F5E , 0x81399436},
{ 0x2F5F , 0x81399437},
{ 0x2F60 , 0x81399438},
{ 0x2F61 , 0x81399439},
{ 0x2F62 , 0x81399530},
{ 0x2F63 , 0x81399531},
{ 0x2F64 , 0x81399532},
{ 0x2F65 , 0x81399533},
{ 0x2F66 , 0x81399534},
{ 0x2F67 , 0x81399535},
{ 0x2F68 , 0x81399536},
{ 0x2F69 , 0x81399537},
{ 0x2F6A , 0x81399538},
{ 0x2F6B , 0x81399539},
{ 0x2F6C , 0x81399630},
{ 0x2F6D , 0x81399631},
{ 0x2F6E , 0x81399632},
{ 0x2F6F , 0x81399633},
{ 0x2F70 , 0x81399634},
{ 0x2F71 , 0x81399635},
{ 0x2F72 , 0x81399636},
{ 0x2F73 , 0x81399637},
{ 0x2F74 , 0x81399638},
{ 0x2F75 , 0x81399639},
{ 0x2F76 , 0x81399730},
{ 0x2F77 , 0x81399731},
{ 0x2F78 , 0x81399732},
{ 0x2F79 , 0x81399733},
{ 0x2F7A , 0x81399734},
{ 0x2F7B , 0x81399735},
{ 0x2F7C , 0x81399736},
{ 0x2F7D , 0x81399737},
{ 0x2F7E , 0x81399738},
{ 0x2F7F , 0x81399739},
{ 0x2F80 , 0x81399830},
{ 0x2F81 , 0x81399831},
{ 0x2F82 , 0x81399832},
{ 0x2F83 , 0x81399833},
{ 0x2F84 , 0x81399834},
{ 0x2F85 , 0x81399835},
{ 0x2F86 , 0x81399836},
{ 0x2F87 , 0x81399837},
{ 0x2F88 , 0x81399838},
{ 0x2F89 , 0x81399839},
{ 0x2F8A , 0x81399930},
{ 0x2F8B , 0x81399931},
{ 0x2F8C , 0x81399932},
{ 0x2F8D , 0x81399933},
{ 0x2F8E , 0x81399934},
{ 0x2F8F , 0x81399935},
{ 0x2F90 , 0x81399936},
{ 0x2F91 , 0x81399937},
{ 0x2F92 , 0x81399938},
{ 0x2F93 , 0x81399939},
{ 0x2F94 , 0x81399A30},
{ 0x2F95 , 0x81399A31},
{ 0x2F96 , 0x81399A32},
{ 0x2F97 , 0x81399A33},
{ 0x2F98 , 0x81399A34},
{ 0x2F99 , 0x81399A35},
{ 0x2F9A , 0x81399A36},
{ 0x2F9B , 0x81399A37},
{ 0x2F9C , 0x81399A38},
{ 0x2F9D , 0x81399A39},
{ 0x2F9E , 0x81399B30},
{ 0x2F9F , 0x81399B31},
{ 0x2FA0 , 0x81399B32},
{ 0x2FA1 , 0x81399B33},
{ 0x2FA2 , 0x81399B34},
{ 0x2FA3 , 0x81399B35},
{ 0x2FA4 , 0x81399B36},
{ 0x2FA5 , 0x81399B37},
{ 0x2FA6 , 0x81399B38},
{ 0x2FA7 , 0x81399B39},
{ 0x2FA8 , 0x81399C30},
{ 0x2FA9 , 0x81399C31},
{ 0x2FAA , 0x81399C32},
{ 0x2FAB , 0x81399C33},
{ 0x2FAC , 0x81399C34},
{ 0x2FAD , 0x81399C35},
{ 0x2FAE , 0x81399C36},
{ 0x2FAF , 0x81399C37},
{ 0x2FB0 , 0x81399C38},
{ 0x2FB1 , 0x81399C39},
{ 0x2FB2 , 0x81399D30},
{ 0x2FB3 , 0x81399D31},
{ 0x2FB4 , 0x81399D32},
{ 0x2FB5 , 0x81399D33},
{ 0x2FB6 , 0x81399D34},
{ 0x2FB7 , 0x81399D35},
{ 0x2FB8 , 0x81399D36},
{ 0x2FB9 , 0x81399D37},
{ 0x2FBA , 0x81399D38},
{ 0x2FBB , 0x81399D39},
{ 0x2FBC , 0x81399E30},
{ 0x2FBD , 0x81399E31},
{ 0x2FBE , 0x81399E32},
{ 0x2FBF , 0x81399E33},
{ 0x2FC0 , 0x81399E34},
{ 0x2FC1 , 0x81399E35},
{ 0x2FC2 , 0x81399E36},
{ 0x2FC3 , 0x81399E37},
{ 0x2FC4 , 0x81399E38},
{ 0x2FC5 , 0x81399E39},
{ 0x2FC6 , 0x81399F30},
{ 0x2FC7 , 0x81399F31},
{ 0x2FC8 , 0x81399F32},
{ 0x2FC9 , 0x81399F33},
{ 0x2FCA , 0x81399F34},
{ 0x2FCB , 0x81399F35},
{ 0x2FCC , 0x81399F36},
{ 0x2FCD , 0x81399F37},
{ 0x2FCE , 0x81399F38},
{ 0x2FCF , 0x81399F39},
{ 0x2FD0 , 0x8139A030},
{ 0x2FD1 , 0x8139A031},
{ 0x2FD2 , 0x8139A032},
{ 0x2FD3 , 0x8139A033},
{ 0x2FD4 , 0x8139A034},
{ 0x2FD5 , 0x8139A035},
{ 0x2FD6 , 0x8139A036},
{ 0x2FD7 , 0x8139A037},
{ 0x2FD8 , 0x8139A038},
{ 0x2FD9 , 0x8139A039},
{ 0x2FDA , 0x8139A130},
{ 0x2FDB , 0x8139A131},
{ 0x2FDC , 0x8139A132},
{ 0x2FDD , 0x8139A133},
{ 0x2FDE , 0x8139A134},
{ 0x2FDF , 0x8139A135},
{ 0x2FE0 , 0x8139A136},
{ 0x2FE1 , 0x8139A137},
{ 0x2FE2 , 0x8139A138},
{ 0x2FE3 , 0x8139A139},
{ 0x2FE4 , 0x8139A230},
{ 0x2FE5 , 0x8139A231},
{ 0x2FE6 , 0x8139A232},
{ 0x2FE7 , 0x8139A233},
{ 0x2FE8 , 0x8139A234},
{ 0x2FE9 , 0x8139A235},
{ 0x2FEA , 0x8139A236},
{ 0x2FEB , 0x8139A237},
{ 0x2FEC , 0x8139A238},
{ 0x2FED , 0x8139A239},
{ 0x2FEE , 0x8139A330},
{ 0x2FEF , 0x8139A331},
{ 0x2FFC , 0x8139A332},
{ 0x2FFD , 0x8139A333},
{ 0x2FFE , 0x8139A334},
{ 0x2FFF , 0x8139A335},
{ 0x3004 , 0x8139A336},
{ 0x3018 , 0x8139A337},
{ 0x3019 , 0x8139A338},
{ 0x301A , 0x8139A339},
{ 0x301B , 0x8139A430},
{ 0x301C , 0x8139A431},
{ 0x301F , 0x8139A432},
{ 0x3020 , 0x8139A433},
{ 0x302A , 0x8139A434},
{ 0x302B , 0x8139A435},
{ 0x302C , 0x8139A436},
{ 0x302D , 0x8139A437},
{ 0x302E , 0x8139A438},
{ 0x302F , 0x8139A439},
{ 0x3030 , 0x8139A530},
{ 0x3031 , 0x8139A531},
{ 0x3032 , 0x8139A532},
{ 0x3033 , 0x8139A533},
{ 0x3034 , 0x8139A534},
{ 0x3035 , 0x8139A535},
{ 0x3036 , 0x8139A536},
{ 0x3037 , 0x8139A537},
{ 0x3038 , 0x8139A538},
{ 0x3039 , 0x8139A539},
{ 0x303A , 0x8139A630},
{ 0x303B , 0x8139A631},
{ 0x303C , 0x8139A632},
{ 0x303D , 0x8139A633},
{ 0x303F , 0x8139A634},
{ 0x3040 , 0x8139A635},
{ 0x3094 , 0x8139A636},
{ 0x3095 , 0x8139A637},
{ 0x3096 , 0x8139A638},
{ 0x3097 , 0x8139A639},
{ 0x3098 , 0x8139A730},
{ 0x3099 , 0x8139A731},
{ 0x309A , 0x8139A732},
{ 0x309F , 0x8139A733},
{ 0x30A0 , 0x8139A734},
{ 0x30F7 , 0x8139A735},
{ 0x30F8 , 0x8139A736},
{ 0x30F9 , 0x8139A737},
{ 0x30FA , 0x8139A738},
{ 0x30FB , 0x8139A739},
{ 0x30FF , 0x8139A830},
{ 0x3100 , 0x8139A831},
{ 0x3101 , 0x8139A832},
{ 0x3102 , 0x8139A833},
{ 0x3103 , 0x8139A834},
{ 0x3104 , 0x8139A835},
{ 0x312A , 0x8139A836},
{ 0x312B , 0x8139A837},
{ 0x312C , 0x8139A838},
{ 0x312D , 0x8139A839},
{ 0x312E , 0x8139A930},
{ 0x312F , 0x8139A931},
{ 0x3130 , 0x8139A932},
{ 0x3131 , 0x8139A933},
{ 0x3132 , 0x8139A934},
{ 0x3133 , 0x8139A935},
{ 0x3134 , 0x8139A936},
{ 0x3135 , 0x8139A937},
{ 0x3136 , 0x8139A938},
{ 0x3137 , 0x8139A939},
{ 0x3138 , 0x8139AA30},
{ 0x3139 , 0x8139AA31},
{ 0x313A , 0x8139AA32},
{ 0x313B , 0x8139AA33},
{ 0x313C , 0x8139AA34},
{ 0x313D , 0x8139AA35},
{ 0x313E , 0x8139AA36},
{ 0x313F , 0x8139AA37},
{ 0x3140 , 0x8139AA38},
{ 0x3141 , 0x8139AA39},
{ 0x3142 , 0x8139AB30},
{ 0x3143 , 0x8139AB31},
{ 0x3144 , 0x8139AB32},
{ 0x3145 , 0x8139AB33},
{ 0x3146 , 0x8139AB34},
{ 0x3147 , 0x8139AB35},
{ 0x3148 , 0x8139AB36},
{ 0x3149 , 0x8139AB37},
{ 0x314A , 0x8139AB38},
{ 0x314B , 0x8139AB39},
{ 0x314C , 0x8139AC30},
{ 0x314D , 0x8139AC31},
{ 0x314E , 0x8139AC32},
{ 0x314F , 0x8139AC33},
{ 0x3150 , 0x8139AC34},
{ 0x3151 , 0x8139AC35},
{ 0x3152 , 0x8139AC36},
{ 0x3153 , 0x8139AC37},
{ 0x3154 , 0x8139AC38},
{ 0x3155 , 0x8139AC39},
{ 0x3156 , 0x8139AD30},
{ 0x3157 , 0x8139AD31},
{ 0x3158 , 0x8139AD32},
{ 0x3159 , 0x8139AD33},
{ 0x315A , 0x8139AD34},
{ 0x315B , 0x8139AD35},
{ 0x315C , 0x8139AD36},
{ 0x315D , 0x8139AD37},
{ 0x315E , 0x8139AD38},
{ 0x315F , 0x8139AD39},
{ 0x3160 , 0x8139AE30},
{ 0x3161 , 0x8139AE31},
{ 0x3162 , 0x8139AE32},
{ 0x3163 , 0x8139AE33},
{ 0x3164 , 0x8139AE34},
{ 0x3165 , 0x8139AE35},
{ 0x3166 , 0x8139AE36},
{ 0x3167 , 0x8139AE37},
{ 0x3168 , 0x8139AE38},
{ 0x3169 , 0x8139AE39},
{ 0x316A , 0x8139AF30},
{ 0x316B , 0x8139AF31},
{ 0x316C , 0x8139AF32},
{ 0x316D , 0x8139AF33},
{ 0x316E , 0x8139AF34},
{ 0x316F , 0x8139AF35},
{ 0x3170 , 0x8139AF36},
{ 0x3171 , 0x8139AF37},
{ 0x3172 , 0x8139AF38},
{ 0x3173 , 0x8139AF39},
{ 0x3174 , 0x8139B030},
{ 0x3175 , 0x8139B031},
{ 0x3176 , 0x8139B032},
{ 0x3177 , 0x8139B033},
{ 0x3178 , 0x8139B034},
{ 0x3179 , 0x8139B035},
{ 0x317A , 0x8139B036},
{ 0x317B , 0x8139B037},
{ 0x317C , 0x8139B038},
{ 0x317D , 0x8139B039},
{ 0x317E , 0x8139B130},
{ 0x317F , 0x8139B131},
{ 0x3180 , 0x8139B132},
{ 0x3181 , 0x8139B133},
{ 0x3182 , 0x8139B134},
{ 0x3183 , 0x8139B135},
{ 0x3184 , 0x8139B136},
{ 0x3185 , 0x8139B137},
{ 0x3186 , 0x8139B138},
{ 0x3187 , 0x8139B139},
{ 0x3188 , 0x8139B230},
{ 0x3189 , 0x8139B231},
{ 0x318A , 0x8139B232},
{ 0x318B , 0x8139B233},
{ 0x318C , 0x8139B234},
{ 0x318D , 0x8139B235},
{ 0x318E , 0x8139B236},
{ 0x318F , 0x8139B237},
{ 0x3190 , 0x8139B238},
{ 0x3191 , 0x8139B239},
{ 0x3192 , 0x8139B330},
{ 0x3193 , 0x8139B331},
{ 0x3194 , 0x8139B332},
{ 0x3195 , 0x8139B333},
{ 0x3196 , 0x8139B334},
{ 0x3197 , 0x8139B335},
{ 0x3198 , 0x8139B336},
{ 0x3199 , 0x8139B337},
{ 0x319A , 0x8139B338},
{ 0x319B , 0x8139B339},
{ 0x319C , 0x8139B430},
{ 0x319D , 0x8139B431},
{ 0x319E , 0x8139B432},
{ 0x319F , 0x8139B433},
{ 0x31A0 , 0x8139B434},
{ 0x31A1 , 0x8139B435},
{ 0x31A2 , 0x8139B436},
{ 0x31A3 , 0x8139B437},
{ 0x31A4 , 0x8139B438},
{ 0x31A5 , 0x8139B439},
{ 0x31A6 , 0x8139B530},
{ 0x31A7 , 0x8139B531},
{ 0x31A8 , 0x8139B532},
{ 0x31A9 , 0x8139B533},
{ 0x31AA , 0x8139B534},
{ 0x31AB , 0x8139B535},
{ 0x31AC , 0x8139B536},
{ 0x31AD , 0x8139B537},
{ 0x31AE , 0x8139B538},
{ 0x31AF , 0x8139B539},
{ 0x31B0 , 0x8139B630},
{ 0x31B1 , 0x8139B631},
{ 0x31B2 , 0x8139B632},
{ 0x31B3 , 0x8139B633},
{ 0x31B4 , 0x8139B634},
{ 0x31B5 , 0x8139B635},
{ 0x31B6 , 0x8139B636},
{ 0x31B7 , 0x8139B637},
{ 0x31B8 , 0x8139B638},
{ 0x31B9 , 0x8139B639},
{ 0x31BA , 0x8139B730},
{ 0x31BB , 0x8139B731},
{ 0x31BC , 0x8139B732},
{ 0x31BD , 0x8139B733},
{ 0x31BE , 0x8139B734},
{ 0x31BF , 0x8139B735},
{ 0x31C0 , 0x8139B736},
{ 0x31C1 , 0x8139B737},
{ 0x31C2 , 0x8139B738},
{ 0x31C3 , 0x8139B739},
{ 0x31C4 , 0x8139B830},
{ 0x31C5 , 0x8139B831},
{ 0x31C6 , 0x8139B832},
{ 0x31C7 , 0x8139B833},
{ 0x31C8 , 0x8139B834},
{ 0x31C9 , 0x8139B835},
{ 0x31CA , 0x8139B836},
{ 0x31CB , 0x8139B837},
{ 0x31CC , 0x8139B838},
{ 0x31CD , 0x8139B839},
{ 0x31CE , 0x8139B930},
{ 0x31CF , 0x8139B931},
{ 0x31D0 , 0x8139B932},
{ 0x31D1 , 0x8139B933},
{ 0x31D2 , 0x8139B934},
{ 0x31D3 , 0x8139B935},
{ 0x31D4 , 0x8139B936},
{ 0x31D5 , 0x8139B937},
{ 0x31D6 , 0x8139B938},
{ 0x31D7 , 0x8139B939},
{ 0x31D8 , 0x8139BA30},
{ 0x31D9 , 0x8139BA31},
{ 0x31DA , 0x8139BA32},
{ 0x31DB , 0x8139BA33},
{ 0x31DC , 0x8139BA34},
{ 0x31DD , 0x8139BA35},
{ 0x31DE , 0x8139BA36},
{ 0x31DF , 0x8139BA37},
{ 0x31E0 , 0x8139BA38},
{ 0x31E1 , 0x8139BA39},
{ 0x31E2 , 0x8139BB30},
{ 0x31E3 , 0x8139BB31},
{ 0x31E4 , 0x8139BB32},
{ 0x31E5 , 0x8139BB33},
{ 0x31E6 , 0x8139BB34},
{ 0x31E7 , 0x8139BB35},
{ 0x31E8 , 0x8139BB36},
{ 0x31E9 , 0x8139BB37},
{ 0x31EA , 0x8139BB38},
{ 0x31EB , 0x8139BB39},
{ 0x31EC , 0x8139BC30},
{ 0x31ED , 0x8139BC31},
{ 0x31EE , 0x8139BC32},
{ 0x31EF , 0x8139BC33},
{ 0x31F0 , 0x8139BC34},
{ 0x31F1 , 0x8139BC35},
{ 0x31F2 , 0x8139BC36},
{ 0x31F3 , 0x8139BC37},
{ 0x31F4 , 0x8139BC38},
{ 0x31F5 , 0x8139BC39},
{ 0x31F6 , 0x8139BD30},
{ 0x31F7 , 0x8139BD31},
{ 0x31F8 , 0x8139BD32},
{ 0x31F9 , 0x8139BD33},
{ 0x31FA , 0x8139BD34},
{ 0x31FB , 0x8139BD35},
{ 0x31FC , 0x8139BD36},
{ 0x31FD , 0x8139BD37},
{ 0x31FE , 0x8139BD38},
{ 0x31FF , 0x8139BD39},
{ 0x3200 , 0x8139BE30},
{ 0x3201 , 0x8139BE31},
{ 0x3202 , 0x8139BE32},
{ 0x3203 , 0x8139BE33},
{ 0x3204 , 0x8139BE34},
{ 0x3205 , 0x8139BE35},
{ 0x3206 , 0x8139BE36},
{ 0x3207 , 0x8139BE37},
{ 0x3208 , 0x8139BE38},
{ 0x3209 , 0x8139BE39},
{ 0x320A , 0x8139BF30},
{ 0x320B , 0x8139BF31},
{ 0x320C , 0x8139BF32},
{ 0x320D , 0x8139BF33},
{ 0x320E , 0x8139BF34},
{ 0x320F , 0x8139BF35},
{ 0x3210 , 0x8139BF36},
{ 0x3211 , 0x8139BF37},
{ 0x3212 , 0x8139BF38},
{ 0x3213 , 0x8139BF39},
{ 0x3214 , 0x8139C030},
{ 0x3215 , 0x8139C031},
{ 0x3216 , 0x8139C032},
{ 0x3217 , 0x8139C033},
{ 0x3218 , 0x8139C034},
{ 0x3219 , 0x8139C035},
{ 0x321A , 0x8139C036},
{ 0x321B , 0x8139C037},
{ 0x321C , 0x8139C038},
{ 0x321D , 0x8139C039},
{ 0x321E , 0x8139C130},
{ 0x321F , 0x8139C131},
{ 0x322A , 0x8139C132},
{ 0x322B , 0x8139C133},
{ 0x322C , 0x8139C134},
{ 0x322D , 0x8139C135},
{ 0x322E , 0x8139C136},
{ 0x322F , 0x8139C137},
{ 0x3230 , 0x8139C138},
{ 0x3232 , 0x8139C139},
{ 0x3233 , 0x8139C230},
{ 0x3234 , 0x8139C231},
{ 0x3235 , 0x8139C232},
{ 0x3236 , 0x8139C233},
{ 0x3237 , 0x8139C234},
{ 0x3238 , 0x8139C235},
{ 0x3239 , 0x8139C236},
{ 0x323A , 0x8139C237},
{ 0x323B , 0x8139C238},
{ 0x323C , 0x8139C239},
{ 0x323D , 0x8139C330},
{ 0x323E , 0x8139C331},
{ 0x323F , 0x8139C332},
{ 0x3240 , 0x8139C333},
{ 0x3241 , 0x8139C334},
{ 0x3242 , 0x8139C335},
{ 0x3243 , 0x8139C336},
{ 0x3244 , 0x8139C337},
{ 0x3245 , 0x8139C338},
{ 0x3246 , 0x8139C339},
{ 0x3247 , 0x8139C430},
{ 0x3248 , 0x8139C431},
{ 0x3249 , 0x8139C432},
{ 0x324A , 0x8139C433},
{ 0x324B , 0x8139C434},
{ 0x324C , 0x8139C435},
{ 0x324D , 0x8139C436},
{ 0x324E , 0x8139C437},
{ 0x324F , 0x8139C438},
{ 0x3250 , 0x8139C439},
{ 0x3251 , 0x8139C530},
{ 0x3252 , 0x8139C531},
{ 0x3253 , 0x8139C532},
{ 0x3254 , 0x8139C533},
{ 0x3255 , 0x8139C534},
{ 0x3256 , 0x8139C535},
{ 0x3257 , 0x8139C536},
{ 0x3258 , 0x8139C537},
{ 0x3259 , 0x8139C538},
{ 0x325A , 0x8139C539},
{ 0x325B , 0x8139C630},
{ 0x325C , 0x8139C631},
{ 0x325D , 0x8139C632},
{ 0x325E , 0x8139C633},
{ 0x325F , 0x8139C634},
{ 0x3260 , 0x8139C635},
{ 0x3261 , 0x8139C636},
{ 0x3262 , 0x8139C637},
{ 0x3263 , 0x8139C638},
{ 0x3264 , 0x8139C639},
{ 0x3265 , 0x8139C730},
{ 0x3266 , 0x8139C731},
{ 0x3267 , 0x8139C732},
{ 0x3268 , 0x8139C733},
{ 0x3269 , 0x8139C734},
{ 0x326A , 0x8139C735},
{ 0x326B , 0x8139C736},
{ 0x326C , 0x8139C737},
{ 0x326D , 0x8139C738},
{ 0x326E , 0x8139C739},
{ 0x326F , 0x8139C830},
{ 0x3270 , 0x8139C831},
{ 0x3271 , 0x8139C832},
{ 0x3272 , 0x8139C833},
{ 0x3273 , 0x8139C834},
{ 0x3274 , 0x8139C835},
{ 0x3275 , 0x8139C836},
{ 0x3276 , 0x8139C837},
{ 0x3277 , 0x8139C838},
{ 0x3278 , 0x8139C839},
{ 0x3279 , 0x8139C930},
{ 0x327A , 0x8139C931},
{ 0x327B , 0x8139C932},
{ 0x327C , 0x8139C933},
{ 0x327D , 0x8139C934},
{ 0x327E , 0x8139C935},
{ 0x327F , 0x8139C936},
{ 0x3280 , 0x8139C937},
{ 0x3281 , 0x8139C938},
{ 0x3282 , 0x8139C939},
{ 0x3283 , 0x8139CA30},
{ 0x3284 , 0x8139CA31},
{ 0x3285 , 0x8139CA32},
{ 0x3286 , 0x8139CA33},
{ 0x3287 , 0x8139CA34},
{ 0x3288 , 0x8139CA35},
{ 0x3289 , 0x8139CA36},
{ 0x328A , 0x8139CA37},
{ 0x328B , 0x8139CA38},
{ 0x328C , 0x8139CA39},
{ 0x328D , 0x8139CB30},
{ 0x328E , 0x8139CB31},
{ 0x328F , 0x8139CB32},
{ 0x3290 , 0x8139CB33},
{ 0x3291 , 0x8139CB34},
{ 0x3292 , 0x8139CB35},
{ 0x3293 , 0x8139CB36},
{ 0x3294 , 0x8139CB37},
{ 0x3295 , 0x8139CB38},
{ 0x3296 , 0x8139CB39},
{ 0x3297 , 0x8139CC30},
{ 0x3298 , 0x8139CC31},
{ 0x3299 , 0x8139CC32},
{ 0x329A , 0x8139CC33},
{ 0x329B , 0x8139CC34},
{ 0x329C , 0x8139CC35},
{ 0x329D , 0x8139CC36},
{ 0x329E , 0x8139CC37},
{ 0x329F , 0x8139CC38},
{ 0x32A0 , 0x8139CC39},
{ 0x32A1 , 0x8139CD30},
{ 0x32A2 , 0x8139CD31},
{ 0x32A4 , 0x8139CD32},
{ 0x32A5 , 0x8139CD33},
{ 0x32A6 , 0x8139CD34},
{ 0x32A7 , 0x8139CD35},
{ 0x32A8 , 0x8139CD36},
{ 0x32A9 , 0x8139CD37},
{ 0x32AA , 0x8139CD38},
{ 0x32AB , 0x8139CD39},
{ 0x32AC , 0x8139CE30},
{ 0x32AD , 0x8139CE31},
{ 0x32AE , 0x8139CE32},
{ 0x32AF , 0x8139CE33},
{ 0x32B0 , 0x8139CE34},
{ 0x32B1 , 0x8139CE35},
{ 0x32B2 , 0x8139CE36},
{ 0x32B3 , 0x8139CE37},
{ 0x32B4 , 0x8139CE38},
{ 0x32B5 , 0x8139CE39},
{ 0x32B6 , 0x8139CF30},
{ 0x32B7 , 0x8139CF31},
{ 0x32B8 , 0x8139CF32},
{ 0x32B9 , 0x8139CF33},
{ 0x32BA , 0x8139CF34},
{ 0x32BB , 0x8139CF35},
{ 0x32BC , 0x8139CF36},
{ 0x32BD , 0x8139CF37},
{ 0x32BE , 0x8139CF38},
{ 0x32BF , 0x8139CF39},
{ 0x32C0 , 0x8139D030},
{ 0x32C1 , 0x8139D031},
{ 0x32C2 , 0x8139D032},
{ 0x32C3 , 0x8139D033},
{ 0x32C4 , 0x8139D034},
{ 0x32C5 , 0x8139D035},
{ 0x32C6 , 0x8139D036},
{ 0x32C7 , 0x8139D037},
{ 0x32C8 , 0x8139D038},
{ 0x32C9 , 0x8139D039},
{ 0x32CA , 0x8139D130},
{ 0x32CB , 0x8139D131},
{ 0x32CC , 0x8139D132},
{ 0x32CD , 0x8139D133},
{ 0x32CE , 0x8139D134},
{ 0x32CF , 0x8139D135},
{ 0x32D0 , 0x8139D136},
{ 0x32D1 , 0x8139D137},
{ 0x32D2 , 0x8139D138},
{ 0x32D3 , 0x8139D139},
{ 0x32D4 , 0x8139D230},
{ 0x32D5 , 0x8139D231},
{ 0x32D6 , 0x8139D232},
{ 0x32D7 , 0x8139D233},
{ 0x32D8 , 0x8139D234},
{ 0x32D9 , 0x8139D235},
{ 0x32DA , 0x8139D236},
{ 0x32DB , 0x8139D237},
{ 0x32DC , 0x8139D238},
{ 0x32DD , 0x8139D239},
{ 0x32DE , 0x8139D330},
{ 0x32DF , 0x8139D331},
{ 0x32E0 , 0x8139D332},
{ 0x32E1 , 0x8139D333},
{ 0x32E2 , 0x8139D334},
{ 0x32E3 , 0x8139D335},
{ 0x32E4 , 0x8139D336},
{ 0x32E5 , 0x8139D337},
{ 0x32E6 , 0x8139D338},
{ 0x32E7 , 0x8139D339},
{ 0x32E8 , 0x8139D430},
{ 0x32E9 , 0x8139D431},
{ 0x32EA , 0x8139D432},
{ 0x32EB , 0x8139D433},
{ 0x32EC , 0x8139D434},
{ 0x32ED , 0x8139D435},
{ 0x32EE , 0x8139D436},
{ 0x32EF , 0x8139D437},
{ 0x32F0 , 0x8139D438},
{ 0x32F1 , 0x8139D439},
{ 0x32F2 , 0x8139D530},
{ 0x32F3 , 0x8139D531},
{ 0x32F4 , 0x8139D532},
{ 0x32F5 , 0x8139D533},
{ 0x32F6 , 0x8139D534},
{ 0x32F7 , 0x8139D535},
{ 0x32F8 , 0x8139D536},
{ 0x32F9 , 0x8139D537},
{ 0x32FA , 0x8139D538},
{ 0x32FB , 0x8139D539},
{ 0x32FC , 0x8139D630},
{ 0x32FD , 0x8139D631},
{ 0x32FE , 0x8139D632},
{ 0x32FF , 0x8139D633},
{ 0x3300 , 0x8139D634},
{ 0x3301 , 0x8139D635},
{ 0x3302 , 0x8139D636},
{ 0x3303 , 0x8139D637},
{ 0x3304 , 0x8139D638},
{ 0x3305 , 0x8139D639},
{ 0x3306 , 0x8139D730},
{ 0x3307 , 0x8139D731},
{ 0x3308 , 0x8139D732},
{ 0x3309 , 0x8139D733},
{ 0x330A , 0x8139D734},
{ 0x330B , 0x8139D735},
{ 0x330C , 0x8139D736},
{ 0x330D , 0x8139D737},
{ 0x330E , 0x8139D738},
{ 0x330F , 0x8139D739},
{ 0x3310 , 0x8139D830},
{ 0x3311 , 0x8139D831},
{ 0x3312 , 0x8139D832},
{ 0x3313 , 0x8139D833},
{ 0x3314 , 0x8139D834},
{ 0x3315 , 0x8139D835},
{ 0x3316 , 0x8139D836},
{ 0x3317 , 0x8139D837},
{ 0x3318 , 0x8139D838},
{ 0x3319 , 0x8139D839},
{ 0x331A , 0x8139D930},
{ 0x331B , 0x8139D931},
{ 0x331C , 0x8139D932},
{ 0x331D , 0x8139D933},
{ 0x331E , 0x8139D934},
{ 0x331F , 0x8139D935},
{ 0x3320 , 0x8139D936},
{ 0x3321 , 0x8139D937},
{ 0x3322 , 0x8139D938},
{ 0x3323 , 0x8139D939},
{ 0x3324 , 0x8139DA30},
{ 0x3325 , 0x8139DA31},
{ 0x3326 , 0x8139DA32},
{ 0x3327 , 0x8139DA33},
{ 0x3328 , 0x8139DA34},
{ 0x3329 , 0x8139DA35},
{ 0x332A , 0x8139DA36},
{ 0x332B , 0x8139DA37},
{ 0x332C , 0x8139DA38},
{ 0x332D , 0x8139DA39},
{ 0x332E , 0x8139DB30},
{ 0x332F , 0x8139DB31},
{ 0x3330 , 0x8139DB32},
{ 0x3331 , 0x8139DB33},
{ 0x3332 , 0x8139DB34},
{ 0x3333 , 0x8139DB35},
{ 0x3334 , 0x8139DB36},
{ 0x3335 , 0x8139DB37},
{ 0x3336 , 0x8139DB38},
{ 0x3337 , 0x8139DB39},
{ 0x3338 , 0x8139DC30},
{ 0x3339 , 0x8139DC31},
{ 0x333A , 0x8139DC32},
{ 0x333B , 0x8139DC33},
{ 0x333C , 0x8139DC34},
{ 0x333D , 0x8139DC35},
{ 0x333E , 0x8139DC36},
{ 0x333F , 0x8139DC37},
{ 0x3340 , 0x8139DC38},
{ 0x3341 , 0x8139DC39},
{ 0x3342 , 0x8139DD30},
{ 0x3343 , 0x8139DD31},
{ 0x3344 , 0x8139DD32},
{ 0x3345 , 0x8139DD33},
{ 0x3346 , 0x8139DD34},
{ 0x3347 , 0x8139DD35},
{ 0x3348 , 0x8139DD36},
{ 0x3349 , 0x8139DD37},
{ 0x334A , 0x8139DD38},
{ 0x334B , 0x8139DD39},
{ 0x334C , 0x8139DE30},
{ 0x334D , 0x8139DE31},
{ 0x334E , 0x8139DE32},
{ 0x334F , 0x8139DE33},
{ 0x3350 , 0x8139DE34},
{ 0x3351 , 0x8139DE35},
{ 0x3352 , 0x8139DE36},
{ 0x3353 , 0x8139DE37},
{ 0x3354 , 0x8139DE38},
{ 0x3355 , 0x8139DE39},
{ 0x3356 , 0x8139DF30},
{ 0x3357 , 0x8139DF31},
{ 0x3358 , 0x8139DF32},
{ 0x3359 , 0x8139DF33},
{ 0x335A , 0x8139DF34},
{ 0x335B , 0x8139DF35},
{ 0x335C , 0x8139DF36},
{ 0x335D , 0x8139DF37},
{ 0x335E , 0x8139DF38},
{ 0x335F , 0x8139DF39},
{ 0x3360 , 0x8139E030},
{ 0x3361 , 0x8139E031},
{ 0x3362 , 0x8139E032},
{ 0x3363 , 0x8139E033},
{ 0x3364 , 0x8139E034},
{ 0x3365 , 0x8139E035},
{ 0x3366 , 0x8139E036},
{ 0x3367 , 0x8139E037},
{ 0x3368 , 0x8139E038},
{ 0x3369 , 0x8139E039},
{ 0x336A , 0x8139E130},
{ 0x336B , 0x8139E131},
{ 0x336C , 0x8139E132},
{ 0x336D , 0x8139E133},
{ 0x336E , 0x8139E134},
{ 0x336F , 0x8139E135},
{ 0x3370 , 0x8139E136},
{ 0x3371 , 0x8139E137},
{ 0x3372 , 0x8139E138},
{ 0x3373 , 0x8139E139},
{ 0x3374 , 0x8139E230},
{ 0x3375 , 0x8139E231},
{ 0x3376 , 0x8139E232},
{ 0x3377 , 0x8139E233},
{ 0x3378 , 0x8139E234},
{ 0x3379 , 0x8139E235},
{ 0x337A , 0x8139E236},
{ 0x337B , 0x8139E237},
{ 0x337C , 0x8139E238},
{ 0x337D , 0x8139E239},
{ 0x337E , 0x8139E330},
{ 0x337F , 0x8139E331},
{ 0x3380 , 0x8139E332},
{ 0x3381 , 0x8139E333},
{ 0x3382 , 0x8139E334},
{ 0x3383 , 0x8139E335},
{ 0x3384 , 0x8139E336},
{ 0x3385 , 0x8139E337},
{ 0x3386 , 0x8139E338},
{ 0x3387 , 0x8139E339},
{ 0x3388 , 0x8139E430},
{ 0x3389 , 0x8139E431},
{ 0x338A , 0x8139E432},
{ 0x338B , 0x8139E433},
{ 0x338C , 0x8139E434},
{ 0x338D , 0x8139E435},
{ 0x3390 , 0x8139E436},
{ 0x3391 , 0x8139E437},
{ 0x3392 , 0x8139E438},
{ 0x3393 , 0x8139E439},
{ 0x3394 , 0x8139E530},
{ 0x3395 , 0x8139E531},
{ 0x3396 , 0x8139E532},
{ 0x3397 , 0x8139E533},
{ 0x3398 , 0x8139E534},
{ 0x3399 , 0x8139E535},
{ 0x339A , 0x8139E536},
{ 0x339B , 0x8139E537},
{ 0x339F , 0x8139E538},
{ 0x33A0 , 0x8139E539},
{ 0x33A2 , 0x8139E630},
{ 0x33A3 , 0x8139E631},
{ 0x33A4 , 0x8139E632},
{ 0x33A5 , 0x8139E633},
{ 0x33A6 , 0x8139E634},
{ 0x33A7 , 0x8139E635},
{ 0x33A8 , 0x8139E636},
{ 0x33A9 , 0x8139E637},
{ 0x33AA , 0x8139E638},
{ 0x33AB , 0x8139E639},
{ 0x33AC , 0x8139E730},
{ 0x33AD , 0x8139E731},
{ 0x33AE , 0x8139E732},
{ 0x33AF , 0x8139E733},
{ 0x33B0 , 0x8139E734},
{ 0x33B1 , 0x8139E735},
{ 0x33B2 , 0x8139E736},
{ 0x33B3 , 0x8139E737},
{ 0x33B4 , 0x8139E738},
{ 0x33B5 , 0x8139E739},
{ 0x33B6 , 0x8139E830},
{ 0x33B7 , 0x8139E831},
{ 0x33B8 , 0x8139E832},
{ 0x33B9 , 0x8139E833},
{ 0x33BA , 0x8139E834},
{ 0x33BB , 0x8139E835},
{ 0x33BC , 0x8139E836},
{ 0x33BD , 0x8139E837},
{ 0x33BE , 0x8139E838},
{ 0x33BF , 0x8139E839},
{ 0x33C0 , 0x8139E930},
{ 0x33C1 , 0x8139E931},
{ 0x33C2 , 0x8139E932},
{ 0x33C3 , 0x8139E933},
{ 0x33C5 , 0x8139E934},
{ 0x33C6 , 0x8139E935},
{ 0x33C7 , 0x8139E936},
{ 0x33C8 , 0x8139E937},
{ 0x33C9 , 0x8139E938},
{ 0x33CA , 0x8139E939},
{ 0x33CB , 0x8139EA30},
{ 0x33CC , 0x8139EA31},
{ 0x33CD , 0x8139EA32},
{ 0x33CF , 0x8139EA33},
{ 0x33D0 , 0x8139EA34},
{ 0x33D3 , 0x8139EA35},
{ 0x33D4 , 0x8139EA36},
{ 0x33D6 , 0x8139EA37},
{ 0x33D7 , 0x8139EA38},
{ 0x33D8 , 0x8139EA39},
{ 0x33D9 , 0x8139EB30},
{ 0x33DA , 0x8139EB31},
{ 0x33DB , 0x8139EB32},
{ 0x33DC , 0x8139EB33},
{ 0x33DD , 0x8139EB34},
{ 0x33DE , 0x8139EB35},
{ 0x33DF , 0x8139EB36},
{ 0x33E0 , 0x8139EB37},
{ 0x33E1 , 0x8139EB38},
{ 0x33E2 , 0x8139EB39},
{ 0x33E3 , 0x8139EC30},
{ 0x33E4 , 0x8139EC31},
{ 0x33E5 , 0x8139EC32},
{ 0x33E6 , 0x8139EC33},
{ 0x33E7 , 0x8139EC34},
{ 0x33E8 , 0x8139EC35},
{ 0x33E9 , 0x8139EC36},
{ 0x33EA , 0x8139EC37},
{ 0x33EB , 0x8139EC38},
{ 0x33EC , 0x8139EC39},
{ 0x33ED , 0x8139ED30},
{ 0x33EE , 0x8139ED31},
{ 0x33EF , 0x8139ED32},
{ 0x33F0 , 0x8139ED33},
{ 0x33F1 , 0x8139ED34},
{ 0x33F2 , 0x8139ED35},
{ 0x33F3 , 0x8139ED36},
{ 0x33F4 , 0x8139ED37},
{ 0x33F5 , 0x8139ED38},
{ 0x33F6 , 0x8139ED39},
{ 0x33F7 , 0x8139EE30},
{ 0x33F8 , 0x8139EE31},
{ 0x33F9 , 0x8139EE32},
{ 0x33FA , 0x8139EE33},
{ 0x33FB , 0x8139EE34},
{ 0x33FC , 0x8139EE35},
{ 0x33FD , 0x8139EE36},
{ 0x33FE , 0x8139EE37},
{ 0x33FF , 0x8139EE38},
{ 0x3400 , 0x8139EE39},
{ 0x3401 , 0x8139EF30},
{ 0x3402 , 0x8139EF31},
{ 0x3403 , 0x8139EF32},
{ 0x3404 , 0x8139EF33},
{ 0x3405 , 0x8139EF34},
{ 0x3406 , 0x8139EF35},
{ 0x3407 , 0x8139EF36},
{ 0x3408 , 0x8139EF37},
{ 0x3409 , 0x8139EF38},
{ 0x340A , 0x8139EF39},
{ 0x340B , 0x8139F030},
{ 0x340C , 0x8139F031},
{ 0x340D , 0x8139F032},
{ 0x340E , 0x8139F033},
{ 0x340F , 0x8139F034},
{ 0x3410 , 0x8139F035},
{ 0x3411 , 0x8139F036},
{ 0x3412 , 0x8139F037},
{ 0x3413 , 0x8139F038},
{ 0x3414 , 0x8139F039},
{ 0x3415 , 0x8139F130},
{ 0x3416 , 0x8139F131},
{ 0x3417 , 0x8139F132},
{ 0x3418 , 0x8139F133},
{ 0x3419 , 0x8139F134},
{ 0x341A , 0x8139F135},
{ 0x341B , 0x8139F136},
{ 0x341C , 0x8139F137},
{ 0x341D , 0x8139F138},
{ 0x341E , 0x8139F139},
{ 0x341F , 0x8139F230},
{ 0x3420 , 0x8139F231},
{ 0x3421 , 0x8139F232},
{ 0x3422 , 0x8139F233},
{ 0x3423 , 0x8139F234},
{ 0x3424 , 0x8139F235},
{ 0x3425 , 0x8139F236},
{ 0x3426 , 0x8139F237},
{ 0x3427 , 0x8139F238},
{ 0x3428 , 0x8139F239},
{ 0x3429 , 0x8139F330},
{ 0x342A , 0x8139F331},
{ 0x342B , 0x8139F332},
{ 0x342C , 0x8139F333},
{ 0x342D , 0x8139F334},
{ 0x342E , 0x8139F335},
{ 0x342F , 0x8139F336},
{ 0x3430 , 0x8139F337},
{ 0x3431 , 0x8139F338},
{ 0x3432 , 0x8139F339},
{ 0x3433 , 0x8139F430},
{ 0x3434 , 0x8139F431},
{ 0x3435 , 0x8139F432},
{ 0x3436 , 0x8139F433},
{ 0x3437 , 0x8139F434},
{ 0x3438 , 0x8139F435},
{ 0x3439 , 0x8139F436},
{ 0x343A , 0x8139F437},
{ 0x343B , 0x8139F438},
{ 0x343C , 0x8139F439},
{ 0x343D , 0x8139F530},
{ 0x343E , 0x8139F531},
{ 0x343F , 0x8139F532},
{ 0x3440 , 0x8139F533},
{ 0x3441 , 0x8139F534},
{ 0x3442 , 0x8139F535},
{ 0x3443 , 0x8139F536},
{ 0x3444 , 0x8139F537},
{ 0x3445 , 0x8139F538},
{ 0x3446 , 0x8139F539},
{ 0x3448 , 0x8139F630},
{ 0x3449 , 0x8139F631},
{ 0x344A , 0x8139F632},
{ 0x344B , 0x8139F633},
{ 0x344C , 0x8139F634},
{ 0x344D , 0x8139F635},
{ 0x344E , 0x8139F636},
{ 0x344F , 0x8139F637},
{ 0x3450 , 0x8139F638},
{ 0x3451 , 0x8139F639},
{ 0x3452 , 0x8139F730},
{ 0x3453 , 0x8139F731},
{ 0x3454 , 0x8139F732},
{ 0x3455 , 0x8139F733},
{ 0x3456 , 0x8139F734},
{ 0x3457 , 0x8139F735},
{ 0x3458 , 0x8139F736},
{ 0x3459 , 0x8139F737},
{ 0x345A , 0x8139F738},
{ 0x345B , 0x8139F739},
{ 0x345C , 0x8139F830},
{ 0x345D , 0x8139F831},
{ 0x345E , 0x8139F832},
{ 0x345F , 0x8139F833},
{ 0x3460 , 0x8139F834},
{ 0x3461 , 0x8139F835},
{ 0x3462 , 0x8139F836},
{ 0x3463 , 0x8139F837},
{ 0x3464 , 0x8139F838},
{ 0x3465 , 0x8139F839},
{ 0x3466 , 0x8139F930},
{ 0x3467 , 0x8139F931},
{ 0x3468 , 0x8139F932},
{ 0x3469 , 0x8139F933},
{ 0x346A , 0x8139F934},
{ 0x346B , 0x8139F935},
{ 0x346C , 0x8139F936},
{ 0x346D , 0x8139F937},
{ 0x346E , 0x8139F938},
{ 0x346F , 0x8139F939},
{ 0x3470 , 0x8139FA30},
{ 0x3471 , 0x8139FA31},
{ 0x3472 , 0x8139FA32},
{ 0x3474 , 0x8139FA33},
{ 0x3475 , 0x8139FA34},
{ 0x3476 , 0x8139FA35},
{ 0x3477 , 0x8139FA36},
{ 0x3478 , 0x8139FA37},
{ 0x3479 , 0x8139FA38},
{ 0x347A , 0x8139FA39},
{ 0x347B , 0x8139FB30},
{ 0x347C , 0x8139FB31},
{ 0x347D , 0x8139FB32},
{ 0x347E , 0x8139FB33},
{ 0x347F , 0x8139FB34},
{ 0x3480 , 0x8139FB35},
{ 0x3481 , 0x8139FB36},
{ 0x3482 , 0x8139FB37},
{ 0x3483 , 0x8139FB38},
{ 0x3484 , 0x8139FB39},
{ 0x3485 , 0x8139FC30},
{ 0x3486 , 0x8139FC31},
{ 0x3487 , 0x8139FC32},
{ 0x3488 , 0x8139FC33},
{ 0x3489 , 0x8139FC34},
{ 0x348A , 0x8139FC35},
{ 0x348B , 0x8139FC36},
{ 0x348C , 0x8139FC37},
{ 0x348D , 0x8139FC38},
{ 0x348E , 0x8139FC39},
{ 0x348F , 0x8139FD30},
{ 0x3490 , 0x8139FD31},
{ 0x3491 , 0x8139FD32},
{ 0x3492 , 0x8139FD33},
{ 0x3493 , 0x8139FD34},
{ 0x3494 , 0x8139FD35},
{ 0x3495 , 0x8139FD36},
{ 0x3496 , 0x8139FD37},
{ 0x3497 , 0x8139FD38},
{ 0x3498 , 0x8139FD39},
{ 0x3499 , 0x8139FE30},
{ 0x349A , 0x8139FE31},
{ 0x349B , 0x8139FE32},
{ 0x349C , 0x8139FE33},
{ 0x349D , 0x8139FE34},
{ 0x349E , 0x8139FE35},
{ 0x349F , 0x8139FE36},
{ 0x34A0 , 0x8139FE37},
{ 0x34A1 , 0x8139FE38},
{ 0x34A2 , 0x8139FE39},
{ 0x34A3 , 0x82308130},
{ 0x34A4 , 0x82308131},
{ 0x34A5 , 0x82308132},
{ 0x34A6 , 0x82308133},
{ 0x34A7 , 0x82308134},
{ 0x34A8 , 0x82308135},
{ 0x34A9 , 0x82308136},
{ 0x34AA , 0x82308137},
{ 0x34AB , 0x82308138},
{ 0x34AC , 0x82308139},
{ 0x34AD , 0x82308230},
{ 0x34AE , 0x82308231},
{ 0x34AF , 0x82308232},
{ 0x34B0 , 0x82308233},
{ 0x34B1 , 0x82308234},
{ 0x34B2 , 0x82308235},
{ 0x34B3 , 0x82308236},
{ 0x34B4 , 0x82308237},
{ 0x34B5 , 0x82308238},
{ 0x34B6 , 0x82308239},
{ 0x34B7 , 0x82308330},
{ 0x34B8 , 0x82308331},
{ 0x34B9 , 0x82308332},
{ 0x34BA , 0x82308333},
{ 0x34BB , 0x82308334},
{ 0x34BC , 0x82308335},
{ 0x34BD , 0x82308336},
{ 0x34BE , 0x82308337},
{ 0x34BF , 0x82308338},
{ 0x34C0 , 0x82308339},
{ 0x34C1 , 0x82308430},
{ 0x34C2 , 0x82308431},
{ 0x34C3 , 0x82308432},
{ 0x34C4 , 0x82308433},
{ 0x34C5 , 0x82308434},
{ 0x34C6 , 0x82308435},
{ 0x34C7 , 0x82308436},
{ 0x34C8 , 0x82308437},
{ 0x34C9 , 0x82308438},
{ 0x34CA , 0x82308439},
{ 0x34CB , 0x82308530},
{ 0x34CC , 0x82308531},
{ 0x34CD , 0x82308532},
{ 0x34CE , 0x82308533},
{ 0x34CF , 0x82308534},
{ 0x34D0 , 0x82308535},
{ 0x34D1 , 0x82308536},
{ 0x34D2 , 0x82308537},
{ 0x34D3 , 0x82308538},
{ 0x34D4 , 0x82308539},
{ 0x34D5 , 0x82308630},
{ 0x34D6 , 0x82308631},
{ 0x34D7 , 0x82308632},
{ 0x34D8 , 0x82308633},
{ 0x34D9 , 0x82308634},
{ 0x34DA , 0x82308635},
{ 0x34DB , 0x82308636},
{ 0x34DC , 0x82308637},
{ 0x34DD , 0x82308638},
{ 0x34DE , 0x82308639},
{ 0x34DF , 0x82308730},
{ 0x34E0 , 0x82308731},
{ 0x34E1 , 0x82308732},
{ 0x34E2 , 0x82308733},
{ 0x34E3 , 0x82308734},
{ 0x34E4 , 0x82308735},
{ 0x34E5 , 0x82308736},
{ 0x34E6 , 0x82308737},
{ 0x34E7 , 0x82308738},
{ 0x34E8 , 0x82308739},
{ 0x34E9 , 0x82308830},
{ 0x34EA , 0x82308831},
{ 0x34EB , 0x82308832},
{ 0x34EC , 0x82308833},
{ 0x34ED , 0x82308834},
{ 0x34EE , 0x82308835},
{ 0x34EF , 0x82308836},
{ 0x34F0 , 0x82308837},
{ 0x34F1 , 0x82308838},
{ 0x34F2 , 0x82308839},
{ 0x34F3 , 0x82308930},
{ 0x34F4 , 0x82308931},
{ 0x34F5 , 0x82308932},
{ 0x34F6 , 0x82308933},
{ 0x34F7 , 0x82308934},
{ 0x34F8 , 0x82308935},
{ 0x34F9 , 0x82308936},
{ 0x34FA , 0x82308937},
{ 0x34FB , 0x82308938},
{ 0x34FC , 0x82308939},
{ 0x34FD , 0x82308A30},
{ 0x34FE , 0x82308A31},
{ 0x34FF , 0x82308A32},
{ 0x3500 , 0x82308A33},
{ 0x3501 , 0x82308A34},
{ 0x3502 , 0x82308A35},
{ 0x3503 , 0x82308A36},
{ 0x3504 , 0x82308A37},
{ 0x3505 , 0x82308A38},
{ 0x3506 , 0x82308A39},
{ 0x3507 , 0x82308B30},
{ 0x3508 , 0x82308B31},
{ 0x3509 , 0x82308B32},
{ 0x350A , 0x82308B33},
{ 0x350B , 0x82308B34},
{ 0x350C , 0x82308B35},
{ 0x350D , 0x82308B36},
{ 0x350E , 0x82308B37},
{ 0x350F , 0x82308B38},
{ 0x3510 , 0x82308B39},
{ 0x3511 , 0x82308C30},
{ 0x3512 , 0x82308C31},
{ 0x3513 , 0x82308C32},
{ 0x3514 , 0x82308C33},
{ 0x3515 , 0x82308C34},
{ 0x3516 , 0x82308C35},
{ 0x3517 , 0x82308C36},
{ 0x3518 , 0x82308C37},
{ 0x3519 , 0x82308C38},
{ 0x351A , 0x82308C39},
{ 0x351B , 0x82308D30},
{ 0x351C , 0x82308D31},
{ 0x351D , 0x82308D32},
{ 0x351E , 0x82308D33},
{ 0x351F , 0x82308D34},
{ 0x3520 , 0x82308D35},
{ 0x3521 , 0x82308D36},
{ 0x3522 , 0x82308D37},
{ 0x3523 , 0x82308D38},
{ 0x3524 , 0x82308D39},
{ 0x3525 , 0x82308E30},
{ 0x3526 , 0x82308E31},
{ 0x3527 , 0x82308E32},
{ 0x3528 , 0x82308E33},
{ 0x3529 , 0x82308E34},
{ 0x352A , 0x82308E35},
{ 0x352B , 0x82308E36},
{ 0x352C , 0x82308E37},
{ 0x352D , 0x82308E38},
{ 0x352E , 0x82308E39},
{ 0x352F , 0x82308F30},
{ 0x3530 , 0x82308F31},
{ 0x3531 , 0x82308F32},
{ 0x3532 , 0x82308F33},
{ 0x3533 , 0x82308F34},
{ 0x3534 , 0x82308F35},
{ 0x3535 , 0x82308F36},
{ 0x3536 , 0x82308F37},
{ 0x3537 , 0x82308F38},
{ 0x3538 , 0x82308F39},
{ 0x3539 , 0x82309030},
{ 0x353A , 0x82309031},
{ 0x353B , 0x82309032},
{ 0x353C , 0x82309033},
{ 0x353D , 0x82309034},
{ 0x353E , 0x82309035},
{ 0x353F , 0x82309036},
{ 0x3540 , 0x82309037},
{ 0x3541 , 0x82309038},
{ 0x3542 , 0x82309039},
{ 0x3543 , 0x82309130},
{ 0x3544 , 0x82309131},
{ 0x3545 , 0x82309132},
{ 0x3546 , 0x82309133},
{ 0x3547 , 0x82309134},
{ 0x3548 , 0x82309135},
{ 0x3549 , 0x82309136},
{ 0x354A , 0x82309137},
{ 0x354B , 0x82309138},
{ 0x354C , 0x82309139},
{ 0x354D , 0x82309230},
{ 0x354E , 0x82309231},
{ 0x354F , 0x82309232},
{ 0x3550 , 0x82309233},
{ 0x3551 , 0x82309234},
{ 0x3552 , 0x82309235},
{ 0x3553 , 0x82309236},
{ 0x3554 , 0x82309237},
{ 0x3555 , 0x82309238},
{ 0x3556 , 0x82309239},
{ 0x3557 , 0x82309330},
{ 0x3558 , 0x82309331},
{ 0x3559 , 0x82309332},
{ 0x355A , 0x82309333},
{ 0x355B , 0x82309334},
{ 0x355C , 0x82309335},
{ 0x355D , 0x82309336},
{ 0x355E , 0x82309337},
{ 0x355F , 0x82309338},
{ 0x3560 , 0x82309339},
{ 0x3561 , 0x82309430},
{ 0x3562 , 0x82309431},
{ 0x3563 , 0x82309432},
{ 0x3564 , 0x82309433},
{ 0x3565 , 0x82309434},
{ 0x3566 , 0x82309435},
{ 0x3567 , 0x82309436},
{ 0x3568 , 0x82309437},
{ 0x3569 , 0x82309438},
{ 0x356A , 0x82309439},
{ 0x356B , 0x82309530},
{ 0x356C , 0x82309531},
{ 0x356D , 0x82309532},
{ 0x356E , 0x82309533},
{ 0x356F , 0x82309534},
{ 0x3570 , 0x82309535},
{ 0x3571 , 0x82309536},
{ 0x3572 , 0x82309537},
{ 0x3573 , 0x82309538},
{ 0x3574 , 0x82309539},
{ 0x3575 , 0x82309630},
{ 0x3576 , 0x82309631},
{ 0x3577 , 0x82309632},
{ 0x3578 , 0x82309633},
{ 0x3579 , 0x82309634},
{ 0x357A , 0x82309635},
{ 0x357B , 0x82309636},
{ 0x357C , 0x82309637},
{ 0x357D , 0x82309638},
{ 0x357E , 0x82309639},
{ 0x357F , 0x82309730},
{ 0x3580 , 0x82309731},
{ 0x3581 , 0x82309732},
{ 0x3582 , 0x82309733},
{ 0x3583 , 0x82309734},
{ 0x3584 , 0x82309735},
{ 0x3585 , 0x82309736},
{ 0x3586 , 0x82309737},
{ 0x3587 , 0x82309738},
{ 0x3588 , 0x82309739},
{ 0x3589 , 0x82309830},
{ 0x358A , 0x82309831},
{ 0x358B , 0x82309832},
{ 0x358C , 0x82309833},
{ 0x358D , 0x82309834},
{ 0x358E , 0x82309835},
{ 0x358F , 0x82309836},
{ 0x3590 , 0x82309837},
{ 0x3591 , 0x82309838},
{ 0x3592 , 0x82309839},
{ 0x3593 , 0x82309930},
{ 0x3594 , 0x82309931},
{ 0x3595 , 0x82309932},
{ 0x3596 , 0x82309933},
{ 0x3597 , 0x82309934},
{ 0x3598 , 0x82309935},
{ 0x3599 , 0x82309936},
{ 0x359A , 0x82309937},
{ 0x359B , 0x82309938},
{ 0x359C , 0x82309939},
{ 0x359D , 0x82309A30},
{ 0x359F , 0x82309A31},
{ 0x35A0 , 0x82309A32},
{ 0x35A1 , 0x82309A33},
{ 0x35A2 , 0x82309A34},
{ 0x35A3 , 0x82309A35},
{ 0x35A4 , 0x82309A36},
{ 0x35A5 , 0x82309A37},
{ 0x35A6 , 0x82309A38},
{ 0x35A7 , 0x82309A39},
{ 0x35A8 , 0x82309B30},
{ 0x35A9 , 0x82309B31},
{ 0x35AA , 0x82309B32},
{ 0x35AB , 0x82309B33},
{ 0x35AC , 0x82309B34},
{ 0x35AD , 0x82309B35},
{ 0x35AE , 0x82309B36},
{ 0x35AF , 0x82309B37},
{ 0x35B0 , 0x82309B38},
{ 0x35B1 , 0x82309B39},
{ 0x35B2 , 0x82309C30},
{ 0x35B3 , 0x82309C31},
{ 0x35B4 , 0x82309C32},
{ 0x35B5 , 0x82309C33},
{ 0x35B6 , 0x82309C34},
{ 0x35B7 , 0x82309C35},
{ 0x35B8 , 0x82309C36},
{ 0x35B9 , 0x82309C37},
{ 0x35BA , 0x82309C38},
{ 0x35BB , 0x82309C39},
{ 0x35BC , 0x82309D30},
{ 0x35BD , 0x82309D31},
{ 0x35BE , 0x82309D32},
{ 0x35BF , 0x82309D33},
{ 0x35C0 , 0x82309D34},
{ 0x35C1 , 0x82309D35},
{ 0x35C2 , 0x82309D36},
{ 0x35C3 , 0x82309D37},
{ 0x35C4 , 0x82309D38},
{ 0x35C5 , 0x82309D39},
{ 0x35C6 , 0x82309E30},
{ 0x35C7 , 0x82309E31},
{ 0x35C8 , 0x82309E32},
{ 0x35C9 , 0x82309E33},
{ 0x35CA , 0x82309E34},
{ 0x35CB , 0x82309E35},
{ 0x35CC , 0x82309E36},
{ 0x35CD , 0x82309E37},
{ 0x35CE , 0x82309E38},
{ 0x35CF , 0x82309E39},
{ 0x35D0 , 0x82309F30},
{ 0x35D1 , 0x82309F31},
{ 0x35D2 , 0x82309F32},
{ 0x35D3 , 0x82309F33},
{ 0x35D4 , 0x82309F34},
{ 0x35D5 , 0x82309F35},
{ 0x35D6 , 0x82309F36},
{ 0x35D7 , 0x82309F37},
{ 0x35D8 , 0x82309F38},
{ 0x35D9 , 0x82309F39},
{ 0x35DA , 0x8230A030},
{ 0x35DB , 0x8230A031},
{ 0x35DC , 0x8230A032},
{ 0x35DD , 0x8230A033},
{ 0x35DE , 0x8230A034},
{ 0x35DF , 0x8230A035},
{ 0x35E0 , 0x8230A036},
{ 0x35E1 , 0x8230A037},
{ 0x35E2 , 0x8230A038},
{ 0x35E3 , 0x8230A039},
{ 0x35E4 , 0x8230A130},
{ 0x35E5 , 0x8230A131},
{ 0x35E6 , 0x8230A132},
{ 0x35E7 , 0x8230A133},
{ 0x35E8 , 0x8230A134},
{ 0x35E9 , 0x8230A135},
{ 0x35EA , 0x8230A136},
{ 0x35EB , 0x8230A137},
{ 0x35EC , 0x8230A138},
{ 0x35ED , 0x8230A139},
{ 0x35EE , 0x8230A230},
{ 0x35EF , 0x8230A231},
{ 0x35F0 , 0x8230A232},
{ 0x35F1 , 0x8230A233},
{ 0x35F2 , 0x8230A234},
{ 0x35F3 , 0x8230A235},
{ 0x35F4 , 0x8230A236},
{ 0x35F5 , 0x8230A237},
{ 0x35F6 , 0x8230A238},
{ 0x35F7 , 0x8230A239},
{ 0x35F8 , 0x8230A330},
{ 0x35F9 , 0x8230A331},
{ 0x35FA , 0x8230A332},
{ 0x35FB , 0x8230A333},
{ 0x35FC , 0x8230A334},
{ 0x35FD , 0x8230A335},
{ 0x35FE , 0x8230A336},
{ 0x35FF , 0x8230A337},
{ 0x3600 , 0x8230A338},
{ 0x3601 , 0x8230A339},
{ 0x3602 , 0x8230A430},
{ 0x3603 , 0x8230A431},
{ 0x3604 , 0x8230A432},
{ 0x3605 , 0x8230A433},
{ 0x3606 , 0x8230A434},
{ 0x3607 , 0x8230A435},
{ 0x3608 , 0x8230A436},
{ 0x3609 , 0x8230A437},
{ 0x360A , 0x8230A438},
{ 0x360B , 0x8230A439},
{ 0x360C , 0x8230A530},
{ 0x360D , 0x8230A531},
{ 0x360F , 0x8230A532},
{ 0x3610 , 0x8230A533},
{ 0x3611 , 0x8230A534},
{ 0x3612 , 0x8230A535},
{ 0x3613 , 0x8230A536},
{ 0x3614 , 0x8230A537},
{ 0x3615 , 0x8230A538},
{ 0x3616 , 0x8230A539},
{ 0x3617 , 0x8230A630},
{ 0x3618 , 0x8230A631},
{ 0x3619 , 0x8230A632},
{ 0x361B , 0x8230A633},
{ 0x361C , 0x8230A634},
{ 0x361D , 0x8230A635},
{ 0x361E , 0x8230A636},
{ 0x361F , 0x8230A637},
{ 0x3620 , 0x8230A638},
{ 0x3621 , 0x8230A639},
{ 0x3622 , 0x8230A730},
{ 0x3623 , 0x8230A731},
{ 0x3624 , 0x8230A732},
{ 0x3625 , 0x8230A733},
{ 0x3626 , 0x8230A734},
{ 0x3627 , 0x8230A735},
{ 0x3628 , 0x8230A736},
{ 0x3629 , 0x8230A737},
{ 0x362A , 0x8230A738},
{ 0x362B , 0x8230A739},
{ 0x362C , 0x8230A830},
{ 0x362D , 0x8230A831},
{ 0x362E , 0x8230A832},
{ 0x362F , 0x8230A833},
{ 0x3630 , 0x8230A834},
{ 0x3631 , 0x8230A835},
{ 0x3632 , 0x8230A836},
{ 0x3633 , 0x8230A837},
{ 0x3634 , 0x8230A838},
{ 0x3635 , 0x8230A839},
{ 0x3636 , 0x8230A930},
{ 0x3637 , 0x8230A931},
{ 0x3638 , 0x8230A932},
{ 0x3639 , 0x8230A933},
{ 0x363A , 0x8230A934},
{ 0x363B , 0x8230A935},
{ 0x363C , 0x8230A936},
{ 0x363D , 0x8230A937},
{ 0x363E , 0x8230A938},
{ 0x363F , 0x8230A939},
{ 0x3640 , 0x8230AA30},
{ 0x3641 , 0x8230AA31},
{ 0x3642 , 0x8230AA32},
{ 0x3643 , 0x8230AA33},
{ 0x3644 , 0x8230AA34},
{ 0x3645 , 0x8230AA35},
{ 0x3646 , 0x8230AA36},
{ 0x3647 , 0x8230AA37},
{ 0x3648 , 0x8230AA38},
{ 0x3649 , 0x8230AA39},
{ 0x364A , 0x8230AB30},
{ 0x364B , 0x8230AB31},
{ 0x364C , 0x8230AB32},
{ 0x364D , 0x8230AB33},
{ 0x364E , 0x8230AB34},
{ 0x364F , 0x8230AB35},
{ 0x3650 , 0x8230AB36},
{ 0x3651 , 0x8230AB37},
{ 0x3652 , 0x8230AB38},
{ 0x3653 , 0x8230AB39},
{ 0x3654 , 0x8230AC30},
{ 0x3655 , 0x8230AC31},
{ 0x3656 , 0x8230AC32},
{ 0x3657 , 0x8230AC33},
{ 0x3658 , 0x8230AC34},
{ 0x3659 , 0x8230AC35},
{ 0x365A , 0x8230AC36},
{ 0x365B , 0x8230AC37},
{ 0x365C , 0x8230AC38},
{ 0x365D , 0x8230AC39},
{ 0x365E , 0x8230AD30},
{ 0x365F , 0x8230AD31},
{ 0x3660 , 0x8230AD32},
{ 0x3661 , 0x8230AD33},
{ 0x3662 , 0x8230AD34},
{ 0x3663 , 0x8230AD35},
{ 0x3664 , 0x8230AD36},
{ 0x3665 , 0x8230AD37},
{ 0x3666 , 0x8230AD38},
{ 0x3667 , 0x8230AD39},
{ 0x3668 , 0x8230AE30},
{ 0x3669 , 0x8230AE31},
{ 0x366A , 0x8230AE32},
{ 0x366B , 0x8230AE33},
{ 0x366C , 0x8230AE34},
{ 0x366D , 0x8230AE35},
{ 0x366E , 0x8230AE36},
{ 0x366F , 0x8230AE37},
{ 0x3670 , 0x8230AE38},
{ 0x3671 , 0x8230AE39},
{ 0x3672 , 0x8230AF30},
{ 0x3673 , 0x8230AF31},
{ 0x3674 , 0x8230AF32},
{ 0x3675 , 0x8230AF33},
{ 0x3676 , 0x8230AF34},
{ 0x3677 , 0x8230AF35},
{ 0x3678 , 0x8230AF36},
{ 0x3679 , 0x8230AF37},
{ 0x367A , 0x8230AF38},
{ 0x367B , 0x8230AF39},
{ 0x367C , 0x8230B030},
{ 0x367D , 0x8230B031},
{ 0x367E , 0x8230B032},
{ 0x367F , 0x8230B033},
{ 0x3680 , 0x8230B034},
{ 0x3681 , 0x8230B035},
{ 0x3682 , 0x8230B036},
{ 0x3683 , 0x8230B037},
{ 0x3684 , 0x8230B038},
{ 0x3685 , 0x8230B039},
{ 0x3686 , 0x8230B130},
{ 0x3687 , 0x8230B131},
{ 0x3688 , 0x8230B132},
{ 0x3689 , 0x8230B133},
{ 0x368A , 0x8230B134},
{ 0x368B , 0x8230B135},
{ 0x368C , 0x8230B136},
{ 0x368D , 0x8230B137},
{ 0x368E , 0x8230B138},
{ 0x368F , 0x8230B139},
{ 0x3690 , 0x8230B230},
{ 0x3691 , 0x8230B231},
{ 0x3692 , 0x8230B232},
{ 0x3693 , 0x8230B233},
{ 0x3694 , 0x8230B234},
{ 0x3695 , 0x8230B235},
{ 0x3696 , 0x8230B236},
{ 0x3697 , 0x8230B237},
{ 0x3698 , 0x8230B238},
{ 0x3699 , 0x8230B239},
{ 0x369A , 0x8230B330},
{ 0x369B , 0x8230B331},
{ 0x369C , 0x8230B332},
{ 0x369D , 0x8230B333},
{ 0x369E , 0x8230B334},
{ 0x369F , 0x8230B335},
{ 0x36A0 , 0x8230B336},
{ 0x36A1 , 0x8230B337},
{ 0x36A2 , 0x8230B338},
{ 0x36A3 , 0x8230B339},
{ 0x36A4 , 0x8230B430},
{ 0x36A5 , 0x8230B431},
{ 0x36A6 , 0x8230B432},
{ 0x36A7 , 0x8230B433},
{ 0x36A8 , 0x8230B434},
{ 0x36A9 , 0x8230B435},
{ 0x36AA , 0x8230B436},
{ 0x36AB , 0x8230B437},
{ 0x36AC , 0x8230B438},
{ 0x36AD , 0x8230B439},
{ 0x36AE , 0x8230B530},
{ 0x36AF , 0x8230B531},
{ 0x36B0 , 0x8230B532},
{ 0x36B1 , 0x8230B533},
{ 0x36B2 , 0x8230B534},
{ 0x36B3 , 0x8230B535},
{ 0x36B4 , 0x8230B536},
{ 0x36B5 , 0x8230B537},
{ 0x36B6 , 0x8230B538},
{ 0x36B7 , 0x8230B539},
{ 0x36B8 , 0x8230B630},
{ 0x36B9 , 0x8230B631},
{ 0x36BA , 0x8230B632},
{ 0x36BB , 0x8230B633},
{ 0x36BC , 0x8230B634},
{ 0x36BD , 0x8230B635},
{ 0x36BE , 0x8230B636},
{ 0x36BF , 0x8230B637},
{ 0x36C0 , 0x8230B638},
{ 0x36C1 , 0x8230B639},
{ 0x36C2 , 0x8230B730},
{ 0x36C3 , 0x8230B731},
{ 0x36C4 , 0x8230B732},
{ 0x36C5 , 0x8230B733},
{ 0x36C6 , 0x8230B734},
{ 0x36C7 , 0x8230B735},
{ 0x36C8 , 0x8230B736},
{ 0x36C9 , 0x8230B737},
{ 0x36CA , 0x8230B738},
{ 0x36CB , 0x8230B739},
{ 0x36CC , 0x8230B830},
{ 0x36CD , 0x8230B831},
{ 0x36CE , 0x8230B832},
{ 0x36CF , 0x8230B833},
{ 0x36D0 , 0x8230B834},
{ 0x36D1 , 0x8230B835},
{ 0x36D2 , 0x8230B836},
{ 0x36D3 , 0x8230B837},
{ 0x36D4 , 0x8230B838},
{ 0x36D5 , 0x8230B839},
{ 0x36D6 , 0x8230B930},
{ 0x36D7 , 0x8230B931},
{ 0x36D8 , 0x8230B932},
{ 0x36D9 , 0x8230B933},
{ 0x36DA , 0x8230B934},
{ 0x36DB , 0x8230B935},
{ 0x36DC , 0x8230B936},
{ 0x36DD , 0x8230B937},
{ 0x36DE , 0x8230B938},
{ 0x36DF , 0x8230B939},
{ 0x36E0 , 0x8230BA30},
{ 0x36E1 , 0x8230BA31},
{ 0x36E2 , 0x8230BA32},
{ 0x36E3 , 0x8230BA33},
{ 0x36E4 , 0x8230BA34},
{ 0x36E5 , 0x8230BA35},
{ 0x36E6 , 0x8230BA36},
{ 0x36E7 , 0x8230BA37},
{ 0x36E8 , 0x8230BA38},
{ 0x36E9 , 0x8230BA39},
{ 0x36EA , 0x8230BB30},
{ 0x36EB , 0x8230BB31},
{ 0x36EC , 0x8230BB32},
{ 0x36ED , 0x8230BB33},
{ 0x36EE , 0x8230BB34},
{ 0x36EF , 0x8230BB35},
{ 0x36F0 , 0x8230BB36},
{ 0x36F1 , 0x8230BB37},
{ 0x36F2 , 0x8230BB38},
{ 0x36F3 , 0x8230BB39},
{ 0x36F4 , 0x8230BC30},
{ 0x36F5 , 0x8230BC31},
{ 0x36F6 , 0x8230BC32},
{ 0x36F7 , 0x8230BC33},
{ 0x36F8 , 0x8230BC34},
{ 0x36F9 , 0x8230BC35},
{ 0x36FA , 0x8230BC36},
{ 0x36FB , 0x8230BC37},
{ 0x36FC , 0x8230BC38},
{ 0x36FD , 0x8230BC39},
{ 0x36FE , 0x8230BD30},
{ 0x36FF , 0x8230BD31},
{ 0x3700 , 0x8230BD32},
{ 0x3701 , 0x8230BD33},
{ 0x3702 , 0x8230BD34},
{ 0x3703 , 0x8230BD35},
{ 0x3704 , 0x8230BD36},
{ 0x3705 , 0x8230BD37},
{ 0x3706 , 0x8230BD38},
{ 0x3707 , 0x8230BD39},
{ 0x3708 , 0x8230BE30},
{ 0x3709 , 0x8230BE31},
{ 0x370A , 0x8230BE32},
{ 0x370B , 0x8230BE33},
{ 0x370C , 0x8230BE34},
{ 0x370D , 0x8230BE35},
{ 0x370E , 0x8230BE36},
{ 0x370F , 0x8230BE37},
{ 0x3710 , 0x8230BE38},
{ 0x3711 , 0x8230BE39},
{ 0x3712 , 0x8230BF30},
{ 0x3713 , 0x8230BF31},
{ 0x3714 , 0x8230BF32},
{ 0x3715 , 0x8230BF33},
{ 0x3716 , 0x8230BF34},
{ 0x3717 , 0x8230BF35},
{ 0x3718 , 0x8230BF36},
{ 0x3719 , 0x8230BF37},
{ 0x371A , 0x8230BF38},
{ 0x371B , 0x8230BF39},
{ 0x371C , 0x8230C030},
{ 0x371D , 0x8230C031},
{ 0x371E , 0x8230C032},
{ 0x371F , 0x8230C033},
{ 0x3720 , 0x8230C034},
{ 0x3721 , 0x8230C035},
{ 0x3722 , 0x8230C036},
{ 0x3723 , 0x8230C037},
{ 0x3724 , 0x8230C038},
{ 0x3725 , 0x8230C039},
{ 0x3726 , 0x8230C130},
{ 0x3727 , 0x8230C131},
{ 0x3728 , 0x8230C132},
{ 0x3729 , 0x8230C133},
{ 0x372A , 0x8230C134},
{ 0x372B , 0x8230C135},
{ 0x372C , 0x8230C136},
{ 0x372D , 0x8230C137},
{ 0x372E , 0x8230C138},
{ 0x372F , 0x8230C139},
{ 0x3730 , 0x8230C230},
{ 0x3731 , 0x8230C231},
{ 0x3732 , 0x8230C232},
{ 0x3733 , 0x8230C233},
{ 0x3734 , 0x8230C234},
{ 0x3735 , 0x8230C235},
{ 0x3736 , 0x8230C236},
{ 0x3737 , 0x8230C237},
{ 0x3738 , 0x8230C238},
{ 0x3739 , 0x8230C239},
{ 0x373A , 0x8230C330},
{ 0x373B , 0x8230C331},
{ 0x373C , 0x8230C332},
{ 0x373D , 0x8230C333},
{ 0x373E , 0x8230C334},
{ 0x373F , 0x8230C335},
{ 0x3740 , 0x8230C336},
{ 0x3741 , 0x8230C337},
{ 0x3742 , 0x8230C338},
{ 0x3743 , 0x8230C339},
{ 0x3744 , 0x8230C430},
{ 0x3745 , 0x8230C431},
{ 0x3746 , 0x8230C432},
{ 0x3747 , 0x8230C433},
{ 0x3748 , 0x8230C434},
{ 0x3749 , 0x8230C435},
{ 0x374A , 0x8230C436},
{ 0x374B , 0x8230C437},
{ 0x374C , 0x8230C438},
{ 0x374D , 0x8230C439},
{ 0x374E , 0x8230C530},
{ 0x374F , 0x8230C531},
{ 0x3750 , 0x8230C532},
{ 0x3751 , 0x8230C533},
{ 0x3752 , 0x8230C534},
{ 0x3753 , 0x8230C535},
{ 0x3754 , 0x8230C536},
{ 0x3755 , 0x8230C537},
{ 0x3756 , 0x8230C538},
{ 0x3757 , 0x8230C539},
{ 0x3758 , 0x8230C630},
{ 0x3759 , 0x8230C631},
{ 0x375A , 0x8230C632},
{ 0x375B , 0x8230C633},
{ 0x375C , 0x8230C634},
{ 0x375D , 0x8230C635},
{ 0x375E , 0x8230C636},
{ 0x375F , 0x8230C637},
{ 0x3760 , 0x8230C638},
{ 0x3761 , 0x8230C639},
{ 0x3762 , 0x8230C730},
{ 0x3763 , 0x8230C731},
{ 0x3764 , 0x8230C732},
{ 0x3765 , 0x8230C733},
{ 0x3766 , 0x8230C734},
{ 0x3767 , 0x8230C735},
{ 0x3768 , 0x8230C736},
{ 0x3769 , 0x8230C737},
{ 0x376A , 0x8230C738},
{ 0x376B , 0x8230C739},
{ 0x376C , 0x8230C830},
{ 0x376D , 0x8230C831},
{ 0x376E , 0x8230C832},
{ 0x376F , 0x8230C833},
{ 0x3770 , 0x8230C834},
{ 0x3771 , 0x8230C835},
{ 0x3772 , 0x8230C836},
{ 0x3773 , 0x8230C837},
{ 0x3774 , 0x8230C838},
{ 0x3775 , 0x8230C839},
{ 0x3776 , 0x8230C930},
{ 0x3777 , 0x8230C931},
{ 0x3778 , 0x8230C932},
{ 0x3779 , 0x8230C933},
{ 0x377A , 0x8230C934},
{ 0x377B , 0x8230C935},
{ 0x377C , 0x8230C936},
{ 0x377D , 0x8230C937},
{ 0x377E , 0x8230C938},
{ 0x377F , 0x8230C939},
{ 0x3780 , 0x8230CA30},
{ 0x3781 , 0x8230CA31},
{ 0x3782 , 0x8230CA32},
{ 0x3783 , 0x8230CA33},
{ 0x3784 , 0x8230CA34},
{ 0x3785 , 0x8230CA35},
{ 0x3786 , 0x8230CA36},
{ 0x3787 , 0x8230CA37},
{ 0x3788 , 0x8230CA38},
{ 0x3789 , 0x8230CA39},
{ 0x378A , 0x8230CB30},
{ 0x378B , 0x8230CB31},
{ 0x378C , 0x8230CB32},
{ 0x378D , 0x8230CB33},
{ 0x378E , 0x8230CB34},
{ 0x378F , 0x8230CB35},
{ 0x3790 , 0x8230CB36},
{ 0x3791 , 0x8230CB37},
{ 0x3792 , 0x8230CB38},
{ 0x3793 , 0x8230CB39},
{ 0x3794 , 0x8230CC30},
{ 0x3795 , 0x8230CC31},
{ 0x3796 , 0x8230CC32},
{ 0x3797 , 0x8230CC33},
{ 0x3798 , 0x8230CC34},
{ 0x3799 , 0x8230CC35},
{ 0x379A , 0x8230CC36},
{ 0x379B , 0x8230CC37},
{ 0x379C , 0x8230CC38},
{ 0x379D , 0x8230CC39},
{ 0x379E , 0x8230CD30},
{ 0x379F , 0x8230CD31},
{ 0x37A0 , 0x8230CD32},
{ 0x37A1 , 0x8230CD33},
{ 0x37A2 , 0x8230CD34},
{ 0x37A3 , 0x8230CD35},
{ 0x37A4 , 0x8230CD36},
{ 0x37A5 , 0x8230CD37},
{ 0x37A6 , 0x8230CD38},
{ 0x37A7 , 0x8230CD39},
{ 0x37A8 , 0x8230CE30},
{ 0x37A9 , 0x8230CE31},
{ 0x37AA , 0x8230CE32},
{ 0x37AB , 0x8230CE33},
{ 0x37AC , 0x8230CE34},
{ 0x37AD , 0x8230CE35},
{ 0x37AE , 0x8230CE36},
{ 0x37AF , 0x8230CE37},
{ 0x37B0 , 0x8230CE38},
{ 0x37B1 , 0x8230CE39},
{ 0x37B2 , 0x8230CF30},
{ 0x37B3 , 0x8230CF31},
{ 0x37B4 , 0x8230CF32},
{ 0x37B5 , 0x8230CF33},
{ 0x37B6 , 0x8230CF34},
{ 0x37B7 , 0x8230CF35},
{ 0x37B8 , 0x8230CF36},
{ 0x37B9 , 0x8230CF37},
{ 0x37BA , 0x8230CF38},
{ 0x37BB , 0x8230CF39},
{ 0x37BC , 0x8230D030},
{ 0x37BD , 0x8230D031},
{ 0x37BE , 0x8230D032},
{ 0x37BF , 0x8230D033},
{ 0x37C0 , 0x8230D034},
{ 0x37C1 , 0x8230D035},
{ 0x37C2 , 0x8230D036},
{ 0x37C3 , 0x8230D037},
{ 0x37C4 , 0x8230D038},
{ 0x37C5 , 0x8230D039},
{ 0x37C6 , 0x8230D130},
{ 0x37C7 , 0x8230D131},
{ 0x37C8 , 0x8230D132},
{ 0x37C9 , 0x8230D133},
{ 0x37CA , 0x8230D134},
{ 0x37CB , 0x8230D135},
{ 0x37CC , 0x8230D136},
{ 0x37CD , 0x8230D137},
{ 0x37CE , 0x8230D138},
{ 0x37CF , 0x8230D139},
{ 0x37D0 , 0x8230D230},
{ 0x37D1 , 0x8230D231},
{ 0x37D2 , 0x8230D232},
{ 0x37D3 , 0x8230D233},
{ 0x37D4 , 0x8230D234},
{ 0x37D5 , 0x8230D235},
{ 0x37D6 , 0x8230D236},
{ 0x37D7 , 0x8230D237},
{ 0x37D8 , 0x8230D238},
{ 0x37D9 , 0x8230D239},
{ 0x37DA , 0x8230D330},
{ 0x37DB , 0x8230D331},
{ 0x37DC , 0x8230D332},
{ 0x37DD , 0x8230D333},
{ 0x37DE , 0x8230D334},
{ 0x37DF , 0x8230D335},
{ 0x37E0 , 0x8230D336},
{ 0x37E1 , 0x8230D337},
{ 0x37E2 , 0x8230D338},
{ 0x37E3 , 0x8230D339},
{ 0x37E4 , 0x8230D430},
{ 0x37E5 , 0x8230D431},
{ 0x37E6 , 0x8230D432},
{ 0x37E7 , 0x8230D433},
{ 0x37E8 , 0x8230D434},
{ 0x37E9 , 0x8230D435},
{ 0x37EA , 0x8230D436},
{ 0x37EB , 0x8230D437},
{ 0x37EC , 0x8230D438},
{ 0x37ED , 0x8230D439},
{ 0x37EE , 0x8230D530},
{ 0x37EF , 0x8230D531},
{ 0x37F0 , 0x8230D532},
{ 0x37F1 , 0x8230D533},
{ 0x37F2 , 0x8230D534},
{ 0x37F3 , 0x8230D535},
{ 0x37F4 , 0x8230D536},
{ 0x37F5 , 0x8230D537},
{ 0x37F6 , 0x8230D538},
{ 0x37F7 , 0x8230D539},
{ 0x37F8 , 0x8230D630},
{ 0x37F9 , 0x8230D631},
{ 0x37FA , 0x8230D632},
{ 0x37FB , 0x8230D633},
{ 0x37FC , 0x8230D634},
{ 0x37FD , 0x8230D635},
{ 0x37FE , 0x8230D636},
{ 0x37FF , 0x8230D637},
{ 0x3800 , 0x8230D638},
{ 0x3801 , 0x8230D639},
{ 0x3802 , 0x8230D730},
{ 0x3803 , 0x8230D731},
{ 0x3804 , 0x8230D732},
{ 0x3805 , 0x8230D733},
{ 0x3806 , 0x8230D734},
{ 0x3807 , 0x8230D735},
{ 0x3808 , 0x8230D736},
{ 0x3809 , 0x8230D737},
{ 0x380A , 0x8230D738},
{ 0x380B , 0x8230D739},
{ 0x380C , 0x8230D830},
{ 0x380D , 0x8230D831},
{ 0x380E , 0x8230D832},
{ 0x380F , 0x8230D833},
{ 0x3810 , 0x8230D834},
{ 0x3811 , 0x8230D835},
{ 0x3812 , 0x8230D836},
{ 0x3813 , 0x8230D837},
{ 0x3814 , 0x8230D838},
{ 0x3815 , 0x8230D839},
{ 0x3816 , 0x8230D930},
{ 0x3817 , 0x8230D931},
{ 0x3818 , 0x8230D932},
{ 0x3819 , 0x8230D933},
{ 0x381A , 0x8230D934},
{ 0x381B , 0x8230D935},
{ 0x381C , 0x8230D936},
{ 0x381D , 0x8230D937},
{ 0x381E , 0x8230D938},
{ 0x381F , 0x8230D939},
{ 0x3820 , 0x8230DA30},
{ 0x3821 , 0x8230DA31},
{ 0x3822 , 0x8230DA32},
{ 0x3823 , 0x8230DA33},
{ 0x3824 , 0x8230DA34},
{ 0x3825 , 0x8230DA35},
{ 0x3826 , 0x8230DA36},
{ 0x3827 , 0x8230DA37},
{ 0x3828 , 0x8230DA38},
{ 0x3829 , 0x8230DA39},
{ 0x382A , 0x8230DB30},
{ 0x382B , 0x8230DB31},
{ 0x382C , 0x8230DB32},
{ 0x382D , 0x8230DB33},
{ 0x382E , 0x8230DB34},
{ 0x382F , 0x8230DB35},
{ 0x3830 , 0x8230DB36},
{ 0x3831 , 0x8230DB37},
{ 0x3832 , 0x8230DB38},
{ 0x3833 , 0x8230DB39},
{ 0x3834 , 0x8230DC30},
{ 0x3835 , 0x8230DC31},
{ 0x3836 , 0x8230DC32},
{ 0x3837 , 0x8230DC33},
{ 0x3838 , 0x8230DC34},
{ 0x3839 , 0x8230DC35},
{ 0x383A , 0x8230DC36},
{ 0x383B , 0x8230DC37},
{ 0x383C , 0x8230DC38},
{ 0x383D , 0x8230DC39},
{ 0x383E , 0x8230DD30},
{ 0x383F , 0x8230DD31},
{ 0x3840 , 0x8230DD32},
{ 0x3841 , 0x8230DD33},
{ 0x3842 , 0x8230DD34},
{ 0x3843 , 0x8230DD35},
{ 0x3844 , 0x8230DD36},
{ 0x3845 , 0x8230DD37},
{ 0x3846 , 0x8230DD38},
{ 0x3847 , 0x8230DD39},
{ 0x3848 , 0x8230DE30},
{ 0x3849 , 0x8230DE31},
{ 0x384A , 0x8230DE32},
{ 0x384B , 0x8230DE33},
{ 0x384C , 0x8230DE34},
{ 0x384D , 0x8230DE35},
{ 0x384E , 0x8230DE36},
{ 0x384F , 0x8230DE37},
{ 0x3850 , 0x8230DE38},
{ 0x3851 , 0x8230DE39},
{ 0x3852 , 0x8230DF30},
{ 0x3853 , 0x8230DF31},
{ 0x3854 , 0x8230DF32},
{ 0x3855 , 0x8230DF33},
{ 0x3856 , 0x8230DF34},
{ 0x3857 , 0x8230DF35},
{ 0x3858 , 0x8230DF36},
{ 0x3859 , 0x8230DF37},
{ 0x385A , 0x8230DF38},
{ 0x385B , 0x8230DF39},
{ 0x385C , 0x8230E030},
{ 0x385D , 0x8230E031},
{ 0x385E , 0x8230E032},
{ 0x385F , 0x8230E033},
{ 0x3860 , 0x8230E034},
{ 0x3861 , 0x8230E035},
{ 0x3862 , 0x8230E036},
{ 0x3863 , 0x8230E037},
{ 0x3864 , 0x8230E038},
{ 0x3865 , 0x8230E039},
{ 0x3866 , 0x8230E130},
{ 0x3867 , 0x8230E131},
{ 0x3868 , 0x8230E132},
{ 0x3869 , 0x8230E133},
{ 0x386A , 0x8230E134},
{ 0x386B , 0x8230E135},
{ 0x386C , 0x8230E136},
{ 0x386D , 0x8230E137},
{ 0x386E , 0x8230E138},
{ 0x386F , 0x8230E139},
{ 0x3870 , 0x8230E230},
{ 0x3871 , 0x8230E231},
{ 0x3872 , 0x8230E232},
{ 0x3873 , 0x8230E233},
{ 0x3874 , 0x8230E234},
{ 0x3875 , 0x8230E235},
{ 0x3876 , 0x8230E236},
{ 0x3877 , 0x8230E237},
{ 0x3878 , 0x8230E238},
{ 0x3879 , 0x8230E239},
{ 0x387A , 0x8230E330},
{ 0x387B , 0x8230E331},
{ 0x387C , 0x8230E332},
{ 0x387D , 0x8230E333},
{ 0x387E , 0x8230E334},
{ 0x387F , 0x8230E335},
{ 0x3880 , 0x8230E336},
{ 0x3881 , 0x8230E337},
{ 0x3882 , 0x8230E338},
{ 0x3883 , 0x8230E339},
{ 0x3884 , 0x8230E430},
{ 0x3885 , 0x8230E431},
{ 0x3886 , 0x8230E432},
{ 0x3887 , 0x8230E433},
{ 0x3888 , 0x8230E434},
{ 0x3889 , 0x8230E435},
{ 0x388A , 0x8230E436},
{ 0x388B , 0x8230E437},
{ 0x388C , 0x8230E438},
{ 0x388D , 0x8230E439},
{ 0x388E , 0x8230E530},
{ 0x388F , 0x8230E531},
{ 0x3890 , 0x8230E532},
{ 0x3891 , 0x8230E533},
{ 0x3892 , 0x8230E534},
{ 0x3893 , 0x8230E535},
{ 0x3894 , 0x8230E536},
{ 0x3895 , 0x8230E537},
{ 0x3896 , 0x8230E538},
{ 0x3897 , 0x8230E539},
{ 0x3898 , 0x8230E630},
{ 0x3899 , 0x8230E631},
{ 0x389A , 0x8230E632},
{ 0x389B , 0x8230E633},
{ 0x389C , 0x8230E634},
{ 0x389D , 0x8230E635},
{ 0x389E , 0x8230E636},
{ 0x389F , 0x8230E637},
{ 0x38A0 , 0x8230E638},
{ 0x38A1 , 0x8230E639},
{ 0x38A2 , 0x8230E730},
{ 0x38A3 , 0x8230E731},
{ 0x38A4 , 0x8230E732},
{ 0x38A5 , 0x8230E733},
{ 0x38A6 , 0x8230E734},
{ 0x38A7 , 0x8230E735},
{ 0x38A8 , 0x8230E736},
{ 0x38A9 , 0x8230E737},
{ 0x38AA , 0x8230E738},
{ 0x38AB , 0x8230E739},
{ 0x38AC , 0x8230E830},
{ 0x38AD , 0x8230E831},
{ 0x38AE , 0x8230E832},
{ 0x38AF , 0x8230E833},
{ 0x38B0 , 0x8230E834},
{ 0x38B1 , 0x8230E835},
{ 0x38B2 , 0x8230E836},
{ 0x38B3 , 0x8230E837},
{ 0x38B4 , 0x8230E838},
{ 0x38B5 , 0x8230E839},
{ 0x38B6 , 0x8230E930},
{ 0x38B7 , 0x8230E931},
{ 0x38B8 , 0x8230E932},
{ 0x38B9 , 0x8230E933},
{ 0x38BA , 0x8230E934},
{ 0x38BB , 0x8230E935},
{ 0x38BC , 0x8230E936},
{ 0x38BD , 0x8230E937},
{ 0x38BE , 0x8230E938},
{ 0x38BF , 0x8230E939},
{ 0x38C0 , 0x8230EA30},
{ 0x38C1 , 0x8230EA31},
{ 0x38C2 , 0x8230EA32},
{ 0x38C3 , 0x8230EA33},
{ 0x38C4 , 0x8230EA34},
{ 0x38C5 , 0x8230EA35},
{ 0x38C6 , 0x8230EA36},
{ 0x38C7 , 0x8230EA37},
{ 0x38C8 , 0x8230EA38},
{ 0x38C9 , 0x8230EA39},
{ 0x38CA , 0x8230EB30},
{ 0x38CB , 0x8230EB31},
{ 0x38CC , 0x8230EB32},
{ 0x38CD , 0x8230EB33},
{ 0x38CE , 0x8230EB34},
{ 0x38CF , 0x8230EB35},
{ 0x38D0 , 0x8230EB36},
{ 0x38D1 , 0x8230EB37},
{ 0x38D2 , 0x8230EB38},
{ 0x38D3 , 0x8230EB39},
{ 0x38D4 , 0x8230EC30},
{ 0x38D5 , 0x8230EC31},
{ 0x38D6 , 0x8230EC32},
{ 0x38D7 , 0x8230EC33},
{ 0x38D8 , 0x8230EC34},
{ 0x38D9 , 0x8230EC35},
{ 0x38DA , 0x8230EC36},
{ 0x38DB , 0x8230EC37},
{ 0x38DC , 0x8230EC38},
{ 0x38DD , 0x8230EC39},
{ 0x38DE , 0x8230ED30},
{ 0x38DF , 0x8230ED31},
{ 0x38E0 , 0x8230ED32},
{ 0x38E1 , 0x8230ED33},
{ 0x38E2 , 0x8230ED34},
{ 0x38E3 , 0x8230ED35},
{ 0x38E4 , 0x8230ED36},
{ 0x38E5 , 0x8230ED37},
{ 0x38E6 , 0x8230ED38},
{ 0x38E7 , 0x8230ED39},
{ 0x38E8 , 0x8230EE30},
{ 0x38E9 , 0x8230EE31},
{ 0x38EA , 0x8230EE32},
{ 0x38EB , 0x8230EE33},
{ 0x38EC , 0x8230EE34},
{ 0x38ED , 0x8230EE35},
{ 0x38EE , 0x8230EE36},
{ 0x38EF , 0x8230EE37},
{ 0x38F0 , 0x8230EE38},
{ 0x38F1 , 0x8230EE39},
{ 0x38F2 , 0x8230EF30},
{ 0x38F3 , 0x8230EF31},
{ 0x38F4 , 0x8230EF32},
{ 0x38F5 , 0x8230EF33},
{ 0x38F6 , 0x8230EF34},
{ 0x38F7 , 0x8230EF35},
{ 0x38F8 , 0x8230EF36},
{ 0x38F9 , 0x8230EF37},
{ 0x38FA , 0x8230EF38},
{ 0x38FB , 0x8230EF39},
{ 0x38FC , 0x8230F030},
{ 0x38FD , 0x8230F031},
{ 0x38FE , 0x8230F032},
{ 0x38FF , 0x8230F033},
{ 0x3900 , 0x8230F034},
{ 0x3901 , 0x8230F035},
{ 0x3902 , 0x8230F036},
{ 0x3903 , 0x8230F037},
{ 0x3904 , 0x8230F038},
{ 0x3905 , 0x8230F039},
{ 0x3906 , 0x8230F130},
{ 0x3907 , 0x8230F131},
{ 0x3908 , 0x8230F132},
{ 0x3909 , 0x8230F133},
{ 0x390A , 0x8230F134},
{ 0x390B , 0x8230F135},
{ 0x390C , 0x8230F136},
{ 0x390D , 0x8230F137},
{ 0x390E , 0x8230F138},
{ 0x390F , 0x8230F139},
{ 0x3910 , 0x8230F230},
{ 0x3911 , 0x8230F231},
{ 0x3912 , 0x8230F232},
{ 0x3913 , 0x8230F233},
{ 0x3914 , 0x8230F234},
{ 0x3915 , 0x8230F235},
{ 0x3916 , 0x8230F236},
{ 0x3917 , 0x8230F237},
{ 0x3919 , 0x8230F238},
{ 0x391A , 0x8230F239},
{ 0x391B , 0x8230F330},
{ 0x391C , 0x8230F331},
{ 0x391D , 0x8230F332},
{ 0x391E , 0x8230F333},
{ 0x391F , 0x8230F334},
{ 0x3920 , 0x8230F335},
{ 0x3921 , 0x8230F336},
{ 0x3922 , 0x8230F337},
{ 0x3923 , 0x8230F338},
{ 0x3924 , 0x8230F339},
{ 0x3925 , 0x8230F430},
{ 0x3926 , 0x8230F431},
{ 0x3927 , 0x8230F432},
{ 0x3928 , 0x8230F433},
{ 0x3929 , 0x8230F434},
{ 0x392A , 0x8230F435},
{ 0x392B , 0x8230F436},
{ 0x392C , 0x8230F437},
{ 0x392D , 0x8230F438},
{ 0x392E , 0x8230F439},
{ 0x392F , 0x8230F530},
{ 0x3930 , 0x8230F531},
{ 0x3931 , 0x8230F532},
{ 0x3932 , 0x8230F533},
{ 0x3933 , 0x8230F534},
{ 0x3934 , 0x8230F535},
{ 0x3935 , 0x8230F536},
{ 0x3936 , 0x8230F537},
{ 0x3937 , 0x8230F538},
{ 0x3938 , 0x8230F539},
{ 0x3939 , 0x8230F630},
{ 0x393A , 0x8230F631},
{ 0x393B , 0x8230F632},
{ 0x393C , 0x8230F633},
{ 0x393D , 0x8230F634},
{ 0x393E , 0x8230F635},
{ 0x393F , 0x8230F636},
{ 0x3940 , 0x8230F637},
{ 0x3941 , 0x8230F638},
{ 0x3942 , 0x8230F639},
{ 0x3943 , 0x8230F730},
{ 0x3944 , 0x8230F731},
{ 0x3945 , 0x8230F732},
{ 0x3946 , 0x8230F733},
{ 0x3947 , 0x8230F734},
{ 0x3948 , 0x8230F735},
{ 0x3949 , 0x8230F736},
{ 0x394A , 0x8230F737},
{ 0x394B , 0x8230F738},
{ 0x394C , 0x8230F739},
{ 0x394D , 0x8230F830},
{ 0x394E , 0x8230F831},
{ 0x394F , 0x8230F832},
{ 0x3950 , 0x8230F833},
{ 0x3951 , 0x8230F834},
{ 0x3952 , 0x8230F835},
{ 0x3953 , 0x8230F836},
{ 0x3954 , 0x8230F837},
{ 0x3955 , 0x8230F838},
{ 0x3956 , 0x8230F839},
{ 0x3957 , 0x8230F930},
{ 0x3958 , 0x8230F931},
{ 0x3959 , 0x8230F932},
{ 0x395A , 0x8230F933},
{ 0x395B , 0x8230F934},
{ 0x395C , 0x8230F935},
{ 0x395D , 0x8230F936},
{ 0x395E , 0x8230F937},
{ 0x395F , 0x8230F938},
{ 0x3960 , 0x8230F939},
{ 0x3961 , 0x8230FA30},
{ 0x3962 , 0x8230FA31},
{ 0x3963 , 0x8230FA32},
{ 0x3964 , 0x8230FA33},
{ 0x3965 , 0x8230FA34},
{ 0x3966 , 0x8230FA35},
{ 0x3967 , 0x8230FA36},
{ 0x3968 , 0x8230FA37},
{ 0x3969 , 0x8230FA38},
{ 0x396A , 0x8230FA39},
{ 0x396B , 0x8230FB30},
{ 0x396C , 0x8230FB31},
{ 0x396D , 0x8230FB32},
{ 0x396F , 0x8230FB33},
{ 0x3970 , 0x8230FB34},
{ 0x3971 , 0x8230FB35},
{ 0x3972 , 0x8230FB36},
{ 0x3973 , 0x8230FB37},
{ 0x3974 , 0x8230FB38},
{ 0x3975 , 0x8230FB39},
{ 0x3976 , 0x8230FC30},
{ 0x3977 , 0x8230FC31},
{ 0x3978 , 0x8230FC32},
{ 0x3979 , 0x8230FC33},
{ 0x397A , 0x8230FC34},
{ 0x397B , 0x8230FC35},
{ 0x397C , 0x8230FC36},
{ 0x397D , 0x8230FC37},
{ 0x397E , 0x8230FC38},
{ 0x397F , 0x8230FC39},
{ 0x3980 , 0x8230FD30},
{ 0x3981 , 0x8230FD31},
{ 0x3982 , 0x8230FD32},
{ 0x3983 , 0x8230FD33},
{ 0x3984 , 0x8230FD34},
{ 0x3985 , 0x8230FD35},
{ 0x3986 , 0x8230FD36},
{ 0x3987 , 0x8230FD37},
{ 0x3988 , 0x8230FD38},
{ 0x3989 , 0x8230FD39},
{ 0x398A , 0x8230FE30},
{ 0x398B , 0x8230FE31},
{ 0x398C , 0x8230FE32},
{ 0x398D , 0x8230FE33},
{ 0x398E , 0x8230FE34},
{ 0x398F , 0x8230FE35},
{ 0x3990 , 0x8230FE36},
{ 0x3991 , 0x8230FE37},
{ 0x3992 , 0x8230FE38},
{ 0x3993 , 0x8230FE39},
{ 0x3994 , 0x82318130},
{ 0x3995 , 0x82318131},
{ 0x3996 , 0x82318132},
{ 0x3997 , 0x82318133},
{ 0x3998 , 0x82318134},
{ 0x3999 , 0x82318135},
{ 0x399A , 0x82318136},
{ 0x399B , 0x82318137},
{ 0x399C , 0x82318138},
{ 0x399D , 0x82318139},
{ 0x399E , 0x82318230},
{ 0x399F , 0x82318231},
{ 0x39A0 , 0x82318232},
{ 0x39A1 , 0x82318233},
{ 0x39A2 , 0x82318234},
{ 0x39A3 , 0x82318235},
{ 0x39A4 , 0x82318236},
{ 0x39A5 , 0x82318237},
{ 0x39A6 , 0x82318238},
{ 0x39A7 , 0x82318239},
{ 0x39A8 , 0x82318330},
{ 0x39A9 , 0x82318331},
{ 0x39AA , 0x82318332},
{ 0x39AB , 0x82318333},
{ 0x39AC , 0x82318334},
{ 0x39AD , 0x82318335},
{ 0x39AE , 0x82318336},
{ 0x39AF , 0x82318337},
{ 0x39B0 , 0x82318338},
{ 0x39B1 , 0x82318339},
{ 0x39B2 , 0x82318430},
{ 0x39B3 , 0x82318431},
{ 0x39B4 , 0x82318432},
{ 0x39B5 , 0x82318433},
{ 0x39B6 , 0x82318434},
{ 0x39B7 , 0x82318435},
{ 0x39B8 , 0x82318436},
{ 0x39B9 , 0x82318437},
{ 0x39BA , 0x82318438},
{ 0x39BB , 0x82318439},
{ 0x39BC , 0x82318530},
{ 0x39BD , 0x82318531},
{ 0x39BE , 0x82318532},
{ 0x39BF , 0x82318533},
{ 0x39C0 , 0x82318534},
{ 0x39C1 , 0x82318535},
{ 0x39C2 , 0x82318536},
{ 0x39C3 , 0x82318537},
{ 0x39C4 , 0x82318538},
{ 0x39C5 , 0x82318539},
{ 0x39C6 , 0x82318630},
{ 0x39C7 , 0x82318631},
{ 0x39C8 , 0x82318632},
{ 0x39C9 , 0x82318633},
{ 0x39CA , 0x82318634},
{ 0x39CB , 0x82318635},
{ 0x39CC , 0x82318636},
{ 0x39CD , 0x82318637},
{ 0x39CE , 0x82318638},
{ 0x39D1 , 0x82318639},
{ 0x39D2 , 0x82318730},
{ 0x39D3 , 0x82318731},
{ 0x39D4 , 0x82318732},
{ 0x39D5 , 0x82318733},
{ 0x39D6 , 0x82318734},
{ 0x39D7 , 0x82318735},
{ 0x39D8 , 0x82318736},
{ 0x39D9 , 0x82318737},
{ 0x39DA , 0x82318738},
{ 0x39DB , 0x82318739},
{ 0x39DC , 0x82318830},
{ 0x39DD , 0x82318831},
{ 0x39DE , 0x82318832},
{ 0x39E0 , 0x82318833},
{ 0x39E1 , 0x82318834},
{ 0x39E2 , 0x82318835},
{ 0x39E3 , 0x82318836},
{ 0x39E4 , 0x82318837},
{ 0x39E5 , 0x82318838},
{ 0x39E6 , 0x82318839},
{ 0x39E7 , 0x82318930},
{ 0x39E8 , 0x82318931},
{ 0x39E9 , 0x82318932},
{ 0x39EA , 0x82318933},
{ 0x39EB , 0x82318934},
{ 0x39EC , 0x82318935},
{ 0x39ED , 0x82318936},
{ 0x39EE , 0x82318937},
{ 0x39EF , 0x82318938},
{ 0x39F0 , 0x82318939},
{ 0x39F1 , 0x82318A30},
{ 0x39F2 , 0x82318A31},
{ 0x39F3 , 0x82318A32},
{ 0x39F4 , 0x82318A33},
{ 0x39F5 , 0x82318A34},
{ 0x39F6 , 0x82318A35},
{ 0x39F7 , 0x82318A36},
{ 0x39F8 , 0x82318A37},
{ 0x39F9 , 0x82318A38},
{ 0x39FA , 0x82318A39},
{ 0x39FB , 0x82318B30},
{ 0x39FC , 0x82318B31},
{ 0x39FD , 0x82318B32},
{ 0x39FE , 0x82318B33},
{ 0x39FF , 0x82318B34},
{ 0x3A00 , 0x82318B35},
{ 0x3A01 , 0x82318B36},
{ 0x3A02 , 0x82318B37},
{ 0x3A03 , 0x82318B38},
{ 0x3A04 , 0x82318B39},
{ 0x3A05 , 0x82318C30},
{ 0x3A06 , 0x82318C31},
{ 0x3A07 , 0x82318C32},
{ 0x3A08 , 0x82318C33},
{ 0x3A09 , 0x82318C34},
{ 0x3A0A , 0x82318C35},
{ 0x3A0B , 0x82318C36},
{ 0x3A0C , 0x82318C37},
{ 0x3A0D , 0x82318C38},
{ 0x3A0E , 0x82318C39},
{ 0x3A0F , 0x82318D30},
{ 0x3A10 , 0x82318D31},
{ 0x3A11 , 0x82318D32},
{ 0x3A12 , 0x82318D33},
{ 0x3A13 , 0x82318D34},
{ 0x3A14 , 0x82318D35},
{ 0x3A15 , 0x82318D36},
{ 0x3A16 , 0x82318D37},
{ 0x3A17 , 0x82318D38},
{ 0x3A18 , 0x82318D39},
{ 0x3A19 , 0x82318E30},
{ 0x3A1A , 0x82318E31},
{ 0x3A1B , 0x82318E32},
{ 0x3A1C , 0x82318E33},
{ 0x3A1D , 0x82318E34},
{ 0x3A1E , 0x82318E35},
{ 0x3A1F , 0x82318E36},
{ 0x3A20 , 0x82318E37},
{ 0x3A21 , 0x82318E38},
{ 0x3A22 , 0x82318E39},
{ 0x3A23 , 0x82318F30},
{ 0x3A24 , 0x82318F31},
{ 0x3A25 , 0x82318F32},
{ 0x3A26 , 0x82318F33},
{ 0x3A27 , 0x82318F34},
{ 0x3A28 , 0x82318F35},
{ 0x3A29 , 0x82318F36},
{ 0x3A2A , 0x82318F37},
{ 0x3A2B , 0x82318F38},
{ 0x3A2C , 0x82318F39},
{ 0x3A2D , 0x82319030},
{ 0x3A2E , 0x82319031},
{ 0x3A2F , 0x82319032},
{ 0x3A30 , 0x82319033},
{ 0x3A31 , 0x82319034},
{ 0x3A32 , 0x82319035},
{ 0x3A33 , 0x82319036},
{ 0x3A34 , 0x82319037},
{ 0x3A35 , 0x82319038},
{ 0x3A36 , 0x82319039},
{ 0x3A37 , 0x82319130},
{ 0x3A38 , 0x82319131},
{ 0x3A39 , 0x82319132},
{ 0x3A3A , 0x82319133},
{ 0x3A3B , 0x82319134},
{ 0x3A3C , 0x82319135},
{ 0x3A3D , 0x82319136},
{ 0x3A3E , 0x82319137},
{ 0x3A3F , 0x82319138},
{ 0x3A40 , 0x82319139},
{ 0x3A41 , 0x82319230},
{ 0x3A42 , 0x82319231},
{ 0x3A43 , 0x82319232},
{ 0x3A44 , 0x82319233},
{ 0x3A45 , 0x82319234},
{ 0x3A46 , 0x82319235},
{ 0x3A47 , 0x82319236},
{ 0x3A48 , 0x82319237},
{ 0x3A49 , 0x82319238},
{ 0x3A4A , 0x82319239},
{ 0x3A4B , 0x82319330},
{ 0x3A4C , 0x82319331},
{ 0x3A4D , 0x82319332},
{ 0x3A4E , 0x82319333},
{ 0x3A4F , 0x82319334},
{ 0x3A50 , 0x82319335},
{ 0x3A51 , 0x82319336},
{ 0x3A52 , 0x82319337},
{ 0x3A53 , 0x82319338},
{ 0x3A54 , 0x82319339},
{ 0x3A55 , 0x82319430},
{ 0x3A56 , 0x82319431},
{ 0x3A57 , 0x82319432},
{ 0x3A58 , 0x82319433},
{ 0x3A59 , 0x82319434},
{ 0x3A5A , 0x82319435},
{ 0x3A5B , 0x82319436},
{ 0x3A5C , 0x82319437},
{ 0x3A5D , 0x82319438},
{ 0x3A5E , 0x82319439},
{ 0x3A5F , 0x82319530},
{ 0x3A60 , 0x82319531},
{ 0x3A61 , 0x82319532},
{ 0x3A62 , 0x82319533},
{ 0x3A63 , 0x82319534},
{ 0x3A64 , 0x82319535},
{ 0x3A65 , 0x82319536},
{ 0x3A66 , 0x82319537},
{ 0x3A67 , 0x82319538},
{ 0x3A68 , 0x82319539},
{ 0x3A69 , 0x82319630},
{ 0x3A6A , 0x82319631},
{ 0x3A6B , 0x82319632},
{ 0x3A6C , 0x82319633},
{ 0x3A6D , 0x82319634},
{ 0x3A6E , 0x82319635},
{ 0x3A6F , 0x82319636},
{ 0x3A70 , 0x82319637},
{ 0x3A71 , 0x82319638},
{ 0x3A72 , 0x82319639},
{ 0x3A74 , 0x82319730},
{ 0x3A75 , 0x82319731},
{ 0x3A76 , 0x82319732},
{ 0x3A77 , 0x82319733},
{ 0x3A78 , 0x82319734},
{ 0x3A79 , 0x82319735},
{ 0x3A7A , 0x82319736},
{ 0x3A7B , 0x82319737},
{ 0x3A7C , 0x82319738},
{ 0x3A7D , 0x82319739},
{ 0x3A7E , 0x82319830},
{ 0x3A7F , 0x82319831},
{ 0x3A80 , 0x82319832},
{ 0x3A81 , 0x82319833},
{ 0x3A82 , 0x82319834},
{ 0x3A83 , 0x82319835},
{ 0x3A84 , 0x82319836},
{ 0x3A85 , 0x82319837},
{ 0x3A86 , 0x82319838},
{ 0x3A87 , 0x82319839},
{ 0x3A88 , 0x82319930},
{ 0x3A89 , 0x82319931},
{ 0x3A8A , 0x82319932},
{ 0x3A8B , 0x82319933},
{ 0x3A8C , 0x82319934},
{ 0x3A8D , 0x82319935},
{ 0x3A8E , 0x82319936},
{ 0x3A8F , 0x82319937},
{ 0x3A90 , 0x82319938},
{ 0x3A91 , 0x82319939},
{ 0x3A92 , 0x82319A30},
{ 0x3A93 , 0x82319A31},
{ 0x3A94 , 0x82319A32},
{ 0x3A95 , 0x82319A33},
{ 0x3A96 , 0x82319A34},
{ 0x3A97 , 0x82319A35},
{ 0x3A98 , 0x82319A36},
{ 0x3A99 , 0x82319A37},
{ 0x3A9A , 0x82319A38},
{ 0x3A9B , 0x82319A39},
{ 0x3A9C , 0x82319B30},
{ 0x3A9D , 0x82319B31},
{ 0x3A9E , 0x82319B32},
{ 0x3A9F , 0x82319B33},
{ 0x3AA0 , 0x82319B34},
{ 0x3AA1 , 0x82319B35},
{ 0x3AA2 , 0x82319B36},
{ 0x3AA3 , 0x82319B37},
{ 0x3AA4 , 0x82319B38},
{ 0x3AA5 , 0x82319B39},
{ 0x3AA6 , 0x82319C30},
{ 0x3AA7 , 0x82319C31},
{ 0x3AA8 , 0x82319C32},
{ 0x3AA9 , 0x82319C33},
{ 0x3AAA , 0x82319C34},
{ 0x3AAB , 0x82319C35},
{ 0x3AAC , 0x82319C36},
{ 0x3AAD , 0x82319C37},
{ 0x3AAE , 0x82319C38},
{ 0x3AAF , 0x82319C39},
{ 0x3AB0 , 0x82319D30},
{ 0x3AB1 , 0x82319D31},
{ 0x3AB2 , 0x82319D32},
{ 0x3AB3 , 0x82319D33},
{ 0x3AB4 , 0x82319D34},
{ 0x3AB5 , 0x82319D35},
{ 0x3AB6 , 0x82319D36},
{ 0x3AB7 , 0x82319D37},
{ 0x3AB8 , 0x82319D38},
{ 0x3AB9 , 0x82319D39},
{ 0x3ABA , 0x82319E30},
{ 0x3ABB , 0x82319E31},
{ 0x3ABC , 0x82319E32},
{ 0x3ABD , 0x82319E33},
{ 0x3ABE , 0x82319E34},
{ 0x3ABF , 0x82319E35},
{ 0x3AC0 , 0x82319E36},
{ 0x3AC1 , 0x82319E37},
{ 0x3AC2 , 0x82319E38},
{ 0x3AC3 , 0x82319E39},
{ 0x3AC4 , 0x82319F30},
{ 0x3AC5 , 0x82319F31},
{ 0x3AC6 , 0x82319F32},
{ 0x3AC7 , 0x82319F33},
{ 0x3AC8 , 0x82319F34},
{ 0x3AC9 , 0x82319F35},
{ 0x3ACA , 0x82319F36},
{ 0x3ACB , 0x82319F37},
{ 0x3ACC , 0x82319F38},
{ 0x3ACD , 0x82319F39},
{ 0x3ACE , 0x8231A030},
{ 0x3ACF , 0x8231A031},
{ 0x3AD0 , 0x8231A032},
{ 0x3AD1 , 0x8231A033},
{ 0x3AD2 , 0x8231A034},
{ 0x3AD3 , 0x8231A035},
{ 0x3AD4 , 0x8231A036},
{ 0x3AD5 , 0x8231A037},
{ 0x3AD6 , 0x8231A038},
{ 0x3AD7 , 0x8231A039},
{ 0x3AD8 , 0x8231A130},
{ 0x3AD9 , 0x8231A131},
{ 0x3ADA , 0x8231A132},
{ 0x3ADB , 0x8231A133},
{ 0x3ADC , 0x8231A134},
{ 0x3ADD , 0x8231A135},
{ 0x3ADE , 0x8231A136},
{ 0x3ADF , 0x8231A137},
{ 0x3AE0 , 0x8231A138},
{ 0x3AE1 , 0x8231A139},
{ 0x3AE2 , 0x8231A230},
{ 0x3AE3 , 0x8231A231},
{ 0x3AE4 , 0x8231A232},
{ 0x3AE5 , 0x8231A233},
{ 0x3AE6 , 0x8231A234},
{ 0x3AE7 , 0x8231A235},
{ 0x3AE8 , 0x8231A236},
{ 0x3AE9 , 0x8231A237},
{ 0x3AEA , 0x8231A238},
{ 0x3AEB , 0x8231A239},
{ 0x3AEC , 0x8231A330},
{ 0x3AED , 0x8231A331},
{ 0x3AEE , 0x8231A332},
{ 0x3AEF , 0x8231A333},
{ 0x3AF0 , 0x8231A334},
{ 0x3AF1 , 0x8231A335},
{ 0x3AF2 , 0x8231A336},
{ 0x3AF3 , 0x8231A337},
{ 0x3AF4 , 0x8231A338},
{ 0x3AF5 , 0x8231A339},
{ 0x3AF6 , 0x8231A430},
{ 0x3AF7 , 0x8231A431},
{ 0x3AF8 , 0x8231A432},
{ 0x3AF9 , 0x8231A433},
{ 0x3AFA , 0x8231A434},
{ 0x3AFB , 0x8231A435},
{ 0x3AFC , 0x8231A436},
{ 0x3AFD , 0x8231A437},
{ 0x3AFE , 0x8231A438},
{ 0x3AFF , 0x8231A439},
{ 0x3B00 , 0x8231A530},
{ 0x3B01 , 0x8231A531},
{ 0x3B02 , 0x8231A532},
{ 0x3B03 , 0x8231A533},
{ 0x3B04 , 0x8231A534},
{ 0x3B05 , 0x8231A535},
{ 0x3B06 , 0x8231A536},
{ 0x3B07 , 0x8231A537},
{ 0x3B08 , 0x8231A538},
{ 0x3B09 , 0x8231A539},
{ 0x3B0A , 0x8231A630},
{ 0x3B0B , 0x8231A631},
{ 0x3B0C , 0x8231A632},
{ 0x3B0D , 0x8231A633},
{ 0x3B0E , 0x8231A634},
{ 0x3B0F , 0x8231A635},
{ 0x3B10 , 0x8231A636},
{ 0x3B11 , 0x8231A637},
{ 0x3B12 , 0x8231A638},
{ 0x3B13 , 0x8231A639},
{ 0x3B14 , 0x8231A730},
{ 0x3B15 , 0x8231A731},
{ 0x3B16 , 0x8231A732},
{ 0x3B17 , 0x8231A733},
{ 0x3B18 , 0x8231A734},
{ 0x3B19 , 0x8231A735},
{ 0x3B1A , 0x8231A736},
{ 0x3B1B , 0x8231A737},
{ 0x3B1C , 0x8231A738},
{ 0x3B1D , 0x8231A739},
{ 0x3B1E , 0x8231A830},
{ 0x3B1F , 0x8231A831},
{ 0x3B20 , 0x8231A832},
{ 0x3B21 , 0x8231A833},
{ 0x3B22 , 0x8231A834},
{ 0x3B23 , 0x8231A835},
{ 0x3B24 , 0x8231A836},
{ 0x3B25 , 0x8231A837},
{ 0x3B26 , 0x8231A838},
{ 0x3B27 , 0x8231A839},
{ 0x3B28 , 0x8231A930},
{ 0x3B29 , 0x8231A931},
{ 0x3B2A , 0x8231A932},
{ 0x3B2B , 0x8231A933},
{ 0x3B2C , 0x8231A934},
{ 0x3B2D , 0x8231A935},
{ 0x3B2E , 0x8231A936},
{ 0x3B2F , 0x8231A937},
{ 0x3B30 , 0x8231A938},
{ 0x3B31 , 0x8231A939},
{ 0x3B32 , 0x8231AA30},
{ 0x3B33 , 0x8231AA31},
{ 0x3B34 , 0x8231AA32},
{ 0x3B35 , 0x8231AA33},
{ 0x3B36 , 0x8231AA34},
{ 0x3B37 , 0x8231AA35},
{ 0x3B38 , 0x8231AA36},
{ 0x3B39 , 0x8231AA37},
{ 0x3B3A , 0x8231AA38},
{ 0x3B3B , 0x8231AA39},
{ 0x3B3C , 0x8231AB30},
{ 0x3B3D , 0x8231AB31},
{ 0x3B3E , 0x8231AB32},
{ 0x3B3F , 0x8231AB33},
{ 0x3B40 , 0x8231AB34},
{ 0x3B41 , 0x8231AB35},
{ 0x3B42 , 0x8231AB36},
{ 0x3B43 , 0x8231AB37},
{ 0x3B44 , 0x8231AB38},
{ 0x3B45 , 0x8231AB39},
{ 0x3B46 , 0x8231AC30},
{ 0x3B47 , 0x8231AC31},
{ 0x3B48 , 0x8231AC32},
{ 0x3B49 , 0x8231AC33},
{ 0x3B4A , 0x8231AC34},
{ 0x3B4B , 0x8231AC35},
{ 0x3B4C , 0x8231AC36},
{ 0x3B4D , 0x8231AC37},
{ 0x3B4F , 0x8231AC38},
{ 0x3B50 , 0x8231AC39},
{ 0x3B51 , 0x8231AD30},
{ 0x3B52 , 0x8231AD31},
{ 0x3B53 , 0x8231AD32},
{ 0x3B54 , 0x8231AD33},
{ 0x3B55 , 0x8231AD34},
{ 0x3B56 , 0x8231AD35},
{ 0x3B57 , 0x8231AD36},
{ 0x3B58 , 0x8231AD37},
{ 0x3B59 , 0x8231AD38},
{ 0x3B5A , 0x8231AD39},
{ 0x3B5B , 0x8231AE30},
{ 0x3B5C , 0x8231AE31},
{ 0x3B5D , 0x8231AE32},
{ 0x3B5E , 0x8231AE33},
{ 0x3B5F , 0x8231AE34},
{ 0x3B60 , 0x8231AE35},
{ 0x3B61 , 0x8231AE36},
{ 0x3B62 , 0x8231AE37},
{ 0x3B63 , 0x8231AE38},
{ 0x3B64 , 0x8231AE39},
{ 0x3B65 , 0x8231AF30},
{ 0x3B66 , 0x8231AF31},
{ 0x3B67 , 0x8231AF32},
{ 0x3B68 , 0x8231AF33},
{ 0x3B69 , 0x8231AF34},
{ 0x3B6A , 0x8231AF35},
{ 0x3B6B , 0x8231AF36},
{ 0x3B6C , 0x8231AF37},
{ 0x3B6D , 0x8231AF38},
{ 0x3B6E , 0x8231AF39},
{ 0x3B6F , 0x8231B030},
{ 0x3B70 , 0x8231B031},
{ 0x3B71 , 0x8231B032},
{ 0x3B72 , 0x8231B033},
{ 0x3B73 , 0x8231B034},
{ 0x3B74 , 0x8231B035},
{ 0x3B75 , 0x8231B036},
{ 0x3B76 , 0x8231B037},
{ 0x3B77 , 0x8231B038},
{ 0x3B78 , 0x8231B039},
{ 0x3B79 , 0x8231B130},
{ 0x3B7A , 0x8231B131},
{ 0x3B7B , 0x8231B132},
{ 0x3B7C , 0x8231B133},
{ 0x3B7D , 0x8231B134},
{ 0x3B7E , 0x8231B135},
{ 0x3B7F , 0x8231B136},
{ 0x3B80 , 0x8231B137},
{ 0x3B81 , 0x8231B138},
{ 0x3B82 , 0x8231B139},
{ 0x3B83 , 0x8231B230},
{ 0x3B84 , 0x8231B231},
{ 0x3B85 , 0x8231B232},
{ 0x3B86 , 0x8231B233},
{ 0x3B87 , 0x8231B234},
{ 0x3B88 , 0x8231B235},
{ 0x3B89 , 0x8231B236},
{ 0x3B8A , 0x8231B237},
{ 0x3B8B , 0x8231B238},
{ 0x3B8C , 0x8231B239},
{ 0x3B8D , 0x8231B330},
{ 0x3B8E , 0x8231B331},
{ 0x3B8F , 0x8231B332},
{ 0x3B90 , 0x8231B333},
{ 0x3B91 , 0x8231B334},
{ 0x3B92 , 0x8231B335},
{ 0x3B93 , 0x8231B336},
{ 0x3B94 , 0x8231B337},
{ 0x3B95 , 0x8231B338},
{ 0x3B96 , 0x8231B339},
{ 0x3B97 , 0x8231B430},
{ 0x3B98 , 0x8231B431},
{ 0x3B99 , 0x8231B432},
{ 0x3B9A , 0x8231B433},
{ 0x3B9B , 0x8231B434},
{ 0x3B9C , 0x8231B435},
{ 0x3B9D , 0x8231B436},
{ 0x3B9E , 0x8231B437},
{ 0x3B9F , 0x8231B438},
{ 0x3BA0 , 0x8231B439},
{ 0x3BA1 , 0x8231B530},
{ 0x3BA2 , 0x8231B531},
{ 0x3BA3 , 0x8231B532},
{ 0x3BA4 , 0x8231B533},
{ 0x3BA5 , 0x8231B534},
{ 0x3BA6 , 0x8231B535},
{ 0x3BA7 , 0x8231B536},
{ 0x3BA8 , 0x8231B537},
{ 0x3BA9 , 0x8231B538},
{ 0x3BAA , 0x8231B539},
{ 0x3BAB , 0x8231B630},
{ 0x3BAC , 0x8231B631},
{ 0x3BAD , 0x8231B632},
{ 0x3BAE , 0x8231B633},
{ 0x3BAF , 0x8231B634},
{ 0x3BB0 , 0x8231B635},
{ 0x3BB1 , 0x8231B636},
{ 0x3BB2 , 0x8231B637},
{ 0x3BB3 , 0x8231B638},
{ 0x3BB4 , 0x8231B639},
{ 0x3BB5 , 0x8231B730},
{ 0x3BB6 , 0x8231B731},
{ 0x3BB7 , 0x8231B732},
{ 0x3BB8 , 0x8231B733},
{ 0x3BB9 , 0x8231B734},
{ 0x3BBA , 0x8231B735},
{ 0x3BBB , 0x8231B736},
{ 0x3BBC , 0x8231B737},
{ 0x3BBD , 0x8231B738},
{ 0x3BBE , 0x8231B739},
{ 0x3BBF , 0x8231B830},
{ 0x3BC0 , 0x8231B831},
{ 0x3BC1 , 0x8231B832},
{ 0x3BC2 , 0x8231B833},
{ 0x3BC3 , 0x8231B834},
{ 0x3BC4 , 0x8231B835},
{ 0x3BC5 , 0x8231B836},
{ 0x3BC6 , 0x8231B837},
{ 0x3BC7 , 0x8231B838},
{ 0x3BC8 , 0x8231B839},
{ 0x3BC9 , 0x8231B930},
{ 0x3BCA , 0x8231B931},
{ 0x3BCB , 0x8231B932},
{ 0x3BCC , 0x8231B933},
{ 0x3BCD , 0x8231B934},
{ 0x3BCE , 0x8231B935},
{ 0x3BCF , 0x8231B936},
{ 0x3BD0 , 0x8231B937},
{ 0x3BD1 , 0x8231B938},
{ 0x3BD2 , 0x8231B939},
{ 0x3BD3 , 0x8231BA30},
{ 0x3BD4 , 0x8231BA31},
{ 0x3BD5 , 0x8231BA32},
{ 0x3BD6 , 0x8231BA33},
{ 0x3BD7 , 0x8231BA34},
{ 0x3BD8 , 0x8231BA35},
{ 0x3BD9 , 0x8231BA36},
{ 0x3BDA , 0x8231BA37},
{ 0x3BDB , 0x8231BA38},
{ 0x3BDC , 0x8231BA39},
{ 0x3BDD , 0x8231BB30},
{ 0x3BDE , 0x8231BB31},
{ 0x3BDF , 0x8231BB32},
{ 0x3BE0 , 0x8231BB33},
{ 0x3BE1 , 0x8231BB34},
{ 0x3BE2 , 0x8231BB35},
{ 0x3BE3 , 0x8231BB36},
{ 0x3BE4 , 0x8231BB37},
{ 0x3BE5 , 0x8231BB38},
{ 0x3BE6 , 0x8231BB39},
{ 0x3BE7 , 0x8231BC30},
{ 0x3BE8 , 0x8231BC31},
{ 0x3BE9 , 0x8231BC32},
{ 0x3BEA , 0x8231BC33},
{ 0x3BEB , 0x8231BC34},
{ 0x3BEC , 0x8231BC35},
{ 0x3BED , 0x8231BC36},
{ 0x3BEE , 0x8231BC37},
{ 0x3BEF , 0x8231BC38},
{ 0x3BF0 , 0x8231BC39},
{ 0x3BF1 , 0x8231BD30},
{ 0x3BF2 , 0x8231BD31},
{ 0x3BF3 , 0x8231BD32},
{ 0x3BF4 , 0x8231BD33},
{ 0x3BF5 , 0x8231BD34},
{ 0x3BF6 , 0x8231BD35},
{ 0x3BF7 , 0x8231BD36},
{ 0x3BF8 , 0x8231BD37},
{ 0x3BF9 , 0x8231BD38},
{ 0x3BFA , 0x8231BD39},
{ 0x3BFB , 0x8231BE30},
{ 0x3BFC , 0x8231BE31},
{ 0x3BFD , 0x8231BE32},
{ 0x3BFE , 0x8231BE33},
{ 0x3BFF , 0x8231BE34},
{ 0x3C00 , 0x8231BE35},
{ 0x3C01 , 0x8231BE36},
{ 0x3C02 , 0x8231BE37},
{ 0x3C03 , 0x8231BE38},
{ 0x3C04 , 0x8231BE39},
{ 0x3C05 , 0x8231BF30},
{ 0x3C06 , 0x8231BF31},
{ 0x3C07 , 0x8231BF32},
{ 0x3C08 , 0x8231BF33},
{ 0x3C09 , 0x8231BF34},
{ 0x3C0A , 0x8231BF35},
{ 0x3C0B , 0x8231BF36},
{ 0x3C0C , 0x8231BF37},
{ 0x3C0D , 0x8231BF38},
{ 0x3C0E , 0x8231BF39},
{ 0x3C0F , 0x8231C030},
{ 0x3C10 , 0x8231C031},
{ 0x3C11 , 0x8231C032},
{ 0x3C12 , 0x8231C033},
{ 0x3C13 , 0x8231C034},
{ 0x3C14 , 0x8231C035},
{ 0x3C15 , 0x8231C036},
{ 0x3C16 , 0x8231C037},
{ 0x3C17 , 0x8231C038},
{ 0x3C18 , 0x8231C039},
{ 0x3C19 , 0x8231C130},
{ 0x3C1A , 0x8231C131},
{ 0x3C1B , 0x8231C132},
{ 0x3C1C , 0x8231C133},
{ 0x3C1D , 0x8231C134},
{ 0x3C1E , 0x8231C135},
{ 0x3C1F , 0x8231C136},
{ 0x3C20 , 0x8231C137},
{ 0x3C21 , 0x8231C138},
{ 0x3C22 , 0x8231C139},
{ 0x3C23 , 0x8231C230},
{ 0x3C24 , 0x8231C231},
{ 0x3C25 , 0x8231C232},
{ 0x3C26 , 0x8231C233},
{ 0x3C27 , 0x8231C234},
{ 0x3C28 , 0x8231C235},
{ 0x3C29 , 0x8231C236},
{ 0x3C2A , 0x8231C237},
{ 0x3C2B , 0x8231C238},
{ 0x3C2C , 0x8231C239},
{ 0x3C2D , 0x8231C330},
{ 0x3C2E , 0x8231C331},
{ 0x3C2F , 0x8231C332},
{ 0x3C30 , 0x8231C333},
{ 0x3C31 , 0x8231C334},
{ 0x3C32 , 0x8231C335},
{ 0x3C33 , 0x8231C336},
{ 0x3C34 , 0x8231C337},
{ 0x3C35 , 0x8231C338},
{ 0x3C36 , 0x8231C339},
{ 0x3C37 , 0x8231C430},
{ 0x3C38 , 0x8231C431},
{ 0x3C39 , 0x8231C432},
{ 0x3C3A , 0x8231C433},
{ 0x3C3B , 0x8231C434},
{ 0x3C3C , 0x8231C435},
{ 0x3C3D , 0x8231C436},
{ 0x3C3E , 0x8231C437},
{ 0x3C3F , 0x8231C438},
{ 0x3C40 , 0x8231C439},
{ 0x3C41 , 0x8231C530},
{ 0x3C42 , 0x8231C531},
{ 0x3C43 , 0x8231C532},
{ 0x3C44 , 0x8231C533},
{ 0x3C45 , 0x8231C534},
{ 0x3C46 , 0x8231C535},
{ 0x3C47 , 0x8231C536},
{ 0x3C48 , 0x8231C537},
{ 0x3C49 , 0x8231C538},
{ 0x3C4A , 0x8231C539},
{ 0x3C4B , 0x8231C630},
{ 0x3C4C , 0x8231C631},
{ 0x3C4D , 0x8231C632},
{ 0x3C4E , 0x8231C633},
{ 0x3C4F , 0x8231C634},
{ 0x3C50 , 0x8231C635},
{ 0x3C51 , 0x8231C636},
{ 0x3C52 , 0x8231C637},
{ 0x3C53 , 0x8231C638},
{ 0x3C54 , 0x8231C639},
{ 0x3C55 , 0x8231C730},
{ 0x3C56 , 0x8231C731},
{ 0x3C57 , 0x8231C732},
{ 0x3C58 , 0x8231C733},
{ 0x3C59 , 0x8231C734},
{ 0x3C5A , 0x8231C735},
{ 0x3C5B , 0x8231C736},
{ 0x3C5C , 0x8231C737},
{ 0x3C5D , 0x8231C738},
{ 0x3C5E , 0x8231C739},
{ 0x3C5F , 0x8231C830},
{ 0x3C60 , 0x8231C831},
{ 0x3C61 , 0x8231C832},
{ 0x3C62 , 0x8231C833},
{ 0x3C63 , 0x8231C834},
{ 0x3C64 , 0x8231C835},
{ 0x3C65 , 0x8231C836},
{ 0x3C66 , 0x8231C837},
{ 0x3C67 , 0x8231C838},
{ 0x3C68 , 0x8231C839},
{ 0x3C69 , 0x8231C930},
{ 0x3C6A , 0x8231C931},
{ 0x3C6B , 0x8231C932},
{ 0x3C6C , 0x8231C933},
{ 0x3C6D , 0x8231C934},
{ 0x3C6F , 0x8231C935},
{ 0x3C70 , 0x8231C936},
{ 0x3C71 , 0x8231C937},
{ 0x3C72 , 0x8231C938},
{ 0x3C73 , 0x8231C939},
{ 0x3C74 , 0x8231CA30},
{ 0x3C75 , 0x8231CA31},
{ 0x3C76 , 0x8231CA32},
{ 0x3C77 , 0x8231CA33},
{ 0x3C78 , 0x8231CA34},
{ 0x3C79 , 0x8231CA35},
{ 0x3C7A , 0x8231CA36},
{ 0x3C7B , 0x8231CA37},
{ 0x3C7C , 0x8231CA38},
{ 0x3C7D , 0x8231CA39},
{ 0x3C7E , 0x8231CB30},
{ 0x3C7F , 0x8231CB31},
{ 0x3C80 , 0x8231CB32},
{ 0x3C81 , 0x8231CB33},
{ 0x3C82 , 0x8231CB34},
{ 0x3C83 , 0x8231CB35},
{ 0x3C84 , 0x8231CB36},
{ 0x3C85 , 0x8231CB37},
{ 0x3C86 , 0x8231CB38},
{ 0x3C87 , 0x8231CB39},
{ 0x3C88 , 0x8231CC30},
{ 0x3C89 , 0x8231CC31},
{ 0x3C8A , 0x8231CC32},
{ 0x3C8B , 0x8231CC33},
{ 0x3C8C , 0x8231CC34},
{ 0x3C8D , 0x8231CC35},
{ 0x3C8E , 0x8231CC36},
{ 0x3C8F , 0x8231CC37},
{ 0x3C90 , 0x8231CC38},
{ 0x3C91 , 0x8231CC39},
{ 0x3C92 , 0x8231CD30},
{ 0x3C93 , 0x8231CD31},
{ 0x3C94 , 0x8231CD32},
{ 0x3C95 , 0x8231CD33},
{ 0x3C96 , 0x8231CD34},
{ 0x3C97 , 0x8231CD35},
{ 0x3C98 , 0x8231CD36},
{ 0x3C99 , 0x8231CD37},
{ 0x3C9A , 0x8231CD38},
{ 0x3C9B , 0x8231CD39},
{ 0x3C9C , 0x8231CE30},
{ 0x3C9D , 0x8231CE31},
{ 0x3C9E , 0x8231CE32},
{ 0x3C9F , 0x8231CE33},
{ 0x3CA0 , 0x8231CE34},
{ 0x3CA1 , 0x8231CE35},
{ 0x3CA2 , 0x8231CE36},
{ 0x3CA3 , 0x8231CE37},
{ 0x3CA4 , 0x8231CE38},
{ 0x3CA5 , 0x8231CE39},
{ 0x3CA6 , 0x8231CF30},
{ 0x3CA7 , 0x8231CF31},
{ 0x3CA8 , 0x8231CF32},
{ 0x3CA9 , 0x8231CF33},
{ 0x3CAA , 0x8231CF34},
{ 0x3CAB , 0x8231CF35},
{ 0x3CAC , 0x8231CF36},
{ 0x3CAD , 0x8231CF37},
{ 0x3CAE , 0x8231CF38},
{ 0x3CAF , 0x8231CF39},
{ 0x3CB0 , 0x8231D030},
{ 0x3CB1 , 0x8231D031},
{ 0x3CB2 , 0x8231D032},
{ 0x3CB3 , 0x8231D033},
{ 0x3CB4 , 0x8231D034},
{ 0x3CB5 , 0x8231D035},
{ 0x3CB6 , 0x8231D036},
{ 0x3CB7 , 0x8231D037},
{ 0x3CB8 , 0x8231D038},
{ 0x3CB9 , 0x8231D039},
{ 0x3CBA , 0x8231D130},
{ 0x3CBB , 0x8231D131},
{ 0x3CBC , 0x8231D132},
{ 0x3CBD , 0x8231D133},
{ 0x3CBE , 0x8231D134},
{ 0x3CBF , 0x8231D135},
{ 0x3CC0 , 0x8231D136},
{ 0x3CC1 , 0x8231D137},
{ 0x3CC2 , 0x8231D138},
{ 0x3CC3 , 0x8231D139},
{ 0x3CC4 , 0x8231D230},
{ 0x3CC5 , 0x8231D231},
{ 0x3CC6 , 0x8231D232},
{ 0x3CC7 , 0x8231D233},
{ 0x3CC8 , 0x8231D234},
{ 0x3CC9 , 0x8231D235},
{ 0x3CCA , 0x8231D236},
{ 0x3CCB , 0x8231D237},
{ 0x3CCC , 0x8231D238},
{ 0x3CCD , 0x8231D239},
{ 0x3CCE , 0x8231D330},
{ 0x3CCF , 0x8231D331},
{ 0x3CD0 , 0x8231D332},
{ 0x3CD1 , 0x8231D333},
{ 0x3CD2 , 0x8231D334},
{ 0x3CD3 , 0x8231D335},
{ 0x3CD4 , 0x8231D336},
{ 0x3CD5 , 0x8231D337},
{ 0x3CD6 , 0x8231D338},
{ 0x3CD7 , 0x8231D339},
{ 0x3CD8 , 0x8231D430},
{ 0x3CD9 , 0x8231D431},
{ 0x3CDA , 0x8231D432},
{ 0x3CDB , 0x8231D433},
{ 0x3CDC , 0x8231D434},
{ 0x3CDD , 0x8231D435},
{ 0x3CDE , 0x8231D436},
{ 0x3CDF , 0x8231D437},
{ 0x3CE1 , 0x8231D438},
{ 0x3CE2 , 0x8231D439},
{ 0x3CE3 , 0x8231D530},
{ 0x3CE4 , 0x8231D531},
{ 0x3CE5 , 0x8231D532},
{ 0x3CE6 , 0x8231D533},
{ 0x3CE7 , 0x8231D534},
{ 0x3CE8 , 0x8231D535},
{ 0x3CE9 , 0x8231D536},
{ 0x3CEA , 0x8231D537},
{ 0x3CEB , 0x8231D538},
{ 0x3CEC , 0x8231D539},
{ 0x3CED , 0x8231D630},
{ 0x3CEE , 0x8231D631},
{ 0x3CEF , 0x8231D632},
{ 0x3CF0 , 0x8231D633},
{ 0x3CF1 , 0x8231D634},
{ 0x3CF2 , 0x8231D635},
{ 0x3CF3 , 0x8231D636},
{ 0x3CF4 , 0x8231D637},
{ 0x3CF5 , 0x8231D638},
{ 0x3CF6 , 0x8231D639},
{ 0x3CF7 , 0x8231D730},
{ 0x3CF8 , 0x8231D731},
{ 0x3CF9 , 0x8231D732},
{ 0x3CFA , 0x8231D733},
{ 0x3CFB , 0x8231D734},
{ 0x3CFC , 0x8231D735},
{ 0x3CFD , 0x8231D736},
{ 0x3CFE , 0x8231D737},
{ 0x3CFF , 0x8231D738},
{ 0x3D00 , 0x8231D739},
{ 0x3D01 , 0x8231D830},
{ 0x3D02 , 0x8231D831},
{ 0x3D03 , 0x8231D832},
{ 0x3D04 , 0x8231D833},
{ 0x3D05 , 0x8231D834},
{ 0x3D06 , 0x8231D835},
{ 0x3D07 , 0x8231D836},
{ 0x3D08 , 0x8231D837},
{ 0x3D09 , 0x8231D838},
{ 0x3D0A , 0x8231D839},
{ 0x3D0B , 0x8231D930},
{ 0x3D0C , 0x8231D931},
{ 0x3D0D , 0x8231D932},
{ 0x3D0E , 0x8231D933},
{ 0x3D0F , 0x8231D934},
{ 0x3D10 , 0x8231D935},
{ 0x3D11 , 0x8231D936},
{ 0x3D12 , 0x8231D937},
{ 0x3D13 , 0x8231D938},
{ 0x3D14 , 0x8231D939},
{ 0x3D15 , 0x8231DA30},
{ 0x3D16 , 0x8231DA31},
{ 0x3D17 , 0x8231DA32},
{ 0x3D18 , 0x8231DA33},
{ 0x3D19 , 0x8231DA34},
{ 0x3D1A , 0x8231DA35},
{ 0x3D1B , 0x8231DA36},
{ 0x3D1C , 0x8231DA37},
{ 0x3D1D , 0x8231DA38},
{ 0x3D1E , 0x8231DA39},
{ 0x3D1F , 0x8231DB30},
{ 0x3D20 , 0x8231DB31},
{ 0x3D21 , 0x8231DB32},
{ 0x3D22 , 0x8231DB33},
{ 0x3D23 , 0x8231DB34},
{ 0x3D24 , 0x8231DB35},
{ 0x3D25 , 0x8231DB36},
{ 0x3D26 , 0x8231DB37},
{ 0x3D27 , 0x8231DB38},
{ 0x3D28 , 0x8231DB39},
{ 0x3D29 , 0x8231DC30},
{ 0x3D2A , 0x8231DC31},
{ 0x3D2B , 0x8231DC32},
{ 0x3D2C , 0x8231DC33},
{ 0x3D2D , 0x8231DC34},
{ 0x3D2E , 0x8231DC35},
{ 0x3D2F , 0x8231DC36},
{ 0x3D30 , 0x8231DC37},
{ 0x3D31 , 0x8231DC38},
{ 0x3D32 , 0x8231DC39},
{ 0x3D33 , 0x8231DD30},
{ 0x3D34 , 0x8231DD31},
{ 0x3D35 , 0x8231DD32},
{ 0x3D36 , 0x8231DD33},
{ 0x3D37 , 0x8231DD34},
{ 0x3D38 , 0x8231DD35},
{ 0x3D39 , 0x8231DD36},
{ 0x3D3A , 0x8231DD37},
{ 0x3D3B , 0x8231DD38},
{ 0x3D3C , 0x8231DD39},
{ 0x3D3D , 0x8231DE30},
{ 0x3D3E , 0x8231DE31},
{ 0x3D3F , 0x8231DE32},
{ 0x3D40 , 0x8231DE33},
{ 0x3D41 , 0x8231DE34},
{ 0x3D42 , 0x8231DE35},
{ 0x3D43 , 0x8231DE36},
{ 0x3D44 , 0x8231DE37},
{ 0x3D45 , 0x8231DE38},
{ 0x3D46 , 0x8231DE39},
{ 0x3D47 , 0x8231DF30},
{ 0x3D48 , 0x8231DF31},
{ 0x3D49 , 0x8231DF32},
{ 0x3D4A , 0x8231DF33},
{ 0x3D4B , 0x8231DF34},
{ 0x3D4C , 0x8231DF35},
{ 0x3D4D , 0x8231DF36},
{ 0x3D4E , 0x8231DF37},
{ 0x3D4F , 0x8231DF38},
{ 0x3D50 , 0x8231DF39},
{ 0x3D51 , 0x8231E030},
{ 0x3D52 , 0x8231E031},
{ 0x3D53 , 0x8231E032},
{ 0x3D54 , 0x8231E033},
{ 0x3D55 , 0x8231E034},
{ 0x3D56 , 0x8231E035},
{ 0x3D57 , 0x8231E036},
{ 0x3D58 , 0x8231E037},
{ 0x3D59 , 0x8231E038},
{ 0x3D5A , 0x8231E039},
{ 0x3D5B , 0x8231E130},
{ 0x3D5C , 0x8231E131},
{ 0x3D5D , 0x8231E132},
{ 0x3D5E , 0x8231E133},
{ 0x3D5F , 0x8231E134},
{ 0x3D60 , 0x8231E135},
{ 0x3D61 , 0x8231E136},
{ 0x3D62 , 0x8231E137},
{ 0x3D63 , 0x8231E138},
{ 0x3D64 , 0x8231E139},
{ 0x3D65 , 0x8231E230},
{ 0x3D66 , 0x8231E231},
{ 0x3D67 , 0x8231E232},
{ 0x3D68 , 0x8231E233},
{ 0x3D69 , 0x8231E234},
{ 0x3D6A , 0x8231E235},
{ 0x3D6B , 0x8231E236},
{ 0x3D6C , 0x8231E237},
{ 0x3D6D , 0x8231E238},
{ 0x3D6E , 0x8231E239},
{ 0x3D6F , 0x8231E330},
{ 0x3D70 , 0x8231E331},
{ 0x3D71 , 0x8231E332},
{ 0x3D72 , 0x8231E333},
{ 0x3D73 , 0x8231E334},
{ 0x3D74 , 0x8231E335},
{ 0x3D75 , 0x8231E336},
{ 0x3D76 , 0x8231E337},
{ 0x3D77 , 0x8231E338},
{ 0x3D78 , 0x8231E339},
{ 0x3D79 , 0x8231E430},
{ 0x3D7A , 0x8231E431},
{ 0x3D7B , 0x8231E432},
{ 0x3D7C , 0x8231E433},
{ 0x3D7D , 0x8231E434},
{ 0x3D7E , 0x8231E435},
{ 0x3D7F , 0x8231E436},
{ 0x3D80 , 0x8231E437},
{ 0x3D81 , 0x8231E438},
{ 0x3D82 , 0x8231E439},
{ 0x3D83 , 0x8231E530},
{ 0x3D84 , 0x8231E531},
{ 0x3D85 , 0x8231E532},
{ 0x3D86 , 0x8231E533},
{ 0x3D87 , 0x8231E534},
{ 0x3D88 , 0x8231E535},
{ 0x3D89 , 0x8231E536},
{ 0x3D8A , 0x8231E537},
{ 0x3D8B , 0x8231E538},
{ 0x3D8C , 0x8231E539},
{ 0x3D8D , 0x8231E630},
{ 0x3D8E , 0x8231E631},
{ 0x3D8F , 0x8231E632},
{ 0x3D90 , 0x8231E633},
{ 0x3D91 , 0x8231E634},
{ 0x3D92 , 0x8231E635},
{ 0x3D93 , 0x8231E636},
{ 0x3D94 , 0x8231E637},
{ 0x3D95 , 0x8231E638},
{ 0x3D96 , 0x8231E639},
{ 0x3D97 , 0x8231E730},
{ 0x3D98 , 0x8231E731},
{ 0x3D99 , 0x8231E732},
{ 0x3D9A , 0x8231E733},
{ 0x3D9B , 0x8231E734},
{ 0x3D9C , 0x8231E735},
{ 0x3D9D , 0x8231E736},
{ 0x3D9E , 0x8231E737},
{ 0x3D9F , 0x8231E738},
{ 0x3DA0 , 0x8231E739},
{ 0x3DA1 , 0x8231E830},
{ 0x3DA2 , 0x8231E831},
{ 0x3DA3 , 0x8231E832},
{ 0x3DA4 , 0x8231E833},
{ 0x3DA5 , 0x8231E834},
{ 0x3DA6 , 0x8231E835},
{ 0x3DA7 , 0x8231E836},
{ 0x3DA8 , 0x8231E837},
{ 0x3DA9 , 0x8231E838},
{ 0x3DAA , 0x8231E839},
{ 0x3DAB , 0x8231E930},
{ 0x3DAC , 0x8231E931},
{ 0x3DAD , 0x8231E932},
{ 0x3DAE , 0x8231E933},
{ 0x3DAF , 0x8231E934},
{ 0x3DB0 , 0x8231E935},
{ 0x3DB1 , 0x8231E936},
{ 0x3DB2 , 0x8231E937},
{ 0x3DB3 , 0x8231E938},
{ 0x3DB4 , 0x8231E939},
{ 0x3DB5 , 0x8231EA30},
{ 0x3DB6 , 0x8231EA31},
{ 0x3DB7 , 0x8231EA32},
{ 0x3DB8 , 0x8231EA33},
{ 0x3DB9 , 0x8231EA34},
{ 0x3DBA , 0x8231EA35},
{ 0x3DBB , 0x8231EA36},
{ 0x3DBC , 0x8231EA37},
{ 0x3DBD , 0x8231EA38},
{ 0x3DBE , 0x8231EA39},
{ 0x3DBF , 0x8231EB30},
{ 0x3DC0 , 0x8231EB31},
{ 0x3DC1 , 0x8231EB32},
{ 0x3DC2 , 0x8231EB33},
{ 0x3DC3 , 0x8231EB34},
{ 0x3DC4 , 0x8231EB35},
{ 0x3DC5 , 0x8231EB36},
{ 0x3DC6 , 0x8231EB37},
{ 0x3DC7 , 0x8231EB38},
{ 0x3DC8 , 0x8231EB39},
{ 0x3DC9 , 0x8231EC30},
{ 0x3DCA , 0x8231EC31},
{ 0x3DCB , 0x8231EC32},
{ 0x3DCC , 0x8231EC33},
{ 0x3DCD , 0x8231EC34},
{ 0x3DCE , 0x8231EC35},
{ 0x3DCF , 0x8231EC36},
{ 0x3DD0 , 0x8231EC37},
{ 0x3DD1 , 0x8231EC38},
{ 0x3DD2 , 0x8231EC39},
{ 0x3DD3 , 0x8231ED30},
{ 0x3DD4 , 0x8231ED31},
{ 0x3DD5 , 0x8231ED32},
{ 0x3DD6 , 0x8231ED33},
{ 0x3DD7 , 0x8231ED34},
{ 0x3DD8 , 0x8231ED35},
{ 0x3DD9 , 0x8231ED36},
{ 0x3DDA , 0x8231ED37},
{ 0x3DDB , 0x8231ED38},
{ 0x3DDC , 0x8231ED39},
{ 0x3DDD , 0x8231EE30},
{ 0x3DDE , 0x8231EE31},
{ 0x3DDF , 0x8231EE32},
{ 0x3DE0 , 0x8231EE33},
{ 0x3DE1 , 0x8231EE34},
{ 0x3DE2 , 0x8231EE35},
{ 0x3DE3 , 0x8231EE36},
{ 0x3DE4 , 0x8231EE37},
{ 0x3DE5 , 0x8231EE38},
{ 0x3DE6 , 0x8231EE39},
{ 0x3DE7 , 0x8231EF30},
{ 0x3DE8 , 0x8231EF31},
{ 0x3DE9 , 0x8231EF32},
{ 0x3DEA , 0x8231EF33},
{ 0x3DEB , 0x8231EF34},
{ 0x3DEC , 0x8231EF35},
{ 0x3DED , 0x8231EF36},
{ 0x3DEE , 0x8231EF37},
{ 0x3DEF , 0x8231EF38},
{ 0x3DF0 , 0x8231EF39},
{ 0x3DF1 , 0x8231F030},
{ 0x3DF2 , 0x8231F031},
{ 0x3DF3 , 0x8231F032},
{ 0x3DF4 , 0x8231F033},
{ 0x3DF5 , 0x8231F034},
{ 0x3DF6 , 0x8231F035},
{ 0x3DF7 , 0x8231F036},
{ 0x3DF8 , 0x8231F037},
{ 0x3DF9 , 0x8231F038},
{ 0x3DFA , 0x8231F039},
{ 0x3DFB , 0x8231F130},
{ 0x3DFC , 0x8231F131},
{ 0x3DFD , 0x8231F132},
{ 0x3DFE , 0x8231F133},
{ 0x3DFF , 0x8231F134},
{ 0x3E00 , 0x8231F135},
{ 0x3E01 , 0x8231F136},
{ 0x3E02 , 0x8231F137},
{ 0x3E03 , 0x8231F138},
{ 0x3E04 , 0x8231F139},
{ 0x3E05 , 0x8231F230},
{ 0x3E06 , 0x8231F231},
{ 0x3E07 , 0x8231F232},
{ 0x3E08 , 0x8231F233},
{ 0x3E09 , 0x8231F234},
{ 0x3E0A , 0x8231F235},
{ 0x3E0B , 0x8231F236},
{ 0x3E0C , 0x8231F237},
{ 0x3E0D , 0x8231F238},
{ 0x3E0E , 0x8231F239},
{ 0x3E0F , 0x8231F330},
{ 0x3E10 , 0x8231F331},
{ 0x3E11 , 0x8231F332},
{ 0x3E12 , 0x8231F333},
{ 0x3E13 , 0x8231F334},
{ 0x3E14 , 0x8231F335},
{ 0x3E15 , 0x8231F336},
{ 0x3E16 , 0x8231F337},
{ 0x3E17 , 0x8231F338},
{ 0x3E18 , 0x8231F339},
{ 0x3E19 , 0x8231F430},
{ 0x3E1A , 0x8231F431},
{ 0x3E1B , 0x8231F432},
{ 0x3E1C , 0x8231F433},
{ 0x3E1D , 0x8231F434},
{ 0x3E1E , 0x8231F435},
{ 0x3E1F , 0x8231F436},
{ 0x3E20 , 0x8231F437},
{ 0x3E21 , 0x8231F438},
{ 0x3E22 , 0x8231F439},
{ 0x3E23 , 0x8231F530},
{ 0x3E24 , 0x8231F531},
{ 0x3E25 , 0x8231F532},
{ 0x3E26 , 0x8231F533},
{ 0x3E27 , 0x8231F534},
{ 0x3E28 , 0x8231F535},
{ 0x3E29 , 0x8231F536},
{ 0x3E2A , 0x8231F537},
{ 0x3E2B , 0x8231F538},
{ 0x3E2C , 0x8231F539},
{ 0x3E2D , 0x8231F630},
{ 0x3E2E , 0x8231F631},
{ 0x3E2F , 0x8231F632},
{ 0x3E30 , 0x8231F633},
{ 0x3E31 , 0x8231F634},
{ 0x3E32 , 0x8231F635},
{ 0x3E33 , 0x8231F636},
{ 0x3E34 , 0x8231F637},
{ 0x3E35 , 0x8231F638},
{ 0x3E36 , 0x8231F639},
{ 0x3E37 , 0x8231F730},
{ 0x3E38 , 0x8231F731},
{ 0x3E39 , 0x8231F732},
{ 0x3E3A , 0x8231F733},
{ 0x3E3B , 0x8231F734},
{ 0x3E3C , 0x8231F735},
{ 0x3E3D , 0x8231F736},
{ 0x3E3E , 0x8231F737},
{ 0x3E3F , 0x8231F738},
{ 0x3E40 , 0x8231F739},
{ 0x3E41 , 0x8231F830},
{ 0x3E42 , 0x8231F831},
{ 0x3E43 , 0x8231F832},
{ 0x3E44 , 0x8231F833},
{ 0x3E45 , 0x8231F834},
{ 0x3E46 , 0x8231F835},
{ 0x3E47 , 0x8231F836},
{ 0x3E48 , 0x8231F837},
{ 0x3E49 , 0x8231F838},
{ 0x3E4A , 0x8231F839},
{ 0x3E4B , 0x8231F930},
{ 0x3E4C , 0x8231F931},
{ 0x3E4D , 0x8231F932},
{ 0x3E4E , 0x8231F933},
{ 0x3E4F , 0x8231F934},
{ 0x3E50 , 0x8231F935},
{ 0x3E51 , 0x8231F936},
{ 0x3E52 , 0x8231F937},
{ 0x3E53 , 0x8231F938},
{ 0x3E54 , 0x8231F939},
{ 0x3E55 , 0x8231FA30},
{ 0x3E56 , 0x8231FA31},
{ 0x3E57 , 0x8231FA32},
{ 0x3E58 , 0x8231FA33},
{ 0x3E59 , 0x8231FA34},
{ 0x3E5A , 0x8231FA35},
{ 0x3E5B , 0x8231FA36},
{ 0x3E5C , 0x8231FA37},
{ 0x3E5D , 0x8231FA38},
{ 0x3E5E , 0x8231FA39},
{ 0x3E5F , 0x8231FB30},
{ 0x3E60 , 0x8231FB31},
{ 0x3E61 , 0x8231FB32},
{ 0x3E62 , 0x8231FB33},
{ 0x3E63 , 0x8231FB34},
{ 0x3E64 , 0x8231FB35},
{ 0x3E65 , 0x8231FB36},
{ 0x3E66 , 0x8231FB37},
{ 0x3E67 , 0x8231FB38},
{ 0x3E68 , 0x8231FB39},
{ 0x3E69 , 0x8231FC30},
{ 0x3E6A , 0x8231FC31},
{ 0x3E6B , 0x8231FC32},
{ 0x3E6C , 0x8231FC33},
{ 0x3E6D , 0x8231FC34},
{ 0x3E6E , 0x8231FC35},
{ 0x3E6F , 0x8231FC36},
{ 0x3E70 , 0x8231FC37},
{ 0x3E71 , 0x8231FC38},
{ 0x3E72 , 0x8231FC39},
{ 0x3E73 , 0x8231FD30},
{ 0x3E74 , 0x8231FD31},
{ 0x3E75 , 0x8231FD32},
{ 0x3E76 , 0x8231FD33},
{ 0x3E77 , 0x8231FD34},
{ 0x3E78 , 0x8231FD35},
{ 0x3E79 , 0x8231FD36},
{ 0x3E7A , 0x8231FD37},
{ 0x3E7B , 0x8231FD38},
{ 0x3E7C , 0x8231FD39},
{ 0x3E7D , 0x8231FE30},
{ 0x3E7E , 0x8231FE31},
{ 0x3E7F , 0x8231FE32},
{ 0x3E80 , 0x8231FE33},
{ 0x3E81 , 0x8231FE34},
{ 0x3E82 , 0x8231FE35},
{ 0x3E83 , 0x8231FE36},
{ 0x3E84 , 0x8231FE37},
{ 0x3E85 , 0x8231FE38},
{ 0x3E86 , 0x8231FE39},
{ 0x3E87 , 0x82328130},
{ 0x3E88 , 0x82328131},
{ 0x3E89 , 0x82328132},
{ 0x3E8A , 0x82328133},
{ 0x3E8B , 0x82328134},
{ 0x3E8C , 0x82328135},
{ 0x3E8D , 0x82328136},
{ 0x3E8E , 0x82328137},
{ 0x3E8F , 0x82328138},
{ 0x3E90 , 0x82328139},
{ 0x3E91 , 0x82328230},
{ 0x3E92 , 0x82328231},
{ 0x3E93 , 0x82328232},
{ 0x3E94 , 0x82328233},
{ 0x3E95 , 0x82328234},
{ 0x3E96 , 0x82328235},
{ 0x3E97 , 0x82328236},
{ 0x3E98 , 0x82328237},
{ 0x3E99 , 0x82328238},
{ 0x3E9A , 0x82328239},
{ 0x3E9B , 0x82328330},
{ 0x3E9C , 0x82328331},
{ 0x3E9D , 0x82328332},
{ 0x3E9E , 0x82328333},
{ 0x3E9F , 0x82328334},
{ 0x3EA0 , 0x82328335},
{ 0x3EA1 , 0x82328336},
{ 0x3EA2 , 0x82328337},
{ 0x3EA3 , 0x82328338},
{ 0x3EA4 , 0x82328339},
{ 0x3EA5 , 0x82328430},
{ 0x3EA6 , 0x82328431},
{ 0x3EA7 , 0x82328432},
{ 0x3EA8 , 0x82328433},
{ 0x3EA9 , 0x82328434},
{ 0x3EAA , 0x82328435},
{ 0x3EAB , 0x82328436},
{ 0x3EAC , 0x82328437},
{ 0x3EAD , 0x82328438},
{ 0x3EAE , 0x82328439},
{ 0x3EAF , 0x82328530},
{ 0x3EB0 , 0x82328531},
{ 0x3EB1 , 0x82328532},
{ 0x3EB2 , 0x82328533},
{ 0x3EB3 , 0x82328534},
{ 0x3EB4 , 0x82328535},
{ 0x3EB5 , 0x82328536},
{ 0x3EB6 , 0x82328537},
{ 0x3EB7 , 0x82328538},
{ 0x3EB8 , 0x82328539},
{ 0x3EB9 , 0x82328630},
{ 0x3EBA , 0x82328631},
{ 0x3EBB , 0x82328632},
{ 0x3EBC , 0x82328633},
{ 0x3EBD , 0x82328634},
{ 0x3EBE , 0x82328635},
{ 0x3EBF , 0x82328636},
{ 0x3EC0 , 0x82328637},
{ 0x3EC1 , 0x82328638},
{ 0x3EC2 , 0x82328639},
{ 0x3EC3 , 0x82328730},
{ 0x3EC4 , 0x82328731},
{ 0x3EC5 , 0x82328732},
{ 0x3EC6 , 0x82328733},
{ 0x3EC7 , 0x82328734},
{ 0x3EC8 , 0x82328735},
{ 0x3EC9 , 0x82328736},
{ 0x3ECA , 0x82328737},
{ 0x3ECB , 0x82328738},
{ 0x3ECC , 0x82328739},
{ 0x3ECD , 0x82328830},
{ 0x3ECE , 0x82328831},
{ 0x3ECF , 0x82328832},
{ 0x3ED0 , 0x82328833},
{ 0x3ED1 , 0x82328834},
{ 0x3ED2 , 0x82328835},
{ 0x3ED3 , 0x82328836},
{ 0x3ED4 , 0x82328837},
{ 0x3ED5 , 0x82328838},
{ 0x3ED6 , 0x82328839},
{ 0x3ED7 , 0x82328930},
{ 0x3ED8 , 0x82328931},
{ 0x3ED9 , 0x82328932},
{ 0x3EDA , 0x82328933},
{ 0x3EDB , 0x82328934},
{ 0x3EDC , 0x82328935},
{ 0x3EDD , 0x82328936},
{ 0x3EDE , 0x82328937},
{ 0x3EDF , 0x82328938},
{ 0x3EE0 , 0x82328939},
{ 0x3EE1 , 0x82328A30},
{ 0x3EE2 , 0x82328A31},
{ 0x3EE3 , 0x82328A32},
{ 0x3EE4 , 0x82328A33},
{ 0x3EE5 , 0x82328A34},
{ 0x3EE6 , 0x82328A35},
{ 0x3EE7 , 0x82328A36},
{ 0x3EE8 , 0x82328A37},
{ 0x3EE9 , 0x82328A38},
{ 0x3EEA , 0x82328A39},
{ 0x3EEB , 0x82328B30},
{ 0x3EEC , 0x82328B31},
{ 0x3EED , 0x82328B32},
{ 0x3EEE , 0x82328B33},
{ 0x3EEF , 0x82328B34},
{ 0x3EF0 , 0x82328B35},
{ 0x3EF1 , 0x82328B36},
{ 0x3EF2 , 0x82328B37},
{ 0x3EF3 , 0x82328B38},
{ 0x3EF4 , 0x82328B39},
{ 0x3EF5 , 0x82328C30},
{ 0x3EF6 , 0x82328C31},
{ 0x3EF7 , 0x82328C32},
{ 0x3EF8 , 0x82328C33},
{ 0x3EF9 , 0x82328C34},
{ 0x3EFA , 0x82328C35},
{ 0x3EFB , 0x82328C36},
{ 0x3EFC , 0x82328C37},
{ 0x3EFD , 0x82328C38},
{ 0x3EFE , 0x82328C39},
{ 0x3EFF , 0x82328D30},
{ 0x3F00 , 0x82328D31},
{ 0x3F01 , 0x82328D32},
{ 0x3F02 , 0x82328D33},
{ 0x3F03 , 0x82328D34},
{ 0x3F04 , 0x82328D35},
{ 0x3F05 , 0x82328D36},
{ 0x3F06 , 0x82328D37},
{ 0x3F07 , 0x82328D38},
{ 0x3F08 , 0x82328D39},
{ 0x3F09 , 0x82328E30},
{ 0x3F0A , 0x82328E31},
{ 0x3F0B , 0x82328E32},
{ 0x3F0C , 0x82328E33},
{ 0x3F0D , 0x82328E34},
{ 0x3F0E , 0x82328E35},
{ 0x3F0F , 0x82328E36},
{ 0x3F10 , 0x82328E37},
{ 0x3F11 , 0x82328E38},
{ 0x3F12 , 0x82328E39},
{ 0x3F13 , 0x82328F30},
{ 0x3F14 , 0x82328F31},
{ 0x3F15 , 0x82328F32},
{ 0x3F16 , 0x82328F33},
{ 0x3F17 , 0x82328F34},
{ 0x3F18 , 0x82328F35},
{ 0x3F19 , 0x82328F36},
{ 0x3F1A , 0x82328F37},
{ 0x3F1B , 0x82328F38},
{ 0x3F1C , 0x82328F39},
{ 0x3F1D , 0x82329030},
{ 0x3F1E , 0x82329031},
{ 0x3F1F , 0x82329032},
{ 0x3F20 , 0x82329033},
{ 0x3F21 , 0x82329034},
{ 0x3F22 , 0x82329035},
{ 0x3F23 , 0x82329036},
{ 0x3F24 , 0x82329037},
{ 0x3F25 , 0x82329038},
{ 0x3F26 , 0x82329039},
{ 0x3F27 , 0x82329130},
{ 0x3F28 , 0x82329131},
{ 0x3F29 , 0x82329132},
{ 0x3F2A , 0x82329133},
{ 0x3F2B , 0x82329134},
{ 0x3F2C , 0x82329135},
{ 0x3F2D , 0x82329136},
{ 0x3F2E , 0x82329137},
{ 0x3F2F , 0x82329138},
{ 0x3F30 , 0x82329139},
{ 0x3F31 , 0x82329230},
{ 0x3F32 , 0x82329231},
{ 0x3F33 , 0x82329232},
{ 0x3F34 , 0x82329233},
{ 0x3F35 , 0x82329234},
{ 0x3F36 , 0x82329235},
{ 0x3F37 , 0x82329236},
{ 0x3F38 , 0x82329237},
{ 0x3F39 , 0x82329238},
{ 0x3F3A , 0x82329239},
{ 0x3F3B , 0x82329330},
{ 0x3F3C , 0x82329331},
{ 0x3F3D , 0x82329332},
{ 0x3F3E , 0x82329333},
{ 0x3F3F , 0x82329334},
{ 0x3F40 , 0x82329335},
{ 0x3F41 , 0x82329336},
{ 0x3F42 , 0x82329337},
{ 0x3F43 , 0x82329338},
{ 0x3F44 , 0x82329339},
{ 0x3F45 , 0x82329430},
{ 0x3F46 , 0x82329431},
{ 0x3F47 , 0x82329432},
{ 0x3F48 , 0x82329433},
{ 0x3F49 , 0x82329434},
{ 0x3F4A , 0x82329435},
{ 0x3F4B , 0x82329436},
{ 0x3F4C , 0x82329437},
{ 0x3F4D , 0x82329438},
{ 0x3F4E , 0x82329439},
{ 0x3F4F , 0x82329530},
{ 0x3F50 , 0x82329531},
{ 0x3F51 , 0x82329532},
{ 0x3F52 , 0x82329533},
{ 0x3F53 , 0x82329534},
{ 0x3F54 , 0x82329535},
{ 0x3F55 , 0x82329536},
{ 0x3F56 , 0x82329537},
{ 0x3F57 , 0x82329538},
{ 0x3F58 , 0x82329539},
{ 0x3F59 , 0x82329630},
{ 0x3F5A , 0x82329631},
{ 0x3F5B , 0x82329632},
{ 0x3F5C , 0x82329633},
{ 0x3F5D , 0x82329634},
{ 0x3F5E , 0x82329635},
{ 0x3F5F , 0x82329636},
{ 0x3F60 , 0x82329637},
{ 0x3F61 , 0x82329638},
{ 0x3F62 , 0x82329639},
{ 0x3F63 , 0x82329730},
{ 0x3F64 , 0x82329731},
{ 0x3F65 , 0x82329732},
{ 0x3F66 , 0x82329733},
{ 0x3F67 , 0x82329734},
{ 0x3F68 , 0x82329735},
{ 0x3F69 , 0x82329736},
{ 0x3F6A , 0x82329737},
{ 0x3F6B , 0x82329738},
{ 0x3F6C , 0x82329739},
{ 0x3F6D , 0x82329830},
{ 0x3F6E , 0x82329831},
{ 0x3F6F , 0x82329832},
{ 0x3F70 , 0x82329833},
{ 0x3F71 , 0x82329834},
{ 0x3F72 , 0x82329835},
{ 0x3F73 , 0x82329836},
{ 0x3F74 , 0x82329837},
{ 0x3F75 , 0x82329838},
{ 0x3F76 , 0x82329839},
{ 0x3F77 , 0x82329930},
{ 0x3F78 , 0x82329931},
{ 0x3F79 , 0x82329932},
{ 0x3F7A , 0x82329933},
{ 0x3F7B , 0x82329934},
{ 0x3F7C , 0x82329935},
{ 0x3F7D , 0x82329936},
{ 0x3F7E , 0x82329937},
{ 0x3F7F , 0x82329938},
{ 0x3F80 , 0x82329939},
{ 0x3F81 , 0x82329A30},
{ 0x3F82 , 0x82329A31},
{ 0x3F83 , 0x82329A32},
{ 0x3F84 , 0x82329A33},
{ 0x3F85 , 0x82329A34},
{ 0x3F86 , 0x82329A35},
{ 0x3F87 , 0x82329A36},
{ 0x3F88 , 0x82329A37},
{ 0x3F89 , 0x82329A38},
{ 0x3F8A , 0x82329A39},
{ 0x3F8B , 0x82329B30},
{ 0x3F8C , 0x82329B31},
{ 0x3F8D , 0x82329B32},
{ 0x3F8E , 0x82329B33},
{ 0x3F8F , 0x82329B34},
{ 0x3F90 , 0x82329B35},
{ 0x3F91 , 0x82329B36},
{ 0x3F92 , 0x82329B37},
{ 0x3F93 , 0x82329B38},
{ 0x3F94 , 0x82329B39},
{ 0x3F95 , 0x82329C30},
{ 0x3F96 , 0x82329C31},
{ 0x3F97 , 0x82329C32},
{ 0x3F98 , 0x82329C33},
{ 0x3F99 , 0x82329C34},
{ 0x3F9A , 0x82329C35},
{ 0x3F9B , 0x82329C36},
{ 0x3F9C , 0x82329C37},
{ 0x3F9D , 0x82329C38},
{ 0x3F9E , 0x82329C39},
{ 0x3F9F , 0x82329D30},
{ 0x3FA0 , 0x82329D31},
{ 0x3FA1 , 0x82329D32},
{ 0x3FA2 , 0x82329D33},
{ 0x3FA3 , 0x82329D34},
{ 0x3FA4 , 0x82329D35},
{ 0x3FA5 , 0x82329D36},
{ 0x3FA6 , 0x82329D37},
{ 0x3FA7 , 0x82329D38},
{ 0x3FA8 , 0x82329D39},
{ 0x3FA9 , 0x82329E30},
{ 0x3FAA , 0x82329E31},
{ 0x3FAB , 0x82329E32},
{ 0x3FAC , 0x82329E33},
{ 0x3FAD , 0x82329E34},
{ 0x3FAE , 0x82329E35},
{ 0x3FAF , 0x82329E36},
{ 0x3FB0 , 0x82329E37},
{ 0x3FB1 , 0x82329E38},
{ 0x3FB2 , 0x82329E39},
{ 0x3FB3 , 0x82329F30},
{ 0x3FB4 , 0x82329F31},
{ 0x3FB5 , 0x82329F32},
{ 0x3FB6 , 0x82329F33},
{ 0x3FB7 , 0x82329F34},
{ 0x3FB8 , 0x82329F35},
{ 0x3FB9 , 0x82329F36},
{ 0x3FBA , 0x82329F37},
{ 0x3FBB , 0x82329F38},
{ 0x3FBC , 0x82329F39},
{ 0x3FBD , 0x8232A030},
{ 0x3FBE , 0x8232A031},
{ 0x3FBF , 0x8232A032},
{ 0x3FC0 , 0x8232A033},
{ 0x3FC1 , 0x8232A034},
{ 0x3FC2 , 0x8232A035},
{ 0x3FC3 , 0x8232A036},
{ 0x3FC4 , 0x8232A037},
{ 0x3FC5 , 0x8232A038},
{ 0x3FC6 , 0x8232A039},
{ 0x3FC7 , 0x8232A130},
{ 0x3FC8 , 0x8232A131},
{ 0x3FC9 , 0x8232A132},
{ 0x3FCA , 0x8232A133},
{ 0x3FCB , 0x8232A134},
{ 0x3FCC , 0x8232A135},
{ 0x3FCD , 0x8232A136},
{ 0x3FCE , 0x8232A137},
{ 0x3FCF , 0x8232A138},
{ 0x3FD0 , 0x8232A139},
{ 0x3FD1 , 0x8232A230},
{ 0x3FD2 , 0x8232A231},
{ 0x3FD3 , 0x8232A232},
{ 0x3FD4 , 0x8232A233},
{ 0x3FD5 , 0x8232A234},
{ 0x3FD6 , 0x8232A235},
{ 0x3FD7 , 0x8232A236},
{ 0x3FD8 , 0x8232A237},
{ 0x3FD9 , 0x8232A238},
{ 0x3FDA , 0x8232A239},
{ 0x3FDB , 0x8232A330},
{ 0x3FDC , 0x8232A331},
{ 0x3FDD , 0x8232A332},
{ 0x3FDE , 0x8232A333},
{ 0x3FDF , 0x8232A334},
{ 0x3FE0 , 0x8232A335},
{ 0x3FE1 , 0x8232A336},
{ 0x3FE2 , 0x8232A337},
{ 0x3FE3 , 0x8232A338},
{ 0x3FE4 , 0x8232A339},
{ 0x3FE5 , 0x8232A430},
{ 0x3FE6 , 0x8232A431},
{ 0x3FE7 , 0x8232A432},
{ 0x3FE8 , 0x8232A433},
{ 0x3FE9 , 0x8232A434},
{ 0x3FEA , 0x8232A435},
{ 0x3FEB , 0x8232A436},
{ 0x3FEC , 0x8232A437},
{ 0x3FED , 0x8232A438},
{ 0x3FEE , 0x8232A439},
{ 0x3FEF , 0x8232A530},
{ 0x3FF0 , 0x8232A531},
{ 0x3FF1 , 0x8232A532},
{ 0x3FF2 , 0x8232A533},
{ 0x3FF3 , 0x8232A534},
{ 0x3FF4 , 0x8232A535},
{ 0x3FF5 , 0x8232A536},
{ 0x3FF6 , 0x8232A537},
{ 0x3FF7 , 0x8232A538},
{ 0x3FF8 , 0x8232A539},
{ 0x3FF9 , 0x8232A630},
{ 0x3FFA , 0x8232A631},
{ 0x3FFB , 0x8232A632},
{ 0x3FFC , 0x8232A633},
{ 0x3FFD , 0x8232A634},
{ 0x3FFE , 0x8232A635},
{ 0x3FFF , 0x8232A636},
{ 0x4000 , 0x8232A637},
{ 0x4001 , 0x8232A638},
{ 0x4002 , 0x8232A639},
{ 0x4003 , 0x8232A730},
{ 0x4004 , 0x8232A731},
{ 0x4005 , 0x8232A732},
{ 0x4006 , 0x8232A733},
{ 0x4007 , 0x8232A734},
{ 0x4008 , 0x8232A735},
{ 0x4009 , 0x8232A736},
{ 0x400A , 0x8232A737},
{ 0x400B , 0x8232A738},
{ 0x400C , 0x8232A739},
{ 0x400D , 0x8232A830},
{ 0x400E , 0x8232A831},
{ 0x400F , 0x8232A832},
{ 0x4010 , 0x8232A833},
{ 0x4011 , 0x8232A834},
{ 0x4012 , 0x8232A835},
{ 0x4013 , 0x8232A836},
{ 0x4014 , 0x8232A837},
{ 0x4015 , 0x8232A838},
{ 0x4016 , 0x8232A839},
{ 0x4017 , 0x8232A930},
{ 0x4018 , 0x8232A931},
{ 0x4019 , 0x8232A932},
{ 0x401A , 0x8232A933},
{ 0x401B , 0x8232A934},
{ 0x401C , 0x8232A935},
{ 0x401D , 0x8232A936},
{ 0x401E , 0x8232A937},
{ 0x401F , 0x8232A938},
{ 0x4020 , 0x8232A939},
{ 0x4021 , 0x8232AA30},
{ 0x4022 , 0x8232AA31},
{ 0x4023 , 0x8232AA32},
{ 0x4024 , 0x8232AA33},
{ 0x4025 , 0x8232AA34},
{ 0x4026 , 0x8232AA35},
{ 0x4027 , 0x8232AA36},
{ 0x4028 , 0x8232AA37},
{ 0x4029 , 0x8232AA38},
{ 0x402A , 0x8232AA39},
{ 0x402B , 0x8232AB30},
{ 0x402C , 0x8232AB31},
{ 0x402D , 0x8232AB32},
{ 0x402E , 0x8232AB33},
{ 0x402F , 0x8232AB34},
{ 0x4030 , 0x8232AB35},
{ 0x4031 , 0x8232AB36},
{ 0x4032 , 0x8232AB37},
{ 0x4033 , 0x8232AB38},
{ 0x4034 , 0x8232AB39},
{ 0x4035 , 0x8232AC30},
{ 0x4036 , 0x8232AC31},
{ 0x4037 , 0x8232AC32},
{ 0x4038 , 0x8232AC33},
{ 0x4039 , 0x8232AC34},
{ 0x403A , 0x8232AC35},
{ 0x403B , 0x8232AC36},
{ 0x403C , 0x8232AC37},
{ 0x403D , 0x8232AC38},
{ 0x403E , 0x8232AC39},
{ 0x403F , 0x8232AD30},
{ 0x4040 , 0x8232AD31},
{ 0x4041 , 0x8232AD32},
{ 0x4042 , 0x8232AD33},
{ 0x4043 , 0x8232AD34},
{ 0x4044 , 0x8232AD35},
{ 0x4045 , 0x8232AD36},
{ 0x4046 , 0x8232AD37},
{ 0x4047 , 0x8232AD38},
{ 0x4048 , 0x8232AD39},
{ 0x4049 , 0x8232AE30},
{ 0x404A , 0x8232AE31},
{ 0x404B , 0x8232AE32},
{ 0x404C , 0x8232AE33},
{ 0x404D , 0x8232AE34},
{ 0x404E , 0x8232AE35},
{ 0x404F , 0x8232AE36},
{ 0x4050 , 0x8232AE37},
{ 0x4051 , 0x8232AE38},
{ 0x4052 , 0x8232AE39},
{ 0x4053 , 0x8232AF30},
{ 0x4054 , 0x8232AF31},
{ 0x4055 , 0x8232AF32},
{ 0x4057 , 0x8232AF33},
{ 0x4058 , 0x8232AF34},
{ 0x4059 , 0x8232AF35},
{ 0x405A , 0x8232AF36},
{ 0x405B , 0x8232AF37},
{ 0x405C , 0x8232AF38},
{ 0x405D , 0x8232AF39},
{ 0x405E , 0x8232B030},
{ 0x405F , 0x8232B031},
{ 0x4060 , 0x8232B032},
{ 0x4061 , 0x8232B033},
{ 0x4062 , 0x8232B034},
{ 0x4063 , 0x8232B035},
{ 0x4064 , 0x8232B036},
{ 0x4065 , 0x8232B037},
{ 0x4066 , 0x8232B038},
{ 0x4067 , 0x8232B039},
{ 0x4068 , 0x8232B130},
{ 0x4069 , 0x8232B131},
{ 0x406A , 0x8232B132},
{ 0x406B , 0x8232B133},
{ 0x406C , 0x8232B134},
{ 0x406D , 0x8232B135},
{ 0x406E , 0x8232B136},
{ 0x406F , 0x8232B137},
{ 0x4070 , 0x8232B138},
{ 0x4071 , 0x8232B139},
{ 0x4072 , 0x8232B230},
{ 0x4073 , 0x8232B231},
{ 0x4074 , 0x8232B232},
{ 0x4075 , 0x8232B233},
{ 0x4076 , 0x8232B234},
{ 0x4077 , 0x8232B235},
{ 0x4078 , 0x8232B236},
{ 0x4079 , 0x8232B237},
{ 0x407A , 0x8232B238},
{ 0x407B , 0x8232B239},
{ 0x407C , 0x8232B330},
{ 0x407D , 0x8232B331},
{ 0x407E , 0x8232B332},
{ 0x407F , 0x8232B333},
{ 0x4080 , 0x8232B334},
{ 0x4081 , 0x8232B335},
{ 0x4082 , 0x8232B336},
{ 0x4083 , 0x8232B337},
{ 0x4084 , 0x8232B338},
{ 0x4085 , 0x8232B339},
{ 0x4086 , 0x8232B430},
{ 0x4087 , 0x8232B431},
{ 0x4088 , 0x8232B432},
{ 0x4089 , 0x8232B433},
{ 0x408A , 0x8232B434},
{ 0x408B , 0x8232B435},
{ 0x408C , 0x8232B436},
{ 0x408D , 0x8232B437},
{ 0x408E , 0x8232B438},
{ 0x408F , 0x8232B439},
{ 0x4090 , 0x8232B530},
{ 0x4091 , 0x8232B531},
{ 0x4092 , 0x8232B532},
{ 0x4093 , 0x8232B533},
{ 0x4094 , 0x8232B534},
{ 0x4095 , 0x8232B535},
{ 0x4096 , 0x8232B536},
{ 0x4097 , 0x8232B537},
{ 0x4098 , 0x8232B538},
{ 0x4099 , 0x8232B539},
{ 0x409A , 0x8232B630},
{ 0x409B , 0x8232B631},
{ 0x409C , 0x8232B632},
{ 0x409D , 0x8232B633},
{ 0x409E , 0x8232B634},
{ 0x409F , 0x8232B635},
{ 0x40A0 , 0x8232B636},
{ 0x40A1 , 0x8232B637},
{ 0x40A2 , 0x8232B638},
{ 0x40A3 , 0x8232B639},
{ 0x40A4 , 0x8232B730},
{ 0x40A5 , 0x8232B731},
{ 0x40A6 , 0x8232B732},
{ 0x40A7 , 0x8232B733},
{ 0x40A8 , 0x8232B734},
{ 0x40A9 , 0x8232B735},
{ 0x40AA , 0x8232B736},
{ 0x40AB , 0x8232B737},
{ 0x40AC , 0x8232B738},
{ 0x40AD , 0x8232B739},
{ 0x40AE , 0x8232B830},
{ 0x40AF , 0x8232B831},
{ 0x40B0 , 0x8232B832},
{ 0x40B1 , 0x8232B833},
{ 0x40B2 , 0x8232B834},
{ 0x40B3 , 0x8232B835},
{ 0x40B4 , 0x8232B836},
{ 0x40B5 , 0x8232B837},
{ 0x40B6 , 0x8232B838},
{ 0x40B7 , 0x8232B839},
{ 0x40B8 , 0x8232B930},
{ 0x40B9 , 0x8232B931},
{ 0x40BA , 0x8232B932},
{ 0x40BB , 0x8232B933},
{ 0x40BC , 0x8232B934},
{ 0x40BD , 0x8232B935},
{ 0x40BE , 0x8232B936},
{ 0x40BF , 0x8232B937},
{ 0x40C0 , 0x8232B938},
{ 0x40C1 , 0x8232B939},
{ 0x40C2 , 0x8232BA30},
{ 0x40C3 , 0x8232BA31},
{ 0x40C4 , 0x8232BA32},
{ 0x40C5 , 0x8232BA33},
{ 0x40C6 , 0x8232BA34},
{ 0x40C7 , 0x8232BA35},
{ 0x40C8 , 0x8232BA36},
{ 0x40C9 , 0x8232BA37},
{ 0x40CA , 0x8232BA38},
{ 0x40CB , 0x8232BA39},
{ 0x40CC , 0x8232BB30},
{ 0x40CD , 0x8232BB31},
{ 0x40CE , 0x8232BB32},
{ 0x40CF , 0x8232BB33},
{ 0x40D0 , 0x8232BB34},
{ 0x40D1 , 0x8232BB35},
{ 0x40D2 , 0x8232BB36},
{ 0x40D3 , 0x8232BB37},
{ 0x40D4 , 0x8232BB38},
{ 0x40D5 , 0x8232BB39},
{ 0x40D6 , 0x8232BC30},
{ 0x40D7 , 0x8232BC31},
{ 0x40D8 , 0x8232BC32},
{ 0x40D9 , 0x8232BC33},
{ 0x40DA , 0x8232BC34},
{ 0x40DB , 0x8232BC35},
{ 0x40DC , 0x8232BC36},
{ 0x40DD , 0x8232BC37},
{ 0x40DE , 0x8232BC38},
{ 0x40DF , 0x8232BC39},
{ 0x40E0 , 0x8232BD30},
{ 0x40E1 , 0x8232BD31},
{ 0x40E2 , 0x8232BD32},
{ 0x40E3 , 0x8232BD33},
{ 0x40E4 , 0x8232BD34},
{ 0x40E5 , 0x8232BD35},
{ 0x40E6 , 0x8232BD36},
{ 0x40E7 , 0x8232BD37},
{ 0x40E8 , 0x8232BD38},
{ 0x40E9 , 0x8232BD39},
{ 0x40EA , 0x8232BE30},
{ 0x40EB , 0x8232BE31},
{ 0x40EC , 0x8232BE32},
{ 0x40ED , 0x8232BE33},
{ 0x40EE , 0x8232BE34},
{ 0x40EF , 0x8232BE35},
{ 0x40F0 , 0x8232BE36},
{ 0x40F1 , 0x8232BE37},
{ 0x40F2 , 0x8232BE38},
{ 0x40F3 , 0x8232BE39},
{ 0x40F4 , 0x8232BF30},
{ 0x40F5 , 0x8232BF31},
{ 0x40F6 , 0x8232BF32},
{ 0x40F7 , 0x8232BF33},
{ 0x40F8 , 0x8232BF34},
{ 0x40F9 , 0x8232BF35},
{ 0x40FA , 0x8232BF36},
{ 0x40FB , 0x8232BF37},
{ 0x40FC , 0x8232BF38},
{ 0x40FD , 0x8232BF39},
{ 0x40FE , 0x8232C030},
{ 0x40FF , 0x8232C031},
{ 0x4100 , 0x8232C032},
{ 0x4101 , 0x8232C033},
{ 0x4102 , 0x8232C034},
{ 0x4103 , 0x8232C035},
{ 0x4104 , 0x8232C036},
{ 0x4105 , 0x8232C037},
{ 0x4106 , 0x8232C038},
{ 0x4107 , 0x8232C039},
{ 0x4108 , 0x8232C130},
{ 0x4109 , 0x8232C131},
{ 0x410A , 0x8232C132},
{ 0x410B , 0x8232C133},
{ 0x410C , 0x8232C134},
{ 0x410D , 0x8232C135},
{ 0x410E , 0x8232C136},
{ 0x410F , 0x8232C137},
{ 0x4110 , 0x8232C138},
{ 0x4111 , 0x8232C139},
{ 0x4112 , 0x8232C230},
{ 0x4113 , 0x8232C231},
{ 0x4114 , 0x8232C232},
{ 0x4115 , 0x8232C233},
{ 0x4116 , 0x8232C234},
{ 0x4117 , 0x8232C235},
{ 0x4118 , 0x8232C236},
{ 0x4119 , 0x8232C237},
{ 0x411A , 0x8232C238},
{ 0x411B , 0x8232C239},
{ 0x411C , 0x8232C330},
{ 0x411D , 0x8232C331},
{ 0x411E , 0x8232C332},
{ 0x411F , 0x8232C333},
{ 0x4120 , 0x8232C334},
{ 0x4121 , 0x8232C335},
{ 0x4122 , 0x8232C336},
{ 0x4123 , 0x8232C337},
{ 0x4124 , 0x8232C338},
{ 0x4125 , 0x8232C339},
{ 0x4126 , 0x8232C430},
{ 0x4127 , 0x8232C431},
{ 0x4128 , 0x8232C432},
{ 0x4129 , 0x8232C433},
{ 0x412A , 0x8232C434},
{ 0x412B , 0x8232C435},
{ 0x412C , 0x8232C436},
{ 0x412D , 0x8232C437},
{ 0x412E , 0x8232C438},
{ 0x412F , 0x8232C439},
{ 0x4130 , 0x8232C530},
{ 0x4131 , 0x8232C531},
{ 0x4132 , 0x8232C532},
{ 0x4133 , 0x8232C533},
{ 0x4134 , 0x8232C534},
{ 0x4135 , 0x8232C535},
{ 0x4136 , 0x8232C536},
{ 0x4137 , 0x8232C537},
{ 0x4138 , 0x8232C538},
{ 0x4139 , 0x8232C539},
{ 0x413A , 0x8232C630},
{ 0x413B , 0x8232C631},
{ 0x413C , 0x8232C632},
{ 0x413D , 0x8232C633},
{ 0x413E , 0x8232C634},
{ 0x413F , 0x8232C635},
{ 0x4140 , 0x8232C636},
{ 0x4141 , 0x8232C637},
{ 0x4142 , 0x8232C638},
{ 0x4143 , 0x8232C639},
{ 0x4144 , 0x8232C730},
{ 0x4145 , 0x8232C731},
{ 0x4146 , 0x8232C732},
{ 0x4147 , 0x8232C733},
{ 0x4148 , 0x8232C734},
{ 0x4149 , 0x8232C735},
{ 0x414A , 0x8232C736},
{ 0x414B , 0x8232C737},
{ 0x414C , 0x8232C738},
{ 0x414D , 0x8232C739},
{ 0x414E , 0x8232C830},
{ 0x414F , 0x8232C831},
{ 0x4150 , 0x8232C832},
{ 0x4151 , 0x8232C833},
{ 0x4152 , 0x8232C834},
{ 0x4153 , 0x8232C835},
{ 0x4154 , 0x8232C836},
{ 0x4155 , 0x8232C837},
{ 0x4156 , 0x8232C838},
{ 0x4157 , 0x8232C839},
{ 0x4158 , 0x8232C930},
{ 0x4159 , 0x8232C931},
{ 0x415A , 0x8232C932},
{ 0x415B , 0x8232C933},
{ 0x415C , 0x8232C934},
{ 0x415D , 0x8232C935},
{ 0x415E , 0x8232C936},
{ 0x4160 , 0x8232C937},
{ 0x4161 , 0x8232C938},
{ 0x4162 , 0x8232C939},
{ 0x4163 , 0x8232CA30},
{ 0x4164 , 0x8232CA31},
{ 0x4165 , 0x8232CA32},
{ 0x4166 , 0x8232CA33},
{ 0x4167 , 0x8232CA34},
{ 0x4168 , 0x8232CA35},
{ 0x4169 , 0x8232CA36},
{ 0x416A , 0x8232CA37},
{ 0x416B , 0x8232CA38},
{ 0x416C , 0x8232CA39},
{ 0x416D , 0x8232CB30},
{ 0x416E , 0x8232CB31},
{ 0x416F , 0x8232CB32},
{ 0x4170 , 0x8232CB33},
{ 0x4171 , 0x8232CB34},
{ 0x4172 , 0x8232CB35},
{ 0x4173 , 0x8232CB36},
{ 0x4174 , 0x8232CB37},
{ 0x4175 , 0x8232CB38},
{ 0x4176 , 0x8232CB39},
{ 0x4177 , 0x8232CC30},
{ 0x4178 , 0x8232CC31},
{ 0x4179 , 0x8232CC32},
{ 0x417A , 0x8232CC33},
{ 0x417B , 0x8232CC34},
{ 0x417C , 0x8232CC35},
{ 0x417D , 0x8232CC36},
{ 0x417E , 0x8232CC37},
{ 0x417F , 0x8232CC38},
{ 0x4180 , 0x8232CC39},
{ 0x4181 , 0x8232CD30},
{ 0x4182 , 0x8232CD31},
{ 0x4183 , 0x8232CD32},
{ 0x4184 , 0x8232CD33},
{ 0x4185 , 0x8232CD34},
{ 0x4186 , 0x8232CD35},
{ 0x4187 , 0x8232CD36},
{ 0x4188 , 0x8232CD37},
{ 0x4189 , 0x8232CD38},
{ 0x418A , 0x8232CD39},
{ 0x418B , 0x8232CE30},
{ 0x418C , 0x8232CE31},
{ 0x418D , 0x8232CE32},
{ 0x418E , 0x8232CE33},
{ 0x418F , 0x8232CE34},
{ 0x4190 , 0x8232CE35},
{ 0x4191 , 0x8232CE36},
{ 0x4192 , 0x8232CE37},
{ 0x4193 , 0x8232CE38},
{ 0x4194 , 0x8232CE39},
{ 0x4195 , 0x8232CF30},
{ 0x4196 , 0x8232CF31},
{ 0x4197 , 0x8232CF32},
{ 0x4198 , 0x8232CF33},
{ 0x4199 , 0x8232CF34},
{ 0x419A , 0x8232CF35},
{ 0x419B , 0x8232CF36},
{ 0x419C , 0x8232CF37},
{ 0x419D , 0x8232CF38},
{ 0x419E , 0x8232CF39},
{ 0x419F , 0x8232D030},
{ 0x41A0 , 0x8232D031},
{ 0x41A1 , 0x8232D032},
{ 0x41A2 , 0x8232D033},
{ 0x41A3 , 0x8232D034},
{ 0x41A4 , 0x8232D035},
{ 0x41A5 , 0x8232D036},
{ 0x41A6 , 0x8232D037},
{ 0x41A7 , 0x8232D038},
{ 0x41A8 , 0x8232D039},
{ 0x41A9 , 0x8232D130},
{ 0x41AA , 0x8232D131},
{ 0x41AB , 0x8232D132},
{ 0x41AC , 0x8232D133},
{ 0x41AD , 0x8232D134},
{ 0x41AE , 0x8232D135},
{ 0x41AF , 0x8232D136},
{ 0x41B0 , 0x8232D137},
{ 0x41B1 , 0x8232D138},
{ 0x41B2 , 0x8232D139},
{ 0x41B3 , 0x8232D230},
{ 0x41B4 , 0x8232D231},
{ 0x41B5 , 0x8232D232},
{ 0x41B6 , 0x8232D233},
{ 0x41B7 , 0x8232D234},
{ 0x41B8 , 0x8232D235},
{ 0x41B9 , 0x8232D236},
{ 0x41BA , 0x8232D237},
{ 0x41BB , 0x8232D238},
{ 0x41BC , 0x8232D239},
{ 0x41BD , 0x8232D330},
{ 0x41BE , 0x8232D331},
{ 0x41BF , 0x8232D332},
{ 0x41C0 , 0x8232D333},
{ 0x41C1 , 0x8232D334},
{ 0x41C2 , 0x8232D335},
{ 0x41C3 , 0x8232D336},
{ 0x41C4 , 0x8232D337},
{ 0x41C5 , 0x8232D338},
{ 0x41C6 , 0x8232D339},
{ 0x41C7 , 0x8232D430},
{ 0x41C8 , 0x8232D431},
{ 0x41C9 , 0x8232D432},
{ 0x41CA , 0x8232D433},
{ 0x41CB , 0x8232D434},
{ 0x41CC , 0x8232D435},
{ 0x41CD , 0x8232D436},
{ 0x41CE , 0x8232D437},
{ 0x41CF , 0x8232D438},
{ 0x41D0 , 0x8232D439},
{ 0x41D1 , 0x8232D530},
{ 0x41D2 , 0x8232D531},
{ 0x41D3 , 0x8232D532},
{ 0x41D4 , 0x8232D533},
{ 0x41D5 , 0x8232D534},
{ 0x41D6 , 0x8232D535},
{ 0x41D7 , 0x8232D536},
{ 0x41D8 , 0x8232D537},
{ 0x41D9 , 0x8232D538},
{ 0x41DA , 0x8232D539},
{ 0x41DB , 0x8232D630},
{ 0x41DC , 0x8232D631},
{ 0x41DD , 0x8232D632},
{ 0x41DE , 0x8232D633},
{ 0x41DF , 0x8232D634},
{ 0x41E0 , 0x8232D635},
{ 0x41E1 , 0x8232D636},
{ 0x41E2 , 0x8232D637},
{ 0x41E3 , 0x8232D638},
{ 0x41E4 , 0x8232D639},
{ 0x41E5 , 0x8232D730},
{ 0x41E6 , 0x8232D731},
{ 0x41E7 , 0x8232D732},
{ 0x41E8 , 0x8232D733},
{ 0x41E9 , 0x8232D734},
{ 0x41EA , 0x8232D735},
{ 0x41EB , 0x8232D736},
{ 0x41EC , 0x8232D737},
{ 0x41ED , 0x8232D738},
{ 0x41EE , 0x8232D739},
{ 0x41EF , 0x8232D830},
{ 0x41F0 , 0x8232D831},
{ 0x41F1 , 0x8232D832},
{ 0x41F2 , 0x8232D833},
{ 0x41F3 , 0x8232D834},
{ 0x41F4 , 0x8232D835},
{ 0x41F5 , 0x8232D836},
{ 0x41F6 , 0x8232D837},
{ 0x41F7 , 0x8232D838},
{ 0x41F8 , 0x8232D839},
{ 0x41F9 , 0x8232D930},
{ 0x41FA , 0x8232D931},
{ 0x41FB , 0x8232D932},
{ 0x41FC , 0x8232D933},
{ 0x41FD , 0x8232D934},
{ 0x41FE , 0x8232D935},
{ 0x41FF , 0x8232D936},
{ 0x4200 , 0x8232D937},
{ 0x4201 , 0x8232D938},
{ 0x4202 , 0x8232D939},
{ 0x4203 , 0x8232DA30},
{ 0x4204 , 0x8232DA31},
{ 0x4205 , 0x8232DA32},
{ 0x4206 , 0x8232DA33},
{ 0x4207 , 0x8232DA34},
{ 0x4208 , 0x8232DA35},
{ 0x4209 , 0x8232DA36},
{ 0x420A , 0x8232DA37},
{ 0x420B , 0x8232DA38},
{ 0x420C , 0x8232DA39},
{ 0x420D , 0x8232DB30},
{ 0x420E , 0x8232DB31},
{ 0x420F , 0x8232DB32},
{ 0x4210 , 0x8232DB33},
{ 0x4211 , 0x8232DB34},
{ 0x4212 , 0x8232DB35},
{ 0x4213 , 0x8232DB36},
{ 0x4214 , 0x8232DB37},
{ 0x4215 , 0x8232DB38},
{ 0x4216 , 0x8232DB39},
{ 0x4217 , 0x8232DC30},
{ 0x4218 , 0x8232DC31},
{ 0x4219 , 0x8232DC32},
{ 0x421A , 0x8232DC33},
{ 0x421B , 0x8232DC34},
{ 0x421C , 0x8232DC35},
{ 0x421D , 0x8232DC36},
{ 0x421E , 0x8232DC37},
{ 0x421F , 0x8232DC38},
{ 0x4220 , 0x8232DC39},
{ 0x4221 , 0x8232DD30},
{ 0x4222 , 0x8232DD31},
{ 0x4223 , 0x8232DD32},
{ 0x4224 , 0x8232DD33},
{ 0x4225 , 0x8232DD34},
{ 0x4226 , 0x8232DD35},
{ 0x4227 , 0x8232DD36},
{ 0x4228 , 0x8232DD37},
{ 0x4229 , 0x8232DD38},
{ 0x422A , 0x8232DD39},
{ 0x422B , 0x8232DE30},
{ 0x422C , 0x8232DE31},
{ 0x422D , 0x8232DE32},
{ 0x422E , 0x8232DE33},
{ 0x422F , 0x8232DE34},
{ 0x4230 , 0x8232DE35},
{ 0x4231 , 0x8232DE36},
{ 0x4232 , 0x8232DE37},
{ 0x4233 , 0x8232DE38},
{ 0x4234 , 0x8232DE39},
{ 0x4235 , 0x8232DF30},
{ 0x4236 , 0x8232DF31},
{ 0x4237 , 0x8232DF32},
{ 0x4238 , 0x8232DF33},
{ 0x4239 , 0x8232DF34},
{ 0x423A , 0x8232DF35},
{ 0x423B , 0x8232DF36},
{ 0x423C , 0x8232DF37},
{ 0x423D , 0x8232DF38},
{ 0x423E , 0x8232DF39},
{ 0x423F , 0x8232E030},
{ 0x4240 , 0x8232E031},
{ 0x4241 , 0x8232E032},
{ 0x4242 , 0x8232E033},
{ 0x4243 , 0x8232E034},
{ 0x4244 , 0x8232E035},
{ 0x4245 , 0x8232E036},
{ 0x4246 , 0x8232E037},
{ 0x4247 , 0x8232E038},
{ 0x4248 , 0x8232E039},
{ 0x4249 , 0x8232E130},
{ 0x424A , 0x8232E131},
{ 0x424B , 0x8232E132},
{ 0x424C , 0x8232E133},
{ 0x424D , 0x8232E134},
{ 0x424E , 0x8232E135},
{ 0x424F , 0x8232E136},
{ 0x4250 , 0x8232E137},
{ 0x4251 , 0x8232E138},
{ 0x4252 , 0x8232E139},
{ 0x4253 , 0x8232E230},
{ 0x4254 , 0x8232E231},
{ 0x4255 , 0x8232E232},
{ 0x4256 , 0x8232E233},
{ 0x4257 , 0x8232E234},
{ 0x4258 , 0x8232E235},
{ 0x4259 , 0x8232E236},
{ 0x425A , 0x8232E237},
{ 0x425B , 0x8232E238},
{ 0x425C , 0x8232E239},
{ 0x425D , 0x8232E330},
{ 0x425E , 0x8232E331},
{ 0x425F , 0x8232E332},
{ 0x4260 , 0x8232E333},
{ 0x4261 , 0x8232E334},
{ 0x4262 , 0x8232E335},
{ 0x4263 , 0x8232E336},
{ 0x4264 , 0x8232E337},
{ 0x4265 , 0x8232E338},
{ 0x4266 , 0x8232E339},
{ 0x4267 , 0x8232E430},
{ 0x4268 , 0x8232E431},
{ 0x4269 , 0x8232E432},
{ 0x426A , 0x8232E433},
{ 0x426B , 0x8232E434},
{ 0x426C , 0x8232E435},
{ 0x426D , 0x8232E436},
{ 0x426E , 0x8232E437},
{ 0x426F , 0x8232E438},
{ 0x4270 , 0x8232E439},
{ 0x4271 , 0x8232E530},
{ 0x4272 , 0x8232E531},
{ 0x4273 , 0x8232E532},
{ 0x4274 , 0x8232E533},
{ 0x4275 , 0x8232E534},
{ 0x4276 , 0x8232E535},
{ 0x4277 , 0x8232E536},
{ 0x4278 , 0x8232E537},
{ 0x4279 , 0x8232E538},
{ 0x427A , 0x8232E539},
{ 0x427B , 0x8232E630},
{ 0x427C , 0x8232E631},
{ 0x427D , 0x8232E632},
{ 0x427E , 0x8232E633},
{ 0x427F , 0x8232E634},
{ 0x4280 , 0x8232E635},
{ 0x4281 , 0x8232E636},
{ 0x4282 , 0x8232E637},
{ 0x4283 , 0x8232E638},
{ 0x4284 , 0x8232E639},
{ 0x4285 , 0x8232E730},
{ 0x4286 , 0x8232E731},
{ 0x4287 , 0x8232E732},
{ 0x4288 , 0x8232E733},
{ 0x4289 , 0x8232E734},
{ 0x428A , 0x8232E735},
{ 0x428B , 0x8232E736},
{ 0x428C , 0x8232E737},
{ 0x428D , 0x8232E738},
{ 0x428E , 0x8232E739},
{ 0x428F , 0x8232E830},
{ 0x4290 , 0x8232E831},
{ 0x4291 , 0x8232E832},
{ 0x4292 , 0x8232E833},
{ 0x4293 , 0x8232E834},
{ 0x4294 , 0x8232E835},
{ 0x4295 , 0x8232E836},
{ 0x4296 , 0x8232E837},
{ 0x4297 , 0x8232E838},
{ 0x4298 , 0x8232E839},
{ 0x4299 , 0x8232E930},
{ 0x429A , 0x8232E931},
{ 0x429B , 0x8232E932},
{ 0x429C , 0x8232E933},
{ 0x429D , 0x8232E934},
{ 0x429E , 0x8232E935},
{ 0x429F , 0x8232E936},
{ 0x42A0 , 0x8232E937},
{ 0x42A1 , 0x8232E938},
{ 0x42A2 , 0x8232E939},
{ 0x42A3 , 0x8232EA30},
{ 0x42A4 , 0x8232EA31},
{ 0x42A5 , 0x8232EA32},
{ 0x42A6 , 0x8232EA33},
{ 0x42A7 , 0x8232EA34},
{ 0x42A8 , 0x8232EA35},
{ 0x42A9 , 0x8232EA36},
{ 0x42AA , 0x8232EA37},
{ 0x42AB , 0x8232EA38},
{ 0x42AC , 0x8232EA39},
{ 0x42AD , 0x8232EB30},
{ 0x42AE , 0x8232EB31},
{ 0x42AF , 0x8232EB32},
{ 0x42B0 , 0x8232EB33},
{ 0x42B1 , 0x8232EB34},
{ 0x42B2 , 0x8232EB35},
{ 0x42B3 , 0x8232EB36},
{ 0x42B4 , 0x8232EB37},
{ 0x42B5 , 0x8232EB38},
{ 0x42B6 , 0x8232EB39},
{ 0x42B7 , 0x8232EC30},
{ 0x42B8 , 0x8232EC31},
{ 0x42B9 , 0x8232EC32},
{ 0x42BA , 0x8232EC33},
{ 0x42BB , 0x8232EC34},
{ 0x42BC , 0x8232EC35},
{ 0x42BD , 0x8232EC36},
{ 0x42BE , 0x8232EC37},
{ 0x42BF , 0x8232EC38},
{ 0x42C0 , 0x8232EC39},
{ 0x42C1 , 0x8232ED30},
{ 0x42C2 , 0x8232ED31},
{ 0x42C3 , 0x8232ED32},
{ 0x42C4 , 0x8232ED33},
{ 0x42C5 , 0x8232ED34},
{ 0x42C6 , 0x8232ED35},
{ 0x42C7 , 0x8232ED36},
{ 0x42C8 , 0x8232ED37},
{ 0x42C9 , 0x8232ED38},
{ 0x42CA , 0x8232ED39},
{ 0x42CB , 0x8232EE30},
{ 0x42CC , 0x8232EE31},
{ 0x42CD , 0x8232EE32},
{ 0x42CE , 0x8232EE33},
{ 0x42CF , 0x8232EE34},
{ 0x42D0 , 0x8232EE35},
{ 0x42D1 , 0x8232EE36},
{ 0x42D2 , 0x8232EE37},
{ 0x42D3 , 0x8232EE38},
{ 0x42D4 , 0x8232EE39},
{ 0x42D5 , 0x8232EF30},
{ 0x42D6 , 0x8232EF31},
{ 0x42D7 , 0x8232EF32},
{ 0x42D8 , 0x8232EF33},
{ 0x42D9 , 0x8232EF34},
{ 0x42DA , 0x8232EF35},
{ 0x42DB , 0x8232EF36},
{ 0x42DC , 0x8232EF37},
{ 0x42DD , 0x8232EF38},
{ 0x42DE , 0x8232EF39},
{ 0x42DF , 0x8232F030},
{ 0x42E0 , 0x8232F031},
{ 0x42E1 , 0x8232F032},
{ 0x42E2 , 0x8232F033},
{ 0x42E3 , 0x8232F034},
{ 0x42E4 , 0x8232F035},
{ 0x42E5 , 0x8232F036},
{ 0x42E6 , 0x8232F037},
{ 0x42E7 , 0x8232F038},
{ 0x42E8 , 0x8232F039},
{ 0x42E9 , 0x8232F130},
{ 0x42EA , 0x8232F131},
{ 0x42EB , 0x8232F132},
{ 0x42EC , 0x8232F133},
{ 0x42ED , 0x8232F134},
{ 0x42EE , 0x8232F135},
{ 0x42EF , 0x8232F136},
{ 0x42F0 , 0x8232F137},
{ 0x42F1 , 0x8232F138},
{ 0x42F2 , 0x8232F139},
{ 0x42F3 , 0x8232F230},
{ 0x42F4 , 0x8232F231},
{ 0x42F5 , 0x8232F232},
{ 0x42F6 , 0x8232F233},
{ 0x42F7 , 0x8232F234},
{ 0x42F8 , 0x8232F235},
{ 0x42F9 , 0x8232F236},
{ 0x42FA , 0x8232F237},
{ 0x42FB , 0x8232F238},
{ 0x42FC , 0x8232F239},
{ 0x42FD , 0x8232F330},
{ 0x42FE , 0x8232F331},
{ 0x42FF , 0x8232F332},
{ 0x4300 , 0x8232F333},
{ 0x4301 , 0x8232F334},
{ 0x4302 , 0x8232F335},
{ 0x4303 , 0x8232F336},
{ 0x4304 , 0x8232F337},
{ 0x4305 , 0x8232F338},
{ 0x4306 , 0x8232F339},
{ 0x4307 , 0x8232F430},
{ 0x4308 , 0x8232F431},
{ 0x4309 , 0x8232F432},
{ 0x430A , 0x8232F433},
{ 0x430B , 0x8232F434},
{ 0x430C , 0x8232F435},
{ 0x430D , 0x8232F436},
{ 0x430E , 0x8232F437},
{ 0x430F , 0x8232F438},
{ 0x4310 , 0x8232F439},
{ 0x4311 , 0x8232F530},
{ 0x4312 , 0x8232F531},
{ 0x4313 , 0x8232F532},
{ 0x4314 , 0x8232F533},
{ 0x4315 , 0x8232F534},
{ 0x4316 , 0x8232F535},
{ 0x4317 , 0x8232F536},
{ 0x4318 , 0x8232F537},
{ 0x4319 , 0x8232F538},
{ 0x431A , 0x8232F539},
{ 0x431B , 0x8232F630},
{ 0x431C , 0x8232F631},
{ 0x431D , 0x8232F632},
{ 0x431E , 0x8232F633},
{ 0x431F , 0x8232F634},
{ 0x4320 , 0x8232F635},
{ 0x4321 , 0x8232F636},
{ 0x4322 , 0x8232F637},
{ 0x4323 , 0x8232F638},
{ 0x4324 , 0x8232F639},
{ 0x4325 , 0x8232F730},
{ 0x4326 , 0x8232F731},
{ 0x4327 , 0x8232F732},
{ 0x4328 , 0x8232F733},
{ 0x4329 , 0x8232F734},
{ 0x432A , 0x8232F735},
{ 0x432B , 0x8232F736},
{ 0x432C , 0x8232F737},
{ 0x432D , 0x8232F738},
{ 0x432E , 0x8232F739},
{ 0x432F , 0x8232F830},
{ 0x4330 , 0x8232F831},
{ 0x4331 , 0x8232F832},
{ 0x4332 , 0x8232F833},
{ 0x4333 , 0x8232F834},
{ 0x4334 , 0x8232F835},
{ 0x4335 , 0x8232F836},
{ 0x4336 , 0x8232F837},
{ 0x4338 , 0x8232F838},
{ 0x4339 , 0x8232F839},
{ 0x433A , 0x8232F930},
{ 0x433B , 0x8232F931},
{ 0x433C , 0x8232F932},
{ 0x433D , 0x8232F933},
{ 0x433E , 0x8232F934},
{ 0x433F , 0x8232F935},
{ 0x4340 , 0x8232F936},
{ 0x4341 , 0x8232F937},
{ 0x4342 , 0x8232F938},
{ 0x4343 , 0x8232F939},
{ 0x4344 , 0x8232FA30},
{ 0x4345 , 0x8232FA31},
{ 0x4346 , 0x8232FA32},
{ 0x4347 , 0x8232FA33},
{ 0x4348 , 0x8232FA34},
{ 0x4349 , 0x8232FA35},
{ 0x434A , 0x8232FA36},
{ 0x434B , 0x8232FA37},
{ 0x434C , 0x8232FA38},
{ 0x434D , 0x8232FA39},
{ 0x434E , 0x8232FB30},
{ 0x434F , 0x8232FB31},
{ 0x4350 , 0x8232FB32},
{ 0x4351 , 0x8232FB33},
{ 0x4352 , 0x8232FB34},
{ 0x4353 , 0x8232FB35},
{ 0x4354 , 0x8232FB36},
{ 0x4355 , 0x8232FB37},
{ 0x4356 , 0x8232FB38},
{ 0x4357 , 0x8232FB39},
{ 0x4358 , 0x8232FC30},
{ 0x4359 , 0x8232FC31},
{ 0x435A , 0x8232FC32},
{ 0x435B , 0x8232FC33},
{ 0x435C , 0x8232FC34},
{ 0x435D , 0x8232FC35},
{ 0x435E , 0x8232FC36},
{ 0x435F , 0x8232FC37},
{ 0x4360 , 0x8232FC38},
{ 0x4361 , 0x8232FC39},
{ 0x4362 , 0x8232FD30},
{ 0x4363 , 0x8232FD31},
{ 0x4364 , 0x8232FD32},
{ 0x4365 , 0x8232FD33},
{ 0x4366 , 0x8232FD34},
{ 0x4367 , 0x8232FD35},
{ 0x4368 , 0x8232FD36},
{ 0x4369 , 0x8232FD37},
{ 0x436A , 0x8232FD38},
{ 0x436B , 0x8232FD39},
{ 0x436C , 0x8232FE30},
{ 0x436D , 0x8232FE31},
{ 0x436E , 0x8232FE32},
{ 0x436F , 0x8232FE33},
{ 0x4370 , 0x8232FE34},
{ 0x4371 , 0x8232FE35},
{ 0x4372 , 0x8232FE36},
{ 0x4373 , 0x8232FE37},
{ 0x4374 , 0x8232FE38},
{ 0x4375 , 0x8232FE39},
{ 0x4376 , 0x82338130},
{ 0x4377 , 0x82338131},
{ 0x4378 , 0x82338132},
{ 0x4379 , 0x82338133},
{ 0x437A , 0x82338134},
{ 0x437B , 0x82338135},
{ 0x437C , 0x82338136},
{ 0x437D , 0x82338137},
{ 0x437E , 0x82338138},
{ 0x437F , 0x82338139},
{ 0x4380 , 0x82338230},
{ 0x4381 , 0x82338231},
{ 0x4382 , 0x82338232},
{ 0x4383 , 0x82338233},
{ 0x4384 , 0x82338234},
{ 0x4385 , 0x82338235},
{ 0x4386 , 0x82338236},
{ 0x4387 , 0x82338237},
{ 0x4388 , 0x82338238},
{ 0x4389 , 0x82338239},
{ 0x438A , 0x82338330},
{ 0x438B , 0x82338331},
{ 0x438C , 0x82338332},
{ 0x438D , 0x82338333},
{ 0x438E , 0x82338334},
{ 0x438F , 0x82338335},
{ 0x4390 , 0x82338336},
{ 0x4391 , 0x82338337},
{ 0x4392 , 0x82338338},
{ 0x4393 , 0x82338339},
{ 0x4394 , 0x82338430},
{ 0x4395 , 0x82338431},
{ 0x4396 , 0x82338432},
{ 0x4397 , 0x82338433},
{ 0x4398 , 0x82338434},
{ 0x4399 , 0x82338435},
{ 0x439A , 0x82338436},
{ 0x439B , 0x82338437},
{ 0x439C , 0x82338438},
{ 0x439D , 0x82338439},
{ 0x439E , 0x82338530},
{ 0x439F , 0x82338531},
{ 0x43A0 , 0x82338532},
{ 0x43A1 , 0x82338533},
{ 0x43A2 , 0x82338534},
{ 0x43A3 , 0x82338535},
{ 0x43A4 , 0x82338536},
{ 0x43A5 , 0x82338537},
{ 0x43A6 , 0x82338538},
{ 0x43A7 , 0x82338539},
{ 0x43A8 , 0x82338630},
{ 0x43A9 , 0x82338631},
{ 0x43AA , 0x82338632},
{ 0x43AB , 0x82338633},
{ 0x43AD , 0x82338634},
{ 0x43AE , 0x82338635},
{ 0x43AF , 0x82338636},
{ 0x43B0 , 0x82338637},
{ 0x43B2 , 0x82338638},
{ 0x43B3 , 0x82338639},
{ 0x43B4 , 0x82338730},
{ 0x43B5 , 0x82338731},
{ 0x43B6 , 0x82338732},
{ 0x43B7 , 0x82338733},
{ 0x43B8 , 0x82338734},
{ 0x43B9 , 0x82338735},
{ 0x43BA , 0x82338736},
{ 0x43BB , 0x82338737},
{ 0x43BC , 0x82338738},
{ 0x43BD , 0x82338739},
{ 0x43BE , 0x82338830},
{ 0x43BF , 0x82338831},
{ 0x43C0 , 0x82338832},
{ 0x43C1 , 0x82338833},
{ 0x43C2 , 0x82338834},
{ 0x43C3 , 0x82338835},
{ 0x43C4 , 0x82338836},
{ 0x43C5 , 0x82338837},
{ 0x43C6 , 0x82338838},
{ 0x43C7 , 0x82338839},
{ 0x43C8 , 0x82338930},
{ 0x43C9 , 0x82338931},
{ 0x43CA , 0x82338932},
{ 0x43CB , 0x82338933},
{ 0x43CC , 0x82338934},
{ 0x43CD , 0x82338935},
{ 0x43CE , 0x82338936},
{ 0x43CF , 0x82338937},
{ 0x43D0 , 0x82338938},
{ 0x43D1 , 0x82338939},
{ 0x43D2 , 0x82338A30},
{ 0x43D3 , 0x82338A31},
{ 0x43D4 , 0x82338A32},
{ 0x43D5 , 0x82338A33},
{ 0x43D6 , 0x82338A34},
{ 0x43D7 , 0x82338A35},
{ 0x43D8 , 0x82338A36},
{ 0x43D9 , 0x82338A37},
{ 0x43DA , 0x82338A38},
{ 0x43DB , 0x82338A39},
{ 0x43DC , 0x82338B30},
{ 0x43DE , 0x82338B31},
{ 0x43DF , 0x82338B32},
{ 0x43E0 , 0x82338B33},
{ 0x43E1 , 0x82338B34},
{ 0x43E2 , 0x82338B35},
{ 0x43E3 , 0x82338B36},
{ 0x43E4 , 0x82338B37},
{ 0x43E5 , 0x82338B38},
{ 0x43E6 , 0x82338B39},
{ 0x43E7 , 0x82338C30},
{ 0x43E8 , 0x82338C31},
{ 0x43E9 , 0x82338C32},
{ 0x43EA , 0x82338C33},
{ 0x43EB , 0x82338C34},
{ 0x43EC , 0x82338C35},
{ 0x43ED , 0x82338C36},
{ 0x43EE , 0x82338C37},
{ 0x43EF , 0x82338C38},
{ 0x43F0 , 0x82338C39},
{ 0x43F1 , 0x82338D30},
{ 0x43F2 , 0x82338D31},
{ 0x43F3 , 0x82338D32},
{ 0x43F4 , 0x82338D33},
{ 0x43F5 , 0x82338D34},
{ 0x43F6 , 0x82338D35},
{ 0x43F7 , 0x82338D36},
{ 0x43F8 , 0x82338D37},
{ 0x43F9 , 0x82338D38},
{ 0x43FA , 0x82338D39},
{ 0x43FB , 0x82338E30},
{ 0x43FC , 0x82338E31},
{ 0x43FD , 0x82338E32},
{ 0x43FE , 0x82338E33},
{ 0x43FF , 0x82338E34},
{ 0x4400 , 0x82338E35},
{ 0x4401 , 0x82338E36},
{ 0x4402 , 0x82338E37},
{ 0x4403 , 0x82338E38},
{ 0x4404 , 0x82338E39},
{ 0x4405 , 0x82338F30},
{ 0x4406 , 0x82338F31},
{ 0x4407 , 0x82338F32},
{ 0x4408 , 0x82338F33},
{ 0x4409 , 0x82338F34},
{ 0x440A , 0x82338F35},
{ 0x440B , 0x82338F36},
{ 0x440C , 0x82338F37},
{ 0x440D , 0x82338F38},
{ 0x440E , 0x82338F39},
{ 0x440F , 0x82339030},
{ 0x4410 , 0x82339031},
{ 0x4411 , 0x82339032},
{ 0x4412 , 0x82339033},
{ 0x4413 , 0x82339034},
{ 0x4414 , 0x82339035},
{ 0x4415 , 0x82339036},
{ 0x4416 , 0x82339037},
{ 0x4417 , 0x82339038},
{ 0x4418 , 0x82339039},
{ 0x4419 , 0x82339130},
{ 0x441A , 0x82339131},
{ 0x441B , 0x82339132},
{ 0x441C , 0x82339133},
{ 0x441D , 0x82339134},
{ 0x441E , 0x82339135},
{ 0x441F , 0x82339136},
{ 0x4420 , 0x82339137},
{ 0x4421 , 0x82339138},
{ 0x4422 , 0x82339139},
{ 0x4423 , 0x82339230},
{ 0x4424 , 0x82339231},
{ 0x4425 , 0x82339232},
{ 0x4426 , 0x82339233},
{ 0x4427 , 0x82339234},
{ 0x4428 , 0x82339235},
{ 0x4429 , 0x82339236},
{ 0x442A , 0x82339237},
{ 0x442B , 0x82339238},
{ 0x442C , 0x82339239},
{ 0x442D , 0x82339330},
{ 0x442E , 0x82339331},
{ 0x442F , 0x82339332},
{ 0x4430 , 0x82339333},
{ 0x4431 , 0x82339334},
{ 0x4432 , 0x82339335},
{ 0x4433 , 0x82339336},
{ 0x4434 , 0x82339337},
{ 0x4435 , 0x82339338},
{ 0x4436 , 0x82339339},
{ 0x4437 , 0x82339430},
{ 0x4438 , 0x82339431},
{ 0x4439 , 0x82339432},
{ 0x443A , 0x82339433},
{ 0x443B , 0x82339434},
{ 0x443C , 0x82339435},
{ 0x443D , 0x82339436},
{ 0x443E , 0x82339437},
{ 0x443F , 0x82339438},
{ 0x4440 , 0x82339439},
{ 0x4441 , 0x82339530},
{ 0x4442 , 0x82339531},
{ 0x4443 , 0x82339532},
{ 0x4444 , 0x82339533},
{ 0x4445 , 0x82339534},
{ 0x4446 , 0x82339535},
{ 0x4447 , 0x82339536},
{ 0x4448 , 0x82339537},
{ 0x4449 , 0x82339538},
{ 0x444A , 0x82339539},
{ 0x444B , 0x82339630},
{ 0x444C , 0x82339631},
{ 0x444D , 0x82339632},
{ 0x444E , 0x82339633},
{ 0x444F , 0x82339634},
{ 0x4450 , 0x82339635},
{ 0x4451 , 0x82339636},
{ 0x4452 , 0x82339637},
{ 0x4453 , 0x82339638},
{ 0x4454 , 0x82339639},
{ 0x4455 , 0x82339730},
{ 0x4456 , 0x82339731},
{ 0x4457 , 0x82339732},
{ 0x4458 , 0x82339733},
{ 0x4459 , 0x82339734},
{ 0x445A , 0x82339735},
{ 0x445B , 0x82339736},
{ 0x445C , 0x82339737},
{ 0x445D , 0x82339738},
{ 0x445E , 0x82339739},
{ 0x445F , 0x82339830},
{ 0x4460 , 0x82339831},
{ 0x4461 , 0x82339832},
{ 0x4462 , 0x82339833},
{ 0x4463 , 0x82339834},
{ 0x4464 , 0x82339835},
{ 0x4465 , 0x82339836},
{ 0x4466 , 0x82339837},
{ 0x4467 , 0x82339838},
{ 0x4468 , 0x82339839},
{ 0x4469 , 0x82339930},
{ 0x446A , 0x82339931},
{ 0x446B , 0x82339932},
{ 0x446C , 0x82339933},
{ 0x446D , 0x82339934},
{ 0x446E , 0x82339935},
{ 0x446F , 0x82339936},
{ 0x4470 , 0x82339937},
{ 0x4471 , 0x82339938},
{ 0x4472 , 0x82339939},
{ 0x4473 , 0x82339A30},
{ 0x4474 , 0x82339A31},
{ 0x4475 , 0x82339A32},
{ 0x4476 , 0x82339A33},
{ 0x4477 , 0x82339A34},
{ 0x4478 , 0x82339A35},
{ 0x4479 , 0x82339A36},
{ 0x447A , 0x82339A37},
{ 0x447B , 0x82339A38},
{ 0x447C , 0x82339A39},
{ 0x447D , 0x82339B30},
{ 0x447E , 0x82339B31},
{ 0x447F , 0x82339B32},
{ 0x4480 , 0x82339B33},
{ 0x4481 , 0x82339B34},
{ 0x4482 , 0x82339B35},
{ 0x4483 , 0x82339B36},
{ 0x4484 , 0x82339B37},
{ 0x4485 , 0x82339B38},
{ 0x4486 , 0x82339B39},
{ 0x4487 , 0x82339C30},
{ 0x4488 , 0x82339C31},
{ 0x4489 , 0x82339C32},
{ 0x448A , 0x82339C33},
{ 0x448B , 0x82339C34},
{ 0x448C , 0x82339C35},
{ 0x448D , 0x82339C36},
{ 0x448E , 0x82339C37},
{ 0x448F , 0x82339C38},
{ 0x4490 , 0x82339C39},
{ 0x4491 , 0x82339D30},
{ 0x4492 , 0x82339D31},
{ 0x4493 , 0x82339D32},
{ 0x4494 , 0x82339D33},
{ 0x4495 , 0x82339D34},
{ 0x4496 , 0x82339D35},
{ 0x4497 , 0x82339D36},
{ 0x4498 , 0x82339D37},
{ 0x4499 , 0x82339D38},
{ 0x449A , 0x82339D39},
{ 0x449B , 0x82339E30},
{ 0x449C , 0x82339E31},
{ 0x449D , 0x82339E32},
{ 0x449E , 0x82339E33},
{ 0x449F , 0x82339E34},
{ 0x44A0 , 0x82339E35},
{ 0x44A1 , 0x82339E36},
{ 0x44A2 , 0x82339E37},
{ 0x44A3 , 0x82339E38},
{ 0x44A4 , 0x82339E39},
{ 0x44A5 , 0x82339F30},
{ 0x44A6 , 0x82339F31},
{ 0x44A7 , 0x82339F32},
{ 0x44A8 , 0x82339F33},
{ 0x44A9 , 0x82339F34},
{ 0x44AA , 0x82339F35},
{ 0x44AB , 0x82339F36},
{ 0x44AC , 0x82339F37},
{ 0x44AD , 0x82339F38},
{ 0x44AE , 0x82339F39},
{ 0x44AF , 0x8233A030},
{ 0x44B0 , 0x8233A031},
{ 0x44B1 , 0x8233A032},
{ 0x44B2 , 0x8233A033},
{ 0x44B3 , 0x8233A034},
{ 0x44B4 , 0x8233A035},
{ 0x44B5 , 0x8233A036},
{ 0x44B6 , 0x8233A037},
{ 0x44B7 , 0x8233A038},
{ 0x44B8 , 0x8233A039},
{ 0x44B9 , 0x8233A130},
{ 0x44BA , 0x8233A131},
{ 0x44BB , 0x8233A132},
{ 0x44BC , 0x8233A133},
{ 0x44BD , 0x8233A134},
{ 0x44BE , 0x8233A135},
{ 0x44BF , 0x8233A136},
{ 0x44C0 , 0x8233A137},
{ 0x44C1 , 0x8233A138},
{ 0x44C2 , 0x8233A139},
{ 0x44C3 , 0x8233A230},
{ 0x44C4 , 0x8233A231},
{ 0x44C5 , 0x8233A232},
{ 0x44C6 , 0x8233A233},
{ 0x44C7 , 0x8233A234},
{ 0x44C8 , 0x8233A235},
{ 0x44C9 , 0x8233A236},
{ 0x44CA , 0x8233A237},
{ 0x44CB , 0x8233A238},
{ 0x44CC , 0x8233A239},
{ 0x44CD , 0x8233A330},
{ 0x44CE , 0x8233A331},
{ 0x44CF , 0x8233A332},
{ 0x44D0 , 0x8233A333},
{ 0x44D1 , 0x8233A334},
{ 0x44D2 , 0x8233A335},
{ 0x44D3 , 0x8233A336},
{ 0x44D4 , 0x8233A337},
{ 0x44D5 , 0x8233A338},
{ 0x44D7 , 0x8233A339},
{ 0x44D8 , 0x8233A430},
{ 0x44D9 , 0x8233A431},
{ 0x44DA , 0x8233A432},
{ 0x44DB , 0x8233A433},
{ 0x44DC , 0x8233A434},
{ 0x44DD , 0x8233A435},
{ 0x44DE , 0x8233A436},
{ 0x44DF , 0x8233A437},
{ 0x44E0 , 0x8233A438},
{ 0x44E1 , 0x8233A439},
{ 0x44E2 , 0x8233A530},
{ 0x44E3 , 0x8233A531},
{ 0x44E4 , 0x8233A532},
{ 0x44E5 , 0x8233A533},
{ 0x44E6 , 0x8233A534},
{ 0x44E7 , 0x8233A535},
{ 0x44E8 , 0x8233A536},
{ 0x44E9 , 0x8233A537},
{ 0x44EA , 0x8233A538},
{ 0x44EB , 0x8233A539},
{ 0x44EC , 0x8233A630},
{ 0x44ED , 0x8233A631},
{ 0x44EE , 0x8233A632},
{ 0x44EF , 0x8233A633},
{ 0x44F0 , 0x8233A634},
{ 0x44F1 , 0x8233A635},
{ 0x44F2 , 0x8233A636},
{ 0x44F3 , 0x8233A637},
{ 0x44F4 , 0x8233A638},
{ 0x44F5 , 0x8233A639},
{ 0x44F6 , 0x8233A730},
{ 0x44F7 , 0x8233A731},
{ 0x44F8 , 0x8233A732},
{ 0x44F9 , 0x8233A733},
{ 0x44FA , 0x8233A734},
{ 0x44FB , 0x8233A735},
{ 0x44FC , 0x8233A736},
{ 0x44FD , 0x8233A737},
{ 0x44FE , 0x8233A738},
{ 0x44FF , 0x8233A739},
{ 0x4500 , 0x8233A830},
{ 0x4501 , 0x8233A831},
{ 0x4502 , 0x8233A832},
{ 0x4503 , 0x8233A833},
{ 0x4504 , 0x8233A834},
{ 0x4505 , 0x8233A835},
{ 0x4506 , 0x8233A836},
{ 0x4507 , 0x8233A837},
{ 0x4508 , 0x8233A838},
{ 0x4509 , 0x8233A839},
{ 0x450A , 0x8233A930},
{ 0x450B , 0x8233A931},
{ 0x450C , 0x8233A932},
{ 0x450D , 0x8233A933},
{ 0x450E , 0x8233A934},
{ 0x450F , 0x8233A935},
{ 0x4510 , 0x8233A936},
{ 0x4511 , 0x8233A937},
{ 0x4512 , 0x8233A938},
{ 0x4513 , 0x8233A939},
{ 0x4514 , 0x8233AA30},
{ 0x4515 , 0x8233AA31},
{ 0x4516 , 0x8233AA32},
{ 0x4517 , 0x8233AA33},
{ 0x4518 , 0x8233AA34},
{ 0x4519 , 0x8233AA35},
{ 0x451A , 0x8233AA36},
{ 0x451B , 0x8233AA37},
{ 0x451C , 0x8233AA38},
{ 0x451D , 0x8233AA39},
{ 0x451E , 0x8233AB30},
{ 0x451F , 0x8233AB31},
{ 0x4520 , 0x8233AB32},
{ 0x4521 , 0x8233AB33},
{ 0x4522 , 0x8233AB34},
{ 0x4523 , 0x8233AB35},
{ 0x4524 , 0x8233AB36},
{ 0x4525 , 0x8233AB37},
{ 0x4526 , 0x8233AB38},
{ 0x4527 , 0x8233AB39},
{ 0x4528 , 0x8233AC30},
{ 0x4529 , 0x8233AC31},
{ 0x452A , 0x8233AC32},
{ 0x452B , 0x8233AC33},
{ 0x452C , 0x8233AC34},
{ 0x452D , 0x8233AC35},
{ 0x452E , 0x8233AC36},
{ 0x452F , 0x8233AC37},
{ 0x4530 , 0x8233AC38},
{ 0x4531 , 0x8233AC39},
{ 0x4532 , 0x8233AD30},
{ 0x4533 , 0x8233AD31},
{ 0x4534 , 0x8233AD32},
{ 0x4535 , 0x8233AD33},
{ 0x4536 , 0x8233AD34},
{ 0x4537 , 0x8233AD35},
{ 0x4538 , 0x8233AD36},
{ 0x4539 , 0x8233AD37},
{ 0x453A , 0x8233AD38},
{ 0x453B , 0x8233AD39},
{ 0x453C , 0x8233AE30},
{ 0x453D , 0x8233AE31},
{ 0x453E , 0x8233AE32},
{ 0x453F , 0x8233AE33},
{ 0x4540 , 0x8233AE34},
{ 0x4541 , 0x8233AE35},
{ 0x4542 , 0x8233AE36},
{ 0x4543 , 0x8233AE37},
{ 0x4544 , 0x8233AE38},
{ 0x4545 , 0x8233AE39},
{ 0x4546 , 0x8233AF30},
{ 0x4547 , 0x8233AF31},
{ 0x4548 , 0x8233AF32},
{ 0x4549 , 0x8233AF33},
{ 0x454A , 0x8233AF34},
{ 0x454B , 0x8233AF35},
{ 0x454C , 0x8233AF36},
{ 0x454D , 0x8233AF37},
{ 0x454E , 0x8233AF38},
{ 0x454F , 0x8233AF39},
{ 0x4550 , 0x8233B030},
{ 0x4551 , 0x8233B031},
{ 0x4552 , 0x8233B032},
{ 0x4553 , 0x8233B033},
{ 0x4554 , 0x8233B034},
{ 0x4555 , 0x8233B035},
{ 0x4556 , 0x8233B036},
{ 0x4557 , 0x8233B037},
{ 0x4558 , 0x8233B038},
{ 0x4559 , 0x8233B039},
{ 0x455A , 0x8233B130},
{ 0x455B , 0x8233B131},
{ 0x455C , 0x8233B132},
{ 0x455D , 0x8233B133},
{ 0x455E , 0x8233B134},
{ 0x455F , 0x8233B135},
{ 0x4560 , 0x8233B136},
{ 0x4561 , 0x8233B137},
{ 0x4562 , 0x8233B138},
{ 0x4563 , 0x8233B139},
{ 0x4564 , 0x8233B230},
{ 0x4565 , 0x8233B231},
{ 0x4566 , 0x8233B232},
{ 0x4567 , 0x8233B233},
{ 0x4568 , 0x8233B234},
{ 0x4569 , 0x8233B235},
{ 0x456A , 0x8233B236},
{ 0x456B , 0x8233B237},
{ 0x456C , 0x8233B238},
{ 0x456D , 0x8233B239},
{ 0x456E , 0x8233B330},
{ 0x456F , 0x8233B331},
{ 0x4570 , 0x8233B332},
{ 0x4571 , 0x8233B333},
{ 0x4572 , 0x8233B334},
{ 0x4573 , 0x8233B335},
{ 0x4574 , 0x8233B336},
{ 0x4575 , 0x8233B337},
{ 0x4576 , 0x8233B338},
{ 0x4577 , 0x8233B339},
{ 0x4578 , 0x8233B430},
{ 0x4579 , 0x8233B431},
{ 0x457A , 0x8233B432},
{ 0x457B , 0x8233B433},
{ 0x457C , 0x8233B434},
{ 0x457D , 0x8233B435},
{ 0x457E , 0x8233B436},
{ 0x457F , 0x8233B437},
{ 0x4580 , 0x8233B438},
{ 0x4581 , 0x8233B439},
{ 0x4582 , 0x8233B530},
{ 0x4583 , 0x8233B531},
{ 0x4584 , 0x8233B532},
{ 0x4585 , 0x8233B533},
{ 0x4586 , 0x8233B534},
{ 0x4587 , 0x8233B535},
{ 0x4588 , 0x8233B536},
{ 0x4589 , 0x8233B537},
{ 0x458A , 0x8233B538},
{ 0x458B , 0x8233B539},
{ 0x458C , 0x8233B630},
{ 0x458D , 0x8233B631},
{ 0x458E , 0x8233B632},
{ 0x458F , 0x8233B633},
{ 0x4590 , 0x8233B634},
{ 0x4591 , 0x8233B635},
{ 0x4592 , 0x8233B636},
{ 0x4593 , 0x8233B637},
{ 0x4594 , 0x8233B638},
{ 0x4595 , 0x8233B639},
{ 0x4596 , 0x8233B730},
{ 0x4597 , 0x8233B731},
{ 0x4598 , 0x8233B732},
{ 0x4599 , 0x8233B733},
{ 0x459A , 0x8233B734},
{ 0x459B , 0x8233B735},
{ 0x459C , 0x8233B736},
{ 0x459D , 0x8233B737},
{ 0x459E , 0x8233B738},
{ 0x459F , 0x8233B739},
{ 0x45A0 , 0x8233B830},
{ 0x45A1 , 0x8233B831},
{ 0x45A2 , 0x8233B832},
{ 0x45A3 , 0x8233B833},
{ 0x45A4 , 0x8233B834},
{ 0x45A5 , 0x8233B835},
{ 0x45A6 , 0x8233B836},
{ 0x45A7 , 0x8233B837},
{ 0x45A8 , 0x8233B838},
{ 0x45A9 , 0x8233B839},
{ 0x45AA , 0x8233B930},
{ 0x45AB , 0x8233B931},
{ 0x45AC , 0x8233B932},
{ 0x45AD , 0x8233B933},
{ 0x45AE , 0x8233B934},
{ 0x45AF , 0x8233B935},
{ 0x45B0 , 0x8233B936},
{ 0x45B1 , 0x8233B937},
{ 0x45B2 , 0x8233B938},
{ 0x45B3 , 0x8233B939},
{ 0x45B4 , 0x8233BA30},
{ 0x45B5 , 0x8233BA31},
{ 0x45B6 , 0x8233BA32},
{ 0x45B7 , 0x8233BA33},
{ 0x45B8 , 0x8233BA34},
{ 0x45B9 , 0x8233BA35},
{ 0x45BA , 0x8233BA36},
{ 0x45BB , 0x8233BA37},
{ 0x45BC , 0x8233BA38},
{ 0x45BD , 0x8233BA39},
{ 0x45BE , 0x8233BB30},
{ 0x45BF , 0x8233BB31},
{ 0x45C0 , 0x8233BB32},
{ 0x45C1 , 0x8233BB33},
{ 0x45C2 , 0x8233BB34},
{ 0x45C3 , 0x8233BB35},
{ 0x45C4 , 0x8233BB36},
{ 0x45C5 , 0x8233BB37},
{ 0x45C6 , 0x8233BB38},
{ 0x45C7 , 0x8233BB39},
{ 0x45C8 , 0x8233BC30},
{ 0x45C9 , 0x8233BC31},
{ 0x45CA , 0x8233BC32},
{ 0x45CB , 0x8233BC33},
{ 0x45CC , 0x8233BC34},
{ 0x45CD , 0x8233BC35},
{ 0x45CE , 0x8233BC36},
{ 0x45CF , 0x8233BC37},
{ 0x45D0 , 0x8233BC38},
{ 0x45D1 , 0x8233BC39},
{ 0x45D2 , 0x8233BD30},
{ 0x45D3 , 0x8233BD31},
{ 0x45D4 , 0x8233BD32},
{ 0x45D5 , 0x8233BD33},
{ 0x45D6 , 0x8233BD34},
{ 0x45D7 , 0x8233BD35},
{ 0x45D8 , 0x8233BD36},
{ 0x45D9 , 0x8233BD37},
{ 0x45DA , 0x8233BD38},
{ 0x45DB , 0x8233BD39},
{ 0x45DC , 0x8233BE30},
{ 0x45DD , 0x8233BE31},
{ 0x45DE , 0x8233BE32},
{ 0x45DF , 0x8233BE33},
{ 0x45E0 , 0x8233BE34},
{ 0x45E1 , 0x8233BE35},
{ 0x45E2 , 0x8233BE36},
{ 0x45E3 , 0x8233BE37},
{ 0x45E4 , 0x8233BE38},
{ 0x45E5 , 0x8233BE39},
{ 0x45E6 , 0x8233BF30},
{ 0x45E7 , 0x8233BF31},
{ 0x45E8 , 0x8233BF32},
{ 0x45E9 , 0x8233BF33},
{ 0x45EA , 0x8233BF34},
{ 0x45EB , 0x8233BF35},
{ 0x45EC , 0x8233BF36},
{ 0x45ED , 0x8233BF37},
{ 0x45EE , 0x8233BF38},
{ 0x45EF , 0x8233BF39},
{ 0x45F0 , 0x8233C030},
{ 0x45F1 , 0x8233C031},
{ 0x45F2 , 0x8233C032},
{ 0x45F3 , 0x8233C033},
{ 0x45F4 , 0x8233C034},
{ 0x45F5 , 0x8233C035},
{ 0x45F6 , 0x8233C036},
{ 0x45F7 , 0x8233C037},
{ 0x45F8 , 0x8233C038},
{ 0x45F9 , 0x8233C039},
{ 0x45FA , 0x8233C130},
{ 0x45FB , 0x8233C131},
{ 0x45FC , 0x8233C132},
{ 0x45FD , 0x8233C133},
{ 0x45FE , 0x8233C134},
{ 0x45FF , 0x8233C135},
{ 0x4600 , 0x8233C136},
{ 0x4601 , 0x8233C137},
{ 0x4602 , 0x8233C138},
{ 0x4603 , 0x8233C139},
{ 0x4604 , 0x8233C230},
{ 0x4605 , 0x8233C231},
{ 0x4606 , 0x8233C232},
{ 0x4607 , 0x8233C233},
{ 0x4608 , 0x8233C234},
{ 0x4609 , 0x8233C235},
{ 0x460A , 0x8233C236},
{ 0x460B , 0x8233C237},
{ 0x460C , 0x8233C238},
{ 0x460D , 0x8233C239},
{ 0x460E , 0x8233C330},
{ 0x460F , 0x8233C331},
{ 0x4610 , 0x8233C332},
{ 0x4611 , 0x8233C333},
{ 0x4612 , 0x8233C334},
{ 0x4613 , 0x8233C335},
{ 0x4614 , 0x8233C336},
{ 0x4615 , 0x8233C337},
{ 0x4616 , 0x8233C338},
{ 0x4617 , 0x8233C339},
{ 0x4618 , 0x8233C430},
{ 0x4619 , 0x8233C431},
{ 0x461A , 0x8233C432},
{ 0x461B , 0x8233C433},
{ 0x461C , 0x8233C434},
{ 0x461D , 0x8233C435},
{ 0x461E , 0x8233C436},
{ 0x461F , 0x8233C437},
{ 0x4620 , 0x8233C438},
{ 0x4621 , 0x8233C439},
{ 0x4622 , 0x8233C530},
{ 0x4623 , 0x8233C531},
{ 0x4624 , 0x8233C532},
{ 0x4625 , 0x8233C533},
{ 0x4626 , 0x8233C534},
{ 0x4627 , 0x8233C535},
{ 0x4628 , 0x8233C536},
{ 0x4629 , 0x8233C537},
{ 0x462A , 0x8233C538},
{ 0x462B , 0x8233C539},
{ 0x462C , 0x8233C630},
{ 0x462D , 0x8233C631},
{ 0x462E , 0x8233C632},
{ 0x462F , 0x8233C633},
{ 0x4630 , 0x8233C634},
{ 0x4631 , 0x8233C635},
{ 0x4632 , 0x8233C636},
{ 0x4633 , 0x8233C637},
{ 0x4634 , 0x8233C638},
{ 0x4635 , 0x8233C639},
{ 0x4636 , 0x8233C730},
{ 0x4637 , 0x8233C731},
{ 0x4638 , 0x8233C732},
{ 0x4639 , 0x8233C733},
{ 0x463A , 0x8233C734},
{ 0x463B , 0x8233C735},
{ 0x463C , 0x8233C736},
{ 0x463D , 0x8233C737},
{ 0x463E , 0x8233C738},
{ 0x463F , 0x8233C739},
{ 0x4640 , 0x8233C830},
{ 0x4641 , 0x8233C831},
{ 0x4642 , 0x8233C832},
{ 0x4643 , 0x8233C833},
{ 0x4644 , 0x8233C834},
{ 0x4645 , 0x8233C835},
{ 0x4646 , 0x8233C836},
{ 0x4647 , 0x8233C837},
{ 0x4648 , 0x8233C838},
{ 0x4649 , 0x8233C839},
{ 0x464A , 0x8233C930},
{ 0x464B , 0x8233C931},
{ 0x464D , 0x8233C932},
{ 0x464E , 0x8233C933},
{ 0x464F , 0x8233C934},
{ 0x4650 , 0x8233C935},
{ 0x4651 , 0x8233C936},
{ 0x4652 , 0x8233C937},
{ 0x4653 , 0x8233C938},
{ 0x4654 , 0x8233C939},
{ 0x4655 , 0x8233CA30},
{ 0x4656 , 0x8233CA31},
{ 0x4657 , 0x8233CA32},
{ 0x4658 , 0x8233CA33},
{ 0x4659 , 0x8233CA34},
{ 0x465A , 0x8233CA35},
{ 0x465B , 0x8233CA36},
{ 0x465C , 0x8233CA37},
{ 0x465D , 0x8233CA38},
{ 0x465E , 0x8233CA39},
{ 0x465F , 0x8233CB30},
{ 0x4660 , 0x8233CB31},
{ 0x4662 , 0x8233CB32},
{ 0x4663 , 0x8233CB33},
{ 0x4664 , 0x8233CB34},
{ 0x4665 , 0x8233CB35},
{ 0x4666 , 0x8233CB36},
{ 0x4667 , 0x8233CB37},
{ 0x4668 , 0x8233CB38},
{ 0x4669 , 0x8233CB39},
{ 0x466A , 0x8233CC30},
{ 0x466B , 0x8233CC31},
{ 0x466C , 0x8233CC32},
{ 0x466D , 0x8233CC33},
{ 0x466E , 0x8233CC34},
{ 0x466F , 0x8233CC35},
{ 0x4670 , 0x8233CC36},
{ 0x4671 , 0x8233CC37},
{ 0x4672 , 0x8233CC38},
{ 0x4673 , 0x8233CC39},
{ 0x4674 , 0x8233CD30},
{ 0x4675 , 0x8233CD31},
{ 0x4676 , 0x8233CD32},
{ 0x4677 , 0x8233CD33},
{ 0x4678 , 0x8233CD34},
{ 0x4679 , 0x8233CD35},
{ 0x467A , 0x8233CD36},
{ 0x467B , 0x8233CD37},
{ 0x467C , 0x8233CD38},
{ 0x467D , 0x8233CD39},
{ 0x467E , 0x8233CE30},
{ 0x467F , 0x8233CE31},
{ 0x4680 , 0x8233CE32},
{ 0x4681 , 0x8233CE33},
{ 0x4682 , 0x8233CE34},
{ 0x4683 , 0x8233CE35},
{ 0x4684 , 0x8233CE36},
{ 0x4685 , 0x8233CE37},
{ 0x4686 , 0x8233CE38},
{ 0x4687 , 0x8233CE39},
{ 0x4688 , 0x8233CF30},
{ 0x4689 , 0x8233CF31},
{ 0x468A , 0x8233CF32},
{ 0x468B , 0x8233CF33},
{ 0x468C , 0x8233CF34},
{ 0x468D , 0x8233CF35},
{ 0x468E , 0x8233CF36},
{ 0x468F , 0x8233CF37},
{ 0x4690 , 0x8233CF38},
{ 0x4691 , 0x8233CF39},
{ 0x4692 , 0x8233D030},
{ 0x4693 , 0x8233D031},
{ 0x4694 , 0x8233D032},
{ 0x4695 , 0x8233D033},
{ 0x4696 , 0x8233D034},
{ 0x4697 , 0x8233D035},
{ 0x4698 , 0x8233D036},
{ 0x4699 , 0x8233D037},
{ 0x469A , 0x8233D038},
{ 0x469B , 0x8233D039},
{ 0x469C , 0x8233D130},
{ 0x469D , 0x8233D131},
{ 0x469E , 0x8233D132},
{ 0x469F , 0x8233D133},
{ 0x46A0 , 0x8233D134},
{ 0x46A1 , 0x8233D135},
{ 0x46A2 , 0x8233D136},
{ 0x46A3 , 0x8233D137},
{ 0x46A4 , 0x8233D138},
{ 0x46A5 , 0x8233D139},
{ 0x46A6 , 0x8233D230},
{ 0x46A7 , 0x8233D231},
{ 0x46A8 , 0x8233D232},
{ 0x46A9 , 0x8233D233},
{ 0x46AA , 0x8233D234},
{ 0x46AB , 0x8233D235},
{ 0x46AC , 0x8233D236},
{ 0x46AD , 0x8233D237},
{ 0x46AE , 0x8233D238},
{ 0x46AF , 0x8233D239},
{ 0x46B0 , 0x8233D330},
{ 0x46B1 , 0x8233D331},
{ 0x46B2 , 0x8233D332},
{ 0x46B3 , 0x8233D333},
{ 0x46B4 , 0x8233D334},
{ 0x46B5 , 0x8233D335},
{ 0x46B6 , 0x8233D336},
{ 0x46B7 , 0x8233D337},
{ 0x46B8 , 0x8233D338},
{ 0x46B9 , 0x8233D339},
{ 0x46BA , 0x8233D430},
{ 0x46BB , 0x8233D431},
{ 0x46BC , 0x8233D432},
{ 0x46BD , 0x8233D433},
{ 0x46BE , 0x8233D434},
{ 0x46BF , 0x8233D435},
{ 0x46C0 , 0x8233D436},
{ 0x46C1 , 0x8233D437},
{ 0x46C2 , 0x8233D438},
{ 0x46C3 , 0x8233D439},
{ 0x46C4 , 0x8233D530},
{ 0x46C5 , 0x8233D531},
{ 0x46C6 , 0x8233D532},
{ 0x46C7 , 0x8233D533},
{ 0x46C8 , 0x8233D534},
{ 0x46C9 , 0x8233D535},
{ 0x46CA , 0x8233D536},
{ 0x46CB , 0x8233D537},
{ 0x46CC , 0x8233D538},
{ 0x46CD , 0x8233D539},
{ 0x46CE , 0x8233D630},
{ 0x46CF , 0x8233D631},
{ 0x46D0 , 0x8233D632},
{ 0x46D1 , 0x8233D633},
{ 0x46D2 , 0x8233D634},
{ 0x46D3 , 0x8233D635},
{ 0x46D4 , 0x8233D636},
{ 0x46D5 , 0x8233D637},
{ 0x46D6 , 0x8233D638},
{ 0x46D7 , 0x8233D639},
{ 0x46D8 , 0x8233D730},
{ 0x46D9 , 0x8233D731},
{ 0x46DA , 0x8233D732},
{ 0x46DB , 0x8233D733},
{ 0x46DC , 0x8233D734},
{ 0x46DD , 0x8233D735},
{ 0x46DE , 0x8233D736},
{ 0x46DF , 0x8233D737},
{ 0x46E0 , 0x8233D738},
{ 0x46E1 , 0x8233D739},
{ 0x46E2 , 0x8233D830},
{ 0x46E3 , 0x8233D831},
{ 0x46E4 , 0x8233D832},
{ 0x46E5 , 0x8233D833},
{ 0x46E6 , 0x8233D834},
{ 0x46E7 , 0x8233D835},
{ 0x46E8 , 0x8233D836},
{ 0x46E9 , 0x8233D837},
{ 0x46EA , 0x8233D838},
{ 0x46EB , 0x8233D839},
{ 0x46EC , 0x8233D930},
{ 0x46ED , 0x8233D931},
{ 0x46EE , 0x8233D932},
{ 0x46EF , 0x8233D933},
{ 0x46F0 , 0x8233D934},
{ 0x46F1 , 0x8233D935},
{ 0x46F2 , 0x8233D936},
{ 0x46F3 , 0x8233D937},
{ 0x46F4 , 0x8233D938},
{ 0x46F5 , 0x8233D939},
{ 0x46F6 , 0x8233DA30},
{ 0x46F7 , 0x8233DA31},
{ 0x46F8 , 0x8233DA32},
{ 0x46F9 , 0x8233DA33},
{ 0x46FA , 0x8233DA34},
{ 0x46FB , 0x8233DA35},
{ 0x46FC , 0x8233DA36},
{ 0x46FD , 0x8233DA37},
{ 0x46FE , 0x8233DA38},
{ 0x46FF , 0x8233DA39},
{ 0x4700 , 0x8233DB30},
{ 0x4701 , 0x8233DB31},
{ 0x4702 , 0x8233DB32},
{ 0x4703 , 0x8233DB33},
{ 0x4704 , 0x8233DB34},
{ 0x4705 , 0x8233DB35},
{ 0x4706 , 0x8233DB36},
{ 0x4707 , 0x8233DB37},
{ 0x4708 , 0x8233DB38},
{ 0x4709 , 0x8233DB39},
{ 0x470A , 0x8233DC30},
{ 0x470B , 0x8233DC31},
{ 0x470C , 0x8233DC32},
{ 0x470D , 0x8233DC33},
{ 0x470E , 0x8233DC34},
{ 0x470F , 0x8233DC35},
{ 0x4710 , 0x8233DC36},
{ 0x4711 , 0x8233DC37},
{ 0x4712 , 0x8233DC38},
{ 0x4713 , 0x8233DC39},
{ 0x4714 , 0x8233DD30},
{ 0x4715 , 0x8233DD31},
{ 0x4716 , 0x8233DD32},
{ 0x4717 , 0x8233DD33},
{ 0x4718 , 0x8233DD34},
{ 0x4719 , 0x8233DD35},
{ 0x471A , 0x8233DD36},
{ 0x471B , 0x8233DD37},
{ 0x471C , 0x8233DD38},
{ 0x471D , 0x8233DD39},
{ 0x471E , 0x8233DE30},
{ 0x471F , 0x8233DE31},
{ 0x4720 , 0x8233DE32},
{ 0x4721 , 0x8233DE33},
{ 0x4722 , 0x8233DE34},
{ 0x4724 , 0x8233DE35},
{ 0x4725 , 0x8233DE36},
{ 0x4726 , 0x8233DE37},
{ 0x4727 , 0x8233DE38},
{ 0x4728 , 0x8233DE39},
{ 0x472A , 0x8233DF30},
{ 0x472B , 0x8233DF31},
{ 0x472C , 0x8233DF32},
{ 0x472D , 0x8233DF33},
{ 0x472E , 0x8233DF34},
{ 0x472F , 0x8233DF35},
{ 0x4730 , 0x8233DF36},
{ 0x4731 , 0x8233DF37},
{ 0x4732 , 0x8233DF38},
{ 0x4733 , 0x8233DF39},
{ 0x4734 , 0x8233E030},
{ 0x4735 , 0x8233E031},
{ 0x4736 , 0x8233E032},
{ 0x4737 , 0x8233E033},
{ 0x4738 , 0x8233E034},
{ 0x4739 , 0x8233E035},
{ 0x473A , 0x8233E036},
{ 0x473B , 0x8233E037},
{ 0x473C , 0x8233E038},
{ 0x473D , 0x8233E039},
{ 0x473E , 0x8233E130},
{ 0x473F , 0x8233E131},
{ 0x4740 , 0x8233E132},
{ 0x4741 , 0x8233E133},
{ 0x4742 , 0x8233E134},
{ 0x4743 , 0x8233E135},
{ 0x4744 , 0x8233E136},
{ 0x4745 , 0x8233E137},
{ 0x4746 , 0x8233E138},
{ 0x4747 , 0x8233E139},
{ 0x4748 , 0x8233E230},
{ 0x4749 , 0x8233E231},
{ 0x474A , 0x8233E232},
{ 0x474B , 0x8233E233},
{ 0x474C , 0x8233E234},
{ 0x474D , 0x8233E235},
{ 0x474E , 0x8233E236},
{ 0x474F , 0x8233E237},
{ 0x4750 , 0x8233E238},
{ 0x4751 , 0x8233E239},
{ 0x4752 , 0x8233E330},
{ 0x4753 , 0x8233E331},
{ 0x4754 , 0x8233E332},
{ 0x4755 , 0x8233E333},
{ 0x4756 , 0x8233E334},
{ 0x4757 , 0x8233E335},
{ 0x4758 , 0x8233E336},
{ 0x4759 , 0x8233E337},
{ 0x475A , 0x8233E338},
{ 0x475B , 0x8233E339},
{ 0x475C , 0x8233E430},
{ 0x475D , 0x8233E431},
{ 0x475E , 0x8233E432},
{ 0x475F , 0x8233E433},
{ 0x4760 , 0x8233E434},
{ 0x4761 , 0x8233E435},
{ 0x4762 , 0x8233E436},
{ 0x4763 , 0x8233E437},
{ 0x4764 , 0x8233E438},
{ 0x4765 , 0x8233E439},
{ 0x4766 , 0x8233E530},
{ 0x4767 , 0x8233E531},
{ 0x4768 , 0x8233E532},
{ 0x4769 , 0x8233E533},
{ 0x476A , 0x8233E534},
{ 0x476B , 0x8233E535},
{ 0x476C , 0x8233E536},
{ 0x476D , 0x8233E537},
{ 0x476E , 0x8233E538},
{ 0x476F , 0x8233E539},
{ 0x4770 , 0x8233E630},
{ 0x4771 , 0x8233E631},
{ 0x4772 , 0x8233E632},
{ 0x4773 , 0x8233E633},
{ 0x4774 , 0x8233E634},
{ 0x4775 , 0x8233E635},
{ 0x4776 , 0x8233E636},
{ 0x4777 , 0x8233E637},
{ 0x4778 , 0x8233E638},
{ 0x4779 , 0x8233E639},
{ 0x477A , 0x8233E730},
{ 0x477B , 0x8233E731},
{ 0x477D , 0x8233E732},
{ 0x477E , 0x8233E733},
{ 0x477F , 0x8233E734},
{ 0x4780 , 0x8233E735},
{ 0x4781 , 0x8233E736},
{ 0x4782 , 0x8233E737},
{ 0x4783 , 0x8233E738},
{ 0x4784 , 0x8233E739},
{ 0x4785 , 0x8233E830},
{ 0x4786 , 0x8233E831},
{ 0x4787 , 0x8233E832},
{ 0x4788 , 0x8233E833},
{ 0x4789 , 0x8233E834},
{ 0x478A , 0x8233E835},
{ 0x478B , 0x8233E836},
{ 0x478C , 0x8233E837},
{ 0x478E , 0x8233E838},
{ 0x478F , 0x8233E839},
{ 0x4790 , 0x8233E930},
{ 0x4791 , 0x8233E931},
{ 0x4792 , 0x8233E932},
{ 0x4793 , 0x8233E933},
{ 0x4794 , 0x8233E934},
{ 0x4795 , 0x8233E935},
{ 0x4796 , 0x8233E936},
{ 0x4797 , 0x8233E937},
{ 0x4798 , 0x8233E938},
{ 0x4799 , 0x8233E939},
{ 0x479A , 0x8233EA30},
{ 0x479B , 0x8233EA31},
{ 0x479C , 0x8233EA32},
{ 0x479D , 0x8233EA33},
{ 0x479E , 0x8233EA34},
{ 0x479F , 0x8233EA35},
{ 0x47A0 , 0x8233EA36},
{ 0x47A1 , 0x8233EA37},
{ 0x47A2 , 0x8233EA38},
{ 0x47A3 , 0x8233EA39},
{ 0x47A4 , 0x8233EB30},
{ 0x47A5 , 0x8233EB31},
{ 0x47A6 , 0x8233EB32},
{ 0x47A7 , 0x8233EB33},
{ 0x47A8 , 0x8233EB34},
{ 0x47A9 , 0x8233EB35},
{ 0x47AA , 0x8233EB36},
{ 0x47AB , 0x8233EB37},
{ 0x47AC , 0x8233EB38},
{ 0x47AD , 0x8233EB39},
{ 0x47AE , 0x8233EC30},
{ 0x47AF , 0x8233EC31},
{ 0x47B0 , 0x8233EC32},
{ 0x47B1 , 0x8233EC33},
{ 0x47B2 , 0x8233EC34},
{ 0x47B3 , 0x8233EC35},
{ 0x47B4 , 0x8233EC36},
{ 0x47B5 , 0x8233EC37},
{ 0x47B6 , 0x8233EC38},
{ 0x47B7 , 0x8233EC39},
{ 0x47B8 , 0x8233ED30},
{ 0x47B9 , 0x8233ED31},
{ 0x47BA , 0x8233ED32},
{ 0x47BB , 0x8233ED33},
{ 0x47BC , 0x8233ED34},
{ 0x47BD , 0x8233ED35},
{ 0x47BE , 0x8233ED36},
{ 0x47BF , 0x8233ED37},
{ 0x47C0 , 0x8233ED38},
{ 0x47C1 , 0x8233ED39},
{ 0x47C2 , 0x8233EE30},
{ 0x47C3 , 0x8233EE31},
{ 0x47C4 , 0x8233EE32},
{ 0x47C5 , 0x8233EE33},
{ 0x47C6 , 0x8233EE34},
{ 0x47C7 , 0x8233EE35},
{ 0x47C8 , 0x8233EE36},
{ 0x47C9 , 0x8233EE37},
{ 0x47CA , 0x8233EE38},
{ 0x47CB , 0x8233EE39},
{ 0x47CC , 0x8233EF30},
{ 0x47CD , 0x8233EF31},
{ 0x47CE , 0x8233EF32},
{ 0x47CF , 0x8233EF33},
{ 0x47D0 , 0x8233EF34},
{ 0x47D1 , 0x8233EF35},
{ 0x47D2 , 0x8233EF36},
{ 0x47D3 , 0x8233EF37},
{ 0x47D4 , 0x8233EF38},
{ 0x47D5 , 0x8233EF39},
{ 0x47D6 , 0x8233F030},
{ 0x47D7 , 0x8233F031},
{ 0x47D8 , 0x8233F032},
{ 0x47D9 , 0x8233F033},
{ 0x47DA , 0x8233F034},
{ 0x47DB , 0x8233F035},
{ 0x47DC , 0x8233F036},
{ 0x47DD , 0x8233F037},
{ 0x47DE , 0x8233F038},
{ 0x47DF , 0x8233F039},
{ 0x47E0 , 0x8233F130},
{ 0x47E1 , 0x8233F131},
{ 0x47E2 , 0x8233F132},
{ 0x47E3 , 0x8233F133},
{ 0x47E4 , 0x8233F134},
{ 0x47E5 , 0x8233F135},
{ 0x47E6 , 0x8233F136},
{ 0x47E7 , 0x8233F137},
{ 0x47E8 , 0x8233F138},
{ 0x47E9 , 0x8233F139},
{ 0x47EA , 0x8233F230},
{ 0x47EB , 0x8233F231},
{ 0x47EC , 0x8233F232},
{ 0x47ED , 0x8233F233},
{ 0x47EE , 0x8233F234},
{ 0x47EF , 0x8233F235},
{ 0x47F0 , 0x8233F236},
{ 0x47F1 , 0x8233F237},
{ 0x47F2 , 0x8233F238},
{ 0x47F3 , 0x8233F239},
{ 0x47F4 , 0x8233F330},
{ 0x47F5 , 0x8233F331},
{ 0x47F6 , 0x8233F332},
{ 0x47F7 , 0x8233F333},
{ 0x47F8 , 0x8233F334},
{ 0x47F9 , 0x8233F335},
{ 0x47FA , 0x8233F336},
{ 0x47FB , 0x8233F337},
{ 0x47FC , 0x8233F338},
{ 0x47FD , 0x8233F339},
{ 0x47FE , 0x8233F430},
{ 0x47FF , 0x8233F431},
{ 0x4800 , 0x8233F432},
{ 0x4801 , 0x8233F433},
{ 0x4802 , 0x8233F434},
{ 0x4803 , 0x8233F435},
{ 0x4804 , 0x8233F436},
{ 0x4805 , 0x8233F437},
{ 0x4806 , 0x8233F438},
{ 0x4807 , 0x8233F439},
{ 0x4808 , 0x8233F530},
{ 0x4809 , 0x8233F531},
{ 0x480A , 0x8233F532},
{ 0x480B , 0x8233F533},
{ 0x480C , 0x8233F534},
{ 0x480D , 0x8233F535},
{ 0x480E , 0x8233F536},
{ 0x480F , 0x8233F537},
{ 0x4810 , 0x8233F538},
{ 0x4811 , 0x8233F539},
{ 0x4812 , 0x8233F630},
{ 0x4813 , 0x8233F631},
{ 0x4814 , 0x8233F632},
{ 0x4815 , 0x8233F633},
{ 0x4816 , 0x8233F634},
{ 0x4817 , 0x8233F635},
{ 0x4818 , 0x8233F636},
{ 0x4819 , 0x8233F637},
{ 0x481A , 0x8233F638},
{ 0x481B , 0x8233F639},
{ 0x481C , 0x8233F730},
{ 0x481D , 0x8233F731},
{ 0x481E , 0x8233F732},
{ 0x481F , 0x8233F733},
{ 0x4820 , 0x8233F734},
{ 0x4821 , 0x8233F735},
{ 0x4822 , 0x8233F736},
{ 0x4823 , 0x8233F737},
{ 0x4824 , 0x8233F738},
{ 0x4825 , 0x8233F739},
{ 0x4826 , 0x8233F830},
{ 0x4827 , 0x8233F831},
{ 0x4828 , 0x8233F832},
{ 0x4829 , 0x8233F833},
{ 0x482A , 0x8233F834},
{ 0x482B , 0x8233F835},
{ 0x482C , 0x8233F836},
{ 0x482D , 0x8233F837},
{ 0x482E , 0x8233F838},
{ 0x482F , 0x8233F839},
{ 0x4830 , 0x8233F930},
{ 0x4831 , 0x8233F931},
{ 0x4832 , 0x8233F932},
{ 0x4833 , 0x8233F933},
{ 0x4834 , 0x8233F934},
{ 0x4835 , 0x8233F935},
{ 0x4836 , 0x8233F936},
{ 0x4837 , 0x8233F937},
{ 0x4838 , 0x8233F938},
{ 0x4839 , 0x8233F939},
{ 0x483A , 0x8233FA30},
{ 0x483B , 0x8233FA31},
{ 0x483C , 0x8233FA32},
{ 0x483D , 0x8233FA33},
{ 0x483E , 0x8233FA34},
{ 0x483F , 0x8233FA35},
{ 0x4840 , 0x8233FA36},
{ 0x4841 , 0x8233FA37},
{ 0x4842 , 0x8233FA38},
{ 0x4843 , 0x8233FA39},
{ 0x4844 , 0x8233FB30},
{ 0x4845 , 0x8233FB31},
{ 0x4846 , 0x8233FB32},
{ 0x4847 , 0x8233FB33},
{ 0x4848 , 0x8233FB34},
{ 0x4849 , 0x8233FB35},
{ 0x484A , 0x8233FB36},
{ 0x484B , 0x8233FB37},
{ 0x484C , 0x8233FB38},
{ 0x484D , 0x8233FB39},
{ 0x484E , 0x8233FC30},
{ 0x484F , 0x8233FC31},
{ 0x4850 , 0x8233FC32},
{ 0x4851 , 0x8233FC33},
{ 0x4852 , 0x8233FC34},
{ 0x4853 , 0x8233FC35},
{ 0x4854 , 0x8233FC36},
{ 0x4855 , 0x8233FC37},
{ 0x4856 , 0x8233FC38},
{ 0x4857 , 0x8233FC39},
{ 0x4858 , 0x8233FD30},
{ 0x4859 , 0x8233FD31},
{ 0x485A , 0x8233FD32},
{ 0x485B , 0x8233FD33},
{ 0x485C , 0x8233FD34},
{ 0x485D , 0x8233FD35},
{ 0x485E , 0x8233FD36},
{ 0x485F , 0x8233FD37},
{ 0x4860 , 0x8233FD38},
{ 0x4861 , 0x8233FD39},
{ 0x4862 , 0x8233FE30},
{ 0x4863 , 0x8233FE31},
{ 0x4864 , 0x8233FE32},
{ 0x4865 , 0x8233FE33},
{ 0x4866 , 0x8233FE34},
{ 0x4867 , 0x8233FE35},
{ 0x4868 , 0x8233FE36},
{ 0x4869 , 0x8233FE37},
{ 0x486A , 0x8233FE38},
{ 0x486B , 0x8233FE39},
{ 0x486C , 0x82348130},
{ 0x486D , 0x82348131},
{ 0x486E , 0x82348132},
{ 0x486F , 0x82348133},
{ 0x4870 , 0x82348134},
{ 0x4871 , 0x82348135},
{ 0x4872 , 0x82348136},
{ 0x4873 , 0x82348137},
{ 0x4874 , 0x82348138},
{ 0x4875 , 0x82348139},
{ 0x4876 , 0x82348230},
{ 0x4877 , 0x82348231},
{ 0x4878 , 0x82348232},
{ 0x4879 , 0x82348233},
{ 0x487A , 0x82348234},
{ 0x487B , 0x82348235},
{ 0x487C , 0x82348236},
{ 0x487D , 0x82348237},
{ 0x487E , 0x82348238},
{ 0x487F , 0x82348239},
{ 0x4880 , 0x82348330},
{ 0x4881 , 0x82348331},
{ 0x4882 , 0x82348332},
{ 0x4883 , 0x82348333},
{ 0x4884 , 0x82348334},
{ 0x4885 , 0x82348335},
{ 0x4886 , 0x82348336},
{ 0x4887 , 0x82348337},
{ 0x4888 , 0x82348338},
{ 0x4889 , 0x82348339},
{ 0x488A , 0x82348430},
{ 0x488B , 0x82348431},
{ 0x488C , 0x82348432},
{ 0x488D , 0x82348433},
{ 0x488E , 0x82348434},
{ 0x488F , 0x82348435},
{ 0x4890 , 0x82348436},
{ 0x4891 , 0x82348437},
{ 0x4892 , 0x82348438},
{ 0x4893 , 0x82348439},
{ 0x4894 , 0x82348530},
{ 0x4895 , 0x82348531},
{ 0x4896 , 0x82348532},
{ 0x4897 , 0x82348533},
{ 0x4898 , 0x82348534},
{ 0x4899 , 0x82348535},
{ 0x489A , 0x82348536},
{ 0x489B , 0x82348537},
{ 0x489C , 0x82348538},
{ 0x489D , 0x82348539},
{ 0x489E , 0x82348630},
{ 0x489F , 0x82348631},
{ 0x48A0 , 0x82348632},
{ 0x48A1 , 0x82348633},
{ 0x48A2 , 0x82348634},
{ 0x48A3 , 0x82348635},
{ 0x48A4 , 0x82348636},
{ 0x48A5 , 0x82348637},
{ 0x48A6 , 0x82348638},
{ 0x48A7 , 0x82348639},
{ 0x48A8 , 0x82348730},
{ 0x48A9 , 0x82348731},
{ 0x48AA , 0x82348732},
{ 0x48AB , 0x82348733},
{ 0x48AC , 0x82348734},
{ 0x48AD , 0x82348735},
{ 0x48AE , 0x82348736},
{ 0x48AF , 0x82348737},
{ 0x48B0 , 0x82348738},
{ 0x48B1 , 0x82348739},
{ 0x48B2 , 0x82348830},
{ 0x48B3 , 0x82348831},
{ 0x48B4 , 0x82348832},
{ 0x48B5 , 0x82348833},
{ 0x48B6 , 0x82348834},
{ 0x48B7 , 0x82348835},
{ 0x48B8 , 0x82348836},
{ 0x48B9 , 0x82348837},
{ 0x48BA , 0x82348838},
{ 0x48BB , 0x82348839},
{ 0x48BC , 0x82348930},
{ 0x48BD , 0x82348931},
{ 0x48BE , 0x82348932},
{ 0x48BF , 0x82348933},
{ 0x48C0 , 0x82348934},
{ 0x48C1 , 0x82348935},
{ 0x48C2 , 0x82348936},
{ 0x48C3 , 0x82348937},
{ 0x48C4 , 0x82348938},
{ 0x48C5 , 0x82348939},
{ 0x48C6 , 0x82348A30},
{ 0x48C7 , 0x82348A31},
{ 0x48C8 , 0x82348A32},
{ 0x48C9 , 0x82348A33},
{ 0x48CA , 0x82348A34},
{ 0x48CB , 0x82348A35},
{ 0x48CC , 0x82348A36},
{ 0x48CD , 0x82348A37},
{ 0x48CE , 0x82348A38},
{ 0x48CF , 0x82348A39},
{ 0x48D0 , 0x82348B30},
{ 0x48D1 , 0x82348B31},
{ 0x48D2 , 0x82348B32},
{ 0x48D3 , 0x82348B33},
{ 0x48D4 , 0x82348B34},
{ 0x48D5 , 0x82348B35},
{ 0x48D6 , 0x82348B36},
{ 0x48D7 , 0x82348B37},
{ 0x48D8 , 0x82348B38},
{ 0x48D9 , 0x82348B39},
{ 0x48DA , 0x82348C30},
{ 0x48DB , 0x82348C31},
{ 0x48DC , 0x82348C32},
{ 0x48DD , 0x82348C33},
{ 0x48DE , 0x82348C34},
{ 0x48DF , 0x82348C35},
{ 0x48E0 , 0x82348C36},
{ 0x48E1 , 0x82348C37},
{ 0x48E2 , 0x82348C38},
{ 0x48E3 , 0x82348C39},
{ 0x48E4 , 0x82348D30},
{ 0x48E5 , 0x82348D31},
{ 0x48E6 , 0x82348D32},
{ 0x48E7 , 0x82348D33},
{ 0x48E8 , 0x82348D34},
{ 0x48E9 , 0x82348D35},
{ 0x48EA , 0x82348D36},
{ 0x48EB , 0x82348D37},
{ 0x48EC , 0x82348D38},
{ 0x48ED , 0x82348D39},
{ 0x48EE , 0x82348E30},
{ 0x48EF , 0x82348E31},
{ 0x48F0 , 0x82348E32},
{ 0x48F1 , 0x82348E33},
{ 0x48F2 , 0x82348E34},
{ 0x48F3 , 0x82348E35},
{ 0x48F4 , 0x82348E36},
{ 0x48F5 , 0x82348E37},
{ 0x48F6 , 0x82348E38},
{ 0x48F7 , 0x82348E39},
{ 0x48F8 , 0x82348F30},
{ 0x48F9 , 0x82348F31},
{ 0x48FA , 0x82348F32},
{ 0x48FB , 0x82348F33},
{ 0x48FC , 0x82348F34},
{ 0x48FD , 0x82348F35},
{ 0x48FE , 0x82348F36},
{ 0x48FF , 0x82348F37},
{ 0x4900 , 0x82348F38},
{ 0x4901 , 0x82348F39},
{ 0x4902 , 0x82349030},
{ 0x4903 , 0x82349031},
{ 0x4904 , 0x82349032},
{ 0x4905 , 0x82349033},
{ 0x4906 , 0x82349034},
{ 0x4907 , 0x82349035},
{ 0x4908 , 0x82349036},
{ 0x4909 , 0x82349037},
{ 0x490A , 0x82349038},
{ 0x490B , 0x82349039},
{ 0x490C , 0x82349130},
{ 0x490D , 0x82349131},
{ 0x490E , 0x82349132},
{ 0x490F , 0x82349133},
{ 0x4910 , 0x82349134},
{ 0x4911 , 0x82349135},
{ 0x4912 , 0x82349136},
{ 0x4913 , 0x82349137},
{ 0x4914 , 0x82349138},
{ 0x4915 , 0x82349139},
{ 0x4916 , 0x82349230},
{ 0x4917 , 0x82349231},
{ 0x4918 , 0x82349232},
{ 0x4919 , 0x82349233},
{ 0x491A , 0x82349234},
{ 0x491B , 0x82349235},
{ 0x491C , 0x82349236},
{ 0x491D , 0x82349237},
{ 0x491E , 0x82349238},
{ 0x491F , 0x82349239},
{ 0x4920 , 0x82349330},
{ 0x4921 , 0x82349331},
{ 0x4922 , 0x82349332},
{ 0x4923 , 0x82349333},
{ 0x4924 , 0x82349334},
{ 0x4925 , 0x82349335},
{ 0x4926 , 0x82349336},
{ 0x4927 , 0x82349337},
{ 0x4928 , 0x82349338},
{ 0x4929 , 0x82349339},
{ 0x492A , 0x82349430},
{ 0x492B , 0x82349431},
{ 0x492C , 0x82349432},
{ 0x492D , 0x82349433},
{ 0x492E , 0x82349434},
{ 0x492F , 0x82349435},
{ 0x4930 , 0x82349436},
{ 0x4931 , 0x82349437},
{ 0x4932 , 0x82349438},
{ 0x4933 , 0x82349439},
{ 0x4934 , 0x82349530},
{ 0x4935 , 0x82349531},
{ 0x4936 , 0x82349532},
{ 0x4937 , 0x82349533},
{ 0x4938 , 0x82349534},
{ 0x4939 , 0x82349535},
{ 0x493A , 0x82349536},
{ 0x493B , 0x82349537},
{ 0x493C , 0x82349538},
{ 0x493D , 0x82349539},
{ 0x493E , 0x82349630},
{ 0x493F , 0x82349631},
{ 0x4940 , 0x82349632},
{ 0x4941 , 0x82349633},
{ 0x4942 , 0x82349634},
{ 0x4943 , 0x82349635},
{ 0x4944 , 0x82349636},
{ 0x4945 , 0x82349637},
{ 0x4946 , 0x82349638},
{ 0x4948 , 0x82349639},
{ 0x4949 , 0x82349730},
{ 0x494A , 0x82349731},
{ 0x494B , 0x82349732},
{ 0x494C , 0x82349733},
{ 0x494D , 0x82349734},
{ 0x494E , 0x82349735},
{ 0x494F , 0x82349736},
{ 0x4950 , 0x82349737},
{ 0x4951 , 0x82349738},
{ 0x4952 , 0x82349739},
{ 0x4953 , 0x82349830},
{ 0x4954 , 0x82349831},
{ 0x4955 , 0x82349832},
{ 0x4956 , 0x82349833},
{ 0x4957 , 0x82349834},
{ 0x4958 , 0x82349835},
{ 0x4959 , 0x82349836},
{ 0x495A , 0x82349837},
{ 0x495B , 0x82349838},
{ 0x495C , 0x82349839},
{ 0x495D , 0x82349930},
{ 0x495E , 0x82349931},
{ 0x495F , 0x82349932},
{ 0x4960 , 0x82349933},
{ 0x4961 , 0x82349934},
{ 0x4962 , 0x82349935},
{ 0x4963 , 0x82349936},
{ 0x4964 , 0x82349937},
{ 0x4965 , 0x82349938},
{ 0x4966 , 0x82349939},
{ 0x4967 , 0x82349A30},
{ 0x4968 , 0x82349A31},
{ 0x4969 , 0x82349A32},
{ 0x496A , 0x82349A33},
{ 0x496B , 0x82349A34},
{ 0x496C , 0x82349A35},
{ 0x496D , 0x82349A36},
{ 0x496E , 0x82349A37},
{ 0x496F , 0x82349A38},
{ 0x4970 , 0x82349A39},
{ 0x4971 , 0x82349B30},
{ 0x4972 , 0x82349B31},
{ 0x4973 , 0x82349B32},
{ 0x4974 , 0x82349B33},
{ 0x4975 , 0x82349B34},
{ 0x4976 , 0x82349B35},
{ 0x4977 , 0x82349B36},
{ 0x4978 , 0x82349B37},
{ 0x4979 , 0x82349B38},
{ 0x497B , 0x82349B39},
{ 0x497C , 0x82349C30},
{ 0x497E , 0x82349C31},
{ 0x497F , 0x82349C32},
{ 0x4980 , 0x82349C33},
{ 0x4981 , 0x82349C34},
{ 0x4984 , 0x82349C35},
{ 0x4987 , 0x82349C36},
{ 0x4988 , 0x82349C37},
{ 0x4989 , 0x82349C38},
{ 0x498A , 0x82349C39},
{ 0x498B , 0x82349D30},
{ 0x498C , 0x82349D31},
{ 0x498D , 0x82349D32},
{ 0x498E , 0x82349D33},
{ 0x498F , 0x82349D34},
{ 0x4990 , 0x82349D35},
{ 0x4991 , 0x82349D36},
{ 0x4992 , 0x82349D37},
{ 0x4993 , 0x82349D38},
{ 0x4994 , 0x82349D39},
{ 0x4995 , 0x82349E30},
{ 0x4996 , 0x82349E31},
{ 0x4997 , 0x82349E32},
{ 0x4998 , 0x82349E33},
{ 0x4999 , 0x82349E34},
{ 0x499A , 0x82349E35},
{ 0x499C , 0x82349E36},
{ 0x499D , 0x82349E37},
{ 0x499E , 0x82349E38},
{ 0x49A0 , 0x82349E39},
{ 0x49A1 , 0x82349F30},
{ 0x49A2 , 0x82349F31},
{ 0x49A3 , 0x82349F32},
{ 0x49A4 , 0x82349F33},
{ 0x49A5 , 0x82349F34},
{ 0x49A6 , 0x82349F35},
{ 0x49A7 , 0x82349F36},
{ 0x49A8 , 0x82349F37},
{ 0x49A9 , 0x82349F38},
{ 0x49AA , 0x82349F39},
{ 0x49AB , 0x8234A030},
{ 0x49AC , 0x8234A031},
{ 0x49AD , 0x8234A032},
{ 0x49AE , 0x8234A033},
{ 0x49AF , 0x8234A034},
{ 0x49B0 , 0x8234A035},
{ 0x49B1 , 0x8234A036},
{ 0x49B2 , 0x8234A037},
{ 0x49B3 , 0x8234A038},
{ 0x49B4 , 0x8234A039},
{ 0x49B5 , 0x8234A130},
{ 0x49B8 , 0x8234A131},
{ 0x49B9 , 0x8234A132},
{ 0x49BA , 0x8234A133},
{ 0x49BB , 0x8234A134},
{ 0x49BC , 0x8234A135},
{ 0x49BD , 0x8234A136},
{ 0x49BE , 0x8234A137},
{ 0x49BF , 0x8234A138},
{ 0x49C0 , 0x8234A139},
{ 0x49C1 , 0x8234A230},
{ 0x49C2 , 0x8234A231},
{ 0x49C3 , 0x8234A232},
{ 0x49C4 , 0x8234A233},
{ 0x49C5 , 0x8234A234},
{ 0x49C6 , 0x8234A235},
{ 0x49C7 , 0x8234A236},
{ 0x49C8 , 0x8234A237},
{ 0x49C9 , 0x8234A238},
{ 0x49CA , 0x8234A239},
{ 0x49CB , 0x8234A330},
{ 0x49CC , 0x8234A331},
{ 0x49CD , 0x8234A332},
{ 0x49CE , 0x8234A333},
{ 0x49CF , 0x8234A334},
{ 0x49D0 , 0x8234A335},
{ 0x49D1 , 0x8234A336},
{ 0x49D2 , 0x8234A337},
{ 0x49D3 , 0x8234A338},
{ 0x49D4 , 0x8234A339},
{ 0x49D5 , 0x8234A430},
{ 0x49D6 , 0x8234A431},
{ 0x49D7 , 0x8234A432},
{ 0x49D8 , 0x8234A433},
{ 0x49D9 , 0x8234A434},
{ 0x49DA , 0x8234A435},
{ 0x49DB , 0x8234A436},
{ 0x49DC , 0x8234A437},
{ 0x49DD , 0x8234A438},
{ 0x49DE , 0x8234A439},
{ 0x49DF , 0x8234A530},
{ 0x49E0 , 0x8234A531},
{ 0x49E1 , 0x8234A532},
{ 0x49E2 , 0x8234A533},
{ 0x49E3 , 0x8234A534},
{ 0x49E4 , 0x8234A535},
{ 0x49E5 , 0x8234A536},
{ 0x49E6 , 0x8234A537},
{ 0x49E7 , 0x8234A538},
{ 0x49E8 , 0x8234A539},
{ 0x49E9 , 0x8234A630},
{ 0x49EA , 0x8234A631},
{ 0x49EB , 0x8234A632},
{ 0x49EC , 0x8234A633},
{ 0x49ED , 0x8234A634},
{ 0x49EE , 0x8234A635},
{ 0x49EF , 0x8234A636},
{ 0x49F0 , 0x8234A637},
{ 0x49F1 , 0x8234A638},
{ 0x49F2 , 0x8234A639},
{ 0x49F3 , 0x8234A730},
{ 0x49F4 , 0x8234A731},
{ 0x49F5 , 0x8234A732},
{ 0x49F6 , 0x8234A733},
{ 0x49F7 , 0x8234A734},
{ 0x49F8 , 0x8234A735},
{ 0x49F9 , 0x8234A736},
{ 0x49FA , 0x8234A737},
{ 0x49FB , 0x8234A738},
{ 0x49FC , 0x8234A739},
{ 0x49FD , 0x8234A830},
{ 0x49FE , 0x8234A831},
{ 0x49FF , 0x8234A832},
{ 0x4A00 , 0x8234A833},
{ 0x4A01 , 0x8234A834},
{ 0x4A02 , 0x8234A835},
{ 0x4A03 , 0x8234A836},
{ 0x4A04 , 0x8234A837},
{ 0x4A05 , 0x8234A838},
{ 0x4A06 , 0x8234A839},
{ 0x4A07 , 0x8234A930},
{ 0x4A08 , 0x8234A931},
{ 0x4A09 , 0x8234A932},
{ 0x4A0A , 0x8234A933},
{ 0x4A0B , 0x8234A934},
{ 0x4A0C , 0x8234A935},
{ 0x4A0D , 0x8234A936},
{ 0x4A0E , 0x8234A937},
{ 0x4A0F , 0x8234A938},
{ 0x4A10 , 0x8234A939},
{ 0x4A11 , 0x8234AA30},
{ 0x4A12 , 0x8234AA31},
{ 0x4A13 , 0x8234AA32},
{ 0x4A14 , 0x8234AA33},
{ 0x4A15 , 0x8234AA34},
{ 0x4A16 , 0x8234AA35},
{ 0x4A17 , 0x8234AA36},
{ 0x4A18 , 0x8234AA37},
{ 0x4A19 , 0x8234AA38},
{ 0x4A1A , 0x8234AA39},
{ 0x4A1B , 0x8234AB30},
{ 0x4A1C , 0x8234AB31},
{ 0x4A1D , 0x8234AB32},
{ 0x4A1E , 0x8234AB33},
{ 0x4A1F , 0x8234AB34},
{ 0x4A20 , 0x8234AB35},
{ 0x4A21 , 0x8234AB36},
{ 0x4A22 , 0x8234AB37},
{ 0x4A23 , 0x8234AB38},
{ 0x4A24 , 0x8234AB39},
{ 0x4A25 , 0x8234AC30},
{ 0x4A26 , 0x8234AC31},
{ 0x4A27 , 0x8234AC32},
{ 0x4A28 , 0x8234AC33},
{ 0x4A29 , 0x8234AC34},
{ 0x4A2A , 0x8234AC35},
{ 0x4A2B , 0x8234AC36},
{ 0x4A2C , 0x8234AC37},
{ 0x4A2D , 0x8234AC38},
{ 0x4A2E , 0x8234AC39},
{ 0x4A2F , 0x8234AD30},
{ 0x4A30 , 0x8234AD31},
{ 0x4A31 , 0x8234AD32},
{ 0x4A32 , 0x8234AD33},
{ 0x4A33 , 0x8234AD34},
{ 0x4A34 , 0x8234AD35},
{ 0x4A35 , 0x8234AD36},
{ 0x4A36 , 0x8234AD37},
{ 0x4A37 , 0x8234AD38},
{ 0x4A38 , 0x8234AD39},
{ 0x4A39 , 0x8234AE30},
{ 0x4A3A , 0x8234AE31},
{ 0x4A3B , 0x8234AE32},
{ 0x4A3C , 0x8234AE33},
{ 0x4A3D , 0x8234AE34},
{ 0x4A3E , 0x8234AE35},
{ 0x4A3F , 0x8234AE36},
{ 0x4A40 , 0x8234AE37},
{ 0x4A41 , 0x8234AE38},
{ 0x4A42 , 0x8234AE39},
{ 0x4A43 , 0x8234AF30},
{ 0x4A44 , 0x8234AF31},
{ 0x4A45 , 0x8234AF32},
{ 0x4A46 , 0x8234AF33},
{ 0x4A47 , 0x8234AF34},
{ 0x4A48 , 0x8234AF35},
{ 0x4A49 , 0x8234AF36},
{ 0x4A4A , 0x8234AF37},
{ 0x4A4B , 0x8234AF38},
{ 0x4A4C , 0x8234AF39},
{ 0x4A4D , 0x8234B030},
{ 0x4A4E , 0x8234B031},
{ 0x4A4F , 0x8234B032},
{ 0x4A50 , 0x8234B033},
{ 0x4A51 , 0x8234B034},
{ 0x4A52 , 0x8234B035},
{ 0x4A53 , 0x8234B036},
{ 0x4A54 , 0x8234B037},
{ 0x4A55 , 0x8234B038},
{ 0x4A56 , 0x8234B039},
{ 0x4A57 , 0x8234B130},
{ 0x4A58 , 0x8234B131},
{ 0x4A59 , 0x8234B132},
{ 0x4A5A , 0x8234B133},
{ 0x4A5B , 0x8234B134},
{ 0x4A5C , 0x8234B135},
{ 0x4A5D , 0x8234B136},
{ 0x4A5E , 0x8234B137},
{ 0x4A5F , 0x8234B138},
{ 0x4A60 , 0x8234B139},
{ 0x4A61 , 0x8234B230},
{ 0x4A62 , 0x8234B231},
{ 0x4A63 , 0x8234B232},
{ 0x4A64 , 0x8234B233},
{ 0x4A65 , 0x8234B234},
{ 0x4A66 , 0x8234B235},
{ 0x4A67 , 0x8234B236},
{ 0x4A68 , 0x8234B237},
{ 0x4A69 , 0x8234B238},
{ 0x4A6A , 0x8234B239},
{ 0x4A6B , 0x8234B330},
{ 0x4A6C , 0x8234B331},
{ 0x4A6D , 0x8234B332},
{ 0x4A6E , 0x8234B333},
{ 0x4A6F , 0x8234B334},
{ 0x4A70 , 0x8234B335},
{ 0x4A71 , 0x8234B336},
{ 0x4A72 , 0x8234B337},
{ 0x4A73 , 0x8234B338},
{ 0x4A74 , 0x8234B339},
{ 0x4A75 , 0x8234B430},
{ 0x4A76 , 0x8234B431},
{ 0x4A77 , 0x8234B432},
{ 0x4A78 , 0x8234B433},
{ 0x4A79 , 0x8234B434},
{ 0x4A7A , 0x8234B435},
{ 0x4A7B , 0x8234B436},
{ 0x4A7C , 0x8234B437},
{ 0x4A7D , 0x8234B438},
{ 0x4A7E , 0x8234B439},
{ 0x4A7F , 0x8234B530},
{ 0x4A80 , 0x8234B531},
{ 0x4A81 , 0x8234B532},
{ 0x4A82 , 0x8234B533},
{ 0x4A83 , 0x8234B534},
{ 0x4A84 , 0x8234B535},
{ 0x4A85 , 0x8234B536},
{ 0x4A86 , 0x8234B537},
{ 0x4A87 , 0x8234B538},
{ 0x4A88 , 0x8234B539},
{ 0x4A89 , 0x8234B630},
{ 0x4A8A , 0x8234B631},
{ 0x4A8B , 0x8234B632},
{ 0x4A8C , 0x8234B633},
{ 0x4A8D , 0x8234B634},
{ 0x4A8E , 0x8234B635},
{ 0x4A8F , 0x8234B636},
{ 0x4A90 , 0x8234B637},
{ 0x4A91 , 0x8234B638},
{ 0x4A92 , 0x8234B639},
{ 0x4A93 , 0x8234B730},
{ 0x4A94 , 0x8234B731},
{ 0x4A95 , 0x8234B732},
{ 0x4A96 , 0x8234B733},
{ 0x4A97 , 0x8234B734},
{ 0x4A98 , 0x8234B735},
{ 0x4A99 , 0x8234B736},
{ 0x4A9A , 0x8234B737},
{ 0x4A9B , 0x8234B738},
{ 0x4A9C , 0x8234B739},
{ 0x4A9D , 0x8234B830},
{ 0x4A9E , 0x8234B831},
{ 0x4A9F , 0x8234B832},
{ 0x4AA0 , 0x8234B833},
{ 0x4AA1 , 0x8234B834},
{ 0x4AA2 , 0x8234B835},
{ 0x4AA3 , 0x8234B836},
{ 0x4AA4 , 0x8234B837},
{ 0x4AA5 , 0x8234B838},
{ 0x4AA6 , 0x8234B839},
{ 0x4AA7 , 0x8234B930},
{ 0x4AA8 , 0x8234B931},
{ 0x4AA9 , 0x8234B932},
{ 0x4AAA , 0x8234B933},
{ 0x4AAB , 0x8234B934},
{ 0x4AAC , 0x8234B935},
{ 0x4AAD , 0x8234B936},
{ 0x4AAE , 0x8234B937},
{ 0x4AAF , 0x8234B938},
{ 0x4AB0 , 0x8234B939},
{ 0x4AB1 , 0x8234BA30},
{ 0x4AB2 , 0x8234BA31},
{ 0x4AB3 , 0x8234BA32},
{ 0x4AB4 , 0x8234BA33},
{ 0x4AB5 , 0x8234BA34},
{ 0x4AB6 , 0x8234BA35},
{ 0x4AB7 , 0x8234BA36},
{ 0x4AB8 , 0x8234BA37},
{ 0x4AB9 , 0x8234BA38},
{ 0x4ABA , 0x8234BA39},
{ 0x4ABB , 0x8234BB30},
{ 0x4ABC , 0x8234BB31},
{ 0x4ABD , 0x8234BB32},
{ 0x4ABE , 0x8234BB33},
{ 0x4ABF , 0x8234BB34},
{ 0x4AC0 , 0x8234BB35},
{ 0x4AC1 , 0x8234BB36},
{ 0x4AC2 , 0x8234BB37},
{ 0x4AC3 , 0x8234BB38},
{ 0x4AC4 , 0x8234BB39},
{ 0x4AC5 , 0x8234BC30},
{ 0x4AC6 , 0x8234BC31},
{ 0x4AC7 , 0x8234BC32},
{ 0x4AC8 , 0x8234BC33},
{ 0x4AC9 , 0x8234BC34},
{ 0x4ACA , 0x8234BC35},
{ 0x4ACB , 0x8234BC36},
{ 0x4ACC , 0x8234BC37},
{ 0x4ACD , 0x8234BC38},
{ 0x4ACE , 0x8234BC39},
{ 0x4ACF , 0x8234BD30},
{ 0x4AD0 , 0x8234BD31},
{ 0x4AD1 , 0x8234BD32},
{ 0x4AD2 , 0x8234BD33},
{ 0x4AD3 , 0x8234BD34},
{ 0x4AD4 , 0x8234BD35},
{ 0x4AD5 , 0x8234BD36},
{ 0x4AD6 , 0x8234BD37},
{ 0x4AD7 , 0x8234BD38},
{ 0x4AD8 , 0x8234BD39},
{ 0x4AD9 , 0x8234BE30},
{ 0x4ADA , 0x8234BE31},
{ 0x4ADB , 0x8234BE32},
{ 0x4ADC , 0x8234BE33},
{ 0x4ADD , 0x8234BE34},
{ 0x4ADE , 0x8234BE35},
{ 0x4ADF , 0x8234BE36},
{ 0x4AE0 , 0x8234BE37},
{ 0x4AE1 , 0x8234BE38},
{ 0x4AE2 , 0x8234BE39},
{ 0x4AE3 , 0x8234BF30},
{ 0x4AE4 , 0x8234BF31},
{ 0x4AE5 , 0x8234BF32},
{ 0x4AE6 , 0x8234BF33},
{ 0x4AE7 , 0x8234BF34},
{ 0x4AE8 , 0x8234BF35},
{ 0x4AE9 , 0x8234BF36},
{ 0x4AEA , 0x8234BF37},
{ 0x4AEB , 0x8234BF38},
{ 0x4AEC , 0x8234BF39},
{ 0x4AED , 0x8234C030},
{ 0x4AEE , 0x8234C031},
{ 0x4AEF , 0x8234C032},
{ 0x4AF0 , 0x8234C033},
{ 0x4AF1 , 0x8234C034},
{ 0x4AF2 , 0x8234C035},
{ 0x4AF3 , 0x8234C036},
{ 0x4AF4 , 0x8234C037},
{ 0x4AF5 , 0x8234C038},
{ 0x4AF6 , 0x8234C039},
{ 0x4AF7 , 0x8234C130},
{ 0x4AF8 , 0x8234C131},
{ 0x4AF9 , 0x8234C132},
{ 0x4AFA , 0x8234C133},
{ 0x4AFB , 0x8234C134},
{ 0x4AFC , 0x8234C135},
{ 0x4AFD , 0x8234C136},
{ 0x4AFE , 0x8234C137},
{ 0x4AFF , 0x8234C138},
{ 0x4B00 , 0x8234C139},
{ 0x4B01 , 0x8234C230},
{ 0x4B02 , 0x8234C231},
{ 0x4B03 , 0x8234C232},
{ 0x4B04 , 0x8234C233},
{ 0x4B05 , 0x8234C234},
{ 0x4B06 , 0x8234C235},
{ 0x4B07 , 0x8234C236},
{ 0x4B08 , 0x8234C237},
{ 0x4B09 , 0x8234C238},
{ 0x4B0A , 0x8234C239},
{ 0x4B0B , 0x8234C330},
{ 0x4B0C , 0x8234C331},
{ 0x4B0D , 0x8234C332},
{ 0x4B0E , 0x8234C333},
{ 0x4B0F , 0x8234C334},
{ 0x4B10 , 0x8234C335},
{ 0x4B11 , 0x8234C336},
{ 0x4B12 , 0x8234C337},
{ 0x4B13 , 0x8234C338},
{ 0x4B14 , 0x8234C339},
{ 0x4B15 , 0x8234C430},
{ 0x4B16 , 0x8234C431},
{ 0x4B17 , 0x8234C432},
{ 0x4B18 , 0x8234C433},
{ 0x4B19 , 0x8234C434},
{ 0x4B1A , 0x8234C435},
{ 0x4B1B , 0x8234C436},
{ 0x4B1C , 0x8234C437},
{ 0x4B1D , 0x8234C438},
{ 0x4B1E , 0x8234C439},
{ 0x4B1F , 0x8234C530},
{ 0x4B20 , 0x8234C531},
{ 0x4B21 , 0x8234C532},
{ 0x4B22 , 0x8234C533},
{ 0x4B23 , 0x8234C534},
{ 0x4B24 , 0x8234C535},
{ 0x4B25 , 0x8234C536},
{ 0x4B26 , 0x8234C537},
{ 0x4B27 , 0x8234C538},
{ 0x4B28 , 0x8234C539},
{ 0x4B29 , 0x8234C630},
{ 0x4B2A , 0x8234C631},
{ 0x4B2B , 0x8234C632},
{ 0x4B2C , 0x8234C633},
{ 0x4B2D , 0x8234C634},
{ 0x4B2E , 0x8234C635},
{ 0x4B2F , 0x8234C636},
{ 0x4B30 , 0x8234C637},
{ 0x4B31 , 0x8234C638},
{ 0x4B32 , 0x8234C639},
{ 0x4B33 , 0x8234C730},
{ 0x4B34 , 0x8234C731},
{ 0x4B35 , 0x8234C732},
{ 0x4B36 , 0x8234C733},
{ 0x4B37 , 0x8234C734},
{ 0x4B38 , 0x8234C735},
{ 0x4B39 , 0x8234C736},
{ 0x4B3A , 0x8234C737},
{ 0x4B3B , 0x8234C738},
{ 0x4B3C , 0x8234C739},
{ 0x4B3D , 0x8234C830},
{ 0x4B3E , 0x8234C831},
{ 0x4B3F , 0x8234C832},
{ 0x4B40 , 0x8234C833},
{ 0x4B41 , 0x8234C834},
{ 0x4B42 , 0x8234C835},
{ 0x4B43 , 0x8234C836},
{ 0x4B44 , 0x8234C837},
{ 0x4B45 , 0x8234C838},
{ 0x4B46 , 0x8234C839},
{ 0x4B47 , 0x8234C930},
{ 0x4B48 , 0x8234C931},
{ 0x4B49 , 0x8234C932},
{ 0x4B4A , 0x8234C933},
{ 0x4B4B , 0x8234C934},
{ 0x4B4C , 0x8234C935},
{ 0x4B4D , 0x8234C936},
{ 0x4B4E , 0x8234C937},
{ 0x4B4F , 0x8234C938},
{ 0x4B50 , 0x8234C939},
{ 0x4B51 , 0x8234CA30},
{ 0x4B52 , 0x8234CA31},
{ 0x4B53 , 0x8234CA32},
{ 0x4B54 , 0x8234CA33},
{ 0x4B55 , 0x8234CA34},
{ 0x4B56 , 0x8234CA35},
{ 0x4B57 , 0x8234CA36},
{ 0x4B58 , 0x8234CA37},
{ 0x4B59 , 0x8234CA38},
{ 0x4B5A , 0x8234CA39},
{ 0x4B5B , 0x8234CB30},
{ 0x4B5C , 0x8234CB31},
{ 0x4B5D , 0x8234CB32},
{ 0x4B5E , 0x8234CB33},
{ 0x4B5F , 0x8234CB34},
{ 0x4B60 , 0x8234CB35},
{ 0x4B61 , 0x8234CB36},
{ 0x4B62 , 0x8234CB37},
{ 0x4B63 , 0x8234CB38},
{ 0x4B64 , 0x8234CB39},
{ 0x4B65 , 0x8234CC30},
{ 0x4B66 , 0x8234CC31},
{ 0x4B67 , 0x8234CC32},
{ 0x4B68 , 0x8234CC33},
{ 0x4B69 , 0x8234CC34},
{ 0x4B6A , 0x8234CC35},
{ 0x4B6B , 0x8234CC36},
{ 0x4B6C , 0x8234CC37},
{ 0x4B6D , 0x8234CC38},
{ 0x4B6E , 0x8234CC39},
{ 0x4B6F , 0x8234CD30},
{ 0x4B70 , 0x8234CD31},
{ 0x4B71 , 0x8234CD32},
{ 0x4B72 , 0x8234CD33},
{ 0x4B73 , 0x8234CD34},
{ 0x4B74 , 0x8234CD35},
{ 0x4B75 , 0x8234CD36},
{ 0x4B76 , 0x8234CD37},
{ 0x4B77 , 0x8234CD38},
{ 0x4B78 , 0x8234CD39},
{ 0x4B79 , 0x8234CE30},
{ 0x4B7A , 0x8234CE31},
{ 0x4B7B , 0x8234CE32},
{ 0x4B7C , 0x8234CE33},
{ 0x4B7D , 0x8234CE34},
{ 0x4B7E , 0x8234CE35},
{ 0x4B7F , 0x8234CE36},
{ 0x4B80 , 0x8234CE37},
{ 0x4B81 , 0x8234CE38},
{ 0x4B82 , 0x8234CE39},
{ 0x4B83 , 0x8234CF30},
{ 0x4B84 , 0x8234CF31},
{ 0x4B85 , 0x8234CF32},
{ 0x4B86 , 0x8234CF33},
{ 0x4B87 , 0x8234CF34},
{ 0x4B88 , 0x8234CF35},
{ 0x4B89 , 0x8234CF36},
{ 0x4B8A , 0x8234CF37},
{ 0x4B8B , 0x8234CF38},
{ 0x4B8C , 0x8234CF39},
{ 0x4B8D , 0x8234D030},
{ 0x4B8E , 0x8234D031},
{ 0x4B8F , 0x8234D032},
{ 0x4B90 , 0x8234D033},
{ 0x4B91 , 0x8234D034},
{ 0x4B92 , 0x8234D035},
{ 0x4B93 , 0x8234D036},
{ 0x4B94 , 0x8234D037},
{ 0x4B95 , 0x8234D038},
{ 0x4B96 , 0x8234D039},
{ 0x4B97 , 0x8234D130},
{ 0x4B98 , 0x8234D131},
{ 0x4B99 , 0x8234D132},
{ 0x4B9A , 0x8234D133},
{ 0x4B9B , 0x8234D134},
{ 0x4B9C , 0x8234D135},
{ 0x4B9D , 0x8234D136},
{ 0x4B9E , 0x8234D137},
{ 0x4B9F , 0x8234D138},
{ 0x4BA0 , 0x8234D139},
{ 0x4BA1 , 0x8234D230},
{ 0x4BA2 , 0x8234D231},
{ 0x4BA3 , 0x8234D232},
{ 0x4BA4 , 0x8234D233},
{ 0x4BA5 , 0x8234D234},
{ 0x4BA6 , 0x8234D235},
{ 0x4BA7 , 0x8234D236},
{ 0x4BA8 , 0x8234D237},
{ 0x4BA9 , 0x8234D238},
{ 0x4BAA , 0x8234D239},
{ 0x4BAB , 0x8234D330},
{ 0x4BAC , 0x8234D331},
{ 0x4BAD , 0x8234D332},
{ 0x4BAE , 0x8234D333},
{ 0x4BAF , 0x8234D334},
{ 0x4BB0 , 0x8234D335},
{ 0x4BB1 , 0x8234D336},
{ 0x4BB2 , 0x8234D337},
{ 0x4BB3 , 0x8234D338},
{ 0x4BB4 , 0x8234D339},
{ 0x4BB5 , 0x8234D430},
{ 0x4BB6 , 0x8234D431},
{ 0x4BB7 , 0x8234D432},
{ 0x4BB8 , 0x8234D433},
{ 0x4BB9 , 0x8234D434},
{ 0x4BBA , 0x8234D435},
{ 0x4BBB , 0x8234D436},
{ 0x4BBC , 0x8234D437},
{ 0x4BBD , 0x8234D438},
{ 0x4BBE , 0x8234D439},
{ 0x4BBF , 0x8234D530},
{ 0x4BC0 , 0x8234D531},
{ 0x4BC1 , 0x8234D532},
{ 0x4BC2 , 0x8234D533},
{ 0x4BC3 , 0x8234D534},
{ 0x4BC4 , 0x8234D535},
{ 0x4BC5 , 0x8234D536},
{ 0x4BC6 , 0x8234D537},
{ 0x4BC7 , 0x8234D538},
{ 0x4BC8 , 0x8234D539},
{ 0x4BC9 , 0x8234D630},
{ 0x4BCA , 0x8234D631},
{ 0x4BCB , 0x8234D632},
{ 0x4BCC , 0x8234D633},
{ 0x4BCD , 0x8234D634},
{ 0x4BCE , 0x8234D635},
{ 0x4BCF , 0x8234D636},
{ 0x4BD0 , 0x8234D637},
{ 0x4BD1 , 0x8234D638},
{ 0x4BD2 , 0x8234D639},
{ 0x4BD3 , 0x8234D730},
{ 0x4BD4 , 0x8234D731},
{ 0x4BD5 , 0x8234D732},
{ 0x4BD6 , 0x8234D733},
{ 0x4BD7 , 0x8234D734},
{ 0x4BD8 , 0x8234D735},
{ 0x4BD9 , 0x8234D736},
{ 0x4BDA , 0x8234D737},
{ 0x4BDB , 0x8234D738},
{ 0x4BDC , 0x8234D739},
{ 0x4BDD , 0x8234D830},
{ 0x4BDE , 0x8234D831},
{ 0x4BDF , 0x8234D832},
{ 0x4BE0 , 0x8234D833},
{ 0x4BE1 , 0x8234D834},
{ 0x4BE2 , 0x8234D835},
{ 0x4BE3 , 0x8234D836},
{ 0x4BE4 , 0x8234D837},
{ 0x4BE5 , 0x8234D838},
{ 0x4BE6 , 0x8234D839},
{ 0x4BE7 , 0x8234D930},
{ 0x4BE8 , 0x8234D931},
{ 0x4BE9 , 0x8234D932},
{ 0x4BEA , 0x8234D933},
{ 0x4BEB , 0x8234D934},
{ 0x4BEC , 0x8234D935},
{ 0x4BED , 0x8234D936},
{ 0x4BEE , 0x8234D937},
{ 0x4BEF , 0x8234D938},
{ 0x4BF0 , 0x8234D939},
{ 0x4BF1 , 0x8234DA30},
{ 0x4BF2 , 0x8234DA31},
{ 0x4BF3 , 0x8234DA32},
{ 0x4BF4 , 0x8234DA33},
{ 0x4BF5 , 0x8234DA34},
{ 0x4BF6 , 0x8234DA35},
{ 0x4BF7 , 0x8234DA36},
{ 0x4BF8 , 0x8234DA37},
{ 0x4BF9 , 0x8234DA38},
{ 0x4BFA , 0x8234DA39},
{ 0x4BFB , 0x8234DB30},
{ 0x4BFC , 0x8234DB31},
{ 0x4BFD , 0x8234DB32},
{ 0x4BFE , 0x8234DB33},
{ 0x4BFF , 0x8234DB34},
{ 0x4C00 , 0x8234DB35},
{ 0x4C01 , 0x8234DB36},
{ 0x4C02 , 0x8234DB37},
{ 0x4C03 , 0x8234DB38},
{ 0x4C04 , 0x8234DB39},
{ 0x4C05 , 0x8234DC30},
{ 0x4C06 , 0x8234DC31},
{ 0x4C07 , 0x8234DC32},
{ 0x4C08 , 0x8234DC33},
{ 0x4C09 , 0x8234DC34},
{ 0x4C0A , 0x8234DC35},
{ 0x4C0B , 0x8234DC36},
{ 0x4C0C , 0x8234DC37},
{ 0x4C0D , 0x8234DC38},
{ 0x4C0E , 0x8234DC39},
{ 0x4C0F , 0x8234DD30},
{ 0x4C10 , 0x8234DD31},
{ 0x4C11 , 0x8234DD32},
{ 0x4C12 , 0x8234DD33},
{ 0x4C13 , 0x8234DD34},
{ 0x4C14 , 0x8234DD35},
{ 0x4C15 , 0x8234DD36},
{ 0x4C16 , 0x8234DD37},
{ 0x4C17 , 0x8234DD38},
{ 0x4C18 , 0x8234DD39},
{ 0x4C19 , 0x8234DE30},
{ 0x4C1A , 0x8234DE31},
{ 0x4C1B , 0x8234DE32},
{ 0x4C1C , 0x8234DE33},
{ 0x4C1D , 0x8234DE34},
{ 0x4C1E , 0x8234DE35},
{ 0x4C1F , 0x8234DE36},
{ 0x4C20 , 0x8234DE37},
{ 0x4C21 , 0x8234DE38},
{ 0x4C22 , 0x8234DE39},
{ 0x4C23 , 0x8234DF30},
{ 0x4C24 , 0x8234DF31},
{ 0x4C25 , 0x8234DF32},
{ 0x4C26 , 0x8234DF33},
{ 0x4C27 , 0x8234DF34},
{ 0x4C28 , 0x8234DF35},
{ 0x4C29 , 0x8234DF36},
{ 0x4C2A , 0x8234DF37},
{ 0x4C2B , 0x8234DF38},
{ 0x4C2C , 0x8234DF39},
{ 0x4C2D , 0x8234E030},
{ 0x4C2E , 0x8234E031},
{ 0x4C2F , 0x8234E032},
{ 0x4C30 , 0x8234E033},
{ 0x4C31 , 0x8234E034},
{ 0x4C32 , 0x8234E035},
{ 0x4C33 , 0x8234E036},
{ 0x4C34 , 0x8234E037},
{ 0x4C35 , 0x8234E038},
{ 0x4C36 , 0x8234E039},
{ 0x4C37 , 0x8234E130},
{ 0x4C38 , 0x8234E131},
{ 0x4C39 , 0x8234E132},
{ 0x4C3A , 0x8234E133},
{ 0x4C3B , 0x8234E134},
{ 0x4C3C , 0x8234E135},
{ 0x4C3D , 0x8234E136},
{ 0x4C3E , 0x8234E137},
{ 0x4C3F , 0x8234E138},
{ 0x4C40 , 0x8234E139},
{ 0x4C41 , 0x8234E230},
{ 0x4C42 , 0x8234E231},
{ 0x4C43 , 0x8234E232},
{ 0x4C44 , 0x8234E233},
{ 0x4C45 , 0x8234E234},
{ 0x4C46 , 0x8234E235},
{ 0x4C47 , 0x8234E236},
{ 0x4C48 , 0x8234E237},
{ 0x4C49 , 0x8234E238},
{ 0x4C4A , 0x8234E239},
{ 0x4C4B , 0x8234E330},
{ 0x4C4C , 0x8234E331},
{ 0x4C4D , 0x8234E332},
{ 0x4C4E , 0x8234E333},
{ 0x4C4F , 0x8234E334},
{ 0x4C50 , 0x8234E335},
{ 0x4C51 , 0x8234E336},
{ 0x4C52 , 0x8234E337},
{ 0x4C53 , 0x8234E338},
{ 0x4C54 , 0x8234E339},
{ 0x4C55 , 0x8234E430},
{ 0x4C56 , 0x8234E431},
{ 0x4C57 , 0x8234E432},
{ 0x4C58 , 0x8234E433},
{ 0x4C59 , 0x8234E434},
{ 0x4C5A , 0x8234E435},
{ 0x4C5B , 0x8234E436},
{ 0x4C5C , 0x8234E437},
{ 0x4C5D , 0x8234E438},
{ 0x4C5E , 0x8234E439},
{ 0x4C5F , 0x8234E530},
{ 0x4C60 , 0x8234E531},
{ 0x4C61 , 0x8234E532},
{ 0x4C62 , 0x8234E533},
{ 0x4C63 , 0x8234E534},
{ 0x4C64 , 0x8234E535},
{ 0x4C65 , 0x8234E536},
{ 0x4C66 , 0x8234E537},
{ 0x4C67 , 0x8234E538},
{ 0x4C68 , 0x8234E539},
{ 0x4C69 , 0x8234E630},
{ 0x4C6A , 0x8234E631},
{ 0x4C6B , 0x8234E632},
{ 0x4C6C , 0x8234E633},
{ 0x4C6D , 0x8234E634},
{ 0x4C6E , 0x8234E635},
{ 0x4C6F , 0x8234E636},
{ 0x4C70 , 0x8234E637},
{ 0x4C71 , 0x8234E638},
{ 0x4C72 , 0x8234E639},
{ 0x4C73 , 0x8234E730},
{ 0x4C74 , 0x8234E731},
{ 0x4C75 , 0x8234E732},
{ 0x4C76 , 0x8234E733},
{ 0x4C78 , 0x8234E734},
{ 0x4C79 , 0x8234E735},
{ 0x4C7A , 0x8234E736},
{ 0x4C7B , 0x8234E737},
{ 0x4C7C , 0x8234E738},
{ 0x4C7D , 0x8234E739},
{ 0x4C7E , 0x8234E830},
{ 0x4C7F , 0x8234E831},
{ 0x4C80 , 0x8234E832},
{ 0x4C81 , 0x8234E833},
{ 0x4C82 , 0x8234E834},
{ 0x4C83 , 0x8234E835},
{ 0x4C84 , 0x8234E836},
{ 0x4C85 , 0x8234E837},
{ 0x4C86 , 0x8234E838},
{ 0x4C87 , 0x8234E839},
{ 0x4C88 , 0x8234E930},
{ 0x4C89 , 0x8234E931},
{ 0x4C8A , 0x8234E932},
{ 0x4C8B , 0x8234E933},
{ 0x4C8C , 0x8234E934},
{ 0x4C8D , 0x8234E935},
{ 0x4C8E , 0x8234E936},
{ 0x4C8F , 0x8234E937},
{ 0x4C90 , 0x8234E938},
{ 0x4C91 , 0x8234E939},
{ 0x4C92 , 0x8234EA30},
{ 0x4C93 , 0x8234EA31},
{ 0x4C94 , 0x8234EA32},
{ 0x4C95 , 0x8234EA33},
{ 0x4C96 , 0x8234EA34},
{ 0x4C97 , 0x8234EA35},
{ 0x4C98 , 0x8234EA36},
{ 0x4C99 , 0x8234EA37},
{ 0x4C9A , 0x8234EA38},
{ 0x4C9B , 0x8234EA39},
{ 0x4C9C , 0x8234EB30},
{ 0x4C9D , 0x8234EB31},
{ 0x4C9E , 0x8234EB32},
{ 0x4CA4 , 0x8234EB33},
{ 0x4CA5 , 0x8234EB34},
{ 0x4CA6 , 0x8234EB35},
{ 0x4CA7 , 0x8234EB36},
{ 0x4CA8 , 0x8234EB37},
{ 0x4CA9 , 0x8234EB38},
{ 0x4CAA , 0x8234EB39},
{ 0x4CAB , 0x8234EC30},
{ 0x4CAC , 0x8234EC31},
{ 0x4CAD , 0x8234EC32},
{ 0x4CAE , 0x8234EC33},
{ 0x4CAF , 0x8234EC34},
{ 0x4CB0 , 0x8234EC35},
{ 0x4CB1 , 0x8234EC36},
{ 0x4CB2 , 0x8234EC37},
{ 0x4CB3 , 0x8234EC38},
{ 0x4CB4 , 0x8234EC39},
{ 0x4CB5 , 0x8234ED30},
{ 0x4CB6 , 0x8234ED31},
{ 0x4CB7 , 0x8234ED32},
{ 0x4CB8 , 0x8234ED33},
{ 0x4CB9 , 0x8234ED34},
{ 0x4CBA , 0x8234ED35},
{ 0x4CBB , 0x8234ED36},
{ 0x4CBC , 0x8234ED37},
{ 0x4CBD , 0x8234ED38},
{ 0x4CBE , 0x8234ED39},
{ 0x4CBF , 0x8234EE30},
{ 0x4CC0 , 0x8234EE31},
{ 0x4CC1 , 0x8234EE32},
{ 0x4CC2 , 0x8234EE33},
{ 0x4CC3 , 0x8234EE34},
{ 0x4CC4 , 0x8234EE35},
{ 0x4CC5 , 0x8234EE36},
{ 0x4CC6 , 0x8234EE37},
{ 0x4CC7 , 0x8234EE38},
{ 0x4CC8 , 0x8234EE39},
{ 0x4CC9 , 0x8234EF30},
{ 0x4CCA , 0x8234EF31},
{ 0x4CCB , 0x8234EF32},
{ 0x4CCC , 0x8234EF33},
{ 0x4CCD , 0x8234EF34},
{ 0x4CCE , 0x8234EF35},
{ 0x4CCF , 0x8234EF36},
{ 0x4CD0 , 0x8234EF37},
{ 0x4CD1 , 0x8234EF38},
{ 0x4CD2 , 0x8234EF39},
{ 0x4CD3 , 0x8234F030},
{ 0x4CD4 , 0x8234F031},
{ 0x4CD5 , 0x8234F032},
{ 0x4CD6 , 0x8234F033},
{ 0x4CD7 , 0x8234F034},
{ 0x4CD8 , 0x8234F035},
{ 0x4CD9 , 0x8234F036},
{ 0x4CDA , 0x8234F037},
{ 0x4CDB , 0x8234F038},
{ 0x4CDC , 0x8234F039},
{ 0x4CDD , 0x8234F130},
{ 0x4CDE , 0x8234F131},
{ 0x4CDF , 0x8234F132},
{ 0x4CE0 , 0x8234F133},
{ 0x4CE1 , 0x8234F134},
{ 0x4CE2 , 0x8234F135},
{ 0x4CE3 , 0x8234F136},
{ 0x4CE4 , 0x8234F137},
{ 0x4CE5 , 0x8234F138},
{ 0x4CE6 , 0x8234F139},
{ 0x4CE7 , 0x8234F230},
{ 0x4CE8 , 0x8234F231},
{ 0x4CE9 , 0x8234F232},
{ 0x4CEA , 0x8234F233},
{ 0x4CEB , 0x8234F234},
{ 0x4CEC , 0x8234F235},
{ 0x4CED , 0x8234F236},
{ 0x4CEE , 0x8234F237},
{ 0x4CEF , 0x8234F238},
{ 0x4CF0 , 0x8234F239},
{ 0x4CF1 , 0x8234F330},
{ 0x4CF2 , 0x8234F331},
{ 0x4CF3 , 0x8234F332},
{ 0x4CF4 , 0x8234F333},
{ 0x4CF5 , 0x8234F334},
{ 0x4CF6 , 0x8234F335},
{ 0x4CF7 , 0x8234F336},
{ 0x4CF8 , 0x8234F337},
{ 0x4CF9 , 0x8234F338},
{ 0x4CFA , 0x8234F339},
{ 0x4CFB , 0x8234F430},
{ 0x4CFC , 0x8234F431},
{ 0x4CFD , 0x8234F432},
{ 0x4CFE , 0x8234F433},
{ 0x4CFF , 0x8234F434},
{ 0x4D00 , 0x8234F435},
{ 0x4D01 , 0x8234F436},
{ 0x4D02 , 0x8234F437},
{ 0x4D03 , 0x8234F438},
{ 0x4D04 , 0x8234F439},
{ 0x4D05 , 0x8234F530},
{ 0x4D06 , 0x8234F531},
{ 0x4D07 , 0x8234F532},
{ 0x4D08 , 0x8234F533},
{ 0x4D09 , 0x8234F534},
{ 0x4D0A , 0x8234F535},
{ 0x4D0B , 0x8234F536},
{ 0x4D0C , 0x8234F537},
{ 0x4D0D , 0x8234F538},
{ 0x4D0E , 0x8234F539},
{ 0x4D0F , 0x8234F630},
{ 0x4D10 , 0x8234F631},
{ 0x4D11 , 0x8234F632},
{ 0x4D12 , 0x8234F633},
{ 0x4D1A , 0x8234F634},
{ 0x4D1B , 0x8234F635},
{ 0x4D1C , 0x8234F636},
{ 0x4D1D , 0x8234F637},
{ 0x4D1E , 0x8234F638},
{ 0x4D1F , 0x8234F639},
{ 0x4D20 , 0x8234F730},
{ 0x4D21 , 0x8234F731},
{ 0x4D22 , 0x8234F732},
{ 0x4D23 , 0x8234F733},
{ 0x4D24 , 0x8234F734},
{ 0x4D25 , 0x8234F735},
{ 0x4D26 , 0x8234F736},
{ 0x4D27 , 0x8234F737},
{ 0x4D28 , 0x8234F738},
{ 0x4D29 , 0x8234F739},
{ 0x4D2A , 0x8234F830},
{ 0x4D2B , 0x8234F831},
{ 0x4D2C , 0x8234F832},
{ 0x4D2D , 0x8234F833},
{ 0x4D2E , 0x8234F834},
{ 0x4D2F , 0x8234F835},
{ 0x4D30 , 0x8234F836},
{ 0x4D31 , 0x8234F837},
{ 0x4D32 , 0x8234F838},
{ 0x4D33 , 0x8234F839},
{ 0x4D34 , 0x8234F930},
{ 0x4D35 , 0x8234F931},
{ 0x4D36 , 0x8234F932},
{ 0x4D37 , 0x8234F933},
{ 0x4D38 , 0x8234F934},
{ 0x4D39 , 0x8234F935},
{ 0x4D3A , 0x8234F936},
{ 0x4D3B , 0x8234F937},
{ 0x4D3C , 0x8234F938},
{ 0x4D3D , 0x8234F939},
{ 0x4D3E , 0x8234FA30},
{ 0x4D3F , 0x8234FA31},
{ 0x4D40 , 0x8234FA32},
{ 0x4D41 , 0x8234FA33},
{ 0x4D42 , 0x8234FA34},
{ 0x4D43 , 0x8234FA35},
{ 0x4D44 , 0x8234FA36},
{ 0x4D45 , 0x8234FA37},
{ 0x4D46 , 0x8234FA38},
{ 0x4D47 , 0x8234FA39},
{ 0x4D48 , 0x8234FB30},
{ 0x4D49 , 0x8234FB31},
{ 0x4D4A , 0x8234FB32},
{ 0x4D4B , 0x8234FB33},
{ 0x4D4C , 0x8234FB34},
{ 0x4D4D , 0x8234FB35},
{ 0x4D4E , 0x8234FB36},
{ 0x4D4F , 0x8234FB37},
{ 0x4D50 , 0x8234FB38},
{ 0x4D51 , 0x8234FB39},
{ 0x4D52 , 0x8234FC30},
{ 0x4D53 , 0x8234FC31},
{ 0x4D54 , 0x8234FC32},
{ 0x4D55 , 0x8234FC33},
{ 0x4D56 , 0x8234FC34},
{ 0x4D57 , 0x8234FC35},
{ 0x4D58 , 0x8234FC36},
{ 0x4D59 , 0x8234FC37},
{ 0x4D5A , 0x8234FC38},
{ 0x4D5B , 0x8234FC39},
{ 0x4D5C , 0x8234FD30},
{ 0x4D5D , 0x8234FD31},
{ 0x4D5E , 0x8234FD32},
{ 0x4D5F , 0x8234FD33},
{ 0x4D60 , 0x8234FD34},
{ 0x4D61 , 0x8234FD35},
{ 0x4D62 , 0x8234FD36},
{ 0x4D63 , 0x8234FD37},
{ 0x4D64 , 0x8234FD38},
{ 0x4D65 , 0x8234FD39},
{ 0x4D66 , 0x8234FE30},
{ 0x4D67 , 0x8234FE31},
{ 0x4D68 , 0x8234FE32},
{ 0x4D69 , 0x8234FE33},
{ 0x4D6A , 0x8234FE34},
{ 0x4D6B , 0x8234FE35},
{ 0x4D6C , 0x8234FE36},
{ 0x4D6D , 0x8234FE37},
{ 0x4D6E , 0x8234FE38},
{ 0x4D6F , 0x8234FE39},
{ 0x4D70 , 0x82358130},
{ 0x4D71 , 0x82358131},
{ 0x4D72 , 0x82358132},
{ 0x4D73 , 0x82358133},
{ 0x4D74 , 0x82358134},
{ 0x4D75 , 0x82358135},
{ 0x4D76 , 0x82358136},
{ 0x4D77 , 0x82358137},
{ 0x4D78 , 0x82358138},
{ 0x4D79 , 0x82358139},
{ 0x4D7A , 0x82358230},
{ 0x4D7B , 0x82358231},
{ 0x4D7C , 0x82358232},
{ 0x4D7D , 0x82358233},
{ 0x4D7E , 0x82358234},
{ 0x4D7F , 0x82358235},
{ 0x4D80 , 0x82358236},
{ 0x4D81 , 0x82358237},
{ 0x4D82 , 0x82358238},
{ 0x4D83 , 0x82358239},
{ 0x4D84 , 0x82358330},
{ 0x4D85 , 0x82358331},
{ 0x4D86 , 0x82358332},
{ 0x4D87 , 0x82358333},
{ 0x4D88 , 0x82358334},
{ 0x4D89 , 0x82358335},
{ 0x4D8A , 0x82358336},
{ 0x4D8B , 0x82358337},
{ 0x4D8C , 0x82358338},
{ 0x4D8D , 0x82358339},
{ 0x4D8E , 0x82358430},
{ 0x4D8F , 0x82358431},
{ 0x4D90 , 0x82358432},
{ 0x4D91 , 0x82358433},
{ 0x4D92 , 0x82358434},
{ 0x4D93 , 0x82358435},
{ 0x4D94 , 0x82358436},
{ 0x4D95 , 0x82358437},
{ 0x4D96 , 0x82358438},
{ 0x4D97 , 0x82358439},
{ 0x4D98 , 0x82358530},
{ 0x4D99 , 0x82358531},
{ 0x4D9A , 0x82358532},
{ 0x4D9B , 0x82358533},
{ 0x4D9C , 0x82358534},
{ 0x4D9D , 0x82358535},
{ 0x4D9E , 0x82358536},
{ 0x4D9F , 0x82358537},
{ 0x4DA0 , 0x82358538},
{ 0x4DA1 , 0x82358539},
{ 0x4DA2 , 0x82358630},
{ 0x4DA3 , 0x82358631},
{ 0x4DA4 , 0x82358632},
{ 0x4DA5 , 0x82358633},
{ 0x4DA6 , 0x82358634},
{ 0x4DA7 , 0x82358635},
{ 0x4DA8 , 0x82358636},
{ 0x4DA9 , 0x82358637},
{ 0x4DAA , 0x82358638},
{ 0x4DAB , 0x82358639},
{ 0x4DAC , 0x82358730},
{ 0x4DAD , 0x82358731},
{ 0x4DAF , 0x82358732},
{ 0x4DB0 , 0x82358733},
{ 0x4DB1 , 0x82358734},
{ 0x4DB2 , 0x82358735},
{ 0x4DB3 , 0x82358736},
{ 0x4DB4 , 0x82358737},
{ 0x4DB5 , 0x82358738},
{ 0x4DB6 , 0x82358739},
{ 0x4DB7 , 0x82358830},
{ 0x4DB8 , 0x82358831},
{ 0x4DB9 , 0x82358832},
{ 0x4DBA , 0x82358833},
{ 0x4DBB , 0x82358834},
{ 0x4DBC , 0x82358835},
{ 0x4DBD , 0x82358836},
{ 0x4DBE , 0x82358837},
{ 0x4DBF , 0x82358838},
{ 0x4DC0 , 0x82358839},
{ 0x4DC1 , 0x82358930},
{ 0x4DC2 , 0x82358931},
{ 0x4DC3 , 0x82358932},
{ 0x4DC4 , 0x82358933},
{ 0x4DC5 , 0x82358934},
{ 0x4DC6 , 0x82358935},
{ 0x4DC7 , 0x82358936},
{ 0x4DC8 , 0x82358937},
{ 0x4DC9 , 0x82358938},
{ 0x4DCA , 0x82358939},
{ 0x4DCB , 0x82358A30},
{ 0x4DCC , 0x82358A31},
{ 0x4DCD , 0x82358A32},
{ 0x4DCE , 0x82358A33},
{ 0x4DCF , 0x82358A34},
{ 0x4DD0 , 0x82358A35},
{ 0x4DD1 , 0x82358A36},
{ 0x4DD2 , 0x82358A37},
{ 0x4DD3 , 0x82358A38},
{ 0x4DD4 , 0x82358A39},
{ 0x4DD5 , 0x82358B30},
{ 0x4DD6 , 0x82358B31},
{ 0x4DD7 , 0x82358B32},
{ 0x4DD8 , 0x82358B33},
{ 0x4DD9 , 0x82358B34},
{ 0x4DDA , 0x82358B35},
{ 0x4DDB , 0x82358B36},
{ 0x4DDC , 0x82358B37},
{ 0x4DDD , 0x82358B38},
{ 0x4DDE , 0x82358B39},
{ 0x4DDF , 0x82358C30},
{ 0x4DE0 , 0x82358C31},
{ 0x4DE1 , 0x82358C32},
{ 0x4DE2 , 0x82358C33},
{ 0x4DE3 , 0x82358C34},
{ 0x4DE4 , 0x82358C35},
{ 0x4DE5 , 0x82358C36},
{ 0x4DE6 , 0x82358C37},
{ 0x4DE7 , 0x82358C38},
{ 0x4DE8 , 0x82358C39},
{ 0x4DE9 , 0x82358D30},
{ 0x4DEA , 0x82358D31},
{ 0x4DEB , 0x82358D32},
{ 0x4DEC , 0x82358D33},
{ 0x4DED , 0x82358D34},
{ 0x4DEE , 0x82358D35},
{ 0x4DEF , 0x82358D36},
{ 0x4DF0 , 0x82358D37},
{ 0x4DF1 , 0x82358D38},
{ 0x4DF2 , 0x82358D39},
{ 0x4DF3 , 0x82358E30},
{ 0x4DF4 , 0x82358E31},
{ 0x4DF5 , 0x82358E32},
{ 0x4DF6 , 0x82358E33},
{ 0x4DF7 , 0x82358E34},
{ 0x4DF8 , 0x82358E35},
{ 0x4DF9 , 0x82358E36},
{ 0x4DFA , 0x82358E37},
{ 0x4DFB , 0x82358E38},
{ 0x4DFC , 0x82358E39},
{ 0x4DFD , 0x82358F30},
{ 0x4DFE , 0x82358F31},
{ 0x4DFF , 0x82358F32},
{ 0x9FA6 , 0x82358F33},
{ 0x9FA7 , 0x82358F34},
{ 0x9FA8 , 0x82358F35},
{ 0x9FA9 , 0x82358F36},
{ 0x9FAA , 0x82358F37},
{ 0x9FAB , 0x82358F38},
{ 0x9FAC , 0x82358F39},
{ 0x9FAD , 0x82359030},
{ 0x9FAE , 0x82359031},
{ 0x9FAF , 0x82359032},
{ 0x9FB0 , 0x82359033},
{ 0x9FB1 , 0x82359034},
{ 0x9FB2 , 0x82359035},
{ 0x9FB3 , 0x82359036},
{ 0x9FB4 , 0x82359037},
{ 0x9FB5 , 0x82359038},
{ 0x9FB6 , 0x82359039},
{ 0x9FB7 , 0x82359130},
{ 0x9FB8 , 0x82359131},
{ 0x9FB9 , 0x82359132},
{ 0x9FBA , 0x82359133},
{ 0x9FBB , 0x82359134},
{ 0x9FBC , 0x82359135},
{ 0x9FBD , 0x82359136},
{ 0x9FBE , 0x82359137},
{ 0x9FBF , 0x82359138},
{ 0x9FC0 , 0x82359139},
{ 0x9FC1 , 0x82359230},
{ 0x9FC2 , 0x82359231},
{ 0x9FC3 , 0x82359232},
{ 0x9FC4 , 0x82359233},
{ 0x9FC5 , 0x82359234},
{ 0x9FC6 , 0x82359235},
{ 0x9FC7 , 0x82359236},
{ 0x9FC8 , 0x82359237},
{ 0x9FC9 , 0x82359238},
{ 0x9FCA , 0x82359239},
{ 0x9FCB , 0x82359330},
{ 0x9FCC , 0x82359331},
{ 0x9FCD , 0x82359332},
{ 0x9FCE , 0x82359333},
{ 0x9FCF , 0x82359334},
{ 0x9FD0 , 0x82359335},
{ 0x9FD1 , 0x82359336},
{ 0x9FD2 , 0x82359337},
{ 0x9FD3 , 0x82359338},
{ 0x9FD4 , 0x82359339},
{ 0x9FD5 , 0x82359430},
{ 0x9FD6 , 0x82359431},
{ 0x9FD7 , 0x82359432},
{ 0x9FD8 , 0x82359433},
{ 0x9FD9 , 0x82359434},
{ 0x9FDA , 0x82359435},
{ 0x9FDB , 0x82359436},
{ 0x9FDC , 0x82359437},
{ 0x9FDD , 0x82359438},
{ 0x9FDE , 0x82359439},
{ 0x9FDF , 0x82359530},
{ 0x9FE0 , 0x82359531},
{ 0x9FE1 , 0x82359532},
{ 0x9FE2 , 0x82359533},
{ 0x9FE3 , 0x82359534},
{ 0x9FE4 , 0x82359535},
{ 0x9FE5 , 0x82359536},
{ 0x9FE6 , 0x82359537},
{ 0x9FE7 , 0x82359538},
{ 0x9FE8 , 0x82359539},
{ 0x9FE9 , 0x82359630},
{ 0x9FEA , 0x82359631},
{ 0x9FEB , 0x82359632},
{ 0x9FEC , 0x82359633},
{ 0x9FED , 0x82359634},
{ 0x9FEE , 0x82359635},
{ 0x9FEF , 0x82359636},
{ 0x9FF0 , 0x82359637},
{ 0x9FF1 , 0x82359638},
{ 0x9FF2 , 0x82359639},
{ 0x9FF3 , 0x82359730},
{ 0x9FF4 , 0x82359731},
{ 0x9FF5 , 0x82359732},
{ 0x9FF6 , 0x82359733},
{ 0x9FF7 , 0x82359734},
{ 0x9FF8 , 0x82359735},
{ 0x9FF9 , 0x82359736},
{ 0x9FFA , 0x82359737},
{ 0x9FFB , 0x82359738},
{ 0x9FFC , 0x82359739},
{ 0x9FFD , 0x82359830},
{ 0x9FFE , 0x82359831},
{ 0x9FFF , 0x82359832},
{ 0xA000 , 0x82359833},
{ 0xA001 , 0x82359834},
{ 0xA002 , 0x82359835},
{ 0xA003 , 0x82359836},
{ 0xA004 , 0x82359837},
{ 0xA005 , 0x82359838},
{ 0xA006 , 0x82359839},
{ 0xA007 , 0x82359930},
{ 0xA008 , 0x82359931},
{ 0xA009 , 0x82359932},
{ 0xA00A , 0x82359933},
{ 0xA00B , 0x82359934},
{ 0xA00C , 0x82359935},
{ 0xA00D , 0x82359936},
{ 0xA00E , 0x82359937},
{ 0xA00F , 0x82359938},
{ 0xA010 , 0x82359939},
{ 0xA011 , 0x82359A30},
{ 0xA012 , 0x82359A31},
{ 0xA013 , 0x82359A32},
{ 0xA014 , 0x82359A33},
{ 0xA015 , 0x82359A34},
{ 0xA016 , 0x82359A35},
{ 0xA017 , 0x82359A36},
{ 0xA018 , 0x82359A37},
{ 0xA019 , 0x82359A38},
{ 0xA01A , 0x82359A39},
{ 0xA01B , 0x82359B30},
{ 0xA01C , 0x82359B31},
{ 0xA01D , 0x82359B32},
{ 0xA01E , 0x82359B33},
{ 0xA01F , 0x82359B34},
{ 0xA020 , 0x82359B35},
{ 0xA021 , 0x82359B36},
{ 0xA022 , 0x82359B37},
{ 0xA023 , 0x82359B38},
{ 0xA024 , 0x82359B39},
{ 0xA025 , 0x82359C30},
{ 0xA026 , 0x82359C31},
{ 0xA027 , 0x82359C32},
{ 0xA028 , 0x82359C33},
{ 0xA029 , 0x82359C34},
{ 0xA02A , 0x82359C35},
{ 0xA02B , 0x82359C36},
{ 0xA02C , 0x82359C37},
{ 0xA02D , 0x82359C38},
{ 0xA02E , 0x82359C39},
{ 0xA02F , 0x82359D30},
{ 0xA030 , 0x82359D31},
{ 0xA031 , 0x82359D32},
{ 0xA032 , 0x82359D33},
{ 0xA033 , 0x82359D34},
{ 0xA034 , 0x82359D35},
{ 0xA035 , 0x82359D36},
{ 0xA036 , 0x82359D37},
{ 0xA037 , 0x82359D38},
{ 0xA038 , 0x82359D39},
{ 0xA039 , 0x82359E30},
{ 0xA03A , 0x82359E31},
{ 0xA03B , 0x82359E32},
{ 0xA03C , 0x82359E33},
{ 0xA03D , 0x82359E34},
{ 0xA03E , 0x82359E35},
{ 0xA03F , 0x82359E36},
{ 0xA040 , 0x82359E37},
{ 0xA041 , 0x82359E38},
{ 0xA042 , 0x82359E39},
{ 0xA043 , 0x82359F30},
{ 0xA044 , 0x82359F31},
{ 0xA045 , 0x82359F32},
{ 0xA046 , 0x82359F33},
{ 0xA047 , 0x82359F34},
{ 0xA048 , 0x82359F35},
{ 0xA049 , 0x82359F36},
{ 0xA04A , 0x82359F37},
{ 0xA04B , 0x82359F38},
{ 0xA04C , 0x82359F39},
{ 0xA04D , 0x8235A030},
{ 0xA04E , 0x8235A031},
{ 0xA04F , 0x8235A032},
{ 0xA050 , 0x8235A033},
{ 0xA051 , 0x8235A034},
{ 0xA052 , 0x8235A035},
{ 0xA053 , 0x8235A036},
{ 0xA054 , 0x8235A037},
{ 0xA055 , 0x8235A038},
{ 0xA056 , 0x8235A039},
{ 0xA057 , 0x8235A130},
{ 0xA058 , 0x8235A131},
{ 0xA059 , 0x8235A132},
{ 0xA05A , 0x8235A133},
{ 0xA05B , 0x8235A134},
{ 0xA05C , 0x8235A135},
{ 0xA05D , 0x8235A136},
{ 0xA05E , 0x8235A137},
{ 0xA05F , 0x8235A138},
{ 0xA060 , 0x8235A139},
{ 0xA061 , 0x8235A230},
{ 0xA062 , 0x8235A231},
{ 0xA063 , 0x8235A232},
{ 0xA064 , 0x8235A233},
{ 0xA065 , 0x8235A234},
{ 0xA066 , 0x8235A235},
{ 0xA067 , 0x8235A236},
{ 0xA068 , 0x8235A237},
{ 0xA069 , 0x8235A238},
{ 0xA06A , 0x8235A239},
{ 0xA06B , 0x8235A330},
{ 0xA06C , 0x8235A331},
{ 0xA06D , 0x8235A332},
{ 0xA06E , 0x8235A333},
{ 0xA06F , 0x8235A334},
{ 0xA070 , 0x8235A335},
{ 0xA071 , 0x8235A336},
{ 0xA072 , 0x8235A337},
{ 0xA073 , 0x8235A338},
{ 0xA074 , 0x8235A339},
{ 0xA075 , 0x8235A430},
{ 0xA076 , 0x8235A431},
{ 0xA077 , 0x8235A432},
{ 0xA078 , 0x8235A433},
{ 0xA079 , 0x8235A434},
{ 0xA07A , 0x8235A435},
{ 0xA07B , 0x8235A436},
{ 0xA07C , 0x8235A437},
{ 0xA07D , 0x8235A438},
{ 0xA07E , 0x8235A439},
{ 0xA07F , 0x8235A530},
{ 0xA080 , 0x8235A531},
{ 0xA081 , 0x8235A532},
{ 0xA082 , 0x8235A533},
{ 0xA083 , 0x8235A534},
{ 0xA084 , 0x8235A535},
{ 0xA085 , 0x8235A536},
{ 0xA086 , 0x8235A537},
{ 0xA087 , 0x8235A538},
{ 0xA088 , 0x8235A539},
{ 0xA089 , 0x8235A630},
{ 0xA08A , 0x8235A631},
{ 0xA08B , 0x8235A632},
{ 0xA08C , 0x8235A633},
{ 0xA08D , 0x8235A634},
{ 0xA08E , 0x8235A635},
{ 0xA08F , 0x8235A636},
{ 0xA090 , 0x8235A637},
{ 0xA091 , 0x8235A638},
{ 0xA092 , 0x8235A639},
{ 0xA093 , 0x8235A730},
{ 0xA094 , 0x8235A731},
{ 0xA095 , 0x8235A732},
{ 0xA096 , 0x8235A733},
{ 0xA097 , 0x8235A734},
{ 0xA098 , 0x8235A735},
{ 0xA099 , 0x8235A736},
{ 0xA09A , 0x8235A737},
{ 0xA09B , 0x8235A738},
{ 0xA09C , 0x8235A739},
{ 0xA09D , 0x8235A830},
{ 0xA09E , 0x8235A831},
{ 0xA09F , 0x8235A832},
{ 0xA0A0 , 0x8235A833},
{ 0xA0A1 , 0x8235A834},
{ 0xA0A2 , 0x8235A835},
{ 0xA0A3 , 0x8235A836},
{ 0xA0A4 , 0x8235A837},
{ 0xA0A5 , 0x8235A838},
{ 0xA0A6 , 0x8235A839},
{ 0xA0A7 , 0x8235A930},
{ 0xA0A8 , 0x8235A931},
{ 0xA0A9 , 0x8235A932},
{ 0xA0AA , 0x8235A933},
{ 0xA0AB , 0x8235A934},
{ 0xA0AC , 0x8235A935},
{ 0xA0AD , 0x8235A936},
{ 0xA0AE , 0x8235A937},
{ 0xA0AF , 0x8235A938},
{ 0xA0B0 , 0x8235A939},
{ 0xA0B1 , 0x8235AA30},
{ 0xA0B2 , 0x8235AA31},
{ 0xA0B3 , 0x8235AA32},
{ 0xA0B4 , 0x8235AA33},
{ 0xA0B5 , 0x8235AA34},
{ 0xA0B6 , 0x8235AA35},
{ 0xA0B7 , 0x8235AA36},
{ 0xA0B8 , 0x8235AA37},
{ 0xA0B9 , 0x8235AA38},
{ 0xA0BA , 0x8235AA39},
{ 0xA0BB , 0x8235AB30},
{ 0xA0BC , 0x8235AB31},
{ 0xA0BD , 0x8235AB32},
{ 0xA0BE , 0x8235AB33},
{ 0xA0BF , 0x8235AB34},
{ 0xA0C0 , 0x8235AB35},
{ 0xA0C1 , 0x8235AB36},
{ 0xA0C2 , 0x8235AB37},
{ 0xA0C3 , 0x8235AB38},
{ 0xA0C4 , 0x8235AB39},
{ 0xA0C5 , 0x8235AC30},
{ 0xA0C6 , 0x8235AC31},
{ 0xA0C7 , 0x8235AC32},
{ 0xA0C8 , 0x8235AC33},
{ 0xA0C9 , 0x8235AC34},
{ 0xA0CA , 0x8235AC35},
{ 0xA0CB , 0x8235AC36},
{ 0xA0CC , 0x8235AC37},
{ 0xA0CD , 0x8235AC38},
{ 0xA0CE , 0x8235AC39},
{ 0xA0CF , 0x8235AD30},
{ 0xA0D0 , 0x8235AD31},
{ 0xA0D1 , 0x8235AD32},
{ 0xA0D2 , 0x8235AD33},
{ 0xA0D3 , 0x8235AD34},
{ 0xA0D4 , 0x8235AD35},
{ 0xA0D5 , 0x8235AD36},
{ 0xA0D6 , 0x8235AD37},
{ 0xA0D7 , 0x8235AD38},
{ 0xA0D8 , 0x8235AD39},
{ 0xA0D9 , 0x8235AE30},
{ 0xA0DA , 0x8235AE31},
{ 0xA0DB , 0x8235AE32},
{ 0xA0DC , 0x8235AE33},
{ 0xA0DD , 0x8235AE34},
{ 0xA0DE , 0x8235AE35},
{ 0xA0DF , 0x8235AE36},
{ 0xA0E0 , 0x8235AE37},
{ 0xA0E1 , 0x8235AE38},
{ 0xA0E2 , 0x8235AE39},
{ 0xA0E3 , 0x8235AF30},
{ 0xA0E4 , 0x8235AF31},
{ 0xA0E5 , 0x8235AF32},
{ 0xA0E6 , 0x8235AF33},
{ 0xA0E7 , 0x8235AF34},
{ 0xA0E8 , 0x8235AF35},
{ 0xA0E9 , 0x8235AF36},
{ 0xA0EA , 0x8235AF37},
{ 0xA0EB , 0x8235AF38},
{ 0xA0EC , 0x8235AF39},
{ 0xA0ED , 0x8235B030},
{ 0xA0EE , 0x8235B031},
{ 0xA0EF , 0x8235B032},
{ 0xA0F0 , 0x8235B033},
{ 0xA0F1 , 0x8235B034},
{ 0xA0F2 , 0x8235B035},
{ 0xA0F3 , 0x8235B036},
{ 0xA0F4 , 0x8235B037},
{ 0xA0F5 , 0x8235B038},
{ 0xA0F6 , 0x8235B039},
{ 0xA0F7 , 0x8235B130},
{ 0xA0F8 , 0x8235B131},
{ 0xA0F9 , 0x8235B132},
{ 0xA0FA , 0x8235B133},
{ 0xA0FB , 0x8235B134},
{ 0xA0FC , 0x8235B135},
{ 0xA0FD , 0x8235B136},
{ 0xA0FE , 0x8235B137},
{ 0xA0FF , 0x8235B138},
{ 0xA100 , 0x8235B139},
{ 0xA101 , 0x8235B230},
{ 0xA102 , 0x8235B231},
{ 0xA103 , 0x8235B232},
{ 0xA104 , 0x8235B233},
{ 0xA105 , 0x8235B234},
{ 0xA106 , 0x8235B235},
{ 0xA107 , 0x8235B236},
{ 0xA108 , 0x8235B237},
{ 0xA109 , 0x8235B238},
{ 0xA10A , 0x8235B239},
{ 0xA10B , 0x8235B330},
{ 0xA10C , 0x8235B331},
{ 0xA10D , 0x8235B332},
{ 0xA10E , 0x8235B333},
{ 0xA10F , 0x8235B334},
{ 0xA110 , 0x8235B335},
{ 0xA111 , 0x8235B336},
{ 0xA112 , 0x8235B337},
{ 0xA113 , 0x8235B338},
{ 0xA114 , 0x8235B339},
{ 0xA115 , 0x8235B430},
{ 0xA116 , 0x8235B431},
{ 0xA117 , 0x8235B432},
{ 0xA118 , 0x8235B433},
{ 0xA119 , 0x8235B434},
{ 0xA11A , 0x8235B435},
{ 0xA11B , 0x8235B436},
{ 0xA11C , 0x8235B437},
{ 0xA11D , 0x8235B438},
{ 0xA11E , 0x8235B439},
{ 0xA11F , 0x8235B530},
{ 0xA120 , 0x8235B531},
{ 0xA121 , 0x8235B532},
{ 0xA122 , 0x8235B533},
{ 0xA123 , 0x8235B534},
{ 0xA124 , 0x8235B535},
{ 0xA125 , 0x8235B536},
{ 0xA126 , 0x8235B537},
{ 0xA127 , 0x8235B538},
{ 0xA128 , 0x8235B539},
{ 0xA129 , 0x8235B630},
{ 0xA12A , 0x8235B631},
{ 0xA12B , 0x8235B632},
{ 0xA12C , 0x8235B633},
{ 0xA12D , 0x8235B634},
{ 0xA12E , 0x8235B635},
{ 0xA12F , 0x8235B636},
{ 0xA130 , 0x8235B637},
{ 0xA131 , 0x8235B638},
{ 0xA132 , 0x8235B639},
{ 0xA133 , 0x8235B730},
{ 0xA134 , 0x8235B731},
{ 0xA135 , 0x8235B732},
{ 0xA136 , 0x8235B733},
{ 0xA137 , 0x8235B734},
{ 0xA138 , 0x8235B735},
{ 0xA139 , 0x8235B736},
{ 0xA13A , 0x8235B737},
{ 0xA13B , 0x8235B738},
{ 0xA13C , 0x8235B739},
{ 0xA13D , 0x8235B830},
{ 0xA13E , 0x8235B831},
{ 0xA13F , 0x8235B832},
{ 0xA140 , 0x8235B833},
{ 0xA141 , 0x8235B834},
{ 0xA142 , 0x8235B835},
{ 0xA143 , 0x8235B836},
{ 0xA144 , 0x8235B837},
{ 0xA145 , 0x8235B838},
{ 0xA146 , 0x8235B839},
{ 0xA147 , 0x8235B930},
{ 0xA148 , 0x8235B931},
{ 0xA149 , 0x8235B932},
{ 0xA14A , 0x8235B933},
{ 0xA14B , 0x8235B934},
{ 0xA14C , 0x8235B935},
{ 0xA14D , 0x8235B936},
{ 0xA14E , 0x8235B937},
{ 0xA14F , 0x8235B938},
{ 0xA150 , 0x8235B939},
{ 0xA151 , 0x8235BA30},
{ 0xA152 , 0x8235BA31},
{ 0xA153 , 0x8235BA32},
{ 0xA154 , 0x8235BA33},
{ 0xA155 , 0x8235BA34},
{ 0xA156 , 0x8235BA35},
{ 0xA157 , 0x8235BA36},
{ 0xA158 , 0x8235BA37},
{ 0xA159 , 0x8235BA38},
{ 0xA15A , 0x8235BA39},
{ 0xA15B , 0x8235BB30},
{ 0xA15C , 0x8235BB31},
{ 0xA15D , 0x8235BB32},
{ 0xA15E , 0x8235BB33},
{ 0xA15F , 0x8235BB34},
{ 0xA160 , 0x8235BB35},
{ 0xA161 , 0x8235BB36},
{ 0xA162 , 0x8235BB37},
{ 0xA163 , 0x8235BB38},
{ 0xA164 , 0x8235BB39},
{ 0xA165 , 0x8235BC30},
{ 0xA166 , 0x8235BC31},
{ 0xA167 , 0x8235BC32},
{ 0xA168 , 0x8235BC33},
{ 0xA169 , 0x8235BC34},
{ 0xA16A , 0x8235BC35},
{ 0xA16B , 0x8235BC36},
{ 0xA16C , 0x8235BC37},
{ 0xA16D , 0x8235BC38},
{ 0xA16E , 0x8235BC39},
{ 0xA16F , 0x8235BD30},
{ 0xA170 , 0x8235BD31},
{ 0xA171 , 0x8235BD32},
{ 0xA172 , 0x8235BD33},
{ 0xA173 , 0x8235BD34},
{ 0xA174 , 0x8235BD35},
{ 0xA175 , 0x8235BD36},
{ 0xA176 , 0x8235BD37},
{ 0xA177 , 0x8235BD38},
{ 0xA178 , 0x8235BD39},
{ 0xA179 , 0x8235BE30},
{ 0xA17A , 0x8235BE31},
{ 0xA17B , 0x8235BE32},
{ 0xA17C , 0x8235BE33},
{ 0xA17D , 0x8235BE34},
{ 0xA17E , 0x8235BE35},
{ 0xA17F , 0x8235BE36},
{ 0xA180 , 0x8235BE37},
{ 0xA181 , 0x8235BE38},
{ 0xA182 , 0x8235BE39},
{ 0xA183 , 0x8235BF30},
{ 0xA184 , 0x8235BF31},
{ 0xA185 , 0x8235BF32},
{ 0xA186 , 0x8235BF33},
{ 0xA187 , 0x8235BF34},
{ 0xA188 , 0x8235BF35},
{ 0xA189 , 0x8235BF36},
{ 0xA18A , 0x8235BF37},
{ 0xA18B , 0x8235BF38},
{ 0xA18C , 0x8235BF39},
{ 0xA18D , 0x8235C030},
{ 0xA18E , 0x8235C031},
{ 0xA18F , 0x8235C032},
{ 0xA190 , 0x8235C033},
{ 0xA191 , 0x8235C034},
{ 0xA192 , 0x8235C035},
{ 0xA193 , 0x8235C036},
{ 0xA194 , 0x8235C037},
{ 0xA195 , 0x8235C038},
{ 0xA196 , 0x8235C039},
{ 0xA197 , 0x8235C130},
{ 0xA198 , 0x8235C131},
{ 0xA199 , 0x8235C132},
{ 0xA19A , 0x8235C133},
{ 0xA19B , 0x8235C134},
{ 0xA19C , 0x8235C135},
{ 0xA19D , 0x8235C136},
{ 0xA19E , 0x8235C137},
{ 0xA19F , 0x8235C138},
{ 0xA1A0 , 0x8235C139},
{ 0xA1A1 , 0x8235C230},
{ 0xA1A2 , 0x8235C231},
{ 0xA1A3 , 0x8235C232},
{ 0xA1A4 , 0x8235C233},
{ 0xA1A5 , 0x8235C234},
{ 0xA1A6 , 0x8235C235},
{ 0xA1A7 , 0x8235C236},
{ 0xA1A8 , 0x8235C237},
{ 0xA1A9 , 0x8235C238},
{ 0xA1AA , 0x8235C239},
{ 0xA1AB , 0x8235C330},
{ 0xA1AC , 0x8235C331},
{ 0xA1AD , 0x8235C332},
{ 0xA1AE , 0x8235C333},
{ 0xA1AF , 0x8235C334},
{ 0xA1B0 , 0x8235C335},
{ 0xA1B1 , 0x8235C336},
{ 0xA1B2 , 0x8235C337},
{ 0xA1B3 , 0x8235C338},
{ 0xA1B4 , 0x8235C339},
{ 0xA1B5 , 0x8235C430},
{ 0xA1B6 , 0x8235C431},
{ 0xA1B7 , 0x8235C432},
{ 0xA1B8 , 0x8235C433},
{ 0xA1B9 , 0x8235C434},
{ 0xA1BA , 0x8235C435},
{ 0xA1BB , 0x8235C436},
{ 0xA1BC , 0x8235C437},
{ 0xA1BD , 0x8235C438},
{ 0xA1BE , 0x8235C439},
{ 0xA1BF , 0x8235C530},
{ 0xA1C0 , 0x8235C531},
{ 0xA1C1 , 0x8235C532},
{ 0xA1C2 , 0x8235C533},
{ 0xA1C3 , 0x8235C534},
{ 0xA1C4 , 0x8235C535},
{ 0xA1C5 , 0x8235C536},
{ 0xA1C6 , 0x8235C537},
{ 0xA1C7 , 0x8235C538},
{ 0xA1C8 , 0x8235C539},
{ 0xA1C9 , 0x8235C630},
{ 0xA1CA , 0x8235C631},
{ 0xA1CB , 0x8235C632},
{ 0xA1CC , 0x8235C633},
{ 0xA1CD , 0x8235C634},
{ 0xA1CE , 0x8235C635},
{ 0xA1CF , 0x8235C636},
{ 0xA1D0 , 0x8235C637},
{ 0xA1D1 , 0x8235C638},
{ 0xA1D2 , 0x8235C639},
{ 0xA1D3 , 0x8235C730},
{ 0xA1D4 , 0x8235C731},
{ 0xA1D5 , 0x8235C732},
{ 0xA1D6 , 0x8235C733},
{ 0xA1D7 , 0x8235C734},
{ 0xA1D8 , 0x8235C735},
{ 0xA1D9 , 0x8235C736},
{ 0xA1DA , 0x8235C737},
{ 0xA1DB , 0x8235C738},
{ 0xA1DC , 0x8235C739},
{ 0xA1DD , 0x8235C830},
{ 0xA1DE , 0x8235C831},
{ 0xA1DF , 0x8235C832},
{ 0xA1E0 , 0x8235C833},
{ 0xA1E1 , 0x8235C834},
{ 0xA1E2 , 0x8235C835},
{ 0xA1E3 , 0x8235C836},
{ 0xA1E4 , 0x8235C837},
{ 0xA1E5 , 0x8235C838},
{ 0xA1E6 , 0x8235C839},
{ 0xA1E7 , 0x8235C930},
{ 0xA1E8 , 0x8235C931},
{ 0xA1E9 , 0x8235C932},
{ 0xA1EA , 0x8235C933},
{ 0xA1EB , 0x8235C934},
{ 0xA1EC , 0x8235C935},
{ 0xA1ED , 0x8235C936},
{ 0xA1EE , 0x8235C937},
{ 0xA1EF , 0x8235C938},
{ 0xA1F0 , 0x8235C939},
{ 0xA1F1 , 0x8235CA30},
{ 0xA1F2 , 0x8235CA31},
{ 0xA1F3 , 0x8235CA32},
{ 0xA1F4 , 0x8235CA33},
{ 0xA1F5 , 0x8235CA34},
{ 0xA1F6 , 0x8235CA35},
{ 0xA1F7 , 0x8235CA36},
{ 0xA1F8 , 0x8235CA37},
{ 0xA1F9 , 0x8235CA38},
{ 0xA1FA , 0x8235CA39},
{ 0xA1FB , 0x8235CB30},
{ 0xA1FC , 0x8235CB31},
{ 0xA1FD , 0x8235CB32},
{ 0xA1FE , 0x8235CB33},
{ 0xA1FF , 0x8235CB34},
{ 0xA200 , 0x8235CB35},
{ 0xA201 , 0x8235CB36},
{ 0xA202 , 0x8235CB37},
{ 0xA203 , 0x8235CB38},
{ 0xA204 , 0x8235CB39},
{ 0xA205 , 0x8235CC30},
{ 0xA206 , 0x8235CC31},
{ 0xA207 , 0x8235CC32},
{ 0xA208 , 0x8235CC33},
{ 0xA209 , 0x8235CC34},
{ 0xA20A , 0x8235CC35},
{ 0xA20B , 0x8235CC36},
{ 0xA20C , 0x8235CC37},
{ 0xA20D , 0x8235CC38},
{ 0xA20E , 0x8235CC39},
{ 0xA20F , 0x8235CD30},
{ 0xA210 , 0x8235CD31},
{ 0xA211 , 0x8235CD32},
{ 0xA212 , 0x8235CD33},
{ 0xA213 , 0x8235CD34},
{ 0xA214 , 0x8235CD35},
{ 0xA215 , 0x8235CD36},
{ 0xA216 , 0x8235CD37},
{ 0xA217 , 0x8235CD38},
{ 0xA218 , 0x8235CD39},
{ 0xA219 , 0x8235CE30},
{ 0xA21A , 0x8235CE31},
{ 0xA21B , 0x8235CE32},
{ 0xA21C , 0x8235CE33},
{ 0xA21D , 0x8235CE34},
{ 0xA21E , 0x8235CE35},
{ 0xA21F , 0x8235CE36},
{ 0xA220 , 0x8235CE37},
{ 0xA221 , 0x8235CE38},
{ 0xA222 , 0x8235CE39},
{ 0xA223 , 0x8235CF30},
{ 0xA224 , 0x8235CF31},
{ 0xA225 , 0x8235CF32},
{ 0xA226 , 0x8235CF33},
{ 0xA227 , 0x8235CF34},
{ 0xA228 , 0x8235CF35},
{ 0xA229 , 0x8235CF36},
{ 0xA22A , 0x8235CF37},
{ 0xA22B , 0x8235CF38},
{ 0xA22C , 0x8235CF39},
{ 0xA22D , 0x8235D030},
{ 0xA22E , 0x8235D031},
{ 0xA22F , 0x8235D032},
{ 0xA230 , 0x8235D033},
{ 0xA231 , 0x8235D034},
{ 0xA232 , 0x8235D035},
{ 0xA233 , 0x8235D036},
{ 0xA234 , 0x8235D037},
{ 0xA235 , 0x8235D038},
{ 0xA236 , 0x8235D039},
{ 0xA237 , 0x8235D130},
{ 0xA238 , 0x8235D131},
{ 0xA239 , 0x8235D132},
{ 0xA23A , 0x8235D133},
{ 0xA23B , 0x8235D134},
{ 0xA23C , 0x8235D135},
{ 0xA23D , 0x8235D136},
{ 0xA23E , 0x8235D137},
{ 0xA23F , 0x8235D138},
{ 0xA240 , 0x8235D139},
{ 0xA241 , 0x8235D230},
{ 0xA242 , 0x8235D231},
{ 0xA243 , 0x8235D232},
{ 0xA244 , 0x8235D233},
{ 0xA245 , 0x8235D234},
{ 0xA246 , 0x8235D235},
{ 0xA247 , 0x8235D236},
{ 0xA248 , 0x8235D237},
{ 0xA249 , 0x8235D238},
{ 0xA24A , 0x8235D239},
{ 0xA24B , 0x8235D330},
{ 0xA24C , 0x8235D331},
{ 0xA24D , 0x8235D332},
{ 0xA24E , 0x8235D333},
{ 0xA24F , 0x8235D334},
{ 0xA250 , 0x8235D335},
{ 0xA251 , 0x8235D336},
{ 0xA252 , 0x8235D337},
{ 0xA253 , 0x8235D338},
{ 0xA254 , 0x8235D339},
{ 0xA255 , 0x8235D430},
{ 0xA256 , 0x8235D431},
{ 0xA257 , 0x8235D432},
{ 0xA258 , 0x8235D433},
{ 0xA259 , 0x8235D434},
{ 0xA25A , 0x8235D435},
{ 0xA25B , 0x8235D436},
{ 0xA25C , 0x8235D437},
{ 0xA25D , 0x8235D438},
{ 0xA25E , 0x8235D439},
{ 0xA25F , 0x8235D530},
{ 0xA260 , 0x8235D531},
{ 0xA261 , 0x8235D532},
{ 0xA262 , 0x8235D533},
{ 0xA263 , 0x8235D534},
{ 0xA264 , 0x8235D535},
{ 0xA265 , 0x8235D536},
{ 0xA266 , 0x8235D537},
{ 0xA267 , 0x8235D538},
{ 0xA268 , 0x8235D539},
{ 0xA269 , 0x8235D630},
{ 0xA26A , 0x8235D631},
{ 0xA26B , 0x8235D632},
{ 0xA26C , 0x8235D633},
{ 0xA26D , 0x8235D634},
{ 0xA26E , 0x8235D635},
{ 0xA26F , 0x8235D636},
{ 0xA270 , 0x8235D637},
{ 0xA271 , 0x8235D638},
{ 0xA272 , 0x8235D639},
{ 0xA273 , 0x8235D730},
{ 0xA274 , 0x8235D731},
{ 0xA275 , 0x8235D732},
{ 0xA276 , 0x8235D733},
{ 0xA277 , 0x8235D734},
{ 0xA278 , 0x8235D735},
{ 0xA279 , 0x8235D736},
{ 0xA27A , 0x8235D737},
{ 0xA27B , 0x8235D738},
{ 0xA27C , 0x8235D739},
{ 0xA27D , 0x8235D830},
{ 0xA27E , 0x8235D831},
{ 0xA27F , 0x8235D832},
{ 0xA280 , 0x8235D833},
{ 0xA281 , 0x8235D834},
{ 0xA282 , 0x8235D835},
{ 0xA283 , 0x8235D836},
{ 0xA284 , 0x8235D837},
{ 0xA285 , 0x8235D838},
{ 0xA286 , 0x8235D839},
{ 0xA287 , 0x8235D930},
{ 0xA288 , 0x8235D931},
{ 0xA289 , 0x8235D932},
{ 0xA28A , 0x8235D933},
{ 0xA28B , 0x8235D934},
{ 0xA28C , 0x8235D935},
{ 0xA28D , 0x8235D936},
{ 0xA28E , 0x8235D937},
{ 0xA28F , 0x8235D938},
{ 0xA290 , 0x8235D939},
{ 0xA291 , 0x8235DA30},
{ 0xA292 , 0x8235DA31},
{ 0xA293 , 0x8235DA32},
{ 0xA294 , 0x8235DA33},
{ 0xA295 , 0x8235DA34},
{ 0xA296 , 0x8235DA35},
{ 0xA297 , 0x8235DA36},
{ 0xA298 , 0x8235DA37},
{ 0xA299 , 0x8235DA38},
{ 0xA29A , 0x8235DA39},
{ 0xA29B , 0x8235DB30},
{ 0xA29C , 0x8235DB31},
{ 0xA29D , 0x8235DB32},
{ 0xA29E , 0x8235DB33},
{ 0xA29F , 0x8235DB34},
{ 0xA2A0 , 0x8235DB35},
{ 0xA2A1 , 0x8235DB36},
{ 0xA2A2 , 0x8235DB37},
{ 0xA2A3 , 0x8235DB38},
{ 0xA2A4 , 0x8235DB39},
{ 0xA2A5 , 0x8235DC30},
{ 0xA2A6 , 0x8235DC31},
{ 0xA2A7 , 0x8235DC32},
{ 0xA2A8 , 0x8235DC33},
{ 0xA2A9 , 0x8235DC34},
{ 0xA2AA , 0x8235DC35},
{ 0xA2AB , 0x8235DC36},
{ 0xA2AC , 0x8235DC37},
{ 0xA2AD , 0x8235DC38},
{ 0xA2AE , 0x8235DC39},
{ 0xA2AF , 0x8235DD30},
{ 0xA2B0 , 0x8235DD31},
{ 0xA2B1 , 0x8235DD32},
{ 0xA2B2 , 0x8235DD33},
{ 0xA2B3 , 0x8235DD34},
{ 0xA2B4 , 0x8235DD35},
{ 0xA2B5 , 0x8235DD36},
{ 0xA2B6 , 0x8235DD37},
{ 0xA2B7 , 0x8235DD38},
{ 0xA2B8 , 0x8235DD39},
{ 0xA2B9 , 0x8235DE30},
{ 0xA2BA , 0x8235DE31},
{ 0xA2BB , 0x8235DE32},
{ 0xA2BC , 0x8235DE33},
{ 0xA2BD , 0x8235DE34},
{ 0xA2BE , 0x8235DE35},
{ 0xA2BF , 0x8235DE36},
{ 0xA2C0 , 0x8235DE37},
{ 0xA2C1 , 0x8235DE38},
{ 0xA2C2 , 0x8235DE39},
{ 0xA2C3 , 0x8235DF30},
{ 0xA2C4 , 0x8235DF31},
{ 0xA2C5 , 0x8235DF32},
{ 0xA2C6 , 0x8235DF33},
{ 0xA2C7 , 0x8235DF34},
{ 0xA2C8 , 0x8235DF35},
{ 0xA2C9 , 0x8235DF36},
{ 0xA2CA , 0x8235DF37},
{ 0xA2CB , 0x8235DF38},
{ 0xA2CC , 0x8235DF39},
{ 0xA2CD , 0x8235E030},
{ 0xA2CE , 0x8235E031},
{ 0xA2CF , 0x8235E032},
{ 0xA2D0 , 0x8235E033},
{ 0xA2D1 , 0x8235E034},
{ 0xA2D2 , 0x8235E035},
{ 0xA2D3 , 0x8235E036},
{ 0xA2D4 , 0x8235E037},
{ 0xA2D5 , 0x8235E038},
{ 0xA2D6 , 0x8235E039},
{ 0xA2D7 , 0x8235E130},
{ 0xA2D8 , 0x8235E131},
{ 0xA2D9 , 0x8235E132},
{ 0xA2DA , 0x8235E133},
{ 0xA2DB , 0x8235E134},
{ 0xA2DC , 0x8235E135},
{ 0xA2DD , 0x8235E136},
{ 0xA2DE , 0x8235E137},
{ 0xA2DF , 0x8235E138},
{ 0xA2E0 , 0x8235E139},
{ 0xA2E1 , 0x8235E230},
{ 0xA2E2 , 0x8235E231},
{ 0xA2E3 , 0x8235E232},
{ 0xA2E4 , 0x8235E233},
{ 0xA2E5 , 0x8235E234},
{ 0xA2E6 , 0x8235E235},
{ 0xA2E7 , 0x8235E236},
{ 0xA2E8 , 0x8235E237},
{ 0xA2E9 , 0x8235E238},
{ 0xA2EA , 0x8235E239},
{ 0xA2EB , 0x8235E330},
{ 0xA2EC , 0x8235E331},
{ 0xA2ED , 0x8235E332},
{ 0xA2EE , 0x8235E333},
{ 0xA2EF , 0x8235E334},
{ 0xA2F0 , 0x8235E335},
{ 0xA2F1 , 0x8235E336},
{ 0xA2F2 , 0x8235E337},
{ 0xA2F3 , 0x8235E338},
{ 0xA2F4 , 0x8235E339},
{ 0xA2F5 , 0x8235E430},
{ 0xA2F6 , 0x8235E431},
{ 0xA2F7 , 0x8235E432},
{ 0xA2F8 , 0x8235E433},
{ 0xA2F9 , 0x8235E434},
{ 0xA2FA , 0x8235E435},
{ 0xA2FB , 0x8235E436},
{ 0xA2FC , 0x8235E437},
{ 0xA2FD , 0x8235E438},
{ 0xA2FE , 0x8235E439},
{ 0xA2FF , 0x8235E530},
{ 0xA300 , 0x8235E531},
{ 0xA301 , 0x8235E532},
{ 0xA302 , 0x8235E533},
{ 0xA303 , 0x8235E534},
{ 0xA304 , 0x8235E535},
{ 0xA305 , 0x8235E536},
{ 0xA306 , 0x8235E537},
{ 0xA307 , 0x8235E538},
{ 0xA308 , 0x8235E539},
{ 0xA309 , 0x8235E630},
{ 0xA30A , 0x8235E631},
{ 0xA30B , 0x8235E632},
{ 0xA30C , 0x8235E633},
{ 0xA30D , 0x8235E634},
{ 0xA30E , 0x8235E635},
{ 0xA30F , 0x8235E636},
{ 0xA310 , 0x8235E637},
{ 0xA311 , 0x8235E638},
{ 0xA312 , 0x8235E639},
{ 0xA313 , 0x8235E730},
{ 0xA314 , 0x8235E731},
{ 0xA315 , 0x8235E732},
{ 0xA316 , 0x8235E733},
{ 0xA317 , 0x8235E734},
{ 0xA318 , 0x8235E735},
{ 0xA319 , 0x8235E736},
{ 0xA31A , 0x8235E737},
{ 0xA31B , 0x8235E738},
{ 0xA31C , 0x8235E739},
{ 0xA31D , 0x8235E830},
{ 0xA31E , 0x8235E831},
{ 0xA31F , 0x8235E832},
{ 0xA320 , 0x8235E833},
{ 0xA321 , 0x8235E834},
{ 0xA322 , 0x8235E835},
{ 0xA323 , 0x8235E836},
{ 0xA324 , 0x8235E837},
{ 0xA325 , 0x8235E838},
{ 0xA326 , 0x8235E839},
{ 0xA327 , 0x8235E930},
{ 0xA328 , 0x8235E931},
{ 0xA329 , 0x8235E932},
{ 0xA32A , 0x8235E933},
{ 0xA32B , 0x8235E934},
{ 0xA32C , 0x8235E935},
{ 0xA32D , 0x8235E936},
{ 0xA32E , 0x8235E937},
{ 0xA32F , 0x8235E938},
{ 0xA330 , 0x8235E939},
{ 0xA331 , 0x8235EA30},
{ 0xA332 , 0x8235EA31},
{ 0xA333 , 0x8235EA32},
{ 0xA334 , 0x8235EA33},
{ 0xA335 , 0x8235EA34},
{ 0xA336 , 0x8235EA35},
{ 0xA337 , 0x8235EA36},
{ 0xA338 , 0x8235EA37},
{ 0xA339 , 0x8235EA38},
{ 0xA33A , 0x8235EA39},
{ 0xA33B , 0x8235EB30},
{ 0xA33C , 0x8235EB31},
{ 0xA33D , 0x8235EB32},
{ 0xA33E , 0x8235EB33},
{ 0xA33F , 0x8235EB34},
{ 0xA340 , 0x8235EB35},
{ 0xA341 , 0x8235EB36},
{ 0xA342 , 0x8235EB37},
{ 0xA343 , 0x8235EB38},
{ 0xA344 , 0x8235EB39},
{ 0xA345 , 0x8235EC30},
{ 0xA346 , 0x8235EC31},
{ 0xA347 , 0x8235EC32},
{ 0xA348 , 0x8235EC33},
{ 0xA349 , 0x8235EC34},
{ 0xA34A , 0x8235EC35},
{ 0xA34B , 0x8235EC36},
{ 0xA34C , 0x8235EC37},
{ 0xA34D , 0x8235EC38},
{ 0xA34E , 0x8235EC39},
{ 0xA34F , 0x8235ED30},
{ 0xA350 , 0x8235ED31},
{ 0xA351 , 0x8235ED32},
{ 0xA352 , 0x8235ED33},
{ 0xA353 , 0x8235ED34},
{ 0xA354 , 0x8235ED35},
{ 0xA355 , 0x8235ED36},
{ 0xA356 , 0x8235ED37},
{ 0xA357 , 0x8235ED38},
{ 0xA358 , 0x8235ED39},
{ 0xA359 , 0x8235EE30},
{ 0xA35A , 0x8235EE31},
{ 0xA35B , 0x8235EE32},
{ 0xA35C , 0x8235EE33},
{ 0xA35D , 0x8235EE34},
{ 0xA35E , 0x8235EE35},
{ 0xA35F , 0x8235EE36},
{ 0xA360 , 0x8235EE37},
{ 0xA361 , 0x8235EE38},
{ 0xA362 , 0x8235EE39},
{ 0xA363 , 0x8235EF30},
{ 0xA364 , 0x8235EF31},
{ 0xA365 , 0x8235EF32},
{ 0xA366 , 0x8235EF33},
{ 0xA367 , 0x8235EF34},
{ 0xA368 , 0x8235EF35},
{ 0xA369 , 0x8235EF36},
{ 0xA36A , 0x8235EF37},
{ 0xA36B , 0x8235EF38},
{ 0xA36C , 0x8235EF39},
{ 0xA36D , 0x8235F030},
{ 0xA36E , 0x8235F031},
{ 0xA36F , 0x8235F032},
{ 0xA370 , 0x8235F033},
{ 0xA371 , 0x8235F034},
{ 0xA372 , 0x8235F035},
{ 0xA373 , 0x8235F036},
{ 0xA374 , 0x8235F037},
{ 0xA375 , 0x8235F038},
{ 0xA376 , 0x8235F039},
{ 0xA377 , 0x8235F130},
{ 0xA378 , 0x8235F131},
{ 0xA379 , 0x8235F132},
{ 0xA37A , 0x8235F133},
{ 0xA37B , 0x8235F134},
{ 0xA37C , 0x8235F135},
{ 0xA37D , 0x8235F136},
{ 0xA37E , 0x8235F137},
{ 0xA37F , 0x8235F138},
{ 0xA380 , 0x8235F139},
{ 0xA381 , 0x8235F230},
{ 0xA382 , 0x8235F231},
{ 0xA383 , 0x8235F232},
{ 0xA384 , 0x8235F233},
{ 0xA385 , 0x8235F234},
{ 0xA386 , 0x8235F235},
{ 0xA387 , 0x8235F236},
{ 0xA388 , 0x8235F237},
{ 0xA389 , 0x8235F238},
{ 0xA38A , 0x8235F239},
{ 0xA38B , 0x8235F330},
{ 0xA38C , 0x8235F331},
{ 0xA38D , 0x8235F332},
{ 0xA38E , 0x8235F333},
{ 0xA38F , 0x8235F334},
{ 0xA390 , 0x8235F335},
{ 0xA391 , 0x8235F336},
{ 0xA392 , 0x8235F337},
{ 0xA393 , 0x8235F338},
{ 0xA394 , 0x8235F339},
{ 0xA395 , 0x8235F430},
{ 0xA396 , 0x8235F431},
{ 0xA397 , 0x8235F432},
{ 0xA398 , 0x8235F433},
{ 0xA399 , 0x8235F434},
{ 0xA39A , 0x8235F435},
{ 0xA39B , 0x8235F436},
{ 0xA39C , 0x8235F437},
{ 0xA39D , 0x8235F438},
{ 0xA39E , 0x8235F439},
{ 0xA39F , 0x8235F530},
{ 0xA3A0 , 0x8235F531},
{ 0xA3A1 , 0x8235F532},
{ 0xA3A2 , 0x8235F533},
{ 0xA3A3 , 0x8235F534},
{ 0xA3A4 , 0x8235F535},
{ 0xA3A5 , 0x8235F536},
{ 0xA3A6 , 0x8235F537},
{ 0xA3A7 , 0x8235F538},
{ 0xA3A8 , 0x8235F539},
{ 0xA3A9 , 0x8235F630},
{ 0xA3AA , 0x8235F631},
{ 0xA3AB , 0x8235F632},
{ 0xA3AC , 0x8235F633},
{ 0xA3AD , 0x8235F634},
{ 0xA3AE , 0x8235F635},
{ 0xA3AF , 0x8235F636},
{ 0xA3B0 , 0x8235F637},
{ 0xA3B1 , 0x8235F638},
{ 0xA3B2 , 0x8235F639},
{ 0xA3B3 , 0x8235F730},
{ 0xA3B4 , 0x8235F731},
{ 0xA3B5 , 0x8235F732},
{ 0xA3B6 , 0x8235F733},
{ 0xA3B7 , 0x8235F734},
{ 0xA3B8 , 0x8235F735},
{ 0xA3B9 , 0x8235F736},
{ 0xA3BA , 0x8235F737},
{ 0xA3BB , 0x8235F738},
{ 0xA3BC , 0x8235F739},
{ 0xA3BD , 0x8235F830},
{ 0xA3BE , 0x8235F831},
{ 0xA3BF , 0x8235F832},
{ 0xA3C0 , 0x8235F833},
{ 0xA3C1 , 0x8235F834},
{ 0xA3C2 , 0x8235F835},
{ 0xA3C3 , 0x8235F836},
{ 0xA3C4 , 0x8235F837},
{ 0xA3C5 , 0x8235F838},
{ 0xA3C6 , 0x8235F839},
{ 0xA3C7 , 0x8235F930},
{ 0xA3C8 , 0x8235F931},
{ 0xA3C9 , 0x8235F932},
{ 0xA3CA , 0x8235F933},
{ 0xA3CB , 0x8235F934},
{ 0xA3CC , 0x8235F935},
{ 0xA3CD , 0x8235F936},
{ 0xA3CE , 0x8235F937},
{ 0xA3CF , 0x8235F938},
{ 0xA3D0 , 0x8235F939},
{ 0xA3D1 , 0x8235FA30},
{ 0xA3D2 , 0x8235FA31},
{ 0xA3D3 , 0x8235FA32},
{ 0xA3D4 , 0x8235FA33},
{ 0xA3D5 , 0x8235FA34},
{ 0xA3D6 , 0x8235FA35},
{ 0xA3D7 , 0x8235FA36},
{ 0xA3D8 , 0x8235FA37},
{ 0xA3D9 , 0x8235FA38},
{ 0xA3DA , 0x8235FA39},
{ 0xA3DB , 0x8235FB30},
{ 0xA3DC , 0x8235FB31},
{ 0xA3DD , 0x8235FB32},
{ 0xA3DE , 0x8235FB33},
{ 0xA3DF , 0x8235FB34},
{ 0xA3E0 , 0x8235FB35},
{ 0xA3E1 , 0x8235FB36},
{ 0xA3E2 , 0x8235FB37},
{ 0xA3E3 , 0x8235FB38},
{ 0xA3E4 , 0x8235FB39},
{ 0xA3E5 , 0x8235FC30},
{ 0xA3E6 , 0x8235FC31},
{ 0xA3E7 , 0x8235FC32},
{ 0xA3E8 , 0x8235FC33},
{ 0xA3E9 , 0x8235FC34},
{ 0xA3EA , 0x8235FC35},
{ 0xA3EB , 0x8235FC36},
{ 0xA3EC , 0x8235FC37},
{ 0xA3ED , 0x8235FC38},
{ 0xA3EE , 0x8235FC39},
{ 0xA3EF , 0x8235FD30},
{ 0xA3F0 , 0x8235FD31},
{ 0xA3F1 , 0x8235FD32},
{ 0xA3F2 , 0x8235FD33},
{ 0xA3F3 , 0x8235FD34},
{ 0xA3F4 , 0x8235FD35},
{ 0xA3F5 , 0x8235FD36},
{ 0xA3F6 , 0x8235FD37},
{ 0xA3F7 , 0x8235FD38},
{ 0xA3F8 , 0x8235FD39},
{ 0xA3F9 , 0x8235FE30},
{ 0xA3FA , 0x8235FE31},
{ 0xA3FB , 0x8235FE32},
{ 0xA3FC , 0x8235FE33},
{ 0xA3FD , 0x8235FE34},
{ 0xA3FE , 0x8235FE35},
{ 0xA3FF , 0x8235FE36},
{ 0xA400 , 0x8235FE37},
{ 0xA401 , 0x8235FE38},
{ 0xA402 , 0x8235FE39},
{ 0xA403 , 0x82368130},
{ 0xA404 , 0x82368131},
{ 0xA405 , 0x82368132},
{ 0xA406 , 0x82368133},
{ 0xA407 , 0x82368134},
{ 0xA408 , 0x82368135},
{ 0xA409 , 0x82368136},
{ 0xA40A , 0x82368137},
{ 0xA40B , 0x82368138},
{ 0xA40C , 0x82368139},
{ 0xA40D , 0x82368230},
{ 0xA40E , 0x82368231},
{ 0xA40F , 0x82368232},
{ 0xA410 , 0x82368233},
{ 0xA411 , 0x82368234},
{ 0xA412 , 0x82368235},
{ 0xA413 , 0x82368236},
{ 0xA414 , 0x82368237},
{ 0xA415 , 0x82368238},
{ 0xA416 , 0x82368239},
{ 0xA417 , 0x82368330},
{ 0xA418 , 0x82368331},
{ 0xA419 , 0x82368332},
{ 0xA41A , 0x82368333},
{ 0xA41B , 0x82368334},
{ 0xA41C , 0x82368335},
{ 0xA41D , 0x82368336},
{ 0xA41E , 0x82368337},
{ 0xA41F , 0x82368338},
{ 0xA420 , 0x82368339},
{ 0xA421 , 0x82368430},
{ 0xA422 , 0x82368431},
{ 0xA423 , 0x82368432},
{ 0xA424 , 0x82368433},
{ 0xA425 , 0x82368434},
{ 0xA426 , 0x82368435},
{ 0xA427 , 0x82368436},
{ 0xA428 , 0x82368437},
{ 0xA429 , 0x82368438},
{ 0xA42A , 0x82368439},
{ 0xA42B , 0x82368530},
{ 0xA42C , 0x82368531},
{ 0xA42D , 0x82368532},
{ 0xA42E , 0x82368533},
{ 0xA42F , 0x82368534},
{ 0xA430 , 0x82368535},
{ 0xA431 , 0x82368536},
{ 0xA432 , 0x82368537},
{ 0xA433 , 0x82368538},
{ 0xA434 , 0x82368539},
{ 0xA435 , 0x82368630},
{ 0xA436 , 0x82368631},
{ 0xA437 , 0x82368632},
{ 0xA438 , 0x82368633},
{ 0xA439 , 0x82368634},
{ 0xA43A , 0x82368635},
{ 0xA43B , 0x82368636},
{ 0xA43C , 0x82368637},
{ 0xA43D , 0x82368638},
{ 0xA43E , 0x82368639},
{ 0xA43F , 0x82368730},
{ 0xA440 , 0x82368731},
{ 0xA441 , 0x82368732},
{ 0xA442 , 0x82368733},
{ 0xA443 , 0x82368734},
{ 0xA444 , 0x82368735},
{ 0xA445 , 0x82368736},
{ 0xA446 , 0x82368737},
{ 0xA447 , 0x82368738},
{ 0xA448 , 0x82368739},
{ 0xA449 , 0x82368830},
{ 0xA44A , 0x82368831},
{ 0xA44B , 0x82368832},
{ 0xA44C , 0x82368833},
{ 0xA44D , 0x82368834},
{ 0xA44E , 0x82368835},
{ 0xA44F , 0x82368836},
{ 0xA450 , 0x82368837},
{ 0xA451 , 0x82368838},
{ 0xA452 , 0x82368839},
{ 0xA453 , 0x82368930},
{ 0xA454 , 0x82368931},
{ 0xA455 , 0x82368932},
{ 0xA456 , 0x82368933},
{ 0xA457 , 0x82368934},
{ 0xA458 , 0x82368935},
{ 0xA459 , 0x82368936},
{ 0xA45A , 0x82368937},
{ 0xA45B , 0x82368938},
{ 0xA45C , 0x82368939},
{ 0xA45D , 0x82368A30},
{ 0xA45E , 0x82368A31},
{ 0xA45F , 0x82368A32},
{ 0xA460 , 0x82368A33},
{ 0xA461 , 0x82368A34},
{ 0xA462 , 0x82368A35},
{ 0xA463 , 0x82368A36},
{ 0xA464 , 0x82368A37},
{ 0xA465 , 0x82368A38},
{ 0xA466 , 0x82368A39},
{ 0xA467 , 0x82368B30},
{ 0xA468 , 0x82368B31},
{ 0xA469 , 0x82368B32},
{ 0xA46A , 0x82368B33},
{ 0xA46B , 0x82368B34},
{ 0xA46C , 0x82368B35},
{ 0xA46D , 0x82368B36},
{ 0xA46E , 0x82368B37},
{ 0xA46F , 0x82368B38},
{ 0xA470 , 0x82368B39},
{ 0xA471 , 0x82368C30},
{ 0xA472 , 0x82368C31},
{ 0xA473 , 0x82368C32},
{ 0xA474 , 0x82368C33},
{ 0xA475 , 0x82368C34},
{ 0xA476 , 0x82368C35},
{ 0xA477 , 0x82368C36},
{ 0xA478 , 0x82368C37},
{ 0xA479 , 0x82368C38},
{ 0xA47A , 0x82368C39},
{ 0xA47B , 0x82368D30},
{ 0xA47C , 0x82368D31},
{ 0xA47D , 0x82368D32},
{ 0xA47E , 0x82368D33},
{ 0xA47F , 0x82368D34},
{ 0xA480 , 0x82368D35},
{ 0xA481 , 0x82368D36},
{ 0xA482 , 0x82368D37},
{ 0xA483 , 0x82368D38},
{ 0xA484 , 0x82368D39},
{ 0xA485 , 0x82368E30},
{ 0xA486 , 0x82368E31},
{ 0xA487 , 0x82368E32},
{ 0xA488 , 0x82368E33},
{ 0xA489 , 0x82368E34},
{ 0xA48A , 0x82368E35},
{ 0xA48B , 0x82368E36},
{ 0xA48C , 0x82368E37},
{ 0xA48D , 0x82368E38},
{ 0xA48E , 0x82368E39},
{ 0xA48F , 0x82368F30},
{ 0xA490 , 0x82368F31},
{ 0xA491 , 0x82368F32},
{ 0xA492 , 0x82368F33},
{ 0xA493 , 0x82368F34},
{ 0xA494 , 0x82368F35},
{ 0xA495 , 0x82368F36},
{ 0xA496 , 0x82368F37},
{ 0xA497 , 0x82368F38},
{ 0xA498 , 0x82368F39},
{ 0xA499 , 0x82369030},
{ 0xA49A , 0x82369031},
{ 0xA49B , 0x82369032},
{ 0xA49C , 0x82369033},
{ 0xA49D , 0x82369034},
{ 0xA49E , 0x82369035},
{ 0xA49F , 0x82369036},
{ 0xA4A0 , 0x82369037},
{ 0xA4A1 , 0x82369038},
{ 0xA4A2 , 0x82369039},
{ 0xA4A3 , 0x82369130},
{ 0xA4A4 , 0x82369131},
{ 0xA4A5 , 0x82369132},
{ 0xA4A6 , 0x82369133},
{ 0xA4A7 , 0x82369134},
{ 0xA4A8 , 0x82369135},
{ 0xA4A9 , 0x82369136},
{ 0xA4AA , 0x82369137},
{ 0xA4AB , 0x82369138},
{ 0xA4AC , 0x82369139},
{ 0xA4AD , 0x82369230},
{ 0xA4AE , 0x82369231},
{ 0xA4AF , 0x82369232},
{ 0xA4B0 , 0x82369233},
{ 0xA4B1 , 0x82369234},
{ 0xA4B2 , 0x82369235},
{ 0xA4B3 , 0x82369236},
{ 0xA4B4 , 0x82369237},
{ 0xA4B5 , 0x82369238},
{ 0xA4B6 , 0x82369239},
{ 0xA4B7 , 0x82369330},
{ 0xA4B8 , 0x82369331},
{ 0xA4B9 , 0x82369332},
{ 0xA4BA , 0x82369333},
{ 0xA4BB , 0x82369334},
{ 0xA4BC , 0x82369335},
{ 0xA4BD , 0x82369336},
{ 0xA4BE , 0x82369337},
{ 0xA4BF , 0x82369338},
{ 0xA4C0 , 0x82369339},
{ 0xA4C1 , 0x82369430},
{ 0xA4C2 , 0x82369431},
{ 0xA4C3 , 0x82369432},
{ 0xA4C4 , 0x82369433},
{ 0xA4C5 , 0x82369434},
{ 0xA4C6 , 0x82369435},
{ 0xA4C7 , 0x82369436},
{ 0xA4C8 , 0x82369437},
{ 0xA4C9 , 0x82369438},
{ 0xA4CA , 0x82369439},
{ 0xA4CB , 0x82369530},
{ 0xA4CC , 0x82369531},
{ 0xA4CD , 0x82369532},
{ 0xA4CE , 0x82369533},
{ 0xA4CF , 0x82369534},
{ 0xA4D0 , 0x82369535},
{ 0xA4D1 , 0x82369536},
{ 0xA4D2 , 0x82369537},
{ 0xA4D3 , 0x82369538},
{ 0xA4D4 , 0x82369539},
{ 0xA4D5 , 0x82369630},
{ 0xA4D6 , 0x82369631},
{ 0xA4D7 , 0x82369632},
{ 0xA4D8 , 0x82369633},
{ 0xA4D9 , 0x82369634},
{ 0xA4DA , 0x82369635},
{ 0xA4DB , 0x82369636},
{ 0xA4DC , 0x82369637},
{ 0xA4DD , 0x82369638},
{ 0xA4DE , 0x82369639},
{ 0xA4DF , 0x82369730},
{ 0xA4E0 , 0x82369731},
{ 0xA4E1 , 0x82369732},
{ 0xA4E2 , 0x82369733},
{ 0xA4E3 , 0x82369734},
{ 0xA4E4 , 0x82369735},
{ 0xA4E5 , 0x82369736},
{ 0xA4E6 , 0x82369737},
{ 0xA4E7 , 0x82369738},
{ 0xA4E8 , 0x82369739},
{ 0xA4E9 , 0x82369830},
{ 0xA4EA , 0x82369831},
{ 0xA4EB , 0x82369832},
{ 0xA4EC , 0x82369833},
{ 0xA4ED , 0x82369834},
{ 0xA4EE , 0x82369835},
{ 0xA4EF , 0x82369836},
{ 0xA4F0 , 0x82369837},
{ 0xA4F1 , 0x82369838},
{ 0xA4F2 , 0x82369839},
{ 0xA4F3 , 0x82369930},
{ 0xA4F4 , 0x82369931},
{ 0xA4F5 , 0x82369932},
{ 0xA4F6 , 0x82369933},
{ 0xA4F7 , 0x82369934},
{ 0xA4F8 , 0x82369935},
{ 0xA4F9 , 0x82369936},
{ 0xA4FA , 0x82369937},
{ 0xA4FB , 0x82369938},
{ 0xA4FC , 0x82369939},
{ 0xA4FD , 0x82369A30},
{ 0xA4FE , 0x82369A31},
{ 0xA4FF , 0x82369A32},
{ 0xA500 , 0x82369A33},
{ 0xA501 , 0x82369A34},
{ 0xA502 , 0x82369A35},
{ 0xA503 , 0x82369A36},
{ 0xA504 , 0x82369A37},
{ 0xA505 , 0x82369A38},
{ 0xA506 , 0x82369A39},
{ 0xA507 , 0x82369B30},
{ 0xA508 , 0x82369B31},
{ 0xA509 , 0x82369B32},
{ 0xA50A , 0x82369B33},
{ 0xA50B , 0x82369B34},
{ 0xA50C , 0x82369B35},
{ 0xA50D , 0x82369B36},
{ 0xA50E , 0x82369B37},
{ 0xA50F , 0x82369B38},
{ 0xA510 , 0x82369B39},
{ 0xA511 , 0x82369C30},
{ 0xA512 , 0x82369C31},
{ 0xA513 , 0x82369C32},
{ 0xA514 , 0x82369C33},
{ 0xA515 , 0x82369C34},
{ 0xA516 , 0x82369C35},
{ 0xA517 , 0x82369C36},
{ 0xA518 , 0x82369C37},
{ 0xA519 , 0x82369C38},
{ 0xA51A , 0x82369C39},
{ 0xA51B , 0x82369D30},
{ 0xA51C , 0x82369D31},
{ 0xA51D , 0x82369D32},
{ 0xA51E , 0x82369D33},
{ 0xA51F , 0x82369D34},
{ 0xA520 , 0x82369D35},
{ 0xA521 , 0x82369D36},
{ 0xA522 , 0x82369D37},
{ 0xA523 , 0x82369D38},
{ 0xA524 , 0x82369D39},
{ 0xA525 , 0x82369E30},
{ 0xA526 , 0x82369E31},
{ 0xA527 , 0x82369E32},
{ 0xA528 , 0x82369E33},
{ 0xA529 , 0x82369E34},
{ 0xA52A , 0x82369E35},
{ 0xA52B , 0x82369E36},
{ 0xA52C , 0x82369E37},
{ 0xA52D , 0x82369E38},
{ 0xA52E , 0x82369E39},
{ 0xA52F , 0x82369F30},
{ 0xA530 , 0x82369F31},
{ 0xA531 , 0x82369F32},
{ 0xA532 , 0x82369F33},
{ 0xA533 , 0x82369F34},
{ 0xA534 , 0x82369F35},
{ 0xA535 , 0x82369F36},
{ 0xA536 , 0x82369F37},
{ 0xA537 , 0x82369F38},
{ 0xA538 , 0x82369F39},
{ 0xA539 , 0x8236A030},
{ 0xA53A , 0x8236A031},
{ 0xA53B , 0x8236A032},
{ 0xA53C , 0x8236A033},
{ 0xA53D , 0x8236A034},
{ 0xA53E , 0x8236A035},
{ 0xA53F , 0x8236A036},
{ 0xA540 , 0x8236A037},
{ 0xA541 , 0x8236A038},
{ 0xA542 , 0x8236A039},
{ 0xA543 , 0x8236A130},
{ 0xA544 , 0x8236A131},
{ 0xA545 , 0x8236A132},
{ 0xA546 , 0x8236A133},
{ 0xA547 , 0x8236A134},
{ 0xA548 , 0x8236A135},
{ 0xA549 , 0x8236A136},
{ 0xA54A , 0x8236A137},
{ 0xA54B , 0x8236A138},
{ 0xA54C , 0x8236A139},
{ 0xA54D , 0x8236A230},
{ 0xA54E , 0x8236A231},
{ 0xA54F , 0x8236A232},
{ 0xA550 , 0x8236A233},
{ 0xA551 , 0x8236A234},
{ 0xA552 , 0x8236A235},
{ 0xA553 , 0x8236A236},
{ 0xA554 , 0x8236A237},
{ 0xA555 , 0x8236A238},
{ 0xA556 , 0x8236A239},
{ 0xA557 , 0x8236A330},
{ 0xA558 , 0x8236A331},
{ 0xA559 , 0x8236A332},
{ 0xA55A , 0x8236A333},
{ 0xA55B , 0x8236A334},
{ 0xA55C , 0x8236A335},
{ 0xA55D , 0x8236A336},
{ 0xA55E , 0x8236A337},
{ 0xA55F , 0x8236A338},
{ 0xA560 , 0x8236A339},
{ 0xA561 , 0x8236A430},
{ 0xA562 , 0x8236A431},
{ 0xA563 , 0x8236A432},
{ 0xA564 , 0x8236A433},
{ 0xA565 , 0x8236A434},
{ 0xA566 , 0x8236A435},
{ 0xA567 , 0x8236A436},
{ 0xA568 , 0x8236A437},
{ 0xA569 , 0x8236A438},
{ 0xA56A , 0x8236A439},
{ 0xA56B , 0x8236A530},
{ 0xA56C , 0x8236A531},
{ 0xA56D , 0x8236A532},
{ 0xA56E , 0x8236A533},
{ 0xA56F , 0x8236A534},
{ 0xA570 , 0x8236A535},
{ 0xA571 , 0x8236A536},
{ 0xA572 , 0x8236A537},
{ 0xA573 , 0x8236A538},
{ 0xA574 , 0x8236A539},
{ 0xA575 , 0x8236A630},
{ 0xA576 , 0x8236A631},
{ 0xA577 , 0x8236A632},
{ 0xA578 , 0x8236A633},
{ 0xA579 , 0x8236A634},
{ 0xA57A , 0x8236A635},
{ 0xA57B , 0x8236A636},
{ 0xA57C , 0x8236A637},
{ 0xA57D , 0x8236A638},
{ 0xA57E , 0x8236A639},
{ 0xA57F , 0x8236A730},
{ 0xA580 , 0x8236A731},
{ 0xA581 , 0x8236A732},
{ 0xA582 , 0x8236A733},
{ 0xA583 , 0x8236A734},
{ 0xA584 , 0x8236A735},
{ 0xA585 , 0x8236A736},
{ 0xA586 , 0x8236A737},
{ 0xA587 , 0x8236A738},
{ 0xA588 , 0x8236A739},
{ 0xA589 , 0x8236A830},
{ 0xA58A , 0x8236A831},
{ 0xA58B , 0x8236A832},
{ 0xA58C , 0x8236A833},
{ 0xA58D , 0x8236A834},
{ 0xA58E , 0x8236A835},
{ 0xA58F , 0x8236A836},
{ 0xA590 , 0x8236A837},
{ 0xA591 , 0x8236A838},
{ 0xA592 , 0x8236A839},
{ 0xA593 , 0x8236A930},
{ 0xA594 , 0x8236A931},
{ 0xA595 , 0x8236A932},
{ 0xA596 , 0x8236A933},
{ 0xA597 , 0x8236A934},
{ 0xA598 , 0x8236A935},
{ 0xA599 , 0x8236A936},
{ 0xA59A , 0x8236A937},
{ 0xA59B , 0x8236A938},
{ 0xA59C , 0x8236A939},
{ 0xA59D , 0x8236AA30},
{ 0xA59E , 0x8236AA31},
{ 0xA59F , 0x8236AA32},
{ 0xA5A0 , 0x8236AA33},
{ 0xA5A1 , 0x8236AA34},
{ 0xA5A2 , 0x8236AA35},
{ 0xA5A3 , 0x8236AA36},
{ 0xA5A4 , 0x8236AA37},
{ 0xA5A5 , 0x8236AA38},
{ 0xA5A6 , 0x8236AA39},
{ 0xA5A7 , 0x8236AB30},
{ 0xA5A8 , 0x8236AB31},
{ 0xA5A9 , 0x8236AB32},
{ 0xA5AA , 0x8236AB33},
{ 0xA5AB , 0x8236AB34},
{ 0xA5AC , 0x8236AB35},
{ 0xA5AD , 0x8236AB36},
{ 0xA5AE , 0x8236AB37},
{ 0xA5AF , 0x8236AB38},
{ 0xA5B0 , 0x8236AB39},
{ 0xA5B1 , 0x8236AC30},
{ 0xA5B2 , 0x8236AC31},
{ 0xA5B3 , 0x8236AC32},
{ 0xA5B4 , 0x8236AC33},
{ 0xA5B5 , 0x8236AC34},
{ 0xA5B6 , 0x8236AC35},
{ 0xA5B7 , 0x8236AC36},
{ 0xA5B8 , 0x8236AC37},
{ 0xA5B9 , 0x8236AC38},
{ 0xA5BA , 0x8236AC39},
{ 0xA5BB , 0x8236AD30},
{ 0xA5BC , 0x8236AD31},
{ 0xA5BD , 0x8236AD32},
{ 0xA5BE , 0x8236AD33},
{ 0xA5BF , 0x8236AD34},
{ 0xA5C0 , 0x8236AD35},
{ 0xA5C1 , 0x8236AD36},
{ 0xA5C2 , 0x8236AD37},
{ 0xA5C3 , 0x8236AD38},
{ 0xA5C4 , 0x8236AD39},
{ 0xA5C5 , 0x8236AE30},
{ 0xA5C6 , 0x8236AE31},
{ 0xA5C7 , 0x8236AE32},
{ 0xA5C8 , 0x8236AE33},
{ 0xA5C9 , 0x8236AE34},
{ 0xA5CA , 0x8236AE35},
{ 0xA5CB , 0x8236AE36},
{ 0xA5CC , 0x8236AE37},
{ 0xA5CD , 0x8236AE38},
{ 0xA5CE , 0x8236AE39},
{ 0xA5CF , 0x8236AF30},
{ 0xA5D0 , 0x8236AF31},
{ 0xA5D1 , 0x8236AF32},
{ 0xA5D2 , 0x8236AF33},
{ 0xA5D3 , 0x8236AF34},
{ 0xA5D4 , 0x8236AF35},
{ 0xA5D5 , 0x8236AF36},
{ 0xA5D6 , 0x8236AF37},
{ 0xA5D7 , 0x8236AF38},
{ 0xA5D8 , 0x8236AF39},
{ 0xA5D9 , 0x8236B030},
{ 0xA5DA , 0x8236B031},
{ 0xA5DB , 0x8236B032},
{ 0xA5DC , 0x8236B033},
{ 0xA5DD , 0x8236B034},
{ 0xA5DE , 0x8236B035},
{ 0xA5DF , 0x8236B036},
{ 0xA5E0 , 0x8236B037},
{ 0xA5E1 , 0x8236B038},
{ 0xA5E2 , 0x8236B039},
{ 0xA5E3 , 0x8236B130},
{ 0xA5E4 , 0x8236B131},
{ 0xA5E5 , 0x8236B132},
{ 0xA5E6 , 0x8236B133},
{ 0xA5E7 , 0x8236B134},
{ 0xA5E8 , 0x8236B135},
{ 0xA5E9 , 0x8236B136},
{ 0xA5EA , 0x8236B137},
{ 0xA5EB , 0x8236B138},
{ 0xA5EC , 0x8236B139},
{ 0xA5ED , 0x8236B230},
{ 0xA5EE , 0x8236B231},
{ 0xA5EF , 0x8236B232},
{ 0xA5F0 , 0x8236B233},
{ 0xA5F1 , 0x8236B234},
{ 0xA5F2 , 0x8236B235},
{ 0xA5F3 , 0x8236B236},
{ 0xA5F4 , 0x8236B237},
{ 0xA5F5 , 0x8236B238},
{ 0xA5F6 , 0x8236B239},
{ 0xA5F7 , 0x8236B330},
{ 0xA5F8 , 0x8236B331},
{ 0xA5F9 , 0x8236B332},
{ 0xA5FA , 0x8236B333},
{ 0xA5FB , 0x8236B334},
{ 0xA5FC , 0x8236B335},
{ 0xA5FD , 0x8236B336},
{ 0xA5FE , 0x8236B337},
{ 0xA5FF , 0x8236B338},
{ 0xA600 , 0x8236B339},
{ 0xA601 , 0x8236B430},
{ 0xA602 , 0x8236B431},
{ 0xA603 , 0x8236B432},
{ 0xA604 , 0x8236B433},
{ 0xA605 , 0x8236B434},
{ 0xA606 , 0x8236B435},
{ 0xA607 , 0x8236B436},
{ 0xA608 , 0x8236B437},
{ 0xA609 , 0x8236B438},
{ 0xA60A , 0x8236B439},
{ 0xA60B , 0x8236B530},
{ 0xA60C , 0x8236B531},
{ 0xA60D , 0x8236B532},
{ 0xA60E , 0x8236B533},
{ 0xA60F , 0x8236B534},
{ 0xA610 , 0x8236B535},
{ 0xA611 , 0x8236B536},
{ 0xA612 , 0x8236B537},
{ 0xA613 , 0x8236B538},
{ 0xA614 , 0x8236B539},
{ 0xA615 , 0x8236B630},
{ 0xA616 , 0x8236B631},
{ 0xA617 , 0x8236B632},
{ 0xA618 , 0x8236B633},
{ 0xA619 , 0x8236B634},
{ 0xA61A , 0x8236B635},
{ 0xA61B , 0x8236B636},
{ 0xA61C , 0x8236B637},
{ 0xA61D , 0x8236B638},
{ 0xA61E , 0x8236B639},
{ 0xA61F , 0x8236B730},
{ 0xA620 , 0x8236B731},
{ 0xA621 , 0x8236B732},
{ 0xA622 , 0x8236B733},
{ 0xA623 , 0x8236B734},
{ 0xA624 , 0x8236B735},
{ 0xA625 , 0x8236B736},
{ 0xA626 , 0x8236B737},
{ 0xA627 , 0x8236B738},
{ 0xA628 , 0x8236B739},
{ 0xA629 , 0x8236B830},
{ 0xA62A , 0x8236B831},
{ 0xA62B , 0x8236B832},
{ 0xA62C , 0x8236B833},
{ 0xA62D , 0x8236B834},
{ 0xA62E , 0x8236B835},
{ 0xA62F , 0x8236B836},
{ 0xA630 , 0x8236B837},
{ 0xA631 , 0x8236B838},
{ 0xA632 , 0x8236B839},
{ 0xA633 , 0x8236B930},
{ 0xA634 , 0x8236B931},
{ 0xA635 , 0x8236B932},
{ 0xA636 , 0x8236B933},
{ 0xA637 , 0x8236B934},
{ 0xA638 , 0x8236B935},
{ 0xA639 , 0x8236B936},
{ 0xA63A , 0x8236B937},
{ 0xA63B , 0x8236B938},
{ 0xA63C , 0x8236B939},
{ 0xA63D , 0x8236BA30},
{ 0xA63E , 0x8236BA31},
{ 0xA63F , 0x8236BA32},
{ 0xA640 , 0x8236BA33},
{ 0xA641 , 0x8236BA34},
{ 0xA642 , 0x8236BA35},
{ 0xA643 , 0x8236BA36},
{ 0xA644 , 0x8236BA37},
{ 0xA645 , 0x8236BA38},
{ 0xA646 , 0x8236BA39},
{ 0xA647 , 0x8236BB30},
{ 0xA648 , 0x8236BB31},
{ 0xA649 , 0x8236BB32},
{ 0xA64A , 0x8236BB33},
{ 0xA64B , 0x8236BB34},
{ 0xA64C , 0x8236BB35},
{ 0xA64D , 0x8236BB36},
{ 0xA64E , 0x8236BB37},
{ 0xA64F , 0x8236BB38},
{ 0xA650 , 0x8236BB39},
{ 0xA651 , 0x8236BC30},
{ 0xA652 , 0x8236BC31},
{ 0xA653 , 0x8236BC32},
{ 0xA654 , 0x8236BC33},
{ 0xA655 , 0x8236BC34},
{ 0xA656 , 0x8236BC35},
{ 0xA657 , 0x8236BC36},
{ 0xA658 , 0x8236BC37},
{ 0xA659 , 0x8236BC38},
{ 0xA65A , 0x8236BC39},
{ 0xA65B , 0x8236BD30},
{ 0xA65C , 0x8236BD31},
{ 0xA65D , 0x8236BD32},
{ 0xA65E , 0x8236BD33},
{ 0xA65F , 0x8236BD34},
{ 0xA660 , 0x8236BD35},
{ 0xA661 , 0x8236BD36},
{ 0xA662 , 0x8236BD37},
{ 0xA663 , 0x8236BD38},
{ 0xA664 , 0x8236BD39},
{ 0xA665 , 0x8236BE30},
{ 0xA666 , 0x8236BE31},
{ 0xA667 , 0x8236BE32},
{ 0xA668 , 0x8236BE33},
{ 0xA669 , 0x8236BE34},
{ 0xA66A , 0x8236BE35},
{ 0xA66B , 0x8236BE36},
{ 0xA66C , 0x8236BE37},
{ 0xA66D , 0x8236BE38},
{ 0xA66E , 0x8236BE39},
{ 0xA66F , 0x8236BF30},
{ 0xA670 , 0x8236BF31},
{ 0xA671 , 0x8236BF32},
{ 0xA672 , 0x8236BF33},
{ 0xA673 , 0x8236BF34},
{ 0xA674 , 0x8236BF35},
{ 0xA675 , 0x8236BF36},
{ 0xA676 , 0x8236BF37},
{ 0xA677 , 0x8236BF38},
{ 0xA678 , 0x8236BF39},
{ 0xA679 , 0x8236C030},
{ 0xA67A , 0x8236C031},
{ 0xA67B , 0x8236C032},
{ 0xA67C , 0x8236C033},
{ 0xA67D , 0x8236C034},
{ 0xA67E , 0x8236C035},
{ 0xA67F , 0x8236C036},
{ 0xA680 , 0x8236C037},
{ 0xA681 , 0x8236C038},
{ 0xA682 , 0x8236C039},
{ 0xA683 , 0x8236C130},
{ 0xA684 , 0x8236C131},
{ 0xA685 , 0x8236C132},
{ 0xA686 , 0x8236C133},
{ 0xA687 , 0x8236C134},
{ 0xA688 , 0x8236C135},
{ 0xA689 , 0x8236C136},
{ 0xA68A , 0x8236C137},
{ 0xA68B , 0x8236C138},
{ 0xA68C , 0x8236C139},
{ 0xA68D , 0x8236C230},
{ 0xA68E , 0x8236C231},
{ 0xA68F , 0x8236C232},
{ 0xA690 , 0x8236C233},
{ 0xA691 , 0x8236C234},
{ 0xA692 , 0x8236C235},
{ 0xA693 , 0x8236C236},
{ 0xA694 , 0x8236C237},
{ 0xA695 , 0x8236C238},
{ 0xA696 , 0x8236C239},
{ 0xA697 , 0x8236C330},
{ 0xA698 , 0x8236C331},
{ 0xA699 , 0x8236C332},
{ 0xA69A , 0x8236C333},
{ 0xA69B , 0x8236C334},
{ 0xA69C , 0x8236C335},
{ 0xA69D , 0x8236C336},
{ 0xA69E , 0x8236C337},
{ 0xA69F , 0x8236C338},
{ 0xA6A0 , 0x8236C339},
{ 0xA6A1 , 0x8236C430},
{ 0xA6A2 , 0x8236C431},
{ 0xA6A3 , 0x8236C432},
{ 0xA6A4 , 0x8236C433},
{ 0xA6A5 , 0x8236C434},
{ 0xA6A6 , 0x8236C435},
{ 0xA6A7 , 0x8236C436},
{ 0xA6A8 , 0x8236C437},
{ 0xA6A9 , 0x8236C438},
{ 0xA6AA , 0x8236C439},
{ 0xA6AB , 0x8236C530},
{ 0xA6AC , 0x8236C531},
{ 0xA6AD , 0x8236C532},
{ 0xA6AE , 0x8236C533},
{ 0xA6AF , 0x8236C534},
{ 0xA6B0 , 0x8236C535},
{ 0xA6B1 , 0x8236C536},
{ 0xA6B2 , 0x8236C537},
{ 0xA6B3 , 0x8236C538},
{ 0xA6B4 , 0x8236C539},
{ 0xA6B5 , 0x8236C630},
{ 0xA6B6 , 0x8236C631},
{ 0xA6B7 , 0x8236C632},
{ 0xA6B8 , 0x8236C633},
{ 0xA6B9 , 0x8236C634},
{ 0xA6BA , 0x8236C635},
{ 0xA6BB , 0x8236C636},
{ 0xA6BC , 0x8236C637},
{ 0xA6BD , 0x8236C638},
{ 0xA6BE , 0x8236C639},
{ 0xA6BF , 0x8236C730},
{ 0xA6C0 , 0x8236C731},
{ 0xA6C1 , 0x8236C732},
{ 0xA6C2 , 0x8236C733},
{ 0xA6C3 , 0x8236C734},
{ 0xA6C4 , 0x8236C735},
{ 0xA6C5 , 0x8236C736},
{ 0xA6C6 , 0x8236C737},
{ 0xA6C7 , 0x8236C738},
{ 0xA6C8 , 0x8236C739},
{ 0xA6C9 , 0x8236C830},
{ 0xA6CA , 0x8236C831},
{ 0xA6CB , 0x8236C832},
{ 0xA6CC , 0x8236C833},
{ 0xA6CD , 0x8236C834},
{ 0xA6CE , 0x8236C835},
{ 0xA6CF , 0x8236C836},
{ 0xA6D0 , 0x8236C837},
{ 0xA6D1 , 0x8236C838},
{ 0xA6D2 , 0x8236C839},
{ 0xA6D3 , 0x8236C930},
{ 0xA6D4 , 0x8236C931},
{ 0xA6D5 , 0x8236C932},
{ 0xA6D6 , 0x8236C933},
{ 0xA6D7 , 0x8236C934},
{ 0xA6D8 , 0x8236C935},
{ 0xA6D9 , 0x8236C936},
{ 0xA6DA , 0x8236C937},
{ 0xA6DB , 0x8236C938},
{ 0xA6DC , 0x8236C939},
{ 0xA6DD , 0x8236CA30},
{ 0xA6DE , 0x8236CA31},
{ 0xA6DF , 0x8236CA32},
{ 0xA6E0 , 0x8236CA33},
{ 0xA6E1 , 0x8236CA34},
{ 0xA6E2 , 0x8236CA35},
{ 0xA6E3 , 0x8236CA36},
{ 0xA6E4 , 0x8236CA37},
{ 0xA6E5 , 0x8236CA38},
{ 0xA6E6 , 0x8236CA39},
{ 0xA6E7 , 0x8236CB30},
{ 0xA6E8 , 0x8236CB31},
{ 0xA6E9 , 0x8236CB32},
{ 0xA6EA , 0x8236CB33},
{ 0xA6EB , 0x8236CB34},
{ 0xA6EC , 0x8236CB35},
{ 0xA6ED , 0x8236CB36},
{ 0xA6EE , 0x8236CB37},
{ 0xA6EF , 0x8236CB38},
{ 0xA6F0 , 0x8236CB39},
{ 0xA6F1 , 0x8236CC30},
{ 0xA6F2 , 0x8236CC31},
{ 0xA6F3 , 0x8236CC32},
{ 0xA6F4 , 0x8236CC33},
{ 0xA6F5 , 0x8236CC34},
{ 0xA6F6 , 0x8236CC35},
{ 0xA6F7 , 0x8236CC36},
{ 0xA6F8 , 0x8236CC37},
{ 0xA6F9 , 0x8236CC38},
{ 0xA6FA , 0x8236CC39},
{ 0xA6FB , 0x8236CD30},
{ 0xA6FC , 0x8236CD31},
{ 0xA6FD , 0x8236CD32},
{ 0xA6FE , 0x8236CD33},
{ 0xA6FF , 0x8236CD34},
{ 0xA700 , 0x8236CD35},
{ 0xA701 , 0x8236CD36},
{ 0xA702 , 0x8236CD37},
{ 0xA703 , 0x8236CD38},
{ 0xA704 , 0x8236CD39},
{ 0xA705 , 0x8236CE30},
{ 0xA706 , 0x8236CE31},
{ 0xA707 , 0x8236CE32},
{ 0xA708 , 0x8236CE33},
{ 0xA709 , 0x8236CE34},
{ 0xA70A , 0x8236CE35},
{ 0xA70B , 0x8236CE36},
{ 0xA70C , 0x8236CE37},
{ 0xA70D , 0x8236CE38},
{ 0xA70E , 0x8236CE39},
{ 0xA70F , 0x8236CF30},
{ 0xA710 , 0x8236CF31},
{ 0xA711 , 0x8236CF32},
{ 0xA712 , 0x8236CF33},
{ 0xA713 , 0x8236CF34},
{ 0xA714 , 0x8236CF35},
{ 0xA715 , 0x8236CF36},
{ 0xA716 , 0x8236CF37},
{ 0xA717 , 0x8236CF38},
{ 0xA718 , 0x8236CF39},
{ 0xA719 , 0x8236D030},
{ 0xA71A , 0x8236D031},
{ 0xA71B , 0x8236D032},
{ 0xA71C , 0x8236D033},
{ 0xA71D , 0x8236D034},
{ 0xA71E , 0x8236D035},
{ 0xA71F , 0x8236D036},
{ 0xA720 , 0x8236D037},
{ 0xA721 , 0x8236D038},
{ 0xA722 , 0x8236D039},
{ 0xA723 , 0x8236D130},
{ 0xA724 , 0x8236D131},
{ 0xA725 , 0x8236D132},
{ 0xA726 , 0x8236D133},
{ 0xA727 , 0x8236D134},
{ 0xA728 , 0x8236D135},
{ 0xA729 , 0x8236D136},
{ 0xA72A , 0x8236D137},
{ 0xA72B , 0x8236D138},
{ 0xA72C , 0x8236D139},
{ 0xA72D , 0x8236D230},
{ 0xA72E , 0x8236D231},
{ 0xA72F , 0x8236D232},
{ 0xA730 , 0x8236D233},
{ 0xA731 , 0x8236D234},
{ 0xA732 , 0x8236D235},
{ 0xA733 , 0x8236D236},
{ 0xA734 , 0x8236D237},
{ 0xA735 , 0x8236D238},
{ 0xA736 , 0x8236D239},
{ 0xA737 , 0x8236D330},
{ 0xA738 , 0x8236D331},
{ 0xA739 , 0x8236D332},
{ 0xA73A , 0x8236D333},
{ 0xA73B , 0x8236D334},
{ 0xA73C , 0x8236D335},
{ 0xA73D , 0x8236D336},
{ 0xA73E , 0x8236D337},
{ 0xA73F , 0x8236D338},
{ 0xA740 , 0x8236D339},
{ 0xA741 , 0x8236D430},
{ 0xA742 , 0x8236D431},
{ 0xA743 , 0x8236D432},
{ 0xA744 , 0x8236D433},
{ 0xA745 , 0x8236D434},
{ 0xA746 , 0x8236D435},
{ 0xA747 , 0x8236D436},
{ 0xA748 , 0x8236D437},
{ 0xA749 , 0x8236D438},
{ 0xA74A , 0x8236D439},
{ 0xA74B , 0x8236D530},
{ 0xA74C , 0x8236D531},
{ 0xA74D , 0x8236D532},
{ 0xA74E , 0x8236D533},
{ 0xA74F , 0x8236D534},
{ 0xA750 , 0x8236D535},
{ 0xA751 , 0x8236D536},
{ 0xA752 , 0x8236D537},
{ 0xA753 , 0x8236D538},
{ 0xA754 , 0x8236D539},
{ 0xA755 , 0x8236D630},
{ 0xA756 , 0x8236D631},
{ 0xA757 , 0x8236D632},
{ 0xA758 , 0x8236D633},
{ 0xA759 , 0x8236D634},
{ 0xA75A , 0x8236D635},
{ 0xA75B , 0x8236D636},
{ 0xA75C , 0x8236D637},
{ 0xA75D , 0x8236D638},
{ 0xA75E , 0x8236D639},
{ 0xA75F , 0x8236D730},
{ 0xA760 , 0x8236D731},
{ 0xA761 , 0x8236D732},
{ 0xA762 , 0x8236D733},
{ 0xA763 , 0x8236D734},
{ 0xA764 , 0x8236D735},
{ 0xA765 , 0x8236D736},
{ 0xA766 , 0x8236D737},
{ 0xA767 , 0x8236D738},
{ 0xA768 , 0x8236D739},
{ 0xA769 , 0x8236D830},
{ 0xA76A , 0x8236D831},
{ 0xA76B , 0x8236D832},
{ 0xA76C , 0x8236D833},
{ 0xA76D , 0x8236D834},
{ 0xA76E , 0x8236D835},
{ 0xA76F , 0x8236D836},
{ 0xA770 , 0x8236D837},
{ 0xA771 , 0x8236D838},
{ 0xA772 , 0x8236D839},
{ 0xA773 , 0x8236D930},
{ 0xA774 , 0x8236D931},
{ 0xA775 , 0x8236D932},
{ 0xA776 , 0x8236D933},
{ 0xA777 , 0x8236D934},
{ 0xA778 , 0x8236D935},
{ 0xA779 , 0x8236D936},
{ 0xA77A , 0x8236D937},
{ 0xA77B , 0x8236D938},
{ 0xA77C , 0x8236D939},
{ 0xA77D , 0x8236DA30},
{ 0xA77E , 0x8236DA31},
{ 0xA77F , 0x8236DA32},
{ 0xA780 , 0x8236DA33},
{ 0xA781 , 0x8236DA34},
{ 0xA782 , 0x8236DA35},
{ 0xA783 , 0x8236DA36},
{ 0xA784 , 0x8236DA37},
{ 0xA785 , 0x8236DA38},
{ 0xA786 , 0x8236DA39},
{ 0xA787 , 0x8236DB30},
{ 0xA788 , 0x8236DB31},
{ 0xA789 , 0x8236DB32},
{ 0xA78A , 0x8236DB33},
{ 0xA78B , 0x8236DB34},
{ 0xA78C , 0x8236DB35},
{ 0xA78D , 0x823